#!/bin/sh

# Run this script after changing or adding .pup files.
# WARNING: this script requires a fair amount of tools - it is intended to
#          run on developers' machines, not on users'

. ../libcschem/config.sh

export LANG=C
PUPLUG=$librnd_libdir/puplug
SCCONF=../../scconfig


# generate scconfig's 3 state plugin list
$PUPLUG findpups . '%$class$|%N|%3|%A|%$short$\n' | sed '
s/^lib/1|lib/
s/^feature/2|feature/
s/^engine/2|engine/
s/^symlib/3|symlib/
s/^import/4|import/
s/^export/5|export/
s/^io/6|io/
s/^hid/7|hid/
s/^gui/7|gui/
' | sort | awk -F "[|]" '
BEGIN {
	HDR["lib"] = "Library plugins"
	HDR["feature"] = "Feature plugins"
	HDR["engine"] = "Engine plugins (concrete->abstract compilation)"
	HDR["symlib"] = "Symbol library accessors"
	HDR["import"] = "Import plugins"
	HDR["export"] = "Export plugins"
	HDR["io"] = "IO plugins (file formats)"
	HDR["gui"] = "GUI"
	print "/******************************************************************************"
	print " Auto-generated by plugins/map_plugins.sh - do NOT edit,"
	print " run make map_plugins in sch-rnd/ - to change any of the data below,"
	print " edit plugins/PLUGIN/PLUGIN.pup"
	print "******************************************************************************/"
}

function q(s) { return "\"" s "\"," }

($2 != last) {
	print "\nplugin_header(\"\\n" HDR[$2] ":\\n\")"
	last = $2
}

{
	if ($4 == "")
		print "Error: invalid default in plugin: " $3 > "/dev/stderr"
	printf("plugin_def(%-20s%-35s%-10s%s)\n", q($3), q($6), $4 "," , $5)
}

END { print "\n" }

' > $SCCONF/plugins.h

$PUPLUG findpups . "" 'plugin_dep("%N", "%m")\n' | sort >> $SCCONF/plugins.h


# Generate the plugin list
echo "# List of all plugins - generated by make map_plugins - do NOT edit" > plugins_ALL.tmpasm
$PUPLUG findpups . "include {../src/plugins/%D/Plug.tmpasm}\n" | sort >> plugins_ALL.tmpasm
