//--------------------------------------------------------------------------
// Copyright (C) 2021-2024 Cisco and/or its affiliates. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License Version 2 as published
// by the Free Software Foundation.  You may not use, modify or distribute
// this program under any other version of the GNU General Public License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//--------------------------------------------------------------------------

// iec104_parse_information_object_elements.h author Jared Rittle <jared.rittle@cisco.com>

#ifndef IEC104_PARSE_INFORMATION_OBJECT_ELEMENTS_H
#define IEC104_PARSE_INFORMATION_OBJECT_ELEMENTS_H

#include "iec104_parse_apdu.h"

#define IEC104_MS_IN_MINUTE 60000
#define IEC104_MINS_IN_HOUR 60
#define IEC104_HOURS_IN_DAY 24
#define IEC104_TIME2ARES4YEAR_BASE 1900
#define IEC104_TIME2ARES4YEAR_1970 70
#define IEC104_TIME2ARES4YEAR_2027 127
#define IEC104_MAX_DAYOFMONTH_FEB_LEAPYEAR 29
#define IEC104_MAX_DAYOFMONTH_FEB_NONLEAPYEAR 28
#define IEC104_MAX_DAYOFMONTH_30 30
#define IEC104_MAX_DAYOFMONTH_31 31

void parseIec104Coi(const Iec104CoiType* coi);
void parseIec104Qoi(const Iec104QoiType* qoi);
void parseIec104Qcc(const Iec104QccType* qcc);
void parseIec104Qpm(const Iec104QpmType* qpm);
void parseIec104Qpa(const Iec104QpaType* qpa);
void parseIec104Qoc(uint8_t qu, uint8_t se);
void parseIec104Qrp(const Iec104QrpType* qrp);
void parseIec104Frq(const Iec104FrqType* frq);
void parseIec104Srq(const Iec104SrqType* srq);
void parseIec104Scq(const Iec104ScqType* scq);
void parseIec104Lsq(const Iec104LsqType* lsq);
void parseIec104Afq(const Iec104AfqType* afq);
uint32_t parseIec104Vsq(const Iec104ApciI* apci);
void parseIec104CauseOfTx(const Iec104ApciI* apci);
void parseIec104TwoOctetCommonAddress(const Iec104ApciI* apci);
void parseIec104InformationObjectAddressWithThreeOctets(
    const Iec104InformationObjectAddressThreeOctetType* ioa);
void parseIec104Siq(const Iec104SiqType* siq);
void parseIec104Diq(const Iec104DiqType* diq);
void parseIec104Qds(const Iec104QdsType* qds);
void parseIec104Qdp(const Iec104QdpType* qdp);
void parseIec104Vti(const Iec104VtiType* vti);
void parseIec104Nva(const Iec104NvaType* nva);
void parseIec104Sva(const Iec104SvaType* sva);
void parseIec104IeeeStd754(const Iec104IeeeStd754Type* ieeeStd754);
void parseIec104Bcr(const Iec104BcrType* bcr);
void parseIec104Sep(const Iec104SepType* sep);
void parseIec104Spe(const Iec104SpeType* spe);
void parseIec104Oci(const Iec104OciType* oci);
void parseIec104Bsi(const Iec104BsiType* bsi);
void parseIec104Fbp(const Iec104FbpType* fbp);
void parseIec104Sco(const Iec104ScoType* sco);
void parseIec104Dco(const Iec104DcoType* dco);
void parseIec104Rco(const Iec104RcoType* rco);
void parseIec104Time2aMilliseconds(const Iec104Time2aMillisecondsType* time2aMilliseconds);
void parseIec104Time2aIvresminute(const Iec104Time2aIvresminuteType* time2aIvresminute);
void parseIec104Time2aSures2hour(const Iec104Time2aSures2hourType* time2aSures2hour);
void parseIec104Time2aDowday(const Iec104Cp56Time2aType* sevenOctetBinaryTime);
void parseIec104Time2aRes3month(const Iec104Time2aRes3monthType* time2aRes3month);
void parseIec104Time2aRes4year(const Iec104Time2aRes4yearType* time2aRes4year);
void parseIec104Cp56Time2a(const Iec104Cp56Time2aType* sevenOctetBinaryTime);
void parseIec104Cp24Time2a(const Iec104Cp24Time2aType* threeOctetBinaryTime);
void parseIec104Cp16Time2a(const Iec104Cp16Time2aType* cp16Time2a);
void parseIec104Nof(const Iec104NofType* nof);
void parseIec104Nos(const Iec104NosType* nos);
void parseIec104Lof(const Iec104LofType* lof);
bool parseIec104Los(const Iec104LosType* los, uint16_t apduSize);
void parseIec104Chs(const Iec104ChsType* chs);
void parseIec104Sof(const Iec104SofType* sof);
void parseIec104Qos(const Iec104QosType* qos);
void parseIec104Scd(const Iec104ScdType* scd);
void parseIec104Tsc(const Iec104TscType* tsc);
void parseIec104Segment(const Iec104SegmentType* segment);

struct GenericIec104AsduIOGroup
{
    bool includeIOA;
    uint16_t apduSize;
    uint32_t asduType;
    union
    {
        const Iec104M_SP_NA_1_IO_Group* m_sp_na_1IOGroup;
        const Iec104M_SP_TA_1_IO_Group* m_sp_ta_1IOGroup;
        const Iec104M_DP_NA_1_IO_Group* m_dp_na_1IOGroup;
        const Iec104M_DP_TA_1_IO_Group* m_dp_ta_1IOGroup;
        const Iec104M_ST_NA_1_IO_Group* m_st_na_1IOGroup;
        const Iec104M_ST_TA_1_IO_Group* m_st_ta_1IOGroup;
        const Iec104M_BO_NA_1_IO_Group* m_bo_na_1IOGroup;
        const Iec104M_BO_TA_1_IO_Group* m_bo_ta_1IOGroup;
        const Iec104M_ME_NA_1_IO_Group* m_me_na_1IOGroup;
        const Iec104M_ME_TA_1_IO_Group* m_me_ta_1IOGroup;
        const Iec104M_ME_NB_1_IO_Group* m_me_nb_1IOGroup;
        const Iec104M_ME_TB_1_IO_Group* m_me_tb_1IOGroup;
        const Iec104M_ME_NC_1_IO_Group* m_me_nc_1IOGroup;
        const Iec104M_ME_TC_1_IO_Group* m_me_tc_1IOGroup;
        const Iec104M_IT_NA_1_IO_Group* m_it_na_1IOGroup;
        const Iec104M_IT_TA_1_IO_Group* m_it_ta_1IOGroup;
        const Iec104M_EP_TA_1_IO_Group* m_ep_ta_1IOGroup;
        const Iec104M_EP_TB_1_IO_Group* m_ep_tb_1IOGroup;
        const Iec104M_EP_TC_1_IO_Group* m_ep_tc_1IOGroup;
        const Iec104M_PS_NA_1_IO_Group* m_ps_na_1IOGroup;
        const Iec104M_ME_ND_1_IO_Group* m_me_nd_1IOGroup;
        const Iec104M_SP_TB_1_IO_Group* m_sp_tb_1IOGroup;
        const Iec104M_DP_TB_1_IO_Group* m_dp_tb_1IOGroup;
        const Iec104M_ST_TB_1_IO_Group* m_st_tb_1IOGroup;
        const Iec104M_BO_TB_1_IO_Group* m_bo_tb_1IOGroup;
        const Iec104M_ME_TD_1_IO_Group* m_me_td_1IOGroup;
        const Iec104M_ME_TE_1_IO_Group* m_me_te_1IOGroup;
        const Iec104M_ME_TF_1_IO_Group* m_me_tf_1IOGroup;
        const Iec104M_IT_TB_1_IO_Group* m_it_tb_1IOGroup;
        const Iec104M_EP_TD_1_IO_Group* m_ep_td_1IOGroup;
        const Iec104M_EP_TE_1_IO_Group* m_ep_te_1IOGroup;
        const Iec104M_EP_TF_1_IO_Group* m_ep_tf_1IOGroup;
        const Iec104C_SC_NA_1_IO_Group* c_sc_na_1IOGroup;
        const Iec104C_DC_NA_1_IO_Group* c_dc_na_1IOGroup;
        const Iec104C_RC_NA_1_IO_Group* c_rc_na_1IOGroup;
        const Iec104C_SE_NA_1_IO_Group* c_se_na_1IOGroup;
        const Iec104C_SE_NB_1_IO_Group* c_se_nb_1IOGroup;
        const Iec104C_SE_NC_1_IO_Group* c_se_nc_1IOGroup;
        const Iec104C_BO_NA_1_IO_Group* c_bo_na_1IOGroup;
        const Iec104C_SC_TA_1_IO_Group* c_sc_ta_1IOGroup;
        const Iec104C_DC_TA_1_IO_Group* c_dc_ta_1IOGroup;
        const Iec104C_RC_TA_1_IO_Group* c_rc_ta_1IOGroup;
        const Iec104C_SE_TA_1_IO_Group* c_se_ta_1IOGroup;
        const Iec104C_SE_TB_1_IO_Group* c_se_tb_1IOGroup;
        const Iec104C_SE_TC_1_IO_Group* c_se_tc_1IOGroup;
        const Iec104C_BO_TA_1_IO_Group* c_bo_ta_1IOGroup;
        const Iec104M_EI_NA_1_IO_Group* m_ei_na_1IOGroup;
        const Iec104C_IC_NA_1_IO_Group* c_ic_na_1IOGroup;
        const Iec104C_CI_NA_1_IO_Group* c_ci_na_1IOGroup;
        const Iec104C_RD_NA_1_IO_Group* c_rd_na_1IOGroup;
        const Iec104C_CS_NA_1_IO_Group* c_cs_na_1IOGroup;
        const Iec104C_TS_NA_1_IO_Group* c_ts_na_1IOGroup;
        const Iec104C_RP_NA_1_IO_Group* c_rp_na_1IOGroup;
        const Iec104C_CD_NA_1_IO_Group* c_cd_na_1IOGroup;
        const Iec104C_TS_TA_1_IO_Group* c_ts_ta_1IOGroup;
        const Iec104P_ME_NA_1_IO_Group* p_me_na_1IOGroup;
        const Iec104P_ME_NB_1_IO_Group* p_me_nb_1IOGroup;
        const Iec104P_ME_NC_1_IO_Group* p_me_nc_1IOGroup;
        const Iec104P_AC_NA_1_IO_Group* p_ac_na_1IOGroup;
        const Iec104F_FR_NA_1_IO_Group* f_fr_na_1IOGroup;
        const Iec104F_SR_NA_1_IO_Group* f_sr_na_1IOGroup;
        const Iec104F_SC_NA_1_IO_Group* f_sc_na_1IOGroup;
        const Iec104F_LS_NA_1_IO_Group* f_ls_na_1IOGroup;
        const Iec104F_AF_NA_1_IO_Group* f_af_na_1IOGroup;
        const Iec104F_SG_NA_1_IO_Group* f_sg_na_1IOGroup;
        const Iec104F_DR_TA_1_IO_Group* f_dr_ta_1IOGroup;
        const Iec104F_SC_NB_1_IO_Group* f_sc_nb_1IOGroup;
    };
    union
    {
        const Iec104M_SP_NA_1_IO_Subgroup* m_sp_na_1IOSubgroup;
        const Iec104M_SP_TA_1_IO_Subgroup* m_sp_ta_1IOSubgroup;
        const Iec104M_DP_NA_1_IO_Subgroup* m_dp_na_1IOSubgroup;
        const Iec104M_DP_TA_1_IO_Subgroup* m_dp_ta_1IOSubgroup;
        const Iec104M_ST_NA_1_IO_Subgroup* m_st_na_1IOSubgroup;
        const Iec104M_ST_TA_1_IO_Subgroup* m_st_ta_1IOSubgroup;
        const Iec104M_BO_NA_1_IO_Subgroup* m_bo_na_1IOSubgroup;
        const Iec104M_BO_TA_1_IO_Subgroup* m_bo_ta_1IOSubgroup;
        const Iec104M_ME_NA_1_IO_Subgroup* m_me_na_1IOSubgroup;
        const Iec104M_ME_TA_1_IO_Subgroup* m_me_ta_1IOSubgroup;
        const Iec104M_ME_NB_1_IO_Subgroup* m_me_nb_1IOSubgroup;
        const Iec104M_ME_TB_1_IO_Subgroup* m_me_tb_1IOSubgroup;
        const Iec104M_ME_NC_1_IO_Subgroup* m_me_nc_1IOSubgroup;
        const Iec104M_ME_TC_1_IO_Subgroup* m_me_tc_1IOSubgroup;
        const Iec104M_IT_NA_1_IO_Subgroup* m_it_na_1IOSubgroup;
        const Iec104M_IT_TA_1_IO_Subgroup* m_it_ta_1IOSubgroup;
        const Iec104M_EP_TA_1_IO_Subgroup* m_ep_ta_1IOSubgroup;
        const Iec104M_EP_TB_1_IO_Subgroup* m_ep_tb_1IOSubgroup;
        const Iec104M_EP_TC_1_IO_Subgroup* m_ep_tc_1IOSubgroup;
        const Iec104M_PS_NA_1_IO_Subgroup* m_ps_na_1IOSubgroup;
        const Iec104M_ME_ND_1_IO_Subgroup* m_me_nd_1IOSubgroup;
        const Iec104M_SP_TB_1_IO_Subgroup* m_sp_tb_1IOSubgroup;
        const Iec104M_DP_TB_1_IO_Subgroup* m_dp_tb_1IOSubgroup;
        const Iec104M_ST_TB_1_IO_Subgroup* m_st_tb_1IOSubgroup;
        const Iec104M_BO_TB_1_IO_Subgroup* m_bo_tb_1IOSubgroup;
        const Iec104M_ME_TD_1_IO_Subgroup* m_me_td_1IOSubgroup;
        const Iec104M_ME_TE_1_IO_Subgroup* m_me_te_1IOSubgroup;
        const Iec104M_ME_TF_1_IO_Subgroup* m_me_tf_1IOSubgroup;
        const Iec104M_IT_TB_1_IO_Subgroup* m_it_tb_1IOSubgroup;
        const Iec104M_EP_TD_1_IO_Subgroup* m_ep_td_1IOSubgroup;
        const Iec104M_EP_TE_1_IO_Subgroup* m_ep_te_1IOSubgroup;
        const Iec104M_EP_TF_1_IO_Subgroup* m_ep_tf_1IOSubgroup;
        const Iec104C_SC_NA_1_IO_Subgroup* c_sc_na_1IOSubgroup;
        const Iec104C_DC_NA_1_IO_Subgroup* c_dc_na_1IOSubgroup;
        const Iec104C_RC_NA_1_IO_Subgroup* c_rc_na_1IOSubgroup;
        const Iec104C_SE_NA_1_IO_Subgroup* c_se_na_1IOSubgroup;
        const Iec104C_SE_NB_1_IO_Subgroup* c_se_nb_1IOSubgroup;
        const Iec104C_SE_NC_1_IO_Subgroup* c_se_nc_1IOSubgroup;
        const Iec104C_BO_NA_1_IO_Subgroup* c_bo_na_1IOSubgroup;
        const Iec104C_SC_TA_1_IO_Subgroup* c_sc_ta_1IOSubgroup;
        const Iec104C_DC_TA_1_IO_Subgroup* c_dc_ta_1IOSubgroup;
        const Iec104C_RC_TA_1_IO_Subgroup* c_rc_ta_1IOSubgroup;
        const Iec104C_SE_TA_1_IO_Subgroup* c_se_ta_1IOSubgroup;
        const Iec104C_SE_TB_1_IO_Subgroup* c_se_tb_1IOSubgroup;
        const Iec104C_SE_TC_1_IO_Subgroup* c_se_tc_1IOSubgroup;
        const Iec104C_BO_TA_1_IO_Subgroup* c_bo_ta_1IOSubgroup;
        const Iec104M_EI_NA_1_IO_Subgroup* m_ei_na_1IOSubgroup;
        const Iec104C_IC_NA_1_IO_Subgroup* c_ic_na_1IOSubgroup;
        const Iec104C_CI_NA_1_IO_Subgroup* c_ci_na_1IOSubgroup;
        const Iec104C_RD_NA_1_IO_Subgroup* c_rd_na_1IOSubgroup;
        const Iec104C_CS_NA_1_IO_Subgroup* c_cs_na_1IOSubgroup;
        const Iec104C_TS_NA_1_IO_Subgroup* c_ts_na_1IOSubgroup;
        const Iec104C_RP_NA_1_IO_Subgroup* c_rp_na_1IOSubgroup;
        const Iec104C_CD_NA_1_IO_Subgroup* c_cd_na_1IOSubgroup;
        const Iec104C_TS_TA_1_IO_Subgroup* c_ts_ta_1IOSubgroup;
        const Iec104P_ME_NA_1_IO_Subgroup* p_me_na_1IOSubgroup;
        const Iec104P_ME_NB_1_IO_Subgroup* p_me_nb_1IOSubgroup;
        const Iec104P_ME_NC_1_IO_Subgroup* p_me_nc_1IOSubgroup;
        const Iec104P_AC_NA_1_IO_Subgroup* p_ac_na_1IOSubgroup;
        const Iec104F_FR_NA_1_IO_Subgroup* f_fr_na_1IOSubgroup;
        const Iec104F_SR_NA_1_IO_Subgroup* f_sr_na_1IOSubgroup;
        const Iec104F_SC_NA_1_IO_Subgroup* f_sc_na_1IOSubgroup;
        const Iec104F_LS_NA_1_IO_Subgroup* f_ls_na_1IOSubgroup;
        const Iec104F_AF_NA_1_IO_Subgroup* f_af_na_1IOSubgroup;
        const Iec104F_SG_NA_1_IO_Subgroup* f_sg_na_1IOSubgroup;
        const Iec104F_DR_TA_1_IO_Subgroup* f_dr_ta_1IOSubgroup;
        const Iec104F_SC_NB_1_IO_Subgroup* f_sc_nb_1IOSubgroup;
    };
} __attribute__((packed));

enum Iec104MonthEnum
{
    IEC104_MONTH_JAN = 1,
    IEC104_MONTH_FEB = 2,
    IEC104_MONTH_MAR = 3,
    IEC104_MONTH_APR = 4,
    IEC104_MONTH_MAY = 5,
    IEC104_MONTH_JUN = 6,
    IEC104_MONTH_JUL = 7,
    IEC104_MONTH_AUG = 8,
    IEC104_MONTH_SEP = 9,
    IEC104_MONTH_OCT = 10,
    IEC104_MONTH_NOV = 11,
    IEC104_MONTH_DEC = 12,
};

enum Iec104WeekdayEnum
{
    IEC104_DAY_WEEKDAY_UNUSED = 0,
    IEC104_DAY_MONDAY = 1,
    IEC104_DAY_TUESDAY = 2,
    IEC104_DAY_WEDNESDAY = 3,
    IEC104_DAY_THURSDAY = 4,
    IEC104_DAY_FRIDAY = 5,
    IEC104_DAY_SATURDAY = 6,
    IEC104_DAY_SUNDAY = 7,
};

enum Iec104CoiUiEnum
{
    IEC104_COI_UI_LOCPOWON = 0,
    IEC104_COI_UI_LOCMANRST = 1,
    IEC104_COI_UI_REMRST = 2,
    IEC104_COI_UI_RES3 = 3,
    IEC104_COI_UI_RES4 = 4,
    IEC104_COI_UI_RES5 = 5,
    IEC104_COI_UI_RES6 = 6,
    IEC104_COI_UI_RES7 = 7,
    IEC104_COI_UI_RES8 = 8,
    IEC104_COI_UI_RES9 = 9,
    IEC104_COI_UI_RES10 = 10,
    IEC104_COI_UI_RES11 = 11,
    IEC104_COI_UI_RES12 = 12,
    IEC104_COI_UI_RES13 = 13,
    IEC104_COI_UI_RES14 = 14,
    IEC104_COI_UI_RES15 = 15,
    IEC104_COI_UI_RES16 = 16,
    IEC104_COI_UI_RES17 = 17,
    IEC104_COI_UI_RES18 = 18,
    IEC104_COI_UI_RES19 = 19,
    IEC104_COI_UI_RES20 = 20,
    IEC104_COI_UI_RES21 = 21,
    IEC104_COI_UI_RES22 = 22,
    IEC104_COI_UI_RES23 = 23,
    IEC104_COI_UI_RES24 = 24,
    IEC104_COI_UI_RES25 = 25,
    IEC104_COI_UI_RES26 = 26,
    IEC104_COI_UI_RES27 = 27,
    IEC104_COI_UI_RES28 = 28,
    IEC104_COI_UI_RES29 = 29,
    IEC104_COI_UI_RES30 = 30,
    IEC104_COI_UI_RES31 = 31,
    IEC104_COI_UI_RES32 = 32,
    IEC104_COI_UI_RES33 = 33,
    IEC104_COI_UI_RES34 = 34,
    IEC104_COI_UI_RES35 = 35,
    IEC104_COI_UI_RES36 = 36,
    IEC104_COI_UI_RES37 = 37,
    IEC104_COI_UI_RES38 = 38,
    IEC104_COI_UI_RES39 = 39,
    IEC104_COI_UI_RES40 = 40,
    IEC104_COI_UI_RES41 = 41,
    IEC104_COI_UI_RES42 = 42,
    IEC104_COI_UI_RES43 = 43,
    IEC104_COI_UI_RES44 = 44,
    IEC104_COI_UI_RES45 = 45,
    IEC104_COI_UI_RES46 = 46,
    IEC104_COI_UI_RES47 = 47,
    IEC104_COI_UI_RES48 = 48,
    IEC104_COI_UI_RES49 = 49,
    IEC104_COI_UI_RES50 = 50,
    IEC104_COI_UI_RES51 = 51,
    IEC104_COI_UI_RES52 = 52,
    IEC104_COI_UI_RES53 = 53,
    IEC104_COI_UI_RES54 = 54,
    IEC104_COI_UI_RES55 = 55,
    IEC104_COI_UI_RES56 = 56,
    IEC104_COI_UI_RES57 = 57,
    IEC104_COI_UI_RES58 = 58,
    IEC104_COI_UI_RES59 = 59,
    IEC104_COI_UI_RES60 = 60,
    IEC104_COI_UI_RES61 = 61,
    IEC104_COI_UI_RES62 = 62,
    IEC104_COI_UI_RES63 = 63,
    IEC104_COI_UI_RES64 = 64,
    IEC104_COI_UI_RES65 = 65,
    IEC104_COI_UI_RES66 = 66,
    IEC104_COI_UI_RES67 = 67,
    IEC104_COI_UI_RES68 = 68,
    IEC104_COI_UI_RES69 = 69,
    IEC104_COI_UI_RES70 = 70,
    IEC104_COI_UI_RES71 = 71,
    IEC104_COI_UI_RES72 = 72,
    IEC104_COI_UI_RES73 = 73,
    IEC104_COI_UI_RES74 = 74,
    IEC104_COI_UI_RES75 = 75,
    IEC104_COI_UI_RES76 = 76,
    IEC104_COI_UI_RES77 = 77,
    IEC104_COI_UI_RES78 = 78,
    IEC104_COI_UI_RES79 = 79,
    IEC104_COI_UI_RES80 = 80,
    IEC104_COI_UI_RES81 = 81,
    IEC104_COI_UI_RES82 = 82,
    IEC104_COI_UI_RES83 = 83,
    IEC104_COI_UI_RES84 = 84,
    IEC104_COI_UI_RES85 = 85,
    IEC104_COI_UI_RES86 = 86,
    IEC104_COI_UI_RES87 = 87,
    IEC104_COI_UI_RES88 = 88,
    IEC104_COI_UI_RES89 = 89,
    IEC104_COI_UI_RES90 = 90,
    IEC104_COI_UI_RES91 = 91,
    IEC104_COI_UI_RES92 = 92,
    IEC104_COI_UI_RES93 = 93,
    IEC104_COI_UI_RES94 = 94,
    IEC104_COI_UI_RES95 = 95,
    IEC104_COI_UI_RES96 = 96,
    IEC104_COI_UI_RES97 = 97,
    IEC104_COI_UI_RES98 = 98,
    IEC104_COI_UI_RES99 = 99,
    IEC104_COI_UI_RES100 = 100,
    IEC104_COI_UI_RES101 = 101,
    IEC104_COI_UI_RES102 = 102,
    IEC104_COI_UI_RES103 = 103,
    IEC104_COI_UI_RES104 = 104,
    IEC104_COI_UI_RES105 = 105,
    IEC104_COI_UI_RES106 = 106,
    IEC104_COI_UI_RES107 = 107,
    IEC104_COI_UI_RES108 = 108,
    IEC104_COI_UI_RES109 = 109,
    IEC104_COI_UI_RES110 = 110,
    IEC104_COI_UI_RES111 = 111,
    IEC104_COI_UI_RES112 = 112,
    IEC104_COI_UI_RES113 = 113,
    IEC104_COI_UI_RES114 = 114,
    IEC104_COI_UI_RES115 = 115,
    IEC104_COI_UI_RES116 = 116,
    IEC104_COI_UI_RES117 = 117,
    IEC104_COI_UI_RES118 = 118,
    IEC104_COI_UI_RES119 = 119,
    IEC104_COI_UI_RES120 = 120,
    IEC104_COI_UI_RES121 = 121,
    IEC104_COI_UI_RES122 = 122,
    IEC104_COI_UI_RES123 = 123,
    IEC104_COI_UI_RES124 = 124,
    IEC104_COI_UI_RES125 = 125,
    IEC104_COI_UI_RES126 = 126,
    IEC104_COI_UI_RES127 = 127,
};

enum Iec104QoiEnum
{
    IEC104_QOI_NOTUSED = 0,
    IEC104_QOI_RES1 = 1,
    IEC104_QOI_RES2 = 2,
    IEC104_QOI_RES3 = 3,
    IEC104_QOI_RES4 = 4,
    IEC104_QOI_RES5 = 5,
    IEC104_QOI_RES6 = 6,
    IEC104_QOI_RES7 = 7,
    IEC104_QOI_RES8 = 8,
    IEC104_QOI_RES9 = 9,
    IEC104_QOI_RES10 = 10,
    IEC104_QOI_RES11 = 11,
    IEC104_QOI_RES12 = 12,
    IEC104_QOI_RES13 = 13,
    IEC104_QOI_RES14 = 14,
    IEC104_QOI_RES15 = 15,
    IEC104_QOI_RES16 = 16,
    IEC104_QOI_RES17 = 17,
    IEC104_QOI_RES18 = 18,
    IEC104_QOI_RES19 = 19,
    IEC104_QOI_INROSTAT = 20,
    IEC104_QOI_INRO1 = 21,
    IEC104_QOI_INRO2 = 22,
    IEC104_QOI_INRO3 = 23,
    IEC104_QOI_INRO4 = 24,
    IEC104_QOI_INRO5 = 25,
    IEC104_QOI_INRO6 = 26,
    IEC104_QOI_INRO7 = 27,
    IEC104_QOI_INRO8 = 28,
    IEC104_QOI_INRO9 = 29,
    IEC104_QOI_INRO10 = 30,
    IEC104_QOI_INRO11 = 31,
    IEC104_QOI_INRO12 = 32,
    IEC104_QOI_INRO13 = 33,
    IEC104_QOI_INRO14 = 34,
    IEC104_QOI_INRO15 = 35,
    IEC104_QOI_INRO16 = 36,
    IEC104_QOI_RES37 = 37,
    IEC104_QOI_RES38 = 38,
    IEC104_QOI_RES39 = 39,
    IEC104_QOI_RES40 = 40,
    IEC104_QOI_RES41 = 41,
    IEC104_QOI_RES42 = 42,
    IEC104_QOI_RES43 = 43,
    IEC104_QOI_RES44 = 44,
    IEC104_QOI_RES45 = 45,
    IEC104_QOI_RES46 = 46,
    IEC104_QOI_RES47 = 47,
    IEC104_QOI_RES48 = 48,
    IEC104_QOI_RES49 = 49,
    IEC104_QOI_RES50 = 50,
    IEC104_QOI_RES51 = 51,
    IEC104_QOI_RES52 = 52,
    IEC104_QOI_RES53 = 53,
    IEC104_QOI_RES54 = 54,
    IEC104_QOI_RES55 = 55,
    IEC104_QOI_RES56 = 56,
    IEC104_QOI_RES57 = 57,
    IEC104_QOI_RES58 = 58,
    IEC104_QOI_RES59 = 59,
    IEC104_QOI_RES60 = 60,
    IEC104_QOI_RES61 = 61,
    IEC104_QOI_RES62 = 62,
    IEC104_QOI_RES63 = 63,
    IEC104_QOI_RES64 = 64,
    IEC104_QOI_RES65 = 65,
    IEC104_QOI_RES66 = 66,
    IEC104_QOI_RES67 = 67,
    IEC104_QOI_RES68 = 68,
    IEC104_QOI_RES69 = 69,
    IEC104_QOI_RES70 = 70,
    IEC104_QOI_RES71 = 71,
    IEC104_QOI_RES72 = 72,
    IEC104_QOI_RES73 = 73,
    IEC104_QOI_RES74 = 74,
    IEC104_QOI_RES75 = 75,
    IEC104_QOI_RES76 = 76,
    IEC104_QOI_RES77 = 77,
    IEC104_QOI_RES78 = 78,
    IEC104_QOI_RES79 = 79,
    IEC104_QOI_RES80 = 80,
    IEC104_QOI_RES81 = 81,
    IEC104_QOI_RES82 = 82,
    IEC104_QOI_RES83 = 83,
    IEC104_QOI_RES84 = 84,
    IEC104_QOI_RES85 = 85,
    IEC104_QOI_RES86 = 86,
    IEC104_QOI_RES87 = 87,
    IEC104_QOI_RES88 = 88,
    IEC104_QOI_RES89 = 89,
    IEC104_QOI_RES90 = 90,
    IEC104_QOI_RES91 = 91,
    IEC104_QOI_RES92 = 92,
    IEC104_QOI_RES93 = 93,
    IEC104_QOI_RES94 = 94,
    IEC104_QOI_RES95 = 95,
    IEC104_QOI_RES96 = 96,
    IEC104_QOI_RES97 = 97,
    IEC104_QOI_RES98 = 98,
    IEC104_QOI_RES99 = 99,
    IEC104_QOI_RES100 = 100,
    IEC104_QOI_RES101 = 101,
    IEC104_QOI_RES102 = 102,
    IEC104_QOI_RES103 = 103,
    IEC104_QOI_RES104 = 104,
    IEC104_QOI_RES105 = 105,
    IEC104_QOI_RES106 = 106,
    IEC104_QOI_RES107 = 107,
    IEC104_QOI_RES108 = 108,
    IEC104_QOI_RES109 = 109,
    IEC104_QOI_RES110 = 110,
    IEC104_QOI_RES111 = 111,
    IEC104_QOI_RES112 = 112,
    IEC104_QOI_RES113 = 113,
    IEC104_QOI_RES114 = 114,
    IEC104_QOI_RES115 = 115,
    IEC104_QOI_RES116 = 116,
    IEC104_QOI_RES117 = 117,
    IEC104_QOI_RES118 = 118,
    IEC104_QOI_RES119 = 119,
    IEC104_QOI_RES120 = 120,
    IEC104_QOI_RES121 = 121,
    IEC104_QOI_RES122 = 122,
    IEC104_QOI_RES123 = 123,
    IEC104_QOI_RES124 = 124,
    IEC104_QOI_RES125 = 125,
    IEC104_QOI_RES126 = 126,
    IEC104_QOI_RES127 = 127,
    IEC104_QOI_RES128 = 128,
    IEC104_QOI_RES129 = 129,
    IEC104_QOI_RES130 = 130,
    IEC104_QOI_RES131 = 131,
    IEC104_QOI_RES132 = 132,
    IEC104_QOI_RES133 = 133,
    IEC104_QOI_RES134 = 134,
    IEC104_QOI_RES135 = 135,
    IEC104_QOI_RES136 = 136,
    IEC104_QOI_RES137 = 137,
    IEC104_QOI_RES138 = 138,
    IEC104_QOI_RES139 = 139,
    IEC104_QOI_RES140 = 140,
    IEC104_QOI_RES141 = 141,
    IEC104_QOI_RES142 = 142,
    IEC104_QOI_RES143 = 143,
    IEC104_QOI_RES144 = 144,
    IEC104_QOI_RES145 = 145,
    IEC104_QOI_RES146 = 146,
    IEC104_QOI_RES147 = 147,
    IEC104_QOI_RES148 = 148,
    IEC104_QOI_RES149 = 149,
    IEC104_QOI_RES150 = 150,
    IEC104_QOI_RES151 = 151,
    IEC104_QOI_RES152 = 152,
    IEC104_QOI_RES153 = 153,
    IEC104_QOI_RES154 = 154,
    IEC104_QOI_RES155 = 155,
    IEC104_QOI_RES156 = 156,
    IEC104_QOI_RES157 = 157,
    IEC104_QOI_RES158 = 158,
    IEC104_QOI_RES159 = 159,
    IEC104_QOI_RES160 = 160,
    IEC104_QOI_RES161 = 161,
    IEC104_QOI_RES162 = 162,
    IEC104_QOI_RES163 = 163,
    IEC104_QOI_RES164 = 164,
    IEC104_QOI_RES165 = 165,
    IEC104_QOI_RES166 = 166,
    IEC104_QOI_RES167 = 167,
    IEC104_QOI_RES168 = 168,
    IEC104_QOI_RES169 = 169,
    IEC104_QOI_RES170 = 170,
    IEC104_QOI_RES171 = 171,
    IEC104_QOI_RES172 = 172,
    IEC104_QOI_RES173 = 173,
    IEC104_QOI_RES174 = 174,
    IEC104_QOI_RES175 = 175,
    IEC104_QOI_RES176 = 176,
    IEC104_QOI_RES177 = 177,
    IEC104_QOI_RES178 = 178,
    IEC104_QOI_RES179 = 179,
    IEC104_QOI_RES180 = 180,
    IEC104_QOI_RES181 = 181,
    IEC104_QOI_RES182 = 182,
    IEC104_QOI_RES183 = 183,
    IEC104_QOI_RES184 = 184,
    IEC104_QOI_RES185 = 185,
    IEC104_QOI_RES186 = 186,
    IEC104_QOI_RES187 = 187,
    IEC104_QOI_RES188 = 188,
    IEC104_QOI_RES189 = 189,
    IEC104_QOI_RES190 = 190,
    IEC104_QOI_RES191 = 191,
    IEC104_QOI_RES192 = 192,
    IEC104_QOI_RES193 = 193,
    IEC104_QOI_RES194 = 194,
    IEC104_QOI_RES195 = 195,
    IEC104_QOI_RES196 = 196,
    IEC104_QOI_RES197 = 197,
    IEC104_QOI_RES198 = 198,
    IEC104_QOI_RES199 = 199,
    IEC104_QOI_RES200 = 200,
    IEC104_QOI_RES201 = 201,
    IEC104_QOI_RES202 = 202,
    IEC104_QOI_RES203 = 203,
    IEC104_QOI_RES204 = 204,
    IEC104_QOI_RES205 = 205,
    IEC104_QOI_RES206 = 206,
    IEC104_QOI_RES207 = 207,
    IEC104_QOI_RES208 = 208,
    IEC104_QOI_RES209 = 209,
    IEC104_QOI_RES210 = 210,
    IEC104_QOI_RES211 = 211,
    IEC104_QOI_RES212 = 212,
    IEC104_QOI_RES213 = 213,
    IEC104_QOI_RES214 = 214,
    IEC104_QOI_RES215 = 215,
    IEC104_QOI_RES216 = 216,
    IEC104_QOI_RES217 = 217,
    IEC104_QOI_RES218 = 218,
    IEC104_QOI_RES219 = 219,
    IEC104_QOI_RES220 = 220,
    IEC104_QOI_RES221 = 221,
    IEC104_QOI_RES222 = 222,
    IEC104_QOI_RES223 = 223,
    IEC104_QOI_RES224 = 224,
    IEC104_QOI_RES225 = 225,
    IEC104_QOI_RES226 = 226,
    IEC104_QOI_RES227 = 227,
    IEC104_QOI_RES228 = 228,
    IEC104_QOI_RES229 = 229,
    IEC104_QOI_RES230 = 230,
    IEC104_QOI_RES231 = 231,
    IEC104_QOI_RES232 = 232,
    IEC104_QOI_RES233 = 233,
    IEC104_QOI_RES234 = 234,
    IEC104_QOI_RES235 = 235,
    IEC104_QOI_RES236 = 236,
    IEC104_QOI_RES237 = 237,
    IEC104_QOI_RES238 = 238,
    IEC104_QOI_RES239 = 239,
    IEC104_QOI_RES240 = 240,
    IEC104_QOI_RES241 = 241,
    IEC104_QOI_RES242 = 242,
    IEC104_QOI_RES243 = 243,
    IEC104_QOI_RES244 = 244,
    IEC104_QOI_RES245 = 245,
    IEC104_QOI_RES246 = 246,
    IEC104_QOI_RES247 = 247,
    IEC104_QOI_RES248 = 248,
    IEC104_QOI_RES249 = 249,
    IEC104_QOI_RES250 = 250,
    IEC104_QOI_RES251 = 251,
    IEC104_QOI_RES252 = 252,
    IEC104_QOI_RES253 = 253,
    IEC104_QOI_RES254 = 254,
    IEC104_QOI_RES255 = 255,
};

enum Iec104QccRqtEnum
{
    IEC104_QCC_RQT_NOTUSED = 0,
    IEC104_QCC_RQT_GROUP1 = 1,
    IEC104_QCC_RQT_GROUP2 = 2,
    IEC104_QCC_RQT_GROUP3 = 3,
    IEC104_QCC_RQT_GROUP4 = 4,
    IEC104_QCC_RQT_GENCTR = 5,
    IEC104_QCC_RQT_RES6 = 6,
    IEC104_QCC_RQT_RES7 = 7,
    IEC104_QCC_RQT_RES8 = 8,
    IEC104_QCC_RQT_RES9 = 9,
    IEC104_QCC_RQT_RES10 = 10,
    IEC104_QCC_RQT_RES11 = 11,
    IEC104_QCC_RQT_RES12 = 12,
    IEC104_QCC_RQT_RES13 = 13,
    IEC104_QCC_RQT_RES14 = 14,
    IEC104_QCC_RQT_RES15 = 15,
    IEC104_QCC_RQT_RES16 = 16,
    IEC104_QCC_RQT_RES17 = 17,
    IEC104_QCC_RQT_RES18 = 18,
    IEC104_QCC_RQT_RES19 = 19,
    IEC104_QCC_RQT_RES20 = 20,
    IEC104_QCC_RQT_RES21 = 21,
    IEC104_QCC_RQT_RES22 = 22,
    IEC104_QCC_RQT_RES23 = 23,
    IEC104_QCC_RQT_RES24 = 24,
    IEC104_QCC_RQT_RES25 = 25,
    IEC104_QCC_RQT_RES26 = 26,
    IEC104_QCC_RQT_RES27 = 27,
    IEC104_QCC_RQT_RES28 = 28,
    IEC104_QCC_RQT_RES29 = 29,
    IEC104_QCC_RQT_RES30 = 30,
    IEC104_QCC_RQT_RES31 = 31,
    IEC104_QCC_RQT_RES32 = 32,
    IEC104_QCC_RQT_RES33 = 33,
    IEC104_QCC_RQT_RES34 = 34,
    IEC104_QCC_RQT_RES35 = 35,
    IEC104_QCC_RQT_RES36 = 36,
    IEC104_QCC_RQT_RES37 = 37,
    IEC104_QCC_RQT_RES38 = 38,
    IEC104_QCC_RQT_RES39 = 39,
    IEC104_QCC_RQT_RES40 = 40,
    IEC104_QCC_RQT_RES41 = 41,
    IEC104_QCC_RQT_RES42 = 42,
    IEC104_QCC_RQT_RES43 = 43,
    IEC104_QCC_RQT_RES44 = 44,
    IEC104_QCC_RQT_RES45 = 45,
    IEC104_QCC_RQT_RES46 = 46,
    IEC104_QCC_RQT_RES47 = 47,
    IEC104_QCC_RQT_RES48 = 48,
    IEC104_QCC_RQT_RES49 = 49,
    IEC104_QCC_RQT_RES50 = 50,
    IEC104_QCC_RQT_RES51 = 51,
    IEC104_QCC_RQT_RES52 = 52,
    IEC104_QCC_RQT_RES53 = 53,
    IEC104_QCC_RQT_RES54 = 54,
    IEC104_QCC_RQT_RES55 = 55,
    IEC104_QCC_RQT_RES56 = 56,
    IEC104_QCC_RQT_RES57 = 57,
    IEC104_QCC_RQT_RES58 = 58,
    IEC104_QCC_RQT_RES59 = 59,
    IEC104_QCC_RQT_RES60 = 60,
    IEC104_QCC_RQT_RES61 = 61,
    IEC104_QCC_RQT_RES62 = 62,
    IEC104_QCC_RQT_RES63 = 63,
};

enum Iec104QccFrzEnum
{
    IEC104_QCC_FRZ_READ = 0,
    IEC104_QCC_FRZ_CTRFRZWITHOUTRST = 1,
    IEC104_QCC_FRZ_CTRFRZWITHRST = 2,
    IEC104_QCC_FRZ_CTRRST = 3,
};

enum Iec104QpmKpaEnum
{
    IEC104_QPM_KPA_NOTUSED = 0,
    IEC104_QPM_KPA_THRESHVAL = 1,
    IEC104_QPM_KPA_SMOOTHFACTOR = 2,
    IEC104_QPM_KPA_LOWTXLMT = 3,
    IEC104_QPM_KPA_HIGHTXLMT = 4,
    IEC104_QPM_KPA_RES5 = 5,
    IEC104_QPM_KPA_RES6 = 6,
    IEC104_QPM_KPA_RES7 = 7,
    IEC104_QPM_KPA_RES8 = 8,
    IEC104_QPM_KPA_RES9 = 9,
    IEC104_QPM_KPA_RES10 = 10,
    IEC104_QPM_KPA_RES11 = 11,
    IEC104_QPM_KPA_RES12 = 12,
    IEC104_QPM_KPA_RES13 = 13,
    IEC104_QPM_KPA_RES14 = 14,
    IEC104_QPM_KPA_RES15 = 15,
    IEC104_QPM_KPA_RES16 = 16,
    IEC104_QPM_KPA_RES17 = 17,
    IEC104_QPM_KPA_RES18 = 18,
    IEC104_QPM_KPA_RES19 = 19,
    IEC104_QPM_KPA_RES20 = 20,
    IEC104_QPM_KPA_RES21 = 21,
    IEC104_QPM_KPA_RES22 = 22,
    IEC104_QPM_KPA_RES23 = 23,
    IEC104_QPM_KPA_RES24 = 24,
    IEC104_QPM_KPA_RES25 = 25,
    IEC104_QPM_KPA_RES26 = 26,
    IEC104_QPM_KPA_RES27 = 27,
    IEC104_QPM_KPA_RES28 = 28,
    IEC104_QPM_KPA_RES29 = 29,
    IEC104_QPM_KPA_RES30 = 30,
    IEC104_QPM_KPA_RES31 = 31,
    IEC104_QPM_KPA_RES32 = 32,
    IEC104_QPM_KPA_RES33 = 33,
    IEC104_QPM_KPA_RES34 = 34,
    IEC104_QPM_KPA_RES35 = 35,
    IEC104_QPM_KPA_RES36 = 36,
    IEC104_QPM_KPA_RES37 = 37,
    IEC104_QPM_KPA_RES38 = 38,
    IEC104_QPM_KPA_RES39 = 39,
    IEC104_QPM_KPA_RES40 = 40,
    IEC104_QPM_KPA_RES41 = 41,
    IEC104_QPM_KPA_RES42 = 42,
    IEC104_QPM_KPA_RES43 = 43,
    IEC104_QPM_KPA_RES44 = 44,
    IEC104_QPM_KPA_RES45 = 45,
    IEC104_QPM_KPA_RES46 = 46,
    IEC104_QPM_KPA_RES47 = 47,
    IEC104_QPM_KPA_RES48 = 48,
    IEC104_QPM_KPA_RES49 = 49,
    IEC104_QPM_KPA_RES50 = 50,
    IEC104_QPM_KPA_RES51 = 51,
    IEC104_QPM_KPA_RES52 = 52,
    IEC104_QPM_KPA_RES53 = 53,
    IEC104_QPM_KPA_RES54 = 54,
    IEC104_QPM_KPA_RES55 = 55,
    IEC104_QPM_KPA_RES56 = 56,
    IEC104_QPM_KPA_RES57 = 57,
    IEC104_QPM_KPA_RES58 = 58,
    IEC104_QPM_KPA_RES59 = 59,
    IEC104_QPM_KPA_RES60 = 60,
    IEC104_QPM_KPA_RES61 = 61,
    IEC104_QPM_KPA_RES62 = 62,
    IEC104_QPM_KPA_RES63 = 63,
};

enum Iec104QpaEnum
{
    IEC104_QPA_NOTUSED = 0,
    IEC104_QPA_ACTDEACTPREVPARAM = 1,
    IEC104_QPA_ACTDEACTPARAM = 2,
    IEC104_QPA_ACTDEACTCYCTX = 3,
    IEC104_QPA_RES4 = 4,
    IEC104_QPA_RES5 = 5,
    IEC104_QPA_RES6 = 6,
    IEC104_QPA_RES7 = 7,
    IEC104_QPA_RES8 = 8,
    IEC104_QPA_RES9 = 9,
    IEC104_QPA_RES10 = 10,
    IEC104_QPA_RES11 = 11,
    IEC104_QPA_RES12 = 12,
    IEC104_QPA_RES13 = 13,
    IEC104_QPA_RES14 = 14,
    IEC104_QPA_RES15 = 15,
    IEC104_QPA_RES16 = 16,
    IEC104_QPA_RES17 = 17,
    IEC104_QPA_RES18 = 18,
    IEC104_QPA_RES19 = 19,
    IEC104_QPA_RES20 = 20,
    IEC104_QPA_RES21 = 21,
    IEC104_QPA_RES22 = 22,
    IEC104_QPA_RES23 = 23,
    IEC104_QPA_RES24 = 24,
    IEC104_QPA_RES25 = 25,
    IEC104_QPA_RES26 = 26,
    IEC104_QPA_RES27 = 27,
    IEC104_QPA_RES28 = 28,
    IEC104_QPA_RES29 = 29,
    IEC104_QPA_RES30 = 30,
    IEC104_QPA_RES31 = 31,
    IEC104_QPA_RES32 = 32,
    IEC104_QPA_RES33 = 33,
    IEC104_QPA_RES34 = 34,
    IEC104_QPA_RES35 = 35,
    IEC104_QPA_RES36 = 36,
    IEC104_QPA_RES37 = 37,
    IEC104_QPA_RES38 = 38,
    IEC104_QPA_RES39 = 39,
    IEC104_QPA_RES40 = 40,
    IEC104_QPA_RES41 = 41,
    IEC104_QPA_RES42 = 42,
    IEC104_QPA_RES43 = 43,
    IEC104_QPA_RES44 = 44,
    IEC104_QPA_RES45 = 45,
    IEC104_QPA_RES46 = 46,
    IEC104_QPA_RES47 = 47,
    IEC104_QPA_RES48 = 48,
    IEC104_QPA_RES49 = 49,
    IEC104_QPA_RES50 = 50,
    IEC104_QPA_RES51 = 51,
    IEC104_QPA_RES52 = 52,
    IEC104_QPA_RES53 = 53,
    IEC104_QPA_RES54 = 54,
    IEC104_QPA_RES55 = 55,
    IEC104_QPA_RES56 = 56,
    IEC104_QPA_RES57 = 57,
    IEC104_QPA_RES58 = 58,
    IEC104_QPA_RES59 = 59,
    IEC104_QPA_RES60 = 60,
    IEC104_QPA_RES61 = 61,
    IEC104_QPA_RES62 = 62,
    IEC104_QPA_RES63 = 63,
    IEC104_QPA_RES64 = 64,
    IEC104_QPA_RES65 = 65,
    IEC104_QPA_RES66 = 66,
    IEC104_QPA_RES67 = 67,
    IEC104_QPA_RES68 = 68,
    IEC104_QPA_RES69 = 69,
    IEC104_QPA_RES70 = 70,
    IEC104_QPA_RES71 = 71,
    IEC104_QPA_RES72 = 72,
    IEC104_QPA_RES73 = 73,
    IEC104_QPA_RES74 = 74,
    IEC104_QPA_RES75 = 75,
    IEC104_QPA_RES76 = 76,
    IEC104_QPA_RES77 = 77,
    IEC104_QPA_RES78 = 78,
    IEC104_QPA_RES79 = 79,
    IEC104_QPA_RES80 = 80,
    IEC104_QPA_RES81 = 81,
    IEC104_QPA_RES82 = 82,
    IEC104_QPA_RES83 = 83,
    IEC104_QPA_RES84 = 84,
    IEC104_QPA_RES85 = 85,
    IEC104_QPA_RES86 = 86,
    IEC104_QPA_RES87 = 87,
    IEC104_QPA_RES88 = 88,
    IEC104_QPA_RES89 = 89,
    IEC104_QPA_RES90 = 90,
    IEC104_QPA_RES91 = 91,
    IEC104_QPA_RES92 = 92,
    IEC104_QPA_RES93 = 93,
    IEC104_QPA_RES94 = 94,
    IEC104_QPA_RES95 = 95,
    IEC104_QPA_RES96 = 96,
    IEC104_QPA_RES97 = 97,
    IEC104_QPA_RES98 = 98,
    IEC104_QPA_RES99 = 99,
    IEC104_QPA_RES100 = 100,
    IEC104_QPA_RES101 = 101,
    IEC104_QPA_RES102 = 102,
    IEC104_QPA_RES103 = 103,
    IEC104_QPA_RES104 = 104,
    IEC104_QPA_RES105 = 105,
    IEC104_QPA_RES106 = 106,
    IEC104_QPA_RES107 = 107,
    IEC104_QPA_RES108 = 108,
    IEC104_QPA_RES109 = 109,
    IEC104_QPA_RES110 = 110,
    IEC104_QPA_RES111 = 111,
    IEC104_QPA_RES112 = 112,
    IEC104_QPA_RES113 = 113,
    IEC104_QPA_RES114 = 114,
    IEC104_QPA_RES115 = 115,
    IEC104_QPA_RES116 = 116,
    IEC104_QPA_RES117 = 117,
    IEC104_QPA_RES118 = 118,
    IEC104_QPA_RES119 = 119,
    IEC104_QPA_RES120 = 120,
    IEC104_QPA_RES121 = 121,
    IEC104_QPA_RES122 = 122,
    IEC104_QPA_RES123 = 123,
    IEC104_QPA_RES124 = 124,
    IEC104_QPA_RES125 = 125,
    IEC104_QPA_RES126 = 126,
    IEC104_QPA_RES127 = 127,
    IEC104_QPA_RES128 = 128,
    IEC104_QPA_RES129 = 129,
    IEC104_QPA_RES130 = 130,
    IEC104_QPA_RES131 = 131,
    IEC104_QPA_RES132 = 132,
    IEC104_QPA_RES133 = 133,
    IEC104_QPA_RES134 = 134,
    IEC104_QPA_RES135 = 135,
    IEC104_QPA_RES136 = 136,
    IEC104_QPA_RES137 = 137,
    IEC104_QPA_RES138 = 138,
    IEC104_QPA_RES139 = 139,
    IEC104_QPA_RES140 = 140,
    IEC104_QPA_RES141 = 141,
    IEC104_QPA_RES142 = 142,
    IEC104_QPA_RES143 = 143,
    IEC104_QPA_RES144 = 144,
    IEC104_QPA_RES145 = 145,
    IEC104_QPA_RES146 = 146,
    IEC104_QPA_RES147 = 147,
    IEC104_QPA_RES148 = 148,
    IEC104_QPA_RES149 = 149,
    IEC104_QPA_RES150 = 150,
    IEC104_QPA_RES151 = 151,
    IEC104_QPA_RES152 = 152,
    IEC104_QPA_RES153 = 153,
    IEC104_QPA_RES154 = 154,
    IEC104_QPA_RES155 = 155,
    IEC104_QPA_RES156 = 156,
    IEC104_QPA_RES157 = 157,
    IEC104_QPA_RES158 = 158,
    IEC104_QPA_RES159 = 159,
    IEC104_QPA_RES160 = 160,
    IEC104_QPA_RES161 = 161,
    IEC104_QPA_RES162 = 162,
    IEC104_QPA_RES163 = 163,
    IEC104_QPA_RES164 = 164,
    IEC104_QPA_RES165 = 165,
    IEC104_QPA_RES166 = 166,
    IEC104_QPA_RES167 = 167,
    IEC104_QPA_RES168 = 168,
    IEC104_QPA_RES169 = 169,
    IEC104_QPA_RES170 = 170,
    IEC104_QPA_RES171 = 171,
    IEC104_QPA_RES172 = 172,
    IEC104_QPA_RES173 = 173,
    IEC104_QPA_RES174 = 174,
    IEC104_QPA_RES175 = 175,
    IEC104_QPA_RES176 = 176,
    IEC104_QPA_RES177 = 177,
    IEC104_QPA_RES178 = 178,
    IEC104_QPA_RES179 = 179,
    IEC104_QPA_RES180 = 180,
    IEC104_QPA_RES181 = 181,
    IEC104_QPA_RES182 = 182,
    IEC104_QPA_RES183 = 183,
    IEC104_QPA_RES184 = 184,
    IEC104_QPA_RES185 = 185,
    IEC104_QPA_RES186 = 186,
    IEC104_QPA_RES187 = 187,
    IEC104_QPA_RES188 = 188,
    IEC104_QPA_RES189 = 189,
    IEC104_QPA_RES190 = 190,
    IEC104_QPA_RES191 = 191,
    IEC104_QPA_RES192 = 192,
    IEC104_QPA_RES193 = 193,
    IEC104_QPA_RES194 = 194,
    IEC104_QPA_RES195 = 195,
    IEC104_QPA_RES196 = 196,
    IEC104_QPA_RES197 = 197,
    IEC104_QPA_RES198 = 198,
    IEC104_QPA_RES199 = 199,
    IEC104_QPA_RES200 = 200,
    IEC104_QPA_RES201 = 201,
    IEC104_QPA_RES202 = 202,
    IEC104_QPA_RES203 = 203,
    IEC104_QPA_RES204 = 204,
    IEC104_QPA_RES205 = 205,
    IEC104_QPA_RES206 = 206,
    IEC104_QPA_RES207 = 207,
    IEC104_QPA_RES208 = 208,
    IEC104_QPA_RES209 = 209,
    IEC104_QPA_RES210 = 210,
    IEC104_QPA_RES211 = 211,
    IEC104_QPA_RES212 = 212,
    IEC104_QPA_RES213 = 213,
    IEC104_QPA_RES214 = 214,
    IEC104_QPA_RES215 = 215,
    IEC104_QPA_RES216 = 216,
    IEC104_QPA_RES217 = 217,
    IEC104_QPA_RES218 = 218,
    IEC104_QPA_RES219 = 219,
    IEC104_QPA_RES220 = 220,
    IEC104_QPA_RES221 = 221,
    IEC104_QPA_RES222 = 222,
    IEC104_QPA_RES223 = 223,
    IEC104_QPA_RES224 = 224,
    IEC104_QPA_RES225 = 225,
    IEC104_QPA_RES226 = 226,
    IEC104_QPA_RES227 = 227,
    IEC104_QPA_RES228 = 228,
    IEC104_QPA_RES229 = 229,
    IEC104_QPA_RES230 = 230,
    IEC104_QPA_RES231 = 231,
    IEC104_QPA_RES232 = 232,
    IEC104_QPA_RES233 = 233,
    IEC104_QPA_RES234 = 234,
    IEC104_QPA_RES235 = 235,
    IEC104_QPA_RES236 = 236,
    IEC104_QPA_RES237 = 237,
    IEC104_QPA_RES238 = 238,
    IEC104_QPA_RES239 = 239,
    IEC104_QPA_RES240 = 240,
    IEC104_QPA_RES241 = 241,
    IEC104_QPA_RES242 = 242,
    IEC104_QPA_RES243 = 243,
    IEC104_QPA_RES244 = 244,
    IEC104_QPA_RES245 = 245,
    IEC104_QPA_RES246 = 246,
    IEC104_QPA_RES247 = 247,
    IEC104_QPA_RES248 = 248,
    IEC104_QPA_RES249 = 249,
    IEC104_QPA_RES250 = 250,
    IEC104_QPA_RES251 = 251,
    IEC104_QPA_RES252 = 252,
    IEC104_QPA_RES253 = 253,
    IEC104_QPA_RES254 = 254,
    IEC104_QPA_RES255 = 255,
};

enum Iec104QocQuEnum
{
    IEC104_QOC_QU_NOADDDEF = 0,
    IEC104_QOC_QU_SHORTPULSE = 1,
    IEC104_QOC_QU_LONGPULSE = 2,
    IEC104_QOC_QU_PERSIST = 3,
    IEC104_QOC_QU_RES4 = 4,
    IEC104_QOC_QU_RES5 = 5,
    IEC104_QOC_QU_RES6 = 6,
    IEC104_QOC_QU_RES7 = 7,
    IEC104_QOC_QU_RES8 = 8,
    IEC104_QOC_QU_RES9 = 9,
    IEC104_QOC_QU_RES10 = 10,
    IEC104_QOC_QU_RES11 = 11,
    IEC104_QOC_QU_RES12 = 12,
    IEC104_QOC_QU_RES13 = 13,
    IEC104_QOC_QU_RES14 = 14,
    IEC104_QOC_QU_RES15 = 15,
    IEC104_QOC_QU_RES16 = 16,
    IEC104_QOC_QU_RES17 = 17,
    IEC104_QOC_QU_RES18 = 18,
    IEC104_QOC_QU_RES19 = 19,
    IEC104_QOC_QU_RES20 = 20,
    IEC104_QOC_QU_RES21 = 21,
    IEC104_QOC_QU_RES22 = 22,
    IEC104_QOC_QU_RES23 = 23,
    IEC104_QOC_QU_RES24 = 24,
    IEC104_QOC_QU_RES25 = 25,
    IEC104_QOC_QU_RES26 = 26,
    IEC104_QOC_QU_RES27 = 27,
    IEC104_QOC_QU_RES28 = 28,
    IEC104_QOC_QU_RES29 = 29,
    IEC104_QOC_QU_RES30 = 30,
    IEC104_QOC_QU_RES31 = 31,
};

enum Iec104QrpEnum
{
    IEC104_QRP_NOTUSED = 0,
    IEC104_QRP_GENRST = 1,
    IEC104_QRP_RSTTIME = 2,
    IEC104_QRP_RES3 = 3,
    IEC104_QRP_RES4 = 4,
    IEC104_QRP_RES5 = 5,
    IEC104_QRP_RES6 = 6,
    IEC104_QRP_RES7 = 7,
    IEC104_QRP_RES8 = 8,
    IEC104_QRP_RES9 = 9,
    IEC104_QRP_RES10 = 10,
    IEC104_QRP_RES11 = 11,
    IEC104_QRP_RES12 = 12,
    IEC104_QRP_RES13 = 13,
    IEC104_QRP_RES14 = 14,
    IEC104_QRP_RES15 = 15,
    IEC104_QRP_RES16 = 16,
    IEC104_QRP_RES17 = 17,
    IEC104_QRP_RES18 = 18,
    IEC104_QRP_RES19 = 19,
    IEC104_QRP_RES20 = 20,
    IEC104_QRP_RES21 = 21,
    IEC104_QRP_RES22 = 22,
    IEC104_QRP_RES23 = 23,
    IEC104_QRP_RES24 = 24,
    IEC104_QRP_RES25 = 25,
    IEC104_QRP_RES26 = 26,
    IEC104_QRP_RES27 = 27,
    IEC104_QRP_RES28 = 28,
    IEC104_QRP_RES29 = 29,
    IEC104_QRP_RES30 = 30,
    IEC104_QRP_RES31 = 31,
    IEC104_QRP_RES32 = 32,
    IEC104_QRP_RES33 = 33,
    IEC104_QRP_RES34 = 34,
    IEC104_QRP_RES35 = 35,
    IEC104_QRP_RES36 = 36,
    IEC104_QRP_RES37 = 37,
    IEC104_QRP_RES38 = 38,
    IEC104_QRP_RES39 = 39,
    IEC104_QRP_RES40 = 40,
    IEC104_QRP_RES41 = 41,
    IEC104_QRP_RES42 = 42,
    IEC104_QRP_RES43 = 43,
    IEC104_QRP_RES44 = 44,
    IEC104_QRP_RES45 = 45,
    IEC104_QRP_RES46 = 46,
    IEC104_QRP_RES47 = 47,
    IEC104_QRP_RES48 = 48,
    IEC104_QRP_RES49 = 49,
    IEC104_QRP_RES50 = 50,
    IEC104_QRP_RES51 = 51,
    IEC104_QRP_RES52 = 52,
    IEC104_QRP_RES53 = 53,
    IEC104_QRP_RES54 = 54,
    IEC104_QRP_RES55 = 55,
    IEC104_QRP_RES56 = 56,
    IEC104_QRP_RES57 = 57,
    IEC104_QRP_RES58 = 58,
    IEC104_QRP_RES59 = 59,
    IEC104_QRP_RES60 = 60,
    IEC104_QRP_RES61 = 61,
    IEC104_QRP_RES62 = 62,
    IEC104_QRP_RES63 = 63,
    IEC104_QRP_RES64 = 64,
    IEC104_QRP_RES65 = 65,
    IEC104_QRP_RES66 = 66,
    IEC104_QRP_RES67 = 67,
    IEC104_QRP_RES68 = 68,
    IEC104_QRP_RES69 = 69,
    IEC104_QRP_RES70 = 70,
    IEC104_QRP_RES71 = 71,
    IEC104_QRP_RES72 = 72,
    IEC104_QRP_RES73 = 73,
    IEC104_QRP_RES74 = 74,
    IEC104_QRP_RES75 = 75,
    IEC104_QRP_RES76 = 76,
    IEC104_QRP_RES77 = 77,
    IEC104_QRP_RES78 = 78,
    IEC104_QRP_RES79 = 79,
    IEC104_QRP_RES80 = 80,
    IEC104_QRP_RES81 = 81,
    IEC104_QRP_RES82 = 82,
    IEC104_QRP_RES83 = 83,
    IEC104_QRP_RES84 = 84,
    IEC104_QRP_RES85 = 85,
    IEC104_QRP_RES86 = 86,
    IEC104_QRP_RES87 = 87,
    IEC104_QRP_RES88 = 88,
    IEC104_QRP_RES89 = 89,
    IEC104_QRP_RES90 = 90,
    IEC104_QRP_RES91 = 91,
    IEC104_QRP_RES92 = 92,
    IEC104_QRP_RES93 = 93,
    IEC104_QRP_RES94 = 94,
    IEC104_QRP_RES95 = 95,
    IEC104_QRP_RES96 = 96,
    IEC104_QRP_RES97 = 97,
    IEC104_QRP_RES98 = 98,
    IEC104_QRP_RES99 = 99,
    IEC104_QRP_RES100 = 100,
    IEC104_QRP_RES101 = 101,
    IEC104_QRP_RES102 = 102,
    IEC104_QRP_RES103 = 103,
    IEC104_QRP_RES104 = 104,
    IEC104_QRP_RES105 = 105,
    IEC104_QRP_RES106 = 106,
    IEC104_QRP_RES107 = 107,
    IEC104_QRP_RES108 = 108,
    IEC104_QRP_RES109 = 109,
    IEC104_QRP_RES110 = 110,
    IEC104_QRP_RES111 = 111,
    IEC104_QRP_RES112 = 112,
    IEC104_QRP_RES113 = 113,
    IEC104_QRP_RES114 = 114,
    IEC104_QRP_RES115 = 115,
    IEC104_QRP_RES116 = 116,
    IEC104_QRP_RES117 = 117,
    IEC104_QRP_RES118 = 118,
    IEC104_QRP_RES119 = 119,
    IEC104_QRP_RES120 = 120,
    IEC104_QRP_RES121 = 121,
    IEC104_QRP_RES122 = 122,
    IEC104_QRP_RES123 = 123,
    IEC104_QRP_RES124 = 124,
    IEC104_QRP_RES125 = 125,
    IEC104_QRP_RES126 = 126,
    IEC104_QRP_RES127 = 127,
    IEC104_QRP_RES128 = 128,
    IEC104_QRP_RES129 = 129,
    IEC104_QRP_RES130 = 130,
    IEC104_QRP_RES131 = 131,
    IEC104_QRP_RES132 = 132,
    IEC104_QRP_RES133 = 133,
    IEC104_QRP_RES134 = 134,
    IEC104_QRP_RES135 = 135,
    IEC104_QRP_RES136 = 136,
    IEC104_QRP_RES137 = 137,
    IEC104_QRP_RES138 = 138,
    IEC104_QRP_RES139 = 139,
    IEC104_QRP_RES140 = 140,
    IEC104_QRP_RES141 = 141,
    IEC104_QRP_RES142 = 142,
    IEC104_QRP_RES143 = 143,
    IEC104_QRP_RES144 = 144,
    IEC104_QRP_RES145 = 145,
    IEC104_QRP_RES146 = 146,
    IEC104_QRP_RES147 = 147,
    IEC104_QRP_RES148 = 148,
    IEC104_QRP_RES149 = 149,
    IEC104_QRP_RES150 = 150,
    IEC104_QRP_RES151 = 151,
    IEC104_QRP_RES152 = 152,
    IEC104_QRP_RES153 = 153,
    IEC104_QRP_RES154 = 154,
    IEC104_QRP_RES155 = 155,
    IEC104_QRP_RES156 = 156,
    IEC104_QRP_RES157 = 157,
    IEC104_QRP_RES158 = 158,
    IEC104_QRP_RES159 = 159,
    IEC104_QRP_RES160 = 160,
    IEC104_QRP_RES161 = 161,
    IEC104_QRP_RES162 = 162,
    IEC104_QRP_RES163 = 163,
    IEC104_QRP_RES164 = 164,
    IEC104_QRP_RES165 = 165,
    IEC104_QRP_RES166 = 166,
    IEC104_QRP_RES167 = 167,
    IEC104_QRP_RES168 = 168,
    IEC104_QRP_RES169 = 169,
    IEC104_QRP_RES170 = 170,
    IEC104_QRP_RES171 = 171,
    IEC104_QRP_RES172 = 172,
    IEC104_QRP_RES173 = 173,
    IEC104_QRP_RES174 = 174,
    IEC104_QRP_RES175 = 175,
    IEC104_QRP_RES176 = 176,
    IEC104_QRP_RES177 = 177,
    IEC104_QRP_RES178 = 178,
    IEC104_QRP_RES179 = 179,
    IEC104_QRP_RES180 = 180,
    IEC104_QRP_RES181 = 181,
    IEC104_QRP_RES182 = 182,
    IEC104_QRP_RES183 = 183,
    IEC104_QRP_RES184 = 184,
    IEC104_QRP_RES185 = 185,
    IEC104_QRP_RES186 = 186,
    IEC104_QRP_RES187 = 187,
    IEC104_QRP_RES188 = 188,
    IEC104_QRP_RES189 = 189,
    IEC104_QRP_RES190 = 190,
    IEC104_QRP_RES191 = 191,
    IEC104_QRP_RES192 = 192,
    IEC104_QRP_RES193 = 193,
    IEC104_QRP_RES194 = 194,
    IEC104_QRP_RES195 = 195,
    IEC104_QRP_RES196 = 196,
    IEC104_QRP_RES197 = 197,
    IEC104_QRP_RES198 = 198,
    IEC104_QRP_RES199 = 199,
    IEC104_QRP_RES200 = 200,
    IEC104_QRP_RES201 = 201,
    IEC104_QRP_RES202 = 202,
    IEC104_QRP_RES203 = 203,
    IEC104_QRP_RES204 = 204,
    IEC104_QRP_RES205 = 205,
    IEC104_QRP_RES206 = 206,
    IEC104_QRP_RES207 = 207,
    IEC104_QRP_RES208 = 208,
    IEC104_QRP_RES209 = 209,
    IEC104_QRP_RES210 = 210,
    IEC104_QRP_RES211 = 211,
    IEC104_QRP_RES212 = 212,
    IEC104_QRP_RES213 = 213,
    IEC104_QRP_RES214 = 214,
    IEC104_QRP_RES215 = 215,
    IEC104_QRP_RES216 = 216,
    IEC104_QRP_RES217 = 217,
    IEC104_QRP_RES218 = 218,
    IEC104_QRP_RES219 = 219,
    IEC104_QRP_RES220 = 220,
    IEC104_QRP_RES221 = 221,
    IEC104_QRP_RES222 = 222,
    IEC104_QRP_RES223 = 223,
    IEC104_QRP_RES224 = 224,
    IEC104_QRP_RES225 = 225,
    IEC104_QRP_RES226 = 226,
    IEC104_QRP_RES227 = 227,
    IEC104_QRP_RES228 = 228,
    IEC104_QRP_RES229 = 229,
    IEC104_QRP_RES230 = 230,
    IEC104_QRP_RES231 = 231,
    IEC104_QRP_RES232 = 232,
    IEC104_QRP_RES233 = 233,
    IEC104_QRP_RES234 = 234,
    IEC104_QRP_RES235 = 235,
    IEC104_QRP_RES236 = 236,
    IEC104_QRP_RES237 = 237,
    IEC104_QRP_RES238 = 238,
    IEC104_QRP_RES239 = 239,
    IEC104_QRP_RES240 = 240,
    IEC104_QRP_RES241 = 241,
    IEC104_QRP_RES242 = 242,
    IEC104_QRP_RES243 = 243,
    IEC104_QRP_RES244 = 244,
    IEC104_QRP_RES245 = 245,
    IEC104_QRP_RES246 = 246,
    IEC104_QRP_RES247 = 247,
    IEC104_QRP_RES248 = 248,
    IEC104_QRP_RES249 = 249,
    IEC104_QRP_RES250 = 250,
    IEC104_QRP_RES251 = 251,
    IEC104_QRP_RES252 = 252,
    IEC104_QRP_RES253 = 253,
    IEC104_QRP_RES254 = 254,
    IEC104_QRP_RES255 = 255,
};

enum Iec104FrqUiEnum
{
    IEC104_FRQ_UI_DEFAULT = 0,
    IEC104_FRQ_UI_RES1 = 1,
    IEC104_FRQ_UI_RES2 = 2,
    IEC104_FRQ_UI_RES3 = 3,
    IEC104_FRQ_UI_RES4 = 4,
    IEC104_FRQ_UI_RES5 = 5,
    IEC104_FRQ_UI_RES6 = 6,
    IEC104_FRQ_UI_RES7 = 7,
    IEC104_FRQ_UI_RES8 = 8,
    IEC104_FRQ_UI_RES9 = 9,
    IEC104_FRQ_UI_RES10 = 10,
    IEC104_FRQ_UI_RES11 = 11,
    IEC104_FRQ_UI_RES12 = 12,
    IEC104_FRQ_UI_RES13 = 13,
    IEC104_FRQ_UI_RES14 = 14,
    IEC104_FRQ_UI_RES15 = 15,
    IEC104_FRQ_UI_RES16 = 16,
    IEC104_FRQ_UI_RES17 = 17,
    IEC104_FRQ_UI_RES18 = 18,
    IEC104_FRQ_UI_RES19 = 19,
    IEC104_FRQ_UI_RES20 = 20,
    IEC104_FRQ_UI_RES21 = 21,
    IEC104_FRQ_UI_RES22 = 22,
    IEC104_FRQ_UI_RES23 = 23,
    IEC104_FRQ_UI_RES24 = 24,
    IEC104_FRQ_UI_RES25 = 25,
    IEC104_FRQ_UI_RES26 = 26,
    IEC104_FRQ_UI_RES27 = 27,
    IEC104_FRQ_UI_RES28 = 28,
    IEC104_FRQ_UI_RES29 = 29,
    IEC104_FRQ_UI_RES30 = 30,
    IEC104_FRQ_UI_RES31 = 31,
    IEC104_FRQ_UI_RES32 = 32,
    IEC104_FRQ_UI_RES33 = 33,
    IEC104_FRQ_UI_RES34 = 34,
    IEC104_FRQ_UI_RES35 = 35,
    IEC104_FRQ_UI_RES36 = 36,
    IEC104_FRQ_UI_RES37 = 37,
    IEC104_FRQ_UI_RES38 = 38,
    IEC104_FRQ_UI_RES39 = 39,
    IEC104_FRQ_UI_RES40 = 40,
    IEC104_FRQ_UI_RES41 = 41,
    IEC104_FRQ_UI_RES42 = 42,
    IEC104_FRQ_UI_RES43 = 43,
    IEC104_FRQ_UI_RES44 = 44,
    IEC104_FRQ_UI_RES45 = 45,
    IEC104_FRQ_UI_RES46 = 46,
    IEC104_FRQ_UI_RES47 = 47,
    IEC104_FRQ_UI_RES48 = 48,
    IEC104_FRQ_UI_RES49 = 49,
    IEC104_FRQ_UI_RES50 = 50,
    IEC104_FRQ_UI_RES51 = 51,
    IEC104_FRQ_UI_RES52 = 52,
    IEC104_FRQ_UI_RES53 = 53,
    IEC104_FRQ_UI_RES54 = 54,
    IEC104_FRQ_UI_RES55 = 55,
    IEC104_FRQ_UI_RES56 = 56,
    IEC104_FRQ_UI_RES57 = 57,
    IEC104_FRQ_UI_RES58 = 58,
    IEC104_FRQ_UI_RES59 = 59,
    IEC104_FRQ_UI_RES60 = 60,
    IEC104_FRQ_UI_RES61 = 61,
    IEC104_FRQ_UI_RES62 = 62,
    IEC104_FRQ_UI_RES63 = 63,
    IEC104_FRQ_UI_RES64 = 64,
    IEC104_FRQ_UI_RES65 = 65,
    IEC104_FRQ_UI_RES66 = 66,
    IEC104_FRQ_UI_RES67 = 67,
    IEC104_FRQ_UI_RES68 = 68,
    IEC104_FRQ_UI_RES69 = 69,
    IEC104_FRQ_UI_RES70 = 70,
    IEC104_FRQ_UI_RES71 = 71,
    IEC104_FRQ_UI_RES72 = 72,
    IEC104_FRQ_UI_RES73 = 73,
    IEC104_FRQ_UI_RES74 = 74,
    IEC104_FRQ_UI_RES75 = 75,
    IEC104_FRQ_UI_RES76 = 76,
    IEC104_FRQ_UI_RES77 = 77,
    IEC104_FRQ_UI_RES78 = 78,
    IEC104_FRQ_UI_RES79 = 79,
    IEC104_FRQ_UI_RES80 = 80,
    IEC104_FRQ_UI_RES81 = 81,
    IEC104_FRQ_UI_RES82 = 82,
    IEC104_FRQ_UI_RES83 = 83,
    IEC104_FRQ_UI_RES84 = 84,
    IEC104_FRQ_UI_RES85 = 85,
    IEC104_FRQ_UI_RES86 = 86,
    IEC104_FRQ_UI_RES87 = 87,
    IEC104_FRQ_UI_RES88 = 88,
    IEC104_FRQ_UI_RES89 = 89,
    IEC104_FRQ_UI_RES90 = 90,
    IEC104_FRQ_UI_RES91 = 91,
    IEC104_FRQ_UI_RES92 = 92,
    IEC104_FRQ_UI_RES93 = 93,
    IEC104_FRQ_UI_RES94 = 94,
    IEC104_FRQ_UI_RES95 = 95,
    IEC104_FRQ_UI_RES96 = 96,
    IEC104_FRQ_UI_RES97 = 97,
    IEC104_FRQ_UI_RES98 = 98,
    IEC104_FRQ_UI_RES99 = 99,
    IEC104_FRQ_UI_RES100 = 100,
    IEC104_FRQ_UI_RES101 = 101,
    IEC104_FRQ_UI_RES102 = 102,
    IEC104_FRQ_UI_RES103 = 103,
    IEC104_FRQ_UI_RES104 = 104,
    IEC104_FRQ_UI_RES105 = 105,
    IEC104_FRQ_UI_RES106 = 106,
    IEC104_FRQ_UI_RES107 = 107,
    IEC104_FRQ_UI_RES108 = 108,
    IEC104_FRQ_UI_RES109 = 109,
    IEC104_FRQ_UI_RES110 = 110,
    IEC104_FRQ_UI_RES111 = 111,
    IEC104_FRQ_UI_RES112 = 112,
    IEC104_FRQ_UI_RES113 = 113,
    IEC104_FRQ_UI_RES114 = 114,
    IEC104_FRQ_UI_RES115 = 115,
    IEC104_FRQ_UI_RES116 = 116,
    IEC104_FRQ_UI_RES117 = 117,
    IEC104_FRQ_UI_RES118 = 118,
    IEC104_FRQ_UI_RES119 = 119,
    IEC104_FRQ_UI_RES120 = 120,
    IEC104_FRQ_UI_RES121 = 121,
    IEC104_FRQ_UI_RES122 = 122,
    IEC104_FRQ_UI_RES123 = 123,
    IEC104_FRQ_UI_RES124 = 124,
    IEC104_FRQ_UI_RES125 = 125,
    IEC104_FRQ_UI_RES126 = 126,
    IEC104_FRQ_UI_RES127 = 127,
};

enum Iec104SrqUiEnum
{
    IEC104_SRQ_UI_DEFAULT = 0,
    IEC104_SRQ_UI_RES1 = 1,
    IEC104_SRQ_UI_RES2 = 2,
    IEC104_SRQ_UI_RES3 = 3,
    IEC104_SRQ_UI_RES4 = 4,
    IEC104_SRQ_UI_RES5 = 5,
    IEC104_SRQ_UI_RES6 = 6,
    IEC104_SRQ_UI_RES7 = 7,
    IEC104_SRQ_UI_RES8 = 8,
    IEC104_SRQ_UI_RES9 = 9,
    IEC104_SRQ_UI_RES10 = 10,
    IEC104_SRQ_UI_RES11 = 11,
    IEC104_SRQ_UI_RES12 = 12,
    IEC104_SRQ_UI_RES13 = 13,
    IEC104_SRQ_UI_RES14 = 14,
    IEC104_SRQ_UI_RES15 = 15,
    IEC104_SRQ_UI_RES16 = 16,
    IEC104_SRQ_UI_RES17 = 17,
    IEC104_SRQ_UI_RES18 = 18,
    IEC104_SRQ_UI_RES19 = 19,
    IEC104_SRQ_UI_RES20 = 20,
    IEC104_SRQ_UI_RES21 = 21,
    IEC104_SRQ_UI_RES22 = 22,
    IEC104_SRQ_UI_RES23 = 23,
    IEC104_SRQ_UI_RES24 = 24,
    IEC104_SRQ_UI_RES25 = 25,
    IEC104_SRQ_UI_RES26 = 26,
    IEC104_SRQ_UI_RES27 = 27,
    IEC104_SRQ_UI_RES28 = 28,
    IEC104_SRQ_UI_RES29 = 29,
    IEC104_SRQ_UI_RES30 = 30,
    IEC104_SRQ_UI_RES31 = 31,
    IEC104_SRQ_UI_RES32 = 32,
    IEC104_SRQ_UI_RES33 = 33,
    IEC104_SRQ_UI_RES34 = 34,
    IEC104_SRQ_UI_RES35 = 35,
    IEC104_SRQ_UI_RES36 = 36,
    IEC104_SRQ_UI_RES37 = 37,
    IEC104_SRQ_UI_RES38 = 38,
    IEC104_SRQ_UI_RES39 = 39,
    IEC104_SRQ_UI_RES40 = 40,
    IEC104_SRQ_UI_RES41 = 41,
    IEC104_SRQ_UI_RES42 = 42,
    IEC104_SRQ_UI_RES43 = 43,
    IEC104_SRQ_UI_RES44 = 44,
    IEC104_SRQ_UI_RES45 = 45,
    IEC104_SRQ_UI_RES46 = 46,
    IEC104_SRQ_UI_RES47 = 47,
    IEC104_SRQ_UI_RES48 = 48,
    IEC104_SRQ_UI_RES49 = 49,
    IEC104_SRQ_UI_RES50 = 50,
    IEC104_SRQ_UI_RES51 = 51,
    IEC104_SRQ_UI_RES52 = 52,
    IEC104_SRQ_UI_RES53 = 53,
    IEC104_SRQ_UI_RES54 = 54,
    IEC104_SRQ_UI_RES55 = 55,
    IEC104_SRQ_UI_RES56 = 56,
    IEC104_SRQ_UI_RES57 = 57,
    IEC104_SRQ_UI_RES58 = 58,
    IEC104_SRQ_UI_RES59 = 59,
    IEC104_SRQ_UI_RES60 = 60,
    IEC104_SRQ_UI_RES61 = 61,
    IEC104_SRQ_UI_RES62 = 62,
    IEC104_SRQ_UI_RES63 = 63,
    IEC104_SRQ_UI_RES64 = 64,
    IEC104_SRQ_UI_RES65 = 65,
    IEC104_SRQ_UI_RES66 = 66,
    IEC104_SRQ_UI_RES67 = 67,
    IEC104_SRQ_UI_RES68 = 68,
    IEC104_SRQ_UI_RES69 = 69,
    IEC104_SRQ_UI_RES70 = 70,
    IEC104_SRQ_UI_RES71 = 71,
    IEC104_SRQ_UI_RES72 = 72,
    IEC104_SRQ_UI_RES73 = 73,
    IEC104_SRQ_UI_RES74 = 74,
    IEC104_SRQ_UI_RES75 = 75,
    IEC104_SRQ_UI_RES76 = 76,
    IEC104_SRQ_UI_RES77 = 77,
    IEC104_SRQ_UI_RES78 = 78,
    IEC104_SRQ_UI_RES79 = 79,
    IEC104_SRQ_UI_RES80 = 80,
    IEC104_SRQ_UI_RES81 = 81,
    IEC104_SRQ_UI_RES82 = 82,
    IEC104_SRQ_UI_RES83 = 83,
    IEC104_SRQ_UI_RES84 = 84,
    IEC104_SRQ_UI_RES85 = 85,
    IEC104_SRQ_UI_RES86 = 86,
    IEC104_SRQ_UI_RES87 = 87,
    IEC104_SRQ_UI_RES88 = 88,
    IEC104_SRQ_UI_RES89 = 89,
    IEC104_SRQ_UI_RES90 = 90,
    IEC104_SRQ_UI_RES91 = 91,
    IEC104_SRQ_UI_RES92 = 92,
    IEC104_SRQ_UI_RES93 = 93,
    IEC104_SRQ_UI_RES94 = 94,
    IEC104_SRQ_UI_RES95 = 95,
    IEC104_SRQ_UI_RES96 = 96,
    IEC104_SRQ_UI_RES97 = 97,
    IEC104_SRQ_UI_RES98 = 98,
    IEC104_SRQ_UI_RES99 = 99,
    IEC104_SRQ_UI_RES100 = 100,
    IEC104_SRQ_UI_RES101 = 101,
    IEC104_SRQ_UI_RES102 = 102,
    IEC104_SRQ_UI_RES103 = 103,
    IEC104_SRQ_UI_RES104 = 104,
    IEC104_SRQ_UI_RES105 = 105,
    IEC104_SRQ_UI_RES106 = 106,
    IEC104_SRQ_UI_RES107 = 107,
    IEC104_SRQ_UI_RES108 = 108,
    IEC104_SRQ_UI_RES109 = 109,
    IEC104_SRQ_UI_RES110 = 110,
    IEC104_SRQ_UI_RES111 = 111,
    IEC104_SRQ_UI_RES112 = 112,
    IEC104_SRQ_UI_RES113 = 113,
    IEC104_SRQ_UI_RES114 = 114,
    IEC104_SRQ_UI_RES115 = 115,
    IEC104_SRQ_UI_RES116 = 116,
    IEC104_SRQ_UI_RES117 = 117,
    IEC104_SRQ_UI_RES118 = 118,
    IEC104_SRQ_UI_RES119 = 119,
    IEC104_SRQ_UI_RES120 = 120,
    IEC104_SRQ_UI_RES121 = 121,
    IEC104_SRQ_UI_RES122 = 122,
    IEC104_SRQ_UI_RES123 = 123,
    IEC104_SRQ_UI_RES124 = 124,
    IEC104_SRQ_UI_RES125 = 125,
    IEC104_SRQ_UI_RES126 = 126,
    IEC104_SRQ_UI_RES127 = 127,
};

enum Iec104ScqUi1Enum
{
    IEC104_SCQ_UI1_DEFAULT = 0,
    IEC104_SCQ_UI1_SELECTFILE = 1,
    IEC104_SCQ_UI1_REQUESTFILE = 2,
    IEC104_SCQ_UI1_DEACTFILE = 3,
    IEC104_SCQ_UI1_DELETEFILE = 4,
    IEC104_SCQ_UI1_SELECTSECTION = 5,
    IEC104_SCQ_UI1_REQUESTSECTION = 6,
    IEC104_SCQ_UI1_DEACTSECTION = 7,
    IEC104_SCQ_UI1_RES8 = 8,
    IEC104_SCQ_UI1_RES9 = 9,
    IEC104_SCQ_UI1_RES10 = 10,
    IEC104_SCQ_UI1_RES11 = 11,
    IEC104_SCQ_UI1_RES12 = 12,
    IEC104_SCQ_UI1_RES13 = 13,
    IEC104_SCQ_UI1_RES14 = 14,
    IEC104_SCQ_UI1_RES15 = 15,
};

enum Iec104ScqUi2Enum
{
    IEC104_SCQ_UI2_DEFAULT = 0,
    IEC104_SCQ_UI2_MEMUNAVAIL = 1,
    IEC104_SCQ_UI2_CHKSMFAILED = 2,
    IEC104_SCQ_UI2_UNEXPECTEDCOMM = 3,
    IEC104_SCQ_UI2_UNEXPECTEDNOF = 4,
    IEC104_SCQ_UI2_UNEXPECTEDNOS = 5,
    IEC104_SCQ_UI2_RES6 = 6,
    IEC104_SCQ_UI2_RES7 = 7,
    IEC104_SCQ_UI2_RES8 = 8,
    IEC104_SCQ_UI2_RES9 = 9,
    IEC104_SCQ_UI2_RES10 = 10,
    IEC104_SCQ_UI2_RES11 = 11,
    IEC104_SCQ_UI2_RES12 = 12,
    IEC104_SCQ_UI2_RES13 = 13,
    IEC104_SCQ_UI2_RES14 = 14,
    IEC104_SCQ_UI2_RES15 = 15,
};

enum Iec104LsqEnum
{
    IEC104_LSQ_NOTUSED = 0,
    IEC104_LSQ_FILETRANSFERWITHOUTDEACT = 1,
    IEC104_LSQ_FILETRANSFERWITHDEACT = 2,
    IEC104_LSQ_SECTIONTRANSFERWITHOUTDEACT = 3,
    IEC104_LSQ_SECTIONTRANSFERWITHDEACT = 4,
    IEC104_LSQ_RES5 = 5,
    IEC104_LSQ_RES6 = 6,
    IEC104_LSQ_RES7 = 7,
    IEC104_LSQ_RES8 = 8,
    IEC104_LSQ_RES9 = 9,
    IEC104_LSQ_RES10 = 10,
    IEC104_LSQ_RES11 = 11,
    IEC104_LSQ_RES12 = 12,
    IEC104_LSQ_RES13 = 13,
    IEC104_LSQ_RES14 = 14,
    IEC104_LSQ_RES15 = 15,
    IEC104_LSQ_RES16 = 16,
    IEC104_LSQ_RES17 = 17,
    IEC104_LSQ_RES18 = 18,
    IEC104_LSQ_RES19 = 19,
    IEC104_LSQ_RES20 = 20,
    IEC104_LSQ_RES21 = 21,
    IEC104_LSQ_RES22 = 22,
    IEC104_LSQ_RES23 = 23,
    IEC104_LSQ_RES24 = 24,
    IEC104_LSQ_RES25 = 25,
    IEC104_LSQ_RES26 = 26,
    IEC104_LSQ_RES27 = 27,
    IEC104_LSQ_RES28 = 28,
    IEC104_LSQ_RES29 = 29,
    IEC104_LSQ_RES30 = 30,
    IEC104_LSQ_RES31 = 31,
    IEC104_LSQ_RES32 = 32,
    IEC104_LSQ_RES33 = 33,
    IEC104_LSQ_RES34 = 34,
    IEC104_LSQ_RES35 = 35,
    IEC104_LSQ_RES36 = 36,
    IEC104_LSQ_RES37 = 37,
    IEC104_LSQ_RES38 = 38,
    IEC104_LSQ_RES39 = 39,
    IEC104_LSQ_RES40 = 40,
    IEC104_LSQ_RES41 = 41,
    IEC104_LSQ_RES42 = 42,
    IEC104_LSQ_RES43 = 43,
    IEC104_LSQ_RES44 = 44,
    IEC104_LSQ_RES45 = 45,
    IEC104_LSQ_RES46 = 46,
    IEC104_LSQ_RES47 = 47,
    IEC104_LSQ_RES48 = 48,
    IEC104_LSQ_RES49 = 49,
    IEC104_LSQ_RES50 = 50,
    IEC104_LSQ_RES51 = 51,
    IEC104_LSQ_RES52 = 52,
    IEC104_LSQ_RES53 = 53,
    IEC104_LSQ_RES54 = 54,
    IEC104_LSQ_RES55 = 55,
    IEC104_LSQ_RES56 = 56,
    IEC104_LSQ_RES57 = 57,
    IEC104_LSQ_RES58 = 58,
    IEC104_LSQ_RES59 = 59,
    IEC104_LSQ_RES60 = 60,
    IEC104_LSQ_RES61 = 61,
    IEC104_LSQ_RES62 = 62,
    IEC104_LSQ_RES63 = 63,
    IEC104_LSQ_RES64 = 64,
    IEC104_LSQ_RES65 = 65,
    IEC104_LSQ_RES66 = 66,
    IEC104_LSQ_RES67 = 67,
    IEC104_LSQ_RES68 = 68,
    IEC104_LSQ_RES69 = 69,
    IEC104_LSQ_RES70 = 70,
    IEC104_LSQ_RES71 = 71,
    IEC104_LSQ_RES72 = 72,
    IEC104_LSQ_RES73 = 73,
    IEC104_LSQ_RES74 = 74,
    IEC104_LSQ_RES75 = 75,
    IEC104_LSQ_RES76 = 76,
    IEC104_LSQ_RES77 = 77,
    IEC104_LSQ_RES78 = 78,
    IEC104_LSQ_RES79 = 79,
    IEC104_LSQ_RES80 = 80,
    IEC104_LSQ_RES81 = 81,
    IEC104_LSQ_RES82 = 82,
    IEC104_LSQ_RES83 = 83,
    IEC104_LSQ_RES84 = 84,
    IEC104_LSQ_RES85 = 85,
    IEC104_LSQ_RES86 = 86,
    IEC104_LSQ_RES87 = 87,
    IEC104_LSQ_RES88 = 88,
    IEC104_LSQ_RES89 = 89,
    IEC104_LSQ_RES90 = 90,
    IEC104_LSQ_RES91 = 91,
    IEC104_LSQ_RES92 = 92,
    IEC104_LSQ_RES93 = 93,
    IEC104_LSQ_RES94 = 94,
    IEC104_LSQ_RES95 = 95,
    IEC104_LSQ_RES96 = 96,
    IEC104_LSQ_RES97 = 97,
    IEC104_LSQ_RES98 = 98,
    IEC104_LSQ_RES99 = 99,
    IEC104_LSQ_RES100 = 100,
    IEC104_LSQ_RES101 = 101,
    IEC104_LSQ_RES102 = 102,
    IEC104_LSQ_RES103 = 103,
    IEC104_LSQ_RES104 = 104,
    IEC104_LSQ_RES105 = 105,
    IEC104_LSQ_RES106 = 106,
    IEC104_LSQ_RES107 = 107,
    IEC104_LSQ_RES108 = 108,
    IEC104_LSQ_RES109 = 109,
    IEC104_LSQ_RES110 = 110,
    IEC104_LSQ_RES111 = 111,
    IEC104_LSQ_RES112 = 112,
    IEC104_LSQ_RES113 = 113,
    IEC104_LSQ_RES114 = 114,
    IEC104_LSQ_RES115 = 115,
    IEC104_LSQ_RES116 = 116,
    IEC104_LSQ_RES117 = 117,
    IEC104_LSQ_RES118 = 118,
    IEC104_LSQ_RES119 = 119,
    IEC104_LSQ_RES120 = 120,
    IEC104_LSQ_RES121 = 121,
    IEC104_LSQ_RES122 = 122,
    IEC104_LSQ_RES123 = 123,
    IEC104_LSQ_RES124 = 124,
    IEC104_LSQ_RES125 = 125,
    IEC104_LSQ_RES126 = 126,
    IEC104_LSQ_RES127 = 127,
    IEC104_LSQ_RES128 = 128,
    IEC104_LSQ_RES129 = 129,
    IEC104_LSQ_RES130 = 130,
    IEC104_LSQ_RES131 = 131,
    IEC104_LSQ_RES132 = 132,
    IEC104_LSQ_RES133 = 133,
    IEC104_LSQ_RES134 = 134,
    IEC104_LSQ_RES135 = 135,
    IEC104_LSQ_RES136 = 136,
    IEC104_LSQ_RES137 = 137,
    IEC104_LSQ_RES138 = 138,
    IEC104_LSQ_RES139 = 139,
    IEC104_LSQ_RES140 = 140,
    IEC104_LSQ_RES141 = 141,
    IEC104_LSQ_RES142 = 142,
    IEC104_LSQ_RES143 = 143,
    IEC104_LSQ_RES144 = 144,
    IEC104_LSQ_RES145 = 145,
    IEC104_LSQ_RES146 = 146,
    IEC104_LSQ_RES147 = 147,
    IEC104_LSQ_RES148 = 148,
    IEC104_LSQ_RES149 = 149,
    IEC104_LSQ_RES150 = 150,
    IEC104_LSQ_RES151 = 151,
    IEC104_LSQ_RES152 = 152,
    IEC104_LSQ_RES153 = 153,
    IEC104_LSQ_RES154 = 154,
    IEC104_LSQ_RES155 = 155,
    IEC104_LSQ_RES156 = 156,
    IEC104_LSQ_RES157 = 157,
    IEC104_LSQ_RES158 = 158,
    IEC104_LSQ_RES159 = 159,
    IEC104_LSQ_RES160 = 160,
    IEC104_LSQ_RES161 = 161,
    IEC104_LSQ_RES162 = 162,
    IEC104_LSQ_RES163 = 163,
    IEC104_LSQ_RES164 = 164,
    IEC104_LSQ_RES165 = 165,
    IEC104_LSQ_RES166 = 166,
    IEC104_LSQ_RES167 = 167,
    IEC104_LSQ_RES168 = 168,
    IEC104_LSQ_RES169 = 169,
    IEC104_LSQ_RES170 = 170,
    IEC104_LSQ_RES171 = 171,
    IEC104_LSQ_RES172 = 172,
    IEC104_LSQ_RES173 = 173,
    IEC104_LSQ_RES174 = 174,
    IEC104_LSQ_RES175 = 175,
    IEC104_LSQ_RES176 = 176,
    IEC104_LSQ_RES177 = 177,
    IEC104_LSQ_RES178 = 178,
    IEC104_LSQ_RES179 = 179,
    IEC104_LSQ_RES180 = 180,
    IEC104_LSQ_RES181 = 181,
    IEC104_LSQ_RES182 = 182,
    IEC104_LSQ_RES183 = 183,
    IEC104_LSQ_RES184 = 184,
    IEC104_LSQ_RES185 = 185,
    IEC104_LSQ_RES186 = 186,
    IEC104_LSQ_RES187 = 187,
    IEC104_LSQ_RES188 = 188,
    IEC104_LSQ_RES189 = 189,
    IEC104_LSQ_RES190 = 190,
    IEC104_LSQ_RES191 = 191,
    IEC104_LSQ_RES192 = 192,
    IEC104_LSQ_RES193 = 193,
    IEC104_LSQ_RES194 = 194,
    IEC104_LSQ_RES195 = 195,
    IEC104_LSQ_RES196 = 196,
    IEC104_LSQ_RES197 = 197,
    IEC104_LSQ_RES198 = 198,
    IEC104_LSQ_RES199 = 199,
    IEC104_LSQ_RES200 = 200,
    IEC104_LSQ_RES201 = 201,
    IEC104_LSQ_RES202 = 202,
    IEC104_LSQ_RES203 = 203,
    IEC104_LSQ_RES204 = 204,
    IEC104_LSQ_RES205 = 205,
    IEC104_LSQ_RES206 = 206,
    IEC104_LSQ_RES207 = 207,
    IEC104_LSQ_RES208 = 208,
    IEC104_LSQ_RES209 = 209,
    IEC104_LSQ_RES210 = 210,
    IEC104_LSQ_RES211 = 211,
    IEC104_LSQ_RES212 = 212,
    IEC104_LSQ_RES213 = 213,
    IEC104_LSQ_RES214 = 214,
    IEC104_LSQ_RES215 = 215,
    IEC104_LSQ_RES216 = 216,
    IEC104_LSQ_RES217 = 217,
    IEC104_LSQ_RES218 = 218,
    IEC104_LSQ_RES219 = 219,
    IEC104_LSQ_RES220 = 220,
    IEC104_LSQ_RES221 = 221,
    IEC104_LSQ_RES222 = 222,
    IEC104_LSQ_RES223 = 223,
    IEC104_LSQ_RES224 = 224,
    IEC104_LSQ_RES225 = 225,
    IEC104_LSQ_RES226 = 226,
    IEC104_LSQ_RES227 = 227,
    IEC104_LSQ_RES228 = 228,
    IEC104_LSQ_RES229 = 229,
    IEC104_LSQ_RES230 = 230,
    IEC104_LSQ_RES231 = 231,
    IEC104_LSQ_RES232 = 232,
    IEC104_LSQ_RES233 = 233,
    IEC104_LSQ_RES234 = 234,
    IEC104_LSQ_RES235 = 235,
    IEC104_LSQ_RES236 = 236,
    IEC104_LSQ_RES237 = 237,
    IEC104_LSQ_RES238 = 238,
    IEC104_LSQ_RES239 = 239,
    IEC104_LSQ_RES240 = 240,
    IEC104_LSQ_RES241 = 241,
    IEC104_LSQ_RES242 = 242,
    IEC104_LSQ_RES243 = 243,
    IEC104_LSQ_RES244 = 244,
    IEC104_LSQ_RES245 = 245,
    IEC104_LSQ_RES246 = 246,
    IEC104_LSQ_RES247 = 247,
    IEC104_LSQ_RES248 = 248,
    IEC104_LSQ_RES249 = 249,
    IEC104_LSQ_RES250 = 250,
    IEC104_LSQ_RES251 = 251,
    IEC104_LSQ_RES252 = 252,
    IEC104_LSQ_RES253 = 253,
    IEC104_LSQ_RES254 = 254,
    IEC104_LSQ_RES255 = 255,
};

enum Iec104AfqUi1Enum
{
    IEC104_AFQ_UI1_NOTUSED = 0,
    IEC104_AFQ_UI1_POSFILEACK = 1,
    IEC104_AFQ_UI1_NEGFILEACK = 2,
    IEC104_AFQ_UI1_POSSECTIONACK = 3,
    IEC104_AFQ_UI1_NEGSECTIONACK = 4,
    IEC104_AFQ_UI1_RES5 = 5,
    IEC104_AFQ_UI1_RES6 = 6,
    IEC104_AFQ_UI1_RES7 = 7,
    IEC104_AFQ_UI1_RES8 = 8,
    IEC104_AFQ_UI1_RES9 = 9,
    IEC104_AFQ_UI1_RES10 = 10,
    IEC104_AFQ_UI1_RES11 = 11,
    IEC104_AFQ_UI1_RES12 = 12,
    IEC104_AFQ_UI1_RES13 = 13,
    IEC104_AFQ_UI1_RES14 = 14,
    IEC104_AFQ_UI1_RES15 = 15,
};

enum Iec104AfqUi2Enum
{
    IEC104_AFQ_UI2_DEFAULT = 0,
    IEC104_AFQ_UI2_MEMUNAVAIL = 1,
    IEC104_AFQ_UI2_CHKSMFAILED = 2,
    IEC104_AFQ_UI2_UNEXPECTEDCOMM = 3,
    IEC104_AFQ_UI2_UNEXPECTEDNOF = 4,
    IEC104_AFQ_UI2_UNEXPECTEDNOS = 5,
    IEC104_AFQ_UI2_RES6 = 6,
    IEC104_AFQ_UI2_RES7 = 7,
    IEC104_AFQ_UI2_RES8 = 8,
    IEC104_AFQ_UI2_RES9 = 9,
    IEC104_AFQ_UI2_RES10 = 10,
    IEC104_AFQ_UI2_RES11 = 11,
    IEC104_AFQ_UI2_RES12 = 12,
    IEC104_AFQ_UI2_RES13 = 13,
    IEC104_AFQ_UI2_RES14 = 14,
    IEC104_AFQ_UI2_RES15 = 15,
};

enum Iec104DiqDpiEnum
{
    IEC104_DIQ_DPI_INDETERMSTATE1 = 0,
    IEC104_DIQ_DPI_STATEOFF = 1,
    IEC104_DIQ_DPI_STATEON = 2,
    IEC104_DIQ_DPI_INDETERMSTATE2 = 3,
};

enum Iec104SepEsEnum
{
    IEC104_SEP_ES_INDETERMSTATE1 = 0,
    IEC104_SEP_ES_STATEOFF = 1,
    IEC104_SEP_ES_STATEON = 2,
    IEC104_SEP_ES_INDETERMSTATE2 = 3,
};

enum Iec104DcoDcsEnum
{
    IEC104_DCO_DCS_NOTPERMITTED1 = 0,
    IEC104_DCO_DCS_STATEOFF = 1,
    IEC104_DCO_DCS_STATEON = 2,
    IEC104_DCO_DCS_NOTPERMITTED2 = 3,
};

enum Iec104RcoRcsEnum
{
    IEC104_RCO_RCS_NOTPERMITTED1 = 0,
    IEC104_RCO_RCS_STEPLOWER = 1,
    IEC104_RCO_RCS_STEPHIGHER = 2,
    IEC104_RCO_RCS_NOTPERMITTED2 = 3,
};

enum Iec104SofStatusEnum
{
    IEC104_SOF_STATUS_DEFAULT = 0,
    IEC104_SOF_STATUS_RES1 = 1,
    IEC104_SOF_STATUS_RES2 = 2,
    IEC104_SOF_STATUS_RES3 = 3,
    IEC104_SOF_STATUS_RES4 = 4,
    IEC104_SOF_STATUS_RES5 = 5,
    IEC104_SOF_STATUS_RES6 = 6,
    IEC104_SOF_STATUS_RES7 = 7,
    IEC104_SOF_STATUS_RES8 = 8,
    IEC104_SOF_STATUS_RES9 = 9,
    IEC104_SOF_STATUS_RES10 = 10,
    IEC104_SOF_STATUS_RES11 = 11,
    IEC104_SOF_STATUS_RES12 = 12,
    IEC104_SOF_STATUS_RES13 = 13,
    IEC104_SOF_STATUS_RES14 = 14,
    IEC104_SOF_STATUS_RES15 = 15,
    IEC104_SOF_STATUS_RES16 = 16,
    IEC104_SOF_STATUS_RES17 = 17,
    IEC104_SOF_STATUS_RES18 = 18,
    IEC104_SOF_STATUS_RES19 = 19,
    IEC104_SOF_STATUS_RES20 = 20,
    IEC104_SOF_STATUS_RES21 = 21,
    IEC104_SOF_STATUS_RES22 = 22,
    IEC104_SOF_STATUS_RES23 = 23,
    IEC104_SOF_STATUS_RES24 = 24,
    IEC104_SOF_STATUS_RES25 = 25,
    IEC104_SOF_STATUS_RES26 = 26,
    IEC104_SOF_STATUS_RES27 = 27,
    IEC104_SOF_STATUS_RES28 = 28,
    IEC104_SOF_STATUS_RES29 = 29,
    IEC104_SOF_STATUS_RES30 = 30,
    IEC104_SOF_STATUS_RES31 = 31,
};

enum Iec104QosQlEnum
{
    IEC104_QOS_QL_DEFAULT = 0,
    IEC104_QOS_QL_RES1 = 1,
    IEC104_QOS_QL_RES2 = 2,
    IEC104_QOS_QL_RES3 = 3,
    IEC104_QOS_QL_RES4 = 4,
    IEC104_QOS_QL_RES5 = 5,
    IEC104_QOS_QL_RES6 = 6,
    IEC104_QOS_QL_RES7 = 7,
    IEC104_QOS_QL_RES8 = 8,
    IEC104_QOS_QL_RES9 = 9,
    IEC104_QOS_QL_RES10 = 10,
    IEC104_QOS_QL_RES11 = 11,
    IEC104_QOS_QL_RES12 = 12,
    IEC104_QOS_QL_RES13 = 13,
    IEC104_QOS_QL_RES14 = 14,
    IEC104_QOS_QL_RES15 = 15,
    IEC104_QOS_QL_RES16 = 16,
    IEC104_QOS_QL_RES17 = 17,
    IEC104_QOS_QL_RES18 = 18,
    IEC104_QOS_QL_RES19 = 19,
    IEC104_QOS_QL_RES20 = 20,
    IEC104_QOS_QL_RES21 = 21,
    IEC104_QOS_QL_RES22 = 22,
    IEC104_QOS_QL_RES23 = 23,
    IEC104_QOS_QL_RES24 = 24,
    IEC104_QOS_QL_RES25 = 25,
    IEC104_QOS_QL_RES26 = 26,
    IEC104_QOS_QL_RES27 = 27,
    IEC104_QOS_QL_RES28 = 28,
    IEC104_QOS_QL_RES29 = 29,
    IEC104_QOS_QL_RES30 = 30,
    IEC104_QOS_QL_RES31 = 31,
    IEC104_QOS_QL_RES32 = 32,
    IEC104_QOS_QL_RES33 = 33,
    IEC104_QOS_QL_RES34 = 34,
    IEC104_QOS_QL_RES35 = 35,
    IEC104_QOS_QL_RES36 = 36,
    IEC104_QOS_QL_RES37 = 37,
    IEC104_QOS_QL_RES38 = 38,
    IEC104_QOS_QL_RES39 = 39,
    IEC104_QOS_QL_RES40 = 40,
    IEC104_QOS_QL_RES41 = 41,
    IEC104_QOS_QL_RES42 = 42,
    IEC104_QOS_QL_RES43 = 43,
    IEC104_QOS_QL_RES44 = 44,
    IEC104_QOS_QL_RES45 = 45,
    IEC104_QOS_QL_RES46 = 46,
    IEC104_QOS_QL_RES47 = 47,
    IEC104_QOS_QL_RES48 = 48,
    IEC104_QOS_QL_RES49 = 49,
    IEC104_QOS_QL_RES50 = 50,
    IEC104_QOS_QL_RES51 = 51,
    IEC104_QOS_QL_RES52 = 52,
    IEC104_QOS_QL_RES53 = 53,
    IEC104_QOS_QL_RES54 = 54,
    IEC104_QOS_QL_RES55 = 55,
    IEC104_QOS_QL_RES56 = 56,
    IEC104_QOS_QL_RES57 = 57,
    IEC104_QOS_QL_RES58 = 58,
    IEC104_QOS_QL_RES59 = 59,
    IEC104_QOS_QL_RES60 = 60,
    IEC104_QOS_QL_RES61 = 61,
    IEC104_QOS_QL_RES62 = 62,
    IEC104_QOS_QL_RES63 = 63,
    IEC104_QOS_QL_RES64 = 64,
    IEC104_QOS_QL_RES65 = 65,
    IEC104_QOS_QL_RES66 = 66,
    IEC104_QOS_QL_RES67 = 67,
    IEC104_QOS_QL_RES68 = 68,
    IEC104_QOS_QL_RES69 = 69,
    IEC104_QOS_QL_RES70 = 70,
    IEC104_QOS_QL_RES71 = 71,
    IEC104_QOS_QL_RES72 = 72,
    IEC104_QOS_QL_RES73 = 73,
    IEC104_QOS_QL_RES74 = 74,
    IEC104_QOS_QL_RES75 = 75,
    IEC104_QOS_QL_RES76 = 76,
    IEC104_QOS_QL_RES77 = 77,
    IEC104_QOS_QL_RES78 = 78,
    IEC104_QOS_QL_RES79 = 79,
    IEC104_QOS_QL_RES80 = 80,
    IEC104_QOS_QL_RES81 = 81,
    IEC104_QOS_QL_RES82 = 82,
    IEC104_QOS_QL_RES83 = 83,
    IEC104_QOS_QL_RES84 = 84,
    IEC104_QOS_QL_RES85 = 85,
    IEC104_QOS_QL_RES86 = 86,
    IEC104_QOS_QL_RES87 = 87,
    IEC104_QOS_QL_RES88 = 88,
    IEC104_QOS_QL_RES89 = 89,
    IEC104_QOS_QL_RES90 = 90,
    IEC104_QOS_QL_RES91 = 91,
    IEC104_QOS_QL_RES92 = 92,
    IEC104_QOS_QL_RES93 = 93,
    IEC104_QOS_QL_RES94 = 94,
    IEC104_QOS_QL_RES95 = 95,
    IEC104_QOS_QL_RES96 = 96,
    IEC104_QOS_QL_RES97 = 97,
    IEC104_QOS_QL_RES98 = 98,
    IEC104_QOS_QL_RES99 = 99,
    IEC104_QOS_QL_RES100 = 100,
    IEC104_QOS_QL_RES101 = 101,
    IEC104_QOS_QL_RES102 = 102,
    IEC104_QOS_QL_RES103 = 103,
    IEC104_QOS_QL_RES104 = 104,
    IEC104_QOS_QL_RES105 = 105,
    IEC104_QOS_QL_RES106 = 106,
    IEC104_QOS_QL_RES107 = 107,
    IEC104_QOS_QL_RES108 = 108,
    IEC104_QOS_QL_RES109 = 109,
    IEC104_QOS_QL_RES110 = 110,
    IEC104_QOS_QL_RES111 = 111,
    IEC104_QOS_QL_RES112 = 112,
    IEC104_QOS_QL_RES113 = 113,
    IEC104_QOS_QL_RES114 = 114,
    IEC104_QOS_QL_RES115 = 115,
    IEC104_QOS_QL_RES116 = 116,
    IEC104_QOS_QL_RES117 = 117,
    IEC104_QOS_QL_RES118 = 118,
    IEC104_QOS_QL_RES119 = 119,
    IEC104_QOS_QL_RES120 = 120,
    IEC104_QOS_QL_RES121 = 121,
    IEC104_QOS_QL_RES122 = 122,
    IEC104_QOS_QL_RES123 = 123,
    IEC104_QOS_QL_RES124 = 124,
    IEC104_QOS_QL_RES125 = 125,
    IEC104_QOS_QL_RES126 = 126,
    IEC104_QOS_QL_RES127 = 127,
};

#endif

