#!/bin/bash
# Script to run spamprobe on input files generated by splitmail.rb and
# summarize the results.

DBDIR=$HOME/s3test

SPEXEC=./spamprobe

(
for h in min-0.25 ; do
  for w in 27 38 50 65; do
    for r in 2 3 4 ; do
      echo `date` RUNNING TEST with $h testcase $w words $r repeats
      cmd="$SPEXEC -t $h -r $r -w $w -cd $DBDIR"

  echo Building databases
  if [ -d $DBDIR ] ; then
    \rm $DBDIR/*.pag $DBDIR/*.dir $DBDIR/*.db $DBDIR/sp_words.* 2>/dev/null
  fi
  $cmd good _good.1
  $cmd spam _spam.1

      echo `date` Verifying good emails
      $cmd score _good.1 | ruby countscores.rb
      #$cmd find-spam _good.1

      echo `date` Verifying spam emails
      $cmd score _spam.1 | ruby countscores.rb
      #$cmd find-good _spam.1

      echo `date` Scoring good mails
      $cmd score _good.2 | ruby countscores.rb
      #$cmd find-spam _good.2

      echo `date` Scoring spam mails
      $cmd score _spam.2 | ruby countscores.rb
      #$cmd find-good _spam.2

      #echo Incrementally scoring good mails
      #ruby incrtest.rb _good.2 good "$cmd"

      #echo Incrementally scoring spam mails
      #ruby incrtest.rb _spam.2 spam "$cmd"

      echo `date` finished
    done
  done
done
) 2>&1 | tee _results
