//------------------------------------------------------------------------------
// GB_nvals.h: definitions for nrows, ncols, and nvals
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2025, All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

//------------------------------------------------------------------------------

#ifndef GB_NVALS_H
#define GB_NVALS_H

// A is nrows-by-ncols, in either CSR or CSC format
#define GB_NROWS(A) ((A)->is_csc ? (A)->vlen : (A)->vdim)
#define GB_NCOLS(A) ((A)->is_csc ? (A)->vdim : (A)->vlen)

GrB_Info GB_nvals           // get the number of entries in a matrix
(
    uint64_t *nvals,        // matrix has nvals entries
    const GrB_Matrix A,     // matrix to query
    GB_Werk Werk
) ;

#endif

