/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_TINT_GUI_THUMBHSL_HPP
#define INDII_TINT_GUI_THUMBHSL_HPP

#include "ThumbImage.hpp"
#include "SpectrumImage.hpp"
#include "../../image/ImageResource.hpp"
#include "../model/ClusterModel.hpp"
#include "../model/ClusterModelObserver.hpp"

#include "wx/panel.h"
#include "wx/slider.h"

namespace indii {
/**
 * Thumbnail with Hue-Saturation-Luminance sliders.
 */
class ThumbHSL : public wxPanel, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent window.
   * @param cluster Cluster number to which this thumbnail pertains.
   */
  ThumbHSL(wxWindow *parent, const int cluster);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(ClusterModel* model);

  /*
   * Handle model changes.
   */
  virtual void notifyNumClustersChange();
  virtual void notifySaturationDecayChange();
  virtual void notifySaturationSoftnessChange();
  virtual void notifyClusterChange(const int i);  
  virtual void notifyHueChange(const int i);
  virtual void notifySatChange(const int i);
  virtual void notifyLightChange(const int i);
  virtual void notifyAlphaChange(const int i);
  
  /*
   * Slider control events.
   */
  void OnSlideH(wxScrollEvent& evt);
  void OnSlideS(wxScrollEvent& evt);
  void OnSlideL(wxScrollEvent& evt);
  void OnSlideA(wxScrollEvent& evt);

private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Cluster number.
   */
  int cluster;

  /*
   * Controls.
   */
  wxSlider *slideH, *slideS, *slideL, *slideA;
  SpectrumImage *spectH, *spectS, *spectL, *spectA;
  ThumbImage* thumb;
  
  /*
   * Slider control ids.
   */
  enum ID {
    ID_SLIDE_H,
    ID_SLIDE_S,
    ID_SLIDE_L,
    ID_SLIDE_A
  };
  
  DECLARE_EVENT_TABLE()
};
}

#endif
