// Code generated by go generate; DO NOT EDIT.
package notion

import "errors"

type Permission int

const (
    Invalid Permission = iota
    ReadContent Permission = iota
    UpdateContent Permission = iota
    InsertContent Permission = iota
    ReadComments Permission = iota
    InsertComments Permission = iota
    ReadUsersWithEmail Permission = iota
    ReadUsersWithoutEmail Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        ReadContent: "read_content",
        UpdateContent: "update_content",
        InsertContent: "insert_content",
        ReadComments: "read_comments",
        InsertComments: "insert_comments",
        ReadUsersWithEmail: "read_users_with_email",
        ReadUsersWithoutEmail: "read_users_without_email",
    }

    StringToPermission = map[string]Permission{
        "read_content": ReadContent,
        "update_content": UpdateContent,
        "insert_content": InsertContent,
        "read_comments": ReadComments,
        "insert_comments": InsertComments,
        "read_users_with_email": ReadUsersWithEmail,
        "read_users_without_email": ReadUsersWithoutEmail,
    }

    PermissionIDs = map[Permission]int{
        ReadContent: 1,
        UpdateContent: 2,
        InsertContent: 3,
        ReadComments: 4,
        InsertComments: 5,
        ReadUsersWithEmail: 6,
        ReadUsersWithoutEmail: 7,
    }

    IdToPermission = map[int]Permission{
        1: ReadContent,
        2: UpdateContent,
        3: InsertContent,
        4: ReadComments,
        5: InsertComments,
        6: ReadUsersWithEmail,
        7: ReadUsersWithoutEmail,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
