/*
	file automatically generated by make_test_files.pl
	Tue May 16 16:46:35 2023
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for CSTD
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_cstd_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* -- prototypes -- */

int estimate_uerror( UNUR_DISTR *distr, double u_resolution, int samplesize );

double cdf_exp(double x, const UNUR_DISTR *distr);
double invcdf_exp(double u, const UNUR_DISTR *distr);

/* -- constants -- */

/* sample size */
static const int    UERROR_SAMPLESIZE = 100000;
static const double UERROR_RESOLUTION = 1.e-14;

#define COMPARE_SAMPLE_SIZE  (500)
#define VIOLATE_SAMPLE_SIZE  (20)




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */




int
estimate_uerror( UNUR_DISTR *distr,     /* distribution object */
		 double u_resolution,   /* maximal tolerated u-error */
  		 int samplesize )       /* sample size for error experiment */
/* returns 0 if maxerror < u_resolution, errorcode otherwise */
{
  UNUR_PAR *par;
  UNUR_GEN *gen;
  int i, nfpar;
  const double *fpar;
  double score;

  /* print data about distribution */
  fprintf(TESTLOG,"> %s (",unur_distr_get_name(distr));
  nfpar = unur_distr_cont_get_pdfparams(distr,&fpar);
  for(i=0;i<nfpar;i++) fprintf(TESTLOG,"%s %g", (i?",":""), fpar[i]);
  fprintf(TESTLOG,")\n");

  /* create parameter object for inversion method */
  par = unur_cstd_new(distr);
  if (par==NULL || 
      unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) {
    fprintf(TESTLOG,"\t--> inversion method not implemented !!\n\n");
    printf("0"); fflush(stdout);
    if (par) unur_par_free(par);
    unur_distr_free(distr);
    return 0; 
  }

  /* initialize generator object */
  gen = unur_init(par);

  /* run test */
  score = run_validate_u_error( TESTLOG, gen, distr, u_resolution, samplesize );

  /* clear working space */
  unur_distr_free(distr);
  unur_free(gen);

  /* return */
  fprintf(TESTLOG,"\n");
  return score;

} /* end of estimate_uerror() */


double cdf_exp(double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) { 
	return ((x<0.) ? 0. : 1.-exp(-x));
}

double invcdf_exp(double u, const UNUR_DISTR *distr ATTRIBUTE__UNUSED) { 
	return (-log(1.- u)); 
}

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,36,(unur_cstd_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,36,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,42,(unur_cstd_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,42,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* not a standard distribution and missing inverse CDF */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,48,(unur_cstd_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,48,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,58,(unur_cstd_set_variant(par,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,58,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,66,(unur_cstd_set_variant(par,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,66,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_cstd_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,75,(unur_cstd_set_variant(par,9999)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,75,UNUR_ERR_PAR_VARIANT)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {0.,1.};
   distr = unur_distr_normal(fpar,2);
   par = unur_arou_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 91,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,95,(unur_cstd_chg_truncated(gen, 0., 1.)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,95,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,106,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,106,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* does not exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = unur_distr_normal(NULL,0);
   par = unur_cstd_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 115,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,119,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double fpar[] = { 1., 2.};
   distr = unur_distr_normal(fpar,2); 
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_cstd_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,135,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,141,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[] = {3., 4.};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_gamma(fpar,2);
par = unur_cstd_new(distr);
unur_cstd_set_variant(par,2);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,155,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "gamma(3.,4.) & method = cstd; variant = 2" );
n_tests_failed += (compare_sequence_gen(TESTLOG,160,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[87];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 87 */
{
fpm[0] = 1.;
fpm[1] = 2.;
distr[0] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 5.;
distr[1] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 1.;
distr[80] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 1.;
fpm[1] = 1.;
distr[81] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 7.;
fpm[1] = 0.5;
distr[60] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 0.7;
fpm[1] = 0.5;
distr[61] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 7.;
fpm[1] = 0.1;
fpm[2] = -1.;
fpm[3] = 2.;
distr[62] = unur_distr_beta(fpm,4);
}

{
fpm[0] = 1.;
fpm[1] = 100.;
distr[2] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 3.;
fpm[1] = 4.;
distr[3] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 100.;
distr[4] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 500.;
fpm[1] = 300.;
distr[5] = unur_distr_beta(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = -3.;
fpm[3] = 15.;
distr[6] = unur_distr_beta(fpm,4);
}

{
fpm[0] = 1;
distr[66] = unur_distr_burr(fpm,1);
}

{
fpm[0] = 2;
fpm[1] = 2;
distr[67] = unur_distr_burr(fpm,2);
}

{
fpm[0] = 3;
fpm[1] = 2;
fpm[2] = 2;
distr[68] = unur_distr_burr(fpm,3);
}

{
fpm[0] = 4;
fpm[1] = 2;
fpm[2] = 2;
distr[69] = unur_distr_burr(fpm,3);
}

{
fpm[0] = 5;
fpm[1] = 2;
fpm[2] = 2;
distr[70] = unur_distr_burr(fpm,3);
}

{
fpm[0] = 6;
fpm[1] = 2;
fpm[2] = 2;
distr[71] = unur_distr_burr(fpm,3);
}

{
fpm[0] = 7;
fpm[1] = 2;
distr[72] = unur_distr_burr(fpm,2);
}

{
fpm[0] = 8;
fpm[1] = 2;
distr[73] = unur_distr_burr(fpm,2);
}

{
fpm[0] = 9;
fpm[1] = 2;
fpm[2] = 2;
distr[74] = unur_distr_burr(fpm,3);
}

{
fpm[0] = 10;
fpm[1] = 2;
distr[75] = unur_distr_burr(fpm,2);
}

{
fpm[0] = 11;
fpm[1] = 2;
distr[76] = unur_distr_burr(fpm,2);
}

{
fpm[0] = 12;
fpm[1] = 2;
fpm[2] = 2;
distr[77] = unur_distr_burr(fpm,3);
}

{
distr[7] = unur_distr_cauchy(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[8] = unur_distr_cauchy(fpm,2);
}

{
fpm[0] = 0.5;
distr[23] = unur_distr_chi(fpm,1);
}

{
fpm[0] = 1.;
distr[24] = unur_distr_chi(fpm,1);
}

{
fpm[0] = 2.;
distr[25] = unur_distr_chi(fpm,1);
}

{
fpm[0] = 50.;
distr[26] = unur_distr_chi(fpm,1);
}

{
distr[27] = unur_distr_exponential(NULL,0);
}

{
fpm[0] = 0.5;
distr[28] = unur_distr_exponential(fpm,1);
}

{
fpm[0] = 5.;
fpm[1] = -3.;
distr[29] = unur_distr_exponential(fpm,2);
}

{
distr[30] = unur_distr_extremeI(NULL,0);
}

{
fpm[0] = -3.;
distr[31] = unur_distr_extremeI(fpm,1);
}

{
fpm[0] = -1.;
fpm[1] = 5.;
distr[32] = unur_distr_extremeI(fpm,2);
}

{
fpm[0] = 3.;
distr[33] = unur_distr_extremeII(fpm,1);
}

{
fpm[0] = 0.5;
fpm[1] = -3.;
distr[34] = unur_distr_extremeII(fpm,2);
}

{
fpm[0] = 0.8;
fpm[1] = -1.;
fpm[2] = 5.;
distr[35] = unur_distr_extremeII(fpm,3);
}

{
fpm[0] = 1.;
distr[9] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 2.;
distr[10] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 3.;
distr[11] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 10.;
distr[12] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 1000.;
distr[13] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 5.;
fpm[1] = 1000.;
distr[14] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 1.e-5;
distr[15] = unur_distr_gamma(fpm,2);
}

{
fpm[0] = 5.;
fpm[1] = 10.;
fpm[2] = 1000;
distr[16] = unur_distr_gamma(fpm,3);
}

{
fpm[0] = 0.5;
distr[63] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 0.2;
distr[64] = unur_distr_gamma(fpm,1);
}

{
fpm[0] = 0.5;
fpm[1] = 7;
fpm[2] = 1;
distr[83] = unur_distr_gig(fpm,3);
}

{
fpm[0] = 0.5;
fpm[1] = 0.5;
fpm[2] = 1;
distr[86] = unur_distr_gig(fpm,3);
}

{
distr[36] = unur_distr_laplace(NULL,0);
}

{
fpm[0] = -3.;
distr[37] = unur_distr_laplace(fpm,1);
}

{
fpm[0] = -1.;
fpm[1] = 5.;
distr[38] = unur_distr_laplace(fpm,2);
}

{
distr[39] = unur_distr_logistic(NULL,0);
}

{
fpm[0] = -3.;
distr[40] = unur_distr_logistic(fpm,1);
}

{
fpm[0] = -1.;
fpm[1] = 5.;
distr[41] = unur_distr_logistic(fpm,2);
}

{
fpm[0] = 2.;
fpm[1] = 3.;
distr[56] = unur_distr_lomax(fpm,2);
}

{
fpm[0] = 20.;
fpm[1] = 0.4;
distr[57] = unur_distr_lomax(fpm,2);
}

{
fpm[0] = 0.2;
fpm[1] = 40.;
distr[58] = unur_distr_lomax(fpm,2);
}

{
fpm[0] = 0.2;
fpm[1] = 0.5;
distr[59] = unur_distr_lomax(fpm,2);
}

{
distr[17] = unur_distr_normal(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 1.e-5;
distr[18] = unur_distr_normal(fpm,2);
}

{
fpm[0] = 0.;
fpm[1] = 1.e+5;
distr[19] = unur_distr_normal(fpm,2);
}

{
fpm[0] = 2.;
fpm[1] = 3.;
distr[52] = unur_distr_pareto(fpm,2);
}

{
fpm[0] = 20.;
fpm[1] = 0.4;
distr[53] = unur_distr_pareto(fpm,2);
}

{
fpm[0] = 0.2;
fpm[1] = 40.;
distr[54] = unur_distr_pareto(fpm,2);
}

{
fpm[0] = 0.2;
fpm[1] = 0.5;
distr[55] = unur_distr_pareto(fpm,2);
}

{
fpm[0] = 0.5;
distr[42] = unur_distr_powerexponential(fpm,1);
}

{
fpm[0] = 1.;
distr[43] = unur_distr_powerexponential(fpm,1);
}

{
fpm[0] = 2.;
distr[44] = unur_distr_powerexponential(fpm,1);
}

{
fpm[0] = 10.;
distr[45] = unur_distr_powerexponential(fpm,1);
}

{
fpm[0] = 1.;
distr[65] = unur_distr_rayleigh(fpm,1);
}

{
distr[82] = unur_distr_slash(NULL,0);
}

{
fpm[0] = 2;
distr[84] = unur_distr_student(fpm,1);
}

{
fpm[0] = 0.5;
distr[85] = unur_distr_student(fpm,1);
}

{
fpm[0] = 0.7;
distr[46] = unur_distr_triangular(fpm,1);
}

{
fpm[0] = 0.;
distr[47] = unur_distr_triangular(fpm,1);
}

{
fpm[0] = 1.;
distr[48] = unur_distr_triangular(fpm,1);
}

{
distr[20] = unur_distr_uniform(NULL,0);
}

{
fpm[0] = 1.;
fpm[1] = 20.;
distr[21] = unur_distr_uniform(fpm,2);
}

{
fpm[0] = 3.;
distr[49] = unur_distr_weibull(fpm,1);
}

{
fpm[0] = 0.5;
fpm[1] = 3.;
distr[50] = unur_distr_weibull(fpm,2);
}

{
fpm[0] = 1.5;
fpm[1] = 2.;
fpm[2] = -5.;
distr[51] = unur_distr_weibull(fpm,3);
}

{
distr[22] = unur_distr_cauchy(NULL,0);
unur_distr_cont_set_domain(distr[22],0.1,1.);
unur_distr_cont_upd_mode(distr[22]);
unur_distr_cont_upd_pdfarea(distr[22]);
}

{
distr[78] = unur_distr_cont_new();
unur_distr_set_name( distr[78], "CDF_only" );
unur_distr_cont_set_domain( distr[78], 0, UNUR_INFINITY );
unur_distr_cont_set_cdf( distr[78], cdf_exp );
}

{
distr[79] = unur_distr_cont_new();
unur_distr_set_name( distr[79], "CDF&invCDF" );
unur_distr_cont_set_domain( distr[79], 0, UNUR_INFINITY );
unur_distr_cont_set_cdf( distr[79], cdf_exp );
unur_distr_cont_set_invcdf( distr[79], invcdf_exp );
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 1044 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [1] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [80] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[80]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[80],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[80]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[80],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [81] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[81]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[81],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[81]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[81],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [2] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [3] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [60] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[60]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[60],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[60]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[60],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [61] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[61]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[61],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[61]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[61],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [4] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [5] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [6] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [66] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[66]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[66],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [67] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[67]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[67],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [68] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[68]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[68],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [69] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[69]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[69],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [70] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[70]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[70],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [71] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[71]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[71],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [72] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[72]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[72],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [73] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[73]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[73],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [74] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[74]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[74],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [75] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[75]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[75],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [76] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[76]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[76],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [77] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[77]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[77],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [23] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [24] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[24]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[24],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [26] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [27] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [28] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [29] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [30] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[30]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[30],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [31] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[31]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[31],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [32] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[32]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[32],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [33] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[33]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[33],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [34] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[34]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[34],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [35] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[35]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[35],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [11] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [12] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [13] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [14] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [15] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [16] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [63] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[63]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[63],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[63]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[63],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[63]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[63],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [64] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[64]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[64],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[64]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[64],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[64]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[64],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [83] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[83]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[83],'%');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [86] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[86]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[86],'%');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [36] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[36]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[36],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [37] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[37]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[37],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [38] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[38]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[38],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [39] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[39]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[39],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[39]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[39],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[39]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[39],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [40] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[40]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[40],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [41] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[41]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[41],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[41]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[41],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[41]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[41],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [56] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[56]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[56],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[56]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[56],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[56]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[56],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [57] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[57]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[57],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[57]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[57],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[57]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[57],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [58] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[58]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[58],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[58]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[58],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[58]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[58],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [59] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[59]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[59],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[59]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[59],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[59]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[59],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [17] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,3)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,4)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,5)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,6)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,7)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'/');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [18] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,3)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,4)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,5)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,6)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,7)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [19] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,3)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,4)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,5)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,6)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,7)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'/');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [52] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[52]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[52],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[52]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[52],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [53] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[53]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[53],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[53]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[53],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [54] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[54]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[54],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[54]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[54],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [55] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[55]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[55],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[55]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[55],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[55]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[55],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [42] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[42]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[42],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[42]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[42],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [43] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[43]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[43],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [44] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[44]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[44],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[44]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[44],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [45] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[45]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[45],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [65] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[65]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[65],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[65]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[65],'-');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [82] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[82]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[82],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[82]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[82],'%');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [84] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[84]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[84],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[84]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[84],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[84]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[84],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [85] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[85]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[85],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[85]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,1)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[85],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[85]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,2)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[85],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [46] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[46]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[46],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[46]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[46],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [47] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[47]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[47],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[47]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[47],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [48] */

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[48]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[48],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[48]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[48],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [49] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[49]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[49],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[49]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[49],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[49]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[49],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [50] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[50]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[50],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[50]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[50],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[50]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[50],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [51] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[51]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[51],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[51]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[51],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[51]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[51],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [20] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [21] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [22] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	if (gen) {
unur_cstd_chg_truncated(gen,0.5,0.55);
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{ UNUR_DISTR *dg =NULL;
par = unur_cstd_new(distr_localcopy);
fpm[0] = 2.;
fpm[1] = 5.;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_cont_set_pdfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [78] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[78]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[78],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [79] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[79]);
par = unur_cstd_new(distr_localcopy);
if (unur_cstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { if (par) unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[79],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);
	unur_distr_free(distr[30]);
	unur_distr_free(distr[31]);
	unur_distr_free(distr[32]);
	unur_distr_free(distr[33]);
	unur_distr_free(distr[34]);
	unur_distr_free(distr[35]);
	unur_distr_free(distr[36]);
	unur_distr_free(distr[37]);
	unur_distr_free(distr[38]);
	unur_distr_free(distr[39]);
	unur_distr_free(distr[40]);
	unur_distr_free(distr[41]);
	unur_distr_free(distr[42]);
	unur_distr_free(distr[43]);
	unur_distr_free(distr[44]);
	unur_distr_free(distr[45]);
	unur_distr_free(distr[46]);
	unur_distr_free(distr[47]);
	unur_distr_free(distr[48]);
	unur_distr_free(distr[49]);
	unur_distr_free(distr[50]);
	unur_distr_free(distr[51]);
	unur_distr_free(distr[52]);
	unur_distr_free(distr[53]);
	unur_distr_free(distr[54]);
	unur_distr_free(distr[55]);
	unur_distr_free(distr[56]);
	unur_distr_free(distr[57]);
	unur_distr_free(distr[58]);
	unur_distr_free(distr[59]);
	unur_distr_free(distr[60]);
	unur_distr_free(distr[61]);
	unur_distr_free(distr[62]);
	unur_distr_free(distr[63]);
	unur_distr_free(distr[64]);
	unur_distr_free(distr[65]);
	unur_distr_free(distr[66]);
	unur_distr_free(distr[67]);
	unur_distr_free(distr[68]);
	unur_distr_free(distr[69]);
	unur_distr_free(distr[70]);
	unur_distr_free(distr[71]);
	unur_distr_free(distr[72]);
	unur_distr_free(distr[73]);
	unur_distr_free(distr[74]);
	unur_distr_free(distr[75]);
	unur_distr_free(distr[76]);
	unur_distr_free(distr[77]);
	unur_distr_free(distr[78]);
	unur_distr_free(distr[79]);
	unur_distr_free(distr[80]);
	unur_distr_free(distr[81]);
	unur_distr_free(distr[82]);
	unur_distr_free(distr[83]);
	unur_distr_free(distr[84]);
	unur_distr_free(distr[85]);
	unur_distr_free(distr[86]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)

/*---------------------------------------------------------------------------*/
/* [special] */

void test_special (void)
{
	/* set boolean to FALSE */
	int FAILED = 0;






  int samplesize = UERROR_SAMPLESIZE;
  double ures = UERROR_RESOLUTION;

  int errorsum = 0;
  double fpar[5];

  UNUR_DISTR *distr;

/* start test */
printf("[special "); fflush(stdout);
fprintf(TESTLOG,"\n[special]\n");

/* set stop watch */
stopwatch_lap(&watch);



  /* test for maximal u-error */
  printf("\n[test maximal u-error for inversion method]\n"); 
  fprintf(TESTLOG,"\n* Test maximal u-error for inversion method *\n"); 


  printf(" beta");

  fpar[0] = 3.;
  fpar[1] = 4.;
  distr = unur_distr_beta(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 1.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  fpar[3] = 4.;
  distr = unur_distr_beta(fpar,4);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" burr");

  fpar[0] = 1.;
  distr = unur_distr_burr(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 2.;
  fpar[1] = 2.;
  distr = unur_distr_burr(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 3.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_burr(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 4.;
  fpar[1] = 1.;
  fpar[2] = 2.;
  distr = unur_distr_burr(fpar,3);
  errorsum += estimate_uerror(distr,1e-10,samplesize);
  /* computation of CDF and /or inverse CDF is not seem very accurate */

  fpar[0] = 5.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_burr(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 6.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_burr(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 7.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_burr(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 8.;
  fpar[1] = 2.;
  distr = unur_distr_burr(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 9.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_burr(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 10.;
  fpar[1] = 2.;
  distr = unur_distr_burr(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 11.;
  fpar[1] = 2.;
  distr = unur_distr_burr(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 12.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_burr(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" cauchy");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_cauchy(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" chi");
  fpar[0] = 3.;
  distr = unur_distr_chi(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" chisquare");
  fpar[0] = 3.;
  distr = unur_distr_chisquare(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" exponential");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_exponential(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" extremeI");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_extremeI(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" extremeII");
  fpar[0] = 1.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_extremeII(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" F");
  fpar[0] = 3.;
  fpar[1] = 4.;
  distr = unur_distr_F(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" gamma");

  fpar[0] = 5.;
  distr = unur_distr_gamma(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 4.;
  fpar[1] = 3.;
  distr = unur_distr_gamma(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 3.;
  fpar[1] = 2.;
  fpar[2] = 1.;
  distr = unur_distr_gamma(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" gig");
  fpar[0] = 1.;
  fpar[1] = 2.;
  fpar[1] = 3.;
  distr = unur_distr_gig(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" gig2");
  fpar[0] = 1.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_gig2(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" ghyp");
  fpar[0] = 1.;
  fpar[1] = 3.;
  fpar[2] = 2.;
  fpar[3] = 4.;
  fpar[4] = 5.;
  distr = unur_distr_ghyp(fpar,5);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" hyperbolic");
  fpar[0] = 3.;
  fpar[1] = 2.;
  fpar[2] = 2.;
  fpar[3] = 2.;
  distr = unur_distr_hyperbolic(fpar,4);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" ig");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_ig(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" laplace");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_laplace(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" logistic");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_logistic(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" lognormal");
  fpar[0] = 1.;
  fpar[1] = 2.;
  fpar[2] = 3.;
  distr = unur_distr_lognormal(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" lomax");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_lomax(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" normal");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_normal(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" pareto");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_pareto(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" powerexponential");
  fpar[0] = 3.;
  distr = unur_distr_powerexponential(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" rayleigh");
  fpar[0] = 2.;
  distr = unur_distr_rayleigh(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" slash");
  distr = unur_distr_slash(NULL,0);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" student");
  fpar[0] = 4.4;
  distr = unur_distr_student(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" triangular");
  fpar[0] = 0.7;
  distr = unur_distr_triangular(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" uniform");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_uniform(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" weibull");
  fpar[0] = 1.;
  fpar[1] = 2.;
  distr = unur_distr_weibull(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


/*---------------------------------------------------------------------------*/

  /* test finished */
  FAILED = (errorsum < 2) ? 0 : 1;



	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (FAILED) ? 0 : 1;
	(FAILED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_special() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_cstd_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_cstd_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_cstd_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_cstd_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 491876;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 491876;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("cstd: ");

	/* run tests */
test_new();
test_set();
test_chg();
test_init();
test_reinit();
test_sample();
test_validate();
test_special();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

