# Villain
[![Python](https://img.shields.io/badge/Python-%E2%89%A5%203.6-yellow.svg)](https://www.python.org/) 
<img src="https://img.shields.io/badge/PowerShell-%E2%89%A5%20v3.0-blue">
<img src="https://img.shields.io/badge/Developed%20on-kali%20linux-blueviolet">
[![License](https://img.shields.io/badge/License-CC%20Attr--NonCommercial%204.0-red)](https://github.com/t3l3machus/Villain/blob/main/LICENSE.md)
<img src="https://img.shields.io/badge/Maintained%3F-Yes-96c40f">

## Purpose
Villain is a high level C2 framework that can handle multiple TCP socket & HoaxShell-based reverse shells, enhance their functionality with additional features (commands, utilities etc) and share them among connected sibling servers (Villain instances running on different machines).  

The framework's main features include:
 - Payload generation based on default, customizable and/or user defined payload templates (Windows & Linux),
 - A dynamically engaged pseudo-shell prompt that can quickly swift between shell sessions,
 - File uploads (via http),
 - Auto-http request & exec scripts against sessions (a bit unstable),
 - Auto-invoke ConPtyShell against a powershell r-shell session as a new process to gain a fully interactive Windows shell,
 - Team chat,
 - Session Defender (a feature that inspects user issued commands for mistakes / unintentional input that may cause a shell to hang)
   
Check out the [Usage Guide](https://github.com/t3l3machus/Villain/blob/main/Usage_Guide.md).
<!--Many additional information can be found in the user guide.-->

<!--:zap: **This release is fresh and is still being tested.** -->
### Video Presentations
[2022-11-30] [John Hammond](https://github.com/JohnHammond) showcased the tool in this incredible video -> [youtube.com/watch?v=pTUggbSCqA0](https://www.youtube.com/watch?v=pTUggbSCqA0)  
[2023-03-30] Latest release demo, made by me -> [youtube.com/watch?v=NqZEmBsLCvQ](https://www.youtube.com/watch?v=HR1KM8wrSV8)  

:warning: Create your own obfuscated reverse shell templates and replace the default ones in your instance of Villain to better handle AV evasion. Here's how 📽️ -> [youtube.com/watch?v=grSBdZdUya0](https://www.youtube.com/watch?v=grSBdZdUya0)

**Disclaimer**: Using this tool against hosts that you do not have explicit permission to test is illegal. You are responsible for any trouble you may cause by using this tool.

## Preview
![image](https://user-images.githubusercontent.com/75489922/228979419-340918d4-3c04-48b6-913a-91aaf8756ff6.png)  


## Installation & Usage
Villain has been explicitly developed and tested on **kali linux**. You can install it with `apt`:
```
apt install villain
```
You should run as root:
```
villain [-h] [-p PORT] [-x HOAX_PORT] [-n NETCAT_PORT] [-f FILE_SMUGGLER_PORT] [-i] [-c CERTFILE] [-k KEYFILE] [-u] [-q] 
```

For the latest version or if you prefer to install it manually:
```
git clone https://github.com/t3l3machus/Villain
cd ./Villain
pip3 install -r requirements.txt
```
You should also install `gnome-terminal` (required for one of the framework's commands):
```
sudo apt update&&sudo apt install gnome-terminal
```

<!--For more information about using Villain check out the [Usage Guide](https://github.com/t3l3machus/Villain/blob/main/Usage_Guide.md).-->

## Important Notes
1. HoaxShell implants are now reusable as long as they were generated by the Villain instance you are trying to connect back to from the victim (Legit session data is saved on disk and is loaded into memory every time you start Villain on your machine). Villain will also re-establish a session if it receives beacons from it (e.g., because the payload is still running on a victim from a past session). You can use the new command `flee` to exit Villain without terminating active sessions. That way, next time you start it, if there are alive beacons from victims, sessions will be re-established.
2. The communication between sibling servers is AES encrypted using the recipient sibling server's ID as the encryption KEY and the 16 first bytes of the local server's ID as IV. During the initial connection handshake of two sibling servers, each server's ID is exchanged clear text, meaning that the handshake could be captured and used to decrypt traffic between sibling servers. I know it's "weak" that way. It's not supposed to be super secure as this tool was designed to be used during penetration testing / red team assessments, for which this encryption schema should be enough.
3. Villain instances connected with each other (sibling servers) must be able to directly reach each other as well. I intend to add a network route mapping utility so that sibling servers can use one another as a proxy to achieve cross network communication between them (some day).

## Contributions
Pull requests are generally welcome. Please, keep in mind: I am constantly working on new offsec tools as well as maintaining several existing ones. I rarely accept pull requests because I either have a plan for the course of a project or I evaluate that it would be hard to test and/or maintain the foreign code. It doesn't have to do with how good or bad is an idea, it's just too much work and also, I am kind of developing all these tools to learn myself.

There are parts of this project that were removed before publishing because I considered them to be buggy or hard to maintain (at this early stage).
If you have an idea for an addition that comes with a significant chunk of code, I suggest you first contact me to discuss if there's something similar already in the making, before making a PR. 
