// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMULL_8H_TRACE_AARCH64_H_
#define VIXL_SIM_UMULL_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_umull_8H[] = {
  0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000, 0x4101, 0x4204,
  0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286,
  0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654,
  0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798,
  0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0,
  0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a,
  0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc,
  0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e,
  0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000,
  0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082,
  0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104,
  0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102, 0x0410,
  0x3267, 0x5456, 0x7c83, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6,
  0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a,
  0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a,
  0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc,
  0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e,
  0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100,
  0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182,
  0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286,
  0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000, 0x4101, 0x4204, 0x4309,
  0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe,
  0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654, 0x6864,
  0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8,
  0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177,
  0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa,
  0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d,
  0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000,
  0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083,
  0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106,
  0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104, 0x0418,
  0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102, 0x0410, 0x1a19,
  0x5456, 0x7c83, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f,
  0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7,
  0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a,
  0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd,
  0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180,
  0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203,
  0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654,
  0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe,
  0x3d09, 0x3e04, 0x3f01, 0x4000, 0x4101, 0x4204, 0x4309, 0x70e4,
  0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe, 0x8778,
  0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0,
  0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802,
  0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac,
  0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956,
  0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000,
  0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa,
  0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083, 0x0154,
  0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550,
  0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104, 0x0418, 0x21de,
  0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102, 0x0410, 0x1a19, 0x3872,
  0x7c83, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302,
  0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac,
  0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456,
  0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500,
  0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa,
  0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798,
  0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654, 0x6864,
  0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe, 0x8778,
  0x3e04, 0x3f01, 0x4000, 0x4101, 0x4204, 0x4309, 0x70e4, 0xa290,
  0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0,
  0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c,
  0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68,
  0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34,
  0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000,
  0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc,
  0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198,
  0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083, 0x0154, 0x0660,
  0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x28a4,
  0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104, 0x0418, 0x21de, 0x43bc,
  0x7d82, 0x0000, 0x0080, 0x0102, 0x0410, 0x1a19, 0x3872, 0x639c,
  0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468,
  0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534,
  0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600,
  0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc,
  0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0,
  0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8,
  0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0,
  0x3e82, 0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0,
  0x3f01, 0x4000, 0x4101, 0x4204, 0x4309, 0x70e4, 0xa290, 0xf040,
  0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518,
  0x3fff, 0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610,
  0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708,
  0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000,
  0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8,
  0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0,
  0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0,
  0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083, 0x0154, 0x0660, 0x3168,
  0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x28a4, 0x5258,
  0x7e81, 0x0000, 0x0081, 0x0104, 0x0418, 0x21de, 0x43bc, 0x7918,
  0x0000, 0x0080, 0x0102, 0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10,
  0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08,
  0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00,
  0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8,
  0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a,
  0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177,
  0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802,
  0x3f00, 0x3fff, 0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c,
  0x3f80, 0x4080, 0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518,
  0x4000, 0x4101, 0x4204, 0x4309, 0x70e4, 0xa290, 0xf040, 0xfa09,
  0x4080, 0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06,
  0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03,
  0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000,
  0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd,
  0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa,
  0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8,
  0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267,
  0x7f00, 0x807f, 0x0000, 0x0083, 0x0154, 0x0660, 0x3168, 0x5401,
  0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89,
  0x0000, 0x0081, 0x0104, 0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86,
  0x0080, 0x0102, 0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83,
  0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80,
  0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d,
  0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc,
  0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa,
  0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac,
  0x3f7e, 0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68,
  0x3fff, 0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610,
  0x4080, 0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06,
  0x4101, 0x4204, 0x4309, 0x70e4, 0xa290, 0xf040, 0xfa09, 0xfc04,
  0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02,
  0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000,
  0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000, 0x00fe,
  0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc,
  0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0,
  0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a,
  0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456,
  0x807f, 0x0000, 0x0083, 0x0154, 0x0660, 0x3168, 0x5401, 0x7c06,
  0x0000, 0x0082, 0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04,
  0x0081, 0x0104, 0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02,
  0x0102, 0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00,
  0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe,
  0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e,
  0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d,
  0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956,
  0x3ffc, 0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34,
  0x407e, 0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708,
  0x4100, 0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03,
  0x4182, 0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02,
  0x4204, 0x4309, 0x70e4, 0xa290, 0xf040, 0xfa09, 0xfc04, 0xfe01,
  0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000,
  0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff,
  0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe,
  0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8,
  0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd,
  0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab,
  0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83,
  0x0000, 0x0083, 0x0154, 0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82,
  0x0082, 0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81,
  0x0104, 0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80,
  0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f,
  0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000,
  0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000,
  0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000,
  0x407a, 0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000,
  0x40fd, 0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000,
  0x4180, 0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000,
  0x4203, 0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000,
  0x4286, 0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000,
  0x4309, 0x70e4, 0xa290, 0xf040, 0xfa09, 0xfc04, 0xfe01, 0x0000,
  0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000,
  0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000,
  0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000,
  0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000,
  0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000,
  0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000,
  0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000,
  0x0083, 0x0154, 0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000,
  0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000,
  0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000,
  0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082,
  0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083,
  0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa,
  0x53ac, 0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc,
  0x5456, 0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8,
  0x5500, 0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd,
  0x55aa, 0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000, 0x00fe,
  0x5654, 0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff,
  0x56fe, 0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000,
  0x70e4, 0xa290, 0xf040, 0xfa09, 0xfc04, 0xfe01, 0x0000, 0x0001,
  0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002,
  0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008,
  0xa802, 0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033,
  0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055,
  0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d,
  0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e,
  0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000, 0x007f,
  0x0154, 0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080,
  0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081,
  0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104,
  0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106,
  0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083, 0x0154,
  0x6468, 0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198,
  0x6534, 0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0,
  0x6600, 0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa,
  0x66cc, 0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc,
  0x6798, 0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe,
  0x6864, 0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000,
  0x8778, 0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002,
  0xa290, 0xf040, 0xfa09, 0xfc04, 0xfe01, 0x0000, 0x0001, 0x0004,
  0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002, 0x0010,
  0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066,
  0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa,
  0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa,
  0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc,
  0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe,
  0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000, 0x007f, 0x0100,
  0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102,
  0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102, 0x0410,
  0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104, 0x0418,
  0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550,
  0x7a10, 0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083, 0x0154, 0x0660,
  0x7b08, 0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0,
  0x7c00, 0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8,
  0x7cf8, 0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0,
  0x7df0, 0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8,
  0x7ee8, 0xa802, 0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000,
  0xa4b0, 0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008,
  0xc5a0, 0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002, 0x0010,
  0xf040, 0xfa09, 0xfc04, 0xfe01, 0x0000, 0x0001, 0x0004, 0x0040,
  0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198,
  0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8,
  0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8,
  0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0,
  0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8,
  0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400,
  0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000, 0x007f, 0x0100, 0x0408,
  0x3267, 0x5456, 0x7c83, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6,
  0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102, 0x0410, 0x1a19,
  0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104, 0x0418, 0x21de,
  0x7c86, 0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x28a4,
  0x7d83, 0x7f00, 0x807f, 0x0000, 0x0083, 0x0154, 0x0660, 0x3168,
  0x7e80, 0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267,
  0x7f7d, 0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a,
  0x807a, 0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd,
  0x8177, 0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000,
  0xa802, 0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033,
  0xc99c, 0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066,
  0xf518, 0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198,
  0xfa09, 0xfc04, 0xfe01, 0x0000, 0x0001, 0x0004, 0x0040, 0x0a29,
  0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef,
  0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7,
  0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a,
  0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d,
  0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980,
  0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3,
  0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a,
  0x5456, 0x7c83, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f,
  0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102, 0x0410, 0x1a19, 0x3872,
  0x7d04, 0x7e81, 0x0000, 0x0081, 0x0104, 0x0418, 0x21de, 0x43bc,
  0x7e02, 0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x28a4, 0x5258,
  0x7f00, 0x807f, 0x0000, 0x0083, 0x0154, 0x0660, 0x3168, 0x5401,
  0x7ffe, 0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456,
  0x80fc, 0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab,
  0x81fa, 0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000,
  0xa8ac, 0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055,
  0xca68, 0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa,
  0xf610, 0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8,
  0xfb06, 0xfd02, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef,
  0xfc04, 0xfe01, 0x0000, 0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39,
  0xfd02, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981,
  0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6,
  0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b,
  0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80,
  0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5,
  0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a,
  0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7,
  0x7c83, 0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302,
  0x7d82, 0x0000, 0x0080, 0x0102, 0x0410, 0x1a19, 0x3872, 0x639c,
  0x7e81, 0x0000, 0x0081, 0x0104, 0x0418, 0x21de, 0x43bc, 0x7918,
  0x7f80, 0x0000, 0x0082, 0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89,
  0x807f, 0x0000, 0x0083, 0x0154, 0x0660, 0x3168, 0x5401, 0x7c06,
  0x817e, 0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83,
  0x827d, 0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000,
  0xa956, 0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d,
  0xcb34, 0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa,
  0xf708, 0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8,
  0xfc03, 0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7,
  0xfd02, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981,
  0xfe01, 0x0000, 0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09,
  0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86,
  0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03,
  0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80,
  0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd,
  0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc,
  0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a,
  0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac,
  0x0000, 0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468,
  0x0000, 0x0080, 0x0102, 0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10,
  0x0000, 0x0081, 0x0104, 0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86,
  0x0000, 0x0082, 0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04,
  0x0000, 0x0083, 0x0154, 0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82,
  0x0000, 0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000,
  0x0000, 0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e,
  0x0000, 0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc,
  0x0000, 0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0,
  0x0000, 0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a,
  0x0000, 0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6,
  0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86,
  0x0000, 0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04,
  0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82,
  0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00,
  0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e,
  0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e,
  0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd,
  0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456,
  0x007e, 0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534,
  0x007f, 0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08,
  0x0080, 0x0102, 0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83,
  0x0081, 0x0104, 0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02,
  0x0082, 0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81,
  0x0083, 0x0154, 0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000,
  0x00aa, 0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000, 0x007f,
  0x00cc, 0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe,
  0x00f8, 0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8,
  0x00fd, 0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d,
  0x00fe, 0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b,
  0x00ff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03,
  0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82,
  0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01,
  0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80,
  0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff,
  0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100,
  0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180,
  0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500,
  0x00fc, 0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600,
  0x00fe, 0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00,
  0x0100, 0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80,
  0x0102, 0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00,
  0x0104, 0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80,
  0x0106, 0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000,
  0x0154, 0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080,
  0x0198, 0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000, 0x007f, 0x0100,
  0x01f0, 0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400,
  0x01fa, 0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980,
  0x01fc, 0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80,
  0x01fe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80,
  0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00,
  0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80,
  0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000,
  0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080,
  0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080, 0x4182,
  0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff, 0x4100, 0x4203,
  0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e, 0x407e, 0x4180, 0x55aa,
  0x03f0, 0x194d, 0x2a80, 0x3efd, 0x3ffc, 0x40fd, 0x5500, 0x66cc,
  0x03f8, 0x1980, 0x2ad5, 0x3f7a, 0x407a, 0x5456, 0x6600, 0x7cf8,
  0x0400, 0x19b3, 0x2b2a, 0x3ff7, 0x53ac, 0x6534, 0x7c00, 0x7f7d,
  0x0408, 0x19e6, 0x2b7f, 0x5302, 0x6468, 0x7b08, 0x7e80, 0x7ffe,
  0x0410, 0x1a19, 0x3872, 0x639c, 0x7a10, 0x7d83, 0x7f00, 0x807f,
  0x0418, 0x21de, 0x43bc, 0x7918, 0x7c86, 0x7e02, 0x7f80, 0x0000,
  0x0550, 0x28a4, 0x5258, 0x7b89, 0x7d04, 0x7e81, 0x0000, 0x0081,
  0x0660, 0x3168, 0x5401, 0x7c06, 0x7d82, 0x0000, 0x0080, 0x0102,
  0x07c0, 0x3267, 0x5456, 0x7c83, 0x0000, 0x007f, 0x0100, 0x0408,
  0x07e8, 0x329a, 0x54ab, 0x0000, 0x007e, 0x00fe, 0x0400, 0x19b3,
  0x07f0, 0x32cd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0x1980, 0x2ad5,
  0x07f8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0x2a80, 0x3efd,
  0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0x3e80, 0x3f7e,
  0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0x3f00, 0x3fff,
  0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0x3f80, 0x4080,
  0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000, 0x4101,
};
const unsigned kExpectedCount_NEON_umull_8H = 361;

#endif  // VIXL_SIM_UMULL_8H_TRACE_AARCH64_H_
