c###ef1var.for
      SUBROUTINE EF1VAR (CYCEN, II)
C--------------------------------
C
C     THIS ROUTINE EVALUATES E AND F1 LAYER IONOSPHERIC PARAMETERS
C
C CYCEN IS SUN ZENITH ANGLE, RADIANS.
C II IS SAMPLE AREA
      COMMON / PSCA / PSC(4), PSCB(4), IPSC
C
      COMMON / MFAC / F2M3(5),HPF2(5),ZENANG(5),ZENMAX(5),IEDP,FSECV(3)
      COMMON /DON /ALATD, AMIN, AMIND, BTR, BTRD, DLONG, DMP, ERTR, GCD,
     1 GCDKM, PMP, PWR, TLAT, TLATD, TLONG, TLONGD, RSN, SIGTR, RLAT,
     2 RLATD,RLONG,RLONGD,BRTD,FLUX,ULAT,ULATD,ULONG,ULONGD,SSN,D90R,
     3 D50R,D10R,D90S,D50S,D10S
      COMMON /A11 /GAMMA (6)
      COMMON /FONE/ ANEW(3),BNEW(3),ACHI(2),BCHI(2)
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON /RON /CLAT(5), CLONG(5), GLAT(5), RD(5), FI(3,5), YI(3,5),
     1HI(3,5), HPRIM(30,5), HTRUE(30,5), FVERT(30,5),KM,KFX, AFAC(30,5),
     2HTR(50,3), FNSQ(50,3)
      COMMON /GEOG /GYZ (5), RAT (5), GMDIP (5), CLCK (5), ABIY (5), ART
     1IC (5), SIGPAT (5), EPSPAT (5)
      COMMON / SSP / SUN(2,12), MONTH
C.....RATIOS OF HEIGHT OF MAXIMUM IONIZATION TO SEMITHICKNESS
      DATA BETAE/5.5/, BETAF1/4.0/
C.....EVALUATE E LAYER CRITICAL FREQUENCY
      CALL VERSY(6, 6, II)
      IF(GAMMA(6) - 0.36) 85, 90, 90
C.....BAD VALUE FOR MAP, USE MIDNIGHT VALUE
   85 GAMMA(6) = 0.36 * SQRT(1. + 0.0098 * SSN)
   90 CONTINUE
C.....FI(1,II) IS E LAYER CRITICAL FREQUENCY
C.....HI(1,II) IS E LAYER HEIGHT OF MAXIMUM IONIZATION
C.....YI(1,II) IS E LAYER SEMITHICKNESS
      FI (1, II) = GAMMA (6) * PSC (1)
      HI (1, II) = 110.
      YI (1, II) = HI (1, II) / BETAE
      CYCEN = ABS (CYCEN)
      Z = CYCEN * R2D
      COSZ = COS (CYCEN)
C.....COSINE OF RAWER MAGNETIC DIP ANGLE
      COSDI = COS (GMDIP (II))
C.....MAXIMUM ZENITH ANGLE FOR F1 LAYER
      ZMAX = ACHI(1)+BCHI(1)*SSN + (ACHI(2)+BCHI(2)*SSN)*COSDI
      ZENMAX(II) = ZMAX
      ZENANG(II) = Z
      IF(Z.le.ZMAX) then
         FI(2,II)=(ANEW(1)+BNEW(1)*SSN) + (ANEW(2)+BNEW(2)*SSN)*COSZ
     A          + (ANEW(3)+BNEW(3)*SSN)*COSZ*COSZ
C.....FI(2,II) IS F1 LAYER CRITICAL FREQUENCY
C.....HI(2,II) IS F1 LAYER HEIGHT OF MAXIMUM IONIZATION
C.....YI(2,II) IS F1 LAYER SEMITHICKNESS
         FI(2,II)=FI(2,II)*PSC(2)
         HI(2,II)=165. + 0.6428*Z
         YI(2,II)=HI(2,II)/BETAF1
      else
         FI(2,II)=0.0
         HI(2,II)=0.0
         YI(2,II)=0.0
      end if
      RETURN
      END
C--------------------------------
