/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;

public class UrlIdentifier
implements Identifier {
    private static Log _log;
    private static final boolean DEBUG;
    private static final Set UNRESERVED_CHARACTERS;
    private URL _urlIdentifier;

    public UrlIdentifier(String identifier) throws DiscoveryException {
        this(identifier, false);
    }

    public UrlIdentifier(String identifier, boolean removeFragment) throws DiscoveryException {
        this._urlIdentifier = UrlIdentifier.normalize(identifier, removeFragment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlIdentifier that = (UrlIdentifier)o;
        return this._urlIdentifier.equals(that._urlIdentifier);
    }

    public int hashCode() {
        return this._urlIdentifier.hashCode();
    }

    public String getIdentifier() {
        return this._urlIdentifier.toExternalForm();
    }

    public String toString() {
        return this._urlIdentifier.toExternalForm();
    }

    public URL getUrl() {
        return this._urlIdentifier;
    }

    public static URL normalize(String text) throws DiscoveryException {
        return UrlIdentifier.normalize(text, false);
    }

    public static URL normalize(String text, boolean removeFragment) throws DiscoveryException {
        try {
            String file;
            URI uri = new URI(text);
            URL url = uri.normalize().toURL();
            String protocol = url.getProtocol().toLowerCase();
            String host = url.getHost().toLowerCase();
            int port = url.getPort();
            String path = UrlIdentifier.normalizeUrlEncoding(url.getPath());
            String query = UrlIdentifier.normalizeUrlEncoding(url.getQuery());
            String fragment = UrlIdentifier.normalizeUrlEncoding(url.getRef());
            if (port == url.getDefaultPort()) {
                port = -1;
            }
            if ("".equals(file = path)) {
                file = "/";
            }
            if (query != null) {
                file = file + "?" + query;
            }
            if (fragment != null && !removeFragment) {
                file = file + "#" + fragment;
            }
            URL normalized = new URL(protocol, host, port, file);
            if (DEBUG) {
                _log.debug((Object)("Normalized: " + text + " to: " + normalized));
            }
            return normalized;
        }
        catch (MalformedURLException e) {
            throw new DiscoveryException("Invalid URL identifier", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DiscoveryException("Invalid URL identifier", (Throwable)e);
        }
    }

    private static String normalizeUrlEncoding(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringBuffer normalized = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char current = text.charAt(i);
            if (current == '%' && i < len - 2) {
                String percentCode = text.substring(i, i + 3).toUpperCase();
                try {
                    String str = URLDecoder.decode(percentCode, "ISO-8859-1");
                    char chr = str.charAt(0);
                    if (UNRESERVED_CHARACTERS.contains(new Character(chr))) {
                        normalized.append(chr);
                    } else {
                        normalized.append(percentCode);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    normalized.append(percentCode);
                }
                i += 2;
                continue;
            }
            normalized.append(current);
        }
        return normalized.toString();
    }

    static {
        char c;
        _log = LogFactory.getLog(UrlIdentifier.class);
        DEBUG = _log.isDebugEnabled();
        UNRESERVED_CHARACTERS = new HashSet();
        for (c = 'a'; c <= 'z'; c = (char)(c + 1)) {
            UNRESERVED_CHARACTERS.add(new Character(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            UNRESERVED_CHARACTERS.add(new Character(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            UNRESERVED_CHARACTERS.add(new Character(c));
        }
        UNRESERVED_CHARACTERS.add(new Character('-'));
        UNRESERVED_CHARACTERS.add(new Character('.'));
        UNRESERVED_CHARACTERS.add(new Character('_'));
        UNRESERVED_CHARACTERS.add(new Character('~'));
    }
}

