/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.OpenIDException;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class DirectError
extends Message {
    private static Log _log = LogFactory.getLog(DirectError.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("error");
    protected static final List optionalFields = Arrays.asList("ns", "contact", "reference");
    private OpenIDException _exception;

    protected DirectError(String msg) {
        this(msg, false);
    }

    protected DirectError(String msg, boolean compatibility) {
        this(null, msg, compatibility);
    }

    protected DirectError(OpenIDException e, boolean compatibility) {
        this(e, e.getMessage(), compatibility);
    }

    protected DirectError(OpenIDException e, String msg, boolean compatibility) {
        this.set("error", msg);
        this._exception = e;
        if (!compatibility) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
    }

    protected DirectError(ParameterList params) {
        super(params);
    }

    public static DirectError createDirectError(OpenIDException e) {
        return DirectError.createDirectError(e, false);
    }

    public static DirectError createDirectError(String msg) {
        return DirectError.createDirectError(null, msg, false);
    }

    public static DirectError createDirectError(String msg, boolean compatibility) {
        return DirectError.createDirectError(null, msg, compatibility);
    }

    public static DirectError createDirectError(OpenIDException e, boolean compatibility) {
        return DirectError.createDirectError(e, e.getMessage(), compatibility);
    }

    public static DirectError createDirectError(OpenIDException e, String msg, boolean compatibility) {
        DirectError err = new DirectError(e, msg, compatibility);
        try {
            err.validate();
        }
        catch (MessageException ex) {
            _log.error((Object)("Invalid " + (compatibility ? "OpenID1" : "OpenID2") + " direct error message created for message: " + msg));
        }
        _log.debug((Object)("Created direct error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public static DirectError createDirectError(ParameterList params) {
        DirectError err = new DirectError(params);
        try {
            err.validate();
        }
        catch (MessageException e) {
            _log.error((Object)("Invalid direct error message created: " + err.keyValueFormEncoding()));
        }
        _log.debug((Object)("Created direct error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public OpenIDException getException() {
        return this._exception;
    }

    public void setException(OpenIDException e) {
        this._exception = e;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }

    public void setErrorMsg(String msg) {
        this.set("error", msg);
    }

    public String getErrorMsg() {
        return this.getParameterValue("error");
    }

    public void setContact(String contact) {
        this.set("contact", contact);
    }

    public void setReference(String reference) {
        this.set("reference", reference);
    }
}

