from wifipumpkin3.core.config.globalimport import *
from wifipumpkin3.core.servers.dns.DNSBase import DNSBase
from wifipumpkin3.core.packets.dnsserver import DNSServerThread

# This file is part of the wifipumpkin3 Open Source Project.
# wifipumpkin3 is licensed under the Apache 2.0.

# Copyright 2020 P0cL4bs Team - Marcos Bomfim (mh4x0f)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

# http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


class PyDNSServer(DNSBase):
    ID = "pydns_server"
    Name = "PyDNS Server"
    Author = "Samuel Colvin @samuelcolvin"
    LogFile = C.LOG_PYDNSSERVER
    ExecutableFile = ""

    def __init__(self, parent):
        super(PyDNSServer, self).__init__(parent)
        if not self.conf.get("accesspoint", "pydns_zone_file", format=str):
            self.conf.set("accesspoint", "pydns_zone_file", C.DNSHOSTS)
        self.root = parent

    @property
    def commandargs(self):
        pass

    def LogOutput(self, data):
        if self.conf.get("accesspoint", "status_ap", format=bool):
            self.logger.info(data)

    def boot(self):
        self.interfaces = Refactor.get_interfaces()
        # filter dns server for only run when is connected on internet
        if self.interfaces.get("activated")[0] != None:
            self.reactor = DNSServerThread(self.conf)
            self.reactor.sendRequests.connect(self.LogOutput)
            self.reactor.setObjectName(self.ID)

    def parser_set_dhcpmode(self, status, command):
        if len(command.split(".")) == 2:
            try:
                # command = dhcpmode.pydns_verbose true
                dhcpmode, key_setting = (
                    command.split(".")[0],
                    command.split(".")[1].split()[0],
                )
                if key_setting in self.conf.get_all_childname("accesspoint"):
                    self.conf.set("accesspoint", key_setting, status)
                else:
                    print(
                        display_messages(
                            "unknown setting: {}".format(key_setting), error=True
                        )
                    )
            except IndexError:
                print(display_messages("unknown sintax command", error=True))
        else:
            try:
                id_dhcp = command.split()[1]
                if not id_dhcp in self.root.dhcp_controller.getInfo().keys():
                    print(
                        display_messages(
                            "the parameter id {} was not found.".format(
                                setcolor(id_dhcp, color="red")
                            ),
                            error=True,
                        )
                    )
                    return
                self.root.dhcp_controller.setDhcpMode(id_dhcp)
            except IndexError:
                print(display_messages("unknown sintax command", error=True))
