// Copyright (c) 2020-2021 by the Zeek Project. See LICENSE for details.

#pragma once

#include <string>
#include <tuple>

#include <hilti/rt/extension-points.h>
#include <hilti/rt/types/bytes.h>
#include <hilti/rt/types/stream.h>
#include <hilti/rt/util.h>

namespace hilti::rt {

namespace real {
/** Available formats for unpacking a binary floating point value. */
enum class Type : int64_t { Undef, IEEE754_Single, IEEE754_Double };

/** Unpacks a floatingpoint value from a binary representation, following the protocol for `unpack` operator. */
extern Result<std::tuple<double, Bytes>> unpack(const Bytes& data, Type type, ByteOrder fmt);

/** Unpacks a floatingpoint value from a binary representation, following the protocol for `unpack` operator. */
extern Result<std::tuple<double, stream::View>> unpack(const stream::View& data, Type type, ByteOrder fmt);

} // namespace real

namespace detail::adl {
std::string to_string(double x, tag /*unused*/);
std::string to_string(const real::Type& x, tag /*unused*/);
} // namespace detail::adl

} // namespace hilti::rt
