/* ANSI-C code produced by gperf version 2.7.1 (19981006 egcs) */
/* Command-line: gperf -L ANSI-C -I -t -H gbHash -N inGB -C -E -o -n -c -D gbpercent.txt  */
/****************************************************
 400 Most frequently used GB chars. 
 ****************************************************/
#include <string.h>
#include "zhstatis.h"

/* maximum key range = 991, duplicates = 5 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
gbHash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991, 991, 991, 991, 991, 991, 991, 991, 991, 991,
      991,  91, 425, 320, 148,  70, 510,  85, 203, 160,
        6,  18, 480, 223, 113, 345,  28, 120, 320, 390,
       75,  20, 275, 380, 230,  50, 433,  15, 145,   5,
      455, 460, 163, 180, 338,  40,   8, 508, 510,  45,
      325,  85,  30, 140, 105, 305,   3, 225, 100, 403,
      113, 480,  25, 205,   0, 250, 393, 371,  63, 260,
      268, 991,  10, 470, 405, 268, 348,  76, 285, 131,
      408, 398, 991, 125, 330, 126, 388, 503,  51, 148,
      350,  46,   1, 166,  15,  16, 485, 106, 458,  41,
      103, 221,  21,  61, 500, 991
    };
  return asso_values[(unsigned char)str[len - 1]] + asso_values[(unsigned char)str[0]];
}

#ifdef __GNUC__
__inline
#endif
const struct charHz *
inGB (register const char *str, register unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 400,
      MIN_WORD_LENGTH = 2,
      MAX_WORD_LENGTH = 2,
      MIN_HASH_VALUE = 0,
      MAX_HASH_VALUE = 990
    };

  static const struct charHz wordlist[] =
    {
      {"",	0.151748},
      {"",	0.062792},
      {"֪",	0.176508},
      {"Ϊ",	0.442767},
      {"",	0.214763},
      {"",	0.213959},
      {"ֻ",	0.229438},
      {"",	0.085280},
      {"λ",	0.128747},
      {"",	0.073778},
      {"",	0.094296},
      {"",	0.168043},
      {"",	0.514231},
      {"",	0.063487},
      {"",	3.500849},
      {"",	0.211674},
      {"Ԫ",	0.071841},
      {"",	0.140707},
      {"ʽ",	0.057680},
      {"",	0.167690},
      {"",	0.072121},
      {"",	0.146944},
      {"",	0.070839},
      {"",	0.081974},
      {"ʵ",	0.156769},
      {"",	0.083052},
      {"",	0.382771},
      {"û",	0.244614},
      {"",	0.057849},
      {"ë",	0.075090},
      {"",	0.396983},
      {"",	0.093383},
      {"",	0.058726},
      {"",	0.233198},
      {"",	0.092784},
      {"",	0.188655},
      {"",	0.054738},
      {"",	0.111181},
      {"ǰ",	0.200232},
      {"",	1.345411},
      {"",	0.129442},
      {"",	0.121678},
      {"δ",	0.054546},
      {"ʹ",	0.118288},
      {"",	0.123170},
      {"",	0.436374},
      {"",	0.495768},
      {"",	0.174189},
      {"",	0.964866},
      {"ɽ",	0.103285},
      {"",	0.091243},
      {"",	0.063780},
      {"",	0.152685},
      {"",	0.717652},
      {"",	0.058755},
      {"ɫ",	0.074190},
      {"",	0.089328},
      {"",	0.204736},
      {"",	0.273937},
      {"",	0.117537},
      {"",	0.117812},
      {"",	0.327524},
      {"֮",	0.327879},
      {"",	0.127394},
      {"ô",	0.276714},
      {"",	1.014949},
      {"",	0.137512},
      {"Ҫ",	0.370943},
      {"ֱ",	0.075193},
      {"",	0.064573},
      {"̫",	0.103034},
      {"",	0.095783},
      {"",	0.151640},
      {"һ",	1.703619},
      {"",	0.101242},
      {"",	0.091301},
      {"ҵ",	0.134539},
      {"",	0.103181},
      {"",	0.126292},
      {"",	0.060073},
      {"",	0.349432},
      {"",	0.222406},
      {"",	0.073591},
      {"ʮ",	0.211422},
      {"Ա",	0.097189},
      {"",	0.152480},
      {"",	0.123866},
      {"ʱ",	0.412130},
      {"",	0.078221},
      {"",	0.624527},
      {"",	0.061338},
      {"",	0.098381},
      {"Ǯ",	0.055097},
      {"˵",	0.508134},
      {"",	0.075883},
      {"",	0.055787},
      {"",	0.061514},
      {"",	0.115919},
      {"",	0.075698},
      {"",	0.143753},
      {"",	0.073937},
      {"",	0.083070},
      {"д",	0.056349},
      {"",	0.078525},
      {"",	0.104545},
      {"",	0.079151},
      {"",	0.074843},
      {"",	0.197660},
      {"",	0.421135},
      {"",	0.176988},
      {"",	0.064201},
      {"",	0.343557},
      {"",	0.077728},
      {"С",	0.293018},
      {"",	0.114808},
      {"",	0.063376},
      {"",	0.128778},
      {"",	0.149985},
      {"",	0.203868},
      {"",	0.305242},
      {"",	0.152936},
      {"",	0.074596},
      {"ս",	0.076361},
      {"",	0.059639},
      {"",	0.057653},
      {"",	0.158364},
      {"",	0.073128},
      {"",	0.065122},
      {"",	0.059687},
      {"",	0.070030},
      {"",	0.061845},
      {"",	0.169370},
      {"",	0.143764},
      {"",	0.058127},
      {"ָ",	0.068890},
      {"",	0.055467},
      {"",	0.074475},
      {"",	0.055267},
      {"",	0.100845},
      {"",	0.642527},
      {"",	0.113407},
      {"",	0.670268},
      {"",	0.072306},
      {"ϵ",	0.085791},
      {"ԭ",	0.089937},
      {"",	0.074014},
      {"",	0.087664},
      {"ˮ",	0.102945},
      {"չ",	0.063943},
      {"ת",	0.059482},
      {"",	0.324818},
      {"Щ",	0.166013},
      {"",	0.142495},
      {"",	0.143041},
      {"",	0.062711},
      {"",	0.063875},
      {"",	0.084231},
      {"",	0.070334},
      {"",	0.340950},
      {"",	0.253537},
      {"",	0.089789},
      {"",	0.066471},
      {"",	0.342850},
      {"˼",	0.068379},
      {"",	0.067758},
      {"",	0.061514},
      {"",	0.058356},
      {"",	0.121345},
      {"",	0.084066},
      {"",	0.084736},
      {"",	0.311761},
      {"Զ",	0.066691},
      {"",	0.134213},
      {"",	0.089264},
      {"ʶ",	0.056331},
      {"",	0.101912},
      {"̨",	0.078054},
      {"",	0.636581},
      {"",	0.300629},
      {"",	0.058334},
      {"",	0.076271},
      {"",	0.146378},
      {"",	0.067145},
      {"",	1.283668},
      {"",	0.084392},
      {"",	0.094190},
      {"",	0.060622},
      {"",	0.079391},
      {"",	0.088464},
      {"",	0.065369},
      {"",	1.307755},
      {"",	0.080068},
      {"",	0.402590},
      {"Ȼ",	0.251950},
      {"ס",	0.097438},
      {"ȫ",	0.151277},
      {"",	0.136630},
      {"",	0.064102},
      {"",	0.090869},
      {"ʲ",	0.130740},
      {"",	0.217789},
      {"",	0.081322},
      {"",	0.088088},
      {"",	0.224425},
      {"",	0.055379},
      {"",	0.107695},
      {"",	0.826706},
      {"",	0.152597},
      {"",	0.073580},
      {"",	0.196038},
      {"",	0.229908},
      {"",	0.077287},
      {"",	0.088749},
      {"",	0.135949},
      {"",	0.060397},
      {"",	0.168552},
      {"",	0.067138},
      {"",	0.084762},
      {"",	0.202303},
      {"",	0.185462},
      {"",	0.182608},
      {"",	0.053845},
      {"",	0.078045},
      {"",	0.126537},
      {"ȥ",	0.330934},
      {"",	0.117460},
      {"",	0.084711},
      {"",	0.072738},
      {"ȴ",	0.105046},
      {"",	0.056342},
      {"",	0.083728},
      {"",	0.064229},
      {"",	0.156121},
      {"",	0.089804},
      {"",	0.054791},
      {"",	0.092669},
      {"",	0.430809},
      {"",	0.072425},
      {"",	0.061534},
      {"",	0.125012},
      {"",	0.252867},
      {"",	0.103862},
      {"",	0.068245},
      {"",	0.064196},
      {"",	0.131700},
      {"",	0.158959},
      {"Ҳ",	0.412956},
      {"",	0.061082},
      {"",	0.060972},
      {"",	0.088065},
      {"",	0.131476},
      {"",	0.061942},
      {"",	0.057693},
      {"",	0.112545},
      {"",	0.169738},
      {"",	0.097747},
      {"",	0.188836},
      {"",	0.067301},
      {"",	0.103631},
      {"",	0.074605},
      {"",	0.087462},
      {"",	0.112757},
      {"Ժ",	0.064434},
      {"",	0.060794},
      {"",	0.161359},
      {"",	0.161229},
      {"",	1.081233},
      {"",	0.211932},
      {"Ŀ",	0.094628},
      {"",	0.100654},
      {"",	0.075649},
      {"",	0.253067},
      {"",	0.232004},
      {"",	0.104464},
      {"",	0.141283},
      {"",	0.202277},
      {"",	0.098824},
      {"",	0.071268},
      {"",	0.076121},
      {"ѧ",	0.313110},
      {"ʿ",	0.059531},
      {"",	0.262760},
      {"",	0.058312},
      {"",	0.075691},
      {"ÿ",	0.067385},
      {"",	0.059983},
      {"ǿ",	0.060747},
      {"ͨ",	0.095327},
      {"",	0.081732},
      {"",	0.060990},
      {"ƽ",	0.116858},
      {"",	0.183761},
      {"",	0.099417},
      {"",	0.208392},
      {"",	0.119434},
      {"",	0.055445},
      {"",	0.075475},
      {"Ȩ",	0.064165},
      {"",	0.238170},
      {"",	0.065223},
      {"",	0.216015},
      {"",	0.176671},
      {"ʦ",	0.098604},
      {"",	0.237050},
      {"",	0.310500},
      {"",	0.123004},
      {"",	0.103316},
      {"",	0.073529},
      {"",	0.748073},
      {"",	0.181841},
      {"",	0.069931},
      {"",	0.366675},
      {"",	0.106073},
      {"",	0.063793},
      {"",	0.055222},
      {"",	0.089414},
      {"",	0.197245},
      {"",	0.148374},
      {"",	0.846428},
      {"",	0.158459},
      {"",	0.099988},
      {"",	0.167521},
      {"",	0.077498},
      {"",	0.057761},
      {"˾",	0.084963},
      {"",	0.072820},
      {"",	0.297066},
      {"",	0.074446},
      {"",	0.075854},
      {"",	0.093914},
      {"",	0.165147},
      {"",	0.114573},
      {"Ц",	0.096279},
      {"",	0.116060},
      {"",	0.082472},
      {"",	0.178348},
      {"Ů",	0.141049},
      {"",	0.090741},
      {"",	0.109685},
      {"",	0.057889},
      {"",	0.122566},
      {"",	0.060534},
      {"",	0.058129},
      {"",	0.059348},
      {"",	0.090981},
      {"Ϣ",	0.056893},
      {"",	0.167708},
      {"",	0.085688},
      {"",	0.087272},
      {"",	0.067046},
      {"",	0.101187},
      {"",	0.058894},
      {"",	0.154598},
      {"",	0.145362},
      {"",	0.189995},
      {"",	0.270297},
      {"ͷ",	0.189444},
      {"",	0.136868},
      {"",	0.138951},
      {"ͳ",	0.074402},
      {"",	0.162739},
      {"",	0.134687},
      {"",	0.120122},
      {"",	0.089189},
      {"",	0.093070},
      {"",	0.594848},
      {"·",	0.089668},
      {"",	0.125810},
      {"",	0.201591},
      {"",	0.441396},
      {"",	0.260181},
      {"",	0.086397},
      {"",	0.440206},
      {"",	0.111459},
      {"",	0.119826},
      {"",	0.066006},
      {"",	0.335011},
      {"",	0.389616},
      {"",	0.155393},
      {"",	0.076789},
      {"",	0.143537},
      {"ͬ",	0.187525},
      {"",	0.152385},
      {"",	0.232956},
      {"",	0.063231},
      {"",	0.099303},
      {"",	0.093403},
      {"",	0.064661},
      {"",	0.235155},
      {"",	0.425756},
      {"",	0.075191},
      {"",	0.087173},
      {"Ʒ",	0.059628},
      {"Ӣ",	0.057878},
      {"",	0.062792},
      {"",	0.096854},
      {"",	0.114705},
      {"",	0.072145},
      {"",	0.061058},
      {"Ӧ",	0.089767}
    };

  static const short lookup[] =
    {
         0,   -1,   -1,    1,   -1,   -1,    2,   -1,
        -1,    3,   -1,    4,   -1,    5,   -1,    6,
         7,   -1,    8,   -1,    9,   10,   -1,   11,
        -1,   12,   13,   -1,   14,   -1,   15,   16,
        -1,   17,   -1,   18,   -1,   -1,   19,   -1,
        -1,   20,   -1,   21,   -1,   -1,   22,   -1,
        -1,   23,   24,   25,   -1,   26,   -1,   27,
        28,   -1,   29,   -1,   30,   31,   -1,   32,
        -1,   33,   34,   -1,   35,   -1,   36,   37,
        -1,   38,   -1,   39,   40,   -1, -482,   -1,
        43, -359,   -2,   44,   45,   46,   47,   -1,
        48,   -1,   49,   50,   -1,   51,   -1,   -1,
        52,   -1,   -1,   -1,   53,   54,   -1,   55,
        -1,   56,   57,   -1,   58,   59,   60,   61,
        -1,   62,   63,   64,   65,   -1,   66,   67,
        68,   69,   -1,   70,   -1,   71,   72,   -1,
        73,   -1,   74,   75,   -1,   76,   77,   78,
        79,   -1,   80,   -1,   81,   82,   -1,   83,
        -1,   84,   85,   -1,   86,   -1,   87,   88,
        -1,   89,   90,   91,   -1,   -1,   92,   -1,
        93,   94,   -1,   95,   -1,   96,   97,   -1,
        98,   -1,   99,  100,   -1,  101,   -1,  102,
       103,   -1,  104,   -1, -605,  107,   -1,  108,
        -1,  109,  110,   -1,  111,   -1,  112,  113,
        -1,  114,   -1,  115,  116,   -1,  117,   -1,
       118,  119,   -1,  120, -295,   -2,   -1,   -1,
       121,   -1,  122,  123,   -1,   -1,  124,  125,
       126,   -1,  127,   -1,  128,  129,   -1,  130,
        -1,  131,  132,   -1,  133,   -1,  134,  135,
        -1,  136,   -1,  137,  138,   -1,  139,   -1,
       140,  141,   -1,   -1,  142,  143,   -1,   -1,
       144,   -1,  145,  146,   -1,  147,   -1,  148,
       149,   -1,  150,   -1,  151,  152,   -1,   -1,
        -1,   -1,  153,   -1,  154,   -1,  155,  156,
        -1,  157,   -1,  158,  159,   -1,  160,   -1,
       161,   -1,   -1,  162,   -1,  163,  164,   -1,
       165,   -1,  166,   -1,   -1,  167,   -1,  168,
        -1,   -1,  169,   -1, -727,  172,   -1,  173,
        -1,  174,  175,   -1,  176,   -1,  177,  178,
        -1,  179,   -1,  180,  181,   -1,  182,   -1,
       183,  184,   -1,  185,   -1,  186, -230,   -2,
       187,   -1,  188,   -1,   -1,  189,   -1,  190,
       191,   -1,  192,   -1,  193,  194,   -1,  195,
        -1,  196,  197,   -1,  198,   -1,  199,  200,
        -1,  201,   -1,  202,  203,   -1,  204,   -1,
       205,  206,   -1,  207,   -1,  208,  209,   -1,
       210,   -1,  211,   -1,   -1,  212,   -1,  213,
        -1,   -1,  214,   -1,  215,  216,   -1,   -1,
       217,  218,  219,   -1,  220,   -1,  221,  222,
        -1,  223,   -1,  224,  225,   -1,  226,  227,
       228,  229,   -1,  230,   -1,  231,   -1,   -1,
       232,   -1, -822,  235,   -1,  236,   -1,  237,
       238,   -1,  239,   -1,  240, -167,   -2,  241,
        -1,  242,   -1,   -1,  243,   -1,  244,  245,
        -1,  246,  247,  248,  249,   -1,  250,   -1,
       251,  252,   -1,  253,  254,  255,   -1,   -1,
       256,   -1,  257,  258,   -1,  259,   -1,  260,
       261,   -1,  262,   -1,  263,  264,   -1,  265,
        -1,  266,  267,   -1,  268,   -1,  269,  270,
        -1,  271,   -1,  272,  273,   -1,  274,   -1,
       275,  276,   -1,  277,   -1,  278,   -1,   -1,
       279,   -1,  280,   -1,   -1,  281,   -1,  282,
        -1,   -1,  283,   -1,  284,   -1,   -1,  285,
        -1,  286,   -1,   -1,  287,   -1,  288,   -1,
        -1,  289,   -1,  290,  291,   -1,  292,   -1,
       293,   -1,   -1,  294,   -1,  295,  296,   -1,
       297,   -1,  298,   -1,   -1,  299,   -1,  300,
        -1,   -1,  301,   -1,  302,   -1,   -1,  303,
        -1,  304,   -1,   -1,  305,   -1, -952,  -94,
        -2,  308,   -1,  309,   -1,   -1,   -1,   -1,
       310,   -1,   -1,  311,   -1,  312,   -1,   -1,
       313,   -1,  314,   -1,   -1,  315,   -1,  316,
        -1,   -1,  317,   -1,  318,   -1,   -1,  319,
        -1,  320,   -1,   -1,  321,   -1,  322,   -1,
        -1,  323,   -1,  324,   -1,   -1,  325,  326,
       327,   -1,   -1,  328,   -1,  329,  330,   -1,
       331,   -1,  332,   -1,   -1,  333,   -1,  334,
        -1,   -1,   -1,   -1,  335,  336,   -1,  337,
        -1,  338,   -1,   -1,  339,   -1,  340,   -1,
        -1,   -1,   -1,  341,   -1,   -1,  342,   -1,
       343,   -1,   -1,   -1,   -1,  344,   -1,   -1,
        -1,   -1,  345,   -1,   -1,  346,   -1,  347,
        -1,   -1,  348,   -1,  349,   -1,   -1,  350,
        -1,  351,  352,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  353,   -1,   -1,  354,   -1,
       355,   -1,   -1,   -1,   -1,  356,   -1,   -1,
       357,   -1,  358,   -1,   -1,   -1,   -1,  359,
        -1,   -1,   -1,   -1,  360,  361,   -1,   -1,
        -1,  362,   -1,   -1,   -1,   -1,  363,   -1,
        -1,  364,   -1,  365,   -1,   -1,  366,   -1,
       367,   -1,   -1,  368,   -1,   -1,   -1,   -1,
        -1,   -1,  369,   -1,   -1,  370,   -1,  371,
        -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,
        -1,  373,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  374,   -1,  375,   -1,   -1,  376,   -1,
       377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  378,
        -1,   -1,  379,   -1,  380,   -1,   -1,   -1,
        -1,  381,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  382,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  383,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  384,   -1,   -1,
        -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,
       387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  388,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  389,   -1,   -1,   -1,   -1,
       390,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       391,   -1,  392,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  393,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  394,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,
       396,   -1,  397,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  398,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  399
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = gbHash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist[index].name;

              if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
                return &wordlist[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct charHz *wordptr = &wordlist[TOTAL_KEYWORDS + lookup[offset]];
              register const struct charHz *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->name;

                  if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}
