// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// This file was generated by a tool.
// See src/System.Text.Encodings.Web/tools/GenUnicodeRanges

using System.Collections.Generic;

namespace System.Text.Unicode.Tests
{
    public static partial class UnicodeRangesTests
    {
        public static IEnumerable<object[]> UnicodeRanges_GeneratedData => new[]
        {
            new object[] { '\u0000', '\u007F', nameof(UnicodeRanges.BasicLatin) },
            new object[] { '\u0080', '\u00FF', nameof(UnicodeRanges.Latin1Supplement) },
            new object[] { '\u0100', '\u017F', nameof(UnicodeRanges.LatinExtendedA) },
            new object[] { '\u0180', '\u024F', nameof(UnicodeRanges.LatinExtendedB) },
            new object[] { '\u0250', '\u02AF', nameof(UnicodeRanges.IpaExtensions) },
            new object[] { '\u02B0', '\u02FF', nameof(UnicodeRanges.SpacingModifierLetters) },
            new object[] { '\u0300', '\u036F', nameof(UnicodeRanges.CombiningDiacriticalMarks) },
            new object[] { '\u0370', '\u03FF', nameof(UnicodeRanges.GreekandCoptic) },
            new object[] { '\u0400', '\u04FF', nameof(UnicodeRanges.Cyrillic) },
            new object[] { '\u0500', '\u052F', nameof(UnicodeRanges.CyrillicSupplement) },
            new object[] { '\u0530', '\u058F', nameof(UnicodeRanges.Armenian) },
            new object[] { '\u0590', '\u05FF', nameof(UnicodeRanges.Hebrew) },
            new object[] { '\u0600', '\u06FF', nameof(UnicodeRanges.Arabic) },
            new object[] { '\u0700', '\u074F', nameof(UnicodeRanges.Syriac) },
            new object[] { '\u0750', '\u077F', nameof(UnicodeRanges.ArabicSupplement) },
            new object[] { '\u0780', '\u07BF', nameof(UnicodeRanges.Thaana) },
            new object[] { '\u07C0', '\u07FF', nameof(UnicodeRanges.NKo) },
            new object[] { '\u0800', '\u083F', nameof(UnicodeRanges.Samaritan) },
            new object[] { '\u0840', '\u085F', nameof(UnicodeRanges.Mandaic) },
            new object[] { '\u0860', '\u086F', nameof(UnicodeRanges.SyriacSupplement) },
            new object[] { '\u08A0', '\u08FF', nameof(UnicodeRanges.ArabicExtendedA) },
            new object[] { '\u0900', '\u097F', nameof(UnicodeRanges.Devanagari) },
            new object[] { '\u0980', '\u09FF', nameof(UnicodeRanges.Bengali) },
            new object[] { '\u0A00', '\u0A7F', nameof(UnicodeRanges.Gurmukhi) },
            new object[] { '\u0A80', '\u0AFF', nameof(UnicodeRanges.Gujarati) },
            new object[] { '\u0B00', '\u0B7F', nameof(UnicodeRanges.Oriya) },
            new object[] { '\u0B80', '\u0BFF', nameof(UnicodeRanges.Tamil) },
            new object[] { '\u0C00', '\u0C7F', nameof(UnicodeRanges.Telugu) },
            new object[] { '\u0C80', '\u0CFF', nameof(UnicodeRanges.Kannada) },
            new object[] { '\u0D00', '\u0D7F', nameof(UnicodeRanges.Malayalam) },
            new object[] { '\u0D80', '\u0DFF', nameof(UnicodeRanges.Sinhala) },
            new object[] { '\u0E00', '\u0E7F', nameof(UnicodeRanges.Thai) },
            new object[] { '\u0E80', '\u0EFF', nameof(UnicodeRanges.Lao) },
            new object[] { '\u0F00', '\u0FFF', nameof(UnicodeRanges.Tibetan) },
            new object[] { '\u1000', '\u109F', nameof(UnicodeRanges.Myanmar) },
            new object[] { '\u10A0', '\u10FF', nameof(UnicodeRanges.Georgian) },
            new object[] { '\u1100', '\u11FF', nameof(UnicodeRanges.HangulJamo) },
            new object[] { '\u1200', '\u137F', nameof(UnicodeRanges.Ethiopic) },
            new object[] { '\u1380', '\u139F', nameof(UnicodeRanges.EthiopicSupplement) },
            new object[] { '\u13A0', '\u13FF', nameof(UnicodeRanges.Cherokee) },
            new object[] { '\u1400', '\u167F', nameof(UnicodeRanges.UnifiedCanadianAboriginalSyllabics) },
            new object[] { '\u1680', '\u169F', nameof(UnicodeRanges.Ogham) },
            new object[] { '\u16A0', '\u16FF', nameof(UnicodeRanges.Runic) },
            new object[] { '\u1700', '\u171F', nameof(UnicodeRanges.Tagalog) },
            new object[] { '\u1720', '\u173F', nameof(UnicodeRanges.Hanunoo) },
            new object[] { '\u1740', '\u175F', nameof(UnicodeRanges.Buhid) },
            new object[] { '\u1760', '\u177F', nameof(UnicodeRanges.Tagbanwa) },
            new object[] { '\u1780', '\u17FF', nameof(UnicodeRanges.Khmer) },
            new object[] { '\u1800', '\u18AF', nameof(UnicodeRanges.Mongolian) },
            new object[] { '\u18B0', '\u18FF', nameof(UnicodeRanges.UnifiedCanadianAboriginalSyllabicsExtended) },
            new object[] { '\u1900', '\u194F', nameof(UnicodeRanges.Limbu) },
            new object[] { '\u1950', '\u197F', nameof(UnicodeRanges.TaiLe) },
            new object[] { '\u1980', '\u19DF', nameof(UnicodeRanges.NewTaiLue) },
            new object[] { '\u19E0', '\u19FF', nameof(UnicodeRanges.KhmerSymbols) },
            new object[] { '\u1A00', '\u1A1F', nameof(UnicodeRanges.Buginese) },
            new object[] { '\u1A20', '\u1AAF', nameof(UnicodeRanges.TaiTham) },
            new object[] { '\u1AB0', '\u1AFF', nameof(UnicodeRanges.CombiningDiacriticalMarksExtended) },
            new object[] { '\u1B00', '\u1B7F', nameof(UnicodeRanges.Balinese) },
            new object[] { '\u1B80', '\u1BBF', nameof(UnicodeRanges.Sundanese) },
            new object[] { '\u1BC0', '\u1BFF', nameof(UnicodeRanges.Batak) },
            new object[] { '\u1C00', '\u1C4F', nameof(UnicodeRanges.Lepcha) },
            new object[] { '\u1C50', '\u1C7F', nameof(UnicodeRanges.OlChiki) },
            new object[] { '\u1C80', '\u1C8F', nameof(UnicodeRanges.CyrillicExtendedC) },
            new object[] { '\u1C90', '\u1CBF', nameof(UnicodeRanges.GeorgianExtended) },
            new object[] { '\u1CC0', '\u1CCF', nameof(UnicodeRanges.SundaneseSupplement) },
            new object[] { '\u1CD0', '\u1CFF', nameof(UnicodeRanges.VedicExtensions) },
            new object[] { '\u1D00', '\u1D7F', nameof(UnicodeRanges.PhoneticExtensions) },
            new object[] { '\u1D80', '\u1DBF', nameof(UnicodeRanges.PhoneticExtensionsSupplement) },
            new object[] { '\u1DC0', '\u1DFF', nameof(UnicodeRanges.CombiningDiacriticalMarksSupplement) },
            new object[] { '\u1E00', '\u1EFF', nameof(UnicodeRanges.LatinExtendedAdditional) },
            new object[] { '\u1F00', '\u1FFF', nameof(UnicodeRanges.GreekExtended) },
            new object[] { '\u2000', '\u206F', nameof(UnicodeRanges.GeneralPunctuation) },
            new object[] { '\u2070', '\u209F', nameof(UnicodeRanges.SuperscriptsandSubscripts) },
            new object[] { '\u20A0', '\u20CF', nameof(UnicodeRanges.CurrencySymbols) },
            new object[] { '\u20D0', '\u20FF', nameof(UnicodeRanges.CombiningDiacriticalMarksforSymbols) },
            new object[] { '\u2100', '\u214F', nameof(UnicodeRanges.LetterlikeSymbols) },
            new object[] { '\u2150', '\u218F', nameof(UnicodeRanges.NumberForms) },
            new object[] { '\u2190', '\u21FF', nameof(UnicodeRanges.Arrows) },
            new object[] { '\u2200', '\u22FF', nameof(UnicodeRanges.MathematicalOperators) },
            new object[] { '\u2300', '\u23FF', nameof(UnicodeRanges.MiscellaneousTechnical) },
            new object[] { '\u2400', '\u243F', nameof(UnicodeRanges.ControlPictures) },
            new object[] { '\u2440', '\u245F', nameof(UnicodeRanges.OpticalCharacterRecognition) },
            new object[] { '\u2460', '\u24FF', nameof(UnicodeRanges.EnclosedAlphanumerics) },
            new object[] { '\u2500', '\u257F', nameof(UnicodeRanges.BoxDrawing) },
            new object[] { '\u2580', '\u259F', nameof(UnicodeRanges.BlockElements) },
            new object[] { '\u25A0', '\u25FF', nameof(UnicodeRanges.GeometricShapes) },
            new object[] { '\u2600', '\u26FF', nameof(UnicodeRanges.MiscellaneousSymbols) },
            new object[] { '\u2700', '\u27BF', nameof(UnicodeRanges.Dingbats) },
            new object[] { '\u27C0', '\u27EF', nameof(UnicodeRanges.MiscellaneousMathematicalSymbolsA) },
            new object[] { '\u27F0', '\u27FF', nameof(UnicodeRanges.SupplementalArrowsA) },
            new object[] { '\u2800', '\u28FF', nameof(UnicodeRanges.BraillePatterns) },
            new object[] { '\u2900', '\u297F', nameof(UnicodeRanges.SupplementalArrowsB) },
            new object[] { '\u2980', '\u29FF', nameof(UnicodeRanges.MiscellaneousMathematicalSymbolsB) },
            new object[] { '\u2A00', '\u2AFF', nameof(UnicodeRanges.SupplementalMathematicalOperators) },
            new object[] { '\u2B00', '\u2BFF', nameof(UnicodeRanges.MiscellaneousSymbolsandArrows) },
            new object[] { '\u2C00', '\u2C5F', nameof(UnicodeRanges.Glagolitic) },
            new object[] { '\u2C60', '\u2C7F', nameof(UnicodeRanges.LatinExtendedC) },
            new object[] { '\u2C80', '\u2CFF', nameof(UnicodeRanges.Coptic) },
            new object[] { '\u2D00', '\u2D2F', nameof(UnicodeRanges.GeorgianSupplement) },
            new object[] { '\u2D30', '\u2D7F', nameof(UnicodeRanges.Tifinagh) },
            new object[] { '\u2D80', '\u2DDF', nameof(UnicodeRanges.EthiopicExtended) },
            new object[] { '\u2DE0', '\u2DFF', nameof(UnicodeRanges.CyrillicExtendedA) },
            new object[] { '\u2E00', '\u2E7F', nameof(UnicodeRanges.SupplementalPunctuation) },
            new object[] { '\u2E80', '\u2EFF', nameof(UnicodeRanges.CjkRadicalsSupplement) },
            new object[] { '\u2F00', '\u2FDF', nameof(UnicodeRanges.KangxiRadicals) },
            new object[] { '\u2FF0', '\u2FFF', nameof(UnicodeRanges.IdeographicDescriptionCharacters) },
            new object[] { '\u3000', '\u303F', nameof(UnicodeRanges.CjkSymbolsandPunctuation) },
            new object[] { '\u3040', '\u309F', nameof(UnicodeRanges.Hiragana) },
            new object[] { '\u30A0', '\u30FF', nameof(UnicodeRanges.Katakana) },
            new object[] { '\u3100', '\u312F', nameof(UnicodeRanges.Bopomofo) },
            new object[] { '\u3130', '\u318F', nameof(UnicodeRanges.HangulCompatibilityJamo) },
            new object[] { '\u3190', '\u319F', nameof(UnicodeRanges.Kanbun) },
            new object[] { '\u31A0', '\u31BF', nameof(UnicodeRanges.BopomofoExtended) },
            new object[] { '\u31C0', '\u31EF', nameof(UnicodeRanges.CjkStrokes) },
            new object[] { '\u31F0', '\u31FF', nameof(UnicodeRanges.KatakanaPhoneticExtensions) },
            new object[] { '\u3200', '\u32FF', nameof(UnicodeRanges.EnclosedCjkLettersandMonths) },
            new object[] { '\u3300', '\u33FF', nameof(UnicodeRanges.CjkCompatibility) },
            new object[] { '\u3400', '\u4DBF', nameof(UnicodeRanges.CjkUnifiedIdeographsExtensionA) },
            new object[] { '\u4DC0', '\u4DFF', nameof(UnicodeRanges.YijingHexagramSymbols) },
            new object[] { '\u4E00', '\u9FFF', nameof(UnicodeRanges.CjkUnifiedIdeographs) },
            new object[] { '\uA000', '\uA48F', nameof(UnicodeRanges.YiSyllables) },
            new object[] { '\uA490', '\uA4CF', nameof(UnicodeRanges.YiRadicals) },
            new object[] { '\uA4D0', '\uA4FF', nameof(UnicodeRanges.Lisu) },
            new object[] { '\uA500', '\uA63F', nameof(UnicodeRanges.Vai) },
            new object[] { '\uA640', '\uA69F', nameof(UnicodeRanges.CyrillicExtendedB) },
            new object[] { '\uA6A0', '\uA6FF', nameof(UnicodeRanges.Bamum) },
            new object[] { '\uA700', '\uA71F', nameof(UnicodeRanges.ModifierToneLetters) },
            new object[] { '\uA720', '\uA7FF', nameof(UnicodeRanges.LatinExtendedD) },
            new object[] { '\uA800', '\uA82F', nameof(UnicodeRanges.SylotiNagri) },
            new object[] { '\uA830', '\uA83F', nameof(UnicodeRanges.CommonIndicNumberForms) },
            new object[] { '\uA840', '\uA87F', nameof(UnicodeRanges.Phagspa) },
            new object[] { '\uA880', '\uA8DF', nameof(UnicodeRanges.Saurashtra) },
            new object[] { '\uA8E0', '\uA8FF', nameof(UnicodeRanges.DevanagariExtended) },
            new object[] { '\uA900', '\uA92F', nameof(UnicodeRanges.KayahLi) },
            new object[] { '\uA930', '\uA95F', nameof(UnicodeRanges.Rejang) },
            new object[] { '\uA960', '\uA97F', nameof(UnicodeRanges.HangulJamoExtendedA) },
            new object[] { '\uA980', '\uA9DF', nameof(UnicodeRanges.Javanese) },
            new object[] { '\uA9E0', '\uA9FF', nameof(UnicodeRanges.MyanmarExtendedB) },
            new object[] { '\uAA00', '\uAA5F', nameof(UnicodeRanges.Cham) },
            new object[] { '\uAA60', '\uAA7F', nameof(UnicodeRanges.MyanmarExtendedA) },
            new object[] { '\uAA80', '\uAADF', nameof(UnicodeRanges.TaiViet) },
            new object[] { '\uAAE0', '\uAAFF', nameof(UnicodeRanges.MeeteiMayekExtensions) },
            new object[] { '\uAB00', '\uAB2F', nameof(UnicodeRanges.EthiopicExtendedA) },
            new object[] { '\uAB30', '\uAB6F', nameof(UnicodeRanges.LatinExtendedE) },
            new object[] { '\uAB70', '\uABBF', nameof(UnicodeRanges.CherokeeSupplement) },
            new object[] { '\uABC0', '\uABFF', nameof(UnicodeRanges.MeeteiMayek) },
            new object[] { '\uAC00', '\uD7AF', nameof(UnicodeRanges.HangulSyllables) },
            new object[] { '\uD7B0', '\uD7FF', nameof(UnicodeRanges.HangulJamoExtendedB) },
            new object[] { '\uF900', '\uFAFF', nameof(UnicodeRanges.CjkCompatibilityIdeographs) },
            new object[] { '\uFB00', '\uFB4F', nameof(UnicodeRanges.AlphabeticPresentationForms) },
            new object[] { '\uFB50', '\uFDFF', nameof(UnicodeRanges.ArabicPresentationFormsA) },
            new object[] { '\uFE00', '\uFE0F', nameof(UnicodeRanges.VariationSelectors) },
            new object[] { '\uFE10', '\uFE1F', nameof(UnicodeRanges.VerticalForms) },
            new object[] { '\uFE20', '\uFE2F', nameof(UnicodeRanges.CombiningHalfMarks) },
            new object[] { '\uFE30', '\uFE4F', nameof(UnicodeRanges.CjkCompatibilityForms) },
            new object[] { '\uFE50', '\uFE6F', nameof(UnicodeRanges.SmallFormVariants) },
            new object[] { '\uFE70', '\uFEFF', nameof(UnicodeRanges.ArabicPresentationFormsB) },
            new object[] { '\uFF00', '\uFFEF', nameof(UnicodeRanges.HalfwidthandFullwidthForms) },
            new object[] { '\uFFF0', '\uFFFF', nameof(UnicodeRanges.Specials) },
        };
    }
}
