/* math-history.c generated by valac 0.40.6, the Vala compiler
 * generated from math-history.vala, do not modify */

/*
 * Copyright (C) 2014 ELITA ASTRID ANGELINA LOBO
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
*/


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "libcalculator.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;
typedef struct _HistoryViewPrivate HistoryViewPrivate;
enum  {
	HISTORY_VIEW_0_PROPERTY,
	HISTORY_VIEW_NUM_PROPERTIES
};
static GParamSpec* history_view_properties[HISTORY_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
enum  {
	HISTORY_VIEW_ANSWER_CLICKED_SIGNAL,
	HISTORY_VIEW_EQUATION_CLICKED_SIGNAL,
	HISTORY_VIEW_ROW_ADDED_SIGNAL,
	HISTORY_VIEW_NUM_SIGNALS
};
static guint history_view_signals[HISTORY_VIEW_NUM_SIGNALS] = {0};
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
enum  {
	HISTORY_ENTRY_0_PROPERTY,
	HISTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* history_entry_properties[HISTORY_ENTRY_NUM_PROPERTIES];
enum  {
	HISTORY_ENTRY_ANSWER_CLICKED_SIGNAL,
	HISTORY_ENTRY_EQUATION_CLICKED_SIGNAL,
	HISTORY_ENTRY_NUM_SIGNALS
};
static guint history_entry_signals[HISTORY_ENTRY_NUM_SIGNALS] = {0};

struct _HistoryView {
	GtkScrolledWindow parent_instance;
	HistoryViewPrivate * priv;
};

struct _HistoryViewClass {
	GtkScrolledWindowClass parent_class;
};

struct _HistoryViewPrivate {
	gchar* last_answer;
	gchar* last_equation;
	Serializer* serializer_four;
	Serializer* serializer_nine;
	GtkListBox* listbox;
};

struct _HistoryEntry {
	GtkListBoxRow parent_instance;
	HistoryEntryPrivate * priv;
};

struct _HistoryEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _HistoryEntryPrivate {
	GtkLabel* equation_label;
	GtkLabel* answer_label;
};


static gpointer history_view_parent_class = NULL;
static gpointer history_entry_parent_class = NULL;

GType history_view_get_type (void) G_GNUC_CONST;
#define HISTORY_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY_VIEW, HistoryViewPrivate))
void history_view_scroll_bottom (HistoryView* self);
static void _history_view_scroll_bottom_history_view_row_added (HistoryView* _sender,
                                                         gpointer self);
void history_view_insert_entry (HistoryView* self,
                                const gchar* equation,
                                Number* answer,
                                gint number_base,
                                guint representation_base);
GType history_entry_get_type (void) G_GNUC_CONST;
HistoryEntry* history_entry_new (const gchar* equation,
                                 const gchar* answer_four_digits,
                                 const gchar* answer_nine_digits);
HistoryEntry* history_entry_construct (GType object_type,
                                       const gchar* equation,
                                       const gchar* answer_four_digits,
                                       const gchar* answer_nine_digits);
static void __lambda4_ (HistoryView* self,
                 const gchar* ans);
static void ___lambda4__history_entry_answer_clicked (HistoryEntry* _sender,
                                               const gchar* ans,
                                               gpointer self);
static void __lambda5_ (HistoryView* self,
                 const gchar* eq);
static void ___lambda5__history_entry_equation_clicked (HistoryEntry* _sender,
                                                 const gchar* equation,
                                                 gpointer self);
void history_view_clear (HistoryView* self);
static void __lambda6_ (HistoryView* self,
                 GtkWidget* child);
static void ___lambda6__gtk_callback (GtkWidget* widget,
                               gpointer self);
HistoryView* history_view_new (void);
HistoryView* history_view_construct (GType object_type);
static void history_view_finalize (GObject * obj);
#define HISTORY_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY_ENTRY, HistoryEntryPrivate))
gboolean history_entry_answer_clicked_cb (HistoryEntry* self,
                                          GtkWidget* widget,
                                          GdkEventButton* eventbutton);
static gboolean _history_entry_answer_clicked_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
static gboolean history_entry_equation_clicked_cb (HistoryEntry* self,
                                            GtkWidget* widget,
                                            GdkEventButton* eventbutton);
static gboolean _history_entry_equation_clicked_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self);
static void history_entry_finalize (GObject * obj);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
history_view_scroll_bottom (HistoryView* self)
{
	GtkAdjustment* adjustment = NULL;
	GtkListBox* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_adjustment (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	adjustment = _tmp2_;
	gtk_widget_get_size_request ((GtkWidget*) self, &_tmp3_, &_tmp4_);
	width = _tmp3_;
	height = _tmp4_;
	gtk_adjustment_set_page_size (adjustment, (gdouble) (height / 3));
	gtk_adjustment_set_value (adjustment, gtk_adjustment_get_upper (adjustment) - gtk_adjustment_get_page_size (adjustment));
	_g_object_unref0 (adjustment);
}


static void
_history_view_scroll_bottom_history_view_row_added (HistoryView* _sender,
                                                    gpointer self)
{
	history_view_scroll_bottom ((HistoryView*) self);
}


static void
__lambda4_ (HistoryView* self,
            const gchar* ans)
{
	g_return_if_fail (ans != NULL);
	g_signal_emit (self, history_view_signals[HISTORY_VIEW_ANSWER_CLICKED_SIGNAL], 0, ans);
}


static void
___lambda4__history_entry_answer_clicked (HistoryEntry* _sender,
                                          const gchar* ans,
                                          gpointer self)
{
	__lambda4_ ((HistoryView*) self, ans);
}


static void
__lambda5_ (HistoryView* self,
            const gchar* eq)
{
	g_return_if_fail (eq != NULL);
	g_signal_emit (self, history_view_signals[HISTORY_VIEW_EQUATION_CLICKED_SIGNAL], 0, eq);
}


static void
___lambda5__history_entry_equation_clicked (HistoryEntry* _sender,
                                            const gchar* equation,
                                            gpointer self)
{
	__lambda5_ ((HistoryView*) self, equation);
}


void
history_view_insert_entry (HistoryView* self,
                           const gchar* equation,
                           Number* answer,
                           gint number_base,
                           guint representation_base)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	gchar* answer_nine_digits = NULL;
	Serializer* _tmp4_;
	gchar* _tmp5_;
	gchar* answer_four_digits = NULL;
	Serializer* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	HistoryEntry* entry = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	HistoryEntry* _tmp14_;
	GtkListBox* _tmp15_;
	HistoryEntry* _tmp16_;
	HistoryEntry* _tmp17_;
	HistoryEntry* _tmp18_;
	HistoryEntry* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (equation != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = self->priv->serializer_four;
	serializer_set_base (_tmp0_, number_base);
	_tmp1_ = self->priv->serializer_nine;
	serializer_set_base (_tmp1_, number_base);
	_tmp2_ = self->priv->serializer_four;
	serializer_set_representation_base (_tmp2_, representation_base);
	_tmp3_ = self->priv->serializer_nine;
	serializer_set_representation_base (_tmp3_, representation_base);
	_tmp4_ = self->priv->serializer_nine;
	_tmp5_ = serializer_to_string (_tmp4_, answer);
	answer_nine_digits = _tmp5_;
	_tmp6_ = self->priv->serializer_four;
	_tmp7_ = serializer_to_string (_tmp6_, answer);
	answer_four_digits = _tmp7_;
	_tmp9_ = self->priv->last_answer;
	_tmp10_ = answer_nine_digits;
	if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
		const gchar* _tmp11_;
		_tmp11_ = self->priv->last_equation;
		_tmp8_ = g_strcmp0 (_tmp11_, equation) == 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_g_free0 (answer_four_digits);
		_g_free0 (answer_nine_digits);
		return;
	}
	_tmp12_ = answer_four_digits;
	_tmp13_ = answer_nine_digits;
	_tmp14_ = history_entry_new (equation, _tmp12_, _tmp13_);
	g_object_ref_sink (_tmp14_);
	entry = _tmp14_;
	_tmp15_ = self->priv->listbox;
	_tmp16_ = entry;
	gtk_list_box_insert (_tmp15_, (GtkWidget*) _tmp16_, -1);
	_tmp17_ = entry;
	gtk_widget_show ((GtkWidget*) _tmp17_);
	_tmp18_ = entry;
	g_signal_connect_object (_tmp18_, "answer-clicked", (GCallback) ___lambda4__history_entry_answer_clicked, self, 0);
	_tmp19_ = entry;
	g_signal_connect_object (_tmp19_, "equation-clicked", (GCallback) ___lambda5__history_entry_equation_clicked, self, 0);
	_tmp20_ = answer_nine_digits;
	_tmp21_ = g_strdup (_tmp20_);
	_g_free0 (self->priv->last_answer);
	self->priv->last_answer = _tmp21_;
	_tmp22_ = g_strdup (equation);
	_g_free0 (self->priv->last_equation);
	self->priv->last_equation = _tmp22_;
	g_signal_emit (self, history_view_signals[HISTORY_VIEW_ROW_ADDED_SIGNAL], 0);
	_g_object_unref0 (entry);
	_g_free0 (answer_four_digits);
	_g_free0 (answer_nine_digits);
}


static void
__lambda6_ (HistoryView* self,
            GtkWidget* child)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->listbox;
	gtk_container_remove ((GtkContainer*) _tmp0_, child);
}


static void
___lambda6__gtk_callback (GtkWidget* widget,
                          gpointer self)
{
	__lambda6_ ((HistoryView*) self, widget);
}


void
history_view_clear (HistoryView* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	gtk_container_foreach ((GtkContainer*) _tmp0_, ___lambda6__gtk_callback, self);
}


HistoryView*
history_view_construct (GType object_type)
{
	HistoryView * self = NULL;
	self = (HistoryView*) g_object_new (object_type, NULL);
	return self;
}


HistoryView*
history_view_new (void)
{
	return history_view_construct (TYPE_HISTORY_VIEW);
}


static void
history_view_class_init (HistoryViewClass * klass)
{
	gint HistoryView_private_offset;
	history_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (HistoryViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = history_view_finalize;
	HistoryView_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/history-view.ui");
	history_view_signals[HISTORY_VIEW_ANSWER_CLICKED_SIGNAL] = g_signal_new ("answer-clicked", TYPE_HISTORY_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	history_view_signals[HISTORY_VIEW_EQUATION_CLICKED_SIGNAL] = g_signal_new ("equation-clicked", TYPE_HISTORY_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	history_view_signals[HISTORY_VIEW_ROW_ADDED_SIGNAL] = g_signal_new ("row-added", TYPE_HISTORY_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, HistoryView_private_offset + G_STRUCT_OFFSET (HistoryViewPrivate, listbox));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scroll_bottom", G_CALLBACK(_history_view_scroll_bottom_history_view_row_added));
}


static void
history_view_instance_init (HistoryView * self)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	self->priv = HISTORY_VIEW_GET_PRIVATE (self);
	self->priv->last_answer = NULL;
	self->priv->last_equation = NULL;
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 4);
	self->priv->serializer_four = _tmp0_;
	_tmp1_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	self->priv->serializer_nine = _tmp1_;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
history_view_finalize (GObject * obj)
{
	HistoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_VIEW, HistoryView);
	_g_free0 (self->priv->last_answer);
	_g_free0 (self->priv->last_equation);
	_g_object_unref0 (self->priv->serializer_four);
	_g_object_unref0 (self->priv->serializer_nine);
	_g_object_unref0 (self->priv->listbox);
	G_OBJECT_CLASS (history_view_parent_class)->finalize (obj);
}


GType
history_view_get_type (void)
{
	static volatile gsize history_view_type_id__volatile = 0;
	if (g_once_init_enter (&history_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HistoryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryView), 0, (GInstanceInitFunc) history_view_instance_init, NULL };
		GType history_view_type_id;
		history_view_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "HistoryView", &g_define_type_info, 0);
		g_once_init_leave (&history_view_type_id__volatile, history_view_type_id);
	}
	return history_view_type_id__volatile;
}


HistoryEntry*
history_entry_construct (GType object_type,
                         const gchar* equation,
                         const gchar* answer_four_digits,
                         const gchar* answer_nine_digits)
{
	HistoryEntry * self = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (answer_four_digits != NULL, NULL);
	g_return_val_if_fail (answer_nine_digits != NULL, NULL);
	self = (HistoryEntry*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->equation_label;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, equation);
	_tmp1_ = self->priv->answer_label;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, answer_nine_digits);
	_tmp2_ = self->priv->equation_label;
	gtk_label_set_text (_tmp2_, equation);
	_tmp3_ = self->priv->answer_label;
	gtk_label_set_text (_tmp3_, answer_four_digits);
	return self;
}


HistoryEntry*
history_entry_new (const gchar* equation,
                   const gchar* answer_four_digits,
                   const gchar* answer_nine_digits)
{
	return history_entry_construct (TYPE_HISTORY_ENTRY, equation, answer_four_digits, answer_nine_digits);
}


gboolean
history_entry_answer_clicked_cb (HistoryEntry* self,
                                 GtkWidget* widget,
                                 GdkEventButton* eventbutton)
{
	gboolean result = FALSE;
	gchar* answer = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (eventbutton != NULL, FALSE);
	_tmp0_ = self->priv->answer_label;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	answer = _tmp2_;
	_tmp3_ = answer;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = answer;
		g_signal_emit (self, history_entry_signals[HISTORY_ENTRY_ANSWER_CLICKED_SIGNAL], 0, _tmp4_);
	}
	result = TRUE;
	_g_free0 (answer);
	return result;
}


static gboolean
_history_entry_answer_clicked_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = history_entry_answer_clicked_cb ((HistoryEntry*) self, _sender, event);
	return result;
}


static gboolean
history_entry_equation_clicked_cb (HistoryEntry* self,
                                   GtkWidget* widget,
                                   GdkEventButton* eventbutton)
{
	gboolean result = FALSE;
	gchar* equation = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (eventbutton != NULL, FALSE);
	_tmp0_ = self->priv->equation_label;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	equation = _tmp2_;
	_tmp3_ = equation;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = equation;
		g_signal_emit (self, history_entry_signals[HISTORY_ENTRY_EQUATION_CLICKED_SIGNAL], 0, _tmp4_);
	}
	result = TRUE;
	_g_free0 (equation);
	return result;
}


static gboolean
_history_entry_equation_clicked_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
	gboolean result;
	result = history_entry_equation_clicked_cb ((HistoryEntry*) self, _sender, event);
	return result;
}


static void
history_entry_class_init (HistoryEntryClass * klass)
{
	gint HistoryEntry_private_offset;
	history_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (HistoryEntryPrivate));
	G_OBJECT_CLASS (klass)->finalize = history_entry_finalize;
	HistoryEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/history-entry.ui");
	history_entry_signals[HISTORY_ENTRY_ANSWER_CLICKED_SIGNAL] = g_signal_new ("answer-clicked", TYPE_HISTORY_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	history_entry_signals[HISTORY_ENTRY_EQUATION_CLICKED_SIGNAL] = g_signal_new ("equation-clicked", TYPE_HISTORY_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "equation_label", FALSE, HistoryEntry_private_offset + G_STRUCT_OFFSET (HistoryEntryPrivate, equation_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "answer_label", FALSE, HistoryEntry_private_offset + G_STRUCT_OFFSET (HistoryEntryPrivate, answer_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "answer_clicked_cb", G_CALLBACK(_history_entry_answer_clicked_cb_gtk_widget_button_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "equation_clicked_cb", G_CALLBACK(_history_entry_equation_clicked_cb_gtk_widget_button_press_event));
}


static void
history_entry_instance_init (HistoryEntry * self)
{
	self->priv = HISTORY_ENTRY_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
history_entry_finalize (GObject * obj)
{
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_ENTRY, HistoryEntry);
	_g_object_unref0 (self->priv->equation_label);
	_g_object_unref0 (self->priv->answer_label);
	G_OBJECT_CLASS (history_entry_parent_class)->finalize (obj);
}


GType
history_entry_get_type (void)
{
	static volatile gsize history_entry_type_id__volatile = 0;
	if (g_once_init_enter (&history_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HistoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryEntry), 0, (GInstanceInitFunc) history_entry_instance_init, NULL };
		GType history_entry_type_id;
		history_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "HistoryEntry", &g_define_type_info, 0);
		g_once_init_leave (&history_entry_type_id__volatile, history_entry_type_id);
	}
	return history_entry_type_id__volatile;
}



