/* test-number.c generated by valac 0.40.6, the Vala compiler
 * generated from test-number.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "libcalculator.h"
#include <float.h>
#include <math.h>
#include <locale.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

void pass (const gchar* text);
void fail (const gchar* text);
void test_integer (void);
void test_unsigned_integer (void);
void test_fraction (void);
gboolean double_matches (Number* a,
                         gdouble b);
void test_double (void);
void test_complex (void);
void test_polar (void);
void test_i (void);
void test_pi (void);
void test_eulers (void);
void test_string (void);
void test_sgn (void);
void test_invert_sign (void);
void test_abs (void);
void test_arg (void);
void test_conjugate (void);
void test_real_component (void);
void test_imaginary_component (void);
gchar* double_string (gdouble x);
void test_integer_component (void);
void test_fractional_component (void);
void test_fractional_part (void);
void test_floor (void);
void test_ceiling (void);
void test_round (void);
void test_reciprocal (void);
void test_epowy (void);
void test_xpowy (void);
void test_xpowy_integer (void);
void test_root3 (void);
void test_sqrt (void);
void test_ln (void);
void test_logarithm2 (void);
void test_logarithm10 (void);
void test_is_zero (void);
void test_is_negative (void);
void test_is_integer (void);
void test_is_positive_integer (void);
void test_is_natural (void);
void test_is_complex (void);
void test_factorial (void);
void test_add (void);
void test_subtract (void);
void test_multiply (void);
void test_multiply_integer (void);
void test_divide (void);
void test_divide_integer (void);
void test_modulus_divide (void);
void test_sin (void);
void test_cos (void);
void test_and (void);
void test_or (void);
void test_xor (void);
void test_not (void);
void test_shift (void);
void test_factorize (void);
GList* factorize (gint number);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
gint _vala_main (gchar** args,
                 int args_length1);


void
pass (const gchar* text)
{
	gint _tmp0_;
	_tmp0_ = pass_count;
	pass_count = _tmp0_ + 1;
}


void
fail (const gchar* text)
{
	FILE* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "*FAIL: %s\n", text);
	_tmp1_ = fail_count;
	fail_count = _tmp1_ + 1;
}


void
test_integer (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				_tmp5_ = z;
				_tmp6_ = a;
				if (number_to_integer (_tmp5_) != ((gint64) _tmp6_)) {
					gint _tmp7_;
					Number* _tmp8_;
					gint _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp7_ = a;
					_tmp8_ = z;
					_tmp9_ = a;
					_tmp10_ = g_strdup_printf ("Number.integer (%d).to_integer () -> %lli, expected %i", _tmp7_, number_to_integer (_tmp8_), _tmp9_);
					_tmp11_ = _tmp10_;
					fail (_tmp11_);
					_g_free0 (_tmp11_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_unsigned_integer (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_unsigned_integer ((guint64) _tmp3_, (guint64) 0);
				z = _tmp4_;
				_tmp5_ = z;
				_tmp6_ = a;
				if (number_to_unsigned_integer (_tmp5_) != ((guint64) _tmp6_)) {
					gint _tmp7_;
					Number* _tmp8_;
					gint _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp7_ = a;
					_tmp8_ = z;
					_tmp9_ = a;
					_tmp10_ = g_strdup_printf ("Number.unsigned_integer (%d).to_unsigned_integer () -> %i, expected %i", _tmp7_, (gint) number_to_unsigned_integer (_tmp8_), _tmp9_);
					_tmp11_ = _tmp10_;
					fail (_tmp11_);
					_g_free0 (_tmp11_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_fraction (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = 1;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							gint _tmp7_;
							Number* _tmp8_;
							gdouble expected = 0.0;
							gint _tmp9_;
							gint _tmp10_;
							Number* _tmp11_;
							gdouble _tmp12_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = b;
							_tmp8_ = number_new_fraction ((gint64) _tmp6_, (gint64) _tmp7_);
							z = _tmp8_;
							_tmp9_ = a;
							_tmp10_ = b;
							expected = ((gdouble) _tmp9_) / _tmp10_;
							_tmp11_ = z;
							_tmp12_ = expected;
							if (!double_matches (_tmp11_, _tmp12_)) {
								gint _tmp13_;
								gint _tmp14_;
								Number* _tmp15_;
								gdouble _tmp16_;
								gchar* _tmp17_;
								gchar* _tmp18_;
								_tmp13_ = a;
								_tmp14_ = b;
								_tmp15_ = z;
								_tmp16_ = expected;
								_tmp17_ = g_strdup_printf ("Number.fraction (%d, %d) -> %f, expected %f", _tmp13_, _tmp14_, number_to_double (_tmp15_), _tmp16_);
								_tmp18_ = _tmp17_;
								fail (_tmp18_);
								_g_free0 (_tmp18_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_double (void)
{
	{
		gdouble a = 0.0;
		a = -10.0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_;
				Number* z = NULL;
				gdouble _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				gdouble _tmp6_;
				if (!_tmp0_) {
					gdouble _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 0.5;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10.0)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double (_tmp3_, (gdouble) 0);
				z = _tmp4_;
				_tmp5_ = z;
				_tmp6_ = a;
				if (number_to_double (_tmp5_) != _tmp6_) {
					gdouble _tmp7_;
					Number* _tmp8_;
					gdouble _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp7_ = a;
					_tmp8_ = z;
					_tmp9_ = a;
					_tmp10_ = g_strdup_printf ("Number.double (%f).to_double () -> %f, expected %f", _tmp7_, number_to_double (_tmp8_), _tmp9_);
					_tmp11_ = _tmp10_;
					fail (_tmp11_);
					_g_free0 (_tmp11_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_complex (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint re_expected = 0;
							gint _tmp14_;
							gint im_expected = 0;
							gint _tmp15_;
							gboolean _tmp16_ = FALSE;
							Number* _tmp17_;
							Number* _tmp18_;
							Number* _tmp19_;
							gint _tmp20_;
							gboolean _tmp21_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							re_expected = _tmp14_;
							_tmp15_ = b;
							im_expected = _tmp15_;
							_tmp17_ = z;
							_tmp18_ = number_real_component (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = re_expected;
							_tmp21_ = number_to_integer (_tmp19_) != ((gint64) _tmp20_);
							_g_object_unref0 (_tmp19_);
							if (_tmp21_) {
								_tmp16_ = TRUE;
							} else {
								Number* _tmp22_;
								Number* _tmp23_;
								Number* _tmp24_;
								gint _tmp25_;
								_tmp22_ = z;
								_tmp23_ = number_imaginary_component (_tmp22_);
								_tmp24_ = _tmp23_;
								_tmp25_ = im_expected;
								_tmp16_ = number_to_integer (_tmp24_) != ((gint64) _tmp25_);
								_g_object_unref0 (_tmp24_);
							}
							if (_tmp16_) {
								gint _tmp26_;
								gint _tmp27_;
								Number* _tmp28_;
								Number* _tmp29_;
								Number* _tmp30_;
								Number* _tmp31_;
								Number* _tmp32_;
								Number* _tmp33_;
								gint _tmp34_;
								gint _tmp35_;
								gchar* _tmp36_;
								gchar* _tmp37_;
								_tmp26_ = a;
								_tmp27_ = b;
								_tmp28_ = z;
								_tmp29_ = number_real_component (_tmp28_);
								_tmp30_ = _tmp29_;
								_tmp31_ = z;
								_tmp32_ = number_imaginary_component (_tmp31_);
								_tmp33_ = _tmp32_;
								_tmp34_ = re_expected;
								_tmp35_ = im_expected;
								_tmp36_ = g_strdup_printf ("Number.complex (%d%+di) -> %d%+di, expected %d%+di", _tmp26_, _tmp27_, (gint) number_to_integer (_tmp30_), (gint) number_to_integer (_tmp33_), _tmp34_, _tmp35_);
								_tmp37_ = _tmp36_;
								fail (_tmp37_);
								_g_free0 (_tmp37_);
								_g_object_unref0 (_tmp33_);
								_g_object_unref0 (_tmp30_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void
test_polar (void)
{
	{
		gint ri = 0;
		ri = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ri;
					ri = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ri;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint theta_i = 0;
					theta_i = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gdouble r = 0.0;
							gint _tmp6_;
							gdouble theta = 0.0;
							gint _tmp7_;
							Number* z = NULL;
							gdouble _tmp8_;
							Number* _tmp9_;
							Number* _tmp10_;
							gdouble _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							Number* _tmp14_;
							Number* _tmp15_;
							gdouble re_expected = 0.0;
							gdouble _tmp16_;
							gdouble _tmp17_;
							gdouble im_expected = 0.0;
							gdouble _tmp18_;
							gdouble _tmp19_;
							gboolean _tmp20_ = FALSE;
							Number* _tmp21_;
							Number* _tmp22_;
							Number* _tmp23_;
							gdouble _tmp24_;
							gboolean _tmp25_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = theta_i;
								theta_i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = theta_i;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = ri;
							r = (gdouble) _tmp6_;
							_tmp7_ = theta_i;
							theta = ((2 * G_PI) * _tmp7_) / 10.0;
							_tmp8_ = r;
							_tmp9_ = number_new_double (_tmp8_, (gdouble) 0);
							_tmp10_ = _tmp9_;
							_tmp11_ = theta;
							_tmp12_ = number_new_double (_tmp11_, (gdouble) 0);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_polar (_tmp10_, _tmp13_, ANGLE_UNIT_RADIANS);
							_tmp15_ = _tmp14_;
							_g_object_unref0 (_tmp13_);
							_g_object_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = r;
							_tmp17_ = theta;
							re_expected = _tmp16_ * cos (_tmp17_);
							_tmp18_ = r;
							_tmp19_ = theta;
							im_expected = _tmp18_ * sin (_tmp19_);
							_tmp21_ = z;
							_tmp22_ = number_real_component (_tmp21_);
							_tmp23_ = _tmp22_;
							_tmp24_ = re_expected;
							_tmp25_ = !double_matches (_tmp23_, _tmp24_);
							_g_object_unref0 (_tmp23_);
							if (_tmp25_) {
								_tmp20_ = TRUE;
							} else {
								Number* _tmp26_;
								Number* _tmp27_;
								Number* _tmp28_;
								gdouble _tmp29_;
								_tmp26_ = z;
								_tmp27_ = number_imaginary_component (_tmp26_);
								_tmp28_ = _tmp27_;
								_tmp29_ = im_expected;
								_tmp20_ = !double_matches (_tmp28_, _tmp29_);
								_g_object_unref0 (_tmp28_);
							}
							if (_tmp20_) {
								gdouble _tmp30_;
								gdouble _tmp31_;
								Number* _tmp32_;
								Number* _tmp33_;
								Number* _tmp34_;
								Number* _tmp35_;
								Number* _tmp36_;
								Number* _tmp37_;
								gdouble _tmp38_;
								gdouble _tmp39_;
								gchar* _tmp40_;
								gchar* _tmp41_;
								_tmp30_ = r;
								_tmp31_ = theta;
								_tmp32_ = z;
								_tmp33_ = number_real_component (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = z;
								_tmp36_ = number_imaginary_component (_tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = re_expected;
								_tmp39_ = im_expected;
								_tmp40_ = g_strdup_printf ("Number.polar (%f, %f) -> %f%+fi, expected %f%+fi", _tmp30_, _tmp31_, number_to_double (_tmp34_), number_to_double (_tmp37_), _tmp38_, _tmp39_);
								_tmp41_ = _tmp40_;
								fail (_tmp41_);
								_g_free0 (_tmp41_);
								_g_object_unref0 (_tmp37_);
								_g_object_unref0 (_tmp34_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void
test_i (void)
{
	Number* z = NULL;
	Number* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = number_new_i ();
	z = _tmp0_;
	_tmp2_ = z;
	_tmp3_ = number_real_component (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_to_integer (_tmp4_) != ((gint64) 0);
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		_tmp6_ = z;
		_tmp7_ = number_imaginary_component (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = number_to_integer (_tmp8_) != ((gint64) 1);
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Number* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		Number* _tmp12_;
		Number* _tmp13_;
		Number* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp9_ = z;
		_tmp10_ = number_real_component (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = z;
		_tmp13_ = number_imaginary_component (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("Number.i () -> %d%+di, expected i", (gint) number_to_integer (_tmp11_), (gint) number_to_integer (_tmp14_));
		_tmp16_ = _tmp15_;
		fail (_tmp16_);
		_g_free0 (_tmp16_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (z);
		return;
	}
	pass (NULL);
	_g_object_unref0 (z);
}


void
test_pi (void)
{
	Number* z = NULL;
	Number* _tmp0_;
	gdouble expected = 0.0;
	Number* _tmp1_;
	gdouble _tmp2_;
	_tmp0_ = number_new_pi ();
	z = _tmp0_;
	expected = G_PI;
	_tmp1_ = z;
	_tmp2_ = expected;
	if (!double_matches (_tmp1_, _tmp2_)) {
		Number* _tmp3_;
		gdouble _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = z;
		_tmp4_ = expected;
		_tmp5_ = g_strdup_printf ("Number.pi () -> %f, expected %f", number_to_double (_tmp3_), _tmp4_);
		_tmp6_ = _tmp5_;
		fail (_tmp6_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (z);
		return;
	}
	pass (NULL);
	_g_object_unref0 (z);
}


void
test_eulers (void)
{
	Number* z = NULL;
	Number* _tmp0_;
	gdouble expected = 0.0;
	Number* _tmp1_;
	gdouble _tmp2_;
	_tmp0_ = number_new_eulers ();
	z = _tmp0_;
	expected = G_E;
	_tmp1_ = z;
	_tmp2_ = expected;
	if (!double_matches (_tmp1_, _tmp2_)) {
		Number* _tmp3_;
		gdouble _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = z;
		_tmp4_ = expected;
		_tmp5_ = g_strdup_printf ("Number.eulers () -> %f, expected %f", number_to_double (_tmp3_), _tmp4_);
		_tmp6_ = _tmp5_;
		fail (_tmp6_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (z);
		return;
	}
	pass (NULL);
	_g_object_unref0 (z);
}


void
test_string (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gchar* s = NULL;
				gint _tmp3_;
				gchar* _tmp4_;
				Number* z = NULL;
				const gchar* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp11_;
				gint _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = g_strdup_printf ("%d", _tmp3_);
				s = _tmp4_;
				_tmp5_ = s;
				_tmp6_ = mp_set_from_string (_tmp5_, 10);
				z = _tmp6_;
				_tmp7_ = z;
				if (_tmp7_ == NULL) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp8_ = s;
					_tmp9_ = g_strdup_printf ("mp_set_from_string (\"%s\") -> null", _tmp8_);
					_tmp10_ = _tmp9_;
					fail (_tmp10_);
					_g_free0 (_tmp10_);
					_g_object_unref0 (z);
					_g_free0 (s);
					return;
				}
				_tmp11_ = z;
				_tmp12_ = a;
				if (number_to_integer (_tmp11_) != ((gint64) _tmp12_)) {
					const gchar* _tmp13_;
					Number* _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp13_ = s;
					_tmp14_ = z;
					_tmp15_ = a;
					_tmp16_ = g_strdup_printf ("mp_set_from_string (\"%s\").to_integer () -> %d, expected %d", _tmp13_, (gint) number_to_integer (_tmp14_), _tmp15_);
					_tmp17_ = _tmp16_;
					fail (_tmp17_);
					_g_free0 (_tmp17_);
					_g_object_unref0 (z);
					_g_free0 (s);
					return;
				}
				_g_object_unref0 (z);
				_g_free0 (s);
			}
		}
	}
	pass (NULL);
}


void
test_sgn (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gint expected = 0;
				gint _tmp5_;
				gint _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				Number* _tmp9_;
				gint _tmp10_;
				gboolean _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				expected = 0;
				_tmp5_ = a;
				if (_tmp5_ < 0) {
					expected = -1;
				}
				_tmp6_ = a;
				if (_tmp6_ > 0) {
					expected = 1;
				}
				_tmp7_ = z;
				_tmp8_ = number_sgn (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = expected;
				_tmp11_ = number_to_integer (_tmp9_) != ((gint64) _tmp10_);
				_g_object_unref0 (_tmp9_);
				if (_tmp11_) {
					gint _tmp12_;
					Number* _tmp13_;
					Number* _tmp14_;
					Number* _tmp15_;
					gint _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = number_sgn (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%d).sgn () -> %d, expected %d", _tmp12_, (gint) number_to_integer (_tmp15_), _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_g_object_unref0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_invert_sign (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gint expected = 0;
				gint _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gint _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				_tmp5_ = a;
				expected = -_tmp5_;
				_tmp6_ = z;
				_tmp7_ = number_invert_sign (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = expected;
				_tmp10_ = number_to_integer (_tmp8_) != ((gint64) _tmp9_);
				_g_object_unref0 (_tmp8_);
				if (_tmp10_) {
					gint _tmp11_;
					Number* _tmp12_;
					Number* _tmp13_;
					Number* _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = number_invert_sign (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = expected;
					_tmp16_ = g_strdup_printf ("(%d).invert_sign () -> %d, expected %d", _tmp11_, (gint) number_to_integer (_tmp14_), _tmp15_);
					_tmp17_ = _tmp16_;
					fail (_tmp17_);
					_g_free0 (_tmp17_);
					_g_object_unref0 (_tmp14_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_abs (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gint expected = 0;
				gint _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gint _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				_tmp5_ = a;
				expected = abs (_tmp5_);
				_tmp6_ = z;
				_tmp7_ = number_abs (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = expected;
				_tmp10_ = number_to_integer (_tmp8_) != ((gint64) _tmp9_);
				_g_object_unref0 (_tmp8_);
				if (_tmp10_) {
					gint _tmp11_;
					Number* _tmp12_;
					Number* _tmp13_;
					Number* _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = number_abs (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = expected;
					_tmp16_ = g_strdup_printf ("(%d).abs () -> %d, expected %d", _tmp11_, (gint) number_to_integer (_tmp14_), _tmp15_);
					_tmp17_ = _tmp16_;
					fail (_tmp17_);
					_g_free0 (_tmp17_);
					_g_object_unref0 (_tmp14_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_arg (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							Number* _tmp14_;
							Number* _tmp15_;
							gdouble expected = 0.0;
							gint _tmp16_;
							gint _tmp17_;
							gboolean _tmp18_ = FALSE;
							Number* _tmp19_;
							Number* _tmp20_;
							Number* _tmp21_;
							gdouble _tmp22_;
							gboolean _tmp23_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = z;
							_tmp15_ = number_arg (_tmp14_, ANGLE_UNIT_RADIANS);
							_g_object_unref0 (z);
							z = _tmp15_;
							_tmp16_ = b;
							_tmp17_ = a;
							expected = atan2 ((gdouble) _tmp16_, (gdouble) _tmp17_);
							_tmp19_ = z;
							_tmp20_ = number_real_component (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = expected;
							_tmp23_ = !double_matches (_tmp21_, _tmp22_);
							_g_object_unref0 (_tmp21_);
							if (_tmp23_) {
								_tmp18_ = TRUE;
							} else {
								Number* _tmp24_;
								Number* _tmp25_;
								Number* _tmp26_;
								_tmp24_ = z;
								_tmp25_ = number_imaginary_component (_tmp24_);
								_tmp26_ = _tmp25_;
								_tmp18_ = !number_is_zero (_tmp26_);
								_g_object_unref0 (_tmp26_);
							}
							if (_tmp18_) {
								gint _tmp27_;
								gint _tmp28_;
								Number* _tmp29_;
								Number* _tmp30_;
								Number* _tmp31_;
								Number* _tmp32_;
								Number* _tmp33_;
								Number* _tmp34_;
								gdouble _tmp35_;
								gchar* _tmp36_;
								gchar* _tmp37_;
								_tmp27_ = a;
								_tmp28_ = b;
								_tmp29_ = z;
								_tmp30_ = number_real_component (_tmp29_);
								_tmp31_ = _tmp30_;
								_tmp32_ = z;
								_tmp33_ = number_imaginary_component (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = expected;
								_tmp36_ = g_strdup_printf ("(%d%+di).arg () -> %f%+fi, expected %f", _tmp27_, _tmp28_, number_to_double (_tmp31_), number_to_double (_tmp34_), _tmp35_);
								_tmp37_ = _tmp36_;
								fail (_tmp37_);
								_g_free0 (_tmp37_);
								_g_object_unref0 (_tmp34_);
								_g_object_unref0 (_tmp31_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void
test_conjugate (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							Number* _tmp14_;
							Number* _tmp15_;
							gint re_expected = 0;
							gint _tmp16_;
							gint im_expected = 0;
							gint _tmp17_;
							gboolean _tmp18_ = FALSE;
							Number* _tmp19_;
							Number* _tmp20_;
							Number* _tmp21_;
							gint _tmp22_;
							gboolean _tmp23_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = z;
							_tmp15_ = number_conjugate (_tmp14_);
							_g_object_unref0 (z);
							z = _tmp15_;
							_tmp16_ = a;
							re_expected = _tmp16_;
							_tmp17_ = b;
							im_expected = -_tmp17_;
							_tmp19_ = z;
							_tmp20_ = number_real_component (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = re_expected;
							_tmp23_ = number_to_integer (_tmp21_) != ((gint64) _tmp22_);
							_g_object_unref0 (_tmp21_);
							if (_tmp23_) {
								_tmp18_ = TRUE;
							} else {
								Number* _tmp24_;
								Number* _tmp25_;
								Number* _tmp26_;
								gint _tmp27_;
								_tmp24_ = z;
								_tmp25_ = number_imaginary_component (_tmp24_);
								_tmp26_ = _tmp25_;
								_tmp27_ = im_expected;
								_tmp18_ = number_to_integer (_tmp26_) != ((gint64) _tmp27_);
								_g_object_unref0 (_tmp26_);
							}
							if (_tmp18_) {
								gint _tmp28_;
								gint _tmp29_;
								Number* _tmp30_;
								Number* _tmp31_;
								Number* _tmp32_;
								Number* _tmp33_;
								Number* _tmp34_;
								Number* _tmp35_;
								gint _tmp36_;
								gint _tmp37_;
								gchar* _tmp38_;
								gchar* _tmp39_;
								_tmp28_ = a;
								_tmp29_ = b;
								_tmp30_ = z;
								_tmp31_ = number_real_component (_tmp30_);
								_tmp32_ = _tmp31_;
								_tmp33_ = z;
								_tmp34_ = number_imaginary_component (_tmp33_);
								_tmp35_ = _tmp34_;
								_tmp36_ = re_expected;
								_tmp37_ = im_expected;
								_tmp38_ = g_strdup_printf ("(%d%+di).real_component () -> %d%+di, expected %d%+di", _tmp28_, _tmp29_, (gint) number_to_integer (_tmp32_), (gint) number_to_integer (_tmp35_), _tmp36_, _tmp37_);
								_tmp39_ = _tmp38_;
								fail (_tmp39_);
								_g_free0 (_tmp39_);
								_g_object_unref0 (_tmp35_);
								_g_object_unref0 (_tmp32_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void
test_real_component (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							Number* _tmp15_;
							Number* _tmp16_;
							Number* _tmp17_;
							gint _tmp18_;
							gboolean _tmp19_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							expected = _tmp14_;
							_tmp15_ = z;
							_tmp16_ = number_real_component (_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp18_ = expected;
							_tmp19_ = number_to_integer (_tmp17_) != ((gint64) _tmp18_);
							_g_object_unref0 (_tmp17_);
							if (_tmp19_) {
								gint _tmp20_;
								gint _tmp21_;
								Number* _tmp22_;
								Number* _tmp23_;
								Number* _tmp24_;
								gint _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								_tmp20_ = a;
								_tmp21_ = b;
								_tmp22_ = z;
								_tmp23_ = number_real_component (_tmp22_);
								_tmp24_ = _tmp23_;
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d+%di).real_component () -> %d, expected %d", _tmp20_, _tmp21_, (gint) number_to_integer (_tmp24_), _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_g_object_unref0 (_tmp24_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_imaginary_component (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							Number* _tmp15_;
							Number* _tmp16_;
							Number* _tmp17_;
							gint _tmp18_;
							gboolean _tmp19_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = b;
							expected = _tmp14_;
							_tmp15_ = z;
							_tmp16_ = number_imaginary_component (_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp18_ = expected;
							_tmp19_ = number_to_integer (_tmp17_) != ((gint64) _tmp18_);
							_g_object_unref0 (_tmp17_);
							if (_tmp19_) {
								gint _tmp20_;
								gint _tmp21_;
								Number* _tmp22_;
								Number* _tmp23_;
								Number* _tmp24_;
								gint _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								_tmp20_ = a;
								_tmp21_ = b;
								_tmp22_ = z;
								_tmp23_ = number_imaginary_component (_tmp22_);
								_tmp24_ = _tmp23_;
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d+%di).imaginary_component () -> %d, expected %d", _tmp20_, _tmp21_, (gint) number_to_integer (_tmp24_), _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_g_object_unref0 (_tmp24_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


gboolean
double_matches (Number* a,
                gdouble b)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (a != NULL, FALSE);
	_tmp0_ = double_string (number_to_double (a));
	_tmp1_ = _tmp0_;
	_tmp2_ = double_string (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar*
double_string (gdouble x)
{
	gchar* result = NULL;
	gchar* value = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%.6f", x);
	value = _tmp0_;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp1_, "-0.000000") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("0.000000");
		result = _tmp2_;
		_g_free0 (value);
		return result;
	} else {
		result = value;
		return result;
	}
	_g_free0 (value);
}


void
test_integer_component (void)
{
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gdouble a = 0.0;
				gint _tmp3_;
				Number* z = NULL;
				gdouble _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gdouble _tmp9_;
				Number* _tmp10_;
				gdouble _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_integer_component (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = trunc (_tmp9_);
				_tmp10_ = z;
				_tmp11_ = expected;
				if (!double_matches (_tmp10_, _tmp11_)) {
					gdouble _tmp12_;
					Number* _tmp13_;
					gdouble _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = expected;
					_tmp15_ = g_strdup_printf ("(%f).integer_component () -> %f, expected %f", _tmp12_, number_to_double (_tmp13_), _tmp14_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_fractional_component (void)
{
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gdouble a = 0.0;
				gint _tmp3_;
				Number* z = NULL;
				gdouble _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gdouble _tmp9_;
				gdouble _tmp10_;
				Number* _tmp11_;
				gdouble _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_fractional_component (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = a;
				expected = _tmp9_ - trunc (_tmp10_);
				_tmp11_ = z;
				_tmp12_ = expected;
				if (!double_matches (_tmp11_, _tmp12_)) {
					gdouble _tmp13_;
					Number* _tmp14_;
					gdouble _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = expected;
					_tmp16_ = g_strdup_printf ("(%f).fractional_component () -> %f, expected %f", _tmp13_, number_to_double (_tmp14_), _tmp15_);
					_tmp17_ = _tmp16_;
					fail (_tmp17_);
					_g_free0 (_tmp17_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_fractional_part (void)
{
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gdouble a = 0.0;
				gint _tmp3_;
				Number* z = NULL;
				gdouble _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gdouble _tmp9_;
				gdouble _tmp10_;
				Number* _tmp11_;
				gdouble _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_fractional_part (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = a;
				expected = _tmp9_ - floor (_tmp10_);
				_tmp11_ = z;
				_tmp12_ = expected;
				if (!double_matches (_tmp11_, _tmp12_)) {
					gdouble _tmp13_;
					Number* _tmp14_;
					gdouble _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = expected;
					_tmp16_ = g_strdup_printf ("(%f).fractional_part () -> %f, expected %f", _tmp13_, number_to_double (_tmp14_), _tmp15_);
					_tmp17_ = _tmp16_;
					fail (_tmp17_);
					_g_free0 (_tmp17_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_floor (void)
{
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gdouble a = 0.0;
				gint _tmp3_;
				Number* z = NULL;
				gdouble _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gdouble _tmp9_;
				Number* _tmp10_;
				gdouble _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_floor (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = floor (_tmp9_);
				_tmp10_ = z;
				_tmp11_ = expected;
				if (!double_matches (_tmp10_, _tmp11_)) {
					gdouble _tmp12_;
					Number* _tmp13_;
					gdouble _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = expected;
					_tmp15_ = g_strdup_printf ("(%f).floor () -> %f, expected %f", _tmp12_, number_to_double (_tmp13_), _tmp14_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_ceiling (void)
{
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gdouble a = 0.0;
				gint _tmp3_;
				Number* z = NULL;
				gdouble _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gdouble _tmp9_;
				Number* _tmp10_;
				gdouble _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_ceiling (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = ceil (_tmp9_);
				_tmp10_ = z;
				_tmp11_ = expected;
				if (!double_matches (_tmp10_, _tmp11_)) {
					gdouble _tmp12_;
					Number* _tmp13_;
					gdouble _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = expected;
					_tmp15_ = g_strdup_printf ("(%f).ceiling () -> %f, expected %f", _tmp12_, number_to_double (_tmp13_), _tmp14_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_round (void)
{
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gdouble a = 0.0;
				gint _tmp3_;
				Number* z = NULL;
				gdouble _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gdouble _tmp9_;
				Number* _tmp10_;
				gdouble _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_round (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = round (_tmp9_);
				_tmp10_ = z;
				_tmp11_ = expected;
				if (!double_matches (_tmp10_, _tmp11_)) {
					gdouble _tmp12_;
					Number* _tmp13_;
					gdouble _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = expected;
					_tmp15_ = g_strdup_printf ("(%f).round () -> %f, expected %f", _tmp12_, number_to_double (_tmp13_), _tmp14_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_reciprocal (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				Number* z = NULL;
				gint _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gint _tmp9_;
				Number* _tmp10_;
				gdouble _tmp11_;
				gdouble _tmp17_;
				Number* _tmp18_;
				Number* _tmp19_;
				Number* _tmp20_;
				Number* _tmp21_;
				gint _tmp22_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				if (_tmp3_ == 0) {
					continue;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double ((gdouble) _tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_reciprocal (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = 1.0 / _tmp9_;
				_tmp10_ = z;
				_tmp11_ = expected;
				if (!double_matches (_tmp10_, _tmp11_)) {
					gint _tmp12_;
					Number* _tmp13_;
					gdouble _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = expected;
					_tmp15_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", (gdouble) _tmp12_, number_to_double (_tmp13_), _tmp14_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_g_object_unref0 (z);
					return;
				}
				_tmp17_ = expected;
				_tmp18_ = number_new_double (_tmp17_, (gdouble) 0);
				_tmp19_ = _tmp18_;
				_tmp20_ = number_reciprocal (_tmp19_);
				_g_object_unref0 (z);
				z = _tmp20_;
				_g_object_unref0 (_tmp19_);
				_tmp21_ = z;
				_tmp22_ = a;
				if (!double_matches (_tmp21_, (gdouble) _tmp22_)) {
					gdouble _tmp23_;
					Number* _tmp24_;
					gint _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp23_ = expected;
					_tmp24_ = z;
					_tmp25_ = a;
					_tmp26_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", _tmp23_, number_to_double (_tmp24_), (gdouble) _tmp25_);
					_tmp27_ = _tmp26_;
					fail (_tmp27_);
					_g_free0 (_tmp27_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_epowy (void)
{
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gdouble a = 0.0;
				gint _tmp3_;
				Number* z = NULL;
				gdouble _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				gdouble expected = 0.0;
				gdouble _tmp9_;
				Number* _tmp10_;
				gdouble _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ai;
					ai = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = ai;
				if (!(_tmp2_ <= 100)) {
					break;
				}
				_tmp3_ = ai;
				a = _tmp3_ / 10.0;
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_, (gdouble) 0);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_epowy (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = exp (_tmp9_);
				_tmp10_ = z;
				_tmp11_ = expected;
				if (!double_matches (_tmp10_, _tmp11_)) {
					gdouble _tmp12_;
					Number* _tmp13_;
					gdouble _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = a;
					_tmp13_ = z;
					_tmp14_ = expected;
					_tmp15_ = g_strdup_printf ("(%f).epowy () -> %f, expected %f", _tmp12_, number_to_double (_tmp13_), _tmp14_);
					_tmp16_ = _tmp15_;
					fail (_tmp16_);
					_g_free0 (_tmp16_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_xpowy (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gdouble expected = 0.0;
							gint _tmp14_;
							Number* _tmp29_;
							gdouble _tmp30_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_xpowy (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							expected = 1.0;
							_tmp14_ = a;
							if (_tmp14_ == 0) {
								expected = 0.0;
							} else {
								gint _tmp15_;
								_tmp15_ = b;
								if (_tmp15_ < 0) {
									{
										gint i = 0;
										i = 0;
										{
											gboolean _tmp16_ = FALSE;
											_tmp16_ = TRUE;
											while (TRUE) {
												gint _tmp18_;
												gint _tmp19_;
												gdouble _tmp20_;
												gint _tmp21_;
												if (!_tmp16_) {
													gint _tmp17_;
													_tmp17_ = i;
													i = _tmp17_ - 1;
												}
												_tmp16_ = FALSE;
												_tmp18_ = i;
												_tmp19_ = b;
												if (!(_tmp18_ > _tmp19_)) {
													break;
												}
												_tmp20_ = expected;
												_tmp21_ = a;
												expected = _tmp20_ / _tmp21_;
											}
										}
									}
								} else {
									gint _tmp22_;
									_tmp22_ = b;
									if (_tmp22_ > 0) {
										{
											gint i = 0;
											i = 0;
											{
												gboolean _tmp23_ = FALSE;
												_tmp23_ = TRUE;
												while (TRUE) {
													gint _tmp25_;
													gint _tmp26_;
													gdouble _tmp27_;
													gint _tmp28_;
													if (!_tmp23_) {
														gint _tmp24_;
														_tmp24_ = i;
														i = _tmp24_ + 1;
													}
													_tmp23_ = FALSE;
													_tmp25_ = i;
													_tmp26_ = b;
													if (!(_tmp25_ < _tmp26_)) {
														break;
													}
													_tmp27_ = expected;
													_tmp28_ = a;
													expected = _tmp27_ * _tmp28_;
												}
											}
										}
									}
								}
							}
							_tmp29_ = z;
							_tmp30_ = expected;
							if (!double_matches (_tmp29_, _tmp30_)) {
								gint _tmp31_;
								gint _tmp32_;
								Number* _tmp33_;
								gdouble _tmp34_;
								gchar* _tmp35_;
								gchar* _tmp36_;
								_tmp31_ = a;
								_tmp32_ = b;
								_tmp33_ = z;
								_tmp34_ = expected;
								_tmp35_ = g_strdup_printf ("(%d).xpowy (%d) -> %f, expected %f", _tmp31_, _tmp32_, number_to_double (_tmp33_), _tmp34_);
								_tmp36_ = _tmp35_;
								fail (_tmp36_);
								_g_free0 (_tmp36_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_xpowy_integer (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							gdouble expected = 0.0;
							gint _tmp12_;
							Number* _tmp27_;
							gdouble _tmp28_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_g_object_unref0 (_tmp8_);
							z = _tmp11_;
							expected = 1.0;
							_tmp12_ = a;
							if (_tmp12_ == 0) {
								expected = 0.0;
							} else {
								gint _tmp13_;
								_tmp13_ = b;
								if (_tmp13_ < 0) {
									{
										gint i = 0;
										i = 0;
										{
											gboolean _tmp14_ = FALSE;
											_tmp14_ = TRUE;
											while (TRUE) {
												gint _tmp16_;
												gint _tmp17_;
												gdouble _tmp18_;
												gint _tmp19_;
												if (!_tmp14_) {
													gint _tmp15_;
													_tmp15_ = i;
													i = _tmp15_ - 1;
												}
												_tmp14_ = FALSE;
												_tmp16_ = i;
												_tmp17_ = b;
												if (!(_tmp16_ > _tmp17_)) {
													break;
												}
												_tmp18_ = expected;
												_tmp19_ = a;
												expected = _tmp18_ / _tmp19_;
											}
										}
									}
								} else {
									gint _tmp20_;
									_tmp20_ = b;
									if (_tmp20_ > 0) {
										{
											gint i = 0;
											i = 0;
											{
												gboolean _tmp21_ = FALSE;
												_tmp21_ = TRUE;
												while (TRUE) {
													gint _tmp23_;
													gint _tmp24_;
													gdouble _tmp25_;
													gint _tmp26_;
													if (!_tmp21_) {
														gint _tmp22_;
														_tmp22_ = i;
														i = _tmp22_ + 1;
													}
													_tmp21_ = FALSE;
													_tmp23_ = i;
													_tmp24_ = b;
													if (!(_tmp23_ < _tmp24_)) {
														break;
													}
													_tmp25_ = expected;
													_tmp26_ = a;
													expected = _tmp25_ * _tmp26_;
												}
											}
										}
									}
								}
							}
							_tmp27_ = z;
							_tmp28_ = expected;
							if (!double_matches (_tmp27_, _tmp28_)) {
								gint _tmp29_;
								gint _tmp30_;
								Number* _tmp31_;
								gdouble _tmp32_;
								gchar* _tmp33_;
								gchar* _tmp34_;
								_tmp29_ = a;
								_tmp30_ = b;
								_tmp31_ = z;
								_tmp32_ = expected;
								_tmp33_ = g_strdup_printf ("(%d).xpowy_integer (%d) -> %f, expected %f", _tmp29_, _tmp30_, number_to_double (_tmp31_), _tmp32_);
								_tmp34_ = _tmp33_;
								fail (_tmp34_);
								_g_free0 (_tmp34_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_root3 (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gdouble expected = 0.0;
				gint _tmp8_;
				Number* _tmp9_;
				gdouble _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_, (gdouble) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_root (_tmp5_, (gint64) 3);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = cbrt ((gdouble) _tmp8_);
				_tmp9_ = z;
				_tmp10_ = expected;
				if (!double_matches (_tmp9_, _tmp10_)) {
					gint _tmp11_;
					Number* _tmp12_;
					gdouble _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%f).root (3) -> %f, expected %f", (gdouble) _tmp11_, number_to_double (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_sqrt (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gdouble expected = 0.0;
				gint _tmp8_;
				Number* _tmp9_;
				gdouble _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_, (gdouble) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_sqrt (_tmp5_);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = sqrt ((gdouble) _tmp8_);
				_tmp9_ = z;
				_tmp10_ = expected;
				if (!double_matches (_tmp9_, _tmp10_)) {
					gint _tmp11_;
					Number* _tmp12_;
					gdouble _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%f).sqrt () -> %f, expected %f", (gdouble) _tmp11_, number_to_double (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_ln (void)
{
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gdouble expected = 0.0;
				gint _tmp8_;
				Number* _tmp9_;
				gdouble _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_, (gdouble) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_ln (_tmp5_);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = log ((gdouble) _tmp8_);
				_tmp9_ = z;
				_tmp10_ = expected;
				if (!double_matches (_tmp9_, _tmp10_)) {
					gint _tmp11_;
					Number* _tmp12_;
					gdouble _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%f).ln () -> %f, expected %f", (gdouble) _tmp11_, number_to_double (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_logarithm2 (void)
{
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gdouble expected = 0.0;
				gint _tmp8_;
				Number* _tmp9_;
				gdouble _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_, (gdouble) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_logarithm (_tmp5_, (gint64) 2);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = log2 ((gdouble) _tmp8_);
				_tmp9_ = z;
				_tmp10_ = expected;
				if (!double_matches (_tmp9_, _tmp10_)) {
					gint _tmp11_;
					Number* _tmp12_;
					gdouble _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%f).logarithm (2) -> %f, expected %f", (gdouble) _tmp11_, number_to_double (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_logarithm10 (void)
{
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gdouble expected = 0.0;
				gint _tmp8_;
				Number* _tmp9_;
				gdouble _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double ((gdouble) _tmp3_, (gdouble) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_logarithm (_tmp5_, (gint64) 10);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = log10 ((gdouble) _tmp8_);
				_tmp9_ = z;
				_tmp10_ = expected;
				if (!double_matches (_tmp9_, _tmp10_)) {
					gint _tmp11_;
					Number* _tmp12_;
					gdouble _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%f).logarithm (10) -> %f, expected %f", (gdouble) _tmp11_, number_to_double (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_is_zero (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gboolean expected = FALSE;
				gint _tmp5_;
				Number* _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ == 0;
				_tmp6_ = z;
				_tmp7_ = expected;
				if (number_is_zero (_tmp6_) != _tmp7_) {
					const gchar* _tmp8_ = NULL;
					Number* _tmp9_;
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_;
					gint _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp9_ = z;
					if (number_is_zero (_tmp9_)) {
						_tmp8_ = "true";
					} else {
						_tmp8_ = "false";
					}
					_tmp11_ = expected;
					if (_tmp11_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("(%d).is_zero () -> %s, expected %s", _tmp12_, _tmp8_, _tmp10_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_is_negative (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gboolean expected = FALSE;
				gint _tmp5_;
				Number* _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ < 0;
				_tmp6_ = z;
				_tmp7_ = expected;
				if (number_is_negative (_tmp6_) != _tmp7_) {
					const gchar* _tmp8_ = NULL;
					Number* _tmp9_;
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_;
					gint _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp9_ = z;
					if (number_is_negative (_tmp9_)) {
						_tmp8_ = "true";
					} else {
						_tmp8_ = "false";
					}
					_tmp11_ = expected;
					if (_tmp11_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("(%d).is_negative () -> %s, expected %s", _tmp12_, _tmp8_, _tmp10_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_is_integer (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gboolean expected = FALSE;
				Number* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				expected = TRUE;
				_tmp5_ = z;
				_tmp6_ = expected;
				if (number_is_integer (_tmp5_) != _tmp6_) {
					const gchar* _tmp7_ = NULL;
					Number* _tmp8_;
					const gchar* _tmp9_ = NULL;
					gboolean _tmp10_;
					gint _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp8_ = z;
					if (number_is_integer (_tmp8_)) {
						_tmp7_ = "true";
					} else {
						_tmp7_ = "false";
					}
					_tmp10_ = expected;
					if (_tmp10_) {
						_tmp9_ = "true";
					} else {
						_tmp9_ = "false";
					}
					_tmp11_ = a;
					_tmp12_ = g_strdup_printf ("(%d).is_integer () -> %s, expected %s", _tmp11_, _tmp7_, _tmp9_);
					_tmp13_ = _tmp12_;
					fail (_tmp13_);
					_g_free0 (_tmp13_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_is_positive_integer (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gboolean expected = FALSE;
				gint _tmp5_;
				Number* _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ >= 0;
				_tmp6_ = z;
				_tmp7_ = expected;
				if (number_is_positive_integer (_tmp6_) != _tmp7_) {
					const gchar* _tmp8_ = NULL;
					Number* _tmp9_;
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_;
					gint _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp9_ = z;
					if (number_is_positive_integer (_tmp9_)) {
						_tmp8_ = "true";
					} else {
						_tmp8_ = "false";
					}
					_tmp11_ = expected;
					if (_tmp11_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("(%d).is_positive_integer () -> %s, expected %s", _tmp12_, _tmp8_, _tmp10_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_is_natural (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gboolean expected = FALSE;
				gint _tmp5_;
				Number* _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				_tmp5_ = a;
				expected = _tmp5_ > 0;
				_tmp6_ = z;
				_tmp7_ = expected;
				if (number_is_natural (_tmp6_) != _tmp7_) {
					const gchar* _tmp8_ = NULL;
					Number* _tmp9_;
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_;
					gint _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp9_ = z;
					if (number_is_natural (_tmp9_)) {
						_tmp8_ = "true";
					} else {
						_tmp8_ = "false";
					}
					_tmp11_ = expected;
					if (_tmp11_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("(%d).is_natural () -> %s, expected %s", _tmp12_, _tmp8_, _tmp10_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_is_complex (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gboolean expected = FALSE;
							gint _tmp14_;
							Number* _tmp15_;
							gboolean _tmp16_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_new_complex (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = b;
							expected = _tmp14_ != 0;
							_tmp15_ = z;
							_tmp16_ = expected;
							if (number_is_complex (_tmp15_) != _tmp16_) {
								const gchar* _tmp17_ = NULL;
								Number* _tmp18_;
								const gchar* _tmp19_ = NULL;
								gboolean _tmp20_;
								gint _tmp21_;
								gint _tmp22_;
								gchar* _tmp23_;
								gchar* _tmp24_;
								_tmp18_ = z;
								if (number_is_complex (_tmp18_)) {
									_tmp17_ = "true";
								} else {
									_tmp17_ = "false";
								}
								_tmp20_ = expected;
								if (_tmp20_) {
									_tmp19_ = "true";
								} else {
									_tmp19_ = "false";
								}
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = g_strdup_printf ("(%d+%di).is_complex () -> %s, expected %s", _tmp21_, _tmp22_, _tmp17_, _tmp19_);
								_tmp24_ = _tmp23_;
								fail (_tmp24_);
								_g_free0 (_tmp24_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_factorial (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				gint expected = 0;
				Number* _tmp11_;
				Number* _tmp12_;
				Number* _tmp13_;
				gint _tmp14_;
				gboolean _tmp15_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				z = _tmp4_;
				expected = 1;
				{
					gint i = 0;
					i = 2;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = i;
								i = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = i;
							_tmp8_ = a;
							if (!(_tmp7_ <= _tmp8_)) {
								break;
							}
							_tmp9_ = expected;
							_tmp10_ = i;
							expected = _tmp9_ * _tmp10_;
						}
					}
				}
				_tmp11_ = z;
				_tmp12_ = number_factorial (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = expected;
				_tmp15_ = number_to_integer (_tmp13_) != ((gint64) _tmp14_);
				_g_object_unref0 (_tmp13_);
				if (_tmp15_) {
					gint _tmp16_;
					Number* _tmp17_;
					Number* _tmp18_;
					Number* _tmp19_;
					gint _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp16_ = a;
					_tmp17_ = z;
					_tmp18_ = number_factorial (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = expected;
					_tmp21_ = g_strdup_printf ("(%d).factorial () -> %lli, expected %lli", _tmp16_, number_to_integer (_tmp19_), _tmp20_);
					_tmp22_ = _tmp21_;
					fail (_tmp22_);
					_g_free0 (_tmp22_);
					_g_object_unref0 (_tmp19_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_add (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							gint _tmp15_;
							Number* _tmp16_;
							gint _tmp17_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_add (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ + _tmp15_;
							_tmp16_ = z;
							_tmp17_ = expected;
							if (number_to_integer (_tmp16_) != ((gint64) _tmp17_)) {
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).add (%d) -> %lli, expected %d", _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_subtract (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							gint _tmp15_;
							Number* _tmp16_;
							gint _tmp17_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_subtract (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ - _tmp15_;
							_tmp16_ = z;
							_tmp17_ = expected;
							if (number_to_integer (_tmp16_) != ((gint64) _tmp17_)) {
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).subtract (%d) -> %lli, expected %d", _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_multiply (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							gint _tmp15_;
							Number* _tmp16_;
							gint _tmp17_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_multiply (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ * _tmp15_;
							_tmp16_ = z;
							_tmp17_ = expected;
							if (number_to_integer (_tmp16_) != ((gint64) _tmp17_)) {
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).multiply (%d) -> %lli, expected %d", _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_multiply_integer (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							gint expected = 0;
							gint _tmp12_;
							gint _tmp13_;
							Number* _tmp14_;
							gint _tmp15_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_multiply_integer (_tmp8_, (gint64) _tmp9_);
							_tmp11_ = _tmp10_;
							_g_object_unref0 (_tmp8_);
							z = _tmp11_;
							_tmp12_ = a;
							_tmp13_ = b;
							expected = _tmp12_ * _tmp13_;
							_tmp14_ = z;
							_tmp15_ = expected;
							if (number_to_integer (_tmp14_) != ((gint64) _tmp15_)) {
								gint _tmp16_;
								gint _tmp17_;
								Number* _tmp18_;
								gint _tmp19_;
								gchar* _tmp20_;
								gchar* _tmp21_;
								_tmp16_ = a;
								_tmp17_ = b;
								_tmp18_ = z;
								_tmp19_ = expected;
								_tmp20_ = g_strdup_printf ("(%d).multiply_integer (%d) -> %lli, expected %d", _tmp16_, _tmp17_, number_to_integer (_tmp18_), _tmp19_);
								_tmp21_ = _tmp20_;
								fail (_tmp21_);
								_g_free0 (_tmp21_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_divide (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gint _tmp6_;
							Number* z = NULL;
							gint _tmp7_;
							gint _tmp8_;
							Number* _tmp9_;
							Number* _tmp10_;
							gint _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							Number* _tmp14_;
							Number* _tmp15_;
							gint expected = 0;
							gint _tmp16_;
							Number* _tmp17_;
							gint _tmp18_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = b;
							if (_tmp6_ == 0) {
								continue;
							}
							_tmp7_ = a;
							_tmp8_ = b;
							_tmp9_ = number_new_integer ((gint64) (_tmp7_ * _tmp8_), (gint64) 0);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_, (gint64) 0);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_divide (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_g_object_unref0 (_tmp13_);
							_g_object_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							expected = _tmp16_;
							_tmp17_ = z;
							_tmp18_ = expected;
							if (number_to_integer (_tmp17_) != ((gint64) _tmp18_)) {
								gint _tmp19_;
								gint _tmp20_;
								gint _tmp21_;
								Number* _tmp22_;
								gint _tmp23_;
								gchar* _tmp24_;
								gchar* _tmp25_;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = b;
								_tmp22_ = z;
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).divide (%d) -> %lli, expected %d", _tmp19_ * _tmp20_, _tmp21_, number_to_integer (_tmp22_), _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_divide_integer (void)
{
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gint _tmp6_;
							Number* z = NULL;
							gint _tmp7_;
							gint _tmp8_;
							Number* _tmp9_;
							Number* _tmp10_;
							gint _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							Number* _tmp15_;
							gint _tmp16_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = b;
							if (_tmp6_ == 0) {
								continue;
							}
							_tmp7_ = a;
							_tmp8_ = b;
							_tmp9_ = number_new_integer ((gint64) (_tmp7_ * _tmp8_), (gint64) 0);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_divide_integer (_tmp10_, (gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp10_);
							z = _tmp13_;
							_tmp14_ = a;
							expected = _tmp14_;
							_tmp15_ = z;
							_tmp16_ = expected;
							if (number_to_integer (_tmp15_) != ((gint64) _tmp16_)) {
								gint _tmp17_;
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp17_ = a;
								_tmp18_ = b;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).divide_integer (%d) -> %lli, expected %d", _tmp17_ * _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_modulus_divide (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = 1;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							gint _tmp15_;
							Number* _tmp16_;
							gint _tmp17_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ <= 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_modulus_divide (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ % _tmp15_;
							_tmp16_ = z;
							_tmp17_ = expected;
							if (number_to_integer (_tmp16_) != ((gint64) _tmp17_)) {
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).modulus_divide (%d) -> %lli, expected %d", _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_sin (void)
{
	{
		gdouble a = 0.0;
		a = -G_PI;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_;
				Number* z = NULL;
				gdouble _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gdouble expected = 0.0;
				gdouble _tmp8_;
				Number* _tmp9_;
				gdouble _tmp10_;
				if (!_tmp0_) {
					gdouble _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + (G_PI / 16);
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= G_PI)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double (_tmp3_, (gdouble) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_sin (_tmp5_, ANGLE_UNIT_RADIANS);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = sin (_tmp8_);
				_tmp9_ = z;
				_tmp10_ = expected;
				if (!double_matches (_tmp9_, _tmp10_)) {
					gdouble _tmp11_;
					Number* _tmp12_;
					gdouble _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%f).sin () -> %f, expected %f", _tmp11_, number_to_double (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_cos (void)
{
	{
		gdouble a = 0.0;
		a = -G_PI;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_;
				Number* z = NULL;
				gdouble _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gdouble expected = 0.0;
				gdouble _tmp8_;
				Number* _tmp9_;
				gdouble _tmp10_;
				if (!_tmp0_) {
					gdouble _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + (G_PI / 16);
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ <= G_PI)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_double (_tmp3_, (gdouble) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_cos (_tmp5_, ANGLE_UNIT_RADIANS);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = cos (_tmp8_);
				_tmp9_ = z;
				_tmp10_ = expected;
				if (!double_matches (_tmp9_, _tmp10_)) {
					gdouble _tmp11_;
					Number* _tmp12_;
					gdouble _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%f).cos () -> %f, expected %f", _tmp11_, number_to_double (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_and (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							gint _tmp15_;
							Number* _tmp16_;
							gint _tmp17_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_and (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ & _tmp15_;
							_tmp16_ = z;
							_tmp17_ = expected;
							if (number_to_integer (_tmp16_) != ((gint64) _tmp17_)) {
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).and (%d) -> %lli, expected %d", _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_or (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							gint _tmp15_;
							Number* _tmp16_;
							gint _tmp17_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_or (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ | _tmp15_;
							_tmp16_ = z;
							_tmp17_ = expected;
							if (number_to_integer (_tmp16_) != ((gint64) _tmp17_)) {
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).or (%d) -> %lli, expected %d", _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_xor (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							Number* _tmp12_;
							Number* _tmp13_;
							gint expected = 0;
							gint _tmp14_;
							gint _tmp15_;
							Number* _tmp16_;
							gint _tmp17_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_new_integer ((gint64) _tmp9_, (gint64) 0);
							_tmp11_ = _tmp10_;
							_tmp12_ = number_xor (_tmp8_, _tmp11_);
							_tmp13_ = _tmp12_;
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (_tmp8_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ ^ _tmp15_;
							_tmp16_ = z;
							_tmp17_ = expected;
							if (number_to_integer (_tmp16_) != ((gint64) _tmp17_)) {
								gint _tmp18_;
								gint _tmp19_;
								Number* _tmp20_;
								gint _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp18_ = a;
								_tmp19_ = b;
								_tmp20_ = z;
								_tmp21_ = expected;
								_tmp22_ = g_strdup_printf ("(%d).xor (%d) -> %lli, expected %d", _tmp18_, _tmp19_, number_to_integer (_tmp20_), _tmp21_);
								_tmp23_ = _tmp22_;
								fail (_tmp23_);
								_g_free0 (_tmp23_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void
test_not (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Number* z = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* _tmp6_;
				Number* _tmp7_;
				gint expected = 0;
				gint _tmp8_;
				Number* _tmp9_;
				gint _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_not (_tmp5_, 8);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				z = _tmp7_;
				_tmp8_ = a;
				expected = (~_tmp8_) & 0xFF;
				_tmp9_ = z;
				_tmp10_ = expected;
				if (number_to_integer (_tmp9_) != ((gint64) _tmp10_)) {
					gint _tmp11_;
					Number* _tmp12_;
					gint _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = a;
					_tmp12_ = z;
					_tmp13_ = expected;
					_tmp14_ = g_strdup_printf ("(%d).not () -> %lli, expected %d", _tmp11_, number_to_integer (_tmp12_), _tmp13_);
					_tmp15_ = _tmp14_;
					fail (_tmp15_);
					_g_free0 (_tmp15_);
					_g_object_unref0 (z);
					return;
				}
				_g_object_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void
test_shift (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							Number* z = NULL;
							gint _tmp6_;
							Number* _tmp7_;
							Number* _tmp8_;
							gint _tmp9_;
							Number* _tmp10_;
							Number* _tmp11_;
							gint expected = 0;
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							Number* _tmp17_;
							gint _tmp18_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = b;
								b = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = b;
							if (!(_tmp5_ < 10)) {
								break;
							}
							_tmp6_ = a;
							_tmp7_ = number_new_integer ((gint64) _tmp6_, (gint64) 0);
							_tmp8_ = _tmp7_;
							_tmp9_ = b;
							_tmp10_ = number_shift (_tmp8_, _tmp9_);
							_tmp11_ = _tmp10_;
							_g_object_unref0 (_tmp8_);
							z = _tmp11_;
							_tmp12_ = a;
							_tmp13_ = b;
							expected = _tmp12_ << _tmp13_;
							_tmp14_ = b;
							if (_tmp14_ < 0) {
								gint _tmp15_;
								gint _tmp16_;
								_tmp15_ = a;
								_tmp16_ = b;
								expected = _tmp15_ >> (-_tmp16_);
							}
							_tmp17_ = z;
							_tmp18_ = expected;
							if (number_to_integer (_tmp17_) != ((gint64) _tmp18_)) {
								gint _tmp19_;
								gint _tmp20_;
								Number* _tmp21_;
								gint _tmp22_;
								gchar* _tmp23_;
								gchar* _tmp24_;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = expected;
								_tmp23_ = g_strdup_printf ("(%d).shift (%d) -> %lli, expected %d", _tmp19_, _tmp20_, number_to_integer (_tmp21_), _tmp22_);
								_tmp24_ = _tmp23_;
								fail (_tmp24_);
								_g_free0 (_tmp24_);
								_g_object_unref0 (z);
								return;
							}
							_g_object_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


void
test_factorize (void)
{
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GList* factors = NULL;
				gint _tmp3_;
				Number* _tmp4_;
				Number* _tmp5_;
				GList* _tmp6_;
				GList* _tmp7_;
				GList* expected = NULL;
				gint _tmp8_;
				GList* _tmp9_;
				gboolean matches = FALSE;
				GList* _tmp10_;
				GList* _tmp11_;
				gboolean _tmp22_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = a;
					a = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = a;
				if (!(_tmp2_ < 100)) {
					break;
				}
				_tmp3_ = a;
				_tmp4_ = number_new_integer ((gint64) _tmp3_, (gint64) 0);
				_tmp5_ = _tmp4_;
				_tmp6_ = number_factorize (_tmp5_);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				factors = _tmp7_;
				_tmp8_ = a;
				_tmp9_ = factorize (_tmp8_);
				expected = _tmp9_;
				matches = FALSE;
				_tmp10_ = factors;
				_tmp11_ = expected;
				if (g_list_length (_tmp10_) == g_list_length (_tmp11_)) {
					matches = TRUE;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp12_ = FALSE;
							_tmp12_ = TRUE;
							while (TRUE) {
								gint _tmp14_;
								GList* _tmp15_;
								GList* _tmp16_;
								gint _tmp17_;
								gconstpointer _tmp18_;
								GList* _tmp19_;
								gint _tmp20_;
								gconstpointer _tmp21_;
								if (!_tmp12_) {
									gint _tmp13_;
									_tmp13_ = i;
									i = _tmp13_ + 1;
								}
								_tmp12_ = FALSE;
								_tmp14_ = i;
								_tmp15_ = factors;
								if (!(((guint) _tmp14_) < g_list_length (_tmp15_))) {
									break;
								}
								_tmp16_ = factors;
								_tmp17_ = i;
								_tmp18_ = g_list_nth_data (_tmp16_, (guint) _tmp17_);
								_tmp19_ = expected;
								_tmp20_ = i;
								_tmp21_ = g_list_nth_data (_tmp19_, (guint) _tmp20_);
								if (number_to_integer ((Number*) _tmp18_) != ((gint64) ((gint) ((gintptr) _tmp21_)))) {
									matches = FALSE;
								}
							}
						}
					}
				}
				_tmp22_ = matches;
				if (!_tmp22_) {
					gchar* factors_string = NULL;
					gchar* _tmp23_;
					GList* _tmp24_;
					gchar* expected_string = NULL;
					gchar* _tmp34_;
					GList* _tmp35_;
					gint _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					_tmp23_ = g_strdup ("");
					factors_string = _tmp23_;
					_tmp24_ = factors;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp24_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							Number* _tmp25_;
							Number* f = NULL;
							_tmp25_ = _g_object_ref0 ((Number*) f_it->data);
							f = _tmp25_;
							{
								const gchar* _tmp26_;
								const gchar* _tmp29_;
								Number* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* _tmp33_;
								_tmp26_ = factors_string;
								if (g_strcmp0 (_tmp26_, "") != 0) {
									const gchar* _tmp27_;
									gchar* _tmp28_;
									_tmp27_ = factors_string;
									_tmp28_ = g_strconcat (_tmp27_, ", ", NULL);
									_g_free0 (factors_string);
									factors_string = _tmp28_;
								}
								_tmp29_ = factors_string;
								_tmp30_ = f;
								_tmp31_ = g_strdup_printf ("%d", (gint) number_to_integer (_tmp30_));
								_tmp32_ = _tmp31_;
								_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
								_g_free0 (factors_string);
								factors_string = _tmp33_;
								_g_free0 (_tmp32_);
								_g_object_unref0 (f);
							}
						}
					}
					_tmp34_ = g_strdup ("");
					expected_string = _tmp34_;
					_tmp35_ = expected;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp35_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							gint f = 0;
							f = (gint) ((gintptr) f_it->data);
							{
								const gchar* _tmp36_;
								const gchar* _tmp39_;
								gint _tmp40_;
								gchar* _tmp41_;
								gchar* _tmp42_;
								gchar* _tmp43_;
								_tmp36_ = expected_string;
								if (g_strcmp0 (_tmp36_, "") != 0) {
									const gchar* _tmp37_;
									gchar* _tmp38_;
									_tmp37_ = expected_string;
									_tmp38_ = g_strconcat (_tmp37_, ", ", NULL);
									_g_free0 (expected_string);
									expected_string = _tmp38_;
								}
								_tmp39_ = expected_string;
								_tmp40_ = f;
								_tmp41_ = g_strdup_printf ("%d", _tmp40_);
								_tmp42_ = _tmp41_;
								_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
								_g_free0 (expected_string);
								expected_string = _tmp43_;
								_g_free0 (_tmp42_);
							}
						}
					}
					_tmp44_ = a;
					_tmp45_ = factors_string;
					_tmp46_ = expected_string;
					_tmp47_ = g_strdup_printf ("(%d).factorize () -> (%s), expected (%s)", _tmp44_, _tmp45_, _tmp46_);
					_tmp48_ = _tmp47_;
					fail (_tmp48_);
					_g_free0 (_tmp48_);
					_g_free0 (expected_string);
					_g_free0 (factors_string);
					_g_list_free0 (expected);
					__g_list_free__g_object_unref0_0 (factors);
					return;
				}
				_g_list_free0 (expected);
				__g_list_free__g_object_unref0_0 (factors);
			}
		}
	}
	pass (NULL);
}


GList*
factorize (gint number)
{
	GList* result = NULL;
	GList* factors = NULL;
	gint n = 0;
	factors = NULL;
	if (number < 2) {
		factors = g_list_append (factors, (gpointer) ((gintptr) number));
		result = factors;
		return result;
	}
	n = number;
	while (TRUE) {
		{
			gint factor = 0;
			factor = 2;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint _tmp2_;
					gint _tmp3_;
					gint _tmp4_;
					gint _tmp5_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = factor;
						factor = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = factor;
					_tmp3_ = n;
					if (!(_tmp2_ <= _tmp3_)) {
						break;
					}
					_tmp4_ = n;
					_tmp5_ = factor;
					if ((_tmp4_ % _tmp5_) == 0) {
						gint _tmp6_;
						gint _tmp7_;
						gint _tmp8_;
						gint _tmp9_;
						_tmp6_ = factor;
						factors = g_list_append (factors, (gpointer) ((gintptr) _tmp6_));
						_tmp7_ = n;
						_tmp8_ = factor;
						n = _tmp7_ / _tmp8_;
						_tmp9_ = n;
						if (_tmp9_ == 1) {
							result = factors;
							return result;
						}
						break;
					}
				}
			}
		}
	}
	_g_list_free0 (factors);
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp7_;
	setlocale (LC_ALL, "C");
	test_integer ();
	test_unsigned_integer ();
	test_fraction ();
	test_double ();
	test_complex ();
	test_polar ();
	test_string ();
	test_eulers ();
	test_i ();
	test_pi ();
	test_is_zero ();
	test_is_negative ();
	test_is_integer ();
	test_is_positive_integer ();
	test_is_natural ();
	test_is_complex ();
	test_sgn ();
	test_invert_sign ();
	test_abs ();
	test_arg ();
	test_conjugate ();
	test_real_component ();
	test_imaginary_component ();
	test_integer_component ();
	test_fractional_component ();
	test_fractional_part ();
	test_floor ();
	test_ceiling ();
	test_round ();
	test_reciprocal ();
	test_epowy ();
	test_xpowy ();
	test_xpowy_integer ();
	test_root3 ();
	test_sqrt ();
	test_ln ();
	test_logarithm2 ();
	test_logarithm10 ();
	test_factorial ();
	test_add ();
	test_subtract ();
	test_multiply ();
	test_multiply_integer ();
	test_divide ();
	test_divide_integer ();
	test_modulus_divide ();
	test_sin ();
	test_cos ();
	test_and ();
	test_or ();
	test_xor ();
	test_not ();
	test_shift ();
	test_factorize ();
	_tmp0_ = fail_count;
	if (_tmp0_ == 0) {
		FILE* _tmp1_;
		gint _tmp2_;
		_tmp1_ = stdout;
		_tmp2_ = pass_count;
		fprintf (_tmp1_, "Passed all %i tests\n", _tmp2_);
	} else {
		FILE* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = stdout;
		_tmp4_ = fail_count;
		_tmp5_ = pass_count;
		_tmp6_ = fail_count;
		fprintf (_tmp3_, "Failed %i/%d tests\n", _tmp4_, _tmp5_ + _tmp6_);
	}
	_tmp7_ = fail_count;
	result = _tmp7_;
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}



