/* libsudoku.h generated by valac 0.39.92.14-46f76, the Vala compiler, do not modify */


#ifndef __LIBSUDOKU_H__
#define __LIBSUDOKU_H__

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

G_BEGIN_DECLS


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_GAME_MODE (game_mode_get_type ())

#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};

typedef enum  {
	GAME_MODE_PLAY,
	GAME_MODE_CREATE
} GameMode;

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GameMode mode;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};


GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
gboolean sudoku_board_is_empty (SudokuBoard* self);
gboolean sudoku_board_is_fully_filled (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows,
                               gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type,
                                     gint block_rows,
                                     gint block_cols);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
void sudoku_board_enable_earmark (SudokuBoard* self,
                                  gint row,
                                  gint column,
                                  gint digit);
void sudoku_board_disable_earmark (SudokuBoard* self,
                                   gint row,
                                   gint column,
                                   gint digit);
void sudoku_board_disable_all_earmarks (SudokuBoard* self,
                                        gint row,
                                        gint column);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                          gint row,
                                          gint column,
                                          gint digit);
gboolean sudoku_board_is_possible (SudokuBoard* self,
                                   gint row,
                                   gint col,
                                   gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self,
                                       gint row,
                                       gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self,
                                      gint row,
                                      gint col,
                                      int* result_length1);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self,
                                                        gint row,
                                                        gint col,
                                                        int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self,
                                 gint row,
                                 gint col,
                                 Coord* result);
void sudoku_board_insert (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val,
                          gboolean is_fixed);
void sudoku_board_set (SudokuBoard* self,
                       gint row,
                       gint col,
                       gint val);
gint sudoku_board_get (SudokuBoard* self,
                       gint row,
                       gint col);
void sudoku_board_remove (SudokuBoard* self,
                          gint row,
                          gint col,
                          gboolean is_fixed);
gint sudoku_board_count_solutions_limited (SudokuBoard* self);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self,
                                     GeeList* coords,
                                     gint val);
gboolean sudoku_board_row_contains (SudokuBoard* self,
                                    gint row,
                                    gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self,
                                    gint col,
                                    gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self,
                                      Coord* block,
                                      gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self,
                         gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self,
                               gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self,
                              int* result_length1,
                              int* result_length2);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self,
                                         gint row,
                                         gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self,
                                            gdouble value);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
void sudoku_board_set_difficulty_category (SudokuBoard* self,
                                           DifficultyCategory value);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_fixed (SudokuBoard* self);
gint sudoku_board_get_size (SudokuBoard* self);
gboolean sudoku_board_get_complete (SudokuBoard* self);
GType house_get_type (void) G_GNUC_CONST;
void coord_init (Coord *self,
                 gint row,
                 gint col);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a,
                      Coord* b);
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self,
                Coord* coord,
                gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a,
                     Cell* b);
gchar* difficulty_category_to_string (DifficultyCategory self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
DifficultyCategory difficulty_category_from_string (const gchar* input);
GType sudoku_game_get_type (void) G_GNUC_CONST;
GType game_mode_get_type (void) G_GNUC_CONST;
gboolean sudoku_game_is_undostack_null (SudokuGame* self);
gboolean sudoku_game_is_redostack_null (SudokuGame* self);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type,
                                   SudokuBoard* board);
void sudoku_game_insert (SudokuGame* self,
                         gint row,
                         gint col,
                         gint val);
void sudoku_game_remove (SudokuGame* self,
                         gint row,
                         gint col);
gboolean sudoku_game_is_empty (SudokuGame* self);
void sudoku_game_undo (SudokuGame* self);
void sudoku_game_redo (SudokuGame* self);
void sudoku_game_reset (SudokuGame* self);
void sudoku_game_cell_changed_cb (SudokuGame* self,
                                  gint row,
                                  gint col,
                                  gint old_val,
                                  gint new_val);
void sudoku_game_update_undo (SudokuGame* self,
                              gint row,
                              gint col,
                              gint old_val,
                              gint new_val);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
void sudoku_game_start_clock (SudokuGame* self);
void sudoku_game_stop_clock (SudokuGame* self);
void sudoku_game_resume_clock (SudokuGame* self);
gboolean sudoku_game_get_paused (SudokuGame* self);
GType sudoku_saver_get_type (void) G_GNUC_CONST;
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
void sudoku_saver_save_game (SudokuSaver* self,
                             SudokuGame* game);
void sudoku_saver_add_game_to_finished (SudokuSaver* self,
                                        SudokuGame* game,
                                        gboolean delete_savegame);
const gchar* sudoku_saver_get_savegame_file (void);
const gchar* sudoku_saver_get_finishgame_dir (void);
void sudoku_generator_generate_boards_async (gint nboards,
                                             DifficultyCategory category,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_,
                                                  GError** error);
void sudoku_generator_print_stats (SudokuBoard* board);
gchar* sudoku_generator_qqwing_version (void);


G_END_DECLS

#endif
