#include "translate.h"

static const t_unicode iso8859_14_g1_chars[] = {
0x00A0, 0x1E02, 0x1E03, 0x00A3, 0x010A, 0x010B, 0x1E0A, 0x00A7, /* 0xA0-0xA7 */
0x1E80, 0x00A9, 0x1E82, 0x1E0B, 0x1EF2, 0x00AD, 0x00AE, 0x0178, /* 0xA8-0xAF */
0x1E1E, 0x1E1F, 0x0120, 0x0121, 0x1E40, 0x1E41, 0x00B6, 0x1E56, /* 0xB0-0xB7 */
0x1E81, 0x1E57, 0x1E83, 0x1E60, 0x1EF3, 0x1E84, 0x1E85, 0x1E61, /* 0xB8-0xBF */
0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, /* 0xC0-0xC7 */
0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF, /* 0xC8-0xCF */
0x0174, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x1E6A, /* 0xD0-0xD7 */
0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x0176, 0x00DF, /* 0xD8-0xDF */
0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, /* 0xE0-0xE7 */
0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, /* 0xE8-0xEF */
0x0175, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x1E6B, /* 0xF0-0xF7 */
0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x0177, 0x00FF, /* 0xF8-0xFF */
};
struct char_set iso8859_14_g1 = {
	1,
	CHARS(iso8859_14_g1_chars),
	0, "", 1, 96, 
};

struct char_set iso8859_14 = {
	.c0 = &ascii_c0,
	.g0 = &ascii_g0,
	.c1 = &ascii_c1,
	.g1 = &iso8859_14_g1,
	.names = { "iso8859-14", 0 },
};

CONSTRUCTOR(static void init(void))
{
	register_charset(&iso8859_14_g1);
	register_charset(&iso8859_14);
}
