/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_nvlipt_lnk_ip_h__
#define __lr10_dev_nvlipt_lnk_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL                           0x00000090      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_SEL                 1:0             /* RWEVF */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_SEL_L0              0x00000000      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_SEL_L3              0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_SEL_TX              0x00000002      /* RWE-V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_SEL_OFF             0x00000003      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_SEL                 4:3             /* RWEVF */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_SEL_PLL_CLK         0x00000000      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_SEL_ALT_CLK         0x00000001      /* RWE-V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_SEL_OFF             0x00000003      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_STS                 17:16           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_STS_L0              0x00000000      /* R---V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_STS_L3              0x00000001      /* R---V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_STS_TX              0x00000002      /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_STS_OFF             0x00000003      /* R---V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_STS                 20:19           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_STS_PLL_CLK         0x00000000      /* R---V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_STS_ALT_CLK         0x00000001      /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_TXCLK_STS_OFF             0x00000003      /* R---V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_PLL_PWR                   24:24           /* RWEVF */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_PLL_PWR_OFF               0x00000000      /* RWE-V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_PLL_PWR_ON                0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_PLL_PWR_STS               25:25           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_PLL_PWR_STS_OFF           0x00000000      /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_PLL_PWR_STS_ON            0x00000001      /* R---V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_HW_DISABLE          31:31           /* RWEVF */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_HW_DISABLE_OFF      0x00000000      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_CLK_CTRL_RXCLK_HW_DISABLE_ON       0x00000001      /* RWE-V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE               0x00000104      /* RW-4R */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE_TYPE          7:0             /* RWIVF */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE_TYPE_INIT     0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE_TYPE_NV2P1TUR 0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE_TYPE_NV3P0AMP 0x00000002      /* RW--V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE_TYPE_NV3P0LRK 0x00000003      /* RW--V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE_TYPE_BB3P0P9P 0x00000004      /* RW--V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_TYPE_TYPE_BB3P0P10 0x00000005      /* RW--V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_LINK_INFO               0x00000110      /* RW-4R */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_LINK_INFO_LINK_NUMBER   7:0             /* RWIVF */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_LINK_INFO_LINK_NUMBER_INIT 0x000000ff   /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0                            0x00000280      /* RW-4R */
#define NV_NVLIPT_LNK_ERR_STATUS_0_SLEEPWHILEACTIVELINK       0:0             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_SLEEPWHILEACTIVELINK_NONE  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_SLEEPWHILEACTIVELINK_CLEAR 0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_ILLEGALLINKSTATEREQUEST    1:1             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_ILLEGALLINKSTATEREQUEST_NONE 0x00000000    /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_ILLEGALLINKSTATEREQUEST_CLEAR 0x00000001   /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_FAILEDMINIONREQUEST        2:2             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_FAILEDMINIONREQUEST_NONE   0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_FAILEDMINIONREQUEST_CLEAR  0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RESERVEDREQUESTVALUE       3:3             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RESERVEDREQUESTVALUE_NONE  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RESERVEDREQUESTVALUE_CLEAR 0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_LINKSTATEWRITEWHILEBUSY    4:4             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_LINKSTATEWRITEWHILEBUSY_NONE 0x00000000    /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_LINKSTATEWRITEWHILEBUSY_CLEAR 0x00000001   /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_LINK_STATE_REQUEST_TIMEOUT 5:5             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_LINK_STATE_REQUEST_TIMEOUT_NONE 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_LINK_STATE_REQUEST_TIMEOUT_CLEAR 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR 6:6         /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_NONE 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RSTSEQ_PHYCTL_TIMEOUT      7:7             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RSTSEQ_PHYCTL_TIMEOUT_NONE 0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RSTSEQ_PHYCTL_TIMEOUT_CLEAR 0x00000001     /* RW--V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RSTSEQ_CLKCTL_TIMEOUT      8:8             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RSTSEQ_CLKCTL_TIMEOUT_NONE 0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_STATUS_0_RSTSEQ_CLKCTL_TIMEOUT_CLEAR 0x00000001     /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0                   0x00000288      /* RW-4R */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_SLEEPWHILEACTIVELINK 0:0          /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_SLEEPWHILEACTIVELINK__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_SLEEPWHILEACTIVELINK_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_SLEEPWHILEACTIVELINK_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_ILLEGALLINKSTATEREQUEST 1:1       /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_ILLEGALLINKSTATEREQUEST_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_ILLEGALLINKSTATEREQUEST_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_FAILEDMINIONREQUEST 2:2           /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_FAILEDMINIONREQUEST_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_FAILEDMINIONREQUEST_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RESERVEDREQUESTVALUE 3:3          /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RESERVEDREQUESTVALUE_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RESERVEDREQUESTVALUE_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_LINKSTATEWRITEWHILEBUSY 4:4       /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_LINKSTATEWRITEWHILEBUSY_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_LINKSTATEWRITEWHILEBUSY_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_LINK_STATE_REQUEST_TIMEOUT 5:5    /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_LINK_STATE_REQUEST_TIMEOUT_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_LINK_STATE_REQUEST_TIMEOUT_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR 6:6 /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_PHYCTL_TIMEOUT 7:7         /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_PHYCTL_TIMEOUT__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_PHYCTL_TIMEOUT_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_PHYCTL_TIMEOUT_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_CLKCTL_TIMEOUT 8:8         /* RWEVF */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_CLKCTL_TIMEOUT__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_CLKCTL_TIMEOUT_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_FATAL_REPORT_EN_0_RSTSEQ_CLKCTL_TIMEOUT_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0               0x0000028c      /* RW-4R */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_SLEEPWHILEACTIVELINK 0:0      /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_SLEEPWHILEACTIVELINK_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_SLEEPWHILEACTIVELINK_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_ILLEGALLINKSTATEREQUEST 1:1   /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_ILLEGALLINKSTATEREQUEST__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_ILLEGALLINKSTATEREQUEST_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_ILLEGALLINKSTATEREQUEST_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_FAILEDMINIONREQUEST 2:2       /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_FAILEDMINIONREQUEST__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_FAILEDMINIONREQUEST_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_FAILEDMINIONREQUEST_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RESERVEDREQUESTVALUE 3:3      /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RESERVEDREQUESTVALUE__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RESERVEDREQUESTVALUE_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RESERVEDREQUESTVALUE_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINKSTATEWRITEWHILEBUSY 4:4   /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINKSTATEWRITEWHILEBUSY__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINKSTATEWRITEWHILEBUSY_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINKSTATEWRITEWHILEBUSY_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINK_STATE_REQUEST_TIMEOUT 5:5 /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINK_STATE_REQUEST_TIMEOUT__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINK_STATE_REQUEST_TIMEOUT_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_LINK_STATE_REQUEST_TIMEOUT_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR 6:6 /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR__PROD 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RSTSEQ_PHYCTL_TIMEOUT 7:7     /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RSTSEQ_PHYCTL_TIMEOUT_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RSTSEQ_PHYCTL_TIMEOUT_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RSTSEQ_CLKCTL_TIMEOUT 8:8     /* RWEVF */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RSTSEQ_CLKCTL_TIMEOUT_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLIPT_LNK_ERR_NON_FATAL_REPORT_EN_0_RSTSEQ_CLKCTL_TIMEOUT_ENABLE 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0                     0x00000298      /* RW-4R */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_SLEEPWHILEACTIVELINK 0:0            /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_SLEEPWHILEACTIVELINK_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_SLEEPWHILEACTIVELINK_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_ILLEGALLINKSTATEREQUEST 1:1         /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_ILLEGALLINKSTATEREQUEST_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_ILLEGALLINKSTATEREQUEST_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_FAILEDMINIONREQUEST 2:2             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_FAILEDMINIONREQUEST_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_FAILEDMINIONREQUEST_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RESERVEDREQUESTVALUE 3:3            /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RESERVEDREQUESTVALUE_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RESERVEDREQUESTVALUE_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_LINKSTATEWRITEWHILEBUSY 4:4         /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_LINKSTATEWRITEWHILEBUSY_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_LINKSTATEWRITEWHILEBUSY_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_LINK_STATE_REQUEST_TIMEOUT 5:5      /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_LINK_STATE_REQUEST_TIMEOUT_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_LINK_STATE_REQUEST_TIMEOUT_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR 6:6  /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RSTSEQ_PHYCTL_TIMEOUT 7:7           /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RSTSEQ_PHYCTL_TIMEOUT_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RSTSEQ_PHYCTL_TIMEOUT_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RSTSEQ_CLKCTL_TIMEOUT 8:8           /* RWIVF */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RSTSEQ_CLKCTL_TIMEOUT_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_REPORT_INJECT_0_RSTSEQ_CLKCTL_TIMEOUT_INSERT 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0                             0x0000029c      /* RW-4R */
#define NV_NVLIPT_LNK_ERR_FIRST_0_SLEEPWHILEACTIVELINK        0:0             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_SLEEPWHILEACTIVELINK_NONE   0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_SLEEPWHILEACTIVELINK_CLEAR  0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_ILLEGALLINKSTATEREQUEST     1:1             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_ILLEGALLINKSTATEREQUEST_NONE 0x00000000     /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_ILLEGALLINKSTATEREQUEST_CLEAR 0x00000001    /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_FAILEDMINIONREQUEST         2:2             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_FAILEDMINIONREQUEST_NONE    0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_FAILEDMINIONREQUEST_CLEAR   0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RESERVEDREQUESTVALUE        3:3             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RESERVEDREQUESTVALUE_NONE   0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RESERVEDREQUESTVALUE_CLEAR  0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_LINKSTATEWRITEWHILEBUSY     4:4             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_LINKSTATEWRITEWHILEBUSY_NONE 0x00000000     /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_LINKSTATEWRITEWHILEBUSY_CLEAR 0x00000001    /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_LINK_STATE_REQUEST_TIMEOUT  5:5             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_LINK_STATE_REQUEST_TIMEOUT_NONE 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_LINK_STATE_REQUEST_TIMEOUT_CLEAR 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR 6:6          /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_NONE 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_WRITE_TO_LOCKED_SYSTEM_REG_ERR_CLEAR 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RSTSEQ_PHYCTL_TIMEOUT       7:7             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RSTSEQ_PHYCTL_TIMEOUT_NONE  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RSTSEQ_PHYCTL_TIMEOUT_CLEAR 0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RSTSEQ_CLKCTL_TIMEOUT       8:8             /* RWIVF */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RSTSEQ_CLKCTL_TIMEOUT_NONE  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_ERR_FIRST_0_RSTSEQ_CLKCTL_TIMEOUT_CLEAR 0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_INTR_CONTROL_LINK                       0x00000300      /* RW-4R */
#define NV_NVLIPT_LNK_INTR_CONTROL_LINK_INT0_EN               0:0             /* RWEVF */
#define NV_NVLIPT_LNK_INTR_CONTROL_LINK_INT0_EN_DISABLE       0x00000000      /* RWE-V */
#define NV_NVLIPT_LNK_INTR_CONTROL_LINK_INT0_EN_ENABLE        0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_INTR_CONTROL_LINK_INT1_EN               1:1             /* RWEVF */
#define NV_NVLIPT_LNK_INTR_CONTROL_LINK_INT1_EN_DISABLE       0x00000000      /* RWE-V */
#define NV_NVLIPT_LNK_INTR_CONTROL_LINK_INT1_EN_ENABLE        0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_RESET_RSTSEQ_LINK_RESET                 0x00000380      /* RW-4R */
#define NV_NVLIPT_LNK_RESET_RSTSEQ_LINK_RESET_LINK_RESET      0:0             /* RWEVF */
#define NV_NVLIPT_LNK_RESET_RSTSEQ_LINK_RESET_LINK_RESET_DEASSERT 0x00000000  /* RW--V */
#define NV_NVLIPT_LNK_RESET_RSTSEQ_LINK_RESET_LINK_RESET_ASSERT 0x00000001    /* RWE-V */
#define NV_NVLIPT_LNK_RESET_RSTSEQ_LINK_RESET_LINK_RESET_STATUS 1:1           /* R-EVF */
#define NV_NVLIPT_LNK_RESET_RSTSEQ_LINK_RESET_LINK_RESET_STATUS_DEASSERTED 0x00000000 /* R---V */
#define NV_NVLIPT_LNK_RESET_RSTSEQ_LINK_RESET_LINK_RESET_STATUS_ASSERTED 0x00000001 /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST                 0x00000480      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_REQUEST         3:0             /* RWEVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_REQUEST_NOP     0x00000000      /* RWE-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_REQUEST_ACTIVE  0x00000001      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_REQUEST_L2      0x00000002      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_REQUEST_EMPTY   0x00000008      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_REQUEST_RESET   0x00000009      /* RW--V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS          15:8            /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS_INIT     0x00000000      /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS_REQUEST_SUCCESSFUL 0x00000001 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS_ILLEGAL_STATE_REQUEST 0x00000002 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS_RESET_SEQ_TIMEOUT 0x00000003 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS_MINION_REQUEST_NOT_ENABLED 0x00000004 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS_REQUEST_TIMEOUT 0x00000005 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_STATUS_MINION_REQUEST_FAIL 0x00000080 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_ERR             30:30           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_ERR_NOERR       0x00000000      /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_ERR_ERR         0x00000001      /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_READY           31:31           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_REQUEST_READY_INIT      0x00000001      /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS                  0x00000484      /* R--4R */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_CURRENTLINKSTATE 3:0             /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_CURRENTLINKSTATE_ACTIVE 0x00000001 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_CURRENTLINKSTATE_L2 0x00000002   /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_CURRENTLINKSTATE_EMPTY 0x00000008 /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_CURRENTLINKSTATE_RESET 0x00000009 /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_CURRENTLINKSTATE_CONTAIN 0x0000000e /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_CURRENTLINKSTATE_DISABLE 0x0000000f /* R---V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_TXTLBUFFEREMPTY  8:8             /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_TXTLBUFFEREMPTY_INIT 0x00000000  /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_TXREPLAYBUFFEREMPTY 9:9          /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_TXREPLAYBUFFEREMPTY_INIT 0x00000000 /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_RXTLBUFFEREMPTY  11:11           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_RXTLBUFFEREMPTY_INIT 0x00000000  /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_RMTTXBUFFEREMPTY 13:13           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_RMTTXBUFFEREMPTY_INIT 0x00000000 /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_RMTRXBUFFEREMPTY 14:14           /* R-EVF */
#define NV_NVLIPT_LNK_CTRL_LINK_STATE_STATUS_RMTRXBUFFEREMPTY_INIT 0x00000000 /* R-E-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL              0x00000600      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_LINK_DISABLE 0:0             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_LINK_DISABLE_ENABLED 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_LINK_DISABLE_DISABLED 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_1   1:1             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_1_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_2   2:2             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_2_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_3   3:3             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_3_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_4   4:4             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_4_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_5   5:5             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_5_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_6   6:6             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_6_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_7   7:7             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_7_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_8   8:8             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_8_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_9   9:9             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_9_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_10  10:10           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_10_INIT 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_11  11:11           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_11_INIT 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_12  12:12           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_12_INIT 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_13  13:13           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_13_INIT 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_14  14:14           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_14_INIT 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_15  15:15           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_MODE_CTRL_RESERVED_15_INIT 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL               0x0000060c      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_MODE 1:0      /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_MODE_COMMON 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_MODE_RESERVED 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_MODE_NON_COMMON_NO_SS 0x00000002 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_MODE_NON_COMMON_SS 0x00000003 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_FREQUENCY 5:4 /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_FREQUENCY_156_25_MHZ 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_REFERENCE_CLOCK_FREQUENCY_150_00_MHZ 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE     15:8            /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_50_00000_GBPS 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_16_00000_GBPS 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_20_00000_GBPS 0x00000002 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_25_00000_GBPS 0x00000003 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_25_78125_GBPS 0x00000004 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_32_00000_GBPS 0x00000005 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_40_00000_GBPS 0x00000006 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_53_12500_GBPS 0x00000007 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CLK_CTRL_LINE_RATE_ILLEGAL_LINE_RATE 0x000000ff /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL           0x00000618      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_AC_DC_MODE 0:0            /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_AC_DC_MODE_AC 0x00000001  /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_AC_DC_MODE_DC 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_LINE_CODE_MODE 2:1        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_LINE_CODE_MODE_NRZ 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_LINE_CODE_MODE_NRZ_128B130 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_LINE_CODE_MODE_PAM4 0x00000003 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_RECEIVER_DETECT_ENABLE 3:3 /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_RECEIVER_DETECT_ENABLE_ENABLE 0x00000001 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_RECEIVER_DETECT_ENABLE_DISABLE 0x00000000 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_BLOCK_CODE_MODE 7:6       /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_BLOCK_CODE_MODE_OFF 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_BLOCK_CODE_MODE_ECC96_ENABLED 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_BLOCK_CODE_MODE_ECC88_ENABLED 0x00000002 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_FOM_FORMAT 10:8   /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_FOM_FORMAT_INIT 0x00000005 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_FOM_FORMAT_FOMA 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_FOM_FORMAT_FOMB 0x00000002 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_FOM_FORMAT_FOMC 0x00000004 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM 18:11 /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_INIT 0x00000017 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A0 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A1 0x00000002 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A2 0x00000004 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A3 0x00000008 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A4 0x00000010 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A5 0x00000020 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A6 0x00000040 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_OPTIMIZATION_ALGORITHM_A7 0x00000080 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_ADJUSTMENT_ALGORITHM 23:19 /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_ADJUSTMENT_ALGORITHM_INIT 0x00000003 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_ADJUSTMENT_ALGORITHM_B0 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_ADJUSTMENT_ALGORITHM_B1 0x00000002 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_ADJUSTMENT_ALGORITHM_B2 0x00000004 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_ADJUSTMENT_ALGORITHM_B3 0x00000008 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_MINIMUM_TRAIN_TIME_MANTISSA 27:24 /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_MINIMUM_TRAIN_TIME_MANTISSA_INIT 0x00000002 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_MINIMUM_TRAIN_TIME_EXPONENT 31:28 /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL_TXTRAIN_MINIMUM_TRAIN_TIME_EXPONENT_INIT 0x00000003 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2          0x00000624      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESTORE_PHY_TRAINING_PARAMS 0:0 /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESTORE_PHY_TRAINING_PARAMS_ENABLE 0x00000001 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESTORE_PHY_TRAINING_PARAMS_DISABLE 0x00000000 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_1 1:1           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_1_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_2 2:2           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_2_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_3 3:3           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_3_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_4 4:4           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_4_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_5 5:5           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_5_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_6 6:6           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_6_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_7 7:7           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_7_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_8 8:8           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_8_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_9 9:9           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_9_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_10 10:10        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_10_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_11 11:11        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_11_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_12 12:12        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_12_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_13 13:13        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_13_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_14 14:14        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_14_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_15 15:15        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_15_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_16 16:16        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_16_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_17 17:17        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_17_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_18 18:18        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_18_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_19 19:19        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_19_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_20 20:20        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_20_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_21 21:21        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_21_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_22 22:22        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_22_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_23 23:23        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_23_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_24 24:24        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_24_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_25 25:25        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_25_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_26 26:26        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_26_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_27 27:27        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_27_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_28 28:28        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_28_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_29 29:29        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_29_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_30 30:30        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_30_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_31 31:31        /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_CHANNEL_CTRL2_RESERVED_31_INIT 0x00000000 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL               0x00000638      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_PWRM_SL_ENABLE 0:0            /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_PWRM_SL_ENABLE_ENABLE 0x00000001 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_PWRM_SL_ENABLE_DISABLE 0x00000000 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_RESERVED_1    1:1             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_RESERVED_1_INIT 0x00000000    /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_PWRM_L2_ENABLE 2:2            /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_PWRM_L2_ENABLE_ENABLE 0x00000001 /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_PWRM_L2_ENABLE_DISABLE 0x00000000 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_RESERVED_3    3:3             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SYSTEM_LINK_AN1_CTRL_RESERVED_3_INIT 0x00000000    /* RWI-V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_SID_LO             0x00000108      /* RW-4R */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_SID_LO_SID_31_0    31:0            /* RWIVF */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_SID_LO_SID_31_0_INIT 0x00000000    /* RWI-V */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_SID_HI             0x0000010c      /* RW-4R */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_SID_HI_SID_63_32   31:0            /* RWIVF */
#define NV_NVLIPT_LNK_TOPOLOGY_REMOTE_CHIP_SID_HI_SID_63_32_INIT 0x00000000   /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL                  0x0000064c      /* RW-4R */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_LINK_DISABLE     0:0             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_LINK_DISABLE_ENABLED 0x00000000  /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_LINK_DISABLE_DISABLED 0x00000001 /* RW--V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_1       1:1             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_1_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_2       2:2             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_2_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_3       3:3             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_3_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_4       4:4             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_4_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_5       5:5             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_5_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_6       6:6             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_6_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_7       7:7             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_7_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_8       8:8             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_8_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_9       9:9             /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_9_INIT  0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_10      10:10           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_10_INIT 0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_11      11:11           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_11_INIT 0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_12      12:12           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_12_INIT 0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_13      13:13           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_13_INIT 0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_14      14:14           /* RWIVF */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_14_INIT 0x00000000      /* RWI-V */
#define NV_NVLIPT_LNK_CTRL_SW_LINK_MODE_CTRL_RESERVED_15      15:15           /* RWIVF */
#endif // __lr10_dev_nvlipt_lnk_ip_h__
