TEMPLATE	= app
LANGUAGE	= C++
TARGET	 = algobox
CONFIG	+= qt warn_off release
QT_VERSION=$$[QT_VERSION]
contains( QT_VERSION, "^5.*" ) {
QT += xml webkitwidgets network widgets printsupport
} else {
QT += xml webkit network
}
ALGOBOXVERSION=0.9
DEFINES += ALGOBOXVERSION=\\\"$${ALGOBOXVERSION}\\\"
###############################
HEADERS	+= algobox.h \
	algoconsole.h \
	browserdialog.h \
	browser.h \
	consoledialog.h \
	animatedlabel.h \
	variabledialog.h \
	modifierlignedialog.h \
	liredialog.h \
	afficherdialog.h \
	messagedialog.h \
	affectationdialog.h \
	conditiondialog.h \
	pourdialog.h \
	pourlineedit.h \
	tantquedialog.h \
	pointdialog.h \
	segmentdialog.h \
	aproposdialog.h \
	algowebview.h \
	algowebpage.h \
	commentairedialog.h \
	loghighlighter.h \
	consolehighlighter.h \
	algoeditor.h \
	algohighlighter.h \
	algoeditorview.h \
	linenumberwidget.h \
	findwidget.h \
	blockdata.h \
	replacedialog.h \
	verifdialog.h \
	treedelegate.h \
	x11fontdialog.h \
	jsmainwindow.h \
	jseditorview.h \
	jseditor.h \
	jshighlighter.h \
	jslinenumberwidget.h \
	jsfindwidget.h \
	jsreplacedialog.h \
	geticon.h \
	latexhighlighter.h \
	toolbox.h \
	latexviewdialog.h \
	configdialog.h \
	affichercalculdialog.h
SOURCES	+= main.cpp \
	algobox.cpp \
	algoconsole.cpp \
	browser.cpp \
	consoledialog.cpp \
	browserdialog.cpp \
	animatedlabel.cpp \
	variabledialog.cpp \
	modifierlignedialog.cpp \
	liredialog.cpp \
	afficherdialog.cpp \
	messagedialog.cpp \
	affectationdialog.cpp \
	conditiondialog.cpp \
	pourdialog.cpp \
	pourlineedit.cpp \
	tantquedialog.cpp \
	pointdialog.cpp \
	segmentdialog.cpp \
	aproposdialog.cpp \
	algowebview.cpp \
	algowebpage.cpp \
	commentairedialog.cpp \
	loghighlighter.cpp \
	consolehighlighter.cpp \
	algoeditor.cpp \
	algohighlighter.cpp \
	algoeditorview.cpp \
	linenumberwidget.cpp \
	findwidget.cpp \
	blockdata.cpp \
	replacedialog.cpp \
	verifdialog.cpp \
	treedelegate.cpp \
	x11fontdialog.cpp \
	jsmainwindow.cpp \
	jseditorview.cpp \
	jseditor.cpp \
	jshighlighter.cpp \
	jslinenumberwidget.cpp \
	jsfindwidget.cpp \
	jsreplacedialog.cpp \
	geticon.cpp \
	latexhighlighter.cpp \
	toolbox.cpp \
	latexviewdialog.cpp \
	configdialog.cpp \
	affichercalculdialog.cpp
RESOURCES += algobox.qrc
FORMS += algobox.ui \
	browserdialog.ui \
	consoledialog.ui \
	variabledialog.ui \
	modifierlignedialog.ui \
	liredialog.ui \
	afficherdialog.ui \
	messagedialog.ui \
	affectationdialog.ui \
	conditiondialog.ui \
	pourdialog.ui \
	tantquedialog.ui \
	pointdialog.ui \
	segmentdialog.ui \
	aproposdialog.ui \
	commentairedialog.ui \
	findwidget.ui \
	replacedialog.ui \
	verifdialog.ui \
	x11fontdialog.ui \
	latexviewdialog.ui \
	configdialog.ui \
	affichercalculdialog.ui
################################
unix:!macx {

UI_DIR = .ui
MOC_DIR = .moc
OBJECTS_DIR = .obj
isEmpty( PREFIX ) {
    PREFIX=/usr
}
isEmpty( DESKTOPDIR ) {
    DESKTOPDIR=/usr/share/applications
}
isEmpty( ICONDIR ) {
    ICONDIR=/usr/share/pixmaps
}
DEFINES += PREFIX=\\\"$${PREFIX}\\\"

contains( QT_VERSION, "^5.*" ) {
INCLUDEPATH +=$${QTDIR}/include/
} 


target.path = $${PREFIX}/bin
utilities.path = $${PREFIX}/share/algobox
desktop.path = $${DESKTOPDIR}
icon.path = $${ICONDIR}

INSTALLS = target

utilities.files = utilities/qt_fr.qm \
		ressources/eleve_calcul_recurrent.alg \
		ressources/eleve_distance_sur_un_axe.alg \
		ressources/eleve_que_fait_lalgo.alg \
		ressources/eleve_simplification_calculs_enchaines.alg \
		ressources/eleve_simul_lancers_de.alg \
		ressources/prof_babylone.alg \
		ressources/prof_balayage_fonctions.alg \
		ressources/prof_courbe_fonction.alg \
		ressources/prof_decomp_facteurspremiers.alg \
		ressources/prof_dichotomie.alg \
		ressources/prof_ductoscane.alg \
		ressources/prof_euler.alg \
		ressources/prof_integrale_trapezes.alg \
		ressources/prof_montecarlo.alg \
		ressources/prof_pgcd_euclide.alg \
		ressources/prof_somme_entiers.alg \
		ressources/prof_suite_syracuse.alg \
		ressources/prof_tri_abulle.alg \
		ressources/prof_pgcd_recursif.alg \
		ressources/aidealgobox.html \
		utilities/AUTHORS \
		utilities/COPYING \
		utilities/CHANGELOG.txt 
INSTALLS += utilities


desktop.files = utilities/algobox.desktop
INSTALLS += desktop

icon.files = utilities/algobox.png
INSTALLS += icon
}
