package com.kreative.bitsnpicas.truetype;

public class PostTableEntry {
	private final Integer intValue;
	private final String stringValue;
	
	public PostTableEntry(int intValue) {
		this.intValue = intValue;
		this.stringValue = null;
	}
	
	public PostTableEntry(String stringValue) {
		this.intValue = null;
		this.stringValue = stringValue;
	}
	
	public static PostTableEntry forCharacter(int ch) {
		if (ch < 0) {
			return new PostTableEntry(0);
		} else if (ch >= 0x20 && ch <= 0x7E) {
			return new PostTableEntry(ch - 29);
		} else switch (ch) {
			case 0x0000: return new PostTableEntry(1);
			case 0x000d: return new PostTableEntry(2);
			case 0x00a0: return new PostTableEntry("uni00A0"); // 172
			case 0x00a1: return new PostTableEntry(163);
			case 0x00a2: return new PostTableEntry(132);
			case 0x00a3: return new PostTableEntry(133);
			case 0x00a4: return new PostTableEntry(189);
			case 0x00a5: return new PostTableEntry(150);
			case 0x00a6: return new PostTableEntry(232);
			case 0x00a7: return new PostTableEntry(134);
			case 0x00a8: return new PostTableEntry(142);
			case 0x00a9: return new PostTableEntry(139);
			case 0x00aa: return new PostTableEntry(157);
			case 0x00ab: return new PostTableEntry(169);
			case 0x00ac: return new PostTableEntry(164);
			case 0x00ad: return new PostTableEntry("hyphen");
			case 0x00ae: return new PostTableEntry(138);
			case 0x00af: return new PostTableEntry(218);
			case 0x00b0: return new PostTableEntry(131);
			case 0x00b1: return new PostTableEntry(147);
			case 0x00b2: return new PostTableEntry(242);
			case 0x00b3: return new PostTableEntry(243);
			case 0x00b4: return new PostTableEntry(141);
			case 0x00b5: return new PostTableEntry(151);
			case 0x00b6: return new PostTableEntry(136);
			case 0x00b7: return new PostTableEntry("periodcentered");
			case 0x00b8: return new PostTableEntry(222);
			case 0x00b9: return new PostTableEntry(241);
			case 0x00ba: return new PostTableEntry(158);
			case 0x00bb: return new PostTableEntry(170);
			case 0x00bc: return new PostTableEntry(245);
			case 0x00bd: return new PostTableEntry(244);
			case 0x00be: return new PostTableEntry(246);
			case 0x00bf: return new PostTableEntry(162);
			case 0x00c0: return new PostTableEntry(173);
			case 0x00c1: return new PostTableEntry(201);
			case 0x00c2: return new PostTableEntry(199);
			case 0x00c3: return new PostTableEntry(174);
			case 0x00c4: return new PostTableEntry(98);
			case 0x00c5: return new PostTableEntry(99);
			case 0x00c6: return new PostTableEntry(144);
			case 0x00c7: return new PostTableEntry(100);
			case 0x00c8: return new PostTableEntry(203);
			case 0x00c9: return new PostTableEntry(101);
			case 0x00ca: return new PostTableEntry(200);
			case 0x00cb: return new PostTableEntry(202);
			case 0x00cc: return new PostTableEntry(207);
			case 0x00cd: return new PostTableEntry(204);
			case 0x00ce: return new PostTableEntry(205);
			case 0x00cf: return new PostTableEntry(206);
			case 0x00d0: return new PostTableEntry(233);
			case 0x00d1: return new PostTableEntry(102);
			case 0x00d2: return new PostTableEntry(211);
			case 0x00d3: return new PostTableEntry(208);
			case 0x00d4: return new PostTableEntry(209);
			case 0x00d5: return new PostTableEntry(175);
			case 0x00d6: return new PostTableEntry(103);
			case 0x00d7: return new PostTableEntry(240);
			case 0x00d8: return new PostTableEntry(145);
			case 0x00d9: return new PostTableEntry(214);
			case 0x00da: return new PostTableEntry(212);
			case 0x00db: return new PostTableEntry(213);
			case 0x00dc: return new PostTableEntry(104);
			case 0x00dd: return new PostTableEntry(235);
			case 0x00de: return new PostTableEntry(237);
			case 0x00df: return new PostTableEntry(137);
			case 0x00e0: return new PostTableEntry(106);
			case 0x00e1: return new PostTableEntry(105);
			case 0x00e2: return new PostTableEntry(107);
			case 0x00e3: return new PostTableEntry(109);
			case 0x00e4: return new PostTableEntry(108);
			case 0x00e5: return new PostTableEntry(110);
			case 0x00e6: return new PostTableEntry(160);
			case 0x00e7: return new PostTableEntry(111);
			case 0x00e8: return new PostTableEntry(113);
			case 0x00e9: return new PostTableEntry(112);
			case 0x00ea: return new PostTableEntry(114);
			case 0x00eb: return new PostTableEntry(115);
			case 0x00ec: return new PostTableEntry(117);
			case 0x00ed: return new PostTableEntry(116);
			case 0x00ee: return new PostTableEntry(118);
			case 0x00ef: return new PostTableEntry(119);
			case 0x00f0: return new PostTableEntry(234);
			case 0x00f1: return new PostTableEntry(120);
			case 0x00f2: return new PostTableEntry(122);
			case 0x00f3: return new PostTableEntry(121);
			case 0x00f4: return new PostTableEntry(123);
			case 0x00f5: return new PostTableEntry(125);
			case 0x00f6: return new PostTableEntry(124);
			case 0x00f7: return new PostTableEntry(184);
			case 0x00f8: return new PostTableEntry(161);
			case 0x00f9: return new PostTableEntry(127);
			case 0x00fa: return new PostTableEntry(126);
			case 0x00fb: return new PostTableEntry(128);
			case 0x00fc: return new PostTableEntry(129);
			case 0x00fd: return new PostTableEntry(236);
			case 0x00fe: return new PostTableEntry(238);
			case 0x00ff: return new PostTableEntry(186);
			case 0x0100: return new PostTableEntry("Amacron");
			case 0x0101: return new PostTableEntry("amacron");
			case 0x0102: return new PostTableEntry("Abreve");
			case 0x0103: return new PostTableEntry("abreve");
			case 0x0104: return new PostTableEntry("Aogonek");
			case 0x0105: return new PostTableEntry("aogonek");
			case 0x0106: return new PostTableEntry(253);
			case 0x0107: return new PostTableEntry(254);
			case 0x0108: return new PostTableEntry("Ccircumflex");
			case 0x0109: return new PostTableEntry("ccircumflex");
			case 0x010a: return new PostTableEntry("Cdotaccent");
			case 0x010b: return new PostTableEntry("cdotaccent");
			case 0x010c: return new PostTableEntry(255);
			case 0x010d: return new PostTableEntry(256);
			case 0x010e: return new PostTableEntry("Dcaron");
			case 0x010f: return new PostTableEntry("dcaron");
			case 0x0110: return new PostTableEntry("Dcroat");
			case 0x0111: return new PostTableEntry(257);
			case 0x0112: return new PostTableEntry("Emacron");
			case 0x0113: return new PostTableEntry("emacron");
			case 0x0114: return new PostTableEntry("Ebreve");
			case 0x0115: return new PostTableEntry("ebreve");
			case 0x0116: return new PostTableEntry("Edotaccent");
			case 0x0117: return new PostTableEntry("edotaccent");
			case 0x0118: return new PostTableEntry("Eogonek");
			case 0x0119: return new PostTableEntry("eogonek");
			case 0x011a: return new PostTableEntry("Ecaron");
			case 0x011b: return new PostTableEntry("ecaron");
			case 0x011c: return new PostTableEntry("Gcircumflex");
			case 0x011d: return new PostTableEntry("gcircumflex");
			case 0x011e: return new PostTableEntry(248);
			case 0x011f: return new PostTableEntry(249);
			case 0x0120: return new PostTableEntry("Gdotaccent");
			case 0x0121: return new PostTableEntry("gdotaccent");
			case 0x0122: return new PostTableEntry("Gcommaaccent");
			case 0x0123: return new PostTableEntry("gcommaaccent");
			case 0x0124: return new PostTableEntry("Hcircumflex");
			case 0x0125: return new PostTableEntry("hcircumflex");
			case 0x0126: return new PostTableEntry("Hbar");
			case 0x0127: return new PostTableEntry("hbar");
			case 0x0128: return new PostTableEntry("Itilde");
			case 0x0129: return new PostTableEntry("itilde");
			case 0x012a: return new PostTableEntry("Imacron");
			case 0x012b: return new PostTableEntry("imacron");
			case 0x012c: return new PostTableEntry("Ibreve");
			case 0x012d: return new PostTableEntry("ibreve");
			case 0x012e: return new PostTableEntry("Iogonek");
			case 0x012f: return new PostTableEntry("iogonek");
			case 0x0130: return new PostTableEntry(250);
			case 0x0131: return new PostTableEntry(215);
			case 0x0132: return new PostTableEntry("IJ");
			case 0x0133: return new PostTableEntry("ij");
			case 0x0134: return new PostTableEntry("Jcircumflex");
			case 0x0135: return new PostTableEntry("jcircumflex");
			case 0x0136: return new PostTableEntry("Kcommaaccent");
			case 0x0137: return new PostTableEntry("kcommaaccent");
			case 0x0138: return new PostTableEntry("kgreenlandic");
			case 0x0139: return new PostTableEntry("Lacute");
			case 0x013a: return new PostTableEntry("lacute");
			case 0x013b: return new PostTableEntry("Lcommaaccent");
			case 0x013c: return new PostTableEntry("lcommaaccent");
			case 0x013d: return new PostTableEntry("Lcaron");
			case 0x013e: return new PostTableEntry("lcaron");
			case 0x013f: return new PostTableEntry("Ldot");
			case 0x0140: return new PostTableEntry("ldot");
			case 0x0141: return new PostTableEntry(226);
			case 0x0142: return new PostTableEntry(227);
			case 0x0143: return new PostTableEntry("Nacute");
			case 0x0144: return new PostTableEntry("nacute");
			case 0x0145: return new PostTableEntry("Ncommaaccent");
			case 0x0146: return new PostTableEntry("ncommaaccent");
			case 0x0147: return new PostTableEntry("Ncaron");
			case 0x0148: return new PostTableEntry("ncaron");
			case 0x0149: return new PostTableEntry("napostrophe");
			case 0x014a: return new PostTableEntry("Eng");
			case 0x014b: return new PostTableEntry("eng");
			case 0x014c: return new PostTableEntry("Omacron");
			case 0x014d: return new PostTableEntry("omacron");
			case 0x014e: return new PostTableEntry("Obreve");
			case 0x014f: return new PostTableEntry("obreve");
			case 0x0150: return new PostTableEntry("Ohungarumlaut");
			case 0x0151: return new PostTableEntry("ohungarumlaut");
			case 0x0152: return new PostTableEntry(176);
			case 0x0153: return new PostTableEntry(177);
			case 0x0154: return new PostTableEntry("Racute");
			case 0x0155: return new PostTableEntry("racute");
			case 0x0156: return new PostTableEntry("Rcommaaccent");
			case 0x0157: return new PostTableEntry("rcommaaccent");
			case 0x0158: return new PostTableEntry("Rcaron");
			case 0x0159: return new PostTableEntry("rcaron");
			case 0x015a: return new PostTableEntry("Sacute");
			case 0x015b: return new PostTableEntry("sacute");
			case 0x015c: return new PostTableEntry("Scircumflex");
			case 0x015d: return new PostTableEntry("scircumflex");
			case 0x015e: return new PostTableEntry(251);
			case 0x015f: return new PostTableEntry(252);
			case 0x0160: return new PostTableEntry(228);
			case 0x0161: return new PostTableEntry(229);
			case 0x0162: return new PostTableEntry("Tcommaaccent");
			case 0x0163: return new PostTableEntry("tcommaaccent");
			case 0x0164: return new PostTableEntry("Tcaron");
			case 0x0165: return new PostTableEntry("tcaron");
			case 0x0166: return new PostTableEntry("Tbar");
			case 0x0167: return new PostTableEntry("tbar");
			case 0x0168: return new PostTableEntry("Utilde");
			case 0x0169: return new PostTableEntry("utilde");
			case 0x016a: return new PostTableEntry("Umacron");
			case 0x016b: return new PostTableEntry("umacron");
			case 0x016c: return new PostTableEntry("Ubreve");
			case 0x016d: return new PostTableEntry("ubreve");
			case 0x016e: return new PostTableEntry("Uring");
			case 0x016f: return new PostTableEntry("uring");
			case 0x0170: return new PostTableEntry("Uhungarumlaut");
			case 0x0171: return new PostTableEntry("uhungarumlaut");
			case 0x0172: return new PostTableEntry("Uogonek");
			case 0x0173: return new PostTableEntry("uogonek");
			case 0x0174: return new PostTableEntry("Wcircumflex");
			case 0x0175: return new PostTableEntry("wcircumflex");
			case 0x0176: return new PostTableEntry("Ycircumflex");
			case 0x0177: return new PostTableEntry("ycircumflex");
			case 0x0178: return new PostTableEntry(187);
			case 0x0179: return new PostTableEntry("Zacute");
			case 0x017a: return new PostTableEntry("zacute");
			case 0x017b: return new PostTableEntry("Zdotaccent");
			case 0x017c: return new PostTableEntry("zdotaccent");
			case 0x017d: return new PostTableEntry(230);
			case 0x017e: return new PostTableEntry(231);
			case 0x017f: return new PostTableEntry("longs");
			case 0x0192: return new PostTableEntry(166);
			case 0x01fa: return new PostTableEntry("Aringacute");
			case 0x01fb: return new PostTableEntry("aringacute");
			case 0x01fc: return new PostTableEntry("AEacute");
			case 0x01fd: return new PostTableEntry("aeacute");
			case 0x01fe: return new PostTableEntry("Oslashacute");
			case 0x01ff: return new PostTableEntry("oslashacute");
			case 0x02c6: return new PostTableEntry(216);
			case 0x02c7: return new PostTableEntry(225);
			case 0x02c9: return new PostTableEntry("macron");
			case 0x02d8: return new PostTableEntry(219);
			case 0x02d9: return new PostTableEntry(220);
			case 0x02da: return new PostTableEntry(221);
			case 0x02db: return new PostTableEntry(224);
			case 0x02dc: return new PostTableEntry("tilde");
			case 0x02dd: return new PostTableEntry(223);
			case 0x0300: return new PostTableEntry("gravecomb");
			case 0x0301: return new PostTableEntry("acutecomb");
			case 0x0303: return new PostTableEntry("tildecomb");
			case 0x0309: return new PostTableEntry("hookabovecomb");
			case 0x0323: return new PostTableEntry("dotbelowcomb");
			case 0x0384: return new PostTableEntry("tonos");
			case 0x0385: return new PostTableEntry("dieresistonos");
			case 0x0386: return new PostTableEntry("Alphatonos");
			case 0x0387: return new PostTableEntry("anoteleia");
			case 0x0388: return new PostTableEntry("Epsilontonos");
			case 0x0389: return new PostTableEntry("Etatonos");
			case 0x038a: return new PostTableEntry("Iotatonos");
			case 0x038c: return new PostTableEntry("Omicrontonos");
			case 0x038e: return new PostTableEntry("Upsilontonos");
			case 0x038f: return new PostTableEntry("Omegatonos");
			case 0x0390: return new PostTableEntry("iotadieresistonos");
			case 0x0391: return new PostTableEntry("Alpha");
			case 0x0392: return new PostTableEntry("Beta");
			case 0x0393: return new PostTableEntry("Gamma");
			case 0x0394: return new PostTableEntry("Delta");
			case 0x0395: return new PostTableEntry("Epsilon");
			case 0x0396: return new PostTableEntry("Zeta");
			case 0x0397: return new PostTableEntry("Eta");
			case 0x0398: return new PostTableEntry("Theta");
			case 0x0399: return new PostTableEntry("Iota");
			case 0x039a: return new PostTableEntry("Kappa");
			case 0x039b: return new PostTableEntry("Lambda");
			case 0x039c: return new PostTableEntry("Mu");
			case 0x039d: return new PostTableEntry("Nu");
			case 0x039e: return new PostTableEntry("Xi");
			case 0x039f: return new PostTableEntry("Omicron");
			case 0x03a0: return new PostTableEntry("Pi");
			case 0x03a1: return new PostTableEntry("Rho");
			case 0x03a3: return new PostTableEntry("Sigma");
			case 0x03a4: return new PostTableEntry("Tau");
			case 0x03a5: return new PostTableEntry("Upsilon");
			case 0x03a6: return new PostTableEntry("Phi");
			case 0x03a7: return new PostTableEntry("Chi");
			case 0x03a8: return new PostTableEntry("Psi");
			case 0x03a9: return new PostTableEntry("Omega");
			case 0x03aa: return new PostTableEntry("Iotadieresis");
			case 0x03ab: return new PostTableEntry("Upsilondieresis");
			case 0x03ac: return new PostTableEntry("alphatonos");
			case 0x03ad: return new PostTableEntry("epsilontonos");
			case 0x03ae: return new PostTableEntry("etatonos");
			case 0x03af: return new PostTableEntry("iotatonos");
			case 0x03b0: return new PostTableEntry("upsilondieresistonos");
			case 0x03b1: return new PostTableEntry("alpha");
			case 0x03b2: return new PostTableEntry("beta");
			case 0x03b3: return new PostTableEntry("gamma");
			case 0x03b4: return new PostTableEntry("delta");
			case 0x03b5: return new PostTableEntry("epsilon");
			case 0x03b6: return new PostTableEntry("zeta");
			case 0x03b7: return new PostTableEntry("eta");
			case 0x03b8: return new PostTableEntry("theta");
			case 0x03b9: return new PostTableEntry("iota");
			case 0x03ba: return new PostTableEntry("kappa");
			case 0x03bb: return new PostTableEntry("lambda");
			case 0x03bc: return new PostTableEntry("mu");
			case 0x03bd: return new PostTableEntry("nu");
			case 0x03be: return new PostTableEntry("xi");
			case 0x03bf: return new PostTableEntry("omicron");
			case 0x03c0: return new PostTableEntry(155);
			case 0x03c1: return new PostTableEntry("rho");
			case 0x03c2: return new PostTableEntry("sigma1");
			case 0x03c3: return new PostTableEntry("sigma");
			case 0x03c4: return new PostTableEntry("tau");
			case 0x03c5: return new PostTableEntry("upsilon");
			case 0x03c6: return new PostTableEntry("phi");
			case 0x03c7: return new PostTableEntry("chi");
			case 0x03c8: return new PostTableEntry("psi");
			case 0x03c9: return new PostTableEntry("omega");
			case 0x03ca: return new PostTableEntry("iotadieresis");
			case 0x03cb: return new PostTableEntry("upsilondieresis");
			case 0x03cc: return new PostTableEntry("omicrontonos");
			case 0x03cd: return new PostTableEntry("upsilontonos");
			case 0x03ce: return new PostTableEntry("omegatonos");
			case 0x0400: return new PostTableEntry("uni0400");
			case 0x0401: return new PostTableEntry("afii10023");
			case 0x0402: return new PostTableEntry("afii10051");
			case 0x0403: return new PostTableEntry("afii10052");
			case 0x0404: return new PostTableEntry("afii10053");
			case 0x0405: return new PostTableEntry("afii10054");
			case 0x0406: return new PostTableEntry("afii10055");
			case 0x0407: return new PostTableEntry("afii10056");
			case 0x0408: return new PostTableEntry("afii10057");
			case 0x0409: return new PostTableEntry("afii10058");
			case 0x040a: return new PostTableEntry("afii10059");
			case 0x040b: return new PostTableEntry("afii10060");
			case 0x040c: return new PostTableEntry("afii10061");
			case 0x040D: return new PostTableEntry("uni040D");
			case 0x040e: return new PostTableEntry("afii10062");
			case 0x040f: return new PostTableEntry("afii10145");
			case 0x0410: return new PostTableEntry("afii10017");
			case 0x0411: return new PostTableEntry("afii10018");
			case 0x0412: return new PostTableEntry("afii10019");
			case 0x0413: return new PostTableEntry("afii10020");
			case 0x0414: return new PostTableEntry("afii10021");
			case 0x0415: return new PostTableEntry("afii10022");
			case 0x0416: return new PostTableEntry("afii10024");
			case 0x0417: return new PostTableEntry("afii10025");
			case 0x0418: return new PostTableEntry("afii10026");
			case 0x0419: return new PostTableEntry("afii10027");
			case 0x041a: return new PostTableEntry("afii10028");
			case 0x041b: return new PostTableEntry("afii10029");
			case 0x041c: return new PostTableEntry("afii10030");
			case 0x041d: return new PostTableEntry("afii10031");
			case 0x041e: return new PostTableEntry("afii10032");
			case 0x041f: return new PostTableEntry("afii10033");
			case 0x0420: return new PostTableEntry("afii10034");
			case 0x0421: return new PostTableEntry("afii10035");
			case 0x0422: return new PostTableEntry("afii10036");
			case 0x0423: return new PostTableEntry("afii10037");
			case 0x0424: return new PostTableEntry("afii10038");
			case 0x0425: return new PostTableEntry("afii10039");
			case 0x0426: return new PostTableEntry("afii10040");
			case 0x0427: return new PostTableEntry("afii10041");
			case 0x0428: return new PostTableEntry("afii10042");
			case 0x0429: return new PostTableEntry("afii10043");
			case 0x042a: return new PostTableEntry("afii10044");
			case 0x042b: return new PostTableEntry("afii10045");
			case 0x042c: return new PostTableEntry("afii10046");
			case 0x042d: return new PostTableEntry("afii10047");
			case 0x042e: return new PostTableEntry("afii10048");
			case 0x042f: return new PostTableEntry("afii10049");
			case 0x0430: return new PostTableEntry("afii10065");
			case 0x0431: return new PostTableEntry("afii10066");
			case 0x0432: return new PostTableEntry("afii10067");
			case 0x0433: return new PostTableEntry("afii10068");
			case 0x0434: return new PostTableEntry("afii10069");
			case 0x0435: return new PostTableEntry("afii10070");
			case 0x0436: return new PostTableEntry("afii10072");
			case 0x0437: return new PostTableEntry("afii10073");
			case 0x0438: return new PostTableEntry("afii10074");
			case 0x0439: return new PostTableEntry("afii10075");
			case 0x043a: return new PostTableEntry("afii10076");
			case 0x043b: return new PostTableEntry("afii10077");
			case 0x043c: return new PostTableEntry("afii10078");
			case 0x043d: return new PostTableEntry("afii10079");
			case 0x043e: return new PostTableEntry("afii10080");
			case 0x043f: return new PostTableEntry("afii10081");
			case 0x0440: return new PostTableEntry("afii10082");
			case 0x0441: return new PostTableEntry("afii10083");
			case 0x0442: return new PostTableEntry("afii10084");
			case 0x0443: return new PostTableEntry("afii10085");
			case 0x0444: return new PostTableEntry("afii10086");
			case 0x0445: return new PostTableEntry("afii10087");
			case 0x0446: return new PostTableEntry("afii10088");
			case 0x0447: return new PostTableEntry("afii10089");
			case 0x0448: return new PostTableEntry("afii10090");
			case 0x0449: return new PostTableEntry("afii10091");
			case 0x044a: return new PostTableEntry("afii10092");
			case 0x044b: return new PostTableEntry("afii10093");
			case 0x044c: return new PostTableEntry("afii10094");
			case 0x044d: return new PostTableEntry("afii10095");
			case 0x044e: return new PostTableEntry("afii10096");
			case 0x044f: return new PostTableEntry("afii10097");
			case 0x0450: return new PostTableEntry("uni0450");
			case 0x0451: return new PostTableEntry("afii10071");
			case 0x0452: return new PostTableEntry("afii10099");
			case 0x0453: return new PostTableEntry("afii10100");
			case 0x0454: return new PostTableEntry("afii10101");
			case 0x0455: return new PostTableEntry("afii10102");
			case 0x0456: return new PostTableEntry("afii10103");
			case 0x0457: return new PostTableEntry("afii10104");
			case 0x0458: return new PostTableEntry("afii10105");
			case 0x0459: return new PostTableEntry("afii10106");
			case 0x045a: return new PostTableEntry("afii10107");
			case 0x045b: return new PostTableEntry("afii10108");
			case 0x045c: return new PostTableEntry("afii10109");
			case 0x045D: return new PostTableEntry("uni045D");
			case 0x045e: return new PostTableEntry("afii10110");
			case 0x045f: return new PostTableEntry("afii10193");
			case 0x0490: return new PostTableEntry("afii10050");
			case 0x0491: return new PostTableEntry("afii10098");
			case 0x1e80: return new PostTableEntry("Wgrave");
			case 0x1e81: return new PostTableEntry("wgrave");
			case 0x1e82: return new PostTableEntry("Wacute");
			case 0x1e83: return new PostTableEntry("wacute");
			case 0x1e84: return new PostTableEntry("Wdieresis");
			case 0x1e85: return new PostTableEntry("wdieresis");
			case 0x1ef2: return new PostTableEntry("Ygrave");
			case 0x1ef3: return new PostTableEntry("ygrave");
			case 0x2013: return new PostTableEntry(178);
			case 0x2014: return new PostTableEntry(179);
			case 0x2015: return new PostTableEntry("afii00208");
			case 0x2017: return new PostTableEntry("underscoredbl");
			case 0x2018: return new PostTableEntry(182);
			case 0x2019: return new PostTableEntry(183);
			case 0x201a: return new PostTableEntry(196);
			case 0x201b: return new PostTableEntry("quotereversed");
			case 0x201c: return new PostTableEntry(180);
			case 0x201d: return new PostTableEntry(181);
			case 0x201e: return new PostTableEntry(197);
			case 0x2020: return new PostTableEntry(130);
			case 0x2021: return new PostTableEntry(194);
			case 0x2022: return new PostTableEntry(135);
			case 0x2026: return new PostTableEntry(171);
			case 0x2030: return new PostTableEntry(198);
			case 0x2032: return new PostTableEntry("minute");
			case 0x2033: return new PostTableEntry("second");
			case 0x2039: return new PostTableEntry(190);
			case 0x203a: return new PostTableEntry(191);
			case 0x203c: return new PostTableEntry("exclamdbl");
			case 0x203e: return new PostTableEntry("uni203E");
			case 0x2044: return new PostTableEntry("fraction");
			case 0x207f: return new PostTableEntry("nsuperior");
			case 0x20a3: return new PostTableEntry(247);
			case 0x20a4: return new PostTableEntry("lira");
			case 0x20a7: return new PostTableEntry("peseta");
			case 0x20ac: return new PostTableEntry("Euro");
			case 0x2105: return new PostTableEntry("afii61248");
			case 0x2113: return new PostTableEntry("afii61289");
			case 0x2116: return new PostTableEntry("afii61352");
			case 0x2122: return new PostTableEntry(140);
			case 0x2126: return new PostTableEntry(159);
			case 0x212e: return new PostTableEntry("estimated");
			case 0x215b: return new PostTableEntry("oneeighth");
			case 0x215c: return new PostTableEntry("threeeighths");
			case 0x215d: return new PostTableEntry("fiveeighths");
			case 0x215e: return new PostTableEntry("seveneighths");
			case 0x2190: return new PostTableEntry("arrowleft");
			case 0x2191: return new PostTableEntry("arrowup");
			case 0x2192: return new PostTableEntry("arrowright");
			case 0x2193: return new PostTableEntry("arrowdown");
			case 0x2194: return new PostTableEntry("arrowboth");
			case 0x2195: return new PostTableEntry("arrowupdn");
			case 0x21a8: return new PostTableEntry("arrowupdnbse");
			case 0x2202: return new PostTableEntry(152);
			case 0x2206: return new PostTableEntry(168);
			case 0x220f: return new PostTableEntry(154);
			case 0x2211: return new PostTableEntry(153);
			case 0x2212: return new PostTableEntry(239);
			case 0x2215: return new PostTableEntry(188);
			case 0x2219: return new PostTableEntry(195);
			case 0x221a: return new PostTableEntry(165);
			case 0x221e: return new PostTableEntry(146);
			case 0x221f: return new PostTableEntry("orthogonal");
			case 0x2229: return new PostTableEntry("intersection");
			case 0x222b: return new PostTableEntry(156);
			case 0x2248: return new PostTableEntry(167);
			case 0x2260: return new PostTableEntry(143);
			case 0x2261: return new PostTableEntry("equivalence");
			case 0x2264: return new PostTableEntry(148);
			case 0x2265: return new PostTableEntry(149);
			case 0x2302: return new PostTableEntry("house");
			case 0x2310: return new PostTableEntry("revlogicalnot");
			case 0x2320: return new PostTableEntry("integraltp");
			case 0x2321: return new PostTableEntry("integralbt");
			case 0x2500: return new PostTableEntry("SF100000");
			case 0x2502: return new PostTableEntry("SF110000");
			case 0x250c: return new PostTableEntry("SF010000");
			case 0x2510: return new PostTableEntry("SF030000");
			case 0x2514: return new PostTableEntry("SF020000");
			case 0x2518: return new PostTableEntry("SF040000");
			case 0x251c: return new PostTableEntry("SF080000");
			case 0x2524: return new PostTableEntry("SF090000");
			case 0x252c: return new PostTableEntry("SF060000");
			case 0x2534: return new PostTableEntry("SF070000");
			case 0x253c: return new PostTableEntry("SF050000");
			case 0x2550: return new PostTableEntry("SF430000");
			case 0x2551: return new PostTableEntry("SF240000");
			case 0x2552: return new PostTableEntry("SF510000");
			case 0x2553: return new PostTableEntry("SF520000");
			case 0x2554: return new PostTableEntry("SF390000");
			case 0x2555: return new PostTableEntry("SF220000");
			case 0x2556: return new PostTableEntry("SF210000");
			case 0x2557: return new PostTableEntry("SF250000");
			case 0x2558: return new PostTableEntry("SF500000");
			case 0x2559: return new PostTableEntry("SF490000");
			case 0x255a: return new PostTableEntry("SF380000");
			case 0x255b: return new PostTableEntry("SF280000");
			case 0x255c: return new PostTableEntry("SF270000");
			case 0x255d: return new PostTableEntry("SF260000");
			case 0x255e: return new PostTableEntry("SF360000");
			case 0x255f: return new PostTableEntry("SF370000");
			case 0x2560: return new PostTableEntry("SF420000");
			case 0x2561: return new PostTableEntry("SF190000");
			case 0x2562: return new PostTableEntry("SF200000");
			case 0x2563: return new PostTableEntry("SF230000");
			case 0x2564: return new PostTableEntry("SF470000");
			case 0x2565: return new PostTableEntry("SF480000");
			case 0x2566: return new PostTableEntry("SF410000");
			case 0x2567: return new PostTableEntry("SF450000");
			case 0x2568: return new PostTableEntry("SF460000");
			case 0x2569: return new PostTableEntry("SF400000");
			case 0x256a: return new PostTableEntry("SF540000");
			case 0x256b: return new PostTableEntry("SF530000");
			case 0x256c: return new PostTableEntry("SF440000");
			case 0x2580: return new PostTableEntry("upblock");
			case 0x2584: return new PostTableEntry("dnblock");
			case 0x2588: return new PostTableEntry("block");
			case 0x258c: return new PostTableEntry("lfblock");
			case 0x2590: return new PostTableEntry("rtblock");
			case 0x2591: return new PostTableEntry("ltshade");
			case 0x2592: return new PostTableEntry("shade");
			case 0x2593: return new PostTableEntry("dkshade");
			case 0x25a0: return new PostTableEntry("filledbox");
			case 0x25a1: return new PostTableEntry("H22073");
			case 0x25aa: return new PostTableEntry("H18543");
			case 0x25ab: return new PostTableEntry("H18551");
			case 0x25ac: return new PostTableEntry("filledrect");
			case 0x25b2: return new PostTableEntry("triagup");
			case 0x25ba: return new PostTableEntry("triagrt");
			case 0x25bc: return new PostTableEntry("triagdn");
			case 0x25c4: return new PostTableEntry("triaglf");
			case 0x25ca: return new PostTableEntry(185);
			case 0x25cb: return new PostTableEntry("circle");
			case 0x25cf: return new PostTableEntry("H18533");
			case 0x25d8: return new PostTableEntry("invbullet");
			case 0x25d9: return new PostTableEntry("invcircle");
			case 0x25e6: return new PostTableEntry("openbullet");
			case 0x263a: return new PostTableEntry("smileface");
			case 0x263b: return new PostTableEntry("invsmileface");
			case 0x263c: return new PostTableEntry("sun");
			case 0x2640: return new PostTableEntry("female");
			case 0x2642: return new PostTableEntry("male");
			case 0x2660: return new PostTableEntry("spade");
			case 0x2663: return new PostTableEntry("club");
			case 0x2665: return new PostTableEntry("heart");
			case 0x2666: return new PostTableEntry("diamond");
			case 0x266a: return new PostTableEntry("musicalnote");
			case 0x266b: return new PostTableEntry("musicalnotedbl");
			case 0xfb01: return new PostTableEntry(192);
			case 0xfb02: return new PostTableEntry(193);
			default:
				String s = Integer.toHexString(ch).toUpperCase();
				while (s.length() < 4) s = "0" + s;
				s = ((ch < 0x10000) ? "uni" : "u") + s;
				return new PostTableEntry(s);
		}
	}
	
	public static PostTableEntry forCharacterName(String name) {
		if (name == null) return new PostTableEntry(0);
		else if (name.equals(".notdef")) return new PostTableEntry(0);
		else if (name.equals(".null")) return new PostTableEntry(1);
		else if (name.equals("nonmarkingreturn")) return new PostTableEntry(2);
		else if (name.equals("space")) return new PostTableEntry(3);
		else if (name.equals("exclam")) return new PostTableEntry(4);
		else if (name.equals("quotedbl")) return new PostTableEntry(5);
		else if (name.equals("numbersign")) return new PostTableEntry(6);
		else if (name.equals("dollar")) return new PostTableEntry(7);
		else if (name.equals("percent")) return new PostTableEntry(8);
		else if (name.equals("ampersand")) return new PostTableEntry(9);
		else if (name.equals("quotesingle")) return new PostTableEntry(10);
		else if (name.equals("parenleft")) return new PostTableEntry(11);
		else if (name.equals("parenright")) return new PostTableEntry(12);
		else if (name.equals("asterisk")) return new PostTableEntry(13);
		else if (name.equals("plus")) return new PostTableEntry(14);
		else if (name.equals("comma")) return new PostTableEntry(15);
		else if (name.equals("hyphen")) return new PostTableEntry(16);
		else if (name.equals("period")) return new PostTableEntry(17);
		else if (name.equals("slash")) return new PostTableEntry(18);
		else if (name.equals("zero")) return new PostTableEntry(19);
		else if (name.equals("one")) return new PostTableEntry(20);
		else if (name.equals("two")) return new PostTableEntry(21);
		else if (name.equals("three")) return new PostTableEntry(22);
		else if (name.equals("four")) return new PostTableEntry(23);
		else if (name.equals("five")) return new PostTableEntry(24);
		else if (name.equals("six")) return new PostTableEntry(25);
		else if (name.equals("seven")) return new PostTableEntry(26);
		else if (name.equals("eight")) return new PostTableEntry(27);
		else if (name.equals("nine")) return new PostTableEntry(28);
		else if (name.equals("colon")) return new PostTableEntry(29);
		else if (name.equals("semicolon")) return new PostTableEntry(30);
		else if (name.equals("less")) return new PostTableEntry(31);
		else if (name.equals("equal")) return new PostTableEntry(32);
		else if (name.equals("greater")) return new PostTableEntry(33);
		else if (name.equals("question")) return new PostTableEntry(34);
		else if (name.equals("at")) return new PostTableEntry(35);
		else if (name.equals("A")) return new PostTableEntry(36);
		else if (name.equals("B")) return new PostTableEntry(37);
		else if (name.equals("C")) return new PostTableEntry(38);
		else if (name.equals("D")) return new PostTableEntry(39);
		else if (name.equals("E")) return new PostTableEntry(40);
		else if (name.equals("F")) return new PostTableEntry(41);
		else if (name.equals("G")) return new PostTableEntry(42);
		else if (name.equals("H")) return new PostTableEntry(43);
		else if (name.equals("I")) return new PostTableEntry(44);
		else if (name.equals("J")) return new PostTableEntry(45);
		else if (name.equals("K")) return new PostTableEntry(46);
		else if (name.equals("L")) return new PostTableEntry(47);
		else if (name.equals("M")) return new PostTableEntry(48);
		else if (name.equals("N")) return new PostTableEntry(49);
		else if (name.equals("O")) return new PostTableEntry(50);
		else if (name.equals("P")) return new PostTableEntry(51);
		else if (name.equals("Q")) return new PostTableEntry(52);
		else if (name.equals("R")) return new PostTableEntry(53);
		else if (name.equals("S")) return new PostTableEntry(54);
		else if (name.equals("T")) return new PostTableEntry(55);
		else if (name.equals("U")) return new PostTableEntry(56);
		else if (name.equals("V")) return new PostTableEntry(57);
		else if (name.equals("W")) return new PostTableEntry(58);
		else if (name.equals("X")) return new PostTableEntry(59);
		else if (name.equals("Y")) return new PostTableEntry(60);
		else if (name.equals("Z")) return new PostTableEntry(61);
		else if (name.equals("bracketleft")) return new PostTableEntry(62);
		else if (name.equals("backslash")) return new PostTableEntry(63);
		else if (name.equals("bracketright")) return new PostTableEntry(64);
		else if (name.equals("asciicircum")) return new PostTableEntry(65);
		else if (name.equals("underscore")) return new PostTableEntry(66);
		else if (name.equals("grave")) return new PostTableEntry(67);
		else if (name.equals("a")) return new PostTableEntry(68);
		else if (name.equals("b")) return new PostTableEntry(69);
		else if (name.equals("c")) return new PostTableEntry(70);
		else if (name.equals("d")) return new PostTableEntry(71);
		else if (name.equals("e")) return new PostTableEntry(72);
		else if (name.equals("f")) return new PostTableEntry(73);
		else if (name.equals("g")) return new PostTableEntry(74);
		else if (name.equals("h")) return new PostTableEntry(75);
		else if (name.equals("i")) return new PostTableEntry(76);
		else if (name.equals("j")) return new PostTableEntry(77);
		else if (name.equals("k")) return new PostTableEntry(78);
		else if (name.equals("l")) return new PostTableEntry(79);
		else if (name.equals("m")) return new PostTableEntry(80);
		else if (name.equals("n")) return new PostTableEntry(81);
		else if (name.equals("o")) return new PostTableEntry(82);
		else if (name.equals("p")) return new PostTableEntry(83);
		else if (name.equals("q")) return new PostTableEntry(84);
		else if (name.equals("r")) return new PostTableEntry(85);
		else if (name.equals("s")) return new PostTableEntry(86);
		else if (name.equals("t")) return new PostTableEntry(87);
		else if (name.equals("u")) return new PostTableEntry(88);
		else if (name.equals("v")) return new PostTableEntry(89);
		else if (name.equals("w")) return new PostTableEntry(90);
		else if (name.equals("x")) return new PostTableEntry(91);
		else if (name.equals("y")) return new PostTableEntry(92);
		else if (name.equals("z")) return new PostTableEntry(93);
		else if (name.equals("braceleft")) return new PostTableEntry(94);
		else if (name.equals("bar")) return new PostTableEntry(95);
		else if (name.equals("braceright")) return new PostTableEntry(96);
		else if (name.equals("asciitilde")) return new PostTableEntry(97);
		else if (name.equals("Adieresis")) return new PostTableEntry(98);
		else if (name.equals("Aring")) return new PostTableEntry(99);
		else if (name.equals("Ccedilla")) return new PostTableEntry(100);
		else if (name.equals("Eacute")) return new PostTableEntry(101);
		else if (name.equals("Ntilde")) return new PostTableEntry(102);
		else if (name.equals("Odieresis")) return new PostTableEntry(103);
		else if (name.equals("Udieresis")) return new PostTableEntry(104);
		else if (name.equals("aacute")) return new PostTableEntry(105);
		else if (name.equals("agrave")) return new PostTableEntry(106);
		else if (name.equals("acircumflex")) return new PostTableEntry(107);
		else if (name.equals("adieresis")) return new PostTableEntry(108);
		else if (name.equals("atilde")) return new PostTableEntry(109);
		else if (name.equals("aring")) return new PostTableEntry(110);
		else if (name.equals("ccedilla")) return new PostTableEntry(111);
		else if (name.equals("eacute")) return new PostTableEntry(112);
		else if (name.equals("egrave")) return new PostTableEntry(113);
		else if (name.equals("ecircumflex")) return new PostTableEntry(114);
		else if (name.equals("edieresis")) return new PostTableEntry(115);
		else if (name.equals("iacute")) return new PostTableEntry(116);
		else if (name.equals("igrave")) return new PostTableEntry(117);
		else if (name.equals("icircumflex")) return new PostTableEntry(118);
		else if (name.equals("idieresis")) return new PostTableEntry(119);
		else if (name.equals("ntilde")) return new PostTableEntry(120);
		else if (name.equals("oacute")) return new PostTableEntry(121);
		else if (name.equals("ograve")) return new PostTableEntry(122);
		else if (name.equals("ocircumflex")) return new PostTableEntry(123);
		else if (name.equals("odieresis")) return new PostTableEntry(124);
		else if (name.equals("otilde")) return new PostTableEntry(125);
		else if (name.equals("uacute")) return new PostTableEntry(126);
		else if (name.equals("ugrave")) return new PostTableEntry(127);
		else if (name.equals("ucircumflex")) return new PostTableEntry(128);
		else if (name.equals("udieresis")) return new PostTableEntry(129);
		else if (name.equals("dagger")) return new PostTableEntry(130);
		else if (name.equals("degree")) return new PostTableEntry(131);
		else if (name.equals("cent")) return new PostTableEntry(132);
		else if (name.equals("sterling")) return new PostTableEntry(133);
		else if (name.equals("section")) return new PostTableEntry(134);
		else if (name.equals("bullet")) return new PostTableEntry(135);
		else if (name.equals("paragraph")) return new PostTableEntry(136);
		else if (name.equals("germandbls")) return new PostTableEntry(137);
		else if (name.equals("registered")) return new PostTableEntry(138);
		else if (name.equals("copyright")) return new PostTableEntry(139);
		else if (name.equals("trademark")) return new PostTableEntry(140);
		else if (name.equals("acute")) return new PostTableEntry(141);
		else if (name.equals("dieresis")) return new PostTableEntry(142);
		else if (name.equals("notequal")) return new PostTableEntry(143);
		else if (name.equals("AE")) return new PostTableEntry(144);
		else if (name.equals("Oslash")) return new PostTableEntry(145);
		else if (name.equals("infinity")) return new PostTableEntry(146);
		else if (name.equals("plusminus")) return new PostTableEntry(147);
		else if (name.equals("lessequal")) return new PostTableEntry(148);
		else if (name.equals("greaterequal")) return new PostTableEntry(149);
		else if (name.equals("yen")) return new PostTableEntry(150);
		else if (name.equals("mu")) return new PostTableEntry(151);
		else if (name.equals("partialdiff")) return new PostTableEntry(152);
		else if (name.equals("summation")) return new PostTableEntry(153);
		else if (name.equals("product")) return new PostTableEntry(154);
		else if (name.equals("pi")) return new PostTableEntry(155);
		else if (name.equals("integral")) return new PostTableEntry(156);
		else if (name.equals("ordfeminine")) return new PostTableEntry(157);
		else if (name.equals("ordmasculine")) return new PostTableEntry(158);
		else if (name.equals("Omega")) return new PostTableEntry(159);
		else if (name.equals("ae")) return new PostTableEntry(160);
		else if (name.equals("oslash")) return new PostTableEntry(161);
		else if (name.equals("questiondown")) return new PostTableEntry(162);
		else if (name.equals("exclamdown")) return new PostTableEntry(163);
		else if (name.equals("logicalnot")) return new PostTableEntry(164);
		else if (name.equals("radical")) return new PostTableEntry(165);
		else if (name.equals("florin")) return new PostTableEntry(166);
		else if (name.equals("approxequal")) return new PostTableEntry(167);
		else if (name.equals("Delta")) return new PostTableEntry(168);
		else if (name.equals("guillemotleft")) return new PostTableEntry(169);
		else if (name.equals("guillemotright")) return new PostTableEntry(170);
		else if (name.equals("ellipsis")) return new PostTableEntry(171);
		else if (name.equals("nonbreakingspace")) return new PostTableEntry(172);
		else if (name.equals("Agrave")) return new PostTableEntry(173);
		else if (name.equals("Atilde")) return new PostTableEntry(174);
		else if (name.equals("Otilde")) return new PostTableEntry(175);
		else if (name.equals("OE")) return new PostTableEntry(176);
		else if (name.equals("oe")) return new PostTableEntry(177);
		else if (name.equals("endash")) return new PostTableEntry(178);
		else if (name.equals("emdash")) return new PostTableEntry(179);
		else if (name.equals("quotedblleft")) return new PostTableEntry(180);
		else if (name.equals("quotedblright")) return new PostTableEntry(181);
		else if (name.equals("quoteleft")) return new PostTableEntry(182);
		else if (name.equals("quoteright")) return new PostTableEntry(183);
		else if (name.equals("divide")) return new PostTableEntry(184);
		else if (name.equals("lozenge")) return new PostTableEntry(185);
		else if (name.equals("ydieresis")) return new PostTableEntry(186);
		else if (name.equals("Ydieresis")) return new PostTableEntry(187);
		else if (name.equals("fraction")) return new PostTableEntry(188);
		else if (name.equals("currency")) return new PostTableEntry(189);
		else if (name.equals("guilsinglleft")) return new PostTableEntry(190);
		else if (name.equals("guilsinglright")) return new PostTableEntry(191);
		else if (name.equals("fi")) return new PostTableEntry(192);
		else if (name.equals("fl")) return new PostTableEntry(193);
		else if (name.equals("daggerdbl")) return new PostTableEntry(194);
		else if (name.equals("periodcentered")) return new PostTableEntry(195);
		else if (name.equals("quotesinglbase")) return new PostTableEntry(196);
		else if (name.equals("quotedblbase")) return new PostTableEntry(197);
		else if (name.equals("perthousand")) return new PostTableEntry(198);
		else if (name.equals("Acircumflex")) return new PostTableEntry(199);
		else if (name.equals("Ecircumflex")) return new PostTableEntry(200);
		else if (name.equals("Aacute")) return new PostTableEntry(201);
		else if (name.equals("Edieresis")) return new PostTableEntry(202);
		else if (name.equals("Egrave")) return new PostTableEntry(203);
		else if (name.equals("Iacute")) return new PostTableEntry(204);
		else if (name.equals("Icircumflex")) return new PostTableEntry(205);
		else if (name.equals("Idieresis")) return new PostTableEntry(206);
		else if (name.equals("Igrave")) return new PostTableEntry(207);
		else if (name.equals("Oacute")) return new PostTableEntry(208);
		else if (name.equals("Ocircumflex")) return new PostTableEntry(209);
		else if (name.equals("apple")) return new PostTableEntry(210);
		else if (name.equals("Ograve")) return new PostTableEntry(211);
		else if (name.equals("Uacute")) return new PostTableEntry(212);
		else if (name.equals("Ucircumflex")) return new PostTableEntry(213);
		else if (name.equals("Ugrave")) return new PostTableEntry(214);
		else if (name.equals("dotlessi")) return new PostTableEntry(215);
		else if (name.equals("circumflex")) return new PostTableEntry(216);
		else if (name.equals("tilde")) return new PostTableEntry(217);
		else if (name.equals("macron")) return new PostTableEntry(218);
		else if (name.equals("breve")) return new PostTableEntry(219);
		else if (name.equals("dotaccent")) return new PostTableEntry(220);
		else if (name.equals("ring")) return new PostTableEntry(221);
		else if (name.equals("cedilla")) return new PostTableEntry(222);
		else if (name.equals("hungarumlaut")) return new PostTableEntry(223);
		else if (name.equals("ogonek")) return new PostTableEntry(224);
		else if (name.equals("caron")) return new PostTableEntry(225);
		else if (name.equals("Lslash")) return new PostTableEntry(226);
		else if (name.equals("lslash")) return new PostTableEntry(227);
		else if (name.equals("Scaron")) return new PostTableEntry(228);
		else if (name.equals("scaron")) return new PostTableEntry(229);
		else if (name.equals("Zcaron")) return new PostTableEntry(230);
		else if (name.equals("zcaron")) return new PostTableEntry(231);
		else if (name.equals("brokenbar")) return new PostTableEntry(232);
		else if (name.equals("Eth")) return new PostTableEntry(233);
		else if (name.equals("eth")) return new PostTableEntry(234);
		else if (name.equals("Yacute")) return new PostTableEntry(235);
		else if (name.equals("yacute")) return new PostTableEntry(236);
		else if (name.equals("Thorn")) return new PostTableEntry(237);
		else if (name.equals("thorn")) return new PostTableEntry(238);
		else if (name.equals("minus")) return new PostTableEntry(239);
		else if (name.equals("multiply")) return new PostTableEntry(240);
		else if (name.equals("onesuperior")) return new PostTableEntry(241);
		else if (name.equals("twosuperior")) return new PostTableEntry(242);
		else if (name.equals("threesuperior")) return new PostTableEntry(243);
		else if (name.equals("onehalf")) return new PostTableEntry(244);
		else if (name.equals("onequarter")) return new PostTableEntry(245);
		else if (name.equals("threequarters")) return new PostTableEntry(246);
		else if (name.equals("franc")) return new PostTableEntry(247);
		else if (name.equals("Gbreve")) return new PostTableEntry(248);
		else if (name.equals("gbreve")) return new PostTableEntry(249);
		else if (name.equals("Idotaccent")) return new PostTableEntry(250);
		else if (name.equals("Scedilla")) return new PostTableEntry(251);
		else if (name.equals("scedilla")) return new PostTableEntry(252);
		else if (name.equals("Cacute")) return new PostTableEntry(253);
		else if (name.equals("cacute")) return new PostTableEntry(254);
		else if (name.equals("Ccaron")) return new PostTableEntry(255);
		else if (name.equals("ccaron")) return new PostTableEntry(256);
		else if (name.equals("dcroat")) return new PostTableEntry(257);
		else return new PostTableEntry(name);
	}
	
	public boolean isInteger() {
		return intValue != null;
	}
	
	public boolean isString() {
		return stringValue != null;
	}
	
	public int intValue() {
		if (intValue != null) {
			return intValue;
		} else {
			return 0;
		}
	}
	
	public String stringValue() {
		if (stringValue != null) {
			return stringValue;
		} else {
			return "";
		}
	}
	
	@Override
	public String toString() {
		if (intValue != null) {
			return intValue.toString();
		} else if (stringValue != null) {
			return stringValue;
		} else {
			return "";
		}
	}
	
	@Override
	public boolean equals(Object o) {
		if (o == this) {
			return true;
		} else if (o instanceof PostTableEntry) {
			PostTableEntry other = (PostTableEntry)o;
			boolean intEq = (this.intValue == null) ? (other.intValue == null) : this.intValue.equals(other.intValue);
			boolean strEq = (this.stringValue == null) ? (other.stringValue == null) : this.stringValue.equals(other.stringValue);
			return intEq && strEq;
		} else {
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		if (intValue != null) {
			return intValue.hashCode();
		} else if (stringValue != null) {
			return stringValue.hashCode();
		} else {
			return 0;
		}
	}
}
