Specifications Relevant to CalendarServer
=========================================

# HTTP

* [HTTP1](https://tools.ietf.org/html/rfc7230) HTTP: Message Syntax and Routing
* [HTTP2](https://tools.ietf.org/html/rfc7231) HTTP: Semantics and Content
* [HTTP3](https://tools.ietf.org/html/rfc7232) HTTP: Conditional Requests
* [HTTP4](https://tools.ietf.org/html/rfc7233) HTTP: Range Requests
* [HTTP5](https://tools.ietf.org/html/rfc7234) HTTP: Caching
* [HTTP6](https://tools.ietf.org/html/rfc7235) HTTP: Authentication
* [HTTP7](https://tools.ietf.org/html/rfc7236) HTTP: Authentication Scheme Registrations
* [HTTP8](https://tools.ietf.org/html/rfc7237) HTTP: Method Registrations

* [PATCH](https://tools.ietf.org/html/rfc5789) PATCH Method for HTTP
* [PREFER](https://tools.ietf.org/html/rfc7240) Prefer Header for HTTP

* [SPNEGO](https://tools.ietf.org/html/rfc4559) SPNEGO-based Kerberos and NTLM HTTP Authentication in Microsoft Windows
* [WELLKNOWN](https://tools.ietf.org/html/rfc5785) Defining Well-Known Uniform Resource Identifiers

# WebDAV
* [WEBDAV](https://tools.ietf.org/html/rfc4918) HTTP Extensions for Web Distributed Authoring and Versioning
* [ACL](https://tools.ietf.org/html/rfc3744) Web Distributed Authoring and Versioning Access Control Protocol
* [QUOTA](https://tools.ietf.org/html/rfc4331) Quota and Size Properties for Distributed Authoring and Versioning Collections
* [DELTAV](https://tools.ietf.org/html/rfc3253) Versioning Extensions to WebDAV

* [CURRENTPRINCIPLE](https://tools.ietf.org/html/rfc5397) Current Principal Extension
* [EXTENDEDMKCOL](https://tools.ietf.org/html/rfc5689) Extended MKCOL for Web Distributed Authoring and Versioning
* [BIND](https://tools.ietf.org/html/rfc5842) Binding Extensions to Web Distributed Authoring and Versioning
* [ADDMEMBER](https://tools.ietf.org/html/rfc5995) Using POST to Add Members to Web Distributed Authoring and Versioning Collections
* [SYNC](https://tools.ietf.org/html/rfc6578) Collection Synchronization for Web Distributed Authoring and Versioning

# iCalendar

* [iCalendar](https://tools.ietf.org/html/rfc5545) Internet Calendaring and Scheduling Core Object Specification
* [iTIP](https://tools.ietf.org/html/rfc5546) iCalendar Transport-Independent Interoperability Protocol
* [iMIP](https://tools.ietf.org/html/rfc6047) iCalendar Message-Based Interoperability Protocol

* [xCal](https://tools.ietf.org/html/rfc6321) The XML Format for iCalendar
* [jCal](https://tools.ietf.org/html/rfc7265) The JSON Format for iCalendar

* [RSCALE](https://tools.ietf.org/html/rfc7529) Non-Gregorian Recurrence Rules in the Internet Calendaring and Scheduling Core Object Specification

* [VAVAILABILITY](https://tools.ietf.org/html/rfc7953) Calendar Availability

* OBSOLETE [CalGuide](https://tools.ietf.org/html/rfc3283) Guide to Internet Calendaring

* [PARAMVAL](https://tools.ietf.org/html/rfc6868) Parameter Value Encoding in iCalendar and vCard

# CalDAV

* [CALDAV](https://tools.ietf.org/html/rfc4791) Calendaring Extensions to WebDAV
* [SCHEDULING](https://tools.ietf.org/html/rfc6638) Scheduling Extensions to CalDAV

* [SRV-CALDAV](https://tools.ietf.org/html/rfc6764) Locating Services for Calendaring Extensions to WebDAV and vCard Extensions to WebDAV

* [TZBYREF](https://tools.ietf.org/html/rfc7809) Time Zones by Reference

* [CALDAVEXT](https://tools.ietf.org/html/draft-daboo-caldav-extensions-01) Collected Extensions to CalDAV

# vCard

* [vCard4](https://tools.ietf.org/html/rfc6350) vCard Format Specification
* [xCard](https://tools.ietf.org/html/rfc6351) vCard XML Representation
* [jCard](https://tools.ietf.org/html/rfc7095) The JSON Format for vCard

# CardDAV
* [CARDDAV](https://tools.ietf.org/html/rfc6352) CardDAV: vCard Extensions to Web Distributed Authoring and Versioning

* [DIRGATEWAY](https://tools.ietf.org/html/draft-daboo-carddav-directory-gateway-02) CardDAV Directory Gateway Extension

# Others

* [TZDIST](https://tools.ietf.org/html/rfc7808) Time Zone Data Distribution Service

* [ISCHEDULE](https://tools.ietf.org/html/draft-desruisseaux-ischedule-05) Internet Calendar Scheduling Protocol
