# Select a hash backend

INCLUDE(SanitizeBool)

# USE_SHA1=CollisionDetection(ON)/HTTPS/Generic/OFF

SanitizeBool(USE_SHA1)
IF(USE_SHA1 STREQUAL ON OR USE_SHA1 STREQUAL "CollisionDetection")
	SET(SHA1_BACKEND "CollisionDetection")
ELSEIF(USE_SHA1 STREQUAL "HTTPS")
	message(STATUS "Checking HTTPS backend… ${HTTPS_BACKEND}")
	IF(HTTPS_BACKEND STREQUAL "SecureTransport")
		SET(SHA1_BACKEND "CommonCrypto")
	ELSEIF(HTTPS_BACKEND STREQUAL "WinHTTP")
		SET(SHA1_BACKEND "Win32")
	ELSEIF(HTTPS_BACKEND)
		SET(SHA1_BACKEND ${HTTPS_BACKEND})
	ELSE()
	ENDIF()
	IF(NOT HTTPS_BACKEND)
		SET(SHA1_BACKEND "CollisionDetection")
	ENDIF()
	message(STATUS "Using SHA1 backend ${SHA1_BACKEND}")
ELSEIF(USE_SHA1 STREQUAL "Generic")
	SET(SHA1_BACKEND "Generic")
# ELSEIF(NOT USE_SHA1)
ELSE()
	MESSAGE(FATAL_ERROR "Invalid value for USE_SHA1: ${USE_SHA1}")
ENDIF()

IF(SHA1_BACKEND STREQUAL "CollisionDetection")
	SET(GIT_SHA1_COLLISIONDETECT 1)
	ADD_DEFINITIONS(-DSHA1DC_NO_STANDARD_INCLUDES=1)
	ADD_DEFINITIONS(-DSHA1DC_CUSTOM_INCLUDE_SHA1_C=\"common.h\")
	ADD_DEFINITIONS(-DSHA1DC_CUSTOM_INCLUDE_UBC_CHECK_C=\"common.h\")
	FILE(GLOB SRC_SHA1 hash/sha1/collisiondetect.* hash/sha1/sha1dc/*)
ELSEIF(SHA1_BACKEND STREQUAL "OpenSSL")
	# OPENSSL_FOUND should already be set, we're checking HTTPS_BACKEND

	SET(GIT_SHA1_OPENSSL 1)
	IF(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")
		LIST(APPEND LIBGIT2_PC_LIBS "-lssl")
	ELSE()
		LIST(APPEND LIBGIT2_PC_REQUIRES "openssl")
	ENDIF()
	FILE(GLOB SRC_SHA1 hash/sha1/openssl.*)
ELSEIF(SHA1_BACKEND STREQUAL "CommonCrypto")
	SET(GIT_SHA1_COMMON_CRYPTO 1)
	FILE(GLOB SRC_SHA1 hash/sha1/common_crypto.*)
ELSEIF(SHA1_BACKEND STREQUAL "mbedTLS")
	SET(GIT_SHA1_MBEDTLS 1)
	FILE(GLOB SRC_SHA1 hash/sha1/mbedtls.*)
	LIST(APPEND LIBGIT2_SYSTEM_INCLUDES ${MBEDTLS_INCLUDE_DIR})
	LIST(APPEND LIBGIT2_LIBS ${MBEDTLS_LIBRARIES})
	# mbedTLS has no pkgconfig file, hence we can't require it
	# https://github.com/ARMmbed/mbedtls/issues/228
	# For now, pass its link flags as our own
	LIST(APPEND LIBGIT2_PC_LIBS ${MBEDTLS_LIBRARIES})
ELSEIF(SHA1_BACKEND STREQUAL "Win32")
	SET(GIT_SHA1_WIN32 1)
	FILE(GLOB SRC_SHA1 hash/sha1/win32.*)
ELSEIF(SHA1_BACKEND STREQUAL "Generic")
	FILE(GLOB SRC_SHA1 hash/sha1/generic.*)
# ELSEIF(NOT USE_SHA1)
ELSE()
	MESSAGE(FATAL_ERROR "Asked for unknown SHA1 backend: ${SHA1_BACKEND}")
ENDIF()

ADD_FEATURE_INFO(SHA ON "using ${SHA1_BACKEND}")
