
#ifndef _LILV_CONFIG_H_
#define _LILV_CONFIG_H_

#define LILV_INTERNAL
#define LILV_VERSION "0.22.1"

#define HAVE_LV2    1
#define HAVE_SERD   1
#define HAVE_SORD   1
#define HAVE_SRATOM 1

#define HAVE_FILENO 1
#define HAVE_CLOCK_GETTIME 1

#ifdef _WIN32
 #define LILV_PATH_SEP ";"
 #define LILV_DIR_SEP "\\"
#else
 #define LILV_PATH_SEP ":"
 #define LILV_DIR_SEP "/"
 #define HAVE_FLOCK 1
#endif

#if defined(__APPLE__)
 #define LILV_DEFAULT_LV2_PATH "~/Library/Audio/Plug-Ins/LV2:/Library/Audio/Plug-Ins/LV2"
#elif defined(__EMSCRIPTEN__)
 #define LILV_DEFAULT_LV2_PATH "~/.lv2:/lv2"
#elif defined(__HAIKU__)
 #define LILV_DEFAULT_LV2_PATH "~/.lv2:/system/add-ons/media/lv2plugins"
#elif defined(_WIN32)
 #define LILV_DEFAULT_LV2_PATH "%APPDATA%\\LV2;%COMMONPROGRAMFILES%\\LV2"
#else
 #define LILV_DEFAULT_LV2_PATH "~/.lv2:/usr/lib/lv2:/usr/local/lib/lv2"
#endif

#endif /* _LILV_CONFIG_H_ */
