{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDirectOutput: Boolean;
    procedure SetDirectOutput(const Value: Boolean);
    function GetMustEvaluate: Boolean;
    procedure SetMustEvaluate(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDirectOutput: TSFBool;
    { Internal wrapper for property @link(DirectOutput). This wrapper API may change, we advise to access simpler @link(DirectOutput) instead. }
    public property FdDirectOutput: TSFBool read FFdDirectOutput;
    {  }
    property DirectOutput: Boolean read GetDirectOutput write SetDirectOutput;

    strict private FFdMustEvaluate: TSFBool;
    { Internal wrapper for property @link(MustEvaluate). This wrapper API may change, we advise to access simpler @link(MustEvaluate) instead. }
    public property FdMustEvaluate: TSFBool read FFdMustEvaluate;
    {  }
    property MustEvaluate: Boolean read GetMustEvaluate write SetMustEvaluate;

{$endif read_interface}

{$ifdef read_implementation}

{ TScriptNode ----------------------------------------------- }

function TScriptNode.GetDirectOutput: Boolean;
begin
  Result := FdDirectOutput.Value;
end;

procedure TScriptNode.SetDirectOutput(const Value: Boolean);
begin
  FdDirectOutput.Send(Value);
end;

function TScriptNode.GetMustEvaluate: Boolean;
begin
  Result := FdMustEvaluate.Value;
end;

procedure TScriptNode.SetMustEvaluate(const Value: Boolean);
begin
  FdMustEvaluate.Send(Value);
end;

class function TScriptNode.ClassX3DType: String;
begin
  Result := 'Script';
end;

procedure TScriptNode.CreateNode;
begin
  inherited;

  FFdDirectOutput := TSFBool.Create(Self, False, 'directOutput', false);
   FdDirectOutput.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDirectOutput);

  FFdMustEvaluate := TSFBool.Create(Self, False, 'mustEvaluate', false);
   FdMustEvaluate.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMustEvaluate);
end;

{$endif read_implementation}
