from __future__ import absolute_import, division, print_function

import iotbx.pdb
import mmtbx.model
from mmtbx.building.cablam_idealization import cablam_idealization, master_phil
import sys
import libtbx.load_env

pdb_str = """\
CRYST1   10.000   10.000   10.000  90.00  90.00  90.00 P 1
ATOM   3486  N   ASP B  60     -68.331  -5.725  16.616  1.00356.89           N
ATOM   3487  CA  ASP B  60     -67.541  -4.918  17.544  1.00354.36           C
ATOM   3488  C   ASP B  60     -68.367  -3.945  18.382  1.00349.38           C
ATOM   3489  O   ASP B  60     -67.818  -3.097  19.085  1.00353.38           O
ATOM   3490  CB  ASP B  60     -66.380  -4.208  16.838  1.00364.04           C
ATOM   3491  CG  ASP B  60     -66.848  -3.072  15.947  1.00374.37           C
ATOM   3492  OD1 ASP B  60     -67.274  -3.347  14.807  1.00380.37           O
ATOM   3493  OD2 ASP B  60     -66.790  -1.905  16.390  1.00373.73           O
ATOM   3494  N   ARG B  61     -69.688  -4.069  18.299  1.00217.95           N
ATOM   3495  CA  ARG B  61     -70.579  -3.330  19.184  1.00218.28           C
ATOM   3496  C   ARG B  61     -70.384  -3.821  20.612  1.00234.70           C
ATOM   3497  O   ARG B  61     -70.597  -3.079  21.571  1.00234.95           O
ATOM   3498  CB  ARG B  61     -72.036  -3.522  18.760  1.00222.27           C
ATOM   3499  CG  ARG B  61     -72.308  -3.208  17.298  1.00232.42           C
ATOM   3500  CD  ARG B  61     -73.800  -3.126  17.017  1.00227.11           C
ATOM   3501  NE  ARG B  61     -74.437  -4.441  17.033  1.00220.57           N
ATOM   3502  CZ  ARG B  61     -75.224  -4.877  18.010  1.00214.60           C
ATOM   3503  NH1 ARG B  61     -75.477  -4.104  19.058  1.00208.86           N
ATOM   3504  NH2 ARG B  61     -75.765  -6.086  17.938  1.00218.17           N
ATOM   3505  N   PHE B  62     -69.981  -5.081  20.744  1.00313.84           N
ATOM   3506  CA  PHE B  62     -69.806  -5.705  22.048  1.00311.92           C
ATOM   3507  C   PHE B  62     -68.353  -5.573  22.485  1.00313.16           C
ATOM   3508  O   PHE B  62     -67.444  -5.948  21.745  1.00313.62           O
ATOM   3509  CB  PHE B  62     -70.185  -7.186  21.984  1.00309.55           C
ATOM   3510  CG  PHE B  62     -71.655  -7.434  21.800  1.00313.91           C
ATOM   3511  CD1 PHE B  62     -72.220  -7.421  20.535  1.00321.28           C
ATOM   3512  CD2 PHE B  62     -72.469  -7.693  22.889  1.00308.01           C
ATOM   3513  CE1 PHE B  62     -73.571  -7.652  20.360  1.00337.52           C
ATOM   3514  CE2 PHE B  62     -73.821  -7.926  22.722  1.00309.58           C
ATOM   3515  CZ  PHE B  62     -74.372  -7.906  21.456  1.00318.15           C
ATOM   3516  N   SER B  63     -68.130  -5.040  23.680  1.00111.87           N
ATOM   3517  CA  SER B  63     -66.767  -4.860  24.171  1.00114.06           C
ATOM   3518  C   SER B  63     -66.702  -5.129  25.666  1.00112.84           C
ATOM   3519  O   SER B  63     -67.647  -4.846  26.389  1.00114.81           O
ATOM   3520  CB  SER B  63     -66.285  -3.437  23.889  1.00122.19           C
ATOM   3521  OG  SER B  63     -66.964  -2.499  24.704  1.00128.65           O
ATOM   3522  N   GLY B  64     -65.590  -5.684  26.131  1.00202.30           N
ATOM   3523  CA  GLY B  64     -65.434  -5.946  27.550  1.00201.80           C
ATOM   3524  C   GLY B  64     -64.380  -5.070  28.196  1.00202.46           C
ATOM   3525  O   GLY B  64     -63.430  -4.645  27.540  1.00204.01           O
ATOM   3526  N   SER B  65     -64.546  -4.798  29.486  1.00415.58           N
ATOM   3527  CA  SER B  65     -63.617  -3.931  30.195  1.00415.64           C
ATOM   3528  C   SER B  65     -62.343  -4.708  30.511  1.00426.21           C
ATOM   3529  O   SER B  65     -62.412  -5.875  30.896  1.00421.89           O
ATOM   3530  CB  SER B  65     -64.248  -3.425  31.492  1.00419.11           C
ATOM   3531  OG  SER B  65     -64.591  -4.500  32.348  1.00420.16           O
ATOM   3532  N   PRO B  66     -61.178  -4.066  30.331  1.00169.68           N
ATOM   3533  CA  PRO B  66     -59.871  -4.722  30.477  1.00191.83           C
ATOM   3534  C   PRO B  66     -59.702  -5.422  31.823  1.00193.95           C
ATOM   3535  O   PRO B  66     -60.275  -4.979  32.818  1.00192.66           O
ATOM   3536  CB  PRO B  66     -58.865  -3.568  30.331  1.00194.66           C
ATOM   3537  CG  PRO B  66     -59.667  -2.310  30.440  1.00190.47           C
ATOM   3538  CD  PRO B  66     -61.046  -2.643  29.980  1.00169.32           C
ATOM   3539  N   GLY B  67     -58.925  -6.502  31.851  1.00 80.00           N
ATOM   3540  CA  GLY B  67     -58.642  -7.188  33.095  1.00 80.51           C
ATOM   3541  C   GLY B  67     -57.514  -6.497  33.837  1.00 81.49           C
ATOM   3542  O   GLY B  67     -56.425  -7.051  33.989  1.00 83.70           O
ATOM   3543  N   SER B  67A    -57.783  -5.282  34.300  1.00199.92           N
ATOM   3544  CA  SER B  67A    -56.736  -4.282  34.475  1.00200.79           C
ATOM   3545  C   SER B  67A    -56.694  -3.694  35.881  1.00199.95           C
ATOM   3546  O   SER B  67A    -56.174  -4.312  36.811  1.00200.95           O
ATOM   3547  CB  SER B  67A    -56.901  -3.160  33.447  1.00200.17           C
ATOM   3548  OG  SER B  67A    -58.231  -2.670  33.441  1.00197.80           O
ATOM   3549  N   THR B  67B    -57.237  -2.486  36.012  1.00276.34           N
ATOM   3550  CA  THR B  67B    -57.204  -1.728  37.262  1.00275.38           C
ATOM   3551  C   THR B  67B    -57.762  -2.498  38.458  1.00273.67           C
ATOM   3552  O   THR B  67B    -58.921  -2.912  38.460  1.00271.08           O
ATOM   3553  CB  THR B  67B    -57.973  -0.398  37.122  1.00273.24           C
ATOM   3554  OG1 THR B  67B    -57.301   0.452  36.184  1.00275.35           O
ATOM   3555  CG2 THR B  67B    -58.069   0.309  38.467  1.00272.11           C
ATOM   3556  N   PHE B  67C    -56.915  -2.687  39.465  1.00301.79           N
ATOM   3557  CA  PHE B  67C    -57.241  -3.518  40.619  1.00297.93           C
ATOM   3558  C   PHE B  67C    -58.413  -2.938  41.408  1.00293.60           C
ATOM   3559  O   PHE B  67C    -58.542  -1.721  41.540  1.00292.18           O
ATOM   3560  CB  PHE B  67C    -56.020  -3.669  41.525  1.00287.21           C
ATOM   3561  CG  PHE B  67C    -54.845  -4.321  40.852  1.00291.30           C
ATOM   3562  CD1 PHE B  67C    -54.930  -5.621  40.385  1.00295.88           C
ATOM   3563  CD2 PHE B  67C    -53.656  -3.631  40.686  1.00295.09           C
ATOM   3564  CE1 PHE B  67C    -53.850  -6.220  39.762  1.00300.88           C
ATOM   3565  CE2 PHE B  67C    -52.573  -4.224  40.066  1.00296.89           C
ATOM   3566  CZ  PHE B  67C    -52.670  -5.519  39.602  1.00298.84           C
ATOM   3567  N   GLY B  68     -59.262  -3.816  41.930  1.00112.35           N
ATOM   3568  CA  GLY B  68     -60.367  -3.398  42.774  1.00110.56           C
ATOM   3569  C   GLY B  68     -61.552  -2.863  41.995  1.00108.59           C
ATOM   3570  O   GLY B  68     -62.376  -2.123  42.534  1.00107.14           O
ATOM   3571  N   THR B  69     -61.637  -3.237  40.723  1.00183.07           N
ATOM   3572  CA  THR B  69     -62.745  -2.814  39.874  1.00181.38           C
ATOM   3573  C   THR B  69     -63.545  -4.003  39.353  1.00181.09           C
ATOM   3574  O   THR B  69     -63.091  -5.146  39.424  1.00182.43           O
ATOM   3575  CB  THR B  69     -62.277  -1.928  38.702  1.00181.62           C
ATOM   3576  OG1 THR B  69     -61.373  -2.667  37.871  1.00183.42           O
ATOM   3577  CG2 THR B  69     -61.575  -0.682  39.223  1.00181.84           C
ATOM   3578  N   THR B  70     -64.733  -3.732  38.825  1.00278.18           N
ATOM   3579  CA  THR B  70     -65.621  -4.789  38.364  1.00281.57           C
ATOM   3580  C   THR B  70     -65.624  -4.886  36.844  1.00285.93           C
ATOM   3581  O   THR B  70     -65.496  -3.878  36.148  1.00285.87           O
ATOM   3582  CB  THR B  70     -67.068  -4.575  38.851  1.00284.48           C
ATOM   3583  OG1 THR B  70     -67.548  -3.307  38.386  1.00289.32           O
ATOM   3584  CG2 THR B  70     -67.132  -4.608  40.367  1.00284.89           C
ATOM   3585  N   ALA B  71     -65.768  -6.105  36.336  1.00205.02           N
ATOM   3586  CA  ALA B  71     -65.795  -6.328  34.898  1.00205.75           C
ATOM   3587  C   ALA B  71     -67.103  -5.798  34.328  1.00203.15           C
ATOM   3588  O   ALA B  71     -68.160  -5.945  34.941  1.00200.88           O
ATOM   3589  CB  ALA B  71     -65.641  -7.806  34.587  1.00207.09           C
ATOM   3590  N   THR B  72     -67.030  -5.179  33.155  1.00197.86           N
ATOM   3591  CA  THR B  72     -68.216  -4.610  32.533  1.00196.26           C
ATOM   3592  C   THR B  72     -68.291  -4.959  31.050  1.00196.89           C
ATOM   3593  O   THR B  72     -67.278  -4.957  30.351  1.00198.50           O
ATOM   3594  CB  THR B  72     -68.256  -3.075  32.716  1.00195.44           C
ATOM   3595  OG1 THR B  72     -68.046  -2.749  34.094  1.00195.12           O
ATOM   3596  CG2 THR B  72     -69.592  -2.507  32.261  1.00193.77           C
ATOM   3597  N   LEU B  73     -69.496  -5.259  30.579  1.00101.29           N
ATOM   3598  CA  LEU B  73     -69.729  -5.469  29.161  1.00 88.83           C
ATOM   3599  C   LEU B  73     -70.496  -4.274  28.618  1.00 88.26           C
ATOM   3600  O   LEU B  73     -71.556  -3.918  29.130  1.00 87.52           O
ATOM   3601  CB  LEU B  73     -70.547  -6.740  28.948  1.00103.60           C
ATOM   3602  CG  LEU B  73     -71.101  -6.977  27.540  1.00104.89           C
ATOM   3603  CD1 LEU B  73     -69.973  -7.253  26.559  1.00 92.28           C
ATOM   3604  CD2 LEU B  73     -72.103  -8.120  27.544  1.00 91.89           C
ATOM   3605  N   THR B  74     -69.957  -3.662  27.572  1.00223.92           N
ATOM   3606  CA  THR B  74     -70.593  -2.524  26.929  1.00224.10           C
ATOM   3607  C   THR B  74     -71.120  -2.933  25.561  1.00227.31           C
ATOM   3608  O   THR B  74     -70.407  -3.554  24.766  1.00233.82           O
ATOM   3609  CB  THR B  74     -69.602  -1.357  26.762  1.00233.24           C
ATOM   3610  OG1 THR B  74     -69.143  -0.930  28.051  1.00232.54           O
ATOM   3611  CG2 THR B  74     -70.260  -0.188  26.050  1.00232.76           C
ATOM   3612  N   ILE B  75     -72.374  -2.583  25.294  1.00280.73           N
ATOM   3613  CA  ILE B  75     -72.965  -2.786  23.980  1.00278.29           C
ATOM   3614  C   ILE B  75     -73.403  -1.447  23.399  1.00281.31           C
ATOM   3615  O   ILE B  75     -74.302  -0.797  23.926  1.00294.58           O
ATOM   3616  CB  ILE B  75     -74.174  -3.739  24.042  1.00293.28           C
ATOM   3617  CG1 ILE B  75     -73.824  -4.996  24.844  1.00285.07           C
ATOM   3618  CG2 ILE B  75     -74.636  -4.103  22.640  1.00278.12           C
ATOM   3619  CD1 ILE B  75     -75.031  -5.760  25.342  1.00287.98           C
"""


def exercise_insertions(prefix="tst_cablam_insertions"):
  pdb_inp = iotbx.pdb.input(lines=pdb_str.split('\n'), source_info=None)
  model = mmtbx.model.manager(
      model_input = pdb_inp)
  with open("%s_start.pdb" % prefix, 'w') as f:
    f.write(model.model_as_pdb())
  ci = cablam_idealization(model = model, params=master_phil.extract().cablam_idealization, log=sys.stdout)
  pdb_txt = model.model_as_pdb()

if __name__ == '__main__':
  if (not libtbx.env.has_module(name="probe")):
    print("Skipping: probe not configured")
  else:
    exercise_insertions()
