from __future__ import division
# Phi/Psi corrections in Angstrom and Radials
mean_devs = {
  (-100, -180) : (0.099023, 1.291129), # 10
  (-100, -10) : (0.052292, 1.666304), # 21
  (-100, 0) : (0.078691, 1.595794), # 51
  (-100, 10) : (0.073208, 1.453412), # 69
  (-100, 20) : (0.061455, 1.569949), # 25
  (-100, 130) : (0.054914, 1.534580), # 17
  (-100, 140) : (0.064213, 1.497443), # 25
  (-100, 150) : (0.082738, 1.488551), # 30
  (-100, 160) : (0.082860, 1.480532), # 33
  (-100, 170) : (0.091434, 1.363466), # 30
  (-100, 180) : (0.081950, 1.352625), # 11
  (-90, -180) : (0.072370, 1.329518), # 38
  (-90, -170) : (0.062345, 1.293857), # 23
  (-90, -30) : (0.043889, 2.203153), # 11
  (-90, -20) : (0.043700, 1.910063), # 66
  (-90, -10) : (0.049792, 1.805874), # 240
  (-90, 0) : (0.055618, 1.647285), # 362
  (-90, 10) : (0.049227, 1.621162), # 219
  (-90, 20) : (0.039828, 1.598560), # 91
  (-90, 30) : (0.029211, 1.708148), # 31
  (-90, 40) : (0.030090, 1.618549), # 27
  (-90, 50) : (0.013826, 1.347432), # 54
  (-90, 60) : (0.012626, 0.984602), # 117
  (-90, 70) : (0.019131, 0.569349), # 79
  (-90, 80) : (0.020704, 1.072402), # 28
  (-90, 90) : (0.038438, 1.081342), # 17
  (-90, 100) : (0.026309, 1.292989), # 20
  (-90, 110) : (0.028175, 1.308552), # 31
  (-90, 120) : (0.040670, 1.554257), # 61
  (-90, 130) : (0.042972, 1.586768), # 96
  (-90, 140) : (0.060674, 1.596580), # 172
  (-90, 150) : (0.069350, 1.580146), # 255
  (-90, 160) : (0.072705, 1.534578), # 271
  (-90, 170) : (0.072918, 1.442521), # 218
  (-90, 180) : (0.064070, 1.334101), # 49
  (-80, -180) : (0.054649, 1.355087), # 98
  (-80, -170) : (0.040040, 1.384632), # 65
  (-80, -40) : (0.029725, 3.040214), # 15
  (-80, -30) : (0.031519, 2.670430), # 149
  (-80, -20) : (0.033492, 2.278672), # 546
  (-80, -10) : (0.036160, 2.131845), # 1001
  (-80, 0) : (0.036201, 2.052469), # 673
  (-80, 10) : (0.031377, 2.173444), # 165
  (-80, 20) : (0.017870, 2.835949), # 50
  (-80, 30) : (0.021037, 2.267222), # 42
  (-80, 40) : (0.012092, 2.481714), # 64
  (-80, 50) : (0.006980, 2.123919), # 203
  (-80, 60) : (0.003431, 1.929990), # 499
  (-80, 70) : (0.006785, 0.873271), # 506
  (-80, 80) : (0.013875, 1.292228), # 221
  (-80, 90) : (0.017135, 1.438307), # 88
  (-80, 100) : (0.021420, 1.507124), # 90
  (-80, 110) : (0.025534, 1.658004), # 147
  (-80, 120) : (0.035111, 1.647476), # 187
  (-80, 130) : (0.039890, 1.678483), # 441
  (-80, 140) : (0.048989, 1.717081), # 919
  (-80, 150) : (0.055000, 1.687593), # 1468
  (-80, 160) : (0.059565, 1.611507), # 1598
  (-80, 170) : (0.056292, 1.518498), # 1039
  (-80, 180) : (0.054916, 1.430974), # 224
  (-70, -180) : (0.039948, 1.760884), # 37
  (-70, -170) : (0.024391, 1.670430), # 11
  (-70, -50) : (0.030210, -2.743228), # 36
  (-70, -40) : (0.028967, -3.131942), # 363
  (-70, -30) : (0.029033, 2.889102), # 1959
  (-70, -20) : (0.030758, 2.709414), # 3029
  (-70, -10) : (0.030063, 2.723126), # 2271
  (-70, 0) : (0.030094, 3.072375), # 349
  (-70, 10) : (0.042554, -2.621162), # 17
  (-70, 30) : (0.058606, -2.405476), # 10
  (-70, 50) : (0.062956, -2.103775), # 23
  (-70, 60) : (0.033446, -2.226617), # 39
  (-70, 70) : (0.017538, -2.287704), # 48
  (-70, 80) : (0.011274, 1.760635), # 19
  (-70, 90) : (0.006786, 2.419850), # 25
  (-70, 100) : (0.009043, 2.526452), # 48
  (-70, 110) : (0.022917, 1.797745), # 118
  (-70, 120) : (0.029178, 1.864534), # 360
  (-70, 130) : (0.038873, 1.870732), # 1237
  (-70, 140) : (0.045046, 1.858593), # 3059
  (-70, 150) : (0.050191, 1.824380), # 4867
  (-70, 160) : (0.050375, 1.777955), # 3761
  (-70, 170) : (0.049776, 1.678758), # 1187
  (-70, 180) : (0.040093, 1.663416), # 124
  (-60, -60) : (0.041506, -2.594384), # 11
  (-60, -50) : (0.024867, -2.615141), # 452
  (-60, -40) : (0.020364, 3.065092), # 4735
  (-60, -30) : (0.027147, 2.961342), # 6705
  (-60, -20) : (0.031011, 2.873311), # 4058
  (-60, -10) : (0.032504, -3.087227), # 636
  (-60, 0) : (0.043511, -2.703457), # 21
  (-60, 110) : (0.026794, 1.828051), # 28
  (-60, 120) : (0.025915, 1.937769), # 379
  (-60, 130) : (0.033848, 1.857121), # 2614
  (-60, 140) : (0.042575, 1.838191), # 6555
  (-60, 150) : (0.049660, 1.823169), # 5657
  (-60, 160) : (0.053282, 1.815577), # 1806
  (-60, 170) : (0.052922, 1.780954), # 219
  (-50, -60) : (0.042197, -2.362861), # 17
  (-50, -50) : (0.031309, -2.261390), # 578
  (-50, -40) : (0.020389, -2.773635), # 2869
  (-50, -30) : (0.023533, -3.111949), # 1438
  (-50, -20) : (0.030661, -2.864792), # 169
  (-50, 120) : (0.014028, 2.254562), # 231
  (-50, 130) : (0.024949, 1.823934), # 1847
  (-50, 140) : (0.034679, 1.740985), # 2305
  (-50, 150) : (0.039179, 1.743221), # 610
  (-50, 160) : (0.053922, 1.831349), # 57
  (-40, -60) : (0.091682, -2.070931), # 10
  (-40, -50) : (0.051606, -2.135850), # 77
  (-40, -40) : (0.034553, -2.352638), # 51
  (-40, 120) : (0.018717, -1.970844), # 25
  (-40, 130) : (0.007511, 2.228680), # 65
  (-40, 140) : (0.017248, 2.633978), # 23
}

if __name__ == '__main__':
  from mmtbx.validation.mean_devs_others_phi_psi import mean_devs as others_phi_psi
  for phi_psi in [(0,0), (-60,-60)]:
    print(phi_psi, mean_devs.get(phi_psi, None), others_phi_psi.get(phi_psi, None))

