from __future__ import absolute_import, division, print_function

def get_percentile_for_mpscore(clashscore, resolution=None):
  windowHalfWidth = 0.25

  nSamples = 0
  nWorse   = 0
  if not resolution: # None or 0.  Resol. not defined -- e.g. NMR structures. Compare to full DB.
    minres = 0
    maxres = 99
  else:
    minres = min(resolution, 3.50) - windowHalfwidth;
    maxres = max(resolution, 0.75) + windowHalfwidth;

  for i in mpscores_by_resolution():
  #[pdbFile,resolution,clashscore]
    if minres <= i[1] <= maxres:
      nSamples += 1
      if i[2] >= clashscore:
        nWorse += 1
  pctRank = int(100.0*nWorse/nSamples)
  return {"minres":minres, "maxres":maxres, "count":nSamples, "percentile":pctRank}

def mpscores_by_resolution():
  #pdbId,resol,eff.resol -- 30 June 2006, IWD -- "clip12" + 0.41245
  return [["2b97",0.75,1.965260872336],
["1x6z",0.78,1.38745408536147],
["1gci",0.78,1.05470435911845],
["1iua",0.8,1.64212757497556],
["1w0n",0.8,2.0836361525806],
["1pq7",0.8,1.40322386347032],
["1fy5",0.81,1.62828809448369],
["1fy4",0.81,1.59135142739061],
["1fn8",0.81,1.66883424214649],
["1gdn",0.81,1.70571711969543],
["1nwz",0.82,1.66273419950510],
["1cbn",0.83,0.970727514512122],
["1ssx",0.83,1.42870224947083],
["1xvo",0.84,1.02205130751648],
["1mc2",0.85,1.36903323841399],
["3pyp",0.85,1.96507607211783],
["1x8q",0.85,1.47639065933330],
["1x8p",0.85,1.70029352930509],
["1pq5",0.85,1.17350577050062],
["2f01",0.85,1.90826825082061],
["1m40",0.85,1.67793846656451],
["1pjx",0.85,2.41122584229608],
["1g6x",0.86,2.31637739119693],
["1muw",0.86,1.50475120841812],
["1v6p",0.87,2.57474442433433],
["1dy5",0.87,1.66299647379316],
["1gwe",0.88,1.50961178838326],
["1jxx",0.89,0.601278956827984],
["1jxt",0.89,0.601278956827984],
["1jxw",0.89,0.601278956827984],
["1jxy",0.89,1.33625163535425],
["1ab1",0.89,1.28516631375339],
["1f9y",0.89,1.61531738166949],
["1ywa",0.89,1.58985790971229],
["1i1w",0.89,1.70014491078253],
["1byz",0.9,0.79722467662333],
["1et1",0.9,1.46556029569114],
["1n9b",0.9,1.45806136117409],
["2bw4",0.9,1.80782912681078],
["1ix9",0.9,1.47899648682437],
["1ixb",0.9,1.72757862340319],
["2pvb",0.91,1.33569533977138],
["1j0p",0.91,1.83073427284885],
["1rb9",0.92,1.99470920587762],
["2g6f",0.92,1.11501099782361],
["1vb0",0.92,2.14418017375127],
["1l9l",0.92,1.91398289725916],
["1iqz",0.92,1.23824235523948],
["1pwm",0.92,1.71764107719594],
["1n4w",0.92,1.63625617364406],
["1vbw",0.93,1.92391883244999],
["1ok0",0.93,1.58407360138726],
["1b0y",0.93,2.22577416660285],
["1gdq",0.93,1.51065324750634],
["1ea7",0.93,1.50245327484180],
["2fdn",0.94,1.63534129137094],
["1iee",0.94,1.72147450702498],
["1nls",0.94,1.76275626296856],
["2bt9",0.94,1.36514515245320],
["1kwf",0.94,1.01230979933563],
["1brf",0.95,1.34864805697728],
["1kth",0.95,2.44412155672569],
["1zzk",0.95,1.96196303545522],
["1ot6",0.95,2.41376551577349],
["4lzt",0.95,1.14505307288157],
["1hj9",0.95,1.47261659245232],
["1lug",0.95,2.1689523488084],
["1nki",0.95,1.45204791479956],
["1rtq",0.95,1.65734277898701],
["1mj5",0.95,1.53528039967973],
["7a3h",0.95,1.56957712241735],
["1z8a",0.95,1.77501239923204],
["1bxo",0.95,1.68479776533973],
["1s5n",0.95,1.49859162368353],
["1n1p",0.95,1.81337964919360],
["1n4u",0.95,1.79782814796552],
["1mxt",0.95,1.61968267993994],
["1aho",0.96,1.40005363599364],
["1u2h",0.96,1.69404458946789],
["1x6x",0.96,0.970677714183958],
["1ufy",0.96,1.08699834728506],
["1luq",0.96,1.85009685540048],
["1k5c",0.96,1.65054053135397],
["1f94",0.97,1.52710850798342],
["1tg0",0.97,1.6877852220793],
["1c75",0.97,1.41145599070115],
["1xmk",0.97,2.08944444932598],
["1m1q",0.97,1.84112525702981],
["1g4i",0.97,1.49659567238551],
["1vl9",0.97,2.15801411714167],
["1ywb",0.97,1.51705632257489],
["2ayw",0.97,1.63455611685111],
["1byi",0.97,1.77728577169661],
["8a3h",0.97,1.65252881886739],
["2bf6",0.97,1.64897868755912],
["1xg0",0.97,1.31170906688403],
["1tqg",0.98,2.28642291234592],
["1unq",0.98,1.63773559280312],
["2g58",0.98,3.03471078517007],
["2bzz",0.98,1.79421791420039],
["1gqv",0.98,1.87244075051495],
["1k4i",0.98,1.66061877624400],
["1ylj",0.98,1.74800506592178],
["1ic6",0.98,1.81476126245236],
["1v0l",0.98,1.09758950175659],
["1ixh",0.98,1.41085583668854],
["1gvt",0.98,1.23421354192129],
["1s5m",0.98,1.33796145194283],
["1jxu",0.99,0.601278956827984],
["1mwq",0.99,1.56678641372351],
["1sfd",0.99,1.39902984652871],
["2fou",0.99,1.59185810643121],
["1mnz",0.99,1.24669250346491],
["1ug6",0.99,1.23085869772635],
["1p1x",0.99,1.13474501701809],
["1w3m",1,2.96745994285501],
["8rxn",1,1.72919606626825],
["1k6u",1,1.93086130704385],
["5pti",1,2.1403851141216],
["1oai",1,1.80816971031490],
["1ir0",1,1.73651619539919],
["1mso",1,1.67780053040031],
["1lkk",1,2.07570022430012],
["2chh",1,1.33780062707138],
["1g2y",1,1.78742574035072],
["1c7k",1,1.32081947861138],
["1k2a",1,2.20536196965758],
["1r2m",1,1.54976664287303],
["1exr",1,1.875003765893],
["1a6m",1,1.72412553397326],
["1tt8",1,1.89786825693417],
["1eb6",1,1.30848979173881],
["1sy2",1,1.65004169791853],
["1sy3",1,1.58864690265008],
["1ywc",1,1.47639065933330],
["1lni",1,1.68925832044561],
["1t2h",1,1.66107563174927],
["1cex",1,1.93724573982803],
["1k4p",1,2.00902333461964],
["1hj8",1,1.65290971565084],
["2a6z",1,1.37722036044188],
["1pq8",1,1.49865868161911],
["2cws",1,1.98829792889211],
["1y55",1,2.08556237694191],
["2gh7",1,1.89615281061706],
["1zk4",1,1.40685215916001],
["2agt",1,1.95538208964503],
["1gvw",1,1.00830256830075],
["1gvx",1,1.05148779960237],
["1kcc",1,1.91471927898541],
["2abb",1,1.76277013524646],
["1ga6",1,1.38637751606975],
["1mn8",1,2.60716820867592],
["1uzv",1,1.42647444919781],
["1n4v",1,1.73171573314211],
["1gkm",1,2.34531964148716],
["1q6z",1,1.44470604115825],
["1o7j",1,1.45352164599838],
["1sxx",1.01,1.59492649718705],
["1x8o",1.01,1.43060000693230],
["1sy1",1.01,1.52848756786558],
["1cc8",1.02,1.95266338266629],
["1i27",1.02,1.99640687246575],
["1m1r",1.02,1.77586445770808],
["1rw1",1.02,1.20247764716140],
["1cxq",1.02,1.09654216431889],
["1mfm",1.02,2.01084381619419],
["1s0q",1.02,1.38974250848757],
["1s0r",1.02,1.45711566166128],
["1p7w",1.02,2.08619573416477],
["1qtw",1.02,1.50525511182961],
["1y93",1.03,1.71289092768851],
["1nh0",1.03,1.63013174913562],
["1xqo",1.03,1.25750061219750],
["1v0k",1.03,1.29624924594969],
["1is9",1.03,1.77260084005138],
["1kqp",1.03,1.4826622133792],
["1i2t",1.04,1.43316850967083],
["1naz",1.04,1.38583747707700],
["1tjx",1.04,2.1099107888219],
["1uow",1.04,2.09668039464648],
["1qxy",1.04,1.68160783982238],
["2bog",1.04,1.64755366977676],
["2anx",1.04,1.77503236069638],
["2anv",1.04,1.56942040963805],
["1w3l",1.04,1.76296210854757],
["1z3n",1.04,1.68912377421543],
["1oe1",1.04,1.37389321061503],
["1d5t",1.04,1.91328478614400],
["1wui",1.04,2.00591493197973],
["1cnr",1.05,0.957100031169252],
["1sf3",1.05,1.85835124317269],
["1m9z",1.05,2.01874212139],
["1lwb",1.05,1.22128204383019],
["1kf3",1.05,1.45048258090311],
["1euw",1.05,1.80681693966839],
["1r2q",1.05,2.06073667602764],
["1sxw",1.05,2.08512728707764],
["1kmv",1.05,1.81806998888534],
["1psr",1.05,2.17753271262093],
["1m2d",1.05,2.06905307159271],
["2c71",1.05,2.06230979891735],
["1rqw",1.05,1.62253504887887],
["1sfh",1.05,1.03335346715865],
["2fhl",1.05,2.08607147167554],
["1zjy",1.05,1.86123846535287],
["1moo",1.05,1.61330177439429],
["2axw",1.05,1.30595783903335],
["1od8",1.05,1.09443972817606],
["1t41",1.05,1.67610746611427],
["1ixg",1.05,1.10584411872434],
["1rwy",1.05,1.32101099145688],
["1gvv",1.05,1.20272100487632],
["1yqs",1.05,1.20597717718260],
["2aba",1.05,1.57719658444914],
["3sil",1.05,1.42167393765951],
["1jfc",1.05,1.69904929702467],
["1w8f",1.05,1.74877502636576],
["1fsg",1.05,1.27246216240993],
["1jcl",1.05,1.12984058411354],
["1kjq",1.05,2.33515855928042],
["1lqt",1.05,1.71147319485926],
["1qow",1.06,2.21024145784620],
["1czb",1.06,1.14970604218682],
["1sx2",1.06,1.47066704226949],
["1swy",1.06,1.18684706580796],
["1swz",1.06,1.56762305294122],
["1pmh",1.06,1.69337367384501],
["1n40",1.06,1.74527454022647],
["1sxy",1.07,1.72915510635711],
["1sfs",1.07,1.90628019962141],
["1gdu",1.07,1.33491166511681],
["2c9v",1.07,1.50107935862351],
["1v0m",1.07,1.24912723677965],
["1xju",1.07,1.45066225396818],
["2ffy",1.07,1.81817653552414],
["1pwg",1.07,1.32720357548087],
["1jbe",1.08,1.29361713584284],
["1koi",1.08,1.62353324895033],
["1ywd",1.08,2.34626010840394],
["1x8n",1.08,2.02828686447295],
["1w66",1.08,1.22875725987755],
["1p7v",1.08,2.17194825810768],
["1h11",1.08,1.38484977541223],
["1ocq",1.08,1.40296921008428],
["1uwc",1.08,1.28830358850945],
["1w23",1.08,1.67720653111353],
["1jk3",1.09,1.84850685670733],
["1kms",1.09,1.80359965431413],
["1kzk",1.09,1.57576124529174],
["1k5n",1.09,1.30048949510951],
["2car",1.09,2.00983492419086],
["1n62",1.09,2.03242383467070],
["1iro",1.1,1.77844510343202],
["1bq8",1.1,0.756224715184947],
["2igd",1.1,0.811799191116927],
["1igd",1.1,1.94733646298101],
["1t8k",1.1,1.67802374013906],
["1ctj",1.1,1.22345413473652],
["2fe5",1.1,1.43929609712084],
["1t2i",1.1,1.42978596865951],
["1sf5",1.1,1.76737855341967],
["1gmx",1.1,2.11206471426042],
["1bkr",1.1,2.25288709462576],
["1d4t",1.1,1.97357654287920],
["1zwp",1.1,2.21960744551290],
["1tk4",1.1,2.50162268651],
["1tj9",1.1,2.73534400086842],
["2bax",1.1,2.30459767497221],
["1kf2",1.1,1.30597635529106],
["1kf4",1.1,1.54886349440802],
["1f9i",1.1,2.15677714960854],
["1lks",1.1,2.04401940515238],
["1x1k",1.1,1.34104008559492],
["1z2u",1.1,0.7642048436267],
["1a6k",1.1,1.93898949177680],
["2cal",1.1,1.63708590475341],
["1l3k",1.1,1.90798886450088],
["1i40",1.1,1.77885134021181],
["1kt6",1.1,2.46684642725574],
["1pm1",1.1,2.10382986717483],
["1qv0",1.1,1.53898362497323],
["1qv1",1.1,1.62255181718175],
["1p5f",1.1,1.42595481652861],
["2aib",1.1,1.45981191289747],
["1s65",1.1,1.91429742978461],
["2avo",1.1,2.02895273207188],
["2avs",1.1,2.16303694622391],
["1uz3",1.1,2.36444294162349],
["2aog",1.1,1.65612689223172],
["2avm",1.1,2.18682973244991],
["1bs9",1.1,1.24184475484639],
["1k4o",1.1,2.08022452092484],
["1xvm",1.1,1.25076410496898],
["1f86",1.1,2.30391311600235],
["1qnj",1.1,1.09654216431889],
["1zjz",1.1,1.66713567214948],
["1oh0",1.1,1.75197595888850],
["1qj4",1.1,1.35511503216636],
["2fos",1.1,1.41843038320960],
["1ylt",1.1,1.7949419536064],
["1ong",1.1,1.02475231697349],
["1rg8",1.1,1.33193916582951],
["1c5e",1.1,1.27275413456017],
["1ls1",1.1,1.52221963379330],
["1uoz",1.1,1.28907671638537],
["1v0n",1.1,0.933669124375694],
["2b3h",1.1,1.29839747665728],
["1nnf",1.1,1.72380178550207],
["1t2d",1.1,1.43927728272404],
["1pwl",1.1,1.40734815168107],
["1ys1",1.1,1.08996597123797],
["1r0r",1.1,1.40646489643005],
["2bwi",1.1,1.75186269705531],
["2abs",1.1,1.78486916527367],
["1yfq",1.1,2.2058925666684],
["1pwc",1.1,1.39458937793518],
["1kdv",1.1,1.47164361973008],
["1kdy",1.1,1.54765253078424],
["2ab0",1.1,1.54703130451909],
["1h4g",1.1,1.39402339623609],
["1itx",1.1,1.43684967224021],
["2a70",1.1,1.60979022719031],
["1g8t",1.1,1.87601478101020],
["1xf6",1.1,1.38583747707700],
["1o5x",1.1,1.68464857128414],
["1jcj",1.1,1.12664137175994],
["1sby",1.1,2.21143235356679],
["1zl0",1.1,1.60283054379727],
["1su8",1.1,2.11067112182543],
["1wuk",1.1,2.01774897066459],
["1wcg",1.1,1.46736080017521],
["1jm1",1.11,1.09654216431889],
["1i1x",1.11,1.14317755243118],
["1oc7",1.11,1.14532708429951],
["1g2b",1.12,1.52021030545271],
["1tuk",1.12,2.10616514994066],
["1sau",1.12,1.5651951453648],
["1jse",1.12,2.14885214619684],
["1jf8",1.12,1.666461628314],
["1lu4",1.12,2.40939449875541],
["1a7s",1.12,2.11374062608729],
["1k7c",1.12,1.42976745591961],
["2eut",1.12,1.35962546292959],
["2bw5",1.12,1.70474611873133],
["1oe2",1.12,1.16871151766509],
["1mpl",1.12,1.00093356953214],
["1ra0",1.12,1.51868792039840],
["1ym1",1.12,1.6293828031522],
["1h1n",1.12,1.29543241080254],
["1su7",1.12,2.09477705905715],
["2ccw",1.13,1.76679634713675],
["1wtn",1.13,1.14785095230744],
["1u07",1.13,2.09621404823498],
["1v7t",1.13,2.0455698261971],
["1z53",1.13,1.71202793355041],
["1scw",1.13,1.16925719078273],
["1n8k",1.13,1.57258580151728],
["1v7s",1.14,1.44071250128928],
["1wyx",1.14,1.3738694798973],
["1kng",1.14,1.64625801856425],
["1odv",1.14,1.70875174573892],
["1k6a",1.14,1.09033474946576],
["1gok",1.14,1.41682307707501],
["1p6o",1.14,1.83404042179512],
["1rxj",1.14,2.0082829314293],
["1swu",1.14,1.87094717834611],
["1g2z",1.15,1.81695358427534],
["1hg7",1.15,1.27831689229720],
["1vfy",1.15,1.55981329428162],
["1k8u",1.15,1.66014659978131],
["1xmt",1.15,1.56356839670481],
["1zmi",1.15,1.68648241654376],
["1j0o",1.15,2.18097531512210],
["1i8o",1.15,1.50345074197269],
["1b9o",1.15,2.37858702858625],
["1kf5",1.15,1.15252113785079],
["1kf7",1.15,1.30757388982488],
["1kf8",1.15,1.98493759816174],
["1f98",1.15,2.03207205474733],
["1jsf",1.15,1.82073770868319],
["1t3y",1.15,1.57589437770145],
["1o8s",1.15,1.44985222517525],
["1xt5",1.15,1.89561811643495],
["2bzv",1.15,1.49516112335812],
["1a6g",1.15,1.64075014306077],
["1a6n",1.15,1.85701861114746],
["2bwf",1.15,1.15452547504738],
["1u7r",1.15,1.62113608340038],
["1bzp",1.15,1.62627716518539],
["1bzr",1.15,1.27403155534561],
["1gwm",1.15,2.18547330057612],
["1h4a",1.15,1.69991042316585],
["1sy0",1.15,1.81376127287995],
["1d2u",1.15,2.31534442570534],
["1rge",1.15,1.49760802630631],
["1agy",1.15,1.03395106963060],
["2fhz",1.15,1.70686620205432],
["1hdo",1.15,1.38745152746604],
["1xod",1.15,1.4415564924071],
["2awk",1.15,1.57869689805791],
["1uto",1.15,1.3641491919776],
["1utq",1.15,1.66433216566083],
["1utn",1.15,1.85116406353852],
["1oxd",1.15,1.73754714683920],
["1vzi",1.15,1.88575017250402],
["2fov",1.15,1.56160765587926],
["1z70",1.15,1.33578626703711],
["1tkj",1.15,1.40461370906511],
["1hf6",1.15,1.62508197765035],
["1h2j",1.15,1.70873455061337],
["1q0e",1.15,1.41656387830843],
["1b6g",1.15,1.55051079786286],
["1odm",1.15,1.17224716872206],
["1kcd",1.15,2.03298991488522],
["2bwd",1.15,1.65321102570794],
["1oe3",1.15,1.56299451395663],
["1sde",1.15,1.37178422661743],
["1i4u",1.15,1.79171582362293],
["1e9g",1.15,1.35785651826973],
["1suf",1.15,1.93594186056495],
["1het",1.15,1.64264348404902],
["1heu",1.15,1.67250313303023],
["1npi",1.16,1.66502156663757],
["1kou",1.16,1.97086004141762],
["1tzb",1.16,1.61109218611817],
["1x9i",1.16,1.40677921297824],
["1hbn",1.16,1.46591415802795],
["1mro",1.16,1.68088663817024],
["1m1n",1.16,1.73568877370549],
["1c9o",1.17,2.24213039989377],
["1sl9",1.17,1.80158678111868],
["1czp",1.17,1.99329213389501],
["1wkq",1.17,1.96062130117244],
["1hvb",1.17,1.37628995613210],
["1kq6",1.18,2.74575383345489],
["1tjm",1.18,2.02416074670353],
["1n3l",1.18,2.57733896867272],
["1t1g",1.18,1.88262340390676],
["1t1e",1.18,2.18544545752138],
["1ubk",1.18,2.36317559498192],
["2frg",1.19,2.02334296823080],
["2fj8",1.19,1.49083520879302],
["1ljn",1.19,1.22345413473652],
["1ifc",1.19,2.20538714346636],
["1gu2",1.19,1.63126875364749],
["1lqp",1.19,1.62578094931254],
["1uwk",1.19,2.00114534217497],
["1n60",1.19,1.88361376660698],
["1sen",1.2,0.945259225169856],
["1bx7",1.2,1.69550626036113],
["1irn",1.2,1.04416274194194],
["1bq9",1.2,1.67107332574743],
["5rxn",1.2,2.54836080089533],
["4rxn",1.2,3.14235327860535],
["2knt",1.2,2.33879707745381],
["1y0m",1.2,1.41042029200509],
["2sn3",1.2,2.23695141317663],
["1ijv",1.2,2.6989824920823],
["1wm3",1.2,2.29256018991533],
["1cc7",1.2,1.99356303545627],
["1sn9",1.2,2.32468376279026],
["1usm",1.2,2.16029332076212],
["1l0i",1.2,1.56525718112629],
["1mj4",1.2,1.84333923435408],
["2akf",1.2,1.56005274952911],
["1wri",1.2,1.23283558554120],
["1ynv",1.2,1.49589422367457],
["1m5a",1.2,3.02384889660652],
["1wn2",1.2,1.93822880370042],
["1ugu",1.2,2.23333755116577],
["1sqz",1.2,2.45575077154848],
["1uwn",1.2,1.76160030884085],
["1knl",1.2,1.88374431766459],
["1djt",1.2,2.19084329662804],
["1knm",1.2,1.61466542551526],
["1qio",1.2,1.76839740250225],
["1tu9",1.2,1.95087989749498],
["2a26",1.2,1.58081261422421],
["1cz9",1.2,1.8493574148161],
["2fcl",1.2,1.51159310419128],
["1ucr",1.2,2.13420591678193],
["1bz6",1.2,1.77975534711576],
["2bk9",1.2,1.68451839867655],
["1j98",1.2,1.63650387513503],
["1hqj",1.2,2.52205539284641],
["1lf7",1.2,2.10057521570887],
["1i76",1.2,2.31750872435815],
["1cku",1.2,1.59006660361030],
["1amm",1.2,2.21879416721448],
["1i6t",1.2,2.21037269611287],
["2fkk",1.2,1.45248014689210],
["2bbr",1.2,1.88993995436013],
["1g7a",1.2,1.51576655891911],
["1rgg",1.2,1.82690481026992],
["1rgh",1.2,1.69311640032518],
["1rgf",1.2,2.08436952005596],
["2pth",1.2,1.71985277312225],
["1t3r",1.2,1.80386856652997],
["1qrw",1.2,1.67945327951585],
["1qq4",1.2,1.91065495699220],
["1ve4",1.2,2.07168698632555],
["1k1t",1.2,1.64802347327026],
["1z0w",1.2,2.1482043348253],
["1he2",1.2,1.72728899138632],
["1kwn",1.2,1.21197367670572],
["1v8h",1.2,1.67074851685933],
["1gyo",1.2,1.92752940994873],
["1me4",1.2,1.22345413473652],
["1me3",1.2,1.40314990883341],
["1jg1",1.2,1.50926235261940],
["1fye",1.2,1.77376241114872],
["1fy2",1.2,2.08769335706326],
["1o08",1.2,2.08638511480634],
["2nlr",1.2,1.48986280052292],
["1vk1",1.2,0.950345322373524],
["1y59",1.2,1.50371970454827],
["2blv",1.2,1.55263401321076],
["2blw",1.2,1.56435070122798],
["1uai",1.2,1.99307346515309],
["1kg2",1.2,1.50167313197792],
["1mun",1.2,1.92095956481476],
["1o7i",1.2,1.7236213659869],
["2g2s",1.2,1.51932147339795],
["1atg",1.2,1.45032548166596],
["1vr7",1.2,2.08059847715454],
["1i3h",1.2,2.22211373616919],
["1y53",1.2,2.00577573785798],
["1ymt",1.2,1.91030636541275],
["1qtn",1.2,1.83688670674284],
["1o0o",1.2,2.61991681611065],
["1o0h",1.2,2.69725454926379],
["1arb",1.2,1.47322367048861],
["1ylp",1.2,1.76436702439597],
["1nym",1.2,1.41604114886224],
["1xdn",1.2,1.32109392419143],
["1yr4",1.2,1.69811325635566],
["2f91",1.2,1.76690941020270],
["1tkf",1.2,1.41826156737942],
["1xbu",1.2,1.41791964242595],
["1nww",1.2,1.45862574565813],
["1lc0",1.2,2.20454173961391],
["1lok",1.2,2.17647254236427],
["1zby",1.2,1.60561218769373],
["1w3k",1.2,1.50712699773364],
["1e0w",1.2,0.715772856642468],
["1z2n",1.2,1.46288062995265],
["1q35",1.2,1.60707468358047],
["1s1p",1.2,1.91792865295650],
["1ryo",1.2,1.78998450144411],
["1cse",1.2,2.44250650925276],
["1obo",1.2,1.52435407877203],
["1wxc",1.2,1.72258520388345],
["1pwd",1.2,1.15865011281288],
["1pw1",1.2,1.31933842479931],
["1r5y",1.2,1.56165252161593],
["1m15",1.2,1.65072298575862],
["1qu9",1.2,1.0728008573201],
["1i24",1.2,1.38648693877638],
["1h12",1.2,1.46690040053583],
["1nz0",1.2,1.65964426249592],
["1ney",1.2,1.43292408756123],
["1e4m",1.2,1.72751923963879],
["1pi3",1.2,1.30224604285945],
["1po7",1.2,1.29308456715851],
["2bhz",1.2,1.45634467770457],
["2bln",1.2,1.58270187777823],
["1w32",1.2,1.88750479386733],
["2c0r",1.2,1.88395582475955],
["1mgo",1.2,1.44237750158679],
["1ubl",1.2,2.36560442188242],
["1qw9",1.2,2.28969536389651],
["1tqw",1.2,1.53334821537207],
["1qwn",1.2,1.59027022874538],
["1w6s",1.2,1.65884538514698],
["1q6o",1.2,1.59688129697277],
["1sxk",1.21,2.44417531340188],
["1skg",1.21,2.96349123164206],
["1e29",1.21,1.91933601625354],
["1lb3",1.21,1.34398233955609],
["1d4o",1.21,1.90358940623486],
["1j8a",1.21,1.22963562196612],
["2b69",1.21,0.971961256759092],
["1n63",1.21,1.78857491660771],
["9pti",1.22,1.56286758592315],
["1g39",1.22,2.36692884885382],
["2f8g",1.22,2.14889118376704],
["1kyf",1.22,2.12433740735429],
["1z2p",1.22,1.43766252680257],
["1mju",1.22,1.87910350333737],
["1yno",1.22,1.55698839960266],
["1hxh",1.22,1.84768942877991],
["1ycc",1.23,2.52216879632263],
["1th6",1.23,2.24518019132866],
["2arm",1.23,2.24518019132866],
["1ppz",1.23,1.72478008968441],
["1pqa",1.23,1.80644029084515],
["2a3n",1.23,1.22839808476024],
["1nte",1.24,1.86303864907803],
["1wma",1.24,1.42290073085931],
["2c9s",1.24,2.17146579747082],
["2c9u",1.24,1.64490872200028],
["1z2o",1.24,1.51170131277103],
["1usc",1.24,1.79186493661528],
["1wuh",1.24,1.97315888317806],
["1jni",1.25,1.37343371638810],
["1msi",1.25,1.80975504106658],
["2c60",1.25,1.68878233741344],
["1y6x",1.25,1.16157101563331],
["1mfg",1.25,1.82505891475439],
["1unr",1.25,2.31015645289891],
["1qau",1.25,2.02527462111721],
["1zma",1.25,1.39633720660444],
["2ft6",1.25,1.3085342389448],
["1tjq",1.25,2.84455344199520],
["1tg1",1.25,3.07712104739411],
["1tjk",1.25,2.8607991357569],
["2d6b",1.25,2.64910613363840],
["2fvv",1.25,1.72559401092371],
["1s3c",1.25,1.46716217356999],
["2fg1",1.25,1.76141755046425],
["1hq2",1.25,1.16871151766509],
["1q0n",1.25,1.62591631701000],
["1hk0",1.25,1.83431527303718],
["1ml7",1.25,1.62364736482684],
["1rfk",1.25,1.53296742168010],
["1i8v",1.25,1.39594750388537],
["1mf7",1.25,2.40334881926003],
["1sdu",1.25,1.39791938164698],
["2f81",1.25,2.01198390083082],
["1cus",1.25,1.49150045843869],
["1m2b",1.25,2.15388845671484],
["1lxz",1.25,1.6505589123319],
["1s83",1.25,1.15655756577919],
["2fzu",1.25,1.78616731761596],
["1ooh",1.25,1.7363404376669],
["1k3x",1.25,2.05720854401843],
["2foq",1.25,1.83598589882847],
["1oaa",1.25,1.77030421943149],
["1tkh",1.25,1.30291037828273],
["1ird",1.25,1.84809371601016],
["2dfo",1.25,1.76573549370977],
["1m4l",1.25,1.96688227528307],
["2b3n",1.25,2.37846321379937],
["1tmm",1.25,1.79093484935588],
["2wea",1.25,1.27504558943552],
["1wms",1.25,2.27636327355804],
["1qft",1.25,1.93478211319764],
["1o8b",1.25,1.58575959630078],
["1mex",1.25,1.60829808998471],
["2b82",1.25,1.31464029704652],
["2tps",1.25,1.84215439776823],
["3chb",1.25,1.57506104635042],
["1jeu",1.25,2.05789545349848],
["1yly",1.25,1.36745875104939],
["2cov",1.25,1.59232816140901],
["1gnt",1.25,1.33147539448454],
["2dfq",1.25,1.87252158870876],
["1ynp",1.25,1.69387129860935],
["1c1d",1.25,1.8546628173076],
["1m70",1.25,1.72987150501570],
["1rwh",1.25,1.2319135300617],
["1lqu",1.25,1.58247005579545],
["1gnl",1.25,1.57814421162675],
["1oa0",1.25,1.53253825370322],
["1upx",1.25,1.50198621247608],
["7rsa",1.26,0.904107539056337],
["1j9b",1.26,1.79227785568528],
["1ctq",1.26,2.31173777599446],
["1n0q",1.26,1.91547544959421],
["2cc6",1.27,1.66325390948987],
["1gxu",1.27,1.65455849963564],
["2cak",1.27,2.39687976837530],
["2bjd",1.27,1.82020784152988],
["1ikj",1.27,1.88548314658985],
["1vyp",1.27,1.54819881984336],
["1wdp",1.27,1.71858053322774],
["1kt7",1.27,2.53132336998043],
["1c52",1.28,2.20321505273575],
["1rtt",1.28,1.51751850019469],
["1mqk",1.28,1.90038581464040],
["1w04",1.28,1.29119311993476],
["1t1i",1.28,2.06360736409244],
["1wdq",1.28,1.81510448431211],
["1vlb",1.28,1.93808779241655],
["1qks",1.28,1.77436696673596],
["1pqh",1.29,1.23863514252176],
["1zbz",1.29,1.45604086659489],
["2aeb",1.29,2.28057132507363],
["1gkp",1.3,1.73901190825532],
["1zmk",1.3,1.71020653690551],
["1jo8",1.3,1.79913226688491],
["1sn4",1.3,2.74086264291555],
["1ptx",1.3,1.30816811311667],
["1seg",1.3,1.81059752040564],
["1pid",1.3,2.22317889739994],
["1ulr",1.3,1.54267518446438],
["1ls9",1.3,1.3725844997413],
["1fk5",1.3,1.68534537292288],
["1cy5",1.3,2.41476378738608],
["1w2l",1.3,2.39517683917659],
["1qt9",1.3,1.00030303478462],
["1jhg",1.3,1.43021529028650],
["1v70",1.3,1.91272117376716],
["1bxa",1.3,1.44947987862062],
["2rac",1.3,1.21699260402446],
["1fus",1.3,1.37148365745910],
["7fd1",1.3,1.71166318624300],
["1rro",1.3,1.64211849389331],
["1pwa",1.3,1.92966194304152],
["1r29",1.3,2.09196727368661],
["135l",1.3,2.30480106648153],
["1w8u",1.3,1.31821553223422],
["2df6",1.3,1.95826890359981],
["1o8x",1.3,1.23917042626338],
["1qdd",1.3,1.88419391890664],
["1dg6",1.3,2.34038657132952],
["1zce",1.3,2.19693569180752],
["1f4p",1.3,1.26565602384815],
["1jcd",1.3,1.14317755243118],
["1jl1",1.3,1.99286046076022],
["1jw8",1.3,1.44607165841799],
["1rut",1.3,0.991191604184062],
["1uso",1.3,1.72502001185635],
["1sxv",1.3,1.42973612033866],
["1k6f",1.3,1.12884143520705],
["1xeo",1.3,1.53749160209949],
["1x1r",1.3,1.35045652139913],
["1z6m",1.3,1.66495928244465],
["1isp",1.3,1.98868243273586],
["1mjn",1.3,2.02301657428599],
["1g7b",1.3,1.47344035177278],
["1vp8",1.3,1.15037620165004],
["1ucd",1.3,1.91549696867403],
["1sdt",1.3,1.13174753832513],
["2a1e",1.3,1.59273093081704],
["1s6g",1.3,2.07519642618280],
["1tw7",1.3,2.05578134364005],
["2aoc",1.3,1.38047537573856],
["2avq",1.3,1.88945489578639],
["1yj1",1.3,2.09530753448231],
["1es9",1.3,2.40685925464503],
["2by6",1.3,1.34905319550174],
["1vd6",1.3,1.89737543984659],
["1lq9",1.3,1.56719723203369],
["1utp",1.3,1.48266231721815],
["2by7",1.3,1.34905319550174],
["2by8",1.3,1.37531153264405],
["2bya",1.3,1.37531153264405],
["2by5",1.3,1.42056568143491],
["2by9",1.3,1.42199434872765],
["2g6e",1.3,1.58927157928058],
["1qwy",1.3,1.12165379218767],
["2fhn",1.3,1.88015867589622],
["1fcy",1.3,1.44873951742782],
["1flm",1.3,1.76341495872567],
["2f69",1.3,1.88310791940331],
["1wcw",1.3,2.33719964196708],
["1ozu",1.3,1.64296502136634],
["1tf8",1.3,1.23376264510803],
["1tf9",1.3,1.43153064271297],
["1dcs",1.3,1.64159650481862],
["1kmt",1.3,1.75357176284157],
["1xub",1.3,1.64692851377640],
["2c4b",1.3,1.51582343455503],
["1gz8",1.3,1.95448065356647],
["2as4",1.3,1.16693758820814],
["2euq",1.3,1.51675072739460],
["1f9v",1.3,2.47791276117729],
["1tjy",1.3,1.59082863758256],
["1x98",1.3,2.12615331723213],
["1lzl",1.3,2.33287188543941],
["1rya",1.3,1.90698764169525],
["1wly",1.3,1.84983653001325],
["2bjs",1.3,1.33017858296191],
["1vly",1.3,1.35952841592623],
["1tbf",1.3,1.68991638272081],
["1nuw",1.3,2.59209003235189],
["1uzw",1.3,1.52406748131309],
["1bk0",1.3,1.18748045611553],
["2bu9",1.3,1.27761275189745],
["1yg9",1.3,1.98093877928820],
["1hb2",1.3,1.23499683174895],
["1obn",1.3,1.39328280414143],
["1to2",1.3,1.55624942943092],
["1wkr",1.3,1.04534700544190],
["2fcj",1.3,1.87287566832829],
["1pw8",1.3,1.35792012543342],
["1usf",1.3,1.57029927195599],
["1ka1",1.3,2.17323479136449],
["1s2p",1.3,1.72309116388049],
["1ocj",1.3,1.68916053351309],
["1nlu",1.3,1.37552043300169],
["1wpn",1.3,1.34925476469615],
["1dbf",1.3,2.12296293729788],
["1nxm",1.3,1.79500780127824],
["1jnd",1.3,1.73351773962712],
["1h13",1.3,1.46248394543657],
["1xwt",1.3,1.15795534673656],
["1wmd",1.3,1.42442815380976],
["1ncw",1.3,1.91209483683671],
["1k3y",1.3,1.77600939568967],
["1g61",1.3,1.77221612623104],
["1gzt",1.3,1.51133281599173],
["2a50",1.3,2.10286108791205],
["1vdw",1.3,1.66093084228094],
["1jr0",1.3,1.90566606281449],
["1djr",1.3,1.36818650946346],
["1wvf",1.3,1.42952257284146],
["1jev",1.3,2.00423305267933],
["2d1s",1.3,1.36533234808536],
["1o7q",1.3,1.78779944251856],
["1ynq",1.3,1.92035169289497],
["1i12",1.3,2.17167426755067],
["1i0d",1.3,2.27065198477283],
["1i0b",1.3,2.67935448020201],
["1hzy",1.3,2.13744106067325],
["1jgm",1.3,2.28785294674433],
["1z41",1.3,1.56028268371163],
["2bie",1.3,1.43319239437484],
["1o2d",1.3,1.11086365968396],
["1j2r",1.3,1.74271684571710],
["1sg4",1.3,2.16149844672110],
["1rwa",1.3,1.36432897433213],
["1eu1",1.3,1.38278059678279],
["1gk9",1.3,1.48334505213847],
["1hyo",1.3,1.70754895627866],
["1tqs",1.3,1.52058769941316],
["1qx1",1.3,1.68845134130987],
["1hdh",1.3,1.65450159131730],
["1t6u",1.3,1.36665164277056],
["1r0m",1.3,1.93505114294234],
["1n61",1.3,1.89159843205425],
["1aac",1.31,0.865567791625972],
["1vmh",1.31,1.03819150164992],
["1gwu",1.31,1.64835306953442],
["1nyk",1.31,1.26496153246650],
["1ocn",1.31,1.27465653291537],
["1vf8",1.31,2.41723723609287],
["1snr",1.31,1.39038268794185],
["1kgd",1.31,1.73045737267180],
["2fgo",1.32,2.00441798936302],
["1hzc",1.32,1.70416906053066],
["2a13",1.32,1.26282715992725],
["1x3s",1.32,2.02022057321229],
["1mkk",1.32,1.46740466999038],
["1v9y",1.32,2.09227780655838],
["2aof",1.32,1.98632692217466],
["1z0j",1.32,1.20920863447034],
["1lzj",1.32,2.01071045954243],
["1e7l",1.32,1.39477866018890],
["1r9z",1.32,1.47738130347233],
["1rak",1.32,1.62620842553501],
["1q5m",1.32,2.06997233018044],
["1gxm",1.32,1.69262857083779],
["1plc",1.33,1.87830812017273],
["1wtm",1.33,1.8749584142765],
["193l",1.33,1.91206620123604],
["2cuo",1.33,1.43780955993837],
["1rtz",1.33,2.20893093160187],
["1o3d",1.33,1.70657386098195],
["2blq",1.33,1.32857119891821],
["2blo",1.33,1.38358211852796],
["2boq",1.33,1.48803420516156],
["1wx3",1.33,1.9143582798753],
["2etx",1.33,1.40936403153166],
["1kko",1.33,2.25895623966971],
["1o9i",1.33,1.16871151766509],
["1utg",1.34,2.60996425418831],
["2d01",1.34,2.08539212645161],
["1rmz",1.34,2.05290575130082],
["1vhu",1.34,1.62088113399071],
["5ptp",1.34,2.16905042258855],
["1ujp",1.34,1.56156240632248],
["2a3u",1.34,1.44108992528784],
["1vh5",1.34,1.78528751966192],
["1yph",1.34,1.34448404781155],
["1ubt",1.34,2.57038646464876],
["1ubr",1.34,2.52624421467092],
["1obx",1.35,1.77206268393728],
["1g2r",1.35,2.18519790809216],
["6fd1",1.35,1.46932485355558],
["1up9",1.35,2.51910025986045],
["1pz4",1.35,1.90401424638973],
["1sv3",1.35,2.56123418789152],
["1bqk",1.35,1.83793561970292],
["1e85",1.35,1.59870092217169],
["2lis",1.35,1.64891775072271],
["1vkk",1.35,1.53495442383163],
["1tzv",1.35,2.59194577195724],
["1sjw",1.35,1.60859688443426],
["1j8q",1.35,1.68132947910401],
["1gyy",1.35,1.6825900151067],
["1gyx",1.35,1.50837462940762],
["1pin",1.35,2.62309278315595],
["1gjn",1.35,1.37507223972059],
["1fd3",1.35,2.15183087137569],
["1rb0",1.35,2.48025035181979],
["1ky3",1.35,2.38952176849327],
["5p21",1.35,1.91312829962227],
["1oh4",1.35,1.73645829832731],
["1e5k",1.35,2.08508574776894],
["1ukf",1.35,1.83140097130132],
["2a8f",1.35,1.52128609985437],
["1yn3",1.35,2.27275593807195],
["1t7i",1.35,1.78356642334466],
["2bb9",1.35,1.86036381739819],
["1gpp",1.35,1.88456382481245],
["1u9c",1.35,1.49671535547859],
["1mqo",1.35,2.20945774711271],
["1kyp",1.35,1.33130025886175],
["1yjf",1.35,1.52100067711706],
["1kg5",1.35,1.40273712048686],
["2g3d",1.35,1.70859853258636],
["1eaj",1.35,1.35160039632186],
["1ijy",1.35,1.60273050859141],
["1mqi",1.35,1.51933751929543],
["1lzi",1.35,1.82865661270774],
["1lqk",1.35,1.77853510824512],
["1p2j",1.35,1.32148048462772],
["1ojr",1.35,1.8033812028389],
["1pb7",1.35,2.17425274569659],
["1zgk",1.35,1.24116922583546],
["2aqd",1.35,1.08051483436644],
["1si0",1.35,1.49278769386163],
["1qje",1.35,1.61679443217737],
["1p5b",1.35,2.17151687400591],
["1p4c",1.35,2.59473173442878],
["2fxu",1.35,1.59941983808445],
["1wu4",1.35,1.66524927672448],
["1lk2",1.35,1.90841535307283],
["2c1i",1.35,1.86197431311485],
["1bsm",1.35,2.57422027522426],
["1i0h",1.35,1.50087766301817],
["1wzd",1.35,1.58776999615562],
["1wdr",1.35,1.63655900939186],
["1e6q",1.35,1.69338529727121],
["1e6s",1.35,1.82188694082891],
["1rf2",1.35,1.90783248516139],
["1rdp",1.35,1.81482836140778],
["1pzk",1.35,1.86304194488961],
["1ylz",1.35,1.58402716028632],
["1w9m",1.35,1.36734341953741],
["1u1w",1.35,1.56896809219095],
["1m6z",1.35,1.7256767813214],
["1rw9",1.35,1.16929667733846],
["1vef",1.35,1.8448227345065],
["1ubh",1.35,2.27326670662521],
["1ubj",1.35,2.42371914991790],
["1ubo",1.35,2.56555231607208],
["1ubu",1.35,2.56986368973016],
["2c4j",1.35,1.06884740223163],
["1f1g",1.35,1.98729334938343],
["1wdd",1.35,1.99339323197735],
["1smm",1.36,2.13598466623908],
["2esk",1.36,1.65663173868790],
["1zir",1.36,2.16102439929978],
["1wbe",1.36,1.7525807621066],
["1qwh",1.36,1.36570277198769],
["1ly0",1.36,1.76381106519004],
["1c5s",1.36,1.98201290423208],
["2izg",1.36,1.90145387493749],
["2izh",1.36,1.89963915284317],
["1rhs",1.36,2.78223649392042],
["1qfv",1.36,1.95487803613415],
["1y2k",1.36,1.14317755243118],
["1vim",1.36,1.72201370768730],
["2akz",1.36,1.87442725707849],
["1lyv",1.36,1.52007237696544],
["1f1e",1.37,1.57189387852137],
["1jo0",1.37,2.10510665752642],
["1kug",1.37,2.18839295830119],
["1gi4",1.37,1.69192590168014],
["1c1t",1.37,1.7687250411733],
["1c1p",1.37,1.86087464710439],
["1c1q",1.37,1.85175425040422],
["1c1r",1.37,2.00015574099037],
["1c5u",1.37,1.73185825732248],
["1c5t",1.37,1.94428939576654],
["1thm",1.37,1.32534073835051],
["1xoz",1.37,1.93451835284753],
["1od1",1.37,1.12493551373993],
["1rgz",1.37,1.59713955647223],
["1ouw",1.37,1.57115123653376],
["1smw",1.38,1.82170486926010],
["1ryq",1.38,0.987143309462223],
["1nxb",1.38,4.88265733990703],
["1kqw",1.38,2.28381250653205],
["1mh1",1.38,2.31527091425206],
["1s9u",1.38,1.88891361769064],
["1gi2",1.38,1.42670371456121],
["1o2w",1.38,1.49130468072901],
["1o38",1.38,1.73785845953382],
["1fcz",1.38,1.21559888507671],
["1fd0",1.38,1.56433053428697],
["1gvo",1.38,1.69833628130498],
["1gvs",1.38,1.85677842856942],
["1gvr",1.38,2.53813007737249],
["1xmz",1.38,1.91920216170103],
["1hx0",1.38,1.36119734875835],
["1gve",1.38,1.63323794920894],
["1gt9",1.38,2.40165265330307],
["2rta",1.39,2.3459831896719],
["1sjy",1.39,2.24995920692453],
["2c3v",1.39,2.47933823378473],
["1i1j",1.39,1.66153186443122],
["1yiw",1.39,1.72364628753970],
["1ghz",1.39,1.58407263841247],
["2rtg",1.39,2.17074333031216],
["2rtq",1.39,2.62009499039319],
["2eur",1.39,1.61167511490235],
["1y9u",1.39,1.70061036133474],
["2cz1",1.39,1.48524652433476],
["1h2w",1.39,1.67166769691152],
["1pi4",1.39,1.77431043721752],
["1k55",1.39,1.91045554068293],
["1jkv",1.39,1.35212892292969],
["2bkx",1.4,1.79756790191154],
["1bx8",1.4,1.87972978006291],
["2bn1",1.4,1.53384494111768],
["2bn3",1.4,1.53534403581344],
["1rdg",1.4,1.90837528772572],
["1rpo",1.4,2.07032276012237],
["3ebx",1.4,2.76030140253537],
["1pfb",1.4,1.73944738984769],
["1t7e",1.4,2.16304231398302],
["1yu5",1.4,1.48467878270579],
["1ssh",1.4,1.36009343585484],
["1en2",1.4,2.06070833389558],
["2fq3",1.4,1.91645497925726],
["1awd",1.4,1.47710338760134],
["1ben",1.4,2.0130986856881],
["2brf",1.4,1.70874011034559],
["2axi",1.4,2.52903273827391],
["3vub",1.4,1.69334812776630],
["1eaz",1.4,2.14690746598971],
["6fdr",1.4,1.78993849332421],
["7fdr",1.4,1.77899669302802],
["1upd",1.4,2.36601012568652],
["1wr5",1.4,2.33930676534762],
["1vzm",1.4,1.89815555936543],
["1kr4",1.4,2.21827823613529],
["1ifr",1.4,2.10597836602365],
["1hh7",1.4,1.50345074197269],
["1v30",1.4,2.08834950755681],
["1h10",1.4,1.70083407595577],
["1pbj",1.4,1.82365832841302],
["1ti0",1.4,2.6153307714085],
["1faz",1.4,1.73510675339455],
["2ft7",1.4,1.34221942832611],
["1eic",1.4,2.87385913601185],
["1eid",1.4,3.02209253507272],
["2blp",1.4,1.56127664272786],
["2blz",1.4,1.56127664272786],
["1rpg",1.4,2.15116772567935],
["1eie",1.4,2.87968882082352],
["1fs3",1.4,2.98863434091818],
["2phy",1.4,2.13733715880682],
["1jzg",1.4,1.80350608100452],
["2blx",1.4,1.82840915464759],
["2bly",1.4,1.71531201053315],
["194l",1.4,2.09802719095095],
["2ihl",1.4,1.6771692242024],
["1qgv",1.4,3.1676708463551],
["1qyz",1.4,1.98550449202249],
["1iwv",1.4,1.15972768315702],
["1iwu",1.4,1.13654739134884],
["1iwx",1.4,1.40303593344921],
["1iww",1.4,1.41017695380371],
["1iwy",1.4,1.41017695380371],
["1jwr",1.4,1.62032512921698],
["1i5f",1.4,1.81144894557005],
["1d06",1.4,2.85331552182265],
["1ew0",1.4,2.72356008057571],
["1kv0",1.4,2.52791098552410],
["1lju",1.4,2.17034720423737],
["1hmt",1.4,1.98356622149809],
["1hms",1.4,2.40743499461737],
["1hmr",1.4,2.51800610171226],
["1gp0",1.4,2.09715438922813],
["1eco",1.4,1.96066475537647],
["1ecd",1.4,2.01564802847472],
["1eca",1.4,2.06433570197368],
["1ecn",1.4,2.07539456929158],
["1iju",1.4,2.88981122749416],
["1kjl",1.4,1.83722887973984],
["1w8t",1.4,1.33070801271431],
["1qk8",1.4,1.78489709436912],
["1i5g",1.4,1.7720671995536],
["1jl7",1.4,1.57474753435823],
["1jf3",1.4,1.69495537397310],
["1jl6",1.4,1.82466797038092],
["1jf4",1.4,1.88942670910065],
["2b06",1.4,1.80185584116044],
["1ng6",1.4,1.62019949997638],
["1f21",1.4,2.37694309456351],
["1dwt",1.4,1.49082000788559],
["2evk",1.4,1.77032735014190],
["1u7s",1.4,2.28106927389271],
["1bvd",1.4,2.15258612749832],
["1mbd",1.4,2.53305388392745],
["1dxd",1.4,1.93645376227506],
["1dxc",1.4,1.49585003577545],
["1h1x",1.4,1.81102460234834],
["1kqr",1.4,2.21081073610753],
["1ezg",1.4,1.66691001922694],
["1i73",1.4,2.61335931154033],
["1fw9",1.4,1.92321259289655],
["1rcf",1.4,1.39728351775106],
["1ye8",1.4,1.14390393410459],
["2ew0",1.4,2.03373090094436],
["1kt3",1.4,2.50096883192126],
["2f1s",1.4,1.69221652690499],
["1sxu",1.4,1.54349849934817],
["1erx",1.4,1.97316528503036],
["1d3s",1.4,2.29671886240527],
["1v7r",1.4,1.84558739646929],
["2fi1",1.4,1.12467703429404],
["2g7s",1.4,1.68097005311754],
["1svf",1.4,1.67246385817524],
["1q92",1.4,1.9707544611283],
["1sdv",1.4,1.34012933291082],
["2aod",1.4,1.29181240708576],
["2ftr",1.4,1.20309052581427],
["1y43",1.4,1.40110664405163],
["1he3",1.4,1.83614674455940],
["2aoi",1.4,1.74445386195335],
["1he4",1.4,1.38612718519104],
["2blu",1.4,1.27031527986808],
["2blr",1.4,1.29598424191759],
["1m1f",1.4,1.8281074504823],
["1k7j",1.4,1.79179657909759],
["1uyl",1.4,2.00107465239978],
["256b",1.4,2.2259830667706],
["2cxv",1.4,2.02916369916053],
["2cz2",1.4,1.66472964992213],
["1o03",1.4,1.71351184677636],
["1y5a",1.4,1.57901456601044],
["1s5s",1.4,1.12051371008626],
["1o3l",1.4,1.40087927031207],
["1n6x",1.4,1.42952652736676],
["1n6y",1.4,1.26096679624217],
["1c1n",1.4,1.96833789253348],
["1o3j",1.4,1.84970144839657],
["1c2h",1.4,1.84828923139091],
["1c2j",1.4,1.97607211348253],
["1c2m",1.4,2.06860138183404],
["1c1o",1.4,2.00383823662078],
["1tpp",1.4,2.01572517242329],
["1uu6",1.4,1.39290561113183],
["1muy",1.4,2.20999383820826],
["4eug",1.4,2.08321259019397],
["2b3p",1.4,1.85454126719416],
["1g8a",1.4,1.65935798082984],
["2fwq",1.4,1.84742423740956],
["2fsq",1.4,1.31360266134914],
["1zi8",1.4,1.93541785072966],
["1f7d",1.4,2.39561094807297],
["1sgp",1.4,2.31264299716278],
["1gg6",1.4,1.62193478289757],
["2any",1.4,1.39992678181963],
["1mk5",1.4,1.54305164001231],
["2rti",1.4,2.49674561240993],
["2izc",1.4,2.78155821565707],
["1haz",1.4,1.70268820380097],
["1jlt",1.4,1.92402637114023],
["1yc5",1.4,1.49402266694206],
["1s2o",1.4,1.85199989560143],
["1rjc",1.4,1.56391836997048],
["1eao",1.4,1.50347929523741],
["1qts",1.4,1.83768853914471],
["1oaf",1.4,2.01976242786500],
["1rl0",1.4,1.47160817816122],
["1ie9",1.4,1.99416774081233],
["1t7r",1.4,1.40759547557168],
["1uxz",1.4,1.61144008847037],
["1es5",1.4,2.10480287334098],
["1yt4",1.4,1.60375873689446],
["1uq5",1.4,1.70244209683332],
["1ypq",1.4,1.72731389211944],
["1u7i",1.4,1.62093468883229],
["1jy2",1.4,1.86566006622573],
["1st3",1.4,1.71401893825021],
["1svn",1.4,2.29511556329629],
["1ltz",1.4,2.20948914405870],
["2cit",1.4,1.43970815720984],
["1h8d",1.4,2.70045978302654],
["1x99",1.4,1.64404412688018],
["1mnn",1.4,1.81805586869954],
["1y20",1.4,1.90178677660527],
["3sdh",1.4,1.37013762931530],
["1ru1",1.4,2.14738708012062],
["2as3",1.4,1.22797075429227],
["2eup",1.4,1.68253134549964],
["1gcu",1.4,2.31677679563294],
["1obd",1.4,1.98228640483711],
["1u4g",1.4,2.0238388589267],
["2ctc",1.4,2.15649510732763],
["1y8a",1.4,1.78084961771730],
["1dry",1.4,1.69424945546212],
["1x96",1.4,2.193416026362],
["1x97",1.4,2.34217153580564],
["1q5y",1.4,1.98075242297286],
["1xgk",1.4,1.63258450994994],
["1qjf",1.4,1.59234875250624],
["1fo8",1.4,1.75912575132261],
["1w3v",1.4,1.45960410519550],
["1hb3",1.4,1.44785757862189],
["1v37",1.4,1.47520793283354],
["2b6d",1.4,2.71882854100638],
["1qnr",1.4,1.35038137438608],
["1fp2",1.4,2.01283444125494],
["1s0p",1.4,2.84695212947155],
["1q2q",1.4,1.58341102423548],
["1h91",1.4,2.28418768924702],
["1uww",1.4,1.47008402538034],
["1oki",1.4,1.71489283717295],
["1h61",1.4,2.31082958865869],
["2g84",1.4,1.53745303994328],
["1ga4",1.4,1.23116707129270],
["1kdz",1.4,1.72876953238106],
["1ga1",1.4,1.42516424294612],
["2a83",1.4,1.42457709121036],
["1u7g",1.4,2.487985455809],
["1m55",1.4,1.19446992387936],
["1r6x",1.4,2.03012044085681],
["1f8d",1.4,2.3022801164908],
["1d1z",1.4,1.86702037581046],
["1ql3",1.4,1.536020909291],
["1t5b",1.4,1.85318611669331],
["2bu3",1.4,2.03350143369345],
["2c78",1.4,1.43051507123612],
["1yuz",1.4,1.62520568795909],
["1f24",1.4,1.49946151535407],
["1f25",1.4,1.43441058927946],
["1f26",1.4,1.37409986639612],
["1oi6",1.4,1.38901467431279],
["1yrc",1.4,1.78872234212848],
["1g57",1.4,2.10800582107414],
["1t5k",1.4,1.55365048672119],
["1p1v",1.4,1.99915908267696],
["1ra5",1.4,2.35002297051007],
["1ks8",1.4,1.87064560343138],
["1ruk",1.4,2.06072404740599],
["1rup",1.4,2.03818276317362],
["2tnf",1.4,2.3229298240528],
["2bnu",1.4,2.65041253913919],
["1g67",1.4,1.89047531953863],
["1pwb",1.4,1.92995780020235],
["1l6r",1.4,1.56531539322146],
["1g6c",1.4,1.72624769984232],
["1kv7",1.4,2.22005735551145],
["1k0m",1.4,1.97676624162672],
["1tzp",1.4,1.53254338979571],
["1uay",1.4,1.61046837654651],
["1f0i",1.4,1.87530828272906],
["1ktn",1.4,1.81157093423404],
["1b16",1.4,1.61599414276937],
["1o98",1.4,1.57172327406281],
["2olb",1.4,2.28272916665567],
["1rkq",1.4,1.49003394729571],
["1q7l",1.4,1.21195308234761],
["1wb4",1.4,1.50093615081287],
["1gkl",1.4,1.54880297283413],
["1wb5",1.4,1.55505055688554],
["1iw0",1.4,1.71234606901389],
["1jub",1.4,2.12516289032451],
["1g5a",1.4,1.60560497708239],
["1w5q",1.4,1.61275435400991],
["1xyz",1.4,1.53562330844195],
["1o7n",1.4,2.13902154441397],
["1y2b",1.4,1.12099342581889],
["1k3i",1.4,1.74530565622648],
["1qop",1.4,1.68582666822095],
["1z44",1.4,1.63787076415541],
["1c1x",1.4,2.06543963239295],
["1qfm",1.4,1.3932143873193],
["1o6g",1.4,1.64457063501007],
["1odz",1.4,1.23949296683779],
["1o1h",1.4,1.78203293135473],
["1wuj",1.4,1.89044025405434],
["1ubm",1.4,2.32981125648684],
["1h2r",1.4,3.06365370062506],
["1f8n",1.4,1.63232440401708],
["1rmt",1.4,1.72454156333294],
["1ub3",1.4,1.80915847563076],
["1yge",1.4,1.99678277208949],
["1zgo",1.4,2.23929221602160],
["1y9z",1.4,1.93005865413160],
["1z5r",1.4,2.00249622495738],
["2dcy",1.4,1.68135503853889],
["1n13",1.4,1.57016918712357],
["1wbi",1.4,1.25350134156080],
["1m22",1.4,1.78028348702320],
["1sjm",1.4,1.34550771376486],
["1hty",1.4,1.97946020271439],
["1uzb",1.4,1.89639089136846],
["2bhq",1.4,1.62906606740261],
["2bjk",1.4,1.59994553731169],
["1llf",1.4,1.69060241096562],
["1gq1",1.4,1.52157595320391],
["1gk8",1.4,2.01602651025915],
["2f9s",1.4,1.35869286141469],
["1vju",1.4,1.99235381204794],
["1mb3",1.41,2.05555615399760],
["2bwq",1.41,2.06074273647319],
["2rtl",1.41,2.52055636889801],
["1xph",1.41,1.27056175249073],
["1o35",1.41,1.43949085709312],
["1o2u",1.41,1.61792027928482],
["2f46",1.41,1.15247360851151],
["1bxq",1.41,1.23454525984338],
["1tc1",1.41,2.07759201789995],
["1x9d",1.41,0.888356821163171],
["1xsz",1.41,1.53595312378535],
["1gkf",1.41,1.63118293035811],
["1qh4",1.41,2.18399824302094],
["1qlq",1.42,1.75537663948625],
["1tgr",1.42,1.5863751656851],
["2d02",1.42,2.05130854165332],
["1cxu",1.42,2.40207410077183],
["2aoh",1.42,2.16378232862146],
["1gi1",1.42,1.56054977839655],
["1gi0",1.42,1.71249109423966],
["2a6y",1.42,2.04117095501443],
["1k3w",1.42,1.94000420649122],
["2f22",1.42,1.28088745959626],
["1yii",1.42,1.98588774804487],
["1pkh",1.42,2.23603874598437],
["1nof",1.42,1.42694857181490],
["1v0u",1.42,1.77881671971172],
["1mxr",1.42,1.80176751453694],
["1pp0",1.42,2.24788411082517],
["1o04",1.42,1.35127181927366],
["1pz7",1.42,2.88629576737417],
["1smu",1.43,2.13828184332519],
["3msi",1.43,2.39758413056504],
["1v05",1.43,1.77608293713114],
["1b0b",1.43,1.42316530708231],
["1m0m",1.43,2.71784996348161],
["1o3k",1.43,1.46244443254587],
["1c5q",1.43,1.66551683856584],
["1c5p",1.43,1.92272461981611],
["3eug",1.43,2.01458364634842],
["2a49",1.43,1.3932143873193],
["1z89",1.43,1.84192167999394],
["1ur1",1.43,1.89950154291755],
["1rk6",1.43,1.81902256463585],
["1m7g",1.43,1.55252674559734],
["1g33",1.44,1.45771621863619],
["1k96",1.44,1.53758282688156],
["1j9e",1.44,1.42697090418121],
["2esq",1.44,1.97121121952506],
["1qx2",1.44,1.91992786308668],
["1zie",1.44,2.10005106319221],
["1kys",1.44,1.63040754916848],
["1gi3",1.44,1.80366757899508],
["1zdy",1.44,1.79305951279384],
["1r66",1.44,1.96780723608714],
["1rd9",1.44,1.77035438802846],
["1kb0",1.44,1.96569579654775],
["1gvd",1.45,1.48842924281568],
["1df4",1.45,2.21495037241498],
["1c8c",1.45,3.11523948160593],
["1yu8",1.45,1.71283444107630],
["1xyi",1.45,2.31004274687345],
["1os6",1.45,1.95075907115466],
["1i71",1.45,2.1943905972832],
["1aba",1.45,1.7427240842758],
["1nnx",1.45,1.91828915334538],
["1lri",1.45,1.79923018001534],
["4vub",1.45,1.85612672454009],
["1uku",1.45,1.42801205818901],
["1xaw",1.45,2.07381600940448],
["1n1x",1.45,1.94698426801474],
["1wlu",1.45,1.50148463466908],
["1xbi",1.45,2.07124168325650],
["1nko",1.45,2.65989328619833],
["1pko",1.45,1.79175761787813],
["1ymn",1.45,2.38158129773514],
["3rn3",1.45,2.77381971746578],
["1bgf",1.45,2.0331807130405],
["1z67",1.45,1.61481232875684],
["1pa7",1.45,1.24173568907608],
["1x2i",1.45,1.63996324670363],
["1is3",1.45,2.14168789032948],
["1eu5",1.45,1.89159391709174],
["2end",1.45,2.09488437319977],
["1w1g",1.45,2.31180258300099],
["1j3f",1.45,1.42423954958370],
["1dws",1.45,1.37616109569447],
["1dwr",1.45,1.39737307683254],
["1hzt",1.45,1.75370960649694],
["1v9q",1.45,1.46733953667969],
["1tmj",1.45,2.78121673587341],
["1uuy",1.45,1.87756325740464],
["2f3y",1.45,1.52165827856088],
["1lw9",1.45,2.04651858225932],
["1io0",1.45,1.98402268557557],
["1zgt",1.45,2.04709206131487],
["1t68",1.45,2.33277643391953],
["1di6",1.45,1.52925810008883],
["1u0x",1.45,1.41164787934679],
["1wl8",1.45,1.73794281556535],
["2b0a",1.45,1.66846143394418],
["2f80",1.45,1.95866070808498],
["1ybk",1.45,1.723049433527],
["1kuk",1.45,2.13219227606452],
["2dct",1.45,1.89841981300327],
["2erf",1.45,1.89241311126787],
["1wei",1.45,1.75238136093438],
["1c1k",1.45,2.22093551169505],
["1hlq",1.45,1.84576137719443],
["1fm0",1.45,1.17131244407209],
["1s6h",1.45,1.15251485789371],
["1o2r",1.45,1.25530059853486],
["1o37",1.45,1.75988723155216],
["1o2y",1.45,1.49372711943366],
["1q4a",1.45,1.82562935744153],
["1dlf",1.45,1.84484059763601],
["2f5t",1.45,1.87480662526709],
["1ji7",1.45,1.99611711155254],
["1sq2",1.45,1.59981949134777],
["1t8z",1.45,2.25532624501169],
["1thf",1.45,2.02460979977399],
["1vwk",1.45,2.79730447007849],
["1vwj",1.45,2.7001695017021],
["1vwl",1.45,2.65924123857588],
["1hf4",1.45,2.13302524679472],
["1pzp",1.45,2.10070363428185],
["1n7s",1.45,1.77367630271741],
["1qqf",1.45,2.13016580524515],
["1pb8",1.45,2.12214497574817],
["1si6",1.45,2.09289562104389],
["2d5x",1.45,1.68344758220163],
["1kw6",1.45,1.94539191883267],
["1kw3",1.45,2.06026088944101],
["2as6",1.45,1.11470047613342],
["2as2",1.45,1.10381999032223],
["2euu",1.45,1.45639214537279],
["2euo",1.45,1.48801040067668],
["2glz",1.45,1.08376893265742],
["1q0r",1.45,1.74336999639673],
["1ve1",1.45,1.94360467453238],
["1pa2",1.45,1.68947956679111],
["2cyg",1.45,1.53552019165385],
["1xlq",1.45,1.54276264239374],
["1e6u",1.45,2.01633408728202],
["1si1",1.45,1.43722658548690],
["1lzk",1.45,2.39832002033636],
["1blz",1.45,1.24347589429758],
["2fgq",1.45,2.30510064055241],
["1jbo",1.45,2.04870034285789],
["1tm5",1.45,1.47610798195458],
["1wua",1.45,1.5303905374289],
["1rcq",1.45,1.66502094520399],
["1r50",1.45,1.84390954921753],
["1qz5",1.45,1.68048977534321],
["1rl9",1.45,2.25632923717114],
["1yyd",1.45,1.70762664552710],
["1hz4",1.45,1.57864688316845],
["1lm4",1.45,1.75099040754504],
["1wu6",1.45,1.67755443848402],
["1x7q",1.45,1.96675988454588],
["2ado",1.45,1.58838915638802],
["1re9",1.45,1.97119720093386],
["1z72",1.45,1.40944968303279],
["1x1z",1.45,1.48583908269848],
["1idp",1.45,1.92208112477684],
["1q9r",1.45,2.13483112579547],
["2a53",1.45,2.07649351312892],
["2a54",1.45,2.28245203832335],
["1v4p",1.45,1.45622291416211],
["1wvq",1.45,1.80282020635108],
["1md2",1.45,1.84576125750746],
["1qh5",1.45,1.57331253419902],
["2d1t",1.45,1.55359639229021],
["1w5r",1.45,2.00326475113750],
["2d5z",1.45,1.37731037094025],
["1w1h",1.45,1.60040367196808],
["1ikp",1.45,1.86774515937340],
["1tzc",1.45,1.45571921970151],
["1xd3",1.45,1.6768961758347],
["1n82",1.45,1.73641225595978],
["1zkk",1.45,1.45858637554203],
["1w2p",1.45,1.82113069650406],
["2c0c",1.45,1.57373834196483],
["1urs",1.45,1.84301924218808],
["1u3w",1.45,1.87560264763971],
["1rwf",1.45,1.34998648952861],
["1gm7",1.45,1.66745142818426],
["1i88",1.45,1.54678280867328],
["2cvd",1.45,1.62118871577096],
["2bry",1.45,1.76726147949601],
["1goi",1.45,1.77576534940202],
["1j40",1.45,1.93686651469440],
["1j41",1.45,1.93316415391968],
["2a8y",1.45,2.15354517977755],
["1sqn",1.45,1.94000292196781],
["1vmg",1.46,1.46070445505607],
["2fb6",1.46,1.48754655544172],
["2iza",1.46,2.16495112166605],
["1vwg",1.46,2.78961145749978],
["2fbb",1.46,1.76098240684088],
["1w70",1.46,1.17083253218724],
["1kt5",1.46,2.4243994962266],
["1g3p",1.46,1.96973252355261],
["1gv9",1.46,2.01339927328158],
["1o33",1.46,1.41314979858164],
["1o2x",1.46,1.36414431826812],
["1tke",1.46,1.93632939390982],
["2fbr",1.46,1.78275678950233],
["1fx2",1.46,2.56091295712795],
["1v0h",1.46,1.38617334449621],
["1o82",1.46,1.52170552050053],
["1hnj",1.46,1.73902900435521],
["1w3x",1.46,1.55291823985697],
["1mzy",1.46,1.84276642015811],
["1r8s",1.46,1.65181398405524],
["1lc5",1.46,1.67023275666162],
["1c0k",1.46,1.93480649899025],
["1vmf",1.46,1.25131990662402],
["1sr7",1.46,2.26207425840994],
["1llr",1.46,1.96464187348855],
["1pzj",1.46,1.84467086592345],
["1gx4",1.46,1.72234517189828],
["1jig",1.46,3.15673727944649],
["2bff",1.46,1.7503149418124],
["1m5e",1.46,1.80878695698558],
["1mqd",1.46,1.84104074506653],
["1hj5",1.46,1.83205274903103],
["1kt4",1.46,2.7940969101227],
["1t6f",1.47,1.01975821333025],
["1seh",1.47,1.67996061688171],
["4gcr",1.47,2.28833881353838],
["1oqq",1.47,2.32574299710978],
["1m0l",1.47,2.56336034722292],
["1smo",1.47,1.74673346623574],
["1o2p",1.47,1.55956581261732],
["1c2i",1.47,1.82916993686883],
["1c5r",1.47,2.14096160255742],
["1fcx",1.47,1.41690603960168],
["2rtf",1.47,1.84870599385039],
["1uyx",1.47,1.75796087055738],
["1uyy",1.47,1.93484841427523],
["1c5l",1.47,2.34843448624209],
["7atj",1.47,1.70052944854033],
["1qbz",1.47,2.03737329297714],
["1rku",1.47,1.77172044848855],
["1n92",1.47,1.50354930537759],
["1pl4",1.47,1.7679690227706],
["1ju2",1.47,1.48001446705533],
["1yxl",1.48,2.16107471813282],
["2gcu",1.48,1.35230352881279],
["1g6u",1.48,1.76600784339323],
["1upq",1.48,2.28814584733864],
["1vm9",1.48,1.46037542811015],
["2fup",1.48,1.41415303309673],
["1vwh",1.48,2.70970516002659],
["1iwz",1.48,1.69300115562089],
["1b67",1.48,2.52246501936511],
["1ru2",1.48,2.19228217194702],
["2rn2",1.48,2.40917361194187],
["1ek0",1.48,2.4570683508426],
["1uca",1.48,1.56621950301605],
["1zd8",1.48,1.43794085634561],
["1c5v",1.48,2.18078003750224],
["1tky",1.48,1.89402851310146],
["1q4b",1.48,1.76172403856899],
["3seb",1.48,2.48282844737471],
["2izl",1.48,1.8946864638537],
["1vyo",1.48,1.59883427547532],
["1o4y",1.48,1.31631852071597],
["1wpu",1.48,1.99508928420497],
["1dzk",1.48,2.43496183941939],
["1kjv",1.48,1.80251972534981],
["1xh3",1.48,1.66015867145902],
["2bcm",1.48,1.49565209265057],
["1l7m",1.48,1.73193603438258],
["1rum",1.48,1.96898845190807],
["2bcg",1.48,1.58595227549839],
["1gqi",1.48,1.85812419053840],
["1s8n",1.48,2.17517745487149],
["1u06",1.49,1.12395340845155],
["1qkd",1.49,2.77761774651278],
["1vyk",1.49,1.59879183518964],
["1z1s",1.49,1.85722156942459],
["1xnb",1.49,1.79613781256541],
["1my7",1.49,2.52081980015805],
["1gi6",1.49,1.57011975380846],
["1uu4",1.49,1.30650507824861],
["1z0n",1.49,1.56629722029006],
["1ziz",1.49,1.96701922043249],
["2afy",1.49,1.1021716210976],
["1xso",1.49,1.72597981208752],
["8abp",1.49,2.04120957569575],
["1so7",1.49,1.96399128064942],
["1uzm",1.49,1.90352890934434],
["1q9q",1.49,2.46670106964204],
["1h2x",1.49,1.41452423744338],
["1pi5",1.49,1.79097779516431],
["1zni",1.5,2.30977119100115],
["1z21",1.5,1.37738463348181],
["1q9b",1.5,2.50339786390175],
["1crn",1.5,0.560238208041396],
["1yzm",1.5,0.876256448091225],
["6rxn",1.5,1.22578272278610],
["1czq",1.5,1.70390656864329],
["2c8r",1.5,1.05354587553636],
["1iu5",1.5,1.36458680161419],
["7rxn",1.5,1.49495346223472],
["1r0i",1.5,0.749128467091287],
["1fhh",1.5,2.46554815108236],
["1fhm",1.5,2.74214562328904],
["1b13",1.5,1.44993025229484],
["2ovo",1.5,2.01025428259828],
["4pti",1.5,1.79618908540810],
["1qke",1.5,2.53526886431974],
["1uoy",1.5,1.58480841217576],
["1yu7",1.5,1.08376893265742],
["1cka",1.5,1.70981366120493],
["1wto",1.5,2.25043473148254],
["1ff4",1.5,2.41489632537544],
["1t7a",1.5,2.47699368370277],
["1sna",1.5,2.11612113872254],
["1uti",1.5,2.29599775129418],
["1lr7",1.5,1.25494944654101],
["1wfb",1.5,1.29951666378088],
["1jek",1.5,1.63761593570596],
["1dp7",1.5,1.59237354166403],
["1edm",1.5,2.83725109996049],
["1uha",1.5,1.83229855171174],
["1eyt",1.5,2.41304159207715],
["1cyo",1.5,1.88650676662214],
["1ehd",1.5,1.90726455265316],
["1yd0",1.5,1.11400570230641],
["1g9o",1.5,1.78966141255443],
["6rlx",1.5,2.20990807619499],
["1n7e",1.5,1.90634747753116],
["1irq",1.5,2.29746503597214],
["4ins",1.5,2.05151684542592],
["3ins",1.5,2.13249209526141],
["1zeh",1.5,2.18706379200782],
["1urr",1.5,2.18380391906629],
["2plt",1.5,1.33043559461560],
["1ln4",1.5,2.21129194823932],
["3ezm",1.5,1.33223340495362],
["1td4",1.5,2.08986816883532],
["1qw2",1.5,1.68108796510788],
["5cyt",1.5,1.87787007286747],
["9rnt",1.5,1.42279032386873],
["2b4z",1.5,1.78475891170509],
["1o4r",1.5,2.11449420493155],
["1zmh",1.5,2.28334422483168],
["1o43",1.5,2.02342126803757],
["1o4a",1.5,2.471248031219],
["1sha",1.5,2.7020398862845],
["1wpa",1.5,1.96293894666794],
["4cpv",1.5,2.89051056645869],
["1kr7",1.5,1.39373645047941],
["1aap",1.5,2.16087871829141],
["1y9l",1.5,1.60724317020001],
["1kpf",1.5,2.03924120254921],
["1vyi",1.5,1.62914672334757],
["2mcm",1.5,1.46788694940810],
["1ccr",1.5,2.37067740200564],
["1noa",1.5,1.12296903239747],
["1t2j",1.5,2.30327642314492],
["1vc3",1.5,1.82173970337561],
["1e87",1.5,2.07268260573973],
["2bwk",1.5,1.52926121722068],
["1f7l",1.5,1.84244106314332],
["1poa",1.5,2.49385243731468],
["2b1f",1.5,1.89619585573923],
["2cyj",1.5,2.46300913657384],
["1sz8",1.5,1.97797215298141],
["1ux7",1.5,1.66398546759364],
["1l7l",1.5,0.796795141363517],
["1isu",1.5,2.10079186356436],
["1qto",1.5,2.23123853407347],
["1whi",1.5,1.95297604642708],
["2bni",1.5,1.78474323617262],
["1kmz",1.5,2.32885095031118],
["1pmy",1.5,2.37143283350467],
["1une",1.5,1.68384997795967],
["1rnd",1.5,1.88914953203437],
["1rnc",1.5,2.06833564477924],
["1ymr",1.5,2.97976061454186],
["1rhb",1.5,2.44573374533505],
["1izr",1.5,2.72542156157122],
["1ymw",1.5,3.02291248752284],
["2rat",1.5,1.6237039772836],
["3rat",1.5,1.93646518324454],
["4rat",1.5,1.77328429871254],
["6rat",1.5,1.86764442148437],
["8rat",1.5,2.09635721893686],
["5rat",1.5,2.21745621070731],
["1rat",1.5,1.97847752259260],
["7rat",1.5,2.26685732027904],
["9rat",1.5,2.49184299986796],
["1izp",1.5,2.60159582816215],
["1agi",1.5,2.38564366002544],
["1n0r",1.5,2.46523101336232],
["1tp6",1.5,1.70286544887419],
["1rie",1.5,1.29886518323491],
["1fgy",1.5,2.11474772173476],
["1vwr",1.5,2.73071301814918],
["1kll",1.5,2.32119260536943],
["1jzf",1.5,2.15256934907887],
["2c8o",1.5,1.83454104213145],
["1aki",1.5,1.99367875112413],
["1vau",1.5,1.65510195288185],
["1lzb",1.5,1.47214037380483],
["1vdq",1.5,1.51425387534426],
["2c8p",1.5,1.76049147659861],
["1lzr",1.5,1.37598125731938],
["1rex",1.5,1.89574365978199],
["1lz1",1.5,2.28872994790290],
["1sj1",1.5,2.54004506335836],
["1wvh",1.5,2.90135405760086],
["1lmi",1.5,2.54167585148031],
["1rxi",1.5,2.23432820222592],
["1g7n",1.5,1.58072391885418],
["1icm",1.5,2.24042996299410],
["1zbf",1.5,1.48158262975580],
["1zhv",1.5,1.92216798786459],
["1c1l",1.5,1.28908736659927],
["1h05",1.5,1.81499285032244],
["2g1u",1.5,1.26846621526389],
["2czs",1.5,2.60443814720445],
["1gz2",1.5,2.39830495461826],
["1lo7",1.5,2.55800066261161],
["2sns",1.5,4.89199339650865],
["1flp",1.5,2.06064015994567],
["1o7u",1.5,1.72703131882041],
["1o85",1.5,1.71126801920888],
["1ggz",1.5,2.26451936337564],
["1w1d",1.5,1.68759698208094],
["2hbg",1.5,2.36109262142681],
["1hbg",1.5,2.34946156111197],
["2g2c",1.5,1.23129584227082],
["1q1f",1.5,2.42867192044536],
["1x91",1.5,1.6477247790582],
["2eso",1.5,1.79773109159490],
["1wcu",1.5,1.62147245683751],
["1x46",1.5,1.39373645047941],
["1oal",1.5,1.36903323841399],
["1do1",1.5,1.09863426903849],
["1bvc",1.5,1.67561357425321],
["1mbc",1.5,2.94631669276424],
["1od6",1.5,1.79750131987165],
["2mbw",1.5,2.48823261886591],
["1abs",1.5,2.49863622157979],
["1roc",1.5,1.79115477721419],
["1wrm",1.5,2.15205459995816],
["1g1t",1.5,2.05197553565844],
["1f9h",1.5,1.26424394144677],
["1hka",1.5,2.40572041320838],
["1eqm",1.5,2.5633109578223],
["1t9p",1.5,2.71771514960754],
["2bzu",1.5,1.69864627453877],
["1d7p",1.5,2.47378216926399],
["1ntv",1.5,1.709923347328],
["1hd2",1.5,1.41685695193779],
["2fr2",1.5,1.91801357215462],
["2cfe",1.5,1.10158320221077],
["1qcz",1.5,1.4354508699512],
["1wmh",1.5,1.80030467252748],
["1p7s",1.5,1.89594328310030],
["1fl0",1.5,2.48703627489811],
["1zw6",1.5,1.52894201724263],
["1z6n",1.5,1.72213648555306],
["821p",1.5,2.37081760318568],
["1nwa",1.5,1.29354289942315],
["1llm",1.5,1.89634534859869],
["1koe",1.5,1.95787051602230],
["1v3w",1.5,2.49843390350389],
["1w2i",1.5,1.13651834013806],
["1ej0",1.5,1.93928328420091],
["1pee",1.5,1.74746582460936],
["2sga",1.5,1.94660376183022],
["1shu",1.5,1.23421354192129],
["1bte",1.5,1.54644903417071],
["1ep0",1.5,1.86364833407872],
["1np4",1.5,2.29164968084307],
["1ike",1.5,2.57240801106204],
["1z3e",1.5,1.52339609694582],
["2bvv",1.5,1.94551907689373],
["2b5h",1.5,1.66479869148543],
["2gh2",1.5,1.62259232812197],
["1tua",1.5,1.62325361962831],
["1hpg",1.5,1.78054184377236],
["1x82",1.5,1.54399844733057],
["1v2x",1.5,3.04050411261681],
["2fom",1.5,1.39140819540394],
["2bfq",1.5,1.43164957278976],
["1ui0",1.5,1.18763477746665],
["2coh",1.5,1.75395491958112],
["1na5",1.5,2.16508600356106],
["1xl2",1.5,1.89841885371358],
["1tal",1.5,1.95008671788684],
["2ull",1.5,3.36731709233585],
["1ocy",1.5,1.45346255968930],
["1j77",1.5,1.88192522106582],
["1iqq",1.5,1.96389755223128],
["1lyq",1.5,2.97860880429016],
["1omr",1.5,3.07839359607696],
["1sqe",1.5,1.99512592877964],
["1nn5",1.5,1.69572956250344],
["1m2a",1.5,2.43327229981025],
["1kui",1.5,2.07001181404677],
["2eng",1.5,1.4303535305236],
["1lfm",1.5,2.03926113992427],
["1k7k",1.5,2.05859822375937],
["1he5",1.5,1.52658216122979],
["2c79",1.5,1.84846022802190],
["1k49",1.5,2.12714135093293],
["2bt6",1.5,1.10071614337630],
["1nf9",1.5,1.82722948042356],
["1jr8",1.5,1.66755148249334],
["1km6",1.5,1.57175276974374],
["1klz",1.5,1.69981552631599],
["1km2",1.5,1.45169369640664],
["1km3",1.5,1.35612612864388],
["1km4",1.5,1.43674702111264],
["1kly",1.5,1.79292792310666],
["1km5",1.5,1.18435279544232],
["1byq",1.5,2.69605278513044],
["1qwx",1.5,1.9451822806493],
["1p3c",1.5,1.18363898939879],
["1jg4",1.5,1.44248809552219],
["1jg2",1.5,1.62330329126991],
["1v8e",1.5,1.90325638149939],
["1kgs",1.5,1.6780870852699],
["1jbz",1.5,1.91942469802821],
["1yj2",1.5,1.50620176081775],
["1oa4",1.5,1.6798695102626],
["1utm",1.5,1.24870197823162],
["1kyr",1.5,1.67473551279353],
["1qyf",1.5,1.69118101065175],
["1bty",1.5,1.56030466438153],
["1o2n",1.5,1.41063803640694],
["1o2v",1.5,1.53851031802729],
["1gj6",1.5,1.71439582432769],
["1xug",1.5,1.80936811702472],
["1o34",1.5,1.76052124872625],
["1o2q",1.5,1.65900659214968],
["1c2l",1.5,2.27832389945941],
["1o2i",1.5,1.87769803638076],
["1tld",1.5,2.47064892722777],
["1xui",1.5,2.05408792729046],
["1i1n",1.5,1.90370949555037],
["1kg7",1.5,1.4845798922332],
["1kg6",1.5,1.65510966509510],
["1tje",1.5,2.18059314446291],
["1tkg",1.5,2.48215380764019],
["1eeq",1.5,1.86966688742438],
["1z1q",1.5,1.69548776573283],
["1s6z",1.5,2.14912248498921],
["2eug",1.5,2.21614903679334],
["2asb",1.5,2.84131947867482],
["1bio",1.5,2.15469868955911],
["1oaq",1.5,1.57327511695533],
["1dyq",1.5,2.32632969580514],
["1yhh",1.5,1.13890720434526],
["1x9q",1.5,1.95179104961277],
["1jyk",1.5,2.28827271194227],
["1ggd",1.5,1.88796388527582],
["1s67",1.5,2.48903700890863],
["1zi9",1.5,1.48171275864848],
["1z3x",1.5,1.13271184780584],
["1qg8",1.5,2.22600531193236],
["1qgq",1.5,2.35675683768193],
["1qb7",1.5,1.78055439571345],
["1xrk",1.5,1.62555351801349],
["1l1g",1.5,1.71122008455246],
["1l0z",1.5,1.87185793864404],
["2ax6",1.5,1.93976378343596],
["1h9h",1.5,2.04165688320866],
["2rte",1.5,1.67509103203122],
["2rtb",1.5,2.67916250613755],
["2rtp",1.5,2.60434952078518],
["2rtc",1.5,2.71828518997386],
["1y5h",1.5,1.43606364559423],
["2c07",1.5,1.30228560684663],
["2erb",1.5,1.78267929165511],
["1n28",1.5,2.67373346082057],
["1z6s",1.5,2.05665137575154],
["1o0n",1.5,2.39595586663042],
["1o0m",1.5,2.24347907495414],
["1o0f",1.5,2.53336493620297],
["1zvh",1.5,1.98549666865647],
["2bsy",1.5,1.8727363925225],
["1o9g",1.5,1.91946695934582],
["1lv7",1.5,2.09711152625722],
["1yp0",1.5,2.61185504634113],
["1f9z",1.5,2.01404839260875],
["2btc",1.5,2.06889251791521],
["1r5l",1.5,2.15782138148219],
["1nq7",1.5,2.08563845655342],
["1hn4",1.5,2.29034107939033],
["1gj7",1.5,2.78382428753437],
["1vwi",1.5,2.86730254289146],
["2b0p",1.5,1.54027682187570],
["1rxf",1.5,1.95859689410854],
["1hjg",1.5,1.63673234676123],
["1xfp",1.5,1.52698206112438],
["1gs5",1.5,2.15781553921048],
["1b0u",1.5,2.29449364821872],
["2ax2",1.5,2.27013061791692],
["1ja9",1.5,1.66866142666755],
["1qqq",1.5,2.04030949255207],
["1j1m",1.5,1.42925641048090],
["1iq6",1.5,1.60623329505727],
["1rxg",1.5,1.41995035337406],
["1c9n",1.5,1.62013912052311],
["1vl7",1.5,1.52987820602814],
["1wsd",1.5,1.64716714402860],
["1st9",1.5,1.89688965712542],
["1nzj",1.5,1.45996220458216],
["2bod",1.5,1.32298820722102],
["1brt",1.5,1.52975277244179],
["1uo9",1.5,1.91289208476319],
["1jks",1.5,2.16472853789141],
["2prk",1.5,2.63633581391371],
["2pkc",1.5,2.50179180717951],
["1y1z",1.5,2.06008415309314],
["1b8o",1.5,2.47508387144829],
["1oh3",1.5,1.72636697295796],
["1egw",1.5,1.49412997560715],
["1y2t",1.5,1.56010817826374],
["2bv9",1.5,1.71637885807739],
["1unb",1.5,2.24821327349025],
["2av0",1.5,1.55882456944694],
["1szh",1.5,1.90184374755914],
["1q1a",1.5,2.20749728744051],
["1uv4",1.5,1.97228099679109],
["1bn7",1.5,1.58943748278979],
["1bn6",1.5,1.86454395853645],
["1c5n",1.5,2.27337060607210],
["1lc3",1.5,1.91277911465745],
["1jdr",1.5,1.80960654276448],
["1szd",1.5,1.65591372069970],
["1oc8",1.5,1.86437058961836],
["1cqw",1.5,2.07666423640401],
["1o81",1.5,2.14418431531940],
["1f9t",1.5,2.41582048806698],
["1us5",1.5,1.76204981118204],
["1ezm",1.5,1.95920341299566],
["1sh8",1.5,1.64404015497943],
["1bqc",1.5,1.91442536833460],
["1nzi",1.5,2.03995435660326],
["1e30",1.5,2.03230903320531],
["1elk",1.5,1.93998469958918],
["1mla",1.5,1.89258111130666],
["2b3l",1.5,2.10504324208932],
["2ctb",1.5,1.85848077380261],
["1j8u",1.5,1.59045370494732],
["1e7s",1.5,1.80209218164333],
["2f62",1.5,1.17387235779847],
["2a94",1.5,1.57952299316142],
["1cip",1.5,1.62143652416251],
["1svs",1.5,1.49454191802315],
["1ys2",1.5,1.06836571689135],
["1a2p",1.5,1.42091780415638],
["1k6x",1.5,2.10138403773056],
["1u8z",1.5,1.83337874901904],
["1gxn",1.5,1.28898378244636],
["2web",1.5,1.50967354195412],
["2wed",1.5,1.43212659519677],
["2wec",1.5,1.58590197534550],
["2arc",1.5,2.04955380798881],
["1i0r",1.5,1.62061270338986],
["1hy7",1.5,2.04555938607717],
["1qiq",1.5,1.3525317467129],
["1hb4",1.5,1.25185116793868],
["1fo9",1.5,1.60365026855270],
["1o3y",1.5,1.69116425723148],
["2bay",1.5,1.62342663037427],
["2bqz",1.5,2.44363150740537],
["2fgr",1.5,2.28753793115892],
["1jx6",1.5,2.16096068451163],
["2b65",1.5,2.66462452227763],
["1wx4",1.5,1.93193161944715],
["1lw6",1.5,1.32957706328648],
["1bx4",1.5,1.76709065704776],
["1qnp",1.5,1.25691666935419],
["1qns",1.5,1.55817166346572],
["1gd0",1.5,1.53345447843169],
["1v5i",1.5,1.70615493990343],
["1a2y",1.5,1.83343553731529],
["1mtp",1.5,1.64606406179673],
["1fg7",1.5,2.01114529453841],
["1g2q",1.5,2.02402935544107],
["1k9z",1.5,2.12362444596581],
["1m4i",1.5,2.08999937026803],
["1i6w",1.5,1.75671523085537],
["1w3u",1.5,1.95688245687455],
["1pvm",1.5,2.30045631946303],
["1uas",1.5,1.95924750027688],
["1h50",1.5,2.38647239593311],
["1oc6",1.5,1.53021974577333],
["1kq3",1.5,1.42684971976605],
["2f8a",1.5,0.974792372154106],
["1rh9",1.5,1.28478621955664],
["2a8k",1.5,1.88545397158346],
["1iom",1.5,1.35790179041191],
["1kpu",1.5,1.45867291128124],
["1xyo",1.5,1.84644026061296],
["1xyp",1.5,1.97106756961777],
["1enx",1.5,2.0083438015611],
["1g7p",1.5,1.82555291099340],
["1zhl",1.5,1.61059005230757],
["1i86",1.5,1.64787220954151],
["1ql4",1.5,1.64176780119316],
["2avv",1.5,2.33518524030459],
["1h32",1.5,2.51024879723162],
["1gut",1.5,1.73064079380827],
["1s1f",1.5,2.26455788473255],
["1gej",1.5,1.9752546747789],
["1yv1",1.5,1.68402309430121],
["1ofn",1.5,1.5741468761494],
["1ht6",1.5,1.61143426505847],
["1h14",1.5,1.39351541570334],
["2cz0",1.5,1.87332691649223],
["1p1m",1.5,2.03651623345793],
["2cz6",1.5,1.44168230827088],
["2fe6",1.5,2.1031337382578],
["2a35",1.5,1.83501332034386],
["1uuq",1.5,1.51333379072623],
["1iyb",1.5,1.69924303369127],
["1tu7",1.5,1.80143565686993],
["1j97",1.5,1.6198703946476],
["1n45",1.5,2.24752981967603],
["1g6s",1.5,1.55240479399027],
["1x8r",1.5,1.46737736053349],
["1rur",1.5,2.39802421309362],
["2aju",1.5,2.24638028816067],
["2ajv",1.5,1.87960917334743],
["1wme",1.5,1.50402612178986],
["1ks2",1.5,2.04844968804235],
["1qwo",1.5,1.60806454417289],
["1fmk",1.5,2.85536524854765],
["1zhx",1.5,1.64034109143059],
["1dfm",1.5,2.3584556658838],
["1k3l",1.5,2.21739360124804],
["1oyg",1.5,1.16189269475263],
["1kgc",1.5,2.01038072743143],
["2src",1.5,3.10090989198017],
["2bp6",1.5,1.64636764007159],
["1g69",1.5,1.80332963364836],
["1fj2",1.5,2.16330473880842],
["1j05",1.5,2.40266248122203],
["1sg0",1.5,1.92459402339064],
["1xi2",1.5,2.38134498229405],
["1pf3",1.5,1.81201771015949],
["1sqs",1.5,2.04066549106531],
["1qe3",1.5,2.19804372615073],
["1k38",1.5,2.20178642453487],
["1m7j",1.5,1.42997585572478],
["1sx5",1.5,2.27603398197902],
["1yn9",1.5,1.2665974780106],
["1m6k",1.5,1.72383085764842],
["1b4v",1.5,1.65191277158859],
["1e73",1.5,1.74278812271393],
["1e71",1.5,1.75745486672999],
["1ekq",1.5,2.18909905989217],
["1c4o",1.5,2.00391768050483],
["1nkg",1.5,1.66587858316578],
["1fr7",1.5,2.13310275747922],
["1jd0",1.5,1.53234054925651],
["1m6j",1.5,1.57743078385536],
["1uza",1.5,1.68509481329167],
["1u8t",1.5,2.69825425710411],
["1dj0",1.5,2.09269190712504],
["1j3w",1.5,1.58139596706590],
["1vqs",1.5,1.12542099846651],
["1gmw",1.5,2.79947677622342],
["1uxa",1.5,2.06199519757089],
["1gmu",1.5,2.09236456687431],
["1dqz",1.5,2.09335110517670],
["1u0k",1.5,1.60823544246464],
["1ybi",1.5,1.51234069894302],
["1y0p",1.5,1.95935888462251],
["1bz0",1.5,2.15737694618356],
["1thb",1.5,2.88051742421819],
["1qz0",1.5,1.95385720557229],
["1bab",1.5,2.19201255431668],
["1a4i",1.5,1.69740949842133],
["2bhy",1.5,1.55540237693832],
["2by3",1.5,1.60785761010370],
["2by2",1.5,1.57599370660941],
["1ofw",1.5,1.75623399821108],
["1y37",1.5,1.55267864385908],
["1x9h",1.5,1.75678433583500],
["1jl0",1.5,1.45455222812111],
["1ijq",1.5,2.40836365616362],
["1k20",1.5,1.46987067841786],
["1ofz",1.5,1.67367933472244],
["1e19",1.5,1.78827996640626],
["1iw1",1.5,1.62285942186545],
["2bmr",1.5,1.69821752046567],
["1l7a",1.5,2.36488145650004],
["1ukv",1.5,1.43838119823997],
["1f1u",1.5,1.59696274838588],
["1kfc",1.5,1.52233316498364],
["1luc",1.5,1.97839144679061],
["1tjp",1.5,1.58625274639299],
["1l8n",1.5,1.91261712351059],
["1h6r",1.5,1.71203291263093],
["1krh",1.5,2.09217851775537],
["1hzj",1.5,2.15163216593297],
["1ek6",1.5,2.13932190859687],
["1i3n",1.5,2.13444142940942],
["1i3m",1.5,2.20782630366883],
["1i3k",1.5,2.17894255611848],
["1i3l",1.5,2.24171090039030],
["1oc2",1.5,1.99285547138266],
["1w3h",1.5,2.12948257194446],
["1bw9",1.5,2.13532791011715],
["1l0g",1.5,1.70908708653624],
["1e8m",1.5,1.91890565848698],
["1e8n",1.5,1.50773995212524],
["2c54",1.5,2.02746461726554],
["1n7o",1.5,2.678428953093],
["2aml",1.5,1.22859800623277],
["2fnu",1.5,1.63396334654619],
["1rwg",1.5,1.34573206459538],
["1v5d",1.5,1.64575723825704],
["1oad",1.5,1.54240403493507],
["1v6s",1.5,1.50095310134588],
["1fr3",1.5,1.24886776601590],
["1v5v",1.5,1.51300009239648],
["1wul",1.5,2.18240252162104],
["2bwr",1.5,1.18859752106979],
["1j2w",1.5,1.66015619334226],
["2al1",1.5,2.03079958445212],
["1m2x",1.5,1.94116074430737],
["1wrv",1.5,2.21890021810125],
["1dvj",1.5,1.4862742352387],
["1cru",1.5,2.02136644773496],
["1o6v",1.5,2.19948727800435],
["2c3n",1.5,1.56577780794340],
["1r2r",1.5,1.49738676636623],
["1hxk",1.5,2.00939755729457],
["1nyt",1.5,1.62662648750888],
["1kdg",1.5,1.22892916178790],
["1uiw",1.5,1.50756691722300],
["1inl",1.5,1.87628815727532],
["1oa2",1.5,1.76330988626473],
["1t61",1.5,2.23718697047557],
["1orr",1.5,2.43171226823289],
["2bkl",1.5,1.35156193006832],
["1h41",1.5,1.73017849212614],
["2cdc",1.5,1.97685726564204],
["1cs1",1.5,2.64930974199678],
["1qs1",1.5,2.07584957216938],
["1dgf",1.5,1.87249295366729],
["1n5w",1.5,1.68725636393971],
["1h5q",1.5,1.95285951834493],
["1jz7",1.5,2.40141589907262],
["1jz8",1.5,2.21371138473577],
["1t60",1.5,2.53906607747803],
["2a5j",1.5,1.32225245665014],
["1ah7",1.5,2.2979481717632],
["1xb3",1.5,1.79605903039371],
["1zkp",1.5,1.84139878538471],
["1mg4",1.5,2.11066382973488],
["2bkv",1.5,1.97828144350146],
["1pyl",1.51,1.50838382566923],
["1vjk",1.51,0.733357640417026],
["1t1d",1.51,2.35895758835406],
["1yv4",1.51,2.05703656531373],
["1t00",1.51,2.18134873344536],
["1x6q",1.51,1.27563331765651],
["1gwl",1.51,1.46752578503479],
["1n6h",1.51,1.75660919894068],
["1qhv",1.51,1.67086262902592],
["1o3i",1.51,1.67657579750766],
["1df8",1.51,1.97633085967256],
["2d1e",1.51,1.93808156722081],
["1y1n",1.51,2.2878014013403],
["1ypy",1.51,2.03822261095183],
["1o7e",1.51,1.75173616216122],
["1xc1",1.51,2.91698570953122],
["1whz",1.52,1.86548271256585],
["1hq1",1.52,2.86055428359977],
["1vmj",1.52,1.31439644005994],
["2esp",1.52,1.65236420481328],
["1pqm",1.52,1.98154545321932],
["2fsr",1.52,2.05091678721883],
["2a2k",1.52,1.90654323383782],
["1p8h",1.52,3.1429466367652],
["1w2u",1.52,1.55383024252967],
["1x1t",1.52,1.58136086324787],
["1ie8",1.52,2.06054940910506],
["1li9",1.52,1.35153837665747],
["1w7b",1.52,1.95503959134565],
["1c4q",1.52,1.50569392622551],
["1rgy",1.52,1.76047318323858],
["1h46",1.52,1.62266545628338],
["2a6v",1.52,2.00759951813697],
["1qq5",1.52,1.90649361685358],
["1iv3",1.52,2.28747143179920],
["1lz8",1.53,1.91401696880525],
["1wvp",1.53,1.78899438198477],
["1s6s",1.53,1.96193326013307],
["1utk",1.53,1.78624891867531],
["1o3h",1.53,1.60005997139578],
["1rv9",1.53,2.05601913416956],
["1qq9",1.53,1.20986853229413],
["1jvp",1.53,2.59443896548949],
["1gvj",1.53,1.96908571473798],
["2auo",1.53,1.38692007884509],
["1s73",1.53,1.72090062047422],
["1t6c",1.53,1.94474064176561],
["1yme",1.53,2.47208215975522],
["1xvx",1.53,1.44673121308704],
["2eu9",1.53,1.51026755235801],
["1usg",1.53,1.58098588095573],
["1xil",1.53,1.96974779583111],
["1n9y",1.53,2.23603617553711],
["1v0t",1.53,1.81031670932192],
["1ohp",1.53,2.25745392021475],
["1ijh",1.53,2.01149983523739],
["1k4v",1.53,1.84295499094627],
["1l0d",1.53,1.63964412578666],
["1kvl",1.53,1.77822203213651],
["1lxk",1.53,2.98025856624242],
["1vkp",1.53,2.16123513772466],
["1urd",1.53,1.80150443481449],
["1h16",1.53,2.04153153053621],
["1lk9",1.53,1.91179024065323],
["1xg5",1.53,1.37470625597865],
["1vhf",1.54,1.65832288276373],
["5pal",1.54,1.84878154164050],
["1dlw",1.54,1.51228375404187],
["1tp5",1.54,2.19584074817794],
["1zia",1.54,2.1311488142105],
["1wu9",1.54,0.963446123839352],
["1s3d",1.54,1.65907723232509],
["1sk2",1.54,2.01980790243832],
["1l2h",1.54,2.2411339928173],
["1p6y",1.54,1.99764263939543],
["1n6p",1.54,1.68672341719475],
["121p",1.54,2.22956172155879],
["2bz1",1.54,1.73228804310161],
["2aoe",1.54,1.99006641461073],
["2b9a",1.54,1.85698431916723],
["2aiq",1.54,2.40078599347618],
["1z9t",1.54,1.49571812313431],
["1z6d",1.54,1.84341802641409],
["1qve",1.54,1.56766058273977],
["1yb6",1.54,1.59382508866606],
["2cba",1.54,1.71700746842007],
["2b49",1.54,1.65553656636153],
["1dyp",1.54,1.60313453339889],
["2aii",1.54,1.25610208683319],
["1tk2",1.54,2.56479576479376],
["1jtv",1.54,1.54847485340856],
["1vzq",1.54,1.43483015265842],
["2bc3",1.54,2.95213633983330],
["5cpa",1.54,3.07998283459754],
["1gvg",1.54,1.83252728261695],
["1dpt",1.54,1.52656053853301],
["1j6z",1.54,1.77441289256809],
["2b2h",1.54,2.42860085928947],
["1e5m",1.54,1.73296573249322],
["1szn",1.54,1.64947836502943],
["2bw8",1.54,1.51259120318193],
["3grs",1.54,2.29803141157413],
["1dl2",1.54,2.12200316009847],
["1xor",1.54,1.05355378648085],
["1ee2",1.54,1.80584053090843],
["1qv9",1.54,2.16057350453030],
["1vhw",1.54,1.77139807389543],
["2f8i",1.54,2.05295588735164],
["2b5a",1.54,1.10792356381412],
["3ovo",1.55,2.48544302595057],
["2f60",1.55,1.33748232850902],
["1l2p",1.55,1.64951138794945],
["2cc9",1.55,1.96884288844843],
["1hta",1.55,2.00427169381376],
["1dsl",1.55,2.13871587717668],
["1jyr",1.55,2.29010710483133],
["1loy",1.55,1.71957578264079],
["1lov",1.55,1.65967664890799],
["1o4g",1.55,2.66584996547191],
["1o48",1.55,2.40654670014222],
["1x6y",1.55,1.66075684115655],
["1paz",1.55,2.22635878845494],
["2bh4",1.55,1.70894129296729],
["2ft8",1.55,1.34398233955609],
["1moy",1.55,1.86052062556232],
["1a62",1.55,2.30594196130845],
["1lzy",1.55,2.19327662737442],
["1lit",1.55,2.47268246533338],
["1sl4",1.55,2.12474755264697],
["1sk1",1.55,1.92792522565479],
["1kjr",1.55,1.62661631553155],
["1qhq",1.55,1.83486476609899],
["1ej8",1.55,2.41764458531473],
["1w4s",1.55,1.51392938277418],
["1smb",1.55,1.27747330774937],
["2b0v",1.55,1.70822922590413],
["1nog",1.55,1.59003740642860],
["1jcv",1.55,1.28608714858358],
["1do3",1.55,1.20516546587147],
["1kbr",1.55,2.09762092282465],
["1sz7",1.55,2.05318540366799],
["1ra9",1.55,2.18570951620788],
["1xep",1.55,1.60096017868477],
["1p3n",1.55,1.93399214368109],
["2bv2",1.55,1.77858951663133],
["2c4w",1.55,2.87098685959115],
["1n6r",1.55,1.96707104852305],
["1n6k",1.55,1.74221073891511],
["1d2s",1.55,2.31462239039314],
["1na3",1.55,1.60348861869024],
["2f9l",1.55,2.38337722527519],
["1tgx",1.55,1.49250057435209],
["1p9h",1.55,1.55918232598309],
["1c5h",1.55,1.83501336936142],
["1pmj",1.55,1.59883195122923],
["1yna",1.55,1.95305632917799],
["1z0c",1.55,2.41351972428198],
["1k1u",1.55,2.18465945688718],
["1z0b",1.55,2.11035733434975],
["1ix2",1.55,2.07248103399272],
["1daz",1.55,2.09508549701792],
["1qrf",1.55,1.92578905245606],
["1nn3",1.55,1.64736805486791],
["1inj",1.55,1.80245105233884],
["1sfx",1.55,1.24470772525520],
["2a4o",1.55,1.64920749829704],
["1vl1",1.55,1.28629378562498],
["1c3w",1.55,2.57654839389493],
["1os8",1.55,1.57209074217436],
["1o30",1.55,1.59825711330887],
["1o3n",1.55,1.77184078417632],
["1o3m",1.55,1.79576684593190],
["1o3f",1.55,1.8100106542883],
["1o3g",1.55,1.8100106542883],
["2ptn",1.55,1.97296343391007],
["1o3o",1.55,2.02212150261481],
["1try",1.55,1.75355422176798],
["1kg3",1.55,1.87429076639559],
["1q4c",1.55,1.92727993858550],
["1x7s",1.55,1.26140564790974],
["2dlf",1.55,1.93801331122752],
["1tlu",1.55,1.88573885517523],
["1deo",1.55,1.6226635274089],
["1l8s",1.55,2.84484473539721],
["1zk2",1.55,1.42240713703218],
["1zk0",1.55,1.54896601127711],
["1es2",1.55,2.28216893024316],
["2b13",1.55,2.09998051754938],
["1r82",1.55,2.04862124491906],
["1xz6",1.55,2.25542289247473],
["1wt1",1.55,2.25494665268527],
["1zi5",1.55,1.99624106771770],
["1zg4",1.55,2.02860996810640],
["1f7z",1.55,1.70342598238851],
["2czl",1.55,1.54967641147900],
["1y1j",1.55,1.15152618169842],
["2a84",1.55,1.24441959327144],
["2aij",1.55,1.46510866386327],
["1egq",1.55,2.39883155944366],
["1qum",1.55,2.22035214119440],
["1tzt",1.55,2.31212037424306],
["1j34",1.55,2.02802391818378],
["1iwh",1.55,2.31951885645167],
["2evg",1.55,1.31530558957645],
["2as1",1.55,1.10484959772542],
["2eus",1.55,1.55026725756106],
["2ghs",1.55,1.25927400973762],
["2f71",1.55,1.87069313088863],
["1ute",1.55,2.59404307606471],
["2b3k",1.55,1.80768449373719],
["1w4w",1.55,1.52045182692402],
["1y7l",1.55,1.70483667419004],
["1u8y",1.55,1.80987853062540],
["1tca",1.55,1.27437213458513],
["1u11",1.55,1.74758947253319],
["1oz2",1.55,1.87237371626760],
["2fp1",1.55,1.43974462731671],
["1hb1",1.55,1.33733344740886],
["1ghe",1.55,2.17068548337378],
["1y34",1.55,1.41188125346388],
["1r5m",1.55,1.67604827296669],
["2b9h",1.55,1.70325581635052],
["1zkj",1.55,1.84703463393361],
["1uqz",1.55,1.51187578227233],
["1z8g",1.55,1.37229804250608],
["1xnk",1.55,1.90706992995367],
["1g58",1.55,2.21260888883350],
["1gw9",1.55,1.67504909322865],
["1ioo",1.55,1.79824606150128],
["1wl4",1.55,2.071235675002],
["1bs3",1.55,2.05671509309314],
["1avm",1.55,2.34945532530875],
["2cyz",1.55,1.53512112265041],
["1qmq",1.55,2.18031342693342],
["1gtv",1.55,1.74720972084842],
["2f8y",1.55,2.32196812707915],
["1x8v",1.55,1.90314315965201],
["1ozw",1.55,1.93004929894887],
["2aay",1.55,1.58425676641931],
["1ksc",1.55,1.94002280839121],
["2a6x",1.55,2.02581111582493],
["1snn",1.55,2.06198692350113],
["2ddd",1.55,1.85973198981856],
["2ddc",1.55,2.11461737548736],
["1g4t",1.55,1.80799341919374],
["1nth",1.55,1.72844274083536],
["1nc7",1.55,1.89380699471779],
["2f6u",1.55,1.95445678636115],
["1y07",1.55,2.04464758631599],
["1zr6",1.55,2.05607032136293],
["2bem",1.55,1.54154190407513],
["1m1p",1.55,1.92790415386056],
["2foy",1.55,1.8820235566517],
["1xoc",1.55,1.94767531265164],
["1y4w",1.55,1.58747143084213],
["1jcz",1.55,1.65931947159702],
["1edq",1.55,1.37725176736800],
["1oa1",1.55,1.23473040825672],
["1shh",1.55,2.34883038672725],
["1jke",1.55,2.23673984277167],
["2by1",1.55,1.63067072922038],
["2by0",1.55,1.56975408656631],
["1t1u",1.55,3.25980782128363],
["1to4",1.55,1.37013762931530],
["1w6g",1.55,1.45043366421777],
["2c2n",1.55,1.65540815934723],
["2bmq",1.55,1.60106141269277],
["1wbh",1.55,2.00789767536166],
["2c0a",1.55,2.05753395699981],
["1w5p",1.55,1.74135824118178],
["1yu6",1.55,1.73316149888473],
["1xom",1.55,1.28513787490727],
["1ugi",1.55,2.40634917266893],
["1wtj",1.55,1.77639193344294],
["1w2v",1.55,2.12045966268389],
["1mg7",1.55,1.65491320106403],
["1kq1",1.55,2.3390782384688],
["1n7n",1.55,2.33569459898184],
["1n7p",1.55,2.50288285518385],
["1elu",1.55,2.0269081632316],
["4ubp",1.55,1.85742170441146],
["2a1o",1.55,1.93061721295427],
["1d5n",1.55,2.31860075074198],
["1qqj",1.55,1.69566660715043],
["1yiz",1.55,3.56121447729987],
["1ejd",1.55,1.77983580358966],
["1u6k",1.55,2.14005148070598],
["1iv4",1.55,2.43423190411821],
["1iv2",1.55,2.5337139823461],
["1zds",1.55,1.660159709037],
["1f0l",1.55,1.95467321070961],
["1xu9",1.55,1.81523112838224],
["1j3y",1.55,1.92923966054493],
["1wmw",1.55,1.70284290580585],
["1evl",1.55,2.17881400894364],
["1mv8",1.55,1.98216516800431],
["1jyw",1.55,2.32061346181164],
["1onj",1.56,2.15186087444985],
["2bkf",1.56,1.58706301615934],
["1eyh",1.56,1.62930108414611],
["1rao",1.56,1.77358745101983],
["1u53",1.56,1.64454367226485],
["1vb6",1.56,1.99844358605586],
["1lo6",1.56,1.56098947594505],
["2rth",1.56,2.61438324978579],
["1gja",1.56,2.40752489519625],
["2euz",1.56,1.18123688598068],
["2evf",1.56,1.19774120003366],
["2bju",1.56,2.28571060192831],
["1w9e",1.56,1.86739892204383],
["1y1k",1.56,1.44212006001689],
["1sxr",1.56,1.75512342427415],
["1yu0",1.56,1.27184142588832],
["1bq6",1.56,2.07838213569510],
["1bi5",1.56,1.84051738491581],
["1oo2",1.56,2.64575366274825],
["1gkb",1.56,1.79941730579986],
["1vke",1.56,1.55293688172020],
["2afw",1.56,1.94362904808690],
["1egu",1.56,2.74948304690102],
["1gdv",1.57,3.45536459463372],
["1o4k",1.57,1.69184177682552],
["2ai4",1.57,2.06324913297309],
["2a0b",1.57,1.66013600134391],
["2d0n",1.57,2.52524788361310],
["1dk8",1.57,1.80630481799810],
["1p37",1.57,1.87579040746680],
["1pqi",1.57,2.63654965617906],
["2fx6",1.57,1.93815484599588],
["1akz",1.57,1.52744797657407],
["1m65",1.57,1.77442260054196],
["2f9h",1.57,2.48201026897465],
["2ize",1.57,2.58600994597147],
["1zi1",1.57,2.27932600045145],
["1xbb",1.57,1.62808835048124],
["1jov",1.57,2.3567338668345],
["2eux",1.57,1.37203656112282],
["1a3h",1.57,1.39495365961133],
["1hch",1.57,1.56816881375074],
["1via",1.57,1.73110892299375],
["1tm3",1.57,1.57145613356012],
["1moq",1.57,1.75295374635965],
["1r9y",1.57,1.53368767782385],
["1a8d",1.57,2.81384043836579],
["1zed",1.57,2.25271141798869],
["1lyc",1.57,2.38050765782592],
["2bme",1.57,2.08249611597917],
["1x7y",1.57,1.83582544099759],
["1r45",1.57,2.14487445716474],
["1zz1",1.57,2.04481524036962],
["1p1r",1.57,1.32965153425092],
["1gv5",1.58,1.29755922376388],
["1wn9",1.58,1.89087911599636],
["1wna",1.58,1.78425750507963],
["2d2y",1.58,1.10381999032223],
["1akr",1.58,2.24411599170478],
["1wwi",1.58,1.82345344415803],
["1p2r",1.58,2.03100056377204],
["1p2l",1.58,2.0661417629852],
["1awq",1.58,2.92488387675222],
["2fdd",1.58,1.66543680350608],
["1r55",1.58,1.77490442978456],
["1fma",1.58,1.94368834818542],
["1q4d",1.58,1.87505159472268],
["2bzg",1.58,1.83669992081437],
["2izf",1.58,1.96257236263942],
["2rto",1.58,2.65407958712606],
["1cp7",1.58,1.40024142154682],
["2fi4",1.58,1.50350524811421],
["2fi5",1.58,1.46070445505607],
["2fi3",1.58,1.35440920650854],
["1o2g",1.58,2.47141167136010],
["1iz7",1.58,2.34383364032138],
["1mkr",1.58,1.63779376625500],
["1vrm",1.58,1.37670448115907],
["2aex",1.58,1.9037150263512],
["1y5w",1.58,1.81427311208400],
["1y5v",1.58,2.01189256008341],
["1xs0",1.58,3.22378366569906],
["1wyc",1.58,1.30413027005814],
["1r9x",1.58,1.5246045147381],
["1xby",1.58,1.52366910555320],
["1skb",1.58,1.53902256569328],
["1xta",1.58,2.19648990966497],
["1ys7",1.58,2.30128192739639],
["1awr",1.58,3.23553287745370],
["1ms9",1.58,1.87220679605304],
["1sd8",1.59,1.39353309840975],
["1v7q",1.59,2.10265120980605],
["1nox",1.59,1.15886214676781],
["1w0h",1.59,1.24521838998529],
["1o39",1.59,1.83136038562675],
["1dpo",1.59,2.21703176971154],
["1exa",1.59,1.45532091710073],
["1zjp",1.59,2.04400387999251],
["2a8w",1.59,1.66746973098892],
["1wsz",1.59,2.34259453698034],
["1zhj",1.59,1.9280126010656],
["1vhn",1.59,1.2542260097421],
["1r9l",1.59,1.15155308392864],
["1mrq",1.59,1.47845094973459],
["1tm7",1.59,1.56283482131185],
["1ye3",1.59,1.75707104650430],
["1vio",1.59,1.69512034457173],
["1g6i",1.59,2.22808292685078],
["2cdp",1.59,1.83330894358733],
["1bzz",1.59,2.16071404035292],
["1bz1",1.59,2.16448021864545],
["1vht",1.59,1.79916758946966],
["1e2r",1.59,1.85965227393822],
["1uz9",1.6,1.91520612434112],
["1guu",1.6,2.03050230281608],
["1r0f",1.6,1.10001494247582],
["1r0g",1.6,1.10001494247582],
["1b2j",1.6,1.44993025229484],
["1knt",1.6,1.74613461713696],
["7pti",1.6,2.23778836259604],
["1ywp",1.6,1.39514264858437],
["1bf4",1.6,2.55883160502038],
["2ccn",1.6,2.18159025934967],
["1wtv",1.6,2.55954610605356],
["2jia",1.6,1.76351716963550],
["5msi",1.6,2.04158875628788],
["4msi",1.6,2.08103695627454],
["1azp",1.6,2.68290139870508],
["1qr9",1.6,2.985360919793],
["4icb",1.6,2.14200865180091],
["1vcc",1.6,2.44927639198712],
["1wm2",1.6,2.18197892624698],
["1u84",1.6,1.70721885830266],
["451c",1.6,2.52878450662783],
["351c",1.6,2.55980467581949],
["2d3d",1.6,0.93328709288676],
["1cm3",1.6,2.62753480695483],
["1a1i",1.6,1.58346764511443],
["1a1h",1.6,2.14405068954253],
["1ptf",1.6,1.55362102394918],
["1gvp",1.6,2.36262988662412],
["1yd3",1.6,0.710612278866998],
["1yd2",1.6,0.849014163991869],
["2ygs",1.6,1.66479943582727],
["1s29",1.6,1.49471512935257],
["1box",1.6,2.03616642318518],
["1trz",1.6,2.63705659260653],
["1zeg",1.6,1.60297615805569],
["1iuz",1.6,1.52798938897273],
["1pnc",1.6,1.36629807285837],
["1pnd",1.6,1.58958561674672],
["2b9d",1.6,3.00319055843819],
["3cao",1.6,2.07217490861756],
["1o4m",1.6,2.10672434049768],
["1o4n",1.6,2.73054757918595],
["1mfw",1.6,2.26110427885804],
["1x0t",1.6,2.07575400362457],
["1co6",1.6,2.55267090172236],
["1bkf",1.6,2.60473748031395],
["3cyr",1.6,1.57195839535836],
["1cdp",1.6,2.27395324200172],
["5cpv",1.6,2.45607999011156],
["1jer",1.6,3.19113203514532],
["1hxi",1.6,1.59506985098890],
["1aal",1.6,2.53693152785298],
["1efq",1.6,2.41464519012652],
["2rhe",1.6,2.88900698237049],
["2rns",1.6,1.84354794283337],
["1rnu",1.6,1.81186273437662],
["1rnv",1.6,1.99210212307472],
["1mav",1.6,2.13546431989609],
["4bp2",1.6,2.24228726817370],
["1zv1",1.6,1.84521819656283],
["1xte",1.6,2.37086956338156],
["2bez",1.6,1.70154206623123],
["1r5r",1.6,2.16232652020669],
["2awg",1.6,1.53140677776176],
["2b29",1.6,2.54569068400457],
["1mvo",1.6,1.54670136539847],
["1q7a",1.6,2.68683210564989],
["1kp4",1.6,2.01334242593571],
["1mg6",1.6,2.28210666622295],
["8paz",1.6,2.66025843271187],
["1m5t",1.6,1.5996023464138],
["1vkq",1.6,1.80709444995421],
["1cxc",1.6,2.64042192567949],
["1bqr",1.6,2.10717205700329],
["4fgf",1.6,2.47246607620951],
["1a5p",1.6,2.75650047618905],
["4rsd",1.6,2.31197404033949],
["1bel",1.6,2.27962548275017],
["3rsd",1.6,2.10569375451834],
["1rob",1.6,2.67489281289896],
["2asf",1.6,1.41856368636724],
["1s1z",1.6,2.19198770689124],
["1s1y",1.6,2.19281519491407],
["1ts0",1.6,2.0229887396638],
["1ts6",1.6,2.0229887396638],
["1t1a",1.6,2.55401670283286],
["1uxx",1.6,2.14362631878645],
["1t1b",1.6,2.80544297666727],
["1bfg",1.6,2.52210755675276],
["1vwm",1.6,2.84376130516231],
["1j3a",1.6,1.71045456630589],
["1jb3",1.6,2.87464519863880],
["1jze",1.6,2.95021945836169],
["1b8z",1.6,1.54400757765036],
["1cuo",1.6,1.50751517707139],
["1vat",1.6,1.58640279607998],
["1t3p",1.6,1.80254788590588],
["1lza",1.6,1.8842797885605],
["1vds",1.6,1.90734742186622],
["1yil",1.6,1.94402480798565],
["1lmq",1.6,2.43561873029804],
["3nul",1.6,1.23116707129270],
["1lid",1.6,1.49652290452906],
["1lif",1.6,1.66559009790992],
["1lie",1.6,1.78833748311822],
["1adl",1.6,1.69451178642336],
["1lic",1.6,1.88311908737388],
["1kuh",1.6,1.51929323683653],
["1eqt",1.6,2.44279939773782],
["1b3a",1.6,1.8514159763657],
["1o8v",1.6,1.48248416028729],
["1zzo",1.6,1.94484551973129],
["1wld",1.6,1.78384039954119],
["1r62",1.6,1.59591882318975],
["1c1f",1.6,1.78272990888042],
["1hi2",1.6,2.31998529832511],
["1lmt",1.6,2.41808650760824],
["1ey4",1.6,2.99969699003624],
["1ey0",1.6,2.86078414525568],
["1tvg",1.6,2.30274819947755],
["2b3g",1.6,1.73391970865013],
["5nul",1.6,1.82573500955616],
["1wqj",1.6,1.82843459313948],
["1x6o",1.6,1.38583747707700],
["1tzw",1.6,2.18689834000678],
["1ugx",1.6,1.01118522348699],
["1id0",1.6,2.75267762896691],
["1mba",1.6,2.19524105131249],
["2fl4",1.6,2.01130422453855],
["2c8s",1.6,2.5556139101954],
["2eve",1.6,1.37791878349091],
["1jxb",1.6,2.27325184123161],
["1nz3",1.6,2.55749440301035],
["1mbo",1.6,2.51344336808504],
["1mz0",1.6,1.44062284630109],
["1n9i",1.6,1.66131517224048],
["1n9x",1.6,1.40506279437438],
["1myz",1.6,1.59026408251352],
["1co9",1.6,2.11255783902314],
["1cio",1.6,2.29869782483297],
["1ufj",1.6,1.87430167177552],
["1fcs",1.6,2.97768344515894],
["1md6",1.6,1.89305406796919],
["1y4m",1.6,2.64255863251875],
["1ie0",1.6,1.7012353220181],
["1c09",1.6,1.45210753940750],
["2ilk",1.6,2.72348279191790],
["2ewr",1.6,1.17135862953214],
["1znd",1.6,2.63641115357099],
["1znk",1.6,2.67894620133244],
["1zng",1.6,2.70580308945867],
["1ra2",1.6,2.07967939004603],
["2f3z",1.6,1.87563848116301],
["1uux",1.6,1.71168202595643],
["1wc9",1.6,2.09508478666015],
["1jhj",1.6,1.87575264743813],
["1a3c",1.6,2.51533188476136],
["1vdn",1.6,2.21447367991053],
["1yb3",1.6,1.34150405164562],
["1qra",1.6,2.20242595587501],
["1g12",1.6,1.71413550594073],
["1h96",1.6,1.19861545277446],
["1n6i",1.6,1.67187967414645],
["1n6n",1.6,1.73832926713060],
["1n6l",1.6,1.69784013248411],
["1tyj",1.6,2.27383344098495],
["1g8q",1.6,2.65528950257657],
["1rfy",1.6,1.42297049061579],
["1y0u",1.6,1.14146444655127],
["1mr3",1.6,2.05320379312463],
["1yw5",1.6,1.77653458247659],
["1dj7",1.6,2.06386376946698],
["1ky2",1.6,2.34910407725616],
["1k4n",1.6,2.37328151161748],
["1di7",1.6,2.09407856872058],
["1eqd",1.6,2.75784855696197],
["1t1v",1.6,2.19439747885426],
["154l",1.6,2.25975153593500],
["153l",1.6,2.18714160974698],
["1hv0",1.6,1.90798637336413],
["1xnc",1.6,1.90705974162838],
["1sk7",1.6,2.33015755890175],
["1ps4",1.6,1.55826372683329],
["1q2u",1.6,1.55826372683329],
["2cve",1.6,1.86221408180509],
["1j1g",1.6,1.70149527113093],
["2ap3",1.6,1.28562173741326],
["2sfa",1.6,2.56445407357899],
["1j1f",1.6,1.68051647711875],
["1wt6",1.6,2.53310231587635],
["1fvg",1.6,2.22028756806022],
["1q91",1.6,1.8138617899776],
["1ru0",1.6,1.69156316019166],
["1rki",1.6,2.15171532177467],
["1cuj",1.6,2.10954877492446],
["1y0h",1.6,1.74420983167054],
["1qrx",1.6,1.87193050961436],
["1jxg",1.6,1.78606291708930],
["1ylx",1.6,1.70150504818116],
["2c0z",1.6,1.54937923188180],
["1umj",1.6,1.90728902518044],
["1fi2",1.6,1.79276817120544],
["2et1",1.6,1.84661533385934],
["1w3o",1.6,2.07589534795052],
["1iuj",1.6,2.75559228854507],
["1j2j",1.6,1.43350403075619],
["2aoj",1.6,2.3580898997544],
["1nf8",1.6,1.44190881571855],
["1gsi",1.6,1.67644592326456],
["1lor",1.6,1.64817081371208],
["1nmy",1.6,1.46381369910601],
["1nn0",1.6,2.32335393381607],
["1e9a",1.6,1.63624226891388],
["1e9c",1.6,2.25588312097266],
["1e2f",1.6,2.14650979801602],
["2gim",1.6,2.16541346804499],
["1e9e",1.6,1.66846624569051],
["1pew",1.6,2.87237755601],
["1ro2",1.6,2.97402589154613],
["1ft5",1.6,2.70885666475199],
["1ppn",1.6,2.67564161429896],
["1nln",1.6,2.21092862682463],
["1fr2",1.6,1.85715509100140],
["1rz2",1.6,2.39287342100013],
["1khq",1.6,1.69034752843881],
["2ayh",1.6,2.20369971292043],
["1t92",1.6,1.84322835897397],
["2brc",1.6,1.59352507931992],
["1f2a",1.6,1.62890537900696],
["2byi",1.6,1.81376416851831],
["1k4l",1.6,2.44730895760269],
["1fqt",1.6,1.64373196322927],
["1zin",1.6,2.01120329225392],
["1ii5",1.6,1.91938949779172],
["1x7t",1.6,1.49642474108066],
["1rc9",1.6,1.49623824757158],
["2evr",1.6,1.09760627022802],
["2f7i",1.6,1.65519887537325],
["1y3v",1.6,1.43608777996396],
["1y5u",1.6,1.78377320030775],
["1fni",1.6,2.51275224755879],
["1gi5",1.6,2.02092818336195],
["1v2l",1.6,1.84535786376966],
["1j16",1.6,1.53124072679301],
["1eeu",1.6,1.70655057902329],
["1dad",1.6,2.00062185740281],
["1dak",1.6,1.92013678804308],
["1kg4",1.6,1.46146521229519],
["1q73",1.6,1.80426159791225],
["1g4y",1.6,2.68158278538590],
["1eug",1.6,2.21891231871286],
["5eug",1.6,2.24455754056127],
["1ou8",1.6,1.64872535151237],
["1o1z",1.6,1.23065800209935],
["2cxa",1.6,1.82300842605287],
["2awj",1.6,1.98310012288875],
["1p5z",1.6,1.46365765576126],
["1yc7",1.6,1.99559443772581],
["1x8h",1.6,1.69242768951974],
["1nfp",1.6,2.13555604011295],
["1sok",1.6,1.48436177355596],
["1fbn",1.6,2.02258601455148],
["1g8s",1.6,2.06810614034652],
["1ct4",1.6,2.0567812729866],
["8gch",1.6,2.43090076629095],
["1na0",1.6,1.25050172748077],
["1gct",1.6,2.09057962314650],
["3gct",1.6,2.10225591141009],
["1ab9",1.6,1.60436688821063],
["1xdz",1.6,1.42829536615922],
["1nme",1.6,1.57862220752556],
["1scs",1.6,1.97938570027258],
["1ow4",1.6,2.1397453502758],
["1btu",1.6,1.94608693027882],
["2izd",1.6,2.89342268438151],
["1wli",1.6,1.91567589365061],
["1wll",1.6,1.72688324291883],
["1jif",1.6,1.94817090740520],
["1hax",1.6,1.35388820927365],
["1elw",1.6,1.45486920092709],
["1qr3",1.6,2.61537712509466],
["1wcv",1.6,2.51986958051247],
["1vap",1.6,2.97219072855576],
["1nu0",1.6,1.86931854506206],
["1xpc",1.6,2.84858149738678],
["1ftk",1.6,2.23412671285060],
["1dbw",1.6,2.29047351629489],
["2beq",1.6,2.11369624779696],
["1w4o",1.6,2.49471370536080],
["1gy6",1.6,2.41450597607878],
["1zo2",1.6,2.18752521402523],
["1mrk",1.6,2.30147573140229],
["1mrj",1.6,2.20928862365130],
["1qtp",1.6,1.59308230669328],
["1u0q",1.6,2.01057475720524],
["1lln",1.6,2.2690727660672],
["2g30",1.6,1.83533871467531],
["1mp8",1.6,2.18914686992881],
["1mct",1.6,2.08783659342412],
["2a7m",1.6,2.4166964863468],
["1qwg",1.6,1.69242624080537],
["1nwp",1.6,1.78843379300601],
["1b2l",1.6,1.74934589564602],
["1g6h",1.6,2.15634194743577],
["1b2k",1.6,2.51423458811036],
["1lkr",1.6,2.71511998441079],
["1cil",1.6,1.92518300292251],
["1t7f",1.6,1.31798856794597],
["1fr4",1.6,2.8912463461601],
["2bl8",1.6,1.70209383820431],
["1p1n",1.6,2.03344085632906],
["1lzs",1.6,2.19823270045313],
["1g0e",1.6,1.87970260697905],
["1hcb",1.6,2.01496977783968],
["1lk0",1.6,1.93536463811208],
["1vka",1.6,0.795101268462388],
["1qgi",1.6,2.12479859763443],
["1uof",1.6,2.27676262585844],
["2evc",1.6,2.29117989115616],
["1t7m",1.6,1.78909440759992],
["1uyz",1.6,1.57208220687315],
["1p1o",1.6,1.62325664403229],
["3pnp",1.6,1.85931256677109],
["1yvm",1.6,2.09340063854622],
["1nxy",1.6,1.72267933922423],
["1g6g",1.6,1.86168799550043],
["1m4j",1.6,2.21825558699253],
["1hjf",1.6,1.72109856343251],
["1kyh",1.6,1.80432049358557],
["1q5p",1.6,2.01030573442014],
["1ndu",1.6,1.94711745275237],
["1urw",1.6,2.08192328036549],
["1qpc",1.6,1.87282798890129],
["2dri",1.6,1.78838596939527],
["1iup",1.6,1.62379860838859],
["1uk8",1.6,1.70959038797999],
["1h00",1.6,2.16925131027429],
["1jy3",1.6,1.80488133638446],
["1sup",1.6,2.02422285802705],
["1iyn",1.6,2.15871788109966],
["2bvd",1.6,1.46264713144968],
["1q4u",1.6,2.37971748642698],
["1ukk",1.6,2.15144796699514],
["1i60",1.6,1.94422272176018],
["1pb9",1.6,2.08125741709119],
["1n57",1.6,2.31264312766276],
["1p2k",1.6,1.59562319817582],
["1p63",1.6,2.06602948736122],
["1q4t",1.6,2.29868435502869],
["1wmq",1.6,2.56827506447127],
["1cg5",1.6,1.93992421861674],
["1jat",1.6,2.15200202243892],
["1yj3",1.6,2.47066001579558],
["1aht",1.6,2.22762213165356],
["1p0h",1.6,2.24033477569278],
["1f2t",1.6,1.82937915733703],
["1lj9",1.6,1.93224544646374],
["1ns9",1.6,1.89954024480373],
["1i5r",1.6,2.01745932095671],
["1exq",1.6,2.89552661752379],
["5hbi",1.6,1.51861822279491],
["7hbi",1.6,1.63644730943283],
["4hbi",1.6,1.76924639142253],
["4sdh",1.6,2.07730735456938],
["1v2b",1.6,1.07393105697307],
["2c30",1.6,1.60173898766181],
["1x2j",1.6,2.17048893283315],
["1ndd",1.6,1.82145053936509],
["1it2",1.6,2.27929412760599],
["1h6t",1.6,2.15673438919159],
["1up3",1.6,1.37311599979827],
["3man",1.6,1.80821720613029],
["1t46",1.6,1.85315487091802],
["1in4",1.6,1.83631841167333],
["1ryl",1.6,2.18580967490528],
["1euv",1.6,1.97484119184586],
["1xsq",1.6,2.16787557253907],
["1uaq",1.6,1.88779047676268],
["2g62",1.6,1.49860745798819],
["2bnj",1.6,1.20607458265824],
["1pa1",1.6,1.63849362024308],
["1xtm",1.6,3.0557698503909],
["1sz3",1.6,2.87101310673313],
["2bz6",1.6,1.51685024240642],
["1dd9",1.6,2.00275914438270],
["1w4y",1.6,1.31044197531266],
["1h57",1.6,1.45570827403845],
["1h5h",1.6,1.46730627671934],
["1h5i",1.6,1.54213801497798],
["1h5k",1.6,1.57838105432256],
["1h5l",1.6,1.50475197916232],
["1h5j",1.6,1.41037871464896],
["1h5e",1.6,1.51671487857299],
["1h5d",1.6,1.52730603304453],
["1h5a",1.6,1.44322588435245],
["1h5f",1.6,1.64227278294095],
["1t9i",1.6,1.98774998105352],
["1n08",1.6,1.88293205257007],
["1mrp",1.6,2.51360443345037],
["1qwk",1.6,1.41686620828576],
["1fcq",1.6,2.42770747659393],
["1cvl",1.6,1.81301710118740],
["1e7q",1.6,2.2029841006017],
["1e7r",1.6,2.08492179658249],
["2f64",1.6,0.752603513988154],
["2f67",1.6,1.15319871266095],
["1su2",1.6,3.53437626309583],
["1kjp",1.6,1.42291217630526],
["1kkk",1.6,1.46565575065485],
["1kjo",1.6,1.47879506168189],
["2tmn",1.6,2.40470271345204],
["6tmn",1.6,2.49294402203213],
["1kei",1.6,1.63276273172557],
["5tmn",1.6,2.40091619809943],
["8tln",1.6,2.25960376044957],
["1hnd",1.6,2.50002435021437],
["1ry6",1.6,2.4064465794019],
["1wtf",1.6,1.82384129867208],
["1a54",1.6,1.86264972638317],
["1odn",1.6,1.16712141944536],
["1o6l",1.6,1.2219657094442],
["1wer",1.6,2.77422762371093],
["1btk",1.6,2.47122996924373],
["1ynd",1.6,1.86233092904532],
["830c",1.6,2.51121900173985],
["1q11",1.6,1.75498157864888],
["1nux",1.6,2.49914394687122],
["1a8e",1.6,1.98903147831244],
["1wlz",1.6,1.98065598636786],
["1vki",1.6,1.27884225572536],
["2bdr",1.6,1.8955580356046],
["1ktp",1.6,2.48846653385703],
["1epn",1.6,1.92638414857431],
["1y0y",1.6,1.84451293747014],
["1n70",1.6,1.69157808170014],
["2er7",1.6,1.97564842044259],
["1wa0",1.6,1.17917873242578],
["1epm",1.6,1.79892241335442],
["1y4a",1.6,1.95258613937569],
["1hsr",1.6,2.20700099378377],
["1aru",1.6,2.14781040493914],
["1arv",1.6,2.11295684705966],
["1arw",1.6,2.14710400003919],
["1c48",1.6,1.87844542124364],
["1mkz",1.6,1.69816782481084],
["1h7n",1.6,2.16195684849114],
["2ahl",1.6,2.31565574177231],
["1l5o",1.6,1.82714451118523],
["3pte",1.6,1.5735780869525],
["1jfu",1.6,1.88631237648029],
["1ur2",1.6,1.68794688535366],
["2c0h",1.6,0.933463904624877],
["1xkn",1.6,1.86273584257665],
["1b6a",1.6,1.27472045850639],
["1qzy",1.6,1.66033603268823],
["1z6f",1.6,1.73151281630574],
["1qgx",1.6,2.4039085463854],
["1m44",1.6,1.29361713584284],
["1s22",1.6,1.26640121477166],
["1xh8",1.6,1.74887772213645],
["1d3g",1.6,1.81062116637356],
["1yyg",1.6,1.94148623105472],
["1yzr",1.6,1.90782123226714],
["1yzp",1.6,1.86967331627118],
["2b5w",1.6,1.32310881463036],
["1qz6",1.6,1.21401029198833],
["2fhp",1.6,1.75808849844237],
["1wny",1.6,2.27728244069861],
["1s44",1.6,2.29633118217310],
["1i58",1.6,2.25895249738509],
["1h51",1.6,1.78567757628011],
["1jrr",1.6,2.0013960011743],
["1ga0",1.6,1.98909936108437],
["2asm",1.6,1.34998212477998],
["1nc5",1.6,1.88147129334948],
["1h60",1.6,2.37335311436259],
["1yt3",1.6,1.69886616753286],
["1g7q",1.6,2.11249596351510],
["1ree",1.6,1.85777366813480],
["1red",1.6,1.90634973082220],
["1uhk",1.6,1.82130215251583],
["1edg",1.6,2.22723807918067],
["1m6o",1.6,2.03097097750557],
["7odc",1.6,2.45250708275384],
["2sim",1.6,2.64080774650401],
["2sil",1.6,2.64740714424582],
["1dim",1.6,2.63937358257551],
["2cc0",1.6,1.45281247275209],
["1aoe",1.6,2.14184816836172],
["1zhk",1.6,2.04638866315395],
["1u1s",1.6,2.42140355629745],
["1xic",1.6,1.77072187604777],
["3xis",1.6,1.85873308175139],
["1tks",1.6,2.56355448749969],
["4xis",1.6,1.83351258773543],
["1xis",1.6,1.78235353102018],
["1nyw",1.6,2.23644478943165],
["1lqv",1.6,2.18817988448675],
["1xib",1.6,1.80828235256183],
["1xif",1.6,1.96355658183622],
["2qwc",1.6,2.00533572531539],
["1xpp",1.6,2.49069382001079],
["1qrr",1.6,1.62466382252156],
["1qdv",1.6,2.66097824230760],
["1gug",1.6,1.52250254276729],
["1i2c",1.6,1.46386397912137],
["1my6",1.6,1.82562806124459],
["1yux",1.6,1.74689049212076],
["1gei",1.6,2.14762905974106],
["1ru4",1.6,1.58902467915280],
["1ar5",1.6,2.29217010973282],
["2c77",1.6,1.78966240160277],
["1phg",1.6,2.37835560541113],
["1phc",1.6,2.34218043054386],
["1phd",1.6,2.56257186993436],
["1phe",1.6,2.47121933487526],
["1phf",1.6,2.69070721218606],
["1phb",1.6,2.58831052580135],
["1ws8",1.6,2.34666572482126],
["1q7e",1.6,1.71269661225420],
["1iu8",1.6,1.61059005230757],
["2czd",1.6,1.92475711471905],
["1pp3",1.6,2.01228389858545],
["1gcy",1.6,2.58142624121766],
["1gso",1.6,2.15806926614036],
["16pk",1.6,2.19001638131043],
["1km1",1.6,1.43592365451252],
["1m7y",1.6,2.07066096003957],
["1qk5",1.6,1.99160360424879],
["1q0x",1.6,2.05713870709761],
["1q36",1.6,1.50398740586351],
["1g6t",1.6,1.29398326345388],
["1g4e",1.6,1.88090768666758],
["1um5",1.6,2.35993074154918],
["1ngz",1.6,2.28554725765446],
["1ksd",1.6,1.97225953235442],
["1egn",1.6,1.50186393798445],
["1q2b",1.6,1.42491452346264],
["1mxg",1.6,1.80101630976425],
["1nlb",1.6,2.59965272680704],
["1zhy",1.6,1.92582369989005],
["1fh0",1.6,2.27874955661562],
["2b4h",1.6,1.9534356293219],
["1k92",1.6,1.79325407331887],
["1xss",1.6,2.07721672755522],
["1pw9",1.6,2.05647314546171],
["1aop",1.6,2.06029333107688],
["1wku",1.6,1.67645951623929],
["1wq7",1.6,2.87258252716955],
["1p5d",1.6,1.38850453232106],
["1yxy",1.6,1.41535896017243],
["1eon",1.6,2.25951118705738],
["1wr8",1.6,1.98958729369999],
["1o6t",1.6,1.84678860429620],
["1po5",1.6,3.21194623424340],
["1zk7",1.6,1.83342744111137],
["1wnl",1.6,2.07216664244992],
["1wpy",1.6,2.50456830621608],
["2ah6",1.6,1.11601392515130],
["1t0a",1.6,1.98624888888461],
["1fs7",1.6,2.15172090081975],
["1fs8",1.6,2.07822422602343],
["1v51",1.6,1.54519699972628],
["1gy7",1.6,2.39624490504121],
["1oko",1.6,1.49165203744609],
["1b5e",1.6,2.19977313824093],
["1n9m",1.6,1.88833921522838],
["1zke",1.6,1.63625248373952],
["1lam",1.6,1.66700590639604],
["1c7j",1.6,2.16498079254464],
["1k4f",1.6,2.11997631882231],
["1nf0",1.6,2.17853016627778],
["1wza",1.6,2.53806848893442],
["1y3n",1.6,2.17962420553392],
["1v3h",1.6,2.16746954408379],
["1z32",1.6,1.44029154554294],
["1smd",1.6,2.08713618462541],
["1yya",1.6,1.40506279437438],
["1w9d",1.6,1.62662866870819],
["1e6x",1.6,1.62374715356844],
["1e72",1.6,1.76444525328151],
["1jlj",1.6,1.60874408280959],
["1gpq",1.6,2.03395089679104],
["1wd7",1.6,2.73132609090794],
["1jl3",1.6,1.72667883659849],
["1rcv",1.6,1.95626917900525],
["1efi",1.6,2.19671979673466],
["1yms",1.6,1.66267554007143],
["1bfd",1.6,1.70639912429051],
["2bce",1.6,2.4479392646663],
["2bgk",1.6,2.88053244186032],
["2d1r",1.6,1.48522598856837],
["1a8u",1.6,1.48599246260743],
["1e2u",1.6,1.34762959912088],
["1rp0",1.6,1.72408053950211],
["1aqu",1.6,2.32180242836695],
["1o97",1.6,2.22090053755338],
["1gkk",1.6,1.55405567091452],
["1n2e",1.6,1.51788123303258],
["1mop",1.6,1.44581253048429],
["1q9i",1.6,2.16922051884138],
["1h7z",1.6,2.29794089463640],
["1v4x",1.6,2.02925850809713],
["1f6k",1.6,1.76979393517161],
["1f2u",1.6,3.19553580311798],
["1u4b",1.6,1.70120444796957],
["1nk4",1.6,1.58823422995813],
["1tvp",1.6,1.78931609321481],
["1f74",1.6,1.65829337473801],
["1vma",1.6,1.94033912839507],
["1v5e",1.6,2.34002846805593],
["1nm8",1.6,2.06435946413889],
["1u69",1.6,1.34721345780588],
["2fct",1.6,1.45960134961115],
["2fcu",1.6,1.54719427985884],
["1uf5",1.6,1.63821941380972],
["1s0i",1.6,2.01266461277732],
["2ah2",1.6,1.96187172692339],
["1hoz",1.6,2.29194209694052],
["1kic",1.6,2.11790799113050],
["1kaf",1.6,2.26188918669773],
["1n1t",1.6,2.26784132018923],
["1s1d",1.6,1.69813786670619],
["1eg9",1.6,2.21691966324749],
["1tbb",1.6,1.39461015025000],
["1kwg",1.6,1.78147810309650],
["1v8c",1.6,1.79343616713730],
["1s95",1.6,2.16216046545867],
["1w5m",1.6,1.67686091853689],
["1x7d",1.6,1.71383541706587],
["1y1p",1.6,1.79363291015141],
["1dsx",1.6,2.14270857030012],
["1dys",1.6,2.17824332999543],
["1tjo",1.6,2.26004775081586],
["1vz3",1.6,1.46048327152316],
["1o6f",1.6,1.50734473553947],
["1pe9",1.6,1.96661827010469],
["1vhd",1.6,1.73713133047291],
["1ojn",1.6,2.23737650967943],
["1t4b",1.6,1.61581512367120],
["1yd9",1.6,2.37370384996807],
["1u3u",1.6,1.91807151908738],
["1ejx",1.6,2.31920039859960],
["1w0p",1.6,2.21919719552583],
["1uer",1.6,2.63947261934617],
["1ues",1.6,2.73188844747336],
["1bd0",1.6,2.6268234401089],
["2bsv",1.6,2.54641682881196],
["2bsu",1.6,2.66254882094576],
["1hqk",1.6,1.58586547781217],
["1kj8",1.6,2.73665595484501],
["1rrm",1.6,1.72148607877206],
["1kj9",1.6,2.62461057644978],
["2c46",1.6,1.56193935796002],
["2gyi",1.6,2.50054720536505],
["1kji",1.6,2.70527351535455],
["2gl5",1.6,1.58398624798988],
["1kwm",1.6,2.03821332172553],
["1dz4",1.6,1.60371127557567],
["1s9r",1.6,1.55401948320685],
["1fgr",1.6,1.71903014824766],
["1ajs",1.6,2.32710053833915],
["1jkx",1.6,2.13997653017555],
["2g6y",1.6,1.94967022828505],
["1h80",1.6,2.03259563023269],
["1wvm",1.6,1.92242478781149],
["1o26",1.6,1.83394074481975],
["1y6v",1.6,2.17016796015225],
["1nbu",1.6,2.32864244541308],
["2apj",1.6,1.48155878403918],
["1hfe",1.6,1.53712430609742],
["2f9n",1.6,2.18262861056235],
["1qwm",1.6,1.89786917980041],
["1qwl",1.6,2.12968538396902],
["1j1n",1.6,1.99675184806654],
["1s3e",1.6,1.59507208013291],
["1gee",1.6,1.89146089013257],
["1j31",1.6,2.13647635809728],
["2bo9",1.6,1.75845273633268],
["2dg5",1.6,1.99339358420441],
["1hj3",1.6,1.89878572892516],
["1hj4",1.6,1.93750249980443],
["1u0f",1.6,1.98276027855436],
["1u0e",1.6,1.92591418938194],
["1j3z",1.6,1.86009700061774],
["1xg4",1.6,2.20474205668284],
["1fiu",1.6,2.40428782026677],
["1l9x",1.6,1.76256962056095],
["1xk7",1.6,1.79384305500261],
["1g87",1.6,1.79713839804063],
["1bav",1.6,2.91927668967643],
["1kxv",1.6,2.54216134829201],
["1ccw",1.6,1.8313833973494],
["1dki",1.6,2.01544846198411],
["1f1x",1.6,1.73299629961047],
["1ji1",1.6,2.08080407636916],
["1tqj",1.6,2.16345562284234],
["1p0z",1.6,1.66660544422725],
["1pzg",1.6,1.51393557775341],
["1juh",1.6,1.59875530083231],
["1q0g",1.6,1.51386057974704],
["1ufo",1.6,2.09429152308687],
["2cdb",1.6,1.95774482270753],
["1zz0",1.6,1.76895855593157],
["1kqf",1.6,1.91182463628800],
["1uxl",1.6,1.98097710387286],
["1xpm",1.6,2.23582161144665],
["1jnr",1.6,1.93693491893510],
["1d8w",1.6,2.67094596081843],
["2fym",1.6,1.61162941355055],
["1gtz",1.6,1.31411841024812],
["1dps",1.6,1.69670286790924],
["1qh1",1.6,1.54176000453117],
["1qgu",1.6,1.52413409370264],
["1qh8",1.6,1.62326803998796],
["1qmg",1.6,1.50936280308343],
["1iy8",1.6,1.63146784408523],
["1y7b",1.6,1.96121541241498],
["8ruc",1.6,2.15931864039727],
["1fwx",1.6,2.79963139661745],
["1kxq",1.6,2.49842241035473],
["1rm6",1.6,1.63364245793569],
["1e6y",1.6,1.72223549685124],
["1y2m",1.6,1.45794304360053],
["1px3",1.6,2.53130727422576],
["1px4",1.6,2.53644764720508],
["2ar1",1.6,1.83917204894676],
["2a0m",1.6,1.33013338476462],
["1vk5",1.6,1.71026384472849],
["1lqa",1.6,1.63958518672473],
["2aen",1.6,1.19692475379155],
["1s8i",1.61,1.36508444067563],
["1xrt",1.61,2.41181484518929],
["1r0q",1.61,2.59017025136508],
["1zcx",1.61,1.58963733138482],
["1tfj",1.61,1.78587844502211],
["1h4y",1.61,2.11236170113411],
["1elt",1.61,1.69513932566009],
["1r7u",1.61,2.02982199718108],
["1li0",1.61,1.99894870090727],
["1on2",1.61,2.14201762272123],
["1xkg",1.61,1.43507741403723],
["1h55",1.61,1.43238164553677],
["1c5c",1.61,2.13340986944302],
["1z3v",1.61,1.57376285471736],
["1p5g",1.61,1.26563680272542],
["2fta",1.61,2.33852647868989],
["1xo7",1.61,2.25483902807832],
["1jqc",1.61,2.44942405176012],
["1pj5",1.61,1.54753241602560],
["1u60",1.61,1.90370323494212],
["1guj",1.62,1.14751500473465],
["1f5b",1.62,1.91394534773645],
["1d0d",1.62,1.49580103474491],
["2bwl",1.62,1.18601626382038],
["1wol",1.62,3.03386648975673],
["1p64",1.62,1.58049469915322],
["1vjf",1.62,1.23684841592369],
["1p8u",1.62,3.67529898375471],
["1o0a",1.62,2.77965670110243],
["1o2t",1.62,1.98816872563439],
["1v2o",1.62,1.63290302706756],
["2rtr",1.62,2.40076817960351],
["1jzi",1.62,2.10392383320518],
["1w9t",1.62,1.94343732228468],
["2ftl",1.62,1.41954692572740],
["1jkl",1.62,2.29560161707699],
["1h5c",1.62,1.35896264514035],
["1r6w",1.62,1.64620333884271],
["1h63",1.62,2.1629307249881],
["1htr",1.62,2.29942615670734],
["1t93",1.62,3.31580168140602],
["1kv8",1.62,1.55757440808065],
["2abw",1.62,2.06416369371347],
["1iat",1.62,2.03638760021897],
["1m26",1.62,1.91305486605924],
["1ikq",1.62,1.99331564826882],
["1gzj",1.62,1.85169286668221],
["1tp9",1.62,2.0735444469563],
["1h2b",1.62,1.99269527479382],
["1fgt",1.62,1.61673323665437],
["1fgo",1.62,1.63456578512850],
["1dzo",1.63,1.30335024360015],
["1x6p",1.63,1.61079365011679],
["2aj6",1.63,1.80217421647007],
["1ir8",1.63,1.09654216431889],
["2bsw",1.63,1.92499872589698],
["1gny",1.63,1.33532732515930],
["1xww",1.63,1.41708455649362],
["2cpl",1.63,1.61345713650859],
["1pzs",1.63,1.53613108166901],
["1lko",1.63,2.14808639095754],
["1iwd",1.63,1.68818259564497],
["1aky",1.63,2.0632712756484],
["1qqu",1.63,2.66879999577686],
["1c1s",1.63,1.75420386345157],
["1o2o",1.63,1.79693166869331],
["1o2k",1.63,1.80207016668661],
["1tqh",1.63,2.0954373382834],
["1n83",1.63,1.81618727876956],
["1zvy",1.63,1.74464724887674],
["1o5c",1.63,2.57506773765884],
["1lcn",1.63,1.98810780374324],
["1th9",1.63,1.92701343324167],
["1k77",1.63,1.82384600036524],
["1rcj",1.63,1.61919806772019],
["1r2z",1.63,2.10028385456302],
["1qyw",1.63,1.61472822330299],
["2cj4",1.63,1.51667834250697],
["2fbn",1.63,1.28987593020055],
["1ds0",1.63,1.91408312297144],
["2cpp",1.63,2.15851994754915],
["1pha",1.63,2.48524409152821],
["1ugp",1.63,1.49427853958948],
["1qgw",1.63,1.44915918529856],
["1mg5",1.63,2.05997518451401],
["1ju4",1.63,1.75498697468245],
["1e5p",1.63,2.24624809680352],
["1tb7",1.63,1.20684617436862],
["1q3l",1.64,2.40118615954447],
["1h98",1.64,1.73436515692465],
["1zpw",1.64,1.67985508949283],
["1dpw",1.64,2.02872378949994],
["1h6m",1.64,1.96965588693271],
["2utg",1.64,3.11765022701106],
["1x3k",1.64,1.44527073584457],
["2cyh",1.64,2.16499423058753],
["1ciz",1.64,2.18063167099498],
["1lkp",1.64,2.12202758381020],
["1dai",1.64,1.77565775598604],
["1o3e",1.64,1.92662917938454],
["1o3c",1.64,1.80856547481073],
["1dag",1.64,1.86695818934334],
["1dah",1.64,1.95418514509425],
["2a0n",1.64,1.41110618955359],
["1gj8",1.64,2.58577148355084],
["1zjo",1.64,1.81769814824104],
["1bue",1.64,1.24692321570346],
["2bok",1.64,1.43689985830596],
["1o83",1.64,1.80382097454496],
["2bof",1.64,1.33278193862758],
["1mkq",1.64,1.67062787768925],
["1vje",1.64,1.68822943400176],
["1ogi",1.64,1.81768213614633],
["1wrr",1.64,1.5719553917973],
["3a3h",1.64,1.81957086287930],
["2fp2",1.64,1.38059875862195],
["1h7p",1.64,2.30547122980894],
["1xh9",1.64,1.61811014874387],
["2asp",1.64,1.40780592582984],
["1yw9",1.64,2.04275212489633],
["1pu6",1.64,1.76929342574048],
["1sk9",1.64,2.46639266527325],
["1kap",1.64,1.46982206937509],
["1wds",1.64,1.86372226443128],
["2ffu",1.64,1.79454467407005],
["2cdo",1.64,1.96461072867587],
["1l7r",1.64,1.93413203231820],
["1n1s",1.64,2.32892093003911],
["1su6",1.64,2.3927712411095],
["2afx",1.64,1.94280824885659],
["2bfc",1.64,1.81882295529947],
["2rmc",1.64,1.93830222382907],
["1yll",1.64,2.57711239928759],
["1u0a",1.64,1.25539402663687],
["1g8k",1.64,1.57944871046823],
["1sdb",1.65,2.41680281949333],
["1ds3",1.65,2.27130432274446],
["1kfn",1.65,2.59776594265071],
["1be7",1.65,1.63925188497332],
["2ccb",1.65,2.51873266871503],
["1b7j",1.65,1.26706343820001],
["1jab",1.65,1.36215467477687],
["1b7i",1.65,1.80636939734996],
["6msi",1.65,1.65655140045783],
["1ekl",1.65,2.00508675021048],
["1ame",1.65,1.57571135648356],
["1cxy",1.65,2.00899988116895],
["1uln",1.65,1.85618567296382],
["1jk2",1.65,2.5074383111708],
["1zld",1.65,1.07441112612948],
["1kcq",1.65,1.33418783127335],
["4gsp",1.65,1.62594061996324],
["2wrp",1.65,1.87855426414777],
["1erv",1.65,2.10704736980703],
["1o4l",1.65,2.39181126890363],
["1sbx",1.65,1.55702580248526],
["1pc4",1.65,1.94176746495501],
["1pal",1.65,2.99527173874995],
["1bu3",1.65,2.23077545392059],
["1xw3",1.65,1.66812580952355],
["1n3z",1.65,2.24613450706732],
["1ui9",1.65,1.76301939622124],
["1ln8",1.65,2.04272486709443],
["1unp",1.65,2.28615862650912],
["2a7b",1.65,1.89181059710988],
["1l6p",1.65,2.47803155986957],
["1dhn",1.65,1.37068875230970],
["1dz3",1.65,1.85412331129793],
["1tew",1.65,1.97444543459523],
["1vwo",1.65,2.78321560111568],
["1dpx",1.65,2.00768681531550],
["1w6z",1.65,1.9347328342124],
["1qjp",1.65,2.26718869621210],
["1snc",1.65,3.16568997323705],
["1ihz",1.65,3.11670230932798],
["2fdx",1.65,2.09841260959044],
["1sd9",1.65,1.78431267392426],
["1i9d",1.65,1.61466889089341],
["2f1w",1.65,2.18596636072385],
["1v8y",1.65,1.57394443716628],
["1uov",1.65,1.75828727976890],
["1yoi",1.65,2.33098213600646],
["1yog",1.65,2.35179226264091],
["1yoh",1.65,2.32197089773819],
["1m45",1.65,1.59624319840828],
["1sk4",1.65,2.25315320580352],
["119l",1.65,1.90585109388202],
["1lpy",1.65,2.69152776135072],
["1pqd",1.65,2.11134631133011],
["1pqo",1.65,2.25702309046047],
["1l58",1.65,2.31864251878164],
["1o9w",1.65,1.63589124448938],
["1w8m",1.65,2.70119721567648],
["1qtx",1.65,1.82775347008827],
["2fn4",1.65,1.80265599842426],
["1m8u",1.65,2.24160239102702],
["1aqb",1.65,2.72319447815938],
["1iwl",1.65,2.52830387348869],
["1wub",1.65,2.91472555216455],
["1pq1",1.65,2.52838014846433],
["1im5",1.65,2.35770145749443],
["1y66",1.65,2.67107981440274],
["1ufi",1.65,2.55538573904154],
["1fr9",1.65,2.27554757280139],
["1i9s",1.65,1.59705513004111],
["1h4c",1.65,2.292547072783],
["1hjj",1.65,2.32105525076057],
["1h4e",1.65,2.43343475822376],
["1us6",1.65,2.05738000582228],
["1n3y",1.65,1.85379684408514],
["1e6b",1.65,2.01377387287302],
["1cqm",1.65,1.95636436909420],
["1nrv",1.65,1.60107940096522],
["1swx",1.65,2.05760442664152],
["1l8r",1.65,2.38494174095749],
["1yer",1.65,1.94104284178802],
["1kx9",1.65,2.36666836450128],
["1dix",1.65,2.41267154418968],
["1e2d",1.65,1.58619596758612],
["9pap",1.65,2.76573471476866],
["1sdi",1.65,1.82885752224253],
["2a46",1.65,1.88971986397162],
["1jfx",1.65,1.75457386953441],
["1pva",1.65,2.37264379901917],
["1tj6",1.65,1.56165452944249],
["1hxr",1.65,1.93576339910238],
["1dts",1.65,1.99901193079493],
["1nqd",1.65,2.92390790849790],
["1kgb",1.65,2.66225313857861],
["1tgn",1.65,3.24456357365583],
["1u5h",1.65,2.60139772780444],
["2cul",1.65,1.56325454630886],
["1y5b",1.65,1.41949205028684],
["2fx4",1.65,1.23617231961497],
["1o2j",1.65,1.73493639965049],
["1o2s",1.65,1.73727564978679],
["1c2e",1.65,2.02889678345700],
["1o2z",1.65,2.05132003201698],
["1c2g",1.65,2.03974670382053],
["1c2d",1.65,2.28442444634184],
["1c2k",1.65,2.59099441891726],
["1v2m",1.65,2.05339376949628],
["1vj2",1.65,1.88328267140607],
["2aip",1.65,2.32249948016002],
["1ct2",1.65,1.98113338023514],
["1sri",1.65,3.07904607882766],
["1sfi",1.65,1.25222345662474],
["2ax9",1.65,2.04332521336912],
["1dza",1.65,2.11042587756929],
["1l6x",1.65,2.33987264907685],
["2a7c",1.65,1.09622847539275],
["1uo6",1.65,1.48052081218943],
["3est",1.65,2.09362134800833],
["2a7j",1.65,1.72754616167087],
["1esa",1.65,2.01751341919512],
["1elg",1.65,2.03926007456126],
["2rtd",1.65,2.2395286602617],
["1nes",1.65,2.05064977101305],
["1g2n",1.65,2.21227054297699],
["1yo3",1.65,2.02520216957098],
["1zko",1.65,1.26986438549825],
["1lp8",1.65,1.78168187597939],
["1j9m",1.65,2.04453034317329],
["1c5y",1.65,2.73738048130609],
["2ev0",1.65,1.78060035159712],
["1y51",1.65,1.84318380477969],
["1m5c",1.65,1.56846517745974],
["1cc3",1.65,2.51820407484574],
["1s50",1.65,2.16194183195623],
["1uy0",1.65,1.85652221756047],
["1mqj",1.65,1.53168335986178],
["1iys",1.65,1.61307950798695],
["1zj1",1.65,1.85602297263218],
["1bbz",1.65,2.62956401599567],
["1o54",1.65,1.51630077793156],
["1r80",1.65,2.10954944752369],
["1lz7",1.65,2.48519948586666],
["1w6n",1.65,2.14769931257317],
["2gdz",1.65,1.44700348566554],
["1f5r",1.65,1.75882245420733],
["2b9e",1.65,1.60073793935605],
["2ftm",1.65,1.37123916279841],
["1p2i",1.65,1.67260352840387],
["1h9m",1.65,1.72076500901586],
["2bzl",1.65,1.78190870513709],
["1jqz",1.65,2.38945113077607],
["1yjh",1.65,2.23302840202909],
["2cwc",1.65,1.82423784817864],
["1cnv",1.65,2.00101733616577],
["1wmu",1.65,2.04209914549558],
["1ghx",1.65,2.59671538184707],
["1nnh",1.65,0.667267994766753],
["1vpd",1.65,1.49058204763677],
["1fhu",1.65,2.03173422187544],
["1mk8",1.65,1.71142284141524],
["1ml2",1.65,2.08376253961865],
["1r4u",1.65,1.70852983764035],
["1cbj",1.65,1.86895719518063],
["4a3h",1.65,1.33004130643793],
["1gy1",1.65,1.93507694770797],
["1g4c",1.65,2.23407816645824],
["1m93",1.65,2.16889709013392],
["1wzz",1.65,1.52309814516205],
["2bcq",1.65,1.78015144777245],
["2erx",1.65,1.26393923545280],
["1i0s",1.65,1.58937887195280],
["1zsw",1.65,1.53966329674963],
["1mvf",1.65,2.43353921519709],
["1iej",1.65,2.25783494318187],
["1w06",1.65,2.07177481546933],
["1phn",1.65,2.18448517377087],
["1kcb",1.65,2.33065561131470],
["1wa1",1.65,1.43945013607372],
["1udc",1.65,1.86486393864744],
["1udb",1.65,2.00513725713238],
["1qnq",1.65,1.27726027940928],
["1ode",1.65,1.94934273210554],
["1fpx",1.65,2.09347985526641],
["1ezw",1.65,2.16025604313346],
["1jg7",1.65,2.08235585310703],
["1oxs",1.65,2.01169174414870],
["1r3s",1.65,1.71283312388775],
["2b61",1.65,1.60572550796795],
["1xrf",1.65,2.1895056342006],
["1ueb",1.65,1.40302574525504],
["1s99",1.65,2.08030207730640],
["1dtd",1.65,2.27586822045853],
["3psg",1.65,2.80700838389212],
["1cem",1.65,1.24532088015296],
["1wb0",1.65,1.82854280154570],
["1tx4",1.65,2.29357444718676],
["1zkc",1.65,1.95867152356741],
["1gw1",1.65,1.17218646034865],
["1vi0",1.65,2.26200873319632],
["1ucg",1.65,1.68395406233985],
["2bvo",1.65,2.14665369563545],
["1bs0",1.65,2.34291914808775],
["6xia",1.65,2.03072028716823],
["1php",1.65,2.33700944208896],
["2d0q",1.65,1.48089198018014],
["1oe8",1.65,2.34924384459044],
["1i0x",1.65,1.41145134305047],
["2fpq",1.65,1.58020249974386],
["1sqg",1.65,2.38543552752066],
["1vhq",1.65,1.46212077805353],
["2fq9",1.65,1.72419144319981],
["1sk8",1.65,2.25684119549359],
["2f0c",1.65,1.52359722606761],
["1wky",1.65,1.89441818949554],
["1iby",1.65,2.30751158950489],
["1mep",1.65,2.83532433640196],
["1ooe",1.65,1.41807121383839],
["1jae",1.65,1.71202094810431],
["1v4y",1.65,1.60217903435298],
["3std",1.65,2.11659406415077],
["2a2n",1.65,2.29953088925607],
["1b8s",1.65,1.80299440271329],
["1e70",1.65,1.72071772022941],
["2a65",1.65,1.87121918625293],
["2al5",1.65,1.34688859747985],
["1pyo",1.65,2.05669223830738],
["1k07",1.65,1.73954524699385],
["1k2x",1.65,1.58937682377066],
["1t3m",1.65,1.97951096018562],
["1njx",1.65,1.68603730285578],
["1vhl",1.65,1.97546593556763],
["2cwl",1.65,1.37616109569447],
["1e0x",1.65,1.67227355185607],
["1qsa",1.65,1.14725835469018],
["1s0j",1.65,1.93998151693181],
["1uuv",1.65,2.34385887287],
["1w5n",1.65,1.69363924179828],
["1gxr",1.65,2.20027566612752],
["1y7t",1.65,2.34315132108479],
["1hfo",1.65,2.12287778306375],
["1mqq",1.65,2.09511141306599],
["1vkf",1.65,1.63385775389781],
["1h2z",1.65,1.5889300871676],
["1yqd",1.65,2.01905641187898],
["1w3y",1.65,2.16836808051787],
["2cvl",1.65,1.66906875240689],
["1ok7",1.65,2.26476475025384],
["1u3v",1.65,1.74390881932770],
["1onw",1.65,2.10509358875437],
["1u6r",1.65,1.45363611817734],
["2aal",1.65,2.2212433241042],
["2d29",1.65,1.64375023841820],
["1mm7",1.65,1.89868433178893],
["2ex0",1.65,2.05148319643323],
["1ubp",1.65,1.87821771194768],
["1kol",1.65,1.80132049644844],
["1fyf",1.65,2.13314401299723],
["1k2o",1.65,2.05357337729855],
["1pj6",1.65,1.58539210180045],
["1d0c",1.65,2.62219027569527],
["2b5r",1.65,1.76773423761338],
["1qk3",1.65,1.98694433998931],
["1iv1",1.65,2.92243487328981],
["1bu7",1.65,2.23993822890873],
["1jpz",1.65,1.50959541802998],
["1wle",1.65,2.34191408261764],
["2d1y",1.65,1.78549159418246],
["1lcp",1.65,1.67543830656510],
["1s3b",1.65,1.84412255795627],
["1j9q",1.65,1.86056312644654],
["1mo9",1.65,2.11346135714892],
["2a9w",1.65,2.29724970952524],
["1hx6",1.65,2.05603222032919],
["1w4n",1.65,1.51366206895381],
["1ms3",1.65,2.13541649480613],
["1w0d",1.65,2.35361686067038],
["1dw9",1.65,1.94979633166440],
["1dwk",1.65,1.93963254569658],
["1vl2",1.65,1.77247367215557],
["1twy",1.65,1.7683695710823],
["1yve",1.65,1.8722072669012],
["1o7t",1.65,2.54376747714081],
["1p80",1.65,1.98542770306605],
["1n9e",1.65,1.68356822598074],
["1gte",1.65,2.18197332541899],
["1pgx",1.66,1.76477325242475],
["1eis",1.66,1.64875989805987],
["1mm9",1.66,2.07941566417838],
["3chy",1.66,1.68199057963020],
["2a7d",1.66,1.98892791537832],
["1jkb",1.66,1.69136961993342],
["1jka",1.66,1.70879957068246],
["1o6d",1.66,2.50775870414455],
["1v8w",1.66,1.85022125541663],
["1fjj",1.66,1.12981234202172],
["5hpg",1.66,2.46349843552352],
["1e4c",1.66,2.05251476579650],
["1o31",1.66,1.76909408584000],
["1t65",1.66,1.71658788598410],
["1t0p",1.66,1.74504959205881],
["2aft",1.66,1.21381703662339],
["1gtk",1.66,2.41588462062502],
["2d81",1.66,1.41659036902812],
["1ymi",1.66,1.96920266516621],
["1tku",1.66,2.70765175118091],
["4uag",1.66,1.86797456945157],
["1xbv",1.66,1.41251624401417],
["2hmz",1.66,1.99236469944750],
["2hmq",1.66,2.13500019256772],
["1vpm",1.66,1.97219626895081],
["1vns",1.66,1.74728872441827],
["1jg9",1.66,1.92986370890473],
["2afm",1.66,1.88713876069564],
["1gzg",1.66,2.17575717364133],
["1cpc",1.66,2.21092682357107],
["1l0f",1.66,1.6758227035133],
["1zr3",1.66,2.29797185823046],
["1l3l",1.66,2.26436998945989],
["1e3u",1.66,2.15921577203613],
["3bto",1.66,1.65539741340992],
["1fxo",1.66,1.90728246370240],
["1krn",1.67,1.41075936401285],
["1sty",1.67,2.12611642102189],
["1n1j",1.67,1.37507223972059],
["1p46",1.67,2.21400261988272],
["1p6z",1.67,1.60267933690947],
["2cth",1.67,2.24782641233336],
["1w7z",1.67,1.99306890388555],
["3vgc",1.67,2.14536317606753],
["1exx",1.67,1.65965310947648],
["1h9l",1.67,1.88882384926883],
["1qxw",1.67,1.54260399331454],
["2ccy",1.67,2.26920837593761],
["2cbb",1.67,1.70287049385252],
["2cbd",1.67,1.88382156095928],
["1zj0",1.67,2.16318014687097],
["1c9m",1.67,1.83546742027747],
["1y1g",1.67,1.29149676339229],
["1y1h",1.67,1.28707703635529],
["2etw",1.67,1.49087680933614],
["2aj7",1.67,1.43825273109305],
["7abp",1.67,2.13965361595683],
["6abp",1.67,2.26604717021856],
["1zkl",1.67,1.56652023732832],
["2bjf",1.67,0.987847830830783],
["1tmg",1.67,1.6924888595218],
["1anf",1.67,3.20516212065713],
["1r87",1.67,1.59132486042473],
["5cha",1.67,3.27652238839427],
["1f60",1.67,1.74159147039821],
["1mw9",1.67,2.11347668337218],
["1rjo",1.67,1.45310566102581],
["1b4k",1.67,2.28018670677720],
["1y2c",1.67,1.17996406395733],
["1gql",1.67,1.63949012501728],
["1k1e",1.67,2.19075698104674],
["1yp5",1.68,1.37199487984995],
["1gv2",1.68,1.93099457949872],
["3c2c",1.68,2.96734957198683],
["1s69",1.68,2.02141239043402],
["2a15",1.68,1.69631115309114],
["2bw9",1.68,1.49904717121507],
["2mye",1.68,2.46644704661898],
["1u14",1.68,2.23600221350437],
["1gcq",1.68,2.02943308498102],
["2fp7",1.68,1.47497851076123],
["1sd5",1.68,1.90201939818147],
["1ojq",1.68,1.8493923795343],
["2trx",1.68,1.75794123104498],
["1o2l",1.68,2.04395579657487],
["2bq4",1.68,2.5573688199195],
["2f2b",1.68,1.81006091762705],
["1w4q",1.68,2.63238180941222],
["1qxz",1.68,1.85272035922873],
["1o5a",1.68,2.48598064173748],
["2bgi",1.68,2.23366457296037],
["2euw",1.68,1.46878053392642],
["6a3h",1.68,1.51027662723632],
["1ns5",1.68,2.18826769681230],
["1om1",1.68,1.96772176720473],
["1to1",1.68,1.58735210276358],
["2bwa",1.68,1.959457883835],
["1fjh",1.68,2.45953201367197],
["4cha",1.68,2.35491957601424],
["1hfu",1.68,1.68458863833687],
["2afz",1.68,1.83154002681004],
["1czf",1.68,1.84885751775808],
["1piy",1.68,2.21377186596516],
["1q0m",1.68,1.63314696208521],
["2bhx",1.68,2.00476826561953],
["1rky",1.68,1.44178107521452],
["1gnx",1.68,1.84452055038909],
["1ud9",1.68,2.31940657305556],
["1th7",1.68,1.93312279067872],
["1s6a",1.69,2.37355051539188],
["1rbx",1.69,2.40611900776853],
["1rbw",1.69,2.27203184846224],
["1uy4",1.69,1.91445878742799],
["1y7y",1.69,2.11445983375079],
["2a4d",1.69,1.99794788713792],
["1wsw",1.69,2.38731612733278],
["1uwf",1.69,1.56878802628948],
["1lkm",1.69,2.07864059845583],
["1xzg",1.69,1.64294328098520],
["1ffa",1.69,1.78763944300625],
["1ffe",1.69,1.67661611540565],
["1cuy",1.69,1.87331751744937],
["1xzf",1.69,1.74024164734244],
["1xzj",1.69,1.74586913441288],
["1xzh",1.69,1.78737023837750],
["1ffd",1.69,1.77077151866077],
["1xzi",1.69,1.84453877142039],
["1xzl",1.69,1.88337456439128],
["1cuu",1.69,2.01728288486449],
["2hft",1.69,2.57861772184671],
["1h2e",1.69,1.83080082043825],
["1n8n",1.69,1.56984021605802],
["1enf",1.69,1.99491814844740],
["1o2m",1.69,1.59848752773592],
["1u21",1.69,2.05154960224843],
["1w4p",1.69,2.59210988723537],
["1vzh",1.69,1.90340909846457],
["1vzg",1.69,2.02341101507647],
["1xqp",1.69,1.29518172348769],
["1s2w",1.69,1.55841960910613],
["1zi3",1.69,1.91497774894198],
["1zj3",1.69,1.98283880851276],
["1zj2",1.69,1.72326348766785],
["2a8u",1.69,2.16393952183082],
["1sbm",1.69,1.42192612190675],
["1sdq",1.69,1.69058727223901],
["1jp4",1.69,1.65334033914172],
["1kli",1.69,2.10474615475992],
["1y3c",1.69,1.55971891221378],
["1vpj",1.69,1.37848713810522],
["1d6f",1.69,2.09308327935524],
["1cml",1.69,2.20400836449715],
["1jy1",1.69,1.88891901208244],
["1ska",1.69,2.56958003008539],
["1ry8",1.69,2.63581679102307],
["1ry0",1.69,2.80588173582898],
["2bfe",1.69,1.95434991369012],
["2bi1",1.69,2.07420088063338],
["2bi2",1.69,2.13315632272678],
["2bi3",1.69,2.08472446309863],
["1q6q",1.7,1.42490586473299],
["1x38",1.7,2.02176593464905],
["1usd",1.7,2.16788412759427],
["1wkx",1.7,0.49999908702147],
["1b17",1.7,1.34922769281048],
["1b2d",1.7,1.52741423537008],
["1b2a",1.7,1.57326051339877],
["9ins",1.7,2.34557680807026],
["1r0h",1.7,1.60124347345291],
["1rop",1.7,1.91376583203484],
["6pti",1.7,1.56475986710828],
["1fxd",1.7,1.84981363594837],
["1jb6",1.7,2.00868738546716],
["1vie",1.7,2.7361153871852],
["1uo4",1.7,1.87625425662675],
["2ccf",1.7,2.02993175001251],
["2ccc",1.7,2.05645372880891],
["1sn1",1.7,2.93573309557233],
["1ypc",1.7,0.983764100153305],
["1wtq",1.7,2.73720742424572],
["2g0c",1.7,2.18971497367664],
["1fw4",1.7,2.14352801892694],
["1uj0",1.7,2.26078840448701],
["7ame",1.7,2.24396945117327],
["7msi",1.7,2.07832150545074],
["1mog",1.7,2.63210245525758],
["1ctf",1.7,2.21278713385802],
["1j2l",1.7,1.63347674035764],
["1a8o",1.7,1.52751610780834],
["1b7v",1.7,2.18488777802726],
["1z0p",1.7,2.19387621347143],
["1bt0",1.7,2.57036754581880],
["1wfa",1.7,1.64659851629092],
["1h75",1.7,1.90550967319753],
["1rwj",1.7,1.85811119138991],
["1tsf",1.7,1.85644139133848],
["2bop",1.7,2.39582068340623],
["1gkh",1.7,3.01719842990817],
["1ij2",1.7,2.64559376251324],
["2buo",1.7,2.45951579835359],
["1mgr",1.7,1.96830494553888],
["1a70",1.7,2.21589927579501],
["1j27",1.7,2.20971010447318],
["1frd",1.7,2.13789733327758],
["1w41",1.7,1.04770569542907],
["1jos",1.7,2.52783431584082],
["1kdj",1.7,1.70740019679031],
["1tuv",1.7,2.68981701768227],
["1nza",1.7,1.65940953279649],
["4bir",1.7,1.39501246357642],
["1hyf",1.7,1.49533969500577],
["1rga",1.7,1.73660107379335],
["1ygt",1.7,2.23930020305678],
["1f2f",1.7,1.49386735456639],
["2a9i",1.7,1.92482898153746],
["1ert",1.7,1.98320868844449],
["1rh6",1.7,2.03616783528333],
["1njh",1.7,2.13381268716299],
["1o4q",1.7,2.31844949304974],
["1o42",1.7,2.17351205579944],
["1o4j",1.7,2.08455263387013],
["1o41",1.7,2.35451560019275],
["1o4o",1.7,2.51439746329595],
["1o44",1.7,2.25196158547666],
["1o49",1.7,2.60427569223755],
["1d3w",1.7,2.69564051152528],
["1fkj",1.7,1.73305287429466],
["1fkb",1.7,1.6831981527123],
["1fkf",1.7,1.95326449849363],
["1fkl",1.7,2.02157095916743],
["1vmb",1.7,1.49495797562627],
["1b8l",1.7,2.12816820383915],
["2b8m",1.7,1.42648397463594],
["1v07",1.7,1.17431005232345],
["1wjx",1.7,1.89749475803061],
["1ddw",1.7,2.20721465737467],
["1uqx",1.7,1.72967106486402],
["1ean",1.7,1.59336621130299],
["2cbo",1.7,1.45981191289747],
["1un3",1.7,1.18650359288803],
["1rbd",1.7,1.98391480837155],
["1jdl",1.7,2.18020303446969],
["2cy3",1.7,2.47844620973639],
["1rbh",1.7,1.93263260588787],
["1m8a",1.7,2.36140844388859],
["1cot",1.7,2.17603686670156],
["1alc",1.7,3.90609075439213],
["3era",1.7,2.06485188369522],
["6ebx",1.7,2.77348521068424],
["1ras",1.7,2.92163953360651],
["2b96",1.7,2.02571004394083],
["1bp2",1.7,2.76459379772021],
["1hml",1.7,2.06931493360792],
["1c9v",1.7,2.56990698201294],
["3rsp",1.7,2.48154837658438],
["1tg4",1.7,2.87516098261204],
["1y80",1.7,0.977544844379707],
["1tdv",1.7,2.77471200159499],
["1mc9",1.7,2.58640385346775],
["1z9l",1.7,1.70398137608009],
["1vwq",1.7,2.693900387011],
["1e6m",1.7,1.96968071198925],
["1jzh",1.7,2.28326905456200],
["1rsu",1.7,2.45416021187243],
["1pdo",1.7,1.82986714474744],
["1lsd",1.7,2.27976122872344],
["1lse",1.7,2.13606021931871],
["1f10",1.7,2.27401625448483],
["1vdt",1.7,1.92922917974287],
["1hel",1.7,2.08061966390403],
["1lsc",1.7,2.08061966390403],
["1lz9",1.7,2.12025700669314],
["1lsb",1.7,2.64447716746684],
["2aub",1.7,1.99304282540278],
["1lsf",1.7,2.70531906683475],
["1lsm",1.7,2.34013682890637],
["1lsa",1.7,2.63404488933116],
["1rst",1.7,2.65688993434588],
["1tay",1.7,2.07345320745215],
["1ge1",1.7,1.50640617162367],
["1tdy",1.7,1.99421624621722],
["1tcy",1.7,1.99483015036645],
["1rey",1.7,1.97965362971547],
["1rez",1.7,2.19349683311112],
["1nep",1.7,1.39303651770939],
["1rxe",1.7,2.16540389823562],
["1lib",1.7,1.97580125372719],
["1uy2",1.7,1.85912086909936],
["1g74",1.7,2.15299410042311],
["1u4p",1.7,1.84803532603162],
["1gmi",1.7,2.79423105046706],
["1is6",1.7,1.96791196727826],
["1dqg",1.7,1.37509951579109],
["1kqx",1.7,2.49291304469929],
["2f1y",1.7,2.26740567636598],
["1h0s",1.7,1.77338063771047],
["1ey5",1.7,2.99979970880173],
["1syd",1.7,2.23917341847834],
["1stg",1.7,2.81327271814887],
["1stn",1.7,2.15448636738588],
["1sno",1.7,2.06245871880021],
["1eyd",1.7,2.59176492869429],
["1rnj",1.7,1.95588161676208],
["1iuk",1.7,2.88527668565684],
["1yrk",1.7,1.67811901299162],
["1sta",1.7,2.09375846162528],
["1b9d",1.7,2.08784024074362],
["1qkk",1.7,2.06072773683289],
["1zd0",1.7,1.57207869088372],
["1yy6",1.7,2.20331266615094],
["1tfe",1.7,2.28539865454611],
["1ear",1.7,2.14359360996060],
["1wka",1.7,1.58607083313628],
["1h6h",1.7,1.86912791128096],
["1cll",1.7,3.03582548980337],
["1gs9",1.7,2.31416726350388],
["1uv7",1.7,2.26251151293954],
["1ewx",1.7,1.50457100237393],
["1vsd",1.7,2.23321461625834],
["1w92",1.7,2.23112917218842],
["1xyy",1.7,3.1079081583077],
["1nb9",1.7,1.97181565189372],
["1nb0",1.7,2.28160979736796],
["1prw",1.7,1.74313748838747],
["1b9f",1.7,2.58494349163528],
["1jp9",1.7,1.56095944341964],
["1jpb",1.7,1.64687157146128],
["1jcc",1.7,1.83712502564622],
["1npg",1.7,1.60649482879814],
["1zxu",1.7,2.26166167410722],
["2jcw",1.7,1.57424790934669],
["1yaz",1.7,2.51391314864562],
["1f18",1.7,1.37142175096258],
["2evp",1.7,1.81546239666261],
["1hrm",1.7,1.99995820286816],
["1xch",1.7,2.21122359477474],
["1nz5",1.7,2.44202081476902],
["1wla",1.7,2.4406406972160],
["1rse",1.7,2.31255112547859],
["1do4",1.7,1.20516546587147],
["2bli",1.7,1.48285413628693],
["1vxh",1.7,2.15698953374644],
["1vxd",1.7,2.22715557600075],
["1vxc",1.7,2.36574718872971],
["1vxg",1.7,2.39583066313775],
["1vxf",1.7,2.37090486789984],
["1gdj",1.7,2.69313125350608],
["2gdm",1.7,2.7360251157345],
["1vxe",1.7,2.60693612744761],
["1cik",1.7,2.11033250351448],
["1lue",1.7,1.76834679225318],
["1f65",1.7,1.92606790654070],
["1ltw",1.7,2.41964279314013],
["1mcy",1.7,2.57705759451141],
["1dti",1.7,2.50630718023828],
["1mym",1.7,2.70119862759571],
["2spm",1.7,2.64813617396078],
["1tes",1.7,2.68442406700083],
["1mtj",1.7,2.77626958003792],
["1mll",1.7,2.72356119533848],
["2spo",1.7,2.54951460321192],
["1mls",1.7,2.86715046066817],
["2spl",1.7,2.66992574699574],
["2mge",1.7,2.75972160605069],
["2spn",1.7,2.75243432577829],
["1bgc",1.7,2.45180431085252],
["1mxi",1.7,2.34424268720333],
["1dsz",1.7,2.01628419328455],
["1vhh",1.7,2.45776829850065],
["1znl",1.7,2.8616043525997],
["1qy1",1.7,2.63724887202575],
["1clu",1.7,2.17551930046983],
["1h0a",1.7,2.1494357632007],
["2d3g",1.7,1.68934326791253],
["1df7",1.7,2.26482453458180],
["1jvw",1.7,1.87544503952220],
["1hfs",1.7,1.46455545824922],
["1qst",1.7,3.01124656552795],
["2g40",1.7,1.19363595210687],
["1urm",1.7,1.66986301368841],
["1asu",1.7,3.29398130599089],
["1l74",1.7,2.08832517177257],
["1l36",1.7,2.13207520559266],
["1l68",1.7,1.87134839524582],
["161l",1.7,1.86946213908383],
["1l83",1.7,2.12077705810547],
["1l65",1.7,2.09083507163718],
["1lyh",1.7,1.99418416211371],
["1l66",1.7,1.99489020282895],
["241l",1.7,2.06790442748552],
["244l",1.7,2.14272275073945],
["130l",1.7,1.52274229095493],
["217l",1.7,1.80710355256433],
["1l92",1.7,1.86889512878731],
["1l62",1.7,1.84960948383175],
["110l",1.7,1.94707069109297],
["1g07",1.7,2.06005145871057],
["131l",1.7,2.11832379164696],
["128l",1.7,1.84888397989251],
["1kni",1.7,2.49658289674692],
["1g0m",1.7,2.07520112519559],
["1lwg",1.7,2.58805379831732],
["4lzm",1.7,1.98308630694001],
["129l",1.7,2.15841199879398],
["138l",1.7,1.97640151545039],
["221l",1.7,2.06267362569314],
["139l",1.7,2.07482887505301],
["1d9w",1.7,2.32684484711922],
["173l",1.7,2.3620637425756],
["3dfr",1.7,2.4181090304742],
["237l",1.7,1.98466350066662],
["1l33",1.7,2.32030341472575],
["1l22",1.7,2.35197271248531],
["1l08",1.7,2.58906603760123],
["1l02",1.7,2.64414037310492],
["1l01",1.7,2.67063107542213],
["1l23",1.7,2.27246357932366],
["1l19",1.7,2.30421967925389],
["3lzm",1.7,2.30421967925389],
["1l60",1.7,2.37055767894847],
["1l32",1.7,2.28488384156137],
["1l46",1.7,2.16779106760773],
["1l30",1.7,2.29491565941728],
["1l47",1.7,2.22332293742254],
["1l17",1.7,2.30699019122379],
["1l12",1.7,2.56188577406154],
["1l26",1.7,2.55509604307279],
["1l15",1.7,2.58708617144143],
["1l05",1.7,2.57254697685095],
["1l14",1.7,2.60256428120736],
["1l45",1.7,2.32854437946754],
["1l44",1.7,2.29404869875816],
["1l52",1.7,2.39803177808965],
["1l09",1.7,2.60125372426864],
["2lzm",1.7,2.60175815851452],
["1l06",1.7,2.62633385374181],
["1l04",1.7,2.62682689659219],
["1l03",1.7,2.39836040661184],
["1l11",1.7,2.63391258735234],
["1l07",1.7,2.61953085885497],
["1l10",1.7,2.64978985635085],
["1l29",1.7,2.6353639834866],
["1l13",1.7,2.64325940558751],
["1l18",1.7,2.18169878012902],
["1l16",1.7,2.56736228794619],
["1l48",1.7,2.30204905089468],
["1l24",1.7,2.37580880078776],
["1w8v",1.7,1.97032884560464],
["1bzs",1.7,2.06620742501692],
["1xj0",1.7,2.06109690447453],
["1wkc",1.7,2.15100527121878],
["1lf0",1.7,1.64058897063828],
["1lf5",1.7,2.21748477594242],
["1zd9",1.7,1.67321985383824],
["1y63",1.7,1.54645267395285],
["1yck",1.7,2.80290108458583],
["1nqz",1.7,2.55345273545469],
["1kao",1.7,2.10083790040816],
["1oix",1.7,2.26378589836263],
["1ymd",1.7,1.32475856990509],
["1yml",1.7,1.71650105943690],
["1czn",1.7,1.13654739134884],
["1ymk",1.7,1.69477943024974],
["1f5f",1.7,2.77709212693112],
["1r03",1.7,1.54389231337103],
["2fck",1.7,2.4786174307751],
["1j54",1.7,1.41560026985231],
["1jyd",1.7,2.66323010040026],
["1ng2",1.7,2.17542434888547],
["1fzq",1.7,2.33289657618973],
["1hbq",1.7,2.87611566335682],
["1kdk",1.7,3.04407466323825],
["2fd5",1.7,2.00905655908103],
["1wnz",1.7,2.60624122206404],
["1eiz",1.7,1.82529868779795],
["1sl8",1.7,1.47857130941409],
["1ytq",1.7,1.64749544386684],
["2c2q",1.7,2.1121930013985],
["1ay7",1.7,1.93542704090867],
["1q2h",1.7,1.54165694843793],
["1ryb",1.7,2.23567839365205],
["1ido",1.7,2.61969235861993],
["1kso",1.7,1.95529108747862],
["1xxn",1.7,2.19408421206157],
["1knb",1.7,2.69867512176832],
["1mol",1.7,2.15405926545244],
["8dfr",1.7,2.93210880104783],
["2f8o",1.7,1.22367436495763],
["2gen",1.7,1.84980009452984],
["1txl",1.7,2.65756771748924],
["1hz6",1.7,1.39403624358666],
["1i9t",1.7,1.72568383503371],
["1i70",1.7,1.43169513084408],
["1gmp",1.7,1.73907974775040],
["2aia",1.7,2.01526571180943],
["2aie",1.7,1.98407507019185],
["1kid",1.7,1.76720782623057],
["1t56",1.7,1.92693596308050],
["1juv",1.7,2.12629018297149],
["1qoa",1.7,1.86830901765704],
["1z4m",1.7,1.83473748687305],
["1qf9",1.7,2.37723720503043],
["1iue",1.7,2.20272963269182],
["1r1t",1.7,1.78494449809646],
["1nkr",1.7,2.52622718872647],
["1r8m",1.7,1.87314324517333],
["1dif",1.7,1.50453554969636],
["2bbb",1.7,1.92343742567277],
["1ida",1.7,2.64931672888687],
["2alp",1.7,2.04893027036709],
["1upi",1.7,2.27328446048823],
["1ffi",1.7,1.49645939260372],
["1z3q",1.7,1.28383816013141],
["1sgw",1.7,0.979593389877052],
["1k2b",1.7,2.17803732671801],
["2et7",1.7,1.89800311779873],
["1e2g",1.7,1.80894634107331],
["1yqh",1.7,1.26369476143796],
["1e9b",1.7,1.72814626579436],
["1e2q",1.7,1.86158689167030],
["1nmx",1.7,1.6678678938437],
["1e9d",1.7,1.778087539733],
["1yc1",1.7,2.52578204238457],
["1azo",1.7,2.50636306881576],
["1xsv",1.7,1.69196695842661],
["1cvz",1.7,1.68877343728259],
["1pg6",1.7,2.16089552239314],
["1j02",1.7,1.90429701626699],
["1wab",1.7,2.74573790974820],
["3bc2",1.7,2.86408127726989],
["1emv",1.7,2.06689220866586],
["1orn",1.7,1.7923115392032],
["1pip",1.7,2.77821893776523],
["1yal",1.7,2.08442486094705],
["1bww",1.7,2.29345133889612],
["1dae",1.7,1.73950465376198],
["1b4p",1.7,2.85873939628745],
["1mz9",1.7,2.79480793089538],
["2act",1.7,1.89410360083725],
["2a6b",1.7,1.0556123170877],
["1f50",1.7,2.62505998111845],
["1pbt",1.7,1.93286887362780],
["1p3q",1.7,2.83937001957995],
["1igq",1.7,2.08161461143313],
["1rdl",1.7,1.57129524278464],
["1rdo",1.7,1.63102716989453],
["1n5s",1.7,2.00704129734366],
["1utl",1.7,1.65600411789280],
["2awm",1.7,2.08602081209009],
["1sgt",1.7,1.67670123951182],
["1y3x",1.7,1.80224455183280],
["1s81",1.7,1.46640576189747],
["1tpo",1.7,1.76834452679585],
["1c2f",1.7,2.11784520191595],
["1o36",1.7,1.96489772436162],
["1tx8",1.7,1.52423337287312],
["3ptb",1.7,2.27201158366907],
["3ptn",1.7,2.26959609589559],
["2tgt",1.7,2.42622411785032],
["1tgt",1.7,2.5080275522238],
["1rxp",1.7,2.05827370286050],
["1v2r",1.7,1.97334483485668],
["2b77",1.7,1.83714831810221],
["2msb",1.7,1.79365825395299],
["1daf",1.7,1.51073554806805],
["1h4w",1.7,1.65603448351903],
["1kqj",1.7,1.31234120130413],
["1x8g",1.7,1.56077079908318],
["1osy",1.7,2.28439749794463],
["1mfa",1.7,1.83042208428137],
["2f6r",1.7,1.96994675380067],
["1j1y",1.7,1.42345733166795],
["1y1d",1.7,2.14524021326580],
["1ijn",1.7,1.71691305186153],
["1o1y",1.7,1.25854830528027],
["2axc",1.7,1.51015362671999],
["1zj4",1.7,1.92912666016426],
["1zj5",1.7,1.95662623258468],
["1ds2",1.7,1.90498664206609],
["1tmi",1.7,2.30964146856393],
["2bka",1.7,1.66357728927338],
["1n6a",1.7,2.26357170800636],
["1zic",1.7,1.84425514271218],
["1zi6",1.7,1.84727687460688],
["2bjv",1.7,1.41480725840998],
["1etb",1.7,2.06896794913022],
["1z3y",1.7,1.13174753832513],
["1p28",1.7,1.88439002357741],
["1spj",1.7,1.40836951530368],
["1wxj",1.7,1.81312238197605],
["2d2e",1.7,1.96365017922568],
["1b2p",1.7,2.40984980704671],
["2ax8",1.7,2.01342727990964],
["1dq0",1.7,1.62477901150062],
["1bec",1.7,2.78954110634679],
["1ecs",1.7,2.49857949781397],
["1y52",1.7,1.84897933487882],
["2br6",1.7,1.94797383329671],
["1gz9",1.7,1.84385905121442],
["1rxk",1.7,1.97862009273888],
["1hay",1.7,1.75185513171389],
["1qgf",1.7,1.50706550184983],
["1hv7",1.7,1.39984539034006],
["1lka",1.7,1.54888241033028],
["1lkb",1.7,1.60904174511478],
["1e38",1.7,1.58518319234135],
["1e36",1.7,1.78668588141012],
["1elf",1.7,2.06292705418416],
["1fv0",1.7,1.93408758256136],
["1y4l",1.7,2.77842673825593],
["1vr9",1.7,1.6777959875951],
["1t1j",1.7,1.46292765829979],
["1n0w",1.7,1.39840643281005],
["1fdr",1.7,1.88565143869105],
["1u9d",1.7,2.44957079427130],
["1f5w",1.7,1.76016521814125],
["3lyn",1.7,2.59971063312199],
["1xp6",1.7,2.92630944928514],
["1afl",1.7,2.411284178058],
["1afk",1.7,2.10121327455759],
["1qhc",1.7,2.99197354615568],
["1v6t",1.7,1.92124384494469],
["1tcs",1.7,2.75063934237985],
["1gis",1.7,2.26985982874184],
["1uog",1.7,2.39867989643276],
["1h03",1.7,2.14032940764339],
["1zki",1.7,1.30661791558761],
["1m2g",1.7,2.16030053820237],
["1m2j",1.7,2.52312152336941],
["1vcd",1.7,1.68701300008037],
["1fa8",1.7,1.95527639036158],
["1eta",1.7,3.16155711315852],
["1zps",1.7,1.72643100452921],
["1v9f",1.7,2.14409573977477],
["1t7t",1.7,1.42064208951684],
["1zs9",1.7,2.10527865823499],
["1tsh",1.7,2.78641130054108],
["1tta",1.7,2.93078513894671],
["1ttc",1.7,3.48547938853661],
["1ttb",1.7,2.63918563917662],
["1eye",1.7,2.78303741806819],
["1lpd",1.7,2.11380925626932],
["1yns",1.7,2.90587236958101],
["1lpc",1.7,1.91173418935870],
["1p99",1.7,1.97223013869488],
["1vdp",1.7,2.35964056639282],
["1m33",1.7,2.09384590714560],
["1mua",1.7,2.40633487728695],
["1sck",1.7,1.6789004313852],
["2a14",1.7,1.14129373319071],
["1cam",1.7,1.89538647551078],
["1yo1",1.7,1.78074241744463],
["2bb7",1.7,1.77234135945781],
["2f5g",1.7,2.5202081770658],
["2evm",1.7,2.18392785252394],
["1ev5",1.7,1.98173637305239],
["1c24",1.7,2.27014785398735],
["1erm",1.7,2.30642115364778],
["1fqg",1.7,2.55215399252573],
["1vp6",1.7,2.06570158568321],
["1y7r",1.7,2.47027266031089],
["1gzw",1.7,1.97099134222567],
["2aio",1.7,2.04001375831673],
["1sml",1.7,2.48534570219172],
["1cg6",1.7,1.36654535867604],
["1cb0",1.7,1.38771055736752],
["2fy7",1.7,2.04431767392692],
["1p9a",1.7,2.40818759602355],
["1fy8",1.7,2.03088414883700],
["1uek",1.7,2.14713684254990],
["1urx",1.7,1.50358699038287],
["2ai3",1.7,2.18146840477528],
["1ako",1.7,1.95419985585683],
["3tgk",1.7,1.98943577674366],
["1ia8",1.7,3.00211500018875],
["3lck",1.7,1.65023667732922],
["1ub4",1.7,2.12077090609987],
["1zxt",1.7,2.09869301528379],
["1jye",1.7,2.05602253745283],
["1uk7",1.7,1.36402771754997],
["1uka",1.7,1.51934435651820],
["2ev6",1.7,2.22997497088768],
["2ai2",1.7,1.90513113107663],
["1sc0",1.7,2.07932326405306],
["1o0i",1.7,2.39444635778931],
["1uar",1.7,1.84911845061552],
["2a88",1.7,1.59210523068941],
["1s01",1.7,1.18676817727668],
["2a7x",1.7,1.49301202775222],
["1j30",1.7,1.80439791635646],
["1uu3",1.7,1.31904022607902],
["2a5s",1.7,2.1668699460066],
["1f2o",1.7,1.52954605800806],
["1u1v",1.7,1.33630073841920],
["1uob",1.7,2.42496354137057],
["1jy0",1.7,2.21367064019786],
["1aqz",1.7,2.68812715549825],
["1fds",1.7,2.10437002522179],
["2axy",1.7,1.90779647311913],
["1mjh",1.7,1.46646081097306],
["1m16",1.7,2.29572787877926],
["2aq6",1.7,1.93037747087808],
["2bjn",1.7,2.52774369013345],
["1nrw",1.7,1.89706242618019],
["1yrw",1.7,1.54979358843484],
["1lgt",1.7,1.62286091389047],
["1aoh",1.7,1.84395522125486],
["2hbi",1.7,1.47556550302034],
["2av3",1.7,1.70181551717262],
["1hbi",1.7,1.90741187614238],
["1yoc",1.7,2.05846052158798],
["1i3d",1.7,2.09223112806465],
["1jm0",1.7,2.47912337667685],
["1ks9",1.7,2.00702487054733],
["2eun",1.7,1.78401175683908],
["1vfj",1.7,2.09188769455208],
["2cyp",1.7,2.17817559678252],
["1yi9",1.7,2.85272150737992],
["1lf1",1.7,2.37694568079200],
["1kok",1.7,1.61006523307574],
["1go2",1.7,1.93466470061416],
["1qgy",1.7,2.10413315820874],
["1elv",1.7,1.77528322226863],
["1fnb",1.7,2.49252005580011],
["1fnd",1.7,2.24194578095187],
["1x2r",1.7,2.37953394567729],
["2f6v",1.7,1.85537700249521],
["2f6z",1.7,1.90046730714031],
["2f6t",1.7,1.74093561954305],
["1wdv",1.7,1.53426168799453],
["1izc",1.7,1.86741537436235],
["1e9p",1.7,1.72727151035857],
["1doj",1.7,2.86245476562959],
["1xfs",1.7,2.07093556405789],
["1e0v",1.7,1.18264298409313],
["1gor",1.7,1.75313681403408],
["1mwc",1.7,1.76983898846275],
["1f9u",1.7,2.87986129970807],
["1abe",1.7,2.23579678669969],
["1xiv",1.7,1.32292805854633],
["1ee3",1.7,1.54842215075037],
["1jb9",1.7,2.32160812818839],
["1nty",1.7,1.60490919399051],
["1h58",1.7,1.54153710809810],
["1ltm",1.7,1.75550346295641],
["1u4o",1.7,1.41159463242733],
["1j8t",1.7,1.88791255218055],
["1q9e",1.7,1.86243441942775],
["1dde",1.7,2.09740406798884],
["1gwt",1.7,1.51170670267786],
["1gca",1.7,1.65144821077429],
["2bw0",1.7,1.96670593113904],
["1sbp",1.7,1.98965172851797],
["1qus",1.7,1.43542218746976],
["1zs4",1.7,2.10792276814937],
["1mk4",1.7,2.25674507568824],
["1ogq",1.7,2.45289766640881],
["1qge",1.7,1.75174794092601],
["2f2t",1.7,1.08481644253644],
["2ffc",1.7,1.92993885338677],
["1t24",1.7,1.77464768162465],
["1ysb",1.7,1.81811049432816],
["1s2a",1.7,1.53176401641165],
["1frb",1.7,2.08112005303637],
["2b5g",1.7,2.27136399441055],
["1fjq",1.7,1.77506468941724],
["1ks7",1.7,1.49154097657527],
["1hyt",1.7,2.01388281149091],
["1kro",1.7,1.5783762005434],
["1zdp",1.7,2.53105341328831],
["1z9g",1.7,2.57334184137685],
["1pe5",1.7,2.27413255650438],
["2fqx",1.7,2.15543790074217],
["4tmn",1.7,2.47017516681003],
["1thl",1.7,2.51893045449748],
["1lnd",1.7,2.06328692288541],
["1lnf",1.7,2.12978137796997],
["1lne",1.7,2.19286836844663],
["3tmn",1.7,2.46492683190278],
["4dfr",1.7,2.65215713629943],
["1zd7",1.7,1.85356380370627],
["2fa1",1.7,2.46556588507071],
["1el3",1.7,2.32285918402108],
["1jw9",1.7,2.01811678053843],
["1syy",1.7,1.94010060021694],
["2d80",1.7,1.68667007745655],
["1v71",1.7,2.27325427542597],
["1p5v",1.7,2.09036963491581],
["2abh",1.7,1.98657290739185],
["1qul",1.7,1.93005113751550],
["1a40",1.7,2.1822276901485],
["1ti7",1.7,1.75409235296743],
["1b20",1.7,1.69483287041862],
["1i7h",1.7,2.01419315193336],
["1o6k",1.7,1.52696242306311],
["1ppm",1.7,1.72647857057944],
["1ppl",1.7,1.96408135423259],
["1yle",1.7,1.74301988779389],
["1w9q",1.7,1.77207798189087],
["2c7p",1.7,1.69743187682493],
["1m2r",1.7,2.13701890454376],
["2f6l",1.7,1.51589870045045],
["1k94",1.7,1.52499162790966],
["1nrj",1.7,1.9512082613482],
["1v9t",1.7,2.65888756514871],
["1z57",1.7,1.25744910001242],
["2ery",1.7,1.32764364454764],
["1mxe",1.7,1.93381959728951],
["1xuc",1.7,1.79475805665536],
["1ne9",1.7,1.75835275823367],
["2a5l",1.7,1.90729124991236],
["2gc9",1.7,1.43169665686038],
["1d1i",1.7,1.30264385442556],
["1et7",1.7,1.84806881033119],
["1xfi",1.7,1.92548921446758],
["1l4b",1.7,2.10019310621723],
["1jx4",1.7,2.39567543353104],
["1dgw",1.7,3.11981076569682],
["1tm4",1.7,1.49244215882564],
["1tm1",1.7,1.34368447065010],
["1llp",1.7,1.81867811786034],
["1z15",1.7,2.01495786664893],
["2bky",1.7,2.20835124500337],
["1uac",1.7,3.20468636216663],
["1f6b",1.7,2.49242090669897],
["1ppv",1.7,2.35621215777595],
["1oio",1.7,2.19174630321961],
["1t6e",1.7,1.96267848867118],
["1r3t",1.7,1.70811550144614],
["1r3w",1.7,1.71436140295201],
["1r3q",1.7,1.62883169621428],
["2aso",1.7,1.69041493905409],
["1j83",1.7,1.71798708813507],
["1qcx",1.7,2.05219524659360],
["1mdo",1.7,2.03494626183257],
["1pxg",1.7,1.95146598274020],
["1vlo",1.7,1.15211834057550],
["1oc5",1.7,1.42107783431267],
["1jq5",1.7,1.52712806882602],
["1p0b",1.7,2.24061246198617],
["1wk8",1.7,2.64916688400957],
["1qd9",1.7,1.96600234611403],
["1u17",1.7,2.48365666253405],
["1h6f",1.7,2.22571009197419],
["4mbp",1.7,3.07579012832668],
["3mbp",1.7,3.01015486219356],
["1lfk",1.7,1.88104686565311],
["1pe0",1.7,1.90839635956092],
["1k4g",1.7,2.28670806672613],
["1fvk",1.7,1.96328223101694],
["1gvy",1.7,1.41104642853245],
["1flt",1.7,2.48943210502898],
["1vjo",1.7,1.82980909579073],
["2b8l",1.7,1.77949533626429],
["1fzk",1.7,1.71934810242996],
["1hpm",1.7,1.60158972060377],
["1kay",1.7,1.63242020403296],
["2bup",1.7,1.52281571231514],
["1bup",1.7,1.49123516389481],
["1ba1",1.7,1.79780758801490],
["1kax",1.7,1.73240276958042],
["1kaz",1.7,1.68830429363354],
["1n2r",1.7,1.99538498244156],
["1syv",1.7,2.04646896493620],
["1rvk",1.7,2.42920092473691],
["1hjz",1.7,1.51332007045728],
["1vjp",1.7,1.82249769200589],
["1zsd",1.7,1.77671019193616],
["1ia1",1.7,2.24460869186631],
["1m79",1.7,2.00740338271143],
["2ccj",1.7,1.68780030716004],
["1xii",1.7,1.79615737640913],
["1xij",1.7,1.98565595338005],
["1xig",1.7,2.1197779704374],
["1xih",1.7,2.12387374752635],
["2bnm",1.7,1.70824780420401],
["1xid",1.7,2.06784586503785],
["1xie",1.7,2.32435173531610],
["1cgz",1.7,2.16210903178260],
["2qwa",1.7,2.05368125026247],
["1f8c",1.7,2.31733591785316],
["1mwe",1.7,2.25673590411334],
["1pm9",1.7,2.03948998976178],
["1d02",1.7,1.72875905372410],
["2as9",1.7,2.44151066556107],
["1jhd",1.7,1.60878568160869],
["1xi3",1.7,1.12860483791128],
["1jne",1.7,2.39782865847624],
["1fva",1.7,3.01272558721671],
["1ehg",1.7,1.60499178499749],
["1cmn",1.7,1.96145357619631],
["1ehe",1.7,1.97759686402347],
["1cl6",1.7,1.98796904710506],
["1cmj",1.7,2.00206215105739],
["1ehf",1.7,2.00404546948838],
["1exm",1.7,2.07544199218085],
["2fer",1.7,1.83599846478208],
["1yrd",1.7,2.05006718464309],
["1gek",1.7,2.72782418303287],
["1pb3",1.7,2.29342887970224],
["1pb1",1.7,2.27623447183376],
["1eyn",1.7,1.7140956935064],
["2uag",1.7,1.48999940967093],
["1u5d",1.7,2.20973863762313],
["1csc",1.7,3.04912742135263],
["2csc",1.7,3.18607176446883],
["1rzf",1.7,1.64978392200731],
["1zan",1.7,2.32400579175449],
["1so4",1.7,1.52454097699242],
["1m6d",1.7,2.173811745748],
["2bc2",1.7,2.05780424592861],
["1mi4",1.7,1.66203824193272],
["1icr",1.7,1.61843449205631],
["1z3t",1.7,1.31437696707079],
["1z3w",1.7,1.65654755026434],
["1ylr",1.7,1.28075105743429],
["1tuo",1.7,2.32661433681492],
["2ajs",1.7,2.15196556106045],
["6cel",1.7,1.40110806295762],
["1q72",1.7,1.98786805792363],
["1css",1.7,2.62815321154727],
["1csi",1.7,2.67519105591709],
["1csr",1.7,2.79855194926344],
["2aef",1.7,2.30993842299147],
["2avd",1.7,1.83041285153748],
["1pvy",1.7,2.47648096317033],
["1ynl",1.7,2.22779409005566],
["1zhw",1.7,1.72073464445395],
["1wpv",1.7,2.39258849186564],
["1d2i",1.7,2.26350587182876],
["2bwv",1.7,1.12487245040519],
["2bwx",1.7,1.05978315394676],
["1pmi",1.7,2.57153568343921],
["1eq9",1.7,2.43846695333573],
["1swh",1.7,2.79013861277055],
["1kyt",1.7,2.07943656806432],
["1fj0",1.7,1.25388763163479],
["1g4s",1.7,1.72819969288938],
["1xkp",1.7,1.92473141551015],
["2ltn",1.7,2.5516411164994],
["1cjc",1.7,1.95776105649919],
["1v58",1.7,1.61130123867763],
["1ewf",1.7,2.83605324773572],
["1nbx",1.7,2.51290731130254],
["1gsn",1.7,2.05176423511934],
["1l2q",1.7,1.78309746967394],
["2a52",1.7,2.28110091743672],
["2hlc",1.7,1.89140241253219],
["1n4x",1.7,2.56012494974192],
["1dnc",1.7,2.07153906236178],
["1fon",1.7,2.64510241261431],
["1n68",1.7,2.29240374635931],
["1twd",1.7,2.19409006950249],
["1e42",1.7,2.18805285035017],
["1vjs",1.7,2.44705845158076],
["1x7i",1.7,2.46813879479633],
["1nqm",1.7,2.33491035263861],
["1htw",1.7,3.08041024902019],
["1kl4",1.7,2.08444333990377],
["1gai",1.7,1.11098777044206],
["1w1o",1.7,1.36260805923536],
["1nms",1.7,1.83734179421617],
["1t6v",1.7,1.30877880464700],
["1qhf",1.7,1.82767342007842],
["1ukg",1.7,1.58935804011881],
["1ofl",1.7,1.89183098867092],
["1dbo",1.7,2.32448823824399],
["1dbg",1.7,2.41914180670926],
["1agj",1.7,2.61204064789568],
["1e43",1.7,1.83229445623863],
["1v10",1.7,3.60000587117935],
["1qq7",1.7,1.74604789407165],
["1v0v",1.7,1.71788446781417],
["1v0r",1.7,1.71325291502149],
["1kl3",1.7,2.20830713495376],
["1f0v",1.7,2.42084155085857],
["1lj8",1.7,1.50791483351163],
["1ayx",1.7,1.84017278892295],
["2ai8",1.7,1.46025841787151],
["1ohs",1.7,2.20516999868499],
["1rxy",1.7,1.28691470848706],
["1w9b",1.7,1.7326961732705],
["1mgq",1.7,2.14648460419807],
["1mo0",1.7,1.72583683400489],
["1r12",1.7,1.90388559732389],
["1gsk",1.7,1.88554187552772],
["2ddf",1.7,1.62827139551194],
["1kzq",1.7,2.22192763483929],
["1txn",1.7,2.30203582461199],
["1lt5",1.7,2.33464166102853],
["1eqj",1.7,2.90058805564022],
["1i2s",1.7,2.68061716741737],
["1gkj",1.7,2.48695780977241],
["1i2w",1.7,2.83762059824892],
["1oa8",1.7,2.14868475418721],
["1hqq",1.7,1.82141420051618],
["1xng",1.7,1.82160990852364],
["1hp1",1.7,1.57376778522513],
["2evo",1.7,2.06561460374858],
["1ymx",1.7,1.59163348037999],
["1ylh",1.7,1.50686795999143],
["1axw",1.7,1.70806775442517],
["1gx5",1.7,2.14163992306018],
["1deu",1.7,2.28755954249470],
["2cxx",1.7,1.99445787662021],
["1w4x",1.7,1.72109534874212],
["1pfv",1.7,1.78559573713942],
["1yqv",1.7,1.60236897535941],
["1wmz",1.7,1.26739113530319],
["1bkp",1.7,2.13853178182551],
["2g0w",1.7,1.52959973524151],
["1jtc",1.7,2.46295661634378],
["1s5a",1.7,1.94434238266488],
["2fex",1.7,1.65808911714053],
["1jt7",1.7,2.32725303286363],
["1t82",1.7,1.94960416307112],
["1iho",1.7,1.84187426176296],
["1n2b",1.7,1.48986773577525],
["1qxm",1.7,1.85499127985560],
["2d60",1.7,1.92535616758360],
["1j7y",1.7,1.83218457705171],
["1qsi",1.7,2.03738598055570],
["1qsh",1.7,2.11130102270921],
["1bbb",1.7,2.5759937026139],
["1n2i",1.7,1.41294316877845],
["1g3m",1.7,1.99042369736135],
["1ta3",1.7,1.62517321801666],
["1v4w",1.7,2.31349704609186],
["1t8o",1.7,1.3433955132003],
["1nk0",1.7,1.59051612129074],
["1l3t",1.7,1.91201834611802],
["1xwl",1.7,2.41564867951907],
["1bf6",1.7,1.91734399606057],
["1ugw",1.7,1.79346147585108],
["2g76",1.7,1.37737525162329],
["1w8o",1.7,1.47252745361029],
["1qfz",1.7,2.40850428582444],
["1erz",1.7,1.76705494167511],
["2biv",1.7,1.69912797634974],
["1nr0",1.7,1.83854384056247],
["1e2k",1.7,2.27843704942023],
["1d3v",1.7,2.20814522423965],
["1zgd",1.7,2.09879330721366],
["1dmh",1.7,2.35036180938310],
["1sii",1.7,1.46459879328379],
["1wnw",1.7,2.07758183780778],
["1jqx",1.7,2.02051004237689],
["1xcr",1.7,1.60460214492539],
["1fd4",1.7,3.08536517680400],
["1s18",1.7,1.75840325811561],
["1odt",1.7,2.22014128711106],
["2etv",1.7,1.70916910677579],
["2ags",1.7,2.06354647506544],
["1gof",1.7,2.24328183684937],
["1o7g",1.7,2.22404126686695],
["1k7x",1.7,2.20663232643739],
["1qd1",1.7,1.69709188124643],
["1l6s",1.7,2.34085245062718],
["1k0r",1.7,2.48452197443066],
["1k8z",1.7,2.91086896695727],
["1w56",1.7,1.76611972658301],
["1y2d",1.7,1.16211520067943],
["1ydy",1.7,2.18350851235178],
["1xdh",1.7,2.31580091373350],
["4pga",1.7,2.46767955717751],
["1k3u",1.7,1.72413747023895],
["1obf",1.7,1.31680966952257],
["2cwh",1.7,1.81115698616619],
["1txg",1.7,1.83303090691824],
["1k9d",1.7,1.55745714048517],
["1r6v",1.7,2.49438335611503],
["1j79",1.7,3.09481083601475],
["1xik",1.7,2.75804663083559],
["1qho",1.7,1.38926644656619],
["1qhp",1.7,1.39743833763883],
["1pxz",1.7,2.70128372838952],
["1rxq",1.7,1.99138752891345],
["2bcn",1.7,3.03086294050359],
["1wy2",1.7,1.95825429203807],
["1e5t",1.7,1.34712377933418],
["2bvw",1.7,1.96108510165734],
["1vg8",1.7,1.77821354679298],
["1c82",1.7,2.73076819154549],
["2c5e",1.7,1.76851310365736],
["1gu7",1.7,1.64771251287539],
["1wo8",1.7,2.05070445561266],
["1zy7",1.7,1.93784608708084],
["1jd1",1.7,2.24182970780282],
["1sg6",1.7,2.28391388061404],
["1ftm",1.7,1.94260443286599],
["1nsc",1.7,2.08087065169726],
["1iyh",1.7,1.81937921569061],
["1w9p",1.7,1.42338291707333],
["1t2b",1.7,2.28129009222432],
["2ahj",1.7,1.73136649500223],
["2feu",1.7,2.03936121456944],
["2bnq",1.7,2.37168758750701],
["1ut1",1.7,2.53531157776403],
["2bii",1.7,1.84476535842992],
["1g24",1.7,2.48549427126886],
["1yum",1.7,3.21634585381389],
["1rff",1.7,2.23348794303174],
["5rub",1.7,3.19993982160044],
["1yki",1.7,1.42053275834610],
["1vcl",1.7,1.28761248490263],
["1oa3",1.7,1.86264865851989],
["1upt",1.7,1.82099176573466],
["1a0j",1.7,1.91243325917429],
["1km0",1.7,1.61917855963606],
["1pby",1.7,2.58927103737982],
["1j8f",1.7,2.74724109882147],
["1p3d",1.7,1.695232266666],
["1ooy",1.7,2.20526498855470],
["1zpe",1.7,2.16109513150165],
["2fzv",1.7,1.81463449933438],
["1tad",1.7,2.15757457706364],
["1k56",1.7,2.21515746143429],
["1v00",1.7,2.07593650730056],
["1k54",1.7,1.84822257710164],
["1fec",1.7,2.26531626408259],
["1e6w",1.7,2.49949582221809],
["1z0s",1.7,1.91681836379626],
["1oja",1.7,1.63440432616626],
["2c65",1.7,1.55187791300058],
["2c67",1.7,1.69798950860233],
["1o6i",1.7,1.94706861705283],
["1e6p",1.7,1.99882692924625],
["1duv",1.7,2.19797086092071],
["1l9o",1.7,1.85773961545744],
["1l9q",1.7,1.94282601495564],
["1xe0",1.7,2.60482771565773],
["1s5u",1.7,2.26445053364523],
["1f3u",1.7,2.74260503485578],
["1p1j",1.7,2.07963093324821],
["1gco",1.7,1.83575044169418],
["1i19",1.7,1.64160541266985],
["2dbx",1.7,1.89428864017792],
["1d4a",1.7,2.79183357350745],
["1q74",1.7,1.21650820722351],
["1g0o",1.7,1.55949237242146],
["1q8a",1.7,2.45410048143749],
["1u0g",1.7,1.98391864365579],
["1lvw",1.7,1.95634421855962],
["1w3i",1.7,2.02511756335264],
["1ftr",1.7,1.85627911063487],
["1a12",1.7,2.27202222658600],
["1m9x",1.7,2.43611293566584],
["1ga2",1.7,1.90170686108024],
["1q8f",1.7,1.73864432996252],
["1jsl",1.7,1.93388691273752],
["1jsr",1.7,1.74705726488464],
["1gqg",1.7,1.64643499940347],
["1w27",1.7,2.54650909446610],
["2c5q",1.7,1.99500360437628],
["1gc0",1.7,2.29286232051154],
["1mwv",1.7,1.72938649386931],
["1pu0",1.7,2.07733947219843],
["1xes",1.7,1.83836964214544],
["2al4",1.7,1.85938743698707],
["1m3k",1.7,2.52886593044296],
["2fjb",1.7,1.99684852534777],
["2byw",1.7,2.07370178090084],
["1i7o",1.7,2.35596367242756],
["1gtt",1.7,2.02426766172573],
["1uqr",1.7,1.87561603007974],
["1eex",1.7,2.75031499857736],
["2cb2",1.7,1.62032720591183],
["1t0b",1.7,1.87097826236642],
["1qmv",1.7,1.61174934571466],
["1nhc",1.7,1.90809481133432],
["1geg",1.7,1.75751198182973],
["1mty",1.7,2.65729218826463],
["1zxi",1.7,1.90694047826447],
["1nvm",1.7,1.72872940397486],
["2c6q",1.7,1.65624903761971],
["1pn0",1.7,1.76164454341274],
["1dp0",1.7,2.26633040975143],
["1y81",1.7,1.93870738751102],
["2a9d",1.7,1.77058223759166],
["1xzo",1.7,3.35325268759063],
["2exr",1.7,1.42124839936747],
["1eoe",1.7,1.85170725118970],
["1yqc",1.71,2.75810479535169],
["1mid",1.71,1.83599013237286],
["1bm8",1.71,2.09482741157152],
["1sf9",1.71,1.87544673687865],
["1gyv",1.71,1.96006924858197],
["1kxx",1.71,2.02439811579071],
["104m",1.71,2.01697605767935],
["2bit",1.71,1.86533771990720],
["2biu",1.71,1.92237579512748],
["1g81",1.71,2.31212491773193],
["1d0q",1.71,2.67766863698957],
["1ywf",1.71,2.06195809943319],
["1ywn",1.71,1.41032937903256],
["1mlw",1.71,1.6970246952663],
["1gt1",1.71,2.22102710462062],
["2fqw",1.71,2.02168850203621],
["2ahk",1.71,2.13553770048878],
["1gwy",1.71,2.29570902662861],
["1kpv",1.71,1.6914748076968],
["1uxw",1.71,1.46766270581738],
["1m78",1.71,2.05428494991038],
["1dje",1.71,2.54935192563033],
["2xis",1.71,1.83023633992383],
["1uz4",1.71,1.31713507029936],
["1gxy",1.71,1.77982978885883],
["1jmk",1.71,2.4046989519236],
["1v0y",1.71,1.42633540607619],
["1sw0",1.71,2.19541476781391],
["1r88",1.71,1.57808891042482],
["1l3v",1.71,1.91580809448429],
["1o07",1.71,1.75225643101251],
["1s0a",1.71,2.15545300560342],
["1tw9",1.71,2.37731695719119],
["1z7a",1.71,1.86308270350880],
["1z8k",1.71,1.37178886262135],
["1tw6",1.71,1.41510540120795],
["1r1g",1.72,1.77477040273318],
["1lom",1.72,2.20586021123573],
["2fke",1.72,1.53056203585909],
["1fkd",1.72,1.36958579196815],
["1mkt",1.72,2.62094824091325],
["1cpq",1.72,1.68319194799266],
["1h87",1.72,1.44388168908639],
["1ey9",1.72,3.27109854131003],
["1ii3",1.72,3.04455860049942],
["1ziq",1.72,2.08864619095071],
["1v3z",1.72,1.67412572787981],
["1jf2",1.72,1.64508867096952],
["1meo",1.72,1.25485528660038],
["1qrg",1.72,1.95124009897560],
["1p3e",1.72,1.84343916851862],
["2a47",1.72,2.08611378846500],
["1v2s",1.72,1.70593055717635],
["1lys",1.72,2.83271866418528],
["2yas",1.72,1.54273986176119],
["2gdn",1.72,1.92178253762209],
["1tzx",1.72,2.17538394512516],
["1rwr",1.72,1.74898007070647],
["1bqb",1.72,2.11803982261002],
["1fh9",1.72,2.01648642881065],
["1i6l",1.72,2.18244192889636],
["1i6m",1.72,2.18906721529882],
["1i6k",1.72,2.30323776705259],
["1wa2",1.72,1.42232182397650],
["1y3f",1.72,1.63745308661512],
["1z16",1.72,2.32101741414616],
["1uqy",1.72,1.86198180549587],
["2b2f",1.72,2.45477691553057],
["1x2t",1.72,2.04203449242342],
["1nr4",1.72,2.34763274894283],
["1e1d",1.72,1.66241872909497],
["1m9e",1.72,2.47682658816189],
["2fds",1.72,2.04219652098086],
["1xon",1.72,1.45979898541015],
["1b5f",1.72,2.59498876554077],
["1ke4",1.72,1.76873273802823],
["1qip",1.72,1.86011890704128],
["1llb",1.72,1.70631899348826],
["1x7z",1.72,1.80755286775014],
["1qbi",1.72,2.11520244630132],
["2f5x",1.72,1.34990937525518],
["1b7d",1.73,2.41183480887636],
["3paz",1.73,2.79424428095382],
["2av4",1.73,2.09314368006199],
["1or3",1.73,2.58096617123159],
["1oaj",1.73,2.62329784060634],
["1yso",1.73,0.870385026211036],
["232l",1.73,2.44972813753673],
["1el4",1.73,1.7650945595162],
["1xl5",1.73,1.50380448171168],
["1zhr",1.73,2.17309429787909],
["1gjc",1.73,2.85256732060266],
["1m5d",1.73,1.77642169901991],
["1jvj",1.73,1.7501667018603],
["1y1e",1.73,1.26188798963425],
["2aik",1.73,1.47575098333780],
["1xjv",1.73,2.75997372445955],
["1gj5",1.73,2.59890226075332],
["1w34",1.73,2.17380960470015],
["1lii",1.73,3.22935355521195],
["1hg8",1.73,3.14637858562408],
["1c0l",1.73,2.41443403697033],
["2a9k",1.73,1.68715328212533],
["1xv5",1.73,2.17748588002418],
["1wmf",1.73,1.78184797709806],
["1ueh",1.73,1.98500922486019],
["1q9v",1.73,2.09574124149698],
["1ush",1.73,1.79461432849159],
["1fs5",1.73,2.62485727843735],
["1hl7",1.73,1.49461727861069],
["1hkh",1.73,1.65092607152609],
["1nqp",1.73,1.67076519517881],
["1m9f",1.73,2.01992885975882],
["1sih",1.73,1.47941852066689],
["2bt3",1.73,1.37483687143479],
["1b80",1.73,1.13845228246281],
["1x7w",1.73,1.87244495075271],
["2bi9",1.73,2.09285112136475],
["2bi5",1.73,2.19701860765813],
["1zru",1.73,2.01938983268043],
["1a2z",1.73,2.09885711503460],
["1vr5",1.73,1.27462578559507],
["2c31",1.73,2.18253614619476],
["2c62",1.74,2.04314580540863],
["1icn",1.74,2.30419578889407],
["1snm",1.74,3.30404462626546],
["1myt",1.74,2.60677749269381],
["1v8n",1.74,2.00921299014159],
["1im6",1.74,2.13004819852377],
["102l",1.74,2.17052080508636],
["1z4r",1.74,2.32529919548586],
["2fcb",1.74,2.29733963264726],
["1h4d",1.74,2.13461874337165],
["2etj",1.74,1.89025918388459],
["2ah5",1.74,1.65206341446589],
["1n5q",1.74,2.18420210514179],
["1kza",1.74,1.82570665612022],
["1jya",1.74,1.86389020773039],
["1ylw",1.74,1.87686337311153],
["1y2w",1.74,1.55952286330198],
["1ltu",1.74,2.32250037183391],
["3hhb",1.74,2.15828773546406],
["1kxm",1.74,2.27245812963925],
["1xvy",1.74,1.6779214134465],
["1ldg",1.74,2.07007716546411],
["1qf8",1.74,1.75299810542740],
["1vjv",1.74,1.38188832257329],
["1kfw",1.74,1.72868764664719],
["1q9t",1.74,2.45228160208919],
["1g94",1.74,1.51831370299077],
["1g60",1.74,2.04255429636570],
["1gwh",1.74,1.6147598678794],
["2f34",1.74,2.47039463673234],
["1zha",1.74,1.97702226281189],
["1xm8",1.74,1.51096553636999],
["1pe1",1.74,2.25141790034871],
["1pcf",1.74,1.57860980005193],
["2hhb",1.74,2.08702387378923],
["4hhb",1.74,3.92007455294165],
["1jiw",1.74,1.73893384389063],
["1px5",1.74,1.69844575190557],
["1q2o",1.74,1.85628734445316],
["1ajr",1.74,2.32237264526171],
["1ges",1.74,1.82442461076477],
["1r1n",1.74,3.20379281011932],
["1vjw",1.75,1.25854830528027],
["1k33",1.75,2.53305111947893],
["2spg",1.75,1.91530844216469],
["1kw4",1.75,1.34922769281048],
["1uj8",1.75,1.94926743221389],
["3hts",1.75,2.65139654033964],
["1okh",1.75,1.53148256512764],
["1j8b",1.75,2.62373601449986],
["1byp",1.75,2.55780615914987],
["1svy",1.75,2.16694844208423],
["1se0",1.75,2.54503314877373],
["1o4i",1.75,2.02006904829854],
["1f5c",1.75,2.49933118625052],
["1pvb",1.75,1.87620824131934],
["1o7s",1.75,2.0608378646247],
["1ikt",1.75,1.82877295183532],
["1gnu",1.75,1.97889320948031],
["1o3u",1.75,1.49081149764188],
["1rbe",1.75,2.03338757482002],
["1gsv",1.75,1.63699785597664],
["1f32",1.75,2.21887403587524],
["1vwp",1.75,2.40961312293419],
["1dyz",1.75,2.57010239963553],
["1dz0",1.75,2.57010239963553],
["1uih",1.75,1.32109392419143],
["1rfp",1.75,1.68209450577442],
["1iot",1.75,1.36514515245320],
["1hew",1.75,2.54508647029285],
["1yik",1.75,2.24289903956726],
["1lma",1.75,2.63435880869355],
["2ali",1.75,2.23157030980317],
["1mdc",1.75,1.64221419719220],
["1fe0",1.75,1.51972220221974],
["1vr8",1.75,0.930989043243292],
["1fe4",1.75,1.59591882318975],
["1ey8",1.75,3.12285444906433],
["1ey6",1.75,3.00972462753872],
["1bkb",1.75,2.16752827417608],
["5nll",1.75,2.06251693640045],
["2fk9",1.75,1.62965190037475],
["1r0u",1.75,1.89745794387152],
["1wk9",1.75,2.03731060116891],
["1k9u",1.75,1.98403096431183],
["1fuk",1.75,2.69782368184188],
["1xvq",1.75,1.83941503070484],
["1jv4",1.75,3.06610821556526],
["1qy2",1.75,2.62713441459892],
["1q42",1.75,2.05504906780103],
["1avs",1.75,2.86907586803085],
["1o9v",1.75,1.74704956175494],
["240l",1.75,1.62083487784104],
["166l",1.75,2.01164073235298],
["165l",1.75,2.20852454148908],
["1l90",1.75,2.03299151048484],
["1qud",1.75,2.20172301003185],
["1l59",1.75,1.78872332618200],
["1l63",1.75,1.9775764610704],
["1dyb",1.75,2.32656003069643],
["1kw5",1.75,2.30274511613399],
["206l",1.75,2.08667690585035],
["247l",1.75,2.16607584119586],
["1l41",1.75,2.29578957512691],
["1n0y",1.75,1.94523524590654],
["1ha1",1.75,2.7946342177899],
["1o9z",1.75,2.09638003492383],
["1xz1",1.75,1.87927241260580],
["1xz3",1.75,1.8877717746858],
["1g2p",1.75,1.88882141505340],
["1lhw",1.75,2.47511830753272],
["1wrd",1.75,2.05129926051284],
["1cv8",1.75,1.52319921246740],
["1xjt",1.75,2.56717017366886],
["1y0k",1.75,1.63514544907515],
["1ysq",1.75,1.60834059277256],
["1h0p",1.75,2.37095203616792],
["2c2p",1.75,1.92987120772494],
["1frw",1.75,2.24748374021879],
["1epz",1.75,2.02089586242694],
["1r8n",1.75,2.81145167647646],
["2atf",1.75,1.33064770716497],
["1wv3",1.75,1.7289013718937],
["1lm6",1.75,1.79276423129350],
["1s2z",1.75,2.05299442213891],
["1qyb",1.75,1.87116739559824],
["1bk7",1.75,2.25053600363006],
["1ym3",1.75,1.56774434651822],
["1d4l",1.75,1.90645901277762],
["1b6l",1.75,1.39432421174948],
["1ryn",1.75,3.51301713797626],
["1mtr",1.75,2.21004706604986],
["1z4k",1.75,1.67533238423587],
["1cub",1.75,1.83598104638097],
["1cuc",1.75,2.08631466126767],
["1xzm",1.75,1.82132219619056],
["1cuf",1.75,1.99840488704061],
["1cuh",1.75,2.08381650800076],
["1xzc",1.75,1.97584511070026],
["1ffc",1.75,1.67770921314045],
["1cug",1.75,1.77021504130567],
["1xze",1.75,2.22279872395517],
["1cux",1.75,1.88744034385022],
["1ffb",1.75,1.78238645567609],
["1xzb",1.75,2.12255696615588],
["1chd",1.75,2.10997417160837],
["1p3u",1.75,1.78529869526284],
["1r77",1.75,1.69974326122618],
["1xkr",1.75,2.39572835904553],
["1mix",1.75,1.63294741804646],
["2a7i",1.75,1.31733103134400],
["1thw",1.75,2.29343754462993],
["1thv",1.75,2.78008526709884],
["1kpt",1.75,1.79648648107014],
["1nmz",1.75,1.64736805486791],
["3cla",1.75,1.77743498653559],
["1ewp",1.75,2.07172404165534],
["1nn6",1.75,2.13717613741377],
["1nlr",1.75,1.97748016730352],
["1l2e",1.75,1.68243333578671],
["1y3y",1.75,1.96482007834098],
["1o3b",1.75,1.85258948028813],
["1tx7",1.75,2.45168177513192],
["1v2w",1.75,1.94888263436693],
["1qy5",1.75,2.44642372213376],
["1fhn",1.75,2.58368056051196],
["1udh",1.75,2.08381643584815],
["1udg",1.75,2.36803287474842],
["1wod",1.75,1.69670351706163],
["1amf",1.75,1.92139495307076],
["2br9",1.75,1.16104122542790],
["2sgf",1.75,2.06731030013526],
["1qwz",1.75,2.10686725432865],
["2a7a",1.75,1.80220685603907],
["1e37",1.75,1.93323414412801],
["1elc",1.75,2.30572443047884],
["2bjw",1.75,1.48790252493073],
["2fue",1.75,1.21618630815921],
["1d2n",1.75,1.78645242954993],
["1oag",1.75,1.97600430349619],
["1gi8",1.75,2.80810167905878],
["1e6f",1.75,2.50833662115693],
["1jjf",1.75,1.95561816559631],
["1c5x",1.75,2.8507664021721],
["1xfj",1.75,2.03175407482756],
["7yas",1.75,1.84813841138249],
["1gjd",1.75,2.22627971493437],
["2cx7",1.75,1.77361138809360],
["1lg5",1.75,2.46387101776271],
["1pv5",1.75,2.22222371360802],
["1c22",1.75,2.21759619144568],
["1wvj",1.75,1.79201990787800],
["1r7y",1.75,2.03091574846658],
["1jwp",1.75,1.70602919061692],
["1ny0",1.75,1.90061286197822],
["1zar",1.75,1.45934209235869],
["1f4b",1.75,1.76839732508810],
["1r81",1.75,2.34611635817149],
["1tvx",1.75,3.13819876311356],
["1dyt",1.75,2.45393871105832],
["1g6a",1.75,1.69172845358072],
["1xjo",1.75,1.90853549318042],
["1eg2",1.75,2.0546404387416],
["3bth",1.75,1.61284166486712],
["1umk",1.75,1.82196775963448],
["1bh6",1.75,1.74245523394986],
["1gqz",1.75,1.70917279090841],
["1a8q",1.75,1.5273266893303],
["1sub",1.75,1.4410792016674],
["1y21",1.75,1.98372057569225],
["1h8i",1.75,2.86320768404865],
["1ghw",1.75,2.56289442726014],
["1v96",1.75,2.31751005431456],
["1o5g",1.75,2.44707604921098],
["1suu",1.75,2.00056692503202],
["1nu3",1.75,1.27197431067379],
["2anz",1.75,1.45865460323816],
["1up0",1.75,1.38966509580223],
["1c1u",1.75,2.32666279193475],
["1szc",1.75,2.07622968980145],
["1r51",1.75,2.18961736901896],
["1k66",1.75,1.69839611966024],
["1us4",1.75,1.56097469732025],
["1e9q",1.75,1.72592119214947],
["1uuj",1.75,2.00916458154656],
["1b31",1.75,1.6565403221961],
["1bg4",1.75,1.57441951071717],
["1qi2",1.75,1.53330188074462],
["2cwk",1.75,1.62441142878905],
["1myg",1.75,3.07821433519577],
["1bap",1.75,2.42405580816844],
["1f57",1.75,1.67321941287414],
["1d9v",1.75,2.49139607192855],
["1wwz",1.75,2.02831234542692],
["1gq8",1.75,1.91487107595147],
["2f1f",1.75,2.89482897792335],
["2bcr",1.75,1.76952836953127],
["2d2j",1.75,1.92469545913178],
["2a9s",1.75,1.75485645534642],
["1y0r",1.75,1.97665147922574],
["1qwd",1.75,1.93898202182544],
["1ryf",1.75,2.04094825783985],
["1ryh",1.75,1.82121675489323],
["1lrk",1.75,2.06984909765783],
["2bjq",1.75,1.85543778515079],
["1eb3",1.75,2.15354429812077],
["1h7o",1.75,2.63918936147001],
["1g7j",1.75,2.16223872854843],
["2b0j",1.75,2.5092938265718],
["1evy",1.75,2.55550690436703],
["2bl0",1.75,1.87940964472590],
["1snt",1.75,2.40998623115237],
["1zsy",1.75,1.62399200308514],
["1gp6",1.75,1.55090843491676],
["1ne2",1.75,2.31259673501511],
["1p57",1.75,1.89799255176265],
["1o5e",1.75,2.15951213828001],
["1q66",1.75,2.19087732021848],
["1u7l",1.75,1.78002527479473],
["1beh",1.75,2.02470329053252],
["1waw",1.75,1.81423942695995],
["1j58",1.75,1.77623539625694],
["1w50",1.75,2.58172303048897],
["1leg",1.75,2.84657249372138],
["1h1a",1.75,1.77438916361509],
["2c1g",1.75,2.45466324541257],
["1avw",1.75,2.4383157803415],
["2aq5",1.75,1.60078341376018],
["1h33",1.75,2.2552531827733],
["1i2b",1.75,1.55524219342848],
["1dym",1.75,1.43091487655441],
["2ete",1.75,1.68392825898572],
["1m0u",1.75,2.05323935262807],
["5cp4",1.75,2.20360093383097],
["1wzg",1.75,1.51230273443715],
["1rmy",1.75,1.71659936426161],
["1k6w",1.75,1.90407922501362],
["1mj8",1.75,2.03726100213157],
["1tu6",1.75,2.02821412910309],
["1k0o",1.75,2.05493668630026],
["2a6w",1.75,2.30461458957764],
["6gsv",1.75,2.21028495961908],
["1vpb",1.75,1.15104255182248],
["2ex4",1.75,1.74092759381626],
["1rua",1.75,2.37333302517496],
["1pl1",1.75,1.45775193357388],
["2bws",1.75,1.09276768345204],
["1w8h",1.75,1.61753872745929],
["2aop",1.75,2.04158010314943],
["1fo3",1.75,2.32170486039248],
["1sn2",1.75,2.1700067623687],
["1dqn",1.75,2.20910030951613],
["1dqp",1.75,2.18051769674267],
["1k2y",1.75,1.90182474282898],
["1sat",1.75,1.63743973581210],
["2fpe",1.75,2.21120201380783],
["1q8p",1.75,1.63892213243994],
["1wov",1.75,2.15485238699798],
["1wd3",1.75,1.67356394550101],
["1pg2",1.75,2.10912090940391],
["1i8f",1.75,2.11789917142090],
["1d4x",1.75,2.42695401229708],
["1g2a",1.75,1.54932514842346],
["1v0s",1.75,1.82006784438942],
["1jak",1.75,1.59943620508294],
["1s7y",1.75,1.81056211073063],
["1vhv",1.75,2.1021921485249],
["1xqh",1.75,2.65718115652046],
["1o9s",1.75,2.64727515827418],
["2aax",1.75,1.63982893262329],
["1e7w",1.75,2.29233685575528],
["1yrb",1.75,2.31511709931704],
["1b32",1.75,1.83182337352942],
["1b4z",1.75,1.88784106984973],
["1f4g",1.75,1.52562290885069],
["1hzo",1.75,1.87529267937838],
["1kzi",1.75,2.07191650706309],
["1uxb",1.75,2.44446274135039],
["1xe7",1.75,1.96558476443186],
["1a7u",1.75,1.80001262733215],
["1go3",1.75,1.68261989089081],
["1aqy",1.75,2.3252043066794],
["1w99",1.75,1.70483734162133],
["1opj",1.75,2.41270573963804],
["2bxy",1.75,1.49179669728248],
["2bxz",1.75,1.50321671309223],
["1p2m",1.75,1.33345891156621],
["1t8n",1.75,1.41879157183012],
["1t8l",1.75,1.32171228661491],
["1ku8",1.75,1.76156649349763],
["1xgs",1.75,2.05833640951775],
["1uxj",1.75,2.03901046076385],
["1ur5",1.75,2.06756065734069],
["1ty0",1.75,2.39635769030173],
["1msv",1.75,1.58459139750651],
["4lip",1.75,1.58645136405755],
["1o7m",1.75,2.2049591225056],
["1kfe",1.75,1.85171600262978],
["1nrz",1.75,2.36640808452276],
["1oi2",1.75,2.00603800648858],
["1k9f",1.75,1.672812974828],
["1nsx",1.75,2.5090991060008],
["1nsz",1.75,2.4696579924244],
["1w9i",1.75,1.08761342110341],
["1gtj",1.75,1.99758217696029],
["1fsy",1.75,1.82507078688452],
["1s5d",1.75,1.51894504366417],
["1ocb",1.75,1.37420503610744],
["2b0t",1.75,2.04281177899636],
["1h17",1.75,2.06997624430492],
["1nqu",1.75,1.24985938219434],
["1kjj",1.75,2.73428759293243],
["1my3",1.75,1.85542884836289],
["1eyz",1.75,2.72037496815178],
["1ez1",1.75,2.89764945014775],
["1g2o",1.75,2.05117998648171],
["1se6",1.75,2.94139183158185],
["1cqx",1.75,2.36969143804624],
["1tcv",1.75,1.77481265365393],
["1h4p",1.75,2.22073203980218],
["1vh4",1.75,1.46083244793799],
["1op3",1.75,2.50505154225519],
["1q2e",1.75,1.51976081919029],
["1p7k",1.75,2.07436272412658],
["1k75",1.75,1.91193231338416],
["1gq6",1.75,1.88712366302191],
["1q9w",1.75,2.83163371271389],
["1ed8",1.75,2.14453532066329],
["1ed9",1.75,2.21424769484931],
["1lk5",1.75,1.92566101101664],
["1zg7",1.75,2.51466257190885],
["1hm9",1.75,2.39966805749729],
["2bbk",1.75,2.17882148709353],
["1vgg",1.75,1.62557236575811],
["1xkz",1.75,2.00044325358032],
["1pz3",1.75,2.36839364851978],
["1l9p",1.75,1.89593356573048],
["1l9t",1.75,1.84141774124725],
["1npy",1.75,2.06534152853612],
["1rre",1.75,2.6938823529234],
["1w6u",1.75,2.35112229211706],
["1d2v",1.75,2.13536750339830],
["1xx1",1.75,2.23560284929027],
["1x6v",1.75,1.99551429996048],
["1g8m",1.75,2.10633385577591],
["1t0t",1.75,1.84098112381396],
["1o66",1.75,1.62899629514588],
["1hdu",1.75,2.68860045667872],
["1hee",1.75,2.68860045667872],
["1jlv",1.75,2.44867472534439],
["1pg4",1.75,1.87718732170423],
["1u8f",1.75,1.80926552025821],
["1n8f",1.75,1.97405978857746],
["1sy7",1.75,2.01975238769379],
["1gtf",1.75,1.95054118886822],
["1w2w",1.75,1.69247366178425],
["1ne7",1.75,2.17290467592215],
["1vlp",1.75,1.41683943699130],
["1egv",1.75,2.81664848568001],
["1woh",1.75,2.2004512220716],
["1qsg",1.75,1.38648325970481],
["1l1l",1.75,2.41874374389856],
["1jz3",1.75,2.3578214359104],
["1jyv",1.75,2.47323319860061],
["1jyx",1.75,2.577160216187],
["2gfs",1.75,1.15274147214202],
["1pm4",1.76,2.69967645608911],
["1r3y",1.76,1.63841578152165],
["1pdq",1.76,1.99032857871424],
["1chz",1.76,3.33027136230161],
["2fcf",1.76,1.09232685806425],
["1i3i",1.76,1.36577935139619],
["1vpi",1.76,2.30489767998607],
["4paz",1.76,2.82313500689466],
["5paz",1.76,2.695664176172],
["1chn",1.76,1.33539017117092],
["1uib",1.76,1.29690473869460],
["1uia",1.76,1.94385800252359],
["1ios",1.76,1.33509386528126],
["1ior",1.76,1.70009796215476],
["1oeb",1.76,1.87426420460265],
["1jzw",1.76,1.92503790171524],
["1v8i",1.76,1.86477416671871],
["1ht9",1.76,1.82075104510635],
["1vi3",1.76,1.46110563494976],
["1xem",1.76,1.54532716473434],
["1mik",1.76,2.01533150353831],
["1k9k",1.76,1.66052623495468],
["1qq0",1.76,2.12708545256728],
["1brn",1.76,2.5916374281452],
["1u9k",1.76,2.35676777651416],
["1tq5",1.76,2.95260439727204],
["1slg",1.76,2.82883197403116],
["1yb7",1.76,1.76035935577423],
["1ghp",1.76,2.72808890782093],
["1xq0",1.76,2.14170317032947],
["2vhb",1.76,2.62824534475215],
["1pda",1.76,1.94799409861525],
["1apb",1.76,2.54878299279215],
["1ell",1.76,1.69037586581974],
["2pvi",1.76,2.33012528803452],
["2acs",1.76,2.36735353525998],
["2acu",1.76,2.23225699919272],
["2acr",1.76,2.43061094267279],
["2acq",1.76,2.42684278159426],
["1n93",1.76,1.37948131368961],
["1uuf",1.76,1.84446802335897],
["1sng",1.76,1.44282552633246],
["1m7a",1.76,2.1124962375474],
["1xw2",1.76,1.24912723677965],
["1q6r",1.76,1.62032019148252],
["1te2",1.76,1.81817523757003],
["1ynb",1.76,2.08363828029502],
["1jl2",1.76,2.36661219168952],
["1l7q",1.76,1.84678445249023],
["1cnz",1.76,2.52877263723676],
["1h5u",1.76,2.8427940069944],
["1c8k",1.76,3.17064086378527],
["1i2m",1.76,2.28701796859526],
["1uwl",1.76,2.29620757851222],
["1zai",1.76,2.09685323223707],
["1zz3",1.76,1.91156751465319],
["2b6h",1.76,1.12000217402367],
["1vph",1.76,1.93203304747674],
["1pwt",1.77,2.40699750134425],
["1lpl",1.77,2.4888841596924],
["1tov",1.77,0.874493536861242],
["3bu4",1.77,1.81966233347515],
["5bu4",1.77,1.97795119950555],
["2fgf",1.77,2.29274537985494],
["1jef",1.77,1.93242257950134],
["1gwd",1.77,2.01198271622761],
["134l",1.77,1.90113092184438],
["1tby",1.77,2.20676691579106],
["1laa",1.77,2.16286780291036],
["133l",1.77,2.14414603448806],
["1r67",1.77,2.22065542711616],
["2blh",1.77,1.41011317926453],
["110m",1.77,2.34345674846198],
["1o4v",1.77,1.5975406892208],
["1ucc",1.77,1.63881610883396],
["1gmr",1.77,1.76353789683803],
["1o2h",1.77,2.01054404058816],
["1vf1",1.77,1.67944077630646],
["1mvq",1.77,1.49930264954090],
["1taz",1.77,1.8231416250446],
["1fhv",1.77,2.16377345161798],
["1zoe",1.77,2.50028176269824],
["2a6s",1.77,2.27223878116516],
["1s8f",1.77,2.60837942362164],
["1dk0",1.77,2.439343370908],
["1pkk",1.77,2.09620600109426],
["1u55",1.77,2.35782818229213],
["3uag",1.77,1.72774447018487],
["1ys6",1.77,2.58771072140466],
["1y1t",1.77,2.46633170609995],
["1r4p",1.77,1.93398531399621],
["1f0j",1.77,2.15193455428572],
["2bfb",1.77,1.79904696614738],
["2bia",1.77,2.26155172358506],
["1y7a",1.77,2.39557662620848],
["1r7a",1.77,1.67154885160638],
["1rx0",1.77,1.69540072627681],
["1m4t",1.77,2.5153200589047],
["1g1l",1.77,2.00776486756597],
["1ev3",1.78,1.87794505917048],
["1mzm",1.78,2.13673300999270],
["1sdz",1.78,2.82371028710109],
["1yv6",1.78,2.29626365518587],
["1fn5",1.78,2.11787475415121],
["1n4f",1.78,2.54878430142753],
["1j23",1.78,2.18503930510438],
["1j24",1.78,1.61246695080830],
["1j25",1.78,1.76783113461514],
["1uv0",1.78,2.48261073734966],
["1khi",1.78,2.12599082867948],
["1uzp",1.78,2.63006417147901],
["1emy",1.78,2.20504652557469],
["1top",1.78,1.84587794475349],
["1yzq",1.78,2.24567109084095],
["1fej",1.78,2.01276247399239],
["1o32",1.78,1.81179130292469],
["1sre",1.78,2.66511267503933],
["1y6i",1.78,1.8570188743886],
["8est",1.78,2.18328364491540],
["4est",1.78,1.92021560739265],
["1mvu",1.78,2.10131023213005],
["1jvu",1.78,2.34952171158537],
["1zk1",1.78,1.58540612971676],
["1gqn",1.78,2.2045626324961],
["1jt1",1.78,1.81801443472575],
["1ew6",1.78,2.12117241995967],
["1wta",1.78,1.44406180239701],
["1ypk",1.78,2.27064025239863],
["1jt4",1.78,2.60233249708185],
["1ypj",1.78,2.664560346468],
["1x7v",1.78,1.81709280959416],
["1yoe",1.78,1.10564457476407],
["1nq6",1.78,1.47482518495431],
["1h1t",1.78,2.42223097959847],
["1axn",1.78,2.60075422662303],
["1qaz",1.78,1.98721112848186],
["1o5f",1.78,2.09154270307157],
["1x84",1.78,2.38942137843876],
["1pvf",1.78,2.49519430280538],
["1vp2",1.78,1.71462838809048],
["1ia3",1.78,2.054774510217],
["1ysr",1.78,2.04401862351907],
["1qh7",1.78,1.33545330475779],
["1zea",1.78,2.3867913914030],
["1seq",1.78,1.88821427733915],
["1pfw",1.78,1.73990180502465],
["1d3c",1.78,2.54535344617796],
["1h2y",1.78,1.48199135535182],
["1vlj",1.78,1.69278404065268],
["1a8i",1.78,2.04000075209327],
["1p6k",1.78,2.18053066198268],
["1l9s",1.78,1.87012826045533],
["1l9r",1.78,1.90968241452627],
["1hbo",1.78,1.77167059950795],
["1flu",1.79,1.83829796388262],
["1rgx",1.79,2.22456120033269],
["1xr9",1.79,1.77895060789259],
["1h9o",1.79,2.54900504510345],
["1gsx",1.79,2.57019617626389],
["1umv",1.79,2.33763589210071],
["1ioq",1.79,1.51601860710132],
["1kxy",1.79,1.78889036282659],
["1xyv",1.79,2.10684366314505],
["1zvc",1.79,1.56349750074628],
["2fq4",1.79,2.15348611722217],
["1ec0",1.79,1.51070106651763],
["1iab",1.79,2.01376610997208],
["2bv7",1.79,1.65216724839092],
["1yk5",1.79,1.52193650227472],
["2ccs",1.79,2.35070445083767],
["1f2s",1.79,1.93350332710788],
["1nxq",1.79,1.23040203523109],
["1gi7",1.79,2.66822248227516],
["1i2k",1.79,2.44048336474463],
["1h01",1.79,1.99224994432868],
["1xp0",1.79,1.80003086185875],
["1m2q",1.79,2.68949475349666],
["2fg0",1.79,1.17598153029054],
["2fr1",1.79,2.45338507268973],
["2bew",1.79,1.83168682028814],
["1q9o",1.79,2.62675541741763],
["1x74",1.79,2.05444757639418],
["1rk4",1.79,1.73381012324187],
["1mjf",1.8,1.53888855399804],
["1q7d",1.8,1.51660604958004],
["1b19",1.8,1.16871151766509],
["1b18",1.8,1.34922769281048],
["1b2b",1.8,1.41708455649362],
["1b2g",1.8,1.52969500396967],
["1b2c",1.8,1.65236298905713],
["1cad",1.8,1.66001612448711],
["1caa",1.8,1.91470248974794],
["1t9q",1.8,3.02668001841815],
["1oks",1.8,2.3396658414603],
["1fca",1.8,1.58106804109348],
["1yod",1.8,2.70248864157454],
["1b6q",1.8,2.35777961454701],
["1shg",1.8,2.50715040105512],
["8pti",1.8,2.95293242122195],
["1qkx",1.8,1.63628945709359],
["1cq4",1.8,1.66131196683736],
["1zik",1.8,2.92670116833133],
["1mhn",1.8,1.96148103610882],
["1vif",1.8,3.08937239605849],
["1zii",1.8,2.97485126271414],
["1ku3",1.8,2.49810636822766],
["1i5x",1.8,1.57291813907093],
["1fas",1.8,2.50752336403591],
["1yib",1.8,1.60873965779006],
["1iq9",1.8,2.55569720600429],
["2zta",1.8,3.0980096451292],
["2cc7",1.8,2.00167982718556],
["1mhx",1.8,1.99474992686291],
["1gzi",1.8,2.08373519724462],
["9ame",1.8,1.70455933433995],
["1wtr",1.8,2.76622746583897],
["1dul",1.8,1.88769092879758],
["1xak",1.8,2.45915142438243],
["1riy",1.8,1.67182589801579],
["1ruw",1.8,2.56835180029214],
["1dxg",1.8,1.26887747531854],
["1z96",1.8,1.00443817160659],
["1hpi",1.8,2.1808616779558],
["1k51",1.8,1.63236178941822],
["1hyp",1.8,2.75247533188647],
["1tif",1.8,2.48460488302079],
["1ubq",1.8,2.58688200277616],
["1ubi",1.8,2.74137698091883],
["2b8i",1.8,2.17481281893425],
["1kp6",1.8,1.55510636315962],
["3kiv",1.8,3.68551985015165],
["1bdo",1.8,1.50966306630588],
["1zt3",1.8,1.96989372494579],
["1t07",1.8,1.41954692572740],
["1m2m",1.8,1.75894468498829],
["1m2i",1.8,1.84910042047790],
["1lqx",1.8,1.46952844871855],
["1m20",1.8,1.52817584998056],
["2ceu",1.8,2.35192093869933],
["1cm2",1.8,2.66262872157637],
["1cei",1.8,2.21645736205681],
["1vqa",1.8,1.29951972505657],
["1vqb",1.8,1.36865944091461],
["1vqc",1.8,1.29503036575436],
["1vqe",1.8,1.29503036575436],
["1vqf",1.8,1.36865944091461],
["1vqi",1.8,1.29503036575436],
["1vqh",1.8,1.4468820315674],
["1vqj",1.8,1.71835009566995],
["1a68",1.8,2.08167993910141],
["1pch",1.8,2.33836116361743],
["1nps",1.8,2.45151114793001],
["1yd1",1.8,1.04416274194194],
["1ycz",1.8,1.30249690169064],
["1n98",1.8,2.55812722676957],
["1y02",1.8,1.58873889157837],
["1yd5",1.8,1.11299802738931],
["1ten",1.8,1.68627797029027],
["1fna",1.8,2.6738919650276],
["1bxv",1.8,2.11626627994771],
["1b9w",1.8,2.15379712844983],
["1fk3",1.8,1.85003159231843],
["1fk1",1.8,2.1658336190272],
["1fk2",1.8,2.52665480072727],
["1fk0",1.8,2.59240836430096],
["1fk4",1.8,2.52914594794879],
["1ij3",1.8,2.78916276141369],
["1dfu",1.8,2.04818826276705],
["2tci",1.8,2.75020671222345],
["1off",1.8,1.97707122292217],
["1gcm",1.8,3.40901685203359],
["2cbp",1.8,2.43108378451962],
["1mwp",1.8,1.93962808321648],
["1rwe",1.8,2.05758171096669],
["1lds",1.8,2.14963193128442],
["7pcy",1.8,2.25866066373446],
["1rn4",1.8,2.41942727949589],
["1j7c",1.8,1.65004571648505],
["1j7a",1.8,2.22747408523531],
["1j7b",1.8,2.25832941899450],
["2acy",1.8,2.30763060322151],
["2pcy",1.8,2.62927138947703],
["5pcy",1.8,2.75005036621803],
["1yn4",1.8,2.32119916131373],
["2fd4",1.8,2.53451229920196],
["1w42",1.8,1.12000217402367],
["1n8u",1.8,2.2781473019097],
["1fao",1.8,2.04793338768323],
["2b1y",1.8,1.61497533202685],
["3wrp",1.8,3.3449946051287],
["1kdi",1.8,2.15607003958476],
["1zfp",1.8,2.06945251235639],
["1qad",1.8,1.46423747234912],
["1h7c",1.8,2.39803667635903],
["1bb1",1.8,1.54625349705038],
["1fzu",1.8,1.18944141124444],
["8rnt",1.8,1.65054747006987],
["2aae",1.8,1.61366729457150],
["1hz1",1.8,1.69130572689427],
["1i2e",1.8,1.55453537213454],
["4bu4",1.8,1.38329552525350],
["5gsp",1.8,1.61200832270600],
["6rnt",1.8,1.84132715934086],
["3rnt",1.8,2.11592469211668],
["2rnt",1.8,2.25720372863951],
["2gsp",1.8,1.62839586453175],
["1det",1.8,2.75893980693212],
["2fmb",1.8,2.52698319904032],
["1fmb",1.8,2.53828916839812],
["1o4c",1.8,2.44045309324761],
["1lxj",1.8,2.14539560354164],
["1bmb",1.8,1.72976504654494],
["1xau",1.8,2.85239848883612],
["1aaj",1.8,1.79849108862921],
["1rds",1.8,2.54925529635059],
["1erw",1.8,1.64595440633057],
["1o47",1.8,1.78612776903567],
["1o45",1.8,2.26926394602885],
["1pc5",1.8,2.04375776798534],
["1v2z",1.8,1.76790244166100],
["2cdv",1.8,2.16027597349413],
["1j4i",1.8,1.90826994738552],
["1j4h",1.8,2.02379736719267],
["1lkl",1.8,2.25171801248974],
["1bhf",1.8,3.01038113908975],
["4pal",1.8,2.17618760543293],
["2pal",1.8,2.57005023310893],
["1gn0",1.8,1.92969475763472],
["1cih",1.8,2.79845835949489],
["1cig",1.8,3.00729060039678],
["1cie",1.8,2.75614245338734],
["1w0u",1.8,2.15622623577792],
["2apx",1.8,1.33389458997072],
["1m1s",1.8,3.02700429768550],
["2apb",1.8,1.72608211958391],
["1gzl",1.8,2.92003907378433],
["1wad",1.8,2.49961824903389],
["1roa",1.8,2.08435282111067],
["1ytc",1.8,2.35417528244277],
["2apf",1.8,2.46425601141689],
["1rtu",1.8,1.04661339665601],
["2tgi",1.8,2.74956496310298],
["4fiv",1.8,2.65593499125928],
["1lcj",1.8,2.56174602568247],
["1rzy",1.8,1.88702331543349],
["1jid",1.8,1.372886137594],
["1evh",1.8,1.63800086264545],
["1z3l",1.8,2.2707466369479],
["1py9",1.8,1.80075553530775],
["1i07",1.8,2.65907219824448],
["1r9h",1.8,1.54775033984330],
["2fi9",1.8,2.07927048046095],
["1a7d",1.8,1.32533164120908],
["1a7e",1.8,1.54501772007886],
["1rbf",1.8,2.01148305874964],
["1rbi",1.8,2.30041445991655],
["1rbg",1.8,2.40525165715831],
["1a3d",1.8,2.39514480393010],
["1ekg",1.8,2.32293289613398],
["1wou",1.8,2.04802706012195],
["1u29",1.8,1.38048888344348],
["1pzb",1.8,2.67431915829292],
["1pza",1.8,2.70365894816566],
["2apq",1.8,1.22886782653039],
["1k5b",1.8,3.15575805185665],
["1ea2",1.8,2.05754214030628],
["1dly",1.8,1.60617817392767],
["1s8h",1.8,1.88946941705301],
["2sak",1.8,1.82689610562327],
["1xki",1.8,1.80753066319952],
["1srn",1.8,3.57567419222612],
["1p90",1.8,2.44635543733652],
["1rtx",1.8,2.84269303210949],
["1c44",1.8,2.93169267008406],
["1k59",1.8,2.95035276601066],
["1b1i",1.8,3.14261124873486],
["1bpq",1.8,2.21729705147761],
["1mku",1.8,3.11472613470484],
["2bpp",1.8,2.98914918551623],
["1a4v",1.8,2.7138626665093],
["2cw4",1.8,2.50419478357841],
["1s7i",1.8,2.56843337273734],
["1c9x",1.8,2.56544315858647],
["1c8w",1.8,2.83022927688466],
["1rnw",1.8,2.53167122181598],
["1rnn",1.8,2.64289546711596],
["1izq",1.8,2.61896920813653],
["1rha",1.8,2.71946402774446],
["1fkq",1.8,3.03311844891233],
["1cgo",1.8,2.31091524399658],
["1at5",1.8,1.57764849035809],
["1u5x",1.8,2.28047897836671],
["1at6",1.8,1.66655346237189],
["2chf",1.8,2.93001174210958],
["2che",1.8,2.97690540375046],
["1ijt",1.8,1.71685077901360],
["1u2b",1.8,0.971961256759092],
["1dt1",1.8,2.36898647181485],
["1bwj",1.8,1.66187609731102],
["1bwh",1.8,1.61626665280264],
["1bvx",1.8,1.75930476062688],
["1bwi",1.8,1.68209450577442],
["1lzd",1.8,2.06319645580369],
["1lze",1.8,2.02070328629602],
["1lzc",1.8,2.01855673419138],
["1heo",1.8,2.17555280402760],
["132l",1.8,2.28685392032047],
["1azf",1.8,2.28311973952030],
["1hen",1.8,2.20680547052021],
["1heq",1.8,2.22175562285527],
["1lzg",1.8,1.86383849693185],
["1hem",1.8,2.1752030638665],
["1her",1.8,2.32791638449375],
["1ykz",1.8,1.70746863387668],
["1hep",1.8,2.39154101287787],
["1lmn",1.8,2.23361966648775],
["1lmo",1.8,2.31842133161096],
["2bqm",1.8,1.9071569302614],
["1lz4",1.8,1.91159591924129],
["2bqj",1.8,2.28883226776307],
["2bqo",1.8,2.21062604264110],
["2bqh",1.8,2.27119376350365],
["1ix0",1.8,2.13781334827505],
["2bqk",1.8,2.17664993894573],
["2bqg",1.8,2.06135840986246],
["2bqi",1.8,2.2678844114638],
["2bql",1.8,2.11341386936967],
["2bqn",1.8,2.40320384762586],
["2bqf",1.8,1.87932186199054],
["2bqb",1.8,1.90254149012787],
["2bqc",1.8,2.04997365318881],
["2bqd",1.8,2.04997365318881],
["2bqe",1.8,1.92455996712629],
["1hz9",1.8,2.17420827297052],
["1lhm",1.8,1.51699681826623],
["2bqa",1.8,2.13082243843185],
["1b5u",1.8,1.35231881173893],
["1cj8",1.8,1.53134532681942],
["1ge0",1.8,1.25730183600803],
["1c45",1.8,1.74251905248359],
["2hec",1.8,1.7789804138152],
["2hee",1.8,1.61096547824458],
["1cj6",1.8,1.67496354863431],
["1ge4",1.8,1.80766368078994],
["1b7r",1.8,1.61559036537828],
["1gdx",1.8,1.70568228846611],
["1gdw",1.8,1.70625184367309],
["1ckf",1.8,1.72170110348756],
["1jkd",1.8,1.9507163767258],
["1lhi",1.8,1.43260308372297],
["2hef",1.8,1.64885045995215],
["1di3",1.8,1.78406355316854],
["1ckc",1.8,1.67064062131718],
["1gb5",1.8,2.13174183195373],
["1ge3",1.8,1.95957660010336],
["2hea",1.8,1.92222938337664],
["1gay",1.8,1.92261005354592],
["1gbo",1.8,2.26641133183650],
["2hed",1.8,2.07355186489637],
["1hnl",1.8,2.3359849195162],
["1lhj",1.8,2.46234040746006],
["1lhk",1.8,1.52732854562910],
["1cj7",1.8,1.56829690412971],
["2meg",1.8,1.56985640204091],
["1ckd",1.8,1.69987496009242],
["1gb2",1.8,1.73765070474030],
["1ip4",1.8,1.65944447961832],
["1wqn",1.8,1.60495057258466],
["1wqp",1.8,1.69987496009242],
["1wqr",1.8,1.60495057258466],
["1gb7",1.8,1.48057727022527],
["1ip1",1.8,1.48057727022527],
["1ip6",1.8,1.36609804114757],
["2mee",1.8,1.50557041517436],
["1c43",1.8,1.58003408110319],
["1gfj",1.8,1.29361713584284],
["1yan",1.8,1.80857286581523],
["1eq4",1.8,1.74438214915767],
["1gb0",1.8,1.51245911093098],
["1gb8",1.8,1.39797988185328],
["2meb",1.8,1.53679065131224],
["2med",1.8,1.67057906125698],
["2mei",1.8,1.61059373921293],
["1gf8",1.8,1.51368603527787],
["1cj9",1.8,1.69966546382427],
["1eq5",1.8,1.98287216831041],
["1eqe",1.8,2.19486680337713],
["1wqq",1.8,1.77404194232169],
["1gf7",1.8,1.64082615176888],
["1gfa",1.8,1.42821229440923],
["2mef",1.8,1.70081147381293],
["2meh",1.8,1.7013833240718],
["1wqo",1.8,1.80123213190233],
["1gf6",1.8,1.66798093648151],
["1gfe",1.8,1.56984630819956],
["1gb3",1.8,1.59435999253353],
["1gf9",1.8,1.47988076345583],
["1gaz",1.8,1.48038729826123],
["1ip2",1.8,1.88568660982056],
["1ip5",1.8,1.67307275246091],
["1gfk",1.8,1.67408401767206],
["1yam",1.8,1.84892213038383],
["1yap",1.8,1.84892213038383],
["207l",1.8,2.0542744237322],
["1gfg",1.8,1.50353920823935],
["1yaq",1.8,1.87297622760191],
["1inu",1.8,1.64088571982885],
["1gfh",1.8,1.74165604615556],
["1wqm",1.8,1.89623381497071],
["1gfr",1.8,1.76185315111134],
["1gf4",1.8,1.91761976333085],
["1gfv",1.8,1.86205069581300],
["1yao",1.8,1.88249387566061],
["1lhh",1.8,1.9506755501181],
["1gbw",1.8,2.01956035907783],
["1gft",1.8,2.12660624096414],
["1loz",1.8,2.39930446600363],
["1gb9",1.8,2.10182253775488],
["1gb6",1.8,1.91383917159305],
["1gby",1.8,1.79983830487322],
["1gbz",1.8,2.60391688566305],
["1gbx",1.8,2.16047537746068],
["1gfu",1.8,1.83470584375891],
["1i1z",1.8,2.42112254589286],
["1b7n",1.8,2.84405622976103],
["1lhl",1.8,1.18092627832470],
["1gf0",1.8,1.63712589930424],
["1gf3",1.8,1.86583869675673],
["3lhm",1.8,1.38156399122116],
["1gf5",1.8,1.73725364039636],
["1gez",1.8,1.70488836655843],
["2lhm",1.8,1.80067654080100],
["1b7o",1.8,2.86416518807730],
["1b7l",1.8,3.03754820854948],
["1ly2",1.8,1.56994951408848],
["1nfn",1.8,2.80959821876885],
["1ce9",1.8,2.81261575725815],
["1mzb",1.8,1.62779410831324],
["1mz4",1.8,1.49044041892407],
["1j22",1.8,1.85864044242747],
["1sl5",1.8,2.34597167555957],
["1hza",1.8,2.04361630035099],
["1uy1",1.8,1.52117058113313],
["1fee",1.8,1.86517343601748],
["1gu4",1.8,2.08755377902823],
["2eif",1.8,2.43229973989425],
["1i2h",1.8,1.25494944654101],
["1lz5",1.8,2.39158760545053],
["1vsr",1.8,1.58843262695069],
["1wlw",1.8,1.84089981278855],
["1uix",1.8,2.22921486749518],
["1hi3",1.8,2.54459297409365],
["1hi5",1.8,2.80054218995747],
["1hi4",1.8,2.73782022356018],
["1f2z",1.8,2.15243285208002],
["1kab",1.8,2.35766673887039],
["1syc",1.8,2.52232055378862],
["1syf",1.8,2.16516314908906],
["1sye",1.8,2.71106319359918],
["1txq",1.8,2.18915080166786],
["1r9w",1.8,1.99545053690816],
["1khc",1.8,2.30551332143555],
["2fbh",1.8,2.35701204739821],
["1syb",1.8,2.43134773251432],
["1enj",1.8,2.93848718811177],
["1sk0",1.8,1.95479738232034],
["1sjz",1.8,1.99748214797468],
["1cbs",1.8,1.83067366646143],
["1lz6",1.8,2.36598549636866],
["6nul",1.8,1.72298948930754],
["2fax",1.8,1.65148547978741],
["2fox",1.8,2.13096034624628],
["5ull",1.8,2.0951454422038],
["2fvx",1.8,2.19762257502310],
["1fld",1.8,2.07402562195483],
["2flv",1.8,2.06900492017162],
["1hdk",1.8,2.81604066809645],
["1lo8",1.8,3.02653674020649],
["2g64",1.8,1.66749341758245],
["1lcl",1.8,2.11097404286677],
["1g86",1.8,2.59781652267945],
["1qkq",1.8,2.78393165454432],
["1k52",1.8,2.02587064574741],
["1hz5",1.8,2.3485466009282],
["2cj7",1.8,2.09928539272711],
["1k6k",1.8,2.31120297374878],
["1h9k",1.8,1.76173292458927],
["1clm",1.8,2.48808700465861],
["2fcs",1.8,2.11450361590352],
["1h9j",1.8,1.75218518840556],
["1q5z",1.8,1.59418848030206],
["4tsv",1.8,3.59541465091764],
["1ahr",1.8,3.49454710660666],
["2fal",1.8,2.4196636328917],
["1wsb",1.8,2.18796051058722],
["1xt6",1.8,2.92215204450718],
["1azl",1.8,1.95135238089185],
["1akt",1.8,2.29032854332117],
["1pxd",1.8,2.08304991895658],
["1p4m",1.8,2.09181529485322],
["1edu",1.8,2.06957214317792],
["1npk",1.8,2.29608478664716],
["1dbu",1.8,2.34661239859214],
["1bj7",1.8,1.78858697132714],
["1v8r",1.8,1.89678960930379],
["1rlh",1.8,1.90959521335485],
["1ilk",1.8,2.4447817860168],
["1asw",1.8,2.84463369746020],
["1f1a",1.8,1.77400028317804],
["1b4l",1.8,2.05841705338653],
["1b4t",1.8,1.96741469675742],
["1nz4",1.8,2.56723666324357],
["1bje",1.8,2.56160317998197],
["1ebc",1.8,2.15453054850960],
["2blj",1.8,1.59051694265740],
["2myd",1.8,2.18612082751851],
["2myc",1.8,2.48988334475342],
["1swm",1.8,2.44063657137098],
["1gdi",1.8,3.09525052660674],
["1gdl",1.8,2.90130703662358],
["1gdk",1.8,2.85751554106494],
["2cmm",1.8,3.04817680714806],
["1soi",1.8,2.12774327482805],
["1co8",1.8,2.31523572296799],
["1f63",1.8,2.05283962374997],
["1n9f",1.8,1.57986006836273],
["1ch2",1.8,1.94333878777516],
["1n9h",1.8,1.67208040959689],
["1ofk",1.8,2.22064423037921],
["1ch9",1.8,2.32754934761981],
["2mgg",1.8,2.75359180435875],
["1mlk",1.8,2.87995830003506],
["1mlo",1.8,2.94138998174275],
["2mgd",1.8,2.65988647380832],
["1mtk",1.8,3.03243064897156],
["2mgf",1.8,2.91964010355007],
["1mlm",1.8,2.95941327784496],
["1ycl",1.8,1.94237605533101],
["1rbs",1.8,2.33905287806652],
["1rbv",1.8,2.51852977840068],
["1kva",1.8,2.52259211306687],
["1rbt",1.8,2.50172004711252],
["1rbu",1.8,2.44833390806576],
["1rbr",1.8,2.33964433885582],
["1law",1.8,2.67439944574507],
["1lav",1.8,2.65463901860989],
["1jyh",1.8,1.46418409013717],
["2b18",1.8,2.08084649934754],
["2fu0",1.8,1.63015615676706],
["1t8g",1.8,2.0206584612144],
["2bep",1.8,1.58376988709894],
["1s7k",1.8,1.95146318211576],
["2a4v",1.8,1.83711589895825],
["1g5t",1.8,2.86185679377299],
["1yp6",1.8,2.56840383954431],
["1qy0",1.8,2.70849678971584],
["1dg7",1.8,2.42073557466112],
["1v8m",1.8,1.79913158054513],
["1zzi",1.8,1.90983025770224],
["1ra3",1.8,2.27447105001540],
["1rf7",1.8,2.37238388721486],
["1ra8",1.8,2.43270335096872],
["1rx2",1.8,2.64224786264596],
["1kxo",1.8,2.56221945463002],
["2bm3",1.8,1.79600864295383],
["156l",1.8,1.85551167874316],
["159l",1.8,1.98578910999872],
["250l",1.8,2.16666720877472],
["158l",1.8,2.06051405250024],
["164l",1.8,1.64782027880063],
["162l",1.8,1.69535015404818],
["163l",1.8,1.91172847058037],
["185l",1.8,1.97906237080657],
["1lyj",1.8,1.8870879821527],
["1ulm",1.8,1.90112162849273],
["1cvk",1.8,2.11507835285968],
["188l",1.8,2.10460767984373],
["107l",1.8,1.95148139756848],
["160l",1.8,2.06289513551622],
["182l",1.8,2.10343724827101],
["229l",1.8,2.17530691274458],
["184l",1.8,2.10177134694441],
["181l",1.8,2.21038038074667],
["187l",1.8,2.32603814560857],
["238l",1.8,2.27305172053391],
["1nhb",1.8,2.28193062697132],
["186l",1.8,2.30200191831457],
["183l",1.8,2.43677641429069],
["239l",1.8,2.27368912790582],
["1l80",1.8,2.52528314752142],
["113l",1.8,1.71563051698190],
["114l",1.8,1.75473944428794],
["115l",1.8,1.95865491029664],
["1l61",1.8,1.84911586933736],
["1lye",1.8,1.88418010544948],
["1lyg",1.8,1.94433944023398],
["126l",1.8,1.81100564053395],
["1l91",1.8,1.9775764610704],
["260l",1.8,2.17925819890382],
["1l94",1.8,2.04453927511342],
["1lyf",1.8,1.99367528229732],
["1g1w",1.8,2.10372108471603],
["112l",1.8,2.05047462662934],
["1l93",1.8,2.06442321094117],
["108l",1.8,1.94214205429966],
["1l87",1.8,2.01710470127453],
["1c69",1.8,2.23719566253774],
["111l",1.8,2.21067286517648],
["1llh",1.8,2.50571156568821],
["226l",1.8,2.39469896243172],
["1l86",1.8,2.34670344013175],
["1cv3",1.8,2.43657913587405],
["1p56",1.8,2.59339125165441],
["122l",1.8,1.58636911190856],
["123l",1.8,1.76288983492855],
["120l",1.8,1.95884705233298],
["118l",1.8,1.61264009266713],
["7lzm",1.8,2.02894001368461],
["6lzm",1.8,2.10067222896742],
["1dye",1.8,2.10128502247479],
["5lzm",1.8,2.16326402535226],
["1qsb",1.8,2.15499529737843],
["1ncz",1.8,2.31368489246929],
["1ncx",1.8,2.65472837325253],
["1ysp",1.8,2.42576080241566],
["1lb6",1.8,2.11969520019679],
["1zp5",1.8,3.24332014166863],
["258l",1.8,2.28515571144582],
["1smx",1.8,1.59886883256760],
["1huq",1.8,1.73382949676481],
["245l",1.8,2.1779947598218],
["242l",1.8,2.09529964337579],
["246l",1.8,2.32022695551937],
["1g0p",1.8,2.2956219920443],
["255l",1.8,1.78424367737738],
["1g0j",1.8,2.03146008076616],
["1qt5",1.8,1.99843545611191],
["1g0l",1.8,2.21313349586399],
["1qt7",1.8,2.12730141248736],
["1g0q",1.8,2.15751258694523],
["1l35",1.8,2.25866020342575],
["1l25",1.8,2.41059043138966],
["1l98",1.8,2.33399438267277],
["1l42",1.8,2.20280043694797],
["1l43",1.8,2.18856765591378],
["1l27",1.8,2.29578957512691],
["1l38",1.8,2.39803177808965],
["1l31",1.8,2.60587002821787],
["256l",1.8,2.52143490518211],
["1l56",1.8,2.5094271009262],
["1l49",1.8,2.42200568033523],
["1l4u",1.8,2.21448668132338],
["1w8l",1.8,2.53160430593352],
["1mug",1.8,2.00375829075660],
["1usn",1.8,1.44989461147737],
["1lop",1.8,2.4771323530028],
["1wz3",1.8,1.94456605961259],
["1cjw",1.8,1.88373735900752],
["1kux",1.8,2.05648586529610],
["1j2a",1.8,2.47707997508864],
["1jah",1.8,2.45165856421001],
["1jai",1.8,2.56492742064817],
["1luz",1.8,1.89183868600141],
["3eip",1.8,2.61421977267567],
["1cwl",1.8,2.14119631795160],
["1fxl",1.8,2.15643545074774],
["1hc9",1.8,2.17083463286128],
["1cwk",1.8,2.3560269160309],
["1cwj",1.8,2.17799006268055],
["1bck",1.8,2.29405461641219],
["1caq",1.8,2.27380711400579],
["1czl",1.8,1.45667319707423],
["1rm8",1.8,2.60275104240324],
["1mgt",1.8,1.72146169667450],
["1n6o",1.8,1.67419386524326],
["1eue",1.8,2.07848857994435],
["1mu4",1.8,1.91151463775872],
["2bmd",1.8,2.58282374317187],
["1wba",1.8,1.87352125954128],
["1ccz",1.8,2.93395364235133],
["1dyw",1.8,2.7609460997022],
["2fcr",1.8,2.00944454330892],
["1fnl",1.8,2.52411788833908],
["1fgl",1.8,2.10974128915015],
["1j53",1.8,1.53009362420173],
["1lhu",1.8,2.48568880506733],
["1fel",1.8,3.59498283992513],
["1g8e",1.8,3.18642435574884],
["1lmb",1.8,2.19781956878633],
["1jwq",1.8,1.68650448837772],
["2biq",1.8,1.93674184450580],
["2bip",1.8,1.71533291768207],
["2cxh",1.8,1.72843386060489],
["1kn3",1.8,2.14774970096495],
["1sgc",1.8,2.32947855423681],
["1ybx",1.8,1.46537085321649],
["1nu4",1.8,2.17039661532650],
["1n7f",1.8,2.03031817213478],
["1ugn",1.8,2.18456828108706],
["1rym",1.8,2.53653919770318],
["1u1q",1.8,2.14004625902972],
["1u1r",1.8,2.49332204789209],
["3sga",1.8,2.20381228165504],
["4sga",1.8,2.10155522248638],
["5sga",1.8,2.09928680605976],
["2cx1",1.8,1.55692582182987],
["2cx0",1.8,2.02342465618213],
["1hv1",1.8,1.92972718627205],
["1bvv",1.8,2.01647828872625],
["1c5i",1.8,2.09944242878128],
["2gar",1.8,2.67709857469184],
["1uxo",1.8,1.50227328111352],
["1s3v",1.8,2.90158737434092],
["1mvt",1.8,3.37266615515133],
["1xda",1.8,2.56090785072969],
["1pdv",1.8,1.69284513944085],
["1jbk",1.8,2.18191730013866],
["2cvb",1.8,2.09569963165341],
["1frr",1.8,2.90174444283561],
["1upg",1.8,1.99764512702556],
["1q0p",1.8,1.87440440308706],
["1gmq",1.8,1.74992383244824],
["1uci",1.8,1.54663938007828],
["1uck",1.8,1.54663938007828],
["1sar",1.8,2.06765317811484],
["2sar",1.8,2.22179998877208],
["1hh8",1.8,1.86616479624692],
["1vm0",1.8,1.95208187606736],
["1ihj",1.8,2.16380734443075],
["1a92",1.8,1.91074841145398],
["1qbs",1.8,2.65250763849936],
["1qog",1.8,1.80042638744524],
["1qof",1.8,1.62879970344843],
["1qob",1.8,1.81928185008045],
["1ljp",1.8,1.45441700496984],
["1z4j",1.8,1.59575577505185],
["1z4l",1.8,1.77254693187511],
["1mh9",1.8,2.3362288974869],
["1dus",1.8,2.16397712512208],
["1v4b",1.8,1.78013827989741],
["1n9p",1.8,1.80039726920627],
["1hvr",1.8,2.61667478444515],
["1qbr",1.8,2.66430377973807],
["1qbu",1.8,2.98086374238344],
["1hwr",1.8,2.92751293174692],
["1hvh",1.8,3.57144647290321],
["2bfw",1.8,1.62548205247466],
["1ec3",1.8,1.90776521315613],
["1hvk",1.8,1.85036746603715],
["1hvi",1.8,1.91389390829539],
["1hvl",1.8,1.93120516655221],
["1g35",1.8,1.47109266105054],
["1pro",1.8,2.19253861973776],
["1bwb",1.8,2.27896245605497],
["1w5v",1.8,1.74242071844100],
["1hxw",1.8,2.15540408881052],
["1w5w",1.8,1.59036629207935],
["1j8r",1.8,1.98919303095923],
["1kzf",1.8,2.01563815485807],
["1xza",1.8,1.98386357217585],
["1cua",1.8,1.80184824413709],
["1fg6",1.8,1.70190106192855],
["1sp5",1.8,1.37398059180526],
["1dnl",1.8,2.52771053617241],
["1fe6",1.8,1.45398328625523],
["2fdi",1.8,1.97194597154646],
["1ast",1.8,1.67233926101285],
["1no5",1.8,2.49593028899555],
["1w3p",1.8,1.67028773698877],
["1khx",1.8,2.77191518507544],
["1ijb",1.8,1.81530042239574],
["1v77",1.8,2.31438166337608],
["1hvc",1.8,2.13043101239786],
["1vd1",1.8,2.32519583657146],
["1r1q",1.8,2.24091430495155],
["1iib",1.8,1.26211699720426],
["1q3o",1.8,2.29568895236947],
["1vd3",1.8,2.13626670888450],
["1vcz",1.8,2.4252425621381],
["1uch",1.8,2.31065341443076],
["2axe",1.8,2.03860524371682],
["3cyt",1.8,2.60671271532006],
["1bir",1.8,2.03775881422992],
["1z78",1.8,2.81416554958900],
["1my5",1.8,2.44831550856587],
["1cmc",1.8,1.83323419857506],
["1cmb",1.8,2.70846317672414],
["1l8f",1.8,2.01702268146361],
["1lr2",1.8,1.72184462511106],
["1lr3",1.8,1.87527881210020],
["1se8",1.8,2.12170114897585],
["1woj",1.8,1.58928018573388],
["1x9u",1.8,2.01309681987574],
["1ft6",1.8,2.50323288573665],
["1aun",1.8,2.18241240833485],
["1cpn",1.8,2.75297806810323],
["1zn6",1.8,1.8547352295678],
["1e99",1.8,1.50520352576947],
["1dv7",1.8,1.99167678386615],
["1hxn",1.8,3.09589225053223],
["1yuk",1.8,2.74258532486399],
["1ro0",1.8,2.43199583289414],
["1ix4",1.8,1.81464724465982],
["2spc",1.8,3.65904862490203],
["1lbu",1.8,2.99287124935643],
["2fbq",1.8,1.68808957149806],
["1ah6",1.8,2.97248505466541],
["1keb",1.8,1.81779293565123],
["1gbg",1.8,2.11547846474519],
["1xzz",1.8,2.46304044686670],
["1f2b",1.8,1.83627768626965],
["1mem",1.8,2.68051522061518],
["1j48",1.8,2.06536677867372],
["1ppo",1.8,2.90188412190294],
["1xvj",1.8,1.91641692384748],
["1t6t",1.8,1.75368128948747],
["1nqc",1.8,1.91983284149782],
["1xqa",1.8,2.03430436985650],
["1p2f",1.8,1.6192789753935],
["1i4j",1.8,2.87292410875234],
["1d4w",1.8,2.05201481390835],
["1rmo",1.8,2.19049126154419],
["1ept",1.8,2.58424672072101],
["1vzw",1.8,1.18843127802281],
["2cd0",1.8,2.53969885116002],
["2axo",1.8,2.64398818555935],
["1c8r",1.8,2.73493916792780],
["1f4z",1.8,2.93696692688009],
["1kzb",1.8,1.97540368125575],
["1m07",1.8,2.40331206913517],
["1jby",1.8,2.96261553531768],
["1aks",1.8,2.55101555144917],
["1rdj",1.8,1.49750925892382],
["1rdn",1.8,1.64159673068325],
["1rdi",1.8,1.57332050222427],
["1rdk",1.8,1.80836492699652],
["1kze",1.8,1.85849051092275],
["1nqn",1.8,2.3127249745674],
["2tbs",1.8,2.35970699857693],
["1vfa",1.8,2.0584693274189],
["1fh2",1.8,2.41039344888518],
["1y3w",1.8,2.18241989932527],
["1y3u",1.8,1.47301651234753],
["1s6f",1.8,1.02739318758660],
["1qbn",1.8,2.17320537268223],
["1qbo",1.8,2.10751614340009],
["1qa0",1.8,2.25336487235223],
["1qb6",1.8,2.38429507357305],
["1fn6",1.8,2.62921434336699],
["1qb9",1.8,2.55640261570726],
["1ppc",1.8,1.83673500774505],
["1g3d",1.8,1.71750341302518],
["1v2n",1.8,1.71693008321954],
["1f0t",1.8,2.15375625323532],
["1bju",1.8,1.97325895986228],
["1may",1.8,2.13863336882006],
["1v2u",1.8,1.55027686920416],
["1bjv",1.8,1.98520607292836],
["1g3e",1.8,1.95173928745222],
["1g3b",1.8,1.83398448940338],
["1tnh",1.8,1.98840660058473],
["1tng",1.8,2.07457628562915],
["1g3c",1.8,2.02747032324312],
["1az8",1.8,2.18005372278124],
["1tnk",1.8,2.06291263052518],
["1tnj",1.8,2.10758297152993],
["1qb1",1.8,2.22874192193772],
["1tgc",1.8,2.58441387213573],
["2tga",1.8,2.60936634945744],
["1v2v",1.8,2.1340893472974],
["1max",1.8,2.77943746065700],
["1qcp",1.8,2.73968047296546],
["1tgb",1.8,3.18796183145811],
["1gvl",1.8,2.92365876556915],
["2g5u",1.8,1.87031104671583],
["1emh",1.8,1.81124998857806],
["1nco",1.8,2.20351308646036],
["1dam",1.8,2.02786198831086],
["1dbs",1.8,2.03117735981939],
["1a82",1.8,2.10470378778636],
["1bs1",1.8,2.03889442541138],
["1kpe",1.8,2.00769029264425],
["1qyq",1.8,1.38351960168834],
["1qkm",1.8,1.82774656380094],
["1uj4",1.8,1.78689853643853],
["1weg",1.8,1.62325361962831],
["1mud",1.8,1.46541155819536],
["1jrs",1.8,2.18384267324967],
["1ytt",1.8,2.20268735973791],
["1cgh",1.8,2.45126325636263],
["2g5z",1.8,1.78843331367035],
["1srg",1.8,2.60132434865249],
["2pab",1.8,3.64628716356899],
["1ton",1.8,2.88232757994045],
["2ahe",1.8,1.40478699280461],
["1tt6",1.8,1.63104594998131],
["1srj",1.8,2.93858309582938],
["1dic",1.8,2.20319223126234],
["2c53",1.8,1.43686765147072],
["1zcr",1.8,1.19782253581806],
["1lau",1.8,1.8439749591126],
["1h8u",1.8,2.32443836023752],
["1e4h",1.8,1.83405439487920],
["1e5a",1.8,1.82049479717995],
["2boo",1.8,2.19049467978835],
["1i8k",1.8,2.33512936567426],
["1eo6",1.8,1.91402864226382],
["1din",1.8,2.43993508097308],
["2vgc",1.8,2.30039003305214],
["2gmt",1.8,3.40670099765612],
["1s66",1.8,2.38256030632492],
["1zix",1.8,1.77763020925101],
["3sgb",1.8,2.24320708153897],
["7gch",1.8,3.32108579933704],
["1ct0",1.8,1.91380558997851],
["1sgr",1.8,2.34893902419327],
["2sgq",1.8,2.25822256608929],
["1sgy",1.8,2.31299652776277],
["1sge",1.8,2.36833085581207],
["1sgd",1.8,2.31862413364692],
["1sgn",1.8,2.46896798591072],
["3sgq",1.8,2.41943023583273],
["2sge",1.8,2.62235050569079],
["2sgd",1.8,2.80148369682226],
["2sgp",1.8,2.91574502915233],
["1dow",1.8,1.55769915859630],
["1afq",1.8,1.74869516308800],
["1xy7",1.8,1.62285539465989],
["2c96",1.8,2.03002752520211],
["2gct",1.8,2.63362963319427],
["1sbw",1.8,1.74172352799093],
["1qyo",1.8,1.50357626269959],
["1z95",1.8,1.95050923160010],
["2axa",1.8,1.75961876745569],
["1al3",1.8,2.87648924324791],
["1qny",1.8,1.72827727116237],
["1lst",1.8,1.83141286053588],
["2ba2",1.8,2.34806614604066],
["1e12",1.8,2.28772142263573],
["1b0e",1.8,1.77571713905591],
["1ol0",1.8,1.74534525798352],
["1eas",1.8,2.42879518472179],
["2foh",1.8,1.92182122502399],
["6est",1.8,2.16785641675131],
["1e34",1.8,2.25470176432657],
["1bma",1.8,1.78125037447239],
["1kpm",1.8,2.32413749283336],
["1ob8",1.8,2.00924148408763],
["1ual",1.8,1.74145005762881],
["1iu1",1.8,2.16486284765755],
["2rtn",1.8,2.54438702190947],
["1dxj",1.8,1.59121672089069],
["1jie",1.8,2.32211876720416],
["7est",1.8,3.11325060926429],
["1xxs",1.8,2.95374210036820],
["2baa",1.8,2.49143551628359],
["1jq9",1.8,2.6102811304798],
["1rwz",1.8,1.70092636341683],
["1xp9",1.8,2.76834326157024],
["1xp1",1.8,2.76800792696747],
["1k50",1.8,1.68090977542796],
["1mrg",1.8,2.88466618043377],
["1xps",1.8,2.12102022547810],
["8rsa",1.8,2.54847327475108],
["9rsa",1.8,2.73749598867640],
["1jn4",1.8,3.36317087297607],
["1giu",1.8,2.72211687638909],
["1f5k",1.8,2.71507588094110],
["1wuc",1.8,1.86582519878712],
["1db1",1.8,1.63872777459669],
["1m2h",1.8,2.21369298150692],
["2stb",1.8,1.81507801124783],
["2sta",1.8,2.05436936330957],
["1xow",1.8,1.88545748523808],
["1rg0",1.8,2.5585207675268],
["1wn6",1.8,1.95125391139231],
["2c4n",1.8,1.92443815308138],
["1ulk",1.8,2.10194860863331],
["1fa5",1.8,2.23910132544023],
["1q9u",1.8,1.55899236927056],
["1kyu",1.8,1.74855946652457],
["1mml",1.8,2.92601735413097],
["1bze",1.8,3.07447801856789],
["1tyr",1.8,3.14817125798299],
["1prz",1.8,2.18850764767965],
["1gi9",1.8,2.59436981928863],
["1str",1.8,2.70872109705630],
["1jzj",1.8,2.54505416329581],
["1i53",1.8,2.71087762958067],
["1gj9",1.8,2.7582217006329],
["1jt2",1.8,2.07720537390825],
["1h70",1.8,2.21875858833153],
["1ztw",1.8,2.29761944890855],
["1gqb",1.8,2.17665672062799],
["1azc",1.8,2.53112532497708],
["1aiz",1.8,2.37600257769427],
["2aza",1.8,2.73863499922293],
["5lym",1.8,2.46934332364128],
["1ljh",1.8,2.51391904967227],
["1ljf",1.8,2.50743629912596],
["1sc9",1.8,1.64453381612082],
["1t79",1.8,1.50300055060122],
["1l1t",1.8,2.04112024542862],
["1ypv",1.8,1.93759256699687],
["1cni",1.8,2.17838670668011],
["1zsc",1.8,2.22856153750797],
["1cnj",1.8,2.18975935976501],
["1alq",1.8,2.51855754915911],
["1gqa",1.8,2.47836776446966],
["1hxl",1.8,1.96292474502754],
["1ip3",1.8,1.57374619102206],
["1bb3",1.8,2.48252865896848],
["1bb5",1.8,2.68494116423908],
["1zb0",1.8,1.33807735649368],
["1ift",1.8,2.40714762277362],
["1cai",1.8,1.97587071392589],
["1yo0",1.8,1.84075087121772],
["1yo2",1.8,1.73151179772406],
["1thk",1.8,1.95486284038057],
["1tg3",1.8,1.99783067640769],
["1ray",1.8,1.88907383952511],
["1rzb",1.8,1.93981172345527],
["1g52",1.8,1.74342325484637],
["1i9q",1.8,2.16429772658714],
["2f4f",1.8,2.83148818535344],
["1zzm",1.8,2.29411443227894],
["1syh",1.8,1.51946376474720],
["1sc3",1.8,2.30392477471667],
["1bbh",1.8,2.41567882490073],
["1mqh",1.8,1.56755188794269],
["1esi",1.8,2.53976401984341],
["1iyo",1.8,2.17498098147508],
["1flj",1.8,2.27272008166592],
["1j6o",1.8,2.03886637359839],
["1cl8",1.8,2.43448040068301],
["1j1q",1.8,2.02056718860398],
["1gik",1.8,3.96719761780909],
["1wt0",1.8,2.12222279019944],
["1wt3",1.8,2.60334909879316],
["1gns",1.8,2.31890386591890],
["1hxz",1.8,2.36135468084805],
["1qah",1.8,2.4825878262783],
["2bs6",1.8,1.30948947330959],
["1c21",1.8,2.32636759245155],
["1suc",1.8,1.99653638088377],
["1jwz",1.8,1.99748685035121],
["1btl",1.8,1.20366567598923],
["1bt5",1.8,1.73711070740369],
["1tdz",1.8,1.59785768555716],
["1lz0",1.8,2.07676150738384],
["1ak0",1.8,2.2302701330677],
["1tdl",1.8,1.41720613363278],
["1tdg",1.8,1.59148497145799],
["1w6p",1.8,2.35455119412168],
["1tys",1.8,1.13750090228206],
["1nvr",1.8,2.26544238289184],
["1nvs",1.8,2.23466489338957],
["1pk1",1.8,2.01731804955692],
["1sue",1.8,2.29475734027331],
["1mcv",1.8,2.17607082678995],
["1iav",1.8,1.97300025892852],
["1c9j",1.8,1.88519223100754],
["1ndq",1.8,2.28751360146152],
["1dbi",1.8,1.77636557654604],
["4vhb",1.8,2.41611345696459],
["1y1f",1.8,1.41652912429404],
["1e0c",1.8,1.68873707348564],
["1nul",1.8,1.93738340340118],
["1uk9",1.8,1.43639591463163],
["1ukb",1.8,1.53826935898730],
["1f2p",1.8,1.34162054756905],
["1t8h",1.8,2.06319029943036],
["1ppf",1.8,2.65781133606256],
["1py3",1.8,2.17689138243651],
["1dqe",1.8,2.40789785799572],
["2bik",1.8,1.41128517931850],
["1a8s",1.8,2.05846336416186],
["2hvm",1.8,1.7817082357953],
["1xws",1.8,1.64941011680375],
["1kve",1.8,1.90255403042830],
["1kvd",1.8,1.91378196108310],
["1nh8",1.8,2.25675826338878],
["1om0",1.8,1.92212272986532],
["1au9",1.8,1.2921603312893],
["1aqn",1.8,1.33653292895676],
["1ak9",1.8,1.45790915795727],
["2st1",1.8,1.88165704793123],
["1yja",1.8,1.95663743378888],
["1yjb",1.8,1.82992793202926],
["1sbh",1.8,1.82077926524670],
["1yjc",1.8,2.37327004626197],
["1taw",1.8,2.05566522448918],
["3btm",1.8,1.65092016094330],
["1ydi",1.8,2.28610626495975],
["3btf",1.8,1.71213549263593],
["1a4w",1.8,2.91610131317683],
["1t6k",1.8,2.19467120918834],
["1i6n",1.8,1.86472727513959],
["1ig1",1.8,2.53045875177183],
["1ht3",1.8,2.68953001328642],
["2b6n",1.8,1.39335702045929],
["1tgs",1.8,2.36964449758715],
["1tom",1.8,2.30647738090549],
["1qbv",1.8,2.52252937755283],
["1h08",1.8,2.23435996109714],
["1q04",1.8,1.8447057306807],
["1z71",1.8,2.31302269382576],
["1nm6",1.8,2.09658912877199],
["1ntf",1.8,2.01492650648732],
["2bv5",1.8,1.66417767302609],
["1ypg",1.8,2.24519030474042],
["1oem",1.8,2.37965217041723],
["1r1w",1.8,1.80219477817606],
["1eok",1.8,2.43721535358915],
["1j35",1.8,2.71590577434876],
["1zgy",1.8,3.23183253247597],
["1w9a",1.8,1.18323516263224],
["1f0n",1.8,2.63733571728848],
["4pnp",1.8,2.26868470555602],
["1xxo",1.8,2.13223297683244],
["1z6e",1.8,2.64820404474032],
["1wdy",1.8,1.61567944988085],
["1yvt",1.8,1.98622724132521],
["1ibe",1.8,2.63921871200718],
["1cho",1.8,2.7668757559938],
["1ay6",1.8,3.25997512446008],
["1ba8",1.8,3.2676993277951],
["1tml",1.8,2.05380810922867],
["1m6p",1.8,2.35586921386282],
["2evi",1.8,1.59915073776831],
["1rpj",1.8,1.99834472409230],
["6hbi",1.8,1.6796517507512],
["2aup",1.8,1.94425255004598],
["2auq",1.8,1.71893279509747],
["1eb1",1.8,2.52014926066916],
["1kxn",1.8,2.09293382831331],
["1nar",1.8,2.38374327293084],
["4dcg",1.8,2.36373841300766],
["3mag",1.8,2.45919833351817],
["1v39",1.8,2.48467747731572],
["1mtz",1.8,2.30279929228202],
["1xro",1.8,2.80473900853064],
["2c6i",1.8,2.50386031121082],
["1kjw",1.8,1.91156117318282],
["1amp",1.8,1.88157620530580],
["1ryc",1.8,1.91978105440956],
["1cca",1.8,1.95386146059285],
["1hcl",1.8,2.72068522942331],
["1g5f",1.8,2.07163159175946],
["1g4h",1.8,2.07689134580041],
["2fvh",1.8,2.22029020429558],
["1yhv",1.8,2.79018017728883],
["1yhw",1.8,3.02640464552873],
["1c3d",1.8,1.97720198845495],
["1k5p",1.8,1.84814776469039],
["1k63",1.8,1.74124102702109],
["1b2r",1.8,2.19835024040801],
["1h72",1.8,1.65251791931536],
["1w7x",1.8,1.67035940753528],
["1r4s",1.8,1.91119589682747],
["1j7k",1.8,1.57564945527899],
["1r0p",1.8,1.40064124125735],
["1c83",1.8,2.48158014793959],
["2c27",1.8,2.35304983389774],
["1dbx",1.8,2.23237835014265],
["1in6",1.8,2.0607173122791],
["2exm",1.8,2.95572921951897],
["1ykr",1.8,3.04084065729026],
["2bge",1.8,2.36971999841925],
["1inn",1.8,1.87794822386398],
["1k2e",1.8,1.82526641235889],
["1zuo",1.8,1.86230477055128],
["2por",1.8,1.86437503316279],
["1tux",1.8,2.20460985799911],
["1ksh",1.8,2.54542518514385],
["1j7x",1.8,2.53058466996195],
["1eeo",1.8,2.25715076636695],
["1goq",1.8,2.41586055451568],
["1ptz",1.8,1.99163546641576],
["1m6m",1.8,2.18756544978284],
["1mwd",1.8,2.08385901693065],
["1u5a",1.8,1.12086906930901],
["1jhf",1.8,2.16010099432877],
["5abp",1.8,2.31204989321151],
["1fs1",1.8,2.97874475168286],
["1g55",1.8,1.95609918268299],
["1h6u",1.8,2.15630311651443],
["1doz",1.8,1.58719205358199],
["1beb",1.8,3.06170317786872],
["1pgs",1.8,2.68201816569907],
["1pyf",1.8,2.06145071117772],
["1exp",1.8,2.03928431504526],
["2exo",1.8,2.12939834422359],
["1b6t",1.8,2.46255056250841],
["1g85",1.8,2.18514214735943],
["1ta8",1.8,1.58105942845308],
["1gt3",1.8,2.52618746738099],
["2a0k",1.8,1.10165069699009],
["1az1",1.8,2.26516296705165],
["1tag",1.8,1.97284963383802],
["1cs8",1.8,1.86153956911462],
["1t26",1.8,1.77955013748545],
["1xov",1.8,2.00742409349205],
["1s2c",1.8,1.60677624321106],
["1kr6",1.8,1.57726304379668],
["1kl6",1.8,1.60077515842732],
["1pe8",1.8,2.10720397114847],
["1lnb",1.8,2.12265629117921],
["1lnc",1.8,2.16742594870449],
["1dhj",1.8,2.48838609760023],
["1k6i",1.8,2.37651326099223],
["1j5x",1.8,1.8377508653113],
["1t40",1.8,2.26671950469180],
["1j4r",1.8,2.45531440248814],
["1vzo",1.8,2.4095741782615],
["2esr",1.8,2.02948154192851],
["1vhs",1.8,1.86054957696879],
["1qs7",1.8,1.90842317013551],
["1b0w",1.8,2.90958581143910],
["1b2x",1.8,1.79645941328448],
["1a73",1.8,2.06285493027800],
["1pot",1.8,3.33683863020633],
["3app",1.8,2.13430881595066],
["1tl9",1.8,1.86152064523315],
["1bg2",1.8,2.72834563654323],
["1xfk",1.8,1.90348827587474],
["2apr",1.8,1.38729235124925],
["1apt",1.8,1.74597676063060],
["1apv",1.8,1.62735313436224],
["1apw",1.8,1.78515699282784],
["1apu",1.8,1.85583364594882],
["1ppk",1.8,1.79060602938765],
["4pep",1.8,2.73947296693636],
["1euj",1.8,2.39456581001361],
["2ag4",1.8,1.61340230626411],
["1wko",1.8,1.62761975001921],
["3apr",1.8,1.45599607778886],
["2d2h",1.8,1.97050874582952],
["1fqe",1.8,2.39617302310649],
["1d3k",1.8,2.25825536588496],
["1a8f",1.8,2.44092350286175],
["1nv0",1.8,2.68411865754579],
["1lf2",1.8,2.78023090828715],
["1n5n",1.8,2.19714396516002],
["1nkp",1.8,2.41523838721272],
["1tr9",1.8,1.84354265000286],
["1rhc",1.8,1.87307490100682],
["1v1t",1.8,2.02803105921928],
["1i9z",1.8,2.55358610075373],
["1c02",1.8,2.22627012287084],
["5er2",1.8,2.32397907527004],
["1xud",1.8,1.74710404253015],
["1vai",1.8,2.97924307613759],
["1fob",1.8,2.08126080194180],
["2f0a",1.8,2.44035752024521],
["2g3t",1.8,2.53461934963791],
["2b9f",1.8,2.17208293197678],
["2sec",1.8,1.77154894803955],
["1gzb",1.8,2.25375005357956],
["1j71",1.8,2.05697573441508],
["3er5",1.8,2.02993544327967],
["1e6c",1.8,2.41548690013772],
["2ben",1.8,1.78585701083662],
["1a9y",1.8,2.12696999142275],
["1nah",1.8,1.71161005855252],
["1xel",1.8,1.97094364379079],
["1uda",1.8,2.10642165530325],
["1lrl",1.8,2.21615716412693],
["1et8",1.8,1.85672518838753],
["1slu",1.8,2.39059043196398],
["9wga",1.8,3.1748768905655],
["1vbi",1.8,2.00913528568526],
["1weh",1.8,1.79009635626649],
["1gjp",1.8,2.83708656792128],
["1uxy",1.8,1.76830732535068],
["2mbr",1.8,2.21556655205722],
["1wx2",1.8,2.40733743227587],
["1mo1",1.8,1.87986826467523],
["1foa",1.8,2.14561940927237],
["2aq2",1.8,2.25554655563],
["1unk",1.8,2.51988921859453],
["1y3d",1.8,1.49684411232250],
["1y3b",1.8,1.75851688372235],
["1y33",1.8,1.90619675662929],
["1s9d",1.8,1.96595892501774],
["1dgm",1.8,1.68569660693072],
["1xiy",1.8,1.97570823636936],
["1ek5",1.8,2.38643295867638],
["1j1p",1.8,2.0302107687644],
["1j1x",1.8,2.01580776664672],
["1j1o",1.8,2.18981100706228],
["1v33",1.8,2.18293049786324],
["1bg6",1.8,2.77967742300265],
["1jh8",1.8,2.45661638690968],
["2a5d",1.8,1.87443901103940],
["1ag9",1.8,1.82156949172840],
["1vfb",1.8,1.83315952520359],
["1g7i",1.8,2.51651539731314],
["1vfl",1.8,2.73022692469172],
["1zzc",1.8,2.06525698258709],
["1w8k",1.8,2.72756236459889],
["1vpr",1.8,1.85615472129996],
["1nvk",1.8,1.68177032686006],
["1boa",1.8,1.42506760612303],
["1wbs",1.8,1.96399644833491],
["1h6l",1.8,2.15603910455256],
["1ka0",1.8,2.07513746529628],
["1bn5",1.8,1.53641569528135],
["1b59",1.8,1.52654400110962],
["1x83",1.8,2.56725756258431],
["1xuo",1.8,1.61942584299701],
["1lkc",1.8,1.76347649632737],
["1m4g",1.8,2.03330359841852],
["1m4d",1.8,1.90656379278486],
["1lc8",1.8,1.91267946053100],
["1r4z",1.8,1.77937188306038],
["1udz",1.8,2.52330504841512],
["1tfz",1.8,2.48233263406132],
["1iq4",1.8,2.57508049973521],
["1uro",1.8,1.86891179604696],
["1umg",1.8,2.05635198612410],
["1qkr",1.8,1.96358060836246],
["1xqf",1.8,1.29901970805462],
["1lc7",1.8,2.15033260283375],
["1ytb",1.8,2.20213087090349],
["2fik",1.8,2.27932864113119],
["1jpu",1.8,1.81805724616533],
["1jh6",1.8,2.61512141856416],
["1jta",1.8,2.2119963937311],
["1d3h",1.8,1.86975221918179],
["1l8b",1.8,2.72010938216323],
["1lfa",1.8,2.35527136994384],
["1vys",1.8,2.24326128988893],
["1i59",1.8,2.53012359241793],
["1sqd",1.8,2.21231864813501],
["1qna",1.8,2.00199641439049],
["1tqf",1.8,1.74497190952952],
["1vk8",1.8,2.29236063656925],
["1ke1",1.8,1.93758132122934],
["2b8v",1.8,2.12220620150706],
["1dmb",1.8,3.14826687925669],
["1lls",1.8,2.21859436097336],
["2psg",1.8,2.24332118281659],
["1atz",1.8,1.65134722684661],
["1r86",1.8,1.98726192268596],
["2aob",1.8,2.53737912781999],
["1k4h",1.8,2.35361863970561],
["1qxj",1.8,1.95500887520265],
["1qy4",1.8,2.22212489143174],
["1c3p",1.8,2.99967147206331],
["1urg",1.8,2.04177959604053],
["1wyb",1.8,1.62750392832117],
["1iir",1.8,1.56523529014153],
["1lm5",1.8,2.37596319071589],
["1uhh",1.8,1.67156596241738],
["1uhj",1.8,1.86720987597079],
["1uhi",1.8,2.26045879997394],
["1fzm",1.8,1.63735553176177],
["1vd5",1.8,1.83850872671197],
["1fzo",1.8,1.74450633230524],
["1uvq",1.8,1.53981850926693],
["2ccm",1.8,2.34302480891319],
["2sic",1.8,3.32117122399698],
["3sic",1.8,3.39189642092624],
["2fur",1.8,1.56973493353263],
["2axf",1.8,2.05430338727934],
["1isa",1.8,1.84122363956593],
["1isc",1.8,1.61488955982337],
["1za5",1.8,2.26073324781472],
["1cs6",1.8,2.15237870294250],
["1fc6",1.8,2.38863255927171],
["1nnc",1.8,2.19992431317714],
["1l7f",1.8,1.99403012338221],
["2qwg",1.8,2.29034060453501],
["1f8b",1.8,2.50505482802778],
["2qwh",1.8,2.23774990864757],
["2qwk",1.8,2.36917887222199],
["1n4g",1.8,1.557344908613],
["1kk1",1.8,2.18561894489405],
["1gus",1.8,1.8415422721013],
["1k0i",1.8,1.96397939520971],
["1ars",1.8,3.08782904059564],
["1art",1.8,3.04365192726536],
["1f5j",1.8,1.75519359279990],
["1vca",1.8,2.60587860610344],
["2fnj",1.8,2.43745182968302],
["1xuq",1.8,2.05501745094683],
["1atl",1.8,1.87137048015951],
["2bsp",1.8,1.94899609355915],
["1bn8",1.8,1.61212517079581],
["1xqd",1.8,1.77382036466986],
["1xre",1.8,2.26511392389079],
["1r1p",1.8,2.55376685516974],
["2bwm",1.8,1.45880550644472],
["1aye",1.8,1.95632353889233],
["1k3o",1.8,2.65507235559201],
["1dlj",1.8,1.68473465943770],
["2d09",1.8,3.17381771277095],
["3mds",1.8,1.86623166084885],
["1mng",1.8,1.86615335590968],
["2cz7",1.8,1.49603648537964],
["1akd",1.8,2.17998895790385],
["1oe7",1.8,2.42522821654002],
["1yac",1.8,1.74004184476305],
["1t85",1.8,2.08324913413050],
["1ajk",1.8,1.82619616799771],
["1x8d",1.8,2.1967345867663],
["1sjn",1.8,1.57389960959521],
["1hdi",1.8,2.39530955322358],
["1zjc",1.8,1.70424643382273],
["3bam",1.8,2.82984961868271],
["1vgt",1.8,2.17149926313034],
["1glq",1.8,1.72377009563301],
["1pgt",1.8,2.2648589425871],
["1f5s",1.8,1.91338119576333],
["1l7n",1.8,2.09296780924403],
["1wy1",1.8,1.55689394472826],
["1ejc",1.8,1.80665669525372],
["1uae",1.8,2.15823432968899],
["1ia6",1.8,1.53516652749036],
["1t2w",1.8,2.53708600022093],
["2bjb",1.8,1.89719241160991],
["1xbz",1.8,1.59856341379768],
["1jax",1.8,1.70212928418277],
["1k70",1.8,1.83165409122387],
["1uj2",1.8,1.84891847076625],
["2c9h",1.8,2.06888828950407],
["1so5",1.8,1.71921420829499],
["1q6l",1.8,1.53392405845991],
["1ugr",1.8,1.51775123917634],
["1ire",1.8,1.52512128017615],
["1n7m",1.8,2.41300070343291],
["2a77",1.8,2.83315278851135],
["1q25",1.8,3.05830952828632],
["1yks",1.8,2.60501158304114],
["1kcv",1.8,2.74851706492162],
["1vfr",1.8,1.77936730008714],
["1xw5",1.8,1.96109169504320],
["2gst",1.8,2.44952088159228],
["1ve2",1.8,2.33521404101325],
["1auo",1.8,2.44803621281175],
["1um4",1.8,2.64974269206245],
["1um6",1.8,2.88045224103799],
["1l7i",1.8,2.17038718691046],
["1amz",1.8,2.64705959128849],
["2b4v",1.8,1.66113824264887],
["1jgu",1.8,2.33426958494819],
["1r89",1.8,2.04600874612162],
["1jjt",1.8,2.66243491385054],
["1qup",1.8,2.09753165091224],
["1hyy",1.8,3.09754137123552],
["1hyx",1.8,3.40767722836744],
["1pl2",1.8,1.51892710920003],
["1jje",1.8,2.77042136498627],
["1k0n",1.8,2.22036812964615],
["1pz5",1.8,2.26210197490815],
["1dll",1.8,2.7934276333704],
["1swl",1.8,2.43852542853013],
["1xp2",1.8,2.09499460475832],
["1rtm",1.8,1.98613096257574],
["1nc9",1.8,2.88433020074058],
["1bu8",1.8,2.16908776929795],
["4aop",1.8,2.26379045929494],
["1g9h",1.8,1.65555910200382],
["2gi3",1.8,1.45656495108440],
["2boj",1.8,1.50284074765512],
["6gep",1.8,1.99076250081557],
["1len",1.8,2.74494377996861],
["2lal",1.8,3.09648470744662],
["1swc",1.8,2.83556215719902],
["1swg",1.8,2.20862108339942],
["1h0b",1.8,1.84857321935530],
["2blf",1.8,1.17486270242987],
["1py6",1.8,2.51298005814457],
["1bkj",1.8,1.05716066606688],
["1m6i",1.8,1.89127084341659],
["1tv4",1.8,1.78198100640876],
["1zw0",1.8,2.52058786505114],
["1hyl",1.8,2.27417775204287],
["1lvm",1.8,2.57813181708614],
["1k7q",1.8,1.65163728449182],
["6cha",1.8,3.54287797475136],
["1xcf",1.8,2.77256744196345],
["1dug",1.8,2.76515019260338],
["1gx1",1.8,2.11563953660127],
["1t4h",1.8,1.91273127937896],
["1vyb",1.8,1.95145775049761],
["1lfw",1.8,2.4221533305534],
["1h8z",1.8,2.46957863476580],
["1j09",1.8,2.24634550524000],
["1ny1",1.8,2.08275042594546],
["1af0",1.8,1.69164735559114],
["1suz",1.8,2.50047857223944],
["1w1q",1.8,1.37296339086818],
["1rk5",1.8,1.64709371484461],
["1rjq",1.8,1.61135721113683],
["1rjp",1.8,1.54409370473070],
["1qnf",1.8,2.97985613717251],
["1xff",1.8,2.06012295532454],
["1kgi",1.8,2.25739344714669],
["1jsd",1.8,2.20142815879327],
["1cy9",1.8,2.17383768252264],
["1s1a",1.8,1.70243696975546],
["1nlv",1.8,2.79852852680659],
["1nm1",1.8,2.49557392983481],
["1kl5",1.8,2.18554388409709],
["1tph",1.8,2.00012411933323],
["2cga",1.8,2.59118794568593],
["6std",1.8,1.78121735396433],
["7std",1.8,2.22002821180733],
["2etg",1.8,2.24237653994127],
["1i45",1.8,1.81628057208976],
["1fpo",1.8,1.99179306783324],
["1wn5",1.8,1.45351116962021],
["1hny",1.8,2.04327231522571],
["1gr7",1.8,1.47071788531727],
["1tpf",1.8,2.53628024768893],
["1fxp",1.8,2.11091476557399],
["3cox",1.8,1.88674794393431],
["1cbo",1.8,1.93464708366707],
["1fvu",1.8,2.37165217316657],
["1a28",1.8,2.02880271265626],
["1coy",1.8,1.93662628415777],
["1vic",1.8,2.21394819435545],
["1sd3",1.8,2.05684249734574],
["1s9t",1.8,2.11427006766524],
["1lbv",1.8,3.10710052510989],
["1jcx",1.8,2.18453390198752],
["1woq",1.8,2.10063088587429],
["1dxe",1.8,2.09377447779861],
["1xq6",1.8,2.51783153770619],
["1rwi",1.8,1.85450919782496],
["1vc4",1.8,1.97498714914710],
["1lro",1.8,2.15195172355716],
["1t8x",1.8,2.16701493813811],
["1pck",1.8,2.01701634571396],
["1fmc",1.8,2.38404719702078],
["1uuz",1.8,2.41224216072919],
["1ftl",1.8,1.76434725968227],
["1p1w",1.8,1.89106393019886],
["1i22",1.8,2.85918132174161],
["1lrq",1.8,2.08561619864797],
["1oyw",1.8,2.17580968419788],
["2aqj",1.8,2.10612223360279],
["1b1h",1.8,1.71098918262975],
["2rkm",1.8,1.80286240473420],
["1b6h",1.8,1.91359566094434],
["1b51",1.8,1.86978639004979],
["1b9j",1.8,1.82491520872650],
["1b3f",1.8,1.93857611944816],
["1b58",1.8,2.16006508981067],
["1qka",1.8,1.80009830842296],
["1b5j",1.8,1.89972421768398],
["1qkb",1.8,2.04134992320487],
["1b46",1.8,2.01750116734768],
["1qx4",1.8,2.33527963977315],
["1fxq",1.8,2.08808939186737],
["1x1n",1.8,1.53023649872197],
["1fsj",1.8,1.48723134492127],
["1y1m",1.8,1.95774422117204],
["1umz",1.8,2.31519624989807],
["1ayl",1.8,2.23881913682059],
["1ea5",1.8,2.10100630276152],
["1dg3",1.8,1.94509382056164],
["1k9t",1.8,2.07298508328575],
["1tyv",1.8,1.50815447713359],
["1qq1",1.8,1.65626320183713],
["1tyx",1.8,1.80737065487800],
["1tyw",1.8,1.82347406886031],
["1tyu",1.8,1.79106780225188],
["1eib",1.8,1.41288024155412],
["1ffr",1.8,2.09839547605108],
["1thg",1.8,1.72165413963396],
["1w2f",1.8,2.67825738194489],
["1p7p",1.8,1.85050455837924],
["1mna",1.8,2.68608435083205],
["2a61",1.8,2.07418350399244],
["1nby",1.8,2.48451728120312],
["1svd",1.8,1.52834169183180],
["1vla",1.8,1.68467063335043],
["1qwi",1.8,1.65716730270931],
["1mpg",1.8,1.81415307131669],
["1m38",1.8,2.43338483657203],
["1o6s",1.8,2.13281321199715],
["1a3n",1.8,1.57421592609776],
["1a3o",1.8,1.91563234715437],
["1kss",1.8,2.09968644449997],
["1qjd",1.8,2.68327692871857],
["1gbu",1.8,2.33947001850469],
["1a01",1.8,2.20549856962988],
["1o1n",1.8,2.02311893345035],
["1r1y",1.8,1.83482491941402],
["1qpw",1.8,2.99526889573328],
["1qi8",1.8,1.99364637820968],
["1ye2",1.8,2.31672401296620],
["1o1o",1.8,2.12388635407048],
["1yvq",1.8,1.84060955473999],
["1sdk",1.8,2.65220759356231],
["1sdl",1.8,2.81536053136854],
["1fhj",1.8,2.74263772040107],
["1n2g",1.8,1.41807121383839],
["1a3a",1.8,1.80253421206228],
["1o1p",1.8,1.89774916284515],
["1c7c",1.8,1.88808865267336],
["1o1l",1.8,2.20000786078811],
["1hy3",1.8,2.16387678214198],
["1n2j",1.8,1.67190704589277],
["1c7d",1.8,2.09134913361984],
["2aa1",1.8,1.63318069193930],
["1gx0",1.8,1.78367090116319],
["1gww",1.8,1.98099608369882],
["1f7b",1.8,1.32977047206906],
["1feh",1.8,1.97973759803835],
["1pym",1.8,2.23328907700855],
["1p2n",1.8,1.32109392419143],
["1t8m",1.8,1.43118242756706],
["1p2q",1.8,1.69753456262848],
["1f0y",1.8,1.91785125778257],
["1nkc",1.8,1.55045052808232],
["1nke",1.8,1.78292684450796],
["1l3u",1.8,1.98083932986619],
["4bdp",1.8,2.89535001110939],
["2bdp",1.8,2.71763190338550],
["19hc",1.8,1.52717232839068],
["1pxv",1.8,2.20447045942346],
["1wlg",1.8,2.20891554085174],
["1ypf",1.8,2.40520598931559],
["1o5k",1.8,1.74921205192462],
["1h4r",1.8,2.070729957914],
["1v5f",1.8,2.14811050720918],
["1uxk",1.8,2.01638109298123],
["1s5o",1.8,2.74191851853549],
["2f57",1.8,1.38084472547376],
["1v99",1.8,2.02443364515162],
["2fcv",1.8,1.52434690279264],
["1yj7",1.8,1.65106487135219],
["1s4i",1.8,3.5834213901901],
["2ber",1.8,1.76958021361671],
["1qfy",1.8,2.27487248887147],
["1x39",1.8,1.93622982097812],
["1uf8",1.8,1.72509557457506],
["1xxq",1.8,2.05204797367190],
["1i1d",1.8,2.12887163675126],
["2bdw",1.8,2.42028196421848],
["1wwr",1.8,2.60560982440406],
["2bfy",1.8,2.40982485763495],
["1jrc",1.8,1.96189364336434],
["1jue",1.8,1.84925724363769],
["2bfx",1.8,2.56536261922270],
["1ytl",1.8,2.28796678322061],
["1qwr",1.8,2.11774163219815],
["2b7k",1.8,2.17946093098391],
["1y9i",1.8,1.94789180233339],
["1rli",1.8,2.13652358375774],
["1y4t",1.8,2.19950977787067],
["1dl5",1.8,1.66589657212196],
["1ebl",1.8,2.56592279735574],
["2cyb",1.8,2.27866633621273],
["1oau",1.8,3.00314694304142],
["1ig0",1.8,2.47385261270258],
["1g16",1.8,2.08483745525913],
["1k6j",1.8,2.07092198843220],
["1uh4",1.8,2.37134875367959],
["1bdm",1.8,2.53845873681255],
["1f1r",1.8,1.55017637657765],
["1z08",1.8,1.44861038716942],
["1kfj",1.8,2.06055775186159],
["1qoq",1.8,1.57168121202648],
["1w4v",1.8,2.42067666851093],
["1vbu",1.8,1.64799834824456],
["1vbr",1.8,1.95562024655789],
["1gad",1.8,2.30921589510443],
["1n7h",1.8,1.28494862667428],
["1x88",1.8,2.06198230600382],
["1nxu",1.8,2.61715220283068],
["1hrn",1.8,3.19690064835737],
["1hxp",1.8,2.52755434353054],
["1ujn",1.8,2.01353298764048],
["2cwf",1.8,1.63351977610458],
["1z48",1.8,1.87931004078865],
["1jp7",1.8,2.22023871306624],
["1yr2",1.8,1.55676526577795],
["2udp",1.8,2.36350140116764],
["1a6v",1.8,3.68946456555226],
["1pm2",1.8,2.12083809037768],
["1u7h",1.8,1.77535412488037],
["3sli",1.8,2.35440639035471],
["2sli",1.8,2.37604772085358],
["4sli",1.8,2.43491683363380],
["1v1r",1.8,1.98903634117234],
["1zze",1.8,1.82864434444236],
["1mmz",1.8,2.50763102745072],
["1nsu",1.8,2.48790249795064],
["1mmx",1.8,2.49403359093443],
["1mmu",1.8,2.41599517954582],
["1nsr",1.8,2.65392388272432],
["1nsv",1.8,2.66927827684784],
["1ns8",1.8,2.61125713903506],
["1qpa",1.8,2.19989782337427],
["3pro",1.8,1.93504165909873],
["1usi",1.8,1.62161416340431],
["1ket",1.8,1.56314570808155],
["1b82",1.8,1.35389729969074],
["1wvg",1.8,3.22671201149809],
["1jpv",1.8,2.46508342945551],
["1sxq",1.8,1.75280812862512],
["1m5r",1.8,1.97323415657556],
["1f7t",1.8,2.12475919470085],
["1ll5",1.8,1.85104062147553],
["1n71",1.8,2.57660457765257],
["2bjr",1.8,1.72064735713381],
["1j1b",1.8,2.81103342097603],
["1tf1",1.8,2.44646802119837],
["2cd9",1.8,1.87570507249214],
["1ld8",1.8,1.92986362312915],
["1kew",1.8,1.98605658212016],
["2bev",1.8,1.92675122789298],
["2a1h",1.8,1.81627961113689],
["1fn9",1.8,1.54116414576778],
["1tn6",1.8,1.50503166644290],
["1ytv",1.8,2.02829057968095],
["1p0f",1.8,1.84505487837043],
["1v4v",1.8,2.58555648936769],
["2gdq",1.8,1.84374105910047],
["1qv6",1.8,1.42930952166511],
["2ohx",1.8,1.95402059567587],
["1qv7",1.8,1.78529243300993],
["2nac",1.8,1.97388979753551],
["1yx1",1.8,1.87803402665441],
["1ci9",1.8,2.28893775513241],
["1x1i",1.8,2.31528620106068],
["1dqs",1.8,1.69101901954474],
["1qnn",1.8,2.3563866547014],
["1xql",1.8,2.18404622274032],
["1y0b",1.8,1.76392866125754],
["1i7u",1.8,1.99131668804091],
["1duz",1.8,2.103348606809],
["1tvb",1.8,1.98851877516582],
["1elq",1.8,2.36755378126259],
["1bjw",1.8,2.37833196963531],
["1t0n",1.8,2.33292383693234],
["1gm9",1.8,1.94055645567437],
["1b5p",1.8,2.5480292959084],
["1qo7",1.8,1.59423051926189],
["1el5",1.8,2.12897858059540],
["1xym",1.8,2.10356245449064],
["1xyl",1.8,2.20633442410372],
["1my2",1.8,2.34286077631848],
["1mxu",1.8,1.92091996615134],
["1lbc",1.8,2.27229757438992],
["1gd9",1.8,2.51032129308624],
["1gde",1.8,2.09309650405465],
["1nzc",1.8,2.24193544128078],
["2a97",1.8,2.90020964599914],
["1v7v",1.8,2.02404660826639],
["1nsd",1.8,2.05944789772636],
["1afw",1.8,3.13001132850049],
["1iyi",1.8,1.91698389053313],
["2as0",1.8,2.17219632180549],
["1h2a",1.8,2.92446089622439],
["2c25",1.8,1.49567294771113],
["1nzy",1.8,2.63769871506657],
["1vme",1.8,1.33195670584206],
["1k06",1.8,2.81942355825916],
["1t3i",1.8,1.76593180027575],
["1ww3",1.8,2.51663422828601],
["1o76",1.8,2.19837287125142],
["1t87",1.8,1.86631962202404],
["1rzh",1.8,1.94094421680474],
["1e3a",1.8,1.83939155685163],
["1giq",1.8,2.72545123753809],
["1jny",1.8,2.82899543488907],
["1o9p",1.8,2.13840440761031],
["1och",1.8,2.30803431606405],
["1o9q",1.8,2.3033168425725],
["1ock",1.8,1.88068468126468],
["1skq",1.8,2.83476430151763],
["1tu8",1.8,1.90199563535653],
["1pt7",1.8,1.99420623015812],
["1ed5",1.8,2.41696707060718],
["1aqw",1.8,1.95413271303829],
["1o2a",1.8,1.87207240937123],
["1xtt",1.8,2.24821687316932],
["8fab",1.8,2.21992634633473],
["1c3c",1.8,2.02447297051475],
["1dqq",1.8,2.61715120100847],
["1esj",1.8,2.43913403518494],
["1uz8",1.8,2.13680035885189],
["1ngx",1.8,2.63612062805002],
["1qj5",1.8,2.03640594682861],
["1c7s",1.8,2.32359610620694],
["1kqc",1.8,1.70983123520766],
["1kqb",1.8,1.66244695736659],
["1icu",1.8,2.40732080578564],
["1te6",1.8,2.57747286065485],
["1v6c",1.8,2.00322574532844],
["1rqp",1.8,2.30714369106831],
["1p43",1.8,2.01833826458672],
["1yqp",1.8,2.11560210532239],
["1zhs",1.8,1.57496826720772],
["1i4y",1.8,2.21300201145355],
["1hcj",1.8,2.43004979257129],
["1s57",1.8,2.15387054523857],
["1n0x",1.8,2.43864850192209],
["1jou",1.8,2.58407404079830],
["1vdk",1.8,1.97923649042651],
["1gqy",1.8,1.99394126906373],
["1m0w",1.8,1.84547250819032],
["1ro7",1.8,2.20701964974158],
["1cyd",1.8,2.22845530432074],
["1e4d",1.8,2.06180243063503],
["1m21",1.8,1.68825352288473],
["2bek",1.8,2.05495134550265],
["1vga",1.8,2.0239950299317],
["1m2w",1.8,1.48398263302934],
["1xm3",1.8,2.30700481836566],
["1rjd",1.8,1.89111468437317],
["2bk3",1.8,1.95228740581370],
["1qw8",1.8,2.30998094520459],
["1ur9",1.8,2.63602155535368],
["1aom",1.8,1.7657535946148],
["1zlq",1.8,2.15939257425908],
["1pwx",1.8,3.59489056437583],
["1zdq",1.8,1.33199283151228],
["1npn",1.8,2.21378503202951],
["1fd7",1.8,2.00061972763372],
["1eef",1.8,1.90045876468693],
["1r33",1.8,1.59309996540483],
["1ps3",1.8,2.09134060296418],
["2bhp",1.8,1.59185639107801],
["1xu7",1.8,2.21352982763860],
["1xk4",1.8,1.96155515329362],
["1o60",1.8,2.24489707992837],
["1sio",1.8,2.43247735185545],
["1sw5",1.8,1.85612219087806],
["1naa",1.8,1.28628500995881],
["1kbq",1.8,2.75677558315083],
["1t6g",1.8,1.80242708139427],
["2dbw",1.8,2.08240042746544],
["1aoq",1.8,1.87934061372401],
["1hm5",1.8,2.37225121619888],
["1o58",1.8,1.61570494346058],
["1cxp",1.8,1.94092367615640],
["1m64",1.8,1.87388925558824],
["2cvz",1.8,1.89666135451525],
["1xs1",1.8,2.63386133374038],
["1jq3",1.8,1.94356494685850],
["1gpe",1.8,1.82306570191449],
["1hl2",1.8,2.07576487558712],
["1thz",1.8,1.88646990080861],
["1ndb",1.8,1.74265485783141],
["1t7q",1.8,1.75691968929755],
["1mr7",1.8,2.15791701727313],
["1hfw",1.8,2.02148829496870],
["1hg1",1.8,2.17713253312711],
["1k72",1.8,1.67219133268602],
["1iqc",1.8,2.56041791896163],
["1ja1",1.8,2.64754143169396],
["1ui8",1.8,1.90865590363667],
["1wmo",1.8,2.07710130819128],
["1wmn",1.8,2.16822583742601],
["1iu7",1.8,2.35211120370836],
["1iqy",1.8,2.39884638749207],
["1ivw",1.8,2.38112034078473],
["1ms1",1.8,2.02366936912072],
["1vqq",1.8,2.36229344616080],
["1mi3",1.8,1.34519645334962],
["2a40",1.8,1.67734111577753],
["1gd1",1.8,2.38231703399423],
["1vkn",1.8,1.57963590093264],
["1jds",1.8,1.61943347998585],
["1jg8",1.8,2.10061379822353],
["1pam",1.8,1.89892221668108],
["1guq",1.8,2.67877835483935],
["1gup",1.8,2.7912779457336],
["1clx",1.8,2.42099879206000],
["1je1",1.8,1.9594981371848],
["1rkx",1.8,2.26238015680018],
["1epx",1.8,2.32164969022353],
["1wap",1.8,2.13034596817094],
["1zah",1.8,2.40489175445848],
["1ryi",1.8,1.95948892503768],
["1mg0",1.8,1.62784757829701],
["1wxx",1.8,1.78908312713666],
["1j2t",1.8,1.73386905972148],
["1wz8",1.8,2.09234409606636],
["1r9d",1.8,2.05498929467810],
["2fje",1.8,2.14505710270052],
["1ukj",1.8,3.53500557974299],
["1l5w",1.8,2.23573301559415],
["1e3d",1.8,1.96486727365462],
["1w96",1.8,1.96609164045079],
["1f8m",1.8,2.18393196666870],
["1uc4",1.8,2.32055966576973],
["1e0t",1.8,3.04096904875240],
["1gu1",1.8,1.59478502263056],
["1d0i",1.8,1.98359590044184],
["1wog",1.8,2.24136948751416],
["1tez",1.8,2.125329945963],
["1m7s",1.8,1.98635877230928],
["1dgg",1.8,2.43628713569374],
["1xvb",1.8,2.4684230451014],
["1yif",1.8,2.21996867296429],
["1tt0",1.8,1.71675663974244],
["1ir1",1.8,2.16078763015934],
["1h0h",1.8,1.93251710285254],
["1hbm",1.8,1.50998075757490],
["1t3q",1.8,2.13705636879235],
["1tr0",1.8,2.08859556095319],
["1z03",1.8,2.52709609595763],
["1z02",1.8,2.62268150818841],
["1z01",1.8,2.73233084787757],
["2fli",1.8,2.46649651556018],
["1m3u",1.8,1.37297234647188],
["1hl5",1.8,1.97429082657157],
["1cf9",1.8,2.12759912391718],
["1orv",1.8,2.59033628191957],
["1q52",1.8,2.19874433464288],
["1jyn",1.8,2.33772539643685],
["1jz5",1.8,2.50354184996076],
["1p7g",1.8,2.83850187763029],
["1flq",1.8,1.33628977183649],
["1zr0",1.8,2.71572841830199],
["1tvh",1.8,2.11582283411423],
["1c7b",1.8,1.99657981130273],
["2a10",1.8,1.47757372586524],
["1va4",1.8,1.92481602482395],
["1ywo",1.81,2.28222088027477],
["1m6t",1.81,1.73150212927036],
["1csu",1.81,2.61157287756768],
["1w7o",1.81,2.78255925805414],
["1gyu",1.81,2.30564732836051],
["1a34",1.81,2.28724826465153],
["1z06",1.81,1.64788413089352],
["1z07",1.81,1.26748710149791],
["1sht",1.81,1.9903463010831],
["1oej",1.81,2.47452789139093],
["1ucj",1.81,1.48305960209754],
["1ebw",1.81,1.79480221536266],
["1d4i",1.81,1.6630484631059],
["1d4h",1.81,1.49495346223472],
["1d4j",1.81,1.49495346223472],
["1yc4",1.81,2.20526731168830],
["1kg9",1.81,2.48311202757413],
["1fny",1.81,2.27156036761621],
["1o3p",1.81,2.90708103386096],
["1x8b",1.81,2.72255739955371],
["1xeg",1.81,1.96511773677915],
["1qyv",1.81,1.56728317681411],
["1ype",1.81,2.05354896587532],
["1sl3",1.81,2.40238118581106],
["1gj4",1.81,2.83190606011754],
["1q33",1.81,2.30785504384874],
["1jln",1.81,2.5480763498237],
["2c3f",1.81,1.4784112158243],
["1zoh",1.81,2.26423148536949],
["1fux",1.81,2.14188528171611],
["1v3y",1.81,1.85101855437428],
["1s38",1.81,2.44841932854070],
["1gqe",1.81,2.24852157433473],
["2c3w",1.81,2.22284230113678],
["2a78",1.81,1.93594993418822],
["1tc2",1.81,1.94980725500087],
["1xbx",1.81,1.39595468490368],
["1gnd",1.81,2.78546512902789],
["1qyg",1.81,2.00063045188612],
["1ndj",1.81,2.67762083129849],
["2fr0",1.81,2.55219549264608],
["1y9a",1.81,2.04073309139514],
["1c96",1.81,2.76353597351271],
["1xya",1.81,2.18410267186383],
["1mly",1.81,2.33195153694958],
["1l7d",1.81,2.45906205103539],
["1p81",1.81,2.11874313607341],
["1flw",1.81,1.41905558989247],
["1zt5",1.82,2.08110566840705],
["1imx",1.82,2.30035859433331],
["1ybz",1.82,0.759602177677527],
["1be9",1.82,2.45714946536150],
["1nxp",1.82,2.63273807354162],
["1x6r",1.82,1.77313895679066],
["2rtk",1.82,2.60416220853913],
["1vwb",1.82,2.54969679005419],
["1hc0",1.82,2.51391718693761],
["1jap",1.82,2.37469129950399],
["1gto",1.82,2.50342649851161],
["1h8p",1.82,1.67499444942929],
["1uec",1.82,2.07653105732639],
["1v98",1.82,1.89282007466927],
["1ucl",1.82,1.54663938007828],
["1iv7",1.82,2.52800935050823],
["1jf0",1.82,2.21754732676569],
["1vaj",1.82,2.16601431841363],
["1ini",1.82,2.25575231681694],
["2a7l",1.82,1.78759090039346],
["2cbe",1.82,2.00195834215189],
["1h9s",1.82,2.09683933745388],
["1xrl",1.82,2.93443867858195],
["1stq",1.82,1.97487626581498],
["5a3h",1.82,1.55980967987494],
["1gy2",1.82,1.94719039148706],
["1fh7",1.82,2.05619544707908],
["1pe7",1.82,2.27849206933751],
["1v73",1.82,2.43596219051443],
["1dw0",1.82,1.74952354068034],
["1fp1",1.82,2.23717527378399],
["1eur",1.82,2.75444416330765],
["1ia2",1.82,2.21365976503247],
["1n0n",1.82,2.20571566626668],
["1hw5",1.82,3.28839068825878],
["1w78",1.82,2.18217349772382],
["1v84",1.82,2.39998099959721],
["1zsq",1.82,2.69510388244529],
["1ry9",1.82,1.91824838778967],
["1hl4",1.82,2.31633879483439],
["1uze",1.82,1.97962726604975],
["1b2s",1.82,1.76889063910263],
["1nqx",1.82,1.26706343820001],
["1dmr",1.82,1.67093646061558],
["1vp4",1.82,1.56972178919754],
["1iye",1.82,2.17984500786879],
["1wur",1.82,1.40046942026447],
["2bg5",1.82,2.51568210585037],
["1euh",1.82,2.08564820517294],
["1b65",1.82,2.40778487338994],
["1xb6",1.82,1.17573423283395],
["2hts",1.83,2.28958162428058],
["1s7z",1.83,2.29088734194711],
["1o13",1.83,1.11798009358310],
["1rfs",1.83,1.93077282313085],
["1r8o",1.83,2.78932591326285],
["1o5u",1.83,1.71805637002207],
["1iiq",1.83,1.62688987621322],
["1iae",1.83,1.78855717460983],
["1zrn",1.83,2.20111797665794],
["1wnh",1.83,2.26324182203406],
["1bit",1.83,2.38623874709274],
["1utj",1.83,1.51904035016848],
["1r9c",1.83,1.98934039359159],
["2bsj",1.83,1.72837463635518],
["1amk",1.83,3.05996624366343],
["2b44",1.83,1.47961860755782],
["1xwv",1.83,2.40339503097993],
["1g45",1.83,1.77068437144527],
["1vhb",1.83,2.38077733261993],
["1yqe",1.83,1.85447053141199],
["1dqy",1.83,2.47772051410766],
["1ylm",1.83,1.84534861475894],
["1bu5",1.83,2.51998312613469],
["1dzp",1.83,2.37777125030790],
["2fne",1.83,2.20344442234714],
["1hq0",1.83,1.81055069705406],
["1e00",1.83,2.45081625725465],
["1gn8",1.83,2.65195449949674],
["1c3i",1.83,2.14763525109586],
["1gun",1.83,1.77794965361437],
["1t2q",1.83,1.88542544812197],
["1ob0",1.83,1.60052969733000],
["1h7e",1.83,2.06615020604442],
["1tcd",1.83,2.42389746251618],
["5tim",1.83,2.60927499978695],
["1tx2",1.83,2.08610089496881],
["2g8x",1.83,2.35792539257665],
["1vlr",1.83,1.51064879351316],
["1z84",1.83,1.59791744371042],
["1xoq",1.83,1.47803249948661],
["1mxo",1.83,2.09386185900105],
["1u5b",1.83,1.86322903156104],
["1cl1",1.83,1.71640577210631],
["1xc7",1.83,2.11800197591235],
["1s09",1.83,2.08495671418017],
["2bk5",1.83,1.44450062049398],
["1w4r",1.83,1.7826907421254],
["1yqw",1.83,1.69549492428605],
["1fly",1.83,1.70009796215476],
["1fdn",1.84,1.96172292476866],
["1c4w",1.84,2.07274633143400],
["1b0d",1.84,1.38901467431279],
["2cj5",1.84,2.11342664458821],
["102m",1.84,2.45166232083028],
["1f8a",1.84,3.08064171224768],
["1xcm",1.84,2.15238599489558],
["1a44",1.84,1.97393417795178],
["1e4b",1.84,2.20108029779624],
["1xlo",1.84,2.05988565165863],
["1hne",1.84,3.35601940380765],
["1sqo",1.84,2.30113134554511],
["1g4j",1.84,1.91754211110836],
["1g46",1.84,2.28650316191824],
["1i9m",1.84,2.30451708468405],
["1zao",1.84,1.75982837663451],
["1tib",1.84,2.72194391560097],
["1ss4",1.84,1.94797588755472],
["1tz0",1.84,2.25755926871889],
["1rn1",1.84,1.89446599681672],
["1rkd",1.84,1.78345067939240],
["1y48",1.84,1.75504617083599],
["1i13",1.84,2.04848789340274],
["2cu5",1.84,1.65235015642397],
["1s3x",1.84,1.39164434575980],
["1cgk",1.84,2.08699056756724],
["1ze3",1.84,1.49924710354985],
["1aqk",1.84,3.52721572788219],
["2a4a",1.84,1.93521119607742],
["1sh7",1.84,2.01016003627909],
["1y4v",1.84,2.40587207423296],
["1sgj",1.84,2.28426964353697],
["1wci",1.84,1.85819837564686],
["1mb4",1.84,2.27853364953359],
["1o69",1.84,1.93389684617793],
["2ag5",1.84,1.62518871126534],
["1t2a",1.84,2.13778383383113],
["1v0z",1.84,1.99084020791296],
["2fjd",1.84,2.04867163269916],
["1jku",1.84,2.32961731734061],
["2c3m",1.84,2.30534586407411],
["1ir2",1.84,2.07766329208166],
["2bei",1.84,1.75200034150782],
["1mmi",1.85,2.89215970991088],
["1j8e",1.85,1.59448514359519],
["1cgd",1.85,1.86146234194427],
["1cag",1.85,2.18741920671845],
["1j75",1.85,2.19654746865113],
["1t7b",1.85,2.01627454087291],
["1igv",1.85,2.04217170444496],
["2cwy",1.85,1.57043531410099],
["1she",1.85,1.60791000954268],
["2byg",1.85,1.24414201589329],
["1i2g",1.85,1.62929001271427],
["1o4d",1.85,2.14474210292525],
["1o4b",1.85,2.18908948826351],
["1nxo",1.85,2.08219312317711],
["1hcv",1.85,2.35420621787808],
["2rln",1.85,1.95018568055793],
["1r9f",1.85,1.61215470843734],
["1mi0",1.85,3.28633865041377],
["1faa",1.85,2.59918839972996],
["1pzc",1.85,2.28297169854374],
["1gsw",1.85,2.13178479013098],
["1o3w",1.85,1.76222220666757],
["1fit",1.85,2.26848839757207],
["2f6e",1.85,1.11831933810116],
["1vwn",1.85,2.95643387922991],
["1uc0",1.85,1.64521694108263],
["1uif",1.85,1.81286307827746],
["2a7f",1.85,2.08027112319384],
["1qqy",1.85,2.26368481653574],
["1tuh",1.85,1.59620666571981],
["1gtw",1.85,1.98080637775181],
["1eyc",1.85,3.2263634471492],
["1ez8",1.85,2.92695563515813],
["1vyf",1.85,2.28004897710449],
["1sth",1.85,2.61904253830683],
["1gak",1.85,2.22847443282608],
["1tzu",1.85,2.51110747428428],
["1dok",1.85,2.22465883822951],
["1eb0",1.85,2.56528795651192],
["1bz4",1.85,2.06707591190487],
["1vls",1.85,3.51224240471939],
["1kfr",1.85,1.64185589699434],
["1bg7",1.85,1.75418851599214],
["1do7",1.85,1.20516546587147],
["2al7",1.85,2.16507464885197],
["1obm",1.85,2.48245546170663],
["2b3m",1.85,1.80614150344017],
["1oby",1.85,1.92096480415428],
["1tol",1.85,2.34334633412662],
["1ex8",1.85,2.65787172358432],
["157l",1.85,2.13678240178636],
["1l73",1.85,2.86875917323802],
["155l",1.85,1.85130438553119],
["220l",1.85,1.84962497085416],
["1l71",1.85,2.36318209016018],
["1quh",1.85,2.43651435617811],
["1l72",1.85,2.43007557864677],
["127l",1.85,1.96171909634679],
["1epy",1.85,2.36745065931191],
["109l",1.85,1.84654931115430],
["1l88",1.85,2.077596777345],
["1li3",1.85,2.15175948323439],
["1lgw",1.85,2.30103154875656],
["1cu2",1.85,2.32933299302838],
["125l",1.85,1.80811586928321],
["224l",1.85,2.10206710274333],
["146l",1.85,1.97272498576492],
["1qs9",1.85,2.32442124453963],
["1g0k",1.85,2.01936010756856],
["1qt3",1.85,2.19872839355449],
["1l21",1.85,2.39110345441979],
["1g06",1.85,2.32572815468106],
["1l39",1.85,2.43776144540993],
["1l40",1.85,2.43550015364653],
["1l37",1.85,2.36629832455103],
["1l20",1.85,2.31735076220273],
["1l53",1.85,2.75611728603406],
["1l50",1.85,2.41497533555406],
["1xen",1.85,1.80244370101638],
["1gnr",1.85,3.29562646218393],
["1o6a",1.85,1.69633896799966],
["1d03",1.85,1.39134411707269],
["1czo",1.85,1.35502657039362],
["1d04",1.85,1.42283650932879],
["1e3b",1.85,2.70876716510281],
["1yzl",1.85,1.89070852865496],
["1udv",1.85,2.61482983152709],
["1cyn",1.85,2.55062495247256],
["1cqq",1.85,2.66586106718690],
["1l1q",1.85,2.46705900610112],
["1y88",1.85,2.09942421062442],
["1avy",1.85,2.96822006391644],
["1zs7",1.85,1.72293626947035],
["1sdo",1.85,1.49412997560715],
["2fxq",1.85,2.52165862046801],
["1b6k",1.85,1.57703139773832],
["1d4k",1.85,1.92004785276292],
["1b6j",1.85,1.46622295298853],
["1z1r",1.85,1.62286156361316],
["1b6m",1.85,1.40833026325350],
["1z1h",1.85,1.73490551990488],
["1vct",1.85,1.84911187376558],
["1zjr",1.85,2.52298846225332],
["1ff0",1.85,1.46755950837727],
["1fg8",1.85,2.24947004214668],
["1ayf",1.85,2.21102849648272],
["1r54",1.85,2.08091458562367],
["1n5i",1.85,1.55400870504583],
["1n5j",1.85,1.59982842021325],
["1uzx",1.85,2.43057418027365],
["1rni",1.85,2.7527481357423],
["2abk",1.85,1.96981429251625],
["1d6o",1.85,2.05875973703393],
["1i2a",1.85,2.15151940078705],
["1amw",1.85,2.46209720688266],
["1qrl",1.85,2.82977452299444],
["1t15",1.85,2.45330611678765],
["1zip",1.85,2.05006731469091],
["1hna",1.85,2.95200715539191],
["1pk3",1.85,1.73274690719976],
["2bbh",1.85,2.16311936667397],
["2gab",1.85,1.52584837915083],
["1dxk",1.85,2.37256206053996],
["1bvt",1.85,2.66398987154965],
["1kzc",1.85,1.86726277945978],
["2awl",1.85,2.04355053493630],
["1u5v",1.85,2.48395467435573],
["1s84",1.85,1.20436816394146],
["1s82",1.85,1.01373389880161],
["1qy8",1.85,2.57473920711510],
["1t32",1.85,2.51556967129295],
["3fiv",1.85,3.02084344950715],
["2asu",1.85,1.32379027529193],
["2g9k",1.85,2.2533895116614],
["1wz1",1.85,1.93060872200277],
["2b94",1.85,1.36540395514891],
["2anw",1.85,2.41419351404699],
["1uaj",1.85,1.81874444392930],
["1xs5",1.85,1.76178940996264],
["1uvo",1.85,1.24842696117402],
["1uvp",1.85,1.53759403490077],
["1gwa",1.85,2.33991177905972],
["1z76",1.85,1.40305036271609],
["1fxf",1.85,2.93304996754951],
["1t6l",1.85,2.55216425803569],
["1zch",1.85,1.81191178237325],
["1ri8",1.85,1.43002330591594],
["1vwa",1.85,2.73420093959246],
["1o5b",1.85,2.72964419717401],
["1v8a",1.85,1.89204584110676],
["1c5z",1.85,2.72712492067651],
["1bv3",1.85,2.37385050453347],
["1ztt",1.85,2.7873984279413],
["3yas",1.85,1.98598831606738],
["1h9n",1.85,1.83266101596391],
["1gsj",1.85,1.90238895739472],
["1nnk",1.85,2.23072427622353],
["1xhy",1.85,1.62476492561299],
["1ckq",1.85,2.45025327534832],
["1zi4",1.85,2.12439566004079],
["1jwv",1.85,2.03653007596636],
["1v3r",1.85,2.02243466346142],
["1rwx",1.85,2.06098322963321],
["1bsg",1.85,1.71118246593615],
["2bxx",1.85,1.87875745970778],
["2c3b",1.85,1.23775284647430],
["1zbi",1.85,1.96769504836001],
["1v3s",1.85,2.0620760793623],
["2btr",1.85,2.53032094241555],
["2b55",1.85,2.56998017796581],
["3bte",1.85,1.90297371240625],
["1llo",1.85,1.80773548241696],
["3btk",1.85,1.68643203334899],
["1r3f",1.85,2.16553386026849],
["1puo",1.85,2.10556477835698],
["2aqz",1.85,1.90651319442559],
["2f2e",1.85,2.31569338307484],
["1ypm",1.85,2.63625367058757],
["1ypl",1.85,2.67625266992804],
["1ai8",1.85,2.44978574728155],
["1h07",1.85,2.3579970651822],
["1y2u",1.85,1.65200986643705],
["1jt5",1.85,2.23360724417799],
["1a3e",1.85,2.31233555160495],
["1zc0",1.85,1.62183999919191],
["1w8z",1.85,1.72450376066806],
["1u6d",1.85,1.33643623364649],
["1nxf",1.85,1.71819557854319],
["1l1d",1.85,1.70154784274623],
["1e1x",1.85,2.55093212390575],
["1ghy",1.85,2.32851600614513],
["1ghv",1.85,2.63155677826150],
["1sog",1.85,1.79038013448196],
["1k6e",1.85,1.84024639376224],
["1k26",1.85,1.85961032071387],
["2b54",1.85,3.47343793031372],
["1pty",1.85,1.64351092660355],
["1e9o",1.85,1.78377507395058],
["1e5j",1.85,1.60962322242725],
["1c39",1.85,2.09711219953449],
["1k8w",1.85,1.99175063553098],
["2auw",1.85,2.4559781508269],
["1wch",1.85,2.30563226692413],
["1v9m",1.85,2.00015299319834],
["2cfi",1.85,2.31504654184706],
["1sdw",1.85,2.48089980426742],
["2a7g",1.85,1.43714469588745],
["1dyj",1.85,2.670323657047],
["1ext",1.85,1.45292342612835],
["1t2e",1.85,2.01128043124013],
["1vfv",1.85,2.76409785373316],
["1zxx",1.85,1.99734694890093],
["1gux",1.85,3.12456797986736],
["2b3u",1.85,2.28548898668269],
["1oth",1.85,2.03119584444997],
["137l",1.85,2.50575773109249],
["2ao0",1.85,2.94333801340683],
["1yyz",1.85,2.02401847908853],
["2c7q",1.85,2.28736124990169],
["2a3t",1.85,1.60298237594714],
["2d2g",1.85,1.95093025405193],
["1jqf",1.85,1.97214402755142],
["1qfo",1.85,1.81445778022804],
["1y65",1.85,2.02926738506030],
["1j9y",1.85,1.32470259578797],
["1xur",1.85,1.71987835560654],
["2c2h",1.85,1.77930495708748],
["1ix1",1.85,1.75322125216350],
["1jvb",1.85,1.87743138272028],
["1g7h",1.85,2.83785918118423],
["1kiq",1.85,2.34138888468568],
["1lm8",1.85,2.69384463486021],
["1r7o",1.85,1.47038026289198],
["1nwk",1.85,1.70219232466399],
["2f4m",1.85,2.71899998512142],
["1r3r",1.85,1.5111297645797],
["1mdl",1.85,2.49141935409418],
["1obq",1.85,1.84510400051871],
["1q63",1.85,2.2546306484011],
["1zh5",1.85,1.63708344372871],
["1j3q",1.85,2.56378777173216],
["1ex2",1.85,2.30558242284592],
["1yw7",1.85,2.23450452621675],
["1f3e",1.85,2.47603197175096],
["1pud",1.85,2.54220691183433],
["1xdc",1.85,1.99942720097628],
["1jf1",1.85,2.01575864512549],
["1elj",1.85,2.06784010290723],
["1isb",1.85,1.7860855175532],
["1ia4",1.85,2.10264654514021],
["1ai9",1.85,2.77085535419191],
["1u7c",1.85,2.58301862921383],
["1l7g",1.85,1.97464970685690],
["1l7h",1.85,1.95528232558940],
["1pk6",1.85,2.17036108511880],
["2b2i",1.85,2.58749859562189],
["2b2j",1.85,3.00032965147791],
["1snf",1.85,1.69603394994211],
["1odo",1.85,1.87404145883653],
["1luv",1.85,2.48042565915116],
["1eqc",1.85,1.50789649781005],
["1cz1",1.85,1.45586936985732],
["1kjz",1.85,2.24548051606876],
["1r4b",1.85,2.15694929537628],
["1bv4",1.85,2.137845535218],
["1bt8",1.85,2.16136174769856],
["1z8p",1.85,2.09560428807243],
["1jbw",1.85,2.73194281277842],
["1wzf",1.85,1.66799045266212],
["2cze",1.85,1.86689292896716],
["2cz5",1.85,2.33898623895199],
["2czf",1.85,2.61984841238986],
["1wnx",1.85,1.68744662257651],
["1p8f",1.85,2.41907171052229],
["1q0u",1.85,2.69265287320169],
["2cxk",1.85,1.90437226744078],
["1jpt",1.85,1.82255825862316],
["1eyq",1.85,2.28947853230576],
["1e4y",1.85,2.93721370429511],
["1e4v",1.85,2.26430906536484],
["1flr",1.85,3.54065788853455],
["1xwg",1.85,1.70689188004935],
["6gsu",1.85,2.10926669410363],
["6gsw",1.85,2.19135050742225],
["2ajx",1.85,2.27576261615193],
["2ak1",1.85,2.32051249397777],
["1al6",1.85,2.60370860937177],
["1jgv",1.85,2.02483435357823],
["1viz",1.85,2.53034601061024],
["1yej",1.85,2.45483108138524],
["1y6l",1.85,2.04671073784769],
["1bxt",1.85,2.63046955770327],
["1h5b",1.85,2.40696199227798],
["2ak3",1.85,1.96995622313499],
["1f3f",1.85,2.2376848416874],
["1cq3",1.85,2.65170112919178],
["1aqm",1.85,1.64507848362985],
["1znb",1.85,1.96545359824950],
["1a7t",1.85,2.05349591938851],
["1tz8",1.85,1.89692700838139],
["1e1m",1.85,1.95724929715529],
["1grb",1.85,2.56239206179203],
["1qvz",1.85,1.76467559553577],
["1us3",1.85,1.57513766835972],
["1xfg",1.85,2.33665330212084],
["1q8v",1.85,1.52011012247776],
["1qo2",1.85,1.98452118581238],
["1v82",1.85,2.48243317897411],
["2ewb",1.85,1.79370848768379],
["1ssq",1.85,2.47606552847535],
["1us2",1.85,1.54843303381284],
["1t96",1.85,2.07810393104118],
["1t99",1.85,2.17442760542476],
["1pcw",1.85,2.02899135906576],
["1e65",1.85,1.94847458337463],
["1jbm",1.85,2.57815249159248],
["1vkh",1.85,1.60042634690339],
["2ab2",1.85,1.77519694564966],
["1qsw",1.85,2.80346227128972],
["1fww",1.85,2.07581188581301],
["1vem",1.85,2.52145416670643],
["1m0z",1.85,2.24590986297453],
["1jmv",1.85,1.74799138596701],
["1ygg",1.85,1.61945056865438],
["1gx6",1.85,2.15034859734864],
["1t8t",1.85,1.58941624395942],
["1n4o",1.85,1.86995017215396],
["2cwz",1.85,1.58340576995037],
["1f4l",1.85,2.32481558649667],
["1nbz",1.85,2.66428787330962],
["2a86",1.85,1.83877284818173],
["8prk",1.85,1.54032482472398],
["1o1m",1.85,1.97975815039503],
["1g9v",1.85,1.96436661954930],
["1qxe",1.85,1.98724122272922],
["1t7c",1.85,1.43037545199617],
["1x23",1.85,2.55436650104160],
["2amd",1.85,2.36939906577995],
["2a42",1.85,1.86763004732056],
["1u79",1.85,2.64226977564544],
["1jps",1.85,2.29662275573475],
["1wnv",1.85,1.93197281941755],
["1lur",1.85,2.58428875407115],
["1yb5",1.85,1.79870205530627],
["1vqu",1.85,1.98727412544349],
["1w5o",1.85,1.73092717469867],
["1x0l",1.85,2.47904761466650],
["1u6e",1.85,1.96989132128012],
["1k9e",1.85,1.63591614199831],
["1z45",1.85,2.73412151512271],
["1z42",1.85,1.91124863451807],
["1nss",1.85,2.45131147557980],
["1ns7",1.85,2.5298677003518],
["1nsm",1.85,2.65354186061392],
["1ns4",1.85,2.47157308414746],
["1mmy",1.85,2.52764528332986],
["1ns0",1.85,2.51339906014032],
["1dhk",1.85,2.11769503834496],
["1b85",1.85,1.33626559997530],
["1uop",1.85,1.52708261118003],
["1muc",1.85,1.85959666063321],
["1jkm",1.85,2.34891753455566],
["1lax",1.85,1.84182358730823],
["1e2v",1.85,2.11039377459764],
["1ef8",1.85,2.47270595285087],
["1epf",1.85,2.68711834785588],
["2aag",1.85,2.39149429904895],
["1l9e",1.85,2.27233660620697],
["2a89",1.85,2.15873706114689],
["1m5b",1.85,1.83175182005712],
["1qt1",1.85,2.05374616135207],
["2gb0",1.85,2.15123441803558],
["1u7k",1.85,1.93756233934708],
["1ie7",1.85,2.15390500266659],
["1tok",1.85,2.46563590263353],
["1w9u",1.85,1.49561672256742],
["1xa3",1.85,1.55967559365498],
["1zzs",1.85,1.83205761372806],
["2fn0",1.85,1.99012221484529],
["1fgq",1.85,1.86525320583929],
["1lwd",1.85,2.09434709133479],
["1zp3",1.85,1.84998901427775],
["1ejb",1.85,1.8582734250753],
["1ejm",1.85,1.90172263071987],
["1qba",1.85,2.06545780176613],
["2al2",1.85,2.43988850576084],
["1zux",1.85,2.11094339846242],
["2cbu",1.85,1.64291347291825],
["1w7u",1.85,2.06598920203018],
["1w7t",1.85,2.13991455857179],
["1w7s",1.85,2.20813640750585],
["2cb5",1.85,1.94062782909853],
["1p31",1.85,1.88073391750927],
["2fe8",1.85,1.90270826300832],
["2c3q",1.85,1.55929866934851],
["1uiu",1.85,3.08430992381527],
["1gpf",1.85,1.96326748950141],
["1w1y",1.85,2.03021145189465],
["1w1v",1.85,2.05353128091429],
["1ogb",1.85,1.77777397858948],
["1as8",1.85,1.97596837859837],
["1cjd",1.85,2.72345461876188],
["1xmn",1.85,2.41822807048803],
["1dnu",1.85,1.8364843572869],
["2es4",1.85,2.06565140798024],
["1wve",1.85,1.81603669381436],
["1kgn",1.85,1.88264832405129],
["1m5s",1.85,2.44167968534737],
["1hjx",1.85,2.11387505983392],
["1pfz",1.85,1.84924956428079],
["1j2u",1.85,1.70590214834903],
["1l8a",1.85,2.90196256318313],
["1xk6",1.85,1.86134725678236],
["1ek4",1.85,1.9763862978744],
["1egm",1.85,2.87957178701105],
["2b3y",1.85,2.36644618570586],
["1woi",1.85,2.23560209161478],
["1hpu",1.85,1.85551145092384],
["1b25",1.85,1.8185223468539],
["1y67",1.85,1.35796197678425],
["1u9u",1.86,1.46865423392736],
["1g1j",1.86,1.77277674474785],
["1ij1",1.86,2.50589351744906],
["1ij0",1.86,2.65077090445047],
["1g02",1.86,1.53492218459492],
["1r75",1.86,2.47878049039155],
["2fo3",1.86,1.5559439797825],
["1ra4",1.86,2.26521564518429],
["1mh8",1.86,2.41831907189013],
["1yxh",1.86,2.41265677844388],
["1q6v",1.86,2.89121842806914],
["1tgm",1.86,2.64983625496579],
["1vwc",1.86,2.74623702357871],
["2c05",1.86,2.35322869560368],
["2exv",1.86,2.13042430026860],
["1cwc",1.86,2.19840063828932],
["1cwh",1.86,2.53693960453075],
["1cwf",1.86,2.37490435217497],
["1cwo",1.86,2.11890008407205],
["1czh",1.86,1.70801841487188],
["1ywm",1.86,1.50549414367658],
["2c0n",1.86,1.91585701396648],
["1rpi",1.86,2.89154323981126],
["1qjj",1.86,2.14185443844337],
["1dyr",1.86,2.78873554186793],
["1dzv",1.86,2.39543018523357],
["1d0b",1.86,1.84125073726280],
["1aec",1.86,1.58257301576871],
["1p8i",1.86,2.63806762754145],
["1f9m",1.86,2.50246461130581],
["1k1a",1.86,2.3659073623047],
["1fzz",1.86,2.47120423363525],
["1t14",1.86,1.59723215692697],
["1qd2",1.86,2.11908274445675],
["1op9",1.86,1.63326724256801],
["1j1i",1.86,2.48158686241773],
["1ghm",1.86,2.5448020454095],
["1g54",1.86,2.23004170925546],
["1g3z",1.86,2.04035192916926],
["1g48",1.86,2.15402499424422],
["1i9n",1.86,2.37975655894578],
["1i9o",1.86,2.35800870270328],
["1i3e",1.86,1.83232268340546],
["1hzg",1.86,1.86189074600549],
["1vho",1.86,2.11075739525003],
["1lij",1.86,3.26062909201336],
["1lp4",1.86,2.35585839197387],
["1lpu",1.86,2.45582594957179],
["2ays",1.86,2.98712934497710],
["1bg0",1.86,1.71504942026116],
["1qn4",1.86,2.21512986932603],
["1yu2",1.86,1.42169323780526],
["1lbk",1.86,2.07642386175373],
["1ruq",1.86,2.28284712381094],
["1yb0",1.86,1.89568464100674],
["1q6c",1.86,2.42592718135852],
["1y7w",1.86,2.10891602174856],
["1rq2",1.86,1.84094403212633],
["1q2w",1.86,2.14943888428064],
["1w5z",1.86,1.75284950427271],
["1r17",1.86,2.28778369495338],
["1hxq",1.86,2.48963355815915],
["1jb7",1.86,2.25777569749258],
["1r8q",1.86,2.30164015475602],
["1tzz",1.86,2.28845298891036],
["1i89",1.86,1.98518933687255],
["1ed4",1.86,2.38613252892805],
["1ger",1.86,1.87122673656528],
["1zx0",1.86,2.54369087427095],
["1z90",1.86,2.26339039872063],
["1xjj",1.86,2.30764118640541],
["1khd",1.86,2.21466866865246],
["2bz4",1.86,2.15256123348701],
["1zpd",1.86,1.52409953432943],
["1y4j",1.86,1.78076488916405],
["1rgk",1.87,1.82945165940996],
["1m5u",1.87,1.65028274665846],
["1y9t",1.87,2.06737432875503],
["1e6i",1.87,1.47387279716671],
["1vwd",1.87,2.54700854245375],
["2fzp",1.87,1.71508507742507],
["1rj1",1.87,1.93997599490227],
["1czt",1.87,2.52449684237502],
["1vi4",1.87,1.42291793835647],
["1cv5",1.87,2.15934759844892],
["1h8n",1.87,2.69689867198450],
["1x09",1.87,2.39629322778225],
["2fhq",1.87,2.38338702049528],
["1n12",1.87,1.63367789878007],
["1goo",1.87,1.90773920129442],
["2cmd",1.87,2.30246253074044],
["1pvv",1.87,3.16674322356897],
["1j39",1.87,2.21657663421252],
["1pt6",1.87,2.15872427286969],
["1tc6",1.87,2.00906075526132],
["1h1y",1.87,1.97558562022670],
["3gcb",1.87,1.76944059693851],
["2f35",1.87,2.31326208342975],
["1y9g",1.87,1.65423734435415],
["1k0y",1.87,1.87791701727778],
["1kd2",1.87,2.25396307451635],
["1onr",1.87,1.90713423841548],
["1ll9",1.87,2.09453349497836],
["1zxm",1.87,2.27544298565474],
["1f3d",1.87,1.84933525405896],
["1hww",1.87,2.00185916059831],
["1yu4",1.87,1.60009188711022],
["1hjs",1.87,2.10063374060889],
["1sjd",1.87,3.0415328616018],
["1m3z",1.87,2.56592581059376],
["1m4s",1.87,2.45073669138081],
["1g0r",1.87,2.09649059009232],
["1w2t",1.87,2.39875633629318],
["1k34",1.88,1.88345733251471],
["1mfl",1.88,1.78387611574443],
["1ey7",1.88,3.35946295316907],
["111m",1.88,2.65483139420511],
["1zmf",1.88,2.22538239030328],
["1dw6",1.88,2.06006548137683],
["1w3q",1.88,1.71824437273870],
["1b00",1.88,3.0810571706087],
["2cbc",1.88,1.96306129657369],
["1cah",1.88,1.93738261037114],
["1u7b",1.88,2.75794774691684],
["2b52",1.88,3.10113619697588],
["1wf3",1.88,2.15925219501470],
["2a5i",1.88,2.92889892239425],
["1xwq",1.88,1.40547424094428],
["1xjz",1.88,2.66391506847203],
["1rul",1.88,2.56194995736569],
["1wxo",1.88,1.97395330951571],
["2a2m",1.88,1.37381463799472],
["1keq",1.88,1.84087384974077],
["1y6z",1.88,2.99288716893963],
["1xg7",1.88,1.19778956996703],
["1oiz",1.88,2.16649932583232],
["1u1x",1.88,1.77628997814293],
["1shr",1.88,1.7796932409863],
["1dss",1.88,2.18730942153675],
["1jpr",1.88,2.37991231655841],
["1xx2",1.88,2.11787587292100],
["1dms",1.88,2.06280006782743],
["1usl",1.88,1.58974689217174],
["1s6v",1.88,2.28656969116202],
["3csu",1.88,2.76180710365755],
["1zcz",1.88,1.48618587239067],
["1f5z",1.88,1.91223116474772],
["2exh",1.88,2.24858647625412],
["1u36",1.89,1.59761000984080],
["1tq3",1.89,2.48323358147128],
["1mkv",1.89,2.50952013277525],
["1uy3",1.89,1.70669579211302],
["1d2w",1.89,2.2703926013198],
["1cup",1.89,2.38641890651263],
["1kw7",1.89,2.30291358350819],
["214l",1.89,3.08750788896183],
["1x7n",1.89,1.59275442150143],
["1u3i",1.89,1.84445880754872],
["1fy3",1.89,2.29369317748848],
["2ao6",1.89,1.72260288099088],
["1a4a",1.89,2.18473546609882],
["1bul",1.89,1.50711835993012],
["1qyx",1.89,1.72993938857107],
["2evj",1.89,1.70778025160295],
["1duw",1.89,2.51418495338445],
["1bva",1.89,2.62480548168813],
["1vkc",1.89,1.01343205750388],
["1ixi",1.89,2.39297872305635],
["1uzi",1.89,2.32227551182358],
["1n43",1.89,2.91191036266722],
["1svz",1.89,2.84949465038208],
["1hsl",1.89,3.29871744645122],
["1fy6",1.89,2.17263529795239],
["1m2t",1.89,2.57313125476098],
["1y9m",1.89,1.82160447186631],
["1y0o",1.89,2.60329909024025],
["1viy",1.89,1.78794893279339],
["2beu",1.89,2.13900931964159],
["1v3e",1.89,2.40397035683548],
["1zth",1.89,2.72878641757507],
["2c8m",1.89,2.39425658472169],
["1oih",1.89,1.83252209842488],
["1vhc",1.89,1.84146772315733],
["1zaj",1.89,2.27278947103892],
["1zal",1.89,2.46211632043587],
["1gyh",1.89,2.09554763960951],
["1gge",1.89,2.15605543713783],
["1gg9",1.89,2.20510893080418],
["2gge",1.89,2.27031039209879],
["1oz9",1.89,1.42052789955708],
["2aif",1.9,2.67105244909679],
["1dph",1.9,2.26562101469442],
["1cph",1.9,1.85056773484462],
["1b2e",1.9,1.37923816724595],
["1b2f",1.9,1.41954692572740],
["1eq7",1.9,1.87502111939761],
["1dfn",1.9,2.22769915460151],
["2cce",1.9,1.8918737147075],
["1ckb",1.9,2.00629997014165],
["1snb",1.9,3.83471929154537],
["2cc8",1.9,2.32712958129821],
["2msj",1.9,2.69227641776032],
["8ame",1.9,1.82330132930399],
["2msi",1.9,2.03922016615654],
["1wd0",1.9,3.12141693664902],
["1hh5",1.9,2.57145621595924],
["1cfw",1.9,1.50021437654766],
["1ail",1.9,1.66754386622343],
["1jml",1.9,2.17577705644961],
["1ntn",1.9,3.6069928506979],
["1pk4",1.9,2.85614153313788],
["1enm",1.9,2.02670242290952],
["1m59",1.9,1.57704836181085],
["1lr6",1.9,1.8768396257371],
["1ehb",1.9,2.15895063219861],
["1a1g",1.9,2.82832790353760],
["1jk1",1.9,2.01637357883647],
["1a1k",1.9,2.34986282914321],
["1rb1",1.9,3.17239412035023],
["1rb4",1.9,2.19416169127563],
["1c6r",1.9,2.32171829914709],
["1wuw",1.9,2.42981192519355],
["1cyi",1.9,2.77709660011213],
["1k9p",1.9,1.66820554312740],
["1yd4",1.9,1.01554225947257],
["1cyj",1.9,2.60883668214830],
["1gq4",1.9,1.79883758291025],
["1bxu",1.9,1.99740192633772],
["1fk7",1.9,1.96435895448266],
["1fk6",1.9,2.43605451150241],
["1mzl",1.9,2.56832952208223],
["1q8b",1.9,2.05515604651693],
["1who",1.9,2.09295424679759],
["1qzm",1.9,2.94344455907188],
["1u9p",1.9,2.12026656842469],
["1tyl",1.9,2.87678968496450],
["1tym",1.9,2.86785599397452],
["3mth",1.9,2.79178099511284],
["1t4f",1.9,2.08941583352932],
["1rb6",1.9,2.16360475131041],
["1rb5",1.9,2.12430689553362],
["3pcy",1.9,2.34370403916316],
["6pcy",1.9,2.68074779074572],
["1wq8",1.9,1.615901987099],
["1yv7",1.9,2.55812352862971],
["3car",1.9,2.30450402827458],
["1q4r",1.9,1.63526671279709],
["7rnt",1.9,1.76893060098167],
["1vck",1.9,1.82285522892894],
["1lra",1.9,1.87955345682799],
["1rls",1.9,2.14860535048865],
["1low",1.9,1.56224316400217],
["1rnt",1.9,2.60349215434215],
["1bu4",1.9,1.70309118612059],
["3gsp",1.9,1.48384049435124],
["1skz",1.9,1.91465888534030],
["1u3z",1.9,1.78893620987137],
["1rms",1.9,2.64686240935248],
["1hrc",1.9,2.79980494391113],
["1o4p",1.9,2.12283555655996],
["1wwc",1.9,2.70167261726376],
["1gk6",1.9,2.34798299309285],
["1crh",1.9,3.60135576482173],
["2fd2",1.9,2.57044161475212],
["1fd2",1.9,2.44613735997784],
["5fd1",1.9,2.49914279158958],
["1g6b",1.9,2.05959322618825],
["1fdd",1.9,2.40905179862805],
["1b2o",1.9,1.79698525309572],
["1io3",1.9,2.20279415266202],
["1irv",1.9,4.04339552663197],
["1b8r",1.9,2.3063701817004],
["1cif",1.9,3.09685809732553],
["1gmg",1.9,1.95533987416508],
["1raq",1.9,2.91591209389921],
["1chj",1.9,2.97718491531021],
["1csw",1.9,2.7421848100119],
["1csv",1.9,3.16673219686457],
["1csx",1.9,3.2569448922407],
["1ctz",1.9,3.93142304618979],
["2ycc",1.9,3.98614705286275],
["1ddv",1.9,2.09150589482178],
["1f4n",1.9,1.64133176689819],
["2apv",1.9,1.23830243839377],
["1rnb",1.9,3.28599041975336],
["1n9l",1.9,1.95111259648563],
["2hdd",1.9,2.67220618396077],
["1jd5",1.9,2.27515042311108],
["1sfp",1.9,2.20606067908435],
["1km8",1.9,2.24304139950361],
["1yea",1.9,3.54415239642868],
["2pii",1.9,2.61379842458453],
["5fiv",1.9,2.38940596909043],
["6fiv",1.9,2.61239620535866],
["1nxx",1.9,2.54347261287850],
["1lsl",1.9,3.28585186055417],
["1neu",1.9,2.64993472046871],
["1b11",1.9,3.03866055306281],
["1fnj",1.9,1.46558026783865],
["1ezj",1.9,2.99403583699659],
["4rhn",1.9,1.50510357932955],
["1xj3",1.9,1.84698571445465],
["1shf",1.9,1.8519348312349],
["1tmy",1.9,3.01662635861563],
["1bxy",1.9,2.12987021236931],
["1e0b",1.9,2.30288930315614],
["1u5f",1.9,1.56083567175148],
["1mai",1.9,2.37475875649192],
["1e21",1.9,2.93423059310727],
["2bgv",1.9,1.63336932261300],
["1dun",1.9,1.98784456062045],
["1c2a",1.9,1.69061477257764],
["1u6t",1.9,2.08310683310642],
["1opy",1.9,2.53334758867691],
["1oho",1.9,1.95162900814017],
["1dmm",1.9,2.87219188851098],
["1buo",1.9,2.10957546701253],
["1rno",1.9,2.49887035642014],
["1rar",1.9,2.56387037839063],
["1kvx",1.9,3.06050713305895],
["1c74",1.9,2.30971299101049],
["1ceh",1.9,2.78563633020587],
["1gh4",1.9,2.20831229572117],
["1kvy",1.9,2.83973953661288],
["1mks",1.9,3.19984175072301],
["1hfx",1.9,2.49609841300510],
["1ymv",1.9,1.45922584433204],
["1m8s",1.9,2.20880438034482],
["1m8r",1.9,2.33780325098620],
["1bfb",1.9,3.23487589842521],
["1rnx",1.9,2.62218900315987],
["1rnz",1.9,2.64989029237574],
["1rca",1.9,2.87827007495803],
["1c0b",1.9,4.47881449655431],
["1bas",1.9,1.95031994968268],
["1o4w",1.9,1.42318272133186],
["2pyr",1.9,2.22941720113185],
["2pyp",1.9,2.13733715880682],
["1s4r",1.9,2.54197445991669],
["1dfx",1.9,2.89952350713087],
["1s4s",1.9,2.67449965200120],
["1jug",1.9,2.33604554186318],
["1wtp",1.9,2.62978975231549],
["1di2",1.9,2.24199789030823],
["1e84",1.9,1.53049878995407],
["1eif",1.9,3.26150200407287],
["1e6l",1.9,1.9626906711682],
["1o7v",1.9,2.85043139480106],
["1d4z",1.9,1.48243072257354],
["1kh0",1.9,2.07604263437100],
["1doi",1.9,2.01683684866078],
["2fit",1.9,2.56439216142426],
["1hhl",1.9,1.9407310475396],
["1uat",1.9,2.33295524816228],
["1lsn",1.9,2.3906996130174],
["1lsy",1.9,1.91140483659338],
["1ir7",1.9,1.73961665462369],
["1hsx",1.9,2.08860313863188],
["1ved",1.9,1.46602076705407],
["1f0w",1.9,2.4360053814721],
["1jiy",1.9,1.74117000433176],
["1ir9",1.9,1.97026275937638],
["1jis",1.9,1.96259837293674],
["1jj1",1.9,2.20680547052021],
["1yl0",1.9,2.07937241051431],
["1jj0",1.9,1.66579093375061],
["1yky",1.9,1.68226637337691],
["1jit",1.9,2.03497994766661],
["1ykx",1.9,1.71020653690551],
["1z55",1.9,2.24146877242012],
["6lyt",1.9,2.61411044178502],
["1yl1",1.9,2.24194515307467],
["5lyt",1.9,3.82876045036366],
["2a1i",1.9,2.71161950297457],
["1i20",1.9,1.64836537796079],
["1e3o",1.9,2.49187055994916],
["2cy5",1.9,2.24685890825205],
["1utx",1.9,1.58059156236103],
["1b0n",1.9,1.99508824048653],
["1ab0",1.9,2.10611727742497],
["1lis",1.9,2.17889678274919],
["1elr",1.9,1.52006635604643],
["1vfq",1.9,2.12224841268005],
["1fwu",1.9,1.98218027167203],
["3nuc",1.9,2.81332786449449],
["1is4",1.9,2.23494473418330],
["1ez6",1.9,2.95090672349618],
["1nuc",1.9,2.68475506646560],
["1rsy",1.9,1.74226818410662],
["1dup",1.9,2.37186700936137],
["1kaa",1.9,2.48192590381340],
["1syg",1.9,2.61980080153306],
["1xgw",1.9,2.41403462271740],
["2g3a",1.9,1.41609560725981],
["1g15",1.9,2.39574725651359],
["1kdb",1.9,2.46113928057228],
["1kda",1.9,2.55589518404027],
["1nl1",1.9,2.88082992866928],
["1rss",1.9,2.26584690690728],
["4nul",1.9,1.90797722042171],
["1fln",1.9,1.87170782562266],
["1fla",1.9,2.39663053084767],
["4nll",1.9,2.09121389013288],
["1fvx",1.9,2.14138431835532],
["1j74",1.9,2.39659302756862],
["1r1m",1.9,2.77845294506695],
["1h7i",1.9,2.39075934123535],
["1u9l",1.9,2.28629898153870],
["1ebt",1.9,2.09933747415122],
["1moh",1.9,2.15937993550591],
["1vlk",1.9,3.21794372592377],
["2fy6",1.9,1.73386885588945],
["1lat",1.9,3.24175542982068],
["1o1x",1.9,1.39171272743432],
["2azw",1.9,1.8607400900793],
["1fip",1.9,2.42569050575366],
["1thq",1.9,2.09251716410667],
["1at0",1.9,2.14217245356207],
["1a5x",1.9,2.36495733293718],
["1a5v",1.9,2.60294708370159],
["1jmw",1.9,4.08766791813905],
["1vkb",1.9,1.17747195954736],
["1emu",1.9,2.04226703247382],
["5mba",1.9,2.51152316629413],
["1akq",1.9,2.06889797866901],
["2fx2",1.9,2.26092409434029],
["1aku",1.9,2.21113434378991],
["4fx2",1.9,2.75690085463492],
["3fx2",1.9,2.82734248014880],
["1puf",1.9,2.48068003681789],
["1buu",1.9,1.95055620857914],
["1ezk",1.9,1.87596880564356],
["1hlw",1.9,2.07106936064879],
["1a3z",1.9,2.35103505646468],
["2a6c",1.9,1.26424394144677],
["1rcy",1.9,2.0400514683145],
["1r4v",1.9,1.69911347650645],
["1npf",1.9,1.49040444664838],
["1v8u",1.9,2.08718887520319],
["2rdv",1.9,2.26560450699996],
["1hsy",1.9,2.63056187822235],
["1nz2",1.9,2.56475691752019],
["1ymb",1.9,3.48241870630219],
["1iop",1.9,1.84113089241083],
["2bwh",1.9,1.63495964834840],
["2myb",1.9,2.55285610295245],
["1mlu",1.9,3.03757717508536],
["1ch1",1.9,2.45365384602924],
["1j52",1.9,2.09904425112384],
["1ch7",1.9,2.55815330907009],
["1jdo",1.9,2.48218957323111],
["1mgn",1.9,2.63822630810024],
["2mgm",1.9,2.79246823982264],
["1mti",1.9,2.84035169688495],
["1moa",1.9,2.79788926962027],
["2mgc",1.9,2.57061829421682],
["1rdb",1.9,2.29775572262129],
["1kvb",1.9,2.9382147238397],
["1kvc",1.9,3.18798429258876],
["1lke",1.9,2.08225296664721],
["1kex",1.9,2.51444063033291],
["1alu",1.9,2.45502575667386],
["1u2p",1.9,1.68438055502118],
["1goa",1.9,3.32500418019328],
["1tcf",1.9,3.19415881855908],
["1ujc",1.9,2.32928878549788],
["1i06",1.9,2.83658620382961],
["1lnm",1.9,2.41531367733777],
["1gvc",1.9,2.51365680518125],
["966c",1.9,3.3855357814169],
["103l",1.9,2.86047761970995],
["1dg9",1.9,2.11107927339026],
["1t5i",1.9,3.10137476108133],
["1k12",1.9,2.62572857797795],
["1rvd",1.9,2.28204706405995],
["1gpr",1.9,2.35461055111054],
["1h6w",1.9,1.53474675082100],
["1yoa",1.9,2.17263063513977],
["1jom",1.9,2.30215550208474],
["1ra1",1.9,2.44681248917846],
["1rx9",1.9,2.54361301174308],
["1rc4",1.9,2.97398447107491],
["1k95",1.9,1.57425013366180],
["1nu2",1.9,1.82562193843693],
["1czs",1.9,2.26260312689460],
["1iw2",1.9,2.10490595640456],
["1wt4",1.9,2.62951140688778],
["192l",1.9,2.36043669038617],
["1l64",1.9,2.05268761391893],
["1cge",1.9,2.53727555612254],
["1l75",1.9,2.69291545267447],
["1c6l",1.9,1.96751642932899],
["248l",1.9,2.12550928597438],
["1l89",1.9,2.36512617104438],
["1l84",1.9,2.64424967454157],
["1c6h",1.9,1.52868098100088],
["1c6i",1.9,1.75926193695206],
["1c6k",1.9,2.04262582977198],
["1c6j",1.9,2.0819434936517],
["1g0g",1.9,2.01164073235298],
["1l67",1.9,1.98090666736718],
["235l",1.9,1.99418416211371],
["228l",1.9,2.25469894186028],
["222l",1.9,2.28038480348124],
["1qsq",1.9,2.22693925521408],
["236l",1.9,1.97113193400171],
["1c6g",1.9,2.23933576792754],
["1l79",1.9,2.17868744483744],
["1quo",1.9,2.30810609875502],
["1i6s",1.9,2.3183929940505],
["1c6e",1.9,2.33039043160105],
["1l70",1.9,2.54861013552944],
["1c6p",1.9,2.0216187579697],
["1c6q",1.9,1.94433944023398],
["1l76",1.9,2.08765028875520],
["1cv6",1.9,2.14575335660759],
["1l55",1.9,2.06373652941534],
["1g1v",1.9,2.11563012963462],
["233l",1.9,2.23366224936717],
["257l",1.9,2.33138816390614],
["1cv4",1.9,2.24581749872703],
["225l",1.9,2.26976373495181],
["1qug",1.9,2.33023761903302],
["234l",1.9,2.30536350679865],
["1l69",1.9,2.24484400343299],
["1lgx",1.9,2.28191182723424],
["223l",1.9,2.63039367159552],
["1b6i",1.9,2.54972375562468],
["1lgu",1.9,2.57795523592820],
["1dyf",1.9,2.27483115329742],
["1l57",1.9,2.09971806283429],
["1dya",1.9,2.26858537914991],
["195l",1.9,2.38403975345146],
["1qtb",1.9,2.76418950293666],
["1wc8",1.9,2.48230290143550],
["1vg1",1.9,1.74660758025884],
["148l",1.9,2.42618654707242],
["1u7o",1.9,1.85228009304940],
["2alf",1.9,2.48704919556831],
["1qnt",1.9,1.93805000785700],
["3cyh",1.9,1.84465531983451],
["249l",1.9,2.13799885247885],
["254l",1.9,2.05088066691542],
["1l28",1.9,2.27639752819211],
["1qt6",1.9,2.22193309289955],
["1pqj",1.9,2.24115374211661],
["1l54",1.9,2.38597136967422],
["1l00",1.9,2.58789891113702],
["1qt8",1.9,2.67168883575885],
["230l",1.9,2.51101435524866],
["1z2a",1.9,1.91315649621456],
["1l34",1.9,2.38569739374727],
["172l",1.9,2.98315741699754],
["1l51",1.9,2.31808005802057],
["1mmq",1.9,2.35800522886124],
["1wlj",1.9,1.49618571332281],
["2nll",1.9,3.40464040549771],
["2atv",1.9,1.35931572046922],
["1cwi",1.9,2.34501120669047],
["1jtm",1.9,2.42627773388059],
["1up1",1.9,2.06156286118265],
["1czk",1.9,1.30733757871154],
["1czr",1.9,1.35190301177319],
["1ihc",1.9,2.20607840996279],
["1fu0",1.9,1.92897401349591],
["1ua8",1.9,2.40041453537991],
["1baz",1.9,2.57368461634823],
["1qzn",1.9,1.61832314973167],
["1e8k",1.9,2.53366541100708],
["1xhd",1.9,1.49496255370863],
["2fha",1.9,1.61776938215261],
["1b2v",1.9,2.47398415184927],
["1erb",1.9,2.93444992968447],
["1yfu",1.9,1.96729050937377],
["1ci4",1.9,1.54349601157284],
["1hbp",1.9,2.96167668663798],
["1eto",1.9,2.36629832455103],
["1ehh",1.9,2.45229682794108],
["1iqb",1.9,2.27045637932511],
["1fen",1.9,2.95397984382285],
["1sqw",1.9,2.56626320026367],
["1fem",1.9,3.59838616293684],
["1krl",1.9,2.42563152950852],
["1h0j",1.9,2.36227144280663],
["2bin",1.9,1.71472770316169],
["2fv8",1.9,1.61484408858042],
["1y9q",1.9,1.74972079850370],
["1mr8",1.9,2.58654812724296],
["1cdw",1.9,2.53414036453894],
["1eyl",1.9,2.08008859754436],
["1q08",1.9,1.84420636233348],
["2cw9",1.9,2.02998087982796],
["2bio",1.9,1.98680430965897],
["1rz3",1.9,1.72852261634501],
["1u1p",1.9,1.60311204971228],
["1rec",1.9,2.42067057337382],
["1wj9",1.9,1.76739612425963],
["1lqy",1.9,2.15270944736854],
["1lmh",1.9,1.64951138794945],
["1iv9",1.9,2.2424176422696],
["1p71",1.9,2.50352337904619],
["1q1y",1.9,1.86838178483970],
["1ex7",1.9,2.53971508593511],
["1u72",1.9,3.2025285973448],
["1s3w",1.9,2.85955936034548],
["1mvs",1.9,3.21268488334268],
["1cuk",1.9,3.12776784371321],
["1jhs",1.9,1.90642732811829],
["1i8u",1.9,1.52655394179672],
["1i82",1.9,1.61614797825226],
["1eq6",1.9,1.88398847704584],
["1iap",1.9,1.74859803223729],
["3tss",1.9,2.37029494441478],
["1dvb",1.9,2.90236432723369],
["1b71",1.9,3.00106212776797],
["1vk2",1.9,1.45210409360332],
["3ukd",1.9,2.19188891505337],
["1et9",1.9,2.19499266337796],
["1qcs",1.9,1.93492233603152],
["5ukd",1.9,2.52090942181168],
["1yzf",1.9,1.86263434654038],
["1tef",1.9,1.51211041269393],
["2bpy",1.9,1.96282427126714],
["2bpv",1.9,2.11785634424619],
["1w5y",1.9,1.47214037380483],
["1izh",1.9,1.60203151807749],
["2aid",1.9,2.2650223245294],
["1met",1.9,2.65602130521869],
["1mer",1.9,2.44636786508828],
["1mes",1.9,2.46403512086105],
["1w5x",1.9,1.63908452099701],
["2a4f",1.9,1.64922517452441],
["1bwa",1.9,2.60287371316976],
["1meu",1.9,2.62411470380753],
["1hpv",1.9,2.57409175928087],
["4upj",1.9,2.72082507978599],
["1sgu",1.9,2.42801229803604],
["1ukz",1.9,2.03720795377637],
["1bud",1.9,2.38267144485712],
["2cut",1.9,2.37311234245141],
["1dto",1.9,2.33842967338600],
["1fgc",1.9,1.91131266880304],
["1p12",1.9,2.22945120883371],
["1fff",1.9,1.94986994676319],
["1e9f",1.9,2.34208917197454],
["1f39",1.9,2.02985914318226],
["1iaa",1.9,1.70456237247994],
["1yp1",1.9,2.33527622631306],
["1q7r",1.9,2.20633291829248],
["1mt7",1.9,1.91391894822260],
["1w3r",1.9,2.03260743365577],
["1u0s",1.9,2.64691037380953],
["1qav",1.9,1.80626614853652],
["1nzl",1.9,2.00158604880218],
["1is0",1.9,2.28247531132514],
["1za4",1.9,2.09965196832332],
["1kd8",1.9,1.61958603812136],
["1bhh",1.9,3.4614103622643],
["1gsm",1.9,2.91151116194480],
["2cd2",1.9,3.09310789995374],
["1ly3",1.9,3.23629218830243],
["1x9r",1.9,2.43171704411424],
["1uy6",1.9,1.80148296853832],
["1fw1",1.9,1.87304009621930],
["3gar",1.9,3.3022523063732],
["1nn1",1.9,1.96389108356231],
["1qnx",1.9,1.89259564978464],
["1uy7",1.9,2.28799074689859],
["1k3s",1.9,2.20909196416007],
["4eng",1.9,2.17509733755556],
["2fem",1.9,2.62803739042972],
["1e98",1.9,2.31277773078451],
["1xj6",1.9,2.20249923097446],
["1miz",1.9,2.53015433624938],
["1coj",1.9,1.97507703392052],
["1dzf",1.9,2.33439101989258],
["1ppp",1.9,3.60764895284203],
["1d7h",1.9,2.03623381725964],
["1d7i",1.9,2.20299906680602],
["1bl4",1.9,2.55906829992237],
["1ivj",1.9,2.16048959810147],
["1vgi",1.9,2.17953346589108],
["1p3j",1.9,2.6790993899674],
["1a75",1.9,3.05606325785633],
["3eng",1.9,1.89339316796462],
["1yet",1.9,2.46517611450586],
["1tk1",1.9,2.80027772938440],
["1wtl",1.9,3.24443535584103],
["2bl9",1.9,2.26309796301035],
["2f7d",1.9,2.43491019654520],
["2byh",1.9,1.63454763091267],
["1qy6",1.9,2.32627357557968],
["2gau",1.9,1.83707511010921],
["1vpp",1.9,2.20014368860033],
["1ms6",1.9,1.80377384380291],
["2ebo",1.9,2.69260510406941],
["1iit",1.9,1.84681802452366],
["1iiw",1.9,2.21597481391532],
["1nvi",1.9,2.30781846464180],
["1cd0",1.9,2.31163922191395],
["1mvc",1.9,1.7027632325464],
["1ois",1.9,2.69462560414321],
["1d2t",1.9,2.13482357707007],
["2f51",1.9,2.08625062409931],
["1kzd",1.9,1.88384165531021],
["1pw3",1.9,2.20198018442080],
["1rmm",1.9,2.25460334969416],
["1zol",1.9,1.27380526412382],
["1rdm",1.9,1.84099129225825],
["1mv9",1.9,2.32229958501862],
["1n5t",1.9,1.58305881275163],
["1twb",1.9,2.25712823586095],
["1q8r",1.9,2.4625854592093],
["1ema",1.9,2.64425135278858],
["1fmg",1.9,2.59657497940962],
["1f0u",1.9,1.23648170725426],
["1pph",1.9,1.79917427520426],
["1mtu",1.9,1.54533372145911],
["1mts",1.9,1.50431422389907],
["1g36",1.9,1.92507788539850],
["1tps",1.9,1.50820852874831],
["1mtv",1.9,1.71603754106095],
["1k1p",1.9,1.80108426281071],
["1mtw",1.9,1.81389261943592],
["1tnl",1.9,2.01311427559654],
["1nc6",1.9,1.77873317430741],
["1tni",1.9,2.17302762257737],
["2bza",1.9,1.89483570967222],
["1v2t",1.9,2.23217412426031],
["1v2j",1.9,2.40633821412038],
["1fgv",1.9,2.29110599296459],
["1q3f",1.9,1.94253466899364],
["1gl2",1.9,1.67126327713539],
["1zzz",1.9,2.65756224684496],
["1v9z",1.9,2.77376804804402],
["1slm",1.9,2.02594778553788],
["1wef",1.9,1.56947916678821],
["1x8i",1.9,1.77371476017421],
["1au8",1.9,2.40937395704279],
["1klt",1.9,2.96246966857229],
["1t31",1.9,2.43387900488673],
["1ek3",1.9,1.93778134156357],
["1dvy",1.9,1.34632158969240],
["1dvu",1.9,1.44665526536955],
["1dvz",1.9,1.48412185668879],
["1dvt",1.9,1.52931572336221],
["1yhi",1.9,0.998976463238855],
["1p62",1.9,1.60469857140922],
["1qhj",1.9,2.29281909036027],
["1x08",1.9,2.34989595173742],
["1v6d",1.9,2.74876370282338],
["1k1b",1.9,2.27941456227743],
["1qr0",1.9,3.50887741726347],
["1pyu",1.9,1.96075118945093],
["1e3f",1.9,1.42272329360634],
["1x06",1.9,2.27444974203839],
["1zd6",1.9,1.40235006944628],
["1pt1",1.9,2.26467889224051],
["1t95",1.9,2.00991302981494],
["1qx3",1.9,2.63697207707507],
["1tvd",1.9,2.31407223417140],
["1fx4",1.9,2.12612121215026],
["1ttr",1.9,2.59200103265219],
["1ziy",1.9,1.71437849904065],
["1vgc",1.9,2.09230842454415],
["1dut",1.9,2.7415650717724],
["1dex",1.9,1.98720288877633],
["2gch",1.9,3.03078547024114],
["4gch",1.9,3.61275767539830],
["3gch",1.9,3.75455779263499],
["1gcd",1.9,2.56969680335686],
["1s68",1.9,2.54477911757120],
["1j5p",1.9,2.46005336076696],
["1pyq",1.9,1.86423588264080],
["1sgq",1.9,2.24416530090821],
["1cso",1.9,2.30886740581481],
["1r6l",1.9,2.61206936146237],
["2d3k",1.9,2.07999753698811],
["2bsh",1.9,2.56341317438307],
["2ax7",1.9,1.91121356724445],
["1rk8",1.9,1.84061952801135],
["1q1c",1.9,2.51529248164228],
["1dq6",1.9,1.88232632225971],
["1jn2",1.9,2.38946070782426],
["1b9k",1.9,1.64323708266694],
["2lao",1.9,2.40927483894016],
["1vet",1.9,3.12466536132539],
["1s4k",1.9,2.08733947403613],
["1xkf",1.9,1.82577694084234],
["2ftz",1.9,1.88203236644044],
["1zm8",1.9,1.58851803714116],
["1ax0",1.9,1.73829583741516],
["2c2a",1.9,2.96399810553488],
["1se4",1.9,3.32199016466351],
["1e35",1.9,2.06694480962725],
["2foa",1.9,1.66463136258858],
["2fob",1.9,1.69049861599997],
["2fog",1.9,2.11129974401613],
["9est",1.9,2.5221519524414],
["1reg",1.9,2.9904387239548],
["1tlm",1.9,2.78138101253248],
["2ess",1.9,1.67237689208812],
["1sj0",1.9,2.98591413936477],
["1qix",1.9,1.88043978507066],
["1cqs",1.9,3.14889135634868],
["1q5t",1.9,3.03609674261342],
["2c99",1.9,1.70769847908242],
["1u73",1.9,2.22286512311070],
["1lsq",1.9,1.98218214314633],
["1c1y",1.9,1.89326683860723],
["2c98",1.9,1.90397546667548],
["1njr",1.9,2.23011840461015],
["2gfh",1.9,1.59101032631390],
["1fhw",1.9,2.36120354803477],
["1sqt",1.9,2.30906456338150],
["1yim",1.9,2.78401061848942],
["1ufk",1.9,2.38027508579018],
["1gr2",1.9,2.3408342851706],
["2d2f",1.9,1.86986375317549],
["1uc7",1.9,1.91230563836972],
["1xpt",1.9,2.06764669972879],
["1wbu",1.9,2.02425087243688],
["1lyx",1.9,2.34383217493993],
["1bsr",1.9,1.80860589966704],
["11bg",1.9,2.06151368457486],
["2ayr",1.9,2.19476308163405],
["3ert",1.9,2.51026541952079],
["1nsf",1.9,2.27602816823520],
["1nri",1.9,2.44860099417167],
["1rkg",1.9,1.909041995751],
["1ci3",1.9,2.24786719329444],
["1o0x",1.9,2.37323601979977],
["1vh7",1.9,1.66948711487477],
["1fa6",1.9,2.19783700229313],
["1fa7",1.9,2.58282012392173],
["1idr",1.9,2.07727126903974],
["1h9i",1.9,1.72257950016149],
["1wxh",1.9,1.97016867356651],
["1wxg",1.9,2.00668023201931],
["1slt",1.9,3.05021110481676],
["1rwl",1.9,2.54569498829717],
["2trh",1.9,2.98332328300715],
["1bzd",1.9,2.94049762615034],
["1gjb",1.9,2.99166345149718],
["1sb2",1.9,2.33317711736770],
["1k4w",1.9,2.5081805853156],
["1zpv",1.9,2.18103889507996],
["1ll2",1.9,2.29126624609860],
["1ukm",1.9,1.73644596446842],
["1txi",1.9,1.84430768633096],
["1hw6",1.9,2.01802781628265],
["1es4",1.9,2.44448378090295],
["1r3d",1.9,1.93831436361424],
["1ydb",1.9,2.18586608373348],
["1nap",1.9,3.55869256649019],
["2f5d",1.9,1.85444017655363],
["1rcm",1.9,1.78412160431522],
["1jj3",1.9,2.21261284857953],
["1dkk",1.9,2.48172384261415],
["1ljg",1.9,2.68762343478956],
["4lyt",1.9,3.55852995000092],
["3lyt",1.9,4.2694357897552],
["1wxe",1.9,2.14882445085333],
["1cnx",1.9,2.36351086302052],
["2ca2",1.9,2.67903863964152],
["1yas",1.9,2.46980008452716],
["1k9j",1.9,2.45376468813017],
["1cng",1.9,2.14582109918101],
["2h4n",1.9,1.86218009621841],
["1f2w",1.9,2.40055250111654],
["1lgd",1.9,2.55222819333685],
["1fw0",1.9,2.82861385887753],
["1ohb",1.9,1.94024781322959],
["2fyx",1.9,1.45441700496984],
["1ip7",1.9,2.15858772613427],
["1sei",1.9,2.84786794359042],
["1tg9",1.9,1.94721914397522],
["1el1",1.9,3.30344007516724],
["1caz",1.9,1.96406799410377],
["1bic",1.9,2.09298645926936],
["1rzd",1.9,1.91640792120128],
["1cak",1.9,2.19564867076864],
["1rza",1.9,1.94667647334842],
["1caj",1.9,2.00347979048463],
["1rze",1.9,2.06174956946154],
["1bcd",1.9,2.07911594001043],
["1rzc",1.9,2.03723564195926],
["1raz",1.9,2.62634424778982],
["1uge",1.9,2.25635594473203],
["1dja",1.9,2.2587905248635],
["1ayo",1.9,2.41598499398006],
["1mq4",1.9,2.59168362314726],
["1cao",1.9,2.21456704105618],
["1can",1.9,2.0830242721015],
["1ll3",1.9,2.61876513103917],
["1ymq",1.9,1.75723892304745],
["1cra",1.9,1.98283811349883],
["1w80",1.9,1.72530367064876],
["1j1r",1.9,1.97778367440513],
["1wt2",1.9,2.27132234375623],
["2cay",1.9,1.70958102220191],
["1efd",1.9,2.8440280519675],
["2mat",1.9,2.54075654154699],
["1co7",1.9,2.75874037486245],
["1hnk",1.9,2.42389061318656],
["1xpb",1.9,2.38128432296237],
["1nyy",1.9,1.82340888907143],
["1pzo",1.9,2.22118183419639],
["1erq",1.9,2.77127420892972],
["1uq4",1.9,1.89777834704141],
["1p4f",1.9,1.57245889819937],
["1f4e",1.9,1.81984621608535],
["1gnv",1.9,1.80971553899765],
["1edt",1.9,2.53111414436332],
["1w6o",1.9,2.17272221802180],
["1ldt",1.9,2.39629636960894],
["1c8z",1.9,3.21182517690225],
["3tgl",1.9,2.73445219164884],
["1pji",1.9,1.94463126169249],
["1nnj",1.9,2.01995580665520],
["1fsf",1.9,2.85622969560683],
["1htv",1.9,2.85306464846618],
["1usp",1.9,2.16424868500967],
["3gal",1.9,3.24556482633129],
["2byc",1.9,2.78683633344816],
["1bkz",1.9,2.83277304958429],
["2c3i",1.9,1.42346249479562],
["2fyb",1.9,1.99371104759587],
["2fya",1.9,2.21400722435962],
["2bhe",1.9,3.05057519416789],
["1pjj",1.9,1.98999087072515],
["2bzi",1.9,1.56562161452804],
["1r4x",1.9,1.64345167881273],
["1vjl",1.9,2.28450427120091],
["1b66",1.9,1.92232614296055],
["1scn",1.9,2.74182262707677],
["1sud",1.9,2.28570597931154],
["1s02",1.9,2.11885212887392],
["3btg",1.9,1.70776605237487],
["2gjs",1.9,2.05604382904572],
["2bzh",1.9,1.49612209209359],
["1y2g",1.9,2.55843479691739],
["3btd",1.9,1.82296281006767],
["3btq",1.9,1.73005678207648],
["3btt",1.9,1.48957210532028],
["1h9r",1.9,2.12121119946069],
["1k68",1.9,2.46730853476530],
["1evr",1.9,1.94718469787228],
["1e25",1.9,1.64812354287045],
["1z2v",1.9,1.77435982764354],
["1y9w",1.9,2.47321644196419],
["1tpa",1.9,2.32046885868133],
["2ptc",1.9,2.09554695262079],
["2tgp",1.9,2.61158459339759],
["3tpi",1.9,2.34893964844364],
["1uu7",1.9,2.52648631614410],
["1zrb",1.9,2.58183281584890],
["1ev6",1.9,1.66152814804383],
["1cg8",1.9,2.18880206672295],
["1ta6",1.9,2.62676722397272],
["1q44",1.9,2.01135843697831],
["1sr8",1.9,2.63731635745016],
["1f00",1.9,2.40434674392216],
["1y2v",1.9,1.74687512399586],
["1sb1",1.9,2.22307417076246],
["1g32",1.9,2.82196155344881],
["1t49",1.9,2.00649142009555],
["1i3c",1.9,1.71107683164086],
["1f0p",1.9,2.78549930770841],
["1h0v",1.9,2.39978009353231],
["1g0b",1.9,2.41552137848241],
["1a27",1.9,2.73376504573528],
["1nhk",1.9,1.82337716291534],
["1fle",1.9,3.28054650175511],
["1z7k",1.9,2.73803606493977],
["1p14",1.9,1.5126785083156],
["1ut7",1.9,1.92613095189571],
["1zwx",1.9,1.62448090250073],
["1fg4",1.9,2.94198589997883],
["2fbl",1.9,2.50439654676375],
["2bkr",1.9,1.52787518211113],
["1han",1.9,1.46876268617881],
["1knd",1.9,1.58302926067870],
["1knf",1.9,1.66279267920120],
["1jzm",1.9,1.93379236402687],
["1ls6",1.9,2.06781081200221],
["1g2l",1.9,2.45657242781312],
["3prn",1.9,2.09594496738724],
["1up5",1.9,2.44885892221417],
["2c6m",1.9,2.56967605160155],
["1vp3",1.9,2.43786746424820],
["1v1i",1.9,2.54954012571552],
["1lkf",1.9,2.39311058690847],
["3lkf",1.9,2.17901471005226],
["2c6k",1.9,2.3907360175054],
["1up2",1.9,1.21954021660672],
["1cp6",1.9,2.41544856024113],
["2anp",1.9,1.8354466414195],
["1cmp",1.9,2.06177890126575],
["4ccx",1.9,2.05997160952156],
["1f08",1.9,2.00712266608608],
["1ujk",1.9,1.91724546456280],
["1v93",1.9,1.54496156363525],
["1hck",1.9,2.83536681101923],
["1c1w",1.9,2.66657068472435],
["1c5o",1.9,2.80138161699069],
["1no9",1.9,2.55452396963999],
["1jci",1.9,1.9412447270336],
["1jk7",1.9,2.26206511564968],
["1w35",1.9,1.88834556202699],
["2man",1.9,1.83936079301494],
["1vgx",1.9,1.74579977616215],
["1in7",1.9,1.76324725476283],
["1bx0",1.9,1.83140983554591],
["1bx1",1.9,1.86511586354985],
["1in8",1.9,1.66271817871720],
["1d7o",1.9,2.14817112957454],
["1eno",1.9,2.49215834489872],
["1a48",1.9,2.39111568761147],
["1aax",1.9,1.91941867030845],
["1cpo",1.9,1.90151057165120],
["1f9f",1.9,2.42067298922715],
["1sxn",1.9,1.59697179143606],
["1sxa",1.9,1.58195378696028],
["1sxc",1.9,1.63716581582461],
["1u94",1.9,1.79204012417865],
["2c3s",1.9,2.58115293698705],
["1een",1.9,2.28592031190248],
["1phm",1.9,2.25518040466291],
["1ixk",1.9,2.16031124428848],
["1ugh",1.9,2.65804248139344],
["1i7b",1.9,2.04400461982062],
["1azv",1.9,2.49624106449323],
["1m6c",1.9,2.19191131967104],
["1myj",1.9,2.74748345142559],
["1myh",1.9,3.26323443405431],
["1ir3",1.9,1.67422894269741],
["2ap1",1.9,1.39742128919839],
["1abf",1.9,2.38398762803252],
["1hye",1.9,2.21566732948272],
["1zle",1.9,1.26268357322280],
["1qou",1.9,1.99598315398851],
["1v6h",1.9,1.89307468152283],
["1iow",1.9,2.83720898247634],
["1c1h",1.9,2.29789056871541],
["2ag6",1.9,2.31303190257262],
["1zh0",1.9,2.3326876607811],
["1qw0",1.9,1.88023985160469],
["2aps",1.9,2.17339614767859],
["1ak1",1.9,2.44171970754885],
["1zei",1.9,2.87697353668021],
["2gbp",1.9,2.54112978163526],
["1gcg",1.9,1.72550922834936],
["1bgp",1.9,1.39110487552564],
["2had",1.9,2.32367289603493],
["1ede",1.9,2.58598582497024],
["1d2a",1.9,2.68076419307118],
["1shk",1.9,2.17890316693344],
["1emd",1.9,2.61260160452568],
["2xyl",1.9,2.0535308659518],
["1fhd",1.9,1.99966211920489],
["1m3q",1.9,2.39361473939531],
["1wl7",1.9,2.29566525923665],
["2fsj",1.9,1.60786228009995],
["1xvw",1.9,1.96446540921349],
["1tm2",1.9,2.06249359151324],
["1t25",1.9,1.52531595886816],
["1ysd",1.9,1.86096465605762],
["1jkg",1.9,2.01288913351800],
["1hnh",1.9,2.54462829102504],
["1fjw",1.9,1.87610935077132],
["1kto",1.9,1.55586232797104],
["2fqy",1.9,2.14973593995907],
["1lna",1.9,2.28315373193775],
["1tmn",1.9,2.38767974266007],
["1dyi",1.9,2.73399486367193],
["1dhi",1.9,2.24179404993889],
["2drc",1.9,2.35281446517859],
["3drc",1.9,2.14960888622929],
["1dra",1.9,2.3309619792725],
["1dyh",1.9,2.74366955065927],
["2d0k",1.9,2.38331005014686],
["1u58",1.9,2.48452217725845],
["1wtc",1.9,2.17362067405845],
["1g5n",1.9,1.94653873525191],
["1a8a",1.9,2.64921460359689],
["1a8b",1.9,2.92233173279838],
["1bri",1.9,2.19317011171417],
["1ist",1.9,2.20648867036628],
["1fkm",1.9,2.31987801705706],
["1qui",1.9,2.23248491123999],
["1quj",1.9,2.24694732940033],
["1pbp",1.9,2.29567265369353],
["1c9y",1.9,2.14370707779132],
["1qth",1.9,4.16677039158083],
["1tlo",1.9,2.28275796678364],
["1ib2",1.9,2.09547266513073],
["1hgx",1.9,2.04727086270836],
["1zsx",1.9,1.53968569229014],
["1ize",1.9,1.40810020883023],
["1izd",1.9,1.69378076501381],
["1np6",1.9,2.39991084135467],
["1lf4",1.9,2.24814568749169],
["1pmz",1.9,1.97122321763074],
["2cy7",1.9,2.32037932633277],
["1q98",1.9,2.66468717126592],
["2c9w",1.9,1.78489054729171],
["1ygh",1.9,2.56675581719595],
["1b8p",1.9,2.06626718706838],
["2c7o",1.9,1.86531392552310],
["2c7r",1.9,2.03130799519727],
["1eyw",1.9,1.96929980596109],
["1oqg",1.9,2.02205444323586],
["1nv4",1.9,2.8373509806048],
["1nuz",1.9,2.77487155092372],
["1tfa",1.9,2.18954754446099],
["2fa8",1.9,2.09246038998451],
["2bi0",1.9,2.13876871899313],
["1epq",1.9,1.95684074671325],
["1ceo",1.9,2.02221623112580],
["1epp",1.9,1.96706224544161],
["1ent",1.9,1.93615111489497],
["1ae9",1.9,1.47574322058444],
["1nv1",1.9,2.8956172697397],
["1nv5",1.9,2.8956172697397],
["1t45",1.9,1.87617946980780],
["1lee",1.9,3.04512585949164],
["1dw1",1.9,2.00245536573466],
["1n67",1.9,2.19890099746963],
["1g1s",1.9,2.06497101497688],
["2ble",1.9,1.91477702436711],
["1nie",1.9,2.33390237823482],
["1nic",1.9,2.31397684767668],
["1b63",1.9,2.05103202782700],
["1pp1",1.9,1.58186695519453],
["1haw",1.9,1.60209343597157],
["1xf8",1.9,1.87861994695819],
["1p4n",1.9,1.78636598280855],
["1vq3",1.9,1.56379492380450],
["1et5",1.9,1.90228501031372],
["1hau",1.9,1.47319633586819],
["1gs8",1.9,1.55798753080401],
["1ck6",1.9,2.18892977210049],
["1ary",1.9,2.34733494872755],
["1arx",1.9,2.35243077369225],
["1arp",1.9,2.48772113302589],
["1tiq",1.9,2.50868504939874],
["1yvo",1.9,1.80724528194199],
["1kvr",1.9,2.01158286141203],
["1a9z",1.9,2.16995406462003],
["1nkx",1.9,2.80295964480089],
["1kvu",1.9,2.21025460680922],
["1lrj",1.9,2.68306964298374],
["1qzg",1.9,2.7934048684466],
["2g93",1.9,2.42189100766446],
["1m8z",1.9,2.3464444120898],
["1wgt",1.9,2.58081940828493],
["1w31",1.9,2.95927047079122],
["1fth",1.9,2.01138747014295],
["1g49",1.9,2.68561380297609],
["1gif",1.9,2.77187467941091],
["1nj4",1.9,2.47399112982961],
["1zav",1.9,2.63739004211097],
["1m66",1.9,1.91080095083480],
["4bcl",1.9,2.76455418834689],
["1alv",1.9,2.40762146649120],
["1ikg",1.9,1.52628963578958],
["1kq9",1.9,1.31234120130413],
["1v7b",1.9,2.24777726962331],
["1d0v",1.9,2.74596068226728],
["1d0s",1.9,2.89891802723653],
["1l5n",1.9,2.01228049121651],
["1l5f",1.9,1.93752433059377],
["1gcz",1.9,2.25724317370399],
["1ua6",1.9,2.15462464760014],
["1iaz",1.9,2.1984202635409],
["1xuu",1.9,2.26383905539404],
["1g7m",1.9,2.12608378376742],
["1xh6",1.9,2.20845313672936],
["1js2",1.9,2.37133541297135],
["1wlt",1.9,2.3652596287265],
["1je5",1.9,2.70771335744584],
["1f5m",1.9,2.47439944030638],
["1jg6",1.9,1.9662738482174],
["1me8",1.9,1.94442256089931],
["1iwm",1.9,2.51895352912382],
["1i5a",1.9,2.39102460744443],
["1zes",1.9,2.08697390534268],
["2adu",1.9,2.151120629709],
["1i5c",1.9,2.44314398106515],
["2bje",1.9,2.11041067612454],
["1k9y",1.9,2.08723281228601],
["1srr",1.9,3.52848976551493],
["1p52",1.9,1.91771261789970],
["1f2j",1.9,2.34382465431561],
["2mnr",1.9,1.64207543776411],
["1g01",1.9,2.08447788880450],
["1r3v",1.9,1.98299489987366],
["1g0c",1.9,2.22501185363106],
["1q8u",1.9,1.54288920270592],
["2cwq",1.9,2.03854132035215],
["1jdw",1.9,2.3835238418101],
["1p0d",1.9,2.36031124968168],
["1k30",1.9,1.66167141240763],
["1agq",1.9,2.52746182364197],
["1vlc",1.9,1.59853148698552],
["1gz1",1.9,2.18435288529407],
["1v2d",1.9,2.30823334690960],
["1c0i",1.9,2.70375831662559],
["1tg5",1.9,2.78889564584890],
["1h62",1.9,2.44369464936867],
["1g8i",1.9,2.18267528415223],
["1vhe",1.9,1.59644227142106],
["1xbw",1.9,2.85576957517269],
["1mor",1.9,2.29341275777653],
["1qn9",1.9,2.22945465626489],
["2dcz",1.9,1.22500794103684],
["1hsb",1.9,2.07556911050196],
["1ez3",1.9,2.15237509532084],
["1jvy",1.9,2.58775235041957],
["1r58",1.9,2.67891992036896],
["1u56",1.9,2.4983660931623],
["2bhg",1.9,2.31893285028706],
["1fqa",1.9,2.42589634646937],
["1fqb",1.9,2.34135079670135],
["1pl3",1.9,1.63660958349448],
["1d7b",1.9,1.64530316648062],
["1d7d",1.9,1.8541142235189],
["1xhk",1.9,2.25478125089023],
["1ca1",1.9,2.62310802666429],
["1nh2",1.9,1.55930501913937],
["1mdq",1.9,3.11514006598990],
["1l3j",1.9,1.88486892259311],
["1sq9",1.9,2.54288622467968],
["1qne",1.9,2.45963108809756],
["1acv",1.9,1.66078805728493],
["1q3e",1.9,2.10922350262433],
["1bhe",1.9,2.39863970751724],
["1fzj",1.9,1.87862331313403],
["1iak",1.9,2.20114760758716],
["1e4f",1.9,2.35205717593295],
["1d7c",1.9,1.85168246169872],
["1qqn",1.9,1.76693135992671],
["1ba0",1.9,2.14562455646127],
["1qqm",1.9,1.67639765013428],
["1qqo",1.9,1.62081207915216],
["1zx8",1.9,1.5360489556132],
["1t1z",1.9,2.21831645639727],
["1ydp",1.9,2.79462518742825],
["1wbx",1.9,2.03383313151716],
["1wwj",1.9,2.91417193939831],
["2bno",1.9,2.04958981320459],
["1dil",1.9,2.7044614483747],
["1n2a",1.9,2.49935346944795],
["2ngr",1.9,2.11598830298304],
["1fc9",1.9,3.14507065951513],
["1clk",1.9,2.39352481614087],
["8xia",1.9,1.85166529703611],
["9xia",1.9,1.7834825499762],
["1m4v",1.9,2.09625883997643],
["1ktb",1.9,2.03822042592031],
["2qwf",1.9,2.24166079689283],
["1uol",1.9,1.84813965989273],
["1u1t",1.9,1.91764703118276],
["1o91",1.9,2.09181158553867],
["1wc3",1.9,2.11566861628129],
["1hsh",1.9,2.91692123889758],
["1vsc",1.9,3.04766780102563],
["1avx",1.9,3.46601850668905],
["1pbe",1.9,3.00461920411847],
["1kk3",1.9,2.30419930561997],
["1ap6",1.9,2.46301770598404],
["1eqp",1.9,1.65085113871059],
["1u2w",1.9,2.39483222429928],
["2g3p",1.9,2.68914946627546],
["1et6",1.9,1.50751793054013],
["1toj",1.9,2.08902531368247],
["1toi",1.9,2.14621444979231],
["1svb",1.9,1.99153611840320],
["1tro",1.9,3.02010753884948],
["1qis",1.9,2.45671750490985],
["1qit",1.9,2.79654311654413],
["1y4i",1.9,2.58076731885893],
["2fre",1.9,1.8373932101302],
["1g0s",1.9,2.52693107190293],
["1ar4",1.9,2.36483054583819],
["1ys3",1.9,2.17360137444471],
["1mky",1.9,1.54351990208467],
["1r1s",1.9,2.96811982936911],
["6cp4",1.9,2.23091081197511],
["1cp4",1.9,2.31387970261513],
["6cpp",1.9,2.35620037123434],
["3cpp",1.9,2.47379908634933],
["1t9m",1.9,2.29497020098849],
["1i5z",1.9,2.17805159376686],
["1eu8",1.9,2.41472589270176],
["1j6p",1.9,1.94292458260122],
["2hoh",1.9,1.30917110137279],
["1bvi",1.9,1.45891749564893],
["1rkv",1.9,1.72555685461465],
["1qoz",1.9,1.52934194320898],
["1o0e",1.9,2.14208506770336],
["1lol",1.9,2.07478357874285],
["1lp6",1.9,1.82158115778024],
["1ws7",1.9,2.49248166649313],
["1iso",1.9,1.66664766666605],
["1ai2",1.9,2.75226125507217],
["1ai3",1.9,2.90952870862843],
["1nsw",1.9,2.61761853891714],
["3gss",1.9,2.36923533041348],
["6gss",1.9,2.38606603975944],
["2gss",1.9,2.32720481206443],
["21gs",1.9,2.40488100447355],
["22gs",1.9,2.52565601839882],
["18gs",1.9,2.57267655211893],
["16gs",1.9,2.65140800885295],
["19gs",1.9,2.79316711987426],
["1eyb",1.9,1.75129332059948],
["1vjd",1.9,2.38024379994425],
["17gs",1.9,2.31222110626398],
["1l7p",1.9,2.27765133434429],
["1glp",1.9,1.65380953140136],
["13gs",1.9,2.31920906406177],
["2bt0",1.9,2.03184337046654],
["2cdd",1.9,2.03184337046654],
["2pgt",1.9,2.53119473913567],
["1jdc",1.9,2.70194249940175],
["1jdd",1.9,2.85370246115128],
["2bz5",1.9,2.42171476938263],
["1nut",1.9,1.98715805919295],
["1nuq",1.9,2.08495294436084],
["1nuu",1.9,2.35834373346782],
["1nup",1.9,2.31018056478874],
["1esg",1.9,2.60856402935631],
["1s3k",1.9,2.33281331343943],
["5cts",1.9,2.98202505527984],
["4csc",1.9,3.1852448167149],
["3csc",1.9,3.32002064116996],
["1u0z",1.9,2.08573769805946],
["1bc2",1.9,2.29632716889633],
["1so3",1.9,1.53705642625791],
["1x8t",1.9,1.93504902944994],
["1mhw",1.9,2.19450887047359],
["1z4o",1.9,1.82398645638655],
["1eeh",1.9,2.04520654996502],
["2c1x",1.9,2.13006656382157],
["1k6d",1.9,2.12286497317533],
["1v5y",1.9,1.8638013516279],
["3gst",1.9,2.52066156836818],
["4gst",1.9,2.92946940272469],
["1kel",1.9,2.34341649001407],
["1jfq",1.9,2.93498809318035],
["1c1e",1.9,3.38508928273073],
["1dy4",1.9,1.33112374922917],
["7cel",1.9,1.40340730771992],
["5cel",1.9,1.47733023898542],
["6fab",1.9,3.23570435280378],
["2f1g",1.9,1.56352879215414],
["2c1z",1.9,1.96273879678452],
["1ce1",1.9,2.71198662098949],
["4enl",1.9,2.51572254374644],
["1m0s",1.9,2.03193854261623],
["1ml6",1.9,2.05593219587453],
["1zht",1.9,1.85311675256344],
["1zhz",1.9,2.03319522026569],
["1r8c",1.9,2.13673584361328],
["1swq",1.9,2.49933204635889],
["1b93",1.9,2.25239389843008],
["1wl9",1.9,1.15098353985370],
["1yei",1.9,2.54695612233745],
["1kn2",1.9,2.68503686811072],
["1kn4",1.9,2.64233680878232],
["1yec",1.9,2.84279895593157],
["1f3a",1.9,2.70763250161360],
["1koq",1.9,2.06558585826128],
["1dvf",1.9,3.02792625116935],
["2fb4",1.9,2.6665558784436],
["1kwz",1.9,2.01457909768737],
["1kww",1.9,1.97167753614029],
["1kdo",1.9,2.12889467917960],
["1okb",1.9,1.55481168524864],
["1kop",1.9,2.15782208968813],
["1rxd",1.9,2.65451611063797],
["2fim",1.9,2.24020044643071],
["3rp2",1.9,2.96954772006757],
["1yai",1.9,2.15136177454878],
["1loe",1.9,2.54622758111967],
["1zck",1.9,2.95811175541883],
["1bgv",1.9,2.67708429245775],
["1shm",1.9,1.94342526281384],
["2bqp",1.9,2.52853804741941],
["1v7p",1.9,1.78113797432916],
["1esf",1.9,2.75384519254502],
["2bpb",1.9,1.35893304266149],
["1les",1.9,2.42868305525538],
["1umw",1.9,2.85936060898687],
["1ovn",1.9,2.28853064918183],
["1zx9",1.9,2.15079576539610],
["2a56",1.9,1.85405780326940],
["1swd",1.9,3.07983947832069],
["2fkm",1.9,1.55801866910574],
["1pcm",1.9,1.94992828014285],
["2bg1",1.9,2.03215126917388],
["1jfl",1.9,1.67588780934445],
["1ua4",1.9,1.94457898011313],
["1fmi",1.9,2.57148514451107],
["1sfl",1.9,3.03579569583782],
["1mus",1.9,2.52450495650504],
["1sn5",1.9,2.17369881599663],
["1sn0",1.9,2.18589446321021],
["1k4q",1.9,2.54373281972195],
["1afb",1.9,1.67528657666168],
["1gfl",1.9,2.6231780248534],
["1zcj",1.9,2.66582486385174],
["1l2t",1.9,1.99157387422509],
["1nxj",1.9,1.66264468307561],
["1eo4",1.9,2.36772867058738],
["1blx",1.9,3.02213461803671],
["1s55",1.9,2.83034577372339],
["1qmy",1.9,2.15818759159480],
["1swr",1.9,2.71752216584886],
["1h5x",1.9,2.48844348834633],
["1suo",1.9,1.92306906918662],
["1xg2",1.9,1.56505317385505],
["1qvw",1.9,2.04746604727654],
["1n75",1.9,2.18181058020870],
["1t06",1.9,2.04562692738777],
["1w17",1.9,1.94981056235915],
["1vhy",1.9,2.44849216311013],
["2gep",1.9,2.09027378217948],
["1rqb",1.9,1.82402687895897],
["1kff",1.9,2.43424510797592],
["1w1r",1.9,1.48495548445101],
["1y5e",1.9,2.00585816789728],
["1wzc",1.9,2.47516173017693],
["1zfj",1.9,2.91953120231518],
["2a07",1.9,2.36821410754352],
["1y4c",1.9,1.98637914895717],
["1jsm",1.9,2.68864748056126],
["1zeb",1.9,2.29816302420089],
["1v83",1.9,2.46682853000307],
["1zef",1.9,2.44758022722955],
["1nmd",1.9,2.48208471249670],
["1bli",1.9,2.25352232423399],
["2d3n",1.9,1.74459282109235],
["1wpc",1.9,1.93942226306742],
["1wlk",1.9,2.24612569223843],
["1e3x",1.9,1.63155092475635],
["1lan",1.9,1.75614753632474],
["1pu5",1.9,2.49011372422076],
["1gyb",1.9,2.62018508818008],
["2fhx",1.9,2.07195591338566],
["1b97",1.9,2.43747357857848],
["1b94",1.9,2.57080364643789],
["1hx1",1.9,2.20539068986093],
["1qb5",1.9,2.45192400271906],
["1tpu",1.9,2.06381698344148],
["1tpv",1.9,2.07601117691268],
["1tpb",1.9,2.02501861472145],
["1tpw",1.9,2.52517868867152],
["1tpc",1.9,2.28950176726518],
["1v3i",1.9,2.35968861435527],
["1pg0",1.9,2.34479302485592],
["1y3q",1.9,2.09474720467201],
["1jxk",1.9,1.80522738933897],
["1byb",1.9,2.95678502785608],
["7tim",1.9,3.07482977251664],
["1ypi",1.9,3.44887720392400],
["1j9l",1.9,2.21041185804844],
["1j9j",1.9,2.26959467729168],
["1yag",1.9,1.87176117241015],
["1kbk",1.9,2.25442045261325],
["1ig3",1.9,2.20684910835179],
["1udr",1.9,1.61113814467017],
["1kbb",1.9,2.22116361267325],
["1u30",1.9,1.73154670564952],
["1xcx",1.9,2.20483473594112],
["2c5l",1.9,2.32308086214662],
["1m03",1.9,1.52233415999805],
["1gyc",1.9,2.11034646458131],
["1yuc",1.9,2.16309341600077],
["1esw",1.9,1.88458945596308],
["1o0y",1.9,2.12944831377615],
["1icj",1.9,2.65421241853755],
["1bs4",1.9,2.59492759578468],
["1bsz",1.9,2.68964633050285],
["1r8h",1.9,2.21540485616632],
["1nnw",1.9,1.31871753689036],
["1ufb",1.9,2.20049088778219],
["1the",1.9,2.75282067097984],
["1fws",1.9,2.04687826753206],
["2azu",1.9,1.60512266715729],
["4azu",1.9,1.61529447240874],
["5azu",1.9,1.91388706636532],
["1vlx",1.9,2.39149133974811],
["1r1c",1.9,3.09964183302893],
["1ejj",1.9,3.03955930833902],
["2cye",1.9,2.62053133025391],
["1m0d",1.9,2.01658740912691],
["1ih8",1.9,1.82887153678949],
["1pq4",1.9,2.8303228208436],
["1fwt",1.9,2.10663788691374],
["1nnp",1.9,2.33128616039093],
["1jcy",1.9,2.13571102494731],
["1xu1",1.9,1.74718283972538],
["1g3k",1.9,1.97033024885387],
["1jjw",1.9,2.06195311483579],
["1yqt",1.9,2.31738202661982],
["2f7w",1.9,2.19722010252665],
["2ae2",1.9,1.99743445836508],
["2apg",1.9,1.91862134680859],
["1b4h",1.9,1.78042843067416],
["1b5h",1.9,1.78579274980058],
["1b0h",1.9,1.97529621701067],
["1b2h",1.9,1.95097356331847],
["1ei5",1.9,2.30835361193136],
["1jfr",1.9,2.1307006725423],
["1qh3",1.9,1.79986154837409],
["1b5i",1.9,1.66243735678355],
["1jtp",1.9,1.77710153807933],
["1oen",1.9,2.44495986569384],
["1obw",1.9,2.43894551675266],
["2cy0",1.9,2.55997254841816],
["1mrz",1.9,2.25873948398058],
["1yt8",1.9,1.75481528391787],
["2f4p",1.9,1.50959940848972],
["1njk",1.9,2.76455219439917],
["1yix",1.9,2.77337346211300],
["1ee8",1.9,2.50806818594354],
["1r3j",1.9,2.01498549790568],
["1pbq",1.9,2.26572177769601],
["1aq2",1.9,2.59989255525626],
["2a0q",1.9,2.62277022355144],
["1sw1",1.9,1.83790205354903],
["1sw4",1.9,1.72079850131147],
["1x6l",1.9,1.9606543356435],
["1jdh",1.9,1.63713293960605],
["1ffq",1.9,1.53036480151352],
["1ehn",1.9,1.58419771157173],
["1clc",1.9,2.08594630615206],
["1ecl",1.9,2.73223848733306],
["1v0o",1.9,2.43637007748827],
["1d2m",1.9,2.97234099730931],
["1ndg",1.9,2.15186781079433],
["1ov8",1.9,1.66966937672983],
["1v8f",1.9,1.748403223928],
["3daa",1.9,2.1998824383476],
["9gac",1.9,2.50169860682206],
["1zq9",1.9,2.06482320268869],
["1xua",1.9,1.46497741720975],
["1mw8",1.9,2.71411021483642],
["1yuy",1.9,2.33133056591039],
["1rj9",1.9,2.77099623983462],
["2f99",1.9,2.10604319166596],
["1n2x",1.9,2.61909645729519],
["1buw",1.9,2.10234146935749],
["1ors",1.9,2.93773067576114],
["1e6a",1.9,1.67338010696421],
["1g08",1.9,2.64793468374644],
["1m6y",1.9,2.70854460358128],
["2aot",1.9,2.18349130477397],
["1xz7",1.9,1.91726553921493],
["1y7d",1.9,2.47631251695543],
["1y83",1.9,2.4667062488152],
["1xz2",1.9,1.75755068609621],
["1vwt",1.9,2.15777877728992],
["1hbb",1.9,2.29013172226277],
["1cls",1.9,2.40396770157295],
["1c8u",1.9,2.63594983238324],
["1o1j",1.9,1.93859610757091],
["1xq5",1.9,3.05168052798826],
["1mum",1.9,2.30203269662171],
["9gaf",1.9,2.14863786660336],
["1nk8",1.9,1.4856654578825],
["1nk7",1.9,1.64384890169635],
["1njw",1.9,1.59972188826871],
["1nk9",1.9,1.97123361256817],
["1xc9",1.9,2.38458434917846],
["3bdp",1.9,3.08077662744341],
["1cf3",1.9,1.37432025485573],
["1z83",1.9,1.19530226520746],
["1yxc",1.9,1.87237823569373],
["1wsh",1.9,2.43927338584627],
["1ff3",1.9,1.82985329892400],
["1n5u",1.9,2.79432791881989],
["1ws5",1.9,1.91395326191968],
["1ws4",1.9,2.01791924669981],
["1x1y",1.9,2.11081146081625],
["1p4k",1.9,2.46159178061412],
["1p4v",1.9,2.47482090046218],
["1eer",1.9,3.65805084153854],
["1jpn",1.9,2.27939735388381],
["1v1h",1.9,2.12096906557275],
["1qgj",1.9,1.86096822165489],
["1q7t",1.9,2.02514441304380],
["1st0",1.9,2.58970970987159],
["1vbk",1.9,1.57598964103718],
["1qhi",1.9,2.81338121255476],
["2ki5",1.9,2.80886034952320],
["1e2i",1.9,2.50315504795315],
["1t7n",1.9,1.95087616754866],
["1uj1",1.9,2.87667514624946],
["1e2h",1.9,2.32017233556083],
["1uf7",1.9,1.72949560123092],
["1wwk",1.9,2.41391432578951],
["1p0k",1.9,2.14933572457916],
["1xxu",1.9,2.41511668174754],
["2a8j",1.9,2.33911216790522],
["2adf",1.9,1.88430295523111],
["1uxg",1.9,2.08020232516587],
["1m9d",1.9,2.07624027102753],
["1i7n",1.9,2.26315501363799],
["1dlt",1.9,2.38800402843203],
["1qte",1.9,1.26884893745642],
["1jrb",1.9,1.95185304355974],
["2cx5",1.9,1.74186662791702],
["8gss",1.9,2.28030540769843],
["1sov",1.9,1.51760894189529],
["1y7p",1.9,2.65118212168296],
["1k7f",1.9,2.24557803408496],
["1g9g",1.9,1.32685571094877],
["1g9j",1.9,1.4347908112983],
["2f02",1.9,1.54682468089026],
["1lr5",1.9,2.04988559888981],
["1xed",1.9,2.91687030422929],
["1lrh",1.9,1.85836192386578],
["1k4m",1.9,2.39318144277975],
["1k8x",1.9,2.06122325977909],
["1beu",1.9,2.57098408457013],
["1o7w",1.9,2.1319169918418],
["1f1v",1.9,1.64297681993441],
["1gog",1.9,2.29228329417395],
["1a5a",1.9,2.70355149868210],
["1l6y",1.9,2.82889699983915],
["1ubs",1.9,2.94184532460382],
["1sow",1.9,1.54812446414602],
["1i8j",1.9,2.52136292194358],
["1u7p",1.9,1.86445623788421],
["1kfb",1.9,1.79543067279470],
["1xjb",1.9,2.25547248148073],
["2tys",1.9,2.26533848473603],
["1bmd",1.9,2.56896755833184],
["1ez2",1.9,2.41848834415742],
["1p6b",1.9,2.41860921268963],
["1djp",1.9,2.34598786386352],
["1qqp",1.9,2.68979596293383],
["1q0b",1.9,2.18226005148695],
["1kv9",1.9,2.3656653138639],
["1mqp",1.9,1.90785624967309],
["1jc1",1.9,3.65655912038522],
["1uod",1.9,2.02636363585360],
["1qw7",1.9,2.30399643189979],
["2bpq",1.9,1.94253151025246],
["1l7j",1.9,3.67726014387609],
["1b8d",1.9,2.06449951619590],
["1cb8",1.9,2.29843911658432],
["1oab",1.9,2.04651870040862],
["1zwy",1.9,2.11332875257754],
["1piz",1.9,2.21323019473415],
["1pj0",1.9,2.2949955652935],
["1bxk",1.9,2.87431897604103],
["1yfd",1.9,1.95127498257467],
["2f49",1.9,2.33141175524885],
["1xge",1.9,2.11805795320525],
["2gf0",1.9,1.64633750029795],
["1mn0",1.9,2.59683261551587],
["1z47",1.9,2.43501020637351],
["1i1q",1.9,2.59946056931241],
["1n1e",1.9,1.93134426686459],
["1stm",1.9,2.23398951258405],
["1t91",1.9,2.16478103161000],
["1moj",1.9,2.29421556202508],
["1f0k",1.9,2.29496704891022],
["1v16",1.9,1.91650107660179],
["1iv8",1.9,2.64701112146286],
["2bt2",1.9,1.62620645665363],
["1g4m",1.9,3.08954736942716],
["2coi",1.9,2.90014592454824],
["1pk9",1.9,2.42412790516852],
["1l0e",1.9,1.78117616506414],
["1fsw",1.9,1.81918302589265],
["2c1l",1.9,2.36410306493603],
["1xfc",1.9,2.32564891664328],
["1jyo",1.9,2.36236674979896],
["2nap",1.9,2.65365816017429],
["1kt8",1.9,3.15684363628368],
["1qjw",1.9,2.01596813857233],
["1vom",1.9,2.80548754730759],
["1wzn",1.9,1.87386674120732],
["1s63",1.9,1.96208588451887],
["2akr",1.9,2.23105700115163],
["1x13",1.9,1.91708525039024],
["1t64",1.9,2.24810704408358],
["1kta",1.9,3.12776436477130],
["1ijx",1.9,2.06610451868325],
["1gyg",1.9,2.40823449521504],
["1z9o",1.9,2.31782612730155],
["1lvk",1.9,3.2782863871816],
["1ez9",1.9,2.32763909234443],
["1o61",1.9,1.76829186534751],
["1m05",1.9,2.44937814401656],
["1tzy",1.9,2.38898397308911],
["1g29",1.9,2.09665459511429],
["1xiw",1.9,2.15756426240525],
["1vgy",1.9,2.06692339457064],
["1pnk",1.9,2.40446085697016],
["1qzr",1.9,1.91890707589150],
["1w0o",1.9,2.20942381291872],
["1rwc",1.9,1.8233130152748],
["2sfp",1.9,2.43332089429638],
["1y8z",1.9,2.37857513168423],
["1gmy",1.9,1.84012216749578],
["1o4s",1.9,1.97737877978592],
["2ff4",1.9,1.78238331350237],
["1sft",1.9,2.35865426576662],
["1vfs",1.9,2.93719097387244],
["1ejw",1.9,2.50263092720532],
["1ysl",1.9,2.18896448027899],
["1ef1",1.9,2.34331347621447],
["1rjy",1.9,2.28524860833758],
["1fv1",1.9,2.61048598163223],
["1u0v",1.9,1.98726473339961],
["1el8",1.9,2.20802347560599],
["1el7",1.9,2.08085638813632],
["1l9c",1.9,2.24869169770818],
["4dmr",1.9,1.59927546657985],
["1my1",1.9,2.37468982172265],
["1my0",1.9,2.32821161827548],
["1mxz",1.9,2.35711610879007],
["1my4",1.9,2.18175017552626],
["1mxw",1.9,2.01047194503298],
["1ftj",1.9,2.26009187705694],
["1ued",1.9,2.01485524143245],
["1chw",1.9,2.43227857040359],
["1a4q",1.9,2.32313264309894],
["1ta9",1.9,1.70538766716585],
["2fd6",1.9,2.98857376798082],
["1n3i",1.9,1.91257700035667],
["1z7g",1.9,2.30312905251105],
["1fng",1.9,2.20655998656353],
["1fne",1.9,2.27567141296564],
["1yro",1.9,2.38289597288295],
["2a3b",1.9,1.54975225650074],
["1fkn",1.9,2.39156473989608],
["1v40",1.9,2.31936870596874],
["1q0q",1.9,1.83104258990032],
["1jxz",1.9,2.496141313397],
["1xa4",1.9,1.71592898583389],
["1chm",1.9,2.78933244146549],
["7aat",1.9,2.32511146345124],
["1z62",1.9,2.60985005720807],
["1dz6",1.9,2.15500493137467],
["1dz8",1.9,2.11344996827222],
["1dz9",1.9,2.26584357901234],
["1t86",1.9,1.89542442519565],
["2a1n",1.9,2.16587026589102],
["1t88",1.9,2.13815751682335],
["1zzq",1.9,2.17123477181731],
["1p6i",1.9,2.34513715108357],
["1zzu",1.9,1.84565646595934],
["1fgm",1.9,1.78263008066186],
["1ww2",1.9,2.65109541476987],
["2agd",1.9,1.65021498009969],
["1t3c",1.9,2.93275475954845],
["2cst",1.9,2.88246875826699],
["1a88",1.9,1.84934405374356],
["1los",1.9,2.24717751525702],
["2bnr",1.9,2.36788682953108],
["1ocm",1.9,2.24258930965558],
["1gpb",1.9,3.87248361497714],
["1obj",1.9,2.28983110231947],
["1kd0",1.9,2.20023521863775],
["1usq",1.9,2.29198233489887],
["1h4h",1.9,2.12586342125381],
["1x1o",1.9,2.21103746584016],
["1nw2",1.9,2.10417400354993],
["5nse",1.9,2.40806508837039],
["1nse",1.9,2.76835952097624],
["1dmk",1.9,2.6120990551218],
["1td1",1.9,1.92849947302632],
["2fef",1.9,1.64498304333075],
["1y60",1.9,2.03701931681178],
["1dlg",1.9,2.0411173676329],
["1qco",1.9,1.66047958804212],
["1yiy",1.9,3.66628157558143],
["1qcn",1.9,2.02320673812591],
["1xyf",1.9,1.85841363338145],
["1xxm",1.9,1.85919598680773],
["1dv1",1.9,2.51895911160799],
["1lu9",1.9,1.57524679142208],
["1c7t",1.9,2.54890446235537],
["1kqd",1.9,1.69380805490075],
["1qa7",1.9,3.54122496324263],
["1ggx",1.9,2.16194272480489],
["1zgp",1.9,1.73559752033114],
["1qu1",1.9,2.64937473102525],
["1xw6",1.9,2.36406868012131],
["12e9",1.9,2.59813403823097],
["1qk4",1.9,2.06689500633101],
["1ebh",1.9,2.45105626956318],
["1b8a",1.9,1.94273557893935],
["1yqo",1.9,2.09146596031444],
["1cq1",1.9,2.41190476391126],
["1rhh",1.9,2.53607326446945],
["1zhq",1.9,1.52358559037976],
["1b8j",1.9,2.13219884303375],
["1mzn",1.9,1.89824900495589],
["1cza",1.9,1.91103762658268],
["1jmx",1.9,2.85173726923732],
["1wlv",1.9,1.88375283893341],
["1sox",1.9,2.27368079547247],
["1wzo",1.9,1.74699609128642],
["1zpg",1.9,2.21596213541489],
["1n2m",1.9,2.09060827624717],
["1nxd",1.9,2.17153641197411],
["1unn",1.9,2.84848135860293],
["1obb",1.9,2.21532067621182],
["1k57",1.9,2.09567651482117],
["1oqs",1.9,2.61037533536250],
["2ao9",1.9,2.17673474410639],
["1np7",1.9,2.55920870995070],
["1jv1",1.9,2.20663286260821],
["1hn0",1.9,2.40918157751278],
["1tg7",1.9,1.81757025016113],
["1v08",1.9,2.10619368685064],
["1h49",1.9,2.52275928363487],
["1rzp",1.9,1.90166311442584],
["2bk4",1.9,1.69766629332443],
["1ur8",1.9,2.14035620481609],
["1w1t",1.9,1.95617401566839],
["1u6z",1.9,1.83918213101142],
["1f0x",1.9,2.88453140399382],
["1px0",1.9,2.78236990104763],
["1npj",1.9,2.2654206511484],
["1j9s",1.9,1.90614097642892],
["1amu",1.9,1.90175657662320],
["2fuw",1.9,2.53109816896027],
["1tqt",1.9,1.86716339526234],
["1loj",1.9,2.90426863831908],
["1qg6",1.9,2.06327450265968],
["2bja",1.9,1.93376227338513],
["1xb9",1.9,2.62094266349713],
["2b4y",1.9,1.96727658449333],
["2aka",1.9,2.4322447949115],
["1rlm",1.9,2.31495982710987],
["2esl",1.9,2.39256623486926],
["1q8j",1.9,2.65020548973662],
["2b6e",1.9,1.97386756394449],
["1qsj",1.9,3.25500695814844],
["1aoz",1.9,2.25924521425127],
["2g5c",1.9,2.48573899078808],
["1g98",1.9,2.67224283264503],
["1koj",1.9,2.84110408819932],
["1otj",1.9,2.54087455638855],
["1yxm",1.9,2.31438692140317],
["1lsh",1.9,3.11420305332558],
["1d5l",1.9,1.75894992533316],
["1dnw",1.9,1.80201504760644],
["1d7w",1.9,2.18532932690531],
["1xg3",1.9,2.23116254351596],
["1hvy",1.9,2.34207425763637],
["1h5t",1.9,2.43638889705323],
["1h5r",1.9,2.51288774445458],
["1ava",1.9,2.68157461578189],
["1wws",1.9,2.06955122675619],
["1j0h",1.9,1.94287943977192],
["1f28",1.9,2.89544782130734],
["1h74",1.9,2.89096802358371],
["1ndf",1.9,2.27371388155330],
["1oni",1.9,2.21967770831545],
["1wa3",1.9,2.28067890118969],
["1m9y",1.9,2.49257071278431],
["1tf4",1.9,1.99751282600905],
["1kfg",1.9,1.97903532418859],
["1i9c",1.9,1.85667886019071],
["1xje",1.9,2.18341208442232],
["1ivu",1.9,2.20599861863967],
["2dfd",1.9,1.54552368039847],
["1g72",1.9,2.08775088368450],
["1t3t",1.9,2.20211251869438],
["1epw",1.9,1.93453743954682],
["1s0e",1.9,2.23860357959509],
["1h8v",1.9,2.10488302080679],
["1hg0",1.9,2.10805898874028],
["1pzh",1.9,1.56590518991496],
["1j4a",1.9,2.6275889261296],
["1qgd",1.9,1.45165682702401],
["2chs",1.9,2.17862328008337],
["1vjj",1.9,2.23438233517912],
["1li1",1.9,2.03413143912574],
["1t5o",1.9,2.59956747080382],
["1h1m",1.9,1.92628316634072],
["1lw4",1.9,1.8857478152618],
["1umd",1.9,1.93388949434238],
["1odk",1.9,1.56103504267830],
["1uks",1.9,2.21492447542886],
["1d7f",1.9,2.43790863621917],
["1h83",1.9,2.15338891652217],
["1b5q",1.9,2.07502158232802],
["1b37",1.9,2.05228161300968],
["1h82",1.9,2.41485504953412],
["1gqk",1.9,1.79605219417598],
["1gqj",1.9,1.89581747153071],
["1qdb",1.9,1.83724288711858],
["1pl8",1.9,2.01496824466092],
["1vps",1.9,1.69238739622861],
["2b2o",1.9,1.21020462458189],
["2b2r",1.9,1.13561189176592],
["1x7u",1.9,1.95223878389274],
["2ash",1.9,1.80082294405353],
["1l7e",1.9,2.84180727395562],
["1fba",1.9,2.28608333251462],
["1ado",1.9,2.37345510789400],
["1pfq",1.9,3.24027987183399],
["1s5e",1.9,2.01572489173120],
["1c9s",1.9,1.99524465314441],
["1uhg",1.9,2.54836626366101],
["1utf",1.9,2.00989197796695],
["1utv",1.9,2.03443857984441],
["1r0d",1.9,2.0634299724468],
["1e61",1.9,1.57372794645738],
["1u1i",1.9,3.94023340728811],
["1xn2",1.9,2.27379551958340],
["2buh",1.9,2.38672403725094],
["1sff",1.9,2.10775302332885],
["1rf6",1.9,3.00696946952219],
["1ec7",1.9,2.65760561709007],
["1zgq",1.9,1.53471713231818],
["1vkm",1.9,1.61687034191081],
["1ec8",1.9,2.48829793878026],
["1uxm",1.9,2.86112380317126],
["1xf1",1.9,3.16341092533916],
["1z10",1.9,2.41107438577088],
["1h64",1.9,2.3970440943397],
["1q16",1.9,2.23703113952682],
["1h1l",1.9,1.98960148827513],
["1uvj",1.9,2.53107747617987],
["1gu9",1.9,3.05079599264065],
["1gk2",1.9,2.52174122985049],
["2ahu",1.9,1.90142570030142],
["1zem",1.9,2.44944750467435],
["1yi7",1.9,2.00045618214384],
["1jiq",1.9,2.03268264971921],
["1fzw",1.9,2.36714575057261],
["1pkx",1.9,2.16272795898289],
["1mpx",1.9,1.47171877367471],
["1hbu",1.9,1.92987562051115],
["1kek",1.9,2.81476652081476],
["1ojx",1.9,1.64502929207396],
["1ods",1.9,2.10141479087625],
["1ynf",1.9,2.22022469371960],
["1uyp",1.9,2.84561554094913],
["1yg6",1.9,2.61951440720500],
["1hfb",1.9,2.86898373424758],
["1oao",1.9,2.41381204231286],
["1qws",1.9,2.29174256037718],
["1szo",1.9,1.54864809389719],
["1c7n",1.9,2.22450553160859],
["1v55",1.9,2.36041099620723],
["1o02",1.9,1.61557723802477],
["1zo8",1.9,2.61305314117653],
["1h7w",1.9,2.17271364428872],
["1yar",1.9,1.99912621827494],
["1yq2",1.9,1.83035819484880],
["1ryp",1.9,2.63188792996812],
["1u3y",1.9,1.73169430262111],
["1u3j",1.9,1.82954387953902],
["1yyh",1.9,1.45973199999864],
["1z40",1.9,2.08924800842461],
["1so6",1.9,1.46594708173683],
["1nl7",1.9,2.61542809091275],
["6paz",1.91,2.82711097941416],
["1mjs",1.91,2.30458928616504],
["1qb0",1.91,1.65857932778646],
["1ko3",1.91,2.1141151661262],
["1z0m",1.91,1.93645919465726],
["1a4b",1.91,2.23799670229743],
["1vk4",1.91,1.36393755405181],
["2f4j",1.91,2.45480013811548],
["1qvj",1.91,2.29938016166402],
["1r7s",1.91,2.01446961433363],
["1lt1",1.91,2.26184546572755],
["1vbl",1.91,2.40380304989946],
["1y57",1.91,1.38884961179771],
["1uzn",1.91,2.09981841503689],
["1u09",1.91,1.88544693159238],
["1cns",1.91,2.45225265792286],
["1yh3",1.91,3.16212731987136],
["2gf6",1.91,2.28911802021935],
["1jpa",1.91,1.87636056396425],
["1pfu",1.91,1.90301029055558],
["1sfq",1.91,2.32231381061028],
["1jqe",1.91,2.21321498549639],
["1y4g",1.91,2.05826658658992],
["1rq3",1.91,2.01776097496801],
["1xxt",1.91,2.38511032528915],
["1q1r",1.91,2.26342785849821],
["1lk3",1.91,2.20605263958212],
["1r0k",1.91,1.87178685070782],
["1z6o",1.91,1.54179862232518],
["1lr0",1.91,1.94122702010304],
["1pgb",1.92,2.42903627243166],
["1uo3",1.92,2.11587135077041],
["1nxs",1.92,2.68363792317374],
["1o7z",1.92,2.77243532778908],
["1nxw",1.92,2.45773189059856],
["1w5k",1.92,1.62381605868183],
["1vwf",1.92,2.46498298812986],
["1iko",1.92,2.35891571295747],
["1fua",1.92,2.33511517074071],
["1dzz",1.92,2.32154640434370],
["1ak2",1.92,2.161268012577],
["1xuj",1.92,2.16303376356457],
["1v2p",1.92,1.86591915602129],
["1u02",1.92,1.69244233890265],
["1nwo",1.92,2.21967439470271],
["1i9p",1.92,2.43557557155280],
["1pzt",1.92,2.16606623644435],
["1kqz",1.92,1.83523658652627],
["1kqy",1.92,1.88361525640060],
["1kr0",1.92,1.92506257962792],
["1fjs",1.92,2.52206508986214],
["1urn",1.92,2.01644907222134],
["1ppb",1.92,2.89548819380547],
["2bsa",1.92,2.01813793986950],
["1gom",1.92,1.63262785632403],
["1bvw",1.92,1.73526010095457],
["1i14",1.92,1.91562322910126],
["1jzo",1.92,1.81923860533873],
["1f6t",1.92,2.98620072417538],
["1z0k",1.92,1.72516003668246],
["1a4u",1.92,2.53791642599369],
["2bib",1.92,2.27110175247309],
["1xm6",1.92,1.80734723624384],
["1gwi",1.92,1.8928686347286],
["1xl0",1.92,2.37671830388241],
["2akm",1.92,2.71938331901892],
["2bvf",1.92,2.18307789090380],
["1k7h",1.92,2.22458584084436],
["1vr6",1.92,1.73748738304147],
["1pqu",1.92,2.35210227371984],
["1qfl",1.92,2.89374813642451],
["2c1d",1.92,2.16418518165420],
["1ggj",1.92,2.37449784404806],
["1f9p",1.93,2.69592287716677],
["1bc8",1.93,3.06459283705274],
["1oap",1.93,2.44466682939366],
["3lyo",1.93,2.37744575383929],
["2lyo",1.93,2.234804047812],
["1lyo",1.93,2.25016755594047],
["1w15",1.93,2.44944129419438],
["1rn8",1.93,2.14545856109529],
["1yvd",1.93,1.75716866870370],
["1b1c",1.93,1.97446915407513],
["1kwa",1.93,2.47277677533001],
["2f8p",1.93,2.13208898469183],
["1p11",1.93,2.13220073484241],
["1nd1",1.93,2.75036849829756],
["1tio",1.93,1.94870499194343],
["2tio",1.93,1.92365460551827],
["1jw6",1.93,2.37114951105292],
["1nli",1.93,2.30478359813414],
["2dcc",1.93,2.68544747457697],
["1i9l",1.93,1.98631634981564],
["1if4",1.93,2.0911964874445],
["1i8z",1.93,2.16763322854827],
["2c43",1.93,2.15748020993522],
["2cz4",1.93,2.39093922536683],
["1y08",1.93,2.09730513461926],
["1h2s",1.93,1.63511572653434],
["1k22",1.93,1.91617126941250],
["2prn",1.93,2.27124013029947],
["1jsz",1.93,2.48232234584305],
["1dj5",1.93,2.23842702973054],
["1dj1",1.93,2.36649192996243],
["1dzm",1.93,2.78111907618327],
["1qh0",1.93,2.13844038052815],
["1zdn",1.93,2.33684352831137],
["1cyq",1.93,2.21321876202426],
["1q54",1.93,2.46788000403616],
["1q4w",1.93,2.30379552285448],
["1qn5",1.93,2.21911848455781],
["1q5d",1.93,2.44329232107122],
["1kl1",1.93,2.1181381852084],
["1kkj",1.93,2.26614025211111],
["1kkp",1.93,2.01838903464611],
["1ku1",1.93,2.07638475551602],
["1pu7",1.93,2.18418463445648],
["1yzx",1.93,1.73118287002117],
["1e3z",1.93,1.71955016490066],
["1tt1",1.93,2.13107024074643],
["2afq",1.93,1.98550615632523],
["1cp2",1.93,2.92842007236595],
["1pfy",1.93,1.90910655288653],
["1wc1",1.93,2.10369882529411],
["1klu",1.93,2.67868925470219],
["1f4t",1.93,2.72633130012826],
["1tc5",1.93,2.00877344971144],
["2vpf",1.93,2.42931627416645],
["1xkx",1.93,2.49969388661672],
["1d1v",1.93,2.305533506532],
["1foi",1.93,2.31876796011000],
["1bd3",1.93,3.40049987000561],
["1m9n",1.93,2.17519691937320],
["1ekj",1.93,2.54276120706187],
["1dm5",1.93,2.64158831195972],
["1l6w",1.93,1.65041625367239],
["2c3y",1.93,2.72594554454025],
["1w8r",1.93,1.83746547217432],
["1azq",1.94,2.9106293646897],
["1sjv",1.94,2.26152733438915],
["2cy4",1.94,2.57408746949212],
["1ixl",1.94,2.27979023556010],
["1eqv",1.94,2.10017607260552],
["1fqi",1.94,2.20417647015657],
["1woz",1.94,2.06940226646332],
["1cx7",1.94,2.39600154605964],
["1xlr",1.94,2.51602051791632],
["1vgj",1.94,2.36000994891348],
["1inc",1.94,2.04791913023033],
["1xtp",1.94,1.39889013902498],
["1pxw",1.94,2.03713120227761],
["2dc8",1.94,2.32250095685844],
["2dcb",1.94,2.45118192135032],
["2dc9",1.94,2.50796721811239],
["2dc7",1.94,2.63297591375648],
["1z5y",1.94,2.648954611456],
["2giv",1.94,2.85417022175432],
["1c5w",1.94,2.70358660144790],
["1uri",1.94,2.35152901453471],
["1if8",1.94,2.37689114076514],
["1g53",1.94,2.23230047838922],
["1nw6",1.94,2.05556914657423],
["2euv",1.94,1.67131396836969],
["1n99",1.94,1.88501623383917],
["2f94",1.94,1.82680670289555],
["1i5b",1.94,2.5832222778044],
["2akp",1.94,2.96841427520671],
["1t6n",1.94,2.47027189025538],
["1aqv",1.94,2.13446554397439],
["1jvk",1.94,2.87660453982901],
["1gsu",1.94,3.04702653198412],
["1jzt",1.94,2.26289975525319],
["1fwn",1.94,2.19769972581366],
["1w2d",1.94,2.3299324664521],
["1zhh",1.94,1.27183237793318],
["1daa",1.94,2.14842689986420],
["1xru",1.94,1.70457555277208],
["2a6n",1.94,1.56954076734469],
["1wva",1.94,3.10544385648955],
["2cw5",1.94,2.01544706158535],
["1q5k",1.94,2.30038439911789],
["1kcl",1.94,1.96939575330244],
["1x14",1.94,2.2723269930833],
["1vch",1.94,2.52084405346016],
["1p2d",1.94,2.51009985187011],
["1fnu",1.94,3.10534607339758],
["1tl0",1.94,1.64686286411331],
["1kx5",1.94,3.08881340383771],
["1xky",1.94,1.61506600768054],
["1m1t",1.94,2.7117888221611],
["1d2e",1.94,2.74446609303386],
["1nto",1.94,2.40527460636817],
["1svm",1.94,2.53903928462297],
["1v97",1.94,2.29380369828753],
["2c8q",1.95,1.17660398278653],
["1ptq",1.95,1.55193768474257],
["1ljo",1.95,1.67854110313873],
["1os3",1.95,1.96334955551307],
["1lou",1.95,2.24397833003582],
["1opc",1.95,2.93546135087766],
["1cqy",1.95,3.03714841078306],
["1puc",1.95,1.77429442947629],
["1rhl",1.95,1.57424313438127],
["1i2f",1.95,1.30396247826278],
["2bu4",1.95,1.46839376904506],
["1o5j",1.95,2.00715790088452],
["1fkh",1.95,2.35522766883989],
["1i77",1.95,1.48872938093198],
["1yeb",1.95,2.95392827075518],
["1nze",1.95,2.65520918885635],
["1tfg",1.95,2.41893846238391],
["1lve",1.95,3.32178229828718],
["1bea",1.95,3.60584834501148],
["1rlk",1.95,1.99808326745087],
["1pqe",1.95,2.33113871204232],
["1zyx",1.95,2.39792079354949],
["2bh5",1.95,1.88042815045524],
["1hq8",1.95,2.48474088436486],
["1kvw",1.95,3.41094640584500],
["1e86",1.95,2.21272268013984],
["1gp3",1.95,2.63289847492362],
["1snp",1.95,2.34566049973399],
["1uic",1.95,1.87963377732349],
["1uie",1.95,1.97531504050386],
["1uig",1.95,1.44295313374835],
["1uid",1.95,2.11346316236809],
["1klx",1.95,1.50871439723968],
["1mq7",1.95,1.6192789753935],
["1enc",1.95,3.14684824279159],
["1syl",1.95,1.99188935353386],
["1ea8",1.95,2.46997202095523],
["1r2d",1.95,2.43069889327988],
["1k04",1.95,2.21800188129528],
["1y2q",1.95,2.14326616789092],
["1vsh",1.95,2.80682923121689],
["1n1f",1.95,2.94505682640463],
["1b8e",1.95,3.41478146935019],
["1o16",1.95,1.92546348210771],
["1icx",1.95,2.38648159325059],
["1zde",1.95,1.90278401320504],
["1uz2",1.95,2.89138345055027],
["1gv8",1.95,2.41630286984909],
["1f47",1.95,2.28750666724834],
["191l",1.95,2.34738108694245],
["200l",1.95,2.69289163899828],
["1l99",1.95,2.72376606329283],
["2b58",1.95,2.07835874038368],
["2b3v",1.95,2.25575122753429],
["1aew",1.95,1.98482497198771],
["1izm",1.95,2.81709814962926],
["1jrl",1.95,1.76175073749807],
["1a58",1.95,2.57171354162974],
["1l1r",1.95,2.3647814032132],
["1svi",1.95,2.30917104029944],
["2f9m",1.95,2.27596241455550],
["1m1h",1.95,3.0863618785865],
["1owf",1.95,2.19400615179803],
["1g2k",1.95,1.50751793054013],
["1bsw",1.95,2.32382095337],
["1bam",1.95,1.88875668203342],
["1i39",1.95,2.3072993917887],
["1tlv",1.95,2.61955581934188],
["1wm5",1.95,2.12958950602263],
["1sx6",1.95,2.05192413634061],
["1g3u",1.95,1.67298449806916],
["1qrm",1.95,2.28847964748397],
["1nrg",1.95,2.98438665500476],
["1ewc",1.95,2.31151641431793],
["1y71",1.95,2.12087625842624],
["1yuo",1.95,1.87018566285261],
["1o4t",1.95,1.91679090582697],
["1ppy",1.95,1.86541939324327],
["1i7e",1.95,3.0697380455479],
["1e8i",1.95,2.33464323314767],
["1u00",1.95,2.28770515309624],
["1lcz",1.95,2.54907101376645],
["2ctv",1.95,2.18452238079298],
["1axy",1.95,2.08097397033794],
["1ax2",1.95,2.08179739824161],
["1axz",1.95,1.81978077578347],
["1ax1",1.95,2.2185889264144],
["1fb2",1.95,3.28129841634693],
["1gs4",1.95,2.40304300483322],
["1m48",1.95,2.15772784121481],
["2cxb",1.95,2.22018794677792],
["1oae",1.95,2.50101372522245],
["2aa2",1.95,2.23311068754213],
["1sts",1.95,2.73246113496841],
["1ydc",1.95,2.04933274421834],
["1hd7",1.95,2.20006150925522],
["1lj4",1.95,2.50598815922998],
["1ttm",1.95,2.56795702661200],
["1sep",1.95,2.01675930912456],
["1tem",1.95,1.41460786275092],
["1c27",1.95,2.52332881344294],
["1p77",1.95,2.58531487947212],
["2a3i",1.95,3.01126300809657],
["2btl",1.95,2.38599598450356],
["1g68",1.95,1.81070515781632],
["4gal",1.95,2.96489696976633],
["1k27",1.95,1.50035144463634],
["1xc8",1.95,1.83047625868494],
["1uk6",1.95,1.58791433647536],
["1pm5",1.95,1.70308886090596],
["1su9",1.95,2.02545397421392],
["1t7v",1.95,2.34840869747809],
["1uu9",1.95,1.96232578485798],
["2hrv",1.95,2.01101471353986],
["1lhc",1.95,2.88835865245323],
["1w4t",1.95,1.97410398313699],
["1q4s",1.95,2.57160618955733],
["1omh",1.95,2.90013222255957],
["1jt3",1.95,2.09601553553531],
["1biz",1.95,2.40437211834974],
["1tu1",1.95,1.84964133565433],
["2c7s",1.95,1.80044385820269],
["1kw9",1.95,1.6434413682076],
["1yli",1.95,2.46479050378822],
["2biy",1.95,1.85106624895188],
["1spg",1.95,2.97864036770812],
["2c68",1.95,2.28013551078141],
["1e1v",1.95,2.69543961223061],
["1vp9",1.95,2.4280852050952],
["2vp3",1.95,2.54586613309994],
["1i7k",1.95,2.35416927685437],
["1c5m",1.95,3.49346918682744],
["1yon",1.95,1.97252958629957],
["2a0c",1.95,2.77481520568559],
["1pw2",1.95,2.53791954831123],
["1pxi",1.95,2.6793968695172],
["1bis",1.95,2.43711061134947],
["1frq",1.95,2.26270889111534],
["1q0z",1.95,1.78796163746969],
["1j1u",1.95,2.50858389762033],
["1ecv",1.95,2.46118153254333],
["2chl",1.95,1.94166383976121],
["1sug",1.95,1.87824527674104],
["1zb6",1.95,2.32488650585908],
["1qhz",1.95,1.60520045787140],
["1zu4",1.95,2.27404133732136],
["1mno",1.95,2.05320370703041],
["1ihb",1.95,2.39807283803379],
["1fh8",1.95,2.00656959667086],
["2tli",1.95,1.7905173996937],
["3tli",1.95,1.60455250663009],
["4tli",1.95,1.83326530408258],
["7tli",1.95,1.75777232289419],
["1bcy",1.95,2.96524856900399],
["1bc3",1.95,2.70364571919968],
["1pze",1.95,1.80495492471390],
["1h45",1.95,2.01639455265988],
["1aii",1.95,2.03972757090546],
["1t6s",1.95,2.45645860291955],
["1gr0",1.95,2.55559529060380],
["1mx3",1.95,2.64207715358634],
["1s17",1.95,2.1227043178137],
["1wae",1.95,1.69756893741049],
["1ywr",1.95,3.37317668461868],
["1xe4",1.95,2.06028400954203],
["2a33",1.95,1.97607418182942],
["1elp",1.95,2.82127736251060],
["1yby",1.95,1.41347980327573],
["1mjw",1.95,2.37184583159891],
["1meh",1.95,2.07524521449281],
["1y1x",1.95,1.2590660507474],
["2c1a",1.95,1.84152306600913],
["2apo",1.95,1.90552405223362],
["1m3s",1.95,1.91850500224623],
["1m7v",1.95,1.4418427794984],
["1s39",1.95,2.47284654784174],
["1wor",1.95,2.09652521472730],
["1yhl",1.95,2.33038319948937],
["1y42",1.95,2.08067224784414],
["1qn3",1.95,2.08622059497569],
["1a7c",1.95,1.81513444362014],
["1nu5",1.95,2.12648354317648],
["1enu",1.95,2.50316902177053],
["1ucf",1.95,1.69803695897229],
["2gc1",1.95,1.75200507667415],
["1hle",1.95,1.94288732592082],
["2g5d",1.95,2.44661283167664],
["1xti",1.95,2.73940517711368],
["1itv",1.95,2.72598275472150],
["1ww9",1.95,2.39401398431192],
["1w9h",1.95,2.39291455073996],
["1szx",1.95,2.60546108562596],
["1tq4",1.95,2.06602353967395],
["1kk0",1.95,2.14779513115302],
["1jbv",1.95,2.62634132010566],
["1qhd",1.95,2.2515554177627],
["1xly",1.95,2.83812295624750],
["1mie",1.95,2.70258379799267],
["1td0",1.95,2.24399540455007],
["1rkt",1.95,2.17765467485371],
["1crz",1.95,2.68682663004166],
["2aee",1.95,1.95965188502867],
["1wst",1.95,1.81151606883424],
["3hoh",1.95,1.32035729499465],
["5gss",1.95,2.52908599315103],
["1uwv",1.95,2.48966490816172],
["1uag",1.95,1.93232502186577],
["2b9w",1.95,1.35271409809353],
["2ba9",1.95,2.10711324015199],
["1sm3",1.95,2.62967932860369],
["1ydk",1.95,1.82649853734835],
["1lgv",1.95,2.43604829193218],
["1gaf",1.95,2.23437705496550],
["1e4w",1.95,2.73056576391479],
["1d7u",1.95,2.85123220657046],
["2fbj",1.95,2.89549957319098],
["1a3l",1.95,2.20754789276531],
["1yoj",1.95,2.06103396325993],
["2as8",1.95,2.87690867105634],
["1y0e",1.95,2.4218185015012],
["1kwu",1.95,1.92167632937634],
["1kwt",1.95,1.92860108240823],
["3kmb",1.95,1.93543097846296],
["1kdt",1.95,2.56450019442844],
["1i8p",1.95,1.54709767870771],
["1swo",1.95,2.67497613763725],
["1e1k",1.95,1.96702006853987],
["1fif",1.95,1.83484126460910],
["1fih",1.95,2.09981768226399],
["1txo",1.95,1.30666121407960],
["1y12",1.95,1.28974417910554],
["1fk8",1.95,2.59697898777013],
["2cwm",1.95,2.77390207431141],
["1l2i",1.95,1.62386182323706],
["1yb1",1.95,1.17573423283395],
["1aq6",1.95,2.22306931347939],
["5std",1.95,2.67692313756276],
["1q6e",1.95,2.44701198474077],
["1qkz",1.95,2.55403521831243],
["2flb",1.95,2.66270628837637],
["1u2y",1.95,2.04541093441004],
["1u33",1.95,2.09250236176628],
["1m04",1.95,1.50920379610277],
["1ycj",1.95,2.36568154462885],
["1w2c",1.95,1.87474853548581],
["1zy4",1.95,2.48693090204259],
["1g8f",1.95,2.32886855702563],
["2aa6",1.95,1.77420142166514],
["1v9e",1.95,2.60095792576777],
["1yvr",1.95,2.13127160946504],
["1sa3",1.95,2.04558078866336],
["1khy",1.95,2.47778260791691],
["1tsd",1.95,2.79729722089134],
["1t8u",1.95,1.64844562207072],
["1j5w",1.95,2.22983453850575],
["1nzk",1.95,2.19985922075836],
["1q7f",1.95,3.01080808120126],
["1l5u",1.95,1.81000343776134],
["1b4f",1.95,2.59122720587126],
["1oj6",1.95,2.72359467740426],
["1rqj",1.95,2.02825318326719],
["1of1",1.95,2.08281819494302],
["1hs6",1.95,2.90571171894461],
["1h7s",1.95,2.26956577433007],
["2a75",1.95,2.20543675386819],
["1mdw",1.95,2.36033631796485],
["1eua",1.95,2.18752096988750],
["1o7p",1.95,2.29258025575015],
["1bsl",1.95,3.20186617041913],
["1ogd",1.95,1.70609832243414],
["1nns",1.95,2.09811565489786],
["1q40",1.95,1.90090370995770],
["6q21",1.95,3.84102712971368],
["1pj1",1.95,2.19718997279057],
["1r65",1.95,2.24279166415727],
["1osp",1.95,2.30596141760896],
["1xhn",1.95,2.05309636339377],
["2asd",1.95,1.96067907581570],
["1ns2",1.95,2.644563598438],
["1l7k",1.95,2.61050704973573],
["1pb0",1.95,2.37757375343251],
["1r1h",1.95,2.89972653383132],
["1v11",1.95,1.76126571804342],
["1gvn",1.95,1.68490746406581],
["1w9l",1.95,1.64563869849882],
["1ekf",1.95,3.1352723391053],
["1lts",1.95,2.14245094834085],
["1zb1",1.95,2.54910808326009],
["2f6q",1.95,1.76181329425873],
["2aqv",1.95,2.05567933424533],
["2aqo",1.95,2.18748415641823],
["1hf3",1.95,2.26777644650609],
["1nlf",1.95,2.16033990336185],
["1xqk",1.95,2.36896206423847],
["2av1",1.95,2.12824134518496],
["1vi6",1.95,1.87048501799409],
["1l9d",1.95,2.28871112874037],
["1m5f",1.95,1.87945571179343],
["1aw7",1.95,2.43134542642507],
["1mxy",1.95,2.04275923043194],
["1mxv",1.95,1.98659690332163],
["1i8b",1.95,1.94846231862401],
["2a3e",1.95,1.53554595395788],
["1o75",1.95,1.64508213472748],
["1zpt",1.95,2.02785095469469],
["1rs7",1.95,2.35387928687991],
["1rs6",1.95,2.37014454069258],
["1y4k",1.95,1.68824149705659],
["1gzf",1.95,2.39495493527089],
["1d0o",1.95,2.31265474335034],
["1dm6",1.95,2.43662242018931],
["4nse",1.95,2.45145779813766],
["1vl4",1.95,1.68646156063237],
["1nec",1.95,1.75820754215842],
["1b12",1.95,2.67638946141450],
["2brr",1.95,1.84821987527217],
["2cbv",1.95,1.84000776068008],
["1oyj",1.95,2.46001609670729],
["1vl5",1.95,1.44717573027880],
["1fur",1.95,2.29642357322582],
["1ekx",1.95,1.75807323553747],
["1m1z",1.95,2.41706104186337],
["1r5z",1.95,2.4265340651725],
["1uws",1.95,2.06707908882928],
["1uwt",1.95,2.04962965012574],
["1uwu",1.95,2.050131245755],
["1jgt",1.95,2.44430650214101],
["1uiv",1.95,2.83522099536080],
["1j9t",1.95,2.01397016955305],
["1r34",1.95,1.87481085994712],
["1pn2",1.95,1.77337688256064],
["1svl",1.95,2.72613206431835],
["2dbu",1.95,2.06123978322277],
["1t4d",1.95,2.80618961346152],
["1l3i",1.95,2.28098264626923],
["1f73",1.95,1.94303606093677],
["1lv5",1.95,3.20093074731759],
["1z7x",1.95,1.55155114328989],
["1olm",1.95,2.33835208304762],
["1o6z",1.95,2.26174830278235],
["1fo6",1.95,2.19522834830954],
["2oat",1.95,2.66043219366387],
["2b4g",1.95,1.70757234747959],
["1h4o",1.95,2.01055958387103],
["2d0i",1.95,2.35511594050298],
["1ni4",1.95,2.21209864737554],
["1a4m",1.95,2.74319575131353],
["1i7q",1.95,2.74072307191500],
["1k3t",1.95,3.06422366329044],
["1um0",1.95,2.98522358195489],
["1u1g",1.95,1.86568724369913],
["1m1o",1.95,2.75675879539011],
["2asv",1.95,2.19954585811711],
["1g5h",1.95,2.40321426288331],
["2byz",1.95,2.22444495474499],
["1ynh",1.95,2.0699438795209],
["1kbv",1.95,2.55630630749463],
["1umn",1.95,1.88925873418175],
["1p1h",1.95,3.20697470419506],
["2bo4",1.95,2.07532455636317],
["1nfv",1.95,2.10764035931035],
["2ajc",1.95,2.52489182116209],
["1itw",1.95,2.01148637134298],
["2f2h",1.95,2.40861196477013],
["2c1u",1.95,2.21280114829060],
["1h7m",1.96,1.62790963210375],
["1km9",1.96,1.64032948311910],
["1kxw",1.96,1.76545785719686],
["1ifb",1.96,3.50492777928660],
["1a2t",1.96,2.80324780905086],
["1lg7",1.96,2.65537466066414],
["2bf3",1.96,2.54596484437359],
["1s36",1.96,1.34486368868503],
["1teg",1.96,2.08576759679486],
["2cwa",1.96,1.79678822523639],
["1zio",1.96,2.17948346066897],
["2aky",1.96,2.09501071321973],
["1s5p",1.96,2.74112653744827],
["1zhm",1.96,2.26611563862519],
["1hcz",1.96,2.3574753020813],
["1g4o",1.96,2.19315929335525],
["1e5h",1.96,1.87998977091784],
["1vhx",1.96,2.44004909473275],
["1jsv",1.96,2.72101691557731],
["1prn",1.96,2.21197839894412],
["1pxo",1.96,2.69073258791804],
["1be0",1.96,1.89563330598606],
["1jol",1.96,2.63809414049954],
["1qrp",1.96,1.49763213273388],
["1z17",1.96,1.92203393411758],
["1rhf",1.96,2.09681015651640],
["2g74",1.96,2.64886097132818],
["1nfs",1.96,2.45964841452044],
["1mdx",1.96,1.93216196732463],
["1u18",1.96,2.29154656475805],
["1gar",1.96,2.96907630158137],
["1t0o",1.96,2.26962699264621],
["1q9k",1.96,3.2516415353502],
["1n7y",1.96,2.78412877962835],
["1g97",1.96,1.45005063829949],
["1g9k",1.96,1.42333498364761],
["1p60",1.96,2.06695795937577],
["1y9r",1.96,3.69986055130827],
["1pr9",1.96,2.41099352098873],
["1gwf",1.96,1.83671145634976],
["2g9z",1.96,2.36003232431811],
["1v5g",1.96,2.23147389424898],
["1ptm",1.96,2.56190619396671],
["1xgi",1.96,1.97881333707969],
["1xyb",1.96,1.96286087957411],
["1vi9",1.96,2.11482839144693],
["1hrd",1.96,2.93171955298766],
["1xfo",1.96,2.03520657690359],
["1lvo",1.96,2.80276862677073],
["1k7w",1.96,2.37247515825152],
["1m5w",1.96,2.94143161078614],
["1xu5",1.96,2.42971287529810],
["1xvg",1.96,2.30508581137296],
["1fz7",1.96,2.38391854864735],
["1fz1",1.96,2.13940925931304],
["3pcg",1.96,2.61288708223589],
["2bbe",1.97,1.76241141257368],
["1chh",1.97,3.28715978469096],
["2imn",1.97,2.47652503977065],
["2lzt",1.97,1.62771821282424],
["1lzt",1.97,3.49215030032702],
["2snm",1.97,3.36365026569138],
["1v8v",1.97,2.02317415087638],
["1fm4",1.97,1.55113448347130],
["1ky0",1.97,2.22319747629345],
["1d3j",1.97,2.19676352615956],
["1d4y",1.97,2.37262284074023],
["1e48",1.97,2.63190922899527],
["1unf",1.97,2.53054103126433],
["1pry",1.97,1.53168311470118],
["1r7x",1.97,2.08040314403270],
["1k2v",1.97,2.63121432276359],
["1t0h",1.97,1.98965455787993],
["1jbs",1.97,2.40091741925547],
["9abp",1.97,2.64729985755343],
["2d7v",1.97,2.53920865149202],
["1d0l",1.97,1.29216008757072],
["1nfz",1.97,2.22157325821272],
["2g73",1.97,2.52483453282943],
["1le6",1.97,1.97607969460027],
["1q6h",1.97,1.46636580225937],
["1z4n",1.97,2.02319720318541],
["2d03",1.97,2.23264462203169],
["1va0",1.97,1.82126549619941],
["2b56",1.97,2.13897190557068],
["1vzx",1.97,1.69183102129383],
["1vzu",1.97,2.0798739613725],
["1o7o",1.97,2.10970381211034],
["1wx1",1.97,2.07930773454808],
["1xgj",1.97,2.22534653471624],
["1fxh",1.97,2.05489941977616],
["1ms7",1.97,2.18878039866784],
["1kti",1.97,2.78953658941640],
["1jqb",1.97,2.50102338269450],
["1hd3",1.98,2.61723796529352],
["1l3p",1.98,1.78895957560960],
["1kt9",1.98,2.19309287116805],
["1f3z",1.98,3.70361608870395],
["1l0j",1.98,2.48457684355593],
["1v0a",1.98,1.80676053453174],
["1z4i",1.98,2.03627379906965],
["1uy8",1.98,2.16776939923467],
["4tmk",1.98,2.39909504252097],
["5tmp",1.98,2.81170163159635],
["1yf4",1.98,2.13964530989012],
["1h7l",1.98,2.76644465875536],
["1qcc",1.98,1.78310862826267],
["1ml9",1.98,3.07086317446042],
["1if7",1.98,2.21339164263883],
["1zcv",1.98,1.72836600196831],
["1i9g",1.98,2.21522326186201],
["1shv",1.98,3.04776673908155],
["2b4w",1.98,2.39397955078810],
["1c1v",1.98,2.69520162093947],
["1mdn",1.98,2.29819156543063],
["1v7l",1.98,2.99278563658763],
["1xdw",1.98,1.74574729172090],
["2tec",1.98,2.31357644638152],
["2bim",1.98,1.69075970898384],
["1njs",1.98,1.96586015976288],
["2aha",1.98,2.90823083596883],
["7taa",1.98,2.22491477286564],
["1zvr",1.98,2.94758226500663],
["1xnf",1.98,1.96961656656427],
["1hds",1.98,5.37328827266315],
["1y7z",1.98,2.48073442139035],
["1y4p",1.98,2.13246730495044],
["1zud",1.98,2.57784167639262],
["2dh4",1.98,2.33839928101445],
["1c97",1.98,2.74821370050390],
["1p6h",1.98,2.47049470827256],
["1xnj",1.98,2.75984282680007],
["1n9g",1.98,1.77614928642692],
["3pcc",1.98,2.54100616624529],
["1vdv",1.98,2.12148743078277],
["2evh",1.99,1.73178580295392],
["1uo2",1.99,2.07464296111419],
["1m47",1.99,2.14553549967118],
["1tp3",1.99,2.55367338132875],
["1dm1",1.99,2.05965865744225],
["1tfu",1.99,2.65608230749531],
["2aoa",1.99,3.33741876625694],
["2evt",1.99,2.18273532380060],
["1rjk",1.99,1.8146864025212],
["1ztf",1.99,3.01849518865378],
["1zcy",1.99,1.95173313682325],
["1uwz",1.99,1.6413900168548],
["1ux0",1.99,1.78296178245564],
["1tqm",1.99,2.07261999462191],
["2bts",1.99,2.0748549006571],
["1mu6",1.99,2.58180376177697],
["1j99",1.99,2.44515498211941],
["1w3w",1.99,2.07014375738151],
["1g1b",1.99,2.55491203647614],
["1vqz",1.99,1.46602076705407],
["1xo5",1.99,2.13003360457328],
["1s7q",1.99,2.05419698225082],
["1s7s",1.99,2.31235049096615],
["2g45",1.99,2.00613382614787],
["1q6y",1.99,2.34016972413606],
["1p5u",1.99,1.99407389746105],
["1jxj",1.99,1.75849281471092],
["1pzi",1.99,2.15310434179525],
["1xy0",1.99,2.48524263380135],
["2fb5",1.99,1.9971295491606],
["2gpn",1.99,2.03521032361800],
["1e6z",1.99,1.98443502090246],
["2bex",1.99,1.98445049501223],
["1tzj",1.99,2.38317344759538],
["1vax",1.99,2.1585462798675],
["1zbg",2,2.24642331429946],
["1y8y",2,2.66467330764542],
["1bph",2,2.04328314907837],
["1aph",2,2.43820533656733],
["1kfm",2,2.25831669724292],
["2mlt",2,2.25132696051881],
["1rdv",2,3.19779889080979],
["1r0j",2,2.25182997522330],
["1dur",2,1.78036826855767],
["1bpt",2,2.76054185852917],
["1em7",2,2.86094042653676],
["1qkw",2,1.81614603140855],
["1gzr",2,2.98777194971049],
["1egp",2,1.94630059519825],
["1fsc",2,2.37023227068535],
["1h02",2,3.47582594049595],
["4mt2",2,3.02731367177326],
["5ebx",2,2.80814118380104],
["1r69",2,1.79695976557106],
["1ypa",2,1.84038962499158],
["1ypb",2,1.38868884659847],
["1bnz",2,2.63940741471967],
["1omy",2,2.21981852441944],
["1bkv",2,1.70696893610368],
["2ci2",2,3.23415930243892],
["2ame",2,1.65708620059418],
["1t6o",2,2.18852644366476],
["3il8",2,2.45759663517506],
["1mjc",2,2.67322654497256],
["1y0n",2,3.07581037452017],
["1dcd",2,2.51560545641529],
["1aik",2,2.66319282572437],
["1b0x",2,1.92531254431309],
["1tgg",2,2.03436478518795],
["1hoe",2,2.45689157912495],
["1l0h",2,2.15384912556769],
["1esr",2,2.94298912173796],
["1nh9",2,2.12335579058820],
["1pzw",2,2.96645460179381],
["1pht",2,2.44988895955408],
["2f8k",2,1.50493240219486],
["1g1i",2,2.38547525876258],
["1a1j",2,1.64629340380459],
["1j2x",2,2.20160347467205],
["1hip",2,3.86402048502424],
["1poh",2,3.12969438713527],
["1vku",2,1.92679312980767],
["1r5q",2,2.20773094106244],
["1ayi",2,1.90120821740501],
["1hb6",2,1.79119003174374],
["1j55",2,2.28201245045589],
["1ae3",2,2.47150421255695],
["1ae2",2,2.57602151223172],
["2hpr",2,2.56386611702195],
["1y50",2,2.11547241659388],
["1nfj",2,2.56498039041457],
["1tig",2,2.22996616578055],
["1yqb",2,1.50317875341467],
["1mho",2,1.96542049078418],
["1yo5",2,1.64982828506655],
["1x6j",2,1.94416957119136],
["2f15",2,2.55215091429140],
["1hbk",2,2.41068540977676],
["1xe1",2,1.53186528853345],
["2gnk",2,2.63449004562607],
["1az5",2,2.17038240577224],
["1q4v",2,2.44191297853593],
["1j73",2,2.33353042674054],
["1zij",2,3.97753449198036],
["1zim",2,3.55084326470568],
["1izb",2,2.96016663431133],
["1ris",2,2.13510864960970],
["2c3g",2,3.29325821755541],
["6ins",2,3.70709804661596],
["1oow",2,1.7403095862771],
["1mgw",2,1.76343987407487],
["3tlh",2,2.61039383742669],
["2es9",2,2.45871008120287],
["2az8",2,2.092928978468],
["1xer",2,1.67919345828149],
["1fhg",2,1.66322432911217],
["1p1l",2,1.64461939650242],
["1shd",2,2.60916368709005],
["1j2v",2,3.53379944728864],
["1w0t",2,2.21806448549928],
["3kvt",2,1.74216379549008],
["1m5i",2,2.46706045013659],
["1fys",2,1.75212066137546],
["1rgl",2,1.94791845044044],
["1lxi",2,2.78388397390728],
["1o4f",2,2.12982501416931],
["1aan",2,1.95782019893481],
["1aiu",2,2.22611835329675],
["1mb0",2,2.37000975138348],
["2cvk",2,2.22953093488419],
["1gxq",2,2.73846239611145],
["1fut",2,2.43608858304901],
["1uwm",2,2.29914889374942],
["1cri",2,2.7571336816787],
["1crg",2,2.99243655079791],
["1btn",2,2.46384852343260],
["1o4e",2,2.55805397343941],
["1o46",2,2.63743017255712],
["1a1x",2,2.23878125852273],
["1shb",2,2.71518591990779],
["1irw",2,3.42324830215795],
["1c9h",2,1.95314489342877],
["2cym",2,3.3682260655817],
["1fkg",2,2.12672567519289],
["1gmb",2,1.65163311793472],
["1he7",2,2.91016357559826],
["1xw4",2,1.89705510247771],
["1du0",2,2.18311165690176],
["1ei8",2,2.27139143741014],
["1acx",2,4.62630518575949],
["1b9a",2,2.37321465761653],
["2tir",2,1.98230599244924],
["1chi",2,3.28877690643702],
["1ox3",2,1.20435220401248],
["1jpc",2,2.05225375389229],
["1cew",2,3.41140983100551],
["1i4m",2,2.20936727248857],
["1aa2",2,2.85226671389556],
["1s3p",2,2.22265410216053],
["2apw",2,2.03824825290892],
["1npl",2,2.679857329604],
["1by2",2,1.74065642941488],
["1xd6",2,2.58860927645674],
["1w6x",2,2.28515546938980],
["2c2c",2,2.97427233654361],
["1tgj",2,2.01905838256365],
["1jgg",2,3.37053356525869],
["1lgp",2,2.33851385606444],
["1l4x",2,2.55581476453286],
["1yhf",2,1.95663132449989],
["2imm",2,2.49889157875398],
["5lve",2,2.32967999543517],
["3lve",2,2.45556141342325],
["1kjt",2,2.27473808985702],
["2bti",2,2.34844954820856],
["1fnk",2,1.97546750218351],
["1z3m",2,2.33944885809621],
["1i0c",2,2.56040867360705],
["1xj2",2,2.14250225574079],
["1npu",2,2.53003159728283],
["1cs3",2,2.39539074965435],
["1z3p",2,1.96767797404702],
["1wq6",2,2.46134082743907],
["1uhd",2,2.45837838033177],
["1fiv",2,2.76290435859007],
["1rbc",2,2.49521654514477],
["1nxv",2,2.51672997671954],
["1mh7",2,2.60863764456246],
["1ae7",2,2.3739952871006],
["1uii",2,1.52779521298273],
["1e97",2,3.12912645168895],
["1rri",2,1.86669606188488],
["1h53",2,2.88453499167184],
["2bz8",2,3.13333895037389],
["1ssc",2,2.69964664885353],
["1ppa",2,2.77685313780677],
["1fkv",2,2.48528217334260],
["1hmk",2,2.68378369089897],
["1py0",2,2.23294251390363],
["4srn",2,3.38880112703182],
["1nzn",2,1.99592412758108],
["1h52",2,3.00112142548523],
["1ssa",2,3.40954322526986],
["1ssb",2,3.44063861012655],
["3srn",2,3.83197037437312],
["7paz",2,3.08045145328299],
["1huf",2,3.00676920401721],
["1hby",2,2.99621644312778],
["1b1j",2,3.71173224834092],
["1b1e",2,3.28373792658055],
["2ang",2,3.22635890351063],
["1zib",2,2.54171855356978],
["1bk9",2,1.98865090613551],
["3rsk",2,2.3880679088571],
["1eow",2,1.78449799986528],
["1rsm",2,1.97946844427393],
["1aqp",2,2.30215469717005],
["1rnm",2,2.57660085484963],
["1rnq",2,2.59798254303742],
["5rsa",2,2.69473800043930],
["6rsa",2,2.78678514326061],
["1f7s",2,2.10627016507410],
["1rny",2,2.76996127202632],
["1c0c",2,4.39101035639999],
["1ob9",2,2.29768867063209],
["1acf",2,3.06091225050102],
["1h04",2,2.29130565441490],
["2ftb",2,1.78856129207743],
["1kh8",2,2.31432080087761],
["1tvq",2,1.83487991758204],
["1yig",2,2.03465560659562],
["1sem",2,2.78472025279426],
["1gmm",2,2.47086761990886],
["1qg7",2,3.11285073392609],
["1j5u",2,1.86158134313740],
["5chy",2,2.65295982165459],
["1di4",2,2.38594574453843],
["1inr",2,2.44491724897636],
["1lsz",2,2.21502792745614],
["2cds",2,1.56511277978320],
["1hsw",2,2.53895279557315],
["1dkj",2,2.30426871339067],
["1lpi",2,2.58043628001167],
["2lym",2,2.56789666514052],
["1ps5",2,2.16997112960390],
["3lym",2,2.56122483478772],
["6lyz",2,3.45418498002514],
["3lyz",2,3.69492226497487],
["2lyz",2,3.4865434326745],
["4lyz",2,3.71031116342985],
["5lyz",2,3.71754907620286],
["1lyz",2,4.38997963437583],
["1bb7",2,2.02460181781941],
["1bb6",2,2.34206826023308],
["1lmc",2,2.38163593808860],
["1lmp",2,2.51955390771735],
["1msc",2,4.08314192405885],
["1bff",2,3.09145498965106],
["1nfo",2,3.03371873270774],
["1b5x",2,2.23901884007304],
["1e6k",2,2.41560321436948],
["1ge2",2,2.2379933285679],
["1b7p",2,2.61911143787095],
["1ckh",2,1.74251700186599],
["1ubz",2,2.46884841671287],
["1b7q",2,3.13606087964956],
["1jhc",2,2.30985071346069],
["1t3x",2,1.53884623080655],
["1u4l",2,1.58340576995037],
["1u4m",2,1.62688987621322],
["1abo",2,1.92095417451381],
["1q8c",2,3.24893653921548],
["1uz0",2,1.90784284168844],
["1o8p",2,2.0160350885959],
["1tqo",2,2.07287815460846],
["1jfv",2,2.28093443607793],
["2ifb",2,2.96324361537241],
["1tou",2,1.78472626237191],
["1tow",2,1.62423843954487],
["2amu",2,1.39471649789516],
["1gr3",2,2.14352241573362],
["1lpj",2,3.16262750094799],
["2dhq",2,2.00010937445495],
["2nuc",2,2.79789887665703],
["1a2u",2,2.93066567829759],
["1iul",2,2.601235411884],
["1is5",2,2.05971726633121],
["1wlc",2,1.92162051152519],
["1ve0",2,1.86940507250630],
["1poc",2,3.08335182832138],
["1h1h",2,2.78081764777667],
["1eya",2,3.21376908818079],
["1rlj",2,2.52434149887848],
["2c02",2,2.27613593391876],
["1f2y",2,2.33170409463614],
["1f2m",2,2.48433901413989],
["1b68",2,2.18859571535495],
["1taf",2,1.90653120550605],
["1tn3",2,3.35885550253678],
["1kdc",2,2.48429327844418],
["1twu",2,2.47329251400728],
["1stb",2,2.93005282181645],
["1enk",2,2.95995742719586],
["3cbs",2,1.67289135733633],
["2cxc",2,2.73836083380368],
["1fso",2,2.13409520168288],
["1sfu",2,2.54262926320075],
["1fil",2,2.73684630233783],
["1y2f",2,2.69851589328507],
["1bvq",2,3.30328701108557],
["1pne",2,2.54839315574446],
["1q2y",2,2.53702616438029],
["2d28",2,2.86360744577662],
["1ifg",2,2.67938733468067],
["1p4p",2,2.5325466980441],
["1ekr",2,2.80569798056194],
["1r2i",2,2.73345383164207],
["1osd",2,2.05033740498552],
["1ety",2,2.48413215839216],
["1c3k",2,2.07993836135618],
["7ins",2,3.63748929686024],
["1nig",2,2.53793533429525],
["1yoy",2,1.74157172727225],
["1c3m",2,2.53659117927706],
["1o80",2,2.98303320734387],
["1etv",2,2.26982124366758],
["1l5z",2,1.95303746287852],
["1a5w",2,2.69074549891708],
["1lin",2,2.23029708214906],
["2cj6",2,2.36594067840991],
["1aly",2,3.61220845542043],
["3mba",2,2.46492210150836],
["2fam",2,2.54071538621192],
["4mba",2,2.57792185594873],
["1akv",2,2.23818641555784],
["1i1o",2,2.08984912651538],
["1fx1",2,4.05092572106026],
["1cdm",2,2.41192819217717],
["1rfj",2,2.39789841285425],
["2lhb",2,2.71121895184065],
["1o22",2,1.88507379812734],
["31bi",2,3.22789960762507],
["2faz",2,2.29838642028424],
["1ndc",2,1.63055496473474],
["1wrj",2,2.42144073097798],
["1qg5",2,3.15045453073721],
["1amx",2,2.54966446666312],
["1ibh",2,2.01628895595664],
["1ibd",2,2.50609573517264],
["1rnh",2,3.01649940094476],
["1ws1",2,2.56179209698884],
["1fia",2,2.59292714520416],
["1i1b",2,2.15697170017192],
["21bi",2,3.27595949332912],
["4i1b",2,3.34105398024126],
["1sra",2,1.90751544725975],
["1duo",2,3.0357838011136],
["1vh2",2,1.59141124482392],
["1dvo",2,2.10228014792130],
["1byr",2,2.82833384412209],
["1bys",2,2.84752723022764],
["1ly1",2,1.62749291095104],
["1lhs",2,2.97630407120648],
["1lht",2,2.37476374603507],
["1azi",2,3.24380444580346],
["1yma",2,3.65840818269855],
["1ymc",2,3.55478118608465],
["1mbn",2,4.06713943742041],
["2lh2",2,2.27219615686082],
["1mbi",2,2.27748125285664],
["2lh3",2,2.38199211544584],
["2lh5",2,2.2468476612063],
["1lh3",2,2.47679706437712],
["1lh1",2,2.26989454144841],
["2lh1",2,2.19626546628817],
["2lh6",2,2.36405659080483],
["1lh2",2,2.36620658813398],
["1lh5",2,2.33366998732225],
["5mbn",2,2.4677294043768],
["2lh7",2,2.168887180577],
["1lh6",2,2.58353020972557],
["4mbn",2,2.54384343749418],
["1lh7",2,2.44324973879446],
["1vxa",2,3.41670227314584],
["1spe",2,3.29515371391813],
["1vxb",2,4.27144403049322],
["1iwq",2,2.37218070930451],
["1iob",2,3.49051796278099],
["2i1b",2,2.98554848870007],
["1z7c",2,3.3713316554009],
["1eso",2,2.58460585563416],
["1mlf",2,2.51885526930492],
["1mlg",2,2.9777329307683],
["1mlh",2,2.50559465257043],
["2mgb",2,2.78052774510689],
["1ch3",2,2.42138982977488],
["1cp0",2,2.72866526587751],
["1mln",2,2.81034715880527],
["1mlr",2,2.79529354583996],
["1mlq",2,2.70813836815338],
["1mlj",2,2.80929630694092],
["2mgk",2,2.89740139260518],
["1mod",2,3.02752646600539],
["2mgj",2,3.10354956588291],
["2mgi",2,2.95375454604893],
["1moc",2,3.08508817804179],
["2mgh",2,2.86472406820565],
["2mgl",2,3.03981166159341],
["1etw",2,2.13460709912367],
["1gob",2,3.11498040559527],
["2tn4",2,2.41820203020458],
["1t9o",2,1.91195213203455],
["1txj",2,1.83939738166484],
["1goc",2,3.5051121482403],
["1i05",2,2.09107219998541],
["1j85",2,2.84607460869605],
["1yh2",2,2.05166896704469],
["2e2c",2,2.74344165073463],
["1esl",2,2.1399825553183],
["1yp7",2,2.57154528548096],
["1zne",2,2.97136760311657],
["1jj9",2,2.54972572583670],
["1dy3",2,2.09648613760092],
["1t4a",2,2.07934892427068],
["1dg8",2,2.59455462704422],
["1dg5",2,2.36817445802607],
["1rfe",2,1.93900592845763],
["1eh7",2,1.81637727330533],
["1a85",2,2.59005055145619],
["1a86",2,2.55612029869117],
["1wgb",2,2.35537991995724],
["1rg7",2,3.013692385423],
["1bv1",2,2.17667287443580],
["1cm1",2,2.12175441669176],
["1rx1",2,2.81398672270754],
["1rx6",2,2.85999972614233],
["1u9b",2,2.78724600769043],
["1i04",2,2.58771599730632],
["1hyb",2,2.01477296482585],
["2g2d",2,1.34221942832611],
["2g6b",2,1.89101032602221],
["4tnc",2,2.95855328260214],
["1p2t",2,1.84827035022097],
["1p2u",2,2.08602829228451],
["1u9a",2,2.56317382717278],
["1ioz",2,2.43014488258207],
["5tnc",2,2.95937496579524],
["1s21",2,1.95392596128521],
["190l",2,2.51257953656116],
["1c60",2,1.72657464917832],
["1c6d",2,1.91172847058037],
["1c6f",2,1.91172847058037],
["1c61",2,1.70326998282239],
["1c64",2,2.11507835285968],
["1c6c",2,2.25469894186028],
["227l",2,2.19997820581859],
["142l",2,2.24993187713956],
["1c63",2,2.35742723505272],
["1c65",2,2.33955491433145],
["2l78",2,2.27912471461008],
["1l85",2,2.57215042823896],
["141l",2,1.86889512878731],
["1li2",2,2.19286662228947],
["1lyi",2,1.96324006935470],
["143l",2,2.27102054015594],
["1c6t",2,2.32477743582259],
["147l",2,2.27088777957326],
["1li6",2,2.45353285055201],
["1l81",2,2.24238794799238],
["1l95",2,2.39387209797770],
["1tla",2,2.41002801870834],
["1d3n",2,2.55172361269178],
["145l",2,2.45350263669795],
["1l96",2,2.50439047340122],
["1qsr",2,2.47934410889219],
["1sn8",2,1.72196893433020],
["2af9",2,1.8973202374337],
["253l",2,2.17862545170690],
["1rl6",2,2.30944314448868],
["1qtz",2,2.46296340993727],
["152l",2,2.6095639214142],
["1lyd",2,2.83017946093895],
["1wrz",2,2.66958501472906],
["1huw",2,2.213287925137],
["1l4y",2,2.41408295224967],
["1vbs",2,2.14687971792857],
["1eh6",2,1.88176444608750],
["1kuv",2,2.82948687215547],
["1zvq",2,1.96958284993978],
["721p",2,2.81987729411855],
["1ge5",2,1.86224448442692],
["1cwm",2,2.06192054238102],
["1b8y",2,2.53423687461526],
["1wv9",2,3.35958627328484],
["1m8g",2,1.56756993757701],
["1yzk",2,1.38149744943203],
["1ftg",2,2.6705419219462],
["1flv",2,3.03877353191152],
["1dy2",2,2.27774111300712],
["1yzg",2,2.64622532755852],
["1ym9",2,1.32475856990509],
["1txy",2,2.78944573714720],
["1czu",2,1.25423686120074],
["3rab",2,1.96909589706516],
["4q21",2,3.01646644546821],
["1xtq",2,2.43418666423847],
["1ys0",2,2.26687087530719],
["2bl1",2,2.14471900606612],
["1awp",2,2.53048643714975],
["1l8j",2,2.55976538874484],
["2ew1",2,2.87830093560741],
["1mvl",2,2.20685863655458],
["1rcd",2,2.07101476466791],
["1rci",2,2.49413732653992],
["1zj6",2,2.10695766114169],
["1fcg",2,2.33455525530548],
["1spv",2,2.40613701042555],
["1sph",2,2.67927260254043],
["1lki",2,2.36388583613595],
["1aaz",2,2.08027546904840],
["1qoi",2,2.3132516475541],
["1mq9",2,1.96618486880613],
["1rkb",2,2.22649301380570],
["2cy2",2,2.68384340570245],
["2prd",2,2.31481068189558],
["1j00",2,2.52424870051643],
["1yfw",2,1.95162423380916],
["1yfx",2,2.47855052702980],
["1lhn",2,2.5738364025169],
["1jyj",2,2.46072468266200],
["1jeo",2,1.73521634703883],
["1gcs",2,2.85685427672247],
["1g2f",2,2.76249839571953],
["1t8a",2,2.55820852059051],
["1rbp",2,2.60429015610547],
["1c6o",2,1.78552121273991],
["1v2g",2,2.28643381973482],
["1lho",2,2.03599417024591],
["2atz",2,2.48193590797183],
["1fbs",2,2.43420467766451],
["1fn0",2,2.88265411591052],
["1fbu",2,2.01981994385755],
["1fbq",2,2.41392486679783],
["1xyn",2,2.54870077735250],
["1t9f",2,2.95593013406791],
["1dpf",2,1.81881743941663],
["1fjl",2,2.47618549263087],
["1q0a",2,1.81391231390313],
["1cdy",2,3.94124856764089],
["1t4m",2,1.54824072583131],
["1s7f",2,2.39234064986251],
["1m7b",2,2.17169015907765],
["1cws",2,2.13465971436022],
["1uvc",2,2.91573568478985],
["2cvj",2,2.22727797698447],
["2cu6",2,1.84729400098449],
["1euo",2,2.67062536881377],
["1v76",2,1.86699154243480],
["1zon",2,2.81760701450191],
["1bk1",2,1.71212143867353],
["1mk1",2,1.77241881905382],
["1u1k",2,2.02776083758827],
["1u1m",2,1.91312416903908],
["1u1o",2,1.97037397539087],
["1u1l",2,2.15137241701874],
["1umh",2,2.15222378366786],
["1s6c",2,2.12435430551619],
["1ipc",2,2.33255544622129],
["1ln0",2,2.34218091481218],
["1pi1",2,1.70473712775534],
["2cxd",2,1.95717681091876],
["1a64",2,3.01360158418606],
["1drf",2,3.62947356920159],
["1gky",2,2.05142012239405],
["1rgp",2,3.09534770104053],
["1jlm",2,2.77099587293893],
["1hjl",2,2.35483030018296],
["1a2j",2,1.95046779213225],
["1vqt",2,1.9043175958522],
["2fiu",2,1.77541416285096],
["1rsn",2,1.69714851284960],
["1cdc",2,2.5773348122818],
["1jyq",2,1.90256099043121],
["1jjv",2,2.42014691666283],
["1wq9",2,2.54923476559187],
["1utu",2,2.96593235084114],
["4ukd",2,2.12835758244996],
["1ipb",2,2.33911698429426],
["1b6p",2,1.80833821813529],
["2ai7",2,2.22849064741239],
["1v74",2,1.44906300955091],
["2amh",2,1.47713863439304],
["1v9h",2,2.31715139023528],
["1c8s",2,3.57096669456759],
["1dmp",2,3.00057614111231],
["1z4p",2,2.18605459578888],
["1pbv",2,1.73294543579504],
["1byo",2,2.85265628215392],
["1rl8",2,2.76193041593033],
["1ody",2,3.24268784502626],
["1k6v",2,1.55546991050087],
["1hvj",2,1.85895708401152],
["1wbm",2,1.54159183245927],
["1npw",2,1.95319420980389],
["1npa",2,1.97463703161334],
["1hpx",2,1.86806142035476],
["1wbk",2,1.62500636310553],
["1hsg",2,2.19482779466026],
["7upj",2,2.22841555981218],
["1msn",2,1.56913373678652],
["1mrw",2,1.62081207915216],
["1npv",2,1.91678266850730],
["1msm",2,1.63937763113163],
["1ajv",2,2.12033381684040],
["1ec2",2,1.650368875558],
["1mrx",2,1.66634134423933],
["1bv7",2,2.56036350773666],
["1htg",2,2.07945378643287],
["1ajx",2,2.51669060592477],
["1bv9",2,2.7432905629756],
["1odx",2,2.88707473226008],
["2hpe",2,2.67792734962635],
["1axa",2,2.86050541108341],
["1a30",2,1.88460981108717],
["1hiv",2,2.42734042095245],
["1gbj",2,1.73953001181607],
["1fzv",2,2.80167912294574],
["1p01",2,2.05307892100770],
["5hvp",2,2.45440222996327],
["2fm9",2,2.01181442832822],
["1r23",2,1.89778719615377],
["2b0c",2,2.00106194050305],
["1g79",2,2.76297551541150],
["1p02",2,2.31582170188693],
["1z77",2,1.44233477059418],
["1l5b",2,3.63076852022244],
["1bft",2,3.14739646934426],
["1qde",2,2.42203691065792],
["4aig",2,2.12890777230435],
["1iag",2,2.81177630949607],
["1kj7",2,2.02522651315578],
["2ga1",2,1.03819150164992],
["1mzw",2,1.85951119000074],
["4cd2",2,2.92522864758262],
["1f7a",2,2.21448836219658],
["1kjg",2,2.01304272578206],
["1mt9",2,2.27257079909487],
["1tsq",2,2.33586574219901],
["1kjh",2,1.93453115101810],
["1i55",2,2.22459237746149],
["1kjf",2,2.22197686368925],
["1nsj",2,2.84096396700637],
["1cfb",2,1.28427445004295],
["1e26",2,2.96587581099544],
["1gnk",2,2.60187849048695],
["1jv6",2,2.4733593306948],
["1rgc",2,2.38524927439332],
["2aad",2,2.48043362535547],
["1b2m",2,2.18047818678676],
["1w77",2,3.39723302866833],
["1h2f",2,1.8705212352152],
["1mrs",2,1.95222941663645],
["1wd5",2,2.05798189431773],
["1oa7",2,2.08685027634378],
["1oa9",2,2.55321160813133],
["2a48",2,2.51965442486402],
["1a09",2,1.90167894298071],
["1e2e",2,2.37038111051161],
["1uy9",2,2.14588365411711],
["1uyg",2,2.28350051239714],
["1uyc",2,2.44614746128372],
["1uye",2,2.35358697591944],
["1uyf",2,2.22774255891903],
["1yul",2,2.18534548283413],
["2fua",2,2.26831903877727],
["1r7l",2,2.63185845117582],
["1u5p",2,1.40832505613517],
["1row",2,2.29526987700946],
["1ppd",2,2.49497437826695],
["1ulx",2,1.79735280642974],
["1a7x",2,2.03970470126032],
["1eym",2,2.58092535828608],
["1rei",2,3.63467522034876],
["1qz4",2,1.90160770311576],
["1khp",2,2.27559182359306],
["1io2",2,2.21468144261932],
["1wcz",2,2.39446282412623],
["4cla",2,1.67308867840415],
["1vid",2,2.47493095659766],
["1am1",2,2.72665632965449],
["1b8c",2,2.58933848471713],
["1kg8",2,2.75084385384867],
["1mgy",2,2.13743295643365],
["1cpm",2,2.69282846766637],
["1gov",2,2.15561257855957],
["1goy",2,2.20211027924617],
["2apt",2,2.23533577424892],
["1h1d",2,2.29406129431856],
["1i6p",2,1.83951090571860],
["1dvp",2,2.82175672725419],
["1bhd",2,2.60777663999705],
["1aim",2,1.71159503725998],
["1ewl",2,2.07887120162009],
["1f2c",2,1.65097859613440],
["1ewm",2,1.85969043600804],
["2bdl",2,1.64401609763978],
["1sur",2,2.23853796659142],
["1xio",2,1.39425787424786],
["1meg",2,2.61403633512633],
["1vkw",2,1.82818735125511],
["1kea",2,2.18146575647093],
["2arv",2,2.8937290138175],
["1vc1",2,2.89371820154576],
["1dkz",2,1.95868924127934],
["1a7q",2,2.35774733157142],
["1zrm",2,2.19607693481428],
["1a7o",2,2.76876573195435],
["1ix3",2,2.02264618779700],
["1mw7",2,2.73646481181683],
["2cmk",2,2.75387538251706],
["1xw8",2,2.69431617333814],
["1e2x",2,1.87757887354216],
["2fdr",2,1.98025902475563],
["1bol",2,2.47262042915325],
["2rsp",2,2.36908568057363],
["1emg",2,2.29609688152178],
["1pts",2,2.83149582518391],
["1o3a",2,2.00760318356169],
["1tyn",2,2.00717319261268],
["1k1n",2,1.78517778040642],
["1jir",2,2.0911700933843],
["1k1o",2,1.93186854107581],
["1v2k",2,2.11300142653310],
["1eb2",2,2.18894172717645],
["1gbt",2,2.51838074243076],
["1j15",2,1.82335087976057],
["1j17",2,2.15402073463495],
["1emj",2,1.74928746976648],
["1og1",2,2.26382676438639],
["1dkx",2,2.44947212506907],
["1kpa",2,2.05336468635575],
["1kpb",2,2.08359050882829],
["1av5",2,3.03662996560902],
["2g16",2,1.34973831696243],
["1z1p",2,2.43351378570295],
["1ct5",2,2.02789662053389],
["1uj5",2,1.83649928221533],
["1btz",2,1.89171992845724],
["1a8v",2,2.78212609632972],
["1yoz",2,2.80989608763799],
["1srf",2,2.96627099829542],
["1bm7",2,2.34376297408478],
["1bmz",2,2.46666365339349],
["1qxt",2,1.44466270447019],
["1q7s",2,2.18509631459121],
["1dvq",2,1.37833048868763],
["1dvs",2,1.55041288591936],
["1dvx",2,1.68909942363061],
["1qy3",2,1.49079351134863],
["1dst",2,3.03383859004243],
["1iii",2,1.63644041207609],
["1p9q",2,2.40017981230976],
["1aol",2,2.52735028994035],
["2fiv",2,2.86809208860343],
["1j1t",2,1.98430989608357],
["1xcj",2,2.92171217869732],
["1xcl",2,3.02494517860283],
["1iau",2,3.01970108065868],
["1x42",2,2.30126820174989],
["1sh6",2,3.31589999202476],
["1m49",2,2.14414362781050],
["1pt0",2,2.26200900778486],
["1h9p",2,2.40993886994568],
["1ij8",2,2.48118122627805],
["1z5p",2,1.70335302130841],
["1xvh",2,1.83791591961320],
["1tha",2,2.93136257045868],
["2rox",2,3.07996507389531],
["1i4p",2,2.87153961858278],
["1swt",2,2.5210914941992],
["2cha",2,3.38815245548271],
["1sko",2,3.19288134567373],
["1wr2",2,1.97241345996906],
["1r6m",2,2.54616975750019],
["1ksk",2,2.27180729080967],
["1pob",2,3.07653037536904],
["1ghb",2,3.21157290015219],
["1op0",2,1.99238561072286],
["1qgs",2,2.23048806131548],
["1tl2",2,1.88803844943799],
["1qb8",2,1.71114985411760],
["1uns",2,2.57011564690106],
["1h7q",2,2.47992708918135],
["1g3q",2,1.55543857189355],
["2fda",2,2.09116586676216],
["2cna",2,4.39759824377401],
["1scr",2,1.88076095344830],
["1con",2,2.40262961402731],
["1dq5",2,2.50389018281849],
["1eem",2,3.47940702360087],
["1ohq",2,2.31820517977877],
["1za0",2,1.60713801906567],
["1zh2",2,2.40568299526701],
["1v13",2,3.01457677471187],
["1ste",2,2.39711222270439],
["1bm9",2,2.87105457334797],
["2ad1",2,2.86745099367774],
["1d9c",2,2.35219055294663],
["1pqf",2,2.06316261967713],
["1lte",2,2.15246544192719],
["2bsx",2,3.40241006546698],
["1iz4",2,2.84020014298356],
["1ji0",2,2.73535736387644],
["1eat",2,2.45034128679696],
["2fo9",2,2.03338822135362],
["1eau",2,2.56385932682010],
["2fod",2,2.23358827902409],
["2foc",2,2.15472537642844],
["2btn",2,2.33139480404862],
["1x7r",2,2.08825050239955],
["1gua",2,2.15396153945044],
["1jwi",2,2.40300495121786],
["1due",2,2.60500421961770],
["1dua",2,2.72160929734952],
["1tq9",2,2.89102485231981],
["1sd4",2,2.45577813738841],
["1gsl",2,2.18114874616666],
["1led",2,2.22230954399981],
["1lec",2,2.2479010373505],
["1jq8",2,2.66917612411495],
["1byf",2,2.14820968871066],
["1jb2",2,2.45610711020625],
["1p5x",2,2.22382254185579],
["1p6d",2,2.46089707821830],
["1sqa",2,2.60214038810029],
["1zv5",2,1.91997907598906],
["1urq",2,1.47489008389244],
["1dck",2,2.18691737226313],
["1ma3",2,2.18292248977863],
["1ahc",2,2.25409158259264],
["1mrh",2,3.21249409218984],
["1afu",2,2.40056442244692],
["1eos",2,2.3161432706058],
["1i37",2,3.15993181545469],
["1u1b",2,2.43293238295822],
["1b6v",2,3.09526681028859],
["1fx9",2,3.15698255597193],
["1do6",2,2.05303060423074],
["1vja",2,2.41086783441201],
["1i38",2,3.04670819199748],
["2arp",2,3.03979072967523],
["1jul",2,2.26775657283221],
["1a53",2,2.41630628531612],
["1igs",2,2.56984348485505],
["1ztd",2,1.77809302882113],
["1tw4",2,1.85613537323911],
["1h8x",2,2.41565392250024],
["1f9q",2,3.03424338492375],
["5csm",2,2.10312739781903],
["1if2",2,1.25854830528027],
["1ogx",2,2.74741519090239],
["1qds",2,1.55947095691647],
["1vc8",2,1.94598714717410],
["2f5n",2,2.30111016641106],
["1bz8",2,3.28497143108544],
["1ppe",2,2.40253418182310],
["2c4x",2,1.82473796791583],
["1qyu",2,1.93232709432797],
["1kyd",2,2.0174590901905],
["1coz",2,1.94159050087981],
["1xb8",2,2.24649573372821],
["2dnj",2,1.94254559845284],
["1wcx",2,2.42960721957056],
["1dtj",2,3.02343005453952],
["1j3m",2,2.86697633158864],
["2try",2,3.28940415754407],
["2f5p",2,2.10783553617476],
["1x25",2,1.55096988597765],
["1ky6",2,2.23815243314199],
["1vin",2,2.10741291915563],
["1f9r",2,2.93898837869656],
["1qi7",2,1.99046292084256],
["1rte",2,2.20425736317937],
["1hb8",2,1.67405806181514],
["1jvl",2,1.53943953481220],
["1hec",2,2.64438512296718],
["1hea",2,2.76319576623711],
["1es6",2,2.58232913274972],
["1rxz",2,3.30843403721196],
["1e3v",2,2.53411871372121],
["1hed",2,2.66603058730533],
["1heb",2,2.74023756142845],
["1n4l",2,2.75974533865121],
["1t74",2,1.93985307914750],
["1rcp",2,2.36888154033632],
["1lje",2,2.44830407688657],
["1lji",2,2.46869926805150],
["1lj3",2,2.55598784522265],
["1ljj",2,2.59989366275384],
["1uco",2,3.08939370450495],
["4yas",2,1.69305999971677],
["1cnw",2,2.36356348746402],
["1fql",2,2.52250279298493],
["3ca2",2,2.50654704963535],
["1ca2",2,2.39976891472727],
["1fqm",2,2.53087796578758],
["1hug",2,2.37925748155685],
["1crm",2,2.42419091020057],
["2cab",2,2.41418911914545],
["1i6j",2,2.48386599692512],
["3dni",2,2.40399014385272],
["1kcm",2,2.63820563459935],
["1f2l",2,3.40111364483019],
["1l2d",2,1.83751691235738],
["1y4y",2,1.61137239675987],
["1avn",2,2.44848065246424],
["1h4n",2,1.64667280659746],
["1zsb",2,2.18541833694982],
["1fqn",2,2.58235182998693],
["2abe",2,2.26309788227834],
["1hw3",2,2.40670841262289],
["1djc",2,2.89161073259805],
["1kge",2,2.39893112995964],
["3blm",2,2.72366807566452],
["1a8p",2,2.58997141003272],
["2ev5",2,2.01850462589754],
["1jxm",2,2.27654179777169],
["1ifs",2,2.34130276687937],
["1teu",2,1.99470483594456],
["1tbt",2,1.83665890379726],
["1teq",2,2.05155481868922],
["1tb0",2,2.03064148957608],
["1ugb",2,1.77022806152207],
["1te3",2,2.05629834895839],
["1t9n",2,2.17654023413895],
["1if5",2,2.2840555564792],
["1ze8",2,2.31195192138079],
["1i90",2,2.25665399146014],
["1i91",2,2.46132088865630],
["1azm",2,2.53757484458261],
["1if9",2,2.32486519231789],
["1fqr",2,2.93286747507279],
["1ugd",2,2.02680077128373],
["1ugf",2,2.07058005839800],
["1ugc",2,2.18668890809391],
["1uga",2,2.00436442062208],
["1zcu",2,2.15086446751649],
["1fvi",2,2.89641754779034],
["1pye",2,2.42889983972678],
["2d05",2,1.98163747628763],
["1puj",2,2.23457795550796],
["1rwn",2,2.42777531240188],
["1iyp",2,2.25070540621631],
["1esz",2,2.59084731781817],
["1xwy",2,2.3170107661036],
["1czm",2,2.79591684310180],
["1bzm",2,2.90225013759779],
["1y6o",2,2.00548576236619],
["1j1s",2,2.41148052531111],
["1xba",2,2.32518366946374],
["1skf",2,2.72251086108513],
["1c23",2,2.48894810860902],
["2bv1",2,1.54408441319876],
["1evg",2,2.17686376877557],
["1arc",2,1.91399018354270],
["1esu",2,2.43818882634577],
["1lhy",2,1.70721885830266],
["1axb",2,1.89681839806173],
["2gal",2,2.81389293555013],
["1hg2",2,2.99049716194875],
["1hf8",2,2.93005726589225],
["1hfa",2,3.0285457230276],
["1hg5",2,3.05194248643557],
["3mat",2,2.78658665468986],
["2a72",2,1.57165783425881],
["1bdb",2,2.13031947525931],
["1c8y",2,2.14836713775225],
["1ouv",2,2.60837167844095],
["1c8x",2,2.91064832441380],
["1q2p",2,1.89714236105158],
["5gal",2,3.07957652154129],
["1tqi",2,2.11095395745586],
["1nvq",2,2.37762658253301],
["1wzu",2,1.84629679771848],
["1dui",2,2.87706815235225],
["1lqo",2,1.94213250020394],
["1xbc",2,2.15470494868702],
["1a78",2,2.98565621119531],
["2bgm",2,3.20891019586764],
["2fs2",2,2.54154887331663],
["2b4l",2,2.21455136687504],
["1yze",2,3.48647433928263],
["1jea",2,2.21534842704306],
["2f93",2,1.49330489307426],
["1r78",2,2.20974661122148],
["1qpe",2,2.1443080856433],
["1v9o",2,2.17245267540677],
["2br1",2,2.47534049966971],
["1yvi",2,1.91570146174862],
["1drk",2,1.80944375789044],
["4mat",2,3.31747442593203],
["1qpd",2,2.14513235105338],
["1eg4",2,2.48665656934521],
["2ai1",2,2.05489876949254],
["1nkz",2,3.05491437754356],
["1wkj",2,1.65179419477918],
["1iuo",2,1.6609972573131],
["1i7p",2,1.77155290933686],
["1avt",2,2.45887028749801],
["1kr1",2,2.02336501551182],
["1aq1",2,2.60858629289924],
["1fy7",2,2.60766466160414],
["1sca",2,2.96017898649432],
["1ik6",2,2.47680792524747],
["2tdt",2,2.67397890243556],
["3tdt",2,2.44243648876826],
["1kgq",2,2.7174418034746],
["1af7",2,2.82361180970187],
["1md0",2,2.04266170535758],
["1mgp",2,1.93587615235333],
["1yxv",2,1.84777718303169],
["1ywv",2,2.00011690557013],
["1yxx",2,2.10789566715952],
["1yxt",2,2.46113836404206],
["1b6z",2,2.43717356991509],
["2plc",2,2.54598267521277],
["1st2",2,2.46097813679347],
["1ltv",2,2.24242999152517],
["1gii",2,2.75363792885104],
["1ga8",2,2.10557781221266],
["1g9r",2,1.99088354176789],
["1ke6",2,1.78372716524719],
["1pa9",2,2.70154904037007],
["1ke9",2,2.33001692989463],
["1ke7",2,1.70420136416577],
["1wmy",2,1.64549183331895],
["1b8n",2,2.4037113292272],
["1ke8",2,1.79070359782556],
["1bcu",2,2.30935815755864],
["1xjd",2,2.75086030410255],
["1z8j",2,3.01479945634938],
["1t4v",2,2.67010244637281],
["1t4u",2,2.80852946740445],
["1pzz",2,1.88172375894941],
["1mue",2,2.45670521708138],
["1nt1",2,2.33419811659427],
["1g37",2,2.38642554854385],
["1mu8",2,2.22051669109249],
["2byd",2,1.51261827084484],
["2fk8",2,1.58003761435813],
["2aao",2,2.4414722973877],
["1ad8",2,2.53628214286489],
["1d6w",2,3.36899725074094],
["1znj",2,2.66990655795936],
["1m4r",2,2.38074322214953],
["1eam",2,2.42770826233942],
["1a9q",2,2.31213937799092],
["1a9r",2,2.29934274703455],
["1zej",2,1.82805422852757],
["1ajz",2,2.66906212885314],
["1aj2",2,2.85287038378113],
["1aj0",2,2.94340229221861],
["1a9s",2,2.45354767632934],
["1h1w",2,2.23574218835601],
["1g30",2,2.73183008066206],
["1xi0",2,2.75380582925274],
["1ni9",2,2.15138368827043],
["1a9t",2,2.25722609476647],
["1nlk",2,2.14565862840907],
["1qiz",2,2.65235575782526],
["1k1k",2,2.65320303425596],
["2hbe",2,3.46195934375822],
["2mhb",2,3.15380520965693],
["1a4f",2,3.01465247841000],
["2nck",2,2.17269274831949],
["2ebn",2,2.52516880843429],
["1lpg",2,2.78661960798678],
["1mzg",2,2.70066288284324],
["1yq5",2,1.68084785263869],
["1psz",2,2.36815161652109],
["1hbt",2,2.27974318128691],
["1qz1",2,2.52268215538502],
["1z8i",2,2.76574211812466],
["1jwg",2,2.44060446216050],
["1ye5",2,2.20538511542009],
["1kwb",2,1.86579010602924],
["1kw8",2,1.63286051413670],
["1kmy",2,1.43871130788238],
["1t0j",2,2.11722453826159],
["5prn",2,2.02863396497848],
["1wde",2,2.8372368489684],
["1eiq",2,2.66424465319269],
["1eil",2,2.62594595576229],
["1eir",2,2.78721682141396],
["1a9o",2,2.76209624974075],
["1pbn",2,2.72341226422556],
["1j8y",2,2.37009419700146],
["1b38",2,2.63227108664606],
["3mct",2,2.44585108199989],
["1jte",2,2.49712631768673],
["1bky",2,2.45941728052928],
["1p39",2,2.56357865131381],
["1s3z",2,2.56296767168394],
["1xqw",2,3.11163973985188],
["1ldd",2,3.20803450848984],
["1txr",2,2.3848633464967],
["1bes",2,2.67818872326213],
["1ccc",2,2.04936574521129],
["1ccl",2,2.13227959617054],
["2erv",2,1.75202880448843],
["1c7f",2,2.44003695872461],
["1u2k",2,3.15116720597686],
["1lcy",2,2.76298300165364],
["1dse",2,2.44273863825438],
["1gsh",2,2.19758122436968],
["1ae8",2,3.16320695240515],
["1afe",2,3.20810188901917],
["1d07",2,2.77039635652237],
["1jbb",2,2.46914660574489],
["1csn",2,2.13838179637553],
["1mt3",2,3.33645482704837],
["1u32",2,2.32681333430198],
["1uma",2,3.16859388979015],
["2f4w",2,2.44674364972275],
["1iz8",2,2.6867744141375],
["1gd2",2,1.99102866808624],
["1krj",2,1.85643859380446],
["2b53",2,3.11788302117941],
["1j8m",2,2.78915403545588],
["1qur",2,2.99674255631281],
["2gno",2,0.888396566666415],
["1h73",2,1.81735250977848],
["1frn",2,2.81368463904397],
["1np8",2,2.34041072685041],
["1pvl",2,2.46604158230322],
["1iip",2,2.90833101056387],
["1t4g",2,2.35137446730802],
["1vjy",2,1.84781599523746],
["1sqh",2,2.91074886438802],
["2azr",2,1.30956242700037],
["1n2s",2,2.75929652388394],
["1z4e",2,2.05474453691938],
["1acb",2,2.83689542003778],
["1w94",2,2.5412209223419],
["1in5",2,2.02180417290216],
["1g1f",2,1.84758099269007],
["1sxs",2,1.92380524116899],
["1sxb",2,1.49489596589907],
["1cob",2,2.81875594754791],
["2a3h",2,1.61919108717323],
["2bx3",2,2.48195074776155],
["1qj1",2,2.90366123056536],
["1nlw",2,2.77423972962632],
["1jbu",2,1.85007831052055],
["1t9j",2,2.49598764273917],
["1rxw",2,2.23266495416561],
["1xew",2,2.82305687638678],
["1yjk",2,2.3351889503775],
["1ceq",2,1.96455318713324],
["2f6f",2,1.92359232333825],
["1nm2",2,2.08445088478183],
["1qoy",2,1.54524785518509],
["1hag",2,4.06019991011233],
["1myi",2,2.94489054573508],
["1ihs",2,2.19275691551253],
["1i72",2,2.00284100735366],
["1u4s",2,1.22854025457019],
["1elm",2,1.82498247999352],
["1cpx",2,2.04827137590714],
["1urv",2,2.62167117783472],
["6atj",2,1.46217305455755],
["1kzm",2,1.42442934682469],
["1ic2",2,1.98817694548983],
["1u98",2,1.80616976868897],
["1iy7",2,2.19459938806270],
["7cpa",2,2.78694078667932],
["8cpa",2,2.9655778808665],
["6cpa",2,3.03530135764977],
["1cbx",2,3.0443181990589],
["3cpa",2,3.08897667262381],
["1dmw",2,1.96121496857758],
["1n06",2,2.40543599384593],
["4pah",2,1.80764832865110],
["3pah",2,1.60939619094638],
["1mmt",2,1.84022874953566],
["1pah",2,2.44232653248214],
["1glg",2,2.45076021562556],
["2fpm",2,2.45423181706334],
["1i4a",2,2.29289783792344],
["1n0i",2,2.25098489779469],
["1mmk",2,1.96975406496973],
["1xiz",2,2.43014604716839],
["1mx6",2,2.48473850027945],
["1gia",2,1.33997751542034],
["2fyt",2,2.53896265768490],
["1obp",2,2.77507729702494],
["1ynr",2,2.27000798804262],
["1j01",2,2.0260494183022],
["2lig",2,3.01398256417575],
["1mx4",2,2.50832429988397],
["1hvf",2,2.55796146761617],
["1hvd",2,2.65084833587096],
["1svk",2,1.83349064170204],
["1as0",2,2.15774279223290],
["1dd3",2,2.94946967948234],
["1pnf",2,2.31885006128412],
["1gsa",2,1.98946421358219],
["1xlp",2,2.10918877316618],
["1z1y",2,2.29588652378677],
["1xf0",2,1.55197625192867],
["1zcb",2,2.07729359591027],
["1a77",2,3.67887819167768],
["1a76",2,3.71895455215739],
["1trb",2,2.90825912413066],
["1fjo",2,1.75106994469661],
["1fjv",2,1.73169842311800],
["1fj3",2,1.85812557147303],
["1fju",2,2.03379834863299],
["1ros",2,2.31314823869223],
["1qlm",2,1.91484731814681],
["2fe7",2,1.84778165647532],
["1s1r",2,1.71433236303269],
["1npc",2,2.49583254165761],
["1bsa",2,2.78113451400292],
["1zsz",2,2.09353234631892],
["1nij",2,3.40190608392594],
["1bnf",2,2.19531416319547],
["1bc0",2,3.22513249425979],
["3cms",2,3.12508217780281],
["1bsc",2,2.81565106636084],
["1brk",2,2.13599827179092],
["1zdr",2,2.84771462140617],
["1brj",2,2.38578559392515],
["3lip",2,2.01277150353806],
["1brh",2,2.37261771924243],
["1bsb",2,2.82079133948033],
["1bse",2,3.15463051992296],
["2fxf",2,2.54552397783432],
["1wq4",2,2.47131009673098],
["1gxj",2,2.51821734617173],
["2pia",2,2.32027739902654],
["1zcm",2,2.32354525016152],
["2aqw",2,2.4608710241732],
["1evx",2,2.04506907182481],
["1wq3",2,2.46047214055809],
["1x8x",2,1.82456943810585],
["1b21",2,2.48753071587231],
["2bcv",2,1.76569609153789],
["1b4e",2,2.26494776864678],
["1h44",2,2.51089361991974],
["1rtp",2,2.28370985944897],
["1pui",2,2.40377003637703],
["1lct",2,3.16727291706942],
["1eh3",2,2.14376137142612],
["1uh9",2,1.42877615949515],
["1m2p",2,2.22812673442929],
["1l97",2,3.80151050453908],
["2gao",2,1.4954444334847],
["1f3v",2,2.87507478007806],
["1psw",2,1.88957753639864],
["1i6i",2,2.74569686735644],
["1zyj",2,2.65093850741177],
["1lr4",2,2.47161305693372],
["201l",2,2.82304066370390],
["1gyn",2,2.03289078432652],
["1d4n",2,2.51193882025874],
["1nv3",2,3.00196986803003],
["1yxi",2,2.33988680760167],
["1pso",2,1.60214551004559],
["1pme",2,2.48497727385451],
["1eed",2,1.79476451653073],
["1fc3",2,2.84224504358552],
["6ldh",2,3.76500389437334],
["1i9y",2,2.77993338596551],
["4er1",2,1.79370876935145],
["1epo",2,2.74043428238407],
["3er3",2,2.86971337167095],
["5er1",2,3.21223800827805],
["1gew",2,1.99011162829694],
["1fpq",2,2.37601358140984],
["1tv9",2,1.74433778521130],
["1ge7",2,1.76129451119971],
["1qy7",2,1.88008745140054],
["1u90",2,1.93212265627166],
["2bos",2,1.44579248746891],
["1j33",2,2.17569738638528],
["1spb",2,2.96781744107718],
["4er2",2,2.33699763375385],
["1epl",2,2.72938017182979],
["1nhi",2,2.53861811182719],
["1ri6",2,1.82759954687782],
["1yv5",2,1.43217357361090],
["1g17",2,2.59133895733485],
["1xx6",2,2.14876531000828],
["2er6",2,2.95516825788933],
["2ae0",2,1.69409242307748],
["1smr",2,2.69821816980526],
["1xix",2,1.97112092063688],
["1zz2",2,2.70603677418037],
["1er8",2,2.45500715772701],
["1n2d",2,1.91034594534196],
["2b4b",2,2.79913157005054],
["1y4d",2,2.4213879664334],
["1mee",2,2.39624866895478],
["1slw",2,2.68823760536441],
["2b4d",2,2.80473263036083],
["1d1k",2,1.36458680161419],
["2gfo",2,2.18690368808476],
["1ljt",2,2.07614265595434],
["1nai",2,2.43177043877329],
["1mff",2,2.02188181722634],
["1icc",2,2.19786656227229],
["1ia5",2,2.37013651776919],
["2g5j",2,2.54079640696849],
["7wga",2,3.15889911942289],
["1l5m",2,2.26851522156004],
["1jhr",2,2.47241834736514],
["3tec",2,2.41197419265997],
["1mka",2,1.77984281778113],
["1mkb",2,2.11175820728034],
["1g7l",2,2.10109604138273],
["1knq",2,2.20227071199933],
["1cqr",2,2.45113773863356],
["1d7x",2,2.45930677155434],
["1cgq",2,2.03044966278787],
["1h7r",2,3.4451854284099],
["2cav",2,3.09773611661115],
["1x0a",2,1.69051885715091],
["1scj",2,2.63307219446933],
["1qno",2,1.56961071084325],
["1yht",2,1.94800173949954],
["1n0s",2,2.68944083861294],
["1s14",2,2.52923055270652],
["1nzu",2,2.64676398003625],
["1l5k",2,2.13417247214826],
["1jhu",2,2.62587443111772],
["1l4m",2,2.07498826733848],
["1jhq",2,2.57157250850558],
["1jhx",2,2.52971718618601],
["1jha",2,2.50430603456768],
["1jhy",2,2.59624786932934],
["1jho",2,2.66915252751159],
["1jhv",2,2.56017869363308],
["2scp",2,2.87791710419592],
["1lj0",2,1.91421843787773],
["1by7",2,2.59927586370219],
["1l4l",2,2.14040812275218],
["1l4e",2,2.39652585701790],
["1l5l",2,2.19370698802164],
["1l4n",2,2.3061092397547],
["2cwg",2,2.94339969110306],
["1aoc",2,2.99183290678156],
["1kir",2,2.82970816581362],
["1bht",2,2.99933540756168],
["1gox",2,2.83883258794283],
["1ndy",2,2.95352874430362],
["1ndw",2,3.3503082493659],
["1ndz",2,3.47811137318507],
["1r3c",2,1.99197535558660],
["1zz6",2,2.41151100177927],
["1qin",2,1.36940332717320],
["1hv6",2,1.82799507130569],
["1zzl",2,2.55540520622647],
["1nzd",2,1.87765231420703],
["1lqb",2,2.61284450928136],
["1kq0",2,1.80556658960480],
["1hur",2,3.35405814351761],
["1wbv",2,1.94379855354824],
["1wbt",2,2.31397088607776],
["1d6j",2,2.68971102365596],
["2b5v",2,2.31290235041398],
["2c1b",2,1.51490796216257],
["1sn7",2,2.73164026535179],
["1l3r",2,1.99668858316026],
["1ow2",2,2.69301414758984],
["1wdc",2,2.77985730438246],
["2ajg",2,2.30593728074592],
["1g0v",2,1.77623578640276],
["1yqj",2,2.86293500076416],
["1mpp",2,1.87078226331945],
["1mns",2,1.73577220170634],
["1mn2",2,1.94284923240490],
["1mn1",2,2.12039197106369],
["1q8t",2,1.7845672986692],
["1eus",2,2.69057778909198],
["1t0i",2,2.38944305258438],
["1apm",2,2.79594500138277],
["2b0m",2,2.35032871675347],
["1ue0",2,2.80053819624443],
["1obu",2,2.14994190203816],
["1gl4",2,1.88763534336798],
["1o7k",2,1.92297785197403],
["1pjc",2,2.94640754414041],
["2fc1",2,2.69287448152278],
["1a6q",2,2.56124183441089],
["1gvq",2,2.40043281466420],
["2bm5",2,2.18725906855026],
["1djl",2,2.17254948238912],
["1wop",2,2.25016645707592],
["4thi",2,2.25561734145487],
["3thi",2,2.15610133170263],
["1nx1",2,2.48666873333035],
["1z2w",2,2.73842063656351],
["1ald",2,3.70404299895978],
["1ul3",2,2.31286398961626],
["1zop",2,2.60764317768703],
["1s12",2,2.84133854163468],
["2b9l",2,2.53501753224285],
["1np1",2,2.75806935607571],
["2np1",2,2.96863599691141],
["1sgm",2,2.85713270875514],
["1gp1",2,2.18844923157596],
["1wmx",2,3.25185340064484],
["1n8o",2,2.39748492942466],
["1mos",2,2.03790727943790],
["1vpk",2,1.76715006592048],
["1yd6",2,2.08328396205658],
["1ke2",2,2.13888259677341],
["1hru",2,2.53603663248783],
["1fnf",2,2.87103079683076],
["1r5g",2,2.61703744269947],
["1vjn",2,1.87997223144279],
["1jw5",2,2.48064914891038],
["1jw4",2,2.44923324881785],
["1hix",2,2.79351074333359],
["1mpb",2,1.77129863051384],
["1zjl",2,2.06461576224072],
["1ziu",2,1.93888766067419],
["1q43",2,1.95373449822147],
["1xmb",2,1.61740214105276],
["2g3b",2,2.02649354714164],
["1efz",2,2.31930392875196],
["1qlp",2,2.54943752394323],
["1d2o",2,3.2689831285589],
["2fez",2,1.9334803868674],
["1ac1",2,1.70136210151754],
["1dyk",2,2.62104643404651],
["2gc0",2,1.78422004126543],
["1dsb",2,2.20430984723463],
["1r1u",2,2.89710673325171],
["1lg9",2,2.33849072494210],
["1xbf",2,2.43686008084321],
["1uw8",2,1.22346429648039],
["1sul",2,2.43880970212445],
["2ex1",2,2.48169821247476],
["1pbw",2,3.00974983728113],
["1ok8",2,2.73758067100583],
["1fbt",2,2.86003218748909],
["1p18",2,2.54284374309351],
["2bvq",2,2.45536160286877],
["1t1y",2,2.10917162996142],
["1a1n",2,2.40123322033963],
["1qc5",2,2.11215050159838],
["1juf",2,2.60519903776316],
["1mp9",2,1.85097188513502],
["1vfh",2,2.79178445292826],
["1bay",2,2.03234670095337],
["2axg",2,2.21261799202960],
["1k5u",2,2.37987330295873],
["2bss",2,2.06581618772576],
["1u77",2,2.48780705939877],
["1dj9",2,3.15895942896560],
["2bi7",2,1.97207210910677],
["1b9i",2,2.60699548404305],
["1b9h",2,2.53559385838341],
["1w2h",2,2.22770560428865],
["1fc7",2,2.71744293791019],
["1eay",2,3.57281066501062],
["1q5u",2,2.04080510999352],
["1v5c",2,1.91946744666236],
["2bat",2,2.89959261299255],
["7nn9",2,2.12592610674792],
["2qwd",2,2.16266534783897],
["2qwb",2,2.27600798390948],
["1bji",2,2.31621301346532],
["2qwe",2,2.19147069482675],
["2qwj",2,2.36703780629044],
["2qwi",2,2.40456804173851],
["1uut",2,1.59423176966356],
["2awp",2,1.45889345335396],
["1cc4",2,2.08701141893520],
["1bgn",2,1.87424164827896],
["1woc",2,3.06385946189482],
["1iut",2,1.9460040371352],
["1iux",2,2.18423034466498],
["1iuw",2,2.13609650936617],
["1iuu",2,2.05155336404815],
["1doc",2,2.14377257760061],
["1dob",2,2.25034243839342],
["1k0l",2,2.06923698321054],
["1io1",2,2.89701879835004],
["1toe",2,2.52177435830084],
["1spa",2,3.24249021946753],
["1g4v",2,3.38055052335124],
["1z05",2,1.66231387905291],
["1c5k",2,3.09592762020227],
["1v5x",2,2.82044207755127],
["1vpe",2,2.2813585530561],
["1oyc",2,2.65135674216660],
["1ulw",2,1.97959009870680],
["1rom",2,2.34696791142960],
["2rom",2,2.18744864520632],
["1dfa",2,3.56349313143762],
["1a94",2,2.83934552348878],
["1a8k",2,3.50853793288388],
["1jip",2,2.54241252519678],
["1o63",2,2.31553556597358],
["1vra",2,1.51778869767102],
["1pca",2,2.89568268682914],
["1dth",2,2.71428873907387],
["1znv",2,2.20252369927517],
["1z8q",2,2.36446284754472],
["1wpo",2,3.29486307830666],
["2au3",2,2.01989881899196],
["1iz6",2,2.7106873739822],
["2a8a",2,2.07507665742029],
["1rp8",2,1.52859666422678],
["1rp9",2,1.67539327981064],
["1rpk",2,1.77674785849088],
["1p6w",2,2.02237851095647],
["1kmj",2,1.56318470391928],
["1yjs",2,2.35793954057139],
["1jf9",2,1.58912945354971],
["7cpp",2,2.34217869791735],
["1gem",2,2.51176539541291],
["1iwi",2,2.45466426984167],
["1iwj",2,2.44506529994738],
["1iwk",2,2.49593249484385],
["1wht",2,2.74347686242399],
["1s96",2,2.42735682909058],
["7fab",2,2.47416898877674],
["5hoh",2,1.52893800750225],
["1qh6",2,1.68443492004964],
["1w7l",2,1.98842442012961],
["1ng5",2,3.44896043966664],
["1hj6",2,2.87088026673228],
["1o20",2,1.41998946958922],
["1jra",2,2.19610763966355],
["1lh0",2,2.33878210549677],
["1rmq",2,2.19360441634374],
["1zvi",2,2.85545571409188],
["2bam",2,2.86436037120178],
["1pn9",2,2.35727239076218],
["1kbn",2,2.49778806808788],
["1ieg",2,2.59240959653414],
["1mfe",2,2.50194811296924],
["1qi4",2,2.70413074025465],
["1qpk",2,2.70986730330155],
["1qi5",2,2.68181289472681],
["1qi3",2,2.65735586413699],
["1yun",2,3.18407532195257],
["2btw",2,2.87157645960975],
["1bqu",2,1.97804640681900],
["1uax",2,2.51923742575692],
["1edh",2,1.65438247631353],
["1vag",2,2.854158866516],
["1ied",2,2.79174222857482],
["1rmg",2,2.23263534968454],
["1t2p",2,2.94538525896497],
["1s1q",2,1.94025940756478],
["1q0y",2,2.08270482403316],
["2bab",2,1.40420862649531],
["1gv3",2,2.06383417281089],
["1p9b",2,2.60875614027661],
["5fwg",2,3.76487824731238],
["1ank",2,3.38090074046814],
["1l2l",2,2.86095625378776],
["1bm3",2,3.74657563397140],
["1v4a",2,2.25129339310137],
["1kp2",2,2.33131163414745],
["1hav",2,2.64366949836132],
["35c8",2,2.69009358779979],
["25c8",2,3.19780577496467],
["1uet",2,2.62594609212087],
["1rz7",2,2.12365849303911],
["1ugq",2,1.65168943098079],
["1ugs",2,1.77288222702673],
["2bre",2,2.14631524124720],
["1ueu",2,2.77303817790288],
["1mz8",2,2.31945729328678],
["1k97",2,2.09308199046219],
["1ylu",2,1.64506019543770],
["1gd7",2,3.02164640617722],
["2mcg",2,4.59949689636806],
["3mcg",2,4.82618799253412],
["1d5i",2,2.9648815187155],
["1d6v",2,3.17756902489110],
["1d7r",2,3.05299342460399],
["1zc9",2,2.22267875317213],
["1m0q",2,2.64203394669351],
["1ia7",2,1.67203261944912],
["1qf5",2,2.28345684038267],
["1idt",2,2.4070516811063],
["1dd6",2,2.48648331787115],
["1npz",2,2.13402935239224],
["1t3f",2,2.13390754873762],
["1v5z",2,2.21492481962153],
["1bif",2,2.33197274069987],
["5gst",2,3.25145091281622],
["1uan",2,2.19509856582151],
["1lv0",2,2.29207113886952],
["1h1b",2,3.01087409363727],
["3cel",2,1.60030533688385],
["1riu",2,2.00295079759466],
["2bfk",2,2.33069695404890],
["1cr9",2,2.31862468750355],
["1mxd",2,2.20467151100398],
["1nbv",2,3.90665654654895],
["1kp3",2,2.28327085968415],
["1bl3",2,2.79658588153087],
["2cts",2,3.17559916497723],
["1vge",2,2.93102310164640],
["1r8b",2,2.24571853701377],
["1eo9",2,2.54488188557611],
["1pkw",2,1.78216564801166],
["1xd5",2,2.36206410683902],
["2aor",2,2.32758740108194],
["1yeg",2,2.66576439794622],
["1yef",2,2.73779097259638],
["1wl6",2,1.18600990063851],
["1f3b",2,2.48382701566994],
["1sbs",2,2.60918919733242],
["1gse",2,2.21884025878340],
["1u8i",2,2.70518085649489],
["1tqx",2,2.30381486527865],
["1v9a",2,2.06317292696517],
["1diw",2,2.94093889877908],
["1vav",2,2.80716621659288],
["1kwx",2,1.77995339213312],
["1kwv",2,2.00716025898739],
["1kx0",2,1.9989472009364],
["1kwy",2,2.05801224228372],
["2kmb",2,1.77105456935271],
["4kmb",2,1.80904938284018],
["1eke",2,2.47009782901922],
["1sws",2,2.66906001346281],
["1mzh",2,2.56641466808468],
["1qja",2,2.3811952252625],
["1ff9",2,2.80808237008355],
["1tj1",2,1.98416518858727],
["1kdn",2,2.29495258194086],
["1hmd",2,1.94303067133075],
["1hmo",2,1.97376824271169],
["1nhp",2,2.06088831405955],
["1nhq",2,2.12081911288074],
["1e4i",2,2.73204247965563],
["2f5b",2,2.84809756280028],
["1aqh",2,1.76757503528010],
["2fea",2,1.87537167648436],
["1uzl",2,2.78759517721759],
["1ucn",2,2.51386168338993],
["1gef",2,2.49321071193355],
["1qcf",2,2.66245282961207],
["1swj",2,2.95665491931267],
["1vcv",2,2.30519252350197],
["1v6z",2,1.99673839695584],
["1s4v",2,1.5324537094103],
["4gep",2,2.3887666212544],
["1f58",2,2.18482654272528],
["2bj4",2,1.9469017218235],
["1goz",2,2.59972055493845],
["1r9o",2,2.86914424037572],
["1pii",2,2.72966027907994],
["1dsu",2,3.15910329979716],
["1s53",2,2.50780149599925],
["1kme",2,2.45939055540394],
["1s51",2,2.9027083936061],
["1v9k",2,2.79406374392993],
["1z5z",2,2.82329275593804],
["1tjg",2,2.06300094476027],
["2fkf",2,1.72245692503444],
["1az0",2,2.17804844153135],
["2c1n",2,2.78473270868447],
["1bgb",2,2.8102237034197],
["1k7g",2,1.48648713342903],
["1tiw",2,1.93479901456239],
["1bsu",2,2.59633621235049],
["1v57",2,1.62493828382408],
["2bmi",2,2.15107486305935],
["1h9w",2,2.30524187294259],
["1pcj",2,1.95060594067450],
["1tv2",2,1.98922601663892],
["1ra6",2,2.40001299533098],
["1f83",2,3.29478425833305],
["1wvv",2,1.26146561426160],
["1afa",2,2.0508331322258],
["1afd",2,2.36243089727336],
["1bch",2,2.24981835682],
["2bzs",2,2.32501247321169],
["1mu5",2,2.71570925960368],
["1rt8",2,2.36525170753376],
["1go8",2,1.63155702515052],
["2f6x",2,2.15146743945954],
["1xan",2,2.10485385219651],
["1grg",2,2.3951451843377],
["1grf",2,2.42986989088812],
["1gra",2,2.39948256537948],
["1gre",2,2.48204670541943],
["1swk",2,2.4279421607189],
["1swp",2,2.53806199717569],
["1nqb",2,2.13115881825006],
["1dqt",2,2.47059223570715],
["1sh5",2,2.49275884100541],
["1nc1",2,2.4182647947852],
["1z5o",2,1.97667075715408],
["1lx7",2,2.01263929685988],
["2b0d",2,2.84308039831376],
["1qjb",2,2.98958466886095],
["1u5k",2,2.44753071037633],
["1n7k",2,2.15496447835540],
["1dek",2,2.72247602536732],
["1p27",2,2.92584791616619],
["2be6",2,2.34844573094733],
["1eo3",2,2.61064458518928],
["1srp",2,2.67873848098285],
["2arz",2,2.42136303624116],
["1q5x",2,2.29607990057727],
["1akl",2,2.57926471695967],
["1rqh",2,2.23332546221994],
["2fno",2,1.59481648177710],
["1gah",2,1.49514490749310],
["1rr2",2,2.25426616287113],
["1fs9",2,2.27908958435919],
["1swf",2,2.51470266306228],
["1gic",2,2.73433589124521],
["1rrk",2,2.31763443829748],
["1w1s",2,1.95265499968612],
["2pgd",2,2.55941579071625],
["1yf9",2,1.70681066342432],
["1y89",2,1.48460787991058],
["1o0w",2,2.12486168175094],
["1m85",2,1.66076874083017],
["1e93",2,1.88870798452764],
["1uzy",2,1.94587975377760],
["1qmp",2,1.85973155572805],
["1esv",2,3.31325375650980],
["1geq",2,2.66364957895526],
["1n3o",2,1.75969280158236],
["2ff3",2,1.93967002220870],
["2f7f",2,2.03318703040341],
["1r1d",2,1.4994543854534],
["1u9m",2,2.23260381886617],
["1g13",2,2.18537173268775],
["1c7i",2,2.49525263869295],
["1hvx",2,1.77588598346891],
["1rw0",2,2.36607775214516],
["2fkb",2,2.18868528881228],
["1n4a",2,2.25185650326277],
["1rva",2,1.86927042311474],
["2ag2",2,2.13701065300578],
["1v03",2,2.46566287251625],
["1k4e",2,2.45696139114422],
["1p15",2,3.9250288012823],
["1tjj",2,2.09048703113209],
["1n5b",2,2.28568831849241],
["1u7e",2,2.44212917680559],
["1n2z",2,1.97074898343908],
["1pqk",2,2.68574234129336],
["1c0g",2,1.46856255877928],
["1oe4",2,2.07394683896410],
["1nxz",2,2.82972481210608],
["1fof",2,2.03687769305359],
["1q6g",2,2.30047766209774],
["1q6d",2,2.41861435207027],
["1y3p",2,2.50566332811162],
["1dqk",2,2.30865048010733],
["1mfu",2,1.77480172201719],
["1btc",2,2.68614579195528],
["1ilv",2,2.74783312223369],
["2fu5",2,2.26647036050785],
["1h8y",2,2.46838632174792],
["1kwh",2,2.50836352282085],
["1g2i",2,2.19127661834066],
["2awh",2,2.37344497018657],
["1ci1",2,2.41294501791737],
["1kgu",2,2.36610037857536],
["1mfv",2,1.74174778614456],
["1xd0",2,1.73767854117732],
["1bsi",2,2.13804050085583],
["1xh0",2,2.18621448994155],
["1cpu",2,2.17239350901111],
["1xcw",2,2.14957551942688],
["1xgz",2,2.25377985890908],
["2cpu",2,2.38447852814360],
["3cpu",2,2.65828275697562],
["1kgx",2,2.72219297081685],
["1z0u",2,2.62163004496591],
["1u46",2,2.06222253629885],
["2g7c",2,2.15513752705558],
["1xt8",2,2.10760055068811],
["1sux",2,1.76475906800812],
["1t44",2,2.02973294298932],
["1n1d",2,2.51465266964005],
["1g73",2,2.7249247223017],
["1dwf",2,1.76349149030026],
["1dwg",2,1.76349149030026],
["1dwh",2,1.76349149030026],
["1dwi",2,1.76349149030026],
["1cwy",2,1.74954719838517],
["1woy",2,2.6145441788088],
["1a8h",2,3.09008360152503],
["1r0s",2,2.07649927618702],
["1r16",2,2.03085299130249],
["1zuc",2,1.95821966966512],
["1clv",2,1.67608313793623],
["1lbw",2,3.17919212027666],
["1w6l",2,1.65116165280999],
["1h5y",2,1.84744613576004],
["1te5",2,3.11929873794065],
["1ezl",2,3.58068215508927],
["1e5y",2,1.88878358238659],
["1e5z",2,1.99992688630160],
["1dpe",2,2.54191839363404],
["2afg",2,3.26038324034748],
["1g8z",2,1.93877111728688],
["1eei",2,2.08082819002200],
["2chb",2,2.42859498874712],
["1d2z",2,1.42449762067186],
["1chp",2,2.59168709801133],
["1zy5",2,2.58320198380236],
["1eb4",2,2.55359956173578],
["1c14",2,2.63666640963306],
["1i36",2,2.40047213892244],
["1mbl",2,2.76179380861927],
["4blm",2,2.94325456274999],
["1czy",2,2.49773630935487],
["1fto",2,2.27459434333142],
["1fsn",2,2.74124828592765],
["1p1u",2,2.06208125327874],
["1fsq",2,2.88729819326227],
["1fsr",2,3.18862278194939],
["1lci",2,2.05586507258434],
["1j18",2,2.09081658933972],
["2b50",2,2.29073842710881],
["1knc",2,1.81356333307415],
["1b3h",2,1.87612765713481],
["1b7h",2,2.35557293491775],
["1wmb",2,1.8254586602157],
["1b05",2,2.15312388631775],
["1b3g",2,2.02530249690842],
["1p0i",2,2.42738842285501],
["1wdj",2,2.34505791023858],
["1hyu",2,2.24401996860575],
["1ddt",2,2.75217101571654],
["1f4f",2,1.94646207804165],
["1f4c",2,2.08526078045244],
["1qci",2,2.70282243796045],
["1g0n",2,2.44803072271665],
["1jg0",2,2.51328886792983],
["2b1e",2,1.83133995866706],
["2bsz",2,2.52941368398448],
["1v0p",2,2.59611632584792],
["1hy2",2,2.47936741736358],
["1l1e",2,2.83662217783389],
["1syn",2,2.74348144454924],
["1gcw",2,3.02097971808271],
["1k4c",2,2.08962092974739],
["1zlj",2,2.12795458843691],
["1p42",2,1.93970877842242],
["1ekk",2,2.33057211674726],
["1fgk",2,1.6505952101151],
["1k3d",2,2.64542861960447],
["1k3c",2,2.49475143192431],
["1tws",2,2.17095360885842],
["1qa1",2,1.74228461373343],
["1qa2",2,1.76126201821005],
["1qa3",2,1.73308834326629],
["1x6n",2,1.78639019034049],
["2a5t",2,2.37423296245672],
["1clw",2,1.72339202362164],
["1qrb",2,1.80544608199442],
["1tsp",2,2.37561132028884],
["2nsy",2,1.86596956871150],
["1nqe",2,2.91312120132694],
["1sel",2,2.08982076062417],
["1sbk",2,2.35196178625013],
["1gcv",2,2.76432546393351],
["1uxe",2,2.13534953069912],
["1yvx",2,2.43823155419245],
["1r5t",2,2.24461657957239],
["1vky",2,1.60558348269231],
["1dqj",2,2.59715715238707],
["1l5x",2,2.69678821658238],
["1g2w",2,2.01908485125720],
["1ia9",2,3.05244041531511],
["1icf",2,2.69766680571433],
["1iqd",2,2.56653408015425],
["1xml",2,2.31394078769406],
["1wiw",2,2.14432239056064],
["1hzw",2,2.25310796310021],
["2c2x",2,2.53961813915624],
["2for",2,1.71632460921935],
["1h0d",2,2.55118962279489],
["1zc3",2,2.77842650395924],
["1uok",2,2.86261354302099],
["1wg8",2,2.86648673421339],
["2dab",2,1.82724670470817],
["1a0g",2,1.97764600577642],
["1de7",2,1.97821770037141],
["3rub",2,3.0994720909615],
["1pzx",2,2.58731739394803],
["1wgj",2,1.74807635918162],
["1rif",2,3.05421514386995],
["1g7t",2,3.15496647037827],
["2b7a",2,1.75795327624949],
["1o1k",2,1.63198864917567],
["1v4u",2,2.78490546925341],
["2fh7",2,2.03094662486422],
["1xz4",2,1.86578850098665],
["1y4f",2,2.05988955756295],
["1y45",2,2.04992608142529],
["1yih",2,2.52401030888508],
["1gbv",2,2.82348903860525],
["1j7w",2,2.51481596662547],
["1a0z",2,2.32246153716599],
["1a00",2,2.31617468253241],
["6hbw",2,2.32266447758355],
["1g7s",2,3.2505123759657],
["1dan",2,2.25987704098596],
["1vzt",2,2.01790344503912],
["1n2h",2,1.85873268521668],
["1jc4",2,2.14647631295394],
["1o86",2,2.09281471277971],
["1o8a",2,2.13882223578297],
["1uzf",2,2.10944333233030],
["1sr4",2,2.10235936814156],
["1d3y",2,2.49425169730616],
["1brs",2,2.5842121805608],
["1s2u",2,2.36767890794655],
["1p2o",2,1.81718043223936],
["1ts3",2,1.99624345472596],
["1d5z",2,2.39352161032766],
["1rj4",2,2.16766107156631],
["1a96",2,1.80567784263949],
["1s2t",2,2.17985503048594],
["1njy",2,1.76280718770009],
["1ua1",2,1.83472889877831],
["1njz",2,1.80720241710117],
["1nkb",2,1.89754399424400],
["1u47",2,1.80076017987774],
["1kuj",2,1.93385671204915],
["1d5m",2,2.34704144229354],
["1yxd",2,1.78695691858830],
["3had",2,2.28364089200417],
["1i8d",2,2.86487183096782],
["1it6",2,2.28274064159407],
["1z6j",2,3.03821112925944],
["1n3f",2,2.61529235776383],
["1wsi",2,2.58429414812754],
["1qya",2,1.60142305922866],
["1v9b",2,1.99400176827919],
["2b3j",2,2.34123208356282],
["1apy",2,2.11534605435053],
["2bw3",2,1.97774261243210],
["1mej",2,2.10075712007079],
["1qga",2,2.56505590762216],
["2sod",2,4.52968884154885],
["1xtl",2,3.14174037394901],
["2a8l",2,2.14591227436004],
["1m9c",2,2.21730957558315],
["1wyk",2,2.15169941943891],
["1fmt",2,2.65200771921526],
["1aq0",2,1.51691873623540],
["1srd",2,3.68928593855065],
["1xxr",2,1.99089916642917],
["1pev",2,2.27120042748339],
["1wof",2,2.26633489325678],
["1wra",2,2.39294319231446],
["1mki",2,2.66906644518475],
["1yw4",2,2.91476635264876],
["1dlm",2,2.7474474700044],
["1he1",2,1.40810020883023],
["1uir",2,2.64539851868892],
["1dor",2,1.72421083984264],
["2dor",2,1.96407197134030],
["1el6",2,1.82561836318028],
["1ty2",2,2.55798833051042],
["1z82",2,1.89550489366671],
["1kie",2,2.61250030191511],
["1lld",2,2.94329742738648],
["1fns",2,2.27946364498578],
["2ew2",2,1.84980124058273],
["1u24",2,2.61283640590047],
["1mwm",2,2.93344677812555],
["2awd",2,1.93597659307803],
["1mvy",2,2.03685866256106],
["1mw3",2,2.12773270643541],
["1jgi",2,2.11461061124544],
["1fbw",2,1.55384358831231],
["1fce",2,1.62080669391995],
["1cm4",2,1.5892190434829],
["1hn9",2,2.22024388071759],
["1kz8",2,2.45069461075665],
["1bre",2,3.93811708859716],
["1a5b",2,2.60446836343139],
["1eun",2,2.43417035043999],
["1cun",2,2.40631146411805],
["1frp",2,2.24855895432612],
["1uh2",2,2.45722415449534],
["1qic",2,3.1785426072914],
["1v3u",2,1.86012890975858],
["1tki",2,2.27995072411534],
["1ttq",2,2.72935998388296],
["1qia",2,2.48958049484741],
["1xo0",2,3.28299973799857],
["1pv9",2,2.58276869302821],
["1w89",2,2.19581128496612],
["1yr0",2,1.99193147101391],
["1ylk",2,1.72752553700535],
["1cw2",2,2.64360989550332],
["1tkl",2,2.52390837074477],
["1t9s",2,1.69256197375615],
["1iz9",2,2.01859543404695],
["1wzi",2,2.21200186400376],
["1wze",2,2.17700621670097],
["1xkw",2,1.98442905417525],
["1s4b",2,1.92106961348418],
["1psc",2,2.41557718514607],
["1p6c",2,2.72886609243703],
["1djo",2,2.29735903619539],
["1dc6",2,3.24675714470985],
["1dc5",2,3.40096487410836],
["1szw",2,2.24263581119692],
["1zba",2,2.99494607465593],
["1v3v",2,1.84091831206927],
["1kmo",2,2.61046663423303],
["2a67",2,2.44262406368272],
["1p6x",2,2.21499047116133],
["9ldt",2,3.29797094540526],
["1crw",2,2.19854782627473],
["1szj",2,2.33159930631538],
["1jc0",2,4.06688969285687],
["2ahb",2,2.58068516595741],
["1uoe",2,2.19814587757668],
["2a8i",2,2.33015966249649],
["1h3j",2,2.10219219445886],
["1jdz",2,2.36240965532343],
["1ly9",2,1.81941153324582],
["1lyk",2,2.00760076975368],
["1fm2",2,2.09030512924034],
["1mqr",2,1.89287147999159],
["1yga",2,2.34957982526832],
["2d1i",2,2.7715596157592],
["1ror",2,2.1821464049863],
["1hmu",2,2.30862325512609],
["1hm2",2,2.33247188384080],
["2c6c",2,2.13872951333676],
["1ib4",2,2.69014513536815],
["1b43",2,2.87088479678664],
["1jdt",2,2.45792742567756],
["1pim",2,2.49528330857682],
["1sli",2,2.30680706550867],
["1sll",2,2.4908746284873],
["1rsr",2,2.27944880367888],
["1y79",2,2.77221361361841],
["1ujm",2,2.13521013665599],
["1cgt",2,2.15441019736229],
["1b57",2,2.31229178845332],
["1eo5",2,2.25132531439802],
["1ot1",2,1.47716384634515],
["1pj9",2,1.69358562974959],
["1cdg",2,2.50160942289687],
["1bbp",2,2.52113021239555],
["1ro6",2,2.30782072336051],
["1lcf",2,3.55736825195554],
["1cb6",2,3.06117521702547],
["1sst",2,2.64648205502558],
["1x80",2,2.03925130382673],
["2b4i",2,2.57098614746436],
["1yv3",2,1.61284404830440],
["1dzb",2,3.36191198965103],
["1icq",2,2.26461492105588],
["2fna",2,1.74616608518309],
["1v1m",2,1.72516418171750],
["1q8i",2,2.77837172590906],
["1wiy",2,1.79694890335705],
["1nwh",2,1.99631005641983],
["1d8c",2,2.53014637930721],
["1iel",2,1.99240111993536],
["1pw7",2,2.61527927079786],
["1yrr",2,2.16436762570339],
["1qfs",2,1.87303169741084],
["1a05",2,2.50497505604454],
["1sbz",2,2.38961208602002],
["2bls",2,3.51584155278478],
["1hrk",2,2.33938907541504],
["1mzc",2,1.97102524014966],
["1ld7",2,2.09898936954929],
["1fr1",2,2.82018218571137],
["1cdk",2,2.65992026951229],
["1f9g",2,2.93967273378344],
["1loh",2,2.98713342591317],
["1io8",2,3.37645332241164],
["1w9j",2,1.22285941666188],
["1eg5",2,2.23897822551770],
["1cb2",2,1.77286303337389],
["1qk2",2,2.14249411454654],
["2c59",2,2.01625015164687],
["1w19",2,1.99577937110685],
["5bj4",2,2.32085153186487],
["1q45",2,2.39852379222598],
["1d1b",2,3.44886150172565],
["1lt4",2,2.02692451393971],
["1lt3",2,2.10509970486834],
["1u5u",2,2.03053577877869],
["1jcr",2,1.80483740732723],
["1got",2,2.67466026556641],
["1kvo",2,2.59748778530613],
["1d0x",2,3.15644534106429],
["1d0y",2,3.31213411150568],
["1d0z",2,2.81850197301251],
["1tvf",2,1.94600986051225],
["1mmd",2,2.87238172156535],
["1d8d",2,1.97748664233162],
["2avt",2,2.48216573760210],
["1po9",2,2.3654628295781],
["1kz1",2,2.30490858884508],
["1d1a",2,3.53544111038542],
["1wsr",2,1.56910435808370],
["1c3r",2,3.05411226433178],
["1u3a",2,2.65869687532439],
["1m6h",2,1.79549884960092],
["1fwi",2,2.11012432156011],
["1fwf",2,2.12927725537598],
["1fwe",2,2.32380226287281],
["1ht0",2,1.91287555854617],
["1a71",2,2.29385968542072],
["1ju9",2,2.11482694817456],
["1axe",2,2.3965565237957],
["1r6u",2,2.76523050831224],
["1ejr",2,2.15469695424757],
["1eju",2,2.18316305668192],
["1cfm",2,2.55247189906457],
["1bf2",2,2.33625107347829],
["1vgm",2,2.2583820279637],
["1ci8",2,2.22463939125394],
["1kx3",2,2.23135756370120],
["1fnn",2,2.25551370833961],
["1amj",2,2.35764949292056],
["8acn",2,2.42247793019893],
["1ami",2,2.43720635644527],
["7acn",2,2.46547127551420],
["1wbz",2,2.51722687176278],
["2bnl",2,1.64489255636243],
["1l6f",2,2.23956927130892],
["1l6g",2,2.49757496089794],
["1h2g",2,1.74270801137674],
["2clr",2,2.54886924410592],
["1t0m",2,2.45645390112118],
["1fwd",2,2.13967894774662],
["1fwc",2,2.19371276644404],
["1fwa",2,2.18683066135529],
["1fwb",2,2.18683066135529],
["1ejs",2,2.13276728737228],
["1ejt",2,2.17130125401815],
["1fwg",2,2.12409566050398],
["1fwh",2,2.21491990749105],
["1gm8",2,2.17439476637852],
["1a5m",2,2.17761395658287],
["2kau",2,2.24036397004431],
["1wkv",2,2.12505379253993],
["1ha3",2,1.90496048004033],
["1h65",2,2.07605656952175],
["1y8t",2,3.43622945009996],
["1n2t",2,2.09746695785557],
["1eli",2,2.08190932842317],
["1el9",2,2.18195447640315],
["1mbm",2,2.24955560871152],
["1mxx",2,2.01684787939854],
["1p1q",2,2.47551523844266],
["1ku0",2,2.27854538259687],
["1d6i",2,2.28872435052680],
["1ybq",2,2.64587368689351],
["1v7x",2,2.02070735086479],
["1e18",2,1.69679503938244],
["1tpz",2,2.57507781613503],
["1ykj",2,2.91104865742901],
["1ll7",2,2.34279838638538],
["1g38",2,2.37711762683559],
["2fyd",2,2.20454651143626],
["1nmm",2,2.52271979788089],
["1nf5",2,2.58395908070465],
["2fyc",2,2.53566208351625],
["1nqi",2,2.71031613288483],
["1nkh",2,2.844297319554],
["1ids",2,2.26579444725383],
["2b8t",2,1.45572212259715],
["1i80",2,2.35447294955295],
["2ubp",2,2.1718173140676],
["3ubp",2,2.21240150977076],
["1w9v",2,1.61158307642422],
["1y5y",2,2.29472311925072],
["1ahx",2,3.33363040634431],
["1kkc",2,1.89503571200080],
["1m7h",2,2.48485402222920],
["1rrv",2,1.76424461025073],
["1h3f",2,2.04974330178488],
["1b4d",2,2.24113817755009],
["1evk",2,2.46666413973963],
["1jdp",2,3.02137111077745],
["1fp3",2,3.16083216269595],
["1p4j",2,2.37399035738279],
["1uyu",2,1.78118992775645],
["2gpa",2,2.44520804400678],
["1h2v",2,1.98014490085142],
["1lwn",2,2.47589403142542],
["1lwo",2,2.58003270001691],
["1mmv",2,2.38841801229619],
["1p6j",2,2.31232600621529],
["1lzx",2,2.35770926582739],
["1mmw",2,2.42846142409616],
["2aec",2,1.75600313242974],
["2ah9",2,1.83260873055967],
["2aes",2,1.77158952924657],
["2ae7",2,1.98035646172526],
["2cdy",2,1.72918911089445],
["1j3n",2,2.40890259887123],
["1en4",2,1.78115749487504],
["1en6",2,1.94964737578479],
["1h3n",2,1.8394717884167],
["1lxy",2,1.77754392803428],
["2cwx",2,2.5625263394514],
["1ykw",2,2.18192106399082],
["1obl",2,2.28583636078591],
["1ocl",2,2.32460979280476],
["1o9n",2,2.40791777248198],
["2c21",2,1.49120654069004],
["2bkq",2,2.45581373277879],
["1e8y",2,3.18348218218046],
["1aqx",2,3.77462710567623],
["1i83",2,2.35238428415416],
["1pt5",2,2.15677904236081],
["1d1x",2,2.46019151337454],
["1d1w",2,2.55159972746412],
["1dmi",2,2.47979423028133],
["1foo",2,2.43552603467366],
["1z5g",2,1.39840643281005],
["1tcu",2,1.64921358791893],
["1rov",2,3.59653339199594],
["1f61",2,2.01459467036952],
["1aug",2,2.37767988051335],
["1ik3",2,3.7426545632191],
["1k4k",2,3.03128555006265],
["1l6k",2,3.18193118848646],
["1naw",2,2.6392727981889],
["1ub5",2,2.87038079267353],
["1rgt",2,2.28296995732460],
["1o24",2,2.2554405712638],
["1mu7",2,2.18750800264155],
["1c3q",2,2.35339785372847],
["1isz",2,1.96355716834141],
["1it0",2,2.04687840178251],
["1d8h",2,3.51400002467641],
["2az4",2,2.43798616295296],
["1dp4",2,1.6429977176302],
["1rrh",2,2.82905199056913],
["1bzy",2,3.27958206247742],
["2g6x",2,2.62456023702401],
["1hil",2,2.45301466466474],
["1uyw",2,1.91761470980206],
["1rzg",2,2.46301016185633],
["1kxg",2,2.16977757220844],
["1o29",2,2.27607572725128],
["1qbb",2,2.05811682255380],
["1ade",2,2.70225378369635],
["1v3b",2,2.3390632673413],
["1e7u",2,2.76358876723616],
["2btj",2,2.17523836957058],
["1yy8",2,2.57759015300767],
["2c1p",2,2.69335286113599],
["1g7k",2,2.61124865791763],
["2cel",2,1.56406936262958],
["2c2w",2,2.59438718228965],
["1uz1",2,1.90813251875713],
["1v6w",2,2.14176328668959],
["1p48",2,2.07172305164333],
["2one",2,3.38983815373941],
["1lo2",2,2.86015707555584],
["1lo0",2,2.92154475410855],
["1z0h",2,2.91729553460341],
["1jme",2,2.36593512721274],
["1w3j",2,2.11739809035018],
["1p0w",2,1.9718905151514],
["1p0x",2,2.12842824349406],
["1smi",2,2.65002526392200],
["1kh5",2,2.38879906654964],
["1s5z",2,2.70033101866468],
["1e8v",2,2.70818807410173],
["1usr",2,2.70797867309443],
["1e8u",2,2.66650816409351],
["1lob",2,2.58409555196780],
["1get",2,2.12171548319499],
["1uqu",2,3.06934345620640],
["1ew9",2,2.48550380979239],
["1alk",2,3.0696158327773],
["1w44",2,2.44377291010709],
["1uqt",2,2.7924406170014],
["1nue",2,1.86304412026770],
["1u2x",2,2.43478205656883],
["1ik4",2,2.28006904403823],
["1egh",2,2.37422249114727],
["1jmz",2,2.80514581899936],
["1g5y",2,3.32834623515948],
["1fuq",2,2.37003737340852],
["1ktw",2,2.03637754720315],
["2bmh",2,2.8212503621259],
["1cjb",2,2.99793141216872],
["1lk7",2,2.41118254666567],
["1zg9",2,2.70389628574147],
["1zg8",2,2.79639750770767],
["1wuq",2,1.46909156571077],
["2hpd",2,2.35587133734283],
["2acv",2,2.39077300414013],
["2air",2,3.38510838281411],
["1xv2",2,2.11950885656877],
["1z5b",2,1.86104800996940],
["1d3b",2,2.38079633108473],
["1ppr",2,1.74027012651596],
["1hqg",2,2.22118674690123],
["5cna",2,2.33260477205171],
["1qdc",2,2.29145669109688],
["2bra",2,2.9970236992316],
["1ho1",2,2.72947785047691],
["1e3s",2,1.74518781553508],
["1shq",2,2.09903021962776],
["1zp9",2,2.57901119558785],
["1p8x",2,2.68023463134990],
["1js1",2,2.66963816128278],
["1npp",2,3.04762676751078],
["1j4g",2,2.62949938140949],
["1m1g",2,3.49789941479889],
["2shp",2,2.95032796890733],
["2fpz",2,2.33105714564884],
["1dpg",2,2.51706047684879],
["1feb",2,2.84141199515232],
["1r0v",2,2.82073620494139],
["1f9a",2,3.00146681609142],
["1gv4",2,2.55281704281783],
["1qrz",2,3.02719719734612],
["1e55",2,2.41860089239293],
["1ddj",2,3.14168282415456],
["1ulu",2,1.78729616807778],
["1rje",2,1.69682080489903],
["1e8c",2,2.11886615236594],
["1e3w",2,2.06774388462081],
["2afn",2,1.93319624137008],
["1aq8",2,1.88614396117315],
["1ecf",2,2.08093791113019],
["1h0i",2,2.22829656938914],
["1pz2",2,2.48940115608009],
["1h0g",2,2.19120259909464],
["1mzz",2,2.84230280024651],
["1j9r",2,2.10993446474929],
["1rm4",2,2.51823619085822],
["1nba",2,2.17530081291373],
["1as7",2,2.15765609174233],
["1bkc",2,2.96043972773390],
["1sac",2,2.85957635780466],
["1u7t",2,2.26576047339194],
["1d01",2,2.61500355757125],
["1xkl",2,2.46106008605205],
["1n1b",2,1.80239916019354],
["1d0a",2,2.46264515692437],
["1j3b",2,1.89784752357329],
["1b3l",2,2.32608344170051],
["1g6k",2,1.83283642307684],
["1rwb",2,2.36842641242802],
["1yrz",2,2.64525988525542],
["1fpz",2,3.44065058348530],
["1mhy",2,1.88272846128801],
["1rlo",2,2.61146474987775],
["2an1",2,2.24120351544625],
["1cle",2,2.13678515399419],
["1aof",2,1.98421138715748],
["1h66",2,2.82703598030405],
["2fuv",2,1.74375691679092],
["1p2c",2,2.59983154895780],
["1lar",2,2.99723863213626],
["1i7w",2,1.68674652720072],
["1h1s",2,2.96496039035864],
["1h1r",2,3.12898613107934],
["1q4g",2,2.4059810271739],
["2ayl",2,2.49324254808244],
["2ax0",2,1.46836139992982],
["1q85",2,2.81805405362822],
["1nhu",2,2.07446287564695],
["1xtb",2,2.43486660300268],
["1nb4",2,3.06492513552295],
["1kpg",2,2.5537769751715],
["1kph",2,2.43052322908180],
["1lj1",2,2.27104081130162],
["1ksu",2,2.36608612807832],
["1jrx",2,2.89361368962535],
["1jrz",2,2.57918127977798],
["1sr9",2,2.07841933823744],
["1wp4",2,1.94808925562921],
["1xs6",2,2.03849466788065],
["1l2w",2,1.97109145267874],
["1w37",2,2.07120749394068],
["1wzl",2,2.43932514568931],
["2fhj",2,2.22969020408228],
["2fhk",2,1.97363438392694],
["1kgp",2,1.70395146287238],
["1oqu",2,2.06821012597485],
["1sct",2,2.24395594957777],
["1wsj",2,2.64635192823168],
["1xl7",2,1.95590860919827],
["1xmc",2,2.11878472849266],
["1guz",2,2.717677917149],
["1o0s",2,2.69078542164355],
["1rvg",2,2.64860893331645],
["1fcj",2,2.52104716696204],
["1js4",2,1.79322449322940],
["4tf4",2,1.96760580823495],
["2fkz",2,2.39216103074110],
["1vdh",2,1.75305456842623],
["1cb7",2,1.89383849014612],
["1iqx",2,2.17889419539965],
["1ms5",2,2.04678634200585],
["1ui7",2,2.47267803774024],
["1wmp",2,2.00777506915413],
["1olz",2,3.41675029038300],
["1ms8",2,1.89624954008068],
["1zow",2,2.66637405008323],
["2sqc",2,1.97704235323559],
["1mws",2,2.56902759316075],
["1f07",2,2.07812155025660],
["1s0b",2,2.34658322634142],
["1g9b",2,2.22045386477685],
["1vlg",2,1.58270583683613],
["1np3",2,2.00630597701756],
["3pga",2,2.87825087415347],
["1t8q",2,2.52349589805448],
["1n7z",2,2.53681700748068],
["1tzk",2,2.40021115497289],
["1tyz",2,2.10451436472172],
["2fm0",2,1.92046455799202],
["1oyn",2,2.17757078834104],
["2czc",2,2.67540574191781],
["1or0",2,2.00931067002809],
["1sgx",2,2.24726243579623],
["1gg1",2,2.54193529455584],
["1trk",2,2.23229175260948],
["1f2d",2,2.93014583897946],
["1s9f",2,2.28026604385438],
["1jdv",2,1.87854683979261],
["1d00",2,2.72366918844102],
["1v3k",2,1.90224382901036],
["1i75",2,2.01900103071057],
["1ukq",2,2.18766770619043],
["1v3m",2,2.11451916294771],
["1v3j",2,2.28666261990701],
["1ded",2,2.6378445025243],
["1usk",2,1.45522921188237],
["1h84",2,2.22891280586561],
["1h86",2,2.21952015332557],
["1x0p",2,2.06473176997057],
["2tod",2,2.98811852146416],
["1v7c",2,2.11612569881696],
["1ex0",2,2.56053113971552],
["1k9s",2,2.09885766158482],
["1ecp",2,2.79728332791767],
["1itk",2,1.81507795199066],
["1pl6",2,1.92824591203894],
["2d0o",2,2.24145305005066],
["1vpn",2,1.82713391354681],
["2b2s",2,1.14794022891552],
["2fkp",2,2.12711251466064],
["2cca",2,1.91820023955047],
["1tjl",2,3.44802665687386],
["1pvn",2,1.95958301156696],
["1spu",2,2.77036111062274],
["1qak",2,2.53606086473196],
["1oac",2,2.56440583726734],
["1gy8",2,1.92444821327127],
["1ewg",2,3.37058318903954],
["1tk3",2,2.91950125488637],
["1vj0",2,1.54911894555882],
["1t7l",2,2.37618423472799],
["1gc2",2,2.67319226638401],
["1o8u",2,1.70177055931896],
["1bto",2,2.14497813783716],
["1f8g",2,2.43403188697935],
["1n18",2,1.71782649100059],
["1j20",2,2.47189936246976],
["1h5n",2,1.82390953687327],
["2f2s",2,2.82241173358714],
["1xet",2,1.95823939790027],
["2cx9",2,2.18404281595633],
["1xpk",2,2.14220192727921],
["1xpl",2,2.18678982601623],
["1e60",2,2.07502739404508],
["1sp8",2,2.70251870556388],
["1dm3",2,2.83050592497798],
["1u0w",2,2.67855989457443],
["1w1x",2,2.4689982447213],
["1sgz",2,2.30351372011143],
["1oj7",2,1.56097136069223],
["1wa5",2,2.65784531903999],
["1xn3",2,2.41109271326877],
["2fja",2,2.20318208568811],
["1l5v",2,2.16429200064937],
["1ydg",2,1.64734611855043],
["1dqa",2,2.48273996238433],
["1lp9",2,2.57829101562199],
["2bz3",2,2.15300745544123],
["1h4f",2,2.29612454471202],
["2byx",2,1.96685825821416],
["1m3y",2,3.34263769824294],
["2bb6",2,2.91855219791947],
["1k8k",2,2.73650502707381],
["3tmk",2,3.15487246951846],
["1twi",2,2.15742495680830],
["2avw",2,2.40581740537738],
["1muu",2,2.35214444518090],
["1w7v",2,1.13201929873258],
["1jdf",2,2.02080990149525],
["1ecq",2,3.03858598421126],
["1gu0",2,2.08672352384449],
["1ec9",2,2.48163539418735],
["1dce",2,3.29987146209507],
["1tjw",2,2.19837622269791],
["1tjv",2,1.91824484689634],
["2bzd",2,2.44420412380415],
["1wqa",2,2.78601612758748],
["2b1x",2,2.40507980532479],
["1kxt",2,3.28979045675184],
["1f8r",2,2.09665163448448],
["1ct9",2,3.26159043938159],
["1y4z",2,2.43441925710406],
["1dgh",2,2.46107242745093],
["1hhs",2,2.33079477203226],
["1uvm",2,2.4770123332736],
["1uvl",2,2.63367678591900],
["2ahv",2,1.96037850142056],
["1j11",2,2.31626317157784],
["1t5r",2,2.37245356322813],
["1xvf",2,2.47116137815731],
["1xvc",2,2.51559519258937],
["1ozh",2,2.23178064106191],
["1o94",2,2.16957721539506],
["1m5h",2,2.80140478062228],
["1h6k",2,2.15425705154051],
["1x0r",2,3.01553038540352],
["1wpb",2,1.77058933111150],
["1m3d",2,2.51857903350473],
["1pmm",2,1.85976709691055],
["1req",2,2.38124334199662],
["1w85",2,1.97712900549663],
["1eq2",2,2.69226183191599],
["1h8e",2,2.57291022892382],
["1tqy",2,2.72889543284790],
["1r27",2,2.46273919870964],
["1m5q",2,2.47165357612684],
["1f8s",2,2.09290628617487],
["1c30",2,2.90574826285882],
["1k32",2,2.59787787907132],
["1ti6",2,2.46869132343140],
["1vlf",2,2.44478709957434],
["1sx3",2,2.36319495024577],
["1kp8",2,2.75138585109695],
["2b9v",2,2.11316652687182],
["2ayv",2,1.94289582489208],
["1yzv",2,1.83226252778185],
["1u1d",2,2.12099808927253],
["1u1e",2,2.21709850476586],
["1rfx",2,2.13362455045723],
["1t5h",2,1.74029449023453],
["1vji",2,2.60743790021841],
["2a9a",2,1.91999566617955],
["1e6h",2.01,3.13035685920394],
["2d9r",2.01,2.62906899141389],
["1bc7",2.01,2.97543585121911],
["2esw",2.01,2.75671642884284],
["1tjn",2.01,2.68116011065414],
["1ljl",2.01,1.74493262559056],
["2atr",2.01,2.45377332201772],
["1icw",2.01,2.67407270129749],
["2apl",2.01,1.97394129586761],
["1cx6",2.01,2.28843612428093],
["1t6h",2.01,1.92336454432203],
["1gwg",2.01,2.24410803008126],
["1ebz",2.01,1.65153431118695],
["1cuv",2.01,2.51490920545187],
["2g7g",2.01,1.83950491768275],
["2azc",2.01,2.21035475684325],
["1vjg",2.01,1.95476355419677],
["1jc9",2.01,1.96857909383138],
["1yb2",2.01,2.1376504179716],
["2bsi",2.01,2.61911778333304],
["1xvs",2.01,2.99787287136344],
["1wt9",2.01,2.42418675984408],
["1n2f",2.01,2.11829904356534],
["1qn2",2.01,2.74741723425268],
["1dp2",2.01,2.29302056174031],
["1xt4",2.01,2.17166305942911],
["1i79",2.01,2.25433020483254],
["2fvg",2.01,1.77229546567548],
["1edb",2.01,2.51877904311416],
["1lwy",2.01,2.67337482591095],
["1t2c",2.01,1.8941073137243],
["1yw2",2.01,3.64589437679829],
["1w81",2.01,2.85478468250582],
["1xzk",2.01,2.13275861331829],
["1vec",2.01,2.4172930932835],
["1zl9",2.01,2.12130048630747],
["1m4n",2.01,2.20388415359191],
["1u13",2.01,1.92806578059861],
["1li4",2.01,2.51042598719445],
["1xaf",2.01,2.49192440351474],
["1wo2",2.01,1.70225706333284],
["1ua3",2.01,1.97110089689126],
["1l9y",2.01,2.04643433663469],
["1oj4",2.01,1.95516025657114],
["1u45",2.01,1.97204982902160],
["1mw0",2.01,1.87765104746553],
["1uvz",2.01,2.56535780310411],
["1yxo",2.01,2.28577178764254],
["1s4p",2.01,2.29646876905625],
["1s4o",2.01,2.35366143980039],
["1s4n",2.01,2.50636994311321],
["1yxq",2.01,2.17948315982446],
["1vmk",2.01,1.87968931763227],
["1ddg",2.01,3.20215097957232],
["1m9q",2.01,1.78577787597415],
["1m9k",2.01,2.05518951916138],
["1wuo",2.01,2.65169438921638],
["1gq3",2.01,2.98470058043478],
["2ae8",2.01,2.45527875671527],
["1nqo",2.01,2.14003104527647],
["1evu",2.01,2.8585321087168],
["2av6",2.01,2.21684512713836],
["2af6",2.01,2.11938156135009],
["1h7x",2.01,2.07790967829246],
["2a5z",2.02,2.09580212266722],
["1ylq",2.02,2.56619412552061],
["1qx8",2.02,2.37045848379965],
["1zp8",2.02,2.83990012859885],
["1zpa",2.02,2.95269709125716],
["1b92",2.02,2.27300373986759],
["105m",2.02,2.63089189781375],
["1l0k",2.02,2.39553343996111],
["1j84",2.02,2.55842865078472],
["1e20",2.02,2.82222757185689],
["1u6q",2.02,2.34749061882435],
["1xpz",2.02,2.31481445695372],
["1vm1",2.02,2.34555970913507],
["1v75",2.02,2.119404270883],
["1way",2.02,1.66758010643098],
["1dk7",2.02,2.33658330271672],
["1ds4",2.02,2.54561607263278],
["2ng1",2.02,2.89167155812817],
["1zdw",2.02,1.97427413284863],
["1d0k",2.02,1.71553944580823],
["1cbk",2.02,2.22248240166545],
["2a5f",2.02,1.90473444920242],
["1svg",2.02,2.0270462536764],
["1j3p",2.02,2.51899069221015],
["1yzh",2.02,2.32976850230441],
["2b4j",2.02,2.13828588559842],
["1rd5",2.02,2.27855742729084],
["2fv9",2.02,2.21707274359156],
["1ven",2.02,2.54287812602856],
["1va5",2.02,2.32776612897285],
["1st4",2.02,2.84552319345581],
["1khf",2.02,2.12999463008818],
["1wx5",2.02,3.35784009591191],
["2amx",2.02,2.04334096432438],
["1z8h",2.02,1.88317026813228],
["1fqj",2.02,2.00066971984502],
["1uwq",2.02,2.07551135316722],
["2byn",2.02,2.09701534280285],
["1q1g",2.02,2.23958439946995],
["2azb",2.03,2.40179354417797],
["1w40",2.03,1.85249244926512],
["2cbm",2.03,1.60936596075698],
["1zr8",2.03,2.50921050312822],
["1c10",2.03,2.61700596208329],
["1qtk",2.03,2.77841407602913],
["1ocs",2.03,2.13315554552387],
["1jd3",2.03,2.47616907977145],
["1xln",2.03,2.16974082165382],
["1k24",2.03,3.56554759382881],
["1i3v",2.03,2.79914340578925],
["1an1",2.03,2.10166142364922],
["1sd1",2.03,1.77828901399237],
["1dsp",2.03,2.36340198497494],
["1dso",2.03,2.60157137451536],
["1ng1",2.03,2.38940054474052],
["1mcx",2.03,1.95755637426422],
["1z3a",2.03,2.77446112229028],
["1b2z",2.03,2.34016282890803],
["1f3l",2.03,2.83597871380376],
["1alw",2.03,2.39406799977438],
["1geb",2.03,2.54879847486580],
["1md3",2.03,2.54762888005419],
["1px7",2.03,2.15828478974929],
["1yye",2.03,2.76296613270318],
["1k6s",2.03,2.32380478593392],
["1sw3",2.03,1.47688342820763],
["1jfh",2.03,1.81820944690152],
["1xh1",2.03,2.45855877661047],
["3erd",2.03,2.60609611898347],
["1qqt",2.03,2.44774964417594],
["1y5j",2.03,2.55590723574773],
["1idq",2.03,2.09128134556414],
["2kfn",2.03,2.91366140366445],
["2kfz",2.03,2.92047342824964],
["1rys",2.03,2.34929967957692],
["1lga",2.03,2.04544313586323],
["1z6q",2.03,2.47240206717891],
["2ane",2.03,2.9633965005316],
["1qwu",2.03,1.89846782423962],
["1tqv",2.03,2.06454646466047],
["1tqu",2.03,1.99604449498616],
["1bvy",2.03,3.02890193314777],
["2aj3",2.03,3.00009178518231],
["2fm5",2.03,2.02908590781318],
["1q32",2.03,2.36041885822862],
["1fe8",2.03,2.63677963972590],
["1g8j",2.03,1.97857252590356],
["2min",2.03,2.32389177099232],
["3min",2.03,2.40951418312098],
["1fz3",2.03,2.3312312500967],
["1mj0",2.03,2.25660979469157],
["2b8j",2.03,1.78391173678501],
["1h34",2.04,2.79656013624938],
["2avp",2.04,2.25680823484004],
["1iu9",2.04,2.14668833158263],
["1qll",2.04,2.66259460788815],
["2fgn",2.04,2.31213581100492],
["2ars",2.04,1.85285409315296],
["1g1d",2.04,1.96725856361965],
["1jtk",2.04,2.08369809891495],
["1riw",2.04,2.30188908343212],
["1d3d",2.04,2.5808922089132],
["6prn",2.04,2.08816213950704],
["1s7c",2.04,2.41796128729124],
["1cef",2.04,2.18701245726372],
["1khz",2.04,2.57899269360974],
["2a7v",2.04,2.61840080618728],
["1g09",2.04,2.62895252964256],
["1g0a",2.04,2.70916641783785],
["1ghq",2.04,2.52280337064917],
["2g8l",2.04,1.23193073509157],
["2trs",2.04,2.86713969856799],
["1nwc",2.04,2.32047696782154],
["1x15",2.04,2.10800721557850],
["1fyh",2.04,2.44258722655916],
["2a92",2.04,2.33137663447211],
["2bbd",2.04,2.48759049025875],
["1dyu",2.04,2.58988088528084],
["1smh",2.04,2.01564214664173],
["4ame",2.05,1.90347328847593],
["1b6w",2.05,2.1441595877728],
["2psr",2.05,1.95692443560507],
["1ub9",2.05,2.72122738501122],
["2fls",2.05,1.86507926715531],
["1crj",2.05,2.87139219037171],
["1gm4",2.05,1.77697890912475],
["2c5k",2.05,1.57836336058815],
["1vpz",2.05,1.99107504290044],
["1ugm",2.05,2.06136634332606],
["1duc",2.05,2.10761185787250],
["1dmn",2.05,2.80340913567943],
["1t6a",2.05,1.33919893002603],
["1e83",2.05,1.84353948774262],
["1fgz",2.05,2.21184358704587],
["1joi",2.05,1.79993249696623],
["1d1m",2.05,2.81637209815861],
["1nae",2.05,2.13609444609505],
["4lyo",2.05,2.35273081180366],
["1hzi",2.05,2.49729344453335],
["1b56",2.05,2.44363178377882],
["1a3u",2.05,2.83538029697077],
["2enb",2.05,3.25298259635985],
["1vsf",2.05,2.75572277668389],
["2fzt",2.05,0.960569474694351],
["1d3f",2.05,2.14059287393092],
["1l77",2.05,2.12447733143541],
["1cuq",2.05,2.45943548111840],
["1ky1",2.05,2.57278701245253],
["1cu5",2.05,2.59029436319875],
["1wlf",2.05,1.95468253269004],
["1e7z",2.05,2.67749542862948],
["1dat",2.05,2.27697351892437],
["1ilw",2.05,2.54325607465218],
["1fmz",2.05,2.55087057954762],
["1s30",2.05,1.98721541465516],
["1z4q",2.05,2.19884094900875],
["1cpi",2.05,1.96096688538159],
["7lpr",2.05,2.45118918565077],
["2bsm",2.05,1.94975289422010],
["1bxi",2.05,2.80238660554685],
["1aya",2.05,2.75278613600602],
["1vdf",2.05,3.28760947081948],
["1zgh",2.05,1.02046866988409],
["1fnz",2.05,2.22770607347131],
["1hb0",2.05,1.7919956167292],
["1uak",2.05,1.93503439103134],
["1ub0",2.05,2.01381014411183],
["2fpd",2.05,2.23925926788244],
["1txz",2.05,2.32709761419195],
["2ffz",2.05,2.44535640635298],
["1jvt",2.05,2.57316818653909],
["1lbf",2.05,2.54181826631595],
["2f5o",2.05,2.49087571072764],
["1sef",2.05,2.8551157216043],
["1vlz",2.05,1.92354003542156],
["1q3b",2.05,2.21835301139920],
["1cnh",2.05,2.09039214757667],
["1xeu",2.05,2.90182673462529],
["1ypu",2.05,2.1686087548759],
["1nw5",2.05,2.22298015692909],
["1f56",2.05,2.16492752766285],
["1h4k",2.05,2.17343916461042],
["1luf",2.05,1.82316121640367],
["3btw",2.05,1.89773099649408],
["2bzj",2.05,1.55138458041098],
["1ckp",2.05,2.43325670735950],
["1q03",2.05,1.88823792306508],
["1em9",2.05,1.70646865114163],
["2bij",2.05,1.96490483092264],
["1nfu",2.05,2.95494500675533],
["1ffh",2.05,1.46203976964905],
["1ns6",2.05,1.55739323062004],
["1ym5",2.05,2.27658714766235],
["1kag",2.05,2.35316879212486],
["1k0z",2.05,2.60865028451723],
["1sxz",2.05,1.71616795318747],
["1g9y",2.05,3.00301784911701],
["1yzt",2.05,1.60561826177068],
["1cet",2.05,2.14763988258244],
["1obg",2.05,2.30045561871946],
["1r9q",2.05,1.56182129152820],
["1rkp",2.05,2.18009901285636],
["1yvh",2.05,2.49090108597259],
["1m3h",2.05,2.78551077609839],
["1f44",2.05,3.32869904259448],
["1dsn",2.05,3.33021397744428],
["1gyd",2.05,2.15049688523859],
["1tli",2.05,1.89465759307569],
["1bc1",2.05,3.18230480776504],
["1bns",2.05,2.86138194955493],
["1gxo",2.05,2.11881599202947],
["1vjz",2.05,1.49381425587225],
["1y7m",2.05,2.73240556088187],
["6mht",2.05,2.03184941839163],
["1t6q",2.05,1.37982732106897],
["1n84",2.05,2.28558936754716],
["1e82",2.05,2.00875678746251],
["1e81",2.05,2.58018367443485],
["1e80",2.05,2.13766308329028],
["1e5o",2.05,2.57058384565864],
["1bq5",2.05,2.81437787219935],
["1ftf",2.05,2.3216556191264],
["1v72",2.05,1.94283185755481],
["2poo",2.05,2.79145735836388],
["1xh5",2.05,1.95426664087605],
["1jqa",2.05,1.90808638437191],
["1bd9",2.05,1.69293629810253],
["1agd",2.05,2.17355423307073],
["1uz5",2.05,2.42474702492345],
["1rc0",2.05,1.85433335648805],
["1jy5",2.05,1.75644001696905],
["4hoh",2.05,1.92009687273275],
["1dkq",2.05,2.50137662170072],
["1d7s",2.05,2.84755457294348],
["1h5z",2.05,2.19347041238519],
["1dq2",2.05,2.67294603102647],
["1u8x",2.05,2.56736401264199],
["2ez6",2.05,2.24386505744252],
["2f5a",2.05,2.92555913216548],
["2bbw",2.05,1.92479698620371],
["2b51",2.05,2.44922912732771],
["1tj2",2.05,1.98644783906585],
["2a6q",2.05,2.12041740262281],
["1k89",2.05,2.99260968298358],
["1a6r",2.05,2.17929975680912],
["1oy3",2.05,3.11947065026919],
["2pka",2.05,3.09342930830416],
["1ro8",2.05,2.46853211203072],
["1tqn",2.05,3.28782016294595],
["2bbs",2.05,2.37640871709283],
["1qae",2.05,2.29651751659391],
["1q8q",2.05,1.55733948417940],
["1q8s",2.05,1.72906019274318],
["2ftw",2.05,1.95515030965038],
["1b95",2.05,2.48632994108614],
["2ff6",2.05,2.07496653396781],
["1o5d",2.05,2.84271851309996],
["2a6r",2.05,2.24418516383108],
["1lnx",2.05,2.02051496989503],
["1sz6",2.05,2.60312350600061],
["1w6r",2.05,2.4058739512230],
["1g7c",2.05,2.23657229847553],
["1qid",2.05,2.44752574150838],
["1nh6",2.05,1.70121109675043],
["2g7z",2.05,1.80637182430917],
["1ufv",2.05,2.02316886355652],
["1okk",2.05,1.52102669527921],
["1bro",2.05,2.34534623999374],
["2tss",2.05,1.80394728603599],
["2a6l",2.05,1.59557299362343],
["1wpm",2.05,2.01135657406024],
["1wpp",2.05,1.64101663254456],
["1i7d",2.05,2.72922022857047],
["1i2o",2.05,1.60008707689753],
["1i2p",2.05,1.67819298041384],
["1i2q",2.05,1.71690416555507],
["1i2n",2.05,1.57207508269531],
["2afb",2.05,1.75135040690412],
["1dx9",2.05,2.14648551678515],
["1rdz",2.05,2.70127414865986],
["1ly8",2.05,2.18565931257975],
["1b7g",2.05,2.05854729434537],
["1biq",2.05,2.86504780646181],
["1lt8",2.05,3.20229429866282],
["1q8y",2.05,2.49850645967034],
["1q2x",2.05,1.81417399241009],
["1w9k",2.05,1.99999621296730],
["1io9",2.05,3.36136033834554],
["1ee0",2.05,2.34228325150650],
["1nis",2.05,2.48627018324854],
["1nit",2.05,2.48930388356219],
["1fgh",2.05,2.42051778917341],
["1aco",2.05,2.46705777437688],
["2av7",2.05,2.01876082229484],
["1ajq",2.05,2.29820194509099],
["1nqv",2.05,1.39737307683254],
["1s32",2.05,2.57422164162928],
["1efc",2.05,2.86666328398641],
["1un7",2.05,2.48888122593701],
["1wkb",2.05,3.03824591539266],
["2b67",2.05,2.44974038244204],
["1lzz",2.05,2.39336339538234],
["1m00",2.05,2.4299028752191],
["1zzr",2.05,2.43767976456388],
["1k0g",2.05,2.83305008582061],
["1ed6",2.05,2.65638452924994],
["1vl0",2.05,1.62288281909864],
["1mu9",2.05,2.4396361136075],
["1d8i",2.05,3.15987146686496],
["1oe9",2.05,1.88521427140730],
["1xqc",2.05,2.34756655969566],
["1p0v",2.05,2.19931940222237],
["1lod",2.05,2.63168165470480],
["1xey",2.05,1.91125370182016],
["1jju",2.05,3.07981964455013],
["1eum",2.05,2.53874572669947],
["1q7b",2.05,2.02106533406991],
["1hxj",2.05,2.28274247316924],
["1rm0",2.05,2.75017513175081],
["2fpo",2.05,2.31659368706491],
["1qi9",2.05,1.81296383372948],
["1ym2",2.05,2.11306407786405],
["1go4",2.05,2.92155955445948],
["2hbs",2.05,2.23521456753492],
["1z0e",2.05,3.26861733758615],
["1o6u",2.05,1.73535175920286],
["1qy9",2.05,1.56286126243832],
["2aa3",2.05,2.35569035614076],
["1q1l",2.05,2.73671148829457],
["1o17",2.05,2.84733286091546],
["1lw5",2.05,1.80011210281378],
["1kev",2.05,1.94947450692092],
["2b2q",2.05,1.33997088870018],
["1lvu",2.05,2.74858824760539],
["1yaa",2.05,2.45829801260086],
["1uz6",2.05,1.98045908629163],
["2bpl",2.05,2.93680562034372],
["1z11",2.05,2.56913075513605],
["2bys",2.05,1.67717723877034],
["1fz6",2.05,2.55748558073294],
["3pch",2.05,2.62192500090581],
["1nf4",2.05,2.16019756310929],
["1h6d",2.05,2.52110476712947],
["1uw9",2.05,2.14483319697351],
["2gdb",2.06,2.58896685396836],
["1a0b",2.06,2.08856089637898],
["1wdg",2.06,2.87376224393156],
["1ujb",2.06,1.27173858598931],
["1d2y",2.06,2.35936097288600],
["1z22",2.06,1.77014269374561],
["1yzn",2.06,2.05280913482002],
["1vr3",2.06,1.70613416050233],
["1la1",2.06,2.37186395342005],
["1cqv",2.06,2.69859229165824],
["1laf",2.06,2.01679771247447],
["1lah",2.06,1.78826694427455],
["1lag",2.06,1.83114036005077],
["1jt9",2.06,2.45155015291934],
["11ba",2.06,2.34479240015017],
["1hw4",2.06,2.75123971776573],
["1ym0",2.06,1.55817930672922],
["1t01",2.06,2.76593574799704],
["1tfr",2.06,2.67349684357482],
["1a5g",2.06,3.24058878404233],
["1vmd",2.06,1.81241518769067],
["1qf2",2.06,1.86377631431209],
["1qp1",2.06,3.08753841536109],
["1gza",2.06,2.15864840202302],
["2f9k",2.06,1.73279401299995],
["1pu2",2.06,1.76317951482238],
["1oza",2.06,2.18187514126332],
["1pqp",2.06,2.17470407704456],
["1fvj",2.06,1.90341863650135],
["1vgk",2.06,2.37764119354876],
["1i0i",2.06,2.08111925476944],
["1ebk",2.06,3.12855888765845],
["1ds7",2.06,2.78513235725329],
["1fx6",2.06,2.29877137053060],
["2fzq",2.06,2.12878379320738],
["1ee1",2.06,2.05023856992956],
["1vep",2.06,2.62350434240029],
["1crl",2.06,2.14947370809616],
["1xlz",2.06,1.85819746058475],
["1kvm",2.06,2.07498931151064],
["1cm7",2.06,3.51479171312455],
["1p4h",2.06,2.49597681881577],
["2b0o",2.06,2.56577905514665],
["1xjq",2.06,2.47187733448129],
["3pce",2.06,2.65324325746879],
["1ykk",2.06,2.0124517994947],
["1pga",2.07,2.6177909376509],
["1uo5",2.07,2.64085286681654],
["1unu",2.07,2.46535153636375],
["1unt",2.07,3.30852367847174],
["1e9m",2.07,1.42805183299751],
["103m",2.07,2.46229258850342],
["101m",2.07,2.61841927322863],
["2gf4",2.07,2.14261366675701],
["1yu9",2.07,1.82348996891719],
["1jnw",2.07,2.13718994524054],
["1q06",2.07,2.21329584248887],
["1t63",2.07,2.13447278554705],
["1b5g",2.07,3.36311338903637],
["1d4p",2.07,2.56460627855168],
["1yzi",2.07,2.94090296897003],
["1mni",2.07,2.76408031245159],
["1gwo",2.07,1.58784000979515],
["1sv0",2.07,2.48000023386114],
["1jiv",2.07,2.33649982050158],
["1r2v",2.07,3.04339169728789],
["1mdz",2.07,2.18448618695726],
["1qlh",2.07,2.17503415589638],
["1u4h",2.07,2.15182813694885],
["1yu1",2.07,2.10557758434448],
["1udx",2.07,2.50947449612519],
["1ajo",2.07,2.01740064860766],
["1olt",2.07,1.96164899271984],
["1usb",2.07,2.30588893388066],
["1wd4",2.07,1.76778219533801],
["1bfn",2.07,2.22643487418731],
["1q4n",2.07,1.86250996948804],
["2d42",2.07,2.31354071274748],
["1xq7",2.07,2.824162593778],
["1vl8",2.07,1.52977718649888],
["2lyn",2.07,2.88757727730334],
["2f4b",2.07,2.91173005569248],
["1y2z",2.07,2.51483328390355],
["2qil",2.07,2.05869556939833],
["2ddh",2.07,2.41229805076390],
["1kxr",2.07,2.51848866012851],
["1yz0",2.07,2.83921693562258],
["2a3c",2.07,1.45822826026033],
["1s2q",2.07,1.76901373821222],
["2byp",2.07,1.70447589571491],
["1fz0",2.07,2.34253579860204],
["2c12",2.07,2.23396644421809],
["2a3z",2.08,2.05410720958257],
["1z27",2.08,2.64798777637875],
["1u8u",2.08,2.3263367308305],
["1a6p",2.08,2.39178355299644],
["1crc",2.08,3.87425342921672],
["1gy0",2.08,2.3525927731603],
["1yr7",2.08,3.15679633101392],
["1w8p",2.08,2.58052378608598],
["2a5a",2.08,2.95112531697344],
["1aa7",2.08,2.32569487309594],
["1gt5",2.08,2.48108159939929],
["1mww",2.08,3.06590809813242],
["5cpp",2.08,2.36954165765155],
["1xk3",2.08,2.06582036482349],
["1xk1",2.08,2.69290108596264],
["1rlu",2.08,1.80444476006601],
["1d8y",2.08,3.10180204411575],
["1q13",2.08,3.18894328813863],
["2cvq",2.08,1.99199617394213],
["2fp4",2.08,2.38267783954937],
["1yx2",2.08,2.74509307216012],
["1e3i",2.08,2.28042505349476],
["1yfs",2.08,2.62734451214301],
["1tzm",2.08,2.55687193263385],
["1w20",2.08,2.35988911846702],
["1w21",2.08,2.35988911846702],
["1zmd",2.08,2.17925983225695],
["2f8m",2.09,1.94244421262276],
["107m",2.09,2.34144852561709],
["1nqy",2.09,2.41309597488879],
["1ya9",2.09,2.56321683652407],
["1u4e",2.09,3.01106164424234],
["1dzu",2.09,2.15304709477582],
["2g43",2.09,2.38113296280307],
["2amy",2.09,2.36672391340526],
["5est",2.09,2.26418104595566],
["1le7",2.09,2.32432067229605],
["1zb2",2.09,1.47430480375246],
["1if6",2.09,2.28248473618057],
["1r7t",2.09,2.19564268142492],
["1r7v",2.09,2.31002827342704],
["1yjq",2.09,1.84961782253526],
["1ko1",2.09,2.81134568486886],
["2alu",2.09,3.01838684660329],
["2b41",2.09,3.11629057650742],
["1a59",2.09,2.43773832183208],
["1zli",2.09,2.28663757750955],
["2f96",2.09,1.45931413064784],
["1rfd",2.09,2.18165638628115],
["1hkd",2.09,2.26675394647292],
["1vr4",2.09,3.10989339017565],
["1b9n",2.09,2.67502258296744],
["1cxk",2.09,2.15652207286664],
["1z6b",2.09,2.28667111166471],
["1dfi",2.09,2.68633839041273],
["1sc6",2.09,2.90070597071798],
["1rp7",2.09,2.91836761175755],
["1rrl",2.09,3.25413423336930],
["1vjh",2.1,1.99367248480251],
["1ybm",2.1,1.83776188458030],
["1vjq",2.1,2.47888738936977],
["2ghl",2.1,3.36582445384193],
["1enh",2.1,2.10057830027454],
["1kna",2.1,1.85717760013518],
["1i5y",2.1,1.73524015027532],
["1d1l",2.1,2.60368982173030],
["1qm7",2.1,3.37946879674323],
["6ame",2.1,2.29534939049281],
["1qr8",2.1,3.51309206231283],
["1lr8",2.1,2.40754847798060],
["1wvn",2.1,1.80327763488123],
["1bcg",2.1,2.45459818218952],
["1kiv",2.1,3.74066859699484],
["2fi0",2.1,2.28588411585416],
["1blu",2.1,2.62522207968852],
["1es1",2.1,2.04234176582645],
["1a32",2.1,3.1050522911093],
["1zaa",2.1,2.78443484886885],
["1cos",2.1,3.57464766725613],
["2bs5",2.1,1.53889170087772],
["1uvb",2.1,3.14152591041681],
["2fb0",2.1,1.45396432820873],
["1j1v",2.1,1.83368622605741],
["1h59",2.1,2.07802522662818],
["1mb1",2.1,3.36571824941489],
["1kc2",2.1,2.64366355085243],
["1bm2",2.1,1.96111853264956],
["1rzx",2.1,1.98415748139467],
["1tze",2.1,2.45666515712009],
["1wwb",2.1,3.26834624355335],
["1eru",2.1,1.74133106829733],
["1auc",2.1,2.86729034479182],
["1nn7",2.1,2.34161442251278],
["1b0t",2.1,2.43753218932246],
["1a6l",2.1,2.39573792024062],
["1frk",2.1,2.36753635800137],
["1fda",2.1,2.29950744530315],
["1fri",2.1,2.65604939412628],
["1axq",2.1,2.60204686800006],
["1xg8",2.1,2.77419921694869],
["2coq",2.1,3.13315364316159],
["1f1w",2.1,2.57858467263331],
["2cwp",2.1,2.6271600002181],
["1bkl",2.1,3.17885517720417],
["1zox",2.1,2.04184746867816],
["1wy9",2.1,2.41119697743818],
["1o3x",2.1,3.23199358911823],
["1ed1",2.1,2.64898587028925],
["3rhn",2.1,1.95036520772852],
["1ne8",2.1,1.68970707799683],
["1rmd",2.1,2.75671939733739],
["1y28",2.1,2.92138615839069],
["1od9",2.1,2.62867581720106],
["2awf",2.1,1.84355495031658],
["1un4",2.1,2.09695227389666],
["1gs3",2.1,2.86423846319398],
["3bp2",2.1,3.1296335293573],
["1gcl",2.1,3.87831042527139],
["1gv7",2.1,2.65323322122815],
["1w6y",2.1,2.25452690182018],
["1kqu",2.1,2.30858812196552],
["1pod",2.1,3.42252407209226],
["4rsk",2.1,2.19986936553297],
["1rbn",2.1,2.14350248814551],
["2ch9",2.1,2.13967768178020],
["1u9r",2.1,2.00369070399147],
["1cpr",2.1,1.79944239633568],
["1jpo",2.1,2.54173784995000],
["4lym",2.1,3.10032736621326],
["1xei",2.1,3.90477041569681],
["1xej",2.1,4.20739534252566],
["2es0",2.1,1.27668856608533],
["1rem",2.1,1.86326817875719],
["1gev",2.1,2.5445537052966],
["1tr5",2.1,1.56171463689015],
["1u8b",2.1,2.65862995914918],
["1yiv",2.1,2.38139453199762],
["1dc9",2.1,2.02756526599705],
["2hmb",2.1,3.01313745360274],
["1gu5",2.1,2.17471847263703],
["1cm9",2.1,2.77340191834209],
["1w9w",2.1,2.27804987216291],
["5nuc",2.1,2.70766516010391],
["1aex",2.1,2.80216222697127],
["1a3t",2.1,2.8087358006578],
["1crb",2.1,1.76302697934966],
["1wjg",2.1,2.25393851935871],
["2fbi",2.1,2.52785215563437],
["1h0r",2.1,1.972637265197],
["1a3k",2.1,1.94669302415043],
["2cbs",2.1,2.04258081932287],
["1xcv",2.1,2.27617101746503],
["1jwf",2.1,2.67861243395548],
["2fop",2.1,2.47904451866956],
["1n05",2.1,2.37712323789319],
["1r2e",2.1,2.65901903283168],
["1k53",2.1,2.05556942253739],
["1xjc",2.1,2.00981476277708],
["1qqh",2.1,2.61544858908233],
["1ngn",2.1,2.64004367490610],
["1etk",2.1,2.14315518116463],
["1vsj",2.1,2.89324005196325],
["1qj9",2.1,3.23250552911295],
["1hhq",2.1,2.71241506039239],
["1nsp",2.1,2.26184986077916],
["1f3g",2.1,3.45233371228498],
["1gyj",2.1,2.34131211664963],
["1b5l",2.1,2.76234725535253],
["1ibb",2.1,2.14356633160825],
["1bzo",2.1,2.77383667106240],
["1q7h",2.1,2.17074689992567],
["1j6v",2.1,2.01573954038879],
["5i1b",2.1,3.08296220089054],
["3sod",2.1,3.1783070307288],
["1f1d",2.1,2.11190939167965],
["1t4q",2.1,2.63115323133402],
["1twe",2.1,2.84795700163537],
["1too",2.1,2.81772220924848],
["2a11",2.1,3.25405241322783],
["1cp5",2.1,2.58752228107585],
["1ufp",2.1,2.28506783111157],
["1ch5",2.1,2.94048530048448],
["1phr",2.1,2.22738598037805],
["1fyl",2.1,2.28666479317474],
["1v8l",2.1,1.77886974658246],
["1w8i",2.1,1.70519476948795],
["1g5r",2.1,2.59361450033853],
["205l",2.1,2.73373583622316],
["1znh",2.1,2.83389573608918],
["1mnc",2.1,2.66868602601952],
["1mmb",2.1,2.55283313236542],
["1c6m",2.1,2.11922450143531],
["1c66",2.1,2.7146738312611],
["2b72",2.1,1.79117659264051],
["2b75",2.1,1.85133592742501],
["2b6t",2.1,2.01590877898758],
["2b74",2.1,1.86314953535473],
["1klo",2.1,2.64573931998451],
["1cu6",2.1,2.38889435267258],
["1ctw",2.1,2.51628207929740],
["1l82",2.1,3.05762482027043],
["1c6a",2.1,1.85539584174846],
["140l",2.1,2.24231065243175],
["1cv1",2.1,2.32002677651528],
["197l",2.1,2.93651130260728],
["1dyd",2.1,2.35421357546513],
["144l",2.1,2.32085105629122],
["1dyg",2.1,2.12567723587131],
["1dyc",2.1,2.48679442975962],
["1ncy",2.1,2.73890067910461],
["1lwk",2.1,3.44562901552548],
["1iqv",2.1,2.17520724043043],
["2nul",2.1,2.24463867262445],
["5cyh",2.1,2.40440199804514],
["4cyh",2.1,2.15782705922657],
["252l",2.1,2.58789498751554],
["1qt4",2.1,2.81637672539203],
["1sfe",2.1,2.88862863543928],
["1cwa",2.1,2.11045320582152],
["2c5j",2.1,2.02926873885244],
["1obv",2.1,1.99056416139928],
["1dux",2.1,2.76347038941252],
["2bmj",2.1,1.87629246272253],
["1qng",2.1,1.65321475817162],
["1xeq",2.1,2.60294914553720],
["1pue",2.1,3.20798860411889],
["2bsf",2.1,1.81465669073999],
["1bef",2.1,4.05431338477434],
["1ftn",2.1,3.03759886413338],
["1bwo",2.1,2.52818568312994],
["1tfk",2.1,2.55596162724675],
["1cwr",2.1,2.46067882634703],
["1ore",2.1,1.85947516421116],
["1lli",2.1,2.09136762567064],
["1ta0",2.1,2.42001320207463],
["2bb2",2.1,2.93274474036615],
["1znw",2.1,1.70986810888319],
["1br9",2.1,2.6484719487484],
["1u1n",2.1,1.99825177126854],
["1po6",2.1,2.27028630589448],
["2up1",2.1,2.05325060244260],
["1hfp",2.1,2.89428472931318],
["1boz",2.1,2.82260653875796],
["1hfq",2.1,2.71437356965905],
["1hfr",2.1,3.07994082433427],
["1pd8",2.1,3.23613569265149],
["2f3n",2.1,1.98050612554673],
["1zm0",2.1,3.42793218308635],
["1ygs",2.1,2.86497382649985],
["1g0x",2.1,2.0658459106035],
["1fio",2.1,2.15231851819072],
["1uct",2.1,2.23872044596648],
["1uhn",2.1,1.98814369499343],
["1ryt",2.1,2.45148680811103],
["1lvg",2.1,2.52272081631105],
["1qbj",2.1,2.48792202576114],
["1mjv",2.1,2.51853642359063],
["1nch",2.1,3.10489665552661],
["1tev",2.1,2.41383512469886],
["1g1c",2.1,2.15816410181232],
["1cqn",2.1,2.01149704214496],
["1s2b",2.1,2.73532065417751],
["3adk",2.1,3.81781327533533],
["1cuz",2.1,1.80304748504699],
["1ewn",2.1,2.43785837667363],
["1qbt",2.1,2.74869914125812],
["2tct",2.1,2.14439262447772],
["1ec1",2.1,1.67967167756368],
["1lv1",2.1,2.07873314101049],
["2bqv",2.1,1.41460786275092],
["1t7k",2.1,1.93970601822408],
["4phv",2.1,2.32693541690313],
["1odw",2.1,2.65511848946828],
["1j8s",2.1,2.19309279175929],
["1t4w",2.1,1.97236292413407],
["2g7l",2.1,2.60083788528063],
["1m4w",2.1,1.75622409387588],
["1p3t",2.1,2.35907665110047],
["2bf2",2.1,2.61401398876118],
["1g77",2.1,2.92295962053177],
["6lpr",2.1,2.39003534231189],
["1p05",2.1,2.60018282116876],
["2fdh",2.1,1.76484753322253],
["2fdf",2.1,1.82836851944818],
["1iac",2.1,1.98964825649495],
["1tsu",2.1,2.72352539344101],
["1kzl",2.1,1.70327655798165],
["1kd9",2.1,1.99327827263563],
["1p7i",2.1,1.38545818428718],
["1p7j",2.1,1.81582730841668],
["1nzv",2.1,2.51106879149216],
["1vj3",2.1,3.60154915399518],
["1ly4",2.1,4.08643256878906],
["1fb6",2.1,2.03463343461064],
["1mjl",2.1,2.79603213473931],
["1kk9",2.1,2.48557671626109],
["1lvf",2.1,1.78811498420409],
["2fdj",2.1,1.80150918692999],
["1f2v",2.1,3.20349409421866],
["2brq",2.1,1.94475033851344],
["1rz4",2.1,1.88390036298017],
["1vf6",2.1,2.35255200897233],
["1pe6",2.1,2.84035438779601],
["1xq1",2.1,2.3764554229469],
["1bwp",2.1,2.74932839966252],
["1pop",2.1,1.88892686320606],
["1rrx",2.1,2.3718932754823],
["1qb2",2.1,2.43939718126925],
["1ewo",2.1,1.89408139867704],
["1q6k",2.1,2.46347084718553],
["1u9x",2.1,2.09802401107005],
["1p92",2.1,3.32688946284156],
["1h68",2.1,2.16921724220917],
["1kr5",2.1,2.60311388779056],
["1gec",2.1,3.32537593901098],
["2c9y",2.1,2.43102573520933],
["1emk",2.1,2.79530162233831],
["1tff",2.1,2.39243777143411],
["2ak2",2.1,2.38296343645912],
["1v1q",2.1,2.90854763873679],
["1ep7",2.1,2.36573619717151],
["2tgd",2.1,4.14024470878226],
["1lgq",2.1,2.39188571261767],
["1yp9",2.1,2.44326188808331],
["2a7h",2.1,2.32654491632084],
["1auj",2.1,2.05027473422414],
["1ql7",2.1,2.30178798523791],
["1h9g",2.1,2.58438995167449],
["1ks5",2.1,2.10310459963843],
["1qye",2.1,2.67100348655742],
["1f0b",2.1,3.86850311118233],
["1yyy",2.1,2.65756224684496],
["1bfp",2.1,3.19943892141761],
["1xqm",2.1,1.77204056069651],
["8pch",2.1,2.43475971209170],
["1b54",2.1,3.10523869765825],
["1cks",2.1,2.37984082866955],
["1dzi",2.1,2.71365489283870],
["1k61",2.1,2.25229407236353],
["1qkp",2.1,2.36563151921189],
["1qko",2.1,2.34936684763997],
["2c56",2.1,1.67121097953926],
["1z6u",2.1,1.78282658199662],
["1smf",2.1,2.41764642785326],
["1upv",2.1,2.63517064419874],
["1bfv",2.1,2.62578397019797],
["1cfv",2.1,2.56605684395403],
["1xap",2.1,2.52447993025118],
["4vgc",2.1,2.24016712067126],
["1i4r",2.1,2.58883280584216],
["1spx",2.1,2.17902833341555],
["1gmh",2.1,2.51834738524263],
["6gch",2.1,3.67647086395806],
["4sgb",2.1,2.53575386119421],
["1ksl",2.1,2.64637047443917],
["1ge8",2.1,2.27317276479238],
["3p2p",2.1,3.78511796443906],
["1zpb",2.1,2.39374748756253],
["1pzl",2.1,2.66195122121282],
["2aud",2.1,3.38930728679813],
["1vpl",2.1,2.03601711421350],
["1rnf",2.1,2.74474006121396],
["1elb",2.1,2.32006197831323],
["1exf",2.1,1.60162484346036],
["1sc4",2.1,2.39844752710039],
["2c9c",2.1,1.45391608626837],
["1ty8",2.1,2.42283533492349],
["2frn",2.1,3.18611142986434],
["2bej",2.1,2.2678067366931],
["1f5l",2.1,2.10005517980281],
["2fuc",2.1,2.02713030136480],
["1xtz",2.1,2.31087928033583],
["1poe",2.1,3.52966809713831],
["1r5c",2.1,2.08355419387703],
["1txf",2.1,2.59514952241624],
["1tpe",2.1,2.59491030846079],
["3fib",2.1,2.09561539450967],
["1fib",2.1,2.20485338514663],
["1tzf",2.1,2.86818993149739],
["1f2x",2.1,2.41184572952675],
["2c26",2.1,2.07032807735771],
["1k5v",2.1,2.38845070025042],
["1ri5",2.1,2.27898457247501],
["1n4h",2.1,2.46897922815158],
["5ca2",2.1,2.77609002730047],
["4ca2",2.1,2.63040993104911],
["2c3j",2.1,2.90310756428565],
["1y6a",2.1,2.13524006702069],
["1s19",2.1,1.70743417049965],
["1ldf",2.1,2.09342283166095],
["1cim",2.1,2.05134462013526],
["1cin",2.1,1.98478600781903],
["1ydd",2.1,2.87013214596252],
["1zx2",2.1,2.51450235840743],
["1okl",2.1,2.07533580466211],
["1yda",2.1,2.64089043439938],
["1dcb",2.1,2.84330474862466],
["2brh",2.1,2.84260169127482],
["2brg",2.1,2.98940866297103],
["1ljk",2.1,2.44356222971094],
["1gcp",2.1,2.075996376736],
["1e5i",2.1,1.92789468034663],
["1t76",2.1,1.83692673902778],
["1bn1",2.1,2.23836464957836],
["1bn4",2.1,2.39007671393447],
["1djb",2.1,2.71829466857434],
["1lbb",2.1,2.30842530067684],
["1ghl",2.1,2.31082978773472],
["1eou",2.1,2.48420419918169],
["1cay",2.1,2.13534979325146],
["1sd2",2.1,1.92704725484804],
["1y6b",2.1,1.70125017772164],
["1nas",2.1,1.73386876386312],
["1fid",2.1,2.0653933531505],
["1j2z",2.1,2.50441294627108],
["1u0j",2.1,2.74255493510194],
["1jcm",2.1,3.02568696316527],
["1rwo",2.1,2.41080042499855],
["1rwv",2.1,2.44310448771456],
["2a9u",2.1,2.05082715984591],
["1jtt",2.1,1.54924941442283],
["1fdq",2.1,3.28116026488264],
["1m08",2.1,2.5228786469833],
["1s61",2.1,2.53092264310482],
["1iyq",2.1,2.43112631031984],
["1us8",2.1,2.11468317757017],
["2anj",2.1,2.23125399111342],
["2ag8",2.1,2.60416717162260],
["1zg6",2.1,2.67321537666317],
["1ero",2.1,2.73785426016633],
["1z93",2.1,2.69491289439448],
["1z97",2.1,2.874879058563],
["1zrh",2.1,1.83471007297510],
["3vhb",2.1,3.36989206420418],
["3tms",2.1,2.69017156416518],
["1sua",2.1,2.72726124944256],
["1c92",2.1,2.78148066407255],
["1c91",2.1,2.22667485409000],
["1c3f",2.1,2.90291275121685],
["1c93",2.1,3.05782999771368],
["1w6q",2.1,2.82821348697676],
["1tqp",2.1,2.30351799530996],
["1aob",2.1,1.91154021573715],
["1bdu",2.1,2.11795958376152],
["1b7x",2.1,3.14013539144365],
["1yav",2.1,2.22343018920360],
["1eqf",2.1,2.07408778414324],
["1nw7",2.1,2.13902276508080],
["1sw2",2.1,2.35257904493116],
["2brb",2.1,2.58443900844764],
["1zw2",2.1,2.87169663331974],
["2be4",2.1,2.14776123831762],
["1ndh",2.1,3.98239279614417],
["1dm2",2.1,3.00633660897280],
["1h4m",2.1,2.24580204723244],
["1brb",2.1,2.26263230075168],
["2thf",2.1,3.31279941458713],
["1vsb",2.1,2.64938170908797],
["2hex",2.1,2.85614603708278],
["1t80",2.1,2.31271162205467],
["2ac3",2.1,2.58932898683267],
["1thp",2.1,3.32585743784441],
["2bj7",2.1,1.84882284067653],
["2bj8",2.1,2.08039257895428],
["1s1s",2.1,3.03260063968623],
["1ca8",2.1,3.14326636730739],
["1shx",2.1,2.9502918246969],
["2tpi",2.1,2.70329205913059],
["2fk7",2.1,1.61807548239561],
["1dcq",2.1,2.25897531741602],
["1bb0",2.1,3.06952938149751],
["1a80",2.1,2.90244614235929],
["1xr1",2.1,3.38752279492232],
["1bzx",2.1,2.05936847282809],
["1hxf",2.1,3.35626389500494],
["1hxe",2.1,3.51936421952759],
["1h0w",2.1,2.58378685885329],
["7kme",2.1,3.36724056070274],
["1t71",2.1,3.22302519487700],
["8kme",2.1,3.82862461645975],
["1aix",2.1,2.75502442997152],
["1tdh",2.1,1.74977471111820],
["1mq5",2.1,2.60942321267037],
["1mq6",2.1,2.82908885433814],
["1eoj",2.1,2.35655148230442],
["1ktt",2.1,2.67415184463437],
["1eom",2.1,2.02817645408245],
["1f0r",2.1,2.44882421802292],
["1nfw",2.1,3.01316936355241],
["1f0s",2.1,3.05015316792964],
["1eol",2.1,2.38569953794132],
["1d3p",2.1,2.63256393260957],
["1w8w",2.1,1.82663166184621],
["1ksn",2.1,3.00867442711704],
["1c4u",2.1,3.63520710104918],
["1i57",2.1,2.38258680048603],
["1hho",2.1,3.46182732107879],
["1nfy",2.1,2.71532436666298],
["1wdi",2.1,2.31216384045510],
["2f06",2.1,2.84404754472098],
["2f1r",2.1,2.4508924216575],
["1ilr",2.1,2.52843176431274],
["1kwc",2.1,1.93147509650945],
["1j1l",2.1,2.71540445770609],
["2c6o",2.1,3.08727614510608],
["1b39",2.1,2.88474158152402],
["1wz7",2.1,3.26975569813426],
["1xqx",2.1,2.94068621475990],
["2c69",2.1,2.72450208145508],
["5gds",2.1,2.93868486534453],
["1xry",2.1,1.68771148664382],
["1cmt",2.1,1.86030952619202],
["1aee",2.1,1.91452466912074],
["1aet",2.1,1.97414977376657],
["1aeb",2.1,1.94225098562194],
["1aef",2.1,1.94225098562194],
["1aed",2.1,1.9428042572446],
["1aeq",2.1,1.95372132857328],
["1aeg",2.1,1.95425990227409],
["1aej",2.1,1.95425990227409],
["1aeh",2.1,1.96541536459042],
["1ac8",2.1,1.99771463547858],
["1aem",2.1,2.01857924245836],
["1aek",2.1,2.02818802380046],
["1cmu",2.1,2.13982360092124],
["1aes",2.1,2.14884041243985],
["1aev",2.1,2.07981323049572],
["1ccg",2.1,2.38763999747674],
["1aeo",2.1,2.41757217287159],
["1aen",2.1,2.43400034423523],
["1aeu",2.1,2.45768917495763],
["1ac4",2.1,2.47232333502745],
["1ccb",2.1,2.38584757627108],
["1ccj",2.1,1.95159734354883],
["1aa4",2.1,1.97412498577392],
["1a2g",2.1,2.24493668679918],
["1a2f",2.1,2.17485979715361],
["1cck",2.1,2.23777871201795],
["1c4v",2.1,4.15238227126694],
["1a2c",2.1,4.03706153317117],
["1l5y",2.1,1.83975376291207],
["1k3a",2.1,1.98628695386005],
["2bcd",2.1,1.87349508411883],
["1wyw",2.1,1.7610807478244],
["1rjb",2.1,2.18931548713676],
["1xc3",2.1,1.85813301703169],
["1iht",2.1,2.03530889130101],
["1gjr",2.1,2.66179344244445],
["1xms",2.1,2.00152404083246],
["1vpg",2.1,1.57520847747463],
["2fpk",2.1,2.75174758847835],
["1w9y",2.1,2.93947042063317],
["1t9r",2.1,2.06662906878367],
["2b07",2.1,1.36746398027872],
["1c87",2.1,2.52010183542879],
["1wzv",2.1,1.89229449340888],
["1epa",2.1,3.24487877836807],
["1yh6",2.1,2.04900644648182],
["2e2a",2.1,1.83859819301376],
["1esc",2.1,3.28144004420227],
["1qi0",2.1,1.75574276881199],
["1rb7",2.1,1.82934094669716],
["1irk",2.1,2.1100451180134],
["1r3e",2.1,3.41066146087268],
["1ycb",2.1,3.14785946731922],
["1d5r",2.1,3.38583859493602],
["1ut0",2.1,2.62167117783472],
["1lrm",2.1,1.47565003897505],
["1qvs",2.1,1.29764448890820],
["1u4n",2.1,2.3640455152543],
["1tto",2.1,1.47214037380483],
["5pah",2.1,1.90124657421715],
["1tdw",2.1,2.11650586298845],
["16vp",2.1,1.98682031930086],
["2bx6",2.1,2.20630631161516],
["2ac4",2.1,1.80295850737749],
["1qdr",2.1,1.65997693414023],
["1qdt",2.1,1.65727400098286],
["1dyo",2.1,2.58165705802295],
["1bez",2.1,2.08780158859677],
["3phm",2.1,2.6090985915913],
["2cbl",2.1,3.19464588495173],
["1ebm",2.1,2.48800470270728],
["1gkd",2.1,2.19800073283945],
["1a5z",2.1,3.06937157685528],
["1jhh",2.1,2.26007644320670],
["1lww",2.1,2.93610109587897],
["1drt",2.1,2.63584002143364],
["1wm1",2.1,2.23038827741493],
["1by4",2.1,4.1335206763031],
["1gt4",2.1,3.06127841551257],
["1tr7",2.1,2.36586555760200],
["1xgd",2.1,2.21615670974938],
["1bh2",2.1,2.09836439704754],
["1mzs",2.1,2.29943711019908],
["1tde",2.1,2.53199471359519],
["5tli",2.1,2.01206611341927],
["6tli",2.1,2.13638949852844],
["1os0",2.1,1.77309732624077],
["1y3g",2.1,2.61106776979983],
["1jwb",2.1,2.68854468441818],
["1tlx",2.1,2.06122620278902],
["1pta",2.1,2.6880168354231],
["1rb2",2.1,3.12770881925530],
["1c28",2.1,3.39854025670676],
["1vhm",2.1,2.36390340119096],
["1nos",2.1,3.01453562626163],
["1bcw",2.1,3.29076653693944],
["1bng",2.1,2.27287872724924],
["1n41",2.1,2.13919758897157],
["1n42",2.1,2.08853145036195],
["1n00",2.1,3.10487718026485],
["1g8p",2.1,3.02427797399574],
["1j6w",2.1,2.37153704706045],
["2lip",2.1,2.25799123313172],
["1bne",2.1,2.39656511464604],
["1bni",2.1,2.85021528267699],
["1bnj",2.1,2.39215153284183],
["1zjm",2.1,1.62693560287152],
["1bwn",2.1,3.58283321787923],
["1cgf",2.1,2.94676449635166],
["1cz0",2.1,2.15260127453848],
["1mw5",2.1,2.40929664711062],
["1wru",2.1,2.99124455650942],
["2f84",2.1,2.40483725955640],
["175l",2.1,3.00547571693101],
["216l",2.1,3.44399421322669],
["1fcu",2.1,2.52044700251037],
["1uh7",2.1,1.32540371829947],
["1d1g",2.1,2.4432938544626],
["1b8v",2.1,1.92830189070221],
["1y25",2.1,2.10728725619334],
["1nmk",2.1,1.94890962571593],
["5apr",2.1,1.64290506175573],
["1fqf",2.1,2.43337151507424],
["1n7x",2.1,2.19675903124314],
["1nft",2.1,2.45678045701932],
["1w03",2.1,2.07938089105036],
["1ldm",2.1,3.54637522247627],
["4ape",2.1,3.30897048854485],
["2f2l",2.1,1.52454097699242],
["1cz3",2.1,2.45368618661836],
["1sed",2.1,1.85959921197262],
["1b62",2.1,2.69503901869527],
["1nv2",2.1,2.83715677736113],
["2f6m",2.1,2.17164144051804],
["1dw3",2.1,1.88374147801745],
["1jce",2.1,2.15448751528537],
["2nrd",2.1,2.38664344894471],
["1pzm",2.1,1.84514872175628],
["1pqz",2.1,3.14958491926417],
["2bal",2.1,2.02103459655369],
["1sbn",2.1,3.52629715936057],
["1qzz",2.1,2.59868571904125],
["1ndt",2.1,1.80911782873977],
["1jcf",2.1,1.83897035036386],
["2sni",2.1,2.44534274205298],
["1re8",2.1,2.29766720872315],
["1eag",2.1,2.73058714416601],
["1bx6",2.1,4.26952698053018],
["1e54",2.1,2.66910341914512],
["4er4",2.1,3.33138576322196],
["2a5w",2.1,1.8568348489373],
["1vj1",2.1,1.83898317943269],
["1fs0",2.1,2.28675812804151],
["1zax",2.1,2.53302705769626],
["2cau",2.1,2.566994580792],
["1sb8",2.1,1.63774066266481],
["1qnh",2.1,1.73130862438234],
["1jxl",2.1,2.33509804647473],
["1s10",2.1,2.48962024608469],
["1how",2.1,2.67392933628854],
["1zz7",2.1,2.34523747035985],
["1z18",2.1,2.23746554510802],
["1hh2",2.1,3.77115359850881],
["1xaa",2.1,2.13903273737438],
["1xab",2.1,2.35738589777273],
["1g2u",2.1,2.36903757114105],
["1xad",2.1,3.1355638747946],
["1xac",2.1,3.15692593790856],
["1l4g",2.1,2.34555549730053],
["1l4h",2.1,2.19263181257493],
["1l4f",2.1,2.32903808143768],
["1v9n",2.1,2.54675005910131],
["1gp4",2.1,1.68294176329252],
["1ic7",2.1,2.46384650973161],
["1s4u",2.1,2.81318978143821],
["1r2j",2.1,2.97565789485418],
["1b6r",2.1,3.22147415944029],
["1wph",2.1,2.16699624121624],
["1kip",2.1,2.78452569573228],
["1ove",2.1,2.29983062197020],
["3erk",2.1,3.50638869786932],
["1p38",2.1,2.53631771898438],
["1nzf",2.1,2.10444372188976],
["1poo",2.1,2.91089070022905],
["1q61",2.1,1.94643781268838],
["1pkj",2.1,2.03728557077441],
["1jl5",2.1,2.99171955801963],
["1hx3",2.1,2.39737240580198],
["1vhr",2.1,2.12375234385458],
["1axi",2.1,2.47469753984097],
["1pno",2.1,2.35844649022058],
["1gwn",2.1,2.47801727338659],
["1l1n",2.1,2.3898381955363],
["1mdr",2.1,1.96573513026673],
["1dtn",2.1,2.53078547329148],
["1mra",2.1,3.26297873161816],
["1g64",2.1,3.38508060776561],
["1lg2",2.1,1.93221884427559],
["1jph",2.1,1.78801816554634],
["1okg",2.1,2.74033780753754],
["1y54",2.1,3.33968999666457],
["1yhk",2.1,1.71505929595020],
["2jdw",2.1,2.35259791585121],
["1pjb",2.1,2.92023706882350],
["1say",2.1,2.94686782461814],
["2esc",2.1,2.69865690942981],
["1xrv",2.1,2.90239222277489],
["1nvp",2.1,2.48429334759976],
["1xqe",2.1,1.58059339988948],
["2ald",2.1,2.83244530847036],
["1x9z",2.1,2.37038246874852],
["1xdg",2.1,1.94304679934898],
["2gan",2.1,2.97640440266794],
["1q65",2.1,2.68399657236171],
["1as4",2.1,1.76124496667579],
["1pea",2.1,2.94092385312767],
["1qn8",2.1,2.23913526715017],
["1qn6",2.1,2.18601862287287],
["1mpc",2.1,1.82852543499142],
["3sdp",2.1,4.64022894850684],
["1n2v",2.1,2.71754132488818],
["1dy9",2.1,2.78162096266616],
["1ais",2.1,3.07974643453412],
["1zvd",2.1,2.58944091067224],
["2gc3",2.1,1.70945398781424],
["2gc2",2.1,2.19600267314996],
["1nd7",2.1,3.56629419290596],
["1sek",2.1,3.2750744215095],
["1xmx",2.1,2.51075046196588],
["1hp7",2.1,2.74502158401405],
["1s2m",2.1,1.68218039757012],
["1rk1",2.1,2.10899001058679],
["1vok",2.1,2.89960913917799],
["2yhx",2.1,4.53728442676397],
["1dvn",2.1,2.91668896971500],
["1agc",2.1,2.12827738596571],
["2a8t",2.1,2.38857316126479],
["1jge",2.1,1.88381568208307],
["2bst",2.1,2.27420944186569],
["1u20",2.1,2.17629780380885],
["1ffg",2.1,1.88924586737846],
["1grn",2.1,2.33807848369104],
["1fcf",2.1,3.54029212541783],
["1pie",2.1,3.40835635423788],
["1kk2",2.1,2.31942920542511],
["1pdh",2.1,2.12745820729675],
["1smc",2.1,1.36239942945269],
["1n5k",2.1,2.08135198909618],
["1pxc",2.1,1.96849908422028],
["1dod",2.1,2.23034302982326],
["1w2g",2.1,2.16265179427328],
["1amr",2.1,3.01613413634903],
["1rbz",2.1,2.01048384702404],
["1lrz",2.1,1.79814161770892],
["1htd",2.1,2.42630464416196],
["1g6n",2.1,2.45296780539845],
["1aox",2.1,2.85724969702752],
["2f5u",2.1,2.64888177305127],
["1a0f",2.1,2.46206695087378],
["1d7y",2.1,2.71688198707270],
["1jio",2.1,2.59998394850335],
["1o64",2.1,2.44518050725319],
["1zrf",2.1,1.83900825672600],
["1tmk",2.1,2.18943383486023],
["1pkf",2.1,2.55647142711],
["1eup",2.1,2.60344589686189],
["1yjz",2.1,2.52237917220099],
["2cp4",2.1,2.47556371674467],
["8cpp",2.1,2.22693540046760],
["4cp4",2.1,2.38451368600536],
["1w7k",2.1,2.56382552675272],
["1mjo",2.1,2.83759756586444],
["1gir",2.1,2.71619591725765],
["1eog",2.1,2.52636207783074],
["1zgn",2.1,2.07597479400647],
["12gs",2.1,2.47568459538698],
["1md4",2.1,2.29677960126967],
["1cw4",2.1,2.21107059394982],
["1cw1",2.1,2.24671507389927],
["4pgt",2.1,2.87062779626417],
["1exb",2.1,2.16974853229276],
["1vjc",2.1,2.28201925682904],
["1yrt",2.1,3.18918154781071],
["1c3e",2.1,2.74031609294605],
["1c2t",2.1,2.76495712381966],
["1px6",2.1,2.19495711324715],
["1o5z",2.1,2.42365772056888],
["1mfb",2.1,2.38129416711086],
["1mfd",2.1,2.45081164019268],
["1mfc",2.1,2.56426567168992],
["1qw6",2.1,2.9418292131184],
["1mh3",2.1,2.33863785308294],
["1knw",2.1,2.09588179241220],
["1fxw",2.1,2.77527968942575],
["1dqm",2.1,3.05007783146127],
["1jep",2.1,2.05791601576744],
["1df9",2.1,4.05759172061034],
["2f2g",2.1,1.88224570513001],
["1sz9",2.1,2.44882812714637],
["1sqf",2.1,2.84679124959478],
["1twr",2.1,2.38835089253555],
["2b6c",2.1,2.05639527167754],
["1c5b",2.1,2.66623857827561],
["2bg7",2.1,2.29970457606818],
["1pkz",2.1,1.9715321682597],
["2dkb",2.1,2.53549107304205],
["2rcs",2.1,2.24321705263396],
["1aj7",2.1,2.31507485649624],
["1lon",2.1,2.54626689383471],
["1ah8",2.1,2.65525441734262],
["1dqd",2.1,3.23702411238899],
["1ykc",2.1,2.3692410138692],
["1ve3",2.1,2.46449834205625],
["1clo",2.1,2.90643655102632],
["2ajy",2.1,2.50673924958833],
["2c9z",2.1,2.07336761311660],
["1jg3",2.1,1.79850115471925],
["1ynk",2.1,2.99126878688355],
["1l7t",2.1,2.70694329938517],
["1r8a",2.1,2.28167378713972],
["1u2o",2.1,2.20438615623989],
["1p3r",2.1,2.47810038159893],
["1yek",2.1,2.70251274570009],
["1pt2",2.1,1.57299436440593],
["1wlr",2.1,1.28867743308824],
["1npm",2.1,2.43104853972558],
["1u8h",2.1,2.70385584146439],
["1d0h",2.1,2.90948304732014],
["2aej",2.1,2.61371326733091],
["1a3r",2.1,1.63949903963614],
["1qs4",2.1,2.39626807561449],
["1kmb",2.1,1.93395640400979],
["1gxz",2.1,1.71095899273276],
["2axn",2.1,2.56761292568929],
["1wt5",2.1,2.99645417425882],
["1nhr",2.1,2.09050601587212],
["3aop",2.1,2.16971727370586],
["1l0p",2.1,1.82404302671357],
["1i4g",2.1,2.66951654073637],
["1e9x",2.1,2.26180074706721],
["3geo",2.1,2.24667709393380],
["5gep",2.1,2.36810117026670],
["1bqp",2.1,2.49014233714497],
["1log",2.1,2.66629534951041],
["1e0p",2.1,1.83751562224808],
["3bct",2.1,1.83821590310447],
["1a31",2.1,2.80868734311091],
["1soq",2.1,2.14024908854952],
["1rv5",2.1,2.73385936935661],
["1w5d",2.1,3.09528501638773],
["1bcj",2.1,2.14405256185262],
["1tjh",2.1,2.46165207878678],
["1u5g",2.1,2.70315737626322],
["1bwc",2.1,2.48180623889567],
["1go7",2.1,1.43592365451252],
["2a9m",2.1,2.6057207586993],
["1z59",2.1,1.83656284788576],
["1nr6",2.1,2.56530232157968],
["1q3a",2.1,3.76396676620764],
["2f20",2.1,2.46111092434167],
["1z5n",2.1,2.35217000879900],
["1x8c",2.1,2.52360815295801],
["1xxl",2.1,1.84171593824974],
["1tj0",2.1,2.02329530002950],
["1w1b",2.1,2.22209579900462],
["1rjr",2.1,1.70752047457694],
["1s2l",2.1,2.55216230134867],
["6taa",2.1,3.29171300355746],
["2aaa",2.1,2.94197342319144],
["1qwt",2.1,2.56697967422909],
["1n3p",2.1,1.78732833212094],
["1wp6",2.1,1.94139787591173],
["1w9x",2.1,1.89341434411708],
["1xtg",2.1,2.6026034194955],
["1wox",2.1,1.99115684019871],
["1kws",2.1,1.87096623526525],
["1lru",2.1,2.820127240097],
["1xuv",2.1,2.85162408836991],
["1qq6",2.1,1.63246016545375],
["1stx",2.1,2.77344818829252],
["1rid",2.1,4.22969224216581],
["1rvc",2.1,1.81797137475940],
["1rvb",2.1,2.04535896973839],
["1zdt",2.1,2.57334321283831],
["1s2d",2.1,2.07265749563926],
["1g27",2.1,3.05676166082456],
["1q6f",2.1,2.59927846493647],
["1s2g",2.1,2.48183374749887],
["2c6e",2.1,2.74642446136141],
["1bry",2.1,1.67479932442215],
["1j9k",2.1,2.37057402784809],
["1yvn",2.1,2.6944202268107],
["1tpd",2.1,2.43633538125505],
["1nm9",2.1,1.82187922906302],
["1kb3",2.1,2.67987543590008],
["1kgw",2.1,2.4441425643752],
["1huc",2.1,2.84174036137568],
["1ici",2.1,2.19535452975973],
["1sw6",2.1,2.68331472628812],
["1isi",2.1,2.40684959870484],
["1hp5",2.1,1.84912577983696],
["1m01",2.1,1.64744761011933],
["1qd6",2.1,2.51346095867184],
["1z98",2.1,2.42802474856373],
["1qfe",2.1,1.91384234244860],
["1qyr",2.1,2.13351031409506],
["1bs6",2.1,2.98870726975499],
["1cte",2.1,3.02732779408869],
["1otv",2.1,2.33990829521078],
["1wmg",2.1,2.93247468665184],
["3azu",2.1,2.27508506737945],
["1lrn",2.1,2.1730098554096],
["1chq",2.1,3.05794298175424],
["1nd4",2.1,2.12405484933038],
["1u4d",2.1,2.11188602862815],
["1b8f",2.1,2.77690032578828],
["1m4y",2.1,1.86013679246915],
["1em8",2.1,1.84233483257119],
["1fzr",2.1,2.30003497442740],
["1z1n",2.1,2.93512507082083],
["1x89",2.1,2.65925746254735],
["1z54",2.1,2.46115802901045],
["1x71",2.1,2.58603450022026],
["1k2p",2.1,3.68012432617534],
["1syi",2.1,2.2318548728048],
["1itc",2.1,2.04590838306351],
["1b9z",2.1,2.44371860148216],
["1y7i",2.1,2.75854382320388],
["1eb8",2.1,2.42790386886866],
["1eb9",2.1,2.43111434246800],
["1e89",2.1,2.42173490275019],
["1olc",2.1,2.45296761573433],
["2az5",2.1,2.20446750777763],
["1xlw",2.1,2.21044287066716],
["1d6a",2.1,2.37425929877297],
["1qcg",2.1,2.58966584194254],
["1qcj",2.1,2.96964182610249],
["1wxd",2.1,2.4364592873578],
["1fm9",2.1,3.28357405375744],
["1c90",2.1,2.75118926912347],
["1wng",2.1,1.77771038889877],
["1vce",2.1,2.09903628487041],
["1tlc",2.1,2.79766885021874],
["1un1",2.1,2.45037744068970],
["1dea",2.1,2.42279960809374],
["1yhc",2.1,1.89565962577812],
["1e66",2.1,2.16155997970378],
["1qif",2.1,2.43991142129239],
["1qie",2.1,2.53500630608463],
["1trh",2.1,2.16647902624806],
["1xqr",2.1,2.24993939120752],
["1v18",2.1,2.18887597381603],
["1aui",2.1,2.51060971361245],
["1s4m",2.1,2.72491141211723],
["1ba2",2.1,2.16356188445454],
["1doh",2.1,2.14938658532901],
["2hhm",2.1,2.36442368080114],
["2gac",2.1,2.41943594129168],
["1hwu",2.1,2.44565418140336],
["1iep",2.1,2.72706657748708],
["2ahs",2.1,1.56225805238718],
["1xgu",2.1,2.54597169358570],
["1ndm",2.1,2.73115864354694],
["1xgp",2.1,2.65076397546124],
["1xgr",2.1,2.41604369811916],
["1xgt",2.1,2.42269698629743],
["1xgq",2.1,2.54407184245294],
["1n2o",2.1,1.70430978189185],
["2fiy",2.1,2.54715128044174],
["9gaa",2.1,2.45338279575704],
["2daa",2.1,2.35964523149306],
["1yto",2.1,2.31522200063816],
["1vbj",2.1,3.01282766900318],
["1bo6",2.1,2.74505524951968],
["2f98",2.1,2.18009273017149],
["1y44",2.1,2.52459617521942],
["1huj",2.1,2.84709440520872],
["1efv",2.1,2.07808296453696],
["1vi2",2.1,2.47977988534482],
["1a3q",2.1,3.30370163980526],
["1k4t",2.1,2.55452949151679],
["2fjm",2.1,2.23546087223304],
["1t08",2.1,2.03193312430619],
["1y0d",2.1,2.39705416158211],
["1jeb",2.1,2.41565565714144],
["1p2h",2.1,2.96995253138921],
["1y7g",2.1,2.6672512167768],
["1y7c",2.1,2.70345688407763],
["1yhe",2.1,2.0575268289275],
["1y4b",2.1,2.12611659716086],
["1hba",2.1,2.36783412695291],
["1nej",2.1,2.89965255525531],
["1dke",2.1,2.58689111681278],
["1hga",2.1,2.93233987485303],
["1gzx",2.1,3.1786091684565],
["1hgc",2.1,3.09647920070954],
["1hgb",2.1,3.06947780866482],
["1ep3",2.1,2.74629595421761],
["1m1e",2.1,1.90163011831058],
["1ca0",2.1,2.66742796035115],
["1jwn",2.1,1.86678823958292],
["1b27",2.1,2.40169729151008],
["1b2u",2.1,2.33135599578661],
["1vnc",2.1,2.43081030164331],
["1iim",2.1,2.24394645469488],
["1q6n",2.1,2.71394489304324],
["1ua0",2.1,2.52971983802374],
["1it3",2.1,3.2786980311956],
["1fjm",2.1,2.07632973345878],
["1u48",2.1,2.09770161807848],
["1nk5",2.1,2.01146350354602],
["1nk6",2.1,1.89136731144769],
["2g09",2.1,1.76755562923000],
["1tht",2.1,2.53453443988616],
["1fak",2.1,3.23879899852909],
["1h3i",2.1,3.2409588321213],
["1xv1",2.1,2.05971982879342],
["1dt0",2.1,3.22763689177415],
["1x1w",2.1,2.56966264931148],
["1o87",2.1,2.05647334844644],
["1jfz",2.1,3.62560738460747],
["1uld",2.1,2.48305024978022],
["1kfs",2.1,2.94542023235315],
["1pyw",2.1,2.33511665854009],
["1w8n",2.1,1.86326448528184],
["1v1a",2.1,3.27254599704868],
["1nhx",2.1,1.94253675551311],
["1ut9",2.1,2.58572527634578],
["1p7c",2.1,2.60019662401838],
["1nez",2.1,3.11085253840856],
["2abq",2.1,3.22380834885966],
["1h19",2.1,2.35788410575664],
["1lhp",2.1,2.07718116226234],
["1u5q",2.1,2.84721328639123],
["1u5r",2.1,2.87374906046491],
["1uxh",2.1,2.32517029120012],
["1uxi",2.1,2.39237229936928],
["2fv7",2.1,1.70124714884526],
["1dkd",2.1,2.38132146334698],
["2b2n",2.1,2.45512105153896],
["1jqv",2.1,1.87679496978055],
["1vj7",2.1,2.85669513905706],
["2dex",2.1,2.62574302873018],
["5fbp",2.1,2.33712542168572],
["2dew",2.1,2.74203119430876],
["1n1v",2.1,2.32233821700733],
["1ziw",2.1,2.48626303864403],
["1fpf",2.1,2.51976052892646],
["1fpd",2.1,2.36668000031497],
["1mw1",2.1,2.19186132173152],
["1mw2",2.1,2.28226413668253],
["1m98",2.1,2.62589719452164],
["1nf3",2.1,2.27055828202259],
["2cwn",2.1,2.19473540190933],
["1i2r",2.1,1.71240756399451],
["1tcb",2.1,1.66405837646518],
["1uj3",2.1,2.50809156897026],
["1fq0",2.1,2.20387041871553],
["1hp0",2.1,2.23494430629631],
["1gjw",2.1,2.20181049291649],
["1oil",2.1,2.41485838642741],
["1f06",2.1,2.68483497775426],
["2fme",2.1,2.95743208582681],
["2fsk",2.1,2.08283056005917],
["1y2e",2.1,1.34432597470277],
["2aep",2.1,2.11865386016771],
["1p72",2.1,2.24063841996102],
["2bjg",2.1,2.87786319613877],
["1r8k",2.1,2.4906284211896],
["1acc",2.1,2.79848026149458],
["1ic0",2.1,2.53327101586377],
["1v8g",2.1,2.08719173476798],
["1dpm",2.1,2.61349818895742],
["1irj",2.1,2.69952874279387],
["1i0z",2.1,2.47151520044360],
["1hzp",2.1,2.44559687982436],
["1mzj",2.1,3.59056415496843],
["1qmh",2.1,2.51013377145051],
["1ph6",2.1,2.4225929232003],
["1ii6",2.1,3.07334555097941],
["1hm3",2.1,2.35618101526688],
["1q41",2.1,2.15200221205399],
["1svv",2.1,1.77521597046364],
["1b77",2.1,2.22232737547890],
["1s0o",2.1,2.47153258437828],
["1x8l",2.1,1.81180682250187],
["1qdw",2.1,2.45720626528081],
["1cxe",2.1,2.35044632548591],
["1pr6",2.1,2.2870507730387],
["1kam",2.1,2.62653226631314],
["1lfi",2.1,3.86425681943908],
["1n8i",2.1,1.96931062195393],
["1x7x",2.1,1.88181052162256],
["1eud",2.1,2.28613709770178],
["1dmt",2.1,2.31245541597103],
["1euc",2.1,2.33123041292517],
["1jrg",2.1,2.85576269218904],
["1qht",2.1,3.65887169129786],
["1a69",2.1,3.13088774933601],
["1wz9",2.1,2.21452851285782],
["1yyq",2.1,2.14904460162521],
["1s7n",2.1,2.43745941646392],
["1ga9",2.1,2.47553518271061],
["1m8t",2.1,3.08703973779314],
["1zkd",2.1,1.96219617713338],
["1w61",2.1,1.94835915383704],
["2cog",2.1,2.65898216033222],
["1mma",2.1,3.7906952865817],
["1y5x",2.1,2.57929114464376],
["1uoq",2.1,2.03877800388346],
["1o1t",2.1,2.12313167563217],
["1j1c",2.1,2.85774394712344],
["1w6k",2.1,2.08542440155728],
["1sa4",2.1,1.74850032456842],
["1hgw",2.1,2.20301810503977],
["1qk0",2.1,2.24152873879782],
["1mmn",2.1,3.09637577986033],
["1kzp",2.1,1.99880993833576],
["1yxa",2.1,1.99098135031852],
["1fmv",2.1,3.15921361163290],
["1wue",2.1,2.61412208149549],
["1o62",2.1,1.88157869772403],
["2a0u",2.1,2.01631769134775],
["1mkf",2.1,2.76168451192587],
["2aro",2.1,2.34358310996917],
["1dju",2.1,2.7970693032795],
["1vrp",2.1,2.57043953979857],
["2c7n",2.1,2.48799746924392],
["1h5w",2.1,2.64151255260531],
["1na6",2.1,2.91611527688864],
["1tk9",2.1,2.32169824789067],
["2oxi",2.1,2.29453212073059],
["1hld",2.1,2.38631399649602],
["1r31",2.1,2.38020464744696],
["1yad",2.1,2.24469758987528],
["1mh5",2.1,3.24622482568986],
["1qlv",2.1,3.07034338874024],
["1od5",2.1,2.89771874817471],
["1x1j",2.1,2.57999500293385],
["5acn",2.1,2.80474969413111],
["1s16",2.1,2.32570487567217],
["1hsa",2.1,2.13244782798012],
["1ou0",2.1,2.81241682005275],
["1mhc",2.1,2.74467109510192],
["1p3w",2.1,2.63547667289407],
["1pjh",2.1,1.94519210779349],
["1x9m",2.1,2.42568134267793],
["1j32",2.1,2.23194729666299],
["1nr5",2.1,2.61020459034851],
["2bes",2.1,1.43561494007169],
["1kxp",2.1,1.99058353568675],
["1oqm",2.1,2.54666433136761],
["1axk",2.1,2.19203931174433],
["1wno",2.1,2.4571572697547],
["2a3a",2.1,1.74422091676129],
["1m4h",2.1,2.16755331908115],
["1s3t",2.1,1.74954122512831],
["1bqd",2.1,3.10192398529898],
["1bqa",2.1,2.93511204790531],
["1fdp",2.1,2.97701666976368],
["1r6t",2.1,2.19378449354116],
["1aka",2.1,2.55333747979232],
["1ef0",2.1,3.24151092005169],
["1v9s",2.1,2.43610700840433],
["1p4g",2.1,2.51872053169139],
["1xl1",2.1,2.43011556860668],
["1s08",2.1,2.44413331813231],
["2cun",2.1,2.60566796529737],
["2a1m",2.1,2.39681645932947],
["1c8j",2.1,2.70535537657385],
["3amv",2.1,2.69126943344731],
["1obc",2.1,1.69456825257856],
["2fn1",2.1,2.261659964882],
["1d7k",2.1,3.15070144011857],
["1c3h",2.1,3.23728684750128],
["1vew",2.1,1.55634838756093],
["1f1s",2.1,2.97555298011877],
["1ry5",2.1,2.18255672470941],
["1qov",2.1,1.93584554943006],
["1kkr",2.1,2.65286403911553],
["1sz0",2.1,3.24518075108421],
["1yzy",2.1,2.51277147533809],
["1pj7",2.1,1.89085599534276],
["1ztc",2.1,1.71347123724169],
["1foj",2.1,2.61985867058107],
["1dm7",2.1,2.63170611349267],
["3nse",2.1,2.50517436238443],
["1z88",2.1,1.45712300425154],
["1z94",2.1,2.74675416287258],
["1rg1",2.1,2.30037117647638],
["1jva",2.1,2.71820483520482],
["1mjj",2.1,2.44034982858370],
["1ofu",2.1,2.61578082909098],
["1rg2",2.1,2.33096007979057],
["1n8q",2.1,3.04428683707208],
["1jnq",2.1,3.57872670760965],
["1hei",2.1,3.57102008030319],
["1w6t",2.1,1.76830369296688],
["1vgr",2.1,2.7047670336396],
["1nc2",2.1,1.89163891406749],
["1jqh",2.1,2.77496561886973],
["1mgv",2.1,2.73504709152788],
["1cqd",2.1,2.45763700854142],
["1o28",2.1,2.19917137476309],
["1iwe",2.1,2.76641537241642],
["1msw",2.1,3.68242368174062],
["1ni6",2.1,2.67326838245766],
["1kar",2.1,2.41631230541377],
["1a4j",2.1,3.54587386762309],
["1ee4",2.1,1.83914836640980],
["1kah",2.1,2.52485068010512],
["1brw",2.1,2.23961001675121],
["1fl5",2.1,2.9008087958679],
["1isy",2.1,1.93118713608413],
["1v6v",2.1,2.10831802072030],
["1isv",2.1,2.09893688213014],
["1v6x",2.1,2.20095983516517],
["1v6u",2.1,2.24664363969884],
["1isx",2.1,2.27264180778104],
["1isw",2.1,2.46067118725727],
["1ebg",2.1,2.55452625711371],
["1yzw",2.1,1.27089683757355],
["1i1k",2.1,2.5263652677262],
["1i4z",2.1,3.03489012477425],
["1hv9",2.1,2.94026548635784],
["1pq9",2.1,2.19388519923841],
["2ew8",2.1,1.93750933990561],
["1wn3",2.1,1.96019584241336],
["1tug",2.1,3.73913151785875],
["1d09",2.1,3.29514892807762],
["1s7m",2.1,2.52551567196697],
["1n78",2.1,2.64336200208193],
["1rla",2.1,2.52099640287716],
["2c7i",2.1,2.58030470982980],
["1g5c",2.1,2.5800784764337],
["2f9o",2.1,2.39487717261554],
["1nfr",2.1,2.17262895736431],
["1xc6",2.1,1.87903907613393],
["1e56",2.1,2.53206510252191],
["1e4n",2.1,2.55677380977895],
["1mhh",2.1,2.37505297304928],
["2g39",2.1,2.07898627908162],
["1yi8",2.1,3.68678231862942],
["1w1p",2.1,2.06067442788064],
["1va6",2.1,2.18705005913618],
["1l9w",2.1,2.60811732557923],
["1q4q",2.1,3.32232100498068],
["1rm5",2.1,2.37827291616949],
["1g3j",2.1,1.86189380756522],
["1n0t",2.1,1.98114708031542],
["2bgj",2.1,2.49624923412642],
["1ukc",2.1,1.94917096217870],
["1p1k",2.1,2.86835724185409],
["1ho5",2.1,2.91484830515995],
["1fm6",2.1,3.56011161517146],
["1oi8",2.1,1.94558253420098],
["1zgc",2.1,2.38268708388946],
["1h9x",2.1,2.30890396631756],
["1jvn",2.1,2.02306625517150],
["1bkh",2.1,2.41636489880024],
["1ujq",2.1,2.21103859369042],
["1xkq",2.1,2.44839603419068],
["1lnw",2.1,2.74753056041939],
["1izn",2.1,2.89413937468604],
["1j3k",2.1,2.31201647899048],
["1rr9",2.1,3.1252898495599],
["1e8g",2.1,2.36843417414999],
["1q7m",2.1,2.78698895542393],
["1qr6",2.1,3.76066424861764],
["1h1p",2.1,2.92014380131031],
["2c5t",2.1,2.99312767185251],
["2c5o",2.1,3.08628839216011],
["2c5n",2.1,3.17683783638437],
["1hox",2.1,2.75506413572611],
["2ax1",2.1,1.51722585416143],
["1ehy",2.1,2.38458439798009],
["1w73",2.1,2.18908595396580],
["1s2v",2.1,2.69665197434475],
["2bht",2.1,4.01884110943493],
["1u2e",2.1,2.82527600823224],
["1ve6",2.1,2.18670848711762],
["1iin",2.1,2.03837847574028],
["1w3n",2.1,2.09970994175890],
["1w3t",2.1,2.12557642744309],
["1pox",2.1,1.51349927853280],
["1fwk",2.1,2.82729734122933],
["1vk0",2.1,2.04007886959262],
["2esn",2.1,2.77260052846867],
["1xmd",2.1,2.07871324907868],
["1h3g",2.1,2.51878311310267],
["1rz1",2.1,2.16141318724817],
["1hqz",2.1,2.37498040303665],
["1izo",2.1,2.97733862919743],
["1ivv",2.1,2.55262202970887],
["1ib6",2.1,2.70653655927181],
["1yup",2.1,3.08064493308482],
["1o68",2.1,1.75916129432747],
["1k8c",2.1,1.99754091624227],
["1q0c",2.1,2.12917278474036],
["1ek9",2.1,3.11022458706858],
["1t6j",2.1,3.11890222573289],
["1tg6",2.1,2.84706848815868],
["1g9a",2.1,2.28305338553565],
["1rzt",2.1,2.19078437024268],
["1tz2",2.1,2.33829825542871],
["1zkn",2.1,2.17380526088887],
["1cf2",2.1,2.14093007457225],
["1l9n",2.1,2.41470363365886],
["1rle",2.1,2.30213697476372],
["1l9m",2.1,2.72956597307279],
["1umb",2.1,2.00099053088007],
["2aq1",2.1,2.78168094043242],
["1v3l",2.1,2.16960678353802],
["1h81",2.1,2.50535461678415],
["1q0k",2.1,1.64577552064457],
["2a1f",2.1,2.08242891075952],
["1odl",2.1,1.87865823435089],
["1ggu",2.1,3.02345052713332],
["2ccd",2.1,2.58852735524188],
["1d6z",2.1,2.40041253673329],
["1f13",2.1,2.48818701664185],
["1fdj",2.1,2.83955360698606],
["1x70",2.1,2.2003080039174],
["1nu6",2.1,2.95637102283408],
["1sjc",2.1,3.29044607883022],
["1utd",2.1,2.19546402436705],
["1dof",2.1,2.39715632530725],
["1j1z",2.1,2.42589694414457],
["1mj3",2.1,2.24019288433031],
["1wb9",2.1,2.04917753255164],
["2bl2",2.1,1.92157065431222],
["1q3k",2.1,2.66674493195633],
["1yir",2.1,2.61492236043439],
["1hw8",2.1,2.09924551998036],
["1fzd",2.1,3.27471546875604],
["1l5r",2.1,2.70588543582951],
["1l5s",2.1,2.67960007463804],
["2bwn",2.1,1.81108043873306],
["1hwl",2.1,2.33695468178897],
["1ei6",2.1,2.88957912725652],
["1xoi",2.1,2.99838134813216],
["1tbg",2.1,3.10680406355296],
["1igw",2.1,2.56610904980429],
["1dq8",2.1,2.61349401320968],
["2a5h",2.1,3.02893445843994],
["1de6",2.1,2.85503446453435],
["1oxk",2.1,2.29347956046177],
["2rma",2.1,2.35324550036257],
["2rmb",2.1,2.39170468342058],
["1szs",2.1,2.21412588950882],
["2cw6",2.1,2.87405189422132],
["1l8p",2.1,1.99040836731655],
["1iwp",2.1,2.94818094384896],
["1tju",2.1,2.19578720551261],
["1wcq",2.1,1.95438141255178],
["1uf3",2.1,2.54782882086281],
["1c7g",2.1,2.77427924742926],
["1ax4",2.1,2.41151698343741],
["1wnd",2.1,2.32202792936110],
["1s3q",2.1,2.25008950467962],
["1vkd",2.1,2.16912276415046],
["1ukp",2.1,2.25393033887529],
["1uko",2.1,2.57283655443354],
["1uhv",2.1,2.95868724578545],
["1ez0",2.1,1.75189200181368],
["2d4e",2.1,1.93076653021634],
["1j0y",2.1,2.15582249173076],
["1j10",2.1,2.22776586889863],
["1j12",2.1,2.38308872414183],
["2d83",2.1,2.26711756625994],
["1xmg",2.1,2.68375893141224],
["1fz8",2.1,2.43395802406884],
["2fbw",2.1,2.09330703154269],
["1pj3",2.1,2.61555434595296],
["1z7d",2.1,2.66528389343675],
["1pk8",2.1,2.04872776645379],
["1tue",2.1,2.19609485637367],
["2afh",2.1,2.45313283959587],
["3pcd",2.1,2.41918462062537],
["2bvc",2.1,1.40384644572831],
["1tkk",2.1,2.33661566268687],
["1r9m",2.1,2.74912396577951],
["1a8r",2.1,2.15773588933045],
["1gqo",2.1,2.78879881511876],
["1e5q",2.1,1.93714836863552],
["1wyu",2.1,2.57693897806718],
["1vlq",2.1,1.41494219465336],
["1ppj",2.1,2.08441328333425],
["1pp9",2.1,2.03637604187216],
["1jz4",2.1,2.73305530226446],
["1jz6",2.1,2.96071988149545],
["1jz2",2.1,2.9966219513995],
["1a49",2.1,3.30620290983717],
["1xsj",2.1,2.33382955373269],
["1yrq",2.1,2.16566442210926],
["1zum",2.1,1.94047069941845],
["1m6v",2.1,3.07678711038168],
["1kee",2.1,2.8429592304474],
["1t36",2.1,2.97881668506350],
["1ce8",2.1,3.02411803175633],
["1c3o",2.1,2.91621043182752],
["1bxr",2.1,3.14691110393916],
["2bjo",2.1,2.06215350852970],
["1rby",2.1,2.17746766071459],
["1m46",2.1,1.61976485199599],
["1tvl",2.1,2.09491382544915],
["1rbq",2.1,2.01003983152982],
["2b6x",2.11,1.85133592742501],
["1t6m",2.11,3.06342607757083],
["1ttz",2.11,2.50228797112548],
["1wwp",2.11,2.85634053363806],
["2dca",2.11,2.64406132063968],
["2f4z",2.11,2.48857947121104],
["2b59",2.11,2.67208928879722],
["4cpp",2.11,2.51795316984869],
["2gsr",2.11,2.23533013730017],
["1uou",2.11,2.37681827669363],
["1h6n",2.11,2.33767776253594],
["2c36",2.11,2.31842167508817],
["1yev",2.11,2.36549122732122],
["1rq4",2.11,2.26983316221834],
["1xzv",2.11,2.47864236641567],
["1xz5",2.11,2.44560051017979],
["1rqa",2.11,2.22252397296751],
["1y4q",2.11,2.52321097299452],
["1rps",2.11,2.10473973772178],
["1vnh",2.11,1.90666207201499],
["1q99",2.11,2.74093646252221],
["1h0k",2.11,1.5134775659279],
["1zq7",2.11,2.33880790940263],
["1od0",2.11,2.24913349975031],
["2ey4",2.11,2.71699863903218],
["1mb9",2.11,2.55098001815386],
["2bel",2.11,1.85092090786811],
["2f36",2.11,2.31733620833787],
["1nq5",2.11,2.1813677400931],
["1y1r",2.11,2.07871296978394],
["1ngk",2.11,2.52609128790372],
["1yp2",2.11,2.76200012810557],
["1u0u",2.11,3.28765099985899],
["2aj8",2.11,2.57401962412417],
["1xa5",2.12,2.05999458916827],
["1cv0",2.12,2.29347893427102],
["1cu3",2.12,2.53495092623800],
["1d3m",2.12,2.63113606124355],
["1yc3",2.12,2.5223853315913],
["1lva",2.12,2.56257081266345],
["1je8",2.12,2.37244299201577],
["1a46",2.12,3.16221151246487],
["1e06",2.12,2.53820741386080],
["2f70",2.12,1.93864198807628],
["1ja8",2.12,2.5513048593869],
["1z85",2.12,1.71208225906446],
["1e1o",2.12,1.58626330854196],
["1h7f",2.12,1.97667204641808],
["1veo",2.12,2.66921461868192],
["1yeu",2.12,2.54521080159615],
["1y35",2.12,2.51769670975678],
["1zdz",2.12,2.41071585091619],
["1z0a",2.12,2.12851834949017],
["1e3e",2.12,2.16950630372822],
["1n0u",2.12,2.64837778227349],
["1ub6",2.12,3.23348487371367],
["1oif",2.12,2.17799690943067],
["1kcx",2.12,2.53787189769171],
["1s2y",2.12,1.89253390118765],
["1xjk",2.12,2.72570563290643],
["5pgm",2.12,2.41480269588693],
["1dtm",2.13,3.06272898355032],
["1duk",2.13,3.4566741183786],
["1gm6",2.13,3.39319617733755],
["1ssw",2.13,2.13882638239307],
["1uky",2.13,2.36289109490711],
["1gbk",2.13,1.85931797008891],
["5lpr",2.13,2.06763833732030],
["1emb",2.13,2.48704521932332],
["2cc1",2.13,2.30806397848690],
["1gfy",2.13,2.75565563071845],
["2f3g",2.13,3.3651768299972],
["2azp",2.13,1.8962473644095],
["1h1o",2.13,3.36385176898358],
["1em1",2.13,2.21615846690114],
["1pu8",2.13,2.21950631311981],
["1ud2",2.13,1.99983183073062],
["1h7g",2.13,1.99132988647228],
["1mzr",2.13,2.20187434524208],
["1y85",2.13,2.43021436385891],
["1xye",2.13,2.09272239541636],
["1y31",2.13,2.68007479259848],
["1ro9",2.13,2.25440439630147],
["1s5b",2.13,1.86329100369896],
["1lti",2.13,2.8106161881058],
["1vgq",2.13,2.37988974147752],
["1s9p",2.13,2.17466707048371],
["1uzz",2.13,2.5293908090164],
["1ump",2.13,1.94835461933877],
["3pck",2.13,2.69197884203241],
["3pcj",2.13,2.73141662694482],
["4wbc",2.14,2.73259391104188],
["1unv",2.14,2.95175955360136],
["2fwk",2.14,3.94005657518016],
["1qji",2.14,1.92116843027195],
["1kdd",2.14,1.88396704888603],
["1f09",2.14,3.75839218275698],
["1in0",2.14,3.09660315732373],
["1m7z",2.14,1.47642170690158],
["3pgt",2.14,2.71704775799666],
["1riq",2.14,2.24662043261908],
["1dlk",2.14,2.36943240944298],
["1i5n",2.14,1.78854464492966],
["1e67",2.14,1.97988226098189],
["1abr",2.14,3.40621325869199],
["1y5f",2.14,2.57293668397425],
["1y0w",2.14,1.95139386380406],
["1a0u",2.14,2.42847810767485],
["1y0t",2.14,2.50769301242614],
["1ibq",2.14,2.95710153334021],
["1zzt",2.14,2.36269134075356],
["1dty",2.14,3.46359405585293],
["1uwr",2.14,1.98751303338508],
["1jqy",2.14,2.82593964843496],
["2af4",2.15,3.19892894871564],
["2fu2",2.15,2.13687211867708],
["1b8k",2.15,3.23947988740064],
["1pcs",2.15,1.51149314572976],
["4pcy",2.15,2.86343859848833],
["1bxm",2.15,1.83913252392497],
["1i3z",2.15,3.40061142170766],
["1m4b",2.15,2.30850179096438],
["6rhn",2.15,1.91727766041931],
["1ux8",2.15,2.81921803717384],
["1dmq",2.15,2.46942083945146],
["1hh1",2.15,3.05974616637234],
["1cgn",2.15,2.2345044112137],
["1u61",2.15,2.21929568175421],
["1xrx",2.15,2.0249090204142],
["1ena",2.15,3.00319623787877],
["1anu",2.15,2.08435050446178],
["2a1v",2.15,2.05673528858486],
["1r6c",2.15,2.22980435187425],
["1dtl",2.15,2.54870300418637],
["1ash",2.15,2.78286799699423],
["1rda",2.15,3.09577065534815],
["1sv4",2.15,2.60790199472752],
["2a90",2.15,3.06302041029975],
["1qmr",2.15,1.69572484514685],
["1u8a",2.15,2.62709127771632],
["1wrk",2.15,2.09495549499675],
["1wu3",2.15,2.64507576063786],
["1t8f",2.15,2.02023619008013],
["2b73",2.15,1.71754751748027],
["1faj",2.15,2.62135331299246],
["1z0f",2.15,1.97790171965547],
["1a33",2.15,2.05461190535000],
["1xg6",2.15,2.65637107719574],
["2byo",2.15,1.89019897838645],
["1wqg",2.15,2.6213434934102],
["1ktz",2.15,2.43145306051463],
["1izi",2.15,2.39172353130585],
["1gba",2.15,1.89608232247257],
["1ztz",2.15,2.65287649690222],
["1gbb",2.15,1.80509953345228],
["1gbl",2.15,2.01253796594401],
["3lpr",2.15,2.25082354359519],
["1gbf",2.15,1.94780710506295],
["1p03",2.15,2.31976899109864],
["1gen",2.15,3.00569588075759],
["1i3a",2.15,2.16788483914371],
["1mt8",2.15,2.31614599670637],
["1e4a",2.15,2.29518875779374],
["1e47",2.15,2.4008816425223],
["1mjk",2.15,2.19990442015661],
["1rc7",2.15,1.81382783966052],
["1x3e",2.15,2.54097325962183],
["2bjm",2.15,3.76633028839627],
["1uhb",2.15,3.00760022285250],
["1zyb",2.15,1.49643435277433],
["1p9y",2.15,2.13080026306133],
["1dq1",2.15,2.10660378776101],
["1veu",2.15,2.67606221541439],
["1mb8",2.15,2.74832349925393],
["1hnu",2.15,2.63420578867653],
["1yr6",2.15,3.28335147398192],
["1ky7",2.15,2.32744399045314],
["1ktj",2.15,2.56222650444731],
["1bnt",2.15,2.33684204928059],
["1bnu",2.15,2.43486100724838],
["1cnk",2.15,2.42526848190554],
["1awc",2.15,2.44312987451632],
["1qmj",2.15,2.43978598721733],
["1yhs",2.15,2.33668021563778],
["1vfn",2.15,3.5129128004789],
["1m13",2.15,2.75762561133192],
["1be6",2.15,3.02513481420599],
["1vh9",2.15,2.30682231148104],
["1y91",2.15,3.40295856995613],
["1cfr",2.15,2.25482106582304],
["1r1x",2.15,2.31961985392198],
["1nfx",2.15,2.77680227545363],
["1i4s",2.15,3.73767913275933],
["1dvk",2.15,2.2036112391994],
["1e02",2.15,3.0489978625077],
["1h42",2.15,1.81958774625383],
["1jbr",2.15,2.87988458429676],
["2f6y",2.15,2.28769330661104],
["1pxh",2.15,2.31338865422809],
["1mn7",2.15,2.76220178556807],
["1ule",2.15,2.13178365071685],
["2g15",2.15,2.89325112510647],
["1xku",2.15,2.24437224793042],
["1gw2",2.15,1.58706594645350],
["6pah",2.15,1.87699421496689],
["1ko9",2.15,2.37148943712206],
["1id2",2.15,2.46975239492181],
["1or4",2.15,3.05568389664051],
["1mau",2.15,2.55146148504731],
["1nv6",2.15,2.9916646360983],
["1cec",2.15,1.99470273717084],
["1mew",2.15,2.32961759957001],
["1kvq",2.15,2.089097888263],
["1kvt",2.15,2.43526632944462],
["1kvs",2.15,2.95822974163717],
["1ylv",2.15,2.56603534034827],
["1rlz",2.15,2.20931097379018],
["2f92",2.15,2.20662257619123],
["1k3b",2.15,2.99432156612054],
["1mjx",2.15,2.83147868385888],
["1h2k",2.15,1.97153054337586],
["1zk8",2.15,1.91892793967308],
["2asi",2.15,2.96938171375069],
["1nx6",2.15,1.87552671630488],
["1tb4",2.15,2.66220416941706],
["1pr3",2.15,2.61142878779763],
["1me7",2.15,2.05255106327311],
["1jht",2.15,2.49773680997706],
["1lek",2.15,2.40981810830161],
["1hk9",2.15,2.37718580666203],
["1d6h",2.15,2.51184796565061],
["1qg3",2.15,2.41748138308333],
["2d0e",2.15,3.1392316797591],
["1tbw",2.15,2.02380309187784],
["1jgl",2.15,2.31894355486557],
["1byu",2.15,2.2846203950054],
["1nur",2.15,2.30353675008916],
["1axt",2.15,2.84631453695059],
["1eoa",2.15,2.25250119621419],
["1vpo",2.15,2.95522750586993],
["2ar7",2.15,1.32352214736715],
["2znb",2.15,2.4833381239265],
["1bss",2.15,3.08030989546977],
["1bua",2.15,2.45060140732383],
["1vf2",2.15,2.32032614879986],
["1vf3",2.15,2.63302674010248],
["2bwc",2.15,2.28877333765485],
["1pju",2.15,1.86920035981236],
["1q79",2.15,2.50066215820229],
["1sx8",2.15,2.92417438922371],
["1ud4",2.15,1.68268378757748],
["1ud3",2.15,2.37814678075029],
["4std",2.15,2.52490459094353],
["1cbg",2.15,2.10134430830164],
["1cyy",2.15,2.57429341533011],
["1mqg",2.15,2.18960739629344],
["1mm6",2.15,2.10897411947593],
["1tx0",2.15,2.40348500748944],
["5eau",2.15,2.27034820286226],
["1vco",2.15,2.41076725843769],
["1h23",2.15,2.420671030885],
["1f4d",2.15,2.38826192916252],
["1h22",2.15,2.48962161930098],
["1slc",2.15,2.87416683563191],
["1ihu",2.15,2.86395848317755],
["1mdb",2.15,2.48453615009860],
["1ocx",2.15,2.20569864620787],
["117e",2.15,2.3045503840805],
["1vne",2.15,1.95934791651623],
["1vni",2.15,1.92408712890349],
["1m76",2.15,1.93035819987614],
["1u49",2.15,2.16439979387908],
["1vk3",2.15,2.33638734207012],
["1vm7",2.15,1.63644563391297],
["1t6d",2.15,2.14517895789732],
["1uf4",2.15,2.0684945145875],
["1lt7",2.15,2.98967030015206],
["1lev",2.15,3.16560433503204],
["1f29",2.15,1.93292157948883],
["1tb5",2.15,2.14119081604248],
["1nv7",2.15,2.9667020233777],
["1g5b",2.15,2.68832424407017],
["1po0",2.15,2.7974370462373],
["2d3i",2.15,2.59336190944188],
["1h76",2.15,2.27913808941413],
["1sqi",2.15,2.68078411246443],
["1uim",2.15,2.44464980714605],
["1r8g",2.15,2.57885490991196],
["1rjm",2.15,2.17794485982044],
["1kds",2.15,2.44061039840773],
["1ke3",2.15,2.07320666123014],
["1nvj",2.15,2.26135927505071],
["1fmw",2.15,3.19292274391279],
["1yre",2.15,2.54808929031595],
["1hq3",2.15,2.47425078177728],
["1duy",2.15,2.44553169789279],
["1cc1",2.15,2.3802046953033],
["1k7d",2.15,2.25781772550404],
["1aym",2.15,2.18152102606781],
["3ran",2.15,2.38569526900869],
["1k2r",2.15,2.73713771466547],
["2bkk",2.15,3.13917758955363],
["1v2a",2.15,3.09712682399575],
["2bh2",2.15,2.53580533947729],
["1tyo",2.15,2.55560735081651],
["1udd",2.15,2.55492551041604],
["1mlz",2.15,2.51193066103379],
["1no3",2.15,2.98709714893817],
["1yfr",2.15,3.12097997019742],
["1t0q",2.15,2.30924831542138],
["1kw2",2.15,2.32653438674701],
["1iyd",2.15,2.66645489122707],
["1v6i",2.15,2.04510453078765],
["2c63",2.15,1.78842413747307],
["1shn",2.15,2.18765092314387],
["1ezf",2.15,2.63473849823601],
["1uc2",2.15,2.22785188955471],
["1vz5",2.15,1.78724413718121],
["1tz7",2.15,2.1531612107485],
["2d1p",2.15,2.52275818703289],
["2c3d",2.15,2.26480615518031],
["2c3c",2.15,2.23944565755185],
["1nir",2.15,2.44589129811145],
["2awz",2.15,1.44167101639381],
["1qo8",2.15,3.12472343308174],
["1fp6",2.15,2.59685310134773],
["1ve5",2.15,2.85882216250832],
["2byl",2.15,2.17503829804390],
["2ahr",2.15,2.20729429580272],
["1rpn",2.15,2.33982238318413],
["1hju",2.15,2.02691275468376],
["1gqh",2.15,2.06674321376166],
["1szr",2.15,2.09347124556002],
["1ped",2.15,2.65960854931011],
["2ewc",2.15,2.19186451243085],
["1ssm",2.15,2.68372810662993],
["1jrq",2.15,2.52721084387242],
["2fuq",2.15,2.04140328839276],
["1h54",2.15,2.26230617931582],
["1kh3",2.15,2.72743159663114],
["1w72",2.15,1.74948023379765],
["1x31",2.15,2.14824027461459],
["2cev",2.15,1.91787357981097],
["1atj",2.15,2.13675682194143],
["1uvi",2.15,2.43881281134064],
["2ahw",2.15,2.10455649437757],
["1ylo",2.15,2.2039974149315],
["1fz2",2.15,2.35582903101956],
["1fyz",2.15,2.33722244644388],
["2exi",2.15,2.27980348723308],
["2afa",2.15,2.32897402237978],
["2bzn",2.15,1.86423760603521],
["2pcd",2.15,2.58487962265502],
["3pcf",2.15,2.66347176489870],
["3pcl",2.15,2.8120170048525],
["1ggh",2.15,2.35584868587118],
["1o01",2.15,1.78789352239915],
["1xhf",2.15,1.97558071538419],
["1ydh",2.15,2.05062210243652],
["1w5g",2.16,1.66733311121956],
["1czj",2.16,2.64185213238634],
["1ks3",2.16,2.62385491162398],
["1s4q",2.16,1.66959379044837],
["1xt0",2.16,2.18740826257216],
["2fsw",2.16,2.64057169152152],
["1mom",2.16,3.29609859317819],
["1c3l",2.16,2.71349652491896],
["1ljw",2.16,2.59109393290284],
["1beq",2.16,2.63917973944008],
["1u9t",2.16,3.51217582505983],
["1wbo",2.16,2.25739579757316],
["1npx",2.16,2.39035927559079],
["1zx1",2.16,2.0538233995477],
["1spq",2.16,1.27195725461636],
["1eoo",2.16,3.10309608378462],
["1w4l",2.16,2.48901756788261],
["1v8d",2.16,2.85705724625466],
["1xzu",2.16,2.6614863855107],
["1y22",2.16,2.46124086544180],
["1wls",2.16,3.14032861406927],
["1pc3",2.16,2.79671850505721],
["1t3a",2.16,2.62432730817271],
["2abz",2.16,2.59942893733149],
["1mc1",2.16,2.65472035933516],
["2azd",2.16,2.32641114182299],
["2a2o",2.16,1.35266825058453],
["1u9h",2.17,2.83743746645986],
["1w5l",2.17,2.44134392966120],
["1b5v",2.17,1.99180647552196],
["1b5w",2.17,2.20362462574166],
["1irc",2.17,2.88250867579943],
["1s7d",2.17,2.46610491031495],
["1dzw",2.17,2.42122502872824],
["1ivl",2.17,2.79730360880082],
["1qd5",2.17,2.60772563773603],
["2aix",2.17,2.20298806259392],
["1r6f",2.17,3.14836296792333],
["1z5m",2.17,2.80014595597567],
["2f2o",2.17,3.25612232689549],
["1zso",2.17,2.27833721944162],
["2br0",2.17,2.86707965423594],
["1dzr",2.17,2.55161770376596],
["1knv",2.17,2.37013313665217],
["1hfk",2.17,2.40467223820736],
["1gae",2.17,2.34209739752375],
["1zkw",2.17,2.87516556378773],
["1sh0",2.17,2.28700556971344],
["1n8j",2.17,2.17121524052811],
["1sif",2.18,2.59801911689785],
["1zk9",2.18,2.29357074874998],
["1m4a",2.18,2.87042321430396],
["1n4j",2.18,2.254718946025],
["1nr2",2.18,3.59492389707021],
["1yrv",2.18,2.94164466270982],
["1wus",2.18,1.94703351731741],
["1z6g",2.18,1.88611116116255],
["1dzx",2.18,2.69060445776453],
["1g0z",2.18,2.71534499755136],
["1u4j",2.18,3.00745486440636],
["1qdq",2.18,2.40096524462518],
["1sci",2.18,1.74662662509316],
["2a1l",2.18,2.41880637066923],
["1s1j",2.18,2.72959817977195],
["1nzq",2.18,2.60273715128235],
["1rl4",2.18,2.65314492825990],
["1jam",2.18,2.77386347769757],
["1j3r",2.18,2.40928676709919],
["1jpf",2.18,2.77173255705965],
["1zjk",2.18,2.40518200367464],
["1xk0",2.18,2.48842116137588],
["1mko",2.18,2.84220554337317],
["1d9d",2.18,3.15492353678811],
["1vrd",2.18,2.08829194493242],
["1tf5",2.18,2.88592590155429],
["1e5f",2.18,2.16310418005886],
["1e5e",2.18,1.61799179640621],
["1nvv",2.18,2.08028542278034],
["1r4c",2.18,2.67040451621258],
["1npt",2.18,2.15185493609064],
["1q23",2.18,2.92554473949640],
["2f5z",2.18,2.39831085260293],
["1kwi",2.19,2.82521454080384],
["1kxi",2.19,3.36625508251715],
["1ecy",2.19,3.76078079100476],
["1bja",2.19,2.71556831036593],
["1tjt",2.19,2.38088449055008],
["1bh3",2.19,2.30296000242847],
["2eda",2.19,2.77901394379369],
["1t21",2.19,2.0951773081746],
["1gvh",2.19,2.76786173695477],
["1yfe",2.19,2.53498448781293],
["1odb",2.19,2.20624782544338],
["2g59",2.19,2.32661378044162],
["2ae6",2.19,2.34519760304226],
["1xlx",2.19,2.61843363885924],
["1xyc",2.19,2.1176370452511],
["1s8c",2.19,2.93888592307149],
["2bk6",2.19,2.03944863655470],
["1xyg",2.19,2.13110945930941],
["2aqb",2.19,2.29126551662402],
["2bs3",2.19,2.37251395834664],
["3pcb",2.19,2.62217261869742],
["2a22",2.2,2.13378362864768],
["1xlu",2.2,2.55031129516861],
["1u9g",2.2,2.71406197176025],
["2dgc",2.2,2.23489695278797],
["1ptr",2.2,1.62553777605651],
["1bti",2.2,2.83560567044592],
["1ig7",2.2,3.06437537563221],
["1dtx",2.2,2.07624644559364],
["1ciq",2.2,2.6953374512679],
["1unw",2.2,2.98605940978064],
["1wd1",2.2,3.3508320438397],
["1coa",2.2,1.86491038846279],
["1ca5",2.2,3.87293657537759],
["1wtx",2.2,2.47440942945820],
["1wtw",2.2,2.69231725093453],
["1ca6",2.2,3.01760754002559],
["1by9",2.2,1.67044689634119],
["1f0m",2.2,3.08892656642111],
["1x8y",2.2,1.97301595759613],
["4kiv",2.2,4.0672874720917],
["2bl7",2.2,1.89697039152229],
["1bb9",2.2,2.70557266427136],
["1yhb",2.2,2.76603982303190],
["1gq5",2.2,2.53459382323315],
["1qjh",2.2,2.46323478369245],
["1rr7",2.2,3.22872191470802],
["2a66",2.2,2.59751774646359],
["1sj3",2.2,2.28745015739094],
["1i3j",2.2,2.30112322838952],
["1beo",2.2,2.36959849631537],
["2bvz",2.2,2.10220624041141],
["1odd",2.2,2.89629336560898],
["1ayd",2.2,2.61104065522040],
["1yti",2.2,2.14047719725727],
["1hef",2.2,3.37117032186497],
["1heg",2.2,3.91989774603893],
["1wrp",2.2,2.88718323178692],
["1tul",2.2,2.71204405361395],
["1fim",2.2,2.67662265962681],
["1r6y",2.2,2.70627547564426],
["4rnt",2.2,2.75235704625136],
["1gsp",2.2,1.18690470590228],
["6gsp",2.2,1.94973458878512],
["1ijr",2.2,2.47822139415609],
["1bfs",2.2,2.84180332318384],
["1fdb",2.2,2.61658802532704],
["1fkk",2.2,2.89871510498320],
["1txx",2.2,2.90056050575146],
["1cty",2.2,3.71471865948059],
["1hkf",2.2,2.4019329769349],
["3hdd",2.2,2.50743363499028],
["1zka",2.2,2.27356350165969],
["1aqe",2.2,1.58413592179267],
["1jnm",2.2,2.98534629166491],
["1aa0",2.2,2.91497754016476],
["1ecw",2.2,2.57225834943448],
["1j81",2.2,2.60656661987672],
["1igu",2.2,1.89800066650474],
["1b1u",2.2,3.92996038015244],
["1lsw",2.2,2.34481168911189],
["1jmt",2.2,2.73970389352672],
["1nbp",2.2,1.97140616544986],
["1u9f",2.2,2.33315793744668],
["1sjx",2.2,2.27744035841206],
["1rsi",2.2,2.25220697987526],
["2dhn",2.2,2.44062562794283],
["1vip",2.2,1.69602998488922],
["3sem",2.2,2.48145254050126],
["1a15",2.2,3.18900345585215],
["1cxa",2.2,2.77126095676615],
["1db4",2.2,2.87137053700430],
["1bbc",2.2,4.09266768344117],
["1bfc",2.2,3.37907096661951],
["1k46",2.2,2.24689541723133],
["1fga",2.2,3.52908964106449],
["1rpf",2.2,3.26858091569007],
["1rph",2.2,3.16675185934748],
["1dq7",2.2,3.10110207453874],
["2a7t",2.2,2.99223026117269],
["1w5j",2.2,1.90765200347039],
["2sem",2.2,2.22694973001402],
["2lz2",2.2,4.04156101846187],
["1di5",2.2,2.56643666015485],
["2fe1",2.2,1.27333134315653],
["1b5y",2.2,1.35231881173893],
["1a0k",2.2,2.47710792063692],
["208l",2.2,3.15288522601475],
["1b7m",2.2,2.67809112025214],
["1c46",2.2,3.10508690062249],
["1bhl",2.2,2.81797396995454],
["1htp",2.2,2.57532052559373],
["1pxu",2.2,1.73941155358867],
["1a3v",2.2,2.89860296459109],
["1dqo",2.2,2.58856668838540],
["1fwv",2.2,2.21798607492989],
["2pf2",2.2,4.05674859585495],
["1eni",2.2,3.05868884095115],
["1cbq",2.2,2.12207379254000],
["2foo",2.2,2.49402101625639],
["1r2h",2.2,2.22057156908929],
["1maz",2.2,2.86409694753157],
["1wmm",2.2,2.1255658356905],
["1qrv",2.2,2.25565038459996],
["1pq0",2.2,3.02951751953045],
["2fcm",2.2,2.37414552290471],
["2fcn",2.2,2.75670298291673],
["3cln",2.2,3.42942813933754],
["1vsi",2.2,2.99777476307662],
["1asv",2.2,2.79812556130127],
["1vsk",2.2,3.01561682953248],
["1vse",2.2,2.73049619824646],
["1vsl",2.2,3.40199973835692],
["1lba",2.2,2.54371898578925],
["1jmb",2.2,3.69526702783915],
["1jot",2.2,2.91058371302854],
["2a25",2.2,2.7365735079591],
["1ndk",2.2,2.55946509411206],
["4cln",2.2,4.38022139853892],
["1nb2",2.2,3.50484845513844],
["1grj",2.2,3.41574154691671],
["1ncl",2.2,2.22257409186990],
["1v8s",2.2,1.72019070841407],
["1ibf",2.2,2.17135565599589],
["1p4u",2.2,2.58321371911059],
["1jvi",2.2,2.09384241426171],
["1tp0",2.2,2.75533901846004],
["1mob",2.2,2.88780574440678],
["2mga",2.2,3.10574353078976],
["1cpw",2.2,2.54272466982991],
["1y9b",2.2,2.06234705002490],
["5pnt",2.2,2.12509930497563],
["1ihk",2.2,1.44045324275674],
["1wy6",2.2,2.25577999831874],
["1pnt",2.2,2.67146235069752],
["1z13",2.2,2.60062824593315],
["1z12",2.2,2.69907181386908],
["1fym",2.2,1.87821623419583],
["1utt",2.2,2.27040339468038],
["1rx4",2.2,2.95915057205621],
["1rx3",2.2,2.76916863559941],
["1g43",2.2,2.57358294764841],
["1lih",2.2,3.20161760272362],
["1evs",2.2,2.96951424687139],
["1x1s",2.2,2.02478014298691],
["151l",2.2,4.07142352939545],
["1c6n",2.2,2.65095657409941],
["1c67",2.2,2.69269384175201],
["2b6w",2.2,1.87243308998217],
["1c6b",2.2,2.54765589709721],
["1cu0",2.2,2.61674200294729],
["177l",2.2,3.90762644385934],
["2gbo",2.2,2.54460183611983],
["1ge6",2.2,1.90433181259681],
["1o6b",2.2,2.72661300838426],
["2tcl",2.2,1.63848322658045],
["2fg9",2.2,1.73347183204528],
["2ugi",2.2,2.42796817804684],
["2usn",2.2,2.15510229920518],
["421p",2.2,3.00065520286391],
["1cwb",2.2,2.3697153398114],
["1yg2",2.2,2.57954658586055],
["1vq2",2.2,2.26605808011310],
["1q21",2.2,3.42981556937749],
["2q21",2.2,3.67598722731859],
["1qsn",2.2,3.372077580286],
["1rcg",2.2,2.21893178981813],
["1few",2.2,2.86140018698261],
["1sl7",2.2,1.0694825097337],
["1nx2",2.2,2.18226389668456],
["1b24",2.2,3.40505747724622],
["1ino",2.2,3.13214675629945],
["1igp",2.2,3.38567103021985],
["1g2d",2.2,2.45590757119795],
["1iwn",2.2,2.62710433052988],
["2g03",2.2,2.02389754995805],
["3cd4",2.2,4.11258137707180],
["1wp7",2.2,2.79476632327244],
["2bm6",2.2,2.68861529114636],
["1am2",2.2,2.97722116171691],
["1dy0",2.2,2.00164469075538],
["1r5p",2.2,2.44022883754864],
["1wp8",2.2,2.65646581155048],
["1htj",2.2,2.56682841079699],
["1dy1",2.2,2.46298697891120],
["1ise",2.2,2.90698869435171],
["1ecm",2.2,1.72297038805718],
["1is1",2.2,2.55708406271165],
["1m5o",2.2,2.33395755231372],
["1dr1",2.2,2.82598419008003],
["1pd9",2.2,2.92455162054758],
["1u71",2.2,3.39788619997362],
["1pdb",2.2,4.17165412265249],
["1p6f",2.2,2.42500105161915],
["1qc7",2.2,2.15990303794763],
["1jyb",2.2,2.56407125011542],
["2ukd",2.2,2.24771918456998],
["1mey",2.2,3.20545542929906],
["1eje",2.2,2.65197228308803],
["1har",2.2,2.71281832562701],
["1bjz",2.2,2.38625550133609],
["1zxq",2.2,3.03947502554863],
["1fy9",2.2,2.53942816048328],
["1fya",2.2,2.30323032430659],
["1uke",2.2,2.94324360135438],
["1ohz",2.2,1.63313280474944],
["1t7j",2.2,2.16873497330826],
["1k6p",2.2,2.10369300180568],
["1aid",2.2,2.18503638692838],
["1hih",2.2,2.00738881016974],
["1htf",2.2,2.69437355745013],
["1k6c",2.2,2.04219497178244],
["1idb",2.2,2.79314134142235],
["1z8c",2.2,2.25979336575975],
["1smt",2.2,1.74501352029584],
["1qua",2.2,2.65959521049798],
["1p09",2.2,2.25165261527204],
["1yio",2.2,2.09145956350074],
["1lzq",2.2,2.64336377647909],
["1wni",2.2,2.52945632650947],
["2fap",2.2,2.37310136968968],
["1nsg",2.2,2.37552495756500],
["1g76",2.2,2.9548012863112],
["1g78",2.2,3.13892372303379],
["1gbc",2.2,1.85533192434206],
["1gbd",2.2,2.06793038158286],
["1gbh",2.2,2.17174329964546],
["9lpr",2.2,2.30813745314037],
["2fdg",2.2,1.78300129538943],
["1zlx",2.2,2.76228863237939],
["1k2c",2.2,2.40885613377819],
["2cgp",2.2,2.59834174741766],
["1cqk",2.2,2.58488531364204],
["1yn5",2.2,2.70510964894603],
["1kuu",2.2,2.90478165439843],
["2gsq",2.2,2.87524435253618],
["1qhl",2.2,3.28756436706273],
["1qsd",2.2,2.59560273399266],
["1l8d",2.2,2.68037239588661],
["1n6j",2.2,2.57122837189645],
["1a1e",2.2,2.27506720927483],
["1sgl",2.2,2.44911820419473],
["1mjm",2.2,2.50768215680562],
["1cd2",2.2,3.1888335687946],
["1imj",2.2,2.68463693508735],
["1hro",2.2,2.19329022236224],
["1bi1",2.2,2.84390980427420],
["1a1b",2.2,1.63898951228332],
["1bqs",2.2,4.09573668417686],
["1a08",2.2,1.86150698436902],
["1a07",2.2,1.96007077440784],
["1qca",2.2,2.26398802417206],
["1uyh",2.2,2.74682359044285],
["1b4b",2.2,2.87135793928572],
["2bdv",2.2,2.64932018003592],
["1boy",2.2,3.31305731554633],
["1bp4",2.2,2.36931782021888],
["1fki",2.2,2.13314716228429],
["2siv",2.2,3.07565607856569],
["1yes",2.2,2.33132280686531],
["2rbi",2.2,2.17457354044405],
["1em2",2.2,2.58865822961653],
["2aim",2.2,2.52395658533895],
["1u9v",2.2,2.43693514669164],
["1atk",2.2,2.63405851940249],
["1ayu",2.2,2.78134285537550],
["1mxs",2.2,2.63754567487457],
["1aw9",2.2,3.01798215538698],
["1mzv",2.2,2.35204909927008],
["1glo",2.2,2.39093156307929],
["1mvp",2.2,2.42642331659967],
["1mou",2.2,1.87743372459818],
["1gpc",2.2,3.18188197180712],
["1z7u",2.2,2.34640654977453],
["2cbt",2.2,4.20289066052114],
["2aoq",2.2,2.30022626159275],
["1u83",2.2,2.17627090783264],
["1ep8",2.2,2.57788515932900],
["1jv5",2.2,3.10986410222055],
["1xtn",2.2,2.50432514061021],
["1r18",2.2,2.36823311978266],
["1aw8",2.2,1.89904614869751],
["1s85",2.2,1.11817292357385],
["1k1m",2.2,1.75457739990469],
["1lqe",2.2,2.26234924086332],
["1k1i",2.2,1.84208709899869],
["1k1j",2.2,1.64152072604287],
["1btp",2.2,2.98202235761627],
["1aq7",2.2,2.67884983737130],
["1ane",2.2,2.25283752503851],
["1anc",2.2,2.58837841495939],
["1bra",2.2,2.55669981425629],
["1xxg",2.2,1.92423796106224],
["1ihn",2.2,2.29190602061756],
["1bg8",2.2,3.31938793791065],
["1dyn",2.2,3.05488676845978],
["1xji",2.2,1.96395419135731],
["1wud",2.2,1.96499552924234],
["1yln",2.2,2.49218809312726],
["1srh",2.2,3.00072528503061],
["1myw",2.2,2.49294592629075],
["1pjp",2.2,2.32814890472571],
["2brs",2.2,2.35685793039032],
["1huy",2.2,1.90543713117348],
["1kon",2.2,3.38017943641762],
["1ko2",2.2,2.05683465947019],
["1hw7",2.2,2.79769074771736],
["1x07",2.2,2.50729430547953],
["1f7n",2.2,3.04563487477324],
["1f7k",2.2,3.06879285599183],
["1z7j",2.2,1.91312591730774],
["1n69",2.2,2.40254090544416],
["1i4q",2.2,2.66393424333982],
["1scz",2.2,2.49922413537956],
["3tmy",2.2,3.15141620452173],
["1gmc",2.2,2.6988572554349],
["1gmj",2.2,1.98094075576275],
["1gha",2.2,2.75452870165749],
["1gmd",2.2,3.10140521272183],
["1qam",2.2,2.31657134204599],
["1ixz",2.2,2.60842054467611],
["1lcw",2.2,2.29193796543792],
["1k41",2.2,3.84045303258010],
["2roy",2.2,3.4379033233571],
["1r3m",2.2,2.9493968873728],
["1zh4",2.2,2.78656760596053],
["1h4u",2.2,2.72971799648749],
["1yin",2.2,2.90196527033553],
["2fof",2.2,1.87622258275373],
["2foe",2.2,2.33869970008097],
["1c1m",2.2,2.62129422532546],
["1mmj",2.2,3.48248445666226],
["1pa0",2.2,2.22412402671618],
["1ldo",2.2,2.39839896298416],
["1y92",2.2,2.39099518653172],
["1r28",2.2,2.71705534069633],
["1mn4",2.2,2.39997637633287],
["1g9i",2.2,2.91752994844991],
["1tlg",2.2,1.98220175983552],
["1q05",2.2,2.24746262069325],
["1bdy",2.2,2.09244563206892],
["1tj5",2.2,2.54566531862209],
["1joc",2.2,2.63382568982033],
["1wyy",2.2,2.29741531291067],
["1j1a",2.2,2.58983939703773],
["1ahb",2.2,2.46813327696533],
["1aha",2.2,2.20021571847064],
["1mri",2.2,3.06180057857194],
["1f8q",2.2,3.19464139592239],
["1jvv",2.2,2.62718521482816],
["1rav",2.2,3.28044480427467],
["1y94",2.2,2.86325050032425],
["2cam",2.2,3.28002818380226],
["2phi",2.2,2.99037504341138],
["1rk3",2.2,1.94024596033503],
["1xnn",2.2,2.76045153367501],
["1ab6",2.2,2.4789664325557],
["1uam",2.2,2.01060152444171],
["1qkt",2.2,2.90801842472949],
["1j4n",2.2,3.57201305383793],
["1w01",2.2,2.96922044631443],
["1plf",2.2,3.10303210505869],
["1p4x",2.2,2.95891090338531],
["2aa7",2.2,2.32987625909843],
["1s0x",2.2,2.06465174299651],
["1sp4",2.2,2.3892478982624],
["1et0",2.2,2.84304048210905],
["1xx4",2.2,2.85069286054862],
["1z3c",2.2,2.78392125808164],
["2c6d",2.2,3.01274513272047],
["1dca",2.2,2.57553075609047],
["1fx8",2.2,2.30161873940553],
["1u4r",2.2,2.31677406339516],
["5cac",2.2,2.68482365637403],
["4cac",2.2,2.56100773053187],
["1h9q",2.2,2.20186715485231],
["1cvd",2.2,2.74535113967365],
["1cct",2.2,2.65328082859027],
["1cnc",2.2,2.87000552757566],
["1i7g",2.2,2.58393117805506],
["1azb",2.2,2.60475440013732],
["6yas",2.2,1.99197430663773],
["5yas",2.2,2.12021836609837],
["1t73",2.2,1.80659359633417],
["2f5e",2.2,1.95473738960386],
["1l2c",2.2,1.95689541513708],
["1vk6",2.2,1.85930605826293],
["1obs",2.2,2.29911690023639],
["1bn3",2.2,2.42104615350283],
["1okm",2.2,1.85220881717310],
["1lg6",2.2,2.58942208705412],
["1huh",2.2,2.9579628787533],
["1kgf",2.2,2.4817119054582],
["1blc",2.2,3.47030119607802],
["1o6y",2.2,2.49920961010982],
["1b5z",2.2,2.57894330568674],
["2mea",2.2,2.50748822333493],
["1ckg",2.2,2.56306167386805],
["2mec",2.2,2.49607384128834],
["1cal",2.2,2.34605192705121],
["1ugg",2.2,2.63883864722881],
["1rwp",2.2,2.42902195820145],
["1ymp",2.2,3.77048035109751],
["1es3",2.2,2.93406138178573],
["1vpq",2.2,1.59341567774062],
["2cgw",2.2,2.88256225620304],
["2brm",2.2,2.49435580476113],
["2cgx",2.2,2.95203685812687],
["1i8n",2.2,2.27522140927573],
["1ftp",2.2,2.62624151696483],
["1bq2",2.2,2.55936723928264],
["1tsn",2.2,2.42325216670591],
["1zbl",2.2,2.06871893044286],
["1qpj",2.2,2.05806685202438],
["1bid",2.2,2.29492324099717],
["1tjs",2.2,2.62908580406311],
["1psu",2.2,2.52584626253594],
["1fs6",2.2,3.21605762921694],
["1cxz",2.2,2.26697405246491],
["3tgj",2.2,2.48215243705444],
["1eny",2.2,3.48142874111186],
["1drv",2.2,3.99340027201229],
["1dru",2.2,4.05939375815186],
["2bro",2.2,2.85256882679075],
["2f95",2.2,1.49986121057152],
["1dbp",2.2,2.04665706637176],
["1dih",2.2,3.94808352682738],
["1drw",2.2,4.03465999135247],
["1wkl",2.2,2.38346621060551],
["1bc5",2.2,3.05978016168993],
["1bfu",2.2,2.96252407828978],
["1be8",2.2,3.04076369983156],
["1yxs",2.2,2.14989395683951],
["1sbi",2.2,2.08764542233197],
["1l5p",2.2,3.05238554117834],
["1bix",2.2,2.26671059453542],
["1fxu",2.2,2.92268922271339],
["1w0x",2.2,2.85089133018389],
["1ke5",2.2,1.90673900057162],
["1phk",2.2,2.92066483002047],
["1fvt",2.2,2.26703719334821],
["1d4v",2.2,3.53707271293412],
["1r2b",2.2,2.61977657768357],
["1cnm",2.2,2.63686574159022],
["4tpi",2.2,2.3035577173065],
["1r53",2.2,2.38874150716364],
["1di8",2.2,2.1362403917923],
["1wcc",2.2,2.40391543206571],
["1zgv",2.2,2.23331362846817],
["1zgi",2.2,2.22693497630353],
["1wrq",2.2,2.37236186360278],
["1mt6",2.2,3.6612391476126],
["1xt9",2.2,2.91640066157299],
["1a61",2.2,3.56233465681688],
["1oev",2.2,1.95001587885891],
["3prk",2.2,2.76932818435925],
["1pek",2.2,3.26845818043409],
["1cf0",2.2,3.03183715858795],
["1w69",2.2,2.43911712134853],
["1pj8",2.2,3.14446121083905],
["1rsz",2.2,2.76867717349696],
["1awi",2.2,2.80300079841822],
["1wbg",2.2,2.1111144989448],
["1v3x",2.2,2.23506608456132],
["1ezq",2.2,3.29509605596494],
["1hcg",2.2,3.94515828205194],
["1ph0",2.2,2.18876123811871],
["1pyn",2.2,2.41944643866394],
["1mhq",2.2,2.91715257874471],
["1bin",2.2,3.08848653998522],
["1bhs",2.2,2.89341672370354],
["1y30",2.2,2.27472098273368],
["1n4k",2.2,2.4213799158821],
["2hbf",2.2,3.22806595859489],
["2hbd",2.2,3.37376404724063],
["1aj9",2.2,3.4055074212306],
["1fdt",2.2,2.76771122336988],
["1boi",2.2,2.37303425284906],
["1tpy",2.2,2.54912781836162],
["1lpk",2.2,2.76008825605715],
["2cc3",2.2,2.67924911254781],
["1t1n",2.2,2.85548896166519],
["2boh",2.2,2.65237108409506],
["2hgt",2.2,3.68874411904066],
["1h0o",2.2,2.67270363150791],
["1ths",2.2,3.41848038703081],
["1q6j",2.2,2.39914645209277],
["1q6m",2.2,2.69390174014353],
["1eqa",2.2,2.60649878369727],
["1b42",2.2,2.61255086442443],
["1awf",2.2,2.90132736174019],
["1t48",2.2,2.39926681537416],
["1bj9",2.2,2.30246599858722],
["1bep",2.2,2.3683598170319],
["1bem",2.2,2.74795840781718],
["1bek",2.2,2.6846572181809],
["5ccp",2.2,2.31051201715841],
["1cpd",2.2,2.5878541274045],
["1cpf",2.2,2.71187350122039],
["1ft7",2.2,2.77217602171176],
["1dcc",2.2,2.4920633252234],
["6ccp",2.2,2.37422624750518],
["7ccp",2.2,2.52622296562324],
["1cpe",2.2,2.51408146613504],
["1cpg",2.2,2.50685845138564],
["1okc",2.2,2.56039901623507],
["1b3t",2.2,2.32404521913796],
["2glt",2.2,2.64027163775845],
["1no4",2.2,2.40526051978706],
["1ebe",2.2,2.42229650179699],
["3ccp",2.2,2.41499464655349],
["4ccp",2.2,2.38784740776949],
["2ccp",2.2,2.56091414948207],
["1ccp",2.2,2.45163371946628],
["2cep",2.2,2.62614035051848],
["1tmt",2.2,2.78665191978957],
["1etr",2.2,3.29563300017295],
["1hgt",2.2,3.82292534790691],
["1ctt",2.2,3.10160052663244],
["1l6o",2.2,3.79115787327333],
["1fts",2.2,2.66756796959413],
["3ptd",2.2,3.00024915166276],
["2c0j",2.2,2.61111091070766],
["1lme",2.2,1.90696716883846],
["2f6w",2.2,2.17199665804161],
["1g7g",2.2,2.96000261025059],
["1kbz",2.2,2.4838977495799],
["1ndp",2.2,2.83190672042016],
["1uuh",2.2,2.79337183418039],
["1wax",2.2,2.26926679289268],
["1dmu",2.2,2.00205743725512],
["1mnk",2.2,2.46811247677549],
["1epb",2.2,3.2577011075721],
["1qhr",2.2,2.81604700963385],
["1qj6",2.2,2.90944939336340],
["1qj7",2.2,2.97175652411227],
["1g1g",2.2,1.74715560324416],
["1b3x",2.2,1.48731834817338],
["1mnj",2.2,2.745084526819],
["1kjn",2.2,2.62234166184102],
["1keo",2.2,3.24708361508927],
["2bq8",2.2,2.03931415899112],
["1cjl",2.2,2.26485518932903],
["1ghr",2.2,2.43769472032147],
["1iov",2.2,3.84039725372967],
["1c0e",2.2,2.88895743979823],
["1pbo",2.2,2.80889248012799],
["1ufh",2.2,2.1989547114877],
["1tg2",2.2,1.96745884057660],
["1d9y",2.2,3.05825172821730],
["1h43",2.2,2.63819169244521],
["1rz6",2.2,2.18299881579595],
["1png",2.2,2.38663698784090],
["1yip",2.2,2.72324387007090],
["1d1p",2.2,2.38274868085578],
["1tw0",2.2,1.99771298453274],
["1n3a",2.2,2.60677374373176],
["1n39",2.2,2.55837968267691],
["1bge",2.2,2.54134671592028],
["1gfi",2.2,1.85181983905798],
["1nml",2.2,2.13031983241688],
["1bws",2.2,2.89931717036893],
["1gkz",2.2,3.12148130447428],
["1eko",2.2,3.27325881842144],
["1v6y",2.2,1.73413263032375],
["1qf0",2.2,1.88293909012874],
["8tli",2.2,2.23243744191628],
["1fjt",2.2,1.79957499474828],
["1dds",2.2,2.92123706225837],
["1tsy",2.2,2.48524250031072],
["1hse",2.2,2.75888650019393],
["1gfs",2.2,2.21981813939008],
["1bsv",2.2,2.09712041931050],
["1pug",2.2,3.36901642180428],
["1shw",2.2,3.39048365593877],
["1bcz",2.2,3.39081550062974],
["4cms",2.2,2.96199385929971],
["1kn1",2.2,2.54606653504268],
["1bao",2.2,2.60496949739174],
["1t3l",2.2,2.79288597835052],
["2f8l",2.2,2.10043187688405],
["1z7w",2.2,2.46827309788187],
["2dap",2.2,2.85265104210306],
["1brg",2.2,2.8258414769198],
["1bof",2.2,1.63011092590620],
["1gdd",2.2,2.41821531142897],
["1ban",2.2,2.83065888813476],
["1a5t",2.2,2.82459731202780],
["1a74",2.2,2.98692854804307],
["1ipp",2.2,3.23849994630204],
["2cya",2.2,2.23054093099826],
["1jil",2.2,2.43653006255502],
["1yjm",2.2,1.27228678837796],
["2ged",2.2,2.25956380261102],
["2bcs",2.2,1.97061724122606],
["1vmo",2.2,3.29338097053706],
["1hqt",2.2,3.25281975824745],
["2bgu",2.2,2.13007491787112],
["2a0s",2.2,1.88654750246842],
["1wy0",2.2,2.7326123604273],
["2bgt",2.2,2.37141612744458],
["1au1",2.2,2.83495054603444],
["2bcu",2.2,2.18924200926447],
["1qxh",2.2,2.31725436941441],
["176l",2.2,3.72421772269853],
["1psn",2.2,1.50131330774953],
["1yh0",2.2,2.38800260637998],
["167l",2.2,3.46481655947169],
["1bpy",2.2,3.7400145154316],
["1m1d",2.2,3.10286693929925],
["1i5s",2.2,2.84358936153083],
["2ag9",2.2,3.1544855830544],
["1sbq",2.2,2.90645580994688],
["1xsp",2.2,1.83464480721728],
["1skm",2.2,2.33560069005914],
["1day",2.2,2.66279440743864],
["1z0d",2.2,1.74057642314051],
["1m83",2.2,2.59038221273452],
["1n7w",2.2,2.26909998426021],
["1oc1",2.2,1.83616417032157],
["2bak",2.2,2.49425100625502],
["1v04",2.2,2.44580746979380],
["1g4w",2.2,3.13016234234813],
["1dw2",2.2,2.23900312836791],
["1yq7",2.2,2.37705105705828],
["3rap",2.2,2.44245290544566],
["1rej",2.2,2.68399600963506],
["1nid",2.2,2.20749611989485],
["1xho",2.2,1.23301477228193],
["1mze",2.2,2.31176380346975],
["2er9",2.2,2.96480727729298],
["1s2j",2.2,2.43814854273801],
["2eip",2.2,2.03950405736804],
["1gs6",2.2,1.83548525954448],
["1gex",2.2,2.13110807432287],
["1bov",2.2,2.96968459885605],
["1cqf",2.2,1.38583268423517],
["2alt",2.2,3.19929872193555],
["1wgc",2.2,3.25641219262682],
["2wgc",2.2,3.21538948894191],
["1k7v",2.2,3.13691936206819],
["1k7u",2.2,3.48876163660836],
["1tec",2.2,3.03998357721099],
["1hxx",2.2,2.42621981259643],
["1si7",2.2,2.25215000203295],
["1al8",2.2,2.49698284058837],
["1ohe",2.2,1.9436310650506],
["1pmn",2.2,2.66922586398819],
["1juo",2.2,2.72621697028151],
["1dhs",2.2,2.04705767363830],
["1z9u",2.2,2.39389100354768],
["1n48",2.2,2.71065090460519],
["1nqk",2.2,2.48153790989827],
["1f7o",2.2,2.44124275606391],
["2f8c",2.2,2.21765338698499],
["1jdj",2.2,2.15961346470934],
["1slx",2.2,2.76758317093023],
["1pmq",2.2,2.58375922285004],
["1ipd",2.2,3.29144265611671],
["1me9",2.2,2.31243949492507],
["1v43",2.2,2.7094857458044],
["1jhm",2.2,2.8186322460772],
["1jhp",2.2,2.94293766193227],
["1l4k",2.2,2.20962254133615],
["1gp5",2.2,1.65420206816751],
["1mei",2.2,2.20504149278999],
["1xuz",2.2,2.40528803209332],
["1g4r",2.2,2.86457460354336],
["1efy",2.2,2.48799913116495],
["4erk",2.2,3.64713586555331],
["1air",2.2,2.33273716054194],
["2ewe",2.2,2.12353389288563],
["2pec",2.2,2.42687851807432],
["1yds",2.2,3.00674101457756],
["1ydr",2.2,3.06019560447722],
["1q8w",2.2,2.11265028125237],
["2erz",2.2,2.9196673183556],
["1w82",2.2,1.64993248992977],
["1w84",2.2,1.79470364213671],
["1o88",2.2,2.04250643526113],
["1o8g",2.2,1.75627609993227],
["1o8f",2.2,2.22896437530696],
["1o8m",2.2,2.09738932081242],
["1o8d",2.2,1.97990041551059],
["1o8j",2.2,2.26224581770380],
["1o8i",2.2,2.13452119132954],
["1o8k",2.2,2.18626740674069],
["1plu",2.2,2.29090396213270],
["1o8l",2.2,2.46757512719071],
["1o8h",2.2,2.37380336077958],
["1o8e",2.2,2.49715848412261],
["1qlg",2.2,2.84155455726555],
["1yfz",2.2,2.56777678917652],
["1fg3",2.2,2.25346829625538],
["1iji",2.2,2.20632488882796],
["1atp",2.2,3.49772497611793],
["1fmo",2.2,3.64329604018554],
["2btz",2.2,2.84911047718992],
["1jbp",2.2,3.20058335068746],
["1jpk",2.2,2.19838809917266],
["2a4n",2.2,2.76339005629915],
["1dp5",2.2,2.43187317003063],
["1gqp",2.2,2.68388213497817],
["2bm4",2.2,2.54659972281408],
["1f8f",2.2,2.46775600126715],
["2ao8",2.2,3.09772617235099],
["1u31",2.2,1.98593425434209],
["1xdd",2.2,1.93226805285108],
["1h6p",2.2,2.90759881521116],
["1l4i",2.2,2.35948352085853],
["1dzt",2.2,2.09911192645502],
["1ej1",2.2,3.04286129971220],
["1pcz",2.2,2.9705049276201],
["1lq0",2.2,2.19577109674135],
["1b78",2.2,3.1766344697885],
["2mjp",2.2,3.42584125283607],
["1js0",2.2,2.64892850540712],
["1zkb",2.2,2.03521573260731],
["1iz2",2.2,2.94064921912279],
["1wke",2.2,2.60698398769693],
["1wkf",2.2,2.80735451484212],
["1ao3",2.2,2.64459539997526],
["1jxp",2.2,3.57574491753062],
["1tbu",2.2,2.99857673928538],
["1gwj",2.2,2.77336615362768],
["1rp4",2.2,2.68986767927491],
["1k2d",2.2,3.05508040791128],
["1wu5",2.2,1.60335565177591],
["1kbg",2.2,2.55886466134814],
["2ct9",2.2,2.18975994851802],
["1etp",2.2,2.45886809845729],
["1fxi",2.2,4.66882195397675],
["1tip",2.2,2.28473696167336],
["1s8d",2.2,2.21452599343753],
["1yn7",2.2,2.41348428757412],
["1t20",2.2,1.77457277547002],
["1t1x",2.2,2.06944886354772],
["1t1w",2.2,2.04441444827704],
["1t22",2.2,2.19167370585939],
["1s9w",2.2,2.21783584292410],
["1agb",2.2,2.08869465310642],
["1agf",2.2,2.16348588391683],
["1inq",2.2,2.76064039538880],
["1yn6",2.2,2.58027983868658],
["1jpg",2.2,3.03576333018750],
["5sic",2.2,3.85660486167125],
["1ty4",2.2,2.67301128970424],
["1qew",2.2,2.14935303492229],
["1e27",2.2,2.42770033345921],
["1c80",2.2,2.87956595392886],
["1ycs",2.2,3.50960353146068],
["2bu1",2.2,2.26483780148471],
["1h30",2.2,2.55007544674844],
["1lgf",2.2,2.36299284316346],
["1xoe",2.2,2.72952462572870],
["1nn2",2.2,3.05135500883020],
["1fl1",2.2,2.33071675939225],
["1n49",2.2,3.08632200311107],
["1cc6",2.2,1.88480697355964],
["1bf3",2.2,2.12484852616828],
["1bkw",2.2,2.34434594384347],
["1d2k",2.2,2.34922517845146],
["1n0j",2.2,2.46301770598404],
["1ap5",2.2,3.03797004524668],
["1ius",2.2,2.14159333727921],
["1k0j",2.2,2.56721245839894],
["1g4x",2.2,2.90259274445982],
["1g7w",2.2,2.85673427595708],
["1g7x",2.2,3.02175838992147],
["1ix8",2.2,2.74659333829529],
["1asd",2.2,2.67557484657279],
["1qir",2.2,2.79283397796328],
["1ix7",2.2,2.85251350356987],
["1ix6",2.2,3.07215173778921],
["1amq",2.2,3.24623071353654],
["1xrg",2.2,1.28160220315011],
["1pm7",2.2,2.73261678243900],
["1v9c",2.2,2.66713157047141],
["1q0h",2.2,1.89273142294179],
["1i6x",2.2,2.66123753870274],
["1m4z",2.2,2.34706656575598],
["2ce4",2.2,2.05308027381545],
["1phz",2.2,2.87772359045998],
["1a39",2.2,1.95601356202141],
["1mk7",2.2,2.19999439503595],
["1sce",2.2,2.91911866153026],
["1x0m",2.2,2.64755894767405],
["1kmk",2.2,2.33834748154761],
["3sc2",2.2,2.86913066975257],
["1l7o",2.2,2.6317117363558],
["1bhm",2.2,2.83286251277172],
["1lwl",2.2,2.29150989348351],
["1a04",2.2,1.98714531829239],
["1gjm",2.2,2.03850813916721],
["1noo",2.2,1.99718749551537],
["3fyg",2.2,3.94861462472949],
["1saw",2.2,1.89258109969998],
["1mmm",2.2,2.00223463909158],
["1tc0",2.2,2.37149267281263],
["1igo",2.2,2.23064994450288],
["1iec",2.2,2.81304686052864],
["1www",2.2,3.38247792895901],
["1q4o",2.2,3.15791834315517],
["1vlm",2.2,1.48501912797245],
["2mip",2.2,3.52428945731421],
["1id4",2.2,2.60183667786132],
["2col",2.2,3.61986315376747],
["10gs",2.2,2.36712365246870],
["1iqu",2.2,2.38450091637252],
["1zot",2.2,3.52583578475658],
["7gss",2.2,2.52549081005027],
["1n9k",2.2,2.00041409330467],
["2glr",2.2,1.6000581398744],
["1q4j",2.2,2.55569503552490],
["1jda",2.2,3.25569729215948],
["1xwb",2.2,2.35285147718119],
["1rhg",2.2,2.86619244774014],
["1gnw",2.2,2.63349910029653],
["1nus",2.2,2.74344753123819],
["1gao",2.2,2.65511759432975],
["1ko0",2.2,2.17259001658548],
["1ay1",2.2,3.37782484156295],
["1qfh",2.2,1.94746960617622],
["1ind",2.2,3.30223308708185],
["1xwa",2.2,2.68360326502906],
["1f75",2.2,1.99320039494438],
["1f82",2.2,3.27032149951323],
["1i6o",2.2,2.27273386902446],
["1kw1",2.2,1.55934612288769],
["4ake",2.2,2.7214074179378],
["1dvg",2.2,2.52127893110736],
["1twn",2.2,2.04330487984787],
["1xk2",2.2,2.57935225097844],
["1sza",2.2,1.88368716775408],
["1a1v",2.2,2.17472199297574],
["1ngy",2.2,2.99707319644947],
["1kut",2.2,3.17525343655843],
["1vb3",2.2,2.56467619870574],
["1kcu",2.2,3.51919581304443],
["1bjm",2.2,3.87881590987573],
["1m0n",2.2,3.19127569650053],
["1qf4",2.2,2.11390116826562],
["1loo",2.2,2.64669358159835],
["1y2a",2.2,2.68775190125371],
["2cgr",2.2,2.92085263095056],
["1t33",2.2,2.52876744711640],
["2ck0",2.2,2.83768380667697],
["6gst",2.2,2.79020266935364],
["1mtc",2.2,3.15555378293707],
["6gsy",2.2,3.36385865519964],
["1kem",2.2,3.1661431537274],
["1pdz",2.2,3.01509031795127],
["1mwo",2.2,2.32939085526387],
["1s9q",2.2,1.79455211017511],
["1sp3",2.2,2.99019716677611],
["1riv",2.2,1.98676359754542],
["1scf",2.2,2.53391400734629],
["5enl",2.2,2.53552490160687],
["6enl",2.2,2.71816129688425],
["7enl",2.2,3.49421087715371],
["1kpc",2.2,3.29661995420221],
["1il1",2.2,2.70186456037891],
["1f8t",2.2,2.38306222267773],
["1eob",2.2,2.25720072679799],
["2cvh",2.2,3.49377050331889],
["1yee",2.2,2.86936135137247],
["2bwu",2.2,1.13638058152565],
["1eyr",2.2,2.33325874448927],
["1yxw",2.2,3.00757704835405],
["1lvb",2.2,2.80133532757069],
["1uth",2.2,2.35820071329307],
["1trn",2.2,2.55328134915859],
["2a2d",2.2,3.57627174815106],
["1im8",2.2,2.57277274837901],
["1uyq",2.2,2.53229307476598],
["1th0",2.2,2.63016503550721],
["1o0q",2.2,1.98180472843514],
["1yt1",2.2,2.15785796912081],
["1u16",2.2,2.38791213433370],
["5aop",2.2,2.20765069320958],
["8gep",2.2,2.77261866993611],
["1ulz",2.2,2.27939934311789],
["1fvc",2.2,2.89728330956152],
["1s54",2.2,2.52470344532196],
["1pxs",2.2,2.53899267195662],
["1tn5",2.2,2.65467309201080],
["1gcb",2.2,2.57103785651169],
["1wty",2.2,2.74605798864203],
["1k35",2.2,2.99226117279752],
["1xpi",2.2,2.24131665369259],
["1nl0",2.2,2.74650820706661],
["1rhj",2.2,2.55281472853225],
["1tv3",2.2,1.90252891268668],
["2eue",2.2,2.81102773335011],
["1dev",2.2,2.93339483167405],
["1x76",2.2,2.48377764011015],
["1z9s",2.2,2.23642891900353],
["1tji",2.2,2.35622167831932],
["1swn",2.2,2.46591303327236],
["1nc3",2.2,2.32408962172645],
["1y6q",2.2,2.22286115039313],
["1y6r",2.2,2.03082352018238],
["1bpl",2.2,2.51714989982113],
["2fm8",2.2,1.936403929808],
["1t0u",2.2,2.73272354395871],
["2c1m",2.2,2.67401998465947],
["1del",2.2,2.93158181138318],
["1ig8",2.2,2.46895452588244],
["3gly",2.2,2.04003974354877],
["1hql",2.2,2.44611088629562],
["1pfo",2.2,3.24786174515097],
["1chu",2.2,3.01405341079494],
["1zaf",2.2,2.88021094052028],
["1tzd",2.2,3.93549714001446],
["1njg",2.2,3.41424602157160],
["1fx5",2.2,2.41070805210332],
["1n46",2.2,2.81691719472982],
["1q8o",2.2,1.83070990867332],
["1n3q",2.2,1.74563849549665],
["1wow",2.2,1.88251342046201],
["1e40",2.2,1.82518778582113],
["1g40",2.2,4.11771621151539],
["1h93",2.2,1.91745878077646],
["1y8e",2.2,4.22443593528731],
["1y13",2.2,2.12341271085171],
["1qcb",2.2,2.46227488636863],
["1tgv",2.2,2.08084506042855],
["1oxn",2.2,2.52768508818379],
["1b5d",2.2,1.96819674271268],
["1ydv",2.2,2.14633352623697],
["1s3f",2.2,2.58784022025432],
["1byd",2.2,3.11473095817324],
["1byc",2.2,3.01826130035454],
["1bya",2.2,3.39299855280887],
["1mkm",2.2,3.35867991457196],
["2g38",2.2,2.27722977540752],
["1wyi",2.2,3.44423179297826],
["1h6g",2.2,2.59113544963922],
["1y2o",2.2,2.09331859425267],
["1iih",2.2,2.59800357441195],
["6tim",2.2,2.83438773069746],
["1pig",2.2,2.20366778523394],
["1ppi",2.2,2.15197881848366],
["1xh2",2.2,2.42503657031612],
["1xd1",2.2,2.50497520293114],
["1ka2",2.2,2.70569466390912],
["1cc2",2.2,1.84785874965302],
["1tgy",2.2,2.16322759593136],
["1csm",2.2,2.61532466479592],
["1uxt",2.2,2.63562557264317],
["1hp4",2.2,1.51189923351617],
["1c9k",2.2,3.59509443111031],
["1w6w",2.2,1.66534601185677],
["1lbz",2.2,3.86046330766243],
["1zvp",2.2,2.74057127106132],
["1w8e",2.2,1.59809171678619],
["1bs8",2.2,2.97919847033260],
["1cpj",2.2,3.19545313742527],
["2aa5",2.2,1.98936966942926],
["1b15",2.2,2.33907256994812],
["2tsa",2.2,2.88976552674561],
["1ils",2.2,2.07250200887701],
["1nzr",2.2,2.25543980966334],
["1ufa",2.2,2.25378755371821],
["1zjh",2.2,3.11980710272955],
["1ad1",2.2,1.65415469882223],
["2f08",2.2,2.87387614481865],
["1x8u",2.2,2.57226736609325],
["1d8a",2.2,3.06753511646514],
["1dfh",2.2,2.36013356313002],
["1k1f",2.2,3.40498219906226],
["2ab5",2.2,2.04728896784564],
["1dwq",2.2,2.56201188163666],
["2b5d",2.2,2.98408449962879],
["2ar8",2.2,2.08041276033378],
["1e8d",2.2,2.42767547921371],
["1dwo",2.2,2.45856466118784],
["1dwp",2.2,2.47275984857631],
["1b40",2.2,2.28330337120841],
["1wn0",2.2,2.35279462662901],
["1ete",2.2,2.71675188770634],
["2an4",2.2,2.02526378596697],
["1j7l",2.2,2.14771164488489],
["2an3",2.2,1.83722551908514],
["1som",2.2,2.46323374523952],
["1jtu",2.2,2.75968880588802],
["2kce",2.2,2.17488594109805],
["1odc",2.2,2.39680810075422],
["1s5h",2.2,1.94510381768798],
["1hx8",2.2,2.80988310426908],
["1fqo",2.2,2.56536867893689],
["1frz",2.2,2.70625737524462],
["1n7v",2.2,2.59047271061554],
["1gqr",2.2,2.54796120139529],
["1vxr",2.2,2.45194141497371],
["2cek",2.2,2.55297475369121],
["1nv8",2.2,2.80131045915970],
["2bj3",2.2,2.73211034887788],
["1gt6",2.2,2.69411043843885],
["1pv8",2.2,3.08712978439568],
["1ba3",2.2,2.14169582560915],
["1prg",2.2,3.26500768443504],
["1qz7",2.2,2.78869359307421],
["1e9n",2.2,2.69641037774849],
["1d1j",2.2,2.40067577662234],
["1v0b",2.2,2.55841106411101],
["2bvl",2.2,1.90526450931113],
["2gaw",2.2,2.55096753843525],
["1imb",2.2,2.13373964650599],
["1mnq",2.2,3.08204932736279],
["1dbq",2.2,4.00801395373959],
["1vb5",2.2,2.31501442172662],
["1mn6",2.2,2.479017708993],
["1yvz",2.2,2.61636725434647],
["1xl3",2.2,2.59770493114791],
["1g7r",2.2,3.44867782024466],
["1bsf",2.2,3.78605283583322],
["1m53",2.2,2.71489140438084],
["1wgi",2.2,1.90564837559031],
["1aus",2.2,2.59801681841495],
["1huk",2.2,2.7652578908046],
["1jf7",2.2,3.02498402887810],
["1hda",2.2,2.29050716458740],
["2hhe",2.2,3.19544579592731],
["1qvc",2.2,3.86462046740676],
["1mkx",2.2,3.40731852709944],
["1p2e",2.2,2.79744095120698],
["1zup",2.2,2.26366537152103],
["1uh5",2.2,2.30160163046714],
["1si4",2.2,2.5745282461701],
["1y5k",2.2,2.41735774892691],
["1j7s",2.2,2.21466517076335],
["1yh9",2.2,2.17400426656305],
["1hdb",2.2,2.36481279581686],
["2hhd",2.2,2.65655657935629],
["1ep1",2.2,3.05848373945555],
["1wtg",2.2,2.21097805797160],
["2a2l",2.2,2.56706012238218],
["1hbh",2.2,2.59679334411147],
["1g5p",2.2,3.16731015752624],
["2nip",2.2,3.19493614854503],
["1ixc",2.2,2.18079672974109],
["1vng",2.2,2.04465644373161],
["1jzk",2.2,1.79182465370343],
["1rbl",2.2,2.64141517129761],
["1xb0",2.2,2.60355840733774],
["1zc6",2.2,2.76484713164379],
["2aa4",2.2,1.92850487575839],
["1mp3",2.2,2.28896200712223],
["1mp4",2.2,2.45681372588162],
["1dia",2.2,1.60773149706433],
["1dig",2.2,1.61778684349712],
["2fjn",2.2,2.57051565009823],
["1q6s",2.2,2.5911284897087],
["1vq0",2.2,2.01108284728402],
["1s4c",2.2,3.12377774405483],
["1il0",2.2,2.25258052855884],
["1dku",2.2,2.5390652286479],
["1tsr",2.2,3.75900074949297],
["1tup",2.2,3.78634091678998],
["1n1q",2.2,2.47637026831839],
["1xva",2.2,3.02821335027789],
["2hdh",2.2,2.19420319191107],
["1fvr",2.2,1.81865196222879],
["1guy",2.2,1.97356917993895],
["1jez",2.2,2.07509111886063],
["1ulg",2.2,2.84710575212847],
["1gml",2.2,2.14936893998538],
["1fch",2.2,1.71166566678206],
["1r42",2.2,3.10682613013435],
["1jlx",2.2,2.54386219897346],
["1jly",2.2,2.56327737621313],
["1qsl",2.2,2.97073714665461],
["1krp",2.2,3.05757312341263],
["1e2m",2.2,2.56778385170757],
["1ex1",2.2,2.39071145298112],
["1uk2",2.2,3.26158774128216],
["1iex",2.2,2.23443219280214],
["1ki7",2.2,3.16032788737013],
["1ki8",2.2,3.17913347406633],
["1f7u",2.2,2.50424417829409],
["1e2n",2.2,2.54308377469601],
["1gaw",2.2,2.39936221967723],
["1wsg",2.2,2.81704271306475],
["1gw6",2.2,2.05084640279385],
["1ki2",2.2,3.36673133213849],
["1qyc",2.2,2.79435541570269],
["1wql",2.2,2.11943650767501],
["3atj",2.2,1.81448887525834],
["1i74",2.2,3.04108747483809],
["1gx2",2.2,1.69512559813798],
["1to5",2.2,1.92675896473691],
["1mz5",2.2,2.74898035616652],
["1w6c",2.2,1.88040063737521],
["1av4",2.2,2.54950025185954],
["1avk",2.2,2.75782990870724],
["1oak",2.2,3.02004896248662],
["2fhr",2.2,2.30151927094215],
["1oas",2.2,2.24128555870643],
["1w54",2.2,1.783803632485],
["1ucw",2.2,1.77515242253084],
["1fpj",2.2,2.45851634613951],
["1fpe",2.2,2.54145561081439],
["1s46",2.2,1.43066149612035],
["1nn4",2.2,2.87853521965170],
["1juq",2.2,2.44900788504531],
["1wsa",2.2,2.86263338037892],
["1i5p",2.2,2.73611883660734],
["1te0",2.2,3.93128282932981],
["1ww6",2.2,2.89858875059972],
["1ww5",2.2,2.95804880932074],
["1sz2",2.2,2.84926677552368],
["1izj",2.2,2.46266715736676],
["1izk",2.2,2.30903035416299],
["3dap",2.2,2.45592219440581],
["1dap",2.2,3.28288397222185],
["1ev9",2.2,3.20061666199919],
["1goh",2.2,2.69380219949105],
["1kbu",2.2,3.80101430539252],
["1o7h",2.2,2.42331319979793],
["4crx",2.2,3.33309685462936],
["1xb2",2.2,2.5758822108971],
["1xah",2.2,2.94660221666303],
["1bks",2.2,2.89929702409888],
["2d00",2.2,3.05789120350025],
["1kwk",2.2,1.96562592409080],
["150l",2.2,3.54555682138312],
["2irf",2.2,2.21877931680280],
["1ev4",2.2,2.97467253694172],
["1c8v",2.2,2.79681299517761],
["1qor",2.2,2.44454079911252],
["1tv8",2.2,2.69614428328222],
["1vg0",2.2,2.32025639732646],
["12as",2.2,3.19030935547559],
["1tu4",2.2,2.68490627217484],
["2bks",2.2,2.82179765846094],
["1wdt",2.2,2.26939884313527],
["1j49",2.2,3.23684844466481],
["9ldb",2.2,3.27377696450837],
["2cvx",2.2,2.82598529562313],
["1gjy",2.2,3.37594776555089],
["1ii7",2.2,2.27226733765263],
["1pz1",2.2,2.42226212932185],
["1y1o",2.2,2.54191138739907],
["1w5b",2.2,2.81424788463223],
["1q3d",2.2,2.19433751026274],
["1y0g",2.2,2.55489129663072],
["1ps9",2.2,2.98350671290230],
["1rdy",2.2,2.85863978002154],
["2c6g",2.2,2.11808040763998],
["1rzm",2.2,2.57457099996881],
["1cno",2.2,2.00958210457086],
["1rib",2.2,2.20750001374494],
["1piu",2.2,2.38815614748379],
["1pfr",2.2,2.90545065964032],
["1noz",2.2,3.66309353926578],
["1m8w",2.2,2.31707316759553],
["1rsv",2.2,3.03182672855799],
["1m8x",2.2,2.59470636347126],
["1sb7",2.2,2.5661018101861],
["1yiq",2.2,2.85446414065709],
["1cxi",2.2,2.34007343602215],
["2ca6",2.2,2.77244410786234],
["1dr0",2.2,3.46558111256428],
["1vkg",2.2,3.02905674938296],
["1fck",2.2,2.84067738836067],
["1lfg",2.2,3.40279757246374],
["1b0l",2.2,3.16659312895989],
["1ker",2.2,1.91421315527588],
["1iug",2.2,2.66191262087271],
["1u19",2.2,3.63086527416705],
["1fro",2.2,1.86606906551758],
["1tk6",2.2,2.35454157876771],
["1tkp",2.2,2.48547557377215],
["1pr0",2.2,2.7369109961958],
["1vz2",2.2,1.77482720488233],
["1noy",2.2,3.30483717878728],
["1m50",2.2,3.04889903328343],
["1bh5",2.2,2.11122950619753],
["1z5l",2.2,2.84747078053159],
["1yta",2.2,2.09182054249436],
["1f6r",2.2,2.72960194907795],
["1f6s",2.2,2.55408736928506],
["1n7r",2.2,2.95899729813680],
["1n4m",2.2,3.55809990449227],
["1s7h",2.2,2.82072933864979],
["1hgy",2.2,2.46905772563357],
["1leh",2.2,3.19533115308064],
["1w6j",2.2,1.85752030125045],
["1jmo",2.2,2.86785328174832],
["1ru3",2.2,3.49238006681466],
["1a5l",2.2,2.36795445427367],
["1jcs",2.2,1.92638736046834],
["1kzo",2.2,2.12560469779421],
["1lta",2.2,2.04546725219710],
["1qmd",2.2,1.76176197269229],
["1ejh",2.2,2.80738578263718],
["2cyc",2.2,2.19400360831586],
["1xx9",2.2,2.98185455664892],
["1p0c",2.2,2.33543886074447],
["1mp0",2.2,2.06783682257052],
["1deh",2.2,2.53668759893382],
["1hsz",2.2,2.29382550037146],
["1obh",2.2,1.95498870478120],
["1ftx",2.2,2.46275218955687],
["1niu",2.2,2.58210430172337],
["1epv",2.2,2.75308121464048],
["1s7v",2.2,3.08488217970316],
["1i7r",2.2,2.31812963926350],
["1i1y",2.2,2.43580029276607],
["1tdt",2.2,2.32286945607987],
["1h6c",2.2,2.66511313529466],
["1ryd",2.2,2.65706540165198],
["1t7p",2.2,2.41232200834954],
["1nqw",2.2,1.83715119834924],
["1fwj",2.2,2.19017375784149],
["1b5o",2.2,2.21138697229769],
["1a5k",2.2,2.28830058396925],
["1lns",2.2,2.56200606399402],
["1n31",2.2,2.25695704101759],
["1ur4",2.2,2.50099517753212],
["1ji3",2.2,2.53427822050171],
["2bgg",2.2,2.83723286750643],
["1tk5",2.2,2.49227676395571],
["1sl1",2.2,2.59518235052348],
["2ay4",2.2,2.55888698436743],
["2ay1",2.2,2.55561723360061],
["2ay8",2.2,2.69373833683362],
["2ay6",2.2,2.7488051060732],
["1nsb",2.2,2.30186645673126],
["1a4g",2.2,2.40981467338872],
["2bet",2.2,1.46861129145216],
["1cl2",2.2,1.99263524647978],
["1t3d",2.2,2.14916425299171],
["1hf2",2.2,3.16925389503823],
["1zm7",2.2,2.24333745466327],
["1nq3",2.2,1.93764197986842],
["1wy7",2.2,2.97335828973744],
["1qe5",2.2,2.63265962134614],
["1lxm",2.2,3.39220732606833],
["1kyq",2.2,2.78964863135253],
["1x2a",2.2,2.84175081232475],
["1x29",2.2,2.87142692109143],
["1aia",2.2,2.84774005380712],
["1arg",2.2,3.18920574506286],
["1lgy",2.2,2.78619108072215],
["1nvu",2.2,2.20037168309974],
["2a39",2.2,1.72144305407307],
["1jvs",2.2,2.74932953535663],
["1nf2",2.2,3.29536425014901],
["9aat",2.2,2.51281404711515],
["1tar",2.2,2.79733518427051],
["1p2b",2.2,2.44492313585877],
["1p29",2.2,2.3874690514908],
["1fc5",2.2,2.50489514582627],
["2boa",2.2,2.99435986752585],
["1k2u",2.2,2.81878587117632],
["1k2t",2.2,2.70773429765767],
["1i08",2.2,1.82028182618470],
["1i8q",2.2,3.49856038737542],
["1syo",2.2,3.31191996541744],
["1su3",2.2,2.30600599116235],
["1obk",2.2,2.4778393958051],
["1obi",2.2,2.63454729150946],
["2a5v",2.2,2.00266553437180],
["1zrq",2.2,2.04929117482858],
["1iof",2.2,2.87745073910039],
["1e8x",2.2,3.46861124394484],
["1d1y",2.2,2.61756183240557],
["1fol",2.2,2.65435314958926],
["1pt8",2.2,2.33704101307943],
["8gpb",2.2,3.22889951946672],
["1bk5",2.2,2.37636154595402],
["1iic",2.2,2.79265595638858],
["1xgv",2.2,2.78330840303977],
["1rfi",2.2,2.27946464452032],
["1hu9",2.2,3.34741667329502],
["1s06",2.2,2.17139408937591],
["1owc",2.2,3.08764680304181],
["1k3p",2.2,3.21722011986399],
["1hxs",2.2,2.12788323947276],
["1p5h",2.2,2.41088576937556],
["1xtf",2.2,2.85776935282720],
["1bou",2.2,2.70777343280383],
["2pcp",2.2,3.77425352472633],
["1lny",2.2,2.51496181698807],
["1v2i",2.2,2.75290062427015],
["1jc5",2.2,2.51311829328742],
["1ct8",2.2,2.92538573267838],
["1j1j",2.2,3.13419687771756],
["4cel",2.2,1.5093980148683],
["1kc7",2.2,2.93985776005884],
["1p2z",2.2,2.30097837499894],
["1fuj",2.2,3.29806425142243],
["1unl",2.2,2.68606831994601],
["1jxv",2.2,2.74479888557135],
["1gon",2.2,2.07354214257043],
["1p35",2.2,2.73956297997373],
["1ali",2.2,2.22266292629207],
["1qfj",2.2,2.77794452173565],
["1bd4",2.2,3.7668514239604],
["1ewk",2.2,2.09515475555317],
["1c9u",2.2,2.8825570461661],
["1zpy",2.2,3.11217948169235],
["2hrp",2.2,3.08059303290923],
["1t0s",2.2,2.72857946357171],
["1hy0",2.2,2.48102500084158],
["1loa",2.2,3.05271537302901],
["1geu",2.2,2.21660916809984],
["1ew8",2.2,2.60614720187736],
["1ivy",2.2,2.4856256010413],
["1s8a",2.2,2.21603878997801],
["1ucy",2.2,3.44065165733301],
["1tzg",2.2,2.40985431115563],
["1u2g",2.2,1.99767102492743],
["1b47",2.2,3.11050818900011],
["43c9",2.2,2.61885269694260],
["1k0d",2.2,2.59172132276252],
["1wm9",2.2,1.75671051154203],
["1vrt",2.2,3.02784764457393],
["1qu2",2.2,3.35895375281236],
["1ffy",2.2,3.35945518464775],
["1za1",2.2,3.34799809374697],
["1rzj",2.2,3.282564257215],
["1g9m",2.2,3.43389018782392],
["1z5c",2.2,2.16359111030566],
["1z5a",2.2,2.41478483560631],
["1mt1",2.2,1.87694306750708],
["1vlh",2.2,2.22823980988907],
["2fgy",2.2,2.07341800767775],
["1q2l",2.2,2.80366846210193],
["1stz",2.2,2.51867585467808],
["1t5f",2.2,2.44628329530644],
["1t4t",2.2,2.73803554097454],
["3lad",2.2,3.36934830926764],
["1krf",2.2,2.59721513066356],
["1kre",2.2,2.58611484762265],
["1kkt",2.2,2.67395295402241],
["2ako",2.2,1.54962857148889],
["1now",2.2,1.41715349757453],
["1tnd",2.2,3.14225683312848],
["1v59",2.2,2.75588536576403],
["1rth",2.2,3.44962165347468],
["1mdu",2.2,2.88966131818862],
["1ddz",2.2,2.85495308135832],
["1cfz",2.2,3.0035411437429],
["1r64",2.2,2.34820881909935],
["2bm2",2.2,3.28053534512738],
["1jv3",2.2,2.42061912656559],
["1lto",2.2,2.89718542058456],
["1mxh",2.2,2.68153499717406],
["1e4l",2.2,2.43786407409269],
["1rzq",2.2,2.14337124773485],
["1uwx",2.2,2.67459648931618],
["1apx",2.2,2.07628192962751],
["2c64",2.2,2.11817448098883],
["2byb",2.2,2.33019699704581],
["1ca4",2.2,2.65249695044121],
["1hdc",2.2,3.48647768653802],
["1rm3",2.2,2.39888949830664],
["1gyk",2.2,2.01505182429974],
["1lt6",2.2,2.84788090571621],
["1e92",2.2,2.18387609404276],
["1xkv",2.2,2.09373092824606],
["1xev",2.2,2.24539862896225],
["1wxr",2.2,2.85108753835431],
["1ytm",2.2,2.52025979992136],
["1xny",2.2,2.63197697514171],
["1r0x",2.2,2.73399779443199],
["1jki",2.2,3.87925879830057],
["1yvp",2.2,2.67956553323419],
["1n5m",2.2,2.47847021144213],
["1kyz",2.2,2.99223247992051],
["1o57",2.2,2.89909451440304],
["2phl",2.2,3.11170067165489],
["1rlt",2.2,2.89083084051744],
["1oxw",2.2,3.13325107845927],
["1yq3",2.2,2.55296028671612],
["1qlt",2.2,2.53287941216035],
["3fru",2.2,2.8719608874052],
["1vi8",2.2,2.58381159808699],
["1tx6",2.2,2.61441678027412],
["1h27",2.2,2.74034473057622],
["1aso",2.2,2.10515844663958],
["1hqn",2.2,2.57120176772130],
["1qmz",2.2,2.78273661298963],
["1w8d",2.2,2.66892445955426],
["1u2z",2.2,2.56414770337556],
["1nu7",2.2,2.60843839012536],
["1eys",2.2,3.3289131326206],
["1nu9",2.2,2.65826025262429],
["1xi1",2.2,2.96362558660732],
["1iq8",2.2,2.97505271327447],
["1e7a",2.2,3.41997671580099],
["1nal",2.2,2.98293871628340],
["1hyh",2.2,1.9548298246396],
["1vb9",2.2,2.61450640871775],
["1pix",2.2,2.52172740666293],
["1t9b",2.2,1.88708249626369],
["1vrn",2.2,2.04127517638436],
["2b2x",2.2,2.88043044707266],
["1xl8",2.2,2.19114589916468],
["3tf4",2.2,2.04495989344741],
["1rz0",2.2,2.19987730752391],
["1j2g",2.2,2.00477528344646],
["1wek",2.2,2.79567401271860],
["1ivx",2.2,2.67098874275479],
["1b06",2.2,2.72376195295608],
["1jji",2.2,2.82529828509563],
["1gtm",2.2,2.87187739068796],
["1is2",2.2,2.58485841763155],
["1r38",2.2,1.40455444511551],
["2amf",2.2,2.139279754996],
["1ksi",2.2,2.59240789351363],
["1ev2",2.2,1.92259241108973],
["1dcu",2.2,2.51710095315576],
["1s0c",2.2,2.24196213034265],
["1s0d",2.2,2.60239589261513],
["1g9d",2.2,2.65737423093597],
["4eca",2.2,2.82052216534672],
["1um9",2.2,2.13506057004545],
["1n7g",2.2,1.79826950408583],
["1pzf",2.2,1.57555661811685],
["2a8d",2.2,2.54684815285007],
["1lrt",2.2,2.54450965717651],
["1bp5",2.2,2.7476166631596],
["2dbv",2.2,2.80028489830290],
["1nqa",2.2,2.11692871532958],
["1lf9",2.2,2.52830881920627],
["2az3",2.2,2.70936470846171],
["1j0d",2.2,3.01559943077626],
["1a99",2.2,2.45530276224086],
["1com",2.2,2.35918991904857],
["1ovl",2.2,2.81172155709626],
["2cht",2.2,2.69974228985302],
["1tcm",2.2,3.69906510284897],
["1ukt",2.2,2.98193961375182],
["2cvo",2.2,2.24685171866293],
["1q0f",2.2,1.46292765829979],
["1q0d",2.2,1.60262478083277],
["1z2i",2.2,3.06999300816223],
["1pl7",2.2,2.17880842817626],
["1xdj",2.2,2.69655273690585],
["2ggi",2.2,2.45347557281333],
["1nkq",2.2,2.78673860899384],
["1cn3",2.2,2.63678135248186],
["1qaf",2.2,2.69145978645843],
["1qal",2.2,2.55834149582687],
["5bj3",2.2,2.57729309126624],
["1nwu",2.2,1.96143983498968],
["1ex5",2.2,3.35362306993306],
["1znn",2.2,2.11892202765790],
["1nw4",2.2,2.44062494561256],
["1du3",2.2,3.78884856086939],
["2ggh",2.2,2.74908158068297],
["1u8e",2.2,3.09358149929898],
["1rwq",2.2,3.22721240994599],
["1djq",2.2,2.00429278051128],
["1djn",2.2,2.02236836663609],
["1wcy",2.2,2.11374672054144],
["1sjb",2.2,3.26323509801074],
["1nmo",2.2,2.50006329136569],
["1nmp",2.2,2.52707649509467],
["1u1c",2.2,2.21437700661307],
["1pdw",2.2,2.27183516221419],
["1j21",2.2,2.72309193843976],
["1ewq",2.2,2.90422313729813],
["1s7u",2.2,2.52670184362773],
["1yym",2.2,2.80542430168933],
["1sqj",2.2,2.62947400435505],
["1e3m",2.2,2.47160589489438],
["2fw2",2.2,2.41136211758973],
["1bxb",2.2,2.60910793587905],
["1em6",2.2,2.97456380722894],
["1xim",2.2,2.05731192815404],
["1hzd",2.2,2.53518276997721],
["2aw3",2.2,2.30225211186042],
["1l6i",2.2,2.61054243373179],
["1j51",2.2,2.92361462872391],
["2byy",2.2,2.59471280330035],
["1aij",2.2,2.23408636700762],
["1vrq",2.2,2.2641960211009],
["1de5",2.2,3.17913837383273],
["1rf4",2.2,3.04589109825874],
["2aam",2.2,1.53688273714563],
["2c0u",2.2,2.40419842081180],
["1dio",2.2,3.13779284559496],
["2ai0",2.2,2.55242339733164],
["1tfw",2.2,2.05042588997734],
["1yni",2.2,2.62881252246451],
["1v1j",2.2,1.92226638048404],
["1tr1",2.2,2.75869554008493],
["1uli",2.2,1.99797740632116],
["1im3",2.2,2.10041835963323],
["1wnb",2.2,2.40699527371440],
["1sql",2.2,2.57824021890523],
["1fea",2.2,3.15362307317416],
["1siw",2.2,2.50646522789762],
["1dgb",2.2,2.55890806080316],
["1gpm",2.2,2.18754199098934],
["1zk3",2.2,2.0033839122939],
["1ux2",2.2,2.27138603039111],
["1j0z",2.2,2.24171840044868],
["5bca",2.2,2.8946858766996],
["1mmo",2.2,2.73631613682486],
["2exk",2.2,2.34749814996914],
["2exj",2.2,2.76508436666859],
["1m32",2.2,2.37803277616057],
["1y9d",2.2,2.67040388472578],
["1aa1",2.2,2.46170090186575],
["1qla",2.2,2.72391270853413],
["1up8",2.2,1.65960549608471],
["1nx9",2.2,2.08216160411278],
["1sb3",2.2,2.105765356573],
["3pca",2.2,2.55699908329441],
["1xdy",2.2,2.79680483223652],
["1s20",2.2,2.47056557670209],
["5req",2.2,2.16310783612375],
["4req",2.2,2.26175373893526],
["6req",2.2,2.12448602895708],
["7req",2.2,1.73038889742590],
["1rvx",2.2,2.83229206630395],
["1qf7",2.2,2.29411639562085],
["1g20",2.2,2.89630515941772],
["1w0j",2.2,2.34886484733001],
["1xo6",2.2,2.81515576357581],
["1u6i",2.2,2.82333431495648],
["1vqo",2.2,2.76341300488074],
["1vq8",2.2,2.81290968440178],
["1gh0",2.2,2.40219804673676],
["1ha7",2.2,1.76056620505173],
["1w91",2.2,2.99839584990488],
["2bs9",2.2,2.49893736407002],
["2a3w",2.2,2.24211535628520],
["1uw6",2.2,2.34930347768054],
["1xsi",2.2,2.59472084951299],
["1xsk",2.2,2.86961506627498],
["1uzh",2.2,2.14151254714019],
["1mjg",2.2,2.47102174737268],
["1ti4",2.2,2.58587018479321],
["1vle",2.2,2.62136067259820],
["1twl",2.2,1.47946511455393],
["1u8g",2.2,2.75772594464068],
["2a99",2.2,2.08925849682169],
["1u41",2.2,1.97786208062984],
["1t5d",2.21,1.93804195432482],
["1rrw",2.21,2.61718248182380],
["2d27",2.21,2.62474918023545],
["1mvn",2.21,2.44596713693746],
["1p61",2.21,2.56158205667104],
["1npr",2.21,2.87663177255319],
["1vyz",2.21,1.80720237825993],
["1ppw",2.21,2.86956928710323],
["1tjf",2.21,2.65850541950455],
["2cck",2.21,2.30233151445406],
["1ua7",2.21,2.23182634459614],
["2b9y",2.21,1.60584996978006],
["2eys",2.21,2.33836546450667],
["1ea1",2.21,2.62986490795795],
["1u3r",2.21,2.50328193019249],
["1kp9",2.21,2.70553819168727],
["1roz",2.21,1.74449760200383],
["1ntg",2.21,2.55983737910209],
["1r7i",2.21,2.89358508943799],
["2c5u",2.21,2.65381270380094],
["1pjq",2.21,3.27280788420681],
["1ih7",2.21,2.45183344171690],
["1ms4",2.21,2.22344203842496],
["1v8z",2.21,2.68490437446133],
["1z6t",2.21,2.02551811784809],
["3pci",2.21,2.57804924317338],
["1p7z",2.21,2.32660890228963],
["1w7h",2.21,2.31083795917889],
["1upj",2.22,3.3997101262261],
["1gh2",2.22,2.4497613107753],
["1p5s",2.22,2.10846489839647],
["1kye",2.22,2.70094492568283],
["1ul9",2.22,2.50937205380923],
["1war",2.22,1.67157703889274],
["1rrq",2.22,2.86336459085162],
["1z2x",2.22,2.53015808689856],
["1f4v",2.22,3.03047367808619],
["2b9x",2.22,1.83795476775017],
["2b2a",2.22,2.34510675225668],
["1sw7",2.22,2.04888895655227],
["1y0a",2.22,2.38912638130098],
["1yeo",2.22,2.31471285620852],
["1y4r",2.22,2.68896212401689],
["1y46",2.22,2.28449558579948],
["1td2",2.22,2.69450138031793],
["2b8w",2.22,2.68882098264605],
["1yjg",2.22,2.0933206108047],
["2afu",2.22,2.04235650683479],
["2afs",2.22,2.13718082211737],
["1j91",2.22,3.07120757169199],
["1u0m",2.22,3.62644517385468],
["1s9v",2.22,2.30692237603398],
["2b99",2.22,2.65810215854853],
["1qvo",2.22,2.77010804625859],
["1rs9",2.22,2.55933224616329],
["1rgu",2.22,2.28735429843249],
["1s89",2.22,2.10976103729759],
["2ush",2.22,2.78097499146984],
["1p4a",2.22,2.98133379749775],
["1p5e",2.22,2.51753487697018],
["1r9j",2.22,2.14145543708573],
["1hwk",2.22,2.29015919234994],
["1ykm",2.22,1.81765065136259],
["1d6p",2.23,2.74048233881254],
["1bso",2.23,2.61104294073688],
["3aky",2.23,2.73806746701235],
["1h8a",2.23,2.66894011506208],
["1mza",2.23,2.93813857844275],
["1jb4",2.23,3.18615653796107],
["1bb4",2.23,3.440311516024],
["1gan",2.23,2.6102034861904],
["1qnu",2.23,1.31491520556624],
["1qnb",2.23,2.41442635649268],
["1yft",2.23,3.26540170710265],
["1a65",2.23,2.46840174474365],
["1px2",2.23,1.98800398818166],
["1men",2.23,2.63520532856403],
["2gdk",2.23,1.80172868413656],
["1q3x",2.23,2.61118326300294],
["1tbm",2.23,1.77168730623710],
["1eyk",2.23,2.71767538992904],
["1e1y",2.23,2.64594331317185],
["1rj8",2.23,2.28699580820614],
["1w1u",2.23,2.73444696471867],
["1xl9",2.23,2.42091184999983],
["1vhj",2.23,2.34183659627704],
["1jko",2.24,3.26327319149012],
["1hey",2.24,2.42262057017431],
["1r0o",2.24,3.31529602779047],
["1bsy",2.24,2.65959767999485],
["1n5v",2.24,2.24963257978333],
["1ymg",2.24,3.23455262265380],
["1dht",2.24,3.30162697592738],
["1iuc",2.24,2.24945064275989],
["1vfz",2.24,3.17763073024153],
["1s6r",2.24,3.77730309184092],
["1i7a",2.24,2.84808611812491],
["1wb7",2.24,2.39097252712497],
["1u92",2.24,2.76865305907651],
["1u8j",2.24,2.73156438682668],
["1u95",2.24,2.66368145243596],
["1u91",2.24,2.68103722330914],
["1u8q",2.24,2.78205283291653],
["1u8k",2.24,3.0057581080786],
["2ah8",2.24,2.82716285190371],
["1zd1",2.24,2.786789152207],
["2b7d",2.24,2.90778472752525],
["1s2i",2.24,2.46467318441060],
["1svx",2.24,2.57284528898048],
["1idu",2.24,2.50085920351544],
["1i7m",2.24,2.80128558693965],
["1ug3",2.24,2.36899434796074],
["2ae5",2.24,1.74448134341822],
["2c3h",2.24,3.07717376870246],
["2a9v",2.24,1.81783576723496],
["9nse",2.24,2.43748584409282],
["1h26",2.24,3.08978770960346],
["1yxu",2.24,2.4168299491094],
["1xe3",2.24,2.5145975122119],
["2a7k",2.24,2.12592527383576],
["1vay",2.24,2.40508842653404],
["1w2z",2.24,1.92678705273914],
["2adv",2.24,1.75231781128155],
["1xlv",2.25,2.69248901452458],
["1zil",2.25,3.58750000999039],
["2pk4",2.25,3.8222980312914],
["2a3g",2.25,1.78691197074259],
["1cwd",2.25,2.57073672706905],
["1o4h",2.25,2.3939669376215],
["1rap",2.25,2.8326237497389],
["1d5e",2.25,3.17389965885619],
["1fev",2.25,2.83657906391200],
["1d5h",2.25,3.0521585339151],
["1d5d",2.25,2.82446513579769],
["1j7z",2.25,3.01592957274529],
["2ets",2.25,2.08205022762334],
["1c76",2.25,2.73098280252437],
["2mad",2.25,3.12195792515340],
["2c9l",2.25,2.33157554628861],
["1k40",2.25,2.86081988788237],
["1rcb",2.25,3.84952212105091],
["1siz",2.25,1.96719465885665],
["1cnu",2.25,2.68678210749497],
["1lpe",2.25,2.48399655004042],
["1pmk",2.25,4.72357069062076],
["1q2d",2.25,3.34392724092784],
["1q2c",2.25,3.22636725879337],
["2bs8",2.25,3.60526523100565],
["1a4p",2.25,2.66277697805608],
["1p78",2.25,2.39418709622473],
["1ej4",2.25,2.90868909625621],
["1hvs",2.25,2.17313969661401],
["1k6t",2.25,2.09032438445870],
["1p3v",2.25,2.78649141018099],
["1p10",2.25,2.29346602980695],
["2lpr",2.25,2.29346602980695],
["8lpr",2.25,2.35876750838535],
["2f7t",2.25,2.71543451083801],
["1q3p",2.25,2.90758411681554],
["1s3y",2.25,3.15369475462317],
["1jv7",2.25,2.72921981896816],
["2blc",2.25,3.1600231863056],
["1s3g",2.25,2.89768385896524],
["1c4f",2.25,3.31343732109166],
["2ssp",2.25,2.40258526218301],
["1qkn",2.25,2.51808200622943],
["1hy5",2.25,2.81381850958537],
["1xq3",2.25,1.79743687978209],
["1a98",2.25,1.82695285496837],
["1cvf",2.25,2.83577749297358],
["1ccu",2.25,2.8278577901513],
["1cva",2.25,2.76378608969398],
["1cve",2.25,2.77855747430291],
["1bnw",2.25,2.40143466269697],
["1a42",2.25,2.44614980053451],
["1kwr",2.25,2.35875312130855],
["1y6p",2.25,2.56021701594976],
["1nnr",2.25,2.43321949736152],
["1nw8",2.25,2.23739701314039],
["1lhe",2.25,3.26667306130366],
["1lhg",2.25,3.4475002695535],
["1odf",2.25,2.36072141885813],
["1ei9",2.25,2.96948449341483],
["1ncf",2.25,2.28012005105115],
["1w9f",2.25,2.13713816039338],
["1s3j",2.25,1.97318461165554],
["1dd7",2.25,2.60667226897801],
["2c5y",2.25,3.54314234788],
["1xar",2.25,2.42506964019454],
["7prn",2.25,2.76207132710174],
["1c7e",2.25,2.74919490153982],
["1a3y",2.25,2.65647419393526],
["1quf",2.25,2.82625077921435],
["1bzj",2.25,2.0419190609101],
["1b30",2.25,1.51330157875346],
["1zcw",2.25,1.88212534141840],
["1zp7",2.25,2.85823587541823],
["1vlv",2.25,1.95940370365973],
["1cps",2.25,3.23854555251772],
["1ifv",2.25,1.67418796444738],
["1mx2",2.25,2.39361049753941],
["1mnm",2.25,2.44859742002179],
["1ala",2.25,3.10932765813618],
["1o89",2.25,2.28865332348067],
["1f4m",2.25,2.36963630146908],
["1m5x",2.25,2.83862879986321],
["1v8k",2.25,3.17244490591996],
["2baj",2.25,2.82290528070385],
["1w9o",2.25,2.36363801048007],
["2aca",2.25,2.64386655554444],
["1h2l",2.25,1.88877809283804],
["1qxl",2.25,3.34435801415357],
["1a26",2.25,2.42783938397046],
["1jlu",2.25,3.16654915942646],
["1pey",2.25,2.88858295138241],
["1yob",2.25,2.92346021767218],
["1ign",2.25,2.53424552279123],
["1b7a",2.25,2.33963806008294],
["2f6h",2.25,2.12943273564120],
["1rc1",2.25,2.06997279141416],
["1mj7",2.25,2.74662507368282],
["2g9n",2.25,2.70901816126432],
["1yjy",2.25,2.44577694716306],
["1dkm",2.25,2.80174704969406],
["1ynu",2.25,2.37980373395389],
["1q6i",2.25,2.06739950662446],
["1emt",2.25,3.26569794958950],
["1fby",2.25,3.06677014082931],
["2esf",2.25,2.5142894720649],
["2cdf",2.25,2.69590395010531],
["3enl",2.25,3.00904851907568],
["1eoc",2.25,2.33984248446421],
["1eo2",2.25,2.50809643025094],
["1kdr",2.25,3.59709433440525],
["1r7m",2.25,2.95557318060797],
["2atw",2.25,2.52153710351508],
["2bvy",2.25,2.34932894613772],
["1jd7",2.25,1.85291080257971],
["1mbx",2.25,2.10532708006492],
["1orj",2.25,2.67904250297348],
["1r6o",2.25,1.74543156501248],
["1w1a",2.25,2.48677201032487],
["1cwq",2.25,4.20961379204623],
["1ifx",2.25,2.42974336006702],
["1uzj",2.25,3.16993914668077],
["1vcn",2.25,2.99986825296188],
["1r2t",2.25,2.27556371743050],
["1uxu",2.25,2.79973463240143],
["1hkp",2.25,1.97597145841442],
["1lby",2.25,3.40548138892222],
["1k78",2.25,2.53111515518225],
["1cmx",2.25,2.8979896119766],
["1zji",2.25,2.20357792897034],
["1gk3",2.25,3.6482772312018],
["1fyd",2.25,2.40318523605044],
["5eas",2.25,2.21387203650684],
["1p32",2.25,2.62979845880545],
["1hxc",2.25,2.23939345547678],
["1zco",2.25,2.49860323053622],
["1ime",2.25,2.09599062291636],
["1yfo",2.25,2.54381189125874],
["1bg1",2.25,3.26447675413358],
["1y09",2.25,2.18605554498045],
["1qxd",2.25,2.69751656986432],
["2r2f",2.25,2.661802264574],
["1g1m",2.25,3.52698039620256],
["1ciy",2.25,2.82898446185708],
["2g06",2.25,2.08426772675131],
["1jen",2.25,2.03162294206293],
["1c8n",2.25,2.09073748513843],
["2kzz",2.25,3.09784117447556],
["1m51",2.25,2.1314980811112],
["1sjh",2.25,2.51379182179447],
["1mr5",2.25,2.71755053093558],
["2dey",2.25,2.75920473538756],
["2f4i",2.25,1.94630254212680],
["2ge3",2.25,2.98586904274081],
["1fuy",2.25,2.55469488402746],
["1ps6",2.25,2.79049820940601],
["1gwc",2.25,2.11198009814152],
["1eyx",2.25,3.19173086758743],
["1r0e",2.25,2.16233642760581],
["1uin",2.25,2.07565203103344],
["1y8j",2.25,3.27791662472918],
["1tii",2.25,2.33456879191652],
["1r6b",2.25,2.91770415054341],
["1u04",2.25,2.89543194744619],
["1wn1",2.25,2.68687009722601],
["1c3b",2.25,2.85034715033242],
["1su1",2.25,2.72881209354623],
["1guf",2.25,1.77126491612415],
["1ekv",2.25,3.19112208579629],
["1ft1",2.25,2.68832850634993],
["1tn8",2.25,1.93947556221651],
["1eey",2.25,2.24823859062528],
["1fxv",2.25,2.24085840722533],
["1jqi",2.25,2.64830831774686],
["1wkh",2.25,2.16891194504657],
["1wkg",2.25,2.50744768689422],
["1yf6",2.25,1.91905850449345],
["1kq4",2.25,2.176837389998],
["1z2l",2.25,2.90593726448316],
["1dm8",2.25,2.49655957679189],
["8nse",2.25,2.77480759929421],
["1hl9",2.25,2.24123132634587],
["1nc4",2.25,2.10391075604056],
["1z3u",2.25,3.12258686567819],
["1e5x",2.25,2.77363140975918],
["6csc",2.25,3.45010082890793],
["1hqa",2.25,2.29165396496794],
["1js3",2.25,2.50579119523287],
["2pel",2.25,2.37899212327248],
["2fww",2.25,2.8468244326928],
["1rjf",2.25,1.66236960921912],
["1sl6",2.25,2.50690969348687],
["1e6n",2.25,2.20073515676562],
["1jih",2.25,2.54665704549222],
["1n5r",2.25,2.32289094054122],
["1vqr",2.25,1.67130470057308],
["2bxh",2.25,2.96992135114415],
["1qo0",2.25,2.59699662567769],
["1ym4",2.25,2.86503327118518],
["1mhl",2.25,2.10836429034637],
["1f6p",2.25,1.94602947500037],
["2cbi",2.25,2.34258787340874],
["1zro",2.25,1.80737107285697],
["1fwl",2.25,2.9438552732537],
["1kgo",2.25,2.03463511204672],
["1r44",2.25,2.95613472507528],
["1rk2",2.25,1.96169290100927],
["1xmi",2.25,2.25501741697447],
["2b4r",2.25,2.15444246017116],
["2fm1",2.25,1.59564765581175],
["1jpm",2.25,2.01454780554095],
["1ted",2.25,3.07440634291413],
["1umf",2.25,2.9636422306803],
["1v0j",2.25,2.63601900020050],
["1dlu",2.25,3.01665606854631],
["1l5q",2.25,2.54969201459499],
["2fiq",2.25,2.06600981752868],
["1y8q",2.25,2.74093799822144],
["4nos",2.25,2.83550658961043],
["1f8i",2.25,2.19365270424457],
["1qha",2.25,3.32122675460144],
["1ndo",2.25,2.28915833354487],
["2c9t",2.25,1.98941450872317],
["1xjn",2.25,2.66476768091986],
["1ffv",2.25,2.37640919129135],
["1euz",2.25,2.65140302681982],
["3pcm",2.25,2.68393005436667],
["1ykl",2.25,2.79882263486124],
["1xrh",2.25,2.76855411620117],
["1o7a",2.25,2.32691607851047],
["1rvz",2.25,2.88256793929062],
["2awi",2.25,2.77624526458052],
["2dcn",2.25,2.11869608045294],
["1vqp",2.25,2.74164645433617],
["1o05",2.25,2.00777583946336],
["1gth",2.25,2.2627016157397],
["1g65",2.25,3.05429517151482],
["1ehc",2.26,2.73646598384322],
["1twm",2.26,2.70904179355741],
["1ier",2.26,2.19943979765486],
["1fb0",2.26,2.1428389879315],
["1muf",2.26,3.08268429769871],
["1mja",2.26,2.63073849078255],
["2f0r",2.26,2.16556437851156],
["1qx0",2.26,2.39795050233121],
["1f0c",2.26,2.95741561183108],
["1f7q",2.26,2.88704138327203],
["2f4o",2.26,3.03673659963757],
["1gzq",2.26,2.85634778954438],
["1wl5",2.26,1.98723804925515],
["1qbl",2.26,3.17477943400758],
["1xvi",2.26,2.12238365244998],
["2fml",2.26,2.80853636298068],
["1u7n",2.26,2.52092428748529],
["1wut",2.26,3.06619945388982],
["1wuy",2.26,3.11976898899284],
["1wv0",2.26,3.15116790166118],
["1k08",2.26,2.99994788093839],
["1hlf",2.26,3.1832709893773],
["1hwj",2.26,2.36164624853785],
["1ggk",2.26,2.32218321496586],
["1xx7",2.26,1.522550431408],
["1upr",2.27,2.97817636356042],
["1fm5",2.27,2.97727662710955],
["1sln",2.27,2.47631241686176],
["1tr8",2.27,1.97402100210100],
["1gu8",2.27,2.16498216246785],
["1gue",2.27,2.43962373991301],
["1si9",2.27,2.64554112374653],
["1xzn",2.27,2.89209553092587],
["1cnq",2.27,2.31517605412856],
["2c24",2.27,2.13210568014756],
["2c28",2.27,2.73462051836496],
["1wal",2.27,2.42060726901298],
["1qmn",2.27,2.45699036575164],
["2bb3",2.27,3.04114767425772],
["1w0v",2.27,1.80256118559804],
["1cmv",2.27,3.18652948737378],
["2fo0",2.27,2.30457535349549],
["2b9s",2.27,1.87283947642476],
["2ax3",2.27,1.65492461602259],
["1jaz",2.27,2.24429479352576],
["1p6m",2.27,2.77005057150634],
["1vm6",2.27,1.75461351240575],
["1z0g",2.27,3.64606202614784],
["1w7a",2.27,2.46388209828998],
["1fj8",2.27,3.00597046326933],
["1wx0",2.27,2.38224070804936],
["1jkr",2.28,3.13183792730572],
["1waq",2.28,2.61987389744523],
["2bdd",2.28,2.13843427063048],
["2etd",2.28,1.19613298245390],
["1o73",2.28,2.38600957188403],
["9ilb",2.28,2.72371374634392],
["2g42",2.28,1.11501099782361],
["1e0s",2.28,1.84469320894076],
["1gbm",2.28,1.80983551866960],
["1uom",2.28,2.41358735072285],
["1rkh",2.28,2.36047311656892],
["1ck3",2.28,1.91266762982951],
["1s6m",2.28,2.66697066344384],
["2a18",2.28,1.34406262263258],
["1cvw",2.28,2.46207299979167],
["1xos",2.28,2.34666944823549],
["1ryr",2.28,2.68299039224952],
["1ko5",2.28,2.34750079354963],
["1ta4",2.28,2.97020679304137],
["2b2z",2.28,3.09880849300526],
["1oc0",2.28,1.95894099907164],
["1dkp",2.28,2.55394308046455],
["1zxc",2.28,2.67026304538757],
["4otc",2.28,2.20368407007274],
["1v4e",2.28,2.69682613872634],
["1jqd",2.28,2.34081149143956],
["1eyj",2.28,2.52064289496906],
["2fdb",2.28,2.3436701479087],
["1a79",2.28,3.39570367688717],
["2cda",2.28,2.32715584241081],
["1kdw",2.28,2.23303446684855],
["2fbm",2.28,2.67954910014164],
["1jx9",2.28,1.91122110936325],
["1v94",2.28,2.67234748120802],
["1dn0",2.28,3.28030804293096],
["2g75",2.28,2.86807342962349],
["1v3d",2.28,3.01354486032367],
["1q9l",2.28,2.95799671099758],
["1okj",2.28,2.77041113199048],
["2g80",2.28,0.964611438964596],
["1xxx",2.28,1.82697205754515],
["1ggf",2.28,2.46364969807334],
["1ito",2.29,2.50307765498250],
["1x2w",2.29,2.74515572253709],
["1o9y",2.29,2.00306465955112],
["2feg",2.29,2.72047723715708],
["1zbc",2.29,3.13052442808706],
["1yty",2.29,1.94126604387684],
["1s13",2.29,2.80491881603104],
["1msa",2.29,2.438279347304],
["1yf3",2.29,2.54479161970028],
["1t6x",2.29,2.67517521058438],
["1ys4",2.29,2.16633644803330],
["1vlu",2.29,2.17141305297925],
["2etf",2.29,2.06579078367653],
["1dlv",2.29,2.8681087095132],
["1eby",2.29,1.93336444262648],
["1jj6",2.3,2.25903172860876],
["1nhl",2.3,2.02150875763902],
["1mn3",2.3,2.62949090413858],
["1unz",2.3,2.36863947953460],
["1hpt",2.3,2.62347603673579],
["1uny",2.3,2.92203903695896],
["1gzz",2.3,3.3863000025087],
["1e6g",2.3,3.02896112483112],
["1w5i",2.3,2.45133058826761],
["1neg",2.3,2.55751017255892],
["3ame",2.3,2.05036331547384],
["1msj",2.3,2.21973647956680],
["1fyn",2.3,2.93805708265275],
["1ydl",2.3,2.48997843747251],
["1mul",2.3,2.44817662209594],
["3icb",2.3,3.14790520984757],
["1pfp",2.3,2.62403891848220],
["1jk4",2.3,2.40189157731314],
["2cuw",2.3,2.51658353719677],
["1z9f",2.3,2.91537437783631],
["2fgg",2.3,3.58753854473172],
["1a1l",2.3,2.02630862551395],
["2gn5",2.3,5.21521999213666],
["1lng",2.3,3.02219105560767],
["1ov9",2.3,2.52533756762418],
["1mpj",2.3,2.95598595648178],
["1cx0",2.3,2.55069538842956],
["1drz",2.3,2.72083466078236],
["1lph",2.3,3.53437775220600],
["1xw7",2.3,2.55556403010442],
["1ycq",2.3,2.45522236115095],
["1sip",2.3,3.50294755495311],
["1ik7",2.3,1.86011662285965],
["1cyc",2.3,5.10217737677887],
["2bir",2.3,2.04842849700534],
["1ayc",2.3,2.83544645571018],
["1qls",2.3,2.95612316186650],
["1xwc",2.3,2.91141418439448],
["1frm",2.3,2.45377066800255],
["1frh",2.3,2.46035529181416],
["1frl",2.3,2.37079621590390],
["1fer",2.3,2.17648239892462],
["1frj",2.3,2.58298631309823],
["1ff2",2.3,2.57285135925540],
["2a3p",2.3,2.35490794821484],
["1bet",2.3,2.48672973614115],
["1lp1",2.3,3.22424540881432],
["3ssi",2.3,2.95199058591723],
["1n9n",2.3,1.99014827716313],
["1tho",2.3,2.22540505876949],
["1bfe",2.3,2.71881145186767],
["1l1s",2.3,2.15196779318602],
["2esh",2.3,3.21758325972478],
["1xd7",2.3,3.31546693276125],
["1cjr",2.3,3.04339358473176],
["1j82",2.3,2.78740516072453],
["2c5i",2.3,2.41803379082207],
["1w02",2.3,3.13734790515928],
["1bl0",2.3,4.06659505864161],
["2tmy",2.3,2.98712035223184],
["1u27",2.3,2.57073203290357],
["1s8g",2.3,2.19080795576558],
["1w16",2.3,2.53021346223841],
["1byl",2.3,2.19973691008460],
["1a5q",2.3,3.31368769300527],
["5fit",2.3,2.24420463851666],
["8cho",2.3,2.63220183727992],
["1fxr",2.3,2.25485695856276],
["1lfo",2.3,2.69055588307196],
["1dv8",2.3,2.75806196696241],
["1xek",2.3,4.47488913817631],
["1o5l",2.3,1.82186757414639],
["1ku5",2.3,2.72625081794455],
["1kba",2.3,4.23813521429006],
["1qql",2.3,3.56278593076520],
["1ahq",2.3,2.92682598454910],
["1aqt",2.3,2.72585527511357],
["1cof",2.3,2.31778773928706],
["2fo7",2.3,2.11104136029678],
["1su0",2.3,3.21936669248746],
["1dud",2.3,1.95573990350744],
["1nl2",2.3,2.87270634070988],
["1hyz",2.3,2.3270218345159],
["2cy1",2.3,2.25966769138980],
["1jgs",2.3,2.97927559073571],
["1fik",2.3,2.96880927806210],
["1itg",2.3,2.75539331013055],
["1gu3",2.3,2.32730412303233],
["2asr",2.3,2.76598119320397],
["1l7z",2.3,2.83642611366622],
["3fis",2.3,3.05807890072429],
["4fis",2.3,3.21000042399059],
["2af0",2.3,2.04048779853553],
["2aed",2.3,1.77664697316593],
["1jqw",2.3,2.60488521307075],
["1hqp",2.3,3.53125983811642],
["1vjx",2.3,2.02656964182199],
["1aar",2.3,2.75133686247371],
["1jp6",2.3,1.32356200329886],
["1jp8",2.3,1.71860825257565],
["5dfr",2.3,3.62873875349504],
["1ass",2.3,3.02071852029936],
["1mnh",2.3,2.48966278375950],
["1bgd",2.3,2.88717532050032],
["1rdc",2.3,3.9488652950353],
["1cw0",2.3,2.46786255993719],
["1cyx",2.3,2.87532800461149],
["1drh",2.3,3.29583643531357],
["1rx7",2.3,3.17779370900363],
["1rx5",2.3,3.2545641537032],
["1ew3",2.3,3.10028747643051],
["1a6y",2.3,3.81494744704462],
["2fgc",2.3,2.76632781988129],
["1c25",2.3,2.66278134118521],
["1paq",2.3,3.11532888902146],
["1c62",2.3,2.16936973013991],
["196l",2.3,2.59696334753986],
["1jq6",2.3,2.78942028860409],
["1rpy",2.3,1.95078704366468],
["1jpx",2.3,2.70762236754949],
["1qtv",2.3,3.24815861268054],
["1we2",2.3,2.99476670432995],
["1yd7",2.3,1.81564298245202],
["1twq",2.3,2.70152578758645],
["1l0c",2.3,2.63702582585448],
["1p2v",2.3,2.56958223055008],
["221p",2.3,2.9846757647603],
["1agp",2.3,2.40720571126885],
["1g2e",2.3,2.28054087153343],
["1avu",2.3,3.44249120404741],
["1j5y",2.3,1.9136485090671],
["1v67",2.3,2.54445277148170],
["1a45",2.3,3.33465938704230],
["1tzq",2.3,2.21197745629695],
["1hqv",2.3,2.94599791165663],
["1pu9",2.3,3.67646573552219],
["1s7l",2.3,2.46987199967204],
["1pua",2.3,3.50840320086721],
["1cdh",2.3,4.14830988416581],
["1cwt",2.3,2.76373500076345],
["1t9z",2.3,2.52398082051788],
["1s1e",2.3,3.02206070319528],
["2alg",2.3,2.39923461258960],
["1kzn",2.3,2.54276272139208],
["4mon",2.3,4.07543840906197],
["1zny",2.3,2.00754982275781],
["1mr2",2.3,2.32390877352267],
["1mp2",2.3,2.27368019344656],
["2wbc",2.3,3.44174281537558],
["1m1u",2.3,2.66754098534859],
["1ek8",2.3,2.95953532773796],
["1ad6",2.3,3.5531657702792],
["1r22",2.3,2.91461124230925],
["1dr2",2.3,2.73617179143020],
["1dr3",2.3,2.88602201972306],
["1dls",2.3,2.40342381330094],
["1dlr",2.3,3.01449578916484],
["1l0b",2.3,2.83505439466247],
["1a2x",2.3,3.84257756863099],
["1tfo",2.3,2.71285550733703],
["1r1v",2.3,2.65641260661233],
["1es8",2.3,2.03810642258980],
["1aj6",2.3,3.04981516332517],
["1s98",2.3,3.17203102809327],
["1r94",2.3,2.70698674804567],
["1m4k",2.3,2.59559870888137],
["1qcy",2.3,2.18569834835035],
["1u9n",2.3,2.51441760756341],
["5upj",2.3,3.07102132120597],
["1tcx",2.3,2.20076523367089],
["1hii",2.3,2.27411961585702],
["1hbv",2.3,2.68051087906509],
["1sbg",2.3,2.91420510515791],
["1hos",2.3,2.65379425604702],
["4hvp",2.3,3.3231625012138],
["1gnn",2.3,3.03895680652612],
["1hps",2.3,3.28867885128576],
["1gnm",2.3,3.46676026730268],
["1gno",2.3,3.07065612671418],
["1a9m",2.3,2.74050665012603],
["1hxb",2.3,2.38338266259867],
["1ro5",2.3,3.04069791051613],
["1gbe",2.3,2.08434411125407],
["1ytg",2.3,2.58702520861551],
["2fdk",2.3,1.98113436143226],
["1mdv",2.3,2.47459451080856],
["1ywq",2.3,2.2509387886966],
["1gbi",2.3,2.27655573363567],
["1mqw",2.3,2.20676335814567],
["2fd8",2.3,1.70007687826078],
["1iad",2.3,1.79322684279936],
["1r5x",2.3,2.31400221722746],
["1q5o",2.3,2.56541325898364],
["1hj1",2.3,2.26418868434449],
["1cwe",2.3,2.86852333352731],
["2fmu",2.3,1.78030975451362],
["1tik",2.3,1.84689828976751],
["1im4",2.3,2.59641276957121],
["1klk",2.3,3.24996314836845],
["1so8",2.3,2.36223494582741],
["1fwz",2.3,2.97556025454282],
["1trq",2.3,3.11856252166332],
["1daj",2.3,3.66906431523669],
["1brx",2.3,3.37235943882165],
["1fp5",2.3,3.06198069644526],
["1auq",2.3,2.80413840755659],
["2cct",2.3,2.99912587090722],
["1bi0",2.3,2.8044237125844],
["1ouo",2.3,2.92033037491860],
["2aug",2.3,1.65008323820832],
["1i6a",2.3,2.38809230451751],
["1ubb",2.3,2.18338541328508],
["1bwq",2.3,2.97923757382955],
["7cei",2.3,3.3557097139694],
["1x0i",2.3,2.79438813889602],
["1cjs",2.3,2.36273640087464],
["1yt7",2.3,2.39564583698962],
["1u9q",2.3,2.49487714619479],
["1ayv",2.3,2.62613581853835],
["1au4",2.3,3.19416494625058],
["1bnd",2.3,3.21857875315081],
["1u9w",2.3,2.40108315973146],
["2afr",2.3,2.22303691316529],
["1m99",2.3,2.03920916058861],
["1s8l",2.3,2.27841437026543],
["1f37",2.3,2.79184774682556],
["1zzj",2.3,2.66259744684403],
["1ac6",2.3,3.25965979584665],
["1eml",2.3,3.03128601594516],
["1emm",2.3,2.75840958016973],
["1t29",2.3,3.69964773736097],
["1a41",2.3,3.57663216150978],
["2emn",2.3,2.82949542897539],
["2dyn",2.3,2.43825728447877],
["1ppg",2.3,3.12056927365026],
["1ae5",2.3,3.16157336605635],
["1z6k",2.3,2.73542119350408],
["1v2q",2.3,2.08270208973472],
["1and",2.3,2.28917686839633],
["1ql9",2.3,2.33626760822812],
["1u0y",2.3,2.24625279784540],
["1mg9",2.3,2.57265397146342],
["4lve",2.3,2.40965514464959],
["1u2c",2.3,2.8853411757804],
["2czr",2.3,2.57769603820057],
["1iw6",2.3,2.82299075540988],
["1vjm",2.3,1.99602253904225],
["1hfd",2.3,2.79321557986776],
["1flz",2.3,4.37533360984895],
["1msb",2.3,2.05401957976910],
["1ixv",2.3,2.20644900268941],
["2bf8",2.3,2.65249481029889],
["1vyd",2.3,2.61697788200550],
["1cr2",2.3,3.36823581794304],
["1thc",2.3,3.64088651460611],
["1nmn",2.3,2.57223766979663],
["1o9d",2.3,2.54728484657962],
["1m68",2.3,2.09151966388105],
["2blk",2.3,1.9254302395413],
["1cr0",2.3,3.36622896446447],
["1y75",2.3,3.17099116814363],
["1dhr",2.3,2.64038871237867],
["1vzz",2.3,2.77392429481032],
["1lcv",2.3,2.49227116063188],
["5cro",2.3,3.42165155039432],
["1nhz",2.3,2.70838312411412],
["1hfy",2.3,2.38434232942426],
["1cr1",2.3,3.44438675525627],
["1q0s",2.3,2.90030803183439],
["1esb",2.3,2.61327422649229],
["1bpb",2.3,3.70179085194193],
["1zqw",2.3,3.48874008233736],
["1zqy",2.3,3.58060122009845],
["1bru",2.3,2.13318974083797],
["1rjx",2.3,2.81600068885872],
["1rpl",2.3,3.27963933832615],
["1igm",2.3,3.72413922334951],
["1ekb",2.3,2.86852636048667],
["1xmj",2.3,2.83446976384046],
["1ion",2.3,2.8961952616751],
["1ask",2.3,2.47356736682198],
["1edo",2.3,2.99241554495285],
["1q3c",2.3,2.84869434111585],
["1ar0",2.3,2.21676745593484],
["1oun",2.3,2.90113742175889],
["1jb5",2.3,3.25448929791561],
["2evu",2.3,2.72508615406338],
["1p6e",2.3,2.47165680675466],
["1gy5",2.3,2.81886448610761],
["1isq",2.3,2.87198917046574],
["1rtf",2.3,2.4551349844354],
["2b3r",2.3,2.33675614318630],
["1f2k",2.3,3.00082928785744],
["1a7v",2.3,2.5343694670919],
["1ypr",2.3,2.61568844988686],
["1ymu",2.3,3.40934351766044],
["1dnk",2.3,3.02677441840583],
["2dc6",2.3,2.74292295126257],
["2ae1",2.3,2.36686151344601],
["1vc9",2.3,2.40895555304418],
["1rio",2.3,2.76496508470876],
["1ctm",2.3,2.45754694267809],
["2b33",2.3,0.852748770866519],
["1wxf",2.3,2.23122388786245],
["1xnh",2.3,3.0625231553789],
["1nnd",2.3,2.53889793408882],
["1blp",2.3,3.32145591455065],
["1rv1",2.3,2.83387599189742],
["1b74",2.3,3.58904235991368],
["1b73",2.3,3.66657256260925],
["1au7",2.3,3.0033832320889],
["1ca3",2.3,2.87295706529216],
["1hca",2.3,2.87913725075186],
["1udq",2.3,2.92631221804138],
["1uds",2.3,2.85874357328435],
["1udo",2.3,2.94597316041669],
["1udn",2.3,2.91057360167908],
["1cvh",2.3,2.81806000576619],
["1cvc",2.3,2.81115152884156],
["1hva",2.3,3.34629447257582],
["1tab",2.3,4.04953924011037],
["1d1u",2.3,2.9479857577442],
["1f1c",2.3,2.48175724692744],
["1lzv",2.3,2.52299792416623],
["1cny",2.3,2.66002860561403],
["1aqc",2.3,3.17641899397118],
["1zdg",2.3,2.30588852394873],
["1c79",2.3,2.85002418169084],
["1c77",2.3,2.89882367486886],
["1c78",2.3,2.89882367486886],
["1blh",2.3,3.08652347781744],
["1bnn",2.3,2.27795539479170],
["1ghi",2.3,2.68213127188217],
["1kgg",2.3,3.07048539961626],
["1plq",2.3,2.83602273516174],
["1zg1",2.3,2.52441319650249],
["2bcf",2.3,2.13806471333784],
["1rwk",2.3,2.34727097231533],
["1t5z",2.3,2.35068081517553],
["1zg5",2.3,2.45839124797421],
["1apa",2.3,3.36221316341716],
["1edy",2.3,2.07550851109324],
["1ocu",2.3,2.88821717629356],
["1zbm",2.3,2.71118835805962],
["1bjg",2.3,2.04035820327910],
["1cfy",2.3,2.39417690633621],
["1w6m",2.3,1.97139907253680],
["1cd5",2.3,2.69216716367474],
["1egi",2.3,2.63139552769658],
["1gzk",2.3,3.59077274744974],
["1br6",2.3,2.90535710986616],
["1rtc",2.3,3.28295490421717],
["1i2l",2.3,2.51132783145699],
["1mvh",2.3,3.08025373206242],
["1bo4",2.3,3.21117374677096],
["1rl2",2.3,2.59272641772177],
["1scd",2.3,2.83257999407633],
["1egg",2.3,2.64977007505031],
["1ib0",2.3,2.19796990855952],
["1xca",2.3,3.15210331308767],
["1bfk",2.3,3.26058196366005],
["1scb",2.3,3.40337074767601],
["1dhy",2.3,3.0651478297929],
["1kgt",2.3,2.93627524114449],
["1gtq",2.3,2.44106894551526],
["1gmn",2.3,2.61260703636537],
["2f1x",2.3,2.9703478862113],
["2b9c",2.3,3.60529577707406],
["2fjy",2.3,2.87945626423745],
["1nst",2.3,3.04932414267526],
["1fpc",2.3,3.3259244009114],
["1jlk",2.3,2.80463244011596],
["2eth",2.3,2.59164247397577],
["2c2y",2.3,2.42900721285525],
["1u59",2.3,2.68063413745951],
["1oky",2.3,2.66939854474773],
["1tmc",2.3,2.42162803265334],
["1ta2",2.3,2.51245432449687],
["1iod",2.3,2.69269319119592],
["1tbz",2.3,3.30773567612856],
["1n6c",2.3,2.77358000157439],
["1bhx",2.3,2.50821030686939],
["1rt9",2.3,2.86644414837094],
["1d9i",2.3,3.96198621758553],
["1zbs",2.3,3.1180900680252],
["2a8b",2.3,2.58820451518443],
["1hja",2.3,2.46828696220773],
["1qxk",2.3,2.73347819967111],
["1fsl",2.3,2.33182811199157],
["1bia",2.3,3.52462751523538],
["3dhe",2.3,3.09570746204087],
["1qiy",2.3,2.38840824485314],
["1wu1",2.3,2.726783637058],
["1o1i",2.3,2.78904528850052],
["1c40",2.3,2.82589326398651],
["1qiw",2.3,3.61889681840897],
["1thr",2.3,3.44031497600792],
["1out",2.3,2.54690154668167],
["2cdz",2.3,2.03818805774185],
["2aur",2.3,1.84221525521402],
["1m73",2.3,3.23707886071037],
["1n5d",2.3,2.39911751242547],
["1dit",2.3,3.31227244142488],
["1xsm",2.3,3.39889577274143],
["1tmb",2.3,3.60048376670508],
["8prn",2.3,2.78398358487450],
["2c6l",2.3,2.56740613723197],
["1xm1",2.3,2.79321762026570],
["1t3s",2.3,3.08433578112196],
["1xqv",2.3,2.59467218644491],
["1igb",2.3,2.09327221686932],
["1cce",2.3,2.27914423859293],
["1cmq",2.3,2.5463282442125],
["3ccx",2.3,2.10575899341028],
["2ypn",2.3,2.17026654807487],
["1ypn",2.3,2.43355298757137],
["1boh",2.3,2.53306932720846],
["1tfd",2.3,4.41416248540745],
["1xrp",2.3,3.04669652565302],
["1pxj",2.3,2.64807291695281],
["1pxp",2.3,2.79201770498228],
["1wmi",2.3,3.48360023997734],
["1iz0",2.3,2.77359737269846],
["2bdx",2.3,1.97895285216381],
["1ets",2.3,3.3072028326285],
["1hah",2.3,3.30809055269773],
["1af2",2.3,2.27860188827155],
["1aln",2.3,2.21524029014136],
["1ctu",2.3,3.23078706659333],
["1jpj",2.3,3.26456904776662],
["1q20",2.3,1.98774654069555],
["1na8",2.3,2.78827570171609],
["1e62",2.3,2.00965716468307],
["1e64",2.3,2.08555367866103],
["1e63",2.3,2.07411085187102],
["1h85",2.3,2.23851093034632],
["1bjk",2.3,2.27092478400965],
["1qgz",2.3,2.28777503965997],
["2fub",2.3,2.24873127581945],
["1kil",2.3,2.49661551830877],
["4ptd",2.3,3.18998973519056],
["1c86",2.3,2.53365949748855],
["2fpl",2.3,2.58781665072943],
["1ptv",2.3,2.65456119877927],
["1abi",2.3,3.70973058287338],
["2reb",2.3,2.13885195079478],
["1cgj",2.3,3.48227614974244],
["1cgi",2.3,3.55816150865197],
["1cb4",2.3,2.45233193986112],
["1hzf",2.3,3.07444459779447],
["1zx5",2.3,1.60729071373164],
["1cjf",2.3,3.20962240375487],
["1mhm",2.3,2.82814207447596],
["1py5",2.3,3.50132822284434],
["1q67",2.3,2.85171847831399],
["1esd",2.3,3.30785736567760],
["1b3z",2.3,1.81277453332677],
["1ny2",2.3,4.1128665105645],
["1hsk",2.3,2.08554680389654],
["2aql",2.3,2.81533393329798],
["1bob",2.3,2.73794245626211],
["1ksg",2.3,3.34608444691277],
["1rka",2.3,2.11033930127601],
["1hdq",2.3,1.67049930676874],
["2dln",2.3,3.64157086019283],
["1c9e",2.3,2.49290457040602],
["1gkx",2.3,2.87342398517200],
["1s3i",2.3,2.81635217804327],
["1am9",2.3,2.51308316807123],
["1wse",2.3,2.89241531364473],
["1ch0",2.3,1.83409686108648],
["1qz3",2.3,2.21351345176688],
["1sdj",2.3,2.86676704364396],
["2edc",2.3,2.62136844074813],
["1cij",2.3,2.30266491042148],
["1gil",2.3,2.20515532952338],
["1udt",2.3,2.78013965326835],
["1iar",2.3,2.90022640538376],
["1txc",2.3,1.94028577915514],
["1bk4",2.3,2.95303386099576],
["1lwv",2.3,2.85157999431776],
["1ea3",2.3,3.2898494562606],
["1hve",2.3,2.68855190434129],
["1k4z",2.3,2.50759372980867],
["1gkc",2.3,2.15244075146972],
["2ts1",2.3,2.33606069357622],
["1ann",2.3,2.18210993700681],
["1ah3",2.3,2.72962457882946],
["1l3f",2.3,3.67059782921178],
["1tdf",2.3,2.54846322368041],
["7tln",2.3,2.63542330932387],
["5tln",2.3,3.16853637302985],
["4tln",2.3,3.11316922014437],
["1tlp",2.3,2.68407554790283],
["1rb3",2.3,2.76784306409393],
["1nje",2.3,3.10688871207689],
["1ah0",2.3,2.54020774738155],
["2nos",2.3,2.92320338063922],
["1bsd",2.3,3.18224485860308],
["1fxs",2.3,2.05189232809483],
["1avr",2.3,2.28836149114376],
["1all",2.3,2.09343280278199],
["3kar",2.3,3.55923973788545],
["1hqd",2.3,1.77688820436704],
["1vfe",2.3,2.78187691045859],
["1j7j",2.3,2.75314933998798],
["1f35",2.3,1.92274353887477],
["1ak5",2.3,2.50108469978606],
["1xka",2.3,3.23698300307562],
["1cm0",2.3,3.08639739827291],
["1cms",2.3,3.49178312590679],
["1czi",2.3,3.76943873985372],
["1obr",2.3,2.66341285152720],
["1toh",2.3,2.57129641630597],
["1vfw",2.3,3.28383775605463],
["174l",2.3,3.41767445253101],
["1aw5",2.3,3.29859387981509],
["1psq",2.3,2.88573319091585],
["1uh8",2.3,1.47688767792551],
["1zog",2.3,3.14136171184128],
["3pep",2.3,3.06049174549508],
["1yem",2.3,1.34205767923590],
["1mmp",2.3,2.38886361301801],
["1vbt",2.3,2.50677472345642],
["1nnt",2.3,3.83228426109911],
["1a4x",2.3,2.51012755056556],
["2bll",2.3,2.26649665876477],
["1epr",2.3,2.84067495749106],
["1hku",2.3,2.56942805049212],
["1you",2.3,2.84514831419596],
["1db3",2.3,2.2165971638934],
["1gey",2.3,2.05036656023946],
["1ybo",2.3,1.92514211763799],
["1cen",2.3,2.16315862366942],
["1nhj",2.3,2.62736211290578],
["2f5i",2.3,2.95334462821314],
["1fhl",2.3,2.9735569835896],
["1hd8",2.3,2.65819567297763],
["2toh",2.3,3.06538066223486],
["1rek",2.3,2.59554852602780],
["1wfc",2.3,2.22879302228426],
["2g17",2.3,1.91521048311766],
["1zw5",2.3,1.80192443607190],
["1u2m",2.3,2.04676152372626],
["1slv",2.3,2.27300026833231],
["1dbh",2.3,2.66101218571904],
["1mbb",2.3,2.53724318474846],
["1b3d",2.3,2.39676279195833],
["1bqo",2.3,2.70799979123413],
["1sdm",2.3,2.97657177572124],
["2gd9",2.3,1.9062100018357],
["2f7m",2.3,2.57964252442316],
["1vez",2.3,2.68104773625024],
["1zaw",2.3,2.55215268305233],
["1l0s",2.3,2.67912222762387],
["1jnk",2.3,2.79353746615266],
["1f7p",2.3,2.93023015536195],
["1j93",2.3,3.29424757869341],
["1x7f",2.3,2.13724689412101],
["1r39",2.3,2.19833224292747],
["1dvi",2.3,2.05647485040232],
["1aj5",2.3,2.61551948245248],
["2b9j",2.3,2.60244256791782],
["1a5d",2.3,2.88157675932293],
["1gc9",2.3,2.64628461590472],
["1fxk",2.3,2.05693485327382],
["1bi2",2.3,2.61885771259291],
["4htc",2.3,3.54552667045725],
["1ic5",2.3,2.89405367043732],
["1c08",2.3,2.73220425951309],
["1lez",2.3,3.0953830497054],
["1lew",2.3,2.85508551264169],
["1e3j",2.3,2.35799011178817],
["2rsl",2.3,2.57901199358074],
["2paw",2.3,2.27857494526714],
["1jtn",2.3,3.72227282237703],
["1ndv",2.3,3.97146688516629],
["1stc",2.3,3.71061120967414],
["1qkj",2.3,2.92682564163202],
["1svh",2.3,2.23081768975731],
["1ydt",2.3,3.2358961627136],
["1psh",2.3,2.44918670131836],
["1goj",2.3,3.01231897593904],
["1q62",2.3,2.72799543789355],
["1sd0",2.3,2.41011808360212],
["1gtg",2.3,2.90054847774957],
["1jpi",2.3,2.14399843598087],
["1l4d",2.3,2.56182113509355],
["1erk",2.3,3.63917353921774],
["1sbr",2.3,2.80666692782887],
["1rdw",2.3,2.85748595010282],
["1d5w",2.3,2.05287592176269],
["8jdw",2.3,2.57515719678982],
["1bt4",2.3,2.07539842639184],
["2dhf",2.3,3.70872322500550],
["1dhf",2.3,3.452768478053],
["1cau",2.3,4.13901323673153],
["3np1",2.3,3.16162726418304],
["4np1",2.3,3.54141110531421],
["1nx0",2.3,3.18990693739741],
["1zzb",2.3,2.94411106664859],
["1w3c",2.3,3.10568018974517],
["1qnc",2.3,2.49866861013400],
["1fqc",2.3,3.26742310559718],
["1fqd",2.3,3.74213454562903],
["1mpd",2.3,1.83095675692774],
["1qn7",2.3,2.34044148857884],
["1ex6",2.3,3.51060500255166],
["1g0w",2.3,2.40078758955611],
["1ej3",2.3,2.30239773619935],
["1feu",2.3,2.89290566310233],
["1ahs",2.3,2.94846504147716],
["1ydx",2.3,2.30809989851243],
["1fjr",2.3,2.8806068645003],
["2vaa",2.3,1.84826365387292],
["1k8d",2.3,2.96650384962066],
["1s4y",2.3,2.98653925899173],
["1s9y",2.3,2.48853658010813],
["1age",2.3,2.10870014026323],
["1hjo",2.3,2.14104547376980],
["2bwb",2.3,2.22493686279252],
["1xr8",2.3,2.47991270265413],
["1wby",2.3,2.71474753348006],
["1a1o",2.3,2.25147192869410],
["2bsr",2.3,2.52177432655784],
["2cz3",2.3,2.43360892432571],
["1a1m",2.3,2.8120134071683],
["2b4e",2.3,2.25572026055783],
["1zww",2.3,2.33046190958637],
["4nn9",2.3,2.5416990780966],
["3nn9",2.3,2.55805916900288],
["6nn9",2.3,2.58565970791289],
["5nn9",2.3,2.47309287974253],
["1zet",2.3,3.44540485144863],
["1x92",2.3,2.30201576835818],
["1oxm",2.3,2.14269160050911],
["1lxn",2.3,1.88361057422801],
["1zyn",2.3,2.73575271632286],
["1pbd",2.3,2.54727667672936],
["1n5l",2.3,2.1715765527738],
["1aer",2.3,2.8681162479948],
["1j6r",2.3,3.14670159830667],
["2fqm",2.3,3.36261672335023],
["1x3n",2.3,2.49132871765355],
["1qnm",2.3,2.87692307374735],
["1luw",2.3,3.04260121132368],
["1phh",2.3,4.26531060965544],
["1pxb",2.3,2.04159234520897],
["1pxa",2.3,2.45947955166587],
["1doe",2.3,2.23865805260448],
["1qhu",2.3,3.08339860527187],
["1nsa",2.3,2.67175031384727],
["1pd2",2.3,2.65630726207687],
["1bqg",2.3,3.05811512550993],
["1zkg",2.3,2.03831675115039],
["1us7",2.3,2.5114463099039],
["1rbm",2.3,2.14556742964202],
["1u5y",2.3,2.84460302886887],
["1bwk",2.3,2.56332065590129],
["2ccg",2.3,2.74606072145678],
["1inp",2.3,3.56791043832792],
["1akb",2.3,2.76439775666074],
["1maq",2.3,2.90503875735011],
["1akc",2.3,2.95218480054232],
["1ama",2.3,3.25463298651414],
["1xvt",2.3,2.36650765464054],
["1jin",2.3,2.39034927347405],
["1g9q",2.3,3.02212641236688],
["1b79",2.3,2.64872013287667],
["3cp4",2.3,3.43524654746966],
["1p2y",2.3,2.44821077690463],
["1pcv",2.3,3.05957509775580],
["1wb8",2.3,2.20910108722148],
["1cpt",2.3,2.52483545913701],
["1a0q",2.3,2.37381809420035],
["1qqg",2.3,2.59991352378008],
["1ief",2.3,2.89806940622640],
["11gs",2.3,2.39090483564937],
["1ey2",2.3,1.95795461562259],
["1lq1",2.3,3.41236046243066],
["1t2o",2.3,3.0484719195023],
["1zcp",2.3,2.3109172752087],
["1mh4",2.3,2.72219270357282],
["1mrd",2.3,2.80532812083510],
["2bdq",2.3,3.00439941323963],
["1xw9",2.3,3.2820168546477],
["1mre",2.3,2.85208720166198],
["1qwc",2.3,3.30581588275169],
["1fm7",2.3,2.3413104401025],
["1fm8",2.3,2.45159717866634],
["1mac",2.3,3.13241862729494],
["1f23",2.3,2.98680650013008],
["1ik9",2.3,2.57882432112078],
["2bac",2.3,1.54220019727083],
["1f4w",2.3,2.76804484581483],
["1f4x",2.3,2.87443186306527],
["1wrn",2.3,3.00824586937888],
["1npe",2.3,2.50918225157091],
["1lhz",2.3,2.7487197966248],
["2bfz",2.3,2.51310661726976],
["2bg6",2.3,2.40919966069364],
["1j6u",2.3,2.88294403946787],
["1q5n",2.3,2.46763417891512],
["1gig",2.3,3.05894556088172],
["1m7d",2.3,2.77855282790447],
["1dcl",2.3,3.95829927029627],
["3bjl",2.3,4.11252789366104],
["1cib",2.3,2.71906664790273],
["2fhe",2.3,2.57410099880662],
["1tet",2.3,3.04017530846560],
["3bif",2.3,2.25794322498835],
["8ohm",2.3,3.20064653130948],
["1k5j",2.3,2.32828551403376],
["1a16",2.3,2.00622374866822],
["1ejo",2.3,2.80128402463594],
["1wvt",2.3,2.23244030030747],
["1lvh",2.3,2.69420301096672],
["1ggg",2.3,3.52683531046747],
["2azo",2.3,3.34324623168427],
["1ibz",2.3,2.19702750626427],
["1n51",2.3,1.89088478760081],
["1gk4",2.3,2.82075792226638],
["1yyn",2.3,3.04361866579457],
["1c7q",2.3,2.90121315714517],
["2pgi",2.3,3.21365798205245],
["1b0z",2.3,3.21379916675071],
["2g2x",2.3,1.83829562427045],
["1ka9",2.3,2.89953129592327],
["1kdp",2.3,2.79280446909256],
["1trm",2.3,3.06783948699295],
["1hqo",2.3,2.8909656964797],
["1lwx",2.3,2.88636186262528],
["1am7",2.3,1.94617412435512],
["2bef",2.3,2.43600031101667],
["1b08",2.3,2.30594065049034],
["1kxh",2.3,1.52652100878866],
["1v4s",2.3,2.61276327043887],
["1q1s",2.3,2.79497948031984],
["1mbu",2.3,1.97286387681653],
["1q5i",2.3,2.48648203115376],
["1s52",2.3,2.80591635379203],
["1zs6",2.3,1.99385330479966],
["1a8m",2.3,4.07485208086022],
["1lky",2.3,3.01209457518986],
["1g1o",2.3,2.74786268786163],
["1muh",2.3,3.29443239617109],
["1o6e",2.3,3.60337281545271],
["1lof",2.3,3.08302971512579],
["1kcf",2.3,2.24878777514223],
["1e1l",2.3,2.51867537890926],
["1pdu",2.3,1.89818161464718],
["2bnh",2.3,2.72296911496472],
["1tql",2.3,2.61211906059305],
["1wsu",2.3,3.06662642681419],
["1q5v",2.3,2.68072533486472],
["1x7j",2.3,2.52896058701853],
["1ep5",2.3,2.57479811764133],
["1grt",2.3,2.81053604149075],
["1n6b",2.3,2.96555045736582],
["1x7b",2.3,2.68859184525252],
["1cp3",2.3,2.77379039179667],
["1x78",2.3,2.53994505560168],
["2bdm",2.3,2.0285014034089],
["2bne",2.3,2.89833855556342],
["1gc5",2.3,3.41109877856285],
["1k6r",2.3,2.51221418750281],
["1wbf",2.3,2.75033953453294],
["1pgn",2.3,2.92823733448977],
["1nm0",2.3,1.82945072214381],
["1kgj",2.3,2.60821454672462],
["1ome",2.3,2.84827836368663],
["1rtk",2.3,2.44931972860408],
["1eqy",2.3,2.79285421529139],
["1b49",2.3,2.27498091971325],
["2d3l",2.3,2.25630259693493],
["1jxh",2.3,2.80268363529863],
["1cwv",2.3,3.054261796591],
["1h7h",2.3,1.96797578439961],
["1hfz",2.3,2.98218818332411],
["2baw",2.3,2.72437304923664],
["1b96",2.3,2.78321783109833],
["1eov",2.3,2.19557307782608],
["1oe5",2.3,2.91107421883171],
["1xpj",2.3,2.48766912221326],
["1p9l",2.3,2.95434273520727],
["1fgg",2.3,1.96858631327287],
["1yl5",2.3,2.3916985090116],
["2bbt",2.3,2.02853043465615],
["1pif",2.3,2.25837616860034],
["1c8q",2.3,2.28743244151906],
["1fa2",2.3,3.30751478115998],
["1isj",2.3,2.36231573262961],
["1uxr",2.3,2.68473002236117],
["1uxn",2.3,2.74108127082122],
["1yol",2.3,2.09255633068427],
["1x7g",2.3,2.90967158826522],
["1fp8",2.3,2.04071171352465],
["1qai",2.3,3.18405673268747],
["1sh2",2.3,2.60631346857240],
["1g0h",2.3,3.62024800101734],
["1ahh",2.3,2.92692131155918],
["2f7y",2.3,2.36099588402476],
["2tsb",2.3,3.11653290486411],
["1etj",2.3,2.70305062513666],
["1jxo",2.3,2.04689821869264],
["1ct1",2.3,2.41993989615915],
["1uoc",2.3,3.10095997854889],
["1ahi",2.3,2.72243732637185],
["2brk",2.3,2.04266362776698],
["1e5r",2.3,3.59966518422773],
["2d4q",2.3,2.78165278397438],
["2bmb",2.3,1.95864763370095],
["1tjr",2.3,3.13478946790113],
["1pum",2.3,3.00873851808567],
["1puu",2.3,2.90358251201828],
["1m6u",2.3,3.23681485618199],
["1vko",2.3,2.5247568142558],
["1lb9",2.3,1.95739160471963],
["1swv",2.3,2.56932185554192],
["1sww",2.3,2.71406487826641],
["1lw3",2.3,2.77360246758536],
["2a8h",2.3,2.79329628720664],
["1qaj",2.3,2.87425445784464],
["1yqy",2.3,3.18032992419755],
["1b52",2.3,2.67731934508399],
["1x7h",2.3,3.03979331984403],
["1lw1",2.3,3.33564546290771],
["1p0p",2.3,2.70439501838505],
["1lb8",2.3,2.18561915090956],
["1s7j",2.3,3.07553275677973],
["1mqb",2.3,2.76041761357698],
["1cr5",2.3,2.59880613422679],
["1yra",2.3,2.87086124172614],
["1exz",2.3,3.41637281043999],
["1sgk",2.3,2.54028153315294],
["1lss",2.3,2.96444681348067],
["2ktq",2.3,3.54166986523009],
["2gb5",2.3,1.52377765786157],
["1k74",2.3,3.36615788171142],
["1k3r",2.3,3.69732964291816],
["1zgb",2.3,2.35609991955144],
["1dx6",2.3,2.59138533449403],
["2d1q",2.3,1.95744745354620],
["1f6f",2.3,2.86798687838531],
["1k4d",2.3,2.22334215828781],
["1slb",2.3,2.94481737223334],
["2gwx",2.3,3.33981879635076],
["1jjb",2.3,2.27625988961576],
["2bva",2.3,3.76139061673456],
["1qig",2.3,2.62432058844936],
["1jtd",2.3,2.07085777325300],
["1cbu",2.3,3.60782691659188],
["1f6w",2.3,3.40289690978254],
["2dfp",2.3,2.64877265912549],
["1p9o",2.3,2.51513479538830],
["2ast",2.3,2.36994461455328],
["1g4u",2.3,2.61280167727611],
["1y2i",2.3,2.54832592201293],
["1ctn",2.3,2.68895459563014],
["3ktq",2.3,3.16131557359482],
["1qss",2.3,2.9345044303035],
["1qsy",2.3,3.07726798428907],
["1qtm",2.3,2.9519113506419],
["2prg",2.3,2.41587263628372],
["1qqr",2.3,3.02510254481167],
["1f48",2.3,3.14858259950547],
["1tw5",2.3,2.53271890335129],
["1tvy",2.3,2.67761838453634],
["1tw1",2.3,2.8804435747531],
["1o0r",2.3,2.86933885291765],
["1ima",2.3,2.10297000164524],
["1sg8",2.3,3.14826001282832],
["1jzd",2.3,2.94539731919737],
["1zd3",2.3,2.66156053554197],
["1vyu",2.3,2.20917650080006],
["1cy2",2.3,2.75014730046648],
["1cy1",2.3,2.79496106954593],
["1sgi",2.3,3.04511044334214],
["1t57",2.3,3.79605151973931],
["1rpm",2.3,2.79528166714674],
["1qdn",2.3,2.50428203721685],
["1f80",2.3,3.09076137462672],
["1rrj",2.3,2.46184683717386],
["1y14",2.3,2.71606768501316],
["1hbr",2.3,3.03950042962788],
["1smp",2.3,2.04491648500508],
["1mkw",2.3,3.58917158114363],
["1y0c",2.3,2.62960829074689],
["1bij",2.3,3.15800034609919],
["1hab",2.3,3.93295690185439],
["1y8k",2.3,2.55896614892914],
["2aou",2.3,2.24765185140221],
["1zz8",2.3,2.61931883295015],
["1y82",2.3,1.75351065293921],
["1cki",2.3,2.79543909359616],
["1q6p",2.3,2.72282480808401],
["1npd",2.3,2.83011097933319],
["1rsc",2.3,2.62808604814779],
["2d06",2.3,2.81134539071076],
["1qex",2.3,2.8592053126104],
["1s2e",2.3,2.90171765533382],
["1jn9",2.3,2.15744657277897],
["1q6t",2.3,2.54987649657660],
["1aux",2.3,2.62788420853665],
["2g07",2.3,2.14477650564586],
["1ts2",2.3,1.80650165926238],
["1zrl",2.3,2.58606070705988],
["1f14",2.3,2.07700471759617],
["1m75",2.3,2.32414786087299],
["1gal",2.3,2.81190557599542],
["2bxp",2.3,2.72705266979811],
["1s5t",2.3,2.05605013224381],
["1f17",2.3,1.99133152209770],
["2gj1",2.3,2.61888113613439],
["2c7b",2.3,3.29052576350994],
["1zwj",2.3,2.45145822137729],
["1xzp",2.3,2.98992281679959],
["3ng1",2.3,2.78475084265626],
["1iq0",2.3,2.64735517924072],
["1x1x",2.3,2.67138967412455],
["1x1u",2.3,2.83866135207037],
["1wkm",2.3,2.45803436005644],
["1rc5",2.3,3.71503206018297],
["1ni2",2.3,2.90959526756376],
["1oph",2.3,2.25010885558619],
["1dkr",2.3,2.90812919794802],
["1k9o",2.3,3.25558000556381],
["1apz",2.3,2.65693051149616],
["1ksp",2.3,3.04542926569712],
["1t7o",2.3,2.55208409903466],
["1v19",2.3,2.99379540310035],
["2a5k",2.3,2.88857434989615],
["1jwu",2.3,2.63636218356953],
["2amq",2.3,2.78138311913229],
["1ikn",2.3,3.71351986601029],
["1xec",2.3,2.67139909749392],
["1jsu",2.3,2.78704720715701],
["1ghs",2.3,2.28068329560326],
["1sqm",2.3,2.35002670619943],
["1ry2",2.3,3.40553856601174],
["1vlw",2.3,1.89401026514606],
["1u2l",2.3,2.5872394936922],
["1eqw",2.3,2.71464571223357],
["2b5i",2.3,2.88912014500392],
["1wsf",2.3,3.22961984654507],
["1hq5",2.3,2.79699106484311],
["1dlq",2.3,2.65217691016388],
["1wvb",2.3,3.36025722744063],
["2dd8",2.3,2.88619956360942],
["1wda",2.3,2.78597952071693],
["1r4f",2.3,2.46739221437587],
["1nfk",2.3,3.71376543861682],
["1qo3",2.3,2.32457186133541],
["1fpi",2.3,2.46281004599826],
["1fpl",2.3,2.43400362916757],
["1fpg",2.3,2.61387207758110],
["1oc4",2.3,2.75572229519408],
["1f9d",2.3,1.53635672410305],
["1fbo",2.3,1.72270806696568],
["1mwk",2.3,2.90531349005668],
["1ww4",2.3,3.08993233834418],
["1avh",2.3,2.96952382513559],
["1ma7",2.3,3.86530008910906],
["1n0l",2.3,2.85844393032541],
["1uuw",2.3,2.41900522580565],
["1c03",2.3,2.90086760746330],
["1t2x",2.3,1.81917084026438],
["1w9c",2.3,2.44486717040663],
["1a5s",2.3,3.36161881200971],
["1ttp",2.3,3.06828051578505],
["1u7z",2.3,2.66057980372434],
["1a50",2.3,2.42141102041233],
["2eud",2.3,2.87893191302972],
["1c9d",2.3,2.88153538753138],
["1c29",2.3,2.88696135416279],
["1cx9",2.3,3.03194106875699],
["1xwk",2.3,2.59455777515271],
["1fwy",2.3,2.39641103628487],
["1hiw",2.3,3.39182762033245],
["1xmu",2.3,1.99447464873353],
["1k7e",2.3,2.53869331370573],
["1m41",2.3,3.35438018619948],
["1xds",2.3,2.60452252787241],
["2bkt",2.3,3.42797864289058],
["2fky",2.3,2.44267528712823],
["1nb8",2.3,3.16184740906708],
["1xez",2.3,2.22945947756004],
["1v3t",2.3,2.23196161285798],
["1v6a",2.3,2.32350862340763],
["1muq",2.3,3.15820901967999],
["1q4k",2.3,2.92590039819452],
["1s8e",2.3,2.64711192793110],
["1i1i",2.3,2.52100970053237],
["1u6s",2.3,2.32177882802915],
["2b7j",2.3,3.09862796255218],
["1azt",2.3,1.86865657923116],
["1fsa",2.3,3.43327918549146],
["1zvw",2.3,2.423622102331],
["1ph5",2.3,2.52916834368374],
["1hmw",2.3,2.64496197979627],
["1ph4",2.3,2.34719584727620],
["1ph3",2.3,2.42458385214673],
["1q3w",2.3,2.45008855419333],
["1bth",2.3,2.90452881193643],
["1l3a",2.3,2.76471912937521],
["1gzs",2.3,2.43029289779024],
["2ae4",2.3,1.84544184551903],
["1s0y",2.3,2.70164635471827],
["1ciu",2.3,2.98966585757793],
["1ezs",2.3,2.14025489737118],
["1rpx",2.3,2.55217002956071],
["1p8c",2.3,3.26300252903800],
["1y23",2.3,2.43333542030887],
["1r37",2.3,2.21251135269464],
["1bxg",2.3,2.95655815658375],
["1pr1",2.3,2.72578818386239],
["1uum",2.3,2.35416095125644],
["1aa6",2.3,3.04401125853194],
["1x0v",2.3,2.65546169485967],
["1pke",2.3,2.53608070550534],
["1ics",2.3,2.27395352492409],
["1n9w",2.3,2.5445122757875],
["1yj4",2.3,2.16536375432861],
["1xai",2.3,3.55856875424494],
["1f3m",2.3,3.2925930502201],
["1kob",2.3,2.59102495292793],
["1q97",2.3,2.62129601411141],
["1pr2",2.3,2.49073469228386],
["1td5",2.3,3.01978984663930],
["1q0o",2.3,1.99093168157933],
["1azs",2.3,2.29154698142845],
["1n95",2.3,3.05571296937413],
["3bls",2.3,3.11555460177651],
["1utc",2.3,2.16677047206258],
["2muc",2.3,1.9847202136315],
["3muc",2.3,1.96111930684327],
["1ke0",2.3,2.29639531593485],
["1iem",2.3,2.19763515377581],
["1j8d",2.3,2.86793600491042],
["1o5m",2.3,2.17990393801322],
["1o1r",2.3,2.07942772981813],
["1o1s",2.3,2.38484304718519],
["1bls",2.3,3.07161461628014],
["1bjn",2.3,1.46049671181681],
["2b98",2.3,3.03545382683687],
["1mdp",2.3,2.85191785793135],
["1azz",2.3,2.57677731605152],
["1n7q",2.3,2.84199948486143],
["1jcq",2.3,2.11514806655697],
["1hjw",2.3,3.01556997807287],
["1w29",2.3,2.30132187689325],
["1ng4",2.3,2.67893252092640],
["1p19",2.3,3.72269877067032],
["1ltt",2.3,2.31422798151715],
["2b8e",2.3,2.81714583539558],
["1tn7",2.3,1.91740216399282],
["1gp2",2.3,3.28209725847623],
["1nx8",2.3,2.02282370281446],
["1p7o",2.3,2.94792475896264],
["1itq",2.3,2.49527680498892],
["1g31",2.3,2.68308635816596],
["2bvn",2.3,2.72735396465830],
["1d1c",2.3,3.39624531186539],
["1qjg",2.3,2.75578818257971],
["2d0t",2.3,2.90221878952185],
["1p3i",2.3,2.17549634390057],
["1ma0",2.3,2.03444997891596],
["1m6w",2.3,2.08366004463172],
["1li5",2.3,2.89437827127604],
["1m72",2.3,2.39688789007054],
["1m19",2.3,2.67806349061752],
["1x1h",2.3,2.63015122089742],
["1j0m",2.3,3.07501628768460],
["1xme",2.3,2.59517082362075],
["1jti",2.3,3.00052425245461],
["1tqd",2.3,2.99252251429753],
["1wu2",2.3,2.36358550714885],
["1s7t",2.3,2.26734226410989],
["1kit",2.3,3.70645851022969],
["1vft",2.3,3.34806896786333],
["1ibj",2.3,3.17585784695819],
["1js8",2.3,2.62500306448846],
["1eez",2.3,2.68918622382811],
["1nan",2.3,3.08130513081035],
["1kec",2.3,2.02516002439746],
["1kj3",2.3,2.476616675478],
["1kra",2.3,2.53551539134236],
["1sl2",2.3,2.26695269618244],
["1vym",2.3,3.28088265159579],
["1wc5",2.3,2.84704742955137],
["1rjn",2.3,2.32761285281075],
["1ws9",2.3,1.75115670167573],
["2bw7",2.3,2.91020742102918],
["1x9w",2.3,2.5795003152186],
["2ccr",2.3,2.37741892904443],
["1t3n",2.3,3.74767981842884],
["1vkz",2.3,2.50513082250895],
["1skw",2.3,2.51615605943459],
["1ay8",2.3,2.60595451472786],
["1dco",2.3,3.66013862481383],
["1dcp",2.3,3.47067106467569],
["1sks",2.3,2.69400423170447],
["1ei1",2.3,2.97601722369751],
["1pzy",2.3,2.67720747559508],
["1iyk",2.3,2.23333012528140],
["4xia",2.3,1.89910434396925],
["1xla",2.3,2.31238283988982],
["1tk0",2.3,2.60315459829335],
["2gds",2.3,2.76900627194196],
["1iea",2.3,2.60877834127836],
["1arh",2.3,3.5319852484277],
["1ahy",2.3,3.48050404924933],
["1ahe",2.3,3.4159598975097],
["1ahf",2.3,3.56941387958561],
["1ari",2.3,3.78025977658407],
["1t1r",2.3,2.74464215151626],
["1bx3",2.3,2.41856097388939],
["1f2e",2.3,2.18710013700711],
["4ovw",2.3,2.71219563563186],
["3ovw",2.3,2.45470051385001],
["2b11",2.3,2.54887205294205],
["2pcc",2.3,3.57910183425501],
["8aat",2.3,2.50029642334347],
["1dkl",2.3,2.45881194542033],
["1p2g",2.3,2.52281682055298],
["1rs8",2.3,2.65310724859380],
["1uzu",2.3,2.72201987596115],
["1c8l",2.3,2.82720326866908],
["1gfz",2.3,3.07094030080396],
["1en5",2.3,1.77760924971407],
["2b7n",2.3,2.83544485329631],
["1z8d",2.3,2.62438598427426],
["1yex",2.3,2.31495893084837],
["1sg9",2.3,2.58383583933579],
["1e6d",2.3,2.29485449684752],
["1jwk",2.3,2.03711759036479],
["1r35",2.3,2.96242420928940],
["1o9o",2.3,2.46832871087983],
["1fop",2.3,2.74314423227345],
["1axr",2.3,3.20236336894389],
["1z5u",2.3,1.52653714822978],
["1c50",2.3,3.17561096225446],
["2pri",2.3,3.22069211989705],
["2prj",2.3,3.23463376433989],
["2gpb",2.3,3.05529092041058],
["1o5o",2.3,2.27089389115639],
["4gpb",2.3,3.09591045648407],
["3gpb",2.3,3.17352738328543],
["5gpb",2.3,3.21735279191289],
["1sot",2.3,3.37306472374867],
["1tpl",2.3,2.94469460449117],
["1xkd",2.3,2.86412674170877],
["1c3u",2.3,2.36819399855156],
["1ung",2.3,3.18564138123925],
["1xf2",2.3,1.68582770946620],
["1rh0",2.3,2.34897734642668],
["1gxs",2.3,2.24012737743174],
["1nop",2.3,2.34992310157661],
["1s0w",2.3,2.19903307802194],
["1xf3",2.3,2.19991163019827],
["1nxe",2.3,3.33066404735225],
["1r4a",2.3,3.11766192446643],
["1t3z",2.3,2.38106180646949],
["1o27",2.3,2.29442910132663],
["1w4b",2.3,2.85848541001769],
["1vbh",2.3,2.53783766640634],
["1hon",2.3,3.30803387572262],
["1hoo",2.3,3.22527646320005],
["1hop",2.3,3.50467515317640],
["1v3c",2.3,2.62475238427282],
["2bmk",2.3,2.92591420849810],
["1xcc",2.3,2.20810020731227],
["1dik",2.3,3.55456420271613],
["2rus",2.3,3.47527140474446],
["1gg4",2.3,3.11470016418675],
["1i7z",2.3,2.79868794695273],
["1lo3",2.3,3.15662668147042],
["1t66",2.3,3.00037105306005],
["1vbg",2.3,2.49808168097403],
["1hm0",2.3,2.76126240756284],
["1rz8",2.3,2.83043645480902],
["1emc",2.3,2.56289576010938],
["1khj",2.3,2.30503346483304],
["1anj",2.3,2.46450273723083],
["2b3q",2.3,2.79041549837033],
["1upf",2.3,3.74708016813268],
["1m0t",2.3,2.46733208234650],
["1qgr",2.3,2.9746408351442],
["1hjk",2.3,3.05080337721171],
["2b7o",2.3,2.66984351085868],
["1w48",2.3,2.45026817344530],
["1t0r",2.3,2.74631128617049],
["1hpl",2.3,2.47785455501745],
["1pbg",2.3,2.36183242926418],
["1bbr",2.3,3.66119971201813],
["1fv3",2.3,3.41678693762273],
["1u28",2.3,2.34562001510784],
["1kbi",2.3,2.6588942034252],
["43ca",2.3,2.64912263930064],
["1fah",2.3,2.74319027141003],
["1fqk",2.3,2.41508471017665],
["1yny",2.3,2.98505808376735],
["2auk",2.3,2.70678463534882],
["1xr7",2.3,2.19812340156229],
["1f1b",2.3,3.43830709659104],
["1l5h",2.3,3.01046905650403],
["2amt",2.3,2.3117334273244],
["1ixo",2.3,2.89804914161686],
["1ixq",2.3,3.05974243340975],
["1gd8",2.3,3.65536888301985],
["4pgm",2.3,3.05241063142635],
["1dnp",2.3,2.27236121222267],
["1h48",2.3,2.28455429239630],
["1wuv",2.3,2.83365208329260],
["1cvn",2.3,2.31979301211924],
["1njf",2.3,2.80164066244314],
["1rzv",2.3,2.27390914691503],
["1rzu",2.3,2.73518703943520],
["1jvg",2.3,2.60545663061486],
["1jxn",2.3,3.13163995189870],
["1ixp",2.3,2.97840672263593],
["1ho4",2.3,2.73674024806171],
["1ixn",2.3,2.78745261051456],
["1j3l",2.3,3.06364437248235],
["1mxf",2.3,2.66305699547709],
["1aog",2.3,2.23630091052984],
["2fs9",2.3,2.67916271692976],
["1wnt",2.3,3.55736312529878],
["1hsj",2.3,3.63163641425725],
["2f9p",2.3,2.62725776987275],
["1yy5",2.3,3.02328216336198],
["2a4m",2.3,3.53774085128583],
["1ecg",2.3,2.15099579351278],
["2g7u",2.3,2.14966967708690],
["1g2c",2.3,2.61874669214944],
["1wvi",2.3,2.725433339135],
["1yt5",2.3,2.95065986226263],
["1tox",2.3,2.67453779861167],
["1jx2",2.3,2.56395849461134],
["1jwy",2.3,2.64217298563347],
["1ki1",2.3,3.14531282922845],
["2csb",2.3,2.44936353963679],
["1w76",2.3,2.78570190842043],
["1erj",2.3,2.23564498854759],
["1xnv",2.3,2.77261097622398],
["1mdt",2.3,3.01425379411277],
["1n1z",2.3,2.06225897277362],
["1n20",2.3,2.17351229851192],
["1n24",2.3,2.23144316792092],
["1ygy",2.3,3.13841302804531],
["1pvd",2.3,2.98944761020954],
["1s1m",2.3,3.77170348389437],
["1o5q",2.3,2.45269822177007],
["1kk8",2.3,3.05221446125016],
["1djx",2.3,3.20536422591462],
["1yqf",2.3,1.71740059357838],
["1uik",2.3,2.65231801370512],
["1urp",2.3,2.26990117130856],
["1j3j",2.3,2.59919057079096],
["1qbg",2.3,3.00911934487286],
["1kbo",2.3,3.20917590921690],
["1jw7",2.3,3.23402932158373],
["1iy9",2.3,2.99067407485890],
["2fok",2.3,3.27319134444543],
["1pkd",2.3,2.86021532418245],
["2c5p",2.3,3.0365032119011],
["1vyw",2.3,2.31267051464368],
["1fin",2.3,3.40972212779519],
["1ydn",2.3,2.86894994282367],
["1e6e",2.3,2.65344605652906],
["1l8w",2.3,3.0504052505874],
["1ca9",2.3,2.94471722689373],
["1pv1",2.3,3.28269941148802],
["1yox",2.3,3.01346585365867],
["2b4s",2.3,1.69396619383934],
["2bwj",2.3,1.77464579982178],
["1it7",2.3,3.01392313347808],
["1h5s",2.3,2.83032152044974],
["1ji2",2.3,2.52039865629897],
["1wzk",2.3,2.60774882516984],
["1b3u",2.3,2.67883395725331],
["1nbf",2.3,3.20958540572588],
["1o4z",2.3,2.13746157300665],
["1prc",2.3,2.98720781111832],
["1rp3",2.3,2.32141263026648],
["1llq",2.3,2.76468103532385],
["1ndi",2.3,3.28135622726136],
["1yw3",2.3,2.79449777791599],
["2ggk",2.3,2.56133068215717],
["2can",2.3,2.68929061506608],
["1gbn",2.3,2.84678293250650],
["1aor",2.3,2.31472282287082],
["1pgu",2.3,2.59819269056374],
["1ibr",2.3,3.15277136757244],
["1s7g",2.3,2.3341070618049],
["1tll",2.3,3.24965660565644],
["1ez4",2.3,2.35093552019409],
["1bgx",2.3,3.04856849398434],
["2mas",2.3,2.67828527457306],
["1fta",2.3,2.51537012784400],
["1jx1",2.3,2.97825664044917],
["1pg3",2.3,2.03340143905813],
["1ye6",2.3,1.73564838854317],
["2cx4",2.3,3.49489208937218],
["1s0f",2.3,2.98191508723319],
["1qdm",2.3,3.5301167616657],
["1ub7",2.3,2.66621347618321],
["1xsl",2.3,1.87925724778318],
["2a8c",2.3,2.78876195881087],
["1zsv",2.3,1.76153677511271],
["1ptw",2.3,2.72614540673135],
["1q9m",2.3,2.41458130141524],
["2awn",2.3,3.33546019798004],
["2scu",2.3,3.50934925748],
["1iil",2.3,2.56630257182605],
["1u5w",2.3,3.01406073385373],
["2aq3",2.3,3.94610360293585],
["1tkb",2.3,2.60289792363574],
["1fzc",2.3,3.3026011039667],
["6ald",2.3,3.11888007368562],
["1so0",2.3,3.06807561915930],
["1kr2",2.3,2.44275493857836],
["1rye",2.3,3.09564535074433],
["1y10",2.3,2.37901530698526],
["1xs2",2.3,2.39909406300884],
["1xpy",2.3,2.65939677510800],
["1j7n",2.3,3.06691970330582],
["1ixe",2.3,2.51422034148593],
["1sja",2.3,3.46831045480591],
["1u1f",2.3,2.08654988384268],
["2b35",2.3,2.84553000427593],
["2fut",2.3,2.33759156098397],
["1vz0",2.3,2.80744253173977],
["1kh2",2.3,2.67997265745425],
["1kh1",2.3,2.70242676676337],
["1ilu",2.3,2.30591363422731],
["1cm5",2.3,2.26911632548148],
["1h18",2.3,2.35710770635506],
["1j70",2.3,2.74959982912467],
["1hwi",2.3,2.18507594095697],
["1ey3",2.3,2.63211672330256],
["1bxc",2.3,2.90180036769482],
["4xim",2.3,1.90567472586735],
["1z5h",2.3,3.02440667611272],
["3xim",2.3,2.05570859452697],
["5xin",2.3,2.04725761170382],
["3xin",2.3,2.04300394272659],
["2xim",2.3,2.09309239464236],
["2xin",2.3,2.1897504336399],
["1lv8",2.3,3.20277246248993],
["1l7x",2.3,2.27180715543484],
["2ovw",2.3,2.54361383186632],
["1g5i",2.3,2.66510751268942],
["2a9g",2.3,3.31242089970634],
["2aq7",2.3,2.22702086348129],
["2aaf",2.3,3.26528441808157],
["1dd8",2.3,2.23330885068198],
["1dx5",2.3,2.50695869811156],
["1dcn",2.3,2.99592098198555],
["1rf5",2.3,2.78325780443589],
["1yp4",2.3,2.83842095202326],
["1rj7",2.3,2.41525457477579],
["1uc5",2.3,2.68234420927522],
["1wbq",2.3,1.31161668622756],
["1uc3",2.3,2.34743433698553],
["1bgg",2.3,2.5908588513843],
["1j08",2.3,2.33828351010925],
["1hy1",2.3,2.79372552064322],
["1ohv",2.3,1.95462736329655],
["2bgc",2.3,2.68727347868087],
["1jja",2.3,2.72982989901199],
["1si8",2.3,2.52023048122547],
["1q15",2.3,2.52074997508643],
["1k9x",2.3,2.80102812272945],
["1itz",2.3,2.32838378983632],
["2b43",2.3,2.70513197856085],
["1t70",2.3,3.2544911946454],
["1b33",2.3,2.0899811755383],
["1q3q",2.3,2.68697346427171],
["1xvd",2.3,2.53066059094815],
["1xu3",2.3,2.56261697523541],
["1fz9",2.3,2.83918594002026],
["1ezv",2.3,2.90107959042752],
["1kb9",2.3,2.79334387725939],
["1pj4",2.3,2.63400314547783],
["1pj2",2.3,2.80947634173191],
["1gz3",2.3,2.59298802330882],
["1m56",2.3,3.37985926175797],
["1l6l",2.3,3.39985024551503],
["1m7x",2.3,3.33080183597469],
["1t9d",2.3,2.09041560819547],
["1upp",2.3,2.76491691912192],
["1u2j",2.3,3.44669959920706],
["1rbo",2.3,2.29968759360148],
["1r56",2.3,2.40081745916717],
["2cv4",2.3,3.26829809808242],
["1tb3",2.3,2.6819540661504],
["1i10",2.3,3.14111258795615],
["2gl6",2.3,1.69119814070411],
["1w88",2.3,2.06631418510769],
["1llu",2.3,2.96155558795322],
["1mx0",2.3,3.04538126645286],
["1pmo",2.3,2.33478963181334],
["1ru7",2.3,2.7876426805631],
["1r9n",2.3,2.55516832894080],
["2afk",2.3,2.4341527053922],
["1vrg",2.3,1.58187310300643],
["1q51",2.3,2.58799745171824],
["2c91",2.3,2.20996391564786],
["1ryw",2.3,2.16320372057419],
["2occ",2.3,2.66127483439543],
["1twf",2.3,3.23042997158439],
["2bkc",2.3,2.30728349545869],
["1qhb",2.3,1.59107634809061],
["1vqm",2.3,2.78097832596951],
["1vql",2.3,2.80646824975778],
["1vqk",2.3,2.79444778387693],
["1wpg",2.3,2.82718466627191],
["1ya7",2.3,2.39900117018794],
["1upm",2.3,2.42880448537484],
["1rco",2.3,2.4135390748114],
["1uwa",2.3,2.16549979058465],
["1m34",2.3,2.66704554899359],
["2g23",2.3,3.01922371799197],
["1xma",2.3,1.36619746539549],
["2a4k",2.3,1.26746676220636],
["1rzn",2.3,2.64355611633941],
["1w55",2.3,2.08992950605232],
["1xqu",2.3,1.59585435722037],
["5rhn",2.31,1.70571595599078],
["2bhi",2.31,2.61702149037953],
["1rs2",2.31,2.94745918867349],
["2ffg",2.31,2.87566166127653],
["1jim",2.31,2.2666854317532],
["1ggl",2.31,3.68057033682318],
["1pzd",2.31,2.33001379892170],
["1v1k",2.31,2.73004627722218],
["1xcd",2.31,2.24684501606861],
["1ziv",2.31,2.36628514129792],
["1iub",2.31,2.06162921829761],
["1s7o",2.31,2.0086846000245],
["1z7b",2.31,2.52699293741287],
["1siu",2.31,2.92921923013844],
["1t67",2.31,2.55940975904943],
["1dli",2.31,2.43822762699471],
["1s6y",2.31,2.61402794225613],
["1xn0",2.31,2.06680836727174],
["1xm4",2.31,2.12877342585344],
["1ybt",2.31,2.89499541951302],
["1zee",2.31,2.79267379485934],
["1ulh",2.31,3.3030113124212],
["1l3c",2.31,2.15347618271913],
["1ajp",2.31,2.46421553580162],
["1tog",2.31,2.74089759599284],
["1j78",2.31,2.61812648342314],
["1vh0",2.31,2.59025827553350],
["1tu3",2.31,3.1104091527772],
["1vgv",2.31,2.73966483633987],
["1b0p",2.31,2.88446012774942],
["2bp3",2.32,2.41264915545637],
["2a3q",2.32,2.49307862837634],
["2f4e",2.32,3.02267918114603],
["1qtr",2.32,3.43538010088371],
["1vmi",2.32,1.81064240962364],
["1eyi",2.32,2.40710121055994],
["1vhz",2.32,2.50106693866964],
["1q87",2.32,3.03612370720953],
["2aq4",2.32,2.96460143354678],
["1hxa",2.32,2.31056622046822],
["1ayy",2.32,2.70177125490036],
["1s5w",2.32,2.03756050772157],
["1omo",2.32,3.19281531651017],
["1pez",2.32,2.070811604684],
["1o23",2.32,2.80439575917706],
["1nwg",2.32,3.10947294960664],
["1asq",2.32,2.1507720274865],
["1xmf",2.32,2.55766858501458],
["1xmh",2.32,2.44212700404809],
["2c3u",2.32,2.91921947103108],
["1zkz",2.33,2.56964637235126],
["1k5a",2.33,3.31127176530601],
["1z0i",2.33,2.57788532753988],
["1aue",2.33,2.87020700163999],
["6chy",2.33,3.40573156955029],
["1ltq",2.33,3.05638282908504],
["2a03",2.33,1.20098493203636],
["1g95",2.33,2.29076565450699],
["1mfp",2.33,2.97104866647501],
["1oie",2.33,1.78591406172107],
["2bco",2.33,2.56297331417953],
["1o65",2.33,2.50949872385877],
["1ay4",2.33,2.70531710905604],
["1zlv",2.33,2.74637871426067],
["1wc7",2.33,4.02278069715016],
["1yq4",2.33,2.77942364472532],
["1j3i",2.33,2.54044051743924],
["1xi9",2.33,1.82423561493974],
["1hw9",2.33,2.31281971491657],
["1qlb",2.33,2.79231917858704],
["2c3p",2.33,2.47408663079552],
["1nxt",2.34,2.10580466524925],
["1s0l",2.34,3.01632298559842],
["112m",2.34,2.55371236923592],
["1gx9",2.34,3.76305887055315],
["1awu",2.34,2.96355345621857],
["6upj",2.34,2.56908227026231],
["1p06",2.34,2.42394541817694],
["1cla",2.34,2.21401036804244],
["1r2y",2.34,2.29853037146108],
["1gwk",2.34,2.00702911140795],
["1zbt",2.34,1.9808753791811],
["5pep",2.34,3.4162325552381],
["1atr",2.34,2.75103949289851],
["1n64",2.34,3.0759450734768],
["1zy9",2.34,1.91297908828273],
["1ki4",2.34,3.16359765851121],
["1khg",2.34,2.5344353548801],
["1xot",2.34,2.33355832764399],
["1ya3",2.34,3.19839801389544],
["1k5q",2.34,1.87010824494146],
["1mpw",2.34,2.96692376348815],
["2nse",2.34,2.88579384348909],
["1awv",2.34,3.31686421029467],
["1t9c",2.34,1.79715484704508],
["1gqt",2.34,2.49980377007254],
["1yey",2.34,3.10260137272633],
["1yl7",2.34,2.15202962481305],
["1syx",2.35,2.30046481813455],
["2cro",2.35,3.06640152547909],
["1i3f",2.35,1.85472146324175],
["1k0k",2.35,2.86639141109856],
["1b72",2.35,2.07261810041811],
["1mkp",2.35,2.22045767334887],
["2fiw",2.35,2.73302872298512],
["1gxa",2.35,4.00425418960597],
["1mwi",2.35,2.40357982191076],
["2bt7",2.35,2.32832722139160],
["1e7n",2.35,2.36616742582954],
["1kdm",2.35,2.84949359014407],
["2b5s",2.35,2.35527559056738],
["1znx",2.35,1.96049221007328],
["1hdf",2.35,2.64359875203268],
["1ftc",2.35,2.43095928882073],
["1p5t",2.35,3.33570765739839],
["2cla",2.35,2.39796802729484],
["1yyv",2.35,2.16692000415505],
["1ap9",2.35,3.79588445702089],
["1dl7",2.35,4.28701483372130],
["1p4b",2.35,3.19003794440805],
["2enr",2.35,2.15963458800155],
["1jn3",2.35,3.10070799941025],
["1txu",2.35,2.46059017805061],
["1ccs",2.35,2.73244110984784],
["1cnb",2.35,2.76029225185335],
["2exe",2.35,2.20737425030844],
["1vzj",2.35,3.01319073617370],
["2c3l",2.35,3.26378563358503],
["1qe6",2.35,2.51276261911994],
["2f5s",2.35,2.58729100122353],
["2f5q",2.35,2.32063593822742],
["1lhd",2.35,3.25322731295133],
["1o6j",2.35,2.69196994746241],
["1cyf",2.35,2.94341650506261],
["1oc9",2.35,2.41888324327846],
["1c84",2.35,2.901657414217],
["1bzc",2.35,2.60841702388136],
["1kav",2.35,2.66495384318003],
["1a6j",2.35,2.52570683555761],
["1pz0",2.35,2.68447986195646],
["1hu0",2.35,2.81643183197148],
["1or8",2.35,3.08725724211079],
["4tms",2.35,2.74084112523775],
["1ukh",2.35,3.21853284074375],
["1d8u",2.35,2.85961165784799],
["1tzs",2.35,2.22930081016077],
["1nnq",2.35,1.21073764249155],
["1xhc",2.35,1.44207265128162],
["1g3t",2.35,2.64386067114331],
["1o5r",2.35,3.71366259399293],
["2bu5",2.35,2.93995161335385],
["1g9u",2.35,3.38601129699521],
["1ds6",2.35,2.19416569345200],
["1guv",2.35,3.10659520820344],
["1qzo",2.35,3.17459231249573],
["2crk",2.35,3.29423069066469],
["1xks",2.35,2.61288498100331],
["1a21",2.35,2.46345474580667],
["1kjm",2.35,3.19165132363909],
["2bi8",2.35,2.4822590535801],
["1f2i",2.35,3.01301839074731],
["1b9v",2.35,3.4180494037693],
["2aua",2.35,2.32669853596682],
["1egy",2.35,2.78854091130707],
["1r5b",2.35,3.13307015682905],
["2an9",2.35,2.10908349172504],
["1zb7",2.35,2.36821918909445],
["1pqy",2.35,2.24020983959746],
["2b2y",2.35,3.11696446664612],
["2ptk",2.35,3.82521185040360],
["1ow6",2.35,2.87719427631176],
["1q9h",2.35,2.30370738824714],
["1z3s",2.35,3.10346418841979],
["1rke",2.35,3.14787549781160],
["1wro",2.35,2.80477373759104],
["1v7u",2.35,2.67341144922386],
["1ra7",2.35,2.28150090859410],
["1r6q",2.35,1.45401851194748],
["1f1j",2.35,2.43278644365409],
["1e2s",2.35,2.88989006665567],
["1e24",2.35,2.07630716764126],
["2avn",2.35,1.77285349377607],
["1uxv",2.35,2.88369879815343],
["1i7i",2.35,2.83563170020577],
["1xu2",2.35,2.17159197360569],
["1vcm",2.35,2.87726874107982],
["1gpn",2.35,2.20574032201017],
["1qyn",2.35,2.67962492469908],
["1st8",2.35,2.34486559593091],
["1vj5",2.35,2.62093481228338],
["1t10",2.35,3.0153786265927],
["1nvt",2.35,2.8835857380371],
["1vnf",2.35,1.95243077220194],
["2g0a",2.35,2.09898695759083],
["2g08",2.35,2.23926372414447],
["2bdu",2.35,2.06894126697525],
["1s5v",2.35,1.86290794164369],
["1i7l",2.35,2.73568025531909],
["2afo",2.35,2.17468949782160],
["1pvp",2.35,3.75255821946912],
["1u4c",2.35,3.71896043697451],
["1q9d",2.35,2.95586290799243],
["1xaj",2.35,3.22451215100661],
["1tw3",2.35,2.35594640402259],
["2asj",2.35,2.91337059788245],
["1m80",2.35,3.24054605813726],
["1x8j",2.35,2.14284231274267],
["1dot",2.35,3.79044171462280],
["2al6",2.35,2.66278408185153],
["1pz8",2.35,2.97828120273585],
["1r1j",2.35,3.15100357425986],
["1fcn",2.35,2.8658174947645],
["1uoo",2.35,2.01991900176405],
["1q8z",2.35,2.96187551640745],
["1qu0",2.35,2.59444032051932],
["1v2f",2.35,2.56876196029996],
["1ewh",2.35,2.64080698366666],
["1u08",2.35,2.652728818961],
["1ai4",2.35,2.46628228625274],
["1d8t",2.35,2.69308537287408],
["1jmj",2.35,2.66003373853923],
["1asm",2.35,3.29594888880836],
["2czg",2.35,2.41368690942994],
["1p6l",2.35,2.50318013285242],
["1ogv",2.35,2.64170867313529],
["1m8d",2.35,2.05969862297134],
["1rtw",2.35,2.26179411289561],
["6nse",2.35,2.68023384530557],
["7nse",2.35,2.62473974121453],
["1dmj",2.35,2.62230713152518],
["1ftq",2.35,3.20512149409514],
["1fu8",2.35,3.27436463055589],
["1unh",2.35,3.14222673756901],
["1df1",2.35,3.0130975390227],
["1dwv",2.35,2.83222825103631],
["1dww",2.35,2.89541804928450],
["1nj9",2.35,3.94568768081435],
["1jqn",2.35,2.58996841810985],
["1vh8",2.35,2.62360749409072],
["1vha",2.35,2.60726353249534],
["2az1",2.35,3.01543337539650],
["1ona",2.35,2.86987694591451],
["1mu2",2.35,3.0155834492351],
["1qvv",2.35,2.77707679329784],
["1qnw",2.35,2.53966158419706],
["2d3s",2.35,2.71909906233378],
["1rtj",2.35,3.69396174766608],
["2gdd",2.35,2.71966180046693],
["1yvy",2.35,2.76824934555548],
["1pn4",2.35,2.02423970184448],
["1r0z",2.35,2.70621465003223],
["1j06",2.35,2.50469999648455],
["1j07",2.35,2.38081798072233],
["2bxa",2.35,2.80548485012087],
["1xeb",2.35,3.15338389016398],
["2cbj",2.35,2.53486147537323],
["1vbo",2.35,3.13590501537926],
["5prc",2.35,2.72019456756710],
["2bpj",2.35,2.52355443919498],
["1vgw",2.35,2.73233153926406],
["1g9c",2.35,2.60217203445666],
["1qoh",2.35,1.94329696518443],
["1jkj",2.35,2.56096515203782],
["1rjw",2.35,2.43183699864583],
["1xr2",2.35,2.54957751250819],
["1y1q",2.35,2.89375988090178],
["1yq9",2.35,2.31736137949676],
["1fj4",2.35,3.05397123474451],
["1qgh",2.35,2.67945935540862],
["1bxs",2.35,2.29862262640001],
["1l0l",2.35,3.65577667328612],
["1upa",2.35,1.81461150731892],
["1xhx",2.35,2.51686315637605],
["1ffu",2.35,2.40162847707030],
["1nf6",2.35,2.15554275069797],
["1rxc",2.35,2.01393597716380],
["1ocr",2.35,2.76177577733434],
["1pkl",2.35,2.75739028812022],
["1a5u",2.35,3.42406410586679],
["1tzl",2.35,2.46027364248783],
["1vld",2.35,2.75308397922572],
["1nv9",2.36,3.39004645960475],
["1phw",2.36,3.67125568926068],
["1ulf",2.36,2.39645881793153],
["1jms",2.36,2.57043820144422],
["1dvr",2.36,2.89044475927576],
["1ag1",2.36,2.9398237018484],
["1ux1",2.36,2.13086271720234],
["1zab",2.36,2.12174960526699],
["1y2x",2.36,1.87705817692761],
["1ak4",2.36,2.22371140468404],
["1q18",2.36,2.93284527694645],
["1ph8",2.36,2.68036684861398],
["1ai5",2.36,2.45502623828652],
["1ajn",2.36,2.44151678129007],
["1ftw",2.36,3.255304598732],
["1ggn",2.36,3.24782565821919],
["1fu4",2.36,3.26008189012135],
["1fu7",2.36,3.29082059197899],
["1hu3",2.37,2.86964541548597],
["1fqw",2.37,2.15523418882594],
["1td3",2.37,2.78656869358826],
["1stf",2.37,2.57303346542406],
["2bqr",2.37,2.87402958524107],
["7jdw",2.37,2.43737023658857],
["1qbm",2.37,3.21217624522370],
["1u93",2.37,2.69551410910986],
["1zoq",2.37,3.00019233864954],
["1ki6",2.37,2.89215501072111],
["1ki3",2.37,3.59951513465028],
["1qjv",2.37,1.91261830247244],
["1b8g",2.37,3.02800928934972],
["1r0c",2.37,3.32938858612409],
["1xr4",2.37,2.14427488068034],
["1tu5",2.37,2.93584957235303],
["1p9u",2.37,2.58542906443347],
["1hcu",2.37,2.84271726603604],
["1bu6",2.37,3.98321526672607],
["1h3l",2.38,3.2913647507021],
["1eof",2.38,2.08484869640206],
["1ttw",2.38,3.90055955987377],
["1kxf",2.38,2.46479849674928],
["1f9s",2.38,3.61715501902409],
["1pml",2.38,3.36407625315633],
["1lj2",2.38,2.49127998416897],
["1u6h",2.38,3.57827442485831],
["2cj8",2.38,2.69272686567530],
["1j6x",2.38,2.37856085925908],
["2fa7",2.38,3.01535624906353],
["1vli",2.38,2.11088448386848],
["1suj",2.38,3.16506942428658],
["2c4q",2.38,2.31925363764196],
["1dko",2.38,2.72912212346493],
["1fo2",2.38,2.66314845868142],
["1uc9",2.38,2.22435283960543],
["1a9n",2.38,2.74198892727729],
["1p0m",2.38,2.66738689798677],
["1ev7",2.38,2.89616853549253],
["1ewy",2.38,3.93864176935016],
["1ehi",2.38,2.88297708513675],
["2c7u",2.38,2.65043397647492],
["1fs4",2.38,3.22000687138554],
["1fty",2.38,3.21967938652396],
["1z52",2.38,3.09717570473187],
["1e7b",2.38,3.44362182033645],
["1gz6",2.38,2.53138256648778],
["2gf2",2.38,1.92423598544357],
["1uu1",2.38,3.25607485336299],
["1fz4",2.38,2.75643636925655],
["1exs",2.39,3.27690360002846],
["2f5y",2.39,2.39411892267355],
["2fl3",2.39,2.90218296156597],
["9mht",2.39,2.17455561470049],
["1c3v",2.39,3.02828557130474],
["2fkc",2.39,2.81965752310504],
["1b3s",2.39,2.30211271149209],
["1y9k",2.39,2.20772731752863],
["2c6p",2.39,2.61332527279078],
["2gjv",2.39,1.56345988143174],
["2biw",2.39,2.39433267684863],
["2ahx",2.4,2.43880100682701],
["1hgz",2.4,2.84023222040988],
["1hgv",2.4,3.92821732704101],
["1hh0",2.4,3.56048581913788],
["1ijw",2.4,2.45614844566592],
["1kne",2.4,2.8241963674738],
["1uo0",2.4,3.30233074581562],
["1unx",2.4,3.83696691762476],
["1szt",2.4,3.51646774155463],
["2ctx",2.4,3.89444403548044],
["1dol",2.4,2.8196106114616],
["1a7g",2.4,2.98676227151674],
["1myk",2.4,2.94500244578306],
["1qj0",2.4,2.64515343669636],
["2sam",2.4,2.46539399992910],
["1ce0",2.4,3.43918929178761],
["1nwm",2.4,3.07004957688425],
["1deb",2.4,1.74752720273563],
["2bhk",2.4,2.88623628023213],
["1fb8",2.4,2.53604542903172],
["3pal",2.4,3.03590909159983],
["1nt3",2.4,3.64588735375739],
["9ant",2.4,2.56087296459740],
["1ueg",2.4,1.88782543537273],
["1uvy",2.4,2.62238243586421],
["1b8i",2.4,3.82326469456554],
["1lt0",2.4,2.44027780128418],
["1lsv",2.4,2.54083365434275],
["1xt3",2.4,2.79944892969550],
["1drm",2.4,2.51702502237104],
["1iiz",2.4,3.40553629653518],
["1cqa",2.4,2.74664794071646],
["1u68",2.4,2.10095368973797],
["1url",2.4,2.98766096342083],
["3fit",2.4,2.826386437788],
["1ang",2.4,2.9682689980912],
["1u5z",2.4,2.53941412329607],
["4p2p",2.4,3.07736366959385],
["1rlw",2.4,2.85595125365135],
["1ax8",2.4,2.69831253494062],
["1a18",2.4,2.44947598991005],
["2c7m",2.4,2.32631680124519],
["1c7p",2.4,2.33014796926451],
["1ioc",2.4,2.51177075811824],
["1he9",2.4,3.62639112716852],
["1qmt",2.4,3.46157203397229],
["1vyg",2.4,2.67269926665761],
["1zv4",2.4,1.55492958673844],
["3nll",2.4,2.70988334096098],
["1ku7",2.4,3.21721770980477],
["2tdx",2.4,3.72828645782316],
["1h3q",2.4,3.08794242853677],
["2f5c",2.4,2.47332680957121],
["1lsg",2.4,3.62929135305205],
["1jj4",2.4,2.62335490733439],
["1tbe",2.4,3.40186572322779],
["8i1b",2.4,3.26090351043087],
["1j9g",2.4,2.33119627027231],
["1hib",2.4,3.11504717835455],
["1uzq",2.4,2.98462238482199],
["2aak",2.4,3.00274146207138],
["1wzw",2.4,2.25265907088652],
["1v5h",2.4,3.69078906271434],
["6dfr",2.4,3.45847532927481],
["1lb4",2.4,2.89540298268148],
["1mup",2.4,3.87701969971315],
["1jk6",2.4,2.48107966507351],
["1jao",2.4,2.63617577455493],
["1rh3",2.4,3.67225234582348],
["1tlq",2.4,3.46450339197896],
["1gx8",2.4,3.93292874486716],
["1lb5",2.4,2.47504996797642],
["2b6y",2.4,1.63556811118414],
["2b6z",2.4,1.80571990657351],
["2b70",2.4,1.77794006063563],
["1job",2.4,2.62711171393291],
["1fue",2.4,3.00092599685007],
["1f2q",2.4,2.5067656963394],
["1kuy",2.4,2.68093506140276],
["621p",2.4,3.12325355707162],
["2g3y",2.4,2.37634332305597],
["1m8j",2.4,2.04617829890006],
["1m8f",2.4,2.08921920775848],
["1ec6",2.4,2.66656171283994],
["2bdt",2.4,2.61938475204423],
["1rce",2.4,2.30169850636317],
["1rcc",2.4,2.27679006012758],
["1fha",2.4,2.11466989123816],
["1ha4",2.4,2.35389827584927],
["1i5i",2.4,2.55198396814935],
["1qqs",2.4,3.62832232692245],
["1oia",2.4,2.53417938849297],
["2fx0",2.4,2.48248986751109],
["1e44",2.4,2.35879040202712],
["1a2b",2.4,2.74165930791181],
["1f7c",2.4,2.28757318402949],
["1m5k",2.4,2.62411948912523],
["1umi",2.4,2.93841755282414],
["1vdx",2.4,2.26648705589336],
["2fdo",2.4,2.11863004339112],
["2sas",2.4,3.04916074183114],
["1jh7",2.4,4.07301171683503],
["1dr7",2.4,3.21108915191373],
["1dr5",2.4,3.00698159946559],
["1dr4",2.4,2.94964601262608],
["1dr6",2.4,2.98945022763574],
["1m5v",2.4,2.55963365638575],
["1h8g",2.4,2.6490152937221],
["2f44",2.4,2.83234614137249],
["1jsx",2.4,2.84124193304452],
["1yt0",2.4,2.17244362203713],
["1bj0",2.4,1.79720679175034],
["1a6i",2.4,2.69243475841491],
["1u7u",2.4,3.26929107072717],
["1f4r",2.4,2.56386338499361],
["1ork",2.4,2.65721962395929],
["1tcw",2.4,2.93238080307129],
["1vij",2.4,3.67803932257772],
["1vik",2.4,3.35641445492784],
["2bxj",2.4,2.21900698017452],
["1r6n",2.4,2.33797092227892],
["1no1",2.4,1.21197327432017],
["7hvp",2.4,3.42824840275478],
["1rnl",2.4,2.29489555380705],
["1k9v",2.4,2.80650022563996],
["1m5j",2.4,3.18697364502523],
["1bt6",2.4,3.31193193986149],
["1gsq",2.4,3.27058378399467],
["1ln1",2.4,3.202218492306],
["3ull",2.4,3.4627594552392],
["1xk5",2.4,3.43481095903871],
["2ahy",2.4,2.50159665788113],
["1trp",2.4,3.23978745625525],
["2fz4",2.4,3.57973392007919],
["1fbz",2.4,3.53634392661295],
["1k79",2.4,2.6998818686106],
["1an8",2.4,2.72284313129851],
["1g3w",2.4,2.51532692152718],
["1z9m",2.4,2.57742167903862],
["1g3s",2.4,2.34242410980007],
["1f6o",2.4,3.01250230119452],
["1oys",2.4,2.41667653482869],
["1a1c",2.4,1.86312270719521],
["1s35",2.4,1.78541382975082],
["1bwr",2.4,3.14007902724785],
["1snk",2.4,2.65931421114371],
["1dve",2.4,2.42406037360569],
["1hul",2.4,2.9793206079335],
["1ayw",2.4,2.96003854613388],
["1jgj",2.4,3.20808304677454],
["1cjm",2.4,2.65447972994043],
["1mov",2.4,1.90548398484381],
["1gta",2.4,3.06078980486716],
["1spp",2.4,2.71593122396666],
["1m4c",2.4,2.37561472525042],
["1emf",2.4,2.58363540983108],
["1wvr",2.4,2.84773580104164],
["1j14",2.4,2.10030172164362],
["1sq6",2.4,2.78212273121355],
["1yje",2.4,2.83818430698114],
["1euf",2.4,2.47383923633378],
["1qok",2.4,2.26424201480827],
["1ucq",2.4,2.82074777670915],
["1z34",2.4,2.61649336933299],
["1gmz",2.4,2.75418855844585],
["1upw",2.4,2.78357178211801],
["1i8i",2.4,3.00368641281280],
["1ttj",2.4,2.66943037521396],
["1orf",2.4,2.76428436330331],
["1i4x",2.4,3.67467337472898],
["1tti",2.4,3.38452903399175],
["1n1a",2.4,2.98303429760237],
["5p2p",2.4,3.26642281457097],
["1qan",2.4,2.38471638916494],
["1tri",2.4,3.28331040338222],
["3cna",2.4,4.74869894693446],
["3lbd",2.4,2.68538173969525],
["1hqw",2.4,2.17442943878656],
["1jmc",2.4,3.3047849871202],
["2rnf",2.4,3.38045989043243],
["1cbf",2.4,2.83433761901670],
["2gmf",2.4,2.9776675371339],
["1tp2",2.4,2.97765069391361],
["1byg",2.4,2.93687221099911],
["1hrh",2.4,3.34988223330174],
["1okr",2.4,2.67487232684997],
["1i9h",2.4,2.52346889491198],
["1ogl",2.4,2.44644344446776],
["1th8",2.4,2.05024357033536],
["1aoa",2.4,2.85187864743851],
["2art",2.4,2.71594780461614],
["1qtf",2.4,3.04241579775551],
["1zat",2.4,2.72353020570169],
["1yr8",2.4,3.67382721089459],
["1myl",2.4,2.5086914401942],
["1vj9",2.4,2.43145517820822],
["1sc8",2.4,2.31832113469135],
["1lbl",2.4,2.7338922225519],
["1ab5",2.4,2.63216208193483],
["1ozj",2.4,3.43081221267555],
["1o9h",2.4,2.30924359370124],
["1y17",2.4,2.59631437237342],
["1y8x",2.4,2.97701373691671],
["1e3g",2.4,3.20156414866096],
["1rhp",2.4,3.58319205094148],
["1hvv",2.4,2.25662707424571],
["1jj7",2.4,2.00264848672607],
["1nq0",2.4,2.89439474074160],
["1bai",2.4,3.82039101937806],
["1zdm",2.4,2.26378615048089],
["1ag0",2.4,4.04493882359790],
["1ri4",2.4,2.83750469021128],
["1oz7",2.4,3.73752098562627],
["1gyw",2.4,2.20659638182013],
["1ifq",2.4,2.55059226493288],
["1nq2",2.4,3.19869486249338],
["12ca",2.4,2.85543377104227],
["7ca2",2.4,3.02707842362542],
["8ca2",2.4,2.88049523316055],
["1cvb",2.4,2.72344117311438],
["1nbb",2.4,2.67294473046396],
["1ipa",2.4,2.87475704634214],
["1bnq",2.4,2.64417655408626],
["1qgo",2.4,2.23471639318551],
["1bnv",2.4,2.48416069622253],
["1tza",2.4,2.22875264247563],
["1mq0",2.4,2.62865806236884],
["1ifu",2.4,2.43179964877329],
["1zam",2.4,1.66771426530565],
["1a2d",2.4,3.09346593105611],
["2b6p",2.4,3.62935008083904],
["1tpk",2.4,2.57637353899379],
["1vjr",2.4,1.23547710068457],
["1l9k",2.4,2.95777491134916],
["1l2b",2.4,2.28279627684457],
["1mat",2.4,3.78004610919983],
["1yxk",2.4,2.69156787518090],
["1l8t",2.4,2.94407120896829],
["1ajm",2.4,3.13584353449847],
["1yi4",2.4,3.00455355833109],
["1zbp",2.4,2.97668473061639],
["1mpt",2.4,3.21382343059346],
["2ghr",2.4,1.46110625250754],
["1ne4",2.4,3.38336330545391],
["2f5f",2.4,2.13483262126085],
["1x8f",2.4,3.58626216778939],
["1vr2",2.4,3.22050812317075],
["1ubn",2.4,2.04215721059856],
["2bxw",2.4,1.40274641144261],
["1s5x",2.4,2.10594603847812],
["1wvw",2.4,2.74514676189586],
["1r8e",2.4,2.57478763166104],
["1nrr",2.4,2.9739110348211],
["1gjo",2.4,2.76744476609022],
["1jkk",2.4,2.42277454709651],
["1lhf",2.4,3.34709485086364],
["2bmz",2.4,2.27143817154823],
["1oec",2.4,2.64190610605863],
["2a6m",2.4,3.60425605310971],
["1ptk",2.4,2.62042541943435],
["1xkk",2.4,2.09222597772855],
["1v4i",2.4,2.55834961656788],
["1exw",2.4,3.22499638991171],
["1hcq",2.4,3.43850618496158],
["1i44",2.4,2.41846331668133],
["1c4x",2.4,3.19471374335778],
["1yjl",2.4,3.15862411493015],
["1ql6",2.4,2.46804117189275],
["1q1z",2.4,1.80833793214469],
["1kts",2.4,3.01099183029081],
["1ehw",2.4,2.28639228521446],
["1s5k",2.4,2.65953521422242],
["1ytw",2.4,2.65804756754441],
["1ytn",2.4,2.83402252442209],
["1twx",2.4,3.45912531054742],
["1nl9",2.4,2.17703529988454],
["1nz7",2.4,2.61213859615549],
["1nny",2.4,2.42492967095022],
["1no6",2.4,2.86794903035813],
["1g7v",2.4,4.3151716624489],
["1abj",2.4,3.54724164958268],
["1nrs",2.4,3.54505909120639],
["1lpz",2.4,2.94446956189961],
["1s9j",2.4,1.90983857421585],
["1hai",2.4,3.46297239841329],
["1h0n",2.4,3.73053310494501],
["1a9p",2.4,2.91404091046847],
["1xrr",2.4,3.14932940011682],
["1bej",2.4,2.57658745993207],
["1cci",2.4,2.15662487707492],
["2au1",2.4,2.97743086992937],
["1tq7",2.4,3.34347899268026],
["1bco",2.4,2.37380833534894],
["1mu0",2.4,2.94495546333681],
["2bgd",2.4,1.84112959422615],
["2cg4",2.4,2.79900259359085],
["1bjp",2.4,2.21663467540898],
["1ah5",2.4,2.44124510037448],
["2ab4",2.4,3.19355325051299],
["1n26",2.4,3.11528877583415],
["2ftp",2.4,2.40092954481575],
["1rw8",2.4,3.40154847627817],
["1g1h",2.4,1.67255994616260],
["1ese",2.4,3.3949965678552],
["1b3v",2.4,1.84131191232317],
["1pvu",2.4,2.67107537264118],
["1id1",2.4,2.73331923434403],
["1uty",2.4,2.42031057713816],
["1squ",2.4,3.40832371777543],
["1rks",2.4,2.31432734146967],
["3gbp",2.4,2.18808683868371],
["1rz5",2.4,2.08753303490485],
["1spd",2.4,4.47963243243756],
["1ux9",2.4,2.42141781476072],
["1ury",2.4,2.51893290761072],
["1f8y",2.4,2.33470854330363],
["1rdr",2.4,2.29608352301269],
["1o59",2.4,2.43562187037739],
["1en7",2.4,2.52222511624542],
["1i7c",2.4,2.59342421228500],
["2byk",2.4,3.01539574976424],
["1yz4",2.4,2.98884754562142],
["1ga5",2.4,3.11759540972963],
["1eb7",2.4,2.52692766320956],
["1c9w",2.4,2.90023533468019],
["2g86",2.4,2.77272615498361],
["1bp0",2.4,2.56825291069935],
["1bo8",2.4,2.44517350727783],
["1bo7",2.4,2.59707056227875],
["1bp6",2.4,2.72022296889763],
["1bpj",2.4,2.73135454514243],
["2g8d",2.4,3.28844524013954],
["2g8a",2.4,3.3986200612034],
["1czv",2.4,3.07805999940507],
["456c",2.4,3.27033624716254],
["1kkh",2.4,3.42908373561998],
["1xu4",2.4,2.97653004119183],
["3pfk",2.4,2.45581623454751],
["4pfk",2.4,2.60177824805952],
["1b55",2.4,4.40954223869743],
["1ep9",2.4,2.50217107168678],
["1a55",2.4,2.44371123653881],
["1cgl",2.4,3.29276353618986],
["1nw9",2.4,2.76993840370395],
["1nhh",2.4,2.55134272930029],
["1dd4",2.4,3.38791145312144],
["1ssy",2.4,2.22912059279655],
["1as3",2.4,2.56694286946801],
["1rne",2.4,2.59369213091998],
["1s3l",2.4,3.05945263854341],
["1rmh",2.4,2.52395235765962],
["2jxr",2.4,3.42571695195257],
["1u9j",2.4,2.76536202864728],
["1j19",2.4,2.56488752223633],
["1fq5",2.4,3.30051093794857],
["1dtg",2.4,2.35062610168071],
["1bpx",2.4,4.20613187649982],
["1z75",2.4,2.78424889547251],
["1z6y",2.4,2.93553067663696],
["1mzf",2.4,2.33925834796926],
["1sib",2.4,3.8149557693597],
["1ko8",2.4,3.24022559521896],
["1oq9",2.4,2.5478569518279],
["1a8y",2.4,2.70627383998353],
["1fte",2.4,2.62847838239764],
["1djs",2.4,3.29845340355534],
["1k7t",2.4,3.44189938505126],
["1hxt",2.4,2.47630992848877],
["2omf",2.4,2.73367696290825],
["1d8f",2.4,2.40845725625089],
["1rrs",2.4,2.87536415342722],
["1bi3",2.4,2.66752744318639],
["2liv",2.4,3.39655608547136],
["1jqp",2.4,2.42350269537473],
["2lbp",2.4,3.71784020020514],
["1uby",2.4,3.9379857243854],
["1rrg",2.4,3.2513451955388],
["1m7q",2.4,2.65413779805433],
["2bu6",2.4,2.80617456150022],
["1jhl",2.4,3.34020409319177],
["1fkx",2.4,3.01764984198720],
["1uio",2.4,3.12258329275388],
["1fkw",2.4,2.97206016845642],
["1uip",2.4,2.99736135483739],
["2ada",2.4,3.27990966922952],
["1add",2.4,3.33473576591048],
["2a8v",2.4,2.96632285915285],
["2pax",2.4,2.21381386869327],
["1pax",2.4,2.27054139627702],
["3pax",2.4,2.25972347969758],
["1bmk",2.4,3.21509133510987],
["2erk",2.4,2.73436111047766],
["1wbn",2.4,2.52484694905560],
["1cvm",2.4,2.90215482974896],
["1sg1",2.4,3.37164422502396],
["1wbp",2.4,3.19351713659562],
["1re0",2.4,1.92734013125863],
["2bu2",2.4,2.91798100043022],
["1pnq",2.4,2.66230638493637],
["1ps8",2.4,2.78283322069776],
["2bu7",2.4,2.68529172004752],
["2ajh",2.4,2.62983224775667],
["1n1i",2.4,2.60869180319382],
["1p0e",2.4,2.64440837682054],
["1jdx",2.4,2.57391888348304],
["3jdw",2.4,2.5276166582379],
["1bjf",2.4,2.93803021783094],
["1e96",2.4,2.59461755449118],
["1woo",2.4,2.41153307328027],
["1pdk",2.4,3.14207102546035],
["3caa",2.4,2.92025212041779],
["1o9u",2.4,2.88527633706817],
["1xm7",2.4,3.30175259434368],
["1dxp",2.4,3.33095243854775],
["1r5h",2.4,2.39630625055936],
["1tv5",2.4,2.30324952135991],
["1tfh",2.4,2.91516540870830],
["1dy8",2.4,3.02125454212916],
["8adh",2.4,3.42614044520564],
["1hiz",2.4,1.95027140827012],
["1hoc",2.4,3.42736129711522],
["1az3",2.4,3.36637104234132],
["1jmm",2.4,2.36043134013392],
["1az4",2.4,3.46268324182329],
["1bii",2.4,3.30328291341845],
["1ui6",2.4,2.32118094902332],
["1d3u",2.4,2.71895863092394],
["1sys",2.4,2.37366882154791],
["1jk8",2.4,2.79890455452608],
["1lgh",2.4,2.85793327964856],
["1xtk",2.4,3.26877820501656],
["1fgs",2.4,2.64066620333012],
["2iad",2.4,3.63505494072988],
["1ffs",2.4,2.1456914034267],
["2be3",2.4,2.41878050464879],
["1s0u",2.4,3.14728973312569],
["1n1c",2.4,2.52359115490489],
["1ktc",2.4,2.14214267756349],
["1z1e",2.4,2.88349379339895],
["1inx",2.4,2.93966024560488],
["1inw",2.4,3.18260976046822],
["1ive",2.4,3.69283346216448],
["1ivf",2.4,3.60379829737985],
["1ivc",2.4,3.50369834681783],
["1iny",2.4,2.80869512321184],
["1vcj",2.4,3.01753751795142],
["1inv",2.4,2.62658257139918],
["1inf",2.4,3.09328974473372],
["1b9t",2.4,3.44011396423532],
["1ivb",2.4,3.51444337051462],
["1zyp",2.4,2.60701190442746],
["1col",2.4,2.80093543285478],
["1cj4",2.4,2.01143680651403],
["1ui5",2.4,2.12788186857831],
["1h3t",2.4,3.10449297466211],
["1wc0",2.4,2.66026145940184],
["1asc",2.4,3.28866913451172],
["1yoo",2.4,2.70904991576886],
["1asa",2.4,2.98286847895318],
["1cq7",2.4,2.90915393997162],
["1cq8",2.4,2.89310734148195],
["1c9c",2.4,2.93325142874817],
["1aaw",2.4,3.46623611048019],
["5eaa",2.4,3.3730757556758],
["1cze",2.4,2.38824210686068],
["1h4v",2.4,2.65838732734277],
["1yla",2.4,2.68156990983788],
["1f3p",2.4,3.35057490953229],
["1map",2.4,2.92050100249721],
["1ivr",2.4,3.31151924314211],
["1xvv",2.4,2.47665735639409],
["1xvu",2.4,2.70358867669908],
["2tmk",2.4,2.39268174059669],
["1vp7",2.4,1.91611900703008],
["1ern",2.4,3.33805027359067],
["1fno",2.4,3.16631264659261],
["1vyq",2.4,3.01656524027162],
["1dkn",2.4,2.99767713583577],
["1mj2",2.4,3.18688594955101],
["1kas",2.4,2.70025067013328],
["1k6q",2.4,3.26365549728268],
["1mrc",2.4,2.90617350759515],
["1h3u",2.4,3.23702881084304],
["7icd",2.4,2.77712076962911],
["2bbc",2.4,2.90642334374255],
["1qpg",2.4,2.77730024272705],
["1mrf",2.4,2.93160142580544],
["1yis",2.4,2.38396763895028],
["2brx",2.4,2.49755329983451],
["1z0x",2.4,2.95232731659782],
["1f77",2.4,2.63371500463421],
["1ngq",2.4,3.4181760857281],
["1ngp",2.4,3.45432100539792],
["1e0d",2.4,3.18985841375634],
["1h3m",2.4,2.97350592491233],
["1yq6",2.4,1.93072878701159],
["1nlj",2.4,3.29711819691796],
["1wdu",2.4,3.0212211058772],
["1keg",2.4,2.23914196874095],
["1mez",2.4,2.54482168323616],
["4bjl",2.4,4.29022567922098],
["2bg2",2.4,2.55226192700945],
["1ehl",2.4,3.43367826992196],
["1m0o",2.4,2.86856083851839],
["1pdy",2.4,2.70771518012381],
["2b2w",2.4,3.00483745346068],
["1h8s",2.4,2.86469755410687],
["1lo4",2.4,3.3356598716027],
["1els",2.4,3.52010612525144],
["1ee5",2.4,2.59225513148109],
["2bwy",2.4,1.37685082123355],
["2bhc",2.4,1.13950328325311],
["2bn7",2.4,1.10459160461067],
["2bh3",2.4,1.26763188032690],
["1u8m",2.4,2.69197848221367],
["2bha",2.4,1.27402297461368],
["2eyr",2.4,2.15679879365730],
["2etl",2.4,2.75032164614339],
["1to9",2.4,2.80895065806841],
["1z8u",2.4,3.13477290215094],
["1b0i",2.4,1.92028205277489],
["2h1p",2.4,3.56457549674819],
["2npx",2.4,2.52316944483485],
["9atc",2.4,3.40365637407517],
["1ywt",2.4,2.83364013567421],
["1be4",2.4,4.03239983461392],
["1sfj",2.4,3.17089214202526],
["1ndl",2.4,2.31124768770264],
["1fxx",2.4,2.12855150045044],
["1dfp",2.4,2.87595142042262],
["1w3s",2.4,2.7980139114975],
["1e1n",2.4,2.74792616963883],
["1bp1",2.4,2.818106354563],
["1wrb",2.4,3.52376380272766],
["1u9e",2.4,2.31817436532845],
["4gr1",2.4,2.61286010608452],
["5grt",2.4,2.83434145602949],
["7gep",2.4,2.51329520546432],
["2atp",2.4,3.20504134743523],
["1tfc",2.4,2.4571745619309],
["1i1r",2.4,2.99580981126259],
["1nmq",2.4,2.59607155448809],
["2bg3",2.4,2.28571879082082],
["1glm",2.4,1.91922291818453],
["1rdt",2.4,2.64774523184964],
["1xa7",2.4,3.3042034052604],
["3enr",2.4,3.06239490359070],
["1dgl",2.4,3.07683543736983],
["1rty",2.4,2.60516810129985],
["1chk",2.4,2.58847205392026],
["1pk5",2.4,3.41570088097266],
["1h7k",2.4,2.37749922545658],
["1jsi",2.4,2.39598981857736],
["1jsh",2.4,2.41531910765636],
["2ewm",2.4,2.36665134361014],
["1uoj",2.4,2.15890534680245],
["1e1z",2.4,2.82949118950156],
["1jso",2.4,2.65589313980468],
["1jsn",2.4,3.05037859351442],
["1lx6",2.4,2.63049793344383],
["1gwr",2.4,2.57748505254465],
["1mss",2.4,3.03648559955575],
["1jad",2.4,2.73066933414406],
["1bll",2.4,3.06980286606922],
["1e1t",2.4,2.06866800292549],
["1ac5",2.4,2.05525729939532],
["2b5e",2.4,2.77209641314534],
["1h9b",2.4,1.82423598076494],
["1e5s",2.4,3.54392559833020],
["1c0f",2.4,1.66656649351337],
["1dej",2.4,1.60111412423761],
["1i30",2.4,2.76897508292136],
["1m7o",2.4,2.57108321157864],
["1m7p",2.4,2.57344403876195],
["1ad4",2.4,2.38593958039300],
["1i4o",2.4,3.05527018591504],
["2ap2",2.4,3.30518562863648],
["1v15",2.4,2.86703870842247],
["1lxc",2.4,2.68783307754597],
["4tim",2.4,2.65503142439994],
["1vah",2.4,2.31636122090693],
["1lbe",2.4,3.42867269875465],
["1ish",2.4,2.33367710038302],
["1uxq",2.4,2.89397387059176],
["1ky8",2.4,2.71375471765128],
["1ae1",2.4,2.50581677928847],
["1dwj",2.4,2.0891403855873],
["2btm",2.4,2.47614572737847],
["1lbx",2.4,3.80863825197486],
["1g0i",2.4,4.21752230520182],
["1l6m",2.4,2.89497069476321],
["1b14",2.4,2.93725147013308],
["1azr",2.4,2.12831447989002],
["1fgb",2.4,3.8305629539394],
["2brl",2.4,2.03988897232942],
["1k2w",2.4,2.51075587442179],
["1me5",2.4,3.86978793174520],
["2bmx",2.4,2.90502862060849],
["1rql",2.4,2.88811003684062],
["1umr",2.4,3.2901584573859],
["1rkm",2.4,2.71062436348272],
["1f1z",2.4,2.90773806742045],
["1t6z",2.4,2.83877371033134],
["1j7u",2.4,2.24472016365165],
["2ack",2.4,2.78534857846594],
["1hnn",2.4,3.02332640707164],
["1ije",2.4,2.04753757522185],
["1ut6",2.4,2.62797382270816],
["1cnt",2.4,2.69462341993138],
["1p74",2.4,2.99762318041971],
["1yz3",2.4,2.46316392163823],
["1r3i",2.4,2.47364377495535],
["1hot",2.4,2.66637424992932],
["1hor",2.4,2.64780657029620],
["2ezv",2.4,3.13433337772143],
["1vxo",2.4,2.45034542887123],
["1c4p",2.4,3.30063113064673],
["1agw",2.4,1.83405045679991],
["1jog",2.4,3.56284066175975],
["1f89",2.4,3.22688063704239],
["1yco",2.4,2.95895865591474],
["3gwx",2.4,3.63509004817367],
["1epu",2.4,3.29326593587308],
["1fr8",2.4,3.3614692357961],
["1fpu",2.4,3.10502576692974],
["1fgx",2.4,2.89189337795035],
["1qrd",2.4,2.67468783821427],
["2ram",2.4,3.46198004245334],
["1xhl",2.4,2.66877125868298],
["1jhz",2.4,3.73767209160744],
["1hia",2.4,2.96375844874382],
["1qsc",2.4,2.60167649920756],
["2azj",2.4,3.16575660521491],
["1qme",2.4,2.71315193605824],
["4daa",2.4,2.29720359950493],
["1iah",2.4,3.05394802786629],
["1n7u",2.4,2.53682482117216],
["1cy7",2.4,2.79296834626321],
["1efh",2.4,2.37936707808753],
["1pvs",2.4,2.47089699549238],
["1ep2",2.4,2.72434815628870],
["1ypp",2.4,3.13495790397083],
["1yax",2.4,2.57390693671888],
["1vp5",2.4,1.93750301943868],
["1zz9",2.4,3.09404978583641],
["1yie",2.4,2.75211569584564],
["1wun",2.4,2.29332592710468],
["1vrw",2.4,2.74839112079188],
["1c4c",2.4,2.60590034701464],
["1c4a",2.4,2.76234998232048],
["2d4r",2.4,2.99839163729666],
["1yb4",2.4,2.99617383325651],
["2aum",2.4,1.47392316357225],
["2aun",2.4,1.68383250746093],
["2bxk",2.4,2.72177290877549],
["1e7c",2.4,3.2987848889514],
["1hk4",2.4,2.76297119737005],
["1gni",2.4,3.17433303245605],
["1f12",2.4,2.39870854427236],
["1ega",2.4,3.59851368828099],
["1ugy",2.4,2.16523057972335],
["1c0a",2.4,2.88251853889837],
["1p9e",2.4,2.85982499143224],
["1joe",2.4,4.05320828362202],
["1jrk",2.4,2.91771969125361],
["1n8y",2.4,2.99482438702366],
["1viq",2.4,2.86336540503392],
["1ji6",2.4,2.79208000837218],
["1qsm",2.4,2.64825241990739],
["1vs0",2.4,2.47592458075],
["1eai",2.4,2.89279768697477],
["1khe",2.4,2.54290637477974],
["1nol",2.4,2.63569350799541],
["1e2l",2.4,2.73571268521218],
["1rq5",2.4,3.03369091946344],
["1klg",2.4,2.91298554235297],
["1uk3",2.4,3.24020815247125],
["1uug",2.4,1.81844132078213],
["1j8v",2.4,2.5914328586913],
["1hxd",2.4,4.22241246643257],
["1iaw",2.4,2.89775573132024],
["2bh1",2.4,2.10239161076990],
["1dar",2.4,3.53984330347663],
["1zu5",2.4,2.72405011713069],
["1eep",2.4,2.94536480229410],
["2eul",2.4,3.53187009226786],
["2trc",2.4,3.02697295617253],
["1non",2.4,2.84318128778930],
["1g1q",2.4,2.71450602618288],
["1gju",2.4,2.46049953711383],
["1y0z",2.4,2.11752970012097],
["1gdh",2.4,3.03790399261983],
["1pfk",2.4,2.17622243544376],
["1kfk",2.4,2.27512645097272],
["1cm8",2.4,2.87573284290013],
["1xx5",2.4,2.44135566748003],
["1xmy",2.4,2.58019202816407],
["1crx",2.4,3.29475534161533],
["1lox",2.4,2.83199113822992],
["2cvy",2.4,2.97551710658025],
["2ary",2.4,2.22932044084518],
["1xkb",2.4,3.45222472549487],
["1y2h",2.4,2.29306372688328],
["2fxa",2.4,2.46650793702589],
["2cvw",2.4,3.02419176990618],
["1ybu",2.4,3.58508764524667],
["1hfj",2.4,2.14856949196819],
["2ahc",2.4,3.80904600099346],
["1kgz",2.4,2.88566059878731],
["1brl",2.4,3.94307737806923],
["2bhm",2.4,2.28355547225708],
["1xe5",2.4,2.79445585187614],
["1y3t",2.4,3.42565042168026],
["1jpl",2.4,2.88265980008456],
["1m43",2.4,3.37570613728156],
["1bil",2.4,3.29788155617852],
["1eoi",2.4,3.86114096103444],
["2bm0",2.4,2.85926024849138],
["1w5a",2.4,2.93243332668337],
["2bnx",2.4,2.4366995093446],
["1pyx",2.4,2.49742917332241],
["2a0z",2.4,1.69733625514458],
["1jal",2.4,3.75269105337649],
["1fep",2.4,3.02925560100600],
["1avq",2.4,3.13331723939084],
["2ae3",2.4,1.93329840109851],
["2cb3",2.4,2.34747754574245],
["1n56",2.4,2.91653247816891],
["8cgt",2.4,2.24104395491249],
["3cgt",2.4,2.51192615124795],
["1dtu",2.4,2.66885371006992],
["1mjt",2.4,2.51440667446450],
["1a2o",2.4,3.63868652566367],
["2bjj",2.4,2.54818613873123],
["4pro",2.4,2.72670499083116],
["1pr4",2.4,2.58751520485161],
["1sji",2.4,3.42438431943648],
["1cul",2.4,1.94284875705371],
["1viu",2.4,2.7552272473619],
["1ub2",2.4,3.08694809007181],
["1dbt",2.4,1.84458682383073],
["1ysj",2.4,1.86268880626273],
["1kiy",2.4,2.06819622729377],
["1lbq",2.4,3.25386177167291],
["2coj",2.4,2.76122139301190],
["1vrx",2.4,2.92174400168254],
["1ece",2.4,2.26025768002679],
["1qbq",2.4,3.00154263672268],
["1idj",2.4,2.63376476275821],
["1s5j",2.4,2.76159807363621],
["1ltg",2.4,2.79436926265067],
["1ukr",2.4,1.81533546769269],
["1s9h",2.4,3.35181062356314],
["1ezu",2.4,2.69123413380638],
["1keu",2.4,2.00870798965294],
["2a01",2.4,3.80810227653556],
["1d5a",2.4,3.13807331740777],
["1rd4",2.4,2.57894559383386],
["1i8t",2.4,2.47737573864439],
["1gg2",2.4,3.31084942201889],
["1kyv",2.4,2.14899040380250],
["1kyy",2.4,2.06157810004696],
["1ehk",2.4,2.77626300298070],
["1nx4",2.4,1.85734568613911],
["1f38",2.4,2.15252013949248],
["1kho",2.4,2.02603050279024],
["1tq8",2.4,2.33960331224211],
["1xtc",2.4,4.34906780146634],
["1qs0",2.4,2.84870708322494],
["2mta",2.4,2.87103236385238],
["1u1j",2.4,3.43015797661441],
["1k6y",2.4,2.37307114835248],
["1a5n",2.4,2.32041967787848],
["1htb",2.4,2.64079026390339],
["1adb",2.4,3.3450008152998],
["1ejv",2.4,2.24805048252696],
["1p3l",2.4,2.46391092124746],
["1u6m",2.4,3.03593440222683],
["1ya6",2.4,2.9363780638952],
["1j0n",2.4,3.14356273436356],
["1t5w",2.4,2.3168101415225],
["1ukw",2.4,2.71467135909776],
["2gl8",2.4,2.90504802325187],
["1qr1",2.4,2.44580304929622],
["1q94",2.4,3.29343641866591],
["1x9e",2.4,2.70334471972906],
["1d0g",2.4,2.7178795744487],
["1ny5",2.4,3.00254097887495],
["3mdd",2.4,2.90071758105225],
["3mde",2.4,2.83773560392791],
["1skr",2.4,2.41642069799209],
["1t94",2.4,3.11088300205122],
["1xa8",2.4,2.71313115277369],
["1inh",2.4,3.58965895890878],
["1ing",2.4,3.74526081924303],
["2ay2",2.4,2.64531627441496],
["2ay5",2.4,2.68267993117367],
["2ay7",2.4,2.6255827991089],
["2ay3",2.4,2.71688082124040],
["1w5s",2.4,3.06019298071044],
["1zl6",2.4,2.82531055140894],
["1y6f",2.4,3.10700733452763],
["1xlm",2.4,2.17839513721604],
["1oke",2.4,3.23867943222515],
["1c3x",2.4,3.10369524438134],
["1ma9",2.4,2.61915237130964],
["1ktd",2.4,2.74148247521983],
["1x28",2.4,2.9306213830126],
["1aic",2.4,3.15237409073892],
["1oe0",2.4,2.63684354604404],
["1t1s",2.4,2.86631165967018],
["3nos",2.4,2.50131846918423],
["2fyw",2.4,2.32725622557334],
["1soz",2.4,3.60202036476992],
["1u74",2.4,2.88314006250764],
["1j8h",2.4,2.61805048348935],
["1yk0",2.4,3.0534420002596],
["1taq",2.4,3.56155125922038],
["1xja",2.4,2.91993101859671],
["1z6p",2.4,2.60711708775900],
["2d13",2.4,2.60023528910952],
["1trr",2.4,3.24565590375667],
["1mjq",2.4,3.46539355939498],
["1m9t",2.4,2.37074517177638],
["2boz",2.4,2.23849765208329],
["1e8z",2.4,3.3580602740382],
["1gpy",2.4,3.39314964357402],
["2skd",2.4,3.18892795504654],
["2skc",2.4,3.18334632235325],
["1noj",2.4,3.01201561207287],
["1nok",2.4,3.0738957850083],
["1vqy",2.4,1.72289770411211],
["1fa9",2.4,3.07032132233991],
["1hl8",2.4,2.30930870929368],
["1pvc",2.4,1.85253308227613],
["1qw4",2.4,2.98044261546617],
["1n2n",2.4,2.90863860729617],
["1e7v",2.4,3.22809413075349],
["1wu7",2.4,2.89141725219662],
["1vde",2.4,3.58543407823775],
["1bnc",2.4,3.31727688249003],
["1sfc",2.4,3.22564671777132],
["1b35",2.4,3.0066768686574],
["1o25",2.4,2.54424272881682],
["1yf2",2.4,3.35612091568840],
["1c5d",2.4,3.88813803323213],
["1np2",2.4,2.92134236722599],
["2gsa",2.4,2.93683062048835],
["1icv",2.4,2.53258802278434],
["1cez",2.4,3.28423351663601],
["1qln",2.4,3.46769710473783],
["2bif",2.4,2.38707045422978],
["1dbr",2.4,4.07409491492879],
["1a4k",2.4,3.65787440493907],
["1tuf",2.4,2.61067798314357],
["1qzq",2.4,2.45718312830941],
["1qfx",2.4,1.72971214973640],
["1kn9",2.4,2.88217375357462],
["1vqw",2.4,2.83306768751315],
["1b9c",2.4,2.99582437809609],
["1nm5",2.4,2.67297583607253],
["1u8w",2.4,2.76324605183626],
["1kh7",2.4,2.38021602045811],
["1kh4",2.4,2.79763477203074],
["1pjs",2.4,3.30060181270037],
["1fcb",2.4,3.83490665940001],
["2anh",2.4,2.24953353444198],
["1pq6",2.4,2.37275680234026],
["1u3q",2.4,2.93335745922426],
["1w49",2.4,2.67319810466834],
["1e5l",2.4,2.65497685842052],
["1bhn",2.4,4.21243885692015],
["1nye",2.4,3.69601827689496],
["1w4a",2.4,2.68420813960801],
["1i21",2.4,3.04130406527486],
["1jyl",2.4,3.60587457171105],
["1i1m",2.4,2.45551046156856],
["1i1l",2.4,2.65212185908675],
["1l9b",2.4,2.62105911097393],
["1wm6",2.4,1.51833659177704],
["2bkh",2.4,2.19967797758433],
["1v6k",2.4,2.18661324430767],
["1jkf",2.4,4.0289865830435],
["2a8x",2.4,2.71841097160875],
["1pxy",2.4,2.71728971888197],
["1vru",2.4,3.29076049627773],
["1mow",2.4,2.76657678251518],
["1n77",2.4,2.74831312889379],
["1g59",2.4,3.89702212342209],
["1t5g",2.4,3.10563841809009],
["1s1t",2.4,2.9892250546899],
["1sbb",2.4,3.08554380437697],
["2c3t",2.4,2.12145784471978],
["1nou",2.4,1.51310866116373],
["1jvd",2.4,2.97220422507857],
["1jeh",2.4,2.81439372141991],
["2fvz",2.4,3.88406387040827],
["1ot5",2.4,2.91333230911338],
["2tpr",2.4,2.73178326022947],
["1ewz",2.4,2.70737342598588],
["2fvl",2.4,1.40190450131377],
["1bzl",2.4,2.3221255394706],
["1nfq",2.4,2.02867359934714],
["2ahm",2.4,2.96897374275037],
["1x87",2.4,2.41196657942914],
["1r1z",2.4,2.42788017440920],
["1yid",2.4,3.64901294289851],
["1x2g",2.4,2.74189572916571],
["1f99",2.4,2.50985105343314],
["1y7v",2.4,2.94670214812847],
["1su4",2.4,3.05450792094479],
["1qas",2.4,2.8440851845897],
["1p1i",2.4,3.56248448278119],
["1px8",2.4,3.19387798142094],
["2aj4",2.4,2.99429591491524],
["2bf7",2.4,2.07354031934658],
["1qzh",2.4,3.35337185243956],
["1kz7",2.4,2.39995878537362],
["1bj1",2.4,2.77231831905689],
["1cz8",2.4,3.29644094726467],
["1h9y",2.4,2.5184308826367],
["1d9e",2.4,2.95466355704564],
["1n22",2.4,2.32264331496070],
["1n23",2.4,2.22404160487473],
["1ox6",2.4,2.29559558744366],
["1w75",2.4,2.63559777052543],
["1dqx",2.4,3.28727057219068],
["1pyd",2.4,3.17506884922529],
["1kyw",2.4,3.19425389148974],
["1zoy",2.4,3.32150541086563],
["1ii0",2.4,3.01231870929874],
["2br8",2.4,2.42352105571067],
["1qlu",2.4,2.61494592650678],
["1wmr",2.4,2.92756742980287],
["2ark",2.4,2.68131119590527],
["2cfx",2.4,2.88297128485467],
["1qpb",2.4,3.28364741239977],
["2bpm",2.4,2.09467662812262],
["1cvu",2.4,3.08226510696998],
["1gw0",2.4,2.29202595168808],
["3pmg",2.4,2.70082132530968],
["2f2f",2.4,2.70709853154468],
["2c47",2.4,2.06796196928709],
["1yff",2.4,2.03063497219877],
["1kfi",2.4,3.00186528213064],
["1kfq",2.4,2.93906179864921],
["1g51",2.4,3.12816697193026],
["1w5t",2.4,3.10330368390569],
["1j0i",2.4,2.52805607086145],
["1j4t",2.4,3.638476676924],
["3prc",2.4,2.44432671551089],
["4prc",2.4,2.73132073710249],
["1j36",2.4,3.23842484169997],
["1j37",2.4,3.30669524738322],
["2ggl",2.4,2.67485494419030],
["2pfk",2.4,2.55720863972047],
["1xjm",2.4,2.65521470133457],
["1xjf",2.4,2.72093871899009],
["1a0s",2.4,2.95365761140079],
["1a0t",2.4,2.95886721485385],
["1yc2",2.4,2.44050263008134],
["2mpr",2.4,2.45523148080055],
["1af6",2.4,2.42847040800834],
["1xbt",2.4,2.32912639057521],
["1k1x",2.4,2.73460754923327],
["1k1y",2.4,2.81138382545182],
["1ye4",2.4,1.91795210588696],
["4aah",2.4,3.0503872143686],
["2bp1",2.4,1.85218718325951],
["1nb5",2.4,3.84282943700537],
["1d9q",2.4,2.00245380669422],
["3eca",2.4,2.81290319639282],
["2bwg",2.4,2.12107428141830],
["2anu",2.4,1.88058310922186],
["1j0x",2.4,2.65068217573582],
["1iu4",2.4,3.34707683003874],
["1jdi",2.4,2.89957593489101],
["2f8j",2.4,1.61694909978773],
["1gk1",2.4,2.30311850781361],
["1gpw",2.4,3.42156411105435],
["1nug",2.4,2.73244123483120],
["1ngs",2.4,2.59554806416371],
["1s97",2.4,2.95432620667454],
["1hi9",2.4,2.50279417087713],
["1umc",2.4,2.17417486480858],
["1nd6",2.4,2.96268845595579],
["1odi",2.4,2.12595086940443],
["1odj",2.4,2.93204730577053],
["1i7s",2.4,3.69497433064322],
["7mdh",2.4,2.66066454605552],
["1cjx",2.4,2.37793421005015],
["1u10",2.4,2.38966275986788],
["1hg4",2.4,2.80902000387647],
["1lq8",2.4,3.43794537360459],
["1nbw",2.4,2.85381817820560],
["1lvn",2.4,2.71388143458341],
["1d6u",2.4,2.50501963468788],
["1d6y",2.4,2.43402864227401],
["1so2",2.4,2.9573364043574],
["2ggg",2.4,2.89562830830884],
["2tmd",2.4,2.60383513182677],
["1dvm",2.4,3.40778486661109],
["1d1t",2.4,2.55391295316373],
["2dub",2.4,2.86666898232994],
["1s7w",2.4,2.78775863921624],
["1e5v",2.4,2.11508096535936],
["1udy",2.4,3.09770533755885],
["1oh6",2.4,2.26723437524007],
["1wbd",2.4,2.26747610121192],
["2ch1",2.4,2.45502611478125],
["1egd",2.4,2.95999367539356],
["7xim",2.4,2.10976933808737],
["1l0q",2.4,2.42751796971682],
["9xim",2.4,2.16700655499935],
["8xim",2.4,2.18841131401427],
["1xin",2.4,2.03187569144774],
["1exv",2.4,2.66645732972133],
["1htz",2.4,2.81305583595022],
["1r9e",2.4,2.34636362815095],
["1qiu",2.4,2.83733950787675],
["1fc0",2.4,3.02543067101184],
["1i3r",2.4,2.42174738223758],
["2bui",2.4,2.24980836780592],
["1f91",2.4,2.04398341370630],
["1mwa",2.4,3.64467554030274],
["2av9",2.4,2.42971403767142],
["1rzz",2.4,2.52193556726305],
["1t77",2.4,2.90048196683184],
["1dfo",2.4,2.21667842906785],
["1qpo",2.4,2.83465359361773],
["1sf2",2.4,2.23948090575379],
["1h2u",2.4,2.18969998843652],
["1o9l",2.4,2.81434696089689],
["3cev",2.4,2.10997354075420],
["1bga",2.4,2.68143737216609],
["1cev",2.4,2.2461309368215],
["1kbw",2.4,2.70330300207814],
["1wyt",2.4,2.78414851149289],
["1tp7",2.4,2.8716634699277],
["1w8y",2.4,2.76870679910099],
["1vln",2.4,2.62156914076932],
["1f4j",2.4,2.77224687320627],
["1uls",2.4,2.8813827250876],
["1a4e",2.4,2.0873356209434],
["1tlb",2.4,3.06163420128463],
["1o9j",2.4,2.25868632051774],
["2agv",2.4,3.07748380691632],
["1kya",2.4,3.15422896728564],
["1q19",2.4,2.83295546619595],
["1r15",2.4,2.92622873901996],
["1afr",2.4,2.56271749708688],
["1q2v",2.4,2.8197546693365],
["1ntm",2.4,3.40534251281074],
["2fty",2.4,2.17163472678906],
["2fvk",2.4,2.07196136503878],
["2dd0",2.4,2.79721106295963],
["1xve",2.4,2.69691444412721],
["1fz5",2.4,2.70393732251519],
["1dt5",2.4,2.71528913485701],
["2a74",2.4,3.16014257604810],
["1iri",2.4,2.45295854956733],
["1bwv",2.4,2.23375941939762],
["1b4n",2.4,2.90231157540516],
["1e9r",2.4,2.77736569572307],
["3pcn",2.4,2.58562856102804],
["1foh",2.4,2.69343627689111],
["1w2m",2.4,1.39571990882028],
["1m35",2.4,1.78836999382419],
["1g8y",2.4,2.80801800046838],
["1p7y",2.4,2.527123509278],
["1vf7",2.4,2.80435234583189],
["1mx1",2.4,2.53717314195501],
["1up7",2.4,2.41360088480056],
["1e79",2.4,2.80024976501495],
["1u6j",2.4,2.93439300741220],
["1qni",2.4,2.8982815173837],
["1wyv",2.4,2.73064607162244],
["1s72",2.4,2.82041113054406],
["1vqn",2.4,2.87903512143703],
["1vq9",2.4,2.99937621819381],
["1yhq",2.4,2.71898744886575],
["1yce",2.4,2.42038950284606],
["1l1y",2.4,2.28187624622339],
["1a2v",2.4,2.89252280671592],
["1n4q",2.4,2.46755328808111],
["1yde",2.4,2.12823453642268],
["2bfg",2.4,2.98672291109963],
["1vpx",2.4,2.39089647579758],
["1yau",2.4,2.63293561159109],
["1we5",2.4,2.97299470311121],
["1rvv",2.4,2.71982490588857],
["1uzd",2.4,2.38653746322432],
["1rcx",2.4,2.50443932957493],
["1g0u",2.4,3.03396129886671],
["2a6h",2.4,4.11346731051915],
["2be5",2.4,4.13884647890237],
["1hto",2.4,2.82288651423989],
["1wtd",2.4,2.6993700946224],
["1x9g",2.41,3.22934984590424],
["1fd9",2.41,3.04370576808955],
["1x79",2.41,3.25898574496558],
["1o72",2.41,3.05820633496535],
["1wbw",2.41,2.68427738606663],
["2azm",2.41,2.22439377817517],
["2fts",2.41,2.68250430808500],
["2bhb",2.41,1.32498425017281],
["1r3l",2.41,2.32078104008042],
["1u4f",2.41,2.56602030602028],
["2bmf",2.41,3.21500786583156],
["2b3z",2.41,3.36043400846690],
["1sj2",2.41,2.79191249791563],
["1s7x",2.41,2.63355299926416],
["1t0l",2.41,2.46056628382147],
["1ykp",2.41,2.81031651745086],
["2b4a",2.42,2.38854929248149],
["1q9s",2.42,2.36579592589186],
["1syq",2.42,3.04088811175528],
["1m4u",2.42,3.5633979868545],
["1pt9",2.42,2.33233411436489],
["1q88",2.42,3.14586627651363],
["1sjs",2.42,2.16617401535787],
["1rqi",2.42,2.18306982043291],
["1pyy",2.42,2.49942150730775],
["1wy5",2.42,3.02114671309393],
["1s07",2.42,2.31990957395334],
["1ulv",2.42,2.9670073957039],
["1u3h",2.42,3.15569467371253],
["1k47",2.42,2.72049317054185],
["2cx6",2.43,2.93044369404400],
["4fua",2.43,2.67233097913930],
["1s56",2.43,3.14726713128135],
["1yqr",2.43,2.49494405099015],
["1ats",2.43,2.64638565138363],
["1e22",2.43,2.21353182127524],
["1p0q",2.43,2.58039422454046],
["1nhg",2.43,2.70447045854694],
["1jac",2.43,3.11417310795505],
["1e7h",2.43,3.33555011667203],
["1e7f",2.43,3.5766684308958],
["1kck",2.43,2.13414100255710],
["1k5s",2.43,2.09764886972569],
["1m9j",2.43,2.26209688126885],
["2be2",2.43,3.33094655434097],
["1gz5",2.43,2.85341153767742],
["1hc7",2.43,2.41185688742410],
["1dzy",2.44,3.04443040155245],
["1i3g",2.44,2.60413029142631],
["1y38",2.44,2.93122170555595],
["1o0d",2.44,3.14369220931589],
["1bjr",2.44,3.66110508157579],
["1klj",2.44,3.25942392266454],
["1qut",2.44,1.88569483837531],
["1d8m",2.44,2.26408537123617],
["1uuo",2.44,2.55208089954820],
["1h3x",2.44,3.40125366634303],
["1s2n",2.44,2.39999483931597],
["1tj7",2.44,2.53068076054832],
["2ce7",2.44,3.02973000244786],
["1ya5",2.45,3.50146628453604],
["1tc3",2.45,3.0104222454744],
["1vc7",2.45,2.57717735656942],
["1eod",2.45,2.38221621594976],
["1pp7",2.45,3.19713745272127],
["1dpy",2.45,3.02882184479481],
["1fe5",2.45,3.05576392937583],
["1nat",2.45,2.70720115689926],
["1uvx",2.45,2.88769339496409],
["1ctr",2.45,4.17969129294339],
["1c3n",2.45,2.71245714405689],
["1ib5",2.45,2.33761460766003],
["1a17",2.45,2.28221663995066],
["1p2s",2.45,2.68928522400152],
["1nx3",2.45,2.20334354832834],
["1bun",2.45,3.17204631040495],
["2buk",2.45,2.45178690950276],
["1lsp",2.45,3.09520430721435],
["2bnw",2.45,2.32333438287697],
["1m0b",2.45,2.33718902032176],
["1mrn",2.45,2.92925184319271],
["1uym",2.45,2.29872329379767],
["1q6u",2.45,2.58844896815691],
["2fd3",2.45,1.46159512997029],
["1vf4",2.45,2.32322034289321],
["1h89",2.45,3.05083850937689],
["1cl5",2.45,3.14150089829445],
["1zdf",2.45,2.12079938599130],
["1sla",2.45,2.77076230714442],
["2bzk",2.45,1.62459432926288],
["1cx4",2.45,1.92085126203380],
["1x1v",2.45,2.97871033630265],
["1v4k",2.45,3.08188520296877],
["1bqe",2.45,2.67699181886735],
["1b3y",2.45,1.82185690998266],
["2fh5",2.45,2.55457731995208],
["1n07",2.45,2.77679296776987],
["1ei7",2.45,3.26253916909833],
["1flh",2.45,2.67755895655099],
["1g05",2.45,2.44687659030375],
["1y62",2.45,1.88228903969731],
["1u8s",2.45,2.54124596029855],
["1oba",2.45,2.52477315666525],
["1xh4",2.45,2.09270298160128],
["1xag",2.45,3.04219654035598],
["2a09",2.45,3.18947844025976],
["1zb5",2.45,3.14642848272836],
["1rv6",2.45,2.80386490291923],
["2a8r",2.45,2.38439969591970],
["2a8s",2.45,2.12000959232792],
["2bs0",2.45,2.59085498012034],
["1b4x",2.45,3.35880198579331],
["20gs",2.45,3.08637144993205],
["2b2t",2.45,3.56791402881322],
["1mam",2.45,3.48388479648144],
["1jlw",2.45,3.31357168820686],
["1wsc",2.45,3.08179999243729],
["1f8w",2.45,2.04057616454524],
["2bzp",2.45,2.99724049498349],
["1lvl",2.45,3.3456154766901],
["1wvu",2.45,1.63083041851602],
["2qr2",2.45,2.33837175314986],
["1f34",2.45,2.59214694793406],
["1ep6",2.45,2.79618424588281],
["2bnf",2.45,2.80639966032501],
["1m7e",2.45,2.88119203501385],
["1dmy",2.45,2.7871171625059],
["1dmx",2.45,2.97183648200145],
["1m8n",2.45,2.80391318203794],
["1u3d",2.45,2.89182257517709],
["1i51",2.45,2.81369608138204],
["1gwq",2.45,2.42221627703233],
["1uvw",2.45,1.95385914083664],
["1a4c",2.45,2.50529699173327],
["1rkr",2.45,2.5888520683067],
["2ffj",2.45,1.68390369160644],
["1cy0",2.45,2.46307693108161],
["1vpv",2.45,1.69128322192251],
["1cy8",2.45,2.81477238497817],
["1hk8",2.45,2.33061307211737],
["1d6e",2.45,2.44407894530305],
["1d5x",2.45,3.28750608605158],
["1ej7",2.45,2.54320806051904],
["1sje",2.45,2.57320942028782],
["1f05",2.45,2.13524048167182],
["1pvw",2.45,2.61231554415903],
["1pa6",2.45,2.50802515898168],
["1m18",2.45,2.44246209037594],
["2bo6",2.45,2.69631896211221],
["2vub",2.45,2.60875259629698],
["1v4n",2.45,2.85984205812816],
["2fkw",2.45,3.08629836362439],
["1o2b",2.45,2.33871990924526],
["1fl3",2.45,3.36048710292249],
["1suw",2.45,2.95850986806760],
["1q84",2.45,2.10965967087332],
["1djw",2.45,3.31900270700833],
["1knz",2.45,2.94857236868327],
["1fdy",2.45,2.91528707784114],
["1nmt",2.45,2.86278549774914],
["2prc",2.45,2.64003863836747],
["2f6i",2.45,2.71159091067312],
["1mwr",2.45,3.11474348991476],
["1mwt",2.45,2.71592820584407],
["1re3",2.45,2.87545553735478],
["1n80",2.45,3.18679155009522],
["3dbv",2.45,2.78893310010444],
["1j0e",2.45,3.05717090621705],
["1njj",2.45,3.26756532219162],
["1aqd",2.45,2.64166843391046],
["1rxx",2.45,2.89125201031819],
["1g5x",2.45,3.18029732334575],
["1qpr",2.45,2.81861593992105],
["1qpq",2.45,2.75702119883595],
["1nd0",2.45,2.71933572340139],
["1gq7",2.45,1.99588359055534],
["1uvk",2.45,2.69624639334985],
["2byr",2.45,1.92751253237418],
["2fvm",2.45,1.90851900785856],
["1upc",2.45,1.88708910941222],
["1nzx",2.45,1.84120084034387],
["1nzz",2.45,2.04715404039277],
["2f1l",2.46,1.69283990358610],
["2blg",2.46,2.99606142882328],
["1rrc",2.46,3.02440433891302],
["1w05",2.46,2.57163669984144],
["1xha",2.46,2.37873813237885],
["1sfn",2.46,3.12029521285148],
["1lpb",2.46,2.98000108509994],
["2arh",2.46,3.18468521951606],
["1ckj",2.46,2.72167192582243],
["2ajr",2.46,1.88814947499925],
["2av8",2.46,2.71156299297156],
["1fcm",2.46,3.07805810450934],
["2ske",2.46,3.19345221912325],
["1q95",2.46,3.07292064777629],
["2gm3",2.46,2.30673267622456],
["1ewd",2.46,2.96768233306056],
["1s3o",2.47,3.56291770860583],
["1d0m",2.47,1.84251855414780],
["1xh7",2.47,2.0167058779571],
["1t7d",2.47,3.0535053689727],
["1s9a",2.47,3.18187139635913],
["1mbz",2.47,3.10606802129051],
["1ps7",2.47,3.20497470236364],
["1c5f",2.47,2.48955394610848],
["1g1a",2.47,2.73453244930981],
["1pkr",2.48,3.68330200275561],
["2bmm",2.48,3.20605041841863],
["1qcd",2.48,2.05383864507692],
["1xko",2.48,3.24101196939002],
["2alr",2.48,2.93098360375314],
["1ygb",2.48,3.68586504021554],
["1y8o",2.48,2.38304573720879],
["1h7t",2.48,2.20465111239967],
["1e7y",2.48,2.29353506166952],
["1fn3",2.48,4.37047223517252],
["2aov",2.48,2.60300469283037],
["1eo7",2.48,3.20480182419757],
["1e9i",2.48,2.82038493154515],
["2fn6",2.48,2.71495192405116],
["1ydw",2.49,3.2374195342932],
["2fpn",2.49,3.5178378783728],
["1ejf",2.49,2.41103806491711],
["2a5x",2.49,2.24066946203772],
["1sve",2.49,2.33499210787211],
["2fif",2.49,2.24221472970948],
["1hkz",2.49,2.56531183698589],
["1v47",2.49,2.81754173704415],
["1vr0",2.49,2.18355723736894],
["1u3t",2.49,2.68010643022894],
["1tkd",2.49,2.73097738436725],
["1f52",2.49,3.34615723480870],
["2b5o",2.5,2.17553820566919],
["2plh",2.5,3.19980248599595],
["4ovo",2.5,3.31889108377543],
["1w5h",2.5,3.04194632424338],
["1pi2",2.5,3.24922660042115],
["1uo1",2.5,3.72520456965212],
["1t3j",2.5,2.38310842750335],
["1rmr",2.5,2.89247233133259],
["1b7k",2.5,2.44591763563102],
["1b07",2.5,1.82406958846767],
["1dhg",2.5,2.0212314760152],
["1ckt",2.5,3.26149407142819],
["1lr9",2.5,2.28854598809958],
["1skn",2.5,3.90844233885151],
["1wk2",2.5,2.76819964536785],
["1cc5",2.5,4.3903233995543],
["1zx3",2.5,2.74290899068999],
["1fyk",2.5,2.13802433032423],
["1o51",2.5,1.81655036070027],
["1q09",2.5,2.35767778761727],
["1lxe",2.5,2.65971855737184],
["1uva",2.5,3.46099735663048],
["1qys",2.5,3.18768427867313],
["2ins",2.5,3.58960141561936],
["1vc0",2.5,2.52118711574180],
["1jca",2.5,1.43301269349174],
["1t2t",2.5,3.00161709833732],
["1b9e",2.5,2.86675834458329],
["1iza",2.5,3.62969692407591],
["1jwo",2.5,4.42768570728298],
["4fxc",2.5,3.88518362372203],
["1mft",2.5,2.90129625171368],
["1ytj",2.5,2.22519027057394],
["2az9",2.5,3.01080126561556],
["1z9w",2.5,2.7204389097935],
["1frx",2.5,2.57954065314688],
["1bik",2.5,2.74832315891185],
["1g96",2.5,2.89598568682214],
["1jsg",2.5,3.09309968999983],
["1rn7",2.5,2.38280501804361],
["1yat",2.5,2.64269722795822],
["1ubd",2.5,3.82102301609856],
["1j3e",2.5,3.28691361520783],
["1pbk",2.5,2.49347642443779],
["1zns",2.5,3.21431595202986],
["1dp8",2.5,2.76100117600727],
["1aoj",2.5,3.89519340270596],
["1cdt",2.5,3.79841087694777],
["1gd6",2.5,2.82244571653448],
["1c7h",2.5,3.33188292561192],
["1rsd",2.5,1.56426805578375],
["1pdn",2.5,2.58129007757297],
["155c",2.5,4.96770716758293],
["4fit",2.5,3.02900258108676],
["1per",2.5,3.27972629995167],
["1rpe",2.5,3.79765431439269],
["2or1",2.5,4.39936597846585],
["1rtb",2.5,3.76688357177575],
["1rta",2.5,3.74999603190913],
["2acg",2.5,3.18441090765050],
["1prq",2.5,2.80981608193125],
["1yrn",2.5,3.15195629673764],
["1akh",2.5,3.57010326669384],
["2ft9",2.5,2.45137242822764],
["1p6p",2.5,3.25195128011809],
["1qd0",2.5,2.994519848417],
["2bfh",2.5,3.09233143083267],
["3cro",2.5,4.22707481186519],
["1mpu",2.5,3.55845359912584],
["3lz2",2.5,3.64636689361187],
["8lyz",2.5,3.56168891069639],
["7lyz",2.5,3.72905778325132],
["2eql",2.5,3.24022655302728],
["1w08",2.5,2.7640743155113],
["1pf5",2.5,2.68242447951134],
["1alb",2.5,2.46569555368559],
["1hlv",2.5,2.81697275883358],
["1dcf",2.5,2.07347265102153],
["1f7r",2.5,2.79006380224563],
["6pax",2.5,2.81594930995652],
["2spt",2.5,4.02331714396609],
["1xbs",2.5,2.93343580693754],
["1z91",2.5,3.34475251497469],
["1eks",2.5,3.14889922746256],
["1zme",2.5,3.07368228755954],
["1jon",2.5,2.45168617822842],
["1hus",2.5,3.29988835782983],
["1le4",2.5,3.03407330587168],
["2hip",2.5,3.51445233416077],
["1hup",2.5,2.09836336179503],
["1af3",2.5,2.59151736247206],
["1r14",2.5,2.60648009814999],
["2a0j",2.5,2.84392107929589],
["2abx",2.5,5.14170890781682],
["1ec5",2.5,3.74845060187132],
["2hap",2.5,3.58653096523467],
["1b34",2.5,3.15295764124699],
["1z3d",2.5,2.48171770321586],
["1z2m",2.5,2.65944068054512],
["1mbs",2.5,5.12989769990527],
["2gpr",2.5,3.73920318366081],
["1u3l",2.5,2.52209650761189],
["1u2q",2.5,2.53101223235296],
["2c4v",2.5,2.68018830253451],
["1hlb",2.5,3.40435347060644],
["1r4o",2.5,3.91815764702978],
["2ao4",2.5,2.96191584518922],
["7dfr",2.5,3.83409816019158],
["1cyw",2.5,2.95334470203953],
["1b0o",2.5,3.85605920696641],
["1c68",2.5,3.11477457973278],
["171l",2.5,4.16003742214707],
["231l",2.5,2.90865023925597],
["1qtc",2.5,3.21965763420256],
["1qs5",2.5,3.59777172472722],
["1qtd",2.5,4.03179654590887],
["2agc",2.5,3.36543380865536],
["1eh8",2.5,2.5226470632506],
["1tie",2.5,2.19201119564424],
["189l",2.5,4.0665019352818],
["1u3g",2.5,3.25087654490106],
["1bxw",2.5,3.52669753359881],
["1jan",2.5,2.89689269331716],
["1gnq",2.5,3.5474731544701],
["1z6i",2.5,2.19159951801002],
["2b71",2.5,2.23772221498547],
["1t5y",2.5,2.87857205141600],
["1ws6",2.5,3.17545039115322],
["1nni",2.5,3.08433278903230],
["1lck",2.5,3.44055478913941],
["1e4j",2.5,1.82191137548984],
["1m27",2.5,2.03028031988686],
["1yha",2.5,3.66716346514227],
["261l",2.5,3.52046206695112],
["1iiu",2.5,3.20471945658536],
["1mqa",2.5,3.08698735158522],
["1brp",2.5,3.62730491898778],
["1brq",2.5,3.95332976900401],
["1qhx",2.5,2.30024944874479],
["1wdf",2.5,3.22783464696723],
["1cdj",2.5,4.05678707424975],
["1hnf",2.5,3.05815437979777],
["1znz",2.5,2.04886713578906],
["1z8f",2.5,1.90716368240065],
["1hjp",2.5,3.12911274661701],
["1rtv",2.5,3.09805920475054],
["1j9a",2.5,3.34225594377274],
["1n9z",2.5,3.44848208895382],
["1j42",2.5,2.80591222740313],
["1r6k",2.5,2.80599328032634],
["1hgu",2.5,4.30371929957456],
["1u70",2.5,3.3118142321805],
["1s3u",2.5,2.98098436723544],
["1cmi",2.5,2.76919818214321],
["1dtp",2.5,3.48994723223755],
["3ygs",2.5,2.63830305953864],
["3psr",2.5,3.12377890266835],
["1uly",2.5,2.75911084710728],
["1l9g",2.5,2.65215370565708],
["1k4j",2.5,2.54120286289302],
["1c81",2.5,2.97143793716847],
["2bfr",2.5,1.75337602188105],
["1qpi",2.5,3.12920030632667],
["3upj",2.5,2.39613710913758],
["1fxa",2.5,2.64832506208566],
["1nz6",2.5,2.30208504313346],
["1xbn",2.5,4.02010060193849],
["1lay",2.5,3.28368566948202],
["1hpo",2.5,2.43443214251729],
["1bdq",2.5,2.7299063184015],
["2trt",2.5,2.57658790460295],
["2bpz",2.5,2.00502497571895],
["3aid",2.5,2.64621320679285],
["1siv",2.5,2.94792004888963],
["1aaq",2.5,2.72010059026963],
["1hsi",2.5,3.17468805153977],
["1d4s",2.5,3.03435710654713],
["1sh9",2.5,2.93528369915137],
["1c6y",2.5,2.54909267246326],
["1c6x",2.5,2.70113653761306],
["1c6z",2.5,3.10576669577892],
["8hvp",2.5,3.59105390295475],
["1mtb",2.5,2.4677933965576],
["1ivp",2.5,3.35386856487156],
["1a8g",2.5,2.68026224568054],
["1jld",2.5,3.20936963526758],
["1bdt",2.5,2.96897697236825],
["1j0w",2.5,3.22090837383603],
["1m5m",2.5,3.14808684488359],
["1qg2",2.5,2.45671885072309],
["1pmt",2.5,3.43665668148747],
["1jnx",2.5,3.47788920293207],
["1eu4",2.5,2.11914934092626],
["1f97",2.5,1.43021529028650],
["3cd2",2.5,3.37441979231599],
["1vh6",2.5,2.19637531271364],
["1wwa",2.5,3.41414115662780],
["1cde",2.5,3.01209924592445],
["1umu",2.5,2.76106761116484],
["1zzy",2.5,2.34115209783863],
["1psp",2.5,3.16110419751849],
["2euc",2.5,3.60508338062345],
["2a8e",2.5,2.26006599128154],
["1bmc",2.5,3.35036465744717],
["1xwm",2.5,3.55500444164034],
["1bqi",2.5,3.29879390954666],
["1qpf",2.5,2.49550871654270],
["1cia",2.5,2.23426626110322],
["1qva",2.5,2.80797312380109],
["1p59",2.5,2.42014548499754],
["1r5a",2.5,3.17305503427562],
["1bgq",2.5,2.99270550505664],
["1a4h",2.5,3.12413835691846],
["1kku",2.5,3.0721436850047],
["1yk7",2.5,2.29767608096873],
["1au3",2.5,3.19215113261888],
["1ua5",2.5,2.51187050760071],
["1qxa",2.5,2.93293794546203],
["1tjd",2.5,2.61017803346972],
["2g6d",2.5,2.51545800104548],
["1xb7",2.5,1.88470381930337],
["1jjh",2.5,2.30888575382019],
["1jud",2.5,2.36986592952301],
["1uef",2.5,3.11950415332623],
["1eme",2.5,2.74795616890057],
["1y98",2.5,3.30826897782356],
["1qh9",2.5,2.66600028099389],
["1xa9",2.5,3.50784450140545],
["1cv7",2.5,3.65766851217295],
["1k1l",2.5,2.14860573687062],
["1ks4",2.5,2.77213458043108],
["1g62",2.5,2.64074845750214],
["1chg",2.5,4.12519490808297],
["1dze",2.5,3.12285155696807],
["1fy1",2.5,3.08031929095732],
["1ue1",2.5,3.30794486607632],
["1csk",2.5,3.07454222338223],
["1ljm",2.5,2.65342817710739],
["1b88",2.5,3.41292447366327],
["1iw9",2.5,2.73022102464354],
["1x0s",2.5,2.84542898730106],
["1z35",2.5,2.63032560092341],
["1z38",2.5,2.64408992187256],
["1f4k",2.5,2.92122510065387],
["1qm8",2.5,3.31838659699213],
["2bfv",2.5,2.95473682822692],
["1re1",2.5,1.89452019194398],
["1j0r",2.5,2.90579534703155],
["1c2r",2.5,2.75851093756020],
["1z1a",2.5,2.7111626853053],
["1ggv",2.5,2.22264058631275],
["1pvt",2.5,3.45682258388426],
["1gne",2.5,3.62667773449738],
["1pau",2.5,1.9127582096691],
["1rhk",2.5,1.7613197985875],
["1p9p",2.5,2.85817430109699],
["1cr4",2.5,3.26150209734602],
["1lzw",2.5,3.40632292274056],
["1gnz",2.5,3.2468121088126],
["1hdr",2.5,2.84071586786550],
["3ink",2.5,3.24339632718408],
["1est",2.5,2.54670647786441],
["1pc9",2.5,2.47979796756655],
["1zqx",2.5,3.58710780308600],
["2a1x",2.5,2.50499250065455],
["1xhe",2.5,2.87423333550473],
["2est",2.5,2.63182003279584],
["1pp2",2.5,3.3240587960344],
["1q07",2.5,2.20727372988102],
["1dpb",2.5,2.37451945342431],
["1msp",2.5,3.6618392663592],
["1adw",2.5,2.40705291514617],
["1u2s",2.5,2.58525988157772],
["1u5o",2.5,2.92922302120969],
["2aru",2.5,2.90706892356326],
["1jhe",2.5,2.90865988901112],
["1nrf",2.5,2.75665677661211],
["1hno",2.5,2.54647318136489],
["1rbb",2.5,4.14762059205251],
["1r5d",2.5,2.58976334745711],
["1y8c",2.5,2.95179310097689],
["1wdx",2.5,2.09352732784985],
["1xzx",2.5,2.7800166522164],
["1e3r",2.5,3.26251248331988],
["1juk",2.5,2.7081556976037],
["1fhx",2.5,2.79366617721902],
["1quu",2.5,3.43968676378854],
["1zdu",2.5,2.45627341765121],
["2dcd",2.5,2.78103513387201],
["1nav",2.5,2.71113695698276],
["1nf1",2.5,3.50346655132976],
["1wvc",2.5,3.77825205970808],
["1ri1",2.5,2.56082351543004],
["1ri3",2.5,2.8879656749186],
["2fp3",2.5,3.34868251324134],
["2frh",2.5,3.63102543479303],
["6ca2",2.5,2.72642205509552],
["1gaj",2.5,2.98457019255423],
["1raj",2.5,1.87211514839241],
["1bmq",2.5,3.43093266314483],
["1s0z",2.5,2.05692284418747],
["1jaf",2.5,1.93789718531143],
["1pt3",2.5,3.03155829291052],
["1yok",2.5,2.76865081631188],
["2cfv",2.5,2.75438838933012],
["2hnt",2.5,4.17894280654503],
["1i31",2.5,2.96898548304388],
["1ilz",2.5,2.67790816675342],
["1zsa",2.5,2.56977997175000],
["1c3a",2.5,3.193684754648],
["1m61",2.5,3.11376548490463],
["1kzu",2.5,2.85046779168400],
["1usw",2.5,3.43326670337884],
["2cnd",2.5,3.32940283957368],
["2ans",2.5,2.23617740985165],
["1qrh",2.5,2.91604744170443],
["1qps",2.5,3.16411204647613],
["2cgu",2.5,3.02410735370285],
["1imf",2.5,2.55181231458943],
["1a0p",2.5,3.56931321462844],
["1yi3",2.5,2.69171639652944],
["1p2a",2.5,2.85199614512565],
["1yyp",2.5,2.75401742944104],
["1uvt",2.5,2.60139083642295],
["1br5",2.5,3.19912358504923],
["1gzn",2.5,3.71032350209358],
["1vhi",2.5,2.83979030581468],
["1rpu",2.5,2.63774451567611],
["1drj",2.5,2.27470812204050],
["1rw4",2.5,3.33551824448635],
["1ewa",2.5,2.25354822054794],
["1mjb",2.5,2.62026161930738],
["1mj9",2.5,2.66385285486710],
["1sbc",2.5,3.97961492217567],
["1sbt",2.5,4.08641701501159],
["1a06",2.5,2.78604473179228],
["1je6",2.5,3.22914581555171],
["1uu8",2.5,2.48240857060902],
["1brc",2.5,2.44918109961021],
["1k0f",2.5,3.99228530593414],
["1g93",2.5,3.33968010037885],
["2bmy",2.5,2.51336220833240],
["1d8l",2.5,3.26733258802671],
["1yts",2.5,2.56449586532121],
["1gwz",2.5,4.41655204422984],
["1eh5",2.5,2.89039769714428],
["1b02",2.5,2.82124149480394],
["1ith",2.5,2.65576238363763],
["2ffs",2.5,2.13714833503700],
["1rr6",2.5,2.70820521168125],
["1a5y",2.5,2.79411768067216],
["1q14",2.5,3.17980826560168],
["1ut4",2.5,2.21062928420426],
["1wav",2.5,3.58162154845815],
["1pfg",2.5,3.92191719472981],
["1rvw",2.5,3.44230676679692],
["1fdh",2.5,3.57717814148831],
["1td6",2.5,3.28703330828961],
["1pbx",2.5,3.12191751939509],
["2kai",2.5,3.31950235317897],
["1pxl",2.5,2.99048697052218],
["2a2f",2.5,3.10663651424590],
["1q22",2.5,2.20719013713095],
["1dm4",2.5,4.22032013635866],
["1ol5",2.5,2.52992925156755],
["4thn",2.5,3.55174672653475],
["1fpr",2.5,4.423044434545],
["1xp8",2.5,3.06094303726541],
["1pxn",2.5,3.18863195810452],
["1rhd",2.5,4.24602619492504],
["3hat",2.5,3.86152085131761],
["2csn",2.5,2.3889673386577],
["1ett",2.5,3.55752643811473],
["1f42",2.5,2.21947736500507],
["1tmu",2.5,3.14618748721879],
["1jwt",2.5,3.60551779023587],
["2lkf",2.5,2.72209649829229],
["1gr1",2.5,2.15096333718858],
["1nkn",2.5,2.48644782723694],
["1aua",2.5,3.06697220363862],
["1l8g",2.5,2.79909941127320],
["1kak",2.5,2.9362530406586],
["1om9",2.5,2.60055644475100],
["1xbo",2.5,2.07401903202673],
["1f0o",2.5,2.52854741317080],
["2afc",2.5,2.77478979994082],
["2f9d",2.5,2.61735802090521],
["3por",2.5,2.77873184374785],
["1u0c",2.5,3.21622003517803],
["1pmb",2.5,3.48976803431993],
["1tiy",2.5,2.80142900379570],
["1zh6",2.5,2.49721908876958],
["1kw0",2.5,2.8099832043749],
["1ztu",2.5,2.8818014740335],
["2ac2",2.5,2.64992345109417],
["1yqk",2.5,2.73341961841223],
["1f8x",2.5,2.57393286346646],
["1uho",2.5,2.95770563659892],
["1zbx",2.5,2.69921143495774],
["1yqm",2.5,2.53350446859309],
["1efn",2.5,2.90219241037243],
["1fph",2.5,3.18438920079833],
["1twj",2.5,2.78758486967029],
["2ren",2.5,3.74691671506148],
["1tyb",2.5,2.36598979522028],
["1tyc",2.5,2.52489056036957],
["1tyd",2.5,2.42889982919454],
["1gye",2.5,2.60433761988888],
["1utz",2.5,2.32220844636260],
["1tdr",2.5,3.48372976256005],
["1nja",2.5,3.02468439698462],
["1jmf",2.5,2.85791938290295],
["1vzb",2.5,3.52126096480206],
["2g89",2.5,3.26298469983129],
["1vza",2.5,3.62103098268498],
["1lce",2.5,3.75351516869492],
["1vzc",2.5,3.75538711566671],
["1lcb",2.5,4.10244779968649],
["1njc",2.5,2.65213616122501],
["1jmh",2.5,2.88309353291572],
["1tsl",2.5,2.87684888577177],
["1tsx",2.5,2.92900474880255],
["1jmi",2.5,2.97224545652363],
["1cl0",2.5,2.6428896164376],
["1lbt",2.5,1.8851859362606],
["3pbh",2.5,3.32495930214229],
["1p5j",2.5,2.77299047843436],
["1b6b",2.5,2.99043676371780],
["2g36",2.5,1.94051299305251],
["1ko4",2.5,2.71306165481109],
["1vdc",2.5,2.56005370413828],
["1btg",2.5,3.46426883580906],
["1xex",2.5,3.01774526540444],
["1ba7",2.5,2.82955833924287],
["1zh1",2.5,2.79151884795502],
["1lio",2.5,4.79711232733018],
["1qnv",2.5,3.66141588606769],
["1u3f",2.5,2.75318627605846],
["1b8u",2.5,2.92572328032598],
["4apr",2.5,1.9658658749138],
["1hmy",2.5,3.23718234083588],
["1kv1",2.5,3.19831183760152],
["1yzu",2.5,2.60856994454721],
["6apr",2.5,1.82363739708577],
["1fj6",2.5,2.75860560035648],
["1f4o",2.5,2.73149802683918],
["1nw3",2.5,2.41362971406521],
["1s3m",2.5,3.31671004742481],
["1s3n",2.5,3.41986316140367],
["1b3e",2.5,2.72434366843444],
["1z73",2.5,2.70331697996375],
["1szb",2.5,2.99298700514332],
["1pjk",2.5,2.30424018484170],
["1zen",2.5,3.45541168169408],
["1bt3",2.5,2.86530882761559],
["1x72",2.5,2.71278741203326],
["1dxh",2.5,2.73984019906705],
["1r00",2.5,2.40456118656945],
["1j72",2.5,3.70586249159075],
["1czg",2.5,1.51596534600155],
["1w58",2.5,3.23322980128254],
["1p1g",2.5,2.22607637755574],
["1ca7",2.5,2.50402124563655],
["1qpz",2.5,3.51678050520069],
["1jft",2.5,3.62042613984245],
["1sb9",2.5,2.15972646003939],
["1biw",2.5,2.84690999269796],
["1zap",2.5,2.95691587371878],
["1vrl",2.5,2.80407634900498],
["4cpa",2.5,3.88277061992746],
["2bqu",2.5,2.79903993390243],
["1ylf",2.5,2.14481283788917],
["2axp",2.5,3.11716898343662],
["1nk1",2.5,3.735708169703],
["1pmv",2.5,2.82720918077932],
["1oyu",2.5,3.635175005662],
["1n1g",2.5,1.96590119274944],
["1m67",2.5,2.76919474761083],
["262l",2.5,3.62005266648965],
["1l2f",2.5,3.46912580241969],
["1hex",2.5,2.40896388308241],
["1sdn",2.5,2.43317994152070],
["1x94",2.5,2.67046423361813],
["1ic4",2.5,2.82477698074661],
["1nvg",2.5,2.66131384061224],
["1ubv",2.5,4.08030665809018],
["1ubw",2.5,4.05183597730136],
["1ubx",2.5,4.28918785216797],
["1h2m",2.5,1.99586397191173],
["2b9i",2.5,2.9239962967363],
["1uml",2.5,3.03490064299737],
["1wxy",2.5,3.47119605734629],
["1v78",2.5,3.56623242119645],
["1v79",2.5,3.5753147720738],
["1v7a",2.5,3.64081961129308],
["1g2x",2.5,2.76384809478578],
["1tvo",2.5,3.12524228105866],
["1wzy",2.5,3.44825965005324],
["1bl7",2.5,3.14778202546639],
["1bl6",2.5,3.22049736907516],
["1a9u",2.5,3.26590151210209],
["1jej",2.5,2.55723477919544],
["1jiu",2.5,3.10737467409261],
["1w83",2.5,2.62288317871985],
["1i9a",2.5,3.04388279731581],
["1r3u",2.5,2.93882368759333],
["1hdm",2.5,2.73893827430692],
["2ncd",2.5,3.50510691256114],
["1mji",2.5,3.370660596958],
["2f6s",2.5,2.21517401582062],
["2bu8",2.5,2.88105225729436],
["6jdw",2.5,2.36998977816596],
["9jdw",2.5,2.58413654375766],
["4jdw",2.5,2.83912059196672],
["1a1r",2.5,2.71330185522454],
["1p51",2.5,2.1885994235019],
["2g8z",2.5,3.05580775372711],
["1t3u",2.5,2.67709293277115],
["2ai9",2.5,2.83512316350378],
["1ytf",2.5,2.58039077943433],
["1xbr",2.5,2.65041172312801],
["1xip",2.5,3.19960363578214],
["1uun",2.5,2.77949801704166],
["1n3x",2.5,2.3769902005506],
["1fbl",2.5,3.16345152173673],
["2c5s",2.5,2.22673081666719],
["2alz",2.5,3.42012111589535],
["1htm",2.5,3.43281072627087],
["1zmg",2.5,2.70239884820619],
["1mkg",2.5,2.97972796414747],
["1vpf",2.5,2.73850274097675],
["1jvx",2.5,3.23803131908287],
["1c3s",2.5,3.17192190087898],
["1e9l",2.5,3.56579775029036],
["1p9r",2.5,2.78207155009681],
["1zt1",2.5,2.14553147221081],
["1d2p",2.5,3.14365817872569],
["1saz",2.5,2.77264470083432],
["1onl",2.5,2.64085534190697],
["1vac",2.5,2.31477707647220],
["2vab",2.5,1.83539432608017],
["1o5t",2.5,3.2176145675849],
["1vad",2.5,1.90397092863652],
["1a4r",2.5,3.63262612712419],
["2a6a",2.5,2.20581318732509],
["2bnn",2.5,2.32572679341098],
["1s9x",2.5,2.67567558700272],
["1qyi",2.5,3.00310485415572],
["1sqk",2.5,3.03667124077832],
["1a9e",2.5,2.45002341240680],
["1h0c",2.5,2.96497861808973],
["1khh",2.5,3.25220174430351],
["1p1c",2.5,3.21007510341301],
["2a6t",2.5,2.97382852305585],
["1nna",2.5,2.90558628903347],
["1rm1",2.5,2.96076744161052],
["1r9g",2.5,3.39091571057423],
["1guo",2.5,2.40701120915442],
["1b9s",2.5,3.54518001856871],
["1pbb",2.5,2.39457712241095],
["1cj3",2.5,2.11469897509491],
["1var",2.5,3.01659161853849],
["1iuv",2.5,2.59066594118617],
["1j59",2.5,3.87575500427704],
["1ase",2.5,2.93084812636846],
["1czc",2.5,2.5220849074794],
["2bng",2.5,2.47333873766771],
["2a2j",2.5,3.09168686833499],
["1gxp",2.5,3.32627714925347],
["1l6j",2.5,3.04889626705226],
["1bcr",2.5,3.07660052653608],
["1eft",2.5,2.88927283657674],
["1spr",2.5,2.98173462554226],
["1r61",2.5,2.70337960099790],
["1lcs",2.5,2.49669422963357],
["1jqg",2.5,2.4138925750932],
["1du5",2.5,2.429096975519],
["1ux5",2.5,3.16040031342099],
["1y97",2.5,2.92238545640945],
["9icd",2.5,2.69462313296010],
["3icd",2.5,2.70082149860312],
["4icd",2.5,2.74243819559173],
["8icd",2.5,2.76031252293459],
["5icd",2.5,2.90166214441512],
["1grp",2.5,2.58453345142822],
["1gro",2.5,2.63508133440881],
["1bl5",2.5,2.60389694318857],
["1idf",2.5,2.6930311457823],
["1idc",2.5,3.15129635548950],
["1ide",2.5,3.27934255416735],
["4gss",2.5,2.43507518138292],
["1gsd",2.5,1.95262222333347],
["1eyp",2.5,2.84432384709566],
["1qg4",2.5,2.33649357261558],
["1kf0",2.5,2.87394607376205],
["1yru",2.5,3.58953224270903],
["3pgk",2.5,4.99746834949942],
["1axd",2.5,2.59304296932192],
["1hmp",2.5,3.92126087179349],
["1o7f",2.5,3.06439866601079],
["1id5",2.5,3.30277600066340],
["1cje",2.5,3.13567170354234],
["1bz7",2.5,3.41947383322646],
["1pyb",2.5,3.38026684769962],
["1aup",2.5,3.67754523557033],
["1vff",2.5,3.31422936373948],
["1ck0",2.5,2.84288816823624],
["1rho",2.5,2.31808268452774],
["1at3",2.5,3.26234365026971],
["6cts",2.5,3.23123454173425],
["1bag",2.5,2.48932884942526],
["1fgn",2.5,3.08597744424562],
["1iid",2.5,3.52293387147066],
["15c8",2.5,3.29430355902875],
["1biu",2.5,1.86662073204043],
["1rih",2.5,2.78771835601284],
["1c7r",2.5,2.91423119598536],
["1cg3",2.5,2.75933053911687],
["1cg0",2.5,2.88902763648365],
["1cg1",2.5,2.87433855033485],
["1ch8",2.5,2.77266538674172],
["1cg4",2.5,3.0514444500065],
["1gim",2.5,3.01531623399826],
["1nht",2.5,3.49522476752954],
["1mf0",2.5,2.99144164683794],
["2bg8",2.5,2.48532720684373],
["1m7i",2.5,2.88063555753115],
["1g4p",2.5,2.29138605201965],
["1j4b",2.5,3.08583634229028],
["1ucb",2.5,2.80617219320025],
["1aur",2.5,2.88167243726396],
["1kcs",2.5,3.5499822964536],
["1cly",2.5,3.33350876387141],
["1iqw",2.5,3.04688620641798],
["1kc5",2.5,3.52858741107195],
["1lkz",2.5,3.03695745968386],
["1ial",2.5,2.82087005604771],
["1tcr",2.5,3.18498963116977],
["1ru9",2.5,2.45533320415405],
["1apn",2.5,2.80255899306634],
["2aab",2.5,3.11719271446903],
["1mnu",2.5,3.01817465357482],
["2bhd",2.5,1.11879850444609],
["1yyk",2.5,2.98102353600692],
["1l2u",2.5,3.37686153273184],
["1yfp",2.5,2.43515595059858],
["1q1t",2.5,2.60646606019035],
["1ikf",2.5,3.01004915977936],
["1dkf",2.5,3.24195669924218],
["1amh",2.5,2.62994402408556],
["1pjn",2.5,2.69027989637626],
["1xhb",2.5,3.18762805870002],
["1b4s",2.5,2.83514744164485],
["1jd9",2.5,2.56760677349249],
["1yhg",2.5,1.59581171358312],
["1z4x",2.5,2.68231492926062],
["1z4z",2.5,2.71458537566624],
["1mur",2.5,3.32911972671269],
["1mg1",2.5,3.63130456232939],
["1k0a",2.5,2.88367451748788],
["1fv2",2.5,3.27018117518694],
["1tn0",2.5,2.61693373115927],
["1hlk",2.5,2.64234997092758],
["1kr3",2.5,2.8579974514859],
["1o0t",2.5,2.05658840280058],
["2am1",2.5,3.1849167899332],
["2g9i",2.5,2.59218502187384],
["1rhm",2.5,2.49161164987890],
["1u3s",2.5,2.58362957613621],
["2bq0",2.5,2.2464090565812],
["1quq",2.5,3.15593486141647],
["1rc2",2.5,3.03621067555004],
["1xr6",2.5,2.33198766543074],
["3grt",2.5,3.03102122479416],
["1xiu",2.5,3.1868452456881],
["1itb",2.5,3.46530413677397],
["1te1",2.5,2.72092436106392],
["1k3z",2.5,3.36064354981442],
["1pp4",2.5,2.42091177679672],
["1vgo",2.5,2.87811450091456],
["1fl9",2.5,4.54612604581954],
["1gln",2.5,3.85757098679016],
["2pbg",2.5,3.24072401834921],
["1bqy",2.5,2.46887333044664],
["1ni0",2.5,3.42956959232415],
["1s3h",2.5,2.49650748919992],
["1vjt",2.5,2.22813175225982],
["1a35",2.5,2.9331971105397],
["1rqe",2.5,2.48921198342369],
["1pgp",2.5,2.50858535875187],
["1pgo",2.5,2.81518878678275],
["2b25",2.5,1.94165817824672],
["1ie4",2.5,2.60658156267148],
["1gke",2.5,3.46913656105960],
["1mqf",2.5,1.66183442963121],
["1e33",2.5,3.18056169760361],
["1ud6",2.5,2.07105208561253],
["1fgu",2.5,3.49295616992349],
["1snu",2.5,3.72343544779566],
["1xo1",2.5,2.02153570029720],
["1q7c",2.5,2.03735210649695],
["1u05",2.5,2.97290756850661],
["1wq1",2.5,3.07114587989859],
["2dpg",2.5,1.97364149844535],
["1h94",2.5,2.75290157995373],
["1rve",2.5,3.69235150749304],
["1osv",2.5,3.70581724193927],
["1v7y",2.5,2.98975447115597],
["1rh1",2.5,3.21252755051903],
["2bh9",2.5,3.49149428106315],
["1hk7",2.5,3.07554739900318],
["8tim",2.5,3.76217203335974],
["1tim",2.5,4.40550628780489],
["2ypi",2.5,4.39938517367201],
["1hl6",2.5,2.70910262615637],
["1zym",2.5,3.46026551162630],
["2viu",2.5,2.52310680468463],
["1vz4",2.5,2.74111407898175],
["1qma",2.5,2.59546466558182],
["1thn",2.5,3.29743595926310],
["1trd",2.5,3.54561940916557],
["1t8p",2.5,2.74012938288250],
["2f17",2.5,3.00901936780613],
["1k4y",2.5,3.28025598577146],
["7cat",2.5,3.63260942616912],
["1isf",2.5,2.52483829163579],
["1sj7",2.5,3.77688499856976],
["1b1y",2.5,3.08481108465754],
["1i4n",2.5,2.40689824072422],
["1bs5",2.5,3.02364248436041],
["1bs7",2.5,3.16732029322148],
["1tid",2.5,3.14280446993161],
["1pwz",2.5,2.76143600408917],
["2bhf",2.5,2.00862465891375],
["1zh7",2.5,3.61184575875171],
["2a91",2.5,2.71993944664955],
["1jql",2.5,3.34588090132458],
["1kny",2.5,3.62124188721590],
["1byk",2.5,2.57617696735748],
["1lmw",2.5,3.94668761777534],
["1jec",2.5,2.29142023200823],
["1fsi",2.5,3.21490440225731],
["1mvk",2.5,1.69052492710452],
["1dfg",2.5,2.96923487397840],
["1fic",2.5,2.42084936034856],
["1knu",2.5,2.68732980831695],
["1w4z",2.5,2.52387723839301],
["1jto",2.5,2.59409367408158],
["1ipf",2.5,2.65684283247275],
["1ipe",2.5,2.90770969260101],
["1b90",2.5,2.77123948272162],
["2jel",2.5,2.71614136766718],
["2c3a",2.5,2.61443469328695],
["1tww",2.5,2.45529566763258],
["1paf",2.5,2.92819363123801],
["2an5",2.5,2.13790280143368],
["1o4u",2.5,2.14562935776944],
["1qti",2.5,3.23279840114859],
["2fgi",2.5,2.34172430292265],
["1jtq",2.5,1.97290159471460],
["1vot",2.5,2.83317121743873],
["2aai",2.5,3.38719211034676],
["1gtr",2.5,2.44911912512460],
["1zjw",2.5,2.89422333922906],
["1ztx",2.5,3.11879864442066],
["1knr",2.5,3.51947058952388],
["1zwi",2.5,2.97349590504325],
["2atk",2.5,2.99968987373063],
["1h78",2.5,2.89534494080897],
["1ydm",2.5,3.26766770993413],
["1ktq",2.5,3.11808623076786],
["5ktq",2.5,3.25018803256632],
["1qih",2.5,2.55351304757581],
["1hbj",2.5,2.72226255007533],
["1eve",2.5,2.15909582748106],
["1mdf",2.5,2.95458317793582],
["2cw8",2.5,3.33590552955506],
["1dab",2.5,3.55582361825459],
["4ktq",2.5,4.07940878613087],
["1qrc",2.5,1.978432245576],
["1wom",2.5,2.89671447225440],
["1gwx",2.5,3.94578472225087],
["1fgi",2.5,1.99560503899497],
["1exn",2.5,2.66865485641628],
["1awb",2.5,2.01090321864840],
["1i4d",2.5,3.30316626130227],
["2b2c",2.5,2.94070252618003],
["1rtr",2.5,2.58180434536300],
["1m2z",2.5,3.46995195214148],
["1xse",2.5,2.80088787077836],
["1w93",2.5,3.98659981891658],
["1s5y",2.5,2.71715122935035],
["1yv2",2.5,2.73872996692802],
["1ycp",2.5,3.60548761276925],
["1gy9",2.5,3.00529986844938],
["1quv",2.5,3.63621353898107],
["1bsp",2.5,2.58720731166407],
["1d4d",2.5,3.51338629723294],
["1gzd",2.5,2.85319676600049],
["1i00",2.5,2.60921145910365],
["1ypt",2.5,2.09088882851892],
["1cy6",2.5,2.92518128455621],
["1fdl",2.5,2.89560498224525],
["1hwg",2.5,3.08312907706546],
["1o9b",2.5,3.40950123673889],
["2gh1",2.5,2.71831619004266],
["1w0y",2.5,2.67390701353912],
["1diz",2.5,2.94763941487177],
["1ji5",2.5,3.44605708368411],
["1fx3",2.5,3.44018311108656],
["1yvf",2.5,2.80261918993755],
["1bvn",2.5,3.58075882434892],
["1zc4",2.5,2.80798908594532],
["1luj",2.5,2.54935834966189],
["1v35",2.5,2.51178155248326],
["1ye0",2.5,2.97398892498219],
["1gli",2.5,2.24797934333614],
["1b86",2.5,3.4065556991278],
["1kht",2.5,2.52107232731791],
["1wqv",2.5,2.51706733068804],
["1xxv",2.5,2.31701927632778],
["1nnu",2.5,2.77623397217341],
["2seb",2.5,2.76065787027737],
["1gwv",2.5,2.42765886861552],
["1nwi",2.5,1.91246692849494],
["2aqx",2.5,2.96314981716821],
["1di1",2.5,2.48038009070377],
["1rd3",2.5,2.96791880023556],
["1ch4",2.5,2.54402329017851],
["1toq",2.5,2.47522769022142],
["1f9w",2.5,4.17248964095248],
["1dfj",2.5,3.15560125828961],
["1lsj",2.5,2.51080099864600],
["1ybh",2.5,2.18837370415813],
["1e7e",2.5,3.39051777963881],
["1bj5",2.5,3.38073698383903],
["2bxi",2.5,2.80650117624699],
["1e7g",2.5,3.40559644240601],
["2bxm",2.5,2.9080169000531],
["1d2g",2.5,3.40504302093117],
["1d2c",2.5,3.49066692636133],
["1bhj",2.5,3.78955311264922],
["1h9z",2.5,2.95826046410858],
["1ha2",2.5,2.93986982178455],
["1dlc",2.5,2.55867752810884],
["1tmq",2.5,2.7344670608572],
["1j4s",2.5,3.77335770866622],
["1cwu",2.5,2.96130556472704],
["1gv0",2.5,2.77597416132336],
["1sm4",2.5,2.86875901844932],
["1qg0",2.5,2.93011600011834],
["1fuu",2.5,3.12533809802497],
["1ku6",2.5,3.00519031271563],
["1u7w",2.5,3.16814944612291],
["1t3h",2.5,2.76075407159264],
["1krr",2.5,3.18091195985332],
["1mas",2.5,3.8211328922069],
["2ajp",2.5,2.18008889826772],
["1n3e",2.5,3.15061347090509],
["1euu",2.5,3.06966259979919],
["1eut",2.5,3.36040525600534],
["1e2p",2.5,2.62369771764263],
["1sda",2.5,2.81325307499199],
["1fo0",2.5,3.07903136699553],
["1rxv",2.5,2.86858213160308],
["1pi6",2.5,3.17429003447493],
["1t5x",2.5,2.52174091020779],
["1sdy",2.5,2.76653136905718],
["1e2j",2.5,2.61441532316168],
["1a14",2.5,3.34157088938652],
["2f6k",2.5,2.19119937349478],
["1uk4",2.5,3.180824768647],
["1kk6",2.5,2.90645996849502],
["2a19",2.5,2.86904542519439],
["4atj",2.5,2.29136724689671],
["1qhg",2.5,3.22207229444048],
["1pjr",2.5,2.89941223468723],
["1qhh",2.5,2.86651582334929],
["1wwl",2.5,3.22533202652675],
["1kps",2.5,3.14216096593094],
["1t5c",2.5,3.63034913783038],
["4ts1",2.5,2.70840834996989],
["1lth",2.5,3.26871567909246],
["1tco",2.5,3.29254689634287],
["1u26",2.5,3.1643742738197],
["1hjr",2.5,3.94084450995122],
["2bv3",2.5,2.81789554663449],
["2a2u",2.5,2.82145864786294],
["1fbp",2.5,2.82970396727983],
["1f9o",2.5,2.08047993355320],
["1szm",2.5,2.69757273579049],
["1fbh",2.5,2.50393107073852],
["2fgd",2.5,3.02522536050996],
["1ckn",2.5,2.78411878220566],
["1tcc",2.5,2.08105913171872],
["1fj9",2.5,2.69324533100115],
["1ckm",2.5,2.41579424056166],
["1e3p",2.5,2.66293664956285],
["1u4q",2.5,3.07079508950739],
["1rcw",2.5,2.17797724838576],
["1afs",2.5,2.3269203191337],
["1wnf",2.5,3.14591586310795],
["3crx",2.5,3.68257845405484],
["1g6o",2.5,2.60482321301921],
["1oyv",2.5,2.77636618395161],
["1xkj",2.5,2.14023169218436],
["2tsy",2.5,2.91193931297123],
["1zh8",2.5,1.79537106786065],
["1kmp",2.5,3.19029317284476],
["1yj6",2.5,2.61719152603436],
["1ho3",2.5,2.81624768079020],
["11as",2.5,3.51122036356797],
["1yvv",2.5,2.73988634470318],
["1ips",2.5,2.33058491661871],
["2fl6",2.5,2.45878065220619],
["2fl2",2.5,2.38625154058601],
["1yrs",2.5,2.85895634598048],
["1jm6",2.5,3.49737109595545],
["1dc3",2.5,3.20880023278425],
["1dc4",2.5,3.59306785729823],
["1p5c",2.5,2.3333241645675],
["1kb5",2.5,3.97227409229137],
["1qs8",2.5,2.29720051624721],
["1pff",2.5,2.10357502148468],
["1pnz",2.5,2.57862302016637],
["1hdg",2.5,2.70489286838917],
["1g0d",2.5,3.52371123867842],
["1phj",2.5,2.86638560154017],
["2aj9",2.5,3.15329738821467],
["4mdh",2.5,3.80993780395415],
["1bjt",2.5,2.86693425413349],
["1jw0",2.5,2.20897828881929],
["1lya",2.5,2.68185524994138],
["1aih",2.5,3.04071381626516],
["1czw",2.5,1.71959601233126],
["1rcu",2.5,3.05557195515872],
["1ph9",2.5,2.43621663663311],
["1gp9",2.5,3.44125937339027],
["1lyb",2.5,2.80839142549024],
["1ztp",2.5,2.07441903332734],
["1an9",2.5,2.87404118814344],
["1evi",2.5,3.11087073151865],
["1ve9",2.5,3.35906628545352],
["1rnr",2.5,2.36483059782253],
["1mrr",2.5,2.39650579724637],
["1n6m",2.5,3.66459103687213],
["1cyg",2.5,3.43571522661376],
["1keh",2.5,2.46540370976302],
["9cgt",2.5,2.16220790079993],
["5cgt",2.5,2.59017552355943],
["1cgu",2.5,3.11015578013216],
["4otb",2.5,2.64156292159054],
["1tw2",2.5,2.71026350937884],
["1cgv",2.5,2.50408817459076],
["1cgy",2.5,2.7230940476499],
["2cxg",2.5,2.93335025718731],
["1jdu",2.5,2.32457455311461],
["1gc8",2.5,2.63405425424981],
["1l7c",2.5,2.70727664677101],
["1sqy",2.5,2.96139467196906],
["2f4n",2.5,3.10453962545060],
["1pr5",2.5,2.93403023650155],
["1wpq",2.5,2.59411768406318],
["2fys",2.5,3.63250613065587],
["1nlm",2.5,3.06785793498123],
["1w22",2.5,3.39382176073234],
["1cs4",2.5,1.96555163705805],
["1ixy",2.5,2.57998574438014],
["1sxp",2.5,2.90199088851194],
["1jfa",2.5,2.54555464820503],
["1yyr",2.5,2.33682334397698],
["2ael",2.5,2.22204321669340],
["1z26",2.5,3.16530315286027],
["2fcp",2.5,3.0799085612789],
["1tb6",2.5,3.05068341627065],
["1jfg",2.5,2.42728424025181],
["1pk7",2.5,2.84063326913877],
["1w62",2.5,2.36838874242790],
["1f9c",2.5,2.84438518686536],
["1s5c",2.5,2.06151112478073],
["1yqx",2.5,2.81668399145767],
["1fr6",2.5,3.61283291140810],
["1t47",2.5,2.4492827222503],
["2thi",2.5,1.86953693659636],
["1o12",2.5,2.8495208712107],
["1ekp",2.5,3.03013713728812],
["1qaw",2.5,2.72432821416229],
["1htl",2.5,2.88068843545220],
["2pol",2.5,3.04077611006978],
["2csl",2.5,2.81580820686276],
["1pvh",2.5,3.14376335268059],
["1rlr",2.5,3.35535536605066],
["1qm6",2.5,2.01295078601533],
["1pcx",2.5,2.71381771328034],
["1to6",2.5,3.13730754724149],
["1hdx",2.5,2.71497592375058],
["1hdy",2.5,2.79915861774671],
["1hso",2.5,2.63646693571497],
["1ixx",2.5,2.84016303355584],
["1r5v",2.5,2.45495182885539],
["1miq",2.5,2.94894595381651],
["1e3l",2.5,2.85261061785379],
["2cv5",2.5,2.77628412018657],
["1pnm",2.5,2.44200956968093],
["1pnl",2.5,2.49763900427107],
["1cp9",2.5,2.4240796883453],
["1e2z",2.5,2.67731332989005],
["1b0k",2.5,2.6014501729028],
["1b0j",2.5,2.61560247109358],
["1b0m",2.5,3.00509066490999],
["6acn",2.5,2.81149268648345],
["2a9f",2.5,3.67065328425587],
["1hhi",2.5,2.42043313553128],
["1b0g",2.5,2.54790485206458],
["1hhk",2.5,1.85623296182476],
["1hhj",2.5,2.51727227285334],
["1h6a",2.5,2.77740124705683],
["1ai7",2.5,2.41622223568748],
["1ef2",2.5,2.34837354976814],
["1gck",2.5,2.99187786255602],
["1krb",2.5,2.1925681432422],
["1krc",2.5,2.31715765071649],
["1a5o",2.5,2.39996517009219],
["1buc",2.5,2.77158832180176],
["1jcn",2.5,3.35365248789208],
["1dg1",2.5,2.4107367427273],
["1khu",2.5,3.28333396617227],
["1ono",2.5,3.17054822634038],
["1ur0",2.5,2.78582239209681],
["1tgo",2.5,2.87999833120417],
["2ay9",2.5,2.79643057725845],
["1ay5",2.5,2.82105852122404],
["3dmr",2.5,2.07561075308176],
["1kbj",2.5,2.49501290101509],
["2b8q",2.5,2.63172860445859],
["1esq",2.5,2.73861796324793],
["2ax4",2.5,2.56156911127499],
["5xia",2.5,2.18051960071262],
["1xlh",2.5,2.12509574158808],
["1did",2.5,2.12214417058618],
["1xld",2.5,2.23696215644497],
["1xlf",2.5,2.25267761830562],
["1xlj",2.5,2.29328651441720],
["1xlb",2.5,2.18895766152774],
["1xlc",2.5,2.15567177898757],
["1xlg",2.5,2.26709813571610],
["1xll",2.5,2.42378950684408],
["1xlk",2.5,2.40463937325775],
["1xli",2.5,2.29289400688490],
["1xle",2.5,2.28059291710857],
["1die",2.5,2.43649910165990],
["1nhe",2.5,3.03653944995766],
["1vdd",2.5,3.41220778229281],
["1gn4",2.5,3.10745785095728],
["1pb6",2.5,2.98534287073843],
["1xmr",2.5,2.68189738888021],
["1lot",2.5,2.96368907039796],
["1asn",2.5,3.19300635854764],
["1ahg",2.5,4.02917344851528],
["1tk8",2.5,2.48961036007640],
["1g99",2.5,2.14253027401787],
["1tmo",2.5,2.38080821929234],
["1tuu",2.5,2.74318989985780],
["1nd2",2.5,2.37814270911715],
["1ncq",2.5,3.02963289727404],
["1e5d",2.5,3.01857796843392],
["1bd2",2.5,3.10447814101161],
["1p6n",2.5,2.91961321963579],
["1b5t",2.5,2.1528115743442],
["1kby",2.5,2.82014182274783],
["2bns",2.5,2.23200255503512],
["1yf0",2.5,2.46379587426978],
["2ap6",2.5,1.90951481587824],
["1vix",2.5,2.47503727160201],
["1yep",2.5,2.44305195547766],
["1mi5",2.5,2.95623223082689],
["1rg5",2.5,1.83293650535276],
["1npb",2.5,2.54245769485437],
["1nca",2.5,2.99198312209749],
["1ncb",2.5,3.2482762737617],
["1ncc",2.5,3.44522105051632],
["1ile",2.5,3.76691891981868],
["1bw0",2.5,2.1007419385981],
["1ybe",2.5,2.99832880900628],
["1ytu",2.5,2.92832903997346],
["1ufq",2.5,2.73342909959740],
["1a2k",2.5,2.81201489756796],
["1t6b",2.5,2.95965466378246],
["1zvl",2.5,3.2990573422324],
["1e8w",2.5,3.51650557755182],
["1sry",2.5,2.79279049142455],
["1ses",2.5,2.79448139197691],
["1xf4",2.5,2.86160122004384],
["1kzy",2.5,3.13058495934561],
["1xzw",2.5,2.92585627244688],
["1nxg",2.5,3.20325242110575],
["1t75",2.5,2.56344640422975],
["1u1z",2.5,2.92513345062007],
["4gsa",2.5,2.81202265608339],
["1p5r",2.5,2.86549087311555],
["1w47",2.5,2.80105991739988],
["2gm8",2.5,2.43202492113131],
["1cic",2.5,3.28564711907114],
["1aja",2.5,2.69272335717554],
["1adi",2.5,3.38966100359426],
["1ad0",2.5,2.32225220668430],
["1igj",2.5,3.31257329579655],
["1wcb",2.5,3.13968502321669],
["1t4k",2.5,3.23469882518479],
["2ab6",2.5,2.15961968881936],
["1ww8",2.5,2.34963621030703],
["1eqz",2.5,3.29767802976017],
["1b4a",2.5,3.37132097267976],
["2dik",2.5,3.96941678549387],
["1fvd",2.5,3.1903684457105],
["1yak",2.5,2.88498794520059],
["1njt",2.5,2.92640004306500],
["1a3g",2.5,3.5708325974452],
["1jls",2.5,3.70394440666477],
["1r4w",2.5,2.98469991444048],
["1zgr",2.5,2.83605384473924],
["1lwj",2.5,3.08332156717643],
["1we1",2.5,3.03574400861031],
["1p30",2.5,2.48198015915206],
["1kfu",2.5,3.88777228672834],
["1zgs",2.5,2.81593052724637],
["1wyz",2.5,3.21936191950763],
["5tsw",2.5,3.43192966642143],
["1khl",2.5,2.59351661574046],
["1khk",2.5,2.60752133424746],
["1kh9",2.5,2.38879906654964],
["1alh",2.5,2.05456204665071],
["1ani",2.5,2.37179385205736],
["1upu",2.5,3.50422079802336],
["1ajc",2.5,3.03589752496948],
["2fb1",2.5,2.85712412622242],
["1e8t",2.5,2.9038616217556],
["1ajb",2.5,2.40690884579969],
["1ajd",2.5,3.18083933114951],
["1dv2",2.5,3.53200615944112],
["1q1j",2.5,2.57510902431524],
["1za2",2.5,3.03629663423349],
["1bdf",2.5,3.43684970837189],
["1ep4",2.5,3.52336503778821],
["1enq",2.5,3.09061474645977],
["1g1u",2.5,3.19473186250578],
["2tpl",2.5,2.57522875561057],
["8atc",2.5,3.12953309684767],
["1l0y",2.5,2.7872829899687],
["1rai",2.5,3.16942249535092],
["1fk9",2.5,3.30407853107732],
["1gc1",2.5,3.60113948088801],
["1hm8",2.5,3.02646997369692],
["1rad",2.5,3.19877961978948],
["1rah",2.5,3.19145552032186],
["1rae",2.5,3.20032726820425],
["1raf",2.5,3.2024422963991],
["1raa",2.5,3.20855390716454],
["1rac",2.5,3.2433770567475],
["1rab",2.5,3.21128731897718],
["1rag",2.5,3.20262305961390],
["1ibv",2.5,2.81775409354405],
["1qgk",2.5,2.96861740101977],
["1eix",2.5,2.97836347126455],
["1pya",2.5,2.63675015297317],
["1k0c",2.5,2.73392237267818],
["1j3u",2.5,3.09299501225575],
["2tep",2.5,2.21848525904419],
["1v6l",2.5,2.38132282407641],
["1rvu",2.5,2.58412116203515],
["2bto",2.5,2.6739066684147],
["1u25",2.5,3.38841664518127],
["1o5i",2.5,2.64304860251104],
["1bq4",2.5,3.14022266438453],
["4pbg",2.5,2.97901877586328],
["1p8p",2.5,2.87037292599310],
["1ta1",2.5,2.66067039579004],
["1ewj",2.5,3.37574624981166],
["1jkh",2.5,3.41164579743914],
["1c1b",2.5,3.01694156811929],
["1wbl",2.5,3.06817444980664],
["1c1c",2.5,3.34578702534512],
["1jla",2.5,3.23588225286891],
["1np0",2.5,1.5785472942224],
["1h21",2.5,2.44457012404056],
["1z6l",2.5,3.21760819435995],
["1xef",2.5,2.35184765296929],
["1znp",2.5,3.03878241623922],
["2fxr",2.5,2.82144300910026],
["2fs8",2.5,2.83840107380270],
["1k0b",2.5,2.72799854416648],
["1vm8",2.5,2.52923054684733],
["1j0a",2.5,3.29752284605232],
["1txk",2.5,2.71695039813172],
["1g6w",2.5,2.80346326064139],
["1xhv",2.5,3.04246044537237],
["1w18",2.5,2.85326460613894],
["1e1e",2.5,3.24907326731024],
["1v26",2.5,1.98339698602595],
["1khv",2.5,2.91892684423591],
["1tx3",2.5,2.93149873492554],
["1e6r",2.5,2.27080062980760],
["2c66",2.5,2.28650738790959],
["2f61",2.5,2.64650029960378],
["8cat",2.5,3.77805705466536],
["1nia",2.5,2.29956044801432],
["2cv9",2.5,3.11588581761283],
["1omw",2.5,3.07407392014414],
["1d0j",2.5,2.96726132879382],
["1jey",2.5,2.52995424105756],
["1ug9",2.5,2.97748785285758],
["1b09",2.5,3.43986029183355],
["1b7y",2.5,3.66764154096317],
["1b7t",2.5,3.88690569233447],
["1q3h",2.5,2.53124765023414],
["1hcm",2.5,2.34962112981592],
["1xcg",2.5,2.95815194919882],
["1brm",2.5,3.16652315327345],
["2c0p",2.5,2.50093950625086],
["2c0q",2.5,2.58353644106702],
["1djh",2.5,3.24185596545364],
["1dji",2.5,3.1752393403673],
["2isd",2.5,3.21132240936398],
["2f73",2.5,3.37235398778879],
["1du4",2.5,2.75809433737681],
["1un8",2.5,2.86299689542131],
["1yhm",2.5,2.67239627467098],
["2f4l",2.5,2.06705472654513],
["1dxo",2.5,2.96699371736252],
["1gg5",2.5,2.9554318061998],
["1h25",2.5,3.3020521298613],
["1mox",2.5,3.18149925300289],
["1jvf",2.5,3.02681299980164],
["1vao",2.5,3.14579135442246],
["1eg7",2.5,3.42739778313498],
["2fdp",2.5,2.14459469850021],
["1e9h",2.5,3.38399431514728],
["1h1q",2.5,3.51389391947615],
["1h24",2.5,3.35905728340272],
["1k7l",2.5,3.57547043717602],
["1dqr",2.5,3.12079364113347],
["1n8t",2.5,2.71337678364809],
["1th1",2.5,1.96376734164866],
["1rld",2.5,3.37200923056181],
["1xmm",2.5,2.33060308385719],
["1lqf",2.5,3.19689482991987],
["1to0",2.5,3.00185288275607],
["1poi",2.5,2.97694629023159],
["1it8",2.5,3.20764315052627],
["1ao6",2.5,2.92492396334149],
["1bm0",2.5,3.12518765723933],
["1iz1",2.5,2.50641539192696],
["1pow",2.5,1.49486394212878],
["1dii",2.5,2.10405609333464],
["1q6x",2.5,2.32913882407654],
["1mda",2.5,4.16163545344311],
["1oz0",2.5,3.00217381088867],
["1k5h",2.5,3.13549263029760],
["1gv1",2.5,3.04334235713861],
["1dm0",2.5,3.62507054178262],
["1zi7",2.5,2.63717883902089],
["1oat",2.5,2.74616742477727],
["1xjg",2.5,3.03378777725029],
["1fiq",2.5,2.71955669831730],
["1esm",2.5,3.51328779596906],
["1r4q",2.5,3.04449164878945],
["1nmc",2.5,2.72777442266088],
["1cjy",2.5,3.17060175165172],
["1ms0",2.5,2.50168941797406],
["1ie3",2.5,2.7120067148511],
["1ezr",2.5,3.42819388415616],
["1qyd",2.5,3.58388933792491],
["1muk",2.5,2.77196657081505],
["1mwh",2.5,2.98467513052462],
["4fbp",2.5,2.65960781582259],
["1n35",2.5,2.80070466783997],
["1k9i",2.5,2.76864346387966],
["2b81",2.5,2.50682047120423],
["1d7a",2.5,1.78217069113648],
["1iw8",2.5,2.57528733387378],
["1efu",2.5,2.62215330561215],
["1i1e",2.5,2.6213875440048],
["1cu1",2.5,3.27655588951594],
["1rqx",2.5,2.30386391128944],
["1cer",2.5,2.80385704122088],
["2pva",2.5,3.07138638637501],
["1cli",2.5,2.91587400758629],
["1znq",2.5,2.56843326087455],
["2b4t",2.5,2.13310799112898],
["1hi8",2.5,3.53296217598798],
["4dbv",2.5,2.34071050928445],
["1dbv",2.5,2.44395418681297],
["2gd1",2.5,2.80775026377621],
["1f76",2.5,2.52698999479296],
["1gk0",2.5,2.46497326741919],
["1scu",2.5,4.41545401974274],
["1r3h",2.5,4.05151474679595],
["1lrw",2.5,3.05124961818161],
["1x9y",2.5,2.71947344712209],
["1xdp",2.5,3.20989954548857],
["1kqo",2.5,2.80318700774672],
["1uyr",2.5,2.9739962825589],
["1zcc",2.5,3.24666457259868],
["1b6s",2.5,3.32559222966083],
["1qrk",2.5,3.27774809389682],
["1ggy",2.5,3.27567741634577],
["1ykf",2.5,2.34028336020963],
["1fie",2.5,3.33661725469798],
["2ggj",2.5,2.44503372189788],
["1nwt",2.5,2.4362995944989],
["1rvt",2.5,2.97566414698098],
["1rv0",2.5,3.11218506610178],
["1n1m",2.5,3.25322791948627],
["1nu8",2.5,3.19967609440462],
["1d0n",2.5,3.09532939955544],
["1olp",2.5,2.24018123582784],
["1g7y",2.5,2.93845624727972],
["1f6d",2.5,3.0248376095017],
["1d1s",2.5,2.47351283541580],
["1gtn",2.5,2.36142764487463],
["1sj9",2.5,4.0049711748899],
["1axg",2.5,2.67913139972224],
["1lde",2.5,2.36909004545367],
["1ldy",2.5,2.47004281486421],
["2awa",2.5,1.77529135978306],
["1umy",2.5,3.56407269394159],
["1k3f",2.5,4.019094328995],
["1sos",2.5,2.73728275742779],
["1rg9",2.5,3.58503415788453],
["1p7l",2.5,3.63197947719766],
["1wbb",2.5,2.34723024079180],
["1z6z",2.5,1.68926075976830],
["1dub",2.5,2.43297884528961],
["1wuu",2.5,3.89478380263694],
["1cg2",2.5,2.02370134804061],
["1jpw",2.5,3.32254761863261],
["6xim",2.5,2.08635376980297],
["1r8w",2.5,2.46507759873649],
["1jnz",2.5,2.1971459628485],
["1lnu",2.5,3.80931796432742],
["2aw5",2.5,2.53932904070991],
["2aci",2.5,3.43804964974127],
["1dv3",2.5,2.42108510078579],
["1dv6",2.5,2.50613221807453],
["1ds8",2.5,2.48649094066153],
["1oqe",2.5,3.39030655649937],
["13pk",2.5,3.05689934848170],
["1eoh",2.5,2.99284434425007],
["1pg7",2.5,2.59781981878106],
["1mmf",2.5,3.22969680918589],
["1m2o",2.5,2.97855055941401],
["1vdm",2.5,2.58163470977264],
["2c4u",2.5,2.30854655762638],
["1a0c",2.5,2.12986960579165],
["1gu6",2.5,2.82398001853174],
["1pku",2.5,3.039569398895],
["5cev",2.5,2.17103579980297],
["1i0a",2.5,2.56373379554386],
["1auw",2.5,2.35159946075748],
["1w0m",2.5,2.76397825118084],
["1u15",2.5,2.66532243481694],
["1gz0",2.5,3.07523317539809],
["1knx",2.5,2.90052217479700],
["1m3e",2.5,2.85139187302688],
["1qi6",2.5,1.98481592506710],
["1t90",2.5,2.8175574412728],
["1g63",2.5,2.68051728775],
["1i4k",2.5,2.94610949869256],
["1ofh",2.5,3.21429959104025],
["1y5l",2.5,2.58281922089855],
["1ecj",2.5,2.55581908192954],
["1y5n",2.5,2.66539073138032],
["1ekm",2.5,2.74247571730383],
["1fp4",2.5,2.54946479798427],
["1v4g",2.5,2.50082257947855],
["1eyy",2.5,1.74738668497928],
["1uyt",2.5,3.01918953076267],
["1uv6",2.5,2.25784214216582],
["1uij",2.5,3.37474595951964],
["1p84",2.5,2.83712633786445],
["1wdk",2.5,2.70619536579293],
["1jb0",2.5,2.90275543123035],
["2gb3",2.5,1.40401085357630],
["2fjc",2.5,2.69281690820048],
["1bvu",2.5,3.76137651661825],
["1smk",2.5,2.51894155930095],
["1ldn",2.5,3.93600164763304],
["1pd5",2.5,3.28015305766400],
["1k9a",2.5,3.11556595227287],
["1vg9",2.5,2.84585422378322],
["2req",2.5,2.53488109105274],
["1rfm",2.5,2.85703228915768],
["2bm8",2.5,2.52655001219870],
["1jof",2.5,2.68197318850654],
["2buc",2.5,2.56989483254534],
["1e1r",2.5,2.81858743029493],
["1c7o",2.5,2.54585389600104],
["2ak4",2.5,2.07767389674189],
["1noi",2.5,3.24929127668103],
["1fui",2.5,2.46260238831792],
["1hr6",2.5,2.65070453982495],
["1vq7",2.5,2.87761182514604],
["1l2a",2.5,2.42120856968082],
["1e9s",2.5,2.9443386371176],
["1gyt",2.5,2.65459298310921],
["1qo5",2.5,3.53535089036429],
["2a68",2.5,4.12477742965083],
["2a69",2.5,4.14357113296441],
["1w4c",2.5,2.79087975953898],
["1gho",2.5,2.94774791984232],
["1f49",2.5,2.9537023345654],
["1bgl",2.5,3.7734118056332],
["1bgm",2.5,3.95366147627612],
["1gq2",2.5,2.9459652612634],
["1y8g",2.5,2.79974205104617],
["1txt",2.5,2.80725267448981],
["1x8s",2.5,2.22953376339504],
["2a9b",2.5,2.21276050376476],
["1xi8",2.5,2.00462614176668],
["2a9c",2.51,2.07004118058565],
["2ffm",2.51,2.54699454037609],
["1pub",2.51,3.17512940111074],
["1du7",2.51,2.89281916100095],
["1rhu",2.51,2.24623573652005],
["1pc6",2.51,3.16488834841248],
["1w2a",2.51,2.49476986682839],
["1okz",2.51,2.55628571148536],
["1pf8",2.51,2.85592429428053],
["1vev",2.51,2.67053935375146],
["1ddi",2.51,3.15608918781342],
["1jhk",2.51,2.54203671074877],
["1l8l",2.51,4.18340097713843],
["1nuh",2.51,2.54483765025141],
["1wc6",2.51,3.79457754831701],
["1ycn",2.51,2.34822062909668],
["1w45",2.51,2.81236177595584],
["1ggq",2.51,2.4126830215049],
["1ph1",2.51,2.57809930166471],
["1nvd",2.51,2.68615834559657],
["2b7p",2.51,3.2697929007544],
["1v7m",2.51,3.49067003165732],
["1y7o",2.51,2.39593160093496],
["1zxn",2.51,2.97002555099752],
["1ots",2.51,3.18159561418864],
["1h29",2.51,2.94597179778846],
["1pzv",2.52,3.21309773676058],
["1sbd",2.52,3.36638866729108],
["1vpy",2.52,2.17638665867901],
["1ilg",2.52,2.86472335131194],
["1y6k",2.52,3.05855699963973],
["1yu3",2.52,1.70393855513822],
["2fbe",2.52,3.25902124149767],
["1zkx",2.52,2.92951425048053],
["1c0u",2.52,3.25791496180961],
["1n8z",2.52,3.27544015199365],
["1szu",2.52,2.21548669939282],
["1szk",2.52,2.48873677603464],
["1ji4",2.52,2.93853899852854],
["1usy",2.52,3.61920499038355],
["1y7h",2.52,3.00486450006239],
["1914",2.53,3.30735752987298],
["1e49",2.53,2.72100990282796],
["1si5",2.53,3.03862353365938],
["1wg0",2.53,2.56724139283584],
["1pxm",2.53,3.03352377345619],
["2cx8",2.53,2.83057668914099],
["2aeh",2.53,2.88864915761334],
["2b8n",2.53,1.77854900614572],
["1c0m",2.53,3.03633081912086],
["1fcd",2.53,3.73362458726911],
["1xs4",2.53,2.07320282463733],
["1rf1",2.53,2.93597394538837],
["1zmc",2.53,2.42600577943899],
["1gzy",2.54,3.61950059928354],
["1dxs",2.54,3.18278245115954],
["1ex9",2.54,2.04531952444976],
["2b2l",2.54,3.13592445523879],
["2fxk",2.54,2.80831097250046],
["1e7m",2.54,2.42419610823313],
["2f9b",2.54,3.18190427214363],
["1p9s",2.54,3.10345648670619],
["1o67",2.54,2.49298892874651],
["1jt6",2.54,3.22712076614003],
["2bjh",2.54,3.23445238914386],
["1t8e",2.54,2.81256130879172],
["1tyh",2.54,3.24169626571879],
["2b3x",2.54,2.4062932291747],
["1qvi",2.54,3.10516910376390],
["1qx5",2.54,3.56343378110825],
["1yko",2.54,1.84762717982775],
["2frv",2.54,2.84289907276818],
["1dd5",2.55,2.94402555060675],
["1p04",2.55,2.55534547818254],
["1e46",2.55,3.15204820918223],
["1kdq",2.55,3.59896710599444],
["2a7q",2.55,3.00299490463763],
["2bbo",2.55,2.37963928505382],
["2b8p",2.55,2.962688069504],
["2a3k",2.55,2.32286062767584],
["2bil",2.55,1.91264806263926],
["1yvj",2.55,3.12591901365409],
["2aze",2.55,2.88870885181884],
["1wa6",2.55,2.80738588028052],
["1vdr",2.55,3.17542136514248],
["1drg",2.55,3.51423788134901],
["1vfx",2.55,3.99470639163329],
["1lik",2.55,3.76182311061265],
["10mh",2.55,2.34773188983634],
["1zkf",2.55,2.22324960915883],
["1hjq",2.55,2.68543952197213],
["1j4j",2.55,2.38138781044464],
["1jh9",2.55,4.0419091301039],
["2c2r",2.55,3.465489768996],
["1qr4",2.55,2.91771430055731],
["1hkm",2.55,2.79094144035621],
["1hki",2.55,3.02359689985458],
["1w51",2.55,3.14517794193641],
["2cii",2.55,2.71051424221594],
["2c5w",2.55,2.66239400208151],
["1son",2.55,2.41711211455566],
["2gtu",2.55,2.76156095834705],
["1hi6",2.55,3.16142355412004],
["1yeh",2.55,2.9479780718523],
["2bmu",2.55,2.79009288628127],
["1a8t",2.55,4.14672814525404],
["1nj1",2.55,2.77244730670350],
["1cf5",2.55,3.68654761714662],
["1uxp",2.55,2.74922088891535],
["1m0i",2.55,2.72033396013792],
["1vdz",2.55,3.37314084356272],
["2btf",2.55,3.27385556443092],
["1x7p",2.55,2.65150914652669],
["1kfv",2.55,3.13213045869102],
["1tqb",2.55,3.0342154510194],
["2bvm",2.55,2.35516410079865],
["1r74",2.55,2.96399724696419],
["1cy4",2.55,2.64514032569495],
["1irm",2.55,4.09815341467196],
["1ll1",2.55,2.55733218647831],
["1iew",2.55,2.53900532833832],
["1sev",2.55,2.61504118829907],
["1y2j",2.55,2.67321620046294],
["1u75",2.55,2.98970772929222],
["1u1h",2.55,3.29064251646988],
["1ai6",2.55,2.53887090191892],
["1ed3",2.55,3.06491177065072],
["1k2s",2.55,2.94371199479969],
["1m3x",2.55,2.18979537365925],
["1j5q",2.55,3.53527315935262],
["1j7e",2.55,2.53932256424035],
["1ya0",2.55,3.05244196290913],
["1tu0",2.55,3.87414995118856],
["1og5",2.55,3.04932172303029],
["1rt2",2.55,3.49595886386342],
["1rt1",2.55,3.19961115724418],
["1awt",2.55,3.34803842356261],
["2bfp",2.55,2.29786639722245],
["1ult",2.55,2.43523095990132],
["1r0y",2.55,3.06480913742163],
["1kzh",2.55,2.45271038596518],
["1w1k",2.55,2.88443956329625],
["1p4r",2.55,2.68739487485512],
["1l5a",2.55,2.82987586411603],
["1xdq",2.55,3.01537755186267],
["1p0y",2.55,3.0850759778096],
["2b05",2.55,1.88656950198309],
["1sfy",2.55,2.79235483485541],
["1y1s",2.55,3.06632060647132],
["1wxw",2.55,2.89002048800777],
["1h31",2.55,2.47359322768281],
["1tyq",2.55,2.79021575430947],
["1nsi",2.55,2.67123586697921],
["1u2v",2.55,2.67034082762483],
["1uwi",2.55,2.60611919796869],
["1n3s",2.55,2.59785796631195],
["1up6",2.55,2.49918030692541],
["1hr7",2.55,2.60973204562316],
["1s64",2.55,2.40309474186949],
["1v0f",2.55,2.78322420209718],
["1b01",2.56,3.62692243086368],
["3blg",2.56,2.98706708200448],
["1gtd",2.56,2.68611968653659],
["1a7h",2.56,2.45836293765911],
["1ys9",2.56,2.76500998615704],
["1l8k",2.56,3.22452188645502],
["1dsg",2.56,2.76906468369331],
["1xwr",2.56,3.2715000134758],
["2c22",2.56,2.96245084601912],
["1gkw",2.56,2.50029810925431],
["1j90",2.56,2.99595985387311],
["1u8n",2.56,2.69476294245766],
["1tpx",2.56,2.98441664045218],
["1a47",2.56,2.96944422291953],
["1m9r",2.56,2.20142887688929],
["1wp1",2.56,2.51256682562975],
["2bua",2.56,2.67207450325732],
["2ajd",2.56,3.2179617071692],
["1mms",2.57,3.58247302105784],
["1xp3",2.57,3.04725790655864],
["1ur3",2.57,3.03755950929125],
["2c2d",2.57,3.46318873076804],
["2bkw",2.57,3.04218636078739],
["1g5q",2.57,2.34954719772400],
["1ayp",2.57,3.24798014187089],
["1nak",2.57,2.9923449143701],
["1nks",2.57,3.15240392462815],
["2g5w",2.58,1.8263215629602],
["1f3h",2.58,3.93833296884863],
["1w3f",2.58,3.34556568204823],
["1n3u",2.58,2.28547000616672],
["1xq9",2.58,2.94728485179826],
["1nve",2.58,2.80628449738670],
["2ag1",2.58,2.7679253750173],
["2ag0",2.58,2.32773976151785],
["2ab1",2.59,2.06299686812233],
["2flc",2.59,3.45897056662287],
["1umo",2.59,2.82055539348924],
["1utb",2.59,2.54710140795738],
["1peg",2.59,4.05841996049498],
["2hlp",2.59,2.83280894603504],
["1xjl",2.59,2.54487785053191],
["1gaq",2.59,3.23138287385707],
["2evv",2.59,2.81762988900378],
["1asp",2.59,2.25146996752353],
["1t9a",2.59,2.00855109823757],
["1cb5",2.59,2.30370844586717],
["2br4",2.59,2.43021483932706],
["1xpg",2.59,2.60495602734729],
["1gw5",2.59,3.29024650691498],
["1zy8",2.59,3.66733857773909],
["2ce3",2.6,2.71496550470126],
["1uue",2.6,3.05795247414959],
["9msi",2.6,1.95484702515888],
["8msi",2.6,2.19361383110172],
["1baj",2.6,2.42853104139831],
["1a43",2.6,2.36949448789886],
["1dt4",2.6,2.71004753332061],
["1swi",2.6,4.3010930387867],
["1ycr",2.6,2.94967740308569],
["1fb7",2.6,2.59377089482420],
["1ci6",2.6,2.04179241884101],
["1pd3",2.6,2.60117951807608],
["1byw",2.6,2.56954873633013],
["1p65",2.6,2.65738263489800],
["1tsj",2.6,3.30785356969524],
["1env",2.6,2.56611210543844],
["1a6f",2.6,3.75163812133879],
["1cd8",2.6,2.81159573888038],
["1dp9",2.6,2.88680239380252],
["1si2",2.6,2.74825659174033],
["1si3",2.6,3.11475115648761],
["1oz6",2.6,3.27996660018139],
["1stp",2.6,2.70777329837877],
["1un5",2.6,2.13168286623457],
["1b6e",2.6,4.17472269113525],
["1zm6",2.6,3.15327809404367],
["1t37",2.6,3.3784056994879],
["1maf",2.6,2.96795173182481],
["2fhi",2.6,3.17981807115029],
["6fit",2.6,3.01561331765142],
["1o2e",2.6,2.50316788954078],
["1n29",2.6,3.27677705675231],
["1p2p",2.6,3.84435782332546],
["1ml8",2.6,2.35534138611994],
["1hik",2.6,3.37750474112731],
["1bh9",2.6,2.76030381612988],
["1dsy",2.6,2.82110620382306],
["2az2",2.6,2.82991488759562],
["2az0",2.6,2.54263950478525],
["1b1b",2.6,3.50122631338323],
["1t0z",2.6,2.12495542052911],
["1hst",2.6,3.01663622414998],
["1cf7",2.6,3.59071049921781],
["1div",2.6,3.58314331665275],
["1leo",2.6,3.23657307161464],
["1v8t",2.6,2.54316545809175],
["2gli",2.6,4.60660827892933],
["2pil",2.6,3.09677145299681],
["1ay2",2.6,3.12333708328693],
["1j2y",2.6,3.45551906222781],
["1wvl",2.6,3.27354372947894],
["1dre",2.6,3.89583620475553],
["2itg",2.6,4.45153127585847],
["1xyh",2.6,2.90538619678488],
["251l",2.6,3.28624141583397],
["1r0n",2.6,3.59240044404757],
["1nay",2.6,2.56039478659431],
["149l",2.6,3.43612843925116],
["170l",2.6,3.44446142090686],
["1lry",2.6,3.03843739560560],
["521p",2.6,3.35041995014884],
["2rap",2.6,2.53249068017941],
["1ahn",2.6,3.23102827667085],
["1gam",2.6,2.69625360010001],
["1pkv",2.6,2.37616544641076],
["1hrs",2.6,3.3507482437824],
["1h0x",2.6,3.24537377350224],
["1qhy",2.6,2.45228499638444],
["1iv5",2.6,3.84696450433282],
["1m5p",2.6,2.88660311515688],
["1pgz",2.6,2.99961529603106],
["1eh1",2.6,3.07987518564292],
["1ti1",2.6,3.77333668813063],
["1q3i",2.6,3.34176594106470],
["1z24",2.6,2.44010603388440],
["1t4e",2.6,2.98311089794382],
["1yq8",2.6,3.29396959670009],
["1vcy",2.6,3.0144794580607],
["1hcn",2.6,3.66922508854357],
["2bnz",2.6,2.72187431174651],
["1rq9",2.6,3.68538103377853],
["1ivq",2.6,3.62155564761473],
["2aig",2.6,2.80433095629678],
["1par",2.6,3.56299498474590],
["1rtg",2.6,2.89895251302532],
["1sto",2.6,4.08978808253622],
["1thu",2.6,4.3778935064996],
["1i1h",2.6,3.93917611557368],
["1bx9",2.6,2.48259835522873],
["1bvb",2.6,3.31243818070882],
["1yk8",2.6,2.68331524258422],
["1gt0",2.6,3.27792946064408],
["1au0",2.6,3.11336516679813],
["1au2",2.6,3.41615633077286],
["1s1g",2.6,2.92162379644811],
["1ue5",2.6,3.40937554122667],
["1m9b",2.6,1.94810142290531],
["1uru",2.6,2.39615018674342],
["1gtb",2.6,3.46472093183734],
["1qc6",2.6,3.99678803657318],
["2emo",2.6,3.75551557964219],
["2yfp",2.6,3.29409408564946],
["1x0k",2.6,2.83924560177680],
["1ixf",2.6,2.94930087386448],
["1dql",2.6,2.82981909060848],
["1cby",2.6,2.7756357611812],
["1z39",2.6,2.64398940546795],
["1z36",2.6,2.76831235107579],
["2sba",2.6,3.73268411879591],
["1o9c",2.6,2.70494087927006],
["1o9e",2.6,2.89101922853286],
["1skv",2.6,2.92942101095094],
["1hyq",2.6,3.17903315354142],
["1lrv",2.6,3.5549551159794],
["1zpc",2.6,2.60531068088168],
["2acj",2.6,2.94202268282357],
["1zqu",2.6,3.66548911312402],
["1mt0",2.6,3.17276021199054],
["2fnp",2.6,3.90318165048829],
["1dpc",2.6,2.50393038436265],
["1eaa",2.6,2.78709613615546],
["1ead",2.6,2.64343200365707],
["1eab",2.6,2.83002445039827],
["1eac",2.6,2.94916916740401],
["1v0d",2.6,3.20129103865624],
["1h2d",2.6,3.60535694763319],
["1pw6",2.6,2.58683299171034],
["1f92",2.6,2.81979667477388],
["2bml",2.6,2.98744070849764],
["1bj3",2.6,3.58890018754381],
["1hcx",2.6,2.9953646184992],
["1lu1",2.6,2.95902641305717],
["1sc1",2.6,3.02724015524893],
["1i6u",2.6,2.34271640514967],
["1bg5",2.6,4.58061522802025],
["1p8k",2.6,3.58863736780975],
["1ydf",2.6,3.01398093933879],
["1ice",2.6,2.7429496264813],
["1bnm",2.6,2.78820636445367],
["1fw2",2.6,2.93098724496880],
["1kwq",2.6,2.55884310102808],
["2a98",2.6,2.6828278800346],
["1dxm",2.6,2.44350795702069],
["1ev8",2.6,2.61929200331509],
["2c3k",2.6,3.04299098922046],
["1qri",2.6,2.82306381926523],
["1lxa",2.6,3.31390143790367],
["1k7s",2.6,2.99125373971583],
["1r6a",2.6,2.87254082511994],
["2cgv",2.6,3.29757459177574],
["1ft0",2.6,2.98273400487671],
["4tgl",2.6,3.60457969816484],
["1il4",2.6,2.77691590403372],
["2bhh",2.6,2.75161314132415],
["1av7",2.6,3.10946225635855],
["3vsb",2.6,3.14181892871542],
["1af4",2.6,3.12617957817524],
["1aod",2.6,2.35231942006468],
["1uyn",2.6,2.89411131027976],
["1xwj",2.6,3.32855846693271],
["1wvx",2.6,2.85463671980371],
["1kxu",2.6,3.4236540843254],
["1jkw",2.6,3.30515539045604],
["1ss9",2.6,2.88425202716515],
["2phk",2.6,2.75105629543642],
["1ujj",2.6,2.88942690739195],
["1iqn",2.6,3.06619282585627],
["1iqm",2.6,3.24275299629289],
["1iqg",2.6,3.23879252502849],
["1lft",2.6,2.91328517082059],
["1lfq",2.6,3.39305764390869],
["1pf7",2.6,3.67374825312499],
["1jtf",2.6,3.04001759058535],
["1bmm",2.6,3.32009749492677],
["1zjd",2.6,2.76037724353868],
["1ptg",2.6,3.37544861190487],
["6ptd",2.6,3.43562641775772],
["7ptd",2.6,3.59027045194317],
["1sj8",2.6,3.98558684432659],
["1u99",2.6,2.93432935516545],
["2c0k",2.6,2.77680033132758],
["1o70",2.6,2.5896071106321],
["1kc1",2.6,2.60490106936469],
["1ulc",2.6,2.56798737109514],
["1sig",2.6,3.00110448838359],
["1zbd",2.6,2.8067584011159],
["1q1m",2.6,2.31739568982224],
["1hdt",2.6,3.90029723908193],
["1ksj",2.6,3.41486710072298],
["1b3w",2.6,2.00947453083713],
["1ptu",2.6,3.43373356613758],
["2a6o",2.6,3.03878172903756],
["1ypx",2.6,3.49456162860515],
["1m14",2.6,2.81737682961890],
["1d9u",2.6,2.06083164084275],
["1kac",2.6,2.69089468427749],
["1evq",2.6,2.67890902617277],
["1yc0",2.6,2.37339761743681],
["1ld3",2.6,2.56798324826866],
["1bee",2.6,1.75724988206056],
["1by8",2.6,4.1728863854587],
["1wv4",2.6,3.55749790496156],
["1svc",2.6,3.19313701168599],
["1fn7",2.6,2.81567980796763],
["1yql",2.6,2.72852520279628],
["1l9v",2.6,3.17023268941738],
["2shk",2.6,2.6759669691967],
["2fia",2.6,2.87747130304869],
["1jpd",2.6,2.40179566863122],
["1rd7",2.6,3.24495530563966],
["1re7",2.6,3.32892664279322],
["1lbs",2.6,2.71025038463255],
["1git",2.6,2.63798607164283],
["2b0r",2.6,2.37773692878661],
["1b89",2.6,3.23842497875654],
["1g83",2.6,3.26093014385424],
["1um8",2.6,3.20317098325401],
["1i4w",2.6,3.26360630232212],
["9icw",2.6,3.860634536756],
["9icx",2.6,3.98001943885247],
["1zwk",2.6,2.61000819547955],
["1a0i",2.6,3.48565554214501],
["1bu1",2.6,2.74339160573558],
["1jiz",2.6,2.32018741761571],
["1vc2",2.6,3.20673104103183],
["1tva",2.6,2.13700810787613],
["1bpz",2.6,4.28591132671584],
["1c8t",2.6,3.64198423034952],
["2f2p",2.6,3.11448744338334],
["1b7f",2.6,3.60400340332248],
["1u5e",2.6,2.92305174708056],
["1wxq",2.6,3.51628298104227],
["1ixm",2.6,2.74082738867842],
["1ic8",2.6,3.89097870925111],
["2puc",2.6,3.88111576855467],
["2pud",2.6,3.91042819499006],
["1wet",2.6,3.99612935762226],
["1mif",2.6,2.9816199563967],
["2bz0",2.6,2.46052275634496],
["1w74",2.6,2.48839977740297],
["1d5j",2.6,3.11377776377468],
["1qq2",2.6,2.73204411467978],
["1dfv",2.6,3.37662475669282],
["2f89",2.6,2.48688732656593],
["2f8z",2.6,2.85957605674706],
["1al7",2.6,2.71299545144651],
["1di9",2.6,2.11217679894217],
["1fps",2.6,3.60663717271933],
["1q24",2.6,2.32845576318957],
["1buh",2.6,2.97753721460526],
["1tbp",2.6,3.30168373786711],
["1viv",2.6,2.7373156061593],
["2auc",2.6,2.50359311390524],
["5jdw",2.6,2.48564912832669],
["1syt",2.6,3.13809261888002],
["1qmb",2.6,3.12808859797967],
["1cqp",2.6,2.64972087651368],
["1yvw",2.6,2.20963049607091],
["1a22",2.6,2.90795670133294],
["1cav",2.6,4.38218293734905],
["1caw",2.6,4.58920657660855],
["1n1l",2.6,2.45298226965059],
["1hkj",2.6,2.80389056475314],
["1peb",2.6,2.49028199021675],
["1n3w",2.6,3.09648060633314],
["1es0",2.6,2.53250331352607],
["3hla",2.6,2.92220422423196],
["2hla",2.6,2.95935743285488],
["1gp7",2.6,2.59780585730199],
["1wkd",2.6,2.80282389047110],
["1a72",2.6,3.41951872960200],
["1iao",2.6,3.63919553117019],
["2a8q",2.6,2.24692059807372],
["1k2f",2.6,2.52399152515994],
["1e4g",2.6,3.32750884031446],
["1c5g",2.6,3.08603022450993],
["2fwo",2.6,2.92620294563544],
["1h8l",2.6,2.59114203987653],
["1c7z",2.6,2.41397795841242],
["1mst",2.6,2.29505133557121],
["2c4z",2.6,2.46992966306581],
["1vub",2.6,2.20421903164302],
["1j04",2.6,3.00097184093285],
["1vgf",2.6,2.83061154635357],
["1doa",2.6,3.04408862830869],
["1sir",2.6,2.84196323729043],
["1yvg",2.6,3.17381031550075],
["1zbo",2.6,3.14003905690763],
["1tdq",2.6,2.61092687856639],
["1asb",2.6,2.77135788823119],
["1vgl",2.6,3.27417952602874],
["2c4d",2.6,2.10251599595549],
["2phm",2.6,3.06818799053592],
["1b23",2.6,3.02020477529763],
["1uei",2.6,2.40458737394851],
["1udw",2.6,2.47431390092528],
["1jg5",2.6,2.11574798746525],
["1kcg",2.6,3.52956408030015],
["1jnu",2.6,2.66397237552357],
["1ft9",2.6,2.93713487494087],
["2alm",2.6,2.42422507705719],
["1qpp",2.6,2.52863600430101],
["1cw7",2.6,2.57676994161331],
["1xxb",2.6,3.60768875544665],
["1cpy",2.6,4.19370372482536],
["1mim",2.6,3.14539927529671],
["2cdg",2.6,2.96658791423757],
["1c12",2.6,3.14662258531128],
["1dka",2.6,3.06213735207927],
["1g0t",2.6,2.26137120039453],
["1ymf",2.6,3.38209988669453],
["1h3p",2.6,3.5455221107597],
["1v29",2.6,2.52047477441093],
["1m0p",2.6,3.69058596890505],
["1kkf",2.6,2.6307832424208],
["1soo",2.6,2.87626470874412],
["1kjx",2.6,3.63069997622903],
["1cgs",2.6,4.29589480494374],
["1hh6",2.6,3.24990795492277],
["1bog",2.6,3.30625139907766],
["1pg5",2.6,2.78904376664441],
["1onf",2.6,3.57406221173731],
["1nel",2.6,3.81506709383131],
["1err",2.6,3.10980620892953],
["1i9j",2.6,2.60283395835313],
["2cvf",2.6,4.44137105414246],
["1avg",2.6,2.99157579034418],
["2tpt",2.6,2.32802252274212],
["1b48",2.6,3.67032892967821],
["1guh",2.6,1.91716742747973],
["1u8l",2.6,2.74862001551121],
["1z4y",2.6,2.62899979181567],
["1dfq",2.6,3.4573033493888],
["1bdg",2.6,3.10576008113228],
["1f90",2.6,3.20512309947614],
["1ijk",2.6,3.17201251713555],
["1qu7",2.6,4.03369027006896],
["1hiy",2.6,3.11820519295594],
["1yfm",2.6,3.09551755896684],
["2mpa",2.6,3.0844255255568],
["1g1x",2.6,3.86819680719634],
["1mpa",2.6,3.29442207642908],
["1rin",2.6,2.44993522536935],
["1tnf",2.6,3.85518957248424],
["2bih",2.6,2.38406163970370],
["1ayz",2.6,2.67900897750756],
["1y3i",2.6,4.27693921297962],
["1k86",2.6,3.61520001336431],
["2aaq",2.6,2.88732934412216],
["1jtz",2.6,3.09604475488772],
["1sq0",2.6,2.98313211034851],
["1y8n",2.6,2.63700665958952],
["2c1j",2.6,3.31440145946808],
["1igr",2.6,3.66697763507502],
["2bnd",2.6,3.08150749646148],
["1rs0",2.6,2.62717210016571],
["1eop",2.6,3.27118781653837],
["1rc6",2.6,3.19705520404903],
["1ww1",2.6,3.10784094226482],
["1jgc",2.6,2.11271535759771],
["1fyu",2.6,2.70262761010478],
["1kp5",2.6,2.78881836070312],
["1q8m",2.6,3.01872509985581],
["1gq9",2.6,2.97386868864839],
["1gqc",2.6,2.45207252128925],
["1p8z",2.6,2.97685984780138],
["1ej9",2.6,3.07331368649515],
["1zkq",2.6,3.26687801424612],
["1b4w",2.6,3.33911385801091],
["1u3c",2.6,2.87232374899388],
["1wrl",2.6,2.55131853207226],
["1igc",2.6,4.1199813600434],
["1grw",2.6,2.67158010339878],
["1pwo",2.6,3.4857617398476],
["1s1c",2.6,2.84393562556164],
["1rr8",2.6,2.50901444770143],
["1h9d",2.6,3.04021945704469],
["1iig",2.6,2.76006255401854],
["1m2n",2.6,3.32651515732288],
["1k8t",2.6,3.208119524477],
["1ezx",2.6,3.01252044836542],
["1isg",2.6,2.6159192415895],
["2ard",2.6,2.77439089827497],
["1xkt",2.6,3.24812697886335],
["1dxf",2.6,2.61790647706734],
["1tre",2.6,3.28538974639799],
["1azn",2.6,3.48922769203094],
["1zct",2.6,2.68589413691510],
["1j9w",2.6,2.89789196336441],
["1jmy",2.6,3.24369447481458],
["1nyl",2.6,3.48717165063703],
["1pkm",2.6,3.10870207221308],
["1rjl",2.6,3.01984781161499],
["1tls",2.6,2.69082546454946],
["1wpr",2.6,3.33309694628777],
["1euy",2.6,3.17424480687334],
["1qrs",2.6,2.99896080210129],
["1i4t",2.6,3.47163018616146],
["1knp",2.6,3.54329499432541],
["1cfj",2.6,2.78663868398911],
["1p45",2.6,3.72842010516772],
["1dt3",2.6,3.03960991110501],
["1imc",2.6,3.01593610430178],
["1imd",2.6,2.98058020854843],
["1jop",2.6,3.86453585339801],
["1rd6",2.6,2.32228112628289],
["1m52",2.6,2.75648209898705],
["1s8o",2.6,3.07780544021421],
["1zd5",2.6,3.10666499498890],
["1z4s",2.6,2.38243369496132],
["1bql",2.6,3.25940718162953],
["1p8v",2.6,2.8309631125859],
["1yuw",2.6,3.24992185025108],
["1tfx",2.6,2.59184279664247],
["1q50",2.6,2.83174245433202],
["1xl4",2.6,2.51346001503432],
["2buj",2.6,2.36215337497445],
["1nih",2.6,2.85487248701386],
["1yhr",2.6,2.94372975894221],
["1hac",2.6,3.99727631956668],
["1y8i",2.6,2.60456479348924],
["1wss",2.6,2.66739808771474],
["1py1",2.6,2.83725707429833],
["1a97",2.6,1.8007223347116],
["1aby",2.6,2.86444339424988],
["2a3r",2.6,2.96477439697811],
["1zi0",2.6,2.42317618882741],
["1u7f",2.6,3.51482563809821],
["1hxy",2.6,2.82852773279544],
["2a1r",2.6,2.73868464772516],
["1mc3",2.6,3.49026510264723],
["1cbw",2.6,3.08385019456627],
["1lso",2.6,2.83373949573869],
["2bxl",2.6,2.85636284089135],
["1noc",2.6,3.08188396565227],
["2bxq",2.6,2.75158453446663],
["2bxo",2.6,2.80506814746818],
["1i78",2.6,3.01473620487416],
["1gnj",2.6,2.96878484311769],
["1tyy",2.6,3.22499756989242],
["1d9x",2.6,3.73365624569952],
["1rq7",2.6,1.98417603347637],
["1bgs",2.6,2.52060495147103],
["1wd9",2.6,2.96428906639854],
["1vcf",2.6,3.34279247357883],
["1e3h",2.6,2.56732010875472],
["2kzm",2.6,2.96610333349060],
["1vyt",2.6,3.04745300745597],
["1ps1",2.6,2.96504848770825],
["1jws",2.6,3.02650651681766],
["2uug",2.6,2.51870287877897],
["2a8m",2.6,2.96609453936204],
["1lhr",2.6,2.59952758838563],
["1upl",2.6,3.14149813571906],
["1kke",2.6,2.51180726985103],
["1lkt",2.6,2.59825411388166],
["1g44",2.6,3.75242136956408],
["1g82",2.6,2.9439027833007],
["1sg3",2.6,3.17547680599954],
["1yo8",2.6,3.08442591465424],
["1fpb",2.6,2.53945047920665],
["1fbc",2.6,2.70452470412019],
["1mnd",2.6,4.26012442704272],
["1wr6",2.6,2.95888532613871],
["2c1h",2.6,2.60707561694700],
["1w1z",2.6,3.47476587118027],
["1uh3",2.6,2.91085395982641],
["1o0v",2.6,3.26031774309433],
["1fvo",2.6,2.82103885621967],
["1zzd",2.6,3.26264561702381],
["1yxb",2.6,2.06685074157263],
["1wkp",2.6,2.20573017195984],
["1gla",2.6,3.14749689221002],
["1oy5",2.6,3.56380987627630],
["1glb",2.6,3.15196322431164],
["1huo",2.6,3.12894587760978],
["1jqu",2.6,4.31733462236698],
["1ufr",2.6,2.85347643755399],
["1bbt",2.6,2.90542476521608],
["2cvs",2.6,3.12812160343986],
["1lnz",2.6,3.33043173709821],
["2bm1",2.6,3.40377254744738],
["2a41",2.6,2.51105251566108],
["2cbq",2.6,2.52991028470889],
["2af3",2.6,3.23473230610955],
["1jvz",2.6,2.33350165521851],
["1jnf",2.6,3.01409694329025],
["1zbr",2.6,3.30230702471196],
["4cgt",2.6,3.19603132521213],
["1m8y",2.6,3.02422523888814],
["1fod",2.6,3.01453863751276],
["6cgt",2.6,3.10497189211873],
["2dij",2.6,2.71806698069009],
["1ao7",2.6,2.98718059453857],
["1r1i",2.6,4.18361305510896],
["1ymy",2.6,3.24391700225026],
["1by5",2.6,2.94149311138526],
["1ybd",2.6,2.56424886062705],
["2b7f",2.6,3.02268219661029],
["1kiz",2.6,2.19337446988174],
["1ksf",2.6,3.03604695321528],
["1q7g",2.6,3.1607011351199],
["1svo",2.6,3.04598761543627],
["1s5f",2.6,1.97929973201441],
["1ng3",2.6,2.86560113860988],
["1sa5",2.6,2.24667679705305],
["1pd1",2.6,2.59240604482726],
["1pd0",2.6,2.41910154862121],
["1ltb",2.6,2.58292952114717],
["1gl3",2.6,3.37345813468777],
["1b3q",2.6,3.13222699129694],
["1v2e",2.6,3.34936309104321],
["2fch",2.6,1.62249046053373],
["1kyx",2.6,1.99742268965788],
["1qqc",2.6,3.00915236681816],
["1a6z",2.6,3.37407084887274],
["1wsv",2.6,2.34031409650305],
["1t02",2.6,2.73147653621248],
["1kx4",2.6,2.70230784629530],
["1mc5",2.6,2.41190662644747],
["1xxf",2.6,3.22364814223595],
["1g9x",2.6,3.53720078642831],
["1li7",2.6,3.13866517103106],
["1gng",2.6,2.68264773947057],
["2cww",2.6,2.98558205684554],
["1ffp",2.6,3.27018559760025],
["1f66",2.6,2.82412630788238],
["1aqj",2.6,2.74971693098533],
["1aqi",2.6,2.93600945102848],
["1hhg",2.6,2.63434080796542],
["1bx2",2.6,3.25728519156589],
["1h6b",2.6,2.73826076841431],
["1rjz",2.6,2.79235089435136],
["1wu8",2.6,2.7359207001409],
["1rqq",2.6,2.73786919347452],
["1r8l",2.6,2.66093397236240],
["1dn1",2.6,3.00116116964233],
["1fpn",2.6,2.91171160144042],
["1dxi",2.6,4.15699574526553],
["1u76",2.6,3.31352201126062],
["1zl5",2.6,2.87868235068544],
["1axc",2.6,2.08778331373200],
["1jr1",2.6,2.88074918336173],
["1df0",2.6,3.53538933534559],
["1asl",2.6,3.79540021767639],
["1zn3",2.6,2.94242321359045],
["2etr",2.6,2.5486506593231],
["1fyt",2.6,2.7392053977823],
["2sbl",2.6,2.45860667144728],
["1k44",2.6,2.65834678994124],
["1gzh",2.6,2.8794148882419],
["1nq9",2.6,3.00943549596498],
["2esv",2.6,2.44426776755483],
["2ant",2.6,3.94665203251598],
["1uyj",2.6,3.15658090791262],
["1e04",2.6,2.75845023512618],
["1k8g",2.6,3.19151253272111],
["1tbr",2.6,3.01511611116963],
["1cmw",2.6,3.20462749207234],
["1u2r",2.6,2.71808112031569],
["1yqq",2.6,2.89956461498118],
["1p4d",2.6,3.34819678297858],
["1jwj",2.6,2.23286078993005],
["1jvq",2.6,3.22887300587891],
["1fnq",2.6,2.73243703841603],
["2bgh",2.6,3.03798744402592],
["1dwx",2.6,3.09133236503345],
["2nod",2.6,3.15024746535290],
["1nod",2.6,3.43569967889054],
["1vhk",2.6,2.91272230623448],
["1lnh",2.6,3.44231677683168],
["2ctz",2.6,3.29327218099468],
["1q1w",2.6,2.62330343443016],
["1ykb",2.6,2.94070033512489],
["1rba",2.6,4.42391698807283],
["1t16",2.6,3.40598940310940],
["1ngw",2.6,3.35017884143726],
["1axs",2.6,3.72824021401848],
["1mf2",2.6,3.06938102105479],
["1ltd",2.6,3.24252645978183],
["1ggo",2.6,3.82414319934571],
["1yaf",2.6,2.72027188831435],
["1ad5",2.6,2.99016865630986],
["1nkk",2.6,3.2834256725822],
["2fr8",2.6,2.56179539327313],
["1qb4",2.6,3.28611263255222],
["1z2z",2.6,3.36503628999551],
["1uup",2.6,2.96191382898828],
["1etz",2.6,3.13208098020525],
["1lwh",2.6,2.98596551267141],
["2eyt",2.6,2.78507996105973],
["1khn",2.6,2.93582243476174],
["1alj",2.6,2.62743806282229],
["1hkv",2.6,2.996182266130],
["1ad3",2.6,2.96534664606007],
["1elx",2.6,3.07274130892179],
["1s59",2.6,2.80700121380374],
["1ig9",2.6,3.10688034543691],
["1tkt",2.6,3.31268176648849],
["1un0",2.6,2.75205839211812],
["4at1",2.6,3.17813072128981],
["5at1",2.6,3.19334262051249],
["6at1",2.6,3.20092575851924],
["1kq7",2.6,2.59667313059276],
["1ibt",2.6,3.33368800513562],
["1sku",2.6,3.6494320573074],
["2c1t",2.6,2.49223871767711],
["1vh1",2.6,3.02010036508663],
["9rub",2.6,4.03705627692128],
["2acw",2.6,3.20316710460869],
["1nbe",2.6,3.20673937412002],
["1js6",2.6,2.80439311244341],
["1s1v",2.6,3.47229241982925],
["1jlg",2.6,3.39931258381638],
["1rev",2.6,3.09227943441651],
["1jlf",2.6,3.57571789303312],
["1dir",2.6,2.99786114584724],
["1t4p",2.6,2.96325731961375],
["1t4r",2.6,2.82935556535499],
["1efa",2.6,3.06112799517376],
["1kc6",2.6,3.03855904844035],
["1s3r",2.6,3.24785294983276],
["1lmk",2.6,3.3841731412688],
["1dxx",2.6,2.91169651162199],
["1ebd",2.6,3.04212045120249],
["1hv5",2.6,3.19849223368182],
["1m8v",2.6,3.07268556602622],
["1tyt",2.6,2.84891282269067],
["1gow",2.6,3.17335715568739],
["1s9e",2.6,3.89968023546904],
["1e1f",2.6,2.83673155113674],
["1p1f",2.6,3.63560000252981],
["1xvp",2.6,3.22142138896864],
["1t5s",2.6,3.08267345579554],
["1ymh",2.6,3.88718465905526],
["1a6d",2.6,3.04335907540206],
["1irx",2.6,3.1896653599859],
["1nbo",2.6,2.92984025666912],
["1fa0",2.6,3.10357060405380],
["2bfm",2.6,2.53905407190129],
["2bfo",2.6,2.33505443580168],
["1g8g",2.6,2.74068285485393],
["1ygz",2.6,3.60658691902366],
["1kzg",2.6,2.83194808311300],
["1dgr",2.6,2.47438177477415],
["1xf5",2.6,3.3411271396211],
["1m7r",2.6,3.28125524190584],
["1kf9",2.6,3.80208762416131],
["2a5y",2.6,3.58713771903976],
["1ja0",2.6,3.23803851644711],
["1tzh",2.6,2.51907834803965],
["2aly",2.6,2.953995194290],
["1nek",2.6,3.3099667603941],
["1djg",2.6,3.23490673046542],
["1jsc",2.6,2.41274421299243],
["1arz",2.6,3.71706932916424],
["1ii9",2.6,3.19902996497117],
["1gn9",2.6,2.38114636870976],
["1e8h",2.6,2.87964112824765],
["1cax",2.6,4.49323830849033],
["1gyr",2.6,2.25919647750999],
["1efp",2.6,3.05165497266005],
["1nob",2.6,3.0212569159178],
["1jst",2.6,3.38422471977466],
["2bkz",2.6,2.30574792959128],
["1urc",2.6,3.26735711617112],
["2tsr",2.6,2.17697693081414],
["1m6b",2.6,3.25168396241795],
["1nb6",2.6,3.20729667059997],
["1p7h",2.6,3.25643110851844],
["1e78",2.6,3.40716527687089],
["2cby",2.6,2.50828784692459],
["1fdz",2.6,2.87039313867239],
["1flg",2.6,3.29298654696381],
["1il2",2.6,3.16457516010819],
["1bvz",2.6,3.03507294374661],
["1tlf",2.6,3.52938666442310],
["1hyn",2.6,3.06908055569379],
["1e50",2.6,3.09421013280177],
["1t5l",2.6,3.08632096789725],
["1c4z",2.6,3.51235928376752],
["1v9d",2.6,3.12283395966991],
["1amo",2.6,2.92602825697817],
["1j38",2.6,3.36279691960762],
["1ma1",2.6,2.62251646328812],
["1vrb",2.6,2.77924935729588],
["1v1b",2.6,3.28618180128521],
["1y19",2.6,2.79770378570142],
["1cvj",2.6,3.60537225987651],
["1mwu",2.6,2.91424225374983],
["1sof",2.6,2.62754042405933],
["1esn",2.6,3.76425337683847],
["1mpm",2.6,2.95582576472542],
["1o8q",2.6,2.4776796966468],
["1eav",2.6,2.56101065158287],
["6pfk",2.6,2.46303020979361],
["1f31",2.6,2.71425342490571],
["1s0g",2.6,2.55948487360399],
["1o8c",2.6,1.94172264508122],
["1wyg",2.6,3.14243160256383],
["1mlv",2.6,3.12403969696666],
["1pwh",2.6,3.16904198087073],
["1qr7",2.6,2.65294666644515],
["1ywg",2.6,2.42058658111756],
["1ay0",2.6,2.67331178980768],
["1t9k",2.6,3.18842916688047],
["1yo6",2.6,3.20798757786972],
["1a4l",2.6,2.91879625092009],
["1o9k",2.6,3.33758455499771],
["1c4r",2.6,2.77700461682625],
["1htt",2.6,2.92498142533278],
["1ebu",2.6,3.08872870205362],
["1ml1",2.6,2.40427067892381],
["1z68",2.6,3.30165402627859],
["1ewe",2.6,2.98723481273511],
["1j2e",2.6,2.67566898504437],
["1mqm",2.6,3.33977723338785],
["1q12",2.6,3.41876205353929],
["1bpo",2.6,3.88290504213682],
["1kmm",2.6,3.04724818571085],
["2ajt",2.6,2.86676423004843],
["2b37",2.6,3.03739176208063],
["1hge",2.6,2.72718382180357],
["3pfl",2.6,3.01657768074870],
["1zxe",2.6,2.82135455376231],
["1bkg",2.6,2.62274478848704],
["1wgz",2.6,2.69397916606858],
["1x8m",2.6,3.30416443138934],
["2a1s",2.6,2.8834969218578],
["1egc",2.6,3.45625976121844],
["1ng9",2.6,2.22637787696133],
["5xim",2.6,2.15564323846265],
["1n8p",2.6,3.81602121794054],
["1yf1",2.6,2.51365680866456],
["1s00",2.6,2.90429490539791],
["1aig",2.6,2.75775466315135],
["1ybg",2.6,2.55004805444099],
["1uyv",2.6,2.9386329905462],
["2fwr",2.6,3.78016562528955],
["1j2p",2.6,3.18236722894751],
["1qpn",2.6,3.15567679517595],
["1bfo",2.6,3.55052265186666],
["1xtv",2.6,2.91819432428430],
["1yp3",2.6,3.27515191087054],
["1m8p",2.6,3.24271800162525],
["1b6c",2.6,2.8739325702343],
["1x9f",2.6,2.47741863151652],
["1re5",2.6,3.08481368408617],
["1i01",2.6,2.54340161777888],
["2bjy",2.6,2.38512426388924],
["1ulj",2.6,2.32755952047645],
["1gkr",2.6,3.22834038303041],
["1yov",2.6,3.20203649751678],
["1gkq",2.6,1.73496130258623],
["1cr7",2.6,2.55510988432513],
["1f33",2.6,2.45042753372636],
["1yrl",2.6,3.11085895770620],
["2euh",2.6,2.53212021240258],
["2avf",2.6,2.52254632279746],
["1xpq",2.6,3.2681326797876],
["1jbq",2.6,3.08102310554849],
["1l0n",2.6,3.38132098445655],
["1w0c",2.6,2.84244642678962],
["1bvp",2.6,2.93994475154401],
["1ntz",2.6,3.16391908426826],
["1ntk",2.6,3.59751937604545],
["1fzh",2.6,2.62395988859809],
["1i32",2.6,2.70715791128154],
["1efl",2.6,3.51454774033052],
["1efk",2.6,3.64508824141551],
["1ogp",2.6,2.88187035124089],
["1g2v",2.6,2.22410641674502],
["1pl0",2.6,2.85009089058119],
["2c2b",2.6,2.34317602462424],
["1t8s",2.6,2.96820628333008],
["1kif",2.6,2.6434669717005],
["1q5q",2.6,2.73337082070283],
["1xnw",2.6,3.58482452257304],
["1jts",2.6,3.0320829406972],
["1vq5",2.6,2.90826955551035],
["1yij",2.6,2.88676841949261],
["1p8j",2.6,2.46993900325997],
["1o00",2.6,1.86248469533228],
["1n4s",2.6,2.43382610489682],
["1iwa",2.6,3.02491259531310],
["1yg8",2.6,3.15156836420104],
["1n6e",2.6,2.95987483297947],
["1iw7",2.6,4.15393113756919],
["1jz1",2.6,3.41610921659342],
["1jz0",2.6,3.41887558405053],
["1nkt",2.6,3.02519890882756],
["2g1l",2.6,1.87257613300203],
["1yy9",2.61,3.15657590865401],
["1g5s",2.61,3.03061273859413],
["1y1i",2.61,2.14829172701255],
["1rjg",2.61,2.26072696652499],
["1zjn",2.61,2.59541788694599],
["2hmy",2.61,3.00844595127137],
["1wwm",2.61,3.18783289568865],
["2c2e",2.61,3.61553722251783],
["1rk0",2.61,2.39804647967106],
["1tg8",2.61,3.81750886627346],
["2c6w",2.61,3.33386461283372],
["1uej",2.61,2.45230504148663],
["2bww",2.61,1.65195830272046],
["1u65",2.61,2.88654169866606],
["2ffi",2.61,3.56199423492364],
["1fmx",2.61,3.40524295021198],
["1j1d",2.61,3.28921250802304],
["2bas",2.61,2.54619622031182],
["1t4c",2.61,2.92483928001528],
["2c2g",2.61,2.97595260514724],
["1ptj",2.61,3.36383277283695],
["1eqg",2.61,2.80433974688373],
["2c6t",2.61,2.76917304456426],
["1z69",2.61,2.75872556781792],
["1vl6",2.61,2.54946755932573],
["1zmb",2.61,3.13872855406719],
["1e1q",2.61,2.98135645897406],
["1v7o",2.62,3.48067986350581],
["1jfi",2.62,3.04231504569529],
["1b1x",2.62,3.05161541454299],
["1dd1",2.62,2.84992576646583],
["1rkw",2.62,3.49755569973627],
["1nva",2.62,2.84424280562701],
["1oyh",2.62,3.17899121527375],
["1e05",2.62,2.82959712033665],
["1lwc",2.62,3.34053769971019],
["1glf",2.62,4.14761375101454],
["1e1c",2.62,2.71883922694971],
["1jr4",2.63,3.01003336851874],
["1f0q",2.63,3.31440640928461],
["1vgn",2.63,2.67218218828911],
["1wdz",2.63,2.44805232584009],
["1y8p",2.63,2.71232244296804],
["1rzo",2.63,3.49041747392613],
["2fol",2.63,2.70092024207079],
["1qiv",2.64,3.48635693123508],
["1jxi",2.64,3.06654639694332],
["2cx3",2.64,3.15485869958791],
["1z9c",2.64,3.25805703072469],
["2f86",2.64,3.14852339456061],
["2hsd",2.64,3.29386308208392],
["1reu",2.65,3.02939513799372],
["1nfh",2.65,3.27447240638356],
["1xtr",2.65,3.23863359027066],
["1wqf",2.65,2.30790612504937],
["1r95",2.65,2.79128543124918],
["1ysz",2.65,2.20150391063575],
["1mzp",2.65,3.02416846821157],
["2c23",2.65,2.63231945626718],
["1ksv",2.65,3.05159846787018],
["1hjc",2.65,3.11744662604127],
["1sd7",2.65,3.43640339397853],
["1sd6",2.65,3.08150684857621],
["1ynm",2.65,3.21048733346187],
["1bw8",2.65,2.76037169342372],
["1kpi",2.65,2.41722270123853],
["1jqq",2.65,3.20749131002560],
["1u5c",2.65,2.33409884896839],
["2azq",2.65,3.20072873357882],
["1w3a",2.65,3.0222176388824],
["1tdc",2.65,3.63375342038293],
["1tdb",2.65,3.72138403102006],
["1fcv",2.65,2.65609808567228],
["1a3f",2.65,2.998532554773],
["1jma",2.65,3.29367983348282],
["1yw8",2.65,2.87808128497491],
["2atx",2.65,2.90125940701740],
["1r76",2.65,2.91502253985549],
["1qlf",2.65,2.46511601392899],
["2c50",2.65,2.57025829337147],
["1ytk",2.65,3.13527143737549],
["1q0l",2.65,2.12421598505204],
["1q5e",2.65,3.56471957802544],
["1b3n",2.65,2.9434925445259],
["1lil",2.65,4.12495596755228],
["2b2v",2.65,3.82990221519551],
["1ni5",2.65,3.41390634283425],
["1cfn",2.65,3.38107932847427],
["4znb",2.65,2.35493182829464],
["1w0f",2.65,3.53900878346956],
["1dkw",2.65,2.69856398803967],
["1bj4",2.65,2.38575729755037],
["1e3c",2.65,3.16898557195843],
["2axj",2.65,3.05077340485088],
["1oe6",2.65,3.29491411408712],
["1y0s",2.65,2.72402078394280],
["1o99",2.65,2.14454240375502],
["1nyx",2.65,3.74484969172175],
["1kg0",2.65,3.42396079894133],
["1hlu",2.65,3.71314053923326],
["1m9s",2.65,3.56623723473506],
["1qii",2.65,2.63068298628869],
["1hk1",2.65,2.91670886684819],
["2iff",2.65,3.10530438603275],
["1xdt",2.65,2.81212295308781],
["1dew",2.65,2.59392776587804],
["1u7d",2.65,3.07093517480444],
["1vqv",2.65,3.17060406958159],
["2bxn",2.65,2.93435452046180],
["1akj",2.65,2.27491145950500],
["1ihd",2.65,2.31299205765335],
["1bui",2.65,3.70398459912786],
["1pvr",2.65,3.76193281737668],
["1glc",2.65,3.95211067526235],
["1gzm",2.65,2.89511496229164],
["1m9i",2.65,3.39758098697228],
["2asl",2.65,2.4051352542757],
["1dtz",2.65,3.62714084449479],
["1u22",2.65,3.83499904110827],
["1m1a",2.65,2.91703187672583],
["1ffo",2.65,3.21506278702888],
["1vi5",2.65,2.43912924508678],
["1g8r",2.65,3.34278572342948],
["1pcr",2.65,3.29566249781391],
["1h4l",2.65,3.25990303472862],
["1key",2.65,3.22767075157033],
["1nf7",2.65,3.74964312527055],
["1k62",2.65,2.6747039448444],
["1rq0",2.65,3.59999997822522],
["1m1l",2.65,2.66391026558325],
["1klm",2.65,3.06965142100593],
["2b6a",2.65,3.37043996708923],
["1q83",2.65,2.24762532074555],
["1nno",2.65,2.41308692153268],
["1u9y",2.65,2.52052613256737],
["7prc",2.65,2.84457725103904],
["1xea",2.65,2.99479747640428],
["1dbz",2.65,2.2859970318559],
["1j4e",2.65,3.00422635545182],
["1ggt",2.65,3.46069769292037],
["1l3b",2.65,2.89368752982034],
["1flo",2.65,3.05903391705762],
["1ahj",2.65,2.55756238278378],
["2c4k",2.65,3.18917853269482],
["1jre",2.65,2.74782018945640],
["1hkx",2.65,3.42961968896085],
["1bjq",2.65,2.89658018793658],
["1c9b",2.65,3.46623349246575],
["1ag8",2.65,2.76958178424170],
["1aw2",2.65,2.96603052996035],
["1la2",2.65,3.11453938526700],
["1yi2",2.65,2.88781825260931],
["1nzw",2.65,2.06822277168515],
["1n4p",2.65,2.51154378795639],
["2fjf",2.65,2.89919665823929],
["1q3g",2.65,2.44625313572196],
["2a5g",2.66,1.95496789530387],
["1pqw",2.66,2.65308355824032],
["2bov",2.66,2.59018736924343],
["1cbv",2.66,3.8278566441836],
["1qgl",2.66,2.08279477674641],
["1ude",2.66,3.64029321079251],
["1oay",2.66,2.66273251825686],
["1svu",2.66,4.33605578624081],
["1yrg",2.66,2.89530012815090],
["1qm4",2.66,3.72027653374199],
["2bub",2.66,3.84584332793462],
["1eak",2.66,3.64815697115054],
["108m",2.67,2.77217406854204],
["3fua",2.67,2.92416634516687],
["1vpa",2.67,2.02999027862386],
["1ef7",2.67,3.10934275768153],
["2g0t",2.67,1.24616959708907],
["1cd1",2.67,3.63933624873021],
["1rqr",2.67,2.32457197923756],
["2bhs",2.67,2.77540253419067],
["1uwe",2.67,3.12500569997915],
["1zxv",2.67,3.26875724528732],
["1bdj",2.68,2.52048753641836],
["1ecz",2.68,3.36806326233000],
["1x90",2.68,2.98407308587709],
["1w3g",2.68,3.25909473055125],
["2c4y",2.68,2.41860126869729],
["1gtu",2.68,2.45686259005466],
["2bix",2.68,3.37832522072471],
["1pg8",2.68,2.74150442817477],
["1u78",2.69,2.94263956577294],
["1r7h",2.69,1.45628115634790],
["1vis",2.69,2.99073982627612],
["1e77",2.69,2.34679875726429],
["1hl1",2.69,2.50065809690368],
["1f4u",2.69,3.27970713745466],
["1s77",2.69,3.71258134266883],
["1ht8",2.69,2.83394499374620],
["1jll",2.69,3.20168566821857],
["1yfj",2.69,2.92159041558688],
["1sqb",2.69,2.83933765345011],
["1q9x",2.69,3.27871348899702],
["1u42",2.7,2.63821058734009],
["1h8k",2.7,3.95890376594833],
["1csq",2.7,3.19803199782098],
["1df5",2.7,3.65968263071637],
["1vbv",2.7,3.44961411297815],
["1qxx",2.7,3.34882324546603],
["1b5m",2.7,3.89069652005879],
["1f1f",2.7,3.13233934198235],
["1cit",2.7,3.0950371738984],
["1y47",2.7,3.38741103116226],
["1sj4",2.7,2.51636506377375],
["1vbx",2.7,2.74142126512031],
["1hhp",2.7,2.49115421361183],
["3phv",2.7,4.33505906644047],
["1mil",2.7,3.77047221555965],
["3bmp",2.7,2.67319322712266],
["1kql",2.7,2.87082329043916],
["1jd6",2.7,1.95853622243921],
["1pil",2.7,3.12184116558690],
["1d66",2.7,3.45299790419183],
["2lve",2.7,2.36498393963927],
["1apl",2.7,3.6722281207465],
["1lsx",2.7,2.27462550549115],
["1tc8",2.7,3.53704070872388],
["1rs4",2.7,1.81240896638952],
["1rry",2.7,2.53444812052639],
["2fnx",2.7,3.25166251869457],
["1k58",2.7,3.65093151416823],
["1dcy",2.7,2.96253225068255],
["1rbj",2.7,4.20181091409714],
["1xsd",2.7,3.43878363103755],
["1azu",2.7,4.31347057345396],
["1acd",2.7,2.23419551837552],
["1pbi",2.7,2.98429677533532],
["1bow",2.7,3.78815445784091],
["2a1j",2.7,3.75282232677753],
["1r2g",2.7,2.93804783873821],
["1was",2.7,3.72736854764075],
["1ri7",2.7,3.34741412807285],
["1pae",2.7,2.53450192982058],
["1vk9",2.7,2.35814465812342],
["1f9j",2.7,2.77817301919873],
["1qcq",2.7,2.81348108029579],
["1xtd",2.7,2.5967528929589],
["1aep",2.7,3.10883371317826],
["1n5z",2.7,2.74823368601338],
["1jh1",2.7,3.05284560668462],
["2bps",2.7,3.56501389225092],
["178l",2.7,3.652268541666],
["179l",2.7,4.1354654278083],
["2g7r",2.7,3.00125273071714],
["209l",2.7,4.38345629571878],
["1krq",2.7,1.44434520840677],
["1gnp",2.7,3.43482465391658],
["1c3g",2.7,3.72986094557250],
["1kb2",2.7,3.13682926713177],
["1bvo",2.7,3.40030385012574],
["1qhn",2.7,2.60115081544847],
["1cdu",2.7,3.66956407118717],
["1b87",2.7,2.43797899270619],
["1tbx",2.7,3.15344619883258],
["1yk9",2.7,3.57394375292106],
["2c3x",2.7,3.04920155700402],
["1v1g",2.7,3.55562677343305],
["1jd4",2.7,3.16154853506014],
["2cwe",2.7,3.34024663187488],
["1pex",2.7,3.70001852114411],
["1kb6",2.7,3.37425441616206],
["1bnk",2.7,2.87495313772929],
["2fde",2.7,3.00494745841120],
["1rv7",2.7,4.04468334338045],
["1xzd",2.7,2.53189529096469],
["1fap",2.7,3.23044015883688],
["1i5k",2.7,3.57566314494705],
["1eia",2.7,3.23576751812114],
["2gkw",2.7,3.07629498423981],
["2ccu",2.7,3.660711448786],
["1lm3",2.7,3.00844259958465],
["2d2a",2.7,3.48006424063361],
["1r8d",2.7,3.01413673903419],
["1qx6",2.7,2.95859880701591],
["1ldq",2.7,3.04279232659622],
["1x3f",2.7,3.2176503460645],
["1ncn",2.7,2.77554863116597],
["1yc8",2.7,2.4869775493173],
["1qz8",2.7,3.25732794343465],
["1fbm",2.7,3.28610798526501],
["1yzz",2.7,2.59403261349305],
["1w97",2.7,3.81330411173357],
["1i7f",2.7,2.99844669616584],
["1rlg",2.7,3.17809373954537],
["1ktr",2.7,2.57413532850656],
["1f3o",2.7,3.03176628451304],
["1o9f",2.7,2.74701886931368],
["5gch",2.7,3.78261282752422],
["1nlt",2.7,4.0699140297376],
["1se2",2.7,3.83419181269346],
["1z33",2.7,2.79894268434731],
["1mh2",2.7,2.53615572756268],
["1xxw",2.7,2.97933406405236],
["1qao",2.7,2.70907873418643],
["1g3r",2.7,2.63403589458702],
["1zhp",2.7,2.92092376917543],
["1lbd",2.7,4.00071298384392],
["1csg",2.7,2.95645905921971],
["1zqz",2.7,3.95497423367154],
["1zqv",2.7,4.05265540621802],
["1ozy",2.7,3.87878346913193],
["1dpd",2.7,2.52383145500080],
["1tj4",2.7,2.67466042858045],
["1avd",2.7,3.9537717139675],
["1nax",2.7,2.10705764684086],
["1hf0",2.7,3.34777899969499],
["1s03",2.7,3.06593181170163],
["1ri2",2.7,3.08539106049220],
["1ldi",2.7,2.44785949931999],
["1mih",2.7,2.48793565479768],
["2bt1",2.7,2.95832290156848],
["1u12",2.7,3.29483131965083],
["1bxx",2.7,2.80537561661043],
["2c9a",2.7,3.04372721239018],
["1rwm",2.7,2.60238924726198],
["1b8x",2.7,4.27082532213352],
["1cnf",2.7,3.68632914073462],
["1ef9",2.7,3.88510233586994],
["1a25",2.7,2.66934419636814],
["1bar",2.7,4.01274411648847],
["1ov4",2.7,2.52105165283424],
["2b0q",2.7,3.18537112835936],
["1xj7",2.7,3.58026263475365],
["1enz",2.7,4.05880700860244],
["1zid",2.7,3.39686349260879],
["1pja",2.7,2.67452342938444],
["1nh7",2.7,3.44113979719128],
["1x6u",2.7,3.39250872078854],
["1phq",2.7,3.95711818138343],
["1q3n",2.7,4.00122133459605],
["1cbi",2.7,2.78523732835275],
["1wkk",2.7,2.40483433514409],
["1w2n",2.7,2.72150563370496],
["1t7w",2.7,2.53453264024569],
["1eja",2.7,2.75868200090407],
["1q77",2.7,2.73740526318087],
["1fdw",2.7,3.61598036007808],
["1vg3",2.7,3.08158568822032],
["1rkc",2.7,4.19081294479953],
["1t4j",2.7,2.18442609656693],
["1iql",2.7,3.52671739667252],
["1fst",2.7,2.88028785751408],
["1c4y",2.7,3.84255361393052],
["2hco",2.7,3.07430493248550],
["1hco",2.7,4.24952245220149],
["1qfc",2.7,3.36539870386113],
["1lqd",2.7,2.99537885587793],
["2bmg",2.7,2.87863008253580],
["1wpt",2.7,3.47261958833916],
["1h3d",2.7,3.3766197107093],
["1v2h",2.7,3.57717825295173],
["1xrm",2.7,3.00881200411654],
["1to3",2.7,2.31817303078476],
["1ufl",2.7,3.31694433402076],
["1jbt",2.7,3.42339391577017],
["5ptd",2.7,3.29551633583482],
["1glv",2.7,3.61843272025597],
["1kc3",2.7,2.6025806712173],
["2auj",2.7,3.30905759944413],
["1t5j",2.7,2.74003728915373],
["1ecr",2.7,3.19434567378355],
["1udi",2.7,2.40956936043808],
["1ygj",2.7,3.25938724207817],
["1gag",2.7,2.53735347893615],
["1gjv",2.7,3.21255888864659],
["1n3c",2.7,2.86669756395794],
["1a1s",2.7,3.55580047002941],
["1wwh",2.7,3.12821710120453],
["2snw",2.7,3.13112626093181],
["2fzf",2.7,3.24542879409949],
["3ts1",2.7,2.84106982915417],
["2tdd",2.7,3.43080167089335],
["1zhi",2.7,2.97579581544644],
["1qub",2.7,2.62346706918002],
["1fmu",2.7,3.58118427936797],
["1l8q",2.7,3.29116402432793],
["1z7y",2.7,3.23096986166641],
["1z74",2.7,3.06085672170483],
["1sps",2.7,3.12728556894622],
["5mht",2.7,2.32592758596360],
["4mht",2.7,2.75935279626470],
["3mht",2.7,3.06014718622326],
["9ick",2.7,3.88168662382335],
["8ico",2.7,4.06094425254122],
["8ick",2.7,4.03090800927963],
["9icv",2.7,4.0749538344065],
["1zqi",2.7,4.00587883954685],
["1qsp",2.7,2.64650763280551],
["1fq6",2.7,3.36976368536037],
["1uki",2.7,3.88840333573406],
["1lf3",2.7,3.28367208655946],
["1on7",2.7,3.59636454337835],
["2cg5",2.7,3.08672706354985],
["1t97",2.7,3.61187931662767],
["5ldh",2.7,5.10372430880316],
["1mkj",2.7,2.7391278635991],
["1xdu",2.7,2.74844054532091],
["1yci",2.7,2.67884623201196],
["1bdh",2.7,3.78500246657639],
["1qqb",2.7,3.78546518640938],
["2pub",2.7,3.88836725009159],
["2pug",2.7,3.75966553608826],
["1zay",2.7,3.83448921368685],
["1vpw",2.7,3.91261690079784],
["2pue",2.7,3.92665422871556],
["1pnr",2.7,3.98315401374408],
["1pmu",2.7,3.37154093578194],
["1gfp",2.7,2.65453164488025],
["1y6n",2.7,3.01443116277398],
["1x77",2.7,2.64795118422277],
["1v34",2.7,2.75047903796326],
["1e5w",2.7,3.41414200074230],
["1z6x",2.7,3.02843263428428],
["2f7s",2.7,3.02036739204235],
["1yvb",2.7,3.69242039551038],
["1exu",2.7,3.39565210887895],
["2cpk",2.7,2.71883433925634],
["1w33",2.7,3.73513059030859],
["2rmp",2.7,3.22863412342457],
["2fm2",2.7,2.92779340889477],
["2aew",2.7,3.29062002703926],
["1iud",2.7,3.21959276029587],
["1qnl",2.7,2.97010600191023],
["1exc",2.7,3.27018518495034],
["1vhg",2.7,2.9934830755756],
["1a2l",2.7,2.41801042430587],
["2ach",2.7,3.32586882514542],
["1xtj",2.7,3.1358298862599],
["1vgp",2.7,2.82988174411962],
["1a2m",2.7,2.48108611598891],
["1adg",2.7,3.33047325547247],
["1atu",2.7,4.34393657038179],
["1qqd",2.7,3.02934346091160],
["9pai",2.7,3.07891138495566],
["1p9w",2.7,2.83164245782489],
["1bho",2.7,3.24135902477246],
["1idn",2.7,3.25310498157455],
["1bhq",2.7,3.40206263009735],
["1v1p",2.7,3.09221574393558],
["1dl3",2.7,2.90452278462295],
["1a02",2.7,3.32931267529361],
["2a8p",2.7,2.43874620131750],
["1cg9",2.7,2.28539181492043],
["1bms",2.7,2.32052785502467],
["1zdi",2.7,2.55470727180827],
["1zdh",2.7,2.47593766277000],
["1kuo",2.7,2.38293359530701],
["1ffw",2.7,2.29758732517062],
["1pa3",2.7,3.07641064167886],
["1vol",2.7,3.70792475989145],
["1pmp",2.7,3.36223858183037],
["1pbf",2.7,2.43386676290958],
["2phh",2.7,3.34701903550007],
["1cuw",2.7,2.79116264110157],
["1xhm",2.7,2.81538772548954],
["1dt9",2.7,4.03106976413354],
["1cq6",2.7,3.46580813501133],
["1ams",2.7,3.46572715710785],
["1run",2.7,3.91119225395913],
["1tqe",2.7,3.47243523163165],
["1ruo",2.7,4.19527725696466],
["1k03",2.7,2.4067959021965],
["1bwl",2.7,2.89069668084286],
["1k02",2.7,2.79708228889578],
["2b0z",2.7,3.08475018713860],
["1bjy",2.7,2.27709712009711],
["1qs2",2.7,2.59767870907172],
["1n11",2.7,3.68924503182954],
["1tq6",2.7,3.06034130512308],
["1vrr",2.7,3.03226996124780],
["1ue6",2.7,3.53957567303775],
["1i69",2.7,3.33299093285391],
["1ci0",2.7,3.43000318554461],
["2eia",2.7,3.34395612656085],
["1i1c",2.7,2.60476514575748],
["1w7m",2.7,3.01213392486798],
["1ika",2.7,3.62423997964172],
["1jn6",2.7,3.28708960013813],
["1iay",2.7,2.86309943730587],
["1ghf",2.7,3.78908824235902],
["1nkm",2.7,3.60699921013306],
["1d6n",2.7,4.48908179922688],
["2bga",2.7,2.62465293100079],
["1uev",2.7,2.94004376269049],
["1mf1",2.7,3.10012092326664],
["1a8j",2.7,4.30426566253311],
["1mcl",2.7,4.03699369117441],
["1mcr",2.7,4.17813210359709],
["1cf8",2.7,2.99734991941179],
["1hcf",2.7,2.92308620965123],
["1mcn",2.7,4.02055908643432],
["1mcq",2.7,4.00184285667756],
["1mci",2.7,3.96839764312739],
["1ibg",2.7,3.31089288097723],
["1xae",2.7,3.63517849470346],
["1mck",2.7,3.89417568724948],
["1mcd",2.7,3.89724888643494],
["1mcj",2.7,4.10334117890879],
["1mcb",2.7,3.83682983346721],
["1mcs",2.7,4.14301999983943],
["1igi",2.7,3.14000803337349],
["1fai",2.7,3.51156985363626],
["1dbj",2.7,3.39198642046726],
["1dbm",2.7,3.50072560971979],
["1dbb",2.7,3.74924170263932],
["4fab",2.7,4.74322479466144],
["1mch",2.7,3.70372951037750],
["1mcf",2.7,3.89692774504044],
["1mcc",2.7,3.89523577028024],
["1mce",2.7,4.12628364204758],
["1hh9",2.7,3.33111317096056],
["1dn2",2.7,1.82512346525517],
["1cts",2.7,3.51272861815402],
["1eba",2.7,3.14814474029117],
["1s5i",2.7,2.98094814062491],
["1dfb",2.7,3.47267597382417],
["1jaw",2.7,2.64671195306007],
["1ces",2.7,2.97975765160821],
["1mcp",2.7,4.10640666061659],
["1gsf",2.7,2.51017081748445],
["1sxt",2.7,3.38593856686188],
["1af9",2.7,3.06843237884565],
["1kix",2.7,2.25887835758657],
["1ru8",2.7,3.32635790336841],
["3znb",2.7,3.08703510813825],
["1q31",2.7,3.63086147399529],
["1z4w",2.7,2.70185374843883],
["1u0o",2.7,3.5143374262527],
["2beo",2.7,2.66795745725592],
["1ira",2.7,2.33445589948203],
["1ioa",2.7,3.30757685339428],
["3sxl",2.7,3.73481901071419],
["1k88",2.7,3.69036923043721],
["1uur",2.7,3.08754280192337],
["1yy4",2.7,2.74474674225782],
["1kv6",2.7,3.22235136984985],
["1fvp",2.7,4.14281826882508],
["1bbw",2.7,3.07629589521281],
["2grt",2.7,2.75713606088519],
["1jp5",2.7,3.06086557876132],
["2c74",2.7,1.82080087952732],
["1qvn",2.7,2.33156577761307],
["2cah",2.7,2.62122458841654],
["2cag",2.7,2.76850538576423],
["1za7",2.7,2.42175442831212],
["1gxc",2.7,3.14671567331711],
["1lap",2.7,2.93155931378153],
["1ud5",2.7,2.69313423904107],
["1yfk",2.7,2.80897595303556],
["2axh",2.7,3.16093569505401],
["1xq4",2.7,2.83378090223227],
["1bbu",2.7,2.36940968561581],
["1o8o",2.7,2.26726538831039],
["1tdk",2.7,2.51810728263508],
["1tdn",2.7,2.5904087574039],
["1ggp",2.7,4.23509077376079],
["1ybw",2.7,3.12496249189070],
["1su5",2.7,2.01381342867674],
["2mll",2.7,3.89609187568425],
["1ce7",2.7,3.89993493885702],
["1nt0",2.7,3.00980972278613],
["1uos",2.7,3.08900311046586],
["1gme",2.7,2.90468901304201],
["1hzu",2.7,2.8629326160856],
["1yfi",2.7,2.4734188435728],
["1hyr",2.7,3.39513313868904],
["1oce",2.7,3.76618574839563],
["1n7j",2.7,3.09230362800014],
["1jut",2.7,2.63979923845273],
["1qrt",2.7,3.03049967281251],
["1exd",2.7,3.43477768891539],
["1o0b",2.7,3.1352151926311],
["1yh8",2.7,2.28940697877403],
["1sq4",2.7,3.14211613712253],
["1i4l",2.7,3.53208401123621],
["1dx4",2.7,3.27176038774904],
["2bm7",2.7,3.21960874944808],
["1nqf",2.7,3.98614594556459],
["2cw7",2.7,3.14672235223683],
["1qo9",2.7,3.9821186503534],
["1bhc",2.7,2.69774405602001],
["1yjd",2.7,3.79093576943996],
["1ram",2.7,3.67409476334332],
["1ddl",2.7,2.91264007575427],
["1zd4",2.7,3.12066449162487],
["2azk",2.7,3.27815062814351],
["1hu8",2.7,3.37952913554272],
["1rlc",2.7,3.06656894893519],
["1zlp",2.7,3.5316974208274],
["1ygf",2.7,3.15484359405822],
["1yg5",2.7,3.54095351367075],
["1wv7",2.7,2.57545692959391],
["1czz",2.7,2.76200444234705],
["1xb1",2.7,3.02244132865593],
["1xd8",2.7,2.80820148110087],
["1dib",2.7,1.89165492114109],
["1hq6",2.7,2.82665603452941],
["1yhz",2.7,2.40925992695505],
["1yi0",2.7,2.40213117582432],
["1yhy",2.7,2.48074186875244],
["1hk5",2.7,2.53305954854623],
["1e7i",2.7,3.47828472980413],
["1lei",2.7,3.57113044824805],
["1cud",2.7,3.54708421376646],
["5crx",2.7,4.05457219119565],
["1tz6",2.7,3.21342290070997],
["1zun",2.7,2.73732108073169],
["1m7n",2.7,2.8212116087659],
["1u7v",2.7,3.29162137858090],
["2amp",2.7,3.71334500540117],
["1s70",2.7,3.34621799482834],
["1ng0",2.7,2.4003182527957],
["1xm5",2.7,3.367928383315],
["1h7u",2.7,2.72827805954411],
["1ea6",2.7,2.73422985440648],
["1lwi",2.7,3.06402155023311],
["2d2d",2.7,3.36830056476297],
["1ieq",2.7,2.42804012572747],
["1lq2",2.7,2.82001915426468],
["1jwm",2.7,2.97696217442546],
["1nam",2.7,3.67858458916478],
["1r11",2.7,3.55926592119729],
["1tf0",2.7,3.14867784514243],
["1tlt",2.7,3.39798661447479],
["1hde",2.7,2.51663721733754],
["1wpx",2.7,2.94540388802349],
["1fbf",2.7,2.59247530275754],
["1azw",2.7,2.86466297390545],
["1xk8",2.7,1.39283631852524],
["1vbm",2.7,2.99673603908153],
["1vbn",2.7,3.36335443225343],
["1fwr",2.7,2.59451560201139],
["1r5j",2.7,3.64503477393232],
["1me6",2.7,3.35198555377467],
["1sme",2.7,3.48331754338637],
["1m1m",2.7,3.53786738401400],
["1bt1",2.7,3.09717502277944],
["1bt2",2.7,3.29699982960204],
["1bug",2.7,3.40589668877134],
["2dld",2.7,4.32824560836013],
["1nuf",2.7,2.83570879738950],
["1bgw",2.7,3.52890860216851],
["2bse",2.7,2.72332776526945],
["2au0",2.7,3.51965120587924],
["1s0m",2.7,2.68280674873922],
["1i3o",2.7,3.07667404609446],
["1vh3",2.7,3.13180867513380],
["1dr8",2.7,3.90914394095309],
["1w59",2.7,3.29720494558252],
["1f9b",2.7,3.28170439795194],
["1i6q",2.7,4.11091109185845],
["1lqs",2.7,3.02407034216358],
["2fpi",2.7,3.41754765351063],
["1bvk",2.7,3.66336550451821],
["1r5k",2.7,3.00598936938302],
["1kjy",2.7,3.07116001798639],
["1z25",2.7,3.15200992659533],
["1dtw",2.7,3.18535165529901],
["1fcp",2.7,3.27940581501762],
["1qff",2.7,3.19561726440554],
["1l8x",2.7,3.62144010726487],
["1nl4",2.7,3.46236504538172],
["2vsg",2.7,3.18358325585805],
["1qe0",2.7,3.5537271653467],
["1ecx",2.7,2.53007434514438],
["2a59",2.7,2.69139500156392],
["1di0",2.7,3.38886087689766],
["1kp0",2.7,2.62900324433191],
["1kz6",2.7,2.4870292004895],
["1mne",2.7,3.48276266794805],
["1hh4",2.7,3.4407556327455],
["1pok",2.7,3.11391637356112],
["1qty",2.7,3.85589018582154],
["1teh",2.7,3.21551968416669],
["1p34",2.7,2.49968007269705],
["1p3g",2.7,2.67802697671286],
["1adc",2.7,3.57219795525714],
["1k8q",2.7,2.82923263995029],
["1p3p",2.7,2.64828286916342],
["1ffn",2.7,3.42353861476543],
["1til",2.7,3.09669010141408],
["1p17",2.7,3.16629562884901],
["1x9s",2.7,2.88290195729830],
["1szg",2.7,3.17972733446033],
["1zyq",2.7,2.86734603514248],
["1szf",2.7,3.02605535909036],
["1nvb",2.7,3.21079226714066],
["1tq2",2.7,3.20880769367459],
["1p16",2.7,3.09901212404399],
["1ieb",2.7,3.37455655014141],
["1h9u",2.7,2.92849533597132],
["1xd2",2.7,2.40159903176545],
["1nvw",2.7,2.43763086682809],
["1ncr",2.7,2.33753494015473],
["2pmt",2.7,2.56036544824066],
["1frf",2.7,3.11409692754532],
["1m6n",2.7,3.63653982772723],
["2beh",2.7,3.41121797953984],
["1kl2",2.7,2.97736475258419],
["1jgz",2.7,2.91755160808955],
["2bnp",2.7,2.29031148006247],
["1qj3",2.7,2.75726591537411],
["1gze",2.7,3.45630911107873],
["2fu3",2.7,3.13134528049828],
["1jgy",2.7,3.06095436296907],
["1e14",2.7,2.98636253436659],
["1m8i",2.7,2.69895647377071],
["1rqk",2.7,2.24847358734736],
["3nod",2.7,3.27413155775308],
["1k5m",2.7,2.80663928359457],
["2a5u",2.7,3.70670194164224],
["1r1l",2.7,3.18651184084571],
["1ioi",2.7,3.11197890784721],
["1t09",2.7,2.92617380987427],
["1nr9",2.7,3.29030291320763],
["1e90",2.7,3.0492138335126],
["1i3s",2.7,2.94032324482385],
["1qw5",2.7,3.08392835446764],
["1qom",2.7,3.11543243476737],
["1tel",2.7,3.27878448973638],
["1a6t",2.7,3.25078870450807],
["1c0t",2.7,3.18441987011358],
["1sfr",2.7,2.62924572631259],
["1w46",2.7,2.81887128320679],
["1hq4",2.7,3.16294947859241],
["1w26",2.7,3.49924919457739],
["2a71",2.7,2.75115810731654],
["1fve",2.7,3.3506592516416],
["1q17",2.7,3.15419257338724],
["1xm2",2.7,3.24965302320638],
["2a1w",2.7,2.63934080341145],
["1f9n",2.7,3.10685699640226],
["1a0e",2.7,2.56821643542593],
["1o7d",2.7,3.10539932233173],
["1nju",2.7,3.30795066507596],
["1b99",2.7,2.73929894585938],
["2wpo",2.7,3.4684344520746],
["1hez",2.7,3.20798087185429],
["1sus",2.7,3.69867815366166],
["1sui",2.7,3.76974702177723],
["1clq",2.7,3.32605158493312],
["1w25",2.7,2.28304778324613],
["5ttr",2.7,3.57959945436761],
["2byv",2.7,2.10854844196913],
["1s1w",2.7,3.28681177929097],
["1ezz",2.7,3.98473258916838],
["1bzw",2.7,2.14454597840130],
["1ciw",2.7,2.53290278851309],
["2csx",2.7,3.56796925050356],
["1pq2",2.7,3.23812727150337],
["2ct8",2.7,3.44981870241349],
["1n47",2.7,2.97281939635409],
["1bq3",2.7,2.68814451219612],
["3pbg",2.7,2.54553157135734],
["1tbh",2.7,3.12755925692375],
["1szq",2.7,3.14434308515631],
["1yw0",2.7,3.25848914035396],
["1hqe",2.7,3.17641319934227],
["1gxf",2.7,3.12843397751793],
["1dlo",2.7,3.23690135382593],
["1hqu",2.7,3.40157241313884],
["1khw",2.7,2.68075399416622],
["1x27",2.7,3.11892627081436],
["1xv9",2.7,3.43286966722676],
["1wpe",2.7,3.63292639588237],
["1nib",2.7,2.32848917226630],
["1p93",2.7,4.01988968266666],
["1ar1",2.7,3.04994959190288],
["1gku",2.7,3.5339435686365],
["1afc",2.7,4.20370499701598],
["1qez",2.7,2.51583617571740],
["1kl7",2.7,3.25045161011010],
["1i9b",2.7,2.87535285380075],
["1b70",2.7,3.75005512827707],
["1xf9",2.7,2.49219086016498],
["2amc",2.7,3.08193835075372],
["1nsl",2.7,3.51617480113395],
["1mhz",2.7,2.9542406222202],
["1jeq",2.7,2.99379018545465],
["2f1v",2.7,3.34984756064443],
["1ipj",2.7,3.80971449060597],
["1gjq",2.7,2.04547854860984],
["1w1l",2.7,3.05908838842719],
["1w1j",2.7,3.01992203930830],
["1ipk",2.7,4.08691787893219],
["1eqh",2.7,2.78234374011162],
["1am4",2.7,4.13501268032584],
["1ahu",2.7,3.57595122439851],
["1gy3",2.7,3.42345887953333],
["2c4g",2.7,2.65918063815725],
["1fdu",2.7,3.54238251560578],
["1n0e",2.7,3.4350615461396],
["1vkl",2.7,2.68901571524342],
["1jdy",2.7,2.74598052931753],
["1c47",2.7,2.85291477932201],
["1lxt",2.7,3.16832540595867],
["1c4g",2.7,3.35709027611522],
["2b30",2.7,2.23053704629376],
["1seb",2.7,3.18730704330011],
["1lfl",2.7,2.90010122897181],
["1nex",2.7,3.17560179484637],
["1d5y",2.7,3.37927207122532],
["1xj5",2.7,2.6651102847973],
["1ve7",2.7,3.28726804398700],
["1nxk",2.7,3.56681952775529],
["2bx8",2.7,3.18677238396015],
["2bxg",2.7,2.90296875711918],
["1g3l",2.7,2.46126584908114],
["1lbi",2.7,3.75572677100495],
["1zzh",2.7,3.2246160785685],
["2c35",2.7,3.17465277026998],
["1ws2",2.7,2.82200277017711],
["1tui",2.7,3.73981924163235],
["1dml",2.7,3.21842182530072],
["1ttt",2.7,3.75099571905016],
["1j9z",2.7,3.17290146230023],
["1kk4",2.7,3.2833134202424],
["1kk5",2.7,3.07386679533546],
["1nfi",2.7,3.34533455318413],
["2fl0",2.7,2.64792710121749],
["1kgy",2.7,3.59682712823112],
["1p73",2.7,2.83710361993145],
["1tae",2.7,2.82373122775743],
["1vcb",2.7,3.13709822074983],
["1fzf",2.7,2.96516149290090],
["1re4",2.7,3.19939049991613],
["1ii4",2.7,2.73155226996266],
["1qzt",2.7,2.64540340482355],
["1hzh",2.7,3.2273962273939],
["1ltx",2.7,3.41231378530755],
["1usx",2.7,3.3810176336938],
["1nud",2.7,2.85140105030008],
["3req",2.7,3.31652734411577],
["1tka",2.7,2.66720912615685],
["1tkc",2.7,2.80845873850044],
["1dee",2.7,2.91481166840853],
["1od2",2.7,3.41839277998139],
["1n8w",2.7,3.03621834601849],
["1s80",2.7,2.6171687335],
["1nws",2.7,2.52511051548748],
["1nwr",2.7,2.50266457488469],
["1ruy",2.7,3.14416916402564],
["1tkr",2.7,3.24590971899119],
["1o7x",2.7,3.08821485438266],
["1kxz",2.7,2.64440614979646],
["1pwu",2.7,3.22663537534422],
["1r0l",2.7,2.66225674417693],
["1hgi",2.7,2.73266270099210],
["1hgj",2.7,2.67762981236656],
["1hgh",2.7,2.77392335162635],
["1hgd",2.7,2.75079912457510],
["1fw6",2.7,3.34835623620357],
["1zhb",2.7,2.50096055675395],
["1mzo",2.7,2.75345011108879],
["1z6r",2.7,3.17556579917835],
["2ch2",2.7,2.51567207192776],
["1usv",2.7,3.33447542528333],
["1yud",2.7,3.58839790217443],
["2bwp",2.7,2.11760075069828],
["1ovw",2.7,2.83920889091809],
["1p4e",2.7,2.76757649994979],
["1p44",2.7,3.56464504313340],
["1ib1",2.7,2.79935130511239],
["1eqb",2.7,2.09421596889251],
["1adj",2.7,2.78126638431493],
["2fvi",2.7,2.12475032877049],
["4kbp",2.7,3.154890415432],
["1gul",2.7,2.73885052628181],
["1jr3",2.7,3.21849201703150],
["3lhb",2.7,1.7878338366691],
["1eqr",2.7,3.43963336362111],
["1hg3",2.7,3.21066038547353],
["4cev",2.7,2.24828469587122],
["1fag",2.7,3.25410933017301],
["1nfg",2.7,3.01890272677671],
["1ls3",2.7,2.94764566190072],
["1v6m",2.7,2.75178798431776],
["1bcp",2.7,3.59787602766772],
["1o6r",2.7,2.85286335660283],
["1tei",2.7,2.44316258293322],
["1ecb",2.7,2.96705716173497],
["1bi9",2.7,3.40247607992166],
["1sq3",2.7,2.35234505248096],
["1mb2",2.7,3.32052494502974],
["1tt7",2.7,2.89254862816777],
["1m1j",2.7,3.36080541655378],
["2ba1",2.7,3.26635613157803],
["1aw1",2.7,2.60927592255578],
["1od4",2.7,3.42069625146936],
["1zs3",2.7,2.80976812590301],
["2bku",2.7,2.39908019749743],
["1sqp",2.7,3.11672818014982],
["1ywh",2.7,3.37658334077026],
["1kf6",2.7,3.02784142212803],
["2ba0",2.7,3.04463856520359],
["1urz",2.7,2.8488774074579],
["1xhz",2.7,2.9270443813111],
["1bxn",2.7,3.09687558363852],
["4rub",2.7,3.66254819942165],
["1e6v",2.7,3.02035226838096],
["2c3o",2.7,3.16444349348597],
["1is8",2.7,2.86077316282551],
["1t8r",2.7,2.88289675947584],
["1k5d",2.7,3.34109799081614],
["2bma",2.7,3.28990187995713],
["1w8j",2.7,3.25547732928534],
["2cfy",2.7,2.40706851258413],
["2c7f",2.7,3.07130815097758],
["1l1f",2.7,3.68017604676227],
["1qk1",2.7,2.78404545204334],
["1r3n",2.7,2.73785465510499],
["1hr8",2.7,2.72436871213845],
["1ss8",2.7,2.72879116958525],
["1vq4",2.7,2.92882370353892],
["1vq6",2.7,2.94379547363099],
["1tny",2.7,2.53111362357850],
["1tno",2.7,2.35507333775190],
["1tnu",2.7,2.48860273315654],
["1aqf",2.7,3.73648174616999],
["1h2i",2.7,3.16283143945375],
["1jro",2.7,3.17186694696367],
["1t6p",2.7,3.10398765561261],
["1gt7",2.7,2.53337536012331],
["1n6f",2.7,2.9375397229976],
["1smy",2.7,3.96768802982613],
["1qox",2.7,2.23756447122614],
["1j0b",2.7,4.00290134186516],
["1jyy",2.7,3.46177844112476],
["1jyz",2.7,3.46345338485234],
["1s31",2.7,2.65737222754316],
["1po8",2.71,3.50215505721217],
["1sv9",2.71,2.75661555956119],
["2b17",2.71,2.89840072218737],
["1e31",2.71,2.97630732053807],
["1kq2",2.71,3.11078759891131],
["1z5v",2.71,3.5105944978502],
["1ga7",2.71,3.09673156095862],
["1xr3",2.71,3.03251003363421],
["1xgy",2.71,3.17785122713095],
["2f1m",2.71,2.75994875265200],
["1xjw",2.71,3.20721117792219],
["1ydo",2.71,3.29924416423024],
["1kj2",2.71,3.34847205169315],
["1pv2",2.71,3.05833122352507],
["2cy9",2.72,4.32208667019402],
["1bwz",2.72,3.33501049653490],
["2a0i",2.72,3.70121941500561],
["1c85",2.72,3.04149591506393],
["1i9i",2.72,2.94245561602026],
["1qon",2.72,3.42766522289863],
["1n54",2.72,3.41845166385329],
["1uqw",2.72,2.94671458770204],
["1t35",2.72,3.12140385079424],
["1liu",2.72,3.32060692750675],
["1rwt",2.72,1.98043013069363],
["1jc7",2.73,2.84561272582498],
["1ibc",2.73,2.72476818571041],
["1g28",2.73,2.92896960528415],
["1ygd",2.73,2.89961013087367],
["1eet",2.73,3.06734395729732],
["1h4z",2.74,3.51838298747653],
["1a29",2.74,2.13518540790833],
["1mk2",2.74,3.54027603794615],
["2aaj",2.74,2.39643173452383],
["1b6d",2.74,2.93034645216308],
["1by3",2.74,3.14777875045094],
["5rla",2.74,2.69147394144406],
["1liy",2.74,3.57393658537152],
["1jj8",2.75,2.80375341291785],
["1sjf",2.75,2.84549552681223],
["1jyu",2.75,3.49885391890894],
["1jbg",2.75,3.33152073247058],
["1vas",2.75,2.93472787137273],
["1j4x",2.75,4.18759128003479],
["1q89",2.75,3.19185736695434],
["4tss",2.75,3.76188754445959],
["1b98",2.75,3.39279859776259],
["1b8m",2.75,2.80632891187672],
["1yf5",2.75,2.18606031469625],
["1lyn",2.75,3.22080357505776],
["1hkq",2.75,3.23430389921124],
["1gzo",2.75,3.6024879960231],
["1rc8",2.75,3.31367099887851],
["1ula",2.75,4.10571583804721],
["1ulb",2.75,4.18966599510986],
["1vtk",2.75,2.561548651343],
["1tsz",2.75,3.40836636209573],
["1x0x",2.75,2.7905011768238],
["1buv",2.75,3.88263649639282],
["1rtl",2.75,2.88175302692325],
["1a6a",2.75,3.29750202911840],
["1yte",2.75,3.05347648579105],
["1v1o",2.75,2.41133213762419],
["1for",2.75,3.10594698182894],
["1h8o",2.75,2.96891686975755],
["1cfs",2.75,3.64803249523926],
["1dbn",2.75,2.84404252197765],
["1n2k",2.75,2.23616927334661],
["1zyd",2.75,3.04232190475885],
["1twz",2.75,3.08825101752305],
["1ut8",2.75,3.04111687301914],
["1ut5",2.75,3.28543463460967],
["1sxh",2.75,3.53032742975703],
["1h7a",2.75,3.43686279323468],
["1yeq",2.75,3.09137451833569],
["1do5",2.75,3.23408705339203],
["1bs2",2.75,3.01160082519423],
["1pvq",2.75,3.9111379821484],
["1rdx",2.75,4.39993931061207],
["1fml",2.75,2.49027848316030],
["1x8k",2.75,2.63208341391823],
["1yys",2.75,2.76801143965467],
["2aet",2.75,2.62721362766379],
["1fpp",2.75,3.24399258219139],
["2a57",2.75,2.45903705534583],
["1wn7",2.75,3.68536609935239],
["1p3o",2.75,2.49942740474152],
["1vz6",2.75,2.47358279459493],
["1qcw",2.75,2.96843220111843],
["1q9j",2.75,3.27094298503092],
["1oan",2.75,3.48715308428417],
["1psd",2.75,3.12178038498298],
["1rvj",2.75,2.66274371851214],
["1zlu",2.75,3.50563511271983],
["2bty",2.75,3.12667730257737],
["2c1o",2.75,3.41276071581655],
["1ati",2.75,3.14498911560458],
["1jct",2.75,2.95000638637836],
["1qoo",2.75,2.41900352789708],
["1vam",2.75,2.8881077873809],
["2ffv",2.75,3.20590405406151],
["1xup",2.75,3.95278811969898],
["1jui",2.75,2.9632617796203],
["1i5l",2.75,3.33644925466251],
["1jyc",2.75,3.33419294100662],
["1o7l",2.75,3.49917902450666],
["4ota",2.75,2.17229632652174],
["1sr6",2.75,3.67067384974137],
["1e0y",2.75,2.7994837884114],
["1ht5",2.75,3.0711329335377],
["1bko",2.75,3.35637809447629],
["1mp5",2.75,3.09851029633901],
["1le5",2.75,3.98667642829433],
["1diq",2.75,2.22821482277993],
["1t1f",2.75,3.55347322184897],
["1tqq",2.75,3.27047380780614],
["1txv",2.75,2.92721786897809],
["1j0c",2.75,3.44243143266395],
["1qxs",2.75,3.16526960542430],
["1m2v",2.75,3.03539981333762],
["1hjv",2.75,3.21274891865712],
["1vz8",2.75,3.36224039146203],
["1jvo",2.75,2.57068017530029],
["1yyl",2.75,3.08263781906730],
["1ege",2.75,3.2939058519784],
["1sxg",2.75,3.53452898735518],
["1u8r",2.75,3.0877899439628],
["1y8r",2.75,3.21773046821979],
["1smj",2.75,4.09496209386344],
["1k90",2.75,3.51720481292892],
["1td9",2.75,3.34483405438395],
["1a4z",2.75,3.00444894339488],
["1qqw",2.75,3.48145983487968],
["1liw",2.75,3.62253615509739],
["2cea",2.75,3.16253455194026],
["2ajb",2.75,3.03859748733344],
["1iru",2.75,3.18440985800321],
["1fg2",2.75,3.05574883267607],
["1a19",2.76,3.78785859261543],
["1ilh",2.76,3.55447734298258],
["8mht",2.76,2.26718813771958],
["2bob",2.76,2.63535268562949],
["1ki9",2.76,2.87678762279406],
["1b41",2.76,3.14192276703477],
["2bs4",2.76,2.81682008694253],
["1mc4",2.77,3.40210535136697],
["1q4l",2.77,2.69122785760431],
["1bd7",2.78,2.54938888269308],
["1lg1",2.78,2.86121544010232],
["1cjp",2.78,2.30326996809890],
["1oju",2.79,3.14445434469525],
["2bx4",2.79,2.48101199116015],
["1uwg",2.79,3.39721793213469],
["2br3",2.79,2.58318709221826],
["1klf",2.79,3.69438695349129],
["1jkp",2.8,2.93254494211748],
["1abq",2.8,3.50206285919088],
["1k9b",2.8,3.38430225506876],
["1ctx",2.8,4.9739258434793],
["1lfb",2.8,3.26426294422774],
["1f7y",2.8,3.66564674424912],
["1dk1",2.8,3.74544046543395],
["1h0y",2.8,3.4088863920515],
["1vc6",2.8,2.74085455295181],
["1vbz",2.8,2.91015917576762],
["1pdr",2.8,2.44737527564085],
["3hvp",2.8,3.95761641941095],
["1kx8",2.8,2.84277329148215],
["1tlk",2.8,3.44961158560827],
["1bmp",2.8,3.92745628789888],
["1f6l",2.8,2.77289238490504],
["1n9o",2.8,2.91228204251284],
["1ar2",2.8,3.55128464630192],
["1plk",2.8,3.70209769594249],
["1hdd",2.8,3.86404214815088],
["1m4m",2.8,3.69388727270014],
["1plj",2.8,3.790252549674],
["1m3w",2.8,2.67593019230049],
["1nwq",2.8,4.20990497662521],
["1qfp",2.8,2.97747203230175],
["1god",2.8,4.24361502518779],
["1uw7",2.8,3.93083439827456],
["1mae",2.8,3.18891154561987],
["1naf",2.8,3.52462985893253],
["1a0a",2.8,4.80492010013656],
["1db5",2.8,2.91032448933825],
["1d2q",2.8,3.91210435719108],
["2bow",2.8,4.14874584353958],
["1h2p",2.8,3.45731910603345],
["2drp",2.8,2.84977995803138],
["1fe3",2.8,3.52861614626067],
["2fid",2.8,2.33440353056674],
["1qa6",2.8,3.75839450108894],
["1oxz",2.8,3.77598402290025],
["1odg",2.8,3.78228715763845],
["1pll",2.8,4.42372384808489],
["2cbr",2.8,2.37814719511122],
["1o84",2.8,2.53208637538297],
["1lo9",2.8,3.67326821433366],
["1hc8",2.8,2.43893712638239],
["1xpx",2.8,3.30619381914834],
["1y39",2.8,2.85404657816104],
["1pkp",2.8,3.00146312430785],
["1fyx",2.8,3.33615114116437],
["1ril",2.8,4.15863328672259],
["2ara",2.8,3.79961166962768],
["2snv",2.8,4.05208352438621],
["1hlo",2.8,3.09647125231925],
["1asx",2.8,2.76907303097154],
["1xou",2.8,3.02306688964288],
["2mm1",2.8,4.03703720433628],
["1e0r",2.8,3.24938130430415],
["1u40",2.8,2.40201384077813],
["1rdd",2.8,4.21501368823746],
["1knj",2.8,3.29662854381591],
["1knk",2.8,3.48199552922539],
["1htn",2.8,2.91906631836968],
["1a3s",2.8,3.23071500805503],
["1jb1",2.8,3.53077452978322],
["1rx8",2.8,3.26798195444993],
["1hlz",2.8,3.75826192688261],
["1qib",2.8,2.42742961909484],
["1sk3",2.8,3.3099942570872],
["1zwl",2.8,2.24649645391124],
["1xts",2.8,2.97391599866426],
["1cid",2.8,3.96050734947424],
["1qhs",2.8,2.54246956054916],
["1wfx",2.8,2.77767743838211],
["1w2e",2.8,2.84513540773317],
["1z81",2.8,3.23458377284595],
["1bdv",2.8,2.83841798350059],
["1w8a",2.8,3.25857168815536],
["1ui1",2.8,2.68642240435324],
["1kb4",2.8,3.179728852628],
["1rw6",2.8,3.96611185577415],
["1szi",2.8,2.81886573580551],
["1lbm",2.8,2.82499422986456],
["1bdr",2.8,2.46807522261828],
["1bdl",2.8,2.95551447646758],
["2bpw",2.8,2.29882916086872],
["2bpx",2.8,2.08070831639866],
["1mui",2.8,2.64416134311610],
["9hvp",2.8,3.26698838643578],
["1zms",2.8,2.84680582221763],
["1hte",2.8,3.14484335607995],
["4fap",2.8,2.63623681727839],
["1jr9",2.8,3.62088261328909],
["3aig",2.8,2.57442277073579],
["1n5o",2.8,3.01105167538646],
["1t2u",2.8,3.34099298582339],
["1vi7",2.8,3.37934660805805],
["1g3y",2.8,3.00650468976685],
["2ahz",2.8,2.65132251229325],
["1cma",2.8,3.36075772744451],
["1k7a",2.8,2.91037711367585],
["1y01",2.8,3.80798951177115],
["1x1p",2.8,3.42116389158631],
["4pad",2.8,4.03147101144805],
["6pad",2.8,4.03998151856144],
["2pad",2.8,4.03686620823443],
["1wau",2.8,3.58562332843086],
["5pad",2.8,4.04467827974877],
["1lkv",2.8,1.91923247104765],
["1byh",2.8,3.42087143080777],
["1pad",2.8,4.04012135955669],
["1p4i",2.8,3.46869669611672],
["2c3z",2.8,3.53733744550379],
["2feo",2.8,4.35011251840375],
["1qym",2.8,2.18562426914204],
["1anb",2.8,2.99487721734576],
["2trm",2.8,3.81840767265397],
["2aem",2.8,3.06075545897399],
["1sbe",2.8,4.06468686150958],
["1xi6",2.8,2.02764756136984],
["3pgm",2.8,5.14544024655343],
["1hek",2.8,4.55325984826093],
["1iy1",2.8,3.06611178670042],
["1ycy",2.8,2.49893650299793],
["4tmy",2.8,3.34489598031255],
["1gfw",2.8,3.25476236481299],
["1skx",2.8,2.84025424660866],
["1qaq",2.8,2.91326846461682],
["1z92",2.8,3.50210486047102],
["1urt",2.8,2.85893508822791],
["1q4x",2.8,3.39240126586131],
["1una",2.8,3.39358795164836],
["1yo7",2.8,3.4432957160827],
["1nxh",2.8,3.65281668281984],
["1sax",2.8,3.15916278654999],
["3hip",2.8,2.61814261313902],
["2bpc",2.8,3.75307759807139],
["1clp",2.8,4.33571866767033],
["2csm",2.8,2.49318629155735],
["1tj3",2.8,2.75397954545958],
["1ave",2.8,3.88936105970065],
["1mhd",2.8,3.71136951725555],
["1dt2",2.8,3.85636940803781],
["1owk",2.8,2.81473391263051],
["1yr9",2.8,3.85557554094336],
["2znc",2.8,2.62457767791597],
["3znc",2.8,2.78685550312345],
["1mdy",2.8,3.45515731828447],
["2fh9",2.8,3.49183041863619],
["1fc2",2.8,3.32347393732556],
["1mdm",2.8,3.45614691244444],
["1pw5",2.8,3.52951201202262],
["9ca2",2.8,2.66857907168937],
["1lda",2.8,2.70296969360858],
["1q39",2.8,2.99482725014288],
["1rxm",2.8,2.56994559291238],
["1uvs",2.8,2.61378035011617],
["1t7s",2.8,3.20344735985572],
["1mrv",2.8,3.47040849631971],
["1ild",2.8,3.01555123005633],
["2bp5",2.8,2.82393316970111],
["1v8q",2.8,2.67439108374523],
["1obt",2.8,2.25793123702241],
["1rww",2.8,2.64736499409801],
["1uvu",2.8,3.49992901563250],
["1ft3",2.8,2.86025812508885],
["1rgs",2.8,3.90619371101427],
["1t2l",2.8,2.73156960448152],
["1mry",2.8,3.43760758097952],
["2brn",2.8,2.78182683958268],
["2bgl",2.8,3.94046916485705],
["1il3",2.8,2.94618859205606],
["1fmp",2.8,3.18044622544066],
["1t3w",2.8,3.10892741475055],
["1c9p",2.8,2.74957739045907],
["1fnh",2.8,3.92672100849095],
["1b0c",2.8,2.46257625921284],
["1gih",2.8,3.07738941297249],
["1of5",2.8,3.51358136316752],
["2sbt",2.8,4.85873408167564],
["1gmv",2.8,3.10184734080189],
["1t7y",2.8,2.54224851187307],
["1wvy",2.8,2.92856308362156],
["1sj5",2.8,2.89520002125138],
["1v4h",2.8,3.15987853584603],
["1fg5",2.8,3.84923440564144],
["1hap",2.8,4.48095017020867],
["1hao",2.8,4.50451462671343],
["2bn0",2.8,2.71217867010044],
["1wl2",2.8,2.79395792674466],
["2azl",2.8,2.83304221191864],
["1boo",2.8,3.12628265867277],
["1n0g",2.8,3.57259159088233],
["1k3e",2.8,3.22053917961776],
["1sq1",2.8,3.19183245817242],
["1g7u",2.8,4.33314597278247],
["1vea",2.8,3.36798906668892],
["1wps",2.8,3.55238574346746],
["1lfv",2.8,3.27745279308975],
["2dhb",2.8,3.78007474740755],
["1bib",2.8,3.78397621601848],
["1noh",2.8,3.28259945016026],
["1nwn",2.8,2.28865568966099],
["1ldb",2.8,3.72743085138719],
["1rct",2.8,3.5682583892189],
["1v3q",2.8,3.68393454929053],
["1yry",2.8,3.67228560393291],
["1pwy",2.8,3.79531903516812],
["1pxk",2.8,3.2041312513897],
["1bmn",2.8,3.23116173951886],
["1h88",2.8,3.4495551459937],
["1rfn",2.8,2.93355227261405],
["1xrn",2.8,2.96184065240803],
["1xrq",2.8,2.99078351179552],
["1qp9",2.8,3.14473424878807],
["2bym",2.8,2.89403426825222],
["2bc9",2.8,3.44787800509996],
["2c3e",2.8,3.40307543389503],
["1iyz",2.8,2.83735783489783],
["1gc7",2.8,3.02801683218163],
["1fot",2.8,3.79511266914569],
["1zpq",2.8,4.23852641558443],
["1ku9",2.8,3.30197968180327],
["1tgz",2.8,3.26247805968496],
["1etq",2.8,3.20921097923894],
["1z1i",2.8,3.78336450960396],
["1zl3",2.8,2.71983852537572],
["1xto",2.8,3.46336015989965],
["1wnu",2.8,3.17655365778032],
["1yhj",2.8,3.8283677297007],
["1md8",2.8,3.30185064512592],
["2vtk",2.8,2.7044306870308],
["1rft",2.8,3.31737797703204],
["1xsr",2.8,3.20433660133677],
["1mtl",2.8,3.03546924471084],
["1baw",2.8,1.53384494111768],
["1e7d",2.8,2.89830512000475],
["1tya",2.8,2.5776976949698],
["1as2",2.8,2.70592803952674],
["2bn2",2.8,3.26447358235725],
["1esp",2.8,2.17149112709091],
["1xz8",2.8,3.08947403379841],
["1edz",2.8,3.30844340212567],
["1p9n",2.8,4.05009248980786],
["1jn5",2.8,2.91858510034561],
["1jik",2.8,3.48084713801773],
["1kv2",2.8,3.96308650328496],
["1xwi",2.8,2.92417586222569],
["1jhw",2.8,3.93105646027263],
["1nrk",2.8,3.98833864242725],
["2baq",2.8,2.95999238173403],
["104l",2.8,4.27740521541902],
["1hfv",2.8,3.16461546655394],
["1mq3",2.8,2.74245511573941],
["1yd8",2.8,3.93281497783909],
["7ici",2.8,4.01172903024547],
["1zqp",2.8,3.93485629159632],
["7icv",2.8,3.97213884790472],
["9icl",2.8,3.96658668004212],
["7ict",2.8,4.01504302639736],
["7icn",2.8,4.03955143179908],
["7ice",2.8,4.0023399872969],
["8icc",2.8,4.07278526867356],
["8ici",2.8,4.09250874755716],
["8icn",2.8,4.09722505624627],
["7ics",2.8,4.18642243095361],
["1bbs",2.8,3.67074697654341],
["1fq8",2.8,3.56149018432656],
["8ldh",2.8,3.77342686286249],
["1g9t",2.8,3.06309405297353],
["1fq7",2.8,4.06136955202149],
["1g9s",2.8,2.85359409340628],
["2cv8",2.8,3.41028385037229],
["1fsz",2.8,3.83265699206115],
["1aut",2.8,3.2444242616953],
["1iz3",2.8,3.31086897962829],
["1k1s",2.8,3.08361136149173],
["1gfq",2.8,2.46960891049728],
["1kof",2.8,3.20617925050679],
["1s0n",2.8,2.85580280115822],
["1im2",2.8,3.53478710845719],
["1scm",2.8,3.40375737799888],
["1evz",2.8,2.84234737011252],
["1y6m",2.8,3.6556427730923],
["1qfk",2.8,3.09646472357775],
["1hng",2.8,2.83373849307844],
["1uv5",2.8,3.34605414194863],
["1wxz",2.8,3.44448519473178],
["4pax",2.8,2.29292804780039],
["1rq1",2.8,2.94769909198610],
["1p50",2.8,2.88914496598077],
["1hrt",2.8,4.25741512109327],
["1gol",2.8,3.71926292976497],
["1vdg",2.8,3.17981876817103],
["2b2p",2.8,3.16435826260625],
["1sv8",2.8,3.25709358186019],
["1zbw",2.8,3.25765899041220],
["3mon",2.8,3.07711867775859],
["4ald",2.8,3.45234999140866],
["1zhn",2.8,2.68428274390283],
["1pz9",2.8,3.46798291382823],
["1kt1",2.8,3.34217650364872],
["1l4z",2.8,3.14229330925205],
["1svw",2.8,4.17661074373191],
["1an0",2.8,3.49859608306438],
["1civ",2.8,3.24727484519925],
["1qlj",2.8,2.52850695851009],
["1gzp",2.8,2.25740062399174],
["1tlj",2.8,3.67733030042935],
["1cdd",2.8,3.64936466687504],
["1mxa",2.8,3.02483831474239],
["1mxb",2.8,3.07524793416283],
["1ns3",2.8,3.50853748125692],
["1x8e",2.8,2.69931710587405],
["1x3z",2.8,3.86601459657775],
["1ni3",2.8,3.30291527846571],
["1bz9",2.8,3.01163712080666],
["14gs",2.8,2.88398372013136],
["1zxz",2.8,3.2618983482472],
["2es7",2.8,3.37802476053611],
["2bs1",2.8,2.78841147126671],
["2ms2",2.8,2.35252932459391],
["1aq3",2.8,2.42418030800408],
["6msf",2.8,2.61627581467190],
["2c51",2.8,2.49837633980713],
["7msf",2.8,2.73717272901145],
["5msf",2.8,2.69788997771885],
["1j95",2.8,2.89317535186194],
["1nnb",2.8,3.07732541264143],
["1xog",2.8,3.23052235110837],
["1jvm",2.8,2.9933754160924],
["1ytd",2.8,3.05851538914101],
["1xs7",2.8,3.14831137588057],
["1cj2",2.8,2.02305144318462],
["1pbc",2.8,2.50005659954726],
["1xnp",2.8,3.78167816363164],
["1o3t",2.8,4.17233843778183],
["1o5h",2.8,2.59975971173056],
["2aat",2.8,4.793430813463],
["1asg",2.8,2.81755887122992],
["1asf",2.8,3.49459588591728],
["3aat",2.8,4.23619285178638],
["1aam",2.8,4.48060047160785],
["1f45",2.8,3.70469935591943],
["1zre",2.8,3.18329261705325],
["1zrd",2.8,3.21720946693406],
["1zrc",2.8,3.41577895519272],
["1i49",2.8,3.31808755500907],
["1vgu",2.8,3.16091324825683],
["1kxj",2.8,2.93828559404861],
["1amy",2.8,2.88245742000699],
["1bg9",2.8,2.75876215106401],
["1shj",2.8,3.19362999782504],
["1c0n",2.8,3.37255841244154],
["1i29",2.8,2.71400784899242],
["1psk",2.8,3.06361425144497],
["2aw2",2.8,2.38398324955788],
["1flk",2.8,3.77649805245077],
["1ex4",2.8,3.43757887103584],
["2f6b",2.8,2.90007924372251],
["6icd",2.8,2.96734094540548],
["2bgw",2.8,3.11205381133833],
["1dky",2.8,3.17353303810119],
["1gss",2.8,3.31505872822773],
["1xm9",2.8,3.87152900576074],
["1a2n",2.8,2.84109655885392],
["1b0v",2.8,2.9560692345176],
["1ysc",2.8,4.06624971027312],
["2adi",2.8,3.42803296627118],
["1xxc",2.8,4.18529676710349],
["1ine",2.8,3.51405379269676],
["1f4y",2.8,3.90968013261979],
["1dwu",2.8,2.77617070167013],
["1bwu",2.8,3.60529704275831],
["2a1a",2.8,2.86155329775432],
["1jrh",2.8,3.17475286126381],
["1cfq",2.8,3.55765684630533],
["2eck",2.8,2.75921923426654],
["1nl6",2.8,3.34814883334784],
["1a5f",2.8,3.94760568559482],
["1plg",2.8,3.02170438989137],
["1cft",2.8,3.3682162942548],
["1ggb",2.8,3.03150941562367],
["1ggc",2.8,3.26438862399304],
["1bbd",2.8,3.77157618138244],
["1eyg",2.8,4.41415856321404],
["1dgd",2.8,2.74832683942483],
["1d7v",2.8,3.24963733311542],
["1dge",2.8,3.31492353692821],
["1gin",2.8,3.03081046936848],
["1ksz",2.8,3.42225713695574],
["1it9",2.8,3.61940209975929],
["1wnc",2.8,4.59249498170224],
["1x75",2.8,3.18624470626156],
["2f19",2.8,3.42999290563339],
["1m71",2.8,3.44873855673508],
["1rmf",2.8,3.39893013531515],
["1dba",2.8,3.54806179346089],
["1ml0",2.8,3.04045264181801],
["1clz",2.8,3.39554531933028],
["1ejl",2.8,2.57969906873299],
["1iq1",2.8,2.80374381876612],
["2lgs",2.8,2.92248730122019],
["1otp",2.8,2.65915814589976],
["1ens",2.8,3.02584214452512],
["1ai1",2.8,3.59813484028225],
["1py2",2.8,2.35286265691891],
["1yz5",2.8,2.79416900880798],
["1l8o",2.8,4.03999149833003],
["1ifh",2.8,3.07366020906518],
["1frg",2.8,2.99707202999791],
["2igf",2.8,3.36387506850398],
["1omi",2.8,3.39408522096592],
["1bux",2.8,2.96842134014185],
["1l1j",2.8,3.46735094294032],
["1joa",2.8,2.51529600009581],
["1w0e",2.8,3.73437165376518],
["1ebp",2.8,3.65114522431408],
["1z50",2.8,2.69178816921455],
["1om7",2.8,2.58675093926494],
["1ksw",2.8,3.5326967552478],
["3f58",2.8,2.90700321400141],
["1nub",2.8,2.87694878819891],
["1grl",2.8,3.86996656389937],
["2f58",2.8,3.30879891332573],
["1mm8",2.8,3.23238948823755],
["2am2",2.8,3.64148185647362],
["1p0s",2.8,3.38517856056205],
["1xr5",2.8,3.10346634969238],
["4grt",2.8,3.38828919771395],
["1uus",2.8,3.23629746267694],
["2d9q",2.8,3.98630113221931],
["1nj5",2.8,2.81811571703608],
["1q78",2.8,2.97145815998099],
["1n9r",2.8,3.42479938542959],
["2btp",2.8,1.95432568748509],
["1xc4",2.8,3.51842915912297],
["1u5j",2.8,2.96225357872755],
["2f66",2.8,3.05803704637073],
["1ab4",2.8,2.84791933918836],
["1nm3",2.8,3.38611010548241],
["1m7u",2.8,3.3299306644295],
["1a52",2.8,2.93104879013913],
["1wp0",2.8,2.88609036958519],
["1c1j",2.8,3.37600121478683],
["1okx",2.8,2.53309671467691],
["1o8n",2.8,2.11499131607401],
["1y7u",2.8,3.15776877997276],
["1x7e",2.8,3.03998501593304],
["3ypi",2.8,3.36663015496848],
["1y1l",2.8,3.49086489706795],
["1tdj",2.8,4.27458913357163],
["1fw3",2.8,2.67891913543636],
["1yf8",2.8,3.67779773358949],
["1tfm",2.8,3.87100737611018],
["1hti",2.8,3.22222885210036],
["1ha0",2.8,3.34738158157673],
["3tim",2.8,3.18298829946963],
["1p8d",2.8,3.27499587755248],
["1iaj",2.8,3.9367271686619],
["1e3k",2.8,3.87934673992898],
["4csm",2.8,2.92491044789964],
["1btm",2.8,3.09635594383204],
["1g6y",2.8,3.31227870076443],
["2b3o",2.8,3.56403177753238],
["1lu2",2.8,3.06525875987084],
["1znc",2.8,2.40507120747472],
["1pio",2.8,3.31037580823951],
["1dqu",2.8,4.2871543935704],
["1u54",2.8,3.07820810296766],
["1i2z",2.8,2.88764151499201],
["1urh",2.8,3.54881709322008],
["1yv9",2.8,2.99600369538849],
["1rqn",2.8,2.8129703068161],
["1hwm",2.8,3.71656771550642],
["1hwn",2.8,3.94005166076449],
["1wk4",2.8,3.55404275602311],
["1p91",2.8,3.68922856632648],
["1pag",2.8,2.6715334566439],
["1vq1",2.8,2.74625784452252],
["1amn",2.8,3.31576973852209],
["1y3h",2.8,3.65237251442203],
["1acl",2.8,3.07159386030126],
["1ax9",2.8,3.25455802794405],
["1il5",2.8,2.7455589062568],
["1n7i",2.8,3.26834775845268],
["1acj",2.8,2.48419141964325],
["2b4m",2.8,2.58026052580675],
["1t6y",2.8,3.65516735418446],
["1gts",2.8,2.84561397452264],
["1tzi",2.8,2.98863000009149],
["1tqc",2.8,3.24875995653372],
["1r3k",2.8,3.09644535747970],
["1qyy",2.8,3.42024896841818],
["1qij",2.8,2.80298262582357],
["1egj",2.8,3.40002049713179],
["5eat",2.8,2.13169692541746],
["2akj",2.8,3.3520558122022],
["1md9",2.8,3.35986361185902],
["1wd8",2.8,3.48714047529288],
["1ybv",2.8,2.45370914523611],
["1tq0",2.8,3.51311320981171],
["1gwb",2.8,3.89552967854325],
["1fvh",2.8,3.58974238328717],
["1a36",2.8,3.1680524800381],
["1mh0",2.8,3.4778805271267],
["1iun",2.8,2.98654847538588],
["1akn",2.8,3.17008590092516],
["1izy",2.8,3.35622645288977],
["1z19",2.8,2.52014227931220],
["1qmf",2.8,2.25344207849949],
["1pgl",2.8,2.85866135697734],
["1d4e",2.8,3.80866889650202],
["1hk3",2.8,2.9123957662869],
["1hk2",2.8,2.97717315803716],
["1xe8",2.8,3.17963579839854],
["1yen",2.8,3.28523562026867],
["1z4u",2.8,2.89661974428290],
["1fok",2.8,3.52032592861687],
["3hhr",2.8,3.21316831886934],
["2pgh",2.8,3.57787957268978],
["1uf9",2.8,3.27973684873659],
["1dgp",2.8,2.90140086059291],
["1qap",2.8,3.60697153704115],
["1xd9",2.8,2.91919961565867],
["1xdb",2.8,3.19146419346824],
["1uh0",2.8,2.48027437373173],
["1uh1",2.8,2.19119491058969],
["1mtn",2.8,3.69725978364582],
["1uor",2.8,4.54033510939353],
["1z8n",2.8,2.75776883454505],
["1cn4",2.8,3.92576583349572],
["1eh4",2.8,3.76181134813049],
["1ibs",2.8,3.23768778130663],
["1a0r",2.8,2.76237002360506],
["1f2n",2.8,3.40480746154354],
["1xgm",2.8,3.49168550887536],
["1jk0",2.8,3.33198466258723],
["2eui",2.8,3.19731102819187],
["2d2q",2.8,3.39778066122963],
["1bkd",2.8,2.46423803029726],
["1kru",2.8,3.36197892652513],
["1krv",2.8,3.45519394129960],
["1qp8",2.8,3.63806396964654],
["1p0n",2.8,2.72391186104822],
["1iev",2.8,2.90638323185173],
["1tm0",2.8,3.40098262475928],
["1bcm",2.8,2.70562679750735],
["1wlh",2.8,3.72636953403268],
["1mrl",2.8,2.38876600335813],
["1z1j",2.8,3.74962478886442],
["2g2j",2.8,3.85091919142474],
["1rfv",2.8,2.56879233041719],
["2bx9",2.8,3.01014825004468],
["1b04",2.8,3.53614296293268],
["4sbv",2.8,4.19627051629126],
["1ck7",2.8,3.83312014934944],
["1sly",2.8,2.68143713650134],
["1avl",2.8,2.69868120611621],
["1k1w",2.8,3.43415888215389],
["1kwp",2.8,3.89816954846584],
["1uvh",2.8,3.94266258279487],
["1k8f",2.8,3.60935154736062],
["1mir",2.8,2.99993908692231],
["1hyg",2.8,3.42397216065377],
["1xa0",2.8,3.33185138545509],
["2fmt",2.8,3.26759207407942],
["1n1y",2.8,2.71869196035746],
["1wcs",2.8,3.2529250041244],
["3fbp",2.8,3.62842243459508],
["1atn",2.8,3.03710245890338],
["2fbp",2.8,3.83037968844121],
["1dk5",2.8,3.48260199387619],
["1ef3",2.8,3.07449631815908],
["1evt",2.8,3.13924677917566],
["2ewn",2.8,3.36083190715093],
["1f88",2.8,3.34123231497192],
["1hzx",2.8,3.55652307426632],
["2f9c",2.8,3.90862604985988],
["1thj",2.8,2.94337640523598],
["1rfz",2.8,3.49886131034811],
["1uu2",2.8,3.61818875817833],
["1vll",2.8,2.31559478014297],
["1e0o",2.8,3.41130592932907],
["1xns",2.8,3.05922056706722],
["1opx",2.8,3.13077955767164],
["1nly",2.8,2.94248880037821],
["1dct",2.8,3.40711480854576],
["1wlq",2.8,3.69679480893592],
["1tv7",2.8,3.00619427921704],
["1fnm",2.8,3.34524269290266],
["1ls5",2.8,4.03455863721084],
["1xe6",2.8,3.0581499060194],
["1cvs",2.8,2.79301334390506],
["1nql",2.8,3.47721992278531],
["1bim",2.8,3.83688179942220],
["1xal",2.8,3.56230039125872],
["1syk",2.8,3.25733393443066],
["1k1q",2.8,3.80191093210462],
["1wpw",2.8,2.76171084128828],
["1otc",2.8,2.47468104198755],
["1dkg",2.8,3.90365679129994],
["1pxt",2.8,3.59548701717527],
["1peq",2.8,2.73418986612987],
["1lia",2.8,2.75222689163119],
["2aja",2.8,3.33239433572028],
["1av8",2.8,2.47775429780198],
["1lgc",2.8,3.47830107700588],
["2atl",2.8,2.96518969292333],
["1gs0",2.8,3.03657892273257],
["1n04",2.8,3.69495720911464],
["1blf",2.8,2.99206214651259],
["1wqs",2.8,4.38990498855045],
["1dpz",2.8,3.74842591476642],
["2pcb",2.8,3.84399642636077],
["1lfh",2.8,3.5660140131827],
["1jx7",2.8,3.41510663116945],
["1uea",2.8,3.46137679122614],
["1vfg",2.8,4.16529223962376],
["1ky9",2.8,3.92230527881992],
["1cjt",2.8,2.03249146805937],
["1tl7",2.8,2.98180834025852],
["1h8f",2.8,2.85766475679793],
["1cju",2.8,2.30293850085656],
["1z9d",2.8,2.69725181468529],
["1fdo",2.8,3.32681526526279],
["1gtl",2.8,3.10440794848116],
["1bjo",2.8,2.26465475030794],
["2a58",2.8,2.55314802608688],
["1zxj",2.8,3.31741985004355],
["1bjj",2.8,3.36219858079753],
["1n25",2.8,3.21365025404775],
["1xrs",2.8,3.48003020678572],
["1xz0",2.8,2.26501739294006],
["1xu8",2.8,3.08375998921592],
["1cd9",2.8,2.80266609943804],
["1kkl",2.8,3.09153695727387],
["2mys",2.8,3.97585176526679],
["1dlh",2.8,3.57857320797461],
["1z7l",2.8,2.9462640876592],
["1qay",2.8,2.74670103712721],
["1kpr",2.8,3.60656925742262],
["1tme",2.8,3.32580462278597],
["1i7t",2.8,3.10390537593007],
["1i1f",2.8,2.82196359164156],
["1gvm",2.8,3.24722141740343],
["1pnv",2.8,3.09164360004659],
["1p1b",2.8,3.51611059074532],
["1i1a",2.8,3.49554648484047],
["2dmr",2.8,2.47433465250765],
["1v4l",2.8,3.59178018244337],
["1pn3",2.8,3.14013288476056],
["1kkm",2.8,3.22766694940744],
["1y6g",2.8,3.42262966891138],
["2bck",2.8,2.67802683354025],
["2b0u",2.8,3.33596839349189],
["1kt2",2.8,2.80876554349085],
["1aib",2.8,3.05433572843393],
["1aoi",2.8,3.02920825418363],
["1qax",2.8,2.72782485061148],
["4rcr",2.8,5.11774791941864],
["1c8m",2.8,2.45873772265353],
["1qju",2.8,2.15005133845946],
["1qjy",2.8,2.20827905140973],
["1qjx",2.8,2.39559848950343],
["1nd3",2.8,2.50077084324797],
["1kez",2.8,3.28075598498058],
["2b10",2.8,2.62031503229499],
["1tas",2.8,3.65709292425139],
["1l1o",2.8,3.8500717188877],
["1mk9",2.8,3.50339949413677],
["1jgw",2.8,2.42694383149378],
["1lk6",2.8,3.32708587172755],
["1ems",2.8,3.16709725072441],
["1qsf",2.8,3.52237993387135],
["1qse",2.8,3.48194059714649],
["1qrn",2.8,3.02981856017367],
["1f6n",2.8,2.96430114416173],
["1rgn",2.8,2.76895011924957],
["1umx",2.8,3.24055472616331],
["1fn4",2.8,4.66052372820057],
["1bi8",2.8,3.76124850252441],
["1iax",2.8,3.00741971508709],
["1u0l",2.8,3.70709345703773],
["1dzg",2.8,3.36544555280391],
["1gg3",2.8,3.87580771779109],
["1odu",2.8,2.33829761259934],
["1vbe",2.8,2.4966826477864],
["1vbc",2.8,2.58722803423541],
["1vbb",2.8,2.53995711450208],
["3hdh",2.8,3.16154049539550],
["1t1l",2.8,3.88504180163836],
["1kfa",2.8,3.28808840642653],
["1p5q",2.8,3.54387236760044],
["2gm7",2.8,2.39566925284413],
["1bye",2.8,4.21304717576901],
["5csc",2.8,4.34091630817837],
["1bln",2.8,2.99995619259176],
["1kd7",2.8,3.55125549233973],
["1sdd",2.8,3.85446581427661],
["1bk6",2.8,2.64964341008298],
["1d5b",2.8,3.60322391769367],
["1a7a",2.8,3.18777260849246],
["1iyx",2.8,3.22172356521659],
["1c72",2.8,2.92140106821129],
["1yj5",2.8,1.97111643191208],
["2bhr",2.8,3.37677378424333],
["1jde",2.8,4.4447674575123],
["1fl6",2.8,3.41827517803644],
["1r43",2.8,3.10880815186718],
["1igf",2.8,3.40390542929176],
["1ggi",2.8,3.41641713892361],
["1m7w",2.8,3.5663467739756],
["1yyw",2.8,3.32425710800650],
["1ad9",2.8,2.57057513551379],
["1fiy",2.8,3.35439842687877],
["3gtu",2.8,2.36226897065429],
["1kx1",2.8,3.40469690788317],
["1og6",2.8,3.30505146436035],
["1hkw",2.8,3.20781675149404],
["1o6p",2.8,3.11324063217012],
["1nsk",2.8,2.84677812703979],
["2fyi",2.8,2.99769447133022],
["1pre",2.8,3.49165500394708],
["1vbf",2.8,3.36828547706757],
["1w7w",2.8,2.51924692360072],
["1pjt",2.8,3.44578094311071],
["1elz",2.8,2.55964977603098],
["1ely",2.8,3.11634424551897],
["1dgk",2.8,2.4189392209034],
["1pqc",2.8,2.43250900161791],
["1hkc",2.8,3.05444692263529],
["1lw0",2.8,3.4428539441869],
["2gbd",2.8,3.19644572604133],
["1f59",2.8,3.41004407329571],
["1q9y",2.8,3.17726230631517],
["1waj",2.8,3.76930250045416],
["1tl3",2.8,3.27107248056564],
["1dgj",2.8,2.61637090697861],
["1acm",2.8,2.89583720582527],
["7at1",2.8,2.77449225823614],
["8at1",2.8,2.96435037010682],
["2at1",2.8,3.23179601489946],
["1at1",2.8,3.26902752745702],
["3at1",2.8,3.41608687498142],
["1qwj",2.8,3.41102034199687],
["1l0x",2.8,2.96863527383681],
["1fhf",2.8,3.02980967678304],
["1aro",2.8,3.66596912779024],
["2ar9",2.8,3.06240028057916],
["1jle",2.8,3.79433480848158],
["1eo8",2.8,3.30394401092955],
["1fat",2.8,3.02810490798351],
["1dtq",2.8,3.47899186835201],
["1i5o",2.8,3.49767306197433],
["1tth",2.8,3.78510832273568],
["1qf3",2.8,2.20020050754256],
["1cj0",2.8,3.24828974737008],
["1jxq",2.8,2.50808387065636],
["1g8w",2.8,2.95266772622994],
["1wth",2.8,3.61267136062821],
["1qfu",2.8,3.46272084986431],
["1lwf",2.8,3.5651635427666],
["2c5m",2.8,3.74811452368787],
["1s1x",2.8,3.53613210747749],
["1agr",2.8,2.89827306835683],
["1tbj",2.8,2.76974008573906],
["1r1o",2.8,3.20064123183502],
["1hqh",2.8,3.68027491307696],
["1t4s",2.8,3.34567181133143],
["2d3p",2.8,2.72657607131599],
["1tv6",2.8,3.3930367376976],
["1lpf",2.8,3.09159759541742],
["1qdo",2.8,2.92794436705623],
["1rt6",2.8,3.33599385772269],
["1hci",2.8,3.67455608223805],
["1im9",2.8,3.02313632947031],
["1akm",2.8,3.35748348315995],
["2ar0",2.8,3.15546633376685],
["1a2a",2.8,3.92310220291132],
["1s9g",2.8,3.85762999291531],
["1typ",2.8,2.78530407918293],
["2bbv",2.8,3.76033115915727],
["1q47",2.8,3.52834967724933],
["1bzq",2.8,3.3379156932707],
["1woa",2.8,2.10675837547654],
["1wob",2.8,1.98255599663591],
["1lzo",2.8,3.28532458122112],
["1ikx",2.8,3.21841502806921],
["1hni",2.8,3.73544734794521],
["1fgj",2.8,2.92671536536109],
["1jri",2.8,3.23593578541616],
["1tmh",2.8,2.74854569173591],
["1lgn",2.8,2.60381473121958],
["1mhp",2.8,3.35013817279408],
["1g8h",2.8,2.82290383448427],
["1jee",2.8,2.96695053212063],
["1tw8",2.8,3.31910827961121],
["1cqz",2.8,4.10627399187718],
["1cr6",2.8,4.11425691188075],
["2fjg",2.8,2.91176766197814],
["1d5f",2.8,3.56683709605846],
["2akw",2.8,3.17368814880248],
["1l2o",2.8,4.03788674181821],
["1v8o",2.8,3.31423335915766],
["1csj",2.8,3.17338229959719],
["1aql",2.8,3.36759545753898],
["2ad5",2.8,3.76955156253805],
["1eth",2.8,3.94657143408471],
["1djy",2.8,3.46749812441305],
["2a7w",2.8,2.84198003213651],
["1zag",2.8,2.81075255268305],
["1u9z",2.8,2.8021628842388],
["1fxz",2.8,3.16278899209611],
["1dxq",2.8,3.31234993063293],
["1n0f",2.8,3.55928294482360],
["1zj8",2.8,2.62645423102934],
["1mab",2.8,4.11738037389394],
["1kia",2.8,3.46490055587874],
["1dzn",2.8,3.26415915246946],
["1u0r",2.8,3.55819670508592],
["1bq7",2.8,3.05135835227581],
["2vao",2.8,3.71082177787542],
["1fvv",2.8,2.94820426094673],
["1h28",2.8,3.82869866031153],
["1hv4",2.8,3.51712404255283],
["1gn1",2.8,3.2890612975669],
["1ozb",2.8,2.88236525079267],
["1nvf",2.8,2.90016954403622],
["1nbh",2.8,3.55056995331443],
["1xni",2.8,2.89430117084104],
["1sma",2.8,4.08965628054207],
["1xxj",2.8,3.3573786543121],
["1j0j",2.8,2.87271054940090],
["1n0h",2.8,2.34544711543015],
["1oy0",2.8,2.68556117984439],
["1b7b",2.8,2.78311266796399],
["1qhm",2.8,3.25712625476607],
["1mpy",2.8,3.10587871684454],
["1khr",2.8,3.27795562083772],
["1bqh",2.8,3.62725489427032],
["1mpr",2.8,2.61522925533169],
["1mpo",2.8,3.20285647537558],
["1n1h",2.8,2.87894831450044],
["1n38",2.8,2.93436312105527],
["2b5n",2.8,3.66112601216123],
["1nyr",2.8,3.85882993991272],
["1nb3",2.8,3.84840154315191],
["1lt9",2.8,3.23579437074854],
["1qrq",2.8,2.6290170867489],
["1ltj",2.8,3.14279438714272],
["1spi",2.8,4.29039746566393],
["1igt",2.8,3.48905095547718],
["2bis",2.8,2.69981479363148],
["1ty3",2.8,3.03561462767087],
["4gpd",2.8,4.9221257499632],
["1ihx",2.8,2.57208349485598],
["1o6o",2.8,3.16477292227483],
["1qmi",2.8,3.73039607464969],
["1bos",2.8,1.6662029326183],
["1p3h",2.8,3.0335394371133],
["1xp4",2.8,3.4293820237835],
["1m63",2.8,2.58326519998029],
["1avo",2.8,2.50054345629397],
["2awo",2.8,3.58570260779713],
["2hmi",2.8,3.87586581119245],
["1r0a",2.8,3.65686784772196],
["1gyp",2.8,2.76571713357724],
["1a7k",2.8,3.00191812392353],
["1nlx",2.8,2.86320596532483],
["1qdu",2.8,3.85471783978818],
["2fgh",2.8,3.00246895663627],
["1lyl",2.8,2.37434483749926],
["2brw",2.8,2.83591558841977],
["1q1b",2.8,3.78248462453452],
["1cf1",2.8,3.22428570593751],
["1lm1",2.8,3.92836391193279],
["1pww",2.8,3.44652085738209],
["1kmn",2.8,3.7776784559137],
["1kqg",2.8,2.11591172611954],
["1e94",2.8,3.56826684913189],
["1r6z",2.8,2.98119065332397],
["1qxp",2.8,4.44356847333995],
["1hqy",2.8,3.74623012100532],
["2b36",2.8,2.99675452096841],
["1ll6",2.8,2.89665556177110],
["1ll4",2.8,2.91523585426593],
["1m6x",2.8,3.0547186890038],
["1rdf",2.8,3.73136555177871],
["2bwo",2.8,2.4352845946434],
["1ych",2.8,3.32638784689801],
["1ycg",2.8,3.32638120802957],
["1bvr",2.8,3.71877997579203],
["1vyj",2.8,3.57469418482987],
["1g6r",2.8,3.84162403846937],
["1dq9",2.8,3.37612382502221],
["1rzr",2.8,4.12079799279685],
["1nl3",2.8,3.32384653192699],
["1ady",2.8,2.7927250682152],
["1ygp",2.8,3.06732541899532],
["1b3r",2.8,3.16857435712343],
["1ky4",2.8,3.34674388660124],
["1xtu",2.8,2.80477991925772],
["1rqc",2.8,3.50421853820364],
["1xwf",2.8,3.56682745870099],
["1ky5",2.8,3.47326126969561],
["1d4f",2.8,4.09282695287129],
["1jym",2.8,3.27633113715033],
["1mfz",2.8,2.95064270129735],
["1nfd",2.8,4.31743505918146],
["2ap9",2.8,3.24741052277868],
["1y18",2.8,2.96849352473906],
["1xwo",2.8,3.39103891641744],
["1bg3",2.8,2.90492502576479],
["1hkb",2.8,3.27662846256385],
["1jag",2.8,3.10437553451031],
["2acl",2.8,3.29168731812126],
["1ao0",2.8,2.91545583152888],
["1e0u",2.8,3.18025264088188],
["1ohy",2.8,2.42156522254521],
["3sqc",2.8,2.646432610042],
["1gsz",2.8,3.10427165839143],
["1h36",2.8,2.61069219622308],
["1o79",2.8,2.7842220976947],
["1h37",2.8,2.82326863272936],
["1h3b",2.8,2.82942806236824],
["1o6h",2.8,2.92179380133297],
["1h35",2.8,2.76226717934095],
["1h39",2.8,2.85154175533329],
["1o6q",2.8,2.92767344343208],
["1pwe",2.8,3.23143790967935],
["1aei",2.8,2.57898249463990],
["1uul",2.8,3.28277798335593],
["1iqp",2.8,3.33907064279235],
["1y9e",2.8,3.8928859816753],
["1uys",2.8,3.21602637614994],
["1th3",2.8,3.48947546100649],
["1th2",2.8,3.51692464519966],
["1tgu",2.8,3.58468214877806],
["1bpw",2.8,3.05821235224028],
["1w2x",2.8,3.19301080987105],
["1g8x",2.8,3.30374980774127],
["1oqb",2.8,3.0794858676853],
["1t5a",2.8,2.73906408378486],
["1mok",2.8,3.27879602803752],
["2a1t",2.8,2.94089544873597],
["1geh",2.8,3.59223948678349],
["1za6",2.8,3.6883620446251],
["1foe",2.8,3.25662510228478],
["1e2t",2.8,3.6516638497701],
["1ohf",2.8,3.04219981130822],
["1g23",2.8,2.54297452126029],
["1gl6",2.8,2.93944297834572],
["1rfu",2.8,3.4929563046899],
["1v9l",2.8,3.38673455825528],
["1n5x",2.8,2.75071898001667],
["3pva",2.8,3.17071683707776],
["1wpl",2.8,2.62156920772485],
["1is7",2.8,3.15913664617842],
["1t8w",2.8,3.19422073384332],
["1kfl",2.8,2.68666188491133],
["1u9i",2.8,3.39224652174126],
["1yjx",2.8,2.95013699912516],
["1tf7",2.8,3.38092458232458],
["1iph",2.8,2.72218057789916],
["1lwu",2.8,3.6467465464211],
["1ohh",2.8,3.30985451563197],
["2otc",2.8,2.77058428930370],
["1ht2",2.8,3.71752743557207],
["1ht1",2.8,3.72465966402701],
["1hwz",2.8,3.73018261554199],
["1jmu",2.8,2.63295926591767],
["1de4",2.8,3.29998107404338],
["1zgl",2.8,4.01374611106158],
["1zm9",2.8,3.40935119551699],
["1zpu",2.8,2.86817368689311],
["1mx5",2.8,2.81860109019696],
["1abb",2.8,3.66739017151392],
["1n3r",2.8,2.87447241349551],
["1fbx",2.8,2.98434691324449],
["1k83",2.8,3.42621086684982],
["1rv2",2.8,3.47041472166723],
["1occ",2.8,3.03320913244459],
["1oco",2.8,3.17133754041695],
["1i50",2.8,3.32532944909528],
["1m90",2.8,2.96995353151326],
["1jqk",2.8,3.41291225507592],
["1fqv",2.8,3.25722850507517],
["1oel",2.8,2.79505175144656],
["1yit",2.8,3.04293016053827],
["1qun",2.8,3.69772699836828],
["2bo8",2.8,2.95760445419518],
["1ye9",2.8,3.24765045640633],
["1kv3",2.8,3.09569825184440],
["1n4r",2.8,2.61037492951432],
["1mfr",2.8,2.03389339374661],
["1f4a",2.8,3.3565457490522],
["1f4h",2.8,3.78912137537073],
["1f3x",2.8,3.24749721999604],
["1ryy",2.8,2.33602820685231],
["2c37",2.8,2.53497717391052],
["2br2",2.8,2.57023748659244],
["1n6d",2.8,2.94819259259157],
["2fak",2.8,2.92352118702281],
["2f16",2.8,3.00962040262928],
["2a6e",2.8,4.13835208989003],
["1rxs",2.8,2.28553053732286],
["1wf4",2.8,3.17220632605595],
["1we3",2.8,3.15680221425455],
["1mcz",2.8,2.12402875831614],
["1mt5",2.8,2.89497538678338],
["2fg5",2.8,1.81512361292724],
["1tt4",2.8,2.7930473162424],
["1yew",2.8,3.89972799107848],
["1zmw",2.8,2.93063553348601],
["1pcq",2.81,3.17954131499672],
["1svt",2.81,3.36124761030642],
["1jzb",2.81,3.03382008747969],
["1u6l",2.81,3.62488934867318],
["1uvr",2.81,2.76338651537551],
["1t6i",2.81,1.57523440851301],
["1yw1",2.81,2.72942700477865],
["1u6a",2.81,2.81554281643885],
["1rj5",2.81,2.78588040187285],
["1tkz",2.81,3.31938795644995],
["1xdi",2.81,3.47073544626772],
["1lwe",2.81,3.4680464453881],
["2af7",2.81,3.54565928735164],
["1vfo",2.81,3.02925791673252],
["2fie",2.81,3.06551215478798],
["1rf0",2.81,3.19772341017318],
["1i2d",2.81,3.02865072087414],
["1q6w",2.81,2.86030977288148],
["1lb1",2.81,2.65378569514028],
["1ver",2.82,3.21743984395578],
["1ha5",2.82,3.36724461943345],
["1hl0",2.83,2.87548391309959],
["1hzv",2.83,2.85912191711622],
["1e51",2.83,3.39112695233153],
["1udu",2.83,4.27362698288526],
["1qlr",2.83,3.20128446239128],
["2br5",2.83,2.77689954012898],
["1j2q",2.83,3.45651369386582],
["1kuq",2.84,3.17755658657476],
["2mib",2.84,3.12054093899935],
["1h2n",2.84,2.11213794145498],
["1tsi",2.84,3.81046516129741],
["1jus",2.84,3.3913206959065],
["1p8m",2.84,2.89526904342606],
["1u3p",2.85,2.66891393249358],
["1odh",2.85,3.43738825017361],
["1mwj",2.85,2.37129801445943],
["1vei",2.85,3.3042751002862],
["1h3w",2.85,3.45883430450646],
["2d2s",2.85,3.30074069263125],
["1uiy",2.85,3.13143353077837],
["2er8",2.85,3.20548187753612],
["1lsu",2.85,3.87651605330143],
["1tnr",2.85,2.75788314283062],
["1v41",2.85,3.74252325092298],
["2c7l",2.85,2.51442244613788],
["2ago",2.85,3.11260617582172],
["1xqb",2.85,3.25884148326731],
["2cfb",2.85,2.60290814835645],
["1imv",2.85,3.18982850057537],
["1dzs",2.85,2.54650151332355],
["1u1y",2.85,2.84948016441983],
["1p7r",2.85,2.86459845558754],
["1jx0",2.85,3.56973448750602],
["1ttu",2.85,3.57451431604644],
["1uex",2.85,3.16793448403108],
["1nj6",2.85,2.84494454764391],
["1jpy",2.85,3.15183907706287],
["1sq7",2.85,1.76105862311464],
["2bx2",2.85,3.14192936200911],
["1b9b",2.85,3.24454876273148],
["1jxe",2.85,2.44593661408302],
["1e3q",2.85,3.43068207992960],
["1gji",2.85,3.60742387393136],
["1v4j",2.85,2.85343886944277],
["2d2m",2.85,3.30765370687565],
["1mr1",2.85,3.60514348435294],
["1xl6",2.85,3.47552555048372],
["1sqc",2.85,2.68446562867698],
["1u80",2.85,3.1819290143487],
["2fa2",2.85,3.33033822119976],
["1vrs",2.85,3.00526215202896],
["1v53",2.85,3.03381961465945],
["1vcu",2.85,3.07480036394195],
["1jtx",2.85,3.59910165777249],
["1w3b",2.85,3.54255085309976],
["1mhe",2.85,2.96772270693496],
["1nua",2.85,2.97966916189513],
["2bl4",2.85,3.32323249038411],
["2bi4",2.85,3.56402081208017],
["1dzh",2.85,3.20490221695319],
["1m8h",2.85,2.93382889505468],
["1zlw",2.85,3.17538697278948],
["1jfm",2.85,3.83372915816756],
["1rit",2.85,3.06370589681300],
["1tkx",2.85,3.30351800024763],
["1dzq",2.85,2.47482130002478],
["1h4s",2.85,2.91343832145347],
["1l2g",2.85,3.52743397038037],
["1qe1",2.85,3.62209186078022],
["1r2s",2.85,2.26730060426399],
["1z0z",2.85,2.88850939486887],
["1shz",2.85,3.18669481723091],
["1yj8",2.85,1.85129592559482],
["1h1c",2.85,3.56012943512881],
["1uu0",2.85,3.70569453340954],
["1j5s",2.85,3.08992272848772],
["1lql",2.85,3.44338879011130],
["2b9b",2.85,3.18754932753460],
["1pwv",2.85,3.44906642213055],
["1n5a",2.85,3.28720009941178],
["1fun",2.85,2.76524134644065],
["1frv",2.85,4.17330335616272],
["1n0v",2.85,3.10295213762353],
["1jnh",2.85,3.58876665526693],
["1pzn",2.85,3.73320965321073],
["1f30",2.85,3.03023064257359],
["1h3a",2.85,2.63215521312004],
["1w8q",2.85,2.71859424005949],
["1xco",2.85,3.43406245705066],
["1kn0",2.85,2.97221805025616],
["1sqv",2.85,3.355152078717],
["1sxj",2.85,3.39542803302564],
["2b5l",2.85,3.70299302280748],
["1w0k",2.85,2.63838912033108],
["1bmf",2.85,3.28899694785686],
["1up4",2.85,2.57626411454754],
["1tnb",2.85,2.56484537583099],
["1jkq",2.86,3.74730293436443],
["1q46",2.86,3.18678512817258],
["1v45",2.86,3.65245226521878],
["1mc0",2.86,3.20251317084051],
["1zdk",2.86,2.84312855955734],
["1x8z",2.86,3.34424452782044],
["1imh",2.86,3.34518470026129],
["1u5i",2.86,3.99873333287358],
["6gpb",2.86,3.25694245031309],
["1y56",2.86,3.18815310028701],
["1p33",2.86,3.15702088300593],
["2bzf",2.87,2.90579580326237],
["1ja2",2.87,3.22008122395866],
["1c1z",2.87,3.38047902362203],
["7mht",2.87,1.84482274424494],
["1bvl",2.87,3.88625317526876],
["1lix",2.87,3.96843813826081],
["1sej",2.87,3.28236490333168],
["1pyg",2.87,2.95719905787526],
["1dff",2.88,3.20461955248837],
["2gki",2.88,3.41741378564127],
["1ud8",2.88,2.82452302749852],
["1yy3",2.88,4.0637262600389],
["1s76",2.88,3.61194831300111],
["2plv",2.88,3.49691858659125],
["1veb",2.89,2.55552132904034],
["1qvt",2.89,3.53434584823531],
["1r52",2.89,3.04727392376538],
["1ju6",2.89,3.06693751997808],
["1rqf",2.89,2.67006501099396],
["1fpy",2.89,3.55913216564308],
["4hb1",2.9,2.33511452856437],
["1rgv",2.9,2.86890650646366],
["1q1h",2.9,4.10445406251494],
["1l9a",2.9,3.54464018046379],
["1vby",2.9,2.61734597944272],
["1ysa",2.9,3.41409756992567],
["2bnk",2.9,3.40315541845475],
["1an4",2.9,4.81113203875435],
["1dkt",2.9,3.16500199968463],
["41bi",2.9,2.95393693025621],
["1rmv",2.9,4.28567327062530],
["1kxb",2.9,2.71369406261154],
["1hlm",2.9,3.70833907155704],
["1glu",2.9,4.39021104391882],
["1ble",2.9,3.16249610501474],
["1fyv",2.9,3.46827374779013],
["1std",2.9,2.75620083343948],
["1nuk",2.9,3.95062368174325],
["2fgs",2.9,2.61462501873858],
["1an2",2.9,4.34240570531076],
["1etu",2.9,3.77175547187653],
["1grq",2.9,2.91042978796120],
["1grr",2.9,2.8851199433757],
["1cdi",2.9,4.26441148236294],
["1tgh",2.9,3.65613053531623],
["1wqh",2.9,3.58717799966587],
["1i5d",2.9,3.99670089399359],
["1h6o",2.9,3.34417102206526],
["1wd6",2.9,2.55451433698054],
["2dli",2.9,3.79264858489106],
["2fzl",2.9,3.79127775352048],
["2cax",2.9,2.74292592336069],
["2anb",2.9,2.53808740386697],
["1l0a",2.9,3.41957168734855],
["1qpl",2.9,2.80181338321421],
["1rm9",2.9,2.87218494075591],
["1lel",2.9,3.51704751781771],
["4skn",2.9,3.02865780737471],
["1tfp",2.9,3.06198036592848],
["1z37",2.9,2.99173887166078],
["1d9g",2.9,2.78397203064091],
["1rxh",2.9,3.63772193479666],
["1mzd",2.9,3.35981326332218],
["1u2t",2.9,2.76106397663328],
["1e7k",2.9,3.32173839487701],
["1wsp",2.9,3.48299524529853],
["1muo",2.9,4.2649328138372],
["1va7",2.9,1.93060849579448],
["1nq1",2.9,3.62816186942348],
["1scq",2.9,2.04178726123737],
["1hlc",2.9,3.17277520715371],
["3prg",2.9,2.92207000245758],
["1a5i",2.9,3.1393622052456],
["1pl9",2.9,3.84771548052259],
["1an7",2.9,3.09658953152409],
["1cbr",2.9,2.90609814022388],
["1fiz",2.9,3.202393735022],
["1i1g",2.9,3.66114231314734],
["1wm0",2.9,3.60432229110677],
["1qqe",2.9,3.27796764418166],
["1ft4",2.9,3.90985294557972],
["2b0l",2.9,3.76204077554537],
["1d3q",2.9,3.1313815007778],
["1iqi",2.9,3.65002991033457],
["1ioe",2.9,3.74914109051263],
["1iqe",2.9,3.82841799073299],
["1rpz",2.9,3.44437067639247],
["1q1k",2.9,3.45521256163615],
["1hut",2.9,4.62702871230878],
["1rfg",2.9,3.96978254478614],
["1ovv",2.9,3.78416928604132],
["1jwa",2.9,3.31494014903725],
["1ptt",2.9,3.17435351606112],
["1zcl",2.9,3.91156012287773],
["1u0d",2.9,3.81661062233739],
["2bk0",2.9,2.51884777597239],
["2cbn",2.9,3.41318929687597],
["2fk6",2.9,3.47280089474534],
["1p6a",2.9,2.40340099256110],
["1bcf",2.9,2.99753294539239],
["1az2",2.9,3.47464223912276],
["1thy",2.9,2.89542828164697],
["1tsv",2.9,2.98054378124743],
["5lip",2.9,2.27556512524584],
["2bpf",2.9,4.05490956387891],
["1isn",2.9,3.38234807487828],
["9icm",2.9,3.95939106905795],
["7ich",2.9,4.05007826622025],
["7ick",2.9,4.00106750572115],
["9ico",2.9,3.97645019697372],
["8icm",2.9,4.02128205938185],
["7icq",2.9,4.00908351426418],
["9icq",2.9,4.0521011412544],
["9icu",2.9,4.03254316977216],
["8icp",2.9,4.10090897008552],
["9ich",2.9,4.07223029297661],
["8icr",2.9,4.13297450190282],
["1zqf",2.9,4.12348164227757],
["9ics",2.9,4.11479164248075],
["8icf",2.9,4.13317194282834],
["8ics",2.9,4.1540699694655],
["1c8o",2.9,3.4444594869047],
["1x7a",2.9,4.12987750095056],
["1agx",2.9,3.62348786389732],
["1grv",2.9,3.08516211870441],
["1l0o",2.9,3.51577944874504],
["1qp7",2.9,3.98945345167375],
["1qp0",2.9,4.07004914057361],
["2pua",2.9,3.95815198543951],
["1jfs",2.9,3.89694370452283],
["1lw7",2.9,3.68035784151578],
["1ctp",2.9,3.86668519429894],
["1vci",2.9,2.80862935971446],
["1nun",2.9,3.36076617949559],
["1f02",2.9,3.41416448407531],
["1zsh",2.9,3.78149004780903],
["1j7v",2.9,3.43904061416647],
["1jsy",2.9,3.73744282643997],
["2jdx",2.9,2.65626256433617],
["1ljy",2.9,3.38514813983318],
["2b40",2.9,3.22733843520533],
["1xhg",2.9,3.2679894536373],
["1tfv",2.9,3.71881155791526],
["1zbk",2.9,3.41731967595181],
["2aos",2.9,3.62946709936389],
["1kaw",2.9,4.40417518643987],
["4caa",2.9,2.97604185352733],
["1b7e",2.9,4.40331723984277],
["1es7",2.9,2.72958695858511],
["1cmk",2.9,3.55817586199228],
["1fo1",2.9,3.40378703450334],
["1rgq",2.9,2.51406598341725],
["2c5r",2.9,3.45033425297603],
["1adf",2.9,3.14121733844981],
["5adh",2.9,3.58289893846969],
["1hwh",2.9,3.75110649773754],
["1bp3",2.9,4.04997876240146],
["1jhn",2.9,4.28678924176311],
["1ce6",2.9,3.05761420346049],
["1zy0",2.9,3.64832522150366],
["2ghj",2.9,3.17263799873921],
["1py4",2.9,4.42636760783454],
["1zdj",2.9,2.56159267822308],
["1ir6",2.9,3.60688333492709],
["1yue",2.9,3.75204145085649],
["5tss",2.9,3.11419978942579],
["1z1f",2.9,3.29243840290821],
["1sm8",2.9,1.79808441481820],
["1kj4",2.9,3.12811018025232],
["1r5n",2.9,3.33872741518352],
["1ln3",2.9,3.38469476280285],
["1ln2",2.9,3.5726749417291],
["1jdn",2.9,3.36325161536654],
["1fh5",2.9,3.52247974666820],
["1fc1",2.9,3.03943424069592],
["1w7n",2.9,2.86664640868497],
["1k05",2.9,3.38547222218025],
["1nbq",2.9,3.88862190336004],
["2csg",2.9,2.99200694698748],
["1guk",2.9,3.38206107699645],
["2adj",2.9,3.47766389536058],
["2nmt",2.9,3.78397618151737],
["1h3e",2.9,3.14817521500141],
["1baf",2.9,3.06493772532369],
["1z3z",2.9,3.23440698416809],
["1b4j",2.9,3.81956310878132],
["1b2w",2.9,3.5141818907425],
["1nld",2.9,3.41851711806936],
["2dbl",2.9,3.56131417165397],
["1iaq",2.9,3.14574093690384],
["1yyo",2.9,2.99974904047065],
["1e32",2.9,3.45925781757435],
["1dq4",2.9,2.98410415116819],
["2bwt",2.9,1.51477860854930],
["1ejy",2.9,2.98213413103548],
["1cu4",2.9,3.13247148577342],
["1uhl",2.9,3.94798257802989],
["1nt2",2.9,3.80100185056664],
["1kcr",2.9,3.78996635315263],
["1q34",2.9,3.44375876171364],
["1mn9",2.9,2.90650030570414],
["1wv2",2.9,3.38684007177723],
["1i4h",2.9,2.99290911870751],
["1n10",2.9,3.32372732789656],
["2bde",2.9,3.33329392798041],
["1xnx",2.9,3.18331087771036],
["1jn1",2.9,3.76707365524995],
["1r1k",2.9,3.61075974892275],
["1nui",2.9,3.38183660447746],
["1ku2",2.9,3.16591414255682],
["1bpn",2.9,3.26839297916378],
["1bpm",2.9,3.30041674936128],
["2f8e",2.9,2.57329924114317],
["1yl6",2.9,2.7248086553524],
["1ssd",2.9,1.76864166033631],
["1ssg",2.9,2.39390088724189],
["1kmc",2.9,3.00415854949822],
["1p4l",2.9,3.81174782590185],
["2bct",2.9,2.71678406024649],
["1eku",2.9,3.29285103927816],
["1m5n",2.9,3.98728333126895],
["1pkn",2.9,3.66995444534978],
["1a5h",2.9,2.84465855870586],
["1hwo",2.9,3.99949037067358],
["1yom",2.9,3.18370673519335],
["1t98",2.9,3.19936301592050],
["1wnr",2.9,2.69015402118812],
["1v14",2.9,2.88730505320018],
["1xo2",2.9,3.56190384081494],
["1bkn",2.9,3.95584563228505],
["1gqf",2.9,3.41683898859159],
["1qik",2.9,2.92969061962235],
["1pgw",2.9,2.91361879413208],
["1hxg",2.9,2.42940263709919],
["1fbv",2.9,3.41209981162631],
["2fz1",2.9,3.98783704504179],
["2fz2",2.9,3.94368608535221],
["1bf5",2.9,3.59213568270976],
["5daa",2.9,2.37597117397551],
["1igz",2.9,3.64110859553976],
["1j9c",2.9,3.59358891376497],
["4dpv",2.9,3.18339003440664],
["1h79",2.9,3.2916367935015],
["1pkg",2.9,3.34481802170685],
["1xzq",2.9,3.47268341435485],
["1a9w",2.9,1.97758490431584],
["1nip",2.9,4.60002077925673],
["1y8w",2.9,3.22696842159338],
["1coh",2.9,1.79040959534516],
["2d4h",2.9,3.22109179821576],
["2a79",2.9,2.69503588983069],
["1zmu",2.9,3.11042126325512],
["1yi1",2.9,2.53233365561505],
["1hm7",2.9,3.55831972190355],
["1vkx",2.9,4.10577645239795],
["1f8u",2.9,3.1751202201884],
["1lqg",2.9,3.72791747133943],
["1xgn",2.9,3.45160531021901],
["1j4u",2.9,3.42674379804379],
["1qso",2.9,3.00181380577162],
["1tz3",2.9,3.4415132288404],
["1rqg",2.9,3.60102707182395],
["1f7v",2.9,2.93669170103098],
["2fsn",2.9,3.45765361975042],
["1mz6",2.9,3.52754475070993],
["1fbd",2.9,3.05933295711079],
["2a2g",2.9,2.55467365738230],
["1zca",2.9,2.38341812311780],
["1avc",2.9,3.26465151937856],
["1qf6",2.9,3.3850018335214],
["1cja",2.9,3.3299118327147],
["2cvu",2.9,3.12340524485295],
["2cvv",2.9,3.02242216106798],
["1j3h",2.9,3.07071028527129],
["1psa",2.9,2.75934796147315],
["1gpd",2.9,5.08358642363795],
["1zuj",2.9,3.54375524808780],
["1ph7",2.9,2.93067583237943],
["1gzu",2.9,3.86820444906932],
["1yvu",2.9,2.89265800745538],
["2agp",2.9,3.2687904518764],
["1tz9",2.9,3.52319517248366],
["1ybf",2.9,3.2673145533326],
["1brr",2.9,3.39932676547837],
["1tko",2.9,2.59079815106476],
["1u0h",2.9,3.1133976462899],
["1bnl",2.9,3.33914465340582],
["2aek",2.9,2.58857780677867],
["1yyt",2.9,2.89423645159856],
["1b3o",2.9,3.58086973231656],
["1o6c",2.9,3.15099858216483],
["1nkv",2.9,3.34377159532621],
["1fdi",2.9,3.51199573346866],
["1c9i",2.9,3.41700225667544],
["1vsg",2.9,3.01798024214329],
["1c9l",2.9,3.15846521179293],
["1o9t",2.9,3.50425945238615],
["1t13",2.9,2.81395985417636],
["1q1e",2.9,3.47762456832653],
["1g50",2.9,3.75984871122730],
["1rpw",2.9,3.47277683866616],
["1p3m",2.9,2.90773115454715],
["1p3k",2.9,2.91079595182685],
["1wuf",2.9,3.28468308487020],
["1p3f",2.9,3.12470363824086],
["1jt0",2.9,3.65222206670451],
["6adh",2.9,4.37372870719399],
["1r5w",2.9,3.60871522516838],
["1nrx",2.9,3.32293833677059],
["1xvl",2.9,3.64105618083127],
["1zla",2.9,3.04025226632733],
["1fs2",2.9,3.18687246602511],
["1tf2",2.9,3.32998598497816],
["1nfb",2.9,3.79000221694274],
["1gn6",2.9,2.21853397711643],
["1ser",2.9,2.66126981369000],
["2a4z",2.9,3.65867860908251],
["1ayn",2.9,2.25549349976776],
["1ruf",2.9,3.52009768084088],
["1rue",2.9,3.6248867861799],
["1rud",2.9,3.60090309623028],
["1r09",2.9,3.66911387331957],
["1yk1",2.9,3.25848320286759],
["1br8",2.9,3.54480201007283],
["1qjs",2.9,3.13605305798925],
["1mi1",2.9,3.3253136029753],
["168l",2.9,3.96462216460577],
["1m8e",2.9,3.10007036664536],
["1ncd",2.9,3.22902975953612],
["1azx",2.9,2.97877846972612],
["1d4m",2.9,3.02321110825625],
["1eah",2.9,2.46668357175034],
["1h8t",2.9,3.35229860155512],
["1um2",2.9,3.86336381749038],
["1e03",2.9,3.23113308998488],
["1piv",2.9,2.38525571606644],
["1vba",2.9,2.53113858952048],
["1vaf",2.9,3.31687203748208],
["1ar9",2.9,2.32353559491810],
["1ar7",2.9,2.30342773578847],
["1al2",2.9,2.28404862541849],
["1ar6",2.9,2.31117192465226],
["1asj",2.9,2.46670934251025],
["1vbd",2.9,2.48015387707703],
["1ar8",2.9,2.67154155605205],
["1po1",2.9,2.28794183945850],
["1po2",2.9,2.42312081614378],
["1fg9",2.9,3.80311173894134],
["1xqs",2.9,3.36639871997989],
["1ldc",2.9,3.49961494102074],
["1dj2",2.9,2.73196667909276],
["1iai",2.9,3.72755507329944],
["1aif",2.9,4.18569156246597],
["1rus",2.9,3.83910867427801],
["1lco",2.9,3.37479616910678],
["1him",2.9,3.18792351311078],
["4cts",2.9,3.86600494965765],
["1qu3",2.9,4.20783096264569],
["1f5o",2.9,2.38907696963453],
["1f5p",2.9,2.46287638487321],
["2tbv",2.9,4.09602891951400],
["2bvt",2.9,2.97648960658020],
["1tl1",2.9,3.34529403342587],
["2a0f",2.9,4.4596981583475],
["1shs",2.9,3.44624287370818],
["1k28",2.9,3.46238674403674],
["1y4u",2.9,3.32483445529549],
["1v6j",2.9,2.4362557683541],
["1rir",2.9,3.1623389287669],
["1rvy",2.9,2.84352311952674],
["1g9n",2.9,3.63324827968585],
["1rzk",2.9,3.73777007598495],
["1rt4",2.9,2.83638421792058],
["1rt5",2.9,3.05521846143415],
["1p8n",2.9,3.2245058045622],
["1hqf",2.9,3.88628399059761],
["2d3r",2.9,3.022052561601],
["1b9l",2.9,2.74966863176495],
["1dfc",2.9,4.00023443839819],
["1fko",2.9,3.53892793523653],
["1fkp",2.9,3.55540297414363],
["1y4s",2.9,3.5179810358803],
["3hvt",2.9,4.36137179864628],
["2c4c",2.9,2.72815027039941],
["1xdk",2.9,3.92431801607653],
["2bhl",2.9,3.55518796918181],
["1sv5",2.9,4.00711003299814],
["2b5j",2.9,3.89132793046943],
["1s6p",2.9,4.13841958697381],
["1jzr",2.9,3.16894056327547],
["1srq",2.9,3.35735612507567],
["1t5t",2.9,3.13241482784227],
["2csd",2.9,2.62688495648344],
["2bki",2.9,2.39825221782252],
["1pys",2.9,2.79666348417637],
["1ob1",2.9,3.54537914274451],
["1no7",2.9,3.95220499783045],
["1nen",2.9,3.35940305955966],
["1uw5",2.9,3.36243168263293],
["1bl9",2.9,2.66805810762040],
["4prg",2.9,4.17745782115302],
["1n15",2.9,2.3537814549756],
["1n50",2.9,2.38496665676788],
["1n90",2.9,2.38874160225781],
["1e8f",2.9,3.27489425840503],
["1zj9",2.9,3.21824114613076],
["2c5x",2.9,4.2225624501223],
["1a7l",2.9,2.47460853161379],
["2c5v",2.9,3.81685662473977],
["1nhv",2.9,2.90395166234259],
["1bml",2.9,4.04158208473406],
["1nb7",2.9,3.57897932774378],
["1ygr",2.9,3.85357795785432],
["1ygu",2.9,3.87023109507288],
["1dgs",2.9,3.21515130136893],
["1v9p",2.9,3.66902158081988],
["1vfk",2.9,3.1924248017704],
["1vfm",2.9,3.31487793876842],
["2a1b",2.9,4.00457441884573],
["1ze1",2.9,3.5475507601136],
["2pjr",2.9,3.86793395530330],
["1t72",2.9,3.5463334082055],
["1q3u",2.9,3.25192056442845],
["1sv6",2.9,3.40853786101728],
["1n8b",2.9,3.53970630296327],
["1ty5",2.9,3.05822847754699],
["1ty6",2.9,2.94404604125038],
["1cqj",2.9,2.99382950371449],
["1g3n",2.9,3.10581440325554],
["1nd5",2.9,3.46662259079147],
["2hpa",2.9,3.24596368759680],
["1jqj",2.9,3.95688490355775],
["1xcb",2.9,3.55112401830061],
["1us1",2.9,3.04328343956233],
["1fzb",2.9,3.54030180713521],
["1qu4",2.9,3.30184113359442],
["1fza",2.9,3.80770010642425],
["2c2v",2.9,4.32547031278374],
["1f9e",2.9,3.32722964520661],
["1tee",2.9,3.14624484336555],
["1ruz",2.9,3.36237914308684],
["1n73",2.9,3.65820374241036],
["1mql",2.9,3.47358439051092],
["1w1w",2.9,3.31608628102889],
["1ryz",2.9,4.02718132003379],
["3hmg",2.9,2.74922943531965],
["1hgg",2.9,2.83475307485456],
["2pfl",2.9,2.47467499228227],
["2ajf",2.9,3.26921887450673],
["1zyz",2.9,3.29257835741882],
["2f3o",2.9,2.67215459048814],
["1eqn",2.9,3.42546792920608],
["2abr",2.9,4.00425566846946],
["1e4o",2.9,3.64663809270505],
["1ias",2.9,3.28729331156147],
["1we0",2.9,3.33803444710431],
["1ul1",2.9,3.68975180040815],
["1ivs",2.9,3.89192476699019],
["1gax",2.9,3.94706992307181],
["2bte",2.9,3.20436214196252],
["2bvh",2.9,2.83618056826016],
["1h4t",2.9,2.81773289816215],
["1prt",2.9,3.40323280138209],
["1m3i",2.9,3.49622529419250],
["1h3c",2.9,2.79036378723019],
["1eji",2.9,3.28539352923836],
["1g6q",2.9,2.83518812537391],
["1d2r",2.9,3.12208260633292],
["1t9g",2.9,3.27085713655484],
["1vfp",2.9,3.30105783729809],
["1hht",2.9,3.0284822917078],
["1z7m",2.9,3.18736437500054],
["1tr2",2.9,4.15591159680389],
["1m54",2.9,4.04219681627998],
["1q3r",2.9,2.97540807612151],
["1maa",2.9,3.24415684329618],
["1pxx",2.9,3.3253700931009],
["1r1r",2.9,2.50368974345741],
["1d4c",2.9,3.58268846610006],
["1fsk",2.9,3.73326351590836],
["2tmg",2.9,3.49649655888527],
["1tye",2.9,3.11126086659867],
["1r0b",2.9,3.53924833328964],
["1s4e",2.9,2.71076290557663],
["1h8h",2.9,3.12326389348378],
["2c8n",2.9,3.10718846126489],
["1ijg",2.9,3.22150530317767],
["1zm4",2.9,3.27933415400999],
["2a7s",2.9,3.03128957084975],
["1qgn",2.9,3.35353869250263],
["9gpb",2.9,3.78633553185444],
["7gpb",2.9,3.66912497889329],
["1a9c",2.9,2.17630065537179],
["1gpa",2.9,3.85979421620829],
["1rzi",2.9,4.0092242607542],
["1h38",2.9,3.77879937141387],
["1ocz",2.9,3.26944812520277],
["1qvg",2.9,3.148192464898],
["1yjw",2.9,3.08874475668084],
["1mkd",2.9,2.54377518114715],
["1br2",2.9,3.69292897872245],
["1tnz",2.9,2.69756163716315],
["2ewo",2.9,3.64369581782547],
["1pjl",2.9,4.33977467159980],
["1soj",2.9,3.10741187587633],
["1yc6",2.9,3.08684505142418],
["1mx9",2.9,3.1394368590583],
["1zn2",2.91,3.23229023927828],
["1q1q",2.91,3.25275974532055],
["1t69",2.91,3.26846412200946],
["2bq5",2.91,3.02249665748349],
["2glu",2.91,3.19422937239041],
["1gt2",2.91,3.42790557658865],
["1qzu",2.91,3.92008218397783],
["1xxd",2.91,3.55124976279831],
["1kca",2.91,3.07023278492305],
["1x2h",2.91,3.28996492587546],
["2bn4",2.91,3.68065948124413],
["1q3v",2.91,3.49340897964073],
["1zr5",2.92,3.15387012491339],
["1xwd",2.92,3.22955404644122],
["2b5m",2.92,3.77040354446495],
["1xck",2.92,2.83885457105359],
["2ucz",2.93,3.15454754659224],
["1ff5",2.93,3.08251566209170],
["1eaw",2.93,3.57842020930378],
["1gld",2.93,3.97573630445823],
["1ja4",2.94,3.00923387941220],
["1ffl",2.94,2.73911500187228],
["1d3a",2.94,3.08637077642543],
["1gle",2.94,4.06281650235556],
["4rla",2.94,2.61493232320631],
["2bm9",2.94,3.072113630498],
["1bfr",2.94,2.22692510991847],
["1wbc",2.95,3.79435429284491],
["1fzp",2.95,4.7388723373017],
["1iy0",2.95,3.22638132993017],
["1v9i",2.95,3.64330881507133],
["1p8l",2.95,3.50090278918121],
["1yj0",2.95,3.24048162428224],
["2b20",2.95,3.41362664518021],
["2cfq",2.95,4.44134162004386],
["2b2u",2.95,3.83891435820366],
["1l2j",2.95,2.72006157799007],
["1ho8",2.95,4.76487898874755],
["1qos",2.95,2.66185508890468],
["1uwh",2.95,3.06586768521498],
["1p22",2.95,3.94728805125340],
["1de8",2.95,3.32068157743576],
["1p7d",2.95,2.95877791648102],
["1r8x",2.95,3.36244857374261],
["1ka8",2.95,3.77561690662347],
["1vi1",2.95,3.08716726836475],
["1yyu",2.95,2.86140904550228],
["1qjq",2.95,3.32881335068103],
["1u0n",2.95,3.55969602968558],
["1jup",2.95,3.75957853868086],
["1u1u",2.95,4.17531745267071],
["1n59",2.95,3.10209719643159],
["1s7r",2.95,3.10498586758308],
["1a0o",2.95,3.13491705773684],
["1o0u",2.95,2.77326563021772],
["1t34",2.95,3.2160652961078],
["1rv4",2.95,2.68610430724714],
["1p8q",2.95,3.27427845975989],
["1zkm",2.95,3.49412491693376],
["1ngm",2.95,3.61526435495417],
["2ban",2.95,3.89660516274923],
["1sh3",2.95,3.0502981557942],
["1xhu",2.95,3.69812508423252],
["1jed",2.95,2.80413888683123],
["1djz",2.95,3.71210363779885],
["2bxe",2.95,3.03345724136067],
["2bxf",2.95,3.08260365371412],
["1syr",2.95,2.90303619067803],
["2fhy",2.95,2.77980980195856],
["1ywk",2.95,3.37625707654692],
["2ecp",2.95,3.22002550995151],
["1f6m",2.95,3.38546021130686],
["1k93",2.95,3.64685895179754],
["1v5b",2.95,3.44056116095324],
["2buf",2.95,3.73920143033793],
["1q81",2.95,3.18636132070229],
["2bo7",2.95,2.54015482255984],
["1ja6",2.96,2.95319541888584],
["2ldx",2.96,4.49302409039005],
["1rrp",2.96,3.94389206341146],
["2fpg",2.96,3.13522654648174],
["1qvu",2.96,3.53805207217813],
["2etk",2.96,2.36307659988954],
["1p8o",2.96,2.90312103808899],
["1xls",2.96,3.72717703187867],
["2aow",2.97,3.00386545814815],
["1jty",2.97,3.80666990087997],
["2d5n",2.97,3.51044913687352],
["1kyo",2.97,3.20010340627194],
["1sf4",2.98,2.72434214575632],
["1ja7",2.98,3.35567025728113],
["1im0",2.98,3.11961205065829],
["1zx4",2.98,3.95873283919231],
["1jum",2.98,3.62045990742561],
["1zvv",2.98,3.97244205560921],
["1th4",2.98,3.76009358946323],
["1q82",2.98,3.07556986763583],
["2be1",2.98,3.92411637325307],
["1pem",2.99,3.12788061824526],
["1vel",2.99,3.0448483669232],
["1bxz",2.99,3.21932277272078],
["1b3k",2.99,3.25712072278791],
["2fhh",2.99,3.34520975970202],
["1pf9",2.99,3.23276979034645],
["1dgc",3,2.90171196187350],
["6cro",3,4.27387611358778],
["3orc",3,4.36547166562846],
["1aum",3,1.92169021967359],
["1ccd",3,3.77367784964016],
["1jl9",3,3.64564063666485],
["1qoj",3,4.08022800072084],
["1whp",3,2.24489388812517],
["1avv",3,3.37554455294285],
["1fav",3,2.79793402525255],
["1ayb",3,2.65721722381100],
["1cry",3,3.84015789484703],
["1dh3",3,4.66195871531596],
["2ere",3,3.76134680757196],
["1cjq",3,3.28247225351868],
["1h2q",3,3.08083368985355],
["1od7",3,3.00251704763189],
["2bp2",3,4.45764408781927],
["1af5",3,4.17485759092536],
["1uot",3,3.39615466389375],
["1oct",3,2.97590828024905],
["1hij",3,3.18875232875794],
["1bh8",3,3.03566788617375],
["1le2",3,3.79569191957567],
["1fyw",3,3.44482116053928],
["1r4r",3,3.85943700648858],
["1s60",3,3.6229032989241],
["1ufu",3,3.36583418203353],
["2bt8",3,2.93580579535136],
["1bsk",3,1.99869100579659],
["1bsj",3,2.15966113167215],
["1wg3",3,3.5151879439386],
["1ynw",3,3.70715192252573],
["1h9v",3,2.63212575087319],
["1rrf",3,3.87611212776853],
["1dov",3,2.48906432430837],
["1r8i",3,3.59999326629279],
["1v1f",3,3.61086493258369],
["1hrp",3,3.50503680758474],
["2upj",3,3.03948307106213],
["1yt9",3,3.17114652405418],
["2hpf",3,3.86298789776526],
["1ij9",3,2.75554337470753],
["2dl2",3,3.93405963304878],
["1b6u",3,3.87581356800159],
["1o3s",3,3.43062434028887],
["1o3r",3,3.07524052460804],
["1o3q",3,3.37158883691991],
["1dr9",3,3.40904815470653],
["1ykh",3,3.24891133771335],
["1if1",3,4.85670434782736],
["1vzv",3,3.77095113595654],
["1ay9",3,2.24843423053994],
["1fhe",3,4.4458064117752],
["1niv",3,2.57701241084817],
["2blb",3,3.39943309655522],
["1b0f",3,2.86731719798265],
["1rmp",3,3.10096387942325],
["1nhy",3,3.47758090171492],
["1ja3",3,4.41932008522075],
["1x3g",3,3.359879701353],
["1ql8",3,2.73369519443262],
["1nde",3,3.7858891051896],
["1e2o",3,2.73658010307287],
["1lem",3,3.03537886124270],
["1zp2",3,3.15659820809641],
["1iu3",3,4.11546158141419],
["1bu2",3,3.32683415220972],
["1rhr",3,3.76705373433573],
["1j5t",3,3.34616084682845],
["2fpf",3,2.85859300131073],
["1r6g",3,2.74765259810305],
["2not",3,2.39672272936595],
["1rfb",3,4.71414643871739],
["1yow",3,3.31641320335236],
["1dcm",3,3.30467613050253],
["1nom",3,3.91087355563114],
["2avi",3,3.32682618959871],
["1k8r",3,3.35027996136578],
["1ex3",3,4.35444109907849],
["1fv9",3,3.95942055072354],
["1yhn",3,3.81753851627303],
["1pdg",3,4.36320960621650],
["1ijd",3,4.17773323327705],
["1avz",3,3.16059420434416],
["1o7y",3,3.84481529718791],
["1foc",3,4.71509377622164],
["2axm",3,3.22745297715507],
["2c6j",3,3.82507785805793],
["1plr",3,3.65955715680879],
["1hes",3,3.13549418324587],
["1cne",3,4.37260264014109],
["1b3j",3,4.12471259955581],
["2bj1",3,3.29767391244455],
["1dpr",3,3.99114220732457],
["1apg",3,3.21117690249217],
["1gl0",3,2.49312318648019],
["1mvx",3,3.15881164619556],
["2bj9",3,2.37907110432749],
["1ny3",3,3.50855231603416],
["1jyf",3,2.92087641884696],
["1w2o",3,2.76788027143519],
["1gg0",3,3.39409894981056],
["1t7z",3,2.85232445641691],
["1exj",3,4.54754972321754],
["2ayu",3,3.84850260769534],
["1pyp",3,5.06289159445136],
["1wat",3,3.70335552310154],
["1d3t",3,3.17676234202864],
["1iqh",3,3.51464840769316],
["1iqj",3,3.69317066014882],
["1s0h",3,3.88222429051019],
["1nrp",3,4.57215386936322],
["1fax",3,3.09919687912539],
["1h6s",3,2.69718917436837],
["1dwc",3,3.08180098531610],
["1dwd",3,2.89476598636819],
["1dwe",3,2.72663658120827],
["2ldb",3,3.87981688821169],
["1w8b",3,2.51313056167129],
["1ko6",3,3.93194666060826],
["1zrz",3,3.84497690892176],
["1qo4",3,2.24156745483785],
["1g19",3,3.19641711064411],
["1ral",3,4.00994382351839],
["1t62",3,3.35327032934912],
["3vtk",3,3.73258629959572],
["1aow",3,3.95536614773186],
["1h56",3,3.20914311743542],
["1kq5",3,3.11579654969449],
["1hvg",3,3.00443940404616],
["1tsm",3,3.4108092337337],
["1ee9",3,3.09419472504775],
["1n44",3,3.5585373460595],
["1nph",3,3.56083548928774],
["1llc",3,4.20386564352723],
["1qml",3,4.00903602969646],
["1yx9",3,2.87718013466480],
["9ict",3,4.02344007578569],
["7icg",3,3.99616664290919],
["7icm",3,4.07219540204649],
["7icp",3,3.99183867056414],
["8icq",3,4.06825672455455],
["8ica",3,4.09005617781529],
["9ica",3,4.14434367314834],
["1zqn",3,4.04215888696049],
["8icx",3,4.12871175048172],
["9icy",3,4.14640404013355],
["9icr",3,4.09890020583829],
["9icn",3,4.08391417999444],
["7icr",3,4.10730850825823],
["9icf",3,4.17331756959404],
["9icg",3,4.15878867049488],
["8icu",3,4.17701544580668],
["1g0y",3,3.35552443644433],
["3ldh",3,4.98047005863542],
["2c7j",3,3.02445289640018],
["2er0",3,3.32637740686164],
["1qb3",3,3.24349389673485],
["1qqa",3,3.95559034625924],
["1qp4",3,3.93757555215492],
["2puf",3,4.08365224251346],
["1bdi",3,4.07886488537355],
["1bt9",3,3.00343615991986],
["1hxu",3,2.68481441386508],
["1mpf",3,2.91061981225846],
["1mbt",3,2.79373502622755],
["2g9d",3,3.90162523201843],
["1sv2",3,2.92547698246348],
["1rpa",3,3.36245612478777],
["1rpt",3,3.61590002667480],
["1kig",3,3.84560231326175],
["1kdh",3,3.48499657080224],
["1kej",3,3.78570913304824],
["1m6e",3,4.21362583666144],
["2g41",3,3.11234488181215],
["2fdm",3,3.13996789427344],
["1gdt",3,3.27128042860883],
["1zoo",3,2.53367267633722],
["1pfx",3,3.75798210615801],
["1ue8",3,3.64186607564554],
["1ovz",3,3.47617209727323],
["2chr",3,2.86148915043302],
["1d5s",3,3.39407843569656],
["9api",3,2.48210895167577],
["7api",3,2.92220654768796],
["1io4",3,3.50067697613660],
["1xrb",3,3.19479011217910],
["1xra",3,3.24749980775750],
["1xrc",3,3.25709040244523],
["1x3w",3,4.08290410188584],
["1mxc",3,3.11183416248314],
["1e28",3,3.26204740146821],
["1grc",3,3.09154564540717],
["1hhh",3,2.45131819755286],
["1fl7",3,3.47767889202942],
["1zy1",3,3.51969878370001],
["1mva",3,2.32453571394743],
["1aq4",3,2.59224177792164],
["2bny",3,2.57744384126608],
["1mvb",3,2.34722141184894],
["2ala",3,2.65360178125237],
["1shl",3,3.17617696501155],
["1ytz",3,3.7919334372876],
["1zmy",3,3.21697394689635],
["1bgj",3,2.79098458604843],
["1wc4",3,3.19935327050498],
["1cgp",3,3.21397660437292],
["1yq1",3,3.61624727089551],
["1z5w",3,3.63486133087743],
["1slh",3,1.75778902192027],
["2pro",3,4.45994259994132],
["2rve",3,3.7167356467605],
["1vgz",3,3.18426355422877],
["1jq7",3,3.90552610264112],
["1i5e",3,2.80866061689739],
["1wcd",3,3.20566304187582],
["1jnl",3,3.31305470719365],
["1fig",3,3.84927279102141],
["3ck0",3,3.60766869938630],
["1cl7",3,3.79182706867823],
["2fgw",3,3.3960651775265],
["1y6e",3,2.9026569065252],
["2afv",3,3.03887526325395],
["1dbk",3,3.496790052544],
["32c2",3,3.99707761970053],
["1ae6",3,3.40279410134696],
["1rw3",3,4.19316907460828],
["1acy",3,3.40198074727228],
["1vcp",3,3.2942488731942],
["1fpt",3,3.42155483223149],
["1dt6",3,4.02775608611751],
["2bri",3,3.34680644954006],
["2b7y",3,3.79894094577657],
["1qag",3,3.70816822074280],
["2ig2",3,3.33706043842719],
["2atc",3,5.05532495884545],
["1rhq",3,3.89706247887908],
["1r20",3,4.02122061626241],
["2a9n",3,2.94484831054663],
["1f9k",3,2.80676855533126],
["1ddn",3,3.65905055910405],
["1n4d",3,3.36809002689489],
["1lm7",3,3.55942270794699],
["1f5t",3,3.29945336489569],
["1wne",3,3.01741307636996],
["1fq1",3,4.08954581230995],
["2taa",3,4.83014125315906],
["1ti8",3,3.64021357146734],
["1z6a",3,3.76565765520291],
["1zdl",3,3.43133948438214],
["1tdo",3,2.57006778782975],
["2d7s",3,3.63005819303036],
["1bmt",3,3.36553305169427],
["1mo2",3,3.71874850845126],
["1ka4",3,2.77866254355569],
["1ism",3,2.86011564800046],
["3csm",3,2.96428980224616],
["1hjb",3,3.67906021221282],
["1m8k",3,2.86696396723820],
["1ze2",3,3.49526586624070],
["1d0e",3,3.80938510081409],
["1s28",3,3.65408060560172],
["1hux",3,3.22460974175097],
["1lp3",3,4.10047785407257],
["1r10",3,3.33749358286024],
["1qru",3,3.27477789164773],
["1ijf",3,1.84671205278105],
["1y5r",3,3.11840991681151],
["2ass",3,3.37288036375664],
["1i4e",3,3.96083803324512],
["1qim",3,2.98692337230323],
["1gqs",3,3.08012258117948],
["1c8e",3,3.50435828556429],
["1mru",3,3.60542800047949],
["2f1t",3,3.54080409961503],
["1gqw",3,3.22611354294302],
["1zd2",3,3.28214153761918],
["2cas",3,3.4676422518013],
["1c8d",3,3.20322788267933],
["1c8g",3,3.41058859344173],
["1c8f",3,3.53109143540676],
["1de9",3,3.03220342817622],
["1fe2",3,3.73678110176694],
["1diy",3,3.64784045522810],
["3hfm",3,4.17238243101589],
["1adu",3,2.84416765627665],
["1ny7",3,3.09727947571528],
["1eh9",3,4.60479677962702],
["1eha",3,4.65222047134289],
["1bmv",3,4.13680834978827],
["1w2k",3,2.9711260692902],
["1hlt",3,4.06786889641315],
["1seu",3,2.74813555182461],
["1t8i",3,3.13476227998312],
["1equ",3,3.73259511894164],
["1sc7",3,2.61607438879719],
["1cmy",3,3.62938426081333],
["1b9y",3,3.02326847177122],
["1b9x",3,2.82651906843098],
["1xxp",3,2.48851753406658],
["1k7y",3,3.19269326733319],
["2aw6",3,2.72490143844916],
["1tp8",3,2.53409323965081],
["1awh",3,3.6715833492948],
["1iis",3,3.94342831935308],
["1w87",3,3.274977286407],
["1s48",3,3.41760386509314],
["1s49",3,3.41976300618509],
["1fss",3,3.08325102879110],
["1r4l",3,4.17682778869406],
["1d9f",3,2.9765067776014],
["1d6m",3,3.18292822601718],
["1cii",3,3.25590887477499],
["1gff",3,4.19723794994798],
["1bp7",3,3.68494771316464],
["1mqs",3,3.63032801892018],
["1nma",3,3.39087424554931],
["1rlv",3,3.80064676495868],
["2aeq",3,3.73124164966447],
["1smv",3,2.83067242949721],
["1u7x",3,3.67537809961586],
["2g6t",3,3.40959553771756],
["1c6v",3,4.04570860372399],
["2a87",3,3.26450180446515],
["1fpk",3,3.13559363784108],
["2akq",3,3.88955190466228],
["1fbg",3,3.13121441800128],
["1fbe",3,3.46767262788737],
["1c8b",3,3.81976325368479],
["1gxk",3,3.63055007030255],
["1i8l",3,3.46904558290429],
["1x9n",3,3.93159708142804],
["1bo1",3,3.44752976428993],
["2bpa",3,3.41247487535423],
["1hak",3,3.11678316551324],
["1e6j",3,2.49396014550219],
["1ihi",3,3.29409960826891],
["1z3i",3,3.01681721192206],
["1c4t",3,2.84137876770014],
["2aho",3,3.83804859427653],
["1rqd",3,2.35304952494375],
["2ahd",3,3.64831644994790],
["1l5t",3,3.39554262502043],
["1fq9",3,3.09397025592534],
["1zbe",3,3.14402831833104],
["1ebo",3,3.50240529127018],
["2avu",3,3.65557541092189],
["1viw",3,3.79893954728198],
["1peo",3,3.28467270752235],
["1zvu",3,2.89565189434655],
["1a5c",3,3.09183304824868],
["1g88",3,3.07343681103949],
["7cgt",3,3.13078023583267],
["1rgi",3,2.88786486527423],
["1b8h",3,2.89487683125795],
["1gyl",3,4.61430955465979],
["1cjv",3,2.27701647296373],
["1uk1",3,3.83671295871106],
["1uk0",3,4.28419325499132],
["1cjk",3,2.34221927050896],
["2ayq",3,2.86292703815172],
["1tve",3,3.61601393944982],
["1rfq",3,4.53981150330211],
["4rve",3,3.99827022095108],
["1piw",3,3.51600882921668],
["1sp9",3,3.35712902465649],
["1hv8",3,3.6170177831899],
["1rpq",3,2.63209988281614],
["1hlg",3,3.17439334114418],
["1d8e",3,2.62070613613008],
["1p3a",3,2.92954236166497],
["1chr",3,3.9504858611038],
["1dva",3,3.94623555501556],
["1p3b",3,3.02968170416081],
["1zt4",3,3.66582037189286],
["1u35",3,3.11887233952796],
["2fni",3,2.37868688636249],
["1qc9",3,3.66880757420815],
["1zt7",3,3.08950380049493],
["1axm",3,3.31450933606988],
["1efx",3,3.54513071048726],
["1sze",3,3.41105740137574],
["1dch",3,4.20225470300195],
["1miw",3,3.16951622075660],
["1ant",3,3.82035147682647],
["1tau",3,3.77289368098952],
["1bev",3,3.01945998217820],
["1pst",3,3.50146347078756],
["1pss",3,3.59554207866489],
["1tuy",3,3.09110801523726],
["1ruj",3,3.52298826714022],
["1rui",3,3.59690148973834],
["4rhv",3,3.54362804769437],
["1vrh",3,3.59585539108531],
["2r06",3,3.62042103823457],
["1r08",3,3.62693414197538],
["2rs1",3,3.59710029079252],
["2rr1",3,3.59599276344322],
["2rs5",3,3.61776604930229],
["2r07",3,3.65131076327421],
["2hwb",3,3.65624160607941],
["1hrv",3,3.59837340234224],
["2rm2",3,3.62774953690598],
["2hwc",3,3.64723833710795],
["1rug",3,3.6314629347278],
["2rmu",3,3.58959861076205],
["2rs3",3,3.65522480471966],
["1ruh",3,3.61814228208773],
["1rmu",3,3.60820829737127],
["2r04",3,3.63735428341639],
["1hri",3,3.71564678679329],
["1tat",3,3.52465257084911],
["2mev",3,3.58544868965234],
["1rhi",3,3.19869384455324],
["169l",3,4.12638630394462],
["1m74",3,3.62903840562265],
["1ein",3,3.28513761920287],
["1e9y",3,3.59690903066735],
["1e9z",3,3.86947632874409],
["1gxl",3,3.63734371347505],
["1ldj",3,4.23813823730459],
["1gh7",3,3.57752045774108],
["1jzq",3,3.64958622995259],
["1yst",3,4.29988203661701],
["1yuh",3,3.96576469302342],
["3gsb",3,3.07327849623827],
["1qz2",3,3.54498894172742],
["1t04",3,3.17904659003093],
["1wup",3,3.67664376376787],
["1dj3",3,2.79520662112148],
["1hnc",3,2.93768068787996],
["2hck",3,3.25367679832459],
["1azy",3,2.85838088798392],
["2bxr",3,3.2789649671982],
["1he8",3,3.30562077131352],
["1h6z",3,3.41554137961234],
["1h0m",3,3.45356429441157],
["2rla",3,3.76982386085981],
["1rt3",3,3.09223676339919],
["2bg4",3,3.15162900756909],
["1lw2",3,3.53333013272688],
["1osg",3,2.86589032606623],
["1s1u",3,3.43901045031194],
["1h4q",3,3.02411930893287],
["1z63",3,3.55259382752961],
["1jlc",3,3.77910629316404],
["1u2d",3,2.45522667671812],
["1jlq",3,3.65606798242086],
["1qot",3,2.83693164377001],
["1hqx",3,3.69189768378096],
["1m3j",3,3.90790092576455],
["1val",3,3.16721198638581],
["1dtt",3,3.60310724355774],
["1rt7",3,3.21844148102461],
["1jlb",3,3.47703390779532],
["1rti",3,2.96735623086041],
["1ikv",3,3.47484526249548],
["1ikw",3,3.30016777251629],
["1iky",3,3.41791430030789],
["1a3x",3,4.04294817816774],
["1t05",3,3.98427126938834],
["1joj",3,3.44667054551645],
["1a3w",3,4.06022741473189],
["1a0l",3,2.98156965989448],
["1suq",3,3.90331843171921],
["1s6q",3,3.78464226010465],
["1hnv",3,3.88582441566964],
["1glj",3,4.31304055445656],
["1bwf",3,4.37379693554867],
["1gll",3,4.58865447564779],
["1tvr",3,4.23906171692538],
["1hpz",3,3.65277998608492],
["1xv8",3,3.10023660154987],
["1xp5",3,3.5713955976501],
["1jn0",3,3.7628308239132],
["1d2h",3,4.53604343235224],
["1qat",3,3.15710754794328],
["1kcw",3,3.63262665847557],
["2br7",3,2.97694706799386],
["1fez",3,3.75956276258758],
["1zyc",3,3.69342112946625],
["1ek2",3,4.3305876424076],
["1z2c",3,3.29645547892086],
["1ypo",3,2.9570286770536],
["1f8v",3,3.19346269541767],
["1kqm",3,4.3939139151956],
["1qbk",3,4.16984765600448],
["2f43",3,3.96382952380548],
["1nbi",3,3.87740876093805],
["1w1m",3,3.39439944866905],
["1fpm",3,3.8511440745183],
["1pkq",3,3.6399464609031],
["2bhv",3,3.03926131372064],
["1fbi",3,3.68845137039300],
["1myp",3,4.51711335174595],
["1owr",3,3.24500628874279],
["1cj1",3,3.29015907897084],
["1hbs",3,4.63187786710963],
["1kkq",3,4.03168532105473],
["1juj",3,3.33187388596],
["1k23",3,3.13969977540952],
["1z0v",3,4.05484073600569],
["1i7x",3,2.72357427054382],
["1z0t",3,3.93147826196587],
["1efw",3,3.93446773033224],
["1ktk",3,4.15712777625805],
["1le9",3,4.07940585298634],
["1g1y",3,3.20083853851729],
["1f51",3,3.91077256004502],
["1mr9",3,3.693819896417],
["2axv",3,2.82580472078242],
["2axz",3,3.29981103686070],
["2cge",3,3.61193543243954],
["2c6n",3,3.74699160893138],
["1gti",3,2.28841895421810],
["1ahw",3,3.83453847618065],
["1ltk",3,3.6477429930325],
["1rj2",3,3.75636399964045],
["1mpq",3,3.27246309586257],
["1uaa",3,4.31481970494306],
["1tah",3,2.75299553155813],
["1yvl",3,3.67767805402275],
["2erj",3,2.8704023252901],
["2a7r",3,3.25499402308442],
["1rxt",3,4.04937400609128],
["1t2f",3,3.71099958095227],
["1qle",3,3.75575921042563],
["1ihy",3,2.98271916667484],
["1pvj",3,3.12014172893284],
["1qol",3,3.26487163013886],
["1gmo",3,3.12819304819140],
["1rp5",3,3.00158051715237],
["1xdo",3,3.47845728012973],
["1fze",3,3.15935552913266],
["1g4a",3,4.30422854081295],
["1wok",3,3.80764585299214],
["1hys",3,4.0156879740963],
["1n6q",3,4.01086508095907],
["1bvs",3,4.754623223439],
["1jh5",3,3.55189515302209],
["2d0p",3,3.76640936023997],
["1ltl",3,3.36333775060725],
["1vz7",3,3.58719513658426],
["1ord",3,3.49110956348552],
["1llz",3,3.89861235545753],
["1agn",3,3.20494690381102],
["1a81",3,4.53351526319396],
["1hgf",3,2.68399361680481],
["4hmg",3,2.84233936422556],
["2hmg",3,2.97191465751194],
["1m5y",3,3.23400786189194],
["1rd8",3,3.32736946598029],
["1crk",3,3.27011510502390],
["1n3n",3,3.42507351645588],
["1ycf",3,3.4313681877425],
["1yah",3,2.66794428191808],
["1ya8",3,3.07479725207930],
["1ojl",3,4.13785956458469],
["1wb1",3,4.36079527309565],
["2cxe",3,4.44016274285418],
["2nsi",3,2.69858060052935],
["3kbp",3,3.31550861035189],
["2fl5",3,3.32864432661226],
["1e0j",3,3.77388352461212],
["1gum",3,3.34928898805023],
["1a0d",3,2.7628350053656],
["1zs8",3,3.33576349735065],
["1kpl",3,3.30526149962446],
["1vf5",3,4.33200394127419],
["1jqo",3,3.51593550711995],
["2b24",3,3.33257120450122],
["1nlz",3,3.26650499407863],
["1v6o",3,2.90790937716787],
["1l8i",3,3.0669339532372],
["1gph",3,2.88749147115344],
["1s26",3,3.5220912951084],
["1zq1",3,3.59908658593424],
["1qi1",3,2.53566186408305],
["1maw",3,3.43772271278632],
["1mio",3,3.4648525663525],
["1wac",3,3.25025082503905],
["1ukl",3,3.70712987405042],
["1hi0",3,2.9064471894087],
["1hi1",3,3.25301882415451],
["1uvn",3,3.61631340636126],
["1urj",3,3.21382107986997],
["2a3x",3,2.92898518138969],
["1be3",3,4.14408872050130],
["1gnh",3,3.05736415160097],
["1sqq",3,3.3515419117044],
["1i33",3,2.93304145856286],
["5cox",3,3.89684767685715],
["1cx2",3,3.96288758400296],
["1ddx",3,4.35574386330287],
["1m57",3,3.91669402206260],
["3r1r",3,3.07606488853297],
["2r1r",3,2.89104719966918],
["1r8y",3,3.22102909780889],
["1aip",3,3.75552374592994],
["1s4f",3,3.85182844096755],
["1xdm",3,3.7435124611683],
["1n32",3,3.70390092585074],
["1pvo",3,3.51786233242205],
["1pv4",3,3.69503688679424],
["1xmq",3,3.56357130357357],
["1fjg",3,3.58447717363094],
["1xdl",3,3.78316733559761],
["1qvr",3,3.45295052291508],
["1do0",3,3.75011523404042],
["1b26",3,2.40381838394070],
["2pda",3,3.50180811194579],
["1gki",3,2.98687689989824],
["1gl7",3,3.27399080108592],
["1zcf",3,3.22625743276619],
["1lkx",3,3.65035310673542],
["1h4j",3,2.83393719930973],
["1t8y",3,3.21973222329520],
["1xfd",3,3.77830937382496],
["1ea0",3,4.09130011107266],
["2f1d",3,2.66822627680961],
["1x9j",3,2.88467739201863],
["1nbm",3,2.58427624968664],
["1w5e",3,3.45739303282095],
["1g21",3,3.70469458769699],
["1n2c",3,2.78813318567824],
["1ulq",3,2.94432523758109],
["1sxi",3,3.88209357735164],
["1k0u",3,3.65853449384008],
["1twc",3,3.73327688302442],
["2gfb",3,3.3007371785188],
["1nji",3,2.97164759987213],
["1k9m",3,3.04722540788571],
["1q86",3,3.10940971955760],
["1kd1",3,3.07909998597843],
["1k8a",3,3.08165460194820],
["1n8r",3,3.12522247171726],
["1jjk",3,3.67171547736668],
["1yjn",3,3.15325020412438],
["1wdw",3,2.83898412766335],
["2cb6",3,3.1025587603604],
["1z7e",3,3.1545352296657],
["1kiu",3,3.8403055197158],
["1qki",3,3.07107231263182],
["1bgy",3,4.12116675030019],
["1r4m",3,3.28213395860600],
["1hn1",3,3.7072819737483],
["1xfb",3,3.18480782948255],
["1q3s",3,3.39831761935635],
["1f3w",3,3.20367810999349],
["2ex3",3,2.32485062850043],
["1gtp",3,2.30847413477075],
["1jrp",3,3.55736286755086],
["2axt",3,3.54793628421395],
["1jd2",3,3.28706899349873],
["2fny",3,3.14851214075655],
["1zyr",3,4.16888606977088],
["1mnf",3,2.7675489723524],
["1aon",3,3.89625666874907],
["1sx4",3,3.45747979460809],
["1y6j",3.01,3.48781725954834],
["1ps0",3.01,3.60980305399635],
["1z5s",3.01,3.57085728465065],
["1yfh",3.01,3.09015635468439],
["1tly",3.01,3.12364675244489],
["2boc",3.01,2.89332871691635],
["1yvk",3.01,3.39097997387126],
["1jgx",3.01,2.87434893186713],
["1hr9",3.01,2.97597681196253],
["1k73",3.01,2.91825412085961],
["1kc8",3.01,3.02778616561113],
["1k1d",3.01,3.24018286856325],
["1g2m",3.02,3.12751913791557],
["1ii8",3.02,3.68555620782023],
["2b12",3.02,3.23957552500428],
["1u8o",3.02,2.75151764741999],
["2a30",3.02,3.16541475569125],
["2a2z",3.02,3.25843262641149],
["1jch",3.02,4.34947481113464],
["1ua2",3.02,3.85261242489027],
["2byj",3.02,2.09737094146107],
["1vcg",3.02,3.48477927995635],
["1p75",3.02,3.16974867195067],
["1tij",3.03,3.28648059942742],
["1zy2",3.03,3.50262640175195],
["1w1i",3.03,3.0351489699362],
["1ltr",3.04,2.49220305093328],
["1lpa",3.04,3.20343744827820],
["1n8s",3.04,3.52235488640723],
["1vak",3.05,2.85596010785726],
["1fos",3.05,3.05686650038933],
["1nys",3.05,3.45530112386713],
["1zu8",3.05,3.39636492798931],
["1sr0",3.05,3.31162527020978],
["1ksy",3.05,3.06354434864983],
["1pp8",3.05,4.49809565089678],
["1y64",3.05,4.40141941217433],
["1vcw",3.05,3.70983825908128],
["1xiq",3.05,3.10270006860550],
["1bot",3.05,4.36499092756198],
["1xct",3.05,3.81617388276883],
["2bxd",3.05,3.14732802476609],
["1ztm",3.05,3.35724284658654],
["1xn1",3.05,3.2462755212199],
["1xnq",3.05,3.76290425255165],
["1j5e",3.05,3.64871971613317],
["1xpu",3.05,3.04133858057628],
["1p53",3.06,2.85716098051587],
["1jjo",3.06,3.93182436397134],
["2bcj",3.06,2.17456556781503],
["2cxf",3.07,3.2617743844703],
["1z5x",3.07,3.20606551333306],
["1zm2",3.07,3.34652465608482],
["1zm3",3.07,3.40480136670445],
["1l3w",3.08,4.23365405154915],
["1t9x",3.08,3.67398379591927],
["1fub",3.09,3.88342449926061],
["2fkh",3.09,3.05039298608455],
["1tda",3.09,3.65273699766975],
["1faw",3.09,2.99772079518760],
["1qx7",3.09,3.95821923427556],
["1yfl",3.09,3.55723129953554],
["1w57",3.09,3.21660800289411],
["1ifp",3.1,2.38516368019234],
["1ql1",3.1,2.96649699864733],
["1nyh",3.1,2.84649772229195],
["1u6b",3.1,3.09107221558209],
["1fhi",3.1,4.06395012613657],
["1zlk",3.1,3.26173414225013],
["1ql2",3.1,2.85177627891565],
["1r4i",3.1,3.56493420902725],
["1kxc",3.1,2.60463200980388],
["1kxa",3.1,2.84103908999439],
["1llt",3.1,2.93651243234732],
["1c7y",3.1,3.57099633034116],
["1fqx",3.1,3.11179869855107],
["1mfq",3.1,3.42994617980926],
["1ddk",3.1,3.72378225303422],
["1un6",3.1,3.38015661391070],
["2cbf",3.1,3.80465832185314],
["1nuo",3.1,3.69992943633433],
["1qqk",3.1,4.11507948744837],
["1y0x",3.1,3.07557504928604],
["1g5u",3.1,4.37851863404769],
["1il9",3.1,2.91402461201167],
["1i3p",3.1,3.58811508289205],
["1t7x",3.1,2.79143816657729],
["1vg2",3.1,2.96500362816591],
["1lfz",3.1,3.6449174951464],
["1nro",3.1,4.64456109075967],
["1gub",3.1,2.79619351661279],
["1nrn",3.1,3.95073889116316],
["1nyu",3.1,3.67628595677068],
["1vcq",3.1,3.22330976604285],
["1nwe",3.1,2.31861082035638],
["1a87",3.1,3.35988969263825],
["1ij6",3.1,3.33272647781064],
["1p69",3.1,2.68835771374059],
["1mo3",3.1,3.35442191261526],
["1cko",3.1,3.19825198521827],
["1gfn",3.1,2.93106248134916],
["1mq2",3.1,2.36772760280607],
["8icz",3.1,4.1150298924182],
["7icf",3.1,4.05636872893673],
["8icb",3.1,4.12661094871347],
["9icj",3.1,4.20381518021396],
["1zqg",3.1,4.14834580303431],
["1zqh",3.1,4.21457968633868],
["7icl",3.1,4.14230993057272],
["8icl",3.1,4.17405191756948],
["8ict",3.1,4.19178222922921],
["9ici",3.1,4.21533068815717],
["9icp",3.1,4.16556468033631],
["8icy",3.1,4.25262263123525],
["9icc",3.1,4.23471766993190],
["2d4z",3.1,3.39446240478985],
["1jcg",3.1,2.91444017001483],
["1lb2",3.1,3.74138783691019],
["1hl3",3.1,2.95513045792658],
["2hio",3.1,3.15735110058603],
["1tf6",3.1,4.43371980294343],
["2b31",3.1,3.35688469750013],
["1a7b",3.1,3.25061342465168],
["1k8i",3.1,3.36801912680897],
["8api",3.1,3.18786542938116],
["1xqj",3.1,3.2983551334738],
["1ddh",3.1,3.86021027040891],
["1uqs",3.1,4.13541427723781],
["1s9k",3.1,3.42862356565724],
["1ldp",3.1,3.85230365559883],
["1ts5",3.1,1.87435658852043],
["1h3v",3.1,3.61371995336343],
["1gri",3.1,4.09449608186979],
["1mal",3.1,3.32263299554130],
["1bbj",3.1,3.38144889469197],
["1c1a",3.1,3.67557366248056],
["2mcp",3.1,4.06821728374987],
["1hin",3.1,3.71600644111356],
["1fq3",3.1,4.23836285291627],
["1m10",3.1,3.47884994710709],
["1bmo",3.1,2.82119273388281],
["1nh3",3.1,3.02230635249788],
["1q0t",3.1,3.70992966373364],
["1tlw",3.1,3.13711812270581],
["1tlz",3.1,3.34251506960142],
["1fp9",3.1,2.92347586254102],
["1jow",3.1,3.77728089174968],
["1hwp",3.1,4.08179106310251],
["1xfa",3.1,2.94820527952141],
["1euq",3.1,3.59221430901255],
["1n21",3.1,2.59800608184745],
["1ztv",3.1,2.1406594565643],
["1u67",3.1,3.79983085674045],
["1igx",3.1,3.79482705946418],
["1tl8",3.1,3.03136476531807],
["1y8h",3.1,3.093068420135],
["2b3t",3.1,3.99397131045489],
["1nqh",3.1,4.2516161564419],
["1yw6",3.1,3.59824340611038],
["1sms",3.1,3.90115675861945],
["1evw",3.1,3.34827825780489],
["2pah",3.1,3.32286850442283],
["1mc8",3.1,3.8746304316209],
["1xb4",3.1,3.74154471252868],
["1ph2",3.1,2.67425695565411],
["1sr5",3.1,3.77030445126257],
["1mf8",3.1,3.29723406442141],
["1bwd",3.1,3.5580745850498],
["3kin",3.1,4.15499322288314],
["1miu",3.1,4.27240727334427],
["1qkc",3.1,3.80069294411968],
["1yqu",3.1,2.81096030225797],
["1o90",3.1,3.47745856529124],
["1kz4",3.1,2.24036069900224],
["1kz9",3.1,2.40081507078985],
["1ckl",3.1,3.80283642574636],
["1id3",3.1,3.53323974155318],
["1xqg",3.1,3.10273835757299],
["1ktl",3.1,3.60995661179505],
["1f3j",3.1,3.51326154780469],
["1h15",3.1,3.70097944019450],
["1bih",3.1,3.66047262871424],
["1ruc",3.1,3.62671916046061],
["1tbq",3.1,3.15811436147603],
["1k6n",3.1,2.79169274313949],
["1k6l",3.1,2.75534176315432],
["1rlb",3.1,3.81398523413466],
["2rcr",3.1,4.54875645272905],
["1r24",3.1,4.47182084666058],
["1gqq",3.1,3.34355767341178],
["1ibu",3.1,3.47720604551639],
["1yed",3.1,3.22857854147877],
["2tun",3.1,4.01002367134344],
["1q90",3.1,3.20080756803327],
["1tbl",3.1,3.52501020719413],
["1ldk",3.1,4.22998432574991],
["1rz9",3.1,3.10129255319864],
["1mv5",3.1,3.4460955864006],
["1fb1",3.1,3.8730641016207],
["1bqm",3.1,3.61113750945496],
["2bwe",3.1,3.07807070848643],
["1jpp",3.1,2.57908836598157],
["1ek1",3.1,4.46384089306703],
["1e0f",3.1,3.17244324465802],
["2fjh",3.1,3.27091569279909],
["1st6",3.1,3.64380450024377],
["2acz",3.1,3.50814686655992],
["1un9",3.1,3.38881784623523],
["1jwh",3.1,3.94110164863662],
["1ud1",3.1,3.1580381786875],
["1s5g",3.1,3.76912891536052],
["1cqe",3.1,2.62300294459767],
["1ahv",3.1,2.97304220655137],
["1fdv",3.1,3.84852364040529],
["1q7q",3.1,3.47466397351193],
["2bxc",3.1,3.03961047206846],
["1vfu",3.1,3.65928127337909],
["1ob5",3.1,4.45170953701732],
["1smq",3.1,3.40098632520268],
["1nzb",3.1,3.67888474677116],
["1ty7",3.1,3.22697081014424],
["1ere",3.1,2.99456455179362],
["1c16",3.1,3.42651195466898],
["1ynt",3.1,3.77488536377729],
["1t03",3.1,3.7957453137257],
["1n5y",3.1,3.93762838236364],
["2cg9",3.1,3.91933158686996],
["1jv2",3.1,3.86948455696751],
["1zmx",3.1,2.38890338983785],
["1u8c",3.1,3.95226626256547],
["1e69",3.1,3.52096548554887],
["1toc",3.1,3.64445821468575],
["1c41",3.1,2.75211044564812],
["1wb2",3.1,4.35527563627642],
["1gxd",3.1,3.95644327508455],
["1pzu",3.1,3.59288478707166],
["1i9r",3.1,4.19333308709903],
["2exy",3.1,3.82048691086025],
["1jxa",3.1,4.37392047928558],
["1z3h",3.1,3.35714326594261],
["2c57",3.1,3.33228296344942],
["1u6g",3.1,3.98371749876902],
["1iwo",3.1,3.75465835259474],
["1sva",3.1,3.87104040439678],
["1o96",3.1,3.35054696836088],
["5r1r",3.1,3.10441991599272],
["7r1r",3.1,3.17478798413875],
["6r1r",3.1,3.16570018484708],
["1xnr",3.1,3.80391090565102],
["1b3b",3.1,3.23804349789891],
["1xlt",3.1,3.89386123263599],
["1ddo",3.1,3.42504333324399],
["1k5g",3.1,3.65899235432230],
["1cow",3.1,3.30060070064441],
["1efr",3.1,3.33128379614005],
["1q5r",3.1,3.38573313555752],
["1ny6",3.1,4.13845531635149],
["1i3q",3.1,3.56698789453532],
["1qvf",3.1,2.97651586196174],
["1kqs",3.1,3.02458833437373],
["1rxu",3.1,2.27404853292312],
["1e7p",3.1,3.68999777242446],
["1i43",3.1,3.35644006537144],
["1kyi",3.1,3.58934075119068],
["2c38",3.1,2.83178109481839],
["2afi",3.1,2.69235586852341],
["1zmv",3.11,3.32054286007527],
["1rh7",3.11,3.3138246801337],
["1yqn",3.11,2.49072645281532],
["1nj2",3.11,3.11842892493184],
["1t9u",3.11,3.63530369395161],
["1yae",3.11,3.45058274354371],
["1nne",3.11,3.35318305961285],
["1yrh",3.11,2.32565234914699],
["1ibl",3.11,3.74519467128598],
["1exi",3.12,4.53269730256723],
["2aox",3.12,3.25940189234125],
["2fo1",3.12,4.08526716535498],
["1hxm",3.12,3.25482794694908],
["1pfc",3.13,4.97743602212247],
["1r49",3.13,3.44828172184749],
["1lpq",3.14,3.83902141470423],
["2dbt",3.14,2.75412931189138],
["2erg",3.15,3.99931266791123],
["1pm3",3.15,3.8025938867099],
["1zau",3.15,4.35721431946093],
["1q1n",3.15,3.44668215037446],
["1w60",3.15,3.38931125449236],
["2av5",3.15,3.55007556310259],
["1hbx",3.15,3.81708127732418],
["1bke",3.15,3.42560558822188],
["1d9z",3.15,4.0907972130773],
["1tyg",3.15,3.86471537340059],
["1wa9",3.15,3.99849736277741],
["1adq",3.15,3.00784322257835],
["2a81",3.15,2.23805411601857],
["1kfx",3.15,4.16314850105294],
["1ft8",3.15,3.46382035749243],
["2bxs",3.15,3.87196909521704],
["1sgf",3.15,3.03553584753118],
["2g4c",3.15,3.80628964793218],
["1dxl",3.15,3.85719550162596],
["1lj7",3.15,3.61064529086564],
["1xpo",3.15,3.10914480217771],
["1xpr",3.15,2.93983736945024],
["1yhu",3.15,3.18744523082962],
["2bgn",3.15,2.98255204945852],
["1dwb",3.16,2.99981904720524],
["1ds5",3.16,4.00633021156819],
["1bcc",3.16,3.59226425429405],
["1moz",3.17,3.25436189926032],
["1pgq",3.17,2.92408631685770],
["2c0b",3.18,3.85224110733998],
["2bvg",3.18,3.37614195157692],
["1k6o",3.19,3.37420631180462],
["1o92",3.19,3.50017319507503],
["1ewr",3.19,3.97822346658667],
["2c0w",3.2,2.69146163987045],
["1e7o",3.2,4.1651841975683],
["1z1x",3.2,3.669477110107],
["1cdz",3.2,3.84716201426002],
["5rnt",3.2,3.58055311593319],
["1dks",3.2,3.48280326073897],
["1t38",3.2,3.28310394429096],
["1u43",3.2,2.61759283197690],
["2cxl",3.2,2.56878216365025],
["1pyi",3.2,4.29232426659268],
["1srs",3.2,2.71285483969085],
["1j87",3.2,3.28976330255082],
["1dkh",3.2,4.09140903355329],
["1yfy",3.2,3.6143055457249],
["1zp6",3.2,3.84130755427151],
["2xat",3.2,3.18602092006872],
["1xat",3.2,2.93173057321780],
["1q1p",3.2,3.91742605030147],
["1iy2",3.2,3.36264683572024],
["1p6v",3.2,4.08872158523431],
["1j7i",3.2,3.04395986050508],
["1uyo",3.2,3.64228030864323],
["2ac5",3.2,3.77362848152861],
["1t43",3.2,4.17783690765627],
["1dqv",3.2,4.26202892758081],
["1iqk",3.2,3.61798886535151],
["1iqf",3.2,3.83389477989278],
["1p8t",3.2,3.59688415083798],
["1e8o",3.2,3.40739156421452],
["2bke",3.2,2.8385387756303],
["1xqy",3.2,4.00808348583018],
["1cqt",3.2,3.50698958356745],
["1md7",3.2,3.54609424462722],
["1x24",3.2,3.35747793097661],
["2bzo",3.2,4.05811197777289],
["1mo6",3.2,3.3093619444109],
["1pbh",3.2,3.74963802281292],
["1jod",3.2,3.37904384084033],
["1jij",3.2,4.16628736445423],
["1jii",3.2,4.21449866223887],
["1mo4",3.2,3.66254086240528],
["1zqo",3.2,4.10310510340557],
["8ice",3.2,4.18156139742376],
["8icv",3.2,4.17907643796641],
["8icj",3.2,4.18887512915678],
["1zqc",3.2,4.13898727720067],
["1zqm",3.2,4.15824817866509],
["1zqb",3.2,4.19694551537786],
["1zqk",3.2,4.17662742983867],
["9icb",3.2,4.22374797972022],
["2c7k",3.2,3.01380413165490],
["2auh",3.2,3.04422507333497],
["1j86",3.2,3.17930900093779],
["7adh",3.2,4.57878620774224],
["2aji",3.2,2.64634252424739],
["1w3z",3.2,3.78470184360939],
["1ry7",3.2,4.11607551843778],
["1ixs",3.2,3.7251544073629],
["1ue7",3.2,3.81548289680069],
["1bl8",3.2,4.32478186756747],
["1qa9",3.2,3.95525425661302],
["1msd",3.2,3.42103725297666],
["1y7e",3.2,3.70652556463465],
["1xa6",3.2,4.12199155520809],
["2a8z",3.2,2.98622695027296],
["1r5o",3.2,3.50067760210147],
["2bhj",3.2,4.572742534253],
["1vjb",3.2,3.13099694331029],
["1jnn",3.2,3.47461237421490],
["1gh6",3.2,3.81689022925941],
["1i85",3.2,3.68135978239475],
["1lwt",3.2,4.01252341644424],
["1eqq",3.2,3.91763667460913],
["1v5w",3.2,4.14031406248897],
["1cn1",3.2,5.02378926573701],
["1cwp",3.2,3.46554203412972],
["1n2l",3.2,2.35973050091135],
["1snx",3.2,4.20446788508755],
["1ljr",3.2,3.75684231583379],
["2ljr",3.2,4.01861597405030],
["1k4s",3.2,4.08285049781109],
["1rh5",3.2,3.69812184805693],
["1b2y",3.2,1.99619524022139],
["1e57",3.2,4.17644447311978],
["1f15",3.2,3.92894272443863],
["1sfk",3.2,3.53054411866054],
["1p5y",3.2,3.05846750703870],
["1ebv",3.2,3.13173152918794],
["1adv",3.2,3.08052227228525],
["1wl0",3.2,2.73024506356499],
["1hqr",3.2,3.63053940557738],
["2d2n",3.2,3.7577254457063],
["2b92",3.2,3.31625163271896],
["1eui",3.2,3.59980648763900],
["1o9x",3.2,3.37563501360454],
["1s9i",3.2,3.37000092824193],
["1kln",3.2,3.54059227307181],
["1mah",3.2,3.32651401596899],
["1kqa",3.2,3.14649863086028],
["1e4k",3.2,4.26224220615834],
["1hlp",3.2,3.99136231061233],
["1lo5",3.2,3.79503896948079],
["1vit",3.2,3.64211905097409],
["1hqc",3.2,3.89752094883577],
["1hc3",3.2,3.7889669248912],
["1hc6",3.2,3.82053190332777],
["1hc5",3.2,3.79513019353259],
["1hc4",3.2,3.84824925727341],
["1hc2",3.2,4.13380031814282],
["1hc1",3.2,4.2174878587452],
["1o14",3.2,3.39550889618399],
["1mco",3.2,3.79119564317215],
["1hcy",3.2,4.15455315451189],
["1btj",3.2,3.62024894614035],
["1o77",3.2,3.73048962108339],
["1i6b",3.2,4.36167095567687],
["1e5n",3.2,2.50400474771306],
["1peu",3.2,3.82737609847535],
["1n9a",3.2,3.02639371213813],
["2flq",3.2,3.65936181880796],
["1c0w",3.2,3.72403368241579],
["2d31",3.2,3.54674291203157],
["1ath",3.2,3.08737260297729],
["1qku",3.2,3.54248143981122],
["3hud",3.2,3.37990385327197],
["1a9b",3.2,2.80923778932603],
["1fug",3.2,3.99784476360875],
["1nvx",3.2,2.65949485304345],
["1r1a",3.2,4.21678887087623],
["2esm",3.2,2.90437444178068],
["2bhn",3.2,3.56724851481585],
["1qab",3.2,4.54470001830437],
["2btq",3.2,3.54994288215741],
["2bb5",3.2,3.03794984037121],
["1mec",3.2,3.97432161020365],
["1a0h",3.2,4.02514831039755],
["1j88",3.2,3.01380416028214],
["1z7s",3.2,3.65320391535852],
["1sjp",3.2,3.01397188078668],
["2frd",3.2,1.94176094875298],
["1ibw",3.2,3.23466453273237],
["1hmv",3.2,3.43281558060523],
["1pci",3.2,3.49868743056657],
["1p8s",3.2,3.55106245712948],
["1sky",3.2,3.44651234137784],
["2f1z",3.2,4.05523562071905],
["1fx0",3.2,3.596435289368],
["1pp6",3.2,3.90846474913412],
["1uwb",3.2,3.84628261581146],
["2ayn",3.2,3.70914715621308],
["1bo5",3.2,4.16807429495753],
["1a6e",3.2,3.29364343441756],
["1osm",3.2,2.98087449823964],
["1kaq",3.2,3.91150438891943],
["1fvf",3.2,3.71852079135355],
["1ucx",3.2,3.18987775754038],
["1kk7",3.2,4.00152525943344],
["1fp7",3.2,3.81964102814032],
["1l7v",3.2,3.38726351898372],
["1ksx",3.2,3.46520199779969],
["1xcp",3.2,3.18329797810277],
["2bxb",3.2,3.15416259155513],
["1ea9",3.2,4.14500278598688],
["1jf5",3.2,2.9759848810337],
["1jf6",3.2,2.93462086720009],
["1jl8",3.2,3.17228817646288],
["1wzm",3.2,3.32494389521712],
["1rer",3.2,3.74603634470008],
["1j0k",3.2,3.06675465826052],
["1lbh",3.2,3.83652056263921],
["1ws3",3.2,3.10172282655411],
["1d9k",3.2,4.23284032283837],
["2ffh",3.2,2.91027970389254],
["1lqm",3.2,3.30329466737065],
["7pck",3.2,2.93952518988741],
["1osn",3.2,3.39571768587761],
["1mpn",3.2,3.31447625146720],
["3bta",3.2,3.70275952718241],
["1nyq",3.2,3.97143835022811],
["1igy",3.2,3.97912599566854],
["1kno",3.2,3.79518610892092],
["2fnq",3.2,3.78320065766316],
["1n86",3.2,3.79786614060696],
["1cvi",3.2,3.62196143138002],
["1pu4",3.2,3.02057380558878],
["1mqn",3.2,3.32754584211644],
["1l5g",3.2,3.79608307639867],
["1q2s",3.2,3.18877328599369],
["1sl0",3.2,3.70721959668896],
["5hmg",3.2,2.84067070958149],
["1iyl",3.2,3.87899698242468],
["1ya4",3.2,3.07961652078853],
["1slq",3.2,3.45174087312404],
["1wb3",3.2,4.39020944795768],
["1yr3",3.2,2.98831317707131],
["1zxo",3.2,3.67766977284907],
["1e2y",3.2,3.64134967416805],
["1jy7",3.2,2.79980740670753],
["2fee",3.2,3.48273239514915],
["2exw",3.2,3.92235827205940],
["1tfy",3.2,2.91469859642256],
["1flc",3.2,4.18915456056344],
["2abm",3.2,3.38395915038150],
["1v1s",3.2,3.35928338382991],
["1waf",3.2,4.15066039053148],
["1nj8",3.2,3.96108972992482],
["1sk6",3.2,3.88216720339965],
["1l8h",3.2,3.38580641944709],
["1rtd",3.2,2.95747007057396],
["1gl9",3.2,3.94502431290001],
["1dpp",3.2,2.8615754816324],
["1o5w",3.2,3.51457237893647],
["1nu1",3.2,3.70977912121191],
["1gga",3.2,3.05469754285445],
["1k25",3.2,3.81116057599685],
["4r1r",3.2,2.88873980543003],
["2eyq",3.2,3.56478971911149],
["1xy3",3.2,2.85834824184742],
["1hr0",3.2,3.84715593758856],
["1mto",3.2,3.54760367103903],
["1dao",3.2,3.44141684387262],
["1j1w",3.2,3.51384701685182],
["1hwy",3.2,3.92806429158913],
["1jnb",3.2,3.82649810788164],
["1fou",3.2,4.24976792960192],
["1ynj",3.2,3.98258677575207],
["1w5c",3.2,4.02645115946745],
["1n3t",3.2,3.09427218365750],
["1iok",3.2,3.84572875020129],
["1s0v",3.2,4.27279156098979],
["1twa",3.2,3.72155089359168],
["1m1k",3.2,3.04743277898834],
["1q7y",3.2,3.3238061787086],
["1i41",3.2,3.67563386871696],
["1cx8",3.2,3.78021305063036],
["1xfx",3.2,4.08205807765104],
["1m1y",3.2,3.46252788976184],
["1yaj",3.2,3.36700603451198],
["1ogy",3.2,3.81537450111113],
["1fnt",3.2,3.75581458561216],
["2aj2",3.21,3.38740590380969],
["1zbv",3.21,3.47942949535669],
["1q9c",3.21,2.81337455619920],
["1y1u",3.21,3.87590718243873],
["1wz2",3.21,4.13888662379663],
["1sf7",3.22,2.74894694165472],
["1sfg",3.22,2.85648131425683],
["1sfb",3.22,2.95660463891242],
["1sf6",3.22,3.08126836683889],
["1shy",3.22,3.6392233997661],
["1x86",3.22,3.34391197315574],
["1z7q",3.22,3.45612766057662],
["1gka",3.23,3.75119492296746],
["1t8b",3.23,3.82345758871154],
["1u8p",3.23,2.76375085696774],
["1t9t",3.23,3.62801815095125],
["1t9w",3.23,3.10395653651334],
["2fhg",3.23,3.26443479814911],
["1fu2",3.24,4.20404606794235],
["1v8j",3.24,3.97853513611064],
["1t0k",3.24,3.15442976301338],
["1gm5",3.24,4.82974157076387],
["1yt2",3.25,2.51468624015087],
["1mo5",3.25,3.60352637413505],
["1bey",3.25,4.11472073746862],
["1hw2",3.25,3.29715497773636],
["1h9t",3.25,4.09165197847038],
["1ijs",3.25,3.91472748378341],
["1z14",3.25,3.28582812448334],
["2f8x",3.25,3.59427505480662],
["2vis",3.25,3.49434919427385],
["2vit",3.25,3.47658965332893],
["2vir",3.25,3.51085448940378],
["1r46",3.25,3.53997262474295],
["1t3e",3.25,3.51848092628863],
["1szp",3.25,3.71567075235248],
["1l9j",3.25,3.16847966353499],
["1s78",3.25,3.17998097284191],
["1z7n",3.25,3.18891108695365],
["1xmo",3.25,3.87098532696335],
["1i48",3.25,3.72739186795127],
["1xfz",3.25,4.03207447132049],
["1sc5",3.26,3.51416914284494],
["1p1z",3.26,4.30517577065442],
["1usz",3.28,3.66270864685222],
["1k39",3.29,3.31724695112477],
["1tgk",3.3,3.83819260645699],
["2c9n",3.3,2.27292428900217],
["2fcq",3.3,2.43114193057597],
["1vb4",3.3,2.9746367184774],
["1lx5",3.3,3.92599941694978],
["1mbv",3.3,3.47732265704663],
["1zw3",3.3,3.7571739641746],
["1lfy",3.3,3.48639808808081],
["1t39",3.3,3.53482591095588],
["1ube",3.3,3.86108758180812],
["1xri",3.3,2.68291915752573],
["2pbh",3.3,3.7052624182534],
["7icu",3.3,4.0647353118431],
["8ich",3.3,4.13876711229802],
["1zqs",3.3,4.12657494523227],
["1zql",3.3,4.16695615430178],
["8icg",3.3,4.20957089794438],
["7ico",3.3,4.17885932762345],
["1zqq",3.3,4.29672501193242],
["8icw",3.3,4.30577715770317],
["1zqj",3.3,4.34423753139135],
["9ice",3.3,4.36593972677222],
["1gfo",3.3,2.69847585884016],
["1vey",3.3,3.26927788072831],
["2hpq",3.3,4.19625552948982],
["2hpp",3.3,4.23660025073562],
["1y11",3.3,3.57615047838564],
["1sru",3.3,3.73386945167218],
["1gkv",3.3,2.74120981060045],
["1lgb",3.3,3.97449773104849],
["1u9o",3.3,3.53648733225125],
["2cfp",3.3,4.48879790877828],
["1yke",3.3,3.52881582452755],
["2bsk",3.3,3.48704234369927],
["1pw4",3.3,4.00631007677003],
["1koa",3.3,3.8539622474125],
["1x9p",3.3,3.89941033552136],
["2etn",3.3,4.46480669121798],
["1rgb",3.3,4.1979473211832],
["3ljr",3.3,4.0044571429601],
["1b44",3.3,2.67126594062845],
["1p5w",3.3,2.75210827519699],
["1fpv",3.3,4.00446292321363],
["1vg4",3.3,3.43911391932366],
["1rts",3.3,2.74842293301847],
["1qgt",3.3,4.41886794767899],
["1ydz",3.3,3.29614968783337],
["2d26",3.3,3.99251248279376],
["2bap",3.3,3.42863597911356],
["1ixr",3.3,4.29725427420517],
["3pjr",3.3,4.25058040745554],
["2cwo",3.3,3.39922994993145],
["2anl",3.3,4.11589909258689],
["1j1e",3.3,3.26330113354207],
["2brv",3.3,3.32716562047179],
["1mq8",3.3,3.77552060217560],
["1blb",3.3,4.46674793074052],
["1poj",3.3,3.03716684122534],
["2eto",3.3,2.25662305522360],
["1na1",3.3,3.12641993015831],
["1mqt",3.3,3.5344043146781],
["1ux4",3.3,3.73145719252817],
["1iss",3.3,3.49103738527839],
["2b4c",3.3,3.03156882084881],
["1nda",3.3,3.48757240839744],
["2msp",3.3,4.06720434711933],
["1bqn",3.3,4.07767301056904],
["2by4",3.3,3.78480412010588],
["1t2v",3.3,2.6969295642576],
["2fdc",3.3,2.90948848787160],
["1ahz",3.3,3.21470192106982],
["1ivo",3.3,3.88665734640387],
["1eiy",3.3,3.89157217636849],
["2c5d",3.3,3.4891790624801],
["2c2l",3.3,3.75258893589624],
["1j2b",3.3,3.94162397257819],
["1jib",3.3,3.46432587115884],
["1gvi",3.3,3.71507318085242],
["1z3g",3.3,3.57278603219749],
["1lnl",3.3,4.18277166582885],
["1ut2",3.3,3.6736083660493],
["2f55",3.3,4.01172795222248],
["1dlp",3.3,4.64562125536709],
["1cqi",3.3,3.35422609122282],
["1szz",3.3,3.02116276137514],
["1lul",3.3,3.35757260016440],
["1p0t",3.3,2.22290277141765],
["1ayr",3.3,3.84414028538926],
["1m1x",3.3,3.77708010950772],
["1gc4",3.3,3.64844690303942],
["2a73",3.3,3.13154846550013],
["1c9t",3.3,3.02839636421942],
["1e0k",3.3,3.84806791203595],
["4gtu",3.3,3.44432052304335],
["2byt",3.3,3.10276903501631],
["1pk0",3.3,3.59398614409344],
["1fay",3.3,2.94977577500309],
["1zye",3.3,3.08324247626793],
["1fzi",3.3,2.58031903543538],
["2b76",3.3,4.17411348060634],
["1g5g",3.3,3.90944749607944],
["1l0v",3.3,3.56715593049751],
["1v7n",3.3,4.36847610836051],
["1hnz",3.3,3.73964876964884],
["1lnq",3.3,3.31640672766131],
["2b4k",3.3,2.96381889542780],
["1hqm",3.3,4.46402233795347],
["1i6v",3.3,4.43456282580583],
["1nr1",3.3,4.04860618717888],
["1gc3",3.3,3.66807164432981],
["1c2y",3.3,3.81218988001847],
["1ynn",3.3,3.93948451375095],
["1twg",3.3,3.97682805578215],
["1i6h",3.3,3.70640187916962],
["1gt8",3.3,2.7675721419078],
["1xfy",3.3,4.23065107080714],
["2c39",3.3,2.64260040224745],
["1nr7",3.3,3.70774430929704],
["2cw0",3.3,4.19070730111367],
["1otz",3.3,2.45522703244411],
["2fug",3.3,3.94843143276911],
["1oda",3.31,3.3255567854906],
["1f6h",3.31,4.27874377970661],
["1tx9",3.31,3.79801835369781],
["1nqg",3.31,3.95887021989473],
["2b7q",3.31,3.57670477050309],
["1ibm",3.31,3.86572734430185],
["1ibk",3.31,3.8780362037949],
["2fed",3.32,3.02006426763221],
["1l6z",3.32,4.53908518802687],
["1y69",3.33,3.99708777333857],
["1zt2",3.33,3.44790721537952],
["2ffl",3.33,2.75149871047121],
["1s94",3.34,3.80610621590468],
["2a3l",3.34,4.42859410976417],
["1xft",3.35,4.22803448767139],
["1vg6",3.35,2.61636261648588],
["2d3o",3.35,3.92499510131464],
["1ob2",3.35,4.00532262388698],
["1a38",3.35,3.96771631798545],
["1lqj",3.35,4.2119791070341],
["1za3",3.35,3.07709788351197],
["1n33",3.35,3.98596041814315],
["1xfv",3.35,4.20264262280987],
["1xfu",3.35,4.22340060443677],
["1zzn",3.37,4.16114827443294],
["1yz6",3.37,3.92961906036565],
["1biy",3.37,4.10723839940854],
["1vc5",3.4,2.48409556896707],
["1ze0",3.4,3.91839129342981],
["1yab",3.4,3.77843569340720],
["1vb2",3.4,3.34410164849763],
["1mjp",3.4,4.20521617823105],
["1ncj",3.4,4.12864348259985],
["1vg7",3.4,2.68040576701117],
["1zqt",3.4,4.1183811264188],
["1ts4",3.4,3.17178582103372],
["2fx3",3.4,3.55943329407483],
["1bi7",3.4,4.19343668963526],
["1v4t",3.4,3.49059942053328],
["1u63",3.4,4.40647760244266],
["1h1z",3.4,2.97489159240104],
["1uaz",3.4,3.50901093388227],
["1js9",3.4,4.56947921033721],
["1laj",3.4,4.49029075803025],
["1p7q",3.4,3.6966411104022],
["1pth",3.4,3.38493041114225],
["1wkz",3.4,3.15252558597532],
["1r30",3.4,3.88083018104397],
["1g1r",3.4,3.76364221027203],
["1ou5",3.4,4.08214126576707],
["1qjm",3.4,3.97456887860858],
["1n76",3.4,2.87734696633309],
["1ft2",3.4,2.89264443013956],
["1zr4",3.4,3.21238248011059],
["2d0u",3.4,3.02414302044221],
["1ggm",3.4,3.92618391881593],
["1b76",3.4,3.94576059371478],
["1kmh",3.4,3.84091151770656],
["2byq",3.4,2.89068016245533],
["1iyj",3.4,4.15859312032367],
["1po3",3.4,3.64918789572037],
["1gyq",3.4,2.84956175674369],
["1ihm",3.4,2.99207797319125],
["1gn2",3.4,2.85847671919082],
["1ypz",3.4,3.98339645607704],
["2ft3",3.4,3.80447432892132],
["2d3t",3.4,2.73369291349665],
["1hnw",3.4,3.77539707227479],
["1hnx",3.4,3.82617446390946],
["1twh",3.4,3.94540054981076],
["1vyh",3.4,3.86943247336135],
["1xfw",3.4,4.11665981339962],
["1pma",3.4,3.47954731851392],
["1g3i",3.41,3.79151710085471],
["1ll0",3.43,3.51947793197728],
["2b48",3.45,3.74094320405138],
["1ud0",3.45,3.92611160633772],
["1wl1",3.45,3.06382065519775],
["1zcd",3.45,4.16723208282507],
["1r47",3.45,3.64546350490644],
["1ohg",3.45,3.38944277516014],
["1q57",3.45,4.3541094914346],
["1xxh",3.45,3.84224339100825],
["1kct",3.46,4.70368072718313],
["2avy",3.46,4.01400813462169],
["2aw7",3.46,4.00670837535047],
["2aw4",3.46,4.34883249995722],
["1hm4",3.47,3.61840246847693],
["1oye",3.48,3.6383890019184],
["1jkt",3.49,4.39936231047652],
["1o93",3.49,3.5042691139793],
["1emr",3.5,4.08006612871515],
["1kzz",3.5,4.07691223512474],
["1u87",3.5,3.73270983515943],
["1rf3",3.5,4.42118362825598],
["1bm1",3.5,3.31396581357854],
["2brd",3.5,3.76649030825608],
["1nrq",3.5,4.67323007157055],
["1sgh",3.5,4.22889553652109],
["1xgo",3.5,4.44310545272577],
["1vbp",3.5,3.62518218067301],
["1ubf",3.5,3.75634463861856],
["1fb5",3.5,4.14040142063791],
["1zqd",3.5,4.29858275054629],
["7icj",3.5,4.28563493812123],
["1ubg",3.5,3.91211759823144],
["1gfm",3.5,2.65771659181315],
["1fr5",3.5,3.25302335970505],
["1zl1",3.5,3.32615999371498],
["1qbe",3.5,2.93197835778201],
["1hkg",3.5,5.10486174705682],
["1dwn",3.5,3.60970641138578],
["1g6v",3.5,3.51857937721973],
["1frs",3.5,3.34413833408253],
["1u88",3.5,4.14119563874623],
["1lws",3.5,4.12785165786584],
["2ayo",3.5,4.15490074414064],
["1mcw",3.5,4.98386198294577],
["1hnb",3.5,3.27218959363423],
["1zak",3.5,2.99167354535223],
["1kyn",3.5,3.92745264452168],
["1fll",3.5,4.24249041897325],
["1x9t",3.5,3.88441878605624],
["1dzl",3.5,4.30826398690415],
["1a6c",3.5,3.86797596929923],
["1s58",3.5,4.68232476156153],
["1uwj",3.5,3.6280573337735],
["1hx9",3.5,2.68205141749687],
["1rhz",3.5,4.13652145552643],
["1hx5",3.5,2.95550549321733],
["1msl",3.5,4.11867989778232],
["1k3v",3.5,3.90088842607018],
["1c8h",3.5,3.49567665289212],
["1mvm",3.5,4.34845303144304],
["1z1c",3.5,3.83006978749526],
["1wl3",3.5,2.79541902048351],
["1t89",3.5,4.00489322213729],
["1iix",3.5,4.06563000448642],
["1f6a",3.5,3.57567580020778],
["1rb8",3.5,3.43728866759136],
["1m06",3.5,3.33096270430036],
["1mje",3.5,4.3173554720109],
["1qfw",3.5,3.91418536409741],
["1fmd",3.5,3.63093310667331],
["3gpd",3.5,4.92728780008229],
["1ryx",3.5,4.55728115147439],
["1kib",3.5,3.13948938875197],
["1ymm",3.5,4.04918894817465],
["1x81",3.5,3.26758812404474],
["1n94",3.5,3.55858310890259],
["2g01",3.5,4.13874288375689],
["1lcu",3.5,3.73996695784407],
["1miv",3.5,3.43650474916255],
["1tmf",3.5,4.7990745828722],
["1cov",3.5,3.13909040070609],
["1jh0",3.5,2.83645396975227],
["1pv6",3.5,4.0523504986588],
["1qmo",3.5,3.53810597192241],
["1cq9",3.5,2.57229384092956],
["1jck",3.5,3.36854197440057],
["1n9s",3.5,3.59063002944947],
["1iwg",3.5,3.74475527354222],
["1zp0",3.5,3.30090153062920],
["1pge",3.5,3.32251835283967],
["1prh",3.5,3.34915108743997],
["2a1d",3.5,3.75957519515875],
["1al0",3.5,3.81892646063391],
["1xfh",3.5,3.82654955355382],
["1cd3",3.5,4.4386977651142],
["2fix",3.5,4.2200246335852],
["2cde",3.5,3.59471510941489],
["1m1c",3.5,3.92701529702907],
["1j5o",3.5,4.19725930344026],
["1pgr",3.5,3.18219191122181],
["1i0e",3.5,4.04357696333352],
["1zrt",3.5,4.62711183138494],
["1v6n",3.5,3.47935995858147],
["1pto",3.5,3.71946615667744],
["1fft",3.5,4.22373411978878],
["2bcc",3.5,3.8011536266103],
["2b7m",3.5,3.42528301663083],
["1xcq",3.5,4.41092884676472],
["1wdl",3.5,2.99058106605253],
["1ken",3.5,4.25556919915362],
["3tat",3.5,4.52491067007896],
["1kpk",3.5,3.73963326511460],
["1ypw",3.5,4.59225594244554],
["1z8l",3.5,3.67207239056044],
["1kog",3.5,3.84797960263008],
["1r9t",3.5,4.79762225291626],
["1w2b",3.5,3.36984213918050],
["1br1",3.5,4.43838333444752],
["1s5l",3.5,3.80416999607971],
["2gls",3.5,4.98089815085941],
["1nqt",3.5,4.13002681937211],
["2btv",3.5,3.45587895484918],
["1uf2",3.5,3.22566865362218]]
