# -*- coding: utf-8 -*-
info = {
    "name": "fi",
    "date_order": "DMY",
    "january": [
        "tammikuu",
        "tammi",
        "tammikuuta",
        "tammik",
        "tammikuussa"
    ],
    "february": [
        "helmikuu",
        "helmi",
        "helmikuuta",
        "helmik",
        "helmikuussa"
    ],
    "march": [
        "maaliskuu",
        "maalis",
        "maaliskuuta",
        "maalisk",
        "maaliskuussa"
    ],
    "april": [
        "huhtikuu",
        "huhti",
        "huhtikuuta",
        "huhtik",
        "huhtikuussa"
    ],
    "may": [
        "toukokuu",
        "touko",
        "toukokuuta",
        "toukok",
        "toukokuussa"
    ],
    "june": [
        "kesäkuu",
        "kesä",
        "kesäkuuta",
        "kesäk",
        "kesäkuussa"
    ],
    "july": [
        "heinäkuu",
        "heinä",
        "heinäkuuta",
        "heinäk",
        "heinäkuussa"
    ],
    "august": [
        "elokuu",
        "elo",
        "elokuuta",
        "elok",
        "elokuussa"
    ],
    "september": [
        "syyskuu",
        "syys",
        "syyskuuta",
        "syysk",
        "Syyskuussa"
    ],
    "october": [
        "lokakuu",
        "loka",
        "lokakuuta",
        "lokak",
        "Lokakuussa"
    ],
    "november": [
        "marraskuu",
        "marras",
        "marraskuuta",
        "marrask",
        "Marraskuussa"
    ],
    "december": [
        "joulukuu",
        "joulu",
        "joulukuuta",
        "jouluk",
        "Joulukuussa"
    ],
    "monday": [
        "maanantai",
        "ma",
        "maanantaina"
    ],
    "tuesday": [
        "tiistai",
        "ti",
        "tiistaina"
    ],
    "wednesday": [
        "keskiviikko",
        "ke",
        "keskiviikkona"
    ],
    "thursday": [
        "torstai",
        "to",
        "torstaina"
    ],
    "friday": [
        "perjantai",
        "pe",
        "perjantaina"
    ],
    "saturday": [
        "lauantai",
        "la",
        "lauantaina"
    ],
    "sunday": [
        "sunnuntai",
        "su",
        "sunnuntaina"
    ],
    "am": [
        "ap"
    ],
    "pm": [
        "ip"
    ],
    "year": [
        "vuosi",
        "v",
        "vuotta",
        "vv",
        "vuonna",
        "vuoden"
    ],
    "month": [
        "kuukausi",
        "kk",
        "kuukautta",
        "kuukauden"
    ],
    "week": [
        "viikko",
        "vk",
        "viikkoa",
        "vko",
        "viikon"
    ],
    "day": [
        "päivä",
        "pv",
        "päivää",
        "p",
        "pvä",
        "pvää",
        "päivän"
    ],
    "hour": [
        "tunti",
        "t",
        "tuntia",
        "tunnin"
    ],
    "minute": [
        "minuutti",
        "min",
        "minuuttia",
        "minuutin"
    ],
    "second": [
        "sekunti",
        "s",
        "sekuntia",
        "sekuntti",
        "sekunttia",
        "sekuntin",
        "sekunnin"
    ],
    "relative-type": {
        "1 year ago": [
            "viime vuonna",
            "viime v"
        ],
        "0 year ago": [
            "tänä vuonna",
            "tänä v"
        ],
        "in 1 year": [
            "ensi vuonna",
            "ensi v"
        ],
        "1 month ago": [
            "viime kuussa",
            "viime kk"
        ],
        "0 month ago": [
            "tässä kuussa",
            "tässä kk"
        ],
        "in 1 month": [
            "ensi kuussa",
            "ensi kk"
        ],
        "1 week ago": [
            "viime viikolla",
            "viime vk"
        ],
        "0 week ago": [
            "tällä viikolla",
            "tällä vk"
        ],
        "in 1 week": [
            "ensi viikolla",
            "ensi vk"
        ],
        "1 day ago": [
            "eilen"
        ],
        "0 day ago": [
            "tänään"
        ],
        "in 1 day": [
            "huomenna",
            "huom"
        ],
        "0 hour ago": [
            "tämän tunnin aikana",
            "tunnin sisällä"
        ],
        "0 minute ago": [
            "tämän minuutin aikana",
            "minuutin sisällä"
        ],
        "0 second ago": [
            "nyt"
        ],
        "2 year ago": [
            "toissa vuonna"
        ],
        "2 month ago": [
            "toissa kuussa"
        ],
        "2 week ago": [
            "toissa viikolla"
        ],
        "2 day ago": [
            "toissa päivänä"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) vuoden päästä",
            "(\\d+) v päästä"
        ],
        "\\1 year ago": [
            "(\\d+) vuosi sitten",
            "(\\d+) vuotta sitten",
            "(\\d+) v sitten"
        ],
        "in \\1 month": [
            "(\\d+) kuukauden päästä",
            "(\\d+) kk päästä"
        ],
        "\\1 month ago": [
            "(\\d+) kuukausi sitten",
            "(\\d+) kuukautta sitten",
            "(\\d+) kk sitten"
        ],
        "in \\1 week": [
            "(\\d+) viikon päästä",
            "(\\d+) vk päästä"
        ],
        "\\1 week ago": [
            "(\\d+) viikko sitten",
            "(\\d+) viikkoa sitten",
            "(\\d+) vk sitten"
        ],
        "in \\1 day": [
            "(\\d+) päivän päästä",
            "(\\d+) pv päästä"
        ],
        "\\1 day ago": [
            "(\\d+) päivä sitten",
            "(\\d+) päivää sitten",
            "(\\d+) pv sitten"
        ],
        "in \\1 hour": [
            "(\\d+) tunnin päästä",
            "(\\d+) t päästä"
        ],
        "\\1 hour ago": [
            "(\\d+) tunti sitten",
            "(\\d+) tuntia sitten",
            "(\\d+) t sitten"
        ],
        "in \\1 minute": [
            "(\\d+) minuutin päästä",
            "(\\d+) min päästä"
        ],
        "\\1 minute ago": [
            "(\\d+) minuutti sitten",
            "(\\d+) minuuttia sitten",
            "(\\d+) min sitten"
        ],
        "in \\1 second": [
            "(\\d+) sekunnin päästä",
            "(\\d+) s päästä"
        ],
        "\\1 second ago": [
            "(\\d+) sekunti sitten",
            "(\\d+) sekuntia sitten",
            "(\\d+) s sitten"
        ]
    },
    "locale_specific": {},
    "skip": [
        ":n",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "sitten"
    ],
    "in": [
        "kuluttua",
        "päästä"
    ],
    "simplifications": [
        {
            "(\\d+) (sekunnin|sekuntin|minuutin|tunnin|päivän|viikon|kuukauden|vuoden) (päästä|kuluttua)": "\\3 \\1 \\2"
        }
    ]
}