/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#ifndef ESYS_LSMPARTICLEFIELDSAVERPRMSPY_H
#define ESYS_LSMPARTICLEFIELDSAVERPRMSPY_H

#include "Python/esys/lsm/FieldSaverPrmsPy.h"

//--- STL includes ---
#include <string>

//--- Boost includes ---
#include <boost/python.hpp>

namespace esys
{
  namespace lsm
  {
    class ParticleFieldSaverPrmsPy : public FieldSaverPrmsPy
    {
    public:
      ParticleFieldSaverPrmsPy(
        const std::string &fieldName,
        const std::string &fileName,
        const std::string &fileFormat,
        int beginTimeStep,
        int endTimeStep,
        int timeStepIncr
      );

    private:
    };

    class ParticleScalarFieldSaverPrmsPy : public ParticleFieldSaverPrmsPy
    {
    public:
      ParticleScalarFieldSaverPrmsPy(
        const std::string &fieldName,
        const std::string &fileName,
        const std::string &fileFormat,
        int beginTimeStep,
        int endTimeStep,
        int timeStepIncr
      );
    };

    class ParticleVectorFieldSaverPrmsPy : public ParticleFieldSaverPrmsPy
    {
    public:
      ParticleVectorFieldSaverPrmsPy(
        const std::string &fieldName,
        const std::string &fileName,
        const std::string &fileFormat,
        int beginTimeStep,
        int endTimeStep,
        int timeStepIncr
      );
    };

    class TaggedParticleScalarFieldSaverPrmsPy : public ParticleScalarFieldSaverPrmsPy
    {
    private:
      int m_tag;
      int m_mask;
      
    public:
      TaggedParticleScalarFieldSaverPrmsPy(
        const std::string &fieldName,
        const std::string &fileName,
        const std::string &fileFormat,
        int beginTimeStep,
        int endTimeStep,
        int timeStepIncr,
	      int tag,
        int mask
      );

      int getTag() const {return m_tag;}
      int getMask() const {return m_mask;}
    };

    class TaggedParticleVectorFieldSaverPrmsPy : public ParticleVectorFieldSaverPrmsPy
    {
    private:
      int m_tag;
      int m_mask;
      
    public:
      TaggedParticleVectorFieldSaverPrmsPy(
        const std::string &fieldName,
        const std::string &fileName,
        const std::string &fileFormat,
        int beginTimeStep,
        int endTimeStep,
        int timeStepIncr,
	      int tag,
	      int mask
      );

      int getTag() const {return m_tag;}
      int getMask() const {return m_mask;}
    };

    void exportParticleFieldSaverPrms();
  } // namespace lsm
} // namespace esys

#endif
