# Copyright (c) 2025, Manfred Moitzi
# License: MIT License
import pytest
from ezdxf.math import BSpline


@pytest.fixture
def spline():
    control_points = [
        (159.5656249999983, 183.9117098801389, 0.0),
        (159.5656249999983, 184.9700432134714, 0.0),
        (161.2671023719358, 186.0283765468039, 0.0),
        (162.9685797438733, 187.0867098801363, 0.0),
        (165.9156249999978, 188.1450432134697, 0.0),
        (168.8626702561232, 189.2033765468022, 0.0),
        (172.2656249999982, 190.2617098801356, 0.0),
        (175.6685797438731, 191.320043213469, 0.0),
        (178.6156249999985, 192.3783765468024, 0.0),
        (181.5626702561221, 193.4367098801367, 0.0),
        (183.2641476280605, 194.495043213471, 0.0),
        (184.965624999998, 195.5533765468053, 0.0),
        (184.965624999998, 196.6117098801396, 0.0),
        (184.965624999998, 197.2448894245854, 0.0),
        (184.329228833606, 197.8993733974857, 0.0),
    ]
    knots = [
        0.5,
        0.5,
        0.5000000000000006,
        0.541666666666667,
        0.541666666666667,
        0.5833333333333331,
        0.5833333333333331,
        0.625,
        0.625,
        0.666666666666667,
        0.666666666666667,
        0.7083333333333331,
        0.7083333333333331,
        0.75,
        0.75,
        0.775274290106482,
        0.775274290106482,
        0.775274290106482,
    ]
    weights = [
        0.9999999999999996,
        0.9659258262890682,
        1.0,
        0.9659258262890679,
        1.0,
        0.9659258262890679,
        1.0,
        0.9659258262890679,
        1.0,
        0.9659258262890679,
        1.0,
        0.9659258262890679,
        1.0,
        0.97933118676379,
        0.9837370734582357,
    ]
    return BSpline(control_points, 3, knots, weights)


def test_point_calculation_at_0(spline: BSpline):
    """The point at u=0 should not be (0, 0, 0).

    A general solution for #1284 does not exist yet, so the calculated point is still
    not correct.
    """
    p = spline.point(0)
    assert p.is_null is False
