/* $Id: CaseAlternative.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CASE_ALTERNATIVE_HPP_INCLUDED
#define __CASE_ALTERNATIVE_HPP_INCLUDED

#include "frontend/ast/AstNode.hpp"
#include "frontend/ast/SeqStat.hpp"
#include "frontend/ast/Expression.hpp"

namespace ast {

/** one alternative for a case statement */
class CaseAlternative : public AstNode {
public:
	//! c'tor
	/** @param choices List of expressions for this alternative.
          * @param thenList List of statements to do if choices is true.
          * @param loc location of the alternative.
          */
	CaseAlternative(
		std::list<Expression*>* choices,
		std::list<SeqStat*>* thenList,
		Location loc
		) : 	AstNode(loc),
			isVals(choices),
			thenStats(thenList) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		util::MiscUtil::listPut(this->isVals, stream, "| ");
		stream << " => ";
		util::MiscUtil::listPut(this->thenStats, stream, "; ");
	}

	/** evaluate this alternative, if the condition of the 
          * case-statement is one of isVals
          */
	std::list<Expression*>* isVals;
	/** sequential statements of this alternative */
	std::list<SeqStat*>* thenStats;

protected:
	/** Destructor */
	virtual ~CaseAlternative() {
		util::MiscUtil::lterminate(isVals);
		util::MiscUtil::lterminate(thenStats);
	}
};

};

#endif /* __CASE_ALTERNATIVE_HPP_INCLUDED */
