/* $Id: LibraryList.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LIBRARY_LIST_HPP_INCLUDED
#define __LIBRARY_LIST_HPP_INCLUDED

#include <string>
#include "frontend/ast/Library.hpp"

namespace ast {

//! Top node, a list of design libraries.
/** This class is the hierarchical top node of each abstract syntax tree.
 *  It represents a unique list of design libraries.
 *  
 *  @TODO make a distinction between resource libraries and the work library.
 */
class LibraryList : public AstNode {
public:
	//! c'tor
	LibraryList(void) : AstNode(
				Location("library list")) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "LIST OF LIBRARIES... why do you want to know?";
	}


	/** add a library with given name to the library list, 
	 *  in case it doesn't exist yet.
	 *
	 *  @param libname name of the library
	 *  @return either the library in question or a newly generated 
	 *          one.
	 */
	Library* enterLibrary(const char* libname) {
		for (std::list<Library*>::const_iterator i = 
			this->libraries.begin();
			i != this->libraries.end();
			i++) {

			if ((*(*i)->name) == libname) {
				return *i;
			}
		}

		Library *n = new Library(new std::string(libname));
		this->libraries.push_back(n);
		return n;
	}

	/** list of LibUnit */
	std::list<Library*> libraries;
};

}; /* namespace ast */

#endif /* __LIBRARY_LIST_HPP_INCLUDED */
