! (C) Copyright 2013 ECMWF.
!
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation nor
! does it submit to any jurisdiction.

#include "fckit/fckit.h"

module fckit_pathname_module
  !! Module holding the [[fckit_pathname_module:fckit_pathname(type)]] type
  !! for strong typing of file paths

use, intrinsic :: iso_c_binding, only : c_char, c_int32_t

implicit none

public :: fckit_pathname
private :: c_char, c_int32_t

private


TYPE :: fckit_pathname
  !! Type encapsulated string, used for strong typing file paths.
  character(kind=c_char,len=1), allocatable, private :: string(:)
contains
  procedure :: str => fckit_pathname__str
    !! Function that returns the file path as string
END TYPE fckit_pathname

interface fckit_pathname
  !! Constructor for [[fckit_pathname_module:fckit_pathname(type)]]
  module procedure fckit_pathname__ctor_str
end interface

!========================================================
contains
!========================================================


function fckit_pathname__ctor_str(str) result(pathname)
  type(fckit_pathname) :: pathname
  character(kind=c_char,len=*), intent(in) :: str
  integer(c_int32_t) ::  i, nchars
  nchars = len(str)
  allocate( pathname%string(nchars) )
  do i=1,nchars
    pathname%string(i) = str(i:i)
  enddo
end function

function fckit_pathname__str(this) result(str)
  character(kind=c_char,len=:), allocatable :: str
  class(fckit_pathname) :: this
  integer(c_int32_t) :: i, nchars
  nchars = size(this%string)
  FCKIT_ALLOCATE_CHARACTER(str,nchars)
  do i=1,nchars
    str(i:i) = this%string(i)
  enddo
end function

end module fckit_pathname_module

