/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.codestream.writer;

import ucar.jpeg.jj2000.j2k.codestream.CBlkCoordInfo;
import ucar.jpeg.jj2000.j2k.codestream.PrecInfo;
import ucar.jpeg.jj2000.j2k.codestream.writer.BitOutputBuffer;
import ucar.jpeg.jj2000.j2k.codestream.writer.TagTreeEncoder;
import ucar.jpeg.jj2000.j2k.encoder.EncoderSpecs;
import ucar.jpeg.jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import ucar.jpeg.jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import ucar.jpeg.jj2000.j2k.image.Coord;
import ucar.jpeg.jj2000.j2k.util.ArrayUtil;
import ucar.jpeg.jj2000.j2k.util.MathUtil;
import ucar.jpeg.jj2000.j2k.util.ParameterList;
import ucar.jpeg.jj2000.j2k.wavelet.analysis.SubbandAn;

public class PktEncoder {
    public static final char OPT_PREFIX = 'P';
    private static final String[][] pinfo = new String[][]{{"Psop", "[<tile idx>] on|off[ [<tile idx>] on|off ...]", "Specifies whether start of packet (SOP) markers should be used. 'on' enables, 'off' disables it.", "off"}, {"Peph", "[<tile idx>] on|off[ [<tile  idx>] on|off ...]", "Specifies whether end of packet header (EPH) markers should be  used. 'on' enables, 'off' disables it.", "off"}};
    private static final int INIT_LBLOCK = 3;
    private CodedCBlkDataSrcEnc infoSrc;
    private EncoderSpecs encSpec;
    private TagTreeEncoder[][][][][] ttIncl;
    private TagTreeEncoder[][][][][] ttMaxBP;
    private int[][][][][] lblock;
    private int[][][][][] prevtIdxs;
    private int[][][][][] bak_lblock;
    private int[][][][][] bak_prevtIdxs;
    private byte[] lbbuf;
    private int lblen;
    private boolean saved;
    private boolean roiInPkt = false;
    private int roiLen = 0;
    private PrecInfo[][][][] ppinfo;
    private boolean packetWritable;

    public PktEncoder(CodedCBlkDataSrcEnc infoSrc, EncoderSpecs encSpec, Coord[][][] numPrec, ParameterList pl) {
        this.infoSrc = infoSrc;
        this.encSpec = encSpec;
        pl.checkList('P', ParameterList.toNameArray(pinfo));
        int nc = infoSrc.getNumComps();
        int nt = infoSrc.getNumTiles();
        this.ttIncl = new TagTreeEncoder[nt][nc][][][];
        this.ttMaxBP = new TagTreeEncoder[nt][nc][][][];
        this.lblock = new int[nt][nc][][][];
        this.prevtIdxs = new int[nt][nc][][][];
        this.ppinfo = new PrecInfo[nt][nc][][];
        Object tmpCoord = null;
        Object cblks = null;
        infoSrc.setTile(0, 0);
        for (int t = 0; t < nt; ++t) {
            for (int c = 0; c < nc; ++c) {
                SubbandAn root = infoSrc.getAnSubbandTree(t, c);
                int mrl = root.resLvl;
                this.lblock[t][c] = new int[mrl + 1][][];
                this.ttIncl[t][c] = new TagTreeEncoder[mrl + 1][][];
                this.ttMaxBP[t][c] = new TagTreeEncoder[mrl + 1][][];
                this.prevtIdxs[t][c] = new int[mrl + 1][][];
                this.ppinfo[t][c] = new PrecInfo[mrl + 1][];
                for (int r = 0; r <= mrl; ++r) {
                    int mins = r == 0 ? 0 : 1;
                    int maxs = r == 0 ? 1 : 4;
                    int maxPrec = numPrec[t][c][r].x * numPrec[t][c][r].y;
                    this.ttIncl[t][c][r] = new TagTreeEncoder[maxPrec][maxs];
                    this.ttMaxBP[t][c][r] = new TagTreeEncoder[maxPrec][maxs];
                    this.prevtIdxs[t][c][r] = new int[maxs][];
                    this.lblock[t][c][r] = new int[maxs][];
                    this.ppinfo[t][c][r] = new PrecInfo[maxPrec];
                    this.fillPrecInfo(t, c, r);
                    for (int s = mins; s < maxs; ++s) {
                        SubbandAn sb = (SubbandAn)root.getSubbandByIdx(r, s);
                        int numcb = sb.numCb.x * sb.numCb.y;
                        this.lblock[t][c][r][s] = new int[numcb];
                        ArrayUtil.intArraySet(this.lblock[t][c][r][s], 3);
                        this.prevtIdxs[t][c][r][s] = new int[numcb];
                        ArrayUtil.intArraySet(this.prevtIdxs[t][c][r][s], -1);
                    }
                }
            }
            if (t == nt - 1) continue;
            infoSrc.nextTile();
        }
    }

    private void fillPrecInfo(int t, int c, int r) {
        if (this.ppinfo[t][c][r].length == 0) {
            return;
        }
        Coord tileI = this.infoSrc.getTile(null);
        Coord nTiles = this.infoSrc.getNumTiles(null);
        int x0siz = this.infoSrc.getImgULX();
        int y0siz = this.infoSrc.getImgULY();
        int xsiz = x0siz + this.infoSrc.getImgWidth();
        int ysiz = y0siz + this.infoSrc.getImgHeight();
        int xt0siz = this.infoSrc.getTilePartULX();
        int yt0siz = this.infoSrc.getTilePartULY();
        int xtsiz = this.infoSrc.getNomTileWidth();
        int ytsiz = this.infoSrc.getNomTileHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int xrsiz = this.infoSrc.getCompSubsX(c);
        int yrsiz = this.infoSrc.getCompSubsY(c);
        int tcx0 = (int)Math.ceil((double)tx0 / (double)xrsiz);
        int tcy0 = (int)Math.ceil((double)ty0 / (double)yrsiz);
        int tcx1 = (int)Math.ceil((double)tx1 / (double)xrsiz);
        int tcy1 = (int)Math.ceil((double)ty1 / (double)yrsiz);
        int ndl = this.infoSrc.getAnSubbandTree((int)t, (int)c).resLvl - r;
        int trx0 = (int)Math.ceil((double)tcx0 / (double)(1 << ndl));
        int try0 = (int)Math.ceil((double)tcy0 / (double)(1 << ndl));
        int trx1 = (int)Math.ceil((double)tcx1 / (double)(1 << ndl));
        int try1 = (int)Math.ceil((double)tcy1 / (double)(1 << ndl));
        int cb0x = this.infoSrc.getCbULX();
        int cb0y = this.infoSrc.getCbULY();
        double twoppx = this.encSpec.pss.getPPX(t, c, r);
        double twoppy = this.encSpec.pss.getPPY(t, c, r);
        int twoppx2 = (int)(twoppx / 2.0);
        int twoppy2 = (int)(twoppy / 2.0);
        int maxPrec = this.ppinfo[t][c][r].length;
        int nPrec = 0;
        int istart = (int)Math.floor((double)(try0 - cb0y) / twoppy);
        int iend = (int)Math.floor((double)(try1 - 1 - cb0y) / twoppy);
        int jstart = (int)Math.floor((double)(trx0 - cb0x) / twoppx);
        int jend = (int)Math.floor((double)(trx1 - 1 - cb0x) / twoppx);
        SubbandAn root = this.infoSrc.getAnSubbandTree(t, c);
        SubbandAn sb = null;
        int prg_w = (int)twoppx << ndl;
        int prg_h = (int)twoppy << ndl;
        for (int i = istart; i <= iend; ++i) {
            int j = jstart;
            while (j <= jend) {
                CBlkCoordInfo cb;
                int l;
                int k;
                int lend;
                int lstart;
                int l0;
                int kend;
                int kstart;
                int k0;
                int ch;
                int cw;
                int s1y;
                int s0y;
                int s1x;
                int s0x;
                int p1y;
                int p0y;
                int p1x;
                int p0x;
                int acb0y;
                int acb0x;
                int prg_ulx = j == jstart && (trx0 - cb0x) % (xrsiz * (int)twoppx) != 0 ? tx0 : cb0x + j * xrsiz * ((int)twoppx << ndl);
                int prg_uly = i == istart && (try0 - cb0y) % (yrsiz * (int)twoppy) != 0 ? ty0 : cb0y + i * yrsiz * ((int)twoppy << ndl);
                this.ppinfo[t][c][r][nPrec] = new PrecInfo(r, (int)((double)cb0x + (double)j * twoppx), (int)((double)cb0y + (double)i * twoppy), (int)twoppx, (int)twoppy, prg_ulx, prg_uly, prg_w, prg_h);
                if (r == 0) {
                    acb0x = cb0x;
                    acb0y = cb0y;
                    p0x = acb0x + j * (int)twoppx;
                    p1x = p0x + (int)twoppx;
                    p0y = acb0y + i * (int)twoppy;
                    p1y = p0y + (int)twoppy;
                    sb = (SubbandAn)root.getSubbandByIdx(0, 0);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[0] = 0;
                        this.ttIncl[t][c][r][nPrec][0] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][0] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][0] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][0] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[0] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[0] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                this.ppinfo[t][c][r][nPrec].cblk[0][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                            }
                        }
                    }
                } else {
                    acb0x = 0;
                    acb0y = cb0y;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandAn)root.getSubbandByIdx(r, 1);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[1] = 0;
                        this.ttIncl[t][c][r][nPrec][1] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][1] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][1] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][1] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[1] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[1] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                this.ppinfo[t][c][r][nPrec].cblk[1][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                            }
                        }
                    }
                    acb0x = cb0x;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandAn)root.getSubbandByIdx(r, 2);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[2] = 0;
                        this.ttIncl[t][c][r][nPrec][2] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][2] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][2] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][2] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[2] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[2] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                this.ppinfo[t][c][r][nPrec].cblk[2][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                            }
                        }
                    }
                    acb0x = 0;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandAn)root.getSubbandByIdx(r, 3);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[t][c][r][nPrec].nblk[3] = 0;
                        this.ttIncl[t][c][r][nPrec][3] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[t][c][r][nPrec][3] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[t][c][r][nPrec][3] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[t][c][r][nPrec][3] = new TagTreeEncoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[t][c][r][nPrec].cblk[3] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[t][c][r][nPrec].nblk[3] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                this.ppinfo[t][c][r][nPrec].cblk[3][k - kstart][l - lstart] = cb = new CBlkCoordInfo(k - k0, l - l0);
                            }
                        }
                    }
                }
                ++j;
                ++nPrec;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BitOutputBuffer encodePacket(int ly, int c, int r, int t, CBlkRateDistStats[][] cbs, int[][] tIndx, BitOutputBuffer hbuf, byte[] bbuf, int pIdx) {
        int cblen;
        int b;
        int n;
        int nend;
        int m;
        int mend;
        int[] cur_tIndx;
        CBlkRateDistStats[] cur_cbs;
        int[] cur_prevtIdxs;
        SubbandAn sb;
        int s;
        int minsb = r == 0 ? 0 : 1;
        int maxsb = r == 0 ? 1 : 4;
        Coord cbCoord = null;
        SubbandAn root = this.infoSrc.getAnSubbandTree(t, c);
        this.roiInPkt = false;
        this.roiLen = 0;
        if (pIdx >= this.ppinfo[t][c][r].length) {
            this.packetWritable = false;
            return hbuf;
        }
        PrecInfo prec = this.ppinfo[t][c][r][pIdx];
        boolean isPrecVoid = true;
        for (s = minsb; s < maxsb; ++s) {
            if (prec.nblk[s] == 0) continue;
            isPrecVoid = false;
            break;
        }
        if (isPrecVoid) {
            this.packetWritable = true;
            if (hbuf == null) {
                hbuf = new BitOutputBuffer();
            } else {
                hbuf.reset();
            }
            if (bbuf == null) {
                bbuf = new byte[1];
                this.lbbuf = bbuf;
            }
            hbuf.writeBit(0);
            this.lblen = 0;
            return hbuf;
        }
        if (hbuf == null) {
            hbuf = new BitOutputBuffer();
        } else {
            hbuf.reset();
        }
        this.lbbuf = null;
        this.lblen = 0;
        hbuf.writeBit(1);
        for (s = minsb; s < maxsb; ++s) {
            sb = (SubbandAn)root.getSubbandByIdx(r, s);
            if (prec.nblk[s] == 0) continue;
            TagTreeEncoder cur_ttIncl = this.ttIncl[t][c][r][pIdx][s];
            TagTreeEncoder cur_ttMaxBP = this.ttMaxBP[t][c][r][pIdx][s];
            cur_prevtIdxs = this.prevtIdxs[t][c][r][s];
            cur_cbs = cbs[s];
            cur_tIndx = tIndx[s];
            mend = prec.cblk[s] == null ? 0 : prec.cblk[s].length;
            for (m = 0; m < mend; ++m) {
                nend = prec.cblk[s][m] == null ? 0 : prec.cblk[s][m].length;
                for (n = 0; n < nend; ++n) {
                    cbCoord = prec.cblk[s][m][n].idx;
                    b = cbCoord.x + cbCoord.y * sb.numCb.x;
                    if (cur_tIndx[b] > cur_prevtIdxs[b] && cur_prevtIdxs[b] < 0) {
                        cur_ttIncl.setValue(m, n, ly - 1);
                    }
                    if (ly != 1) continue;
                    cur_ttMaxBP.setValue(m, n, cur_cbs[b].skipMSBP);
                }
            }
            for (m = 0; m < prec.cblk[s].length; ++m) {
                for (n = 0; n < prec.cblk[s][m].length; ++n) {
                    int nbits;
                    int j;
                    int prednbits;
                    int newtp;
                    int i;
                    block39: {
                        block38: {
                            cbCoord = prec.cblk[s][m][n].idx;
                            b = cbCoord.x + cbCoord.y * sb.numCb.x;
                            if (cur_tIndx[b] <= cur_prevtIdxs[b]) break block38;
                            if (cur_prevtIdxs[b] < 0) {
                                cur_ttIncl.encode(m, n, ly, hbuf);
                                int thmax = cur_cbs[b].skipMSBP + 1;
                                for (i = 1; i <= thmax; ++i) {
                                    cur_ttMaxBP.encode(m, n, i, hbuf);
                                }
                                this.lblen += cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]];
                            } else {
                                hbuf.writeBit(1);
                                this.lblen += cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]] - cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                            }
                            newtp = cur_prevtIdxs[b] < 0 ? cur_cbs[b].truncIdxs[cur_tIndx[b]] : cur_cbs[b].truncIdxs[cur_tIndx[b]] - cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] - 1;
                            switch (newtp) {
                                case 0: {
                                    hbuf.writeBit(0);
                                    break block39;
                                }
                                case 1: {
                                    hbuf.writeBits(2, 2);
                                    break block39;
                                }
                                case 2: 
                                case 3: 
                                case 4: {
                                    hbuf.writeBits(0xC | newtp - 2, 4);
                                    break block39;
                                }
                                default: {
                                    if (newtp <= 35) {
                                        hbuf.writeBits(0x1E0 | newtp - 5, 9);
                                    } else {
                                        if (newtp > 163) throw new ArithmeticException("Maximum number of truncation points exceeded");
                                        hbuf.writeBits(0xFF80 | newtp - 36, 16);
                                    }
                                    break block39;
                                }
                            }
                        }
                        if (cur_prevtIdxs[b] >= 0) {
                            hbuf.writeBit(0);
                            continue;
                        }
                        cur_ttIncl.encode(m, n, ly, hbuf);
                        continue;
                    }
                    newtp = 1;
                    int maxi = cur_cbs[b].truncIdxs[cur_tIndx[b]];
                    cblen = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                    i = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] + 1;
                    int minbits = 0;
                    while (i < maxi) {
                        if (cur_cbs[b].isTermPass != null && cur_cbs[b].isTermPass[i]) {
                            cblen = cur_cbs[b].truncRates[i] - cblen;
                            prednbits = this.lblock[t][c][r][s][b] + MathUtil.log2(newtp);
                            minbits = (cblen > 0 ? MathUtil.log2(cblen) : 0) + 1;
                            for (j = prednbits; j < minbits; ++j) {
                                int[] nArray = this.lblock[t][c][r][s];
                                int n2 = b;
                                nArray[n2] = nArray[n2] + 1;
                                hbuf.writeBit(1);
                            }
                            newtp = 0;
                            cblen = cur_cbs[b].truncRates[i];
                        }
                        ++i;
                        ++newtp;
                    }
                    cblen = cur_cbs[b].truncRates[i] - cblen;
                    prednbits = this.lblock[t][c][r][s][b] + MathUtil.log2(newtp);
                    minbits = (cblen > 0 ? MathUtil.log2(cblen) : 0) + 1;
                    for (j = prednbits; j < minbits; ++j) {
                        int[] nArray = this.lblock[t][c][r][s];
                        int n3 = b;
                        nArray[n3] = nArray[n3] + 1;
                        hbuf.writeBit(1);
                    }
                    hbuf.writeBit(0);
                    newtp = 1;
                    maxi = cur_cbs[b].truncIdxs[cur_tIndx[b]];
                    cblen = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                    int n4 = i = cur_prevtIdxs[b] < 0 ? 0 : cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] + 1;
                    while (i < maxi) {
                        if (cur_cbs[b].isTermPass != null && cur_cbs[b].isTermPass[i]) {
                            cblen = cur_cbs[b].truncRates[i] - cblen;
                            nbits = MathUtil.log2(newtp) + this.lblock[t][c][r][s][b];
                            hbuf.writeBits(cblen, nbits);
                            newtp = 0;
                            cblen = cur_cbs[b].truncRates[i];
                        }
                        ++i;
                        ++newtp;
                    }
                    cblen = cur_cbs[b].truncRates[i] - cblen;
                    nbits = MathUtil.log2(newtp) + this.lblock[t][c][r][s][b];
                    hbuf.writeBits(cblen, nbits);
                }
            }
        }
        if (bbuf == null || bbuf.length < this.lblen) {
            bbuf = new byte[this.lblen];
        }
        this.lbbuf = bbuf;
        this.lblen = 0;
        for (s = minsb; s < maxsb; ++s) {
            sb = (SubbandAn)root.getSubbandByIdx(r, s);
            cur_prevtIdxs = this.prevtIdxs[t][c][r][s];
            cur_cbs = cbs[s];
            cur_tIndx = tIndx[s];
            int ncb = cur_prevtIdxs.length;
            mend = prec.cblk[s] == null ? 0 : prec.cblk[s].length;
            for (m = 0; m < mend; ++m) {
                nend = prec.cblk[s][m] == null ? 0 : prec.cblk[s][m].length;
                for (n = 0; n < nend; ++n) {
                    cbCoord = prec.cblk[s][m][n].idx;
                    b = cbCoord.x + cbCoord.y * sb.numCb.x;
                    if (cur_tIndx[b] <= cur_prevtIdxs[b]) continue;
                    if (cur_prevtIdxs[b] < 0) {
                        cblen = cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]];
                        System.arraycopy(cur_cbs[b].data, 0, this.lbbuf, this.lblen, cblen);
                    } else {
                        cblen = cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_tIndx[b]]] - cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]];
                        System.arraycopy(cur_cbs[b].data, cur_cbs[b].truncRates[cur_cbs[b].truncIdxs[cur_prevtIdxs[b]]], this.lbbuf, this.lblen, cblen);
                    }
                    this.lblen += cblen;
                    if (cur_cbs[b].nROIcoeff != 0 && (cur_prevtIdxs[b] == -1 || cur_cbs[b].truncIdxs[cur_prevtIdxs[b]] <= cur_cbs[b].nROIcp - 1)) {
                        this.roiInPkt = true;
                        this.roiLen = this.lblen;
                    }
                    cur_prevtIdxs[b] = cur_tIndx[b];
                }
            }
        }
        this.packetWritable = true;
        if (hbuf.getLength() != 0) return hbuf;
        throw new Error("You have found a bug in PktEncoder, method: encodePacket");
    }

    public byte[] getLastBodyBuf() {
        if (this.lbbuf == null) {
            throw new IllegalArgumentException();
        }
        return this.lbbuf;
    }

    public int getLastBodyLen() {
        return this.lblen;
    }

    public void save() {
        int maxsbi;
        int minsbi;
        if (this.bak_lblock == null) {
            this.bak_lblock = new int[this.ttIncl.length][][][][];
            this.bak_prevtIdxs = new int[this.ttIncl.length][][][][];
            for (int t = this.ttIncl.length - 1; t >= 0; --t) {
                this.bak_lblock[t] = new int[this.ttIncl[t].length][][][];
                this.bak_prevtIdxs[t] = new int[this.ttIncl[t].length][][][];
                for (int c = this.ttIncl[t].length - 1; c >= 0; --c) {
                    this.bak_lblock[t][c] = new int[this.lblock[t][c].length][][];
                    this.bak_prevtIdxs[t][c] = new int[this.ttIncl[t][c].length][][];
                    for (int r = this.lblock[t][c].length - 1; r >= 0; --r) {
                        this.bak_lblock[t][c][r] = new int[this.lblock[t][c][r].length][];
                        this.bak_prevtIdxs[t][c][r] = new int[this.prevtIdxs[t][c][r].length][];
                        minsbi = r == 0 ? 0 : 1;
                        maxsbi = r == 0 ? 1 : 4;
                        for (int s = minsbi; s < maxsbi; ++s) {
                            this.bak_lblock[t][c][r][s] = new int[this.lblock[t][c][r][s].length];
                            this.bak_prevtIdxs[t][c][r][s] = new int[this.prevtIdxs[t][c][r][s].length];
                        }
                    }
                }
            }
        }
        for (int t = this.ttIncl.length - 1; t >= 0; --t) {
            for (int c = this.ttIncl[t].length - 1; c >= 0; --c) {
                int[][][] lblock_t_c = this.lblock[t][c];
                int[][][] bak_lblock_t_c = this.bak_lblock[t][c];
                TagTreeEncoder[][][] ttIncl_t_c = this.ttIncl[t][c];
                TagTreeEncoder[][][] ttMaxBP_t_c = this.ttMaxBP[t][c];
                for (int r = lblock_t_c.length - 1; r >= 0; --r) {
                    TagTreeEncoder[][] ttIncl_t_c_r = ttIncl_t_c[r];
                    TagTreeEncoder[][] ttMaxBP_t_c_r = ttMaxBP_t_c[r];
                    int[][] prevtIdxs_t_c_r = this.prevtIdxs[t][c][r];
                    int[][] bak_prevtIdxs_t_c_r = this.bak_prevtIdxs[t][c][r];
                    minsbi = r == 0 ? 0 : 1;
                    maxsbi = r == 0 ? 1 : 4;
                    for (int s = minsbi; s < maxsbi; ++s) {
                        System.arraycopy(lblock_t_c[r][s], 0, bak_lblock_t_c[r][s], 0, lblock_t_c[r][s].length);
                        System.arraycopy(prevtIdxs_t_c_r[s], 0, bak_prevtIdxs_t_c_r[s], 0, prevtIdxs_t_c_r[s].length);
                    }
                    for (int p = this.ppinfo[t][c][r].length - 1; p >= 0; --p) {
                        if (p >= ttIncl_t_c_r.length) continue;
                        for (int s = minsbi; s < maxsbi; ++s) {
                            ttIncl_t_c_r[p][s].save();
                            ttMaxBP_t_c_r[p][s].save();
                        }
                    }
                }
            }
        }
        this.saved = true;
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        this.lbbuf = null;
        for (int t = this.ttIncl.length - 1; t >= 0; --t) {
            for (int c = this.ttIncl[t].length - 1; c >= 0; --c) {
                int[][][] lblock_t_c = this.lblock[t][c];
                int[][][] bak_lblock_t_c = this.bak_lblock[t][c];
                TagTreeEncoder[][][] ttIncl_t_c = this.ttIncl[t][c];
                TagTreeEncoder[][][] ttMaxBP_t_c = this.ttMaxBP[t][c];
                for (int r = lblock_t_c.length - 1; r >= 0; --r) {
                    TagTreeEncoder[][] ttIncl_t_c_r = ttIncl_t_c[r];
                    TagTreeEncoder[][] ttMaxBP_t_c_r = ttMaxBP_t_c[r];
                    int[][] prevtIdxs_t_c_r = this.prevtIdxs[t][c][r];
                    int[][] bak_prevtIdxs_t_c_r = this.bak_prevtIdxs[t][c][r];
                    int minsbi = r == 0 ? 0 : 1;
                    int maxsbi = r == 0 ? 1 : 4;
                    for (int s = minsbi; s < maxsbi; ++s) {
                        System.arraycopy(bak_lblock_t_c[r][s], 0, lblock_t_c[r][s], 0, lblock_t_c[r][s].length);
                        System.arraycopy(bak_prevtIdxs_t_c_r[s], 0, prevtIdxs_t_c_r[s], 0, prevtIdxs_t_c_r[s].length);
                    }
                    for (int p = this.ppinfo[t][c][r].length - 1; p >= 0; --p) {
                        if (p >= ttIncl_t_c_r.length) continue;
                        for (int s = minsbi; s < maxsbi; ++s) {
                            ttIncl_t_c_r[p][s].restore();
                            ttMaxBP_t_c_r[p][s].restore();
                        }
                    }
                }
            }
        }
    }

    public void reset() {
        this.saved = false;
        this.lbbuf = null;
        for (int t = this.ttIncl.length - 1; t >= 0; --t) {
            for (int c = this.ttIncl[t].length - 1; c >= 0; --c) {
                int[][][] lblock_t_c = this.lblock[t][c];
                TagTreeEncoder[][][] ttIncl_t_c = this.ttIncl[t][c];
                TagTreeEncoder[][][] ttMaxBP_t_c = this.ttMaxBP[t][c];
                for (int r = lblock_t_c.length - 1; r >= 0; --r) {
                    TagTreeEncoder[][] ttIncl_t_c_r = ttIncl_t_c[r];
                    TagTreeEncoder[][] ttMaxBP_t_c_r = ttMaxBP_t_c[r];
                    int[][] prevtIdxs_t_c_r = this.prevtIdxs[t][c][r];
                    int minsbi = r == 0 ? 0 : 1;
                    int maxsbi = r == 0 ? 1 : 4;
                    for (int s = minsbi; s < maxsbi; ++s) {
                        ArrayUtil.intArraySet(prevtIdxs_t_c_r[s], -1);
                        ArrayUtil.intArraySet(lblock_t_c[r][s], 3);
                    }
                    for (int p = this.ppinfo[t][c][r].length - 1; p >= 0; --p) {
                        if (p >= ttIncl_t_c_r.length) continue;
                        for (int s = minsbi; s < maxsbi; ++s) {
                            ttIncl_t_c_r[p][s].reset();
                            ttMaxBP_t_c_r[p][s].reset();
                        }
                    }
                }
            }
        }
    }

    public boolean isPacketWritable() {
        return this.packetWritable;
    }

    public boolean isROIinPkt() {
        return this.roiInPkt;
    }

    public int getROILen() {
        return this.roiLen;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public PrecInfo getPrecInfo(int t, int c, int r, int p) {
        return this.ppinfo[t][c][r][p];
    }
}

