/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class ArrayStructureMA
extends ArrayStructure {
    public ArrayStructureMA(StructureMembers members, int[] shape) {
        super(members, shape);
    }

    public ArrayStructureMA(StructureMembers members, int[] shape, StructureData[] sdata) {
        super(members, shape);
        if (this.nelems != sdata.length) {
            throw new IllegalArgumentException("StructureData length= " + sdata.length + "!= shape.length=" + this.nelems);
        }
        this.sdata = sdata;
    }

    public static ArrayStructureMA factoryMA(ArrayStructure from) throws IOException {
        if (from instanceof ArrayStructureMA) {
            return (ArrayStructureMA)from;
        }
        StructureMembers tosm = new StructureMembers(new StructureMembers(from.getStructureMembers()));
        ArrayStructureMA to = new ArrayStructureMA(tosm, from.getShape());
        for (StructureMembers.Member m : from.getMembers()) {
            to.setMemberArray(m.getName(), from.extractMemberArray(m));
        }
        return to;
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        return new StructureDataA(as, index);
    }

    public void setMemberArray(String memberName, Array data) {
        StructureMembers.Member m = this.members.findMember(memberName);
        m.setDataArray(data);
    }

    public static ArrayStructureMA factoryMA(Structure from, int[] shape) throws IOException {
        StructureMembers sm = from.makeStructureMembers();
        for (Variable v : from.getVariables()) {
            Array data = v instanceof Sequence ? new ArrayObject(ArraySequence.class, shape) : (v instanceof Structure ? ArrayStructureMA.factoryMA((Structure)v, ArrayStructureMA.combine(shape, v.getShape())) : Array.factory(v.getDataType(), ArrayStructureMA.combine(shape, v.getShape())));
            StructureMembers.Member m = sm.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return new ArrayStructureMA(sm, shape);
    }

    private static int[] combine(int[] shape1, int[] shape2) {
        int[] result = new int[shape1.length + shape2.length];
        System.arraycopy(shape1, 0, result, 0, shape1.length);
        System.arraycopy(shape2, 0, result, shape1.length, shape2.length);
        return result;
    }
}

