/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.iosp.gempak.GempakLookup;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.iosp.mcidas.McIDASLookup;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridIndexToNC {
    private static Logger logger = LoggerFactory.getLogger(GridIndexToNC.class);
    private Map<String, GridHorizCoordSys> hcsHash = new HashMap<String, GridHorizCoordSys>(10);
    private DateFormatter formatter = new DateFormatter();
    private boolean debug = false;
    private boolean useDescriptionForVariableName = true;

    public static String makeLevelName(GridRecord gr, GridTableLookup lookup) {
        if (lookup instanceof Grib2GridTableLookup) {
            String vname = lookup.getLevelName(gr);
            return lookup.isLayer(gr) ? vname + "_layer" : vname;
        }
        return lookup.getLevelName(gr);
    }

    public static String makeSuffixName(GridRecord gr, GridTableLookup lookup) {
        if (!(lookup instanceof Grib2GridTableLookup)) {
            return "";
        }
        Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)lookup;
        return g2lookup.makeSuffix(gr);
    }

    public String makeVariableName(GridRecord gr, GridTableLookup lookup) {
        GridParameter param = lookup.getParameter(gr);
        String levelName = GridIndexToNC.makeLevelName(gr, lookup);
        String suffixName = GridIndexToNC.makeSuffixName(gr, lookup);
        String paramName = this.useDescriptionForVariableName ? param.getDescription() : param.getName();
        paramName = suffixName.length() == 0 ? paramName : paramName + "_" + suffixName;
        paramName = levelName.length() == 0 ? paramName : paramName + "_" + levelName;
        return paramName;
    }

    public void open(GridIndex index, GridTableLookup lookup, int version, NetcdfFile ncfile, FmrcCoordSys fmrcCoordSys, CancelTask cancelTask) throws IOException {
        ArrayList<GridVariable> gribvars;
        String genType;
        List<GridDefRecord> hcsList = index.getHorizCoordSys();
        boolean needGroups = hcsList.size() > 1;
        for (GridDefRecord gds : hcsList) {
            Group g = null;
            if (needGroups) {
                g = new Group(ncfile, null, gds.getGroupName());
                ncfile.addGroup(null, g);
            }
            GridHorizCoordSys hcs = new GridHorizCoordSys(gds, lookup, g);
            this.hcsHash.put(gds.getParam("GDSkey"), hcs);
        }
        GridRecord firstRecord = null;
        List<GridRecord> records = index.getGridRecords();
        if (GridServiceProvider.debugOpen) {
            System.out.println(" number of products = " + records.size());
        }
        for (GridRecord gribRecord : records) {
            if (firstRecord == null) {
                firstRecord = gribRecord;
            }
            GridHorizCoordSys hcs = this.hcsHash.get(gribRecord.getGridDefRecordId());
            String name = this.makeVariableName(gribRecord, lookup);
            GridVariable pv = hcs.varHash.get(name);
            if (null == pv) {
                String pname = lookup.getParameter(gribRecord).getDescription();
                pv = new GridVariable(name, pname, hcs, lookup);
                hcs.varHash.put(name, pv);
                List<GridVariable> plist = hcs.productHash.get(pname);
                if (null == plist) {
                    plist = new ArrayList<GridVariable>();
                    hcs.productHash.put(pname, plist);
                }
                plist.add(pv);
            }
            pv.addProduct(gribRecord);
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.0"));
        String creator = null;
        if (lookup instanceof Grib2GridTableLookup) {
            Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)lookup;
            creator = g2lookup.getFirstCenterName() + " subcenter = " + g2lookup.getFirstSubcenterId();
            if (creator != null) {
                ncfile.addAttribute(null, new Attribute("Originating_center", creator));
            }
            if ((genType = g2lookup.getTypeGenProcessName(firstRecord)) != null) {
                ncfile.addAttribute(null, new Attribute("Generating_Process_or_Model", genType));
            }
            if (null != g2lookup.getFirstProductStatusName()) {
                ncfile.addAttribute(null, new Attribute("Product_Status", g2lookup.getFirstProductStatusName()));
            }
            ncfile.addAttribute(null, new Attribute("Product_Type", g2lookup.getFirstProductTypeName()));
        } else if (lookup instanceof Grib1GridTableLookup) {
            Grib1GridTableLookup g1lookup = (Grib1GridTableLookup)lookup;
            creator = g1lookup.getFirstCenterName() + " subcenter = " + g1lookup.getFirstSubcenterId();
            if (creator != null) {
                ncfile.addAttribute(null, new Attribute("Originating_center", creator));
            }
            if ((genType = g1lookup.getTypeGenProcessName(firstRecord)) != null) {
                ncfile.addAttribute(null, new Attribute("Generating_Process_or_Model", genType));
            }
            if (null != g1lookup.getFirstProductStatusName()) {
                ncfile.addAttribute(null, new Attribute("Product_Status", g1lookup.getFirstProductStatusName()));
            }
            ncfile.addAttribute(null, new Attribute("Product_Type", g1lookup.getFirstProductTypeName()));
        }
        ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        if (creator != null) {
            ncfile.addAttribute(null, new Attribute("creator_name", creator));
        }
        ncfile.addAttribute(null, new Attribute("file_format", lookup.getGridType()));
        ncfile.addAttribute(null, new Attribute("location", ncfile.getLocation()));
        ncfile.addAttribute(null, new Attribute("history", "Direct read of " + lookup.getGridType() + " into NetCDF-Java 4.0 API"));
        ncfile.addAttribute(null, new Attribute("_CoordinateModelRunDate", this.formatter.toDateTimeStringISO(lookup.getFirstBaseTime())));
        if (fmrcCoordSys != null) {
            this.makeDefinedCoordSys(ncfile, lookup, fmrcCoordSys);
        } else {
            this.makeDenseCoordSys(ncfile, lookup, cancelTask);
        }
        if (GridServiceProvider.debugMissing) {
            int count = 0;
            Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
            for (GridHorizCoordSys hcs : hcset) {
                gribvars = new ArrayList<GridVariable>(hcs.varHash.values());
                for (GridVariable gv : gribvars) {
                    count += gv.dumpMissingSummary();
                }
            }
            System.out.println(" total missing= " + count);
        }
        if (GridServiceProvider.debugMissingDetails) {
            Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
            for (GridHorizCoordSys hcs : hcset) {
                System.out.println("******** Horiz Coordinate= " + hcs.getGridName());
                String lastVertDesc = null;
                gribvars = new ArrayList<GridVariable>(hcs.varHash.values());
                Collections.sort(gribvars, new CompareGridVariableByVertName());
                for (GridVariable gv : gribvars) {
                    String vertDesc = gv.getVertName();
                    if (!vertDesc.equals(lastVertDesc)) {
                        System.out.println("---Vertical Coordinate= " + vertDesc);
                        lastVertDesc = vertDesc;
                    }
                    gv.dumpMissing();
                }
            }
        }
    }

    public GridHorizCoordSys getHorizCoordSys(GridRecord gribRecord) {
        return this.hcsHash.get(gribRecord.getGridDefRecordId());
    }

    public Map<String, GridHorizCoordSys> getHorizCoordSystems() {
        return this.hcsHash;
    }

    private void makeDenseCoordSys(NetcdfFile ncfile, GridTableLookup lookup, CancelTask cancelTask) throws IOException {
        ArrayList<GridTimeCoord> timeCoords = new ArrayList<GridTimeCoord>();
        ArrayList<GridVertCoord> vertCoords = new ArrayList<GridVertCoord>();
        ArrayList<GridEnsembleCoord> ensembleCoords = new ArrayList<GridEnsembleCoord>();
        Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
        for (GridHorizCoordSys hcs : hcset) {
            if (cancelTask != null && cancelTask.isCancel()) break;
            ArrayList<GridVariable> gribvars = new ArrayList<GridVariable>(hcs.varHash.values());
            for (GridVariable pv : gribvars) {
                if (cancelTask != null && cancelTask.isCancel()) break;
                List<GridRecord> recordList = pv.getRecords();
                GridRecord record = recordList.get(0);
                String vname = GridIndexToNC.makeLevelName(record, lookup);
                GridVertCoord useVertCoord = null;
                for (GridVertCoord gvcs : vertCoords) {
                    if (!vname.equals(gvcs.getLevelName()) || !gvcs.matchLevels(recordList)) continue;
                    useVertCoord = gvcs;
                }
                if (useVertCoord == null) {
                    useVertCoord = new GridVertCoord(recordList, vname, lookup, hcs);
                    vertCoords.add(useVertCoord);
                }
                pv.setVertCoord(useVertCoord);
                GridTimeCoord useTimeCoord = null;
                for (GridTimeCoord gridTimeCoord : timeCoords) {
                    if (!gridTimeCoord.matchLevels(recordList)) continue;
                    useTimeCoord = gridTimeCoord;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = new GridTimeCoord(recordList, lookup);
                    timeCoords.add(useTimeCoord);
                }
                pv.setTimeCoord(useTimeCoord);
                GridEnsembleCoord useEnsembleCoord = null;
                GridEnsembleCoord gridEnsembleCoord = new GridEnsembleCoord(recordList, lookup);
                for (GridEnsembleCoord gec : ensembleCoords) {
                    if (gridEnsembleCoord.getNEnsembles() != gec.getNEnsembles()) continue;
                    useEnsembleCoord = gec;
                    break;
                }
                if (useEnsembleCoord == null) {
                    useEnsembleCoord = gridEnsembleCoord;
                    ensembleCoords.add(useEnsembleCoord);
                }
                if (useEnsembleCoord.getNEnsembles() <= 1) continue;
                pv.setEnsembleCoord(useEnsembleCoord);
            }
            GridTimeCoord tcs0 = null;
            int maxTimes = 0;
            for (GridTimeCoord tcs : timeCoords) {
                if (tcs.getNTimes() <= maxTimes) continue;
                tcs0 = tcs;
                maxTimes = tcs.getNTimes();
            }
            int seqno = 1;
            for (GridTimeCoord tcs : timeCoords) {
                if (tcs != tcs0) {
                    tcs.setSequence(seqno++);
                }
                tcs.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            seqno = 0;
            for (GridEnsembleCoord gec : ensembleCoords) {
                gec.setSequence(seqno++);
                if (gec.getNEnsembles() <= 1) continue;
                gec.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            Collections.sort(vertCoords);
            int vcIndex = 0;
            String listName = null;
            int start = 0;
            for (vcIndex = 0; vcIndex < vertCoords.size(); ++vcIndex) {
                GridVertCoord gvcs = (GridVertCoord)vertCoords.get(vcIndex);
                String vname = gvcs.getLevelName();
                if (listName == null) {
                    listName = vname;
                }
                if (vname.equals(listName)) continue;
                this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
                listName = vname;
                start = vcIndex;
            }
            this.makeVerticalDimensions(vertCoords.subList(start, vcIndex), ncfile, hcs.getGroup());
            ArrayList<List<GridVariable>> products = new ArrayList<List<GridVariable>>(hcs.productHash.values());
            Collections.sort(products, new CompareGridVariableListByName());
            for (List list : products) {
                if (cancelTask != null && cancelTask.isCancel()) break;
                if (list.size() == 1) {
                    GridVariable pv = (GridVariable)list.get(0);
                    Variable v = lookup instanceof GempakLookup || lookup instanceof McIDASLookup ? pv.makeVariable(ncfile, hcs.getGroup(), false) : pv.makeVariable(ncfile, hcs.getGroup(), true);
                    ncfile.addVariable(hcs.getGroup(), v);
                    continue;
                }
                Collections.sort(list, new CompareGridVariableByNumberVertLevels());
                boolean isGrib2 = false;
                Grib2GridTableLookup g2lookup = null;
                if (lookup instanceof Grib2GridTableLookup) {
                    g2lookup = (Grib2GridTableLookup)lookup;
                    isGrib2 = true;
                }
                for (int k = 0; k < list.size(); ++k) {
                    GridVariable pv = (GridVariable)list.get(k);
                    if (isGrib2 && (g2lookup.isEnsemble(pv.getFirstRecord()) || g2lookup.isProbability(pv.getFirstRecord())) || lookup instanceof GempakLookup || lookup instanceof McIDASLookup) {
                        ncfile.addVariable(hcs.getGroup(), pv.makeVariable(ncfile, hcs.getGroup(), false));
                        continue;
                    }
                    ncfile.addVariable(hcs.getGroup(), pv.makeVariable(ncfile, hcs.getGroup(), k == 0));
                }
            }
            for (GridTimeCoord gridTimeCoord : timeCoords) {
                gridTimeCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            for (GridEnsembleCoord gridEnsembleCoord : ensembleCoords) {
                if (gridEnsembleCoord.getNEnsembles() <= 1) continue;
                gridEnsembleCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (GridVertCoord gridVertCoord : vertCoords) {
                gridVertCoord.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
    }

    private void makeVerticalDimensions(List<GridVertCoord> vertCoordList, NetcdfFile ncfile, Group group) {
        GridVertCoord gvcs0 = null;
        int maxLevels = 0;
        for (GridVertCoord gvcs : vertCoordList) {
            if (gvcs.getNLevels() <= maxLevels) continue;
            gvcs0 = gvcs;
            maxLevels = gvcs.getNLevels();
        }
        int seqno = 1;
        for (GridVertCoord gvcs : vertCoordList) {
            if (gvcs != gvcs0) {
                gvcs.setSequence(seqno++);
            }
            gvcs.addDimensionsToNetcdfFile(ncfile, group);
        }
    }

    private void makeDefinedCoordSys(NetcdfFile ncfile, GridTableLookup lookup, FmrcCoordSys fmr) throws IOException {
        ArrayList<GridTimeCoord> timeCoords = new ArrayList<GridTimeCoord>();
        ArrayList<GridVertCoord> vertCoords = new ArrayList<GridVertCoord>();
        ArrayList<GridEnsembleCoord> ensembleCoords = new ArrayList<GridEnsembleCoord>();
        ArrayList<String> removeVariables = new ArrayList<String>();
        Collection<GridHorizCoordSys> hcset = this.hcsHash.values();
        for (GridHorizCoordSys hcs : hcset) {
            Set<String> keys = hcs.varHash.keySet();
            for (String key : keys) {
                GridVariable pv = hcs.varHash.get(key);
                GridRecord record = pv.getFirstRecord();
                String searchName = this.findVariableName(ncfile, record, lookup, fmr);
                if (searchName == null) {
                    removeVariables.add(key);
                    continue;
                }
                pv.setVarName(searchName);
                FmrcCoordSys.VertCoord vc_def = fmr.findVertCoordForVariable(searchName);
                if (vc_def != null) {
                    String vc_name = vc_def.getName();
                    GridVertCoord useVertCoord = null;
                    for (GridVertCoord gvcs : vertCoords) {
                        if (!vc_name.equals(gvcs.getLevelName())) continue;
                        useVertCoord = gvcs;
                    }
                    if (useVertCoord == null) {
                        useVertCoord = new GridVertCoord(record, vc_name, lookup, vc_def.getValues1(), vc_def.getValues2());
                        useVertCoord.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
                        vertCoords.add(useVertCoord);
                    }
                    pv.setVertCoord(useVertCoord);
                } else {
                    pv.setVertCoord(new GridVertCoord(searchName));
                }
                FmrcCoordSys.TimeCoord tc_def = fmr.findTimeCoordForVariable(searchName, lookup.getFirstBaseTime());
                String tc_name = tc_def.getName();
                GridTimeCoord useTimeCoord = null;
                for (GridTimeCoord gtc : timeCoords) {
                    if (!tc_name.equals(gtc.getName())) continue;
                    useTimeCoord = gtc;
                }
                if (useTimeCoord == null) {
                    useTimeCoord = new GridTimeCoord(tc_name, tc_def.getOffsetHours(), lookup);
                    useTimeCoord.addDimensionsToNetcdfFile(ncfile, hcs.getGroup());
                    timeCoords.add(useTimeCoord);
                }
                pv.setTimeCoord(useTimeCoord);
                GridEnsembleCoord useEnsembleCoord = null;
                GridEnsembleCoord ensembleCoord = new GridEnsembleCoord(record, lookup);
                for (GridEnsembleCoord gec : ensembleCoords) {
                    if (ensembleCoord.getNEnsembles() != gec.getNEnsembles()) continue;
                    useEnsembleCoord = gec;
                    break;
                }
                if (useEnsembleCoord == null) {
                    useEnsembleCoord = ensembleCoord;
                    ensembleCoords.add(useEnsembleCoord);
                }
                if (useEnsembleCoord.getNEnsembles() <= 1) continue;
                pv.setEnsembleCoord(useEnsembleCoord);
            }
            for (String key : removeVariables) {
                hcs.varHash.remove(key);
            }
            hcs.addDimensionsToNetcdfFile(ncfile);
            Collection<GridVariable> vars = hcs.varHash.values();
            for (GridVariable pv : vars) {
                Variable v;
                Group g = hcs.getGroup() == null ? ncfile.getRootGroup() : hcs.getGroup();
                if (g.findVariable((v = pv.makeVariable(ncfile, g, true)).getShortName()) != null) {
                    logger.warn("GribGridServiceProvider.GridIndexToNC: FmrcCoordSys has 2 variables mapped to =" + v.getShortName() + " for file " + ncfile.getLocation());
                    continue;
                }
                g.addVariable(v);
            }
            for (GridTimeCoord tcs : timeCoords) {
                tcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            for (GridEnsembleCoord gec : ensembleCoords) {
                if (gec.getNEnsembles() <= 1) continue;
                gec.addToNetcdfFile(ncfile, hcs.getGroup());
            }
            hcs.addToNetcdfFile(ncfile);
            for (GridVertCoord gvcs : vertCoords) {
                gvcs.addToNetcdfFile(ncfile, hcs.getGroup());
            }
        }
        if (this.debug) {
            System.out.println("GridIndexToNC.makeDefinedCoordSys for " + ncfile.getLocation());
        }
    }

    private String findVariableName(NetcdfFile ncfile, GridRecord gr, GridTableLookup lookup, FmrcCoordSys fmr) {
        String name = this.makeVariableName(gr, lookup);
        if (this.debug) {
            System.out.println("name =" + name);
        }
        if (fmr.hasVariable(name)) {
            return name;
        }
        String pname = lookup.getParameter(gr).getDescription();
        if (this.debug) {
            System.out.println("pname =" + pname);
        }
        if (fmr.hasVariable(pname)) {
            return pname;
        }
        String nameWunder = StringUtil.replace(name, ' ', "_");
        if (this.debug) {
            System.out.println("nameWunder =" + nameWunder);
        }
        if (fmr.hasVariable(nameWunder)) {
            return nameWunder;
        }
        String pnameWunder = StringUtil.replace(pname, ' ', "_");
        if (this.debug) {
            System.out.println("pnameWunder =" + pnameWunder);
        }
        if (fmr.hasVariable(pnameWunder)) {
            return pnameWunder;
        }
        logger.warn("GridServiceProvider.GridIndexToNC: FmrcCoordSys does not have the variable named =" + name + " or " + pname + " or " + nameWunder + " or " + pnameWunder + " for file " + ncfile.getLocation());
        return null;
    }

    public void setUseDescriptionForVariableName(boolean value) {
        this.useDescriptionForVariableName = value;
    }

    private class CompareGridVariableByNumberVertLevels
    implements Comparator {
        private CompareGridVariableByNumberVertLevels() {
        }

        public int compare(Object o1, Object o2) {
            int n2;
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            int n1 = gv1.getVertCoord().getNLevels();
            if (n1 == (n2 = gv2.getVertCoord().getNLevels())) {
                return gv1.getVertCoord().getLevelName().compareTo(gv2.getVertCoord().getLevelName());
            }
            return n2 - n1;
        }
    }

    private class CompareGridVariableByVertName
    implements Comparator {
        private CompareGridVariableByVertName() {
        }

        public int compare(Object o1, Object o2) {
            GridVariable gv1 = (GridVariable)o1;
            GridVariable gv2 = (GridVariable)o2;
            return gv1.getVertName().compareToIgnoreCase(gv2.getVertName());
        }
    }

    private class CompareGridVariableListByName
    implements Comparator {
        private CompareGridVariableListByName() {
        }

        public int compare(Object o1, Object o2) {
            ArrayList list1 = (ArrayList)o1;
            ArrayList list2 = (ArrayList)o2;
            GridVariable gv1 = (GridVariable)list1.get(0);
            GridVariable gv2 = (GridVariable)list2.get(0);
            return gv1.getName().compareToIgnoreCase(gv2.getName());
        }
    }
}

