/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.Dimension;
import ucar.units.Factor;
import ucar.units.QuantityDimension;
import ucar.units.UnitName;

public final class UnitDimension
extends Dimension {
    public UnitDimension() {
    }

    public UnitDimension(BaseUnit baseUnit) {
        super(new Factor(baseUnit));
    }

    private UnitDimension(Factor[] factors) {
        super(factors);
    }

    public UnitDimension multiplyBy(UnitDimension that) {
        return new UnitDimension(this.mult(that));
    }

    public UnitDimension divideBy(UnitDimension that) {
        return this.multiplyBy(that.raiseTo(-1));
    }

    public UnitDimension raiseTo(int power) {
        return new UnitDimension(this.pow(power));
    }

    public QuantityDimension getQuantityDimension() {
        Factor[] factors = this.getFactors();
        int i = factors.length;
        while (--i >= 0) {
            Factor factor = factors[i];
            factors[i] = new Factor(((BaseUnit)factor.getBase()).getBaseQuantity(), factor.getExponent());
        }
        return new QuantityDimension(factors);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("new UnitDimension() = \"" + new UnitDimension() + '\"');
        UnitDimension timeDimension = new UnitDimension(BaseUnit.getOrCreate(UnitName.newUnitName("second", null, "s"), BaseQuantity.TIME));
        System.out.println("timeDimension = \"" + timeDimension + '\"');
        UnitDimension lengthDimension = new UnitDimension(BaseUnit.getOrCreate(UnitName.newUnitName("meter", null, "m"), BaseQuantity.LENGTH));
        System.out.println("lengthDimension = \"" + lengthDimension + '\"');
        System.out.println("lengthDimension.isReciprocalOf(timeDimension) = \"" + lengthDimension.isReciprocalOf(timeDimension) + '\"');
        UnitDimension hertzDimension = timeDimension.raiseTo(-1);
        System.out.println("hertzDimension = \"" + hertzDimension + '\"');
        System.out.println("hertzDimension.isReciprocalOf(timeDimension) = \"" + hertzDimension.isReciprocalOf(timeDimension) + '\"');
        System.out.println("lengthDimension.divideBy(timeDimension) = \"" + lengthDimension.divideBy(timeDimension) + '\"');
        System.out.println("lengthDimension.divideBy(timeDimension).raiseTo(2) = \"" + lengthDimension.divideBy(timeDimension).raiseTo(2) + '\"');
    }
}

