/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.materialicons;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on Google Material Icons v2.1
 * https://www.google.com/design/icons/
 *
 * @author Jens Deters (mail@jensd.de)
 */
public enum MaterialIcon implements GlyphIcons {

    AC_UNIT('\ueB3B'),
    ACCESS_ALARM('\ue190'),
    ACCESS_ALARMS('\ue191'),
    ACCESS_TIME('\ue192'),
    ACCESSIBILITY('\ue84E'),
    ACCESSIBLE('\ue914'),
    ACCOUNT_BALANCE('\ue84F'),
    ACCOUNT_BALANCE_WALLET('\ue850'),
    ACCOUNT_BOX('\ue851'),
    ACCOUNT_CIRCLE('\ue853'),
    ADB('\ue60E'),
    ADD('\ue145'),
    ADD_A_PHOTO('\ue439'),
    ADD_ALARM('\ue193'),
    ADD_ALERT('\ue003'),
    ADD_BOX('\ue146'),
    ADD_CIRCLE('\ue147'),
    ADD_CIRCLE_OUTLINE('\ue148'),
    ADD_LOCATION('\ue567'),
    ADD_SHOPPING_CART('\ue854'),
    ADD_TO_PHOTOS('\ue39D'),
    ADD_TO_QUEUE('\ue05C'),
    ADJUST('\ue39E'),
    AIRLINE_SEAT_FLAT('\ue630'),
    AIRLINE_SEAT_FLAT_ANGLED('\ue631'),
    AIRLINE_SEAT_INDIVIDUAL_SUITE('\ue632'),
    AIRLINE_SEAT_LEGROOM_EXTRA('\ue633'),
    AIRLINE_SEAT_LEGROOM_NORMAL('\ue634'),
    AIRLINE_SEAT_LEGROOM_REDUCED('\ue635'),
    AIRLINE_SEAT_RECLINE_EXTRA('\ue636'),
    AIRLINE_SEAT_RECLINE_NORMAL('\ue637'),
    AIRPLANEMODE_ACTIVE('\ue195'),
    AIRPLANEMODE_INACTIVE('\ue194'),
    AIRPLAY('\ue055'),
    AIRPORT_SHUTTLE('\ueB3C'),
    ALARM('\ue855'),
    ALARM_ADD('\ue856'),
    ALARM_OFF('\ue857'),
    ALARM_ON('\ue858'),
    ALBUM('\ue019'),
    ALL_INCLUSIVE('\ueB3D'),
    ALL_OUT('\ue90B'),
    ANDROID('\ue859'),
    ANNOUNCEMENT('\ue85A'),
    APPS('\ue5C3'),
    ARCHIVE('\ue149'),
    ARROW_BACK('\ue5C4'),
    ARROW_DOWNLOAD('\ue5DB'),
    ARROW_DROP_DOWN('\ue5C5'),
    ARROW_DROP_DOWN_CIRCLE('\ue5C6'),
    ARROW_DROP_UP('\ue5C7'),
    ARROW_FORWARD('\ue5C8'),
    ARROW_UPWARD('\ue5D8'),
    ART_TRACK('\ue060'),
    ASPECT_RATIO('\ue85B'),
    ASSESSMENT('\ue85C'),
    ASSIGNMENT('\ue85D'),
    ASSIGNMENT_IND('\ue85E'),
    ASSIGNMENT_LATE('\ue85F'),
    ASSIGNMENT_RETURN('\ue860'),
    ASSIGNMENT_RETURNED('\ue861'),
    ASSIGNMENT_TURNED_IN('\ue862'),
    ASSISTANT('\ue39F'),
    ASSISTANT_PHOTO('\ue3A0'),
    ATTACH_FILE('\ue226'),
    ATTACH_MONEY('\ue227'),
    ATTACHMENT('\ue2BC'),
    AUDIOTRACK('\ue3A1'),
    AUTORENEW('\ue863'),
    AV_TIMER('\ue01B'),
    BACKSPACE('\ue14A'),
    BACKUP('\ue864'),
    BATTERY_ALERT('\ue19C'),
    BATTERY_CHARGING_FULL('\ue1A3'),
    BATTERY_FULL('\ue1A4'),
    BATTERY_STD('\ue1A5'),
    BATTERY_UNKNOWN('\ue1A6'),
    BEACH_ACCESS('\ueB3E'),
    BEENHERE('\ue52D'),
    BLOCK('\ue14B'),
    BLUETOOTH('\ue1A7'),
    BLUETOOTH_AUDIO('\ue60F'),
    BLUETOOTH_CONNECTED('\ue1A8'),
    BLUETOOTH_DISABLED('\ue1A9'),
    BLUETOOTH_SEARCHING('\ue1AA'),
    BLUR_CIRCULAR('\ue3A2'),
    BLUR_LINEAR('\ue3A3'),
    BLUR_OFF('\ue3A4'),
    BLUR_ON('\ue3A5'),
    BOOK('\ue865'),
    BOOKMARK('\ue866'),
    BOOKMARK_BORDER('\ue867'),
    BORDER_ALL('\ue228'),
    BORDER_BOTTOM('\ue229'),
    BORDER_CLEAR('\ue22A'),
    BORDER_COLOR('\ue22B'),
    BORDER_HORIZONTAL('\ue22C'),
    BORDER_INNER('\ue22D'),
    BORDER_LEFT('\ue22E'),
    BORDER_OUTER('\ue22F'),
    BORDER_RIGHT('\ue230'),
    BORDER_STYLE('\ue231'),
    BORDER_TOP('\ue232'),
    BORDER_VERTICAL('\ue233'),
    BRIGHTNESS_1('\ue3A6'),
    BRIGHTNESS_2('\ue3A7'),
    BRIGHTNESS_3('\ue3A8'),
    BRIGHTNESS_4('\ue3A9'),
    BRIGHTNESS_5('\ue3AA'),
    BRIGHTNESS_6('\ue3AB'),
    BRIGHTNESS_7('\ue3AC'),
    BRIGHTNESS_AUTO('\ue1AB'),
    BRIGHTNESS_HIGH('\ue1AC'),
    BRIGHTNESS_LOW('\ue1AD'),
    BRIGHTNESS_MEDIUM('\ue1AE'),
    BROKEN_IMAGE('\ue3AD'),
    BRUSH('\ue3AE'),
    BUG_REPORT('\ue868'),
    BUILD('\ue869'),
    BUSINESS('\ue0AF'),
    BUSINESS_CENTER('\ueB3F'),
    CACHED('\ue86A'),
    CAKE('\ue7E9'),
    CALL('\ue0B0'),
    CALL_END('\ue0B1'),
    CALL_MADE('\ue0B2'),
    CALL_MERGE('\ue0B3'),
    CALL_MISSED('\ue0B4'),
    CALL_MISSED_OUTGOING('\ue0E4'),
    CALL_RECEIVED('\ue0B5'),
    CALL_SPLIT('\ue0B6'),
    CAMERA('\ue3AF'),
    CAMERA_ALT('\ue3B0'),
    CAMERA_ENHANCE('\ue8FC'),
    CAMERA_FRONT('\ue3B1'),
    CAMERA_REAR('\ue3B2'),
    CAMERA_ROLL('\ue3B3'),
    CANCEL('\ue5C9'),
    CARD_GIFTCARD('\ue8F6'),
    CARD_MEMBERSHIP('\ue8F7'),
    CARD_TRAVEL('\ue8F8'),
    CASINO('\ueB40'),
    CAST('\ue307'),
    CAST_CONNECTED('\ue308'),
    CENTER_FOCUS_STRONG('\ue3B4'),
    CENTER_FOCUS_WEAK('\ue3B5'),
    CHANGE_HISTORY('\ue86B'),
    CHAT('\ue0B7'),
    CHAT_BUBBLE('\ue0CA'),
    CHAT_BUBBLE_OUTLINE('\ue0CB'),
    CHECK('\ue5CA'),
    CHECK_BOX('\ue834'),
    CHECK_BOX_OUTLINE_BLANK('\ue835'),
    CHECK_CIRCLE('\ue86C'),
    CHEVRON_LEFT('\ue5CB'),
    CHEVRON_RIGHT('\ue5CC'),
    CHILD_CARE('\ueB41'),
    CHILD_FRIENDLY('\ueB42'),
    CHROME_READER_MODE('\ue86D'),
    CLASS('\ue86E'),
    CLEAR('\ue14C'),
    CLEAR_ALL('\ue0B8'),
    CLOSE('\ue5CD'),
    CLOSED_CAPTION('\ue01C'),
    CLOUD('\ue2BD'),
    CLOUD_CIRCLE('\ue2BE'),
    CLOUD_DONE('\ue2BF'),
    CLOUD_DOWNLOAD('\ue2C0'),
    CLOUD_OFF('\ue2C1'),
    CLOUD_QUEUE('\ue2C2'),
    CLOUD_UPLOAD('\ue2C3'),
    CODE('\ue86F'),
    COLLECTIONS('\ue3B6'),
    COLLECTIONS_BOOKMARK('\ue431'),
    COLOR_LENS('\ue3B7'),
    COLORIZE('\ue3B8'),
    COMMENT('\ue0B9'),
    COMPARE('\ue3B9'),
    COMPARE_ARROWS('\ue915'),
    COMPUTER('\ue30A'),
    CONFIRMATION_NUMBER('\ue638'),
    CONTACT_MAIL('\ue0D0'),
    CONTACT_PHONE('\ue0CF'),
    CONTACTS('\ue0BA'),
    CONTENT_COPY('\ue14D'),
    CONTENT_CUT('\ue14E'),
    CONTENT_PASTE('\ue14F'),
    CONTROL_POINT('\ue3BA'),
    CONTROL_POINT_DUPLICATE('\ue3BB'),
    COPYRIGHT('\ue90C'),
    CREATE('\ue150'),
    CREATE_NEW_FOLDER('\ue2CC'),
    CREDIT_CARD('\ue870'),
    CROP('\ue3BE'),
    CROP_16_9('\ue3BC'),
    CROP_3_2('\ue3BD'),
    CROP_5_4('\ue3BF'),
    CROP_7_5('\ue3C0'),
    CROP_DIN('\ue3C1'),
    CROP_FREE('\ue3C2'),
    CROP_LANDSCAPE('\ue3C3'),
    CROP_ORIGINAL('\ue3C4'),
    CROP_PORTRAIT('\ue3C5'),
    CROP_ROTATE('\ue437'),
    CROP_SQUARE('\ue3C6'),
    DASHBOARD('\ue871'),
    DATA_USAGE('\ue1AF'),
    DATE_RANGE('\ue916'),
    DEHAZE('\ue3C7'),
    DELETE('\ue872'),
    DESCRIPTION('\ue873'),
    DESKTOP_MAC('\ue30B'),
    DESKTOP_WINDOWS('\ue30C'),
    DETAILS('\ue3C8'),
    DEVELOPER_BOARD('\ue30D'),
    DEVELOPER_MODE('\ue1B0'),
    DEVICE_HUB('\ue335'),
    DEVICES('\ue1B1'),
    DEVICES_OTHER('\ue337'),
    DIALER_SIP('\ue0BB'),
    DIALPAD('\ue0BC'),
    DIRECTIONS('\ue52E'),
    DIRECTIONS_BIKE('\ue52F'),
    DIRECTIONS_BOAT('\ue532'),
    DIRECTIONS_BUS('\ue530'),
    DIRECTIONS_CAR('\ue531'),
    DIRECTIONS_RAILWAY('\ue534'),
    DIRECTIONS_RUN('\ue566'),
    DIRECTIONS_SUBWAY('\ue533'),
    DIRECTIONS_TRANSIT('\ue535'),
    DIRECTIONS_WALK('\ue536'),
    DISC_FULL('\ue610'),
    DNS('\ue875'),
    DO_NOT_DISTURB('\ue612'),
    DO_NOT_DISTURB_ALT('\ue611'),
    DOCK('\ue30E'),
    DOMAIN('\ue7EE'),
    DONE('\ue876'),
    DONE_ALL('\ue877'),
    DONUT_LARGE('\ue917'),
    DONUT_SMALL('\ue918'),
    DRAFTS('\ue151'),
    DRAG_HANDLE('\ue25D'),
    DRIVE_ETA('\ue613'),
    DVR('\ue1B2'),
    EDIT('\ue3C9'),
    EDIT_LOCATION('\ue568'),
    EJECT('\ue8FB'),
    EMAIL('\ue0BE'),
    ENHANCED_ENCRYPT('\ue63F'),
    EQUALIZER('\ue01D'),
    ERROR('\ue000'),
    ERROR_OUTLINE('\ue001'),
    EVENT('\ue878'),
    EVENT_AVAILABLE('\ue614'),
    EVENT_BUSY('\ue615'),
    EVENT_NOTE('\ue616'),
    EVENT_SEAT('\ue903'),
    EXIT_TO_APP('\ue879'),
    EXPAND_LESS('\ue5CE'),
    EXPAND_MORE('\ue5CF'),
    EXPLICIT('\ue01E'),
    EXPLORE('\ue87A'),
    EXPOSURE('\ue3CA'),
    EXPOSURE_NEG_1('\ue3CB'),
    EXPOSURE_NEG_2('\ue3CC'),
    EXPOSURE_PLUS_1('\ue3CD'),
    EXPOSURE_PLUS_2('\ue3CE'),
    EXPOSURE_ZERO('\ue3CF'),
    EXTENSION('\ue87B'),
    FACE('\ue87C'),
    FAST_FORWARD('\ue01F'),
    FAST_REWIND('\ue020'),
    FAVORITE('\ue87D'),
    FAVORITE_BORDER('\ue87E'),
    FEEDBACK('\ue87F'),
    FIBER_DVR('\ue05D'),
    FIBER_MANUAL_RECORD('\ue061'),
    FIBER_NEW('\ue05E'),
    FIBER_PIN('\ue06A'),
    FIBER_SMART_RECORD('\ue062'),
    FILE_DOWNLOAD('\ue2C4'),
    FILE_UPLOAD('\ue2C6'),
    FILTER('\ue3D3'),
    FILTER_1('\ue3D0'),
    FILTER_2('\ue3D1'),
    FILTER_3('\ue3D2'),
    FILTER_4('\ue3D4'),
    FILTER_5('\ue3D5'),
    FILTER_6('\ue3D6'),
    FILTER_7('\ue3D7'),
    FILTER_8('\ue3D8'),
    FILTER_9('\ue3D9'),
    FILTER_9_PLUS('\ue3DA'),
    FILTER_B_AND_W('\ue3DB'),
    FILTER_CENTER_FOCUS('\ue3DC'),
    FILTER_DRAMA('\ue3DD'),
    FILTER_FRAMES('\ue3DE'),
    FILTER_HDR('\ue3DF'),
    FILTER_LIST('\ue152'),
    FILTER_NONE('\ue3E0'),
    FILTER_TILT_SHIFT('\ue3E2'),
    FILTER_VINTAGE('\ue3E3'),
    FIND_IN_PAGE('\ue880'),
    FIND_REPLACE('\ue881'),
    FINGERPRINT('\ue90D'),
    FITNESS_CENTER('\ueB43'),
    FLAG('\ue153'),
    FLARE('\ue3E4'),
    FLASH_AUTO('\ue3E5'),
    FLASH_OFF('\ue3E6'),
    FLASH_ON('\ue3E7'),
    FLIGHT('\ue539'),
    FLIGHT_LAND('\ue904'),
    FLIGHT_TAKEOFF('\ue905'),
    FLIP('\ue3E8'),
    FLIP_TO_BACK('\ue882'),
    FLIP_TO_FRONT('\ue883'),
    FOLDER('\ue2C7'),
    FOLDER_OPEN('\ue2C8'),
    FOLDER_SHARED('\ue2C9'),
    FOLDER_SPECIAL('\ue617'),
    FONT_DOWNLOAD('\ue167'),
    FORMAT_ALIGN_CENTER('\ue234'),
    FORMAT_ALIGN_JUSTIFY('\ue235'),
    FORMAT_ALIGN_LEFT('\ue236'),
    FORMAT_ALIGN_RIGHT('\ue237'),
    FORMAT_BOLD('\ue238'),
    FORMAT_CLEAR('\ue239'),
    FORMAT_COLOR_FILL('\ue23A'),
    FORMAT_COLOR_RESET('\ue23B'),
    FORMAT_COLOR_TEXT('\ue23C'),
    FORMAT_INDENT_DECREASE('\ue23D'),
    FORMAT_INDENT_INCREASE('\ue23E'),
    FORMAT_ITALIC('\ue23F'),
    FORMAT_LINE_SPACING('\ue240'),
    FORMAT_LIST_BULLETED('\ue241'),
    FORMAT_LIST_NUMBERED('\ue242'),
    FORMAT_PAINT('\ue243'),
    FORMAT_QUOTE('\ue244'),
    FORMAT_SHAPES('\ue25E'),
    FORMAT_SIZE('\ue245'),
    FORMAT_STRIKETHROUGH('\ue246'),
    FORMAT_TEXTDIRECTION_L_TO_R('\ue247'),
    FORMAT_TEXTDIRECTION_R_TO_L('\ue248'),
    FORMAT_UNDERLINED('\ue249'),
    FORUM('\ue0BF'),
    FORWARD('\ue154'),
    FORWARD_10('\ue056'),
    FORWARD_30('\ue057'),
    FORWARD_5('\ue058'),
    FREE_BREAKFAST('\ueB44'),
    FULLSCREEN('\ue5D0'),
    FULLSCREEN_EXIT('\ue5D1'),
    FUNCTIONS('\ue24A'),
    GAMEPAD('\ue30F'),
    GAMES('\ue021'),
    GAVEL('\ue90E'),
    GESTURE('\ue155'),
    GET_APP('\ue884'),
    GIF('\ue908'),
    GOLF_COURSE('\ueB45'),
    GPS_FIXED('\ue1B3'),
    GPS_NOT_FIXED('\ue1B4'),
    GPS_OFF('\ue1B5'),
    GRADE('\ue885'),
    GRADIENT('\ue3E9'),
    GRAIN('\ue3EA'),
    GRAPHIC_EQ('\ue1B8'),
    GRID_OFF('\ue3EB'),
    GRID_ON('\ue3EC'),
    GROUP('\ue7EF'),
    GROUP_ADD('\ue7F0'),
    GROUP_WORK('\ue886'),
    HD('\ue052'),
    HDR_OFF('\ue3ED'),
    HDR_ON('\ue3EE'),
    HDR_STRONG('\ue3F1'),
    HDR_WEAK('\ue3F2'),
    HEADSET('\ue310'),
    HEADSET_MIC('\ue311'),
    HEALING('\ue3F3'),
    HEARING('\ue023'),
    HELP('\ue887'),
    HELP_OUTLINE('\ue8FD'),
    HIGH_QUALITY('\ue024'),
    HIGHLIGHT('\ue25F'),
    HIGHLIGHT_OFF('\ue888'),
    HISTORY('\ue889'),
    HOME('\ue88A'),
    HOT_TUB('\ueB46'),
    HOTEL('\ue53A'),
    HOURGLASS_EMPTY('\ue88B'),
    HOURGLASS_FULL('\ue88C'),
    HTTP('\ue902'),
    HTTPS('\ue88D'),
    IMAGE('\ue3F4'),
    IMAGE_ASPECT_RATIO('\ue3F5'),
    IMPORT_CONTACTS('\ue0E0'),
    IMPORT_EXPORT('\ue0C3'),
    IMPORTANT_DEVICES('\ue912'),
    INBOX('\ue156'),
    INDETERMINATE_CHECK_BOX('\ue909'),
    INFO('\ue88E'),
    INFO_OUTLINE('\ue88F'),
    INPUT('\ue890'),
    INSERT_CHART('\ue24B'),
    INSERT_COMMENT('\ue24C'),
    INSERT_DRIVE_FILE('\ue24D'),
    INSERT_EMOTICON('\ue24E'),
    INSERT_INVITATION('\ue24F'),
    INSERT_LINK('\ue250'),
    INSERT_PHOTO('\ue251'),
    INVERT_COLORS('\ue891'),
    INVERT_COLORS_OFF('\ue0C4'),
    ISO('\ue3F6'),
    KEYBOARD('\ue312'),
    KEYBOARD_ARROW_DOWN('\ue313'),
    KEYBOARD_ARROW_LEFT('\ue314'),
    KEYBOARD_ARROW_RIGHT('\ue315'),
    KEYBOARD_ARROW_UP('\ue316'),
    KEYBOARD_BACKSPACE('\ue317'),
    KEYBOARD_CAPSLOCK('\ue318'),
    KEYBOARD_HIDE('\ue31A'),
    KEYBOARD_RETURN('\ue31B'),
    KEYBOARD_TAB('\ue31C'),
    KEYBOARD_VOICE('\ue31D'),
    KITCHEN('\ueB47'),
    LABEL('\ue892'),
    LABEL_OUTLINE('\ue893'),
    LANDSCAPE('\ue3F7'),
    LANGUAGE('\ue894'),
    LAPTOP('\ue31E'),
    LAPTOP_CHROMEBOOK('\ue31F'),
    LAPTOP_MAC('\ue320'),
    LAPTOP_WINDOWS('\ue321'),
    LAUNCH('\ue895'),
    LAYERS('\ue53B'),
    LAYERS_CLEAR('\ue53C'),
    LEAK_ADD('\ue3F8'),
    LEAK_REMOVE('\ue3F9'),
    LENS('\ue3FA'),
    LIBRARY_ADD('\ue02E'),
    LIBRARY_BOOKS('\ue02F'),
    LIBRARY_MUSIC('\ue030'),
    LIGHTBULB_OUTLINE('\ue90F'),
    LINE_STYLE('\ue919'),
    LINE_WEIGHT('\ue91A'),
    LINEAR_SCALE('\ue260'),
    LINK('\ue157'),
    LINKED_CAMERA('\ue438'),
    LIST('\ue896'),
    LIVE_HELP('\ue0C6'),
    LIVE_TV('\ue639'),
    LOCAL_ACTIVITY('\ue53F'),
    LOCAL_AIRPORT('\ue53D'),
    LOCAL_ATM('\ue53E'),
    LOCAL_BAR('\ue540'),
    LOCAL_CAFE('\ue541'),
    LOCAL_CAR_WASH('\ue542'),
    LOCAL_CONVENIENCE_STORE('\ue543'),
    LOCAL_DINING('\ue556'),
    LOCAL_DRINK('\ue544'),
    LOCAL_FLORIST('\ue545'),
    LOCAL_GAS_STATION('\ue546'),
    LOCAL_GROCERY_STORE('\ue547'),
    LOCAL_HOSPITAL('\ue548'),
    LOCAL_HOTEL('\ue549'),
    LOCAL_LAUNDRY_SERVICE('\ue54A'),
    LOCAL_LIBRARY('\ue54B'),
    LOCAL_MALL('\ue54C'),
    LOCAL_MOVIES('\ue54D'),
    LOCAL_OFFER('\ue54E'),
    LOCAL_PARKING('\ue54F'),
    LOCAL_PHARMACY('\ue550'),
    LOCAL_PHONE('\ue551'),
    LOCAL_PIZZA('\ue552'),
    LOCAL_PLAY('\ue553'),
    LOCAL_POST_OFFICE('\ue554'),
    LOCAL_PRINTSHOP('\ue555'),
    LOCAL_SEE('\ue557'),
    LOCAL_SHIPPING('\ue558'),
    LOCAL_TAXI('\ue559'),
    LOCATION_CITY('\ue7F1'),
    LOCATION_DISABLED('\ue1B6'),
    LOCATION_OFF('\ue0C7'),
    LOCATION_ON('\ue0C8'),
    LOCATION_SEARCHING('\ue1B7'),
    LOCK('\ue897'),
    LOCK_OPEN('\ue898'),
    LOCK_OUTLINE('\ue899'),
    LOOKS('\ue3FC'),
    LOOKS_3('\ue3FB'),
    LOOKS_4('\ue3FD'),
    LOOKS_5('\ue3FE'),
    LOOKS_6('\ue3FF'),
    LOOKS_ONE('\ue400'),
    LOOKS_TWO('\ue401'),
    LOOP('\ue028'),
    LOUPE('\ue402'),
    LOYALTY('\ue89A'),
    MAIL('\ue158'),
    MAIL_OUTLINE('\ue0E1'),
    MAP('\ue55B'),
    MARKUNREAD('\ue159'),
    MARKUNREAD_MAILBOX('\ue89B'),
    MEMORY('\ue322'),
    MENU('\ue5D2'),
    MERGE_TYPE('\ue252'),
    MESSAGE('\ue0C9'),
    MIC('\ue029'),
    MIC_NONE('\ue02A'),
    MIC_OFF('\ue02B'),
    MMS('\ue618'),
    MODE_COMMENT('\ue253'),
    MODE_EDIT('\ue254'),
    MONEY_OFF('\ue25C'),
    MONOCHROME_PHOTOS('\ue403'),
    MOOD('\ue7F2'),
    MOOD_BAD('\ue7F3'),
    MORE('\ue619'),
    MORE_HORIZ('\ue5D3'),
    MORE_VERT('\ue5D4'),
    MOTORCYCLE('\ue91B'),
    MOUSE('\ue323'),
    MOVE_TO_INBOX('\ue168'),
    MOVIE('\ue02C'),
    MOVIE_CREATION('\ue404'),
    MOVIE_FILTER('\ue43A'),
    MUSIC_NOTE('\ue405'),
    MUSIC_VIDEO('\ue063'),
    MY_LOCATION('\ue55C'),
    NATURE('\ue406'),
    NATURE_PEOPLE('\ue407'),
    NAVIGATE_BEFORE('\ue408'),
    NAVIGATE_NEXT('\ue409'),
    NAVIGATION('\ue55D'),
    NEAR_ME('\ue569'),
    NETWORK_CELL('\ue1B9'),
    NETWORK_CHECK('\ue640'),
    NETWORK_LOCKED('\ue61A'),
    NETWORK_WIFI('\ue1BA'),
    NEW_RELEASES('\ue031'),
    NEXT_WEEK('\ue16A'),
    NFC('\ue1BB'),
    NO_ENCRYPTION('\ue641'),
    NO_SIM('\ue0CC'),
    NOT_INTERESTED('\ue033'),
    NOTE_ADD('\ue89C'),
    NOTIFICATIONS('\ue7F4'),
    NOTIFICATIONS_ACTIVE('\ue7F7'),
    NOTIFICATIONS_NONE('\ue7F5'),
    NOTIFICATIONS_OFF('\ue7F6'),
    NOTIFICATIONS_PAUSED('\ue7F8'),
    OFFLINE_PIN('\ue90A'),
    ONDEMAND_VIDEO('\ue63A'),
    OPACITY('\ue91C'),
    OPEN_IN_BROWSER('\ue89D'),
    OPEN_IN_NEW('\ue89E'),
    OPEN_WITH('\ue89F'),
    PAGES('\ue7F9'),
    PAGEVIEW('\ue8A0'),
    PALETTE('\ue40A'),
    PAN_TOOL('\ue925'),
    PANORAMA('\ue40B'),
    PANORAMA_FISH_EYE('\ue40C'),
    PANORAMA_HORIZONTAL('\ue40D'),
    PANORAMA_VERTICAL('\ue40E'),
    PANORAMA_WIDE_ANGLE('\ue40F'),
    PARTY_MODE('\ue7FA'),
    PAUSE('\ue034'),
    PAUSE_CIRCLE_FILLED('\ue035'),
    PAUSE_CIRCLE_OUTLINE('\ue036'),
    PAYMENT('\ue8A1'),
    PEOPLE('\ue7FB'),
    PEOPLE_OUTLINE('\ue7FC'),
    PERM_CAMERA_MIC('\ue8A2'),
    PERM_CONTACT_CALENDAR('\ue8A3'),
    PERM_DATA_SETTING('\ue8A4'),
    PERM_DEVICE_INFORMATION('\ue8A5'),
    PERM_IDENTITY('\ue8A6'),
    PERM_MEDIA('\ue8A7'),
    PERM_PHONE_MSG('\ue8A8'),
    PERM_SCAN_WIFI('\ue8A9'),
    PERSON('\ue7FD'),
    PERSON_ADD('\ue7FE'),
    PERSON_OUTLINE('\ue7FF'),
    PERSON_PIN('\ue55A'),
    PERSON_PIN_CIRCLE('\ue56A'),
    PERSONAL_VIDEO('\ue63B'),
    PETS('\ue91D'),
    PHONE('\ue0CD'),
    PHONE_ANDROID('\ue324'),
    PHONE_BLUETOOTH_SPEAKER('\ue61B'),
    PHONE_FORWARDED('\ue61C'),
    PHONE_IN_TALK('\ue61D'),
    PHONE_IPHONE('\ue325'),
    PHONE_LOCKED('\ue61E'),
    PHONE_MISSED('\ue61F'),
    PHONE_PAUSED('\ue620'),
    PHONELINK('\ue326'),
    PHONELINK_ERASE('\ue0DB'),
    PHONELINK_LOCK('\ue0DC'),
    PHONELINK_OFF('\ue327'),
    PHONELINK_RING('\ue0DD'),
    PHONELINK_SETUP('\ue0DE'),
    PHOTO('\ue410'),
    PHOTO_ALBUM('\ue411'),
    PHOTO_CAMERA('\ue412'),
    PHOTO_FILTER('\ue43B'),
    PHOTO_LIBRARY('\ue413'),
    PHOTO_SIZE_SELECT_ACTUAL('\ue432'),
    PHOTO_SIZE_SELECT_LARGE('\ue433'),
    PHOTO_SIZE_SELECT_SMALL('\ue434'),
    PICTURE_AS_PDF('\ue415'),
    PICTURE_IN_PICTURE('\ue8AA'),
    PICTURE_IN_PICTURE_ALT('\ue911'),
    PIN_DROP('\ue55E'),
    PLACE('\ue55F'),
    PLAY_ARROW('\ue037'),
    PLAY_CIRCLE_FILLED('\ue038'),
    PLAY_CIRCLE_OUTLINE('\ue039'),
    PLAY_FOR_WORK('\ue906'),
    PLAYLIST_ADD('\ue03B'),
    PLAYLIST_ADD_CHECK('\ue065'),
    PLAYLIST_PLAY('\ue05F'),
    PLUS_ONE('\ue800'),
    POLL('\ue801'),
    POLYMER('\ue8AB'),
    POOL('\ueB48'),
    PORTABLE_WIFI_OFF('\ue0CE'),
    PORTRAIT('\ue416'),
    POWER('\ue63C'),
    POWER_INPUT('\ue336'),
    POWER_SETTINGS_NEW('\ue8AC'),
    PREGNANT_WOMAN('\ue91E'),
    PRESENT_TO_ALL('\ue0DF'),
    PRINT('\ue8AD'),
    PUBLIC('\ue80B'),
    PUBLISH('\ue255'),
    QUERY_BUILDER('\ue8AE'),
    QUESTION_ANSWER('\ue8AF'),
    QUEUE('\ue03C'),
    QUEUE_MUSIC('\ue03D'),
    QUEUE_PLAY_NEXT('\ue066'),
    RADIO('\ue03E'),
    RADIO_BUTTON_CHECKED('\ue837'),
    RADIO_BUTTON_UNCHECKED('\ue836'),
    RATE_REVIEW('\ue560'),
    RECEIPT('\ue8B0'),
    RECENT_ACTORS('\ue03F'),
    RECORD_VOICE_OVER('\ue91F'),
    REDEEM('\ue8B1'),
    REDO('\ue15A'),
    REFRESH('\ue5D5'),
    REMOVE('\ue15B'),
    REMOVE_CIRCLE('\ue15C'),
    REMOVE_CIRCLE_OUTLINE('\ue15D'),
    REMOVE_FROM_QUEUE('\ue067'),
    REMOVE_RED_EYE('\ue417'),
    REORDER('\ue8FE'),
    REPEAT('\ue040'),
    REPEAT_ONE('\ue041'),
    REPLAY('\ue042'),
    REPLAY_10('\ue059'),
    REPLAY_30('\ue05A'),
    REPLAY_5('\ue05B'),
    REPLY('\ue15E'),
    REPLY_ALL('\ue15F'),
    REPORT('\ue160'),
    REPORT_PROBLEM('\ue8B2'),
    RESTAURANT_MENU('\ue561'),
    RESTORE('\ue8B3'),
    RING_VOLUME('\ue0D1'),
    ROOM('\ue8B4'),
    ROOM_SERVICE('\ueB49'),
    ROTATE_90_DEGREES_CCW('\ue418'),
    ROTATE_LEFT('\ue419'),
    ROTATE_RIGHT('\ue41A'),
    ROTATION_3D('\ue84D'),
    ROUNDED_CORNER('\ue920'),
    ROUTER('\ue328'),
    ROWING('\ue921'),
    RV_HOOKUP('\ue642'),
    SATELLITE('\ue562'),
    SAVE('\ue161'),
    SCANNER('\ue329'),
    SCHEDULE('\ue8B5'),
    SCHOOL('\ue80C'),
    SCREEN_LOCK_LANDSCAPE('\ue1BE'),
    SCREEN_LOCK_PORTRAIT('\ue1BF'),
    SCREEN_LOCK_ROTATION('\ue1C0'),
    SCREEN_ROTATION('\ue1C1'),
    SCREEN_SHARE('\ue0E2'),
    SD_CARD('\ue623'),
    SD_STORAGE('\ue1C2'),
    SEARCH('\ue8B6'),
    SECURITY('\ue32A'),
    SELECT_ALL('\ue162'),
    SEND('\ue163'),
    SETTINGS('\ue8B8'),
    SETTINGS_APPLICATIONS('\ue8B9'),
    SETTINGS_BACKUP_RESTORE('\ue8BA'),
    SETTINGS_BLUETOOTH('\ue8BB'),
    SETTINGS_BRIGHTNESS('\ue8BD'),
    SETTINGS_CELL('\ue8BC'),
    SETTINGS_ETHERNET('\ue8BE'),
    SETTINGS_INPUT_ANTENNA('\ue8BF'),
    SETTINGS_INPUT_COMPONENT('\ue8C0'),
    SETTINGS_INPUT_COMPOSITE('\ue8C1'),
    SETTINGS_INPUT_HDMI('\ue8C2'),
    SETTINGS_INPUT_SVIDEO('\ue8C3'),
    SETTINGS_OVERSCAN('\ue8C4'),
    SETTINGS_PHONE('\ue8C5'),
    SETTINGS_POWER('\ue8C6'),
    SETTINGS_REMOTE('\ue8C7'),
    SETTINGS_SYSTEM_DAYDREAM('\ue1C3'),
    SETTINGS_VOICE('\ue8C8'),
    SHARE('\ue80D'),
    SHOP('\ue8C9'),
    SHOP_TWO('\ue8CA'),
    SHOPPING_BASKET('\ue8CB'),
    SHOPPING_CART('\ue8CC'),
    SHORT_TEXT('\ue261'),
    SHUFFLE('\ue043'),
    SIGNAL_CELLULAR_4_BAR('\ue1C8'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR('\ue1CD'),
    SIGNAL_CELLULAR_NO_SIM('\ue1CE'),
    SIGNAL_CELLULAR_NULL('\ue1CF'),
    SIGNAL_CELLULAR_OFF('\ue1D0'),
    SIGNAL_WIFI_4_BAR('\ue1D8'),
    SIGNAL_WIFI_4_BAR_LOCK('\ue1D9'),
    SIGNAL_WIFI_OFF('\ue1DA'),
    SIM_CARD('\ue32B'),
    SIM_CARD_ALERT('\ue624'),
    SKIP_NEXT('\ue044'),
    SKIP_PREVIOUS('\ue045'),
    SLIDESHOW('\ue41B'),
    SLOW_MOTION_VIDEO('\ue068'),
    SMARTPHONE('\ue32C'),
    SMOKE_FREE('\ueB4A'),
    SMOKING_ROOMS('\ueB4B'),
    SMS('\ue625'),
    SMS_FAILED('\ue626'),
    SNOOZE('\ue046'),
    SORT('\ue164'),
    SORT_BY_ALPHA('\ue053'),
    SPA('\ueB4C'),
    SPACE_BAR('\ue256'),
    SPEAKER('\ue32D'),
    SPEAKER_GROUP('\ue32E'),
    SPEAKER_NOTES('\ue8CD'),
    SPEAKER_PHONE('\ue0D2'),
    SPELLCHECK('\ue8CE'),
    STAR('\ue838'),
    STAR_BORDER('\ue83A'),
    STAR_HALF('\ue839'),
    STARS('\ue8D0'),
    STAY_CURRENT_LANDSCAPE('\ue0D3'),
    STAY_CURRENT_PORTRAIT('\ue0D4'),
    STAY_PRIMARY_LANDSCAPE('\ue0D5'),
    STAY_PRIMARY_PORTRAIT('\ue0D6'),
    STOP('\ue047'),
    STOP_SCREEN_SHARE('\ue0E3'),
    STORAGE('\ue1DB'),
    STORE('\ue8D1'),
    STORE_MALL_DIRECTORY('\ue563'),
    STRAIGHTEN('\ue41C'),
    STRIKETHROUGH_S('\ue257'),
    STYLE('\ue41D'),
    SUBDIRECTORY_ARROW_LEFT('\ue5D9'),
    SUBDIRECTORY_ARROW_RIGHT('\ue5DA'),
    SUBJECT('\ue8D2'),
    SUBSCRIPTIONS('\ue064'),
    SUBTITLES('\ue048'),
    SUPERVISOR_ACCOUNT('\ue8D3'),
    SURROUND_SOUND('\ue049'),
    SWAP_CALLS('\ue0D7'),
    SWAP_HORIZ('\ue8D4'),
    SWAP_VERT('\ue8D5'),
    SWAP_VERTICAL_CIRCLE('\ue8D6'),
    SWITCH_CAMERA('\ue41E'),
    SWITCH_VIDEO('\ue41F'),
    SYNC('\ue627'),
    SYNC_DISABLED('\ue628'),
    SYNC_PROBLEM('\ue629'),
    SYSTEM_UPDATE('\ue62A'),
    SYSTEM_UPDATE_ALT('\ue8D7'),
    TAB('\ue8D8'),
    TAB_UNSELECTED('\ue8D9'),
    TABLET('\ue32F'),
    TABLET_ANDROID('\ue330'),
    TABLET_MAC('\ue331'),
    TAG_FACES('\ue420'),
    TAP_AND_PLAY('\ue62B'),
    TERRAIN('\ue564'),
    TEXT_FIELDS('\ue262'),
    TEXT_FORMAT('\ue165'),
    TEXTSMS('\ue0D8'),
    TEXTURE('\ue421'),
    THEATERS('\ue8DA'),
    THUMB_DOWN('\ue8DB'),
    THUMB_UP('\ue8DC'),
    THUMBS_UP_DOWN('\ue8DD'),
    TIME_TO_LEAVE('\ue62C'),
    TIMELAPSE('\ue422'),
    TIMELINE('\ue922'),
    TIMER('\ue425'),
    TIMER_10('\ue423'),
    TIMER_3('\ue424'),
    TIMER_OFF('\ue426'),
    TOC('\ue8DE'),
    TODAY('\ue8DF'),
    TOLL('\ue8E0'),
    TONALITY('\ue427'),
    TOUCH_APP('\ue913'),
    TOYS('\ue332'),
    TRACK_CHANGES('\ue8E1'),
    TRAFFIC('\ue565'),
    TRANSFORM('\ue428'),
    TRANSLATE('\ue8E2'),
    TRENDING_DOWN('\ue8E3'),
    TRENDING_FLAT('\ue8E4'),
    TRENDING_UP('\ue8E5'),
    TUNE('\ue429'),
    TURNED_IN('\ue8E6'),
    TURNED_IN_NOT('\ue8E7'),
    TV('\ue333'),
    UNARCHIVE('\ue169'),
    UNDO('\ue166'),
    UNFOLD_LESS('\ue5D6'),
    UNFOLD_MORE('\ue5D7'),
    UPDATE('\ue923'),
    USB('\ue1E0'),
    VERIFIED_USER('\ue8E8'),
    VERTICAL_ALIGN_BOTTOM('\ue258'),
    VERTICAL_ALIGN_CENTER('\ue259'),
    VERTICAL_ALIGN_TOP('\ue25A'),
    VIBRATION('\ue62D'),
    VIDEO_LIBRARY('\ue04A'),
    VIDEOCAM('\ue04B'),
    VIDEOCAM_OFF('\ue04C'),
    VIDEOGAME_ASSET('\ue338'),
    VIEW_AGENDA('\ue8E9'),
    VIEW_ARRAY('\ue8EA'),
    VIEW_CAROUSEL('\ue8EB'),
    VIEW_COLUMN('\ue8EC'),
    VIEW_COMFY('\ue42A'),
    VIEW_COMPACT('\ue42B'),
    VIEW_DAY('\ue8ED'),
    VIEW_HEADLINE('\ue8EE'),
    VIEW_LIST('\ue8EF'),
    VIEW_MODULE('\ue8F0'),
    VIEW_QUILT('\ue8F1'),
    VIEW_STREAM('\ue8F2'),
    VIEW_WEEK('\ue8F3'),
    VIGNETTE('\ue435'),
    VISIBILITY('\ue8F4'),
    VISIBILITY_OFF('\ue8F5'),
    VOICE_CHAT('\ue62E'),
    VOICEMAIL('\ue0D9'),
    VOLUME_DOWN('\ue04D'),
    VOLUME_MUTE('\ue04E'),
    VOLUME_OFF('\ue04F'),
    VOLUME_UP('\ue050'),
    VPN_KEY('\ue0DA'),
    VPN_LOCK('\ue62F'),
    WALLPAPER('\ue1BC'),
    WARNING('\ue002'),
    WATCH('\ue334'),
    WATCH_LATER('\ue924'),
    WB_AUTO('\ue42C'),
    WB_CLOUDY('\ue42D'),
    WB_INCANDESCENT('\ue42E'),
    WB_IRIDESCENT('\ue436'),
    WB_SUNNY('\ue430'),
    WC('\ue63D'),
    WEB('\ue051'),
    WEB_ASSET('\ue069'),
    WEEKEND('\ue16B'),
    WHATSHOT('\ue80E'),
    WIDGETS('\ue1BD'),
    WIFI('\ue63E'),
    WIFI_LOCK('\ue1E1'),
    WIFI_TETHERING('\ue1E2'),
    WORK('\ue8F9'),
    WRAP_TEXT('\ue25B'),
    YOUTUBE_SEARCHED_FOR('\ue8FA'),
    ZOOM_IN('\ue8FF'),
    ZOOM_OUT('\ue900'),
    ZOOM_OUT_MAP('\ue56B');

    private final char character;

    private MaterialIcon(char character) {
        this.character = character;
    }

    @Override
    public char getChar() {
        return character;
    }

    @Override
    public String unicodeToString() {
        return String.format("\\u%04x", (int) character);
    }

    @Override
    public String characterToString() {
        return Character.toString(character);
    }

    @Override
    public String getFontFamily() {
        return "\'Material Icons\'";
    }
}
