(**************************************************************************)
(*                                                                        *)
(*  This file is part of WP plug-in of Frama-C.                           *)
(*                                                                        *)
(*  Copyright (C) 2007-2019                                               *)
(*    CEA (Commissariat a l'energie atomique et aux energies              *)
(*         alternatives)                                                  *)
(*                                                                        *)
(*  you can redistribute it and/or modify it under the terms of the GNU   *)
(*  Lesser General Public License as published by the Free Software       *)
(*  Foundation, version 2.1.                                              *)
(*                                                                        *)
(*  It is distributed in the hope that it will be useful,                 *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU Lesser General Public License for more details.                   *)
(*                                                                        *)
(*  See the GNU Lesser General Public License version 2.1                 *)
(*  for more details (enclosed in the file licenses/LGPLv2.1).            *)
(*                                                                        *)
(**************************************************************************)

(* -------------------------------------------------------------------------- *)
(* --- Proof Search Engine                                                --- *)
(* -------------------------------------------------------------------------- *)

open ProofEngine
open Conditions

val first : tree -> ?anchor:node -> Strategy.t array -> fork option

val index : tree -> anchor:node -> index:int -> fork option

val search : tree -> ?anchor:node -> ?sequent:sequent ->
  Strategy.heuristic list -> fork option

val backtrack : tree -> ?anchor:node -> ?loop:bool -> ?width:int ->
  unit -> fork option

(* -------------------------------------------------------------------------- *)
