//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: UnknownExpressionDeclaration.cpp,v 1.1 2007/02/10 17:22:45 delpinux Exp $

#include <UnknownExpressionDeclaration.hpp>

#include <FunctionExpressionConstant.hpp>
#include <VariableRepository.hpp>

void UnknownExpressionDeclaration::
__preExecute()
{
  ReferenceCounting<RealExpression> value
    = new RealExpressionValue(0);
  ReferenceCounting<FunctionExpression> function
    = new FunctionExpressionConstant(value);

  function->execute();

  ReferenceCounting<Variable> variable
    = new FunctionVariable(__name, function);

  VariableRepository::instance().add(variable);
}

UnknownExpressionDeclaration::
UnknownExpressionDeclaration(const std::string& name,
			     const DiscretizationType::Type& type)
  : UnknownExpression(UnknownExpression::declaration, name, type)
{
  ;
}

UnknownExpressionDeclaration::
~UnknownExpressionDeclaration()
{
  ;
}
