#include <pygoom.h>


PyMODINIT_FUNC initpygoom(void) {
   (void) Py_InitModule("pygoom", pygoomMethods);
}


static PyObject* pygoom_init( PyObject *self, PyObject *args ) 
{
  if ( pygoom_isinit == 0 ) 
    {
      if ( pygoom_set_resolution( self, args ) == NULL )
	return NULL;
      goom_init( pygoom_width, pygoom_height, pygoom_cinema );
      pygoom_isinit = 1;
      Py_INCREF( Py_True );
      return Py_True;
    }
  
  Py_INCREF( Py_False );
  return Py_False;
}


static PyObject* pygoom_set_asm_use( PyObject *self, PyObject *args )
{
  int useit=0;

  if ( ! PyArg_ParseTuple( args, "i", &useit ) )
    return NULL;
  
  goom_setAsmUse( useit );

  Py_INCREF( Py_None );
  return Py_None;
}



static PyObject* pygoom_get_asm_use( PyObject *self, PyObject *args )
{
  if ( ! PyArg_ParseTuple( args, "" ) )
    return NULL;    

  if ( goom_getAsmUse() )
    {
      Py_INCREF( Py_True );
      return Py_True;
    }
  else
    {
      Py_INCREF( Py_False );
      return Py_False;
    }
}


static PyObject* pygoom_close( PyObject *self, PyObject *args )
{
  if ( ! PyArg_ParseTuple( args, "" ) )
    return NULL;

  pygoom_isinit = 0;
  goom_close();

  Py_INCREF( Py_None );
  return Py_None;  
}



static PyObject* pygoom_set_resolution( PyObject *self, PyObject *args ) 
{
  if ( ! PyArg_ParseTuple( args, "ii|i", &pygoom_width, 
			   &pygoom_height, &pygoom_cinema ) )
    return NULL;
  
  if ( pygoom_isinit == 1 )
    goom_set_resolution( pygoom_width, pygoom_height, pygoom_cinema );

  Py_INCREF( Py_None );
  return Py_None;
}



static PyObject* pygoom_get_resolution( PyObject *self, PyObject *args )
{
  if ( ! PyArg_ParseTuple( args, "" ) )
    return NULL;    

  return Py_BuildValue( "(iii)", pygoom_width, pygoom_height, pygoom_cinema );
}


static PyObject* pygoom_update( PyObject *self, PyObject *args ) 
{
  int len=0;
  uint32_t *render_data = NULL;
  static int16_t ldata[ 2 ][ 512 ];
  const char *data=NULL;

  if ( pygoom_isinit == 0 )
    {
      PyErr_SetString( PyExc_ValueError, "You must init goom first!" );
      return NULL;
    }

  if ( ! PyArg_ParseTuple( args, "s#", &data, &len ) )
    return NULL;

  if ( len != 2048 )
    {
      char msg[ 1024 ];
      snprintf( msg, 1023, 
	       "Expected 2048 chars (2 channels with 512 samples " \
	       "of 2 bytes), %d received.", 
	       len );
      msg[ 1024 ] = 0;
      PyErr_SetString( PyExc_ValueError, msg );
      return NULL;
    }

  if( data )
    {
      memcpy( ldata, ((void *) data), 2048 );
      render_data = goom_update( ldata, 0, -1, NULL, NULL );
      
      if( ! render_data ) 
	{
	  PyErr_SetString( PyExc_ValueError, "Goom not producing!" );
	  return NULL;
	}
    }
  return Py_BuildValue( "s#", render_data, 
			pygoom_width * pygoom_height * 4 );
}
