--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.ARB.InternalformatQuery2
-- Copyright   :  (c) Sven Panne 2015
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- The <https://www.opengl.org/registry/specs/ARB/internalformat_query2.txt ARB_internalformat_query2> extension.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.ARB.InternalformatQuery2 (
  -- * Enums
  gl_AUTO_GENERATE_MIPMAP,
  gl_CAVEAT_SUPPORT,
  gl_CLEAR_BUFFER,
  gl_COLOR_COMPONENTS,
  gl_COLOR_ENCODING,
  gl_COLOR_RENDERABLE,
  gl_COMPUTE_TEXTURE,
  gl_DEPTH_COMPONENTS,
  gl_DEPTH_RENDERABLE,
  gl_FILTER,
  gl_FRAGMENT_TEXTURE,
  gl_FRAMEBUFFER_BLEND,
  gl_FRAMEBUFFER_RENDERABLE,
  gl_FRAMEBUFFER_RENDERABLE_LAYERED,
  gl_FULL_SUPPORT,
  gl_GEOMETRY_TEXTURE,
  gl_GET_TEXTURE_IMAGE_FORMAT,
  gl_GET_TEXTURE_IMAGE_TYPE,
  gl_IMAGE_CLASS_10_10_10_2,
  gl_IMAGE_CLASS_11_11_10,
  gl_IMAGE_CLASS_1_X_16,
  gl_IMAGE_CLASS_1_X_32,
  gl_IMAGE_CLASS_1_X_8,
  gl_IMAGE_CLASS_2_X_16,
  gl_IMAGE_CLASS_2_X_32,
  gl_IMAGE_CLASS_2_X_8,
  gl_IMAGE_CLASS_4_X_16,
  gl_IMAGE_CLASS_4_X_32,
  gl_IMAGE_CLASS_4_X_8,
  gl_IMAGE_COMPATIBILITY_CLASS,
  gl_IMAGE_FORMAT_COMPATIBILITY_TYPE,
  gl_IMAGE_PIXEL_FORMAT,
  gl_IMAGE_PIXEL_TYPE,
  gl_IMAGE_TEXEL_SIZE,
  gl_INTERNALFORMAT_ALPHA_SIZE,
  gl_INTERNALFORMAT_ALPHA_TYPE,
  gl_INTERNALFORMAT_BLUE_SIZE,
  gl_INTERNALFORMAT_BLUE_TYPE,
  gl_INTERNALFORMAT_DEPTH_SIZE,
  gl_INTERNALFORMAT_DEPTH_TYPE,
  gl_INTERNALFORMAT_GREEN_SIZE,
  gl_INTERNALFORMAT_GREEN_TYPE,
  gl_INTERNALFORMAT_PREFERRED,
  gl_INTERNALFORMAT_RED_SIZE,
  gl_INTERNALFORMAT_RED_TYPE,
  gl_INTERNALFORMAT_SHARED_SIZE,
  gl_INTERNALFORMAT_STENCIL_SIZE,
  gl_INTERNALFORMAT_STENCIL_TYPE,
  gl_INTERNALFORMAT_SUPPORTED,
  gl_MANUAL_GENERATE_MIPMAP,
  gl_MAX_COMBINED_DIMENSIONS,
  gl_MAX_DEPTH,
  gl_MAX_HEIGHT,
  gl_MAX_LAYERS,
  gl_MAX_WIDTH,
  gl_MIPMAP,
  gl_NUM_SAMPLE_COUNTS,
  gl_READ_PIXELS,
  gl_READ_PIXELS_FORMAT,
  gl_READ_PIXELS_TYPE,
  gl_RENDERBUFFER,
  gl_SAMPLES,
  gl_SHADER_IMAGE_ATOMIC,
  gl_SHADER_IMAGE_LOAD,
  gl_SHADER_IMAGE_STORE,
  gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST,
  gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE,
  gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST,
  gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE,
  gl_SRGB_DECODE_ARB,
  gl_SRGB_READ,
  gl_SRGB_WRITE,
  gl_STENCIL_COMPONENTS,
  gl_STENCIL_RENDERABLE,
  gl_TESS_CONTROL_TEXTURE,
  gl_TESS_EVALUATION_TEXTURE,
  gl_TEXTURE_1D,
  gl_TEXTURE_1D_ARRAY,
  gl_TEXTURE_2D,
  gl_TEXTURE_2D_ARRAY,
  gl_TEXTURE_2D_MULTISAMPLE,
  gl_TEXTURE_2D_MULTISAMPLE_ARRAY,
  gl_TEXTURE_3D,
  gl_TEXTURE_BUFFER,
  gl_TEXTURE_COMPRESSED,
  gl_TEXTURE_COMPRESSED_BLOCK_HEIGHT,
  gl_TEXTURE_COMPRESSED_BLOCK_SIZE,
  gl_TEXTURE_COMPRESSED_BLOCK_WIDTH,
  gl_TEXTURE_CUBE_MAP,
  gl_TEXTURE_CUBE_MAP_ARRAY,
  gl_TEXTURE_GATHER,
  gl_TEXTURE_GATHER_SHADOW,
  gl_TEXTURE_IMAGE_FORMAT,
  gl_TEXTURE_IMAGE_TYPE,
  gl_TEXTURE_RECTANGLE,
  gl_TEXTURE_SHADOW,
  gl_TEXTURE_VIEW,
  gl_VERTEX_TEXTURE,
  gl_VIEW_CLASS_128_BITS,
  gl_VIEW_CLASS_16_BITS,
  gl_VIEW_CLASS_24_BITS,
  gl_VIEW_CLASS_32_BITS,
  gl_VIEW_CLASS_48_BITS,
  gl_VIEW_CLASS_64_BITS,
  gl_VIEW_CLASS_8_BITS,
  gl_VIEW_CLASS_96_BITS,
  gl_VIEW_CLASS_BPTC_FLOAT,
  gl_VIEW_CLASS_BPTC_UNORM,
  gl_VIEW_CLASS_RGTC1_RED,
  gl_VIEW_CLASS_RGTC2_RG,
  gl_VIEW_CLASS_S3TC_DXT1_RGB,
  gl_VIEW_CLASS_S3TC_DXT1_RGBA,
  gl_VIEW_CLASS_S3TC_DXT3_RGBA,
  gl_VIEW_CLASS_S3TC_DXT5_RGBA,
  gl_VIEW_COMPATIBILITY_CLASS,
  -- * Functions
  glGetInternalformati64v
) where

import Graphics.Rendering.OpenGL.Raw.Tokens
import Graphics.Rendering.OpenGL.Raw.Functions
