/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.TableBase;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;

public class PersistentStoreCollectionDatabase
implements PersistentStoreCollection {
    private long persistentStoreIdSequence;
    private final LongKeyHashMap rowStoreMap = new LongKeyHashMap();

    @Override
    public void setStore(Object object, PersistentStore persistentStore) {
        long l = ((TableBase)object).getPersistenceId();
        if (persistentStore == null) {
            this.rowStoreMap.remove(l);
        } else {
            this.rowStoreMap.put(l, persistentStore);
        }
    }

    @Override
    public PersistentStore getStore(Object object) {
        long l = ((TableBase)object).getPersistenceId();
        PersistentStore persistentStore = (PersistentStore)this.rowStoreMap.get(l);
        return persistentStore;
    }

    public void releaseStore(TableBase tableBase) {
        PersistentStore persistentStore = (PersistentStore)this.rowStoreMap.get(tableBase.getPersistenceId());
        if (persistentStore != null) {
            persistentStore.release();
            this.rowStoreMap.remove(tableBase.getPersistenceId());
        }
    }

    public long getNextId() {
        return this.persistentStoreIdSequence++;
    }

    @Override
    public void release() {
        if (this.rowStoreMap.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMap.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMap.clear();
    }
}

