/* Copyright (c) 2001-2017, The HSQL Development Group
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the HSQL Development Group nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL HSQL DEVELOPMENT GROUP, HSQLDB.ORG,
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


package org.hsqldb;

import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedIntHashSet;

/**
 * Defines and enumerates reserved and non-reserved SQL keywords.<p>
 *
 * @author Fred Toussi (fredt@users dot sourceforge.net)
 * @version 2.3.5
 * @since 1.7.2
 */
public class Tokens {

    // SQL 200n reserved words full set
    static final String        T_ABS              = "ABS";
    public static final String T_ALL              = "ALL";
    static final String        T_ALLOCATE         = "ALLOCATE";
    public static final String T_ALTER            = "ALTER";
    static final String        T_AND              = "AND";
    public static final String T_ANY              = "ANY";
    static final String        T_ARE              = "ARE";
    public static final String T_ARRAY            = "ARRAY";
    public static final String T_ARRAY_AGG        = "ARRAY_AGG";
    static final String T_ARRAY_MAX_CARDINALITY   = "ARRAY_MAX_CARDINALITY";
    public static final String T_AS               = "AS";
    static final String        T_ASENSITIVE       = "ASENSITIVE";
    static final String        T_ASYMMETRIC       = "ASYMMETRIC";
    static final String        T_AT               = "AT";
    static final String        T_ATOMIC           = "ATOMIC";
    public static final String T_AUTHORIZATION    = "AUTHORIZATION";
    public static final String T_AVG              = "AVG";
    static final String        T_BEGIN            = "BEGIN";
    static final String        T_BEGIN_FRAME      = "BEGIN_FRAME";
    static final String        T_BEGIN_PARTITION  = "BEGIN_PARTITION";
    static final String        T_BETWEEN          = "BETWEEN";
    public static final String T_BIGINT           = "BIGINT";
    public static final String T_BINARY           = "BINARY";
    static final String        T_BIT_LENGTH       = "BIT_LENGTH";
    public static final String T_BLOB             = "BLOB";
    public static final String T_BOOLEAN          = "BOOLEAN";
    static final String        T_BOTH             = "BOTH";
    static final String        T_BY               = "BY";
    public static final String T_CALL             = "CALL";
    static final String        T_CALLED           = "CALLED";
    static final String        T_CARDINALITY      = "CARDINALITY";
    public static final String T_CASCADED         = "CASCADED";
    static final String        T_CASE             = "CASE";
    static final String        T_CAST             = "CAST";
    static final String        T_CEIL             = "CEIL";
    static final String        T_CEILING          = "CEILING";
    public static final String T_CHAR             = "CHAR";
    static final String        T_CHAR_LENGTH      = "CHAR_LENGTH";
    public static final String T_CHARACTER        = "CHARACTER";
    static final String        T_CHARACTER_LENGTH = "CHARACTER_LENGTH";
    public static final String T_CHECK            = "CHECK";
    public static final String T_CLOB             = "CLOB";
    static final String        T_CLOSE            = "CLOSE";
    static final String        T_COALESCE         = "COALESCE";
    public static final String T_COLLATE          = "COLLATE";
    static final String        T_COLLECT          = "COLLECT";
    static final String        T_COLUMN           = "COLUMN";
    public static final String T_COMMIT           = "COMMIT";
    static final String        T_CONDITION        = "CONDIITON";
    public static final String T_CONNECT          = "CONNECT";
    public static final String T_CONSTRAINT       = "CONSTRAINT";
    public static final String T_CONTAINS         = "CONTAINS";
    public static final String T_CONVERT          = "CONVERT";
    static final String        T_CORR             = "CORR";
    static final String        T_CORRESPONDING    = "CORRESPONDING";
    static final String        T_COUNT            = "COUNT";
    static final String        T_COVAR_POP        = "COVAR_POP";
    static final String        T_COVAR_SAMP       = "COVAR_SAMP";
    public static final String T_CREATE           = "CREATE";
    static final String        T_CROSS            = "CROSS";
    static final String        T_CUBE             = "CUBE";
    static final String        T_CUME_DIST        = "CUME_DIST";
    static final String        T_CURRENT          = "CURRENT";
    static final String        T_CURRENT_CATALOG  = "CURRENT_CATALOG";
    static final String        T_CURRENT_DATE     = "CURRENT_DATE";
    static final String T_CURRENT_DEFAULT_TRANSFORM_GROUP =
        "CURRENT_DEFAULT_TRANSFORM_GROUP";
    static final String T_CURRENT_PATH      = "CURRENT_PATH";
    static final String T_CURRENT_ROLE      = "CURRENT_ROLE";
    static final String T_CURRENT_ROW       = "CURRENT_ROW";
    static final String T_CURRENT_SCHEMA    = "CURRENT_SCHEMA";
    static final String T_CURRENT_TIME      = "CURRENT_TIME";
    static final String T_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    static final String T_CURRENT_TRANSFORM_GROUP_FOR_TYPE =
        "CURRENT_TRANSFORM_GROUP_FOR_TYPE";
    static final String        T_CURRENT_USER      = "CURRENT_USER";
    static final String        T_CURSOR            = "CURSOR";
    static final String        T_CYCLE             = "CYCLE";
    public static final String T_DATE              = "DATE";
    public static final String T_DAY               = "DAY";
    static final String        T_DEALLOCATE        = "DEALLOCATE";
    public static final String T_DEC               = "DEC";
    public static final String T_DECIMAL           = "DECIMAL";
    static final String        T_DECLARE           = "DECLARE";
    public static final String T_DEFAULT           = "DEFAULT";
    public static final String T_DELETE            = "DELETE";
    static final String        T_DENSE_RANK        = "DENSE_RANK";
    static final String        T_DEREF             = "DEREF";
    static final String        T_DESCRIBE          = "DESCRIBE";
    static final String        T_DETERMINISTIC     = "DETERMINISTIC";
    static final String        T_DISCONNECT        = "DISCONNECT";
    static final String        T_DISTINCT          = "DISTINCT";
    public static final String T_DO                = "DO";
    public static final String T_DOUBLE            = "DOUBLE";
    static final String        T_DROP              = "DROP";
    static final String        T_DYNAMIC           = "DYNAMIC";
    static final String        T_EACH              = "EACH";
    static final String        T_ELEMENT           = "ELEMENT";
    static final String        T_ELSE              = "ELSE";
    static final String        T_ELSEIF            = "ELSEIF";
    static final String        T_END               = "END";
    static final String        T_END_EXEC          = "END_EXEC";
    static final String        T_END_FRAME         = "END_FRAME";
    static final String        T_END_PARTITION     = "END_PARTITION";
    static final String        T_EQUALS            = "EQUALS";
    static final String        T_ESCAPE            = "ESCAPE";
    static final String        T_EVERY             = "EVERY";
    static final String        T_EXCEPT            = "EXCEPT";
    public static final String T_EXEC              = "EXEC";
    public static final String T_EXECUTE           = "EXECUTE";
    static final String        T_EXISTS            = "EXISTS";
    static final String        T_EXP               = "EXP";
    public static final String T_EXTERNAL          = "EXTERNAL";
    static final String        T_EXTRACT           = "EXTRACT";
    public static final String T_FALSE             = "FALSE";
    static final String        T_FETCH             = "FETCH";
    static final String        T_FILTER            = "FILTER";
    static final String        T_FIRST_VALUE       = "FIRST_VALUE";
    public static final String T_FLOAT             = "FLOAT";
    static final String        T_FLOOR             = "FLOOR";
    public static final String T_FOR               = "FOR";
    public static final String T_FOREIGN           = "FOREIGN";
    static final String        T_FRAME_ROW         = "FRAME_ROW";
    static final String        T_FREE              = "FREE";
    public static final String T_FROM              = "FROM";
    static final String        T_FULL              = "FULL";
    public static final String T_FUNCTION          = "FUNCTION";
    static final String        T_FUSION            = "FUSION";
    public static final String T_GET               = "GET";
    static final String        T_GLOBAL            = "GLOBAL";
    public static final String T_GRANT             = "GRANT";
    static final String        T_GROUP             = "GROUP";
    static final String        T_GROUPING          = "GROUPING";
    static final String        T_HANDLER           = "HANDLER";
    static final String        T_HAVING            = "HAVING";
    static final String        T_HOLD              = "HOLD";
    public static final String T_HOUR              = "HOUR";
    static final String        T_IDENTITY          = "IDENTITY";
    static final String        T_IF                = "IF";
    static final String        T_IMPORT            = "IMPORT";
    static final String        T_IN                = "IN";
    static final String        T_INDICATOR         = "INDICATOR";
    static final String        T_INNER             = "INNER";
    static final String        T_INOUT             = "INOUT";
    static final String        T_INSENSITIVE       = "INSENSITIVE";
    public static final String T_INSERT            = "INSERT";
    public static final String T_INT               = "INT";
    public static final String T_INTEGER           = "INTEGER";
    static final String        T_INTERSECT         = "INTERSECT";
    static final String        T_INTERSECTION      = "INTERSECTION";
    public static final String T_INTERVAL          = "INTERVAL";
    static final String        T_INTO              = "INTO";
    static final String        T_ITERATE           = "ITERATE";
    public static final String T_IS                = "IS";
    static final String        T_JAR               = "JAR";              // SQL/JRT
    static final String        T_JOIN              = "JOIN";
    static final String        T_LAG               = "LAG";
    public static final String T_LANGUAGE          = "LANGUAGE";
    static final String        T_LARGE             = "LARGE";
    static final String        T_LAST_VALUE        = "LAST_VALUE";
    static final String        T_LATERAL           = "LATERAL";
    static final String        T_LEAD              = "LEAD";
    static final String        T_LEADING           = "LEADING";
    static final String        T_LEAVE             = "LEAVE";
    static final String        T_LEFT              = "LEFT";
    static final String        T_LIKE              = "LIKE";
    static final String        T_LIKE_REGX         = "LIKE_REGX";
    static final String        T_LN                = "LN";
    public static final String T_LOCAL             = "LOCAL";
    static final String        T_LOCALTIME         = "LOCALTIME";
    static final String        T_LOCALTIMESTAMP    = "LOCALTIMESTAMP";
    public static final String T_LOOP              = "LOOP";
    static final String        T_LOWER             = "LOWER";
    static final String        T_MATCH             = "MATCH";
    static final String        T_MAX               = "MAX";
    static final String        T_MAX_CARDINALITY   = "MAX_CARDINALITY";
    static final String        T_MEMBER            = "MEMBER";
    static final String        T_MERGE             = "MERGE";
    static final String        T_METHOD            = "METHOD";
    static final String        T_MIN               = "MIN";
    public static final String T_MINUTE            = "MINUTE";
    static final String        T_MOD               = "MOD";
    static final String        T_MODIFIES          = "MODIFIES";
    static final String        T_MODULE            = "MODULE";
    public static final String T_MONTH             = "MONTH";
    public static final String T_MULTISET          = "MULTISET";
    static final String        T_NATIONAL          = "NATIONAL";
    static final String        T_NATURAL           = "NATURAL";
    static final String        T_NCHAR             = "NCHAR";
    static final String        T_NCLOB             = "NCLOB";
    static final String        T_NEW               = "NEW";
    public static final String T_NO                = "NO";
    public static final String T_NONE              = "NONE";
    static final String        T_NORMALIZE         = "NORMALIZE";
    static final String        T_NOT               = "NOT";
    static final String        T_NTH_VALUE         = "NTH_VALUE";
    static final String        T_NTILE             = "NTILE";
    public static final String T_NULL              = "NULL";
    public static final String T_NULLIF            = "NULLIF";
    public static final String T_NUMERIC           = "NUMERIC";
    static final String        T_OCCURRENCES_REGEX = "OCCURRENCES_REGEX";
    static final String        T_OCTET_LENGTH      = "OCTET_LENGTH";
    static final String        T_OF                = "OF";
    static final String        T_OFFSET            = "OFFSET";
    static final String        T_OLD               = "OLD";
    public static final String T_ON                = "ON";
    public static final String T_ONLY              = "ONLY";
    static final String        T_OPEN              = "OPEN";
    static final String        T_OR                = "OR";
    public static final String T_ORDER             = "ORDER";
    static final String        T_OUT               = "OUT";
    static final String        T_OUTER             = "OUTER";
    static final String        T_OVER              = "OVER";
    static final String        T_OVERLAPS          = "OVERLAPS";
    static final String        T_OVERLAY           = "OVERLAY";
    static final String        T_PARAMETER         = "PARAMETER";
    static final String        T_PARTITION         = "PARTITION";
    static final String        T_PERCENT           = "PERCENT";
    static final String        T_PERCENT_RANK      = "PERCENT_RANK";
    static final String        T_PERCENTILE_CONT   = "PERCENTILE_CONT";
    static final String        T_PERCENTILE_DISC   = "PERCENTILE_DISC";
    static final String        T_PERIOD            = "PERIOD";
    static final String        T_PORTION           = "PORTION";
    static final String        T_POSITION          = "POSITION";
    static final String        T_POSITION_REGEX    = "POSITION_REGEX";
    static final String        T_POWER             = "POWER";
    static final String        T_PRECEDES          = "PRECEDES";
    static final String        T_PRECISION         = "PRECISION";
    static final String        T_PREPARE           = "PREPARE";
    static final String        T_PRIMARY           = "PRIMARY";
    public static final String T_PROCEDURE         = "PROCEDURE";
    static final String        T_RANGE             = "RANGE";
    static final String        T_RANK              = "RANK";
    static final String        T_READS             = "READS";
    public static final String T_REAL              = "REAL";
    static final String        T_RECURSIVE         = "RECURSIVE";
    static final String        T_REF               = "REF";
    public static final String T_REFERENCES        = "REFERENCES";
    static final String        T_REFERENCING       = "REFERENCING";
    static final String        T_REGR_AVGX         = "REGR_AVGX";
    static final String        T_REGR_AVGY         = "REGR_AVGY";
    static final String        T_REGR_COUNT        = "REGR_COUNT";
    static final String        T_REGR_INTERCEPT    = "REGR_INTERCEPT";
    static final String        T_REGR_R2           = "REGR_R2";
    static final String        T_REGR_SLOPE        = "REGR_SLOPE";
    static final String        T_REGR_SXX          = "REGR_SXX";
    static final String        T_REGR_SXY          = "REGR_SXY";
    static final String        T_REGR_SYY          = "REGR_SYY";
    static final String        T_RELEASE           = "RELEASE";
    static final String        T_REPEAT            = "REPEAT";
    static final String        T_RESIGNAL          = "RESIGNAL";
    public static final String T_RESULT            = "RESULT";
    static final String        T_RETURN            = "RETURN";
    static final String        T_RETURNS           = "RETURNS";
    static final String        T_REVOKE            = "REVOKE";
    static final String        T_RIGHT             = "RIGHT";
    public static final String T_ROLLBACK          = "ROLLBACK";
    static final String        T_ROLLUP            = "ROLLUP";
    public static final String T_ROW               = "ROW";
    static final String        T_ROW_NUMBER        = "ROW_NUMBER";
    public static final String T_ROWS              = "ROWS";
    static final String        T_SAVEPOINT         = "SAVEPOINT";
    static final String        T_SCOPE             = "SCOPE";
    static final String        T_SCROLL            = "SCROLL";
    public static final String T_SEARCH            = "SEARCH";
    public static final String T_SECOND            = "SECOND";
    public static final String T_SELECT            = "SELECT";
    static final String        T_SENSITIVE         = "SENSITIVE";
    static final String        T_SESSION_USER      = "SESSION_USER";
    public static final String T_SET               = "SET";
    static final String        T_SIGNAL            = "SIGNAL";
    static final String        T_SIMILAR           = "SIMILAR";
    public static final String T_SMALLINT          = "SMALLINT";
    static final String        T_SOME              = "SOME";
    public static final String T_SPECIFIC          = "SPECIFIC";
    static final String        T_SPECIFICTYPE      = "SPECIFICTYPE";
    public static final String T_SQL               = "SQL";
    static final String        T_SQLEXCEPTION      = "SQLEXCEPTION";
    static final String        T_SQLSTATE          = "SQLSTATE";
    static final String        T_SQLWARNING        = "SQLWARNING";
    static final String        T_SQRT              = "SQRT";
    static final String        T_START             = "START";
    static final String        T_STATIC            = "STATIC";
    static final String        T_STDDEV_POP        = "STDDEV_POP";
    static final String        T_STDDEV_SAMP       = "STDDEV_SAMP";
    static final String        T_SUBMULTISET       = "SUBMULTISET";
    static final String        T_SUBSTRING         = "SUBSTRING";
    static final String        T_SUBSTRING_REGEX   = "SUBSTRING_REGEX";
    static final String        T_SUCCEEDS          = "SUCCEEDS";
    static final String        T_SUM               = "SUM";
    static final String        T_SYMMETRIC         = "SYMMETRIC";
    static final String        T_SYSTEM            = "SYSTEM";
    static final String        T_SYSTEM_TIME       = "SYSTEM_TIME";
    static final String        T_SYSTEM_USER       = "SYSTEM_USER";
    public static final String T_TABLE             = "TABLE";
    static final String        T_TABLESAMPLE       = "TABLESAMPLE";
    static final String        T_THEN              = "THEN";
    public static final String T_TIME              = "TIME";
    public static final String T_TIMESTAMP         = "TIMESTAMP";
    public static final String T_TIMEZONE_HOUR     = "TIMEZONE_HOUR";
    public static final String T_TIMEZONE_MINUTE   = "TIMEZONE_MINUTE";
    public static final String T_TO                = "TO";
    static final String        T_TRAILING          = "TRAILING";
    public static final String T_TRANSLATE         = "TRANSLATE";
    static final String        T_TRANSLATE_REGEX   = "TRANSLATE_REGEX";
    static final String        T_TRANSLATION       = "TRANSLATION";
    static final String        T_TREAT             = "TREAT";
    public static final String T_TRIGGER           = "TRIGGER";
    static final String        T_TRIM              = "TRIM";
    static final String        T_TRIM_ARRAY        = "TRIM_ARRAY";
    public static final String T_TRUE              = "TRUE";
    public static final String T_TRUNCATE          = "TRUNCATE";
    static final String        T_UESCAPE           = "UESCAPE";
    static final String        T_UNION             = "UNION";
    public static final String T_UNIQUE            = "UNIQUE";
    public static final String T_UNKNOWN           = "UNKNOWN";
    static final String        T_UNNEST            = "UNNEST";
    static final String        T_UNTIL             = "UNTIL";
    public static final String T_UPDATE            = "UPDATE";
    static final String        T_UPPER             = "UPPER";
    public static final String T_USER              = "USER";
    public static final String T_USING             = "USING";
    static final String        T_VALUE             = "VALUE";
    static final String        T_VALUES            = "VALUES";
    static final String        T_VALUE_OF          = "VALUE_OF";
    static final String        T_VAR_POP           = "VAR_POP";
    static final String        T_VAR_SAMP          = "VAR_SAMP";
    public static final String T_VARBINARY         = "VARBINARY";
    public static final String T_VARCHAR           = "VARCHAR";
    static final String        T_VARYING           = "VARYING";
    static final String        T_VERSIONING        = "VERSIONING";
    static final String        T_WHEN              = "WHEN";
    static final String        T_WHENEVER          = "WHENEVER";
    static final String        T_WHERE             = "WHERE";
    public static final String T_WHILE             = "WHILE";
    static final String        T_WIDTH_BUCKET      = "WIDTH_BUCKET";
    static final String        T_WINDOW            = "WINDOW";
    public static final String T_WITH              = "WITH";
    static final String        T_WITHIN            = "WITHIN";
    static final String        T_WITHOUT           = "WITHOUT";
    public static final String T_YEAR              = "YEAR";

    // ops
    static final String        T_ASTERISK       = "*";
    public static final String T_COMMA          = ",";
    static final String        T_CIRCUMFLEX     = "^";
    public static final String T_CLOSEBRACKET   = ")";
    static final String        T_COLON          = ":";
    static final String        T_CONCAT_OP      = "||";
    public static final String T_DIVIDE_OP      = "/";
    static final String        T_EQUALS_OP      = "=";
    static final String        T_GREATER_OP     = ">";
    static final String        T_GREATER_EQUALS = ">=";
    public static final String T_LEFTBRACKET    = "[";
    static final String        T_LESS_OP        = "<";
    static final String        T_LESS_EQUALS    = "<=";
    static final String        T_PERCENT_OP     = "%";
    static final String        T_PLUS_OP        = "+";
    static final String        T_MINUS_OP       = "-";
    static final String        T_NOT_EQUALS     = "<>";
    static final String        T_NOT_EQUALS_ALT = "!=";
    public static final String T_OPENBRACKET    = "(";
    static final String        T_QUESTION       = "?";
    public static final String T_RIGHTBRACKET   = "]";
    static final String        T_SEMICOLON      = ";";
    static final String        T_DOUBLE_COLON   = "::";

    // SQL:200n non-reserved word list
    static final String        T_A                    = "A";
    static final String        T_ABSOLUTE             = "ABSOLUTE";
    static final String        T_ACTION               = "ACTION";
    static final String        T_ADA                  = "ADA";
    static final String        T_ADD                  = "ADD";
    static final String        T_ADMIN                = "ADMIN";
    static final String        T_AFTER                = "AFTER";
    static final String        T_ALWAYS               = "ALWAYS";
    static final String        T_ASC                  = "ASC";
    static final String        T_ASSERTION            = "ASSERTION";
    static final String        T_ASSIGNMENT           = "ASSIGNMENT";
    static final String        T_ATTRIBUTE            = "ATTRIBUTE";
    static final String        T_ATTRIBUTES           = "ATTRIBUTES";
    static final String        T_BEFORE               = "BEFORE";
    static final String        T_BERNOULLI            = "BERNOULLI";
    public static final String T_BIT                  = "BIT";
    static final String        T_BITLENGTH            = "BITLENGTH";
    static final String        T_BREADTH              = "BREADTH";
    static final String        T_C                    = "C";
    static final String        T_CASCADE              = "CASCADE";
    public static final String T_CATALOG              = "CATALOG";
    public static final String T_CATALOG_NAME         = "CATALOG_NAME";
    static final String        T_CHAIN                = "CHAIN";
    static final String T_CHARACTER_SET_CATALOG = "CHARACTER_SET_CATALOG";
    static final String        T_CHARACTER_SET_NAME   = "CHARACTER_SET_NAME";
    static final String        T_CHARACTER_SET_SCHEMA = "CHARACTER_SET_SCHEMA";
    static final String        T_CHARACTERISTICS      = "CHARACTERISTICS";
    static final String        T_CHARACTERS           = "CHARACTERS";
    static final String        T_CLASS_ORIGIN         = "CLASS_ORIGIN";
    static final String        T_COBOL                = "COBOL";
    public static final String T_COLLATION            = "COLLATION";
    static final String        T_COLLATION_CATALOG    = "COLLATION_CATALOG";
    static final String        T_COLLATION_NAME       = "COLLATION_NAME";
    static final String        T_COLLATION_SCHEMA     = "COLLATION_SCHEMA";
    static final String        T_COLUMN_NAME          = "COLUMN_NAME";
    static final String        T_COMMAND_FUNCTION     = "COMMAND_FUNCTION";
    static final String T_COMMAND_FUNCTION_CODE = "COMMAND_FUNCTION_CODE";
    public static final String T_COMMITTED            = "COMMITTED";
    static final String        T_COMPARABLE           = "COMPARABLE";    // SQL/JRT
    static final String        T_CONDITION_IDENTIFIER = "CONDIITON_IDENTIFIER";
    static final String        T_CONDITION_NUMBER     = "CONDITION_NUMBER";
    static final String        T_CONNECTION           = "CONNECTION";
    static final String        T_CONNECTION_NAME      = "CONNECTION_NAME";
    static final String        T_CONSTRAINT_CATALOG   = "CONSTRAINT_CATALOG";
    static final String        T_CONSTRAINT_NAME      = "CONSTRAINT_NAME";
    static final String        T_CONSTRAINT_SCHEMA    = "CONSTRAINT_SCHEMA";
    static final String        T_CONSTRAINTS          = "CONSTRAINTS";
    static final String        T_CONSTRUCTOR          = "CONSTRUCTOR";
    static final String        T_CONTINUE             = "CONTINUE";
    static final String        T_CURRENT_COLLATION    = "CURRENT_COLLATION";
    static final String        T_CURSOR_NAME          = "CURSOR_NAME";
    public static final String T_DATA                 = "DATA";
    static final String        T_INTERVAL_CODE = "DATETIME_INTERVAL_CODE";
    static final String T_DATETIME_INTERVAL_PRECISION =
        "DATETIME_INTERVAL_PRECISION";
    public static final String T_DEFAULTS             = "DEFAULTS";
    static final String        T_DEFERRABLE           = "DEFERRABLE";
    static final String        T_DEFERRED             = "DEFERRED";
    static final String        T_DEFINED              = "DEFINED";
    static final String        T_DEFINER              = "DEFINER";
    static final String        T_DEGREE               = "DEGREE";
    static final String        T_DEPTH                = "DEPTH";
    static final String        T_DERIVED              = "DERIVED";
    static final String        T_DESC                 = "DESC";
    static final String        T_DESCRIPTOR           = "DESCRIPTOR";
    static final String        T_DIAGNOSTICS          = "DIAGNOSTICS";
    static final String        T_DISPATCH             = "DISPATCH";
    public static final String T_DOMAIN               = "DOMAIN";
    static final String        T_DYNAMIC_FUNCTION     = "DYNAMIC_FUNCTION";
    static final String T_DYNAMIC_FUNCTION_CODE = "DYNAMIC_FUNCTION_CODE";
    static final String        T_ENFORCED             = "ENFORCED";
    static final String        T_EXCEPTION            = "EXCEPTION";
    static final String        T_EXCLUDE              = "EXCLUDE";
    static final String        T_EXCLUDING            = "EXCLUDING";
    static final String        T_EXIT                 = "EXIT";
    static final String        T_EXPRESSION           = "EXPRESSION";
    static final String        T_FINAL                = "FINAL";
    public static final String T_FIRST                = "FIRST";
    static final String        T_FLAG                 = "FLAG";
    static final String        T_FOLLOWING            = "FOLLOWING";
    static final String        T_FORTRAN              = "FORTRAN";
    static final String        T_FOUND                = "FOUND";
    public static final String T_G_FACTOR             = "G";
    static final String        T_GENERATED            = "GENERATED";
    static final String        T_GENERAL              = "GENERAL";
    static final String        T_GO                   = "GO";
    static final String        T_GOTO                 = "GOTO";
    static final String        T_GRANTED              = "GRANTED";
    static final String        T_HIERARCHY            = "HIERARCHY";
    static final String        T_IGNORE               = "IGNORE";
    static final String        T_IMMEDIATE            = "IMMEDIATE";
    static final String        T_IMMEDIATELY          = "IMMEDIATELY";
    static final String        T_IMPLEMENTATION       = "IMPLEMENTATION";
    static final String        T_INCLUDING            = "INCLUDING";
    public static final String T_INCREMENT            = "INCREMENT";
    static final String        T_INITIALLY            = "INITIALLY";
    static final String        T_INPUT                = "INPUT";
    static final String        T_INSTANCE             = "INSTANCE";
    static final String        T_INSTANTIABLE         = "INSTANTIABLE";
    static final String        T_INSTEAD              = "INSTEAD";
    static final String        T_INTERFACE            = "INTERFACE";     // SQL/JRT
    static final String        T_INVOKER              = "INVOKER";
    public static final String T_ISOLATION            = "ISOLATION";
    public static final String T_JAVA                 = "JAVA";          // SQL/JRT
    public static final String T_K_FACTOR             = "K";
    static final String        T_KEY                  = "KEY";
    static final String        T_KEY_MEMBER           = "KEY_MEMBER";
    static final String        T_KEY_TYPE             = "KEY_TYPE";
    static final String        T_LAST                 = "LAST";
    static final String        T_LENGTH               = "LENGTH";
    public static final String T_LEVEL                = "LEVEL";
    public static final String T_LIBRARY              = "LIBRARY";
    static final String        T_LOCATOR              = "LOCATOR";
    public static final String T_M_FACTOR             = "M";
    static final String        T_MAP                  = "MAP";
    static final String        T_MATCHED              = "MATCHED";
    static final String        T_MAXVALUE             = "MAXVALUE";
    static final String        T_MESSAGE_LENGTH       = "MESSAGE_LENGTH";
    static final String        T_MESSAGE_OCTET_LENGTH = "MESSAGE_OCTET_LENGTH";
    static final String        T_MESSAGE_TEXT         = "MESSAGE_TEXT";
    static final String        T_MINVALUE             = "MINVALUE";
    static final String        T_MORE                 = "MORE";
    static final String        T_MUMPS                = "MUMPS";
    public static final String T_NAME                 = "NAME";
    public static final String T_NAMES                = "NAMES";
    static final String        T_NESTING              = "NESTING";
    static final String        T_NEXT                 = "NEXT";
    static final String        T_NFC                  = "NFC";
    static final String        T_NFD                  = "NFD";
    static final String        T_NFKC                 = "NFKC";
    static final String        T_NFKD                 = "NFKD";
    static final String        T_NORMALIZED           = "NORMALIZED";
    static final String        T_NULLABLE             = "NULLABLE";
    public static final String T_NULLS                = "NULLS";
    static final String        T_NUMBER               = "NUMBER";
    public static final String T_OBJECT               = "OBJECT";
    static final String        T_OCTETS               = "OCTETS";
    static final String        T_OPTION               = "OPTION";
    static final String        T_OPTIONS              = "OPTIONS";
    static final String        T_ORDERING             = "ORDERING";
    static final String        T_ORDINALITY           = "ORDINALITY";
    static final String        T_OTHERS               = "OTHERS";
    static final String        T_OUTPUT               = "OUTPUT";
    public static final String T_OVERRIDING           = "OVERRIDING";
    public static final String T_P_FACTOR             = "P";
    public static final String T_PAD                  = "PAD";
    static final String        T_PARAMETER_MODE       = "PARAMETER_MODE";
    static final String        T_PARAMETER_NAME       = "PARAMETER_NAME";
    static final String T_PARAMETER_ORDINAL_POSITION =
        "PARAMETER_ORDINAL_POSITION";
    static final String T_PARAMETER_SPECIFIC_CATALOG =
        "PARAMETER_SPECIFIC_CATALOG";
    static final String T_PARAMETER_SPEC_NAME = "PARAMETER_SPECIFIC_NAME";
    static final String T_PARAMETER_SPEC_SCHEMA = "PARAMETER_SPECIFIC_SCHEMA";
    static final String        T_PARTIAL              = "PARTIAL";
    static final String        T_PASCAL               = "PASCAL";
    public static final String T_PATH                 = "PATH";
    static final String        T_PLACING              = "PLACING";
    static final String        T_PLI                  = "PLI";
    static final String        T_PRECEDING            = "PRECEDING";
    static final String        T_PRESERVE             = "PRESERVE";
    static final String        T_PRIOR                = "PRIOR";
    static final String        T_PRIVILEGES           = "PRIVILEGES";
    public static final String T_PUBLIC               = "PUBLIC";
    public static final String T_READ                 = "READ";
    static final String        T_RELATIVE             = "RELATIVE";
    static final String        T_REPEATABLE           = "REPEATABLE";
    static final String        T_RESPECT              = "RESPECT";
    static final String        T_RESTART              = "RESTART";
    static final String        T_RESET                = "RESET";
    public static final String T_RESTRICT             = "RESTRICT";
    static final String        T_RETURNED_CARDINALITY = "RETURNED_CARDINALITY";
    static final String        T_RETURNED_LENGTH      = "RETURNED_LENGTH";
    static final String T_RETURNED_OCTET_LENGTH = "RETURNED_OCTET_LENGTH";
    static final String        T_RETURNED_SQLSTATE    = "RETURNED_SQLSTATE";
    public static final String T_ROLE                 = "ROLE";
    public static final String T_ROUTINE              = "ROUTINE";
    static final String        T_ROUTINE_CATALOG      = "ROUTINE_CATALOG";
    static final String        T_ROUTINE_NAME         = "ROUTINE_NAME";
    static final String        T_ROUTINE_SCHEMA       = "ROUTINE_SCHEMA";
    static final String        T_ROW_COUNT            = "ROW_COUNT";
    public static final String T_SCALE                = "SCALE";
    public static final String T_SCHEMA               = "SCHEMA";
    static final String        T_SCHEMA_NAME          = "SCHEMA_NAME";
    static final String        T_SCOPE_CATALOG        = "SCOPE_CATALOG";
    static final String        T_SCOPE_NAME           = "SCOPE_NAME";
    static final String        T_SCOPE_SCHEMA         = "SCOPE_SCHEMA";
    static final String        T_SECTION              = "SECTION";
    static final String        T_SECURITY             = "SECURITY";
    static final String        T_SELF                 = "SELF";
    public static final String T_SEQUENCE             = "SEQUENCE";
    static final String        T_SERIAL               = "SERIAL";
    public static final String T_SERIALIZABLE         = "SERIALIZABLE";
    public static final String T_SERVER               = "SERVER";
    static final String        T_SERVER_NAME          = "SERVER_NAME";
    public static final String T_SESSION              = "SESSION";
    static final String        T_SETS                 = "SETS";
    static final String        T_SIMPLE               = "SIMPLE";
    public static final String T_SIZE                 = "SIZE";
    static final String        T_SOURCE               = "SOURCE";
    public static final String T_SPACE                = "SPACE";
    static final String        T_SPECIFIC_NAME        = "SPECIFIC_NAME";
    static final String        T_SQLDATA              = "SQLDATA";       // SQL/JRT
    static final String        T_STACKED              = "STACKED";
    static final String        T_STATE                = "STATE";
    static final String        T_STATEMENT            = "STATEMENT";
    static final String        T_STRUCTURE            = "STRUCTURE";
    static final String        T_STYLE                = "STYLE";
    static final String        T_SUBCLASS_ORIGIN      = "SUBCLASS_ORIGIN";
    public static final String T_T_FACTOR             = "T";
    static final String        T_TABLE_NAME           = "TABLE_NAME";
    static final String        T_TEMPORARY            = "TEMPORARY";
    static final String        T_TIES                 = "TIES";
    static final String        T_TOP_LEVEL_COUNT      = "TOP_LEVEL_COUNT";
    public static final String T_TRANSACTION          = "TRANSACTION";
    static final String T_TRANSACTS_COMMITTED = "TRANSACTIONS_COMMITTED";
    static final String T_TRANSACTS_ROLLED_BACK = "TRANSACTIONS_ROLLED_BACK";
    static final String        T_TRANSACTION_ACTIVE   = "TRANSACTION_ACTIVE";
    static final String        T_TRANSFORM            = "TRANSFORM";
    static final String        T_TRANSFORMS           = "TRANSFORMS";
    static final String        T_TRIGGER_CATALOG      = "TRIGGER_CATALOG";
    static final String        T_TRIGGER_NAME         = "TRIGGER_NAME";
    static final String        T_TRIGGER_SCHEMA       = "TRIGGER_SCHEMA";
    public static final String T_TYPE                 = "TYPE";
    static final String        T_UNBOUNDED            = "UNBOUNDED";
    static final String        T_UNCOMMITTED          = "UNCOMMITTED";
    static final String        T_UNDER                = "UNDER";
    static final String        T_UNDO                 = "UNDO";
    static final String        T_UNNAMED              = "UNNAMED";
    public static final String T_USAGE                = "USAGE";
    static final String T_USER_DEFINED_TYPE_CATALOG =
        "USER_DEFINED_TYPE_CATALOG";
    static final String T_USER_DEFINED_TYPE_CODE = "USER_DEFINED_TYPE_CODE";
    static final String T_USER_DEFINED_TYPE_NAME = "USER_DEFINED_TYPE_NAME";
    static final String T_USER_DEFINED_TYPE_SCHEMA =
        "USER_DEFINED_TYPE_SCHEMA";
    static final String        T_VIEW    = "VIEW";
    static final String        T_WORK    = "WORK";
    public static final String T_WRAPPER = "WRAPPER";
    public static final String T_WRITE   = "WRITE";
    public static final String T_ZONE    = "ZONE";

    // other tokens
    static final String        T_ALIAS                = "ALIAS";
    static final String        T_AGGREGATE            = "AGGREGATE";
    public static final String T_AUTHENTICATION       = "AUTHENTICATION";
    static final String        T_AUTO_INCREMENT       = "AUTO_INCREMENT";
    static final String        T_AUTOCOMMIT           = "AUTOCOMMIT";
    public static final String T_BACKUP               = "BACKUP";
    static final String        T_BIGSERIAL            = "BIGSERIAL";
    static final String        T_BINARY_DOUBLE        = "BINARY_DOUBLE";
    static final String        T_BINARY_FLOAT         = "BINARY_FLOAT";
    static final String        T_BODY                 = "BODY";
    static final String        T_BYTE                 = "BYTE";
    public static final String T_CACHE                = "CACHE";
    public static final String T_CACHED               = "CACHED";
    static final String        T_CASEWHEN             = "CASEWHEN";
    static final String        T_CHECKPOINT           = "CHECKPOINT";
    static final String        T_CITEXT               = "CITEXT";
    static final String        T_CLASS                = "CLASS";
    static final String        T_CLUSTERED            = "CLUSTERED";
    static final String        T_COMMENT              = "COMMENT";
    public static final String T_COMPACT              = "COMPACT";
    public static final String T_COMPRESSED           = "COMPRESSED";
    public static final String T_CONFLICT             = "CONFLICT";
    public static final String T_CONTROL              = "CONTROL";
    static final String        T_CURDATE              = "CURDATE";
    static final String        T_CURRVAL              = "CURRVAL";
    static final String        T_CURTIME              = "CURTIME";
    public static final String T_DATABASE             = "DATABASE";
    public static final String T_DATETIME             = "DATETIME";
    public static final String T_DB2                  = "DB2";
    public static final String T_DEADLOCK             = "DEADLOCK";
    public static final String T_DEFRAG               = "DEFRAG";
    public static final String T_DELAY                = "DELAY";
    public static final String T_DIGEST               = "DIGEST";
    static final String        T_DUAL                 = "DUAL";
    static final String        T_DUPLICATE            = "DUPLICATE";
    public static final String T_ERROR                = "ERROR";
    public static final String T_EVENT                = "EVENT";
    static final String        T_EXCLUSIVE            = "EXCLUSIVE";
    static final String        T_EXPLAIN              = "EXPLAIN";
    static final String        T_FEATURE              = "FEATURE";
    static final String        T_FILE                 = "FILE";
    public static final String T_FILES                = "FILES";
    static final String        T_FOLD                 = "FOLD";
    static final String        T_FORMAT               = "FORMAT";
    static final String        T_GROUP_CONCAT         = "GROUP_CONCAT";
    static final String        T_HEADER               = "HEADER";
    static final String        T_IFNULL               = "IFNULL";
    public static final String T_IGNORECASE           = "IGNORECASE";
    public static final String T_INDEX                = "INDEX";
    public static final String T_INDEXER              = "INDEXER";
    public static final String T_INITIAL              = "INITIAL";
    public static final String T_INTEGRITY            = "INTEGRITY";
    static final String        T_IS_AUTOCOMMIT        = "IS_AUTOCOMMIT";
    static final String        T_IS_READONLY_DATABASE = "IS_READONLY_DATABASE";
    static final String T_IS_READONLY_DATABASE_FILES =
        "IS_READONLY_DATABASE_FILES";
    static final String        T_IS_READONLY_SESSION  = "IS_READONLY_SESSION";
    static final String        T_ISNULL               = "ISNULL";
    static final String        T_KEEP                 = "KEEP";
    static final String        T_LASTVAL              = "LASTVAL";
    static final String        T_LIMIT                = "LIMIT";
    public static final String T_LOB                  = "LOB";
    public static final String T_LOCK                 = "LOCK";
    public static final String T_LOCKS                = "LOCKS";
    public static final String T_LONG                 = "LONG";
    public static final String T_LONGBLOB             = "LONGBLOB";
    public static final String T_LONGTEXT             = "LONGTEXT";
    public static final String T_LONGVAR              = "LONGVAR";
    public static final String T_LONGVARBINARY        = "LONGVARBINARY";
    public static final String T_LONGVARCHAR          = "LONGVARCHAR";
    static final String        T_MAXROWS              = "MAXROWS";
    static final String        T_MEDIAN               = "MEDIAN";
    static final String        T_MEDIUMBLOB           = "MEDIUMBLOB";
    static final String        T_MEDIUMTEXT           = "MEDIUMTEXT";
    public static final String T_MEMORY               = "MEMORY";
    public static final String T_MILLIS               = "MILLIS";
    static final String        T_MINUS_EXCEPT         = "MINUS";
    public static final String T_MSS                  = "MSS";
    public static final String T_MVCC                 = "MVCC";
    public static final String T_MVLOCKS              = "MVLOCKS";
    public static final String T_MYS                  = "MYS";
    public static final String T_NAN                  = "NAN";
    static final String        T_NEXTVAL              = "NEXTVAL";
    public static final String T_NIO                  = "NIO";
    static final String        T_NOWAIT               = "NOWAIT";
    public static final String T_NVARCHAR             = "NVARCHAR";
    public static final String T_NVARCHAR2            = "NVARCHAR2";
    static final String        T_NVL                  = "NVL";
    static final String        T_NVL2                 = "NVL2";
    static final String        T_OCTETLENGTH          = "OCTETLENGTH";
    static final String        T_OFF                  = "OFF";
    public static final String T_OTHER                = "OTHER";
    public static final String T_ORA                  = "ORA";
    public static final String T_PASSWORD             = "PASSWORD";
    public static final String T_PERFORM              = "PERFORM";
    static final String        T_PLAN                 = "PLAN";
    public static final String T_PGS                  = "PGS";
    static final String        T_PREVVAL              = "PREVVAL";
    static final String        T_PROPERTY             = "PROPERTY";
    static final String        T_QUEUE                = "QUEUE";
    static final String        T_RAW                  = "RAW";
    static final String        T_READONLY             = "READONLY";
    static final String        T_REFERENTIAL          = "REFERENTIAL";
    public static final String T_REGULAR              = "REGULAR";
    static final String        T_RENAME               = "RENAME";
    static final String        T_ROWNUM               = "ROWNUM";
    static final String        T_SCRIPT               = "SCRIPT";
    static final String        T_SEPARATOR            = "SEPARATOR";
    static final String        T_BLOCKING             = "BLOCKING";
    static final String        T_SHARE                = "SHARE";
    static final String        T_SHUTDOWN             = "SHUTDOWN";
    static final String        T_SQL_TSI_DAY          = "SQL_TSI_DAY";
    static final String        T_SQL_TSI_FRAC_SECOND  = "SQL_TSI_FRAC_SECOND";
    static final String        T_SQL_TSI_MILLI_SECOND = "SQL_TSI_MILLI_SECOND";
    static final String        T_SQL_TSI_MICRO_SECOND = "SQL_TSI_MICRO_SECOND";
    static final String        T_SQL_TSI_HOUR         = "SQL_TSI_HOUR";
    static final String        T_SQL_TSI_MINUTE       = "SQL_TSI_MINUTE";
    static final String        T_SQL_TSI_MONTH        = "SQL_TSI_MONTH";
    static final String        T_SQL_TSI_QUARTER      = "SQL_TSI_QUARTER";
    static final String        T_SQL_TSI_SECOND       = "SQL_TSI_SECOND";
    static final String        T_SQL_TSI_WEEK         = "SQL_TSI_WEEK";
    static final String        T_SQL_TSI_YEAR         = "SQL_TSI_YEAR";
    static final String        T_SQL_BIGINT           = "SQL_BIGINT";
    static final String        T_SQL_BINARY           = "SQL_BINARY";
    static final String        T_SQL_BIT              = "SQL_BIT";
    static final String        T_SQL_BLOB             = "SQL_BLOB";
    static final String        T_SQL_BOOLEAN          = "SQL_BOOLEAN";
    static final String        T_SQL_CHAR             = "SQL_CHAR";
    static final String        T_SQL_CLOB             = "SQL_CLOB";
    static final String        T_SQL_DATE             = "SQL_DATE";
    static final String        T_SQL_DECIMAL          = "SQL_DECIMAL";
    static final String        T_SQL_DATALINK         = "SQL_DATALINK";
    static final String        T_SQL_DOUBLE           = "SQL_DOUBLE";
    static final String        T_SQL_FLOAT            = "SQL_FLOAT";
    static final String        T_SQL_INTEGER          = "SQL_INTEGER";
    static final String        T_SQL_LONGVARBINARY    = "SQL_LONGVARBINARY";
    static final String        T_SQL_LONGNVARCHAR     = "SQL_LONGNVARCHAR";
    static final String        T_SQL_LONGVARCHAR      = "SQL_LONGVARCHAR";
    static final String        T_SQL_NCHAR            = "SQL_NCHAR";
    static final String        T_SQL_NCLOB            = "SQL_NCLOB";
    static final String        T_SQL_NUMERIC          = "SQL_NUMERIC";
    static final String        T_SQL_NVARCHAR         = "SQL_NVARCHAR";
    static final String        T_SQL_REAL             = "SQL_REAL";
    static final String        T_SQL_ROWID            = "SQL_ROWID";
    static final String        T_SQL_SQLXML           = "SQL_SQLXML";
    static final String        T_SQL_SMALLINT         = "SQL_SMALLINT";
    static final String        T_SQL_TIME             = "SQL_TIME";
    static final String        T_SQL_TIMESTAMP        = "SQL_TIMESTAMP";
    static final String        T_SQL_TINYINT          = "SQL_TINYINT";
    static final String        T_SQL_VARBINARY        = "SQL_VARBINARY";
    static final String        T_SQL_VARCHAR          = "SQL_VARCHAR";
    public static final String T_SYNONYM              = "SYNONYM";
    public static final String T_SYNTAX               = "SYNTAX";
    public static final String T_TDC                  = "TDC";
    public static final String T_TEMP                 = "TEMP";
    public static final String T_TEXT                 = "TEXT";
    static final String        T_TIMESTAMP_WITH_ZONE  = "TIMESTAMP_WITH_ZONE";
    static final String        T_TIMESTAMPADD         = "TIMESTAMPADD";
    static final String        T_TIMESTAMPDIFF        = "TIMESTAMPDIFF";
    public static final String T_TINYBLOB             = "TINYBLOB";
    public static final String T_TINYINT              = "TINYINT";
    public static final String T_TINYTEXT             = "TINYTEXT";
    static final String        T_TOP                  = "TOP";
    public static final String T_TTI                  = "TTI";
    public static final String T_TYPES                = "TYPES";
    public static final String T_VARCHAR_IGNORECASE   = "VARCHAR_IGNORECASE";
    public static final String T_VARCHAR2             = "VARCHAR2";
    public static final String T_UTF16                = "UTF16";
    static final String        T_WRITE_DELAY          = "WRITE_DELAY";
    public static final String T_YES                  = "YES";

    //
    public static final String T_DAY_NAME     = "DAY_NAME";
    public static final String T_MONTH_NAME   = "MONTH_NAME";
    public static final String T_QUARTER      = "QUARTER";
    public static final String T_DAY_OF_WEEK  = "DAY_OF_WEEK";
    public static final String T_DAY_OF_MONTH = "DAY_OF_MONTH";
    public static final String T_DAY_OF_YEAR  = "DAY_OF_YEAR";
    public static final String T_WEEK_OF_YEAR = "WEEK_OF_YEAR";
    static final String        T_DAYNAME      = "DAYNAME";
    static final String        T_MONTHNAME    = "MONTHNAME";
    static final String        T_DAYOFMONTH   = "DAYOFMONTH";
    static final String        T_DAYOFWEEK    = "DAYOFWEEK";
    static final String        T_DAYOFYEAR    = "DAYOFYEAR";
    static final String        T_WEEK         = "WEEK";
    static final String        T_DAYS         = "DAYS";
    static final String        T_MICROSECOND  = "MICROSECOND";
    static final String        T_MILLISECOND  = "MILLISECOND";
    static final String        T_NANOSECOND   = "NANOSECOND";

    //
    static final String        T_ACOS             = "ACOS";
    static final String        T_ACTION_ID        = "ACTION_ID";
    static final String        T_ADD_MONTHS       = "ADD_MONTHS";
    static final String        T_ARRAY_SORT       = "ARRAY_SORT";
    static final String        T_ASCII            = "ASCII";
    static final String        T_ASIN             = "ASIN";
    static final String        T_ATAN             = "ATAN";
    static final String        T_ATAN2            = "ATAN2";
    static final String        T_BITAND           = "BITAND";
    static final String        T_BITANDNOT        = "BITANDNOT";
    static final String        T_BITNOT           = "BITNOT";
    static final String        T_BITOR            = "BITOR";
    static final String        T_BITXOR           = "BITXOR";
    public static final String T_CONCAT_WORD      = "CONCAT";
    static final String        T_CONCAT_WS        = "CONCAT_WS";
    static final String        T_CHR              = "CHR";
    static final String        T_COS              = "COS";
    static final String        T_COSH             = "COSH";
    static final String        T_COT              = "COT";
    static final String        T_CRYPT_KEY        = "CRYPT_KEY";
    static final String        T_DATABASE_NAME    = "DATABASE_NAME";
    static final String        T_DATE_ADD         = "DATE_ADD";
    static final String        T_DATE_SUB         = "DATE_SUB";
    static final String        T_DATEADD          = "DATEADD";
    static final String        T_DATEDIFF         = "DATEDIFF";
    static final String        T_DATENAME         = "DATENAME";
    static final String        T_DATEPART         = "DATEPART";
    static final String        T_DATETIME2        = "DATETIME2";
    public static final String T_DATETIMEOFFSET   = "DATETIMEOFFSET";
    static final String        T_DBTIMEZONE       = "DBTIMEZONE";
    static final String        T_DECODE           = "DECODE";
    static final String        T_DEGREES          = "DEGREES";
    static final String        T_DIFFERENCE       = "DIFFERENCE";
    static final String        T_DMOD             = "DMOD";
    static final String        T_EOMONTH          = "EOMONTH";
    static final String        T_ENUM             = "ENUM";
    static final String        T_FROM_TZ          = "FROM_TZ";
    public static final String T_GC               = "GC";
    static final String        T_GREATEST         = "GREATEST";
    static final String        T_HEXTORAW         = "HEXTORAW";
    static final String        T_IMAGE            = "IMAGE";
    static final String        T_INSTR            = "INSTR";
    static final String        T_LCASE            = "LCASE";
    static final String        T_LEAST            = "LEAST";
    public static final String T_LITERAL          = "LITERAL";
    static final String        T_LIVE             = "LIVE";
    static final String        T_LOAD             = "LOAD";
    static final String        T_LOAD_FILE        = "LOAD_FILE";
    static final String        T_LOCATE           = "LOCATE";
    public static final String T_LOG              = "LOG";
    static final String        T_LOG10            = "LOG10";
    static final String        T_LAST_DAY         = "LAST_DAY";
    static final String        T_LPAD             = "LPAD";
    static final String        T_LTRIM            = "LTRIM";
    static final String        T_MONEY            = "MONEY";
    static final String        T_MONTHS_BETWEEN   = "MONTHS_BETWEEN";
    static final String        T_NANVL            = "NANVL";
    static final String        T_NEWID            = "NEWID";
    static final String        T_NEW_TIME         = "NEW_TIME";
    static final String        T_NEXT_DAY         = "NEXT_DAY";
    static final String        T_NOW              = "NOW";
    static final String        T_NTEXT            = "NTEXT";
    static final String        T_NUMTODSINTERVAL  = "NUMTODSINTERVAL";
    static final String        T_NUMTOYMINTERVAL  = "NUMTOYMINTERVAL";
    static final String        T_PI               = "PI";
    static final String        T_POSITION_ARRAY   = "POSITION_ARRAY";
    static final String        T_RADIANS          = "RADIANS";
    static final String        T_RAND             = "RAND";
    static final String        T_RAWTOHEX         = "RAWTOHEX";
    static final String        T_REGEXP_MATCHES   = "REGEXP_MATCHES";
    static final String        T_REGEXP_REPLACE   = "REGEXP_REPLACE";
    static final String        T_REGEXP_SUBSTRING = "REGEXP_SUBSTRING";
    static final String T_REGEXP_SUBSTRING_ARRAY  = "REGEXP_SUBSTRING_ARRAY";
    static final String        T_REPLACE          = "REPLACE";
    static final String        T_REVERSE          = "REVERSE";
    static final String        T_ROUND            = "ROUND";
    static final String        T_ROUNDMAGIC       = "ROUNDMAGIC";
    static final String        T_RPAD             = "RPAD";
    static final String        T_RTRIM            = "RTRIM";
    public static final String T_SECONDS_MIDNIGHT = "SECONDS_SINCE_MIDNIGHT";
    static final String        T_SESSIONTIMEZONE  = "SESSIONTIMEZONE";
    static final String        T_SIGN             = "SIGN";
    static final String        T_SIN              = "SIN";
    static final String        T_SINH             = "SINH";
    static final String        T_SORT_ARRAY       = "SORT_ARRAY";
    static final String        T_SOUNDEX          = "SOUNDEX";
    static final String        T_SUBSTR           = "SUBSTR";
    public static final String T_SYS              = "SYS";
    static final String        T_SYS_EXTRACT_UTC  = "SYS_EXTRACT_UTC";
    static final String        T_SYS_GUID         = "SYS_GUID";
    static final String        T_SYSDATE          = "SYSDATE";
    static final String        T_SYSTIMESTAMP     = "SYSTIMESTAMP";
    static final String        T_TAN              = "TAN";
    static final String        T_TANH             = "TANH";
    static final String        T_TO_CHAR          = "TO_CHAR";
    static final String        T_TO_DATE          = "TO_DATE";
    static final String        T_TO_DSINTERVAL    = "TO_DSINTERVAL";
    static final String        T_TO_YMINTERVAL    = "TO_YMINTERVAL";
    static final String        T_TO_NUMBER        = "TO_NUMBER";
    static final String        T_TO_TIMESTAMP     = "TO_TIMESTAMP";
    static final String        T_TO_TIMESTAMP_TZ  = "TO_TIMESTAMP_TZ";
    static final String        T_TZ_OFFSET        = "TZ_OFFSET";
    static final String        T_TRANSACTION_SIZE = "TRANSACTION_SIZE";
    static final String        T_TRANSACTION_ID   = "TRANSACTION_ID";
    static final String        T_TRUNC            = "TRUNC";
    static final String        T_TODAY            = "TODAY";
    static final String        T_UCASE            = "UCASE";
    static final String        T_UNIQUEIDENTIFIER = "UNIQUEIDENTIFIER";
    static final String        T_USE              = "USE";
    static final String        T_UNIX_MILLIS      = "UNIX_MILLIS";
    static final String        T_UNIX_TIMESTAMP   = "UNIX_TIMESTAMP";
    public static final String T_UUID             = "UUID";

    //
    static final String T_ISOLATION_LEVEL         = "ISOLATION_LEVEL";
    static final String T_SESSION_ISOLATION_LEVEL = "SESSION_ISOLATION_LEVEL";
    static final String T_DATABASE_ISOLATION_LEVEL =
        "DATABASE_ISOLATION_LEVEL";
    static final String T_TRANSACTION_CONTROL = "TRANSACTION_CONTROL";
    static final String T_TIMEZONE            = "TIMEZONE";
    static final String T_SESSION_TIMEZONE    = "SESSION_TIMEZONE";
    static final String T_DATABASE_TIMEZONE   = "DATABASE_TIMEZONE";
    static final String T_DATABASE_VERSION    = "DATABASE_VERSION";
    static final String T_SESSION_ID          = "SESSION_ID";
    static final String T_LOB_ID              = "LOB_ID";
    static final String T_SEQUENCE_ARRAY      = "SEQUENCE_ARRAY";

    //
    //SQL 200n Standard reserved keywords - full set
    public static final int ABS                              = 1;
    public static final int ALL                              = 2;
    public static final int ALLOCATE                         = 3;
    public static final int ALTER                            = 4;
    public static final int AND                              = 5;
    public static final int ANY                              = 6;
    public static final int ARE                              = 7;
    public static final int ARRAY                            = 8;
    public static final int ARRAY_AGG                        = 9;
    public static final int ARRAY_MAX_CARDINALITY            = 10;
    public static final int AS                               = 11;
    public static final int ASENSITIVE                       = 12;
    public static final int ASYMMETRIC                       = 13;
    public static final int AT                               = 14;
    public static final int ATOMIC                           = 15;
    public static final int AUTHORIZATION                    = 16;
    public static final int AVG                              = 17;
    public static final int BEGIN                            = 18;
    public static final int BEGIN_FRAME                      = 19;
    public static final int BEGIN_PARTITION                  = 20;
    public static final int BETWEEN                          = 21;
    public static final int BIGINT                           = 22;
    public static final int BINARY                           = 23;
    public static final int BLOB                             = 24;
    public static final int BOOLEAN                          = 25;
    public static final int BOTH                             = 26;
    public static final int BY                               = 27;
    public static final int CALL                             = 28;
    public static final int CALLED                           = 29;
    public static final int CARDINALITY                      = 30;
    public static final int CASCADED                         = 31;
    public static final int CASE                             = 32;
    public static final int CAST                             = 33;
    public static final int CEIL                             = 34;
    public static final int CEILING                          = 35;
    public static final int CHAR                             = 36;
    public static final int CHAR_LENGTH                      = 37;
    public static final int CHARACTER                        = 38;
    public static final int CHARACTER_LENGTH                 = 39;
    public static final int CHECK                            = 40;
    public static final int CLOB                             = 41;
    public static final int CLOSE                            = 42;
    public static final int COALESCE                         = 43;
    public static final int COLLATE                          = 44;
    public static final int COLLECT                          = 45;
    public static final int COLUMN                           = 46;
    public static final int COMMIT                           = 47;
    public static final int COMPARABLE                       = 48;
    public static final int CONDITION                        = 49;
    public static final int CONNECT                          = 50;
    public static final int CONSTRAINT                       = 51;
    public static final int CONTAINS                         = 52;
    public static final int CONVERT                          = 53;
    public static final int CORR                             = 54;
    public static final int CORRESPONDING                    = 55;
    public static final int COUNT                            = 56;
    public static final int COVAR_POP                        = 57;
    public static final int COVAR_SAMP                       = 58;
    public static final int CREATE                           = 59;
    public static final int CROSS                            = 60;
    public static final int CUBE                             = 61;
    public static final int CUME_DIST                        = 62;
    public static final int CURRENT                          = 63;
    public static final int CURRENT_CATALOG                  = 64;
    public static final int CURRENT_DATE                     = 65;
    public static final int CURRENT_DEFAULT_TRANSFORM_GROUP  = 66;
    public static final int CURRENT_PATH                     = 67;
    public static final int CURRENT_ROLE                     = 68;
    public static final int CURRENT_ROW                      = 69;
    public static final int CURRENT_SCHEMA                   = 70;
    public static final int CURRENT_TIME                     = 71;
    public static final int CURRENT_TIMESTAMP                = 72;
    public static final int CURRENT_TRANSFORM_GROUP_FOR_TYPE = 73;
    public static final int CURRENT_USER                     = 74;
    public static final int CURSOR                           = 75;
    public static final int CYCLE                            = 76;
    public static final int DATE                             = 77;
    public static final int DAY                              = 78;
    public static final int DEALLOCATE                       = 79;
    public static final int DEC                              = 80;
    public static final int DECIMAL                          = 81;
    public static final int DECLARE                          = 82;
    public static final int DEFAULT                          = 83;
    public static final int DELETE                           = 84;
    public static final int DENSE_RANK                       = 85;
    public static final int DEREF                            = 86;
    public static final int DESCRIBE                         = 87;
    public static final int DETERMINISTIC                    = 88;
    public static final int DISCONNECT                       = 89;
    public static final int DISTINCT                         = 90;
    public static final int DO                               = 91;
    public static final int DOUBLE                           = 92;
    public static final int DROP                             = 93;
    public static final int DYNAMIC                          = 94;
    public static final int EACH                             = 95;
    public static final int ELEMENT                          = 96;
    public static final int ELSE                             = 97;
    public static final int ELSEIF                           = 98;
    public static final int END                              = 99;
    public static final int END_EXEC                         = 100;
    public static final int END_FRAME                        = 101;
    public static final int END_PARTITION                    = 102;
    public static final int EQUALS                           = 103;
    public static final int ESCAPE                           = 104;
    public static final int EVERY                            = 105;
    public static final int EXCEPT                           = 106;
    public static final int EXEC                             = 107;
    public static final int EXECUTE                          = 108;
    public static final int EXISTS                           = 109;
    public static final int EXIT                             = 110;
    public static final int EXP                              = 111;
    public static final int EXTERNAL                         = 112;
    public static final int EXTRACT                          = 113;
    public static final int FALSE                            = 114;
    public static final int FETCH                            = 115;
    public static final int FILTER                           = 116;
    public static final int FIRST_VALUE                      = 117;
    public static final int FLOAT                            = 118;
    public static final int FLOOR                            = 119;
    public static final int FOR                              = 120;
    public static final int FOREIGN                          = 121;
    public static final int FRAME_ROW                        = 122;
    public static final int FREE                             = 123;
    public static final int FROM                             = 124;
    public static final int FULL                             = 125;
    public static final int FUNCTION                         = 126;
    public static final int FUSION                           = 127;
    public static final int GET                              = 128;
    public static final int GLOBAL                           = 129;
    public static final int GRANT                            = 130;
    public static final int GROUP                            = 131;
    public static final int GROUPS                           = 132;
    public static final int GROUPING                         = 133;
    public static final int HANDLER                          = 134;
    public static final int HAVING                           = 135;
    public static final int HOLD                             = 136;
    public static final int HOUR                             = 137;
    public static final int IDENTITY                         = 138;
    public static final int IMPORT                           = 139;
    public static final int IN                               = 140;
    public static final int INDICATOR                        = 141;
    public static final int INNER                            = 142;
    public static final int INOUT                            = 143;
    public static final int INSENSITIVE                      = 144;
    public static final int INSERT                           = 145;
    public static final int INT                              = 146;
    public static final int INTEGER                          = 147;
    public static final int INTERSECT                        = 148;
    public static final int INTERSECTION                     = 149;
    public static final int INTERVAL                         = 150;
    public static final int INTO                             = 151;
    public static final int IS                               = 152;
    public static final int ITERATE                          = 153;
    public static final int JOIN                             = 154;
    public static final int LAG                              = 155;
    public static final int LANGUAGE                         = 156;
    public static final int LARGE                            = 157;
    public static final int LAST_VALUE                       = 158;
    public static final int LATERAL                          = 159;
    public static final int LEAD                             = 160;
    public static final int LEADING                          = 161;
    public static final int LEAVE                            = 162;
    public static final int LEFT                             = 163;
    public static final int LIKE                             = 164;
    public static final int LIKE_REGEX                       = 165;
    public static final int LN                               = 166;
    public static final int LOCAL                            = 167;
    public static final int LOCALTIME                        = 168;
    public static final int LOCALTIMESTAMP                   = 169;
    public static final int LOOP                             = 170;
    public static final int LOWER                            = 171;
    public static final int MATCH                            = 172;
    public static final int MAX                              = 173;
    public static final int MAX_CARDINALITY                  = 174;
    public static final int MEMBER                           = 175;
    public static final int MERGE                            = 176;
    public static final int METHOD                           = 177;
    public static final int MIN                              = 178;
    public static final int MINUTE                           = 179;
    public static final int MOD                              = 180;
    public static final int MODIFIES                         = 181;
    public static final int MODULE                           = 182;
    public static final int MONTH                            = 183;
    public static final int MULTISET                         = 184;
    public static final int NATIONAL                         = 185;
    public static final int NATURAL                          = 186;
    public static final int NCHAR                            = 187;
    public static final int NCLOB                            = 188;
    public static final int NEW                              = 189;
    public static final int NO                               = 190;
    public static final int NONE                             = 191;
    public static final int NORMALIZE                        = 192;
    public static final int NOT                              = 193;
    public static final int NTH_VALUE                        = 194;
    public static final int NTILE                            = 195;
    public static final int NULL                             = 196;
    public static final int NULLIF                           = 197;
    public static final int NUMERIC                          = 198;
    public static final int OCCURRENCES_REGEX                = 199;
    public static final int OCTET_LENGTH                     = 200;
    public static final int OF                               = 201;
    public static final int OFFSET                           = 202;
    public static final int OLD                              = 203;
    public static final int ON                               = 204;
    public static final int ONLY                             = 205;
    public static final int OPEN                             = 206;
    public static final int OR                               = 207;
    public static final int ORDER                            = 208;
    public static final int OUT                              = 209;
    public static final int OUTER                            = 210;
    public static final int OVER                             = 211;
    public static final int OVERLAPS                         = 212;
    public static final int OVERLAY                          = 213;
    public static final int PARAMETER                        = 214;
    public static final int PARTITION                        = 215;
    public static final int PERCENT                          = 216;
    public static final int PERCENT_RANK                     = 217;
    public static final int PERCENTILE_CONT                  = 218;
    public static final int PERCENTILE_DISC                  = 219;
    public static final int PERIOD                           = 220;
    public static final int PORTION                          = 221;
    public static final int POSITION                         = 222;
    public static final int POSITION_REGEX                   = 223;
    public static final int POWER                            = 224;
    public static final int PRECEDES                         = 225;
    public static final int PRECISION                        = 226;
    public static final int PREPARE                          = 227;
    public static final int PRIMARY                          = 228;
    public static final int PROCEDURE                        = 229;
    public static final int RANGE                            = 230;
    public static final int RANK                             = 231;
    public static final int READS                            = 232;
    public static final int REAL                             = 233;
    public static final int RECURSIVE                        = 234;
    public static final int REF                              = 235;
    public static final int REFERENCES                       = 236;
    public static final int REFERENCING                      = 237;
    public static final int REGR_AVGX                        = 238;
    public static final int REGR_AVGY                        = 239;
    public static final int REGR_COUNT                       = 240;
    public static final int REGR_INTERCEPT                   = 241;
    public static final int REGR_R2                          = 242;
    public static final int REGR_SLOPE                       = 243;
    public static final int REGR_SXX                         = 244;
    public static final int REGR_SXY                         = 245;
    public static final int REGR_SYY                         = 246;
    public static final int RELEASE                          = 247;
    public static final int REPEAT                           = 248;
    public static final int RESIGNAL                         = 249;
    public static final int RESULT                           = 250;
    public static final int RETURN                           = 251;
    public static final int RETURNS                          = 252;
    public static final int REVOKE                           = 253;
    public static final int RIGHT                            = 254;
    public static final int ROLLBACK                         = 255;
    public static final int ROLLUP                           = 256;
    public static final int ROW                              = 257;
    public static final int ROW_NUMBER                       = 258;
    public static final int ROWS                             = 259;
    public static final int SAVEPOINT                        = 260;
    public static final int SCOPE                            = 261;
    public static final int SCROLL                           = 262;
    public static final int SEARCH                           = 263;
    public static final int SECOND                           = 264;
    public static final int SELECT                           = 265;
    public static final int SENSITIVE                        = 266;
    public static final int SESSION_USER                     = 267;
    public static final int SET                              = 268;
    public static final int SIGNAL                           = 269;
    public static final int SIMILAR                          = 270;
    public static final int SMALLINT                         = 271;
    public static final int SOME                             = 272;
    public static final int SPECIFIC                         = 273;
    public static final int SPECIFICTYPE                     = 274;
    public static final int SQL                              = 275;
    public static final int SQLEXCEPTION                     = 276;
    public static final int SQLSTATE                         = 277;
    public static final int SQLWARNING                       = 278;
    public static final int SQRT                             = 279;
    public static final int STACKED                          = 280;
    public static final int START                            = 281;
    public static final int STATIC                           = 282;
    public static final int STDDEV_POP                       = 283;
    public static final int STDDEV_SAMP                      = 284;
    public static final int SUBMULTISET                      = 285;
    public static final int SUBSTRING                        = 286;
    public static final int SUBSTRING_REGEX                  = 287;
    public static final int SUCCEEDS                         = 288;
    public static final int SUM                              = 289;
    public static final int SYMMETRIC                        = 290;
    public static final int SYSTEM                           = 291;
    public static final int SYSTEM_TIME                      = 292;
    public static final int SYSTEM_USER                      = 293;
    public static final int TABLE                            = 294;
    public static final int TABLESAMPLE                      = 295;
    public static final int THEN                             = 296;
    public static final int TIME                             = 297;
    public static final int TIMESTAMP                        = 298;
    public static final int TIMEZONE_HOUR                    = 299;
    public static final int TIMEZONE_MINUTE                  = 300;
    public static final int TO                               = 301;
    public static final int TRAILING                         = 302;
    public static final int TRANSLATE                        = 303;
    public static final int TRANSLATE_REGEX                  = 304;
    public static final int TRANSLATION                      = 305;
    public static final int TREAT                            = 306;
    public static final int TRIGGER                          = 307;
    public static final int TRIM                             = 308;
    public static final int TRIM_ARRAY                       = 309;
    public static final int TRUE                             = 310;
    public static final int TRUNCATE                         = 311;
    public static final int UESCAPE                          = 312;
    public static final int UNDO                             = 313;
    public static final int UNION                            = 314;
    public static final int UNIQUE                           = 315;
    public static final int UNKNOWN                          = 316;
    public static final int UNNEST                           = 317;
    public static final int UNTIL                            = 318;
    public static final int UPDATE                           = 319;
    public static final int UPPER                            = 320;
    public static final int USER                             = 321;
    public static final int USING                            = 322;
    public static final int VALUE                            = 323;
    public static final int VALUES                           = 324;
    public static final int VAR_POP                          = 325;
    public static final int VAR_SAMP                         = 326;
    public static final int VARBINARY                        = 327;
    public static final int VARCHAR                          = 328;
    public static final int VARYING                          = 329;
    public static final int VERSIONING                       = 330;
    public static final int WHEN                             = 331;
    public static final int WHENEVER                         = 332;
    public static final int WHERE                            = 333;
    public static final int WIDTH_BUCKET                     = 334;
    public static final int WINDOW                           = 335;
    public static final int WITH                             = 336;
    public static final int WITHIN                           = 337;
    public static final int WITHOUT                          = 338;
    public static final int WHILE                            = 339;
    public static final int YEAR                             = 340;

    //
    //SQL 200n Standard non-reserved keywords - full set
    public static final int A                           = 351;
    public static final int ABSOLUTE                    = 352;
    public static final int ACTION                      = 353;
    public static final int ADA                         = 354;
    public static final int ADD                         = 355;
    public static final int ADMIN                       = 356;
    public static final int AFTER                       = 357;
    public static final int ALWAYS                      = 358;
    public static final int ASC                         = 359;
    public static final int ASSERTION                   = 360;
    public static final int ASSIGNMENT                  = 361;
    public static final int ATTRIBUTE                   = 362;
    public static final int ATTRIBUTES                  = 363;
    public static final int BEFORE                      = 364;
    public static final int BERNOULLI                   = 365;
    public static final int BREADTH                     = 366;
    public static final int C                           = 367;
    public static final int CASCADE                     = 368;
    public static final int CATALOG                     = 369;
    public static final int CATALOG_NAME                = 370;
    public static final int CHAIN                       = 371;
    public static final int CHARACTER_SET_CATALOG       = 372;
    public static final int CHARACTER_SET_NAME          = 373;
    public static final int CHARACTER_SET_SCHEMA        = 374;
    public static final int CHARACTERISTICS             = 375;
    public static final int CHARACTERS                  = 376;
    public static final int CLASS_ORIGIN                = 377;
    public static final int COBOL                       = 378;
    public static final int COLLATION                   = 379;
    public static final int COLLATION_CATALOG           = 380;
    public static final int COLLATION_NAME              = 381;
    public static final int COLLATION_SCHEMA            = 382;
    public static final int COLUMN_NAME                 = 383;
    public static final int COMMAND_FUNCTION            = 384;
    public static final int COMMAND_FUNCTION_CODE       = 385;
    public static final int COMMITTED                   = 386;
    public static final int CONDITION_IDENTIFIER        = 387;
    public static final int CONDITION_NUMBER            = 388;
    public static final int CONNECTION                  = 389;
    public static final int CONNECTION_NAME             = 390;
    public static final int CONSTRAINT_CATALOG          = 391;
    public static final int CONSTRAINT_NAME             = 392;
    public static final int CONSTRAINT_SCHEMA           = 393;
    public static final int CONSTRAINTS                 = 394;
    public static final int CONSTRUCTOR                 = 395;
    public static final int XCONTAINS                   = 396;
    public static final int CONTINUE                    = 397;
    public static final int CURSOR_NAME                 = 398;
    public static final int DATA                        = 399;
    public static final int DATETIME_INTERVAL_CODE      = 400;
    public static final int DATETIME_INTERVAL_PRECISION = 401;
    public static final int DEFAULTS                    = 402;
    public static final int DEFERRABLE                  = 403;
    public static final int DEFERRED                    = 404;
    public static final int DEFINED                     = 405;
    public static final int DEFINER                     = 406;
    public static final int DEGREE                      = 407;
    public static final int DEPTH                       = 408;
    public static final int DERIVED                     = 409;
    public static final int DESC                        = 410;
    public static final int DESCRIPTOR                  = 411;
    public static final int DIAGNOSTICS                 = 412;
    public static final int DISPATCH                    = 413;
    public static final int DOMAIN                      = 414;
    public static final int DYNAMIC_FUNCTION            = 415;
    public static final int DYNAMIC_FUNCTION_CODE       = 416;
    public static final int EQUALS_OP                   = 417;
    public static final int EXCEPTION                   = 418;
    public static final int EXCLUDE                     = 419;
    public static final int EXCLUDING                   = 420;
    public static final int EXPRESSION                  = 421;
    public static final int FINAL                       = 422;
    public static final int FIRST                       = 423;
    public static final int FOLLOWING                   = 424;
    public static final int FORTRAN                     = 425;
    public static final int FOUND                       = 426;
    public static final int G                           = 427;
    public static final int GENERAL                     = 428;
    public static final int GENERATED                   = 429;
    public static final int GO                          = 430;
    public static final int GOTO                        = 431;
    public static final int GRANTED                     = 432;
    public static final int HIERARCHY                   = 433;
    public static final int IF                          = 434;
    public static final int IGNORE                      = 435;
    public static final int IMMEDIATE                   = 436;
    public static final int IMPLEMENTATION              = 437;
    public static final int INCLUDING                   = 438;
    public static final int INCREMENT                   = 439;
    public static final int INITIALLY                   = 440;
    public static final int INPUT                       = 441;
    public static final int INSTANCE                    = 442;
    public static final int INSTANTIABLE                = 443;
    public static final int INSTEAD                     = 444;
    public static final int INVOKER                     = 445;
    public static final int ISOLATION                   = 446;
    public static final int JAVA                        = 447;
    public static final int K                           = 448;
    public static final int KEY                         = 449;
    public static final int KEY_MEMBER                  = 450;
    public static final int KEY_TYPE                    = 451;
    public static final int LAST                        = 452;
    public static final int LENGTH                      = 453;
    public static final int LEVEL                       = 454;
    public static final int LIBRARY                     = 455;
    public static final int LOCATOR                     = 456;
    public static final int M                           = 457;
    public static final int MAP                         = 458;
    public static final int MATCHED                     = 459;
    public static final int MAXVALUE                    = 460;
    public static final int MESSAGE_LENGTH              = 461;
    public static final int MESSAGE_OCTET_LENGTH        = 462;
    public static final int MESSAGE_TEXT                = 463;
    public static final int MINVALUE                    = 464;
    public static final int MORE                        = 465;
    public static final int MUMPS                       = 466;
    public static final int NAME                        = 467;
    public static final int NAMES                       = 468;
    public static final int NESTING                     = 469;
    public static final int NEXT                        = 470;
    public static final int NORMALIZED                  = 471;
    public static final int NULLABLE                    = 472;
    public static final int NULLS                       = 473;
    public static final int NUMBER                      = 474;
    public static final int OBJECT                      = 475;
    public static final int OCTETS                      = 476;
    public static final int OPTION                      = 477;
    public static final int OPTIONS                     = 478;
    public static final int ORDERING                    = 479;
    public static final int ORDINALITY                  = 480;
    public static final int OTHERS                      = 481;
    public static final int OUTPUT                      = 482;
    public static final int OVERRIDING                  = 483;
    public static final int P                           = 484;
    public static final int PAD                         = 485;
    public static final int PARAMETER_MODE              = 486;
    public static final int PARAMETER_NAME              = 487;
    public static final int PARAMETER_ORDINAL_POSITION  = 488;
    public static final int PARAMETER_SPECIFIC_CATALOG  = 489;
    public static final int PARAMETER_SPECIFIC_NAME     = 490;
    public static final int PARAMETER_SPECIFIC_SCHEMA   = 491;
    public static final int PARTIAL                     = 492;
    public static final int PASCAL                      = 493;
    public static final int PATH                        = 494;
    public static final int PLACING                     = 495;
    public static final int PLI                         = 496;
    public static final int PRECEDING                   = 497;
    public static final int PRESERVE                    = 498;
    public static final int PRIOR                       = 499;
    public static final int PRIVILEGES                  = 500;
    public static final int PUBLIC                      = 501;
    public static final int READ                        = 502;
    public static final int RELATIVE                    = 503;
    public static final int REPEATABLE                  = 504;
    public static final int RESPECT                     = 505;
    public static final int RESTART                     = 506;
    public static final int RESTRICT                    = 507;
    public static final int RETURNED_CARDINALITY        = 508;
    public static final int RETURNED_LENGTH             = 509;
    public static final int RETURNED_OCTET_LENGTH       = 510;
    public static final int RETURNED_SQLSTATE           = 511;
    public static final int ROLE                        = 512;
    public static final int ROUTINE                     = 513;
    public static final int ROUTINE_CATALOG             = 514;
    public static final int ROUTINE_NAME                = 515;
    public static final int ROUTINE_SCHEMA              = 516;
    public static final int ROW_COUNT                   = 517;
    public static final int SCALE                       = 518;
    public static final int SCHEMA                      = 519;
    public static final int SCHEMA_NAME                 = 520;
    public static final int SCOPE_CATALOG               = 521;
    public static final int SCOPE_NAME                  = 522;
    public static final int SCOPE_SCHEMA                = 523;
    public static final int SECTION                     = 524;
    public static final int SECURITY                    = 525;
    public static final int SELF                        = 526;
    public static final int SEQUENCE                    = 527;
    public static final int SERIALIZABLE                = 528;
    public static final int SERVER_NAME                 = 529;
    public static final int SESSION                     = 530;
    public static final int SERVER                      = 531;
    public static final int SETS                        = 532;
    public static final int SIMPLE                      = 533;
    public static final int SIZE                        = 534;
    public static final int SOURCE                      = 535;
    public static final int SPACE                       = 536;
    public static final int SPECIFIC_NAME               = 537;
    public static final int STATE                       = 538;
    public static final int STATEMENT                   = 539;
    public static final int STRUCTURE                   = 540;
    public static final int STYLE                       = 541;
    public static final int SUBCLASS_ORIGIN             = 542;
    public static final int T                           = 543;
    public static final int TABLE_NAME                  = 544;
    public static final int TEMPORARY                   = 545;
    public static final int TIES                        = 546;
    public static final int TOP_LEVEL_COUNT             = 547;
    public static final int TRANSACTION                 = 548;
    public static final int TRANSACTION_ACTIVE          = 549;
    public static final int TRANSACTIONS_COMMITTED      = 550;
    public static final int TRANSACTIONS_ROLLED_BACK    = 551;
    public static final int TRANSFORM                   = 552;
    public static final int TRANSFORMS                  = 553;
    public static final int TRIGGER_CATALOG             = 554;
    public static final int TRIGGER_NAME                = 555;
    public static final int TRIGGER_SCHEMA              = 556;
    public static final int TYPE                        = 557;
    public static final int UNBOUNDED                   = 558;
    public static final int UNCOMMITTED                 = 559;
    public static final int UNDER                       = 560;
    public static final int UNNAMED                     = 561;
    public static final int USAGE                       = 562;
    public static final int USER_DEFINED_TYPE_CATALOG   = 563;
    public static final int USER_DEFINED_TYPE_CODE      = 564;
    public static final int USER_DEFINED_TYPE_NAME      = 565;
    public static final int USER_DEFINED_TYPE_SCHEMA    = 566;
    public static final int VIEW                        = 567;
    public static final int WORK                        = 568;
    public static final int WRITE                       = 569;
    public static final int WRAPPER                     = 570;
    public static final int ZONE                        = 571;

    // other token values used as switch cases
    static final int ALIAS          = 581;
    static final int AGGREGATE      = 582;
    static final int AUTOCOMMIT     = 583;
    static final int AUTHENTICATION = 584;
    static final int BACKUP         = 585;
    static final int BINARY_FLOAT   = 586;
    static final int BINARY_DOUBLE  = 587;
    static final int BIT            = 588;
    static final int BLOCKING       = 589;
    static final int BODY           = 590;
    static final int BYTE           = 591;
    static final int CACHE          = 592;
    static final int CACHED         = 593;
    static final int CASEWHEN       = 594;
    static final int CHECKPOINT     = 595;
    static final int CITEXT         = 596;
    static final int CLASS          = 597;
    static final int CLUSTERED      = 598;
    static final int COMMENT        = 599;
    static final int COMPACT        = 600;
    static final int COMPRESSED     = 601;
    static final int CONFLICT       = 602;
    static final int CONTROL        = 603;
    static final int CURRVAL        = 604;
    static final int DATABASE       = 605;
    static final int DEADLOCK       = 606;
    static final int DEFRAG         = 607;
    static final int DELAY          = 608;
    static final int DIGEST         = 609;
    static final int ENUM           = 610;
    static final int EVENT          = 611;
    static final int EXPLAIN        = 612;
    static final int FEATURE        = 613;
    static final int FILE           = 614;
    static final int FILES          = 615;
    static final int FORMAT         = 616;
    static final int GC             = 617;
    static final int HEADER         = 618;
    static final int IGNORECASE     = 619;
    static final int IMMEDIATELY    = 620;
    static final int INTEGRITY      = 621;
    static final int INDEX          = 622;
    static final int INDEXER        = 623;
    static final int INITIAL        = 624;
    static final int LASTVAL        = 625;
    static final int LIMIT          = 626;
    static final int LITERAL        = 627;
    static final int LIVE           = 628;
    static final int LOAD           = 629;
    static final int LOCK           = 630;
    static final int LOCKS          = 631;
    static final int LONG           = 632;
    static final int LONGVAR        = 633;
    static final int MAXROWS        = 634;
    static final int MEDIAN         = 635;
    static final int MEMORY         = 636;
    static final int MILLIS         = 637;
    static final int MINUS_EXCEPT   = 638;
    static final int NAN            = 639;
    static final int NEXTVAL        = 640;
    static final int NOWAIT         = 641;
    static final int NVARCHAR2      = 642;
    static final int NVL2           = 643;
    static final int OFF            = 644;
    static final int PASSWORD       = 645;
    static final int PERFORM        = 646;
    static final int PLAN           = 647;
    static final int PREVVAL        = 648;
    static final int PROPERTY       = 649;
    static final int RAW            = 650;
    static final int READONLY       = 651;
    static final int REFERENTIAL    = 652;
    static final int REGULAR        = 653;
    static final int RENAME         = 654;
    static final int RESET          = 655;
    static final int ROWNUM         = 656;
    static final int SCRIPT         = 657;
    static final int SEPARATOR      = 658;
    static final int SHUTDOWN       = 659;
    static final int SYNONYM        = 660;
    static final int SYNTAX         = 661;
    static final int TDC            = 662;
    static final int TEMP           = 663;
    static final int TEXT           = 664;
    static final int TOP            = 665;
    static final int TTI            = 666;
    static final int TYPES          = 667;
    static final int USE            = 668;
    static final int VARCHAR2       = 669;
    static final int WRITE_DELAY    = 670;

    //
    static final int        ACOS                       = 701;
    static final int        ACTION_ID                  = 702;
    static final int        ARRAY_SORT                 = 703;
    static final int        ASCII                      = 704;
    static final int        ADD_MONTHS                 = 705;
    static final int        ASIN                       = 706;
    static final int        ATAN                       = 707;
    static final int        ATAN2                      = 708;
    static final int        BIT_LENGTH                 = 709;
    static final int        BITAND                     = 710;
    static final int        BITANDNOT                  = 711;
    static final int        BITLENGTH                  = 712;
    static final int        BITNOT                     = 713;
    static final int        BITOR                      = 714;
    static final int        BITXOR                     = 715;
    static final int        CHR                        = 716;
    static final int        CONCAT_WORD                = 717;
    static final int        CONCAT_WS                  = 718;
    static final int        COS                        = 719;
    static final int        COSH                       = 720;
    static final int        COT                        = 721;
    static final int        CRYPT_KEY                  = 722;
    static final int        CURDATE                    = 723;
    static final int        CURTIME                    = 724;
    static final int        DATABASE_ISOLATION_LEVEL   = 725;
    static final int        DATABASE_NAME              = 726;
    static final int        DATABASE_TIMEZONE          = 727;
    static final int        DATABASE_VERSION           = 728;
    static final int        DATE_ADD                   = 729;
    static final int        DATE_SUB                   = 730;
    static final int        DATEADD                    = 731;
    static final int        DATEDIFF                   = 732;
    public static final int DAY_NAME                   = 733;
    public static final int DAY_OF_MONTH               = 734;
    public static final int DAY_OF_WEEK                = 735;
    public static final int DAY_OF_YEAR                = 736;
    static final int        DAYNAME                    = 737;
    static final int        DAYOFMONTH                 = 738;
    static final int        DAYOFWEEK                  = 739;
    static final int        DAYOFYEAR                  = 740;
    static final int        DAYS                       = 741;
    static final int        DBTIMEZONE                 = 742;
    static final int        DECODE                     = 743;
    static final int        DEGREES                    = 744;
    static final int        DIFFERENCE                 = 745;
    static final int        DMOD                       = 746;
    static final int        FROM_TZ                    = 747;
    static final int        HEXTORAW                   = 748;
    static final int        GREATEST                   = 749;
    static final int        GROUP_CONCAT               = 750;
    static final int        IFNULL                     = 751;
    static final int        INSTR                      = 752;
    static final int        IS_AUTOCOMMIT              = 753;
    static final int        IS_READONLY_DATABASE       = 754;
    static final int        IS_READONLY_DATABASE_FILES = 755;
    static final int        IS_READONLY_SESSION        = 756;
    static final int        ISOLATION_LEVEL            = 757;
    static final int        ISNULL                     = 758;
    static final int        LAST_DAY                   = 759;
    static final int        LCASE                      = 760;
    static final int        LEAST                      = 761;
    static final int        LOAD_FILE                  = 762;
    static final int        LOCATE                     = 763;
    static final int        LOB                        = 764;
    static final int        LOG                        = 765;
    static final int        LOG10                      = 766;
    static final int        LPAD                       = 767;
    static final int        LTRIM                      = 768;
    static final int        LOB_ID                     = 769;
    public static final int MONTH_NAME                 = 770;
    static final int        MONTHNAME                  = 771;
    static final int        MONTHS_BETWEEN             = 772;
    static final int        MVCC                       = 773;
    static final int        MVLOCKS                    = 774;
    static final int        NEW_TIME                   = 775;
    static final int        NEXT_DAY                   = 776;
    static final int        NIO                        = 777;
    static final int        NOW                        = 778;
    static final int        NUMTODSINTERVAL            = 779;
    static final int        NUMTOYMINTERVAL            = 780;
    static final int        OCTETLENGTH                = 781;
    static final int        PI                         = 782;
    static final int        POSITION_ARRAY             = 783;
    public static final int QUARTER                    = 784;
    static final int        RADIANS                    = 785;
    static final int        RAND                       = 786;
    static final int        RAWTOHEX                   = 787;
    static final int        REGEXP_MATCHES             = 788;
    static final int        REGEXP_REPLACE             = 789;
    static final int        REGEXP_SUBSTRING           = 790;
    static final int        REGEXP_SUBSTRING_ARRAY     = 791;
    static final int        REPLACE                    = 792;
    static final int        REVERSE                    = 793;
    static final int        ROUND                      = 794;
    static final int        ROUNDMAGIC                 = 795;
    static final int        RTRIM                      = 796;
    static final int        RPAD                       = 797;
    public static final int SECONDS_MIDNIGHT           = 798;
    static final int        SEQUENCE_ARRAY             = 799;
    static final int        SESSION_ID                 = 800;
    static final int        SESSION_ISOLATION_LEVEL    = 801;
    static final int        SESSION_TIMEZONE           = 802;
    static final int        SESSIONTIMEZONE            = 803;
    static final int        SIGN                       = 804;
    static final int        SIN                        = 805;
    static final int        SINH                       = 806;
    static final int        SORT_ARRAY                 = 807;
    static final int        SOUNDEX                    = 808;
    static final int        SPACE_WORD                 = 809;
    static final int        SUBSTR                     = 810;
    static final int        SYS                        = 811;
    static final int        SYS_EXTRACT_UTC            = 812;
    static final int        SYSDATE                    = 813;
    static final int        SYSTIMESTAMP               = 814;
    static final int        TAN                        = 815;
    static final int        TANH                       = 816;
    static final int        TIMESTAMP_WITH_ZONE        = 817;
    static final int        TIMESTAMPADD               = 818;
    static final int        TIMESTAMPDIFF              = 819;
    public static final int TIMEZONE                   = 820;
    static final int        TO_CHAR                    = 821;
    static final int        TO_DATE                    = 822;
    static final int        TO_DSINTERVAL              = 823;
    static final int        TO_YMINTERVAL              = 824;
    static final int        TO_NUMBER                  = 825;
    static final int        TO_TIMESTAMP               = 826;
    static final int        TO_TIMESTAMP_TZ            = 827;
    static final int        TODAY                      = 828;
    static final int        TRANSACTION_CONTROL        = 829;
    static final int        TRANSACTION_ID             = 830;
    static final int        TRANSACTION_SIZE           = 831;
    static final int        TRUNC                      = 832;
    static final int        TZ_OFFSET                  = 833;
    static final int        UCASE                      = 834;
    static final int        UNIX_MILLIS                = 835;
    static final int        UNIX_TIMESTAMP             = 836;
    static final int        UUID                       = 837;
    static final int        WEEK                       = 838;
    public static final int WEEK_OF_YEAR               = 839;
    static final int        LONGBLOB                   = 840;
    static final int        LONGTEXT                   = 841;
    static final int        MEDIUMBLOB                 = 842;
    static final int        MEDIUMTEXT                 = 843;
    static final int        TINYBLOB                   = 844;
    static final int        TINYTEXT                   = 845;
    static final int        DUPLICATE                  = 846;
    static final int        DATETIMEOFFSET             = 847;
    static final int        DATENAME                   = 848;
    static final int        DATEPART                   = 849;
    static final int        EOMONTH                    = 850;
    static final int        NEWID                      = 851;
    static final int        NANVL                      = 852;
    static final int        SYS_GUID                   = 853;

    //
    public static final int MICROSECOND = 871;
    public static final int MILLISECOND = 872;
    public static final int NANOSECOND  = 873;

    //
    static final int        ASTERISK         = 921;
    static final int        CLOSEBRACKET     = 922;
    static final int        COLON            = 923;
    static final int        COMMA            = 924;
    static final int        CONCAT_OP        = 925;
    static final int        DIVIDE_OP        = 926;
    static final int        DOUBLE_COLON_OP  = 927;
    static final int        DOUBLE_PERIOD_OP = 928;
    static final int        GREATER_OP       = 929;
    static final int        GREATER_EQUALS   = 930;
    static final int        LEFTBRACKET      = 931;
    static final int        LESS_OP          = 932;
    static final int        LESS_EQUALS      = 933;
    public static final int MINUS_OP         = 934;
    static final int        NOT_EQUALS       = 935;
    static final int        OPENBRACKET      = 936;
    static final int        PLUS_OP          = 937;
    static final int        QUESTION         = 938;
    static final int        RIGHT_ARROW_OP   = 939;
    static final int        RIGHTBRACKET     = 940;
    static final int        SEMICOLON        = 941;

    //
    public static final int SQL_BIGINT        = 951;
    public static final int SQL_BINARY        = 952;
    public static final int SQL_BIT           = 953;
    public static final int SQL_BLOB          = 954;
    public static final int SQL_BOOLEAN       = 955;
    public static final int SQL_CHAR          = 956;
    public static final int SQL_CLOB          = 957;
    public static final int SQL_DATE          = 958;
    public static final int SQL_DECIMAL       = 959;
    public static final int SQL_DATALINK      = 960;
    public static final int SQL_DOUBLE        = 961;
    public static final int SQL_FLOAT         = 962;
    public static final int SQL_INTEGER       = 963;
    public static final int SQL_LONGVARBINARY = 964;
    public static final int SQL_LONGNVARCHAR  = 965;
    public static final int SQL_LONGVARCHAR   = 966;
    public static final int SQL_NCHAR         = 967;
    public static final int SQL_NCLOB         = 968;
    public static final int SQL_NUMERIC       = 969;
    public static final int SQL_NVARCHAR      = 970;
    public static final int SQL_REAL          = 971;
    public static final int SQL_ROWID         = 972;
    public static final int SQL_SQLXML        = 973;
    public static final int SQL_SMALLINT      = 974;
    public static final int SQL_TIME          = 975;
    public static final int SQL_TIMESTAMP     = 976;
    public static final int SQL_TINYINT       = 977;
    public static final int SQL_VARBINARY     = 978;
    public static final int SQL_VARCHAR       = 979;

    //
    static final int SQL_TSI_FRAC_SECOND  = 981;
    static final int SQL_TSI_MILLI_SECOND = 982;
    static final int SQL_TSI_MICRO_SECOND = 983;
    static final int SQL_TSI_SECOND       = 984;
    static final int SQL_TSI_MINUTE       = 985;
    static final int SQL_TSI_HOUR         = 986;
    static final int SQL_TSI_DAY          = 987;
    static final int SQL_TSI_WEEK         = 988;
    static final int SQL_TSI_MONTH        = 989;
    static final int SQL_TSI_QUARTER      = 990;
    static final int SQL_TSI_YEAR         = 991;

    //
    static final int X_KEYSET      = 1001;
    static final int X_OPTION      = 1002;
    static final int X_REPEAT      = 1003;
    static final int X_POS_INTEGER = 1004;
    static final int X_TOKEN       = 1005;

    //
    public static final int X_VALUE                    = 1011;
    public static final int X_IDENTIFIER               = 1012;
    public static final int X_DELIMITED_IDENTIFIER     = 1013;
    public static final int X_ENDPARSE                 = 1014;
    public static final int X_STARTPARSE               = 1015;
    public static final int X_REMARK                   = 1016;
    public static final int X_NULL                     = 1017;
    public static final int X_LOB_SIZE                 = 1018;
    public static final int X_MALFORMED_STRING         = 1019;
    public static final int X_MALFORMED_NUMERIC        = 1020;
    public static final int X_MALFORMED_BIT_STRING     = 1021;
    public static final int X_MALFORMED_BINARY_STRING  = 1022;
    public static final int X_MALFORMED_UNICODE_STRING = 1023;
    public static final int X_MALFORMED_COMMENT        = 1024;
    public static final int X_MALFORMED_IDENTIFIER     = 1025;
    public static final int X_MALFORMED_UNICODE_ESCAPE = 1026;

    //
    public static final int X_UNKNOWN_TOKEN = -1;
    private static final IntValueHashMap reservedKeys =
        new IntValueHashMap(351);

    static {
        reservedKeys.put(T_ABS, ABS);
        reservedKeys.put(T_ALL, ALL);
        reservedKeys.put(T_ALLOCATE, ALLOCATE);
        reservedKeys.put(T_ALTER, ALTER);
        reservedKeys.put(T_AND, AND);
        reservedKeys.put(T_ANY, ANY);
        reservedKeys.put(T_ARE, ARE);
        reservedKeys.put(T_ARRAY, ARRAY);
        reservedKeys.put(T_ARRAY_AGG, ARRAY_AGG);
        reservedKeys.put(T_ARRAY_MAX_CARDINALITY, ARRAY_MAX_CARDINALITY);
        reservedKeys.put(T_AS, AS);
        reservedKeys.put(T_ASENSITIVE, ASENSITIVE);
        reservedKeys.put(T_ASYMMETRIC, ASYMMETRIC);
        reservedKeys.put(T_AT, AT);
        reservedKeys.put(T_ATOMIC, ATOMIC);
        reservedKeys.put(T_AUTHORIZATION, AUTHORIZATION);
        reservedKeys.put(T_AVG, AVG);
        reservedKeys.put(T_BEGIN, BEGIN);
        reservedKeys.put(T_BEGIN_FRAME, BEGIN_FRAME);
        reservedKeys.put(T_BEGIN_PARTITION, BEGIN_PARTITION);
        reservedKeys.put(T_BETWEEN, BETWEEN);
        reservedKeys.put(T_BIGINT, BIGINT);
        reservedKeys.put(T_BINARY, BINARY);
        reservedKeys.put(T_BIT_LENGTH, BIT_LENGTH);
        reservedKeys.put(T_BLOB, BLOB);
        reservedKeys.put(T_BOOLEAN, BOOLEAN);
        reservedKeys.put(T_BOTH, BOTH);
        reservedKeys.put(T_BY, BY);
        reservedKeys.put(T_CALL, CALL);
        reservedKeys.put(T_CALLED, CALLED);
        reservedKeys.put(T_CARDINALITY, CARDINALITY);
        reservedKeys.put(T_CASCADED, CASCADED);
        reservedKeys.put(T_CASE, CASE);
        reservedKeys.put(T_CAST, CAST);
        reservedKeys.put(T_CEIL, CEIL);
        reservedKeys.put(T_CEILING, CEILING);
        reservedKeys.put(T_CHAR, CHAR);
        reservedKeys.put(T_CHAR_LENGTH, CHAR_LENGTH);
        reservedKeys.put(T_CHARACTER, CHARACTER);
        reservedKeys.put(T_CHARACTER_LENGTH, CHARACTER_LENGTH);
        reservedKeys.put(T_CHECK, CHECK);
        reservedKeys.put(T_CLOB, CLOB);
        reservedKeys.put(T_CLOSE, CLOSE);
        reservedKeys.put(T_COALESCE, COALESCE);
        reservedKeys.put(T_COLLATE, COLLATE);
        reservedKeys.put(T_COLLECT, COLLECT);
        reservedKeys.put(T_COLUMN, COLUMN);
        reservedKeys.put(T_COMMIT, COMMIT);
        reservedKeys.put(T_COMPARABLE, COMPARABLE);
        reservedKeys.put(T_CONDITION, CONDITION);
        reservedKeys.put(T_CONNECT, CONNECT);
        reservedKeys.put(T_CONSTRAINT, CONSTRAINT);
        reservedKeys.put(T_CONTAINS, CONTAINS);
        reservedKeys.put(T_CONVERT, CONVERT);
        reservedKeys.put(T_CORR, CORR);
        reservedKeys.put(T_CORRESPONDING, CORRESPONDING);
        reservedKeys.put(T_COUNT, COUNT);
        reservedKeys.put(T_COVAR_POP, COVAR_POP);
        reservedKeys.put(T_COVAR_SAMP, COVAR_SAMP);
        reservedKeys.put(T_CREATE, CREATE);
        reservedKeys.put(T_CROSS, CROSS);
        reservedKeys.put(T_CUBE, CUBE);
        reservedKeys.put(T_CUME_DIST, CUME_DIST);
        reservedKeys.put(T_CURRENT, CURRENT);
        reservedKeys.put(T_CURRENT_CATALOG, CURRENT_CATALOG);
        reservedKeys.put(T_CURRENT_DATE, CURRENT_DATE);
        reservedKeys.put(T_CURRENT_DEFAULT_TRANSFORM_GROUP,
                         CURRENT_DEFAULT_TRANSFORM_GROUP);
        reservedKeys.put(T_CURRENT_PATH, CURRENT_PATH);
        reservedKeys.put(T_CURRENT_ROLE, CURRENT_ROLE);
        reservedKeys.put(T_CURRENT_SCHEMA, CURRENT_SCHEMA);
        reservedKeys.put(T_CURRENT_TIME, CURRENT_TIME);
        reservedKeys.put(T_CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
        reservedKeys.put(T_DO, DO);
        reservedKeys.put(T_CURRENT_TRANSFORM_GROUP_FOR_TYPE,
                         CURRENT_TRANSFORM_GROUP_FOR_TYPE);
        reservedKeys.put(T_CURRENT_USER, CURRENT_USER);
        reservedKeys.put(T_CURSOR, CURSOR);
        reservedKeys.put(T_CYCLE, CYCLE);
        reservedKeys.put(T_DATE, DATE);
        reservedKeys.put(T_DAY, DAY);
        reservedKeys.put(T_DEALLOCATE, DEALLOCATE);
        reservedKeys.put(T_DEC, DEC);
        reservedKeys.put(T_DECIMAL, DECIMAL);
        reservedKeys.put(T_DECLARE, DECLARE);
        reservedKeys.put(T_DEFAULT, DEFAULT);
        reservedKeys.put(T_DELETE, DELETE);
        reservedKeys.put(T_DENSE_RANK, DENSE_RANK);
        reservedKeys.put(T_DEREF, DEREF);
        reservedKeys.put(T_DESCRIBE, DESCRIBE);
        reservedKeys.put(T_DETERMINISTIC, DETERMINISTIC);
        reservedKeys.put(T_DISCONNECT, DISCONNECT);
        reservedKeys.put(T_DISTINCT, DISTINCT);
        reservedKeys.put(T_DOUBLE, DOUBLE);
        reservedKeys.put(T_DROP, DROP);
        reservedKeys.put(T_DYNAMIC, DYNAMIC);
        reservedKeys.put(T_EACH, EACH);
        reservedKeys.put(T_ELEMENT, ELEMENT);
        reservedKeys.put(T_ELSE, ELSE);
        reservedKeys.put(T_ELSEIF, ELSEIF);
        reservedKeys.put(T_END, END);
        reservedKeys.put(T_END_FRAME, END_FRAME);
        reservedKeys.put(T_END_PARTITION, END_PARTITION);
        reservedKeys.put(T_END_EXEC, END_EXEC);
        reservedKeys.put(T_EQUALS, EQUALS);
        reservedKeys.put(T_ESCAPE, ESCAPE);
        reservedKeys.put(T_EVERY, EVERY);
        reservedKeys.put(T_EXCEPT, EXCEPT);
        reservedKeys.put(T_EXEC, EXEC);
        reservedKeys.put(T_EXECUTE, EXECUTE);
        reservedKeys.put(T_EXISTS, EXISTS);
        reservedKeys.put(T_EXIT, EXIT);
        reservedKeys.put(T_EXP, EXP);
        reservedKeys.put(T_EXTERNAL, EXTERNAL);
        reservedKeys.put(T_EXTRACT, EXTRACT);
        reservedKeys.put(T_FALSE, FALSE);
        reservedKeys.put(T_FETCH, FETCH);
        reservedKeys.put(T_FILTER, FILTER);
        reservedKeys.put(T_FIRST_VALUE, FIRST_VALUE);
        reservedKeys.put(T_FLOAT, FLOAT);
        reservedKeys.put(T_FLOOR, FLOOR);
        reservedKeys.put(T_FOR, FOR);
        reservedKeys.put(T_FOREIGN, FOREIGN);
        reservedKeys.put(T_FRAME_ROW, FRAME_ROW);
        reservedKeys.put(T_FREE, FREE);
        reservedKeys.put(T_FROM, FROM);
        reservedKeys.put(T_FULL, FULL);
        reservedKeys.put(T_FUNCTION, FUNCTION);
        reservedKeys.put(T_FUSION, FUSION);
        reservedKeys.put(T_GET, GET);
        reservedKeys.put(T_GLOBAL, GLOBAL);
        reservedKeys.put(T_GRANT, GRANT);
        reservedKeys.put(T_GROUP, GROUP);
        reservedKeys.put(T_GROUPING, GROUPING);
        reservedKeys.put(T_HANDLER, HANDLER);
        reservedKeys.put(T_HAVING, HAVING);
        reservedKeys.put(T_HOLD, HOLD);
        reservedKeys.put(T_HOUR, HOUR);
        reservedKeys.put(T_IDENTITY, IDENTITY);
        reservedKeys.put(T_IF, IF);
        reservedKeys.put(T_IMPORT, IMPORT);
        reservedKeys.put(T_IN, IN);
        reservedKeys.put(T_INDICATOR, INDICATOR);
        reservedKeys.put(T_INNER, INNER);
        reservedKeys.put(T_INOUT, INOUT);
        reservedKeys.put(T_INSENSITIVE, INSENSITIVE);
        reservedKeys.put(T_INSERT, INSERT);
        reservedKeys.put(T_INT, INT);
        reservedKeys.put(T_INTEGER, INTEGER);
        reservedKeys.put(T_INTERSECT, INTERSECT);
        reservedKeys.put(T_INTERSECTION, INTERSECTION);
        reservedKeys.put(T_INTERVAL, INTERVAL);
        reservedKeys.put(T_INTO, INTO);
        reservedKeys.put(T_IS, IS);
        reservedKeys.put(T_ITERATE, ITERATE);
        reservedKeys.put(T_JOIN, JOIN);
        reservedKeys.put(T_LAG, LAG);
        reservedKeys.put(T_LANGUAGE, LANGUAGE);
        reservedKeys.put(T_LARGE, LARGE);
        reservedKeys.put(T_LAST_VALUE, LAST_VALUE);
        reservedKeys.put(T_LATERAL, LATERAL);
        reservedKeys.put(T_LEAD, LEAD);
        reservedKeys.put(T_LEADING, LEADING);
        reservedKeys.put(T_LEAVE, LEAVE);
        reservedKeys.put(T_LEFT, LEFT);
        reservedKeys.put(T_LIKE, LIKE);
        reservedKeys.put(T_LIKE_REGX, LIKE_REGEX);
        reservedKeys.put(T_LN, LN);
        reservedKeys.put(T_LOCAL, LOCAL);
        reservedKeys.put(T_LOCALTIME, LOCALTIME);
        reservedKeys.put(T_LOCALTIMESTAMP, LOCALTIMESTAMP);
        reservedKeys.put(T_LOOP, LOOP);
        reservedKeys.put(T_LOWER, LOWER);
        reservedKeys.put(T_MATCH, MATCH);
        reservedKeys.put(T_MAX, MAX);
        reservedKeys.put(T_MAX_CARDINALITY, MAX_CARDINALITY);
        reservedKeys.put(T_MEMBER, MEMBER);
        reservedKeys.put(T_MERGE, MERGE);
        reservedKeys.put(T_METHOD, METHOD);
        reservedKeys.put(T_MIN, MIN);
        reservedKeys.put(T_MINUTE, MINUTE);
        reservedKeys.put(T_MOD, MOD);
        reservedKeys.put(T_MODIFIES, MODIFIES);
        reservedKeys.put(T_MODULE, MODULE);
        reservedKeys.put(T_MONTH, MONTH);
        reservedKeys.put(T_MULTISET, MULTISET);
        reservedKeys.put(T_NATIONAL, NATIONAL);
        reservedKeys.put(T_NATURAL, NATURAL);
        reservedKeys.put(T_NCHAR, NCHAR);
        reservedKeys.put(T_NCLOB, NCLOB);
        reservedKeys.put(T_NEW, NEW);
        reservedKeys.put(T_NO, NO);
        reservedKeys.put(T_NONE, NONE);
        reservedKeys.put(T_NORMALIZE, NORMALIZE);
        reservedKeys.put(T_NOT, NOT);
        reservedKeys.put(T_NTH_VALUE, NTH_VALUE);
        reservedKeys.put(T_NTILE, NTILE);
        reservedKeys.put(T_NULL, NULL);
        reservedKeys.put(T_NULLIF, NULLIF);
        reservedKeys.put(T_NUMERIC, NUMERIC);
        reservedKeys.put(T_OCCURRENCES_REGEX, OCCURRENCES_REGEX);
        reservedKeys.put(T_OCTET_LENGTH, OCTET_LENGTH);
        reservedKeys.put(T_OF, OF);
        reservedKeys.put(T_OFFSET, OFFSET);
        reservedKeys.put(T_OLD, OLD);
        reservedKeys.put(T_ON, ON);
        reservedKeys.put(T_ONLY, ONLY);
        reservedKeys.put(T_OPEN, OPEN);
        reservedKeys.put(T_OR, OR);
        reservedKeys.put(T_ORDER, ORDER);
        reservedKeys.put(T_OUT, OUT);
        reservedKeys.put(T_OUTER, OUTER);
        reservedKeys.put(T_OVER, OVER);
        reservedKeys.put(T_OVERLAPS, OVERLAPS);
        reservedKeys.put(T_OVERLAY, OVERLAY);
        reservedKeys.put(T_PARAMETER, PARAMETER);
        reservedKeys.put(T_PARTITION, PARTITION);
        reservedKeys.put(T_PERCENT_RANK, PERCENT_RANK);
        reservedKeys.put(T_PERCENTILE_CONT, PERCENTILE_CONT);
        reservedKeys.put(T_PERCENTILE_DISC, PERCENTILE_DISC);
        reservedKeys.put(T_PERIOD, PERIOD);
        reservedKeys.put(T_POSITION, POSITION);
        reservedKeys.put(T_POSITION_REGEX, POSITION_REGEX);
        reservedKeys.put(T_POWER, POWER);
        reservedKeys.put(T_PRECEDES, PRECEDES);
        reservedKeys.put(T_PRECISION, PRECISION);
        reservedKeys.put(T_PREPARE, PREPARE);
        reservedKeys.put(T_PRIMARY, PRIMARY);
        reservedKeys.put(T_PROCEDURE, PROCEDURE);
        reservedKeys.put(T_RANGE, RANGE);
        reservedKeys.put(T_RANK, RANK);
        reservedKeys.put(T_READS, READS);
        reservedKeys.put(T_REAL, REAL);
        reservedKeys.put(T_RECURSIVE, RECURSIVE);
        reservedKeys.put(T_REF, REF);
        reservedKeys.put(T_REFERENCES, REFERENCES);
        reservedKeys.put(T_REFERENCING, REFERENCING);
        reservedKeys.put(T_REGR_AVGX, REGR_AVGX);
        reservedKeys.put(T_REGR_AVGY, REGR_AVGY);
        reservedKeys.put(T_REGR_COUNT, REGR_COUNT);
        reservedKeys.put(T_REGR_INTERCEPT, REGR_INTERCEPT);
        reservedKeys.put(T_REGR_R2, REGR_R2);
        reservedKeys.put(T_REGR_SLOPE, REGR_SLOPE);
        reservedKeys.put(T_REGR_SXX, REGR_SXX);
        reservedKeys.put(T_REGR_SXY, REGR_SXY);
        reservedKeys.put(T_REGR_SYY, REGR_SYY);
        reservedKeys.put(T_RELEASE, RELEASE);
        reservedKeys.put(T_REPEAT, REPEAT);
        reservedKeys.put(T_RESIGNAL, RESIGNAL);
        reservedKeys.put(T_RETURN, RETURN);
        reservedKeys.put(T_RETURNS, RETURNS);
        reservedKeys.put(T_REVOKE, REVOKE);
        reservedKeys.put(T_RIGHT, RIGHT);
        reservedKeys.put(T_ROLLBACK, ROLLBACK);
        reservedKeys.put(T_ROLLUP, ROLLUP);
        reservedKeys.put(T_ROW, ROW);
        reservedKeys.put(T_ROW_NUMBER, ROW_NUMBER);
        reservedKeys.put(T_ROWS, ROWS);
        reservedKeys.put(T_SAVEPOINT, SAVEPOINT);
        reservedKeys.put(T_SCOPE, SCOPE);
        reservedKeys.put(T_SCROLL, SCROLL);
        reservedKeys.put(T_SEARCH, SEARCH);
        reservedKeys.put(T_SECOND, SECOND);
        reservedKeys.put(T_SELECT, SELECT);
        reservedKeys.put(T_SENSITIVE, SENSITIVE);
        reservedKeys.put(T_SESSION_USER, SESSION_USER);
        reservedKeys.put(T_SET, SET);
        reservedKeys.put(T_SIGNAL, SIGNAL);
        reservedKeys.put(T_SIMILAR, SIMILAR);
        reservedKeys.put(T_SMALLINT, SMALLINT);
        reservedKeys.put(T_SOME, SOME);
        reservedKeys.put(T_SPECIFIC, SPECIFIC);
        reservedKeys.put(T_SPECIFICTYPE, SPECIFICTYPE);
        reservedKeys.put(T_SQL, SQL);
        reservedKeys.put(T_SQLEXCEPTION, SQLEXCEPTION);
        reservedKeys.put(T_SQLSTATE, SQLSTATE);
        reservedKeys.put(T_SQLWARNING, SQLWARNING);
        reservedKeys.put(T_SQRT, SQRT);
        reservedKeys.put(T_STACKED, STACKED);
        reservedKeys.put(T_START, START);
        reservedKeys.put(T_STATIC, STATIC);
        reservedKeys.put(T_STDDEV_POP, STDDEV_POP);
        reservedKeys.put(T_STDDEV_SAMP, STDDEV_SAMP);
        reservedKeys.put(T_SUBMULTISET, SUBMULTISET);
        reservedKeys.put(T_SUBSTRING, SUBSTRING);
        reservedKeys.put(T_SUBSTRING_REGEX, SUBSTRING_REGEX);
        reservedKeys.put(T_SUCCEEDS, SUCCEEDS);
        reservedKeys.put(T_SUM, SUM);
        reservedKeys.put(T_SYMMETRIC, SYMMETRIC);
        reservedKeys.put(T_SYSTEM, SYSTEM);
        reservedKeys.put(T_SYSTEM_TIME, SYSTEM_TIME);
        reservedKeys.put(T_SYSTEM_USER, SYSTEM_USER);
        reservedKeys.put(T_TABLE, TABLE);
        reservedKeys.put(T_TABLESAMPLE, TABLESAMPLE);
        reservedKeys.put(T_THEN, THEN);
        reservedKeys.put(T_TIME, TIME);
        reservedKeys.put(T_TIMESTAMP, TIMESTAMP);
        reservedKeys.put(T_TIMEZONE_HOUR, TIMEZONE_HOUR);
        reservedKeys.put(T_TIMEZONE_MINUTE, TIMEZONE_MINUTE);
        reservedKeys.put(T_TO, TO);
        reservedKeys.put(T_TRAILING, TRAILING);
        reservedKeys.put(T_TRANSLATE, TRANSLATE);
        reservedKeys.put(T_TRANSLATE_REGEX, TRANSLATE_REGEX);
        reservedKeys.put(T_TRANSLATION, TRANSLATION);
        reservedKeys.put(T_TREAT, TREAT);
        reservedKeys.put(T_TRIGGER, TRIGGER);
        reservedKeys.put(T_TRIM, TRIM);
        reservedKeys.put(T_TRIM_ARRAY, TRIM_ARRAY);
        reservedKeys.put(T_TRUE, TRUE);
        reservedKeys.put(T_TRUNCATE, TRUNCATE);
        reservedKeys.put(T_UESCAPE, UESCAPE);
        reservedKeys.put(T_UNDO, UNDO);
        reservedKeys.put(T_UNION, UNION);
        reservedKeys.put(T_UNIQUE, UNIQUE);
        reservedKeys.put(T_UNKNOWN, UNKNOWN);
        reservedKeys.put(T_UNNEST, UNNEST);
        reservedKeys.put(T_UNTIL, UNTIL);
        reservedKeys.put(T_UPDATE, UPDATE);
        reservedKeys.put(T_UPPER, UPPER);
        reservedKeys.put(T_USER, USER);
        reservedKeys.put(T_USING, USING);
        reservedKeys.put(T_VALUE, VALUE);
        reservedKeys.put(T_VALUES, VALUES);
        reservedKeys.put(T_VAR_POP, VAR_POP);
        reservedKeys.put(T_VAR_SAMP, VAR_SAMP);
        reservedKeys.put(T_VARBINARY, VARBINARY);
        reservedKeys.put(T_VARCHAR, VARCHAR);
        reservedKeys.put(T_VARYING, VARYING);
        reservedKeys.put(T_WHEN, WHEN);
        reservedKeys.put(T_WHENEVER, WHENEVER);
        reservedKeys.put(T_WHERE, WHERE);
        reservedKeys.put(T_WIDTH_BUCKET, WIDTH_BUCKET);
        reservedKeys.put(T_WINDOW, WINDOW);
        reservedKeys.put(T_WITH, WITH);
        reservedKeys.put(T_WITHIN, WITHIN);
        reservedKeys.put(T_WITHOUT, WITHOUT);
        reservedKeys.put(T_WHILE, WHILE);
        reservedKeys.put(T_YEAR, YEAR);
    }

    private static final IntValueHashMap commandSet = new IntValueHashMap(449);

    static {
        commandSet.put(T_ACTION, ACTION);
        commandSet.put(T_ADD, ADD);
        commandSet.put(T_ADMIN, ADMIN);
        commandSet.put(T_AFTER, AFTER);
        commandSet.put(T_AGGREGATE, AGGREGATE);
        commandSet.put(T_ALIAS, ALIAS);
        commandSet.put(T_ALWAYS, ALWAYS);
        commandSet.put(T_ASC, ASC);
        commandSet.put(T_AUTHENTICATION, AUTHENTICATION);
        commandSet.put(T_AUTOCOMMIT, AUTOCOMMIT);
        commandSet.put(T_BACKUP, BACKUP);
        commandSet.put(T_BEFORE, BEFORE);
        commandSet.put(T_BINARY_DOUBLE, BINARY_DOUBLE);
        commandSet.put(T_BINARY_FLOAT, BINARY_FLOAT);
        commandSet.put(T_BIT, BIT);
        commandSet.put(T_BYTE, BYTE);
        commandSet.put(T_BLOCKING, BLOCKING);
        commandSet.put(T_BODY, BODY);
        commandSet.put(T_CACHE, CACHE);
        commandSet.put(T_CACHED, CACHED);
        commandSet.put(T_CASCADE, CASCADE);
        commandSet.put(T_CATALOG, CATALOG);
        commandSet.put(T_CHARACTERISTICS, CHARACTERISTICS);
        commandSet.put(T_CHARACTERS, CHARACTERS);
        commandSet.put(T_CHECKPOINT, CHECKPOINT);
        commandSet.put(T_CITEXT, CITEXT);
        commandSet.put(T_CRYPT_KEY, CRYPT_KEY);
        commandSet.put(T_CLASS, CLASS);
        commandSet.put(T_CLUSTERED, CLUSTERED);
        commandSet.put(T_COLLATE, COLLATE);
        commandSet.put(T_COLLATION, COLLATION);
        commandSet.put(T_COMMENT, COMMENT);
        commandSet.put(T_COMMITTED, COMMITTED);
        commandSet.put(T_COMPACT, COMPACT);
        commandSet.put(T_COMPRESSED, COMPRESSED);
        commandSet.put(T_CONDITION_IDENTIFIER, CONDITION_IDENTIFIER);
        commandSet.put(T_CONFLICT, CONFLICT);
        commandSet.put(T_CONSTRAINTS, CONSTRAINTS);
        commandSet.put(T_CONTINUE, CONTINUE);
        commandSet.put(T_CONTROL, CONTROL);
        commandSet.put(T_CURDATE, CURDATE);
        commandSet.put(T_CURRVAL, CURRVAL);
        commandSet.put(T_CURTIME, CURTIME);
        commandSet.put(T_DATA, DATA);
        commandSet.put(T_DATABASE, DATABASE);
        commandSet.put(T_DEADLOCK, DEADLOCK);
        commandSet.put(T_DEFERRABLE, DEFERRABLE);
        commandSet.put(T_DEFAULTS, DEFAULTS);
        commandSet.put(T_DEFINER, DEFINER);
        commandSet.put(T_DEFRAG, DEFRAG);
        commandSet.put(T_DELAY, DELAY);
        commandSet.put(T_DESC, DESC);
        commandSet.put(T_DIAGNOSTICS, DIAGNOSTICS);
        commandSet.put(T_DIGEST, DIGEST);
        commandSet.put(T_DOMAIN, DOMAIN);
        commandSet.put(T_ENUM, ENUM);
        commandSet.put(T_EVENT, EVENT);
        commandSet.put(T_EXCEPTION, EXCEPTION);
        commandSet.put(T_EXCLUDING, EXCLUDING);
        commandSet.put(T_EXPLAIN, EXPLAIN);
        commandSet.put(T_EXPRESSION, EXPRESSION);
        commandSet.put(T_FEATURE, FEATURE);
        commandSet.put(T_FILE, FILE);
        commandSet.put(T_FILES, FILES);
        commandSet.put(T_FINAL, FINAL);
        commandSet.put(T_FIRST, FIRST);
        commandSet.put(T_FOLLOWING, FOLLOWING);
        commandSet.put(T_FORMAT, FORMAT);
        commandSet.put(T_FOUND, FOUND);
        commandSet.put(T_G_FACTOR, G);
        commandSet.put(T_GC, GC);
        commandSet.put(T_GENERATED, GENERATED);
        commandSet.put(T_GRANTED, GRANTED);
        commandSet.put(T_GROUP_CONCAT, GROUP_CONCAT);
        commandSet.put(T_HEADER, HEADER);
        commandSet.put(T_IF, IF);
        commandSet.put(T_IGNORE, IGNORE);
        commandSet.put(T_IGNORECASE, IGNORECASE);
        commandSet.put(T_IMMEDIATELY, IMMEDIATELY);
        commandSet.put(T_INCLUDING, INCLUDING);
        commandSet.put(T_INCREMENT, INCREMENT);
        commandSet.put(T_INDEX, INDEX);
        commandSet.put(T_INDEXER, INDEXER);
        commandSet.put(T_INITIAL, INITIAL);
        commandSet.put(T_INPUT, INPUT);
        commandSet.put(T_INSTEAD, INSTEAD);
        commandSet.put(T_INTEGRITY, INTEGRITY);
        commandSet.put(T_IS_AUTOCOMMIT, IS_AUTOCOMMIT);
        commandSet.put(T_ISOLATION, ISOLATION);
        commandSet.put(T_IS_READONLY_DATABASE, IS_READONLY_DATABASE);
        commandSet.put(T_IS_READONLY_DATABASE_FILES,
                       IS_READONLY_DATABASE_FILES);
        commandSet.put(T_IS_READONLY_SESSION, IS_READONLY_SESSION);
        commandSet.put(T_JAVA, JAVA);
        commandSet.put(T_K_FACTOR, K);
        commandSet.put(T_KEY, KEY);
        commandSet.put(T_LAST, LAST);
        commandSet.put(T_LASTVAL, LASTVAL);
        commandSet.put(T_LENGTH, LENGTH);
        commandSet.put(T_LEVEL, LEVEL);
        commandSet.put(T_LIBRARY, LIBRARY);
        commandSet.put(T_LIMIT, LIMIT);
        commandSet.put(T_LOB, LOB);
        commandSet.put(T_LOCK, LOCK);
        commandSet.put(T_LOCKS, LOCKS);
        commandSet.put(T_LONG, LONG);
        commandSet.put(T_LONGBLOB, LONGBLOB);
        commandSet.put(T_LONGTEXT, LONGTEXT);
        commandSet.put(T_LONGVAR, LONGVAR);
        commandSet.put(T_M_FACTOR, M);
        commandSet.put(T_MATCHED, MATCHED);
        commandSet.put(T_MAXROWS, MAXROWS);
        commandSet.put(T_MAXVALUE, MAXVALUE);
        commandSet.put(T_MEDIAN, MEDIAN);
        commandSet.put(T_MEDIUMBLOB, MEDIUMBLOB);
        commandSet.put(T_MEDIUMTEXT, MEDIUMTEXT);
        commandSet.put(T_MEMORY, MEMORY);
        commandSet.put(T_MESSAGE_TEXT, MESSAGE_TEXT);
        commandSet.put(T_MILLIS, MILLIS);
        commandSet.put(T_MICROSECOND, MICROSECOND);
        commandSet.put(T_MILLISECOND, MILLISECOND);
        commandSet.put(T_MINUS_EXCEPT, MINUS_EXCEPT);
        commandSet.put(T_MINVALUE, MINVALUE);
        commandSet.put(T_MORE, MORE);
        commandSet.put(T_MVCC, MVCC);
        commandSet.put(T_MVLOCKS, MVLOCKS);
        commandSet.put(T_NAME, NAME);
        commandSet.put(T_NEXT, NEXT);
        commandSet.put(T_NEXTVAL, NEXTVAL);
        commandSet.put(T_NAN, NAN);
        commandSet.put(T_NANOSECOND, NANOSECOND);
        commandSet.put(T_NIO, NIO);
        commandSet.put(T_NOW, NOW);
        commandSet.put(T_NULLS, NULLS);
        commandSet.put(T_NUMBER, NUMBER);
        commandSet.put(T_NVARCHAR2, NVARCHAR2);
        commandSet.put(T_NVL2, NVL2);
        commandSet.put(T_OBJECT, OBJECT);
        commandSet.put(T_OCTETS, OCTETS);
        commandSet.put(T_OFF, OFF);
        commandSet.put(T_OPTION, OPTION);
        commandSet.put(T_ORDINALITY, ORDINALITY);
        commandSet.put(T_OTHERS, OTHERS);
        commandSet.put(T_OVERRIDING, OVERRIDING);
        commandSet.put(T_P_FACTOR, P);
        commandSet.put(T_PAD, PAD);
        commandSet.put(T_PARTIAL, PARTIAL);
        commandSet.put(T_PASSWORD, PASSWORD);
        commandSet.put(T_PERFORM, PERFORM);
        commandSet.put(T_PLACING, PLACING);
        commandSet.put(T_PLAN, PLAN);
        commandSet.put(T_PRECEDING, PRECEDING);
        commandSet.put(T_PRESERVE, PRESERVE);
        commandSet.put(T_PREVVAL, PREVVAL);
        commandSet.put(T_PRIVILEGES, PRIVILEGES);
        commandSet.put(T_PROPERTY, PROPERTY);
        commandSet.put(T_RAW, RAW);
        commandSet.put(T_READ, READ);
        commandSet.put(T_READONLY, READONLY);
        commandSet.put(T_REFERENTIAL, REFERENTIAL);
        commandSet.put(T_REGULAR, REGULAR);
        commandSet.put(T_RENAME, RENAME);
        commandSet.put(T_REPEATABLE, REPEATABLE);
        commandSet.put(T_RESET, RESET);
        commandSet.put(T_RESTART, RESTART);
        commandSet.put(T_RESTRICT, RESTRICT);
        commandSet.put(T_RESULT, RESULT);
        commandSet.put(T_ROLE, ROLE);
        commandSet.put(T_ROUTINE, ROUTINE);
        commandSet.put(T_ROW_COUNT, ROW_COUNT);
        commandSet.put(T_ROWNUM, ROWNUM);
        commandSet.put(T_SCALE, SCALE);
        commandSet.put(T_SCHEMA, SCHEMA);
        commandSet.put(T_SCRIPT, SCRIPT);
        commandSet.put(T_SEQUENCE, SEQUENCE);
        commandSet.put(T_SEPARATOR, SEPARATOR);
        commandSet.put(T_SERIALIZABLE, SERIALIZABLE);
        commandSet.put(T_SERVER, SERVER);
        commandSet.put(T_SESSION, SESSION);
        commandSet.put(T_SETS, SETS);
        commandSet.put(T_SHUTDOWN, SHUTDOWN);
        commandSet.put(T_SIMPLE, SIMPLE);
        commandSet.put(T_SIZE, SIZE);
        commandSet.put(T_SOURCE, SOURCE);
        commandSet.put(T_SQL_BIGINT, SQL_BIGINT);
        commandSet.put(T_SQL_BINARY, SQL_BINARY);
        commandSet.put(T_SQL_BIT, SQL_BIT);
        commandSet.put(T_SQL_BLOB, SQL_BLOB);
        commandSet.put(T_SQL_BOOLEAN, SQL_BOOLEAN);
        commandSet.put(T_SQL_CHAR, SQL_CHAR);
        commandSet.put(T_SQL_CLOB, SQL_CLOB);
        commandSet.put(T_SQL_DATALINK, SQL_DATALINK);
        commandSet.put(T_SQL_DATE, SQL_DATE);
        commandSet.put(T_SQL_DECIMAL, SQL_DECIMAL);
        commandSet.put(T_SQL_DOUBLE, SQL_DOUBLE);
        commandSet.put(T_SQL_FLOAT, SQL_FLOAT);
        commandSet.put(T_SQL_INTEGER, SQL_INTEGER);
        commandSet.put(T_SQL_LONGNVARCHAR, SQL_LONGNVARCHAR);
        commandSet.put(T_SQL_LONGVARBINARY, SQL_LONGVARBINARY);
        commandSet.put(T_SQL_LONGVARCHAR, SQL_LONGVARCHAR);
        commandSet.put(T_SQL_NCHAR, SQL_NCHAR);
        commandSet.put(T_SQL_NCLOB, SQL_NCLOB);
        commandSet.put(T_SQL_NUMERIC, SQL_NUMERIC);
        commandSet.put(T_SQL_NVARCHAR, SQL_NVARCHAR);
        commandSet.put(T_SQL_REAL, SQL_REAL);
        commandSet.put(T_SQL_ROWID, SQL_ROWID);
        commandSet.put(T_SQL_SMALLINT, SQL_SMALLINT);
        commandSet.put(T_SQL_SQLXML, SQL_SQLXML);
        commandSet.put(T_SQL_TIME, SQL_TIME);
        commandSet.put(T_SQL_TIMESTAMP, SQL_TIMESTAMP);
        commandSet.put(T_SQL_TINYINT, SQL_TINYINT);
        commandSet.put(T_SQL_VARBINARY, SQL_VARBINARY);
        commandSet.put(T_SQL_VARCHAR, SQL_VARCHAR);
        commandSet.put(T_SQL_TSI_DAY, SQL_TSI_DAY);
        commandSet.put(T_SQL_TSI_FRAC_SECOND, SQL_TSI_FRAC_SECOND);
        commandSet.put(T_SQL_TSI_MILLI_SECOND, SQL_TSI_MILLI_SECOND);
        commandSet.put(T_SQL_TSI_HOUR, SQL_TSI_HOUR);
        commandSet.put(T_SQL_TSI_MINUTE, SQL_TSI_MINUTE);
        commandSet.put(T_SQL_TSI_MONTH, SQL_TSI_MONTH);
        commandSet.put(T_SQL_TSI_QUARTER, SQL_TSI_QUARTER);
        commandSet.put(T_SQL_TSI_SECOND, SQL_TSI_SECOND);
        commandSet.put(T_SQL_TSI_WEEK, SQL_TSI_WEEK);
        commandSet.put(T_SQL_TSI_YEAR, SQL_TSI_YEAR);
        commandSet.put(T_STATEMENT, STATEMENT);
        commandSet.put(T_STRUCTURE, STRUCTURE);
        commandSet.put(T_STYLE, STYLE);
        commandSet.put(T_SYNONYM, SYNONYM);
        commandSet.put(T_SYNTAX, SYNTAX);
        commandSet.put(T_T_FACTOR, T);
        commandSet.put(T_TDC, TDC);
        commandSet.put(T_TEMP, TEMP);
        commandSet.put(T_TEMPORARY, TEMPORARY);
        commandSet.put(T_TEXT, TEXT);
        commandSet.put(T_TYPES, TYPES);
        commandSet.put(T_TIMESTAMP_WITH_ZONE, TIMESTAMP_WITH_ZONE);
        commandSet.put(T_TIMESTAMPADD, TIMESTAMPADD);
        commandSet.put(T_TIMESTAMPDIFF, TIMESTAMPDIFF);
        commandSet.put(T_TINYBLOB, TINYBLOB);
        commandSet.put(T_TINYTEXT, TINYTEXT);
        commandSet.put(T_TOP, TOP);
        commandSet.put(T_TRANSACTION, TRANSACTION);
        commandSet.put(T_TRANSACTION_ACTIVE, TRANSACTION_ACTIVE);
        commandSet.put(T_TRANSACTS_COMMITTED, TRANSACTIONS_COMMITTED);
        commandSet.put(T_TRANSACTS_ROLLED_BACK, TRANSACTIONS_ROLLED_BACK);
        commandSet.put(T_TTI, TTI);
        commandSet.put(T_TYPE, TYPE);
        commandSet.put(T_UNBOUNDED, UNBOUNDED);
        commandSet.put(T_UNCOMMITTED, UNCOMMITTED);
        commandSet.put(T_USAGE, USAGE);
        commandSet.put(T_USE, USE);
        commandSet.put(T_VIEW, VIEW);
        commandSet.put(T_VARCHAR2, VARCHAR2);
        commandSet.put(T_WORK, WORK);
        commandSet.put(T_WRAPPER, WRAPPER);
        commandSet.put(T_WRITE, WRITE);
        commandSet.put(T_WRITE_DELAY, WRITE_DELAY);
        commandSet.put(T_ZONE, ZONE);

        //
        commandSet.put(T_ACOS, ACOS);
        commandSet.put(T_ACTION_ID, ACTION_ID);
        commandSet.put(T_ADD_MONTHS, ADD_MONTHS);
        commandSet.put(T_ARRAY_SORT, ARRAY_SORT);
        commandSet.put(T_ASCII, ASCII);
        commandSet.put(T_ASIN, ASIN);
        commandSet.put(T_ATAN, ATAN);
        commandSet.put(T_ATAN2, ATAN2);
        commandSet.put(T_BITAND, BITAND);
        commandSet.put(T_BITANDNOT, BITANDNOT);
        commandSet.put(T_BITLENGTH, BITLENGTH);
        commandSet.put(T_BITNOT, BITNOT);
        commandSet.put(T_BITOR, BITOR);
        commandSet.put(T_BITXOR, BITXOR);
        commandSet.put(T_CASEWHEN, CASEWHEN);
        commandSet.put(T_CONCAT_WORD, CONCAT_WORD);
        commandSet.put(T_CONCAT_WS, CONCAT_WS);
        commandSet.put(T_CHR, CHR);
        commandSet.put(T_COS, COS);
        commandSet.put(T_COSH, COSH);
        commandSet.put(T_COT, COT);
        commandSet.put(T_DATABASE_NAME, DATABASE_NAME);
        commandSet.put(T_DATE_ADD, DATE_ADD);
        commandSet.put(T_DATE_SUB, DATE_SUB);
        commandSet.put(T_DATEADD, DATEADD);
        commandSet.put(T_DATEDIFF, DATEDIFF);
        commandSet.put(T_DATETIMEOFFSET, DATETIMEOFFSET);
        commandSet.put(T_DATENAME, DATENAME);
        commandSet.put(T_DATEPART, DATEPART);
        commandSet.put(T_DAY_NAME, DAY_NAME);
        commandSet.put(T_DAY_OF_MONTH, DAY_OF_MONTH);
        commandSet.put(T_DAY_OF_WEEK, DAY_OF_WEEK);
        commandSet.put(T_DAY_OF_YEAR, DAY_OF_YEAR);
        commandSet.put(T_DAYNAME, DAYNAME);
        commandSet.put(T_DAYOFMONTH, DAYOFMONTH);
        commandSet.put(T_DAYOFWEEK, DAYOFWEEK);
        commandSet.put(T_DAYOFYEAR, DAYOFYEAR);
        commandSet.put(T_DAYS, DAYS);
        commandSet.put(T_DBTIMEZONE, DBTIMEZONE);
        commandSet.put(T_DECODE, DECODE);
        commandSet.put(T_DEGREES, DEGREES);
        commandSet.put(T_DIFFERENCE, DIFFERENCE);
        commandSet.put(T_DMOD, DMOD);
        commandSet.put(T_DUPLICATE, DUPLICATE);
        commandSet.put(T_EOMONTH, EOMONTH);
        commandSet.put(T_FROM_TZ, FROM_TZ);
        commandSet.put(T_GREATEST, GREATEST);
        commandSet.put(T_HEXTORAW, HEXTORAW);
        commandSet.put(T_INSTR, INSTR);
        commandSet.put(T_IFNULL, IFNULL);
        commandSet.put(T_ISNULL, ISNULL);
        commandSet.put(T_LAST_DAY, LAST_DAY);
        commandSet.put(T_LCASE, LCASE);
        commandSet.put(T_LEAST, LEAST);
        commandSet.put(T_LITERAL, LITERAL);
        commandSet.put(T_LIVE, LIVE);
        commandSet.put(T_LOAD, LOAD);
        commandSet.put(T_LOAD_FILE, LOAD_FILE);
        commandSet.put(T_LOCATE, LOCATE);
        commandSet.put(T_LOG, LOG);
        commandSet.put(T_LOG10, LOG10);
        commandSet.put(T_LPAD, LPAD);
        commandSet.put(T_LTRIM, LTRIM);
        commandSet.put(T_MONTH_NAME, MONTH_NAME);
        commandSet.put(T_MONTHNAME, MONTHNAME);
        commandSet.put(T_MONTHS_BETWEEN, MONTHS_BETWEEN);
        commandSet.put(T_NAMES, NAMES);
        commandSet.put(T_NANVL, NANVL);
        commandSet.put(T_NEWID, NEWID);
        commandSet.put(T_NEW_TIME, NEW_TIME);
        commandSet.put(T_NEXT_DAY, NEXT_DAY);
        commandSet.put(T_NOWAIT, NOWAIT);
        commandSet.put(T_NUMTODSINTERVAL, NUMTODSINTERVAL);
        commandSet.put(T_NUMTOYMINTERVAL, NUMTOYMINTERVAL);
        commandSet.put(T_NVL, IFNULL);
        commandSet.put(T_OCTETLENGTH, OCTETLENGTH);
        commandSet.put(T_PI, PI);
        commandSet.put(T_POSITION_ARRAY, POSITION_ARRAY);
        commandSet.put(T_QUARTER, QUARTER);
        commandSet.put(T_RADIANS, RADIANS);
        commandSet.put(T_RAND, RAND);
        commandSet.put(T_RAWTOHEX, RAWTOHEX);
        commandSet.put(T_REGEXP_MATCHES, REGEXP_MATCHES);
        commandSet.put(T_REGEXP_REPLACE, REGEXP_REPLACE);
        commandSet.put(T_REGEXP_SUBSTRING, REGEXP_SUBSTRING);
        commandSet.put(T_REGEXP_SUBSTRING_ARRAY, REGEXP_SUBSTRING_ARRAY);
        commandSet.put(T_REPLACE, REPLACE);
        commandSet.put(T_REVERSE, REVERSE);
        commandSet.put(T_ROUND, ROUND);
        commandSet.put(T_ROUNDMAGIC, ROUNDMAGIC);
        commandSet.put(T_RPAD, RPAD);
        commandSet.put(T_RTRIM, RTRIM);
        commandSet.put(T_SECONDS_MIDNIGHT, SECONDS_MIDNIGHT);
        commandSet.put(T_SESSION_ID, SESSION_ID);
        commandSet.put(T_SESSIONTIMEZONE, SESSIONTIMEZONE);
        commandSet.put(T_SIGN, SIGN);
        commandSet.put(T_SIN, SIN);
        commandSet.put(T_SINH, SINH);
        commandSet.put(T_SORT_ARRAY, SORT_ARRAY);
        commandSet.put(T_SOUNDEX, SOUNDEX);
        commandSet.put(T_SPACE, SPACE);
        commandSet.put(T_SUBSTR, SUBSTR);
        commandSet.put(T_SYS, SYS);
        commandSet.put(T_SYS_EXTRACT_UTC, SYS_EXTRACT_UTC);
        commandSet.put(T_SYS_GUID, SYS_GUID);
        commandSet.put(T_SYSDATE, SYSDATE);
        commandSet.put(T_SYSTIMESTAMP, SYSTIMESTAMP);
        commandSet.put(T_TAN, TAN);
        commandSet.put(T_TANH, TANH);
        commandSet.put(T_TO_CHAR, TO_CHAR);
        commandSet.put(T_TO_DATE, TO_DATE);
        commandSet.put(T_TO_DSINTERVAL, TO_DSINTERVAL);
        commandSet.put(T_TO_YMINTERVAL, TO_YMINTERVAL);
        commandSet.put(T_TO_NUMBER, TO_NUMBER);
        commandSet.put(T_TO_TIMESTAMP, TO_TIMESTAMP);
        commandSet.put(T_TO_TIMESTAMP_TZ, TO_TIMESTAMP_TZ);
        commandSet.put(T_TODAY, TODAY);
        commandSet.put(T_TRUNC, TRUNC);
        commandSet.put(T_UCASE, UCASE);
        commandSet.put(T_TRANSACTION_ID, TRANSACTION_ID);
        commandSet.put(T_TRANSACTION_SIZE, TRANSACTION_SIZE);
        commandSet.put(T_TZ_OFFSET, TZ_OFFSET);
        commandSet.put(T_UUID, UUID);
        commandSet.put(T_UNIX_MILLIS, UNIX_MILLIS);
        commandSet.put(T_UNIX_TIMESTAMP, UNIX_TIMESTAMP);
        commandSet.put(T_WEEK, WEEK);
        commandSet.put(T_WEEK_OF_YEAR, WEEK_OF_YEAR);

        //
        commandSet.put(T_ISOLATION_LEVEL, ISOLATION_LEVEL);
        commandSet.put(T_SESSION_ISOLATION_LEVEL, SESSION_ISOLATION_LEVEL);
        commandSet.put(T_DATABASE_ISOLATION_LEVEL, DATABASE_ISOLATION_LEVEL);
        commandSet.put(T_TRANSACTION_CONTROL, TRANSACTION_CONTROL);
        commandSet.put(T_TIMEZONE, TIMEZONE);
        commandSet.put(T_SESSION_TIMEZONE, SESSION_TIMEZONE);
        commandSet.put(T_DATABASE_TIMEZONE, DATABASE_TIMEZONE);
        commandSet.put(T_DATABASE_VERSION, DATABASE_VERSION);
        commandSet.put(T_LOB_ID, LOB_ID);
        commandSet.put(T_SEQUENCE_ARRAY, SEQUENCE_ARRAY);

        //
        commandSet.put(T_ASTERISK, ASTERISK);
        commandSet.put(T_CLOSEBRACKET, CLOSEBRACKET);
        commandSet.put(T_COLON, COLON);
        commandSet.put(T_COMMA, COMMA);
        commandSet.put(T_CONCAT_OP, CONCAT_OP);
        commandSet.put(T_DIVIDE_OP, DIVIDE_OP);
        commandSet.put(T_EQUALS_OP, EQUALS_OP);
        commandSet.put(T_GREATER_OP, GREATER_OP);
        commandSet.put(T_GREATER_EQUALS, GREATER_EQUALS);
        commandSet.put(T_LEFTBRACKET, LEFTBRACKET);
        commandSet.put(T_LESS_OP, LESS_OP);
        commandSet.put(T_LESS_EQUALS, LESS_EQUALS);
        commandSet.put(T_MINUS_OP, MINUS_OP);
        commandSet.put(T_NOT_EQUALS, NOT_EQUALS);
        commandSet.put(T_NOT_EQUALS_ALT, NOT_EQUALS);
        commandSet.put(T_OPENBRACKET, OPENBRACKET);
        commandSet.put(T_PLUS_OP, PLUS_OP);
        commandSet.put(T_QUESTION, QUESTION);
        commandSet.put(T_RIGHTBRACKET, RIGHTBRACKET);
        commandSet.put(T_SEMICOLON, SEMICOLON);
    }

    static int get(String token) {

        int type = reservedKeys.get(token, -1);

        if (type == -1) {
            return commandSet.get(token, -1);
        }

        return type;
    }

    public static boolean isCoreKeyword(int token) {
        return coreReservedWords.contains(token);
    }

    public static boolean isKeyword(String token) {
        return reservedKeys.containsKey(token);
    }

    public static int getKeywordID(String token, int defaultValue) {
        return reservedKeys.get(token, defaultValue);
    }

    public static int getNonKeywordID(String token, int defaultValue) {
        return commandSet.get(token, defaultValue);
    }

    public static String getKeyword(int token) {

        String key = (String) reservedKeys.getKey(token);

        if (key != null) {
            return key;
        }

        key = (String) commandSet.getKey(token);

        return key;
    }

    private static final OrderedIntHashSet coreReservedWords;

    static {

        // minimal set of identifier not allowed as table / column / alias names
        // these are in effect interpreted as reserved words used by HSQLDB
        coreReservedWords = new OrderedIntHashSet(128);

        short[] keyword = {
            ALL, AND, ANY, AS, AT, BY, BETWEEN, BOTH, CALL, CASE, CAST,
            CORRESPONDING, CONVERT, COALESCE, CREATE, CROSS, DEFAULT, DISTINCT,
            DO, DROP, ELSE, EVERY, EXISTS, EXCEPT, FOR, FROM, FULL, GRANT,
            GROUP, HAVING, INTO, IS, IN, INTERSECT, JOIN, INNER, LEFT, LEADING,
            LIKE, NATURAL, NULLIF, NOT, ON, ORDER, OR, OUTER, PRIMARY,
            REFERENCES, RIGHT, SELECT, SET, SOME, SUM, TABLE, THEN, TO,
            TRAILING, TRIGGER, UNION, UNIQUE, USING, VALUES, WHEN, WHERE, WITH,
        };

        for (int i = 0; i < keyword.length; i++) {
            coreReservedWords.add(keyword[i]);
        }
    }

    public static final short[]        SQL_INTERVAL_FIELD_CODES = new short[] {
        YEAR, MONTH, DAY, HOUR, MINUTE, SECOND
    };
    public static final String[] SQL_INTERVAL_FIELD_NAMES = new String[] {
        T_YEAR, T_MONTH, T_DAY, T_HOUR, T_MINUTE, T_SECOND
    };
    private static final IntKeyHashMap sqlTSILookup = new IntKeyHashMap(11);

    static {
        sqlTSILookup.put(SQL_TSI_DAY, T_SQL_TSI_DAY);
        sqlTSILookup.put(SQL_TSI_FRAC_SECOND, T_SQL_TSI_FRAC_SECOND);
        sqlTSILookup.put(SQL_TSI_MICRO_SECOND, T_SQL_TSI_MICRO_SECOND);
        sqlTSILookup.put(SQL_TSI_MILLI_SECOND, T_SQL_TSI_MILLI_SECOND);
        sqlTSILookup.put(SQL_TSI_HOUR, T_SQL_TSI_HOUR);
        sqlTSILookup.put(SQL_TSI_MINUTE, T_SQL_TSI_MINUTE);
        sqlTSILookup.put(SQL_TSI_MONTH, T_SQL_TSI_MONTH);
        sqlTSILookup.put(SQL_TSI_QUARTER, T_SQL_TSI_QUARTER);
        sqlTSILookup.put(SQL_TSI_SECOND, T_SQL_TSI_SECOND);
        sqlTSILookup.put(SQL_TSI_WEEK, T_SQL_TSI_WEEK);
        sqlTSILookup.put(SQL_TSI_YEAR, T_SQL_TSI_YEAR);
    }

    public static String getSQLTSIString(int token) {
        return (String) sqlTSILookup.get(token);
    }
}
