/*
 *  SPDX-FileCopyrightText: 2025 Wolthera van Hövell tot Westerflier <griffinvalley@gmail.com>
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  This file is AUTOGENERATED by generateKoUnicodeBlockData.py from:
 *  https://www.unicode.org/Public/16.0.0/ucd/Blocks.txt
 */

#include "KoUnicodeBlockData.h"
#include <QVector>

struct Q_DECL_HIDDEN KoUnicodeBlockDataFactory::Private
{
    QVector<KoUnicodeBlockData> blockMap;
};

KoUnicodeBlockDataFactory::KoUnicodeBlockDataFactory()
    : d(new Private)
{

    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Basic Latin"), 0x0000, 0x007F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin-1 Supplement"), 0x0080, 0x00FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended-A"), 0x0100, 0x017F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended-B"), 0x0180, 0x024F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "IPA Extensions"), 0x0250, 0x02AF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Spacing Modifier Letters"), 0x02B0, 0x02FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Combining Diacritical Marks"), 0x0300, 0x036F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Greek and Coptic"), 0x0370, 0x03FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cyrillic"), 0x0400, 0x04FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cyrillic Supplement"), 0x0500, 0x052F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Armenian"), 0x0530, 0x058F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hebrew"), 0x0590, 0x05FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic"), 0x0600, 0x06FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Syriac"), 0x0700, 0x074F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic Supplement"), 0x0750, 0x077F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Thaana"), 0x0780, 0x07BF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "NKo"), 0x07C0, 0x07FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Samaritan"), 0x0800, 0x083F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mandaic"), 0x0840, 0x085F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Syriac Supplement"), 0x0860, 0x086F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic Extended-B"), 0x0870, 0x089F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic Extended-A"), 0x08A0, 0x08FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Devanagari"), 0x0900, 0x097F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Bengali"), 0x0980, 0x09FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Gurmukhi"), 0x0A00, 0x0A7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Gujarati"), 0x0A80, 0x0AFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Oriya"), 0x0B00, 0x0B7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tamil"), 0x0B80, 0x0BFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Telugu"), 0x0C00, 0x0C7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kannada"), 0x0C80, 0x0CFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Malayalam"), 0x0D00, 0x0D7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sinhala"), 0x0D80, 0x0DFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Thai"), 0x0E00, 0x0E7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Lao"), 0x0E80, 0x0EFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tibetan"), 0x0F00, 0x0FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Myanmar"), 0x1000, 0x109F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Georgian"), 0x10A0, 0x10FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hangul Jamo"), 0x1100, 0x11FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ethiopic"), 0x1200, 0x137F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ethiopic Supplement"), 0x1380, 0x139F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cherokee"), 0x13A0, 0x13FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Unified Canadian Aboriginal Syllabics"), 0x1400, 0x167F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ogham"), 0x1680, 0x169F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Runic"), 0x16A0, 0x16FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tagalog"), 0x1700, 0x171F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hanunoo"), 0x1720, 0x173F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Buhid"), 0x1740, 0x175F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tagbanwa"), 0x1760, 0x177F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Khmer"), 0x1780, 0x17FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mongolian"), 0x1800, 0x18AF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Unified Canadian Aboriginal Syllabics Extended"), 0x18B0, 0x18FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Limbu"), 0x1900, 0x194F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tai Le"), 0x1950, 0x197F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "New Tai Lue"), 0x1980, 0x19DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Khmer Symbols"), 0x19E0, 0x19FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Buginese"), 0x1A00, 0x1A1F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tai Tham"), 0x1A20, 0x1AAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Combining Diacritical Marks Extended"), 0x1AB0, 0x1AFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Balinese"), 0x1B00, 0x1B7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sundanese"), 0x1B80, 0x1BBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Batak"), 0x1BC0, 0x1BFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Lepcha"), 0x1C00, 0x1C4F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ol Chiki"), 0x1C50, 0x1C7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cyrillic Extended-C"), 0x1C80, 0x1C8F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Georgian Extended"), 0x1C90, 0x1CBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sundanese Supplement"), 0x1CC0, 0x1CCF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Vedic Extensions"), 0x1CD0, 0x1CFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Phonetic Extensions"), 0x1D00, 0x1D7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Phonetic Extensions Supplement"), 0x1D80, 0x1DBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Combining Diacritical Marks Supplement"), 0x1DC0, 0x1DFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended Additional"), 0x1E00, 0x1EFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Greek Extended"), 0x1F00, 0x1FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "General Punctuation"), 0x2000, 0x206F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Superscripts and Subscripts"), 0x2070, 0x209F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Currency Symbols"), 0x20A0, 0x20CF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Combining Diacritical Marks for Symbols"), 0x20D0, 0x20FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Letterlike Symbols"), 0x2100, 0x214F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Number Forms"), 0x2150, 0x218F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arrows"), 0x2190, 0x21FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mathematical Operators"), 0x2200, 0x22FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Miscellaneous Technical"), 0x2300, 0x23FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Control Pictures"), 0x2400, 0x243F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Optical Character Recognition"), 0x2440, 0x245F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Enclosed Alphanumerics"), 0x2460, 0x24FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Box Drawing"), 0x2500, 0x257F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Block Elements"), 0x2580, 0x259F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Geometric Shapes"), 0x25A0, 0x25FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Miscellaneous Symbols"), 0x2600, 0x26FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Dingbats"), 0x2700, 0x27BF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Miscellaneous Mathematical Symbols-A"), 0x27C0, 0x27EF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplemental Arrows-A"), 0x27F0, 0x27FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Braille Patterns"), 0x2800, 0x28FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplemental Arrows-B"), 0x2900, 0x297F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Miscellaneous Mathematical Symbols-B"), 0x2980, 0x29FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplemental Mathematical Operators"), 0x2A00, 0x2AFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Miscellaneous Symbols and Arrows"), 0x2B00, 0x2BFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Glagolitic"), 0x2C00, 0x2C5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended-C"), 0x2C60, 0x2C7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Coptic"), 0x2C80, 0x2CFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Georgian Supplement"), 0x2D00, 0x2D2F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tifinagh"), 0x2D30, 0x2D7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ethiopic Extended"), 0x2D80, 0x2DDF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cyrillic Extended-A"), 0x2DE0, 0x2DFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplemental Punctuation"), 0x2E00, 0x2E7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Radicals Supplement"), 0x2E80, 0x2EFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kangxi Radicals"), 0x2F00, 0x2FDF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ideographic Description Characters"), 0x2FF0, 0x2FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Symbols and Punctuation"), 0x3000, 0x303F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hiragana"), 0x3040, 0x309F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Katakana"), 0x30A0, 0x30FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Bopomofo"), 0x3100, 0x312F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hangul Compatibility Jamo"), 0x3130, 0x318F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kanbun"), 0x3190, 0x319F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Bopomofo Extended"), 0x31A0, 0x31BF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Strokes"), 0x31C0, 0x31EF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Katakana Phonetic Extensions"), 0x31F0, 0x31FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Enclosed CJK Letters and Months"), 0x3200, 0x32FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Compatibility"), 0x3300, 0x33FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension A"), 0x3400, 0x4DBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Yijing Hexagram Symbols"), 0x4DC0, 0x4DFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs"), 0x4E00, 0x9FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Yi Syllables"), 0xA000, 0xA48F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Yi Radicals"), 0xA490, 0xA4CF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Lisu"), 0xA4D0, 0xA4FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Vai"), 0xA500, 0xA63F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cyrillic Extended-B"), 0xA640, 0xA69F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Bamum"), 0xA6A0, 0xA6FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Modifier Tone Letters"), 0xA700, 0xA71F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended-D"), 0xA720, 0xA7FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Syloti Nagri"), 0xA800, 0xA82F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Common Indic Number Forms"), 0xA830, 0xA83F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Phags-pa"), 0xA840, 0xA87F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Saurashtra"), 0xA880, 0xA8DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Devanagari Extended"), 0xA8E0, 0xA8FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kayah Li"), 0xA900, 0xA92F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Rejang"), 0xA930, 0xA95F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hangul Jamo Extended-A"), 0xA960, 0xA97F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Javanese"), 0xA980, 0xA9DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Myanmar Extended-B"), 0xA9E0, 0xA9FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cham"), 0xAA00, 0xAA5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Myanmar Extended-A"), 0xAA60, 0xAA7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tai Viet"), 0xAA80, 0xAADF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Meetei Mayek Extensions"), 0xAAE0, 0xAAFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ethiopic Extended-A"), 0xAB00, 0xAB2F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended-E"), 0xAB30, 0xAB6F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cherokee Supplement"), 0xAB70, 0xABBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Meetei Mayek"), 0xABC0, 0xABFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hangul Syllables"), 0xAC00, 0xD7AF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hangul Jamo Extended-B"), 0xD7B0, 0xD7FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "High Surrogates"), 0xD800, 0xDB7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "High Private Use Surrogates"), 0xDB80, 0xDBFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Low Surrogates"), 0xDC00, 0xDFFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Private Use Area"), 0xE000, 0xF8FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Compatibility Ideographs"), 0xF900, 0xFAFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Alphabetic Presentation Forms"), 0xFB00, 0xFB4F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic Presentation Forms-A"), 0xFB50, 0xFDFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Variation Selectors"), 0xFE00, 0xFE0F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Vertical Forms"), 0xFE10, 0xFE1F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Combining Half Marks"), 0xFE20, 0xFE2F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Compatibility Forms"), 0xFE30, 0xFE4F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Small Form Variants"), 0xFE50, 0xFE6F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic Presentation Forms-B"), 0xFE70, 0xFEFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Halfwidth and Fullwidth Forms"), 0xFF00, 0xFFEF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Specials"), 0xFFF0, 0xFFFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Linear B Syllabary"), 0x10000, 0x1007F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Linear B Ideograms"), 0x10080, 0x100FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Aegean Numbers"), 0x10100, 0x1013F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ancient Greek Numbers"), 0x10140, 0x1018F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ancient Symbols"), 0x10190, 0x101CF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Phaistos Disc"), 0x101D0, 0x101FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Lycian"), 0x10280, 0x1029F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Carian"), 0x102A0, 0x102DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Coptic Epact Numbers"), 0x102E0, 0x102FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old Italic"), 0x10300, 0x1032F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Gothic"), 0x10330, 0x1034F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old Permic"), 0x10350, 0x1037F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ugaritic"), 0x10380, 0x1039F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old Persian"), 0x103A0, 0x103DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Deseret"), 0x10400, 0x1044F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Shavian"), 0x10450, 0x1047F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Osmanya"), 0x10480, 0x104AF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Osage"), 0x104B0, 0x104FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Elbasan"), 0x10500, 0x1052F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Caucasian Albanian"), 0x10530, 0x1056F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Vithkuqi"), 0x10570, 0x105BF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Todhri"), 0x105C0, 0x105FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Linear A"), 0x10600, 0x1077F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended-F"), 0x10780, 0x107BF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cypriot Syllabary"), 0x10800, 0x1083F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Imperial Aramaic"), 0x10840, 0x1085F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Palmyrene"), 0x10860, 0x1087F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Nabataean"), 0x10880, 0x108AF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hatran"), 0x108E0, 0x108FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Phoenician"), 0x10900, 0x1091F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Lydian"), 0x10920, 0x1093F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Meroitic Hieroglyphs"), 0x10980, 0x1099F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Meroitic Cursive"), 0x109A0, 0x109FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kharoshthi"), 0x10A00, 0x10A5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old South Arabian"), 0x10A60, 0x10A7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old North Arabian"), 0x10A80, 0x10A9F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Manichaean"), 0x10AC0, 0x10AFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Avestan"), 0x10B00, 0x10B3F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Inscriptional Parthian"), 0x10B40, 0x10B5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Inscriptional Pahlavi"), 0x10B60, 0x10B7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Psalter Pahlavi"), 0x10B80, 0x10BAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old Turkic"), 0x10C00, 0x10C4F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old Hungarian"), 0x10C80, 0x10CFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Hanifi Rohingya"), 0x10D00, 0x10D3F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Garay"), 0x10D40, 0x10D8F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Rumi Numeral Symbols"), 0x10E60, 0x10E7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Yezidi"), 0x10E80, 0x10EBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic Extended-C"), 0x10EC0, 0x10EFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old Sogdian"), 0x10F00, 0x10F2F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sogdian"), 0x10F30, 0x10F6F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Old Uyghur"), 0x10F70, 0x10FAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Chorasmian"), 0x10FB0, 0x10FDF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Elymaic"), 0x10FE0, 0x10FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Brahmi"), 0x11000, 0x1107F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kaithi"), 0x11080, 0x110CF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sora Sompeng"), 0x110D0, 0x110FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Chakma"), 0x11100, 0x1114F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mahajani"), 0x11150, 0x1117F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sharada"), 0x11180, 0x111DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sinhala Archaic Numbers"), 0x111E0, 0x111FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Khojki"), 0x11200, 0x1124F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Multani"), 0x11280, 0x112AF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Khudawadi"), 0x112B0, 0x112FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Grantha"), 0x11300, 0x1137F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tulu-Tigalari"), 0x11380, 0x113FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Newa"), 0x11400, 0x1147F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tirhuta"), 0x11480, 0x114DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Siddham"), 0x11580, 0x115FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Modi"), 0x11600, 0x1165F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mongolian Supplement"), 0x11660, 0x1167F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Takri"), 0x11680, 0x116CF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Myanmar Extended-C"), 0x116D0, 0x116FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ahom"), 0x11700, 0x1174F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Dogra"), 0x11800, 0x1184F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Warang Citi"), 0x118A0, 0x118FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Dives Akuru"), 0x11900, 0x1195F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Nandinagari"), 0x119A0, 0x119FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Zanabazar Square"), 0x11A00, 0x11A4F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Soyombo"), 0x11A50, 0x11AAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Unified Canadian Aboriginal Syllabics Extended-A"), 0x11AB0, 0x11ABF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Pau Cin Hau"), 0x11AC0, 0x11AFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Devanagari Extended-A"), 0x11B00, 0x11B5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sunuwar"), 0x11BC0, 0x11BFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Bhaiksuki"), 0x11C00, 0x11C6F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Marchen"), 0x11C70, 0x11CBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Masaram Gondi"), 0x11D00, 0x11D5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Gunjala Gondi"), 0x11D60, 0x11DAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Makasar"), 0x11EE0, 0x11EFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kawi"), 0x11F00, 0x11F5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Lisu Supplement"), 0x11FB0, 0x11FBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tamil Supplement"), 0x11FC0, 0x11FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cuneiform"), 0x12000, 0x123FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cuneiform Numbers and Punctuation"), 0x12400, 0x1247F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Early Dynastic Cuneiform"), 0x12480, 0x1254F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cypro-Minoan"), 0x12F90, 0x12FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Egyptian Hieroglyphs"), 0x13000, 0x1342F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Egyptian Hieroglyph Format Controls"), 0x13430, 0x1345F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Egyptian Hieroglyphs Extended-A"), 0x13460, 0x143FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Anatolian Hieroglyphs"), 0x14400, 0x1467F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Gurung Khema"), 0x16100, 0x1613F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Bamum Supplement"), 0x16800, 0x16A3F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mro"), 0x16A40, 0x16A6F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tangsa"), 0x16A70, 0x16ACF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Bassa Vah"), 0x16AD0, 0x16AFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Pahawh Hmong"), 0x16B00, 0x16B8F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kirat Rai"), 0x16D40, 0x16D7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Medefaidrin"), 0x16E40, 0x16E9F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Miao"), 0x16F00, 0x16F9F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ideographic Symbols and Punctuation"), 0x16FE0, 0x16FFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tangut"), 0x17000, 0x187FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tangut Components"), 0x18800, 0x18AFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Khitan Small Script"), 0x18B00, 0x18CFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tangut Supplement"), 0x18D00, 0x18D7F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kana Extended-B"), 0x1AFF0, 0x1AFFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kana Supplement"), 0x1B000, 0x1B0FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kana Extended-A"), 0x1B100, 0x1B12F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Small Kana Extension"), 0x1B130, 0x1B16F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Nushu"), 0x1B170, 0x1B2FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Duployan"), 0x1BC00, 0x1BC9F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Shorthand Format Controls"), 0x1BCA0, 0x1BCAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Symbols for Legacy Computing Supplement"), 0x1CC00, 0x1CEBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Znamenny Musical Notation"), 0x1CF00, 0x1CFCF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Byzantine Musical Symbols"), 0x1D000, 0x1D0FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Musical Symbols"), 0x1D100, 0x1D1FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ancient Greek Musical Notation"), 0x1D200, 0x1D24F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Kaktovik Numerals"), 0x1D2C0, 0x1D2DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mayan Numerals"), 0x1D2E0, 0x1D2FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tai Xuan Jing Symbols"), 0x1D300, 0x1D35F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Counting Rod Numerals"), 0x1D360, 0x1D37F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mathematical Alphanumeric Symbols"), 0x1D400, 0x1D7FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Sutton SignWriting"), 0x1D800, 0x1DAAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Latin Extended-G"), 0x1DF00, 0x1DFFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Glagolitic Supplement"), 0x1E000, 0x1E02F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Cyrillic Extended-D"), 0x1E030, 0x1E08F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Nyiakeng Puachue Hmong"), 0x1E100, 0x1E14F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Toto"), 0x1E290, 0x1E2BF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Wancho"), 0x1E2C0, 0x1E2FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Nag Mundari"), 0x1E4D0, 0x1E4FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ol Onal"), 0x1E5D0, 0x1E5FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ethiopic Extended-B"), 0x1E7E0, 0x1E7FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mende Kikakui"), 0x1E800, 0x1E8DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Adlam"), 0x1E900, 0x1E95F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Indic Siyaq Numbers"), 0x1EC70, 0x1ECBF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ottoman Siyaq Numbers"), 0x1ED00, 0x1ED4F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Arabic Mathematical Alphabetic Symbols"), 0x1EE00, 0x1EEFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Mahjong Tiles"), 0x1F000, 0x1F02F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Domino Tiles"), 0x1F030, 0x1F09F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Playing Cards"), 0x1F0A0, 0x1F0FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Enclosed Alphanumeric Supplement"), 0x1F100, 0x1F1FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Enclosed Ideographic Supplement"), 0x1F200, 0x1F2FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Miscellaneous Symbols and Pictographs"), 0x1F300, 0x1F5FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Emoticons"), 0x1F600, 0x1F64F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Ornamental Dingbats"), 0x1F650, 0x1F67F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Transport and Map Symbols"), 0x1F680, 0x1F6FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Alchemical Symbols"), 0x1F700, 0x1F77F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Geometric Shapes Extended"), 0x1F780, 0x1F7FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplemental Arrows-C"), 0x1F800, 0x1F8FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplemental Symbols and Pictographs"), 0x1F900, 0x1F9FF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Chess Symbols"), 0x1FA00, 0x1FA6F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Symbols and Pictographs Extended-A"), 0x1FA70, 0x1FAFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Symbols for Legacy Computing"), 0x1FB00, 0x1FBFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension B"), 0x20000, 0x2A6DF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension C"), 0x2A700, 0x2B73F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension D"), 0x2B740, 0x2B81F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension E"), 0x2B820, 0x2CEAF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension F"), 0x2CEB0, 0x2EBEF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension I"), 0x2EBF0, 0x2EE5F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Compatibility Ideographs Supplement"), 0x2F800, 0x2FA1F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension G"), 0x30000, 0x3134F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "CJK Unified Ideographs Extension H"), 0x31350, 0x323AF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Tags"), 0xE0000, 0xE007F));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Variation Selectors Supplement"), 0xE0100, 0xE01EF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplementary Private Use Area-A"), 0xF0000, 0xFFFFF));
    d->blockMap.append(KoUnicodeBlockData(i18nc("@title", "Supplementary Private Use Area-B"), 0x100000, 0x10FFFF));
}

KoUnicodeBlockDataFactory::~KoUnicodeBlockDataFactory()
{
}

KoUnicodeBlockData KoUnicodeBlockDataFactory::blockForUCS(const uint &codepoint)
{
    for (int i = 0; i < d->blockMap.size(); i++) {
        KoUnicodeBlockData block = d->blockMap.at(i);
        if (block.match(codepoint)) {
                return block;
        }
    }
    return noBlock();
}