/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.java.source.usages;

import java.io.File;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.openide.filesystems.FileUtil;

/**
 * <i>Copied from java/source, the package needs to be <code>org.netbeans.modules.java.source.usages</code>
 * to be able to access <code>Index.setCacheFolder()</code>.</i>
 * 
 */
public class IndexUtil {

    public static void setCacheFolder (final File cacheFolder) {
        CacheFolder.setCacheFolder(FileUtil.toFileObject(cacheFolder));
    }

}
